% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{getNamedRegions}
\alias{getNamedRegions}
\title{Get named regions}
\usage{
getNamedRegions(x)
}
\arguments{
\item{x}{An xlsx file or Workbook object}
}
\description{
Return a vector of named regions in a xlsx file or
Workbook object
}
\examples{
## create named regions
wb <- createWorkbook()
addWorksheet(wb, "Sheet 1")

## specify region
writeData(wb, sheet = 1, x = iris, startCol = 1, startRow = 1)
createNamedRegion(wb = wb,
                  sheet = 1,
                  name = "iris",
                  rows = 1:(nrow(iris)+1),
                  cols = 1:ncol(iris))


## using writeData 'name' argument to create a named region
writeData(wb, sheet = 1, x = iris, name = "iris2", startCol = 10)
\dontrun{
out_file <- tempfile(fileext = ".xlsx")
saveWorkbook(wb, out_file, overwrite = TRUE)

## see named regions
getNamedRegions(wb) ## From Workbook object
getNamedRegions(out_file) ## From xlsx file

## read named regions
df <- read.xlsx(wb, namedRegion = "iris")
head(df)

df <- read.xlsx(out_file, namedRegion = "iris2")
head(df)}
}
\seealso{
\code{\link{createNamedRegion}}
}
