% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{cbind}
\alias{cbind}
\alias{rbind}
\title{Combine R objects by rows and columns}
\usage{
cbind(...)

rbind(...)
}
\arguments{
\item{...}{(generalized) vectors or matrices.  These can be given as named
    arguments.  Other \R objects may be coerced as appropriate, or S4
    methods may be used: see sections \sQuote{Details} and
    \sQuote{Value}.  (For the \code{"data.frame"} method of \code{cbind}
    these can be further arguments to \code{\link[base]{data.frame}} such as
    \code{stringsAsFactors}.)}
}
\description{
Functions \code{cbind()} and \code{rbind()} are defined in
the \code{mice} package in order to
enable dispatch to \code{cbind.mids()} and \code{rbind.mids()}
when one of the arguments is a \code{data.frame}.
}
\details{
The standard \code{base::cbind()} and \code{base::rbind()}
always dispatch to
\code{base::cbind.data.frame()} or \code{base::rbind.data.frame()}
if one of the arguments is a
\code{data.frame}. The versions defined in the \code{mice}
package intercept the user command
and test whether the first argument has class \code{"mids"}. If so,
function calls \code{cbind.mids()}, respectively \code{rbind.mids()}. In
all other cases, the call is forwarded to standard functions in the
\code{base} package.
}
\seealso{
\code{\link[base:cbind]{cbind}}, \code{\link[base:cbind]{rbind}},
\code{\link{cbind.mids}}, \code{\link{rbind.mids}}
}
\keyword{internal}
