% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repository.r
\docType{methods}
\name{is_detached}
\alias{is_detached}
\alias{is_detached,missing-method}
\alias{is_detached,git_repository-method}
\title{Check if HEAD of repository is detached}
\usage{
is_detached(repo)

\S4method{is_detached}{missing}()

\S4method{is_detached}{git_repository}(repo)
}
\arguments{
\item{repo}{The repository \code{object}
\code{\linkS4class{git_repository}}. If the \code{repo} argument
is missing, the repository is searched for with
\code{\link{discover_repository}} in the current working
directory.}
}
\value{
TRUE if repository HEAD is detached, else FALSE
}
\description{
Check if HEAD of repository is detached
}
\examples{
\dontrun{
## Create and initialize a repository in a temporary directory
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)
config(repo, user.name="Alice", user.email="alice@example.org")

## Create a file, add and commit
writeLines("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
           file.path(path, "example.txt"))
add(repo, "example.txt")
commit_1 <- commit(repo, "Commit message 1")

## Change file, add and commit
writeLines(c("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
             "eiusmod tempor incididunt ut labore et dolore magna aliqua."),
             file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "Commit message 2")

## HEAD of repository is not detached
is_detached(repo)

## Checkout first commit
checkout(commit_1)

## HEAD of repository is detached
is_detached(repo)
}
}
\keyword{methods}
