% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpret_r.R
\name{interpret_r}
\alias{interpret_r}
\title{Correlation interpretation}
\usage{
interpret_r(r, rules = "funder2019")
}
\arguments{
\item{r}{Value or vector of correlation coefficient.}

\item{rules}{Can be "funder2019" (default), "gignac2016", cohen1988", "evans1996" or custom set of rules.}
}
\description{
Correlation interpretation
}
\examples{
interpret_r(r = .015)
interpret_r(r = c(.5, -.02))
}
\references{
\itemize{
  \item Funder, D. C., & Ozer, D. J. (2019). Evaluating effect size in psychological research: sense and nonsense. Advances in Methods and Practices in Psychological Science.
  \item Gignac, G. E., & Szodorai, E. T. (2016). Effect size guidelines for individual differences researchers. Personality and individual differences, 102, 74-78.
  \item Cohen, J. (1988). Statistical power analysis for the behavioural sciences.
  \item Evans, J. D. (1996). Straightforward statistics for the behavioral sciences. Thomson Brooks/Cole Publishing Co.
}
}
\seealso{
Page 88 of APA's 6th Edition.
}
