% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats_tidiers.R
\name{tidy.power.htest}
\alias{tidy.power.htest}
\title{tidy a power.htest}
\usage{
\method{tidy}{power.htest}(x, ...)
}
\arguments{
\item{x}{a power.htest object}

\item{...}{extra arguments, not used}
}
\value{
A data frame with one row per parameter passed in, with
columns \code{n}, \code{delta}, \code{sd}, \code{sig.level}, and
\code{power} (from the \code{power.htest} object).
}
\description{
tidy a power.htest
}
\examples{

ptt <- power.t.test(n = 2:30, delta = 1)
tidy(ptt)

library(ggplot2)
ggplot(tidy(ptt), aes(n, power)) + geom_line()

}
\seealso{
\link{power.t.test}
}
