#
# Copyright 2013 Canonical Ltd.
#
# This file is part of python-ubuntu-platform-api.
#
# python-upa is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 3.
#
# python-upa is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""Common entry point for all ubuntu platform api function calls.

We need to be careful to forward all function calls to the correct
implementation. It's easier to do this in python than it is in C/C++, so we
do it here.

"""


from commands import getstatusoutput


def _get_correct_backend():
    if (getstatusoutput("pgrep surfaceflinger")[0] != 0):
        import _mir
        return _mir
    else:
        import _sf
        return _sf


def get_resolution():
    """Return a tuple containing x, y screen resolution."""
    return _get_correct_backend().get_resolution()
