# PySNMP SMI module. Autogenerated from smidump -f python EtherLike-MIB
# by libsmi2pysnmp-0.1.3 at Mon Apr  2 20:38:57 2012,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ValueSizeConstraint")
( InterfaceIndex, ifIndex, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndex", "ifIndex")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Counter32, Counter64, Integer32, Integer32, ModuleIdentity, MibIdentifier, ObjectIdentity, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, mib_2, transmission, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Counter64", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "ObjectIdentity", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "mib-2", "transmission")
( TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "TruthValue")

# Objects

dot3 = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 7))
dot3StatsTable = MibTable((1, 3, 6, 1, 2, 1, 10, 7, 2))
if mibBuilder.loadTexts: dot3StatsTable.setDescription("Statistics for a collection of ethernet-like\ninterfaces attached to a particular system.\nThere will be one row in this table for each\nethernet-like interface in the system.")
dot3StatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 7, 2, 1)).setIndexNames((0, "EtherLike-MIB", "dot3StatsIndex"))
if mibBuilder.loadTexts: dot3StatsEntry.setDescription("Statistics for a particular interface to an\nethernet-like medium.")
dot3StatsIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 7, 2, 1, 1), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3StatsIndex.setDescription("An index value that uniquely identifies an\ninterface to an ethernet-like medium.  The\ninterface identified by a particular value of\nthis index is the same interface as identified\nby the same value of ifIndex.")
dot3StatsAlignmentErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 7, 2, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3StatsAlignmentErrors.setDescription("A count of frames received on a particular\ninterface that are not an integral number of\noctets in length and do not pass the FCS check.\n\nThe count represented by an instance of this\nobject is incremented when the alignmentError\nstatus is returned by the MAC service to the\nLLC (or other MAC user). Received frames for\nwhich multiple error conditions pertain are,\naccording to the conventions of IEEE 802.3\nLayer Management, counted exclusively according\n\n\n\nto the error status presented to the LLC.\n\nThis counter does not increment for group\nencoding schemes greater than 4 bits per group.\n\nFor interfaces operating at 10 Gb/s, this\ncounter can roll over in less than 5 minutes if\nit is incrementing at its maximum rate.  Since\nthat amount of time could be less than a\nmanagement station's poll cycle time, in order\nto avoid a loss of information, a management\nstation is advised to poll the\ndot3HCStatsAlignmentErrors object for 10 Gb/s\nor faster interfaces.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem, and at other times as indicated by the\nvalue of ifCounterDiscontinuityTime.")
dot3StatsFCSErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 7, 2, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3StatsFCSErrors.setDescription("A count of frames received on a particular\ninterface that are an integral number of octets\nin length but do not pass the FCS check.  This\ncount does not include frames received with\nframe-too-long or frame-too-short error.\n\nThe count represented by an instance of this\nobject is incremented when the frameCheckError\nstatus is returned by the MAC service to the\nLLC (or other MAC user). Received frames for\nwhich multiple error conditions pertain are,\naccording to the conventions of IEEE 802.3\nLayer Management, counted exclusively according\nto the error status presented to the LLC.\n\nNote:  Coding errors detected by the physical\nlayer for speeds above 10 Mb/s will cause the\nframe to fail the FCS check.\n\nFor interfaces operating at 10 Gb/s, this\ncounter can roll over in less than 5 minutes if\n\n\n\nit is incrementing at its maximum rate.  Since\nthat amount of time could be less than a\nmanagement station's poll cycle time, in order\nto avoid a loss of information, a management\nstation is advised to poll the\ndot3HCStatsFCSErrors object for 10 Gb/s or\nfaster interfaces.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem, and at other times as indicated by the\nvalue of ifCounterDiscontinuityTime.")
dot3StatsSingleCollisionFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 7, 2, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3StatsSingleCollisionFrames.setDescription("A count of frames that are involved in a single\ncollision, and are subsequently transmitted\nsuccessfully.\n\nA frame that is counted by an instance of this\nobject is also counted by the corresponding\ninstance of either the ifOutUcastPkts,\nifOutMulticastPkts, or ifOutBroadcastPkts,\nand is not counted by the corresponding\ninstance of the dot3StatsMultipleCollisionFrames\nobject.\n\nThis counter does not increment when the\ninterface is operating in full-duplex mode.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem, and at other times as indicated by the\nvalue of ifCounterDiscontinuityTime.")
dot3StatsMultipleCollisionFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 7, 2, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3StatsMultipleCollisionFrames.setDescription("A count of frames that are involved in more\n\n\n\nthan one collision and are subsequently\ntransmitted successfully.\n\nA frame that is counted by an instance of this\nobject is also counted by the corresponding\ninstance of either the ifOutUcastPkts,\nifOutMulticastPkts, or ifOutBroadcastPkts,\nand is not counted by the corresponding\ninstance of the dot3StatsSingleCollisionFrames\nobject.\n\nThis counter does not increment when the\ninterface is operating in full-duplex mode.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem, and at other times as indicated by the\nvalue of ifCounterDiscontinuityTime.")
dot3StatsSQETestErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 7, 2, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3StatsSQETestErrors.setDescription("A count of times that the SQE TEST ERROR\nis received on a particular interface. The\nSQE TEST ERROR is set in accordance with the\nrules for verification of the SQE detection\nmechanism in the PLS Carrier Sense Function as\ndescribed in IEEE Std. 802.3, 2000 Edition,\nsection 7.2.4.6.\n\nThis counter does not increment on interfaces\noperating at speeds greater than 10 Mb/s, or on\ninterfaces operating in full-duplex mode.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem, and at other times as indicated by the\nvalue of ifCounterDiscontinuityTime.")
dot3StatsDeferredTransmissions = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 7, 2, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3StatsDeferredTransmissions.setDescription("A count of frames for which the first\ntransmission attempt on a particular interface\nis delayed because the medium is busy.\n\nThe count represented by an instance of this\nobject does not include frames involved in\ncollisions.\n\nThis counter does not increment when the\ninterface is operating in full-duplex mode.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem, and at other times as indicated by the\nvalue of ifCounterDiscontinuityTime.")
dot3StatsLateCollisions = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 7, 2, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3StatsLateCollisions.setDescription("The number of times that a collision is\ndetected on a particular interface later than\none slotTime into the transmission of a packet.\n\nA (late) collision included in a count\nrepresented by an instance of this object is\nalso considered as a (generic) collision for\npurposes of other collision-related\nstatistics.\n\nThis counter does not increment when the\ninterface is operating in full-duplex mode.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem, and at other times as indicated by the\nvalue of ifCounterDiscontinuityTime.")
dot3StatsExcessiveCollisions = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 7, 2, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3StatsExcessiveCollisions.setDescription("A count of frames for which transmission on a\nparticular interface fails due to excessive\ncollisions.\n\nThis counter does not increment when the\ninterface is operating in full-duplex mode.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem, and at other times as indicated by the\nvalue of ifCounterDiscontinuityTime.")
dot3StatsInternalMacTransmitErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 7, 2, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3StatsInternalMacTransmitErrors.setDescription("A count of frames for which transmission on a\nparticular interface fails due to an internal\nMAC sublayer transmit error. A frame is only\ncounted by an instance of this object if it is\nnot counted by the corresponding instance of\neither the dot3StatsLateCollisions object, the\ndot3StatsExcessiveCollisions object, or the\ndot3StatsCarrierSenseErrors object.\n\nThe precise meaning of the count represented by\nan instance of this object is implementation-\nspecific.  In particular, an instance of this\nobject may represent a count of transmission\nerrors on a particular interface that are not\notherwise counted.\n\nFor interfaces operating at 10 Gb/s, this\ncounter can roll over in less than 5 minutes if\nit is incrementing at its maximum rate.  Since\nthat amount of time could be less than a\nmanagement station's poll cycle time, in order\nto avoid a loss of information, a management\nstation is advised to poll the\ndot3HCStatsInternalMacTransmitErrors object for\n10 Gb/s or faster interfaces.\n\nDiscontinuities in the value of this counter can\n\n\n\noccur at re-initialization of the management\nsystem, and at other times as indicated by the\nvalue of ifCounterDiscontinuityTime.")
dot3StatsCarrierSenseErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 7, 2, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3StatsCarrierSenseErrors.setDescription("The number of times that the carrier sense\ncondition was lost or never asserted when\nattempting to transmit a frame on a particular\ninterface.\n\nThe count represented by an instance of this\nobject is incremented at most once per\ntransmission attempt, even if the carrier sense\ncondition fluctuates during a transmission\nattempt.\n\nThis counter does not increment when the\ninterface is operating in full-duplex mode.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem, and at other times as indicated by the\nvalue of ifCounterDiscontinuityTime.")
dot3StatsFrameTooLongs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 7, 2, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3StatsFrameTooLongs.setDescription("A count of frames received on a particular\ninterface that exceed the maximum permitted\nframe size.\n\nThe count represented by an instance of this\nobject is incremented when the frameTooLong\nstatus is returned by the MAC service to the\nLLC (or other MAC user). Received frames for\nwhich multiple error conditions pertain are,\n\n\n\naccording to the conventions of IEEE 802.3\nLayer Management, counted exclusively according\nto the error status presented to the LLC.\n\nFor interfaces operating at 10 Gb/s, this\ncounter can roll over in less than 80 minutes if\nit is incrementing at its maximum rate.  Since\nthat amount of time could be less than a\nmanagement station's poll cycle time, in order\nto avoid a loss of information, a management\nstation is advised to poll the\ndot3HCStatsFrameTooLongs object for 10 Gb/s\nor faster interfaces.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem, and at other times as indicated by the\nvalue of ifCounterDiscontinuityTime.")
dot3StatsInternalMacReceiveErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 7, 2, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3StatsInternalMacReceiveErrors.setDescription("A count of frames for which reception on a\nparticular interface fails due to an internal\nMAC sublayer receive error. A frame is only\ncounted by an instance of this object if it is\nnot counted by the corresponding instance of\neither the dot3StatsFrameTooLongs object, the\ndot3StatsAlignmentErrors object, or the\ndot3StatsFCSErrors object.\n\nThe precise meaning of the count represented by\nan instance of this object is implementation-\nspecific.  In particular, an instance of this\nobject may represent a count of receive errors\non a particular interface that are not\notherwise counted.\n\nFor interfaces operating at 10 Gb/s, this\ncounter can roll over in less than 5 minutes if\n\n\n\nit is incrementing at its maximum rate.  Since\nthat amount of time could be less than a\nmanagement station's poll cycle time, in order\nto avoid a loss of information, a management\nstation is advised to poll the\ndot3HCStatsInternalMacReceiveErrors object for\n10 Gb/s or faster interfaces.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem, and at other times as indicated by the\nvalue of ifCounterDiscontinuityTime.")
dot3StatsEtherChipSet = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 7, 2, 1, 17), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3StatsEtherChipSet.setDescription("******** THIS OBJECT IS DEPRECATED ********\n\nThis object contains an OBJECT IDENTIFIER\nwhich identifies the chipset used to\nrealize the interface. Ethernet-like\ninterfaces are typically built out of\nseveral different chips. The MIB implementor\nis presented with a decision of which chip\nto identify via this object. The implementor\nshould identify the chip which is usually\ncalled the Medium Access Control chip.\nIf no such chip is easily identifiable,\nthe implementor should identify the chip\nwhich actually gathers the transmit\nand receive statistics and error\nindications. This would allow a\nmanager station to correlate the\nstatistics and the chip generating\nthem, giving it the ability to take\ninto account any known anomalies\nin the chip.\n\nThis object has been deprecated.  Implementation\nfeedback indicates that it is of limited use for\ndebugging network problems in the field, and\nthe administrative overhead involved in\nmaintaining a registry of chipset OIDs is not\njustified.")
dot3StatsSymbolErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 7, 2, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3StatsSymbolErrors.setDescription("For an interface operating at 100 Mb/s, the\nnumber of times there was an invalid data symbol\nwhen a valid carrier was present.\n\nFor an interface operating in half-duplex mode\nat 1000 Mb/s, the number of times the receiving\nmedia is non-idle (a carrier event) for a period\nof time equal to or greater than slotTime, and\nduring which there was at least one occurrence\nof an event that causes the PHY to indicate\n'Data reception error' or 'carrier extend error'\non the GMII.\n\nFor an interface operating in full-duplex mode\nat 1000 Mb/s, the number of times the receiving\nmedia is non-idle (a carrier event) for a period\nof time equal to or greater than minFrameSize,\nand during which there was at least one\noccurrence of an event that causes the PHY to\nindicate 'Data reception error' on the GMII.\n\nFor an interface operating at 10 Gb/s, the\nnumber of times the receiving media is non-idle\n(a carrier event) for a period of time equal to\nor greater than minFrameSize, and during which\nthere was at least one occurrence of an event\nthat causes the PHY to indicate 'Receive Error'\non the XGMII.\n\nThe count represented by an instance of this\nobject is incremented at most once per carrier\nevent, even if multiple symbol errors occur\nduring the carrier event.  This count does\nnot increment if a collision is present.\n\nThis counter does not increment when the\ninterface is operating at 10 Mb/s.\n\nFor interfaces operating at 10 Gb/s, this\ncounter can roll over in less than 5 minutes if\nit is incrementing at its maximum rate.  Since\nthat amount of time could be less than a\n\n\n\nmanagement station's poll cycle time, in order\nto avoid a loss of information, a management\nstation is advised to poll the\ndot3HCStatsSymbolErrors object for 10 Gb/s\nor faster interfaces.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem, and at other times as indicated by the\nvalue of ifCounterDiscontinuityTime.")
dot3StatsDuplexStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 7, 2, 1, 19), Integer().subtype(subtypeSpec=SingleValueConstraint(1,3,2,)).subtype(namedValues=NamedValues(("unknown", 1), ("halfDuplex", 2), ("fullDuplex", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3StatsDuplexStatus.setDescription("The current mode of operation of the MAC\nentity.  'unknown' indicates that the current\nduplex mode could not be determined.\n\nManagement control of the duplex mode is\naccomplished through the MAU MIB.  When\nan interface does not support autonegotiation,\nor when autonegotiation is not enabled, the\nduplex mode is controlled using\nifMauDefaultType.  When autonegotiation is\nsupported and enabled, duplex mode is controlled\nusing ifMauAutoNegAdvertisedBits.  In either\ncase, the currently operating duplex mode is\nreflected both in this object and in ifMauType.\n\nNote that this object provides redundant\ninformation with ifMauType.  Normally, redundant\nobjects are discouraged.  However, in this\ninstance, it allows a management application to\ndetermine the duplex status of an interface\nwithout having to know every possible value of\nifMauType.  This was felt to be sufficiently\nvaluable to justify the redundancy.")
dot3StatsRateControlAbility = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 7, 2, 1, 20), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3StatsRateControlAbility.setDescription("'true' for interfaces operating at speeds above\n1000 Mb/s that support Rate Control through\nlowering the average data rate of the MAC\nsublayer, with frame granularity, and 'false'\notherwise.")
dot3StatsRateControlStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 7, 2, 1, 21), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,2,)).subtype(namedValues=NamedValues(("rateControlOff", 1), ("rateControlOn", 2), ("unknown", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3StatsRateControlStatus.setDescription("The current Rate Control mode of operation of\nthe MAC sublayer of this interface.")
dot3CollTable = MibTable((1, 3, 6, 1, 2, 1, 10, 7, 5))
if mibBuilder.loadTexts: dot3CollTable.setDescription("A collection of collision histograms for a\nparticular set of interfaces.")
dot3CollEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 7, 5, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "EtherLike-MIB", "dot3CollCount"))
if mibBuilder.loadTexts: dot3CollEntry.setDescription("A cell in the histogram of per-frame\ncollisions for a particular interface.  An\n\n\n\ninstance of this object represents the\nfrequency of individual MAC frames for which\nthe transmission (successful or otherwise) on a\nparticular interface is accompanied by a\nparticular number of media collisions.")
dot3CollCount = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 7, 5, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 16))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dot3CollCount.setDescription("The number of per-frame media collisions for\nwhich a particular collision histogram cell\nrepresents the frequency on a particular\ninterface.")
dot3CollFrequencies = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 7, 5, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3CollFrequencies.setDescription("A count of individual MAC frames for which the\ntransmission (successful or otherwise) on a\nparticular interface occurs after the\nframe has experienced exactly the number\nof collisions in the associated\ndot3CollCount object.\n\nFor example, a frame which is transmitted\non interface 77 after experiencing\nexactly 4 collisions would be indicated\nby incrementing only dot3CollFrequencies.77.4.\nNo other instance of dot3CollFrequencies would\nbe incremented in this example.\n\nThis counter does not increment when the\ninterface is operating in full-duplex mode.\n\nDiscontinuities in the value of this counter can\n\n\n\noccur at re-initialization of the management\nsystem, and at other times as indicated by the\nvalue of ifCounterDiscontinuityTime.")
dot3Tests = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 7, 6))
dot3TestTdr = ObjectIdentity((1, 3, 6, 1, 2, 1, 10, 7, 6, 1))
if mibBuilder.loadTexts: dot3TestTdr.setDescription("******** THIS IDENTITY IS DEPRECATED *******\n\nThe Time-Domain Reflectometry (TDR) test is\nspecific to ethernet-like interfaces of type\n10Base5 and 10Base2.  The TDR value may be\nuseful in determining the approximate distance\nto a cable fault.  It is advisable to repeat\nthis test to check for a consistent resulting\nTDR value, to verify that there is a fault.\n\nA TDR test returns as its result the time\ninterval, measured in 10 MHz ticks or 100 nsec\nunits, between the start of TDR test\ntransmission and the subsequent detection of a\ncollision or deassertion of carrier.  On\nsuccessful completion of a TDR test, the result\nis stored as the value of an appropriate\ninstance of an appropriate vendor specific MIB\nobject, and the OBJECT IDENTIFIER of that\ninstance is stored in the appropriate instance\nof the appropriate test result code object\n(thereby indicating where the result has been\nstored).\n\nThis object identity has been deprecated, since\nthe ifTestTable in the IF-MIB was deprecated,\nand there is no longer a standard mechanism for\ninitiating an interface test.  This left no\nstandard way of using this object identity.")
dot3TestLoopBack = ObjectIdentity((1, 3, 6, 1, 2, 1, 10, 7, 6, 2))
if mibBuilder.loadTexts: dot3TestLoopBack.setDescription("******** THIS IDENTITY IS DEPRECATED *******\n\nThis test configures the MAC chip and executes\nan internal loopback test of memory, data paths,\nand the MAC chip logic.  This loopback test can\nonly be executed if the interface is offline.\nOnce the test has completed, the MAC chip should\n\n\n\nbe reinitialized for network operation, but it\nshould remain offline.\n\nIf an error occurs during a test, the\nappropriate test result object will be set\nto indicate a failure.  The two OBJECT\nIDENTIFIER values dot3ErrorInitError and\ndot3ErrorLoopbackError may be used to provided\nmore information as values for an appropriate\ntest result code object.\n\nThis object identity has been deprecated, since\nthe ifTestTable in the IF-MIB was deprecated,\nand there is no longer a standard mechanism for\ninitiating an interface test.  This left no\nstandard way of using this object identity.")
dot3Errors = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 7, 7))
dot3ErrorInitError = ObjectIdentity((1, 3, 6, 1, 2, 1, 10, 7, 7, 1))
if mibBuilder.loadTexts: dot3ErrorInitError.setDescription("******** THIS IDENTITY IS DEPRECATED *******\n\nCouldn't initialize MAC chip for test.\n\nThis object identity has been deprecated, since\nthe ifTestTable in the IF-MIB was deprecated,\nand there is no longer a standard mechanism for\ninitiating an interface test.  This left no\nstandard way of using this object identity.")
dot3ErrorLoopbackError = ObjectIdentity((1, 3, 6, 1, 2, 1, 10, 7, 7, 2))
if mibBuilder.loadTexts: dot3ErrorLoopbackError.setDescription("******** THIS IDENTITY IS DEPRECATED *******\n\nExpected data not received (or not received\ncorrectly) in loopback test.\n\nThis object identity has been deprecated, since\nthe ifTestTable in the IF-MIB was deprecated,\nand there is no longer a standard mechanism for\ninitiating an interface test.  This left no\nstandard way of using this object identity.")
dot3ControlTable = MibTable((1, 3, 6, 1, 2, 1, 10, 7, 9))
if mibBuilder.loadTexts: dot3ControlTable.setDescription("A table of descriptive and status information\nabout the MAC Control sublayer on the\nethernet-like interfaces attached to a\nparticular system.  There will be one row in\nthis table for each ethernet-like interface in\nthe system which implements the MAC Control\nsublayer.  If some, but not all, of the\nethernet-like interfaces in the system implement\nthe MAC Control sublayer, there will be fewer\nrows in this table than in the dot3StatsTable.")
dot3ControlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 7, 9, 1)).setIndexNames((0, "EtherLike-MIB", "dot3StatsIndex"))
if mibBuilder.loadTexts: dot3ControlEntry.setDescription("An entry in the table, containing information\nabout the MAC Control sublayer on a single\nethernet-like interface.")
dot3ControlFunctionsSupported = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 7, 9, 1, 1), Bits().subtype(namedValues=NamedValues(("pause", 0), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3ControlFunctionsSupported.setDescription("A list of the possible MAC Control functions\nimplemented for this interface.")
dot3ControlInUnknownOpcodes = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 7, 9, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3ControlInUnknownOpcodes.setDescription("A count of MAC Control frames received on this\ninterface that contain an opcode that is not\nsupported by this device.\n\nFor interfaces operating at 10 Gb/s, this\ncounter can roll over in less than 5 minutes if\nit is incrementing at its maximum rate.  Since\nthat amount of time could be less than a\nmanagement station's poll cycle time, in order\nto avoid a loss of information, a management\nstation is advised to poll the\ndot3HCControlInUnknownOpcodes object for 10 Gb/s\nor faster interfaces.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem, and at other times as indicated by the\nvalue of ifCounterDiscontinuityTime.")
dot3HCControlInUnknownOpcodes = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 7, 9, 1, 3), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3HCControlInUnknownOpcodes.setDescription("A count of MAC Control frames received on this\ninterface that contain an opcode that is not\nsupported by this device.\n\nThis counter is a 64 bit version of\ndot3ControlInUnknownOpcodes.  It should be used\non interfaces operating at 10 Gb/s or faster.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem, and at other times as indicated by the\nvalue of ifCounterDiscontinuityTime.")
dot3PauseTable = MibTable((1, 3, 6, 1, 2, 1, 10, 7, 10))
if mibBuilder.loadTexts: dot3PauseTable.setDescription("A table of descriptive and status information\nabout the MAC Control PAUSE function on the\nethernet-like interfaces attached to a\nparticular system. There will be one row in\nthis table for each ethernet-like interface in\nthe system which supports the MAC Control PAUSE\nfunction (i.e., the 'pause' bit in the\ncorresponding instance of\ndot3ControlFunctionsSupported is set).  If some,\nbut not all, of the ethernet-like interfaces in\nthe system implement the MAC Control PAUSE\nfunction (for example, if some interfaces only\nsupport half-duplex), there will be fewer rows\nin this table than in the dot3StatsTable.")
dot3PauseEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 7, 10, 1)).setIndexNames((0, "EtherLike-MIB", "dot3StatsIndex"))
if mibBuilder.loadTexts: dot3PauseEntry.setDescription("An entry in the table, containing information\nabout the MAC Control PAUSE function on a single\nethernet-like interface.")
dot3PauseAdminMode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 7, 10, 1, 1), Integer().subtype(subtypeSpec=SingleValueConstraint(1,4,3,2,)).subtype(namedValues=NamedValues(("disabled", 1), ("enabledXmit", 2), ("enabledRcv", 3), ("enabledXmitAndRcv", 4), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3PauseAdminMode.setDescription("This object is used to configure the default\nadministrative PAUSE mode for this interface.\n\nThis object represents the\nadministratively-configured PAUSE mode for this\ninterface.  If auto-negotiation is not enabled\nor is not implemented for the active MAU\nattached to this interface, the value of this\nobject determines the operational PAUSE mode\nof the interface whenever it is operating in\nfull-duplex mode.  In this case, a set to this\nobject will force the interface into the\nspecified mode.\n\nIf auto-negotiation is implemented and enabled\nfor the MAU attached to this interface, the\nPAUSE mode for this interface is determined by\nauto-negotiation, and the value of this object\ndenotes the mode to which the interface will\nautomatically revert if/when auto-negotiation is\nlater disabled.  Note that when auto-negotiation\nis running, administrative control of the PAUSE\nmode may be accomplished using the\nifMauAutoNegCapAdvertisedBits object in the\nMAU-MIB.\n\nNote that the value of this object is ignored\nwhen the interface is not operating in\nfull-duplex mode.\n\nAn attempt to set this object to\n'enabledXmit(2)' or 'enabledRcv(3)' will fail\non interfaces that do not support operation\nat greater than 100 Mb/s.")
dot3PauseOperMode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 7, 10, 1, 2), Integer().subtype(subtypeSpec=SingleValueConstraint(1,4,3,2,)).subtype(namedValues=NamedValues(("disabled", 1), ("enabledXmit", 2), ("enabledRcv", 3), ("enabledXmitAndRcv", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3PauseOperMode.setDescription("This object reflects the PAUSE mode currently\n\n\n\nin use on this interface, as determined by\neither (1) the result of the auto-negotiation\nfunction or (2) if auto-negotiation is not\nenabled or is not implemented for the active MAU\nattached to this interface, by the value of\ndot3PauseAdminMode.  Interfaces operating at\n100 Mb/s or less will never return\n'enabledXmit(2)' or 'enabledRcv(3)'.  Interfaces\noperating in half-duplex mode will always return\n'disabled(1)'.  Interfaces on which\nauto-negotiation is enabled but not yet\ncompleted should return the value\n'disabled(1)'.")
dot3InPauseFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 7, 10, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3InPauseFrames.setDescription("A count of MAC Control frames received on this\ninterface with an opcode indicating the PAUSE\noperation.\n\nThis counter does not increment when the\ninterface is operating in half-duplex mode.\n\nFor interfaces operating at 10 Gb/s, this\ncounter can roll over in less than 5 minutes if\nit is incrementing at its maximum rate.  Since\nthat amount of time could be less than a\nmanagement station's poll cycle time, in order\nto avoid a loss of information, a management\nstation is advised to poll the\ndot3HCInPauseFrames object for 10 Gb/s or\nfaster interfaces.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem, and at other times as indicated by the\nvalue of ifCounterDiscontinuityTime.")
dot3OutPauseFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 7, 10, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OutPauseFrames.setDescription("A count of MAC Control frames transmitted on\nthis interface with an opcode indicating the\nPAUSE operation.\n\nThis counter does not increment when the\ninterface is operating in half-duplex mode.\n\nFor interfaces operating at 10 Gb/s, this\ncounter can roll over in less than 5 minutes if\nit is incrementing at its maximum rate.  Since\nthat amount of time could be less than a\nmanagement station's poll cycle time, in order\nto avoid a loss of information, a management\nstation is advised to poll the\ndot3HCOutPauseFrames object for 10 Gb/s or\nfaster interfaces.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem, and at other times as indicated by the\nvalue of ifCounterDiscontinuityTime.")
dot3HCInPauseFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 7, 10, 1, 5), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3HCInPauseFrames.setDescription("A count of MAC Control frames received on this\ninterface with an opcode indicating the PAUSE\noperation.\n\nThis counter does not increment when the\ninterface is operating in half-duplex mode.\n\nThis counter is a 64 bit version of\ndot3InPauseFrames.  It should be used on\ninterfaces operating at 10 Gb/s or faster.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem, and at other times as indicated by the\nvalue of ifCounterDiscontinuityTime.")
dot3HCOutPauseFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 7, 10, 1, 6), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3HCOutPauseFrames.setDescription("A count of MAC Control frames transmitted on\nthis interface with an opcode indicating the\nPAUSE operation.\n\nThis counter does not increment when the\ninterface is operating in half-duplex mode.\n\nThis counter is a 64 bit version of\ndot3OutPauseFrames.  It should be used on\ninterfaces operating at 10 Gb/s or faster.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem, and at other times as indicated by the\nvalue of ifCounterDiscontinuityTime.")
dot3HCStatsTable = MibTable((1, 3, 6, 1, 2, 1, 10, 7, 11))
if mibBuilder.loadTexts: dot3HCStatsTable.setDescription("A table containing 64-bit versions of error\ncounters from the dot3StatsTable.  The 32-bit\nversions of these counters may roll over quite\nquickly on higher speed ethernet interfaces.\nThe counters that have 64-bit versions in this\ntable are the counters that apply to full-duplex\ninterfaces, since 10 Gb/s and faster\nethernet-like interfaces do not support\nhalf-duplex, and very few 1000 Mb/s\nethernet-like interfaces support half-duplex.\n\nEntries in this table are recommended for\ninterfaces capable of operating at 1000 Mb/s or\nfaster, and are required for interfaces capable\nof operating at 10 Gb/s or faster.  Lower speed\nethernet-like interfaces do not need entries in\nthis table, in which case there may be fewer\nentries in this table than in the\ndot3StatsTable. However, implementations\ncontaining interfaces with a mix of speeds may\nchoose to implement entries in this table for\n\n\n\nall ethernet-like interfaces.")
dot3HCStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 7, 11, 1)).setIndexNames((0, "EtherLike-MIB", "dot3StatsIndex"))
if mibBuilder.loadTexts: dot3HCStatsEntry.setDescription("An entry containing 64-bit statistics for a\nsingle ethernet-like interface.")
dot3HCStatsAlignmentErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 7, 11, 1, 1), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3HCStatsAlignmentErrors.setDescription("A count of frames received on a particular\ninterface that are not an integral number of\noctets in length and do not pass the FCS check.\n\nThe count represented by an instance of this\nobject is incremented when the alignmentError\nstatus is returned by the MAC service to the\nLLC (or other MAC user). Received frames for\nwhich multiple error conditions pertain are,\naccording to the conventions of IEEE 802.3\nLayer Management, counted exclusively according\nto the error status presented to the LLC.\n\nThis counter does not increment for group\nencoding schemes greater than 4 bits per group.\n\nThis counter is a 64 bit version of\ndot3StatsAlignmentErrors.  It should be used\non interfaces operating at 10 Gb/s or faster.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\n\n\n\nsystem, and at other times as indicated by the\nvalue of ifCounterDiscontinuityTime.")
dot3HCStatsFCSErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 7, 11, 1, 2), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3HCStatsFCSErrors.setDescription("A count of frames received on a particular\ninterface that are an integral number of octets\nin length but do not pass the FCS check.  This\ncount does not include frames received with\nframe-too-long or frame-too-short error.\n\nThe count represented by an instance of this\nobject is incremented when the frameCheckError\nstatus is returned by the MAC service to the\nLLC (or other MAC user). Received frames for\nwhich multiple error conditions pertain are,\naccording to the conventions of IEEE 802.3\nLayer Management, counted exclusively according\nto the error status presented to the LLC.\n\nNote:  Coding errors detected by the physical\nlayer for speeds above 10 Mb/s will cause the\nframe to fail the FCS check.\n\nThis counter is a 64 bit version of\ndot3StatsFCSErrors.  It should be used on\ninterfaces operating at 10 Gb/s or faster.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem, and at other times as indicated by the\nvalue of ifCounterDiscontinuityTime.")
dot3HCStatsInternalMacTransmitErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 7, 11, 1, 3), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3HCStatsInternalMacTransmitErrors.setDescription("A count of frames for which transmission on a\nparticular interface fails due to an internal\nMAC sublayer transmit error. A frame is only\n\n\n\ncounted by an instance of this object if it is\nnot counted by the corresponding instance of\neither the dot3StatsLateCollisions object, the\ndot3StatsExcessiveCollisions object, or the\ndot3StatsCarrierSenseErrors object.\n\nThe precise meaning of the count represented by\nan instance of this object is implementation-\nspecific.  In particular, an instance of this\nobject may represent a count of transmission\nerrors on a particular interface that are not\notherwise counted.\n\nThis counter is a 64 bit version of\ndot3StatsInternalMacTransmitErrors.  It should\nbe used on interfaces operating at 10 Gb/s or\nfaster.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem, and at other times as indicated by the\nvalue of ifCounterDiscontinuityTime.")
dot3HCStatsFrameTooLongs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 7, 11, 1, 4), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3HCStatsFrameTooLongs.setDescription("A count of frames received on a particular\ninterface that exceed the maximum permitted\nframe size.\n\nThe count represented by an instance of this\nobject is incremented when the frameTooLong\nstatus is returned by the MAC service to the\nLLC (or other MAC user). Received frames for\nwhich multiple error conditions pertain are,\naccording to the conventions of IEEE 802.3\nLayer Management, counted exclusively according\nto the error status presented to the LLC.\n\nThis counter is a 64 bit version of\ndot3StatsFrameTooLongs.  It should be used on\ninterfaces operating at 10 Gb/s or faster.\n\nDiscontinuities in the value of this counter can\n\n\n\noccur at re-initialization of the management\nsystem, and at other times as indicated by the\nvalue of ifCounterDiscontinuityTime.")
dot3HCStatsInternalMacReceiveErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 7, 11, 1, 5), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3HCStatsInternalMacReceiveErrors.setDescription("A count of frames for which reception on a\nparticular interface fails due to an internal\nMAC sublayer receive error. A frame is only\ncounted by an instance of this object if it is\nnot counted by the corresponding instance of\neither the dot3StatsFrameTooLongs object, the\ndot3StatsAlignmentErrors object, or the\ndot3StatsFCSErrors object.\n\nThe precise meaning of the count represented by\nan instance of this object is implementation-\nspecific.  In particular, an instance of this\nobject may represent a count of receive errors\non a particular interface that are not\notherwise counted.\n\nThis counter is a 64 bit version of\ndot3StatsInternalMacReceiveErrors.  It should be\nused on interfaces operating at 10 Gb/s or\nfaster.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem, and at other times as indicated by the\nvalue of ifCounterDiscontinuityTime.")
dot3HCStatsSymbolErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 7, 11, 1, 6), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3HCStatsSymbolErrors.setDescription("For an interface operating at 100 Mb/s, the\nnumber of times there was an invalid data symbol\nwhen a valid carrier was present.\n\n\n\n\nFor an interface operating in half-duplex mode\nat 1000 Mb/s, the number of times the receiving\nmedia is non-idle (a carrier event) for a period\nof time equal to or greater than slotTime, and\nduring which there was at least one occurrence\nof an event that causes the PHY to indicate\n'Data reception error' or 'carrier extend error'\non the GMII.\n\nFor an interface operating in full-duplex mode\nat 1000 Mb/s, the number of times the receiving\nmedia is non-idle (a carrier event) for a period\nof time equal to or greater than minFrameSize,\nand during which there was at least one\noccurrence of an event that causes the PHY to\nindicate 'Data reception error' on the GMII.\n\nFor an interface operating at 10 Gb/s, the\nnumber of times the receiving media is non-idle\n(a carrier event) for a period of time equal to\nor greater than minFrameSize, and during which\nthere was at least one occurrence of an event\nthat causes the PHY to indicate 'Receive Error'\non the XGMII.\n\nThe count represented by an instance of this\nobject is incremented at most once per carrier\nevent, even if multiple symbol errors occur\nduring the carrier event.  This count does\nnot increment if a collision is present.\n\nThis counter is a 64 bit version of\ndot3StatsSymbolErrors.  It should be used on\ninterfaces operating at 10 Gb/s or faster.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem, and at other times as indicated by the\nvalue of ifCounterDiscontinuityTime.")
etherMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 35)).setRevisions(("2003-09-19 00:00","1999-08-24 04:00","1998-06-03 21:50","1994-02-03 04:00",))
if mibBuilder.loadTexts: etherMIB.setOrganization("IETF Ethernet Interfaces and Hub MIB\nWorking Group")
if mibBuilder.loadTexts: etherMIB.setContactInfo("WG E-mail: hubmib@ietf.org\nTo subscribe: hubmib-request@ietf.org\n\n       Chair: Dan Romascanu\n      Postal: Avaya Inc.\n              Atidum Technology Park, Bldg. 3\n              Tel Aviv 61131\n              Israel\n         Tel: +972 3 645 8414\n      E-mail: dromasca@avaya.com\n\n     Editor: John Flick\n     Postal: Hewlett-Packard Company\n             8000 Foothills Blvd. M/S 5557\n             Roseville, CA 95747-5557\n             USA\n        Tel: +1 916 785 4018\n        Fax: +1 916 785 1199\n     E-mail: johnf@rose.hp.com")
if mibBuilder.loadTexts: etherMIB.setDescription("The MIB module to describe generic objects for\nethernet-like network interfaces.\n\nThe following reference is used throughout this\nMIB module:\n\n[IEEE 802.3 Std] refers to:\n   IEEE Std 802.3, 2002 Edition: 'IEEE Standard\n\n\n\n   for Information technology -\n   Telecommunications and information exchange\n   between systems - Local and metropolitan\n   area networks - Specific requirements -\n   Part 3: Carrier sense multiple access with\n   collision detection (CSMA/CD) access method\n   and physical layer specifications', as\n   amended by IEEE Std 802.3ae-2002:\n   'Amendment: Media Access Control (MAC)\n   Parameters, Physical Layer, and Management\n   Parameters for 10 Gb/s Operation', August,\n   2002.\n\nOf particular interest is Clause 30, '10 Mb/s,\n100 Mb/s, 1000 Mb/s, and 10 Gb/s Management'.\n\nCopyright (C) The Internet Society (2003).  This\nversion of this MIB module is part of RFC 3635;\nsee the RFC itself for full legal notices.")
etherMIBObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 35, 1))
etherConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 35, 2))
etherGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 35, 2, 1))
etherCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 35, 2, 2))

# Augmentions

# Groups

etherStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 35, 2, 1, 1)).setObjects(*(("EtherLike-MIB", "dot3StatsInternalMacTransmitErrors"), ("EtherLike-MIB", "dot3StatsFCSErrors"), ("EtherLike-MIB", "dot3StatsSingleCollisionFrames"), ("EtherLike-MIB", "dot3StatsIndex"), ("EtherLike-MIB", "dot3StatsInternalMacReceiveErrors"), ("EtherLike-MIB", "dot3StatsMultipleCollisionFrames"), ("EtherLike-MIB", "dot3StatsCarrierSenseErrors"), ("EtherLike-MIB", "dot3StatsExcessiveCollisions"), ("EtherLike-MIB", "dot3StatsEtherChipSet"), ("EtherLike-MIB", "dot3StatsSQETestErrors"), ("EtherLike-MIB", "dot3StatsAlignmentErrors"), ("EtherLike-MIB", "dot3StatsDeferredTransmissions"), ("EtherLike-MIB", "dot3StatsLateCollisions"), ("EtherLike-MIB", "dot3StatsFrameTooLongs"), ) )
if mibBuilder.loadTexts: etherStatsGroup.setDescription("********* THIS GROUP IS DEPRECATED **********\n\nA collection of objects providing information\napplicable to all ethernet-like network\ninterfaces.\n\nThis object group has been deprecated and\nreplaced by etherStatsBaseGroup and\netherStatsLowSpeedGroup.")
etherCollisionTableGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 35, 2, 1, 2)).setObjects(*(("EtherLike-MIB", "dot3CollFrequencies"), ) )
if mibBuilder.loadTexts: etherCollisionTableGroup.setDescription("A collection of objects providing a histogram\nof packets successfully transmitted after\nexperiencing exactly N collisions.")
etherStats100MbsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 35, 2, 1, 3)).setObjects(*(("EtherLike-MIB", "dot3StatsInternalMacTransmitErrors"), ("EtherLike-MIB", "dot3StatsFCSErrors"), ("EtherLike-MIB", "dot3StatsSingleCollisionFrames"), ("EtherLike-MIB", "dot3StatsIndex"), ("EtherLike-MIB", "dot3StatsInternalMacReceiveErrors"), ("EtherLike-MIB", "dot3StatsMultipleCollisionFrames"), ("EtherLike-MIB", "dot3StatsCarrierSenseErrors"), ("EtherLike-MIB", "dot3StatsExcessiveCollisions"), ("EtherLike-MIB", "dot3StatsSymbolErrors"), ("EtherLike-MIB", "dot3StatsEtherChipSet"), ("EtherLike-MIB", "dot3StatsFrameTooLongs"), ("EtherLike-MIB", "dot3StatsAlignmentErrors"), ("EtherLike-MIB", "dot3StatsDeferredTransmissions"), ("EtherLike-MIB", "dot3StatsLateCollisions"), ) )
if mibBuilder.loadTexts: etherStats100MbsGroup.setDescription("********* THIS GROUP IS DEPRECATED **********\n\nA collection of objects providing information\napplicable to 100 Mb/sec ethernet-like network\ninterfaces.\n\nThis object group has been deprecated and\nreplaced by etherStatsBaseGroup and\netherStatsHighSpeedGroup.")
etherStatsBaseGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 35, 2, 1, 4)).setObjects(*(("EtherLike-MIB", "dot3StatsInternalMacTransmitErrors"), ("EtherLike-MIB", "dot3StatsFCSErrors"), ("EtherLike-MIB", "dot3StatsSingleCollisionFrames"), ("EtherLike-MIB", "dot3StatsIndex"), ("EtherLike-MIB", "dot3StatsInternalMacReceiveErrors"), ("EtherLike-MIB", "dot3StatsMultipleCollisionFrames"), ("EtherLike-MIB", "dot3StatsCarrierSenseErrors"), ("EtherLike-MIB", "dot3StatsExcessiveCollisions"), ("EtherLike-MIB", "dot3StatsFrameTooLongs"), ("EtherLike-MIB", "dot3StatsAlignmentErrors"), ("EtherLike-MIB", "dot3StatsDeferredTransmissions"), ("EtherLike-MIB", "dot3StatsLateCollisions"), ) )
if mibBuilder.loadTexts: etherStatsBaseGroup.setDescription("********* THIS GROUP IS DEPRECATED **********\n\nA collection of objects providing information\napplicable to all ethernet-like network\ninterfaces.\n\nThis object group has been deprecated and\nreplaced by etherStatsBaseGroup2 and\netherStatsHalfDuplexGroup, to separate\nobjects which must be implemented by all\nethernet-like network interfaces from\nobjects that need only be implemented on\nethernet-like network interfaces that are\ncapable of half-duplex operation.")
etherStatsLowSpeedGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 35, 2, 1, 5)).setObjects(*(("EtherLike-MIB", "dot3StatsSQETestErrors"), ) )
if mibBuilder.loadTexts: etherStatsLowSpeedGroup.setDescription("A collection of objects providing information\n\n\n\napplicable to ethernet-like network interfaces\ncapable of operating at 10 Mb/s or slower in\nhalf-duplex mode.")
etherStatsHighSpeedGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 35, 2, 1, 6)).setObjects(*(("EtherLike-MIB", "dot3StatsSymbolErrors"), ) )
if mibBuilder.loadTexts: etherStatsHighSpeedGroup.setDescription("A collection of objects providing information\napplicable to ethernet-like network interfaces\ncapable of operating at 100 Mb/s or faster.")
etherDuplexGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 35, 2, 1, 7)).setObjects(*(("EtherLike-MIB", "dot3StatsDuplexStatus"), ) )
if mibBuilder.loadTexts: etherDuplexGroup.setDescription("A collection of objects providing information\nabout the duplex mode of an ethernet-like\nnetwork interface.")
etherControlGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 35, 2, 1, 8)).setObjects(*(("EtherLike-MIB", "dot3ControlFunctionsSupported"), ("EtherLike-MIB", "dot3ControlInUnknownOpcodes"), ) )
if mibBuilder.loadTexts: etherControlGroup.setDescription("A collection of objects providing information\nabout the MAC Control sublayer on ethernet-like\nnetwork interfaces.")
etherControlPauseGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 35, 2, 1, 9)).setObjects(*(("EtherLike-MIB", "dot3PauseOperMode"), ("EtherLike-MIB", "dot3OutPauseFrames"), ("EtherLike-MIB", "dot3PauseAdminMode"), ("EtherLike-MIB", "dot3InPauseFrames"), ) )
if mibBuilder.loadTexts: etherControlPauseGroup.setDescription("A collection of objects providing information\nabout and control of the MAC Control PAUSE\nfunction on ethernet-like network interfaces.")
etherStatsBaseGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 35, 2, 1, 10)).setObjects(*(("EtherLike-MIB", "dot3StatsInternalMacTransmitErrors"), ("EtherLike-MIB", "dot3StatsFCSErrors"), ("EtherLike-MIB", "dot3StatsFrameTooLongs"), ("EtherLike-MIB", "dot3StatsIndex"), ("EtherLike-MIB", "dot3StatsInternalMacReceiveErrors"), ("EtherLike-MIB", "dot3StatsAlignmentErrors"), ) )
if mibBuilder.loadTexts: etherStatsBaseGroup2.setDescription("A collection of objects providing information\napplicable to all ethernet-like network\ninterfaces.")
etherStatsHalfDuplexGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 35, 2, 1, 11)).setObjects(*(("EtherLike-MIB", "dot3StatsExcessiveCollisions"), ("EtherLike-MIB", "dot3StatsSingleCollisionFrames"), ("EtherLike-MIB", "dot3StatsDeferredTransmissions"), ("EtherLike-MIB", "dot3StatsMultipleCollisionFrames"), ("EtherLike-MIB", "dot3StatsLateCollisions"), ("EtherLike-MIB", "dot3StatsCarrierSenseErrors"), ) )
if mibBuilder.loadTexts: etherStatsHalfDuplexGroup.setDescription("A collection of objects providing information\napplicable only to half-duplex ethernet-like\nnetwork interfaces.")
etherHCStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 35, 2, 1, 12)).setObjects(*(("EtherLike-MIB", "dot3HCStatsInternalMacTransmitErrors"), ("EtherLike-MIB", "dot3HCStatsSymbolErrors"), ("EtherLike-MIB", "dot3HCStatsAlignmentErrors"), ("EtherLike-MIB", "dot3HCStatsFrameTooLongs"), ("EtherLike-MIB", "dot3HCStatsFCSErrors"), ("EtherLike-MIB", "dot3HCStatsInternalMacReceiveErrors"), ) )
if mibBuilder.loadTexts: etherHCStatsGroup.setDescription("A collection of objects providing high-capacity\nstatistics applicable to higher-speed\nethernet-like network interfaces.")
etherHCControlGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 35, 2, 1, 13)).setObjects(*(("EtherLike-MIB", "dot3HCControlInUnknownOpcodes"), ) )
if mibBuilder.loadTexts: etherHCControlGroup.setDescription("A collection of objects providing high-capacity\nstatistics for the MAC Control sublayer on\nhigher-speed ethernet-like network interfaces.")
etherHCControlPauseGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 35, 2, 1, 14)).setObjects(*(("EtherLike-MIB", "dot3HCOutPauseFrames"), ("EtherLike-MIB", "dot3HCInPauseFrames"), ) )
if mibBuilder.loadTexts: etherHCControlPauseGroup.setDescription("A collection of objects providing high-capacity\nstatistics for the MAC Control PAUSE function on\nhigher-speed ethernet-like network interfaces.")
etherRateControlGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 35, 2, 1, 15)).setObjects(*(("EtherLike-MIB", "dot3StatsRateControlStatus"), ("EtherLike-MIB", "dot3StatsRateControlAbility"), ) )
if mibBuilder.loadTexts: etherRateControlGroup.setDescription("A collection of objects providing information\nabout the Rate Control function on ethernet-like\ninterfaces.")

# Compliances

etherCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 35, 2, 2, 1)).setObjects(*(("EtherLike-MIB", "etherStatsGroup"), ("EtherLike-MIB", "etherCollisionTableGroup"), ) )
if mibBuilder.loadTexts: etherCompliance.setDescription("******** THIS COMPLIANCE IS DEPRECATED ********\n\nThe compliance statement for managed network\nentities which have ethernet-like network\ninterfaces.\n\nThis compliance is deprecated and replaced by\ndot3Compliance.")
ether100MbsCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 35, 2, 2, 2)).setObjects(*(("EtherLike-MIB", "etherCollisionTableGroup"), ("EtherLike-MIB", "etherStats100MbsGroup"), ) )
if mibBuilder.loadTexts: ether100MbsCompliance.setDescription("******** THIS COMPLIANCE IS DEPRECATED ********\n\nThe compliance statement for managed network\nentities which have 100 Mb/sec ethernet-like\nnetwork interfaces.\n\nThis compliance is deprecated and replaced by\ndot3Compliance.")
dot3Compliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 35, 2, 2, 3)).setObjects(*(("EtherLike-MIB", "etherStatsBaseGroup"), ("EtherLike-MIB", "etherCollisionTableGroup"), ("EtherLike-MIB", "etherDuplexGroup"), ("EtherLike-MIB", "etherControlPauseGroup"), ("EtherLike-MIB", "etherStatsLowSpeedGroup"), ("EtherLike-MIB", "etherControlGroup"), ("EtherLike-MIB", "etherStatsHighSpeedGroup"), ) )
if mibBuilder.loadTexts: dot3Compliance.setDescription("******** THIS COMPLIANCE IS DEPRECATED ********\n\nThe compliance statement for managed network\nentities which have ethernet-like network\ninterfaces.\n\nThis compliance is deprecated and replaced by\ndot3Compliance2.")
dot3Compliance2 = ModuleCompliance((1, 3, 6, 1, 2, 1, 35, 2, 2, 4)).setObjects(*(("EtherLike-MIB", "etherDuplexGroup"), ("EtherLike-MIB", "etherControlPauseGroup"), ("EtherLike-MIB", "etherStatsLowSpeedGroup"), ("EtherLike-MIB", "etherCollisionTableGroup"), ("EtherLike-MIB", "etherControlGroup"), ("EtherLike-MIB", "etherStatsBaseGroup2"), ("EtherLike-MIB", "etherHCControlPauseGroup"), ("EtherLike-MIB", "etherHCStatsGroup"), ("EtherLike-MIB", "etherRateControlGroup"), ("EtherLike-MIB", "etherHCControlGroup"), ("EtherLike-MIB", "etherStatsHalfDuplexGroup"), ("EtherLike-MIB", "etherStatsHighSpeedGroup"), ) )
if mibBuilder.loadTexts: dot3Compliance2.setDescription("The compliance statement for managed network\nentities which have ethernet-like network\ninterfaces.\n\nNote that compliance with this MIB module\nrequires compliance with the ifCompliance3\nMODULE-COMPLIANCE statement of the IF-MIB\n(RFC2863).  In addition, compliance with this\nMIB module requires compliance  with the\nmauModIfCompl3 MODULE-COMPLIANCE statement of\nthe MAU-MIB (RFC3636).")

# Exports

# Module identity
mibBuilder.exportSymbols("EtherLike-MIB", PYSNMP_MODULE_ID=etherMIB)

# Objects
mibBuilder.exportSymbols("EtherLike-MIB", dot3=dot3, dot3StatsTable=dot3StatsTable, dot3StatsEntry=dot3StatsEntry, dot3StatsIndex=dot3StatsIndex, dot3StatsAlignmentErrors=dot3StatsAlignmentErrors, dot3StatsFCSErrors=dot3StatsFCSErrors, dot3StatsSingleCollisionFrames=dot3StatsSingleCollisionFrames, dot3StatsMultipleCollisionFrames=dot3StatsMultipleCollisionFrames, dot3StatsSQETestErrors=dot3StatsSQETestErrors, dot3StatsDeferredTransmissions=dot3StatsDeferredTransmissions, dot3StatsLateCollisions=dot3StatsLateCollisions, dot3StatsExcessiveCollisions=dot3StatsExcessiveCollisions, dot3StatsInternalMacTransmitErrors=dot3StatsInternalMacTransmitErrors, dot3StatsCarrierSenseErrors=dot3StatsCarrierSenseErrors, dot3StatsFrameTooLongs=dot3StatsFrameTooLongs, dot3StatsInternalMacReceiveErrors=dot3StatsInternalMacReceiveErrors, dot3StatsEtherChipSet=dot3StatsEtherChipSet, dot3StatsSymbolErrors=dot3StatsSymbolErrors, dot3StatsDuplexStatus=dot3StatsDuplexStatus, dot3StatsRateControlAbility=dot3StatsRateControlAbility, dot3StatsRateControlStatus=dot3StatsRateControlStatus, dot3CollTable=dot3CollTable, dot3CollEntry=dot3CollEntry, dot3CollCount=dot3CollCount, dot3CollFrequencies=dot3CollFrequencies, dot3Tests=dot3Tests, dot3TestTdr=dot3TestTdr, dot3TestLoopBack=dot3TestLoopBack, dot3Errors=dot3Errors, dot3ErrorInitError=dot3ErrorInitError, dot3ErrorLoopbackError=dot3ErrorLoopbackError, dot3ControlTable=dot3ControlTable, dot3ControlEntry=dot3ControlEntry, dot3ControlFunctionsSupported=dot3ControlFunctionsSupported, dot3ControlInUnknownOpcodes=dot3ControlInUnknownOpcodes, dot3HCControlInUnknownOpcodes=dot3HCControlInUnknownOpcodes, dot3PauseTable=dot3PauseTable, dot3PauseEntry=dot3PauseEntry, dot3PauseAdminMode=dot3PauseAdminMode, dot3PauseOperMode=dot3PauseOperMode, dot3InPauseFrames=dot3InPauseFrames, dot3OutPauseFrames=dot3OutPauseFrames, dot3HCInPauseFrames=dot3HCInPauseFrames, dot3HCOutPauseFrames=dot3HCOutPauseFrames, dot3HCStatsTable=dot3HCStatsTable, dot3HCStatsEntry=dot3HCStatsEntry, dot3HCStatsAlignmentErrors=dot3HCStatsAlignmentErrors, dot3HCStatsFCSErrors=dot3HCStatsFCSErrors, dot3HCStatsInternalMacTransmitErrors=dot3HCStatsInternalMacTransmitErrors, dot3HCStatsFrameTooLongs=dot3HCStatsFrameTooLongs, dot3HCStatsInternalMacReceiveErrors=dot3HCStatsInternalMacReceiveErrors, dot3HCStatsSymbolErrors=dot3HCStatsSymbolErrors, etherMIB=etherMIB, etherMIBObjects=etherMIBObjects, etherConformance=etherConformance, etherGroups=etherGroups, etherCompliances=etherCompliances)

# Groups
mibBuilder.exportSymbols("EtherLike-MIB", etherStatsGroup=etherStatsGroup, etherCollisionTableGroup=etherCollisionTableGroup, etherStats100MbsGroup=etherStats100MbsGroup, etherStatsBaseGroup=etherStatsBaseGroup, etherStatsLowSpeedGroup=etherStatsLowSpeedGroup, etherStatsHighSpeedGroup=etherStatsHighSpeedGroup, etherDuplexGroup=etherDuplexGroup, etherControlGroup=etherControlGroup, etherControlPauseGroup=etherControlPauseGroup, etherStatsBaseGroup2=etherStatsBaseGroup2, etherStatsHalfDuplexGroup=etherStatsHalfDuplexGroup, etherHCStatsGroup=etherHCStatsGroup, etherHCControlGroup=etherHCControlGroup, etherHCControlPauseGroup=etherHCControlPauseGroup, etherRateControlGroup=etherRateControlGroup)

# Compliances
mibBuilder.exportSymbols("EtherLike-MIB", etherCompliance=etherCompliance, ether100MbsCompliance=ether100MbsCompliance, dot3Compliance=dot3Compliance, dot3Compliance2=dot3Compliance2)
