#!/usr/bin/python

import sys
from datetime import ( datetime, timedelta )
import launchpadlib
from launchpadlib.launchpad import Launchpad
from launchpadlib.errors import HTTPError

bugnum       = 422119
consumer     = 'lpltk'
service_root = 'production'
lp           = Launchpad.login_anonymously(consumer, service_root)
bug          = lp.bugs[bugnum]
last_time    = datetime.now()

def ts(start_time):
    global last_time
    now = datetime.now()
    run_time = (now - start_time)
    call_time = (now - last_time)
    last_time = now
    return "[%8.4f (%6.4f sec)]" %(
        run_time.microseconds/1000000.0 + run_time.seconds,
        call_time.microseconds/1000000.0 + call_time.seconds
        )

def main():
    print "%-10s %s" %( bug.id, bug.title )
    print "== attachments =="

    for a in bug.attachments:
        s   = datetime.now()
        print "\n\n"
        print "%8s %-15s %s" % (ts(s), "title:",        a.title)

        print "%8s %-15s %s" % (ts(s), "ispatch:",          a.type)
        print "%8s %-15s %s" % (ts(s), "http_etag:",        a.http_etag)
        print "%8s %-15s %s" % (ts(s), "a.url:",            a.self)
            
        m = a.message
        print "%8s %-15s %s" % (ts(s), "subject:",          m.subject.encode('utf-8'))
        print "%8s %-15s %s" % (ts(s), "owner:",            m.owner.display_name.encode('utf-8'))
        print "%8s %-15s %s" % (ts(s), "created:",          m.date_created)
                
        fb = a.data.open()
        print "%8s %-15s %s" % (ts(s), "modified:",         fb.last_modified)
        print "%8s %-15s %s" % (ts(s), "fb.url:",           fb.url)
        print "%8s %-15s %s" % (ts(s), "content-type:",     fb.content_type)
        print "%8s %-15s %s" % (ts(s), "filename:",         fb.filename.encode('utf-8'))
        print "%8s %-15s %s" % (ts(s), "isatty:",           fb.isatty())
        print "%8s %-15s %s" % (ts(s), "len:",              fb.len)
        print "%8s %-15s %s" % (ts(s), "mode:",             fb.mode)
        print "%8s %-15s %s" % (ts(s), "pos:",              fb.pos)
        print "%8s %-15s %s" % (ts(s), "softspace:",        fb.softspace)
                    
        print "%8s %-15s %s" % (ts(s), "content:",          len(fb.read()))
        print "%8s" %(ts(s))
    return 0

sys.exit(main())
