"""
Help Window
"""
#  Copyright (C) 2004  Henning Jacobs <henning@srcco.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  $Id: HelpWindow.py 92 2004-11-28 15:34:44Z henning $

from Tkinter import *
import Pmw

class HelpWindow(Pmw.Dialog):
    def __init__(self, master):
        Pmw.Dialog.__init__(self, master=master, title='PyCoCuMa Help',
            buttons=('Close',), defaultbutton='Close')
        self.master = master
        self.iconbitmap(master.iconbitmap()) 
        self.iconmask(master.iconmask()) 
        self.text = text = Pmw.ScrolledText(self.interior(), 
            text_width=80, text_height=24,
            text_wrap=WORD,
            text_highlightthickness=0,
            text_padx=5, text_pady=5,
            text_font=('Helvetica', -14),
            text_background='#ffffee',
            text_spacing3=5)
        self.text.pack(fill=BOTH, expand=1)
        
        text.tag_config('h1', font=('Helvetica', -20, 'bold'),
            justify=CENTER,
            spacing3=2)
        text.tag_config('h2', font=('Helvetica', -16, 'bold'),
            justify=LEFT,
            spacing1=10,
            spacing3=5)
        text.tag_config('i', font=('Helvetica', -14, 'italic'))
        text.tag_config('b', font=('Helvetica', -14, 'bold'))
        text.tag_config('a', foreground='#0000aa', underline=1)

        def append(text, tags=None, widget=text):
            parts = text.split('*')
            i = 0
            for s in parts:
                if i % 2 == 1:
                    widget.insert(END, s, 'b')
                else:
                    widget.insert(END, s, tags)
                i += 1

        from __version__ import __version__
        append('PyCoCuMa %s Help\n' % (__version__,), 'h1')
        append('Keyboard Shortcuts:', 'h2')
        append("""
F1 \t switch to the 'List View' notebook page
F2 \t switch to 'Card View'
F3 \t open the contact for edit
F4 \t open the Journal window
F5 \t open the Calendar window
F6 \t open the 'Compose Letter' window
(commands above will also raise the respective window)
CTRL-O \t connect to server / open database from file
CTRL-S \t save modified contact / save modified journal entry
CTRL-F \t open 'Find Contact' dialog 
CTRL-N \t find next contact
CTRL-E \t open external editor (only in text fields)
""")
        append('Tips:', 'h2')
        append("""
PyCoCuMa has many tool-tips (help balloons); e.g. leave the mouse cursor \
over an address-type button in 'Edit Contact' to get the meaning of the \
small symbolic images.
Double-click on a row in List View to switch to Card View.
Double-click on the card in Card View to open the contact for edit.
Double-click on a free day of the Calendar to create a new journal entry for this date.
Enter the first characters of a family name into the \
'Search/Select' textbox on the top to get a list of contacts starting with \
this family name.
To *add a category*, simply add the category to the comma-separated list \
in the 'Categories' textbox of a contact. After saving the card, the \
category will appear in the 'Filter' combobox.
To *change the sorting order* of a contact, edit the 'Sort-String' field \
provided by the 'Additional Fields..' dialog. E.g. a contact named \
'Niklas van Haarten' will be found under the letter 'v' at first; \
but by setting 'Sort-String' to 'Haarten' you can then move the card to the \
letter 'H', were you would probably expect it to be.
Install MikTeX for Windows (""")
        append('http://www.miktex.org', 'a')
        append(""") and add 'pdflatex' to your PATH \
environment variable in order to use 'File'->'Page View' on Windows.
Edit the variables 'url_viewer' and 'mailto_program' in '~/.pycocuma' to set \
them to your preferred web browser and mail-composer application. \
If you leave 'url_viewer' blank, PyCoCuMa will try to use your platform \
specific default web browser.

*Bug-reports, comments and suggestions are very welcome!*
Please send any bug reports to """)
        append("""pycocuma-bugs@srcco.de
""", 'a')
        append("""See the README file for more information.

""")
        append('Last-Modification: Henning Jacobs, 2004-11-28', 'i')

        text.configure(text_state=DISABLED)
        self.withdraw()
        
    _firstshow = 1
    def show(self):
        if self._firstshow:
            self.centerWindow()
        else:
            self.deiconify()
        self._firstshow = 0
            
    def centerWindow(self, relx=0.5, rely=0.5):
        "Center the Window on Screen"
        widget = self
        master = self.master
        widget.update_idletasks() # Actualize geometry information
        if master.winfo_ismapped():
            m_width = master.winfo_width()
            m_height = master.winfo_height()
            m_x = master.winfo_rootx()
            m_y = master.winfo_rooty()
        else:
            m_width = master.winfo_screenwidth()
            m_height = master.winfo_screenheight()
            m_x = m_y = 0
        w_width = widget.winfo_reqwidth()
        w_height = widget.winfo_reqheight()
        x = m_x + (m_width - w_width) * relx
        y = m_y + (m_height - w_height) * rely
        if x+w_width > master.winfo_screenwidth():
            x = master.winfo_screenwidth() - w_width
        elif x < 0:
            x = 0
        if y+w_height > master.winfo_screenheight():
            y = master.winfo_screenheight() - w_height
        elif y < 0:
            y = 0
        widget.geometry("+%d+%d" % (x, y))
        widget.deiconify() # Become visible at the desired location

if __name__ == '__main__':
    tk = Tk()
    win = HelpWindow(tk)
    tk.mainloop()

