/*
  Plee the Bear

  Copyright (C) 20052011 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file hideout_revealing.hpp
 * \brief The class describing an object which reaveal a zone
 * when a player enter.
 * \author Sbastien Angibaud
 */
#ifndef __PTB_HIDEOUT_REVEALING_HPP__
#define __PTB_HIDEOUT_REVEALING_HPP__

#include "engine/base_item.hpp"

#include "ptb/player_proxy.hpp"

#include "engine/export.hpp"

namespace ptb
{
  /**
   * \brief The class describing an object which reaveal a zone
   * when a player enter.
   * \author Sbastien Angibaud
   *  - \a hiding_items: \c (list of items) The items to reveal.
   *  - \a definitive_disclosure: \c Indicates if the disclosure is definitive.
   *  - \a revealing_opacity: \c (real)
   * The opacity when we reveal items.
   *  - \a hideout_opacity: \c (real) The opacity when we hide items.
   *  - \a revelation_duration: \c (real) The duration of the revealation.
   */
  class hideout_revealing:
    public bear::engine::base_item
  {
    DECLARE_BASE_ITEM(hideout_revealing);

  public:
    /** \brief The type of the parent class. */
    typedef bear::engine::base_item super;

  public:
    hideout_revealing();

    void progress( bear::universe::time_type elapsed_time );
    void build();

    virtual bool set_item_list_field
      ( const std::string& name, const std::vector<base_item*>& value );
    virtual bool set_bool_field( const std::string& name, bool value );
    virtual bool set_real_field( const std::string& name, double value );

  private:
    void search_players();
    void reveal();
    void hide();

  private:
    /** \brief The list of items to reveal. */
    std::vector<bear::universe::item_handle> m_items;

    /** \brief Indicate there is a player in the zone. */
    bool m_player_in_zone;

    /** \brief Indicates if the disclosure is definitive. */
    bool m_definitive_disclosure;

    /** \brief The opacity when the zone is revealing. */
    double m_revealing_opacity;

    /** \brief The opacity when the zone is not revealing. */
    double m_hideout_opacity;

    /** \brief Indicates if items have been revealed
     * in the current iteration. */
    bool m_current_revealed;

    /** \brief Indicates if items have been revealed
     * in the last iteration. */
    bool m_last_revealed;

    /** \brief Indicates if the hideout have been definitively found. */
    bool m_hideout_found;

    /** \brief The duration of the revelation. */
    bear::universe::time_type m_revelation_duration;

    /** \brief The time since the last modification. */
    bear::universe::time_type m_last_modification;

    /** \brief The first player. */
    player_proxy m_first_player;

    /** \brief The second player. */
    player_proxy m_second_player;

    /** \brief The identifier of the hideout. */
    std::string m_hideout_name;

  }; // class hideout_revealing
} // namespace ptb

#endif // __PTB_HIDEOUT_REVEALING_HPP__
