/*
 * Plasma applet to display indicators from libindicate
 *
 * Copyright 2009 Canonical Ltd.
 *
 * Authors:
 * - Aurélien Gâteau <aurelien.gateau@canonical.com>
 *
 * License: GPL v3
 */
// Self
#include "timeutilstest.h"

// Qt
#include <QLocale>
#include <QtTest>

// KDE
#include <qtest_kde.h>
#include <KDebug>
#include <KGlobal>
#include <KLocale>

// Local
#include <timeutils.h>

QTEST_KDEMAIN(TimeUtilsTest, GUI)

static const QDate NOW_DATE(2006, 4, 1);
static const QTime NOW_TIME(9, 0);
static const QDateTime NOW_DATETIME(NOW_DATE, NOW_TIME);

void TimeUtilsTest::testFormatDateTime()
{
    QFETCH(QDateTime, dateTime);
    QFETCH(QString, expected);

    QString result = TimeUtils::formatDateTime(dateTime, NOW_DATETIME);
    QCOMPARE(result, expected);
}

void TimeUtilsTest::testFormatDateTime_data()
{
    QTest::addColumn<QDateTime>("dateTime");
    QTest::addColumn<QString>("expected");

    KLocale* locale = KGlobal::locale();
    QDateTime dateTime;
    QTime time;

    QTest::newRow("4 minutes ago")
        << QDateTime(NOW_DATE, NOW_TIME.addSecs(- 4 * 60))
        << TimeUtils::formatShortDuration(4);

    time = NOW_TIME.addSecs(- 2 * 3600 - 4 * 60);
    QTest::newRow("2 hours 4 minutes ago")
        << QDateTime(NOW_DATE, time)
        << locale->formatTime(time);

    dateTime = QDateTime(NOW_DATE.addDays(-1), NOW_TIME);
    QTest::newRow("Yesterday")
        << dateTime
        << QDate::shortDayName(dateTime.date().dayOfWeek()) + " " + locale->formatTime(NOW_TIME);

    dateTime = QDateTime(NOW_DATE.addDays(-7), NOW_TIME);
    QTest::newRow("7 days ago")
        << dateTime
        << dateTime.toString(TimeUtils::shortDateFormat()) + " " + locale->formatTime(NOW_TIME);
}

void TimeUtilsTest::testShortDateFormat()
{
    QLocale cLocale = QLocale::c();
    QString format = TimeUtils::shortDateFormat(&cLocale);
    QCOMPARE(format, QString("d MMM"));
}

#include "timeutilstest.moc"
