#! /usr/bin/perl -w

use strict;
use warnings;

use Socket;

require 'Classes/Filter.pm';

package main;

require 'Functions/nessus.pl';
require 'Functions/console.pl';

my $nessus_report = shift;
my $dest_filter_dir = shift;

if ( ! $nessus_report or ! $dest_filter_dir )
{
	die( "usage : ./nsr2flt.pl nessus_report.nsr destination_filter_dir/\n" );
}

my $callback_data = {
	'nessus_allowed_types' => {
		'INFO' => 1,	# Security Note/Informational
		'REPORT' => 1	# Security Warning/HOLE
	},
	'nessus_port_list' => {},# Discovered port list
	'filter_directory' => $dest_filter_dir,	# Directory where the generated filters would be saved
	'filter_count' => 0
};

if ( -d $dest_filter_dir )
{
	  # Create port list from nessus report file :
	if ( parse_nessus_nsr_file( $nessus_report, \&add_nessus_entry_to_host_port_list, $callback_data ) )
	{
		  # Create a filter for each port in the port list and save it to disk :
		create_filter_from_port_list( $callback_data->{'nessus_port_list'}, 'ip', \&save_generated_filter_to_disk, $callback_data );

		print "\nGenerated ".( $callback_data->{'filter_count'} )." filters from this nessus report ($nessus_report)\n";
	}
}
else
{
	die( "This directory does not exist : $dest_filter_dir\n" );
}

sub save_generated_filter_to_disk($$)
{
	my $callback_data = shift;
	my $Filter = shift;

	$Filter->save();
	$callback_data->{'filter_count'} ++;
}
