#!/usr/bin/perl

print "header {\n";
print "    title = \"Syslog picviz analysis\";\n";
print "}\n";
print "engine {\n";
print "    relative = \"1\";\n";
print "}\n";
print "axes {\n";
print "    timeline time [label=\"Time\"];\n"; # Time
print "    string   auth [label=\"Auth type\"];\n"; # Machine
print "    ipv4     src [label=\"Source\"];\n"; # Service
print "    string   login [label=\"Login\"];\n"; # PAM Module
print "}\n";

print "data {\n";

while ($line = <>) {

        $line =~ s/\"/\\"/g; # We escape our quotes
        $line =~ s/&//g; # We escape our quotes
        $line =~ s/<//g; # We escape our quotes
        $line =~ s/>//g; # We escape our quotes

# Aug 18 (20:45:53) jazz sshd[26424]: (Accepted publickey) for (toady) from (192.168.1.23) port 63379 ssh2
# Aug 18 (20:49:47) jazz sshd[26444]: (Accepted keyboard-interactive/pam) for (toady) from (192.168.1.42) port 1115 ssh2
# Aug 18 (21:02:38) jazz sshd[26592]: error: PAM: (Authentication failure) for (toady) from (192.168.1.42)

	if ($line =~ m/\w+  ?\d+ (\d+:\d+:\d+) [\w-.]+ sshd.*: (.*) for (\w+) from (\d+.\d+.\d+.\d+)/) {
		$time=$1;
		$authtype=$2;
		$login=$3;
		$src=$4;

		if ($authtype =~ m/[fF]ail/) {
			print "    time=\"$time\",auth=\"$authtype\",src=\"$src\",login=\"$login\" [color=\"red\"];\n";
		} else {
			print "    time=\"$time\",auth=\"$authtype\",src=\"$src\",login=\"$login\";\n";
		}
	}
}

print "}\n";

