<?php
/**
*
* install [Ukrainian]
*
* @package language
* @version $Id: install.php 9035 2008-10-25 14:12:13Z acydburn $
* @copyright (c) 2005 phpBB Group
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

$lang = array_merge($lang, array(
	'ADMIN_CONFIG'				=> 'Конфігурація адміністратора',
	'ADMIN_PASSWORD'			=> 'Пароль адміністратора',
	'ADMIN_PASSWORD_CONFIRM'	=> 'Підтвердження паролю адміністратора',
	'ADMIN_PASSWORD_EXPLAIN'	=> 'Введіть, будь-ласка, пароль довжиною від 6 до 30 символів.',
	'ADMIN_TEST'				=> 'Перевірити налаштування адміністратора',
	'ADMIN_USERNAME'			=> 'Ім\'я адміністратора',
	'ADMIN_USERNAME_EXPLAIN'	=> 'Введіть, будь-ласка, пароль довжиною від 3 до 20 символів.',
	'APP_MAGICK'				=> 'Підтримка Imagemagick [ Приєднання ]',
	'AUTHOR_NOTES'				=> 'Примітки автора<br />» %s',
	'AVAILABLE'					=> 'Доступно',
	'AVAILABLE_CONVERTORS'		=> 'Доступні конвертери',

	'BEGIN_CONVERT'					=> 'Розпочати конвертування',
	'BLANK_PREFIX_FOUND'			=> 'Сканування ваших таблиць знайшло коректно встановлений форум без префіксу таблиць.',
	'BOARD_NOT_INSTALLED'			=> 'Не знайдено встановленого форуму',
	'BOARD_NOT_INSTALLED_EXPLAIN'	=> 'Для роботи phpBB Unified Convertor Framework необхідна встановлена за замовчуваням версія phpBB3, будь-ласка <a href="%s">спочатку встановіть phpBB3</a>.',
	'BACKUP_NOTICE'					=> 'Будь-ласка, зробіть резервну копію вашого форуму перед оновленням, щоб запобігти можливим проблемам в процесі оновлення.',
   
	'CATEGORY'					=> 'Категорія',
	'CACHE_STORE'				=> 'Тип кешу',
	'CACHE_STORE_EXPLAIN'		=> 'Фізичне розміщення даних кешу, надається перевага файловій системі.',
	'CAT_CONVERT'				=> 'Конвертування',
	'CAT_INSTALL'				=> 'Встановлення',
	'CAT_OVERVIEW'				=> 'Огляд',
	'CAT_UPDATE'				=> 'Оновлення',
	'CHANGE'					=> 'Змінити',
	'CHECK_TABLE_PREFIX'		=> 'Перевірте, будь-ласка, префікси ваших таблиць і повторіть вашу спробу.',
	'CLEAN_VERIFY'				=> 'Очищення та перевірка кінцевої структури',
	'CLEANING_USERNAMES'		=> 'Очищення імен користувачів',
	'COLLIDING_CLEAN_USERNAME'	=> '<strong>%s</strong> - очищене ім\'я користувача для:',
	'COLLIDING_USERNAMES_FOUND'	=> 'На вашому старому форумі знайдено конфліктні імена користувачів. Для завершення конвертування, будь-ласка, видаліть або перейменуйте цих користувачів, щоб кожному очищеному користувачу відповідав один користувач вашого старого форуму.',
	'COLLIDING_USER'			=> '» ідентифікатор користувача: <strong>%d</strong> ім\'я користувача: <strong>%s</strong> (%d повідомлень)',
	'CONFIG_CONVERT'			=> 'Конвертування конфігурації',
	'CONFIG_FILE_UNABLE_WRITE'	=> 'Не вдалося записати файл конфігурації. Інші способи збереження цього файлу вказано нижче.',
	'CONFIG_FILE_WRITTEN'		=> 'Файл конфігурації збережено. Ви можете перейти до наступного кроку встановлення.',
	'CONFIG_PHPBB_EMPTY'		=> 'Змінна конфігурації phpBB3 для “%s” порожня.',
	'CONFIG_RETRY'				=> 'Повторити спробу',
	'CONTACT_EMAIL_CONFIRM'		=> 'Підтвердження контактної адреси e-mail',
	'CONTINUE_CONVERT'			=> 'Продовжити конвертування',
	'CONTINUE_CONVERT_BODY'		=> 'Виявлено попередню спробу конвертування. Ви можете обрати нове конвертування або продовжити попереднє.',
	'CONTINUE_LAST'				=> 'Продовжити заключні операції',
	'CONTINUE_OLD_CONVERSION'	=> 'Продовжити вже розпочате раніше конвертування',
	'CONVERT'					=> 'Конвертувати',
	'CONVERT_COMPLETE'			=> 'Конвертування завершено',
	'CONVERT_COMPLETE_EXPLAIN'	=> 'Ви успішно конвертували ваш форум в формат phpBB 3.0. Тепер ви можете залогуватись і <a href="../">увійти на форум</a>. Будь-ласка, переконайтесь, що усі налаштування успішно перенесено, перед тим, як увімкнути ваш форум, видаливши папку install. Пам\'ятайте, що допомогу з користування phpBB можна отримати на офсайті phpBB в розділі <a href="https://www.phpbb.com/support/documentation/3.0/">Документація</a> та на <a href="https://www.phpbb.com/community/viewforum.php?f=46">форумі підтримки</a>.',
	'CONVERT_INTRO'				=> 'Ласкаво просимо до phpBB Unified Convertor Framework',
	'CONVERT_INTRO_BODY'		=> 'Тут ви можете імпортувати дані з інших (встановлених) систем форумів. Нижчеподаний список містить усі доступні наразі модулі конвертування. Якщо потрібного вам конвертера немає у цьому списку, будь-ласка, відвідайте наш веб-сайт, на ньому можуть бути доступні додаткові модулі для конвертування.',
	'CONVERT_NEW_CONVERSION'	=> 'Нове конвертування',
	'CONVERT_NOT_EXIST'			=> 'Вказаний конвертер не існує.',
	'CONVERT_OPTIONS'			=> 'Налаштування',
	'CONVERT_SETTINGS_VERIFIED'	=> 'Введену вами інформацію перевірено. Для початку процесу конвертування, натисніть відповідну кнопку внизу.',
	'CONV_ERR_FATAL'			=> 'Критична помилка конвертування',

	'CONV_ERROR_ATTACH_FTP_DIR'			=> 'Для старого форуму увімкнуто завантаження файлів по FTP. Вимкніть, будь-ласка, опцію завантаження по FTP та переконайтесь, що вірно вказано директорію завантаження, тоді скопіюйте усі приєднані файли до цієї доступної через інтернет директорії. Після того, як ви зробите це, перезапустіть конвертер.',
	'CONV_ERROR_CONFIG_EMPTY'			=> 'Відсутня інформація про конфігурацію для конвертування.',
	'CONV_ERROR_FORUM_ACCESS'			=> 'Не вдається отримати інформацію про права доступу.',
	'CONV_ERROR_GET_CATEGORIES'			=> 'Не вдається отримати інформацію про категорії.',
	'CONV_ERROR_GET_CONFIG'				=> 'Не вдається отримати інформацію про конфігурацію форуму.',
	'CONV_ERROR_COULD_NOT_READ'			=> 'Не вдалось отримати доступ/прочитати “%s”.',
	'CONV_ERROR_GROUP_ACCESS'			=> 'Не вдалось отримати інформацію про права доступу для груп.',
	'CONV_ERROR_INCONSISTENT_GROUPS'	=> 'Виявлено порушення цілісності таблиці груп в add_bots() - вам необхідно додати усі спеціальні групи вручну.',
	'CONV_ERROR_INSERT_BOT'				=> 'Не вдалось додати бота в таблицю користувачів.',
	'CONV_ERROR_INSERT_BOTGROUP'		=> 'Не вдалось додати бота в таблицю ботів.',
	'CONV_ERROR_INSERT_USER_GROUP'		=> 'Не вдалось додати користувача в таблицю user_group.',
	'CONV_ERROR_MESSAGE_PARSER'			=> 'Помилка обробки повідомлення',
	'CONV_ERROR_NO_AVATAR_PATH'			=> 'Примітка для розробника: ви повинні вказати $convertor[\'avatar_path\'] для використання %s.',
	'CONV_ERROR_NO_FORUM_PATH'			=> 'Не вказано відносний шлях до початкового форуму.',
	'CONV_ERROR_NO_GALLERY_PATH'		=> 'Примітка для розробника: ви повинні вказати $convertor[\'avatar_gallery_path\'] для використання %s.',
	'CONV_ERROR_NO_GROUP'				=> 'Не вдалось знайти групу “%1$s” в %2$s.',
	'CONV_ERROR_NO_RANKS_PATH'			=> 'Примітка для розробника: ви повинні вказати $convertor[\'ranks_path\'] для використання %s.',
	'CONV_ERROR_NO_SMILIES_PATH'		=> 'Примітка для розробника: ви повинні вказати $convertor[\'smilies_path\'] для використання %s.',
	'CONV_ERROR_NO_UPLOAD_DIR'			=> 'Примітка для розробника: ви повинні вказати $convertor[\'upload_path\'] для використання %s.',
	'CONV_ERROR_PERM_SETTING'			=> 'Не вдалось додати/оновити права доступу.',
	'CONV_ERROR_PM_COUNT'				=> 'Не вдалось визначити кількість приватних повідомлень.',
	'CONV_ERROR_REPLACE_CATEGORY'		=> 'Не вдалось додати новий форум замість старої категорії.',
	'CONV_ERROR_REPLACE_FORUM'			=> 'Не вдалось додати новий форум замість старого.',
	'CONV_ERROR_USER_ACCESS'			=> 'Не вдалось отримати дані автентифікації користувача.',
	'CONV_ERROR_WRONG_GROUP'			=> 'Виявлено невірну групу “%1$s” в %2$s.',
	'CONV_OPTIONS_BODY'					=> 'На цій сторінці вам необхідно ввести дані, необхідні для доступу до початкового форуму. Надайте інформацію про базу даних вашого старого форуму, конвертер не буде вносити в неї жодних змін. Для нормальної роботи конвертера старий форум буде вимкнено.',
	'CONV_SAVED_MESSAGES'				=> 'Збережені повідомлення',

	'COULD_NOT_COPY'			=> 'Не вдається скопіювати файл <strong>%1$s</strong> в <strong>%2$s</strong><br /><br />Перевірте, будь-ласка, чи існує директорія призначення і чи до неї є доступ на запис для вебсерверу.',
	'COULD_NOT_FIND_PATH'		=> 'Не вдалось знайти шлях до старого форуму. Перевірте ваші налаштування і повторіть вашу спробу.<br />» %s - було вказано такий шлях до старого форуму.',

	'DBMS'						=> 'Тип бази даних',
	'DB_CONFIG'					=> 'Конфігурація бази даних',
	'DB_CONNECTION'				=> 'З\'єднання з базою даних',
	'DB_ERR_INSERT'				=> 'Помилка при обробці запиту <code>INSERT</code>.',
	'DB_ERR_LAST'				=> 'Помилка при обробці запиту <var>query_last</var>.',
	'DB_ERR_QUERY_FIRST'		=> 'Помилка при виконанні <var>query_first</var>.',
	'DB_ERR_QUERY_FIRST_TABLE'	=> 'Помилка при виконанні <var>query_first</var>, %s (“%s”).',
	'DB_ERR_SELECT'				=> 'Помилка при обробці запиту <code>SELECT</code>.',
	'DB_HOST'					=> 'Ім\'я хосту сервера бази даних або DSN',
	'DB_HOST_EXPLAIN'			=> 'DSN - назва джерела даних при встановленні з використанням ODBC. При використанні PostgreSQL, використовуйте localhost для з\'єднання з локальним сервером через доменний сокет UNIX, і 127.0.0.1 для з\'єднання через TCP. Для SQLite введіть повний шлях до файлу вашої бази даних.',
	'DB_NAME'					=> 'Назва бази даних',
	'DB_PASSWORD'				=> 'Пароль бази даних',
	'DB_PORT'					=> 'Порт сервера бази даних',
	'DB_PORT_EXPLAIN'			=> 'Залиште це поле порожнім, окрім випадку, якщо ваш сервер використовує нестандартний порт.',
 	'DB_UPDATE_NOT_SUPPORTED' => 'На жаль, цей скрипт не підтримує оновлення з версій phpBB до «%1$s». Встановлена вами версія - «%2$s». Оновіть попередню версію перед запуском цього скрипту. Допомогу з цієї проблеми можна знайти на форумах підтримки на сайті phpBB.com.',
	'DB_USERNAME'				=> 'Ім\'я користувача бази даних',
	'DB_TEST'					=> 'Перевірити з\'єднання',
	'DEFAULT_LANG'				=> 'Мова форуму за замовчуванням',
	'DEFAULT_PREFIX_IS'			=> 'Конвертер не зміг знайти таблиці з вказаним префіксом. Будь-ласка, переконайтесь, що ви ввели правильні дані про форум, який ви конвертуєте. Для таблиць форуму %1$s префікс за замовчуванням - <strong>%2$s</strong>.',
	'DEV_NO_TEST_FILE'			=> 'Для конвертера не вказано значення для змінної test_file variable. Якщо ви користувач цього конвертера, повідомте про цю помилку автора конвертера, оскільки вона не повинна виникати. Якщо ви є автором конвертера, вам необхідно вказати назву файлу форуму, який конвертується, для того, щоб  перевірити правильність шляху до нього.',
	'DIRECTORIES_AND_FILES'		=> 'Налаштування директорій та файлів',
	'DISABLE_KEYS'				=> 'Деактивація ключів',
	'DLL_FIREBIRD'				=> 'Firebird',
	'DLL_FTP'					=> 'Підтримка віддаленого FTP [ Встановлення ]',
	'DLL_GD'					=> 'Підтримка графіки GD [ Візуальне підтвердження ]',
	'DLL_MBSTRING'				=> 'Підтримка багатобайтових символів',
	'DLL_MSSQL'					=> 'MSSQL Server 2000+',
	'DLL_MSSQL_ODBC'			=> 'MSSQL Server 2000+ через ODBC',
  'DLL_MSSQLNATIVE'        		 => 'MSSQL Server 2005+ [ Native ]',
	'DLL_MYSQL'					=> 'MySQL',
	'DLL_MYSQLI'				=> 'MySQL з розширенням MySQLi',
	'DLL_ORACLE'				=> 'Oracle',
	'DLL_POSTGRES'				=> 'PostgreSQL',
	'DLL_SQLITE'				=> 'SQLite',
	'DLL_XML'					=> 'Підтримка XML [ Jabber ]',
	'DLL_ZLIB'					=> 'Підтримка стиснення zlib [ gz, .tar.gz, .zip ]',
	'DL_CONFIG'					=> 'Конфігурація завантаження',
	'DL_CONFIG_EXPLAIN'			=> 'Ви можете завантажити файл config.php на свій комп\'ютер. Потім вам необхідно завантажити його вручну, замінивши існуючий config.php в кореневій директорії phpBB 3.0. Пам\'ятайте, що файл повинен бути завантаженим у форматі ASCII (якщо ви невпевнені, як це правильно зробити, перегляньте документацію вашого FTP-клієнта). Коли ви завантажите config.php, натисніть “Виконано” для переходу до наступного етапу встановлення.',
	'DL_DOWNLOAD'				=> 'Download',
	'DONE'						=> 'Виконано',

	'ENABLE_KEYS'				=> 'Реактивація ключів. Це може зайняти деякий час.',

	'FILES_OPTIONAL'			=> 'Необов\'язкові файли та директорії',
	'FILES_OPTIONAL_EXPLAIN'	=> '<strong>Необов\'язкові</strong> - Ці файли, директорії та права доступу не є обов\'язковими. Система встановлення буде намагатись усіма можливими методами створити їх, якщо вони не існують або вони недоступні для запису. Їх наявність прискорить процес встановлення.',
	'FILES_REQUIRED'			=> 'Файли та директорії',
	'FILES_REQUIRED_EXPLAIN'	=> '<strong>Необхідні</strong> - для коректної роботи phpBB потребує доступ на запис в певні файли та директорії. Якщо ви бачите напис “Не знайдено”, значить вам потрібно створити відповідний файл або директорію. Якщо ви бачите напис “Недоступно для запису”, вам потрібно змінити права доступу до файлу або директорії так, щоб дозволити запис для phpBB в ці файли.',
	'FILLING_TABLE'				=> 'Заповнення таблиці <strong>%s</strong>',
	'FILLING_TABLES'			=> 'Заповнення таблиць',

  'FIREBIRD_DBMS_UPDATE_REQUIRED' => 'phpBB більше не підтримує версії Firebird/Interbase, нижчі за 2.1. Будь-ласка, оновіть Firebird, принаймні до версії 2.1.0 перед продовженням процесу оновлення.',

	'FINAL_STEP'				=> 'Завершальний крок',
	'FORUM_ADDRESS'				=> 'Адреса форуму',
	'FORUM_ADDRESS_EXPLAIN'		=> 'Це URL-адреса вашого старого форуму, наприклад <samp>http://www.example.com/phpBB2/</samp>. Якщо в дане поле введено адресу, вона буде замінена на нову адресу форуму в повідомленнях, приватних повідомленнях і підписах.',
	'FORUM_PATH'				=> 'Шлях до форуму',
	'FORUM_PATH_EXPLAIN'		=> 'Це <strong>відносний</strong> шлях до вашого старого форуму від <strong>кореневої папки phpBB3</strong>.',
	'FOUND'						=> 'Знайдено',
	'FTP_CONFIG'				=> 'Перемістити конфігурацію по FTP',
	'FTP_CONFIG_EXPLAIN'		=> 'phpBB виявило наявність модулю FTP на цьому сервері. За допомогою нього ви можете спробувати завантажити файл config.php. Вам буде необхідно вказати інформацію в нижчеподані поля. Пам\'ятате, що ваше ім\'я користувача та пароль відносяться до вашого сервера! (якщо ви їх не знаєте, запитайте це у вашого провайдера).',
	'FTP_PATH'					=> 'Шлях FTP',
	'FTP_PATH_EXPLAIN'			=> 'Це шлях від вашої кореневої директорії до phpBB, наприклад, <samp>htdocs/phpBB3/</samp>.',
	'FTP_UPLOAD'				=> 'Завантажити',

	'GPL'						=> 'General Public License',

	'INITIAL_CONFIG'			=> 'Базова конфігурація',
	'INITIAL_CONFIG_EXPLAIN'	=> 'Програма встановлення визначила, що на вашому сервері може працювати phpBB, тепер вам необхідно вказати деякі дані. Якщо ви не знаєте, як з\'єднатись з вашою базою даних, зв\'яжіться з вашим хостинг-провайдером або скористайтесь форум підтримки phpBB. Будьте уважні при вводі даних, перед їх відправкою переконайтесь, що ви все ввели правильно.',
	'INSTALL_CONGRATS'			=> 'Вітаємо!',
	'INSTALL_CONGRATS_EXPLAIN'	=> '
		Ви успішно встановили phpBB %1$s. Тепер ви маєте два варіанти, як поступити з встановленим phpBB3:</p>
		<h2>Конвертувати існуючий форум в phpBB3</h2>
		<p>phpBB Unified Convertor Framework підтримує конвертування phpBB 2.0.x та інших форумних систем в phpBB3. Якщо у вас є існуючий форум, який ви бажаєте конвертувати, передіть, будь-ласка, в <a href="%2$s">систему конвертування</a>.</p>
		<h2>Розпочати використання phpBB3!</h2>
  		<p>Натиснувши кнопку внизу, ви перейдете до форми надсилання статистичної інформації до phpBB в Панелі адміністратора. Ми будемо дуже вдячні вам за вашу допомогу. Виділіть деякий час для вивчення доступних вам можливостей. Не забувайте, що допомога доступна в режимі онлайн через розділи <a href="https://www.phpbb.com/support/documentation/3.0/">Документація</a> та на <a href="https://www.phpbb.com/community/viewforum.php?f=46">форумі підтримки</a>, перегляньте файл <a href="%3$s">README</a> для додаткової інформації.</p><p><strong>Будь-ласка, видаліть, перемістіть або перейменуйте директорію install перед використанням форумом. Допоки ця директорія буде присутньою, лише Панель адміністратора буде доступною.</strong>',
  	'INSTALL_INTRO'				=> 'Вас вітає програма встановлення phpBB.',
 	
	'INSTALL_INTRO_BODY'		=> 'За допомогою цієї опції ви можете встановити phpBB3 на ваш сервер.</p><p>Для цього вам необхідно ввести налаштування для вашої бази даних. Якщо ви не знаєте як це зробити, зв\'яжіться з вашим хостером та запитайте про це у нього. Ви не зможете продовжити без цих налаштувань. Вам необхідно мати такі дані:</p>
  
  	<ul>
		<li>Тип бази даних - база даних, яку ви будете використовувати.</li>
		<li>Ім\'я хосту сервера бази даних - адреса сервера бази даних.</li>
		<li>Порт сервера бази даних - порт сервера бази даних (у більшості випадків не потрібно вказувати).</li>
		<li>Ім\'я бази даних - ім\'я бази даних на сервері.</li>
		<li>Ім\'я користувача та пароль бази даних - дані, необхідні для доступу до бази даних.</li>
	</ul>

	<p><strong>Примітка:</strong> якщо ви використовуєте SQLite при встановленні, вам необхідно вказати повний шлях до вашої бази даних в полі для DSN та залишити поля для імені користувача та паролю порожніми. Для безпеки, переконайтесь, що файл бази даних не зберігається в папці, доступній через інтернет.</p>

	<p>phpBB3 підтримує наступні бази даних:</p>
	<ul>
		<li>MySQL 3.23 або вище (MySQLi підтримується)</li>
		<li>PostgreSQL 7.3+</li>
		<li>SQLite 2.8.2+</li>
		<li>Firebird 2.1+</li>
		<li>MS SQL Server 2000 або вище (безпосередньо або через ODBC)</li>
		<li>MS SQL Server 2005 або вище (native)</li>
		<li>Oracle</li>
	</ul>
	
  <p>Буде відображено лише ті бази даних, які підтримуються вашим сервером.',
	'INSTALL_INTRO_NEXT'		=> 'Щоб розпочати встановлення, натисніть кнопку внизу.',
	'INSTALL_LOGIN'				=> 'Увійти',
	'INSTALL_NEXT'				=> 'Наступний крок',
	'INSTALL_NEXT_FAIL'			=> 'Деякі тести не вдалось пройти, вам необхідно виправити ці проблеми до того, як ви перейдете до наступного етапу встановлення. В протилежному випадку встановлення не буде завершено.',
	'INSTALL_NEXT_PASS'			=> 'Усі основні тести пройдено, ви можете перейти до наступного етапу встановлення. Якщо ви змінили якісь права, модулі і т.д., ви можете при бажанні пройти тестування повторно.',
	'INSTALL_PANEL'				=> 'Встановлення',
	'INSTALL_SEND_CONFIG'		=> 'На жаль, phpBB не вдалось записати інформацію про конфігурацію безпосередньо в ваш config.php. Скоріш за все, причиною цього є те, що файл не існує або він недоступний для запису. Нижче подано список варіантів, які дозволяють завершити встановлення config.php.',
	'INSTALL_START'				=> 'Розпочати встановлення',
	'INSTALL_TEST'				=> 'Перевірити знову',
	'INST_ERR'					=> 'Помилка встановлення',
	'INST_ERR_DB_CONNECT'		=> 'Не вдалось з\'єднатись з базою даних. Нижче вказано повідомлення про помилку.',
	'INST_ERR_DB_FORUM_PATH'	=> 'Файл бази даних знаходиться в папці форуму. Вам необхідно його перенести в папку, недоступну через інтернет.',
  'INST_ERR_DB_INVALID_PREFIX'=> 'Введений вами префікс невірний. Він повинен починатись з букви та містити лише букви, цифри та знаки підкреслення.',
	'INST_ERR_DB_NO_ERROR'		=> 'Повідомлення про помилку відсутнє.',
	'INST_ERR_DB_NO_MYSQLI'		=> 'Встановлена версія MySQL несумісна з обраною вами опцією“MySQL з розширенням MySQLi”. Спробуйте замість неї обрати “MySQL”.',
	'INST_ERR_DB_NO_SQLITE'		=> 'На сервері встановлено застарілу версію SQLite, її необхідно оновити хоча б до версіїi 2.8.2.',
	'INST_ERR_DB_NO_ORACLE'		=> 'Для встановленої на сервері версії Oracle необхідно змінити параметр <var>NLS_CHARACTERSET</var> на <var>UTF8</var> або оновити її до версії 9.2+.',
	'INST_ERR_DB_NO_FIREBIRD'	=> 'Встановлена на сервері версія Firebird старіша за версію 2.1, встановіть, будь-ласка, новішу версію.',
	'INST_ERR_DB_NO_FIREBIRD_PS'=> 'Обрана вами база даних Firebird має розмір сторінки менше 8192, повинно бути хоча б 8192.',
	'INST_ERR_DB_NO_POSTGRES'	=> 'Обрана вами база даних створена не в кодуванні <var>UNICODE</var> або <var>UTF8</var>. Спробуйте встановити форум з базою даних в кодуванні <var>UNICODE</var> або <var>UTF8</var>.',
	'INST_ERR_DB_NO_NAME'		=> 'Не вказане ім\'я бази даних.',
	'INST_ERR_EMAIL_INVALID'	=> 'Ви ввели некоректну адресу e-mail.',
	'INST_ERR_EMAIL_MISMATCH'	=> 'Введені вами адреси e-mail не співпадають.',
	'INST_ERR_FATAL'			=> 'Критична помилка встановлення',
	'INST_ERR_FATAL_DB'			=> 'Виникла критична помилка з базою даних, встановлення перервано. Можливо це сталось через те, що вказаний користувач немає прав на виконання операцій <code>CREATE TABLES</code>, <code>INSERT</code> і т.п. Більш детальну інформацію ви можете переглянути нижче. Please contact your hosting provider in the first instance or the support forums of phpBB for further assistance.',
	'INST_ERR_FTP_PATH'			=> 'Не вдалось перейти до вказаної папки, Будь-ласка, перевірте шлях.',
	'INST_ERR_FTP_LOGIN'		=> 'Не вдалось залогуватись на FTP-сервері, перевірте ім\'я користувача та пароль.',
	'INST_ERR_MISSING_DATA'		=> 'Ви повинні заповнити усі поля і цьому блоці.',
	'INST_ERR_NO_DB'			=> 'Не вдається завантажити модуль PHP для обраного типу бази даних.',
	'INST_ERR_PASSWORD_MISMATCH'	=> 'Введені вами паролі не співпадають.',
	'INST_ERR_PASSWORD_TOO_LONG'	=> 'Введений вами пароль надто довгий. Максимальна довжина - 30 символів.',
	'INST_ERR_PASSWORD_TOO_SHORT'	=> 'Введений вами пароль надто короткий. Мінімальна довжина - 6 символів.',
	'INST_ERR_PREFIX'			=> 'Таблиці з таким префіксом вже існують, будь-ласка, оберіть інший префікс.',
	'INST_ERR_PREFIX_INVALID'	=> 'Вказаний вами префікс невірний для вашої бази даних. Будь-ласка, спробуйте вказати інший, виключивши символи такі як дефіс.',
	'INST_ERR_PREFIX_TOO_LONG'	=> 'Вказаний вами префікс надто довгий. Максимальна довжина - %d символів.',
	'INST_ERR_USER_TOO_LONG'	=> 'Введене вами ім\'я користувача надто довге. Максимальна довжина - 20 символів.',
	'INST_ERR_USER_TOO_SHORT'	=> 'Введене вами ім\'я користувача надто коротке. Мінімальна довжина - 3 символи.',
	'INVALID_PRIMARY_KEY'		=> 'Недопустимий первинний ключ : %s',

	'LONG_SCRIPT_EXECUTION'		=> 'Майте на увазі, що це може зайняти деякий час... Будь-ласка, не зупиняйте роботу скрипта.',

	// mbstring
	'MBSTRING_CHECK'						=> 'Перевірка розширення <samp>mbstring</samp>',
	'MBSTRING_CHECK_EXPLAIN'				=> '<strong>Необхідно</strong> - <samp>mbstring</samp> - це розширення PHP, яке забезпечує роботу багатобайтових стрічкових функцій. Певні можливості mbstring несумісні з phpBB і їх потрібно вимкнути.',
	'MBSTRING_FUNC_OVERLOAD'				=> 'Перезавантаження функції',
	'MBSTRING_FUNC_OVERLOAD_EXPLAIN'		=> 'Значення <var>mbstring.func_overload</var> повинно бути 0 або 4.',
	'MBSTRING_ENCODING_TRANSLATION'			=> 'Transparent character encoding',
	'MBSTRING_ENCODING_TRANSLATION_EXPLAIN'	=> 'Значення <var>mbstring.encoding_translation</var> повинно бути 0.',
	'MBSTRING_HTTP_INPUT'					=> 'Конвертування вхідних символів HTTP',
	'MBSTRING_HTTP_INPUT_EXPLAIN'			=> 'Значення <var>mbstring.http_input</var> повинно бути <samp>pass</samp>.',
	'MBSTRING_HTTP_OUTPUT'					=> 'Конвертування вихідних символів HTTP',
	'MBSTRING_HTTP_OUTPUT_EXPLAIN'			=> 'Значення <var>mbstring.http_output</var> повинно бути <samp>pass</samp>.',

	'MAKE_FOLDER_WRITABLE'		=> 'Переконайтесь, будь-ласка, що ця папка існує та доступна для запису вебсервером, після цього повторіть вашу спробу:<br />»<strong>%s</strong>.',
	'MAKE_FOLDERS_WRITABLE'		=> 'Переконайтесь, будь-ласка, що ці папки існують та доступні для запису вебсервером, після цього повторіть вашу спробу:<br />»<strong>%s</strong>.',
	'MYSQL_SCHEMA_UPDATE_REQUIRED'   => 'Схема вашої бази даних MySQL застаріла. Скрипт phpBB визначив, що використовується схема для MySQL 3.x/4.x, але сервер працює на MySQL %2$s.<br /><strong>Перед тим, як розпочати оновлення, вам необхідно оновити схему.</strong><br /><br />Будь-ласка, перегляньте <a href="https://www.phpbb.com/kb/article/doesnt-have-a-default-value-errors/">статтю Бази Знань про оновлення схеми MySQL</a>. При виникненні проблем скористайтесь <a href="https://www.phpbb.com/community/viewforum.php?f=46">нашими форумами підтримки</a>.',

	'NAMING_CONFLICT'			=> 'Конфлікт імен: %s та %s є псевдонімами<br /><br />%s',
	'NEXT_STEP'					=> 'Перейти до наступного кроку',
	'NOT_FOUND'					=> 'Не вдалось знайти',
	'NOT_UNDERSTAND'			=> 'Не вдається розпізнати %s #%d, таблиця %s (“%s”)',
	'NO_CONVERTORS'				=> 'Немає доступних конвертерів.',
	'NO_CONVERT_SPECIFIED'		=> 'Не задано конвертор.',
	'NO_LOCATION'				=> 'Не вдалось знайти додаток. Якщо ви знаєте, що Imagemagick встановлено, ви можете задати шлях до нього пізніше в Панелі адміністратора',
	'NO_TABLES_FOUND'			=> 'Таблиць не знайдено.',
// TODO: Write some explanatory introduction text

	'OVERVIEW_BODY'				=> 'Ласкаво просимо до phpBB3!<br /><br />phpBB™ - найбільш поширене рішення для створення форумів з відкритим кодом у світі. phpBB3 - останній внесок в лінійку продуктів останніх семи років. Які і його попередники, phpBB3 має широкі можливості, зручне в користуванні, та повністю підтримується Командою phpBB. В phpBB3 значно вдосконалено ті можливості, які зробили популярним phpBB2 та долучено нові можливості, яких не було в попередніх версіях та про які найбільше запитувалось. Ми сподіваємось, що phpBB3 перевершить усі ваші сподівання.<br /><br />Ця система встановлення допоможе вам встановити phpBB3, оновити ваш форум до останньої версії phpBB3 з попередніх версій, а також конвертувати ваш форум в phpBB3 з інших форумних систем, включаючи phpBB2. Для отримання додаткової інформації ми радимо вам прочитати <a href="../docs/INSTALL.html">посібник з встановлення</a>.<br /><br />Для перегляду ліцензійної угоди phpBB3 та для того, щоб дізнатись як отримати підтримку та дізнатись про нашу позицію з цих питань, будь-ласка, оберіть відповідні пункти бокового меню. Для продовження, натисніть відповідну кнопку внизу.',
   'PCRE_UTF_SUPPORT'				=> 'Підтримка PCRE UTF-8',
  'PCRE_UTF_SUPPORT_EXPLAIN'		=> 'phpBB <strong>не</strong> буде працювати, якщо встановлена версія PHP не скомпільована з підтримкою UTF-8 для розширення PCRE.',
	'PHP_GETIMAGESIZE_SUPPORT'			=> 'Функція PHP getimagesize() доступна',
	'PHP_GETIMAGESIZE_SUPPORT_EXPLAIN'	=> '<strong>Необхідно</strong> - для нормального функціонування phpBB, функція getimagesize повинна бути доступною.',
	'PHP_OPTIONAL_MODULE'			=> 'Додаткові модулі',
	'PHP_OPTIONAL_MODULE_EXPLAIN'	=> '<strong>Необов\'язково</strong> - Ці модулі або додатки не є обов\'язковими. Проте, якщо вони доступні, буде увімкнено деякі додаткові можливості.',
	'PHP_SUPPORTED_DB'				=> 'Бази даних, які підтримуються',
	'PHP_SUPPORTED_DB_EXPLAIN'		=> '<strong>Необхідно</strong> - Повинна підтримуватись хоча б одна сумісна з PHP база даних. Якщо з перелічених модулів баз даних немає доступних для вас, вам необхідно зв\'язатись з вашим хостинг-провайдером або переглянути відповідний розділ документації PHP.',
	'PHP_REGISTER_GLOBALS'			=> 'Налаштування PHP <var>register_globals</var> вимкнено',
	'PHP_REGISTER_GLOBALS_EXPLAIN'	=> 'phpBB буде працювати і з увімкненою цією функцією. Але, рекомендується, вимкнути функцію PHP register_globals з причин безпеки, звісно, якщо це є можливим.',
	'PHP_SAFE_MODE'					=> 'Безпечний режим',
	'PHP_SETTINGS'					=> 'Версія PHP та налаштування',
	'PHP_SETTINGS_EXPLAIN'			=> '<strong>Необхідно</strong> - Для встановлення phpBB у вас повинно бути встановлено PHP як мінімум версії 4.3.3. Якщо у вас відображається напис <var>безпечний режим</var> внизу, то це означає, що PHP працює у цьому режимі. Це накладає обмеження на віддалене адміністрування та тому подібні функції.',
	'PHP_URL_FOPEN_SUPPORT'			=> 'Налаштування PHP <var>allow_url_fopen</var> увімкнено',
	'PHP_URL_FOPEN_SUPPORT_EXPLAIN'	=> '<strong>Необов\'язково</strong> - це налаштування не є обов\'язковим, деякі функції, такі, як зовнішні аватари, не будуть працювати коректно. ',
	'PHP_VERSION_REQD'				=> 'Версія PHP >= 4.3.3',
	'POST_ID'						=> 'Ідентифікатор повідомлення',
	'PREFIX_FOUND'					=> 'Сканування таблиць показало наявність встановленого форуму з префіксом таблиць <strong>%s</strong>.',
	'PREPROCESS_STEP'				=> 'Виконання попередніх функцій/запитів',
	'PRE_CONVERT_COMPLETE'			=> 'Усі передконвертаційні етапи було успішно завершено. Тепер ви можете розпочати процес конвертування. Заувжте, що можливо вам прийдеться вручну провести деякі дії та налаштування. Після завершення конвертування, обов\'язково перевірте встановлені права доступу, створіть пошуковий індекс, який не підлягає конвертації, а також переконайтесь, що коректно скопійовано усі файли, наприклад, аватари та смайлики.',
	'PROCESS_LAST'					=> 'Виконання останніх запитів',

	'REFRESH_PAGE'				=> 'Оновити сторінку для продовження конвертування',
	'REFRESH_PAGE_EXPLAIN'		=> 'Якщо встановлено "так", конвертер автоматично оновить сторінку для продовження конвертування, після завершення чергового етапу. Якщо це ваша перша конвертація з метою тестування та виявлення можливих помилок, ми радимо встановити значення "Ні".',
//	'REQUIRED'					=> 'Необхідно',
	'REQUIREMENTS_TITLE'		=> 'Сумісність програмного забезпечення',
	'REQUIREMENTS_EXPLAIN'		=> 'Перед початком встановлення phpBB буде проведено тестування конфігурації вашого сервера та файлів для того, щоб переконатись, що встановлення та робота phpBB можливі. Ознайомтесь з результатами і не переходьте до наступного етапу допоки усі необхідні тестування не буде пройдено. Якщо ви хочете використовувати деякі додаткові можливості, переконайтесь, що додаткове тестування, яке відноситься до цих функцій, також пройдено.',
	'RETRY_WRITE'				=> 'Повторити спробу запису конфігурації',
	'RETRY_WRITE_EXPLAIN'		=> 'При бажанні ви можете змінити права доступу до файлу config.php, щоб дозволити запис phpBB в нього. У такому разі натисніть нижче "Повторити" після встановлення прав доступу. Не забудьте повернути попередні права доступу до файлу config.php після завершення встановлення phpBB.',

	'SCRIPT_PATH'				=> 'Шлях до форуму',
	'SCRIPT_PATH_EXPLAIN'		=> 'Шлях до phpBB відносно домену, наприклад, <samp>/phpBB3</samp>.',
	'SELECT_LANG'				=> 'Оберіть мову',
	'SERVER_CONFIG'				=> 'Конфігурація сервера',
	'SEARCH_INDEX_UNCONVERTED'	=> 'Пошуковий індекс не було конвертовано',
	'SEARCH_INDEX_UNCONVERTED_EXPLAIN'	=> 'Ваш старий пошуковий індекс не було конвертовано. Будь-які пошукові запити будуть видавати порожній результат. Для того, щоб створити пошуковий індекс, перейдіть в Панель адміністратора, оберіть пункт Обслуговування, а потім в підменю пункт Пошуковий індекс.',
	'SOFTWARE'					=> 'ПЗ форуму',
	'SPECIFY_OPTIONS'			=> 'Задати налаштування конвертування',
	'STAGE_ADMINISTRATOR'		=> 'Дані про адміністратора',
	'STAGE_ADVANCED'			=> 'Розширені налаштування',
	'STAGE_ADVANCED_EXPLAIN'	=> 'Налаштування на цій сторінці необхідно змінювати, якщо ви впевнені, що вам не підходять налаштування за замовчуванням. Якщо ви не впевнені, просто перейдіть на наступну сторінку, усі ці налаштування можна буде змінити пізніше в Панелі адміністратора.',
	'STAGE_CONFIG_FILE'			=> 'Файл конфігурації',
	'STAGE_CREATE_TABLE'		=> 'Створення таблиць бази даних',
	'STAGE_CREATE_TABLE_EXPLAIN'	=> 'Таблиці бази даних для phpBB 3.0 було створено та заповнено деякими початковими даними. Перейдіть на наступну сторінку для завершення встановлення phpBB.',
	'STAGE_DATABASE'			=> 'Налаштування бази даних',
	'STAGE_FINAL'				=> 'Завершальний етап',
	'STAGE_INTRO'				=> 'Вступ',
	'STAGE_IN_PROGRESS'			=> 'Конвертування в процесі',
	'STAGE_REQUIREMENTS'		=> 'Вимоги',
	'STAGE_SETTINGS'			=> 'Налаштування',
	'STARTING_CONVERT'			=> 'Розпочати процес конвертування',
	'STEP_PERCENT_COMPLETED'	=> 'Крок <strong>%d</strong> з <strong>%d</strong>',
	'SUB_INTRO'					=> 'Вступ',
	'SUB_LICENSE'				=> 'Ліцензія',
	'SUB_SUPPORT'				=> 'Підтримка',
	'SUCCESSFUL_CONNECT'		=> 'Успішне з\'єднання',
  'SUPPORT_BODY'				=> 'Повна підтримка надається безкоштовно для поточної стабільної версії phpBB3. Вона включає:</p><ul><li>встановлення</li><li>конфігурацію</li><li>технічні питання</li><li>проблеми, пов\'язані з можливими помилками в програмному забезпеченні</li><li>оновлення з кандидат-версій (RC) на останні стабільні версії</li><li>конвертування phpBB 2.0.x в phpBB3</li><li>конвертування з іншого форумного програмного забезпечення в phpBB3 (перегляньте, будь-ласка, <a href="https://www.phpbb.com/community/viewforum.php?f=65">Форум конвертування</a>)</li></ul><p>Ми радимо користувачам, які все ще користуються бета-версіями phpBB3 оновити свої форуми до останньої версії.</p><h2>MOD-и / Стилі</h2><p>Відносно проблем, пов\'язаних з MOD-ами, будь-ласка, пишіть у відповідному форумі <a href="https://www.phpbb.com/community/viewforum.php?f=81">Форум модифікацій</a>.<br />Щодо проблем, пов\'язаних зі стилями, шаблонами та наьорами символів, будь-ласка, пишіть у відповідному форумі <a href="https://www.phpbb.com/community/viewforum.php?f=80">Форум стилів</a>.<br /><br />Якщо ваше запитання стосується особливого пакету, будь-ласка, пишіть безпосередньо у тему, яка присвячена цьому.</p><h2>Отримання підтримки</h2><p><a href="https://www.phpbb.com/community/viewtopic.php?f=14&amp;t=571070">The phpBB Welcome Package</a><br /><a href="https://www.phpbb.com/support/">Розділ підтримки</a><br /><a href="https://www.phpbb.com/support/documentation/3.0/quickstart/">Посібник з швидкого старту</a><br /><br />Для того, щоб бути впевненим, що у вас актуальна версія програмного забезпечення, та для того, щоб бути в курсі останніх новин, чому вам б не <a href="https://www.phpbb.com/support/">підписатись на наше розсилання новин</a>?<br /><br />',
	'SYNC_FORUMS'				=> 'Сихронізація форумів',
	'SYNC_POST_COUNT'			=> 'Синхронізація кількості повідомлень',
	'SYNC_POST_COUNT_ID'		=> 'Синхронізація повідомлень з <var>entry</var> %1$s до %2$s.',
	'SYNC_TOPICS'				=> 'Синхронізація тем',
	'SYNC_TOPIC_ID'				=> 'Синхронізація тем з <var>topic_id</var> %1$s to %2$s.',

	'TABLES_MISSING'			=> 'Не вдалось знайти такі таблиці<br />» <strong>%s</strong>.',
	'TABLE_PREFIX'				=> 'Префікс для таблиць бази даних',
  'TABLE_PREFIX_EXPLAIN'		=> 'Префікс повинен починатись з букви та містити лише букви, цифри та знаки підкреслення.',

	'TABLE_PREFIX_SAME'			=> 'Префікс таблиць повинен бути таким, як той, що використовувався програмним забезпеченням, з якого ви переходите на phpBB.<br />» Ви вказали префікс %s.',
	'TESTS_PASSED'				=> 'Тестування завершилось успішно',
	'TESTS_FAILED'				=> 'Тестування завершилось невдало',

	'UNABLE_WRITE_LOCK'			=> 'Не вдається записати файл блокування.',
	'UNAVAILABLE'				=> 'Недоступно',
	'UNWRITABLE'				=> 'Недоступно для запису',
	'UPDATE_TOPICS_POSTED'		=> 'Створення даних тем',
	'UPDATE_TOPICS_POSTED_ERR'	=> 'Виникла помилка при створенні даних тем. Ви можете повторити спробу в Панелі адміністратора після того, як процес конвертування завершиться.',
	'VERIFY_OPTIONS'			=> 'Перевірка налаштувань конвертації',
	'VERSION'					=> 'Версія',

	'WELCOME_INSTALL'			=> 'Ласкаво просимо до встановлення phpBB3',
	'WRITABLE'					=> 'Доступно для запису',
));

// Updater
$lang = array_merge($lang, array(
	'ALL_FILES_UP_TO_DATE'		=> 'Усі файли відповідають самій останній версії phpBB. Тепер <a href="../ucp.php?mode=login">увійдіть на форум</a> і переконайтеся, що все працює нормально. Не забудьте видалити, перейменувати або перемістити вашу директорію install! Будь-ласка, надішліть нам оновлену інформацію про ваш сервер і конфігурації форуму за допомогою сторінки <a href="../ucp.php?mode=login&redirect=adm/index.php%3Fi=send_statistics%26mode=send_statistics">відправки статистичної інформації</a> в панелі адміністрування.',
	'ARCHIVE_FILE'				=> 'Файл-джерело в архіві',

	'BACK'				=> 'Назад',
	'BINARY_FILE'		=> 'Бінарний файл',
	'BOT'				=> 'Павук/Робот',

	'CHANGE_CLEAN_NAMES'			=> 'Метод, який використовується для того, щоб одне ім\'я не використовувалось декількома користувачами, було змінено. Після перевірки новим методом знайдено декількох користувачів, які мають однакові імена. Ви повинні видалити або перейменувати цих користувачів, щоб кожне ім\'я використовувалось лише одним користувачем, перед тим як продовжувати.',
	'CHECK_FILES'					=> 'Перевірити файли',
	'CHECK_FILES_AGAIN'				=> 'Ще раз перевірити файли',
	'CHECK_FILES_EXPLAIN'			=> 'На наступному етапі буде порівняно усі файли з файлами оновлення. Якщо це перша перевірка файлів, це може тривати деякий час, ',
	'CHECK_FILES_UP_TO_DATE'		=> 'Згідно вашої бази даних ваш форум останньої версії. Можливо ви хочете виконати перевірку файлів, для того, щоб переконатись, що усі файли насправді відповідають останній версії phpBB.',
	'CHECK_UPDATE_DATABASE'			=> 'Продовжити процес оновлення',
	'COLLECTED_INFORMATION'			=> 'Інформація про файл',
	'COLLECTED_INFORMATION_EXPLAIN'	=> 'У нижчеподаному списку відображено інформацію про файли, які потребують оновлення. Будь-ласка, прочитайте інформацію в верхній частині кожного статус-блоку, щоб зрозуміти їхній зміст і що необхідно зробити для успішного оновлення.',
	'COLLECTING_FILE_DIFFS'			=> 'Перевірка відміностей у файлах',
	'COMPLETE_LOGIN_TO_BOARD'		=> '<a href="../ucp.php?mode=login">Залогуйтесь на вашому форумі</a> та перевірте, чи все нормально працює. Не забудьте видалити, перейменувати чи перемістити директорію install!',
	'CONTINUE_UPDATE_NOW'			=> 'Продовжити процес оновлення',	// Shown within the database update script at the end if called from the updater
	'CONTINUE_UPDATE'				=> 'Продовжити оновлення',					// Shown after file upload to indicate the update process is not yet finished

 	'CURRENT_FILE'					=> 'Початок конфлікту - код початкового файлу до оновлення',
	'CURRENT_VERSION'				=> 'Поточна версія',

	'DATABASE_TYPE'						=> 'Тип бази даних',
	'DATABASE_UPDATE_INFO_OLD'			=> 'Файл оновлення бази даних в директорії install застарілий. Переконайтесь, будь-ласка, що ви завантажили правильну версію файлу.',
	'DELETE_USER_REMOVE'				=> 'Видалити користувача та його повідомлення',
	'DELETE_USER_RETAIN'				=> 'Видалити користувача та залишити його повідомлення',
	'DESTINATION'						=> 'Файл призначення',
	'DIFF_INLINE'						=> 'Всередині тексту',
	'DIFF_RAW'							=> 'Raw unified diff',
	'DIFF_SEP_EXPLAIN'					=> 'Код, який використовується в оновленому/новому файлі',
	'DIFF_SIDE_BY_SIDE'					=> 'Паралельно',
	'DIFF_UNIFIED'						=> 'Unified diff',
	'DO_NOT_UPDATE'						=> 'Не оновлювати цей файл',
	'DONE'								=> 'Виконано',
	'DOWNLOAD'							=> 'Завантажити',
	'DOWNLOAD_AS'						=> 'Завантажити як',
	'DOWNLOAD_UPDATE_METHOD_BUTTON'      => 'Завантажити архів зі зміненими файлами (рекомендується)',
	'DOWNLOAD_CONFLICTS'				=> 'Завантажити конфліктні місця для цього файлу',
	'DOWNLOAD_CONFLICTS_EXPLAIN'		=> 'Шукати &lt;&lt;&lt; для виявлення конфліктів',
	'DOWNLOAD_UPDATE_METHOD'			=> 'Завантажити архів з зміненими файлами',
	'DOWNLOAD_UPDATE_METHOD_EXPLAIN'	=> 'Після завантаження архіву розпакуйте його. Після цього ви знайдете змінені файли, які вам необхідно завантажити в вашу кореневу директорію з phpBB. Завантажуйте файли в відповідні для них папки. Після того, як завантажите усі файли, будь-ласка, перевірте повторно їх за допомогою кнопки внизу.',

	'ERROR'			=> 'Error',
	'EDIT_USERNAME'	=> 'Edit username',

	'FILE_ALREADY_UP_TO_DATE'		=> 'Файл останньої версії.',
	'FILE_DIFF_NOT_ALLOWED'			=> 'Не дозволено виконання команди diff для цього файлу.',
	'FILE_USED'						=> 'Інформацію взято з',			// Single file
	'FILES_CONFLICT'				=> 'Конфліктні файли',
	'FILES_CONFLICT_EXPLAIN'		=> 'Наступні файли змінено і вони не відповідають оригінальним файлам старої версії. phpBB визначило, що ці файли створять конфлікти, якщо їх об\'єднати. Будь-ласка, вивчіть природу конфліктів і спробуйте вручні вирішити їх або продовжуйте оновлення, обравши відповідні методи об\'єднання. При ручному вирішенні конфліктів, перевірте повторно файли після того, як ви зміните їх. Ви можете обирати метод об\'єднання окремо для кожного файлу. Результатом роботи першого методу буде файл, у якому конфіктні стрічки старого файлу буде усунуто, в другому методі буде усунуто конфліктні стрічки з нового файлу.',
	'FILES_MODIFIED'				=> 'Змінені файли',
	'FILES_MODIFIED_EXPLAIN'		=> 'Наступні файли змінено і вони не відповідають оригінальним файлам старої версії. Оновлений файл буде результатом об\'єднання ваших змін та нового файлу.',
	'FILES_NEW'						=> 'Нові файли',
	'FILES_NEW_EXPLAIN'				=> 'Наступні фали відсутні на вашому форумі, їх буде додано.',
	'FILES_NEW_CONFLICT'			=> 'Нові конфліктні файли',
	'FILES_NEW_CONFLICT_EXPLAIN'	=> 'Наступні фали з\'явились в останній версії, але виявлено, що вже існує файл з такою назвою в такій самій директорії. Цей файл буде замінено на новий.',
	'FILES_NOT_MODIFIED'			=> 'Незмінені файли',
	'FILES_NOT_MODIFIED_EXPLAIN'	=> 'Наступні фали не змінено, вони являють собою оригінальні файли тієї версії phpBB, яку ви хочете оновити.',
	'FILES_UP_TO_DATE'				=> 'Вже оновлені файли',
	'FILES_UP_TO_DATE_EXPLAIN'		=> 'Наступні фали останньої версії і немає потреби оновлювати їх.',
	'FTP_SETTINGS'					=> 'Налаштування FTP',
	'FTP_UPDATE_METHOD'				=> 'Завантаження по FTP',

	'INCOMPATIBLE_UPDATE_FILES'		=> 'Знайдені файли оновлення не сумісні з встановленою у вас версією. У вас встановлено версію %1$s, а файли оновлення призначені для оновлення версії phpBB %2$s до версії %3$s.',
	'INCOMPLETE_UPDATE_FILES'		=> 'Набір файлів оновлення неповний.',
	'INLINE_UPDATE_SUCCESSFUL'		=> 'Оновлення бази даних пройшло успішно. Тепер вам потрібно продовжити процес оновлення.',

	'KEEP_OLD_NAME'		=> 'Keep username',

	'LATEST_VERSION'		=> 'Остання версія',
	'LINE'					=> 'Стрічка',
	'LINE_ADDED'			=> 'Додано',
	'LINE_MODIFIED'			=> 'Змінено',
	'LINE_REMOVED'			=> 'Видалено',
	'LINE_UNMODIFIED'		=> 'Не змінено',
	'LOGIN_UPDATE_EXPLAIN'	=> 'Для здійснення оновлення вам необхідно спочатку залогуватись.',

	'MAPPING_FILE_STRUCTURE'	=> 'Для полегшення завантаження файлів тут вказано розміщення файлів which map your phpBB installation.',

	'MERGE_MODIFICATIONS_OPTION'	=> 'Об\'єднати зміни',

	'MERGE_NO_MERGE_NEW_OPTION'	=> 'Не об\'єднувати - використовувати новий файл',
	'MERGE_NO_MERGE_MOD_OPTION'	=> 'Не об\'єднувати - використовувати існуючий файл',
 	'MERGE_MOD_FILE_OPTION' => 'Об\'єднати зміни (видалити новий код у конфліктному місці)',
 	'MERGE_NEW_FILE_OPTION' => 'Об\'єднати зміни (видалити змінений код у конфліктному місці)',
	'MERGE_SELECT_ERROR'		=> 'Невірно обрано способи об\'єднання конфліктного файлу.',
	'MERGING_FILES'				=> 'Об\'єднання відмінностей',
	'MERGING_FILES_EXPLAIN'		=> 'Наразі відбувається завершальна зміна файлів.<br /><br />Зачекайтесь, будь-ласка, коли phpBB завершить усі операції зі зміненими файлами.',

	'NEW_FILE'					=> 'Кінець конфлікту',
	'NEW_USERNAME'					=> 'Нове ім\'я користувача',
	'NO_AUTH_UPDATE'				=> 'У вас недостатньо прав для здійснення оновлення',
	'NO_ERRORS'						=> 'Без помилок',
	'NO_UPDATE_FILES'				=> 'Наступні файли не буде оновлено',
	'NO_UPDATE_FILES_EXPLAIN'		=> 'Наступні фали є новими або зміненими, але директорію, в якій вони повинні знаходитись, не знайдено. Якщо цей список містить файли, які відносяться до інших директорій, окрім language/ або styles/, це може означати, що ви змінили структуру директорій і оновлення може бути неповним.',
	'NO_UPDATE_FILES_OUTDATED'		=> 'Не знайдено директорію з файлами оновлення, переконайтесь, будь-ласка, що ви завантажили усі відповідні файли.<br /><br />Ваша версія phpBB <strong>не</strong> є останньою, для неї є доступне оновлення %1$s. Відвідайте, будь-ласка, <a href="https://www.phpbb.com/downloads/" rel="external">https://www.phpbb.com/downloads/</a> для отримання пакету оновлення з версії %2$s до %3$s.',
	'NO_UPDATE_FILES_UP_TO_DATE'	=> 'Ваш форум останньої версії. Немає потреби запуску програми оновлення. Якщо ви хочете виконати перевірку цілісності файлів, переконайтесь, що ви завантажили правильні файли оновлення.',
	'NO_UPDATE_INFO'				=> 'Дані про оновлення файлу не знайдено.',
	'NO_UPDATES_REQUIRED'			=> 'Немає потреби у оновленні',
	'NO_VISIBLE_CHANGES'			=> 'Немає видимих змін',
	'NOTICE'						=> 'Примітка',
	'NUM_CONFLICTS'					=> 'Кількість конфліктів',
	'NUMBER_OF_FILES_COLLECTED'		=> 'Перевірено відмінності %1$d файлів з %2$d.<br />Будь-ласка, дочекайтеся повної перевірки усіх файлів.',
	'OLD_UPDATE_FILES'		=> 'Файли оновлення застаріли. Знайдені файли оновлення призначені для оновлення phpBB з версії %1$s до %2$s, але останньою версією phpBB на даний момент є %3$s.',

	'PACKAGE_UPDATES_TO'				=> 'Даний пакет оновлює до версії',
	'PERFORM_DATABASE_UPDATE'			=> 'Виконати оновлення бази даних',
	'PERFORM_DATABASE_UPDATE_EXPLAIN'	=> 'Нижче ви знайдете кнопку для оновлення бази даних. Процес оновлення бази даних може зайняти деякий час, тому, будь-ласка, не переривайте його,  якщо здається, що він ніби завис. Після завершення оновлення бази даних, слідуйте за інструкціями для продовження процесу оновлення.',
	'PREVIOUS_VERSION'					=> 'Попередня версія',
	'PROGRESS'							=> 'Прогрес',

	'RESULT'					=> 'Результат',
	'RUN_DATABASE_SCRIPT'		=> 'Оновити мою базу даних',

	'SELECT_DIFF_MODE'			=> 'Оберіть режим diff',
	'SELECT_DOWNLOAD_FORMAT'	=> 'Оберіть формат архіву для завантаження',
	'SELECT_FTP_SETTINGS'		=> 'Налаштування FTP',
	'SHOW_DIFF_CONFLICT'		=> 'Відмінності/конфлікти',
	'SHOW_DIFF_FINAL'			=> 'Кінцевий файл',
	'SHOW_DIFF_MODIFIED'		=> 'Show merged differences',
	'SHOW_DIFF_NEW'				=> 'Показати вміст файлу',
	'SHOW_DIFF_NEW_CONFLICT'	=> 'Показати відмінності',
	'SHOW_DIFF_NOT_MODIFIED'	=> 'Показати відмінності',
	'SOME_QUERIES_FAILED'		=> 'Виконання деяких запитів завершилось невдало, тексти запитів та помилок подано нижче.',
	'SQL'						=> 'SQL',
	'SQL_FAILURE_EXPLAIN'		=> 'Скоріш за все немає приводу для хвилювання, процес оновлення буде продовжено. Якщо процес оновлення все ж таки не завершиться, вам можливо буде потрібно звернутись про допомогу на форуми підтримки. Перегляньте <a href="../docs/README.html">README</a>, щоб дізнатись як отримати допомогу.',
	'STAGE_FILE_CHECK'			=> 'Перевірка файлів',
	'STAGE_UPDATE_DB'			=> 'Оновлення бази даних',
	'STAGE_UPDATE_FILES'		=> 'Оновлення файлів',
	'STAGE_VERSION_CHECK'		=> 'Перевірка версії',
	'STATUS_CONFLICT'			=> 'Змінений файл створює конфлікт',
	'STATUS_MODIFIED'			=> 'Змінений файл',
	'STATUS_NEW'				=> 'Новий файл',
	'STATUS_NEW_CONFLICT'		=> 'Новий конфіктний файл',
	'STATUS_NOT_MODIFIED'		=> 'Незмінений файл',
	'STATUS_UP_TO_DATE'			=> 'Вже оновлений файл',

	'TOGGLE_DISPLAY'			=> 'Показати/приховати список файлів',
	'TRY_DOWNLOAD_METHOD'      => 'Ви можете спробувати метод завантаження змінених файлів.<br />Цей метод завжди працює і є рекмоендованим методом оновлення.',
	'TRY_DOWNLOAD_METHOD_BUTTON'=> 'Скористатись цим методом',

	'UPDATE_COMPLETED'				=> 'Оновлення завершено',
	'UPDATE_DATABASE'				=> 'Оновлення бази даних',
	'UPDATE_DATABASE_EXPLAIN'		=> 'На наступному кроці буде оновлено базу даних.',
	'UPDATE_DATABASE_SCHEMA'		=> 'Оновлення структури бази даних',
	'UPDATE_FILES'					=> 'Оновлення файлів',
	'UPDATE_FILES_NOTICE'			=> 'Переконайтесь, що ви також оновили файли вашого форуму, цей файл лише оновлює вашу базу даних.',
	'UPDATE_INSTALLATION'			=> 'Оновлення phpBB',
  'UPDATE_INSTALLATION_EXPLAIN'	=> 'За допомогою цієї функції ви можете оновити ваш форум phpBB до останньої версії.<br />Під час цього процесу усі фаші файли буде перевірено на цілісність. Ви будете мати можливість переглянути файли і усі зміни, які будуть вносити в них перед оновленням.<br /><br />Оновлення може бути виконано двома способами.</p><h2>Оновлення вручну</h2><p>Цей спосіб полягає у тому, що ви завантажуєте індивідуальний набір змінених файлів, щоб не втратити зміни, які ви можливо вносили до ваших файлів. Після того, як ви завантажили цей пакет з сервера, вам потрібно вручну завантажити файли в відповідні місця відносно кореневої директорії phpBB. Після цього, ви будете мати можливість повторно виконати перевірку, щоб переконатись, що ви помістили файли в потрібні місця.</p><h2>Автоматичне оновлення по FTP</h2><p>Цей спосіб схожий на перший, але вам непотрібно завантажувати змінені файли та поміщати їх на свій форум. Це буде зроблено за вас. Для того, щоб скористатись цим способом, вам необхідно знати ваші дані для логування на сервер по FTP. Після завершення оновлення вас буде перенаправлено на сторінку повторної перевірки файлів, щоб переконатись, що оновлення пройшло успішно.<br /><br />',
	'UPDATE_INSTRUCTIONS'			=> '

		<h1>Інформація про реліз</h1>

		<p>Перед початком процесу оновлення, будь-ласка, прочитайте <a href="%1$s" title="%1$s"><strong>оголошення про вихід нової версії</strong></a>, воно може містити корисну інформацію. Крім того, в ній присутні посилання для завантаження нової версії, а також перелік змін.</p>

		<br />

		<h1>Як оновити ваш форум за допомогою Автоматичного пакету оновлення</h1>

		<p>Вказаний тут рекомендований спосіб оновлення вашого форуму стосується лише автоматичного пакету оновлення. Ви також можете оновити ваш форум за допомогою інших способів, описаних в документі INSTALL.html. Для виконання автоматичного оновлення phpBB3 потрібно виконати наступні кроки:</p>

		<ul style="margin-left: 20px; font-size: 1.1em;">
			<li>Перейти на <a href="https://www.phpbb.com/downloads/" title="https://www.phpbb.com/downloads/">сторінку завантажень phpBB.com</a> і завантажити архів "Automatic Update Package".<br /><br /></li>
			<li>Розпакувати архів.<br /><br /></li>
			<li>Повністю завантажити розпаковану папку install в кореневу директорію phpBB (де знаходиться ваш файл config.php).<br /><br /></li>
		</ul>

		<p>Після завантаження ваш форум перейде в режим офлайн для звичайних користувачів, оскільки буде присутня завантажена вами директорія install.<br /><br />
		<strong><a href="%2$s" title="%2$s">Після цього розпочати процес оновлення, направивши ваш браузер в папку install</a>.</strong><br />
		<br />
		Вам будуть надаватись вказівки в ході процесу оновлення. Про його завершення вас буде повідомлено.
		</p>
	',
	'UPDATE_INSTRUCTIONS_INCOMPLETE'	=> '

		<h1>Виявлено незавершене оновлення</h1>

		<p>phpBB виявило незакінчене автоматичне оновлення. Переконайтесь, що ви виконали усі кроки автоматичного оновлення. Перейдіть по нижчевказаному посиланню або перейдіть безпосередньо в вашу директорію install.</p>',
	'UPDATE_METHOD'					=> 'Метод оновлення',
	'UPDATE_METHOD_EXPLAIN'			=> 'Ви можете обрати зручний для вас спосіб оновлення. Якщо ви оберете завантаження по FTP, вам буде необхідно вказати дані про ваш обліковий запис FTP. Цей метод забезпечує автоматичне переміщення файлів в нове місцезнаходження та резервне копіювання старих файлів, додаючи розширення .bak до їхнього імені. Якщо ви оберете завантаження змінених файлів ви зможете розпакувати та завантажити їх вручну в відповідні місця.',
	'UPDATE_REQUIRES_FILE'			=> 'Для оновлення необхідна присутність наступного файлу: %s',
	'UPDATE_SUCCESS'				=> 'Оновлення пройшло успішно',
	'UPDATE_SUCCESS_EXPLAIN'		=> 'Успішно оновлено усі файли. Наступний крок включає в себе повторну перевірку усіх файлів, щоб упевнитись що усі файли коректно оновлено.',
	'UPDATE_VERSION_OPTIMIZE'		=> 'Оновлення версії та оптимізація таблиць',
	'UPDATING_DATA'					=> 'Оновлення даних',
	'UPDATING_TO_LATEST_STABLE'		=> 'Оновлення бази даних до останньої стабільної версії',
	'UPDATED_VERSION'				=> 'Оновлена версія',
	'UPGRADE_INSTRUCTIONS'         => 	'Доступна нова версія: <strong>%1$s</strong>. Прочитайте <a href="%2$s" title="%2$s"><strong>оголошення про вихід нової версії</strong></a>, щоб отримати інформацію про нововведення і способи оновлення.',
	'UPLOAD_METHOD'					=> 'Метод завантаження',

	'UPDATE_DB_SUCCESS'				=> 'Оновлення бази даних успішно завершено.',
	'USER_ACTIVE'					=> 'Активний користувач',
	'USER_INACTIVE'					=> 'Неактивний користувач',

	'VERSION_CHECK'				=> 'Перевірка версії',
	'VERSION_CHECK_EXPLAIN'		=> 'Перевірте, чи у вас встановлено останню версію phpBB.',
	'VERSION_NOT_UP_TO_DATE'	=> 'Ваш форум phpBB неостанньої версії. Продовжіть, будь-ласка, процес оновлення.',
	'VERSION_NOT_UP_TO_DATE_ACP'=> 'Ваш форум phpBB неостанньої версії.<br />Нижче ви знайдете посилання на оголошення про вихід нової версії, а також інструкції з оновлення phpBB.',
	'VERSION_UP_TO_DATE'		=> 'Ваш форум останньої версії, немає доступних оновлень. Проте, ви можете перевірити встановлені файли на відповідність останній версії.',
   'VERSION_NOT_UP_TO_DATE_TITLE' => 'Ваша форум phpBB неостанньої версії.', 
	'VERSION_UP_TO_DATE_ACP'	=> 'Ваш форум останньої версії, немає доступних оновлень. Немає потреби оновлювати ваш форум.',
	'VIEWING_FILE_CONTENTS'		=> 'Перегляд вмісту файла',
	'VIEWING_FILE_DIFF'			=> 'Перегляд відмінностей у файлах',

	'WRONG_INFO_FILE_FORMAT'	=> 'Невірний формат файла інформації про оновлення',
));

// Default database schema entries...
$lang = array_merge($lang, array(
	'CONFIG_BOARD_EMAIL_SIG'		=> 'Дякуємо, Адміністрація',
	'CONFIG_SITE_DESC'				=> 'Короткий опис для вашого форуму',
	'CONFIG_SITENAME'				=> 'вашдомен.com',

	'DEFAULT_INSTALL_POST'			=> 'Це приклад повідомлення вашого phpBB3 форуму. Здається ніби все нормально працює. Ви можете при бажанні видалити це повідомлення та продовжити налаштування вашого форуму. В процесі встановлення вашій першій категорії та вашому першому форуму було встановлено відповідні права доступу для передвстановлених груп - адміністраторів, ботів, супермодераторів, гостей, зареєстрованих користувачів та зареєстрованих користувачів COPPA. Якщо ви видалите вашу першу категорію та ваш перший форум, не забудьте надати права доступу усім цих групам до нових категорій та форумів, які ви створите. Рекомендується перейменувати вашу першу категорію та ваш перший форум та скопіювати права з них при створенні нових категорій та форумів. Успіхів!',

	'FORUMS_FIRST_CATEGORY'			=> 'Ваша перша категорія',
	'FORUMS_TEST_FORUM_DESC'		=> 'Опис вашого першого форуму.',
	'FORUMS_TEST_FORUM_TITLE'		=> 'Ваш перший форум',
	'RANKS_SITE_ADMIN_TITLE'		=> 'Адміністратор сайту',
	'REPORT_WAREZ'					=> 'Повідомлення містить посилання на нелегальне або піратське програмне забезпечення.',
	'REPORT_SPAM'					=> 'Повідомлення має за мету лише рекламу вебсайту або іншого продукту.',
	'REPORT_OFF_TOPIC'				=> 'Повідомлення не відноситься до даної теми.',
	'REPORT_OTHER'					=> 'Причина скарги на повідомлення не підпадає під жодну з цих категорій, скористайтесь полем додаткової інформації.',
	'SMILIES_ARROW'					=> 'Стрілка',
	'SMILIES_CONFUSED'				=> 'Спантеличений',
	'SMILIES_COOL'					=> 'Кльво',
	'SMILIES_CRYING'				=> 'Плаче або дуже сердитий',
	'SMILIES_EMARRASSED'			=> 'Збентежений',
	'SMILIES_EVIL'					=> 'Злий або дуже роздратований',
	'SMILIES_EXCLAMATION'			=> 'Увага',
	'SMILIES_GEEK'					=> 'Ботанік',
	'SMILIES_IDEA'					=> 'Ідея',
	'SMILIES_LAUGHING'				=> 'Сміється',
	'SMILIES_MAD'					=> 'Божевільний',
	'SMILIES_MR_GREEN'				=> 'Зелений',
	'SMILIES_NEUTRAL'				=> 'Нейтральний',
	'SMILIES_QUESTION'				=> 'Питання',
	'SMILIES_RAZZ'					=> 'Глузує',
	'SMILIES_ROLLING_EYES'			=> 'Закочує очі',
	'SMILIES_SAD'					=> 'Сумний',
	'SMILIES_SHOCKED'				=> 'Шокований',
	'SMILIES_SMILE'					=> 'Посмішка',
	'SMILIES_SURPRISED'				=> 'Здивований',
	'SMILIES_TWISTED_EVIL'			=> 'Дуже злий',
	'SMILIES_UBER_GEEK'				=> 'Конкретний ботанік',
	'SMILIES_VERY_HAPPY'			=> 'Дуже щасливий',
	'SMILIES_WINK'					=> 'Підморгує',
	'TOPICS_TOPIC_TITLE'			=> 'Ласкаво просимо до phpBB3',
));

?>