/*=========================================================================

   Program: ParaView
   Module:    $RCSfile$

   Copyright (c) 2005,2006 Sandia Corporation, Kitware Inc.
   All rights reserved.

   ParaView is a free software; you can redistribute it and/or modify it
   under the terms of the ParaView license version 1.2.

   See License_v1.2.txt for the full ParaView license.
   A copy of this license can be obtained by contacting
   Kitware Inc.
   28 Corporate Drive
   Clifton Park, NY 12065
   USA

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

========================================================================*/
#ifndef pqYoungsMaterialInterfacePanel_h
#define pqYoungsMaterialInterfacePanel_h

#include "pqAutoGeneratedObjectPanel.h"
#include "pqComponentsModule.h"
#include <QPointer>

class QComboBox;
class QTreeWidget;


/// Properties Panel for YoungsMaterialInterface filter. We use a custom panel
/// since this filter has unusual requirements when it comes to setting
/// OrderingArrays and NormalArrays properties.
class PQCOMPONENTS_EXPORT pqYoungsMaterialInterfacePanel :
  public pqAutoGeneratedObjectPanel
{
  Q_OBJECT
  typedef pqAutoGeneratedObjectPanel Superclass;
public:
  pqYoungsMaterialInterfacePanel(pqProxy* proxy, QWidget* parent=0);
  virtual ~pqYoungsMaterialInterfacePanel();

public slots:
  /// overridden to accept the values for NormalArrays and OrderingArrays.
  virtual void accept();

  /// overridden to reset the values for NormalArrays and OrderingArrays.
  virtual void reset();

private slots:
  void updateOptions();
  void orderingArraysChanged(const QString&);
  void normalArraysChanged(const QString&);

private:
  Q_DISABLE_COPY(pqYoungsMaterialInterfacePanel)

  QPointer<QComboBox> OrderingArrays;
  QPointer<QComboBox> NormalArrays;
  QPointer<QTreeWidget> VolumeFractionArrays;
  bool BlockUpdateOptions;
};

#endif
