/*###############################################################################
# Linux Management Providers (LMP), Boot provider package
# Copyright (C) 2009 Nodir Nazarov <nazarov.nodir@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_SERVICEAFFECTSBOOTACCESS_H_
#define OPENDRIM_SERVICEAFFECTSBOOTACCESS_H_

#include "Boot_Common.h"

#include "OpenDRIM_ServiceAffectsBoot.h"
#include "assocOpenDRIM_ServiceAffectsBoot.h"

int Boot_OpenDRIM_ServiceAffectsBoot_load(const CMPIBroker* broker, string& errorMessage);

int Boot_OpenDRIM_ServiceAffectsBoot_unload(string& errorMessage);

int Boot_OpenDRIM_ServiceAffectsBoot_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_ServiceAffectsBoot>& instances, const char** properties, string& errorMessage, const string& discriminant);

int Boot_OpenDRIM_ServiceAffectsBoot_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_ServiceAffectsBoot& instance, const char** properties, string& errorMessage);

int Boot_OpenDRIM_ServiceAffectsBoot_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ServiceAffectsBoot& newInstance, const OpenDRIM_ServiceAffectsBoot& oldInstance, const char** properties, string& errorMessage);

int Boot_OpenDRIM_ServiceAffectsBoot_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ServiceAffectsBoot& instance, string& errorMessage);

int Boot_OpenDRIM_ServiceAffectsBoot_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ServiceAffectsBoot& instance, string& errorMessage);

int Boot_OpenDRIM_ServiceAffectsBoot_associatorAffectedElementToAffectingElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& AffectedElement_instance, const char** properties, vector<Instance>& AffectingElement_associatedInstances, string& errorMessage, const string& discriminant);

int Boot_OpenDRIM_ServiceAffectsBoot_associatorAffectingElementToAffectedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& AffectingElement_instance, const char** properties, vector<Instance>& AffectedElement_associatedInstances, string& errorMessage, const string& discriminant);

int Boot_OpenDRIM_ServiceAffectsBoot_referenceAffectedElementToAffectingElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& AffectedElement_instance, const vector<Instance>& AffectingElement_instances, vector<OpenDRIM_ServiceAffectsBoot>& OpenDRIM_ServiceAffectsBoot_instances, const char** properties, string& errorMessage, const string& discriminant);

int Boot_OpenDRIM_ServiceAffectsBoot_referenceAffectingElementToAffectedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& AffectingElement_instance, const vector<Instance>& AffectedElement_instances, vector<OpenDRIM_ServiceAffectsBoot>& OpenDRIM_ServiceAffectsBoot_instances, const char** properties, string& errorMessage, const string& discriminant);

int Boot_OpenDRIM_ServiceAffectsBoot_populate(OpenDRIM_ServiceAffectsBoot& instance, string& errorMessage);

#endif /*OPENDRIM_SERVICEAFFECTSBOOTACCESS_H_*/
