/*************************************************************************
 * odil - Copyright (C) Universite de Strasbourg
 * Distributed under the terms of the CeCILL-B license, as published by
 * the CEA-CNRS-INRIA. Refer to the LICENSE file or to
 * http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 * for details.
 ************************************************************************/

#include <map>
#include <string>
#include <tuple>

#include "odil/ElementsDictionary.h"
#include "odil/Tag.h"

namespace odil
{

namespace registry
{

void update_0070(
    ElementsDictionary & public_dictionary,
    std::map<std::string, odil::Tag> & public_tags)
{

    public_dictionary.emplace(Tag(0x0070, 0x0001), ElementsDictionaryEntry("Graphic Annotation Sequence", "GraphicAnnotationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0002), ElementsDictionaryEntry("Graphic Layer", "GraphicLayer",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0003), ElementsDictionaryEntry("Bounding Box Annotation Units", "BoundingBoxAnnotationUnits",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0004), ElementsDictionaryEntry("Anchor Point Annotation Units", "AnchorPointAnnotationUnits",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0005), ElementsDictionaryEntry("Graphic Annotation Units", "GraphicAnnotationUnits",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0006), ElementsDictionaryEntry("Unformatted Text Value", "UnformattedTextValue",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0008), ElementsDictionaryEntry("Text Object Sequence", "TextObjectSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0009), ElementsDictionaryEntry("Graphic Object Sequence", "GraphicObjectSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0010), ElementsDictionaryEntry("Bounding Box Top Left Hand Corner", "BoundingBoxTopLeftHandCorner",  "FL", "2"));
    public_dictionary.emplace(Tag(0x0070, 0x0011), ElementsDictionaryEntry("Bounding Box Bottom Right Hand Corner", "BoundingBoxBottomRightHandCorner",  "FL", "2"));
    public_dictionary.emplace(Tag(0x0070, 0x0012), ElementsDictionaryEntry("Bounding Box Text Horizontal Justification", "BoundingBoxTextHorizontalJustification",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0014), ElementsDictionaryEntry("Anchor Point", "AnchorPoint",  "FL", "2"));
    public_dictionary.emplace(Tag(0x0070, 0x0015), ElementsDictionaryEntry("Anchor Point Visibility", "AnchorPointVisibility",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0020), ElementsDictionaryEntry("Graphic Dimensions", "GraphicDimensions",  "US", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0021), ElementsDictionaryEntry("Number of Graphic Points", "NumberOfGraphicPoints",  "US", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0022), ElementsDictionaryEntry("Graphic Data", "GraphicData",  "FL", "2-n"));
    public_dictionary.emplace(Tag(0x0070, 0x0023), ElementsDictionaryEntry("Graphic Type", "GraphicType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0024), ElementsDictionaryEntry("Graphic Filled", "GraphicFilled",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0040), ElementsDictionaryEntry("Image Rotation (Retired)", "ImageRotationRetired",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0041), ElementsDictionaryEntry("Image Horizontal Flip", "ImageHorizontalFlip",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0042), ElementsDictionaryEntry("Image Rotation", "ImageRotation",  "US", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0050), ElementsDictionaryEntry("Displayed Area Top Left Hand Corner (Trial)", "DisplayedAreaTopLeftHandCornerTrial",  "US", "2"));
    public_dictionary.emplace(Tag(0x0070, 0x0051), ElementsDictionaryEntry("Displayed Area Bottom Right Hand Corner (Trial)", "DisplayedAreaBottomRightHandCornerTrial",  "US", "2"));
    public_dictionary.emplace(Tag(0x0070, 0x0052), ElementsDictionaryEntry("Displayed Area Top Left Hand Corner", "DisplayedAreaTopLeftHandCorner",  "SL", "2"));
    public_dictionary.emplace(Tag(0x0070, 0x0053), ElementsDictionaryEntry("Displayed Area Bottom Right Hand Corner", "DisplayedAreaBottomRightHandCorner",  "SL", "2"));
    public_dictionary.emplace(Tag(0x0070, 0x005a), ElementsDictionaryEntry("Displayed Area Selection Sequence", "DisplayedAreaSelectionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0060), ElementsDictionaryEntry("Graphic Layer Sequence", "GraphicLayerSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0062), ElementsDictionaryEntry("Graphic Layer Order", "GraphicLayerOrder",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0066), ElementsDictionaryEntry("Graphic Layer Recommended Display Grayscale Value", "GraphicLayerRecommendedDisplayGrayscaleValue",  "US", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0067), ElementsDictionaryEntry("Graphic Layer Recommended Display RGB Value", "GraphicLayerRecommendedDisplayRGBValue",  "US", "3"));
    public_dictionary.emplace(Tag(0x0070, 0x0068), ElementsDictionaryEntry("Graphic Layer Description", "GraphicLayerDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0080), ElementsDictionaryEntry("Content Label", "ContentLabel",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0081), ElementsDictionaryEntry("Content Description", "ContentDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0082), ElementsDictionaryEntry("Presentation Creation Date", "PresentationCreationDate",  "DA", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0083), ElementsDictionaryEntry("Presentation Creation Time", "PresentationCreationTime",  "TM", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0084), ElementsDictionaryEntry("Content Creator's Name", "ContentCreatorName",  "PN", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0086), ElementsDictionaryEntry("Content Creator's Identification Code Sequence", "ContentCreatorIdentificationCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0087), ElementsDictionaryEntry("Alternate Content Description Sequence", "AlternateContentDescriptionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0100), ElementsDictionaryEntry("Presentation Size Mode", "PresentationSizeMode",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0101), ElementsDictionaryEntry("Presentation Pixel Spacing", "PresentationPixelSpacing",  "DS", "2"));
    public_dictionary.emplace(Tag(0x0070, 0x0102), ElementsDictionaryEntry("Presentation Pixel Aspect Ratio", "PresentationPixelAspectRatio",  "IS", "2"));
    public_dictionary.emplace(Tag(0x0070, 0x0103), ElementsDictionaryEntry("Presentation Pixel Magnification Ratio", "PresentationPixelMagnificationRatio",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0207), ElementsDictionaryEntry("Graphic Group Label", "GraphicGroupLabel",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0208), ElementsDictionaryEntry("Graphic Group Description", "GraphicGroupDescription",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0209), ElementsDictionaryEntry("Compound Graphic Sequence", "CompoundGraphicSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0226), ElementsDictionaryEntry("Compound Graphic Instance ID", "CompoundGraphicInstanceID",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0227), ElementsDictionaryEntry("Font Name", "FontName",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0228), ElementsDictionaryEntry("Font Name Type", "FontNameType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0229), ElementsDictionaryEntry("CSS Font Name", "CSSFontName",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0230), ElementsDictionaryEntry("Rotation Angle", "RotationAngle",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0231), ElementsDictionaryEntry("Text Style Sequence", "TextStyleSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0232), ElementsDictionaryEntry("Line Style Sequence", "LineStyleSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0233), ElementsDictionaryEntry("Fill Style Sequence", "FillStyleSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0234), ElementsDictionaryEntry("Graphic Group Sequence", "GraphicGroupSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0241), ElementsDictionaryEntry("Text Color CIELab Value", "TextColorCIELabValue",  "US", "3"));
    public_dictionary.emplace(Tag(0x0070, 0x0242), ElementsDictionaryEntry("Horizontal Alignment", "HorizontalAlignment",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0243), ElementsDictionaryEntry("Vertical Alignment", "VerticalAlignment",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0244), ElementsDictionaryEntry("Shadow Style", "ShadowStyle",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0245), ElementsDictionaryEntry("Shadow Offset X", "ShadowOffsetX",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0246), ElementsDictionaryEntry("Shadow Offset Y", "ShadowOffsetY",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0247), ElementsDictionaryEntry("Shadow Color CIELab Value", "ShadowColorCIELabValue",  "US", "3"));
    public_dictionary.emplace(Tag(0x0070, 0x0248), ElementsDictionaryEntry("Underlined", "Underlined",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0249), ElementsDictionaryEntry("Bold", "Bold",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0250), ElementsDictionaryEntry("Italic", "Italic",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0251), ElementsDictionaryEntry("Pattern On Color CIELab Value", "PatternOnColorCIELabValue",  "US", "3"));
    public_dictionary.emplace(Tag(0x0070, 0x0252), ElementsDictionaryEntry("Pattern Off Color CIELab Value", "PatternOffColorCIELabValue",  "US", "3"));
    public_dictionary.emplace(Tag(0x0070, 0x0253), ElementsDictionaryEntry("Line Thickness", "LineThickness",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0254), ElementsDictionaryEntry("Line Dashing Style", "LineDashingStyle",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0255), ElementsDictionaryEntry("Line Pattern", "LinePattern",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0256), ElementsDictionaryEntry("Fill Pattern", "FillPattern",  "OB", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0257), ElementsDictionaryEntry("Fill Mode", "FillMode",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0258), ElementsDictionaryEntry("Shadow Opacity", "ShadowOpacity",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0261), ElementsDictionaryEntry("Gap Length", "GapLength",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0262), ElementsDictionaryEntry("Diameter of Visibility", "DiameterOfVisibility",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0273), ElementsDictionaryEntry("Rotation Point", "RotationPoint",  "FL", "2"));
    public_dictionary.emplace(Tag(0x0070, 0x0274), ElementsDictionaryEntry("Tick Alignment", "TickAlignment",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0278), ElementsDictionaryEntry("Show Tick Label", "ShowTickLabel",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0279), ElementsDictionaryEntry("Tick Label Alignment", "TickLabelAlignment",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0282), ElementsDictionaryEntry("Compound Graphic Units", "CompoundGraphicUnits",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0284), ElementsDictionaryEntry("Pattern On Opacity", "PatternOnOpacity",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0285), ElementsDictionaryEntry("Pattern Off Opacity", "PatternOffOpacity",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0287), ElementsDictionaryEntry("Major Ticks Sequence", "MajorTicksSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0288), ElementsDictionaryEntry("Tick Position", "TickPosition",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0289), ElementsDictionaryEntry("Tick Label", "TickLabel",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0294), ElementsDictionaryEntry("Compound Graphic Type", "CompoundGraphicType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0295), ElementsDictionaryEntry("Graphic Group ID", "GraphicGroupID",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0306), ElementsDictionaryEntry("Shape Type", "ShapeType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0308), ElementsDictionaryEntry("Registration Sequence", "RegistrationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0309), ElementsDictionaryEntry("Matrix Registration Sequence", "MatrixRegistrationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x030a), ElementsDictionaryEntry("Matrix Sequence", "MatrixSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x030b), ElementsDictionaryEntry("Frame of Reference to Displayed Coordinate System Transformation Matrix", "FrameOfReferenceToDisplayedCoordinateSystemTransformationMatrix",  "FD", "16"));
    public_dictionary.emplace(Tag(0x0070, 0x030c), ElementsDictionaryEntry("Frame of Reference Transformation Matrix Type", "FrameOfReferenceTransformationMatrixType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x030d), ElementsDictionaryEntry("Registration Type Code Sequence", "RegistrationTypeCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x030f), ElementsDictionaryEntry("Fiducial Description", "FiducialDescription",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0310), ElementsDictionaryEntry("Fiducial Identifier", "FiducialIdentifier",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0311), ElementsDictionaryEntry("Fiducial Identifier Code Sequence", "FiducialIdentifierCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0312), ElementsDictionaryEntry("Contour Uncertainty Radius", "ContourUncertaintyRadius",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0314), ElementsDictionaryEntry("Used Fiducials Sequence", "UsedFiducialsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0315), ElementsDictionaryEntry("Used RT Structure Set ROI Sequence", "UsedRTStructureSetROISequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0318), ElementsDictionaryEntry("Graphic Coordinates Data Sequence", "GraphicCoordinatesDataSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x031a), ElementsDictionaryEntry("Fiducial UID", "FiducialUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x031b), ElementsDictionaryEntry("Referenced Fiducial UID", "ReferencedFiducialUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x031c), ElementsDictionaryEntry("Fiducial Set Sequence", "FiducialSetSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x031e), ElementsDictionaryEntry("Fiducial Sequence", "FiducialSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x031f), ElementsDictionaryEntry("Fiducials Property Category Code Sequence", "FiducialsPropertyCategoryCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0401), ElementsDictionaryEntry("Graphic Layer Recommended Display CIELab Value", "GraphicLayerRecommendedDisplayCIELabValue",  "US", "3"));
    public_dictionary.emplace(Tag(0x0070, 0x0402), ElementsDictionaryEntry("Blending Sequence", "BlendingSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0403), ElementsDictionaryEntry("Relative Opacity", "RelativeOpacity",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0404), ElementsDictionaryEntry("Referenced Spatial Registration Sequence", "ReferencedSpatialRegistrationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x0405), ElementsDictionaryEntry("Blending Position", "BlendingPosition",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1101), ElementsDictionaryEntry("Presentation Display Collection UID", "PresentationDisplayCollectionUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1102), ElementsDictionaryEntry("Presentation Sequence Collection UID", "PresentationSequenceCollectionUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1103), ElementsDictionaryEntry("Presentation Sequence Position Index", "PresentationSequencePositionIndex",  "US", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1104), ElementsDictionaryEntry("Rendered Image Reference Sequence", "RenderedImageReferenceSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1201), ElementsDictionaryEntry("Volumetric Presentation State Input Sequence", "VolumetricPresentationStateInputSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1202), ElementsDictionaryEntry("Presentation Input Type", "PresentationInputType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1203), ElementsDictionaryEntry("Input Sequence Position Index", "InputSequencePositionIndex",  "US", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1204), ElementsDictionaryEntry("Crop", "Crop",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1205), ElementsDictionaryEntry("Cropping Specification Index", "CroppingSpecificationIndex",  "US", "1-n"));
    public_dictionary.emplace(Tag(0x0070, 0x1206), ElementsDictionaryEntry("Compositing Method", "CompositingMethod",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1207), ElementsDictionaryEntry("Volumetric Presentation Input Number", "VolumetricPresentationInputNumber",  "US", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1208), ElementsDictionaryEntry("Image Volume Geometry", "ImageVolumeGeometry",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1209), ElementsDictionaryEntry("Volumetric Presentation Input Set UID", "VolumetricPresentationInputSetUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x120a), ElementsDictionaryEntry("Volumetric Presentation Input Set Sequence", "VolumetricPresentationInputSetSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x120b), ElementsDictionaryEntry("Global Crop", "GlobalCrop",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x120c), ElementsDictionaryEntry("Global Cropping Specification Index", "GlobalCroppingSpecificationIndex",  "US", "1-n"));
    public_dictionary.emplace(Tag(0x0070, 0x120d), ElementsDictionaryEntry("Rendering Method", "RenderingMethod",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1301), ElementsDictionaryEntry("Volume Cropping Sequence", "VolumeCroppingSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1302), ElementsDictionaryEntry("Volume Cropping Method", "VolumeCroppingMethod",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1303), ElementsDictionaryEntry("Bounding Box Crop", "BoundingBoxCrop",  "FD", "6"));
    public_dictionary.emplace(Tag(0x0070, 0x1304), ElementsDictionaryEntry("Oblique Cropping Plane Sequence", "ObliqueCroppingPlaneSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1305), ElementsDictionaryEntry("Plane", "Plane",  "FD", "4"));
    public_dictionary.emplace(Tag(0x0070, 0x1306), ElementsDictionaryEntry("Plane Normal", "PlaneNormal",  "FD", "3"));
    public_dictionary.emplace(Tag(0x0070, 0x1309), ElementsDictionaryEntry("Cropping Specification Number", "CroppingSpecificationNumber",  "US", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1501), ElementsDictionaryEntry("Multi-Planar Reconstruction Style", "MultiPlanarReconstructionStyle",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1502), ElementsDictionaryEntry("MPR Thickness Type", "MPRThicknessType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1503), ElementsDictionaryEntry("MPR Slab Thickness", "MPRSlabThickness",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1505), ElementsDictionaryEntry("MPR Top Left Hand Corner", "MPRTopLeftHandCorner",  "FD", "3"));
    public_dictionary.emplace(Tag(0x0070, 0x1507), ElementsDictionaryEntry("MPR View Width Direction", "MPRViewWidthDirection",  "FD", "3"));
    public_dictionary.emplace(Tag(0x0070, 0x1508), ElementsDictionaryEntry("MPR View Width", "MPRViewWidth",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x150c), ElementsDictionaryEntry("Number of Volumetric Curve Points", "NumberOfVolumetricCurvePoints",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x150d), ElementsDictionaryEntry("Volumetric Curve Points", "VolumetricCurvePoints",  "OD", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1511), ElementsDictionaryEntry("MPR View Height Direction", "MPRViewHeightDirection",  "FD", "3"));
    public_dictionary.emplace(Tag(0x0070, 0x1512), ElementsDictionaryEntry("MPR View Height", "MPRViewHeight",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1602), ElementsDictionaryEntry("Render Projection", "RenderProjection",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1603), ElementsDictionaryEntry("Viewpoint Position", "ViewpointPosition",  "FD", "3"));
    public_dictionary.emplace(Tag(0x0070, 0x1604), ElementsDictionaryEntry("Viewpoint LookAt Point", "ViewpointLookAtPoint",  "FD", "3"));
    public_dictionary.emplace(Tag(0x0070, 0x1605), ElementsDictionaryEntry("Viewpoint Up Direction", "ViewpointUpDirection",  "FD", "3"));
    public_dictionary.emplace(Tag(0x0070, 0x1606), ElementsDictionaryEntry("Render Field of View", "RenderFieldOfView",  "FD", "6"));
    public_dictionary.emplace(Tag(0x0070, 0x1607), ElementsDictionaryEntry("Sampling Step Size", "SamplingStepSize",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1701), ElementsDictionaryEntry("Shading Style", "ShadingStyle",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1702), ElementsDictionaryEntry("Ambient Reflection Intensity", "AmbientReflectionIntensity",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1703), ElementsDictionaryEntry("Light Direction", "LightDirection",  "FD", "3"));
    public_dictionary.emplace(Tag(0x0070, 0x1704), ElementsDictionaryEntry("Diffuse Reflection Intensity", "DiffuseReflectionIntensity",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1705), ElementsDictionaryEntry("Specular Reflection Intensity", "SpecularReflectionIntensity",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1706), ElementsDictionaryEntry("Shininess", "Shininess",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1801), ElementsDictionaryEntry("Presentation State Classification Component Sequence", "PresentationStateClassificationComponentSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1802), ElementsDictionaryEntry("Component Type", "ComponentType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1803), ElementsDictionaryEntry("Component Input Sequence", "ComponentInputSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1804), ElementsDictionaryEntry("Volumetric Presentation Input Index", "VolumetricPresentationInputIndex",  "US", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1805), ElementsDictionaryEntry("Presentation State Compositor Component Sequence", "PresentationStateCompositorComponentSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1806), ElementsDictionaryEntry("Weighting Transfer Function Sequence", "WeightingTransferFunctionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1807), ElementsDictionaryEntry("Weighting Lookup Table Descriptor", "WeightingLookupTableDescriptor",  "US", "3"));
    public_dictionary.emplace(Tag(0x0070, 0x1808), ElementsDictionaryEntry("Weighting Lookup Table Data", "WeightingLookupTableData",  "OB", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1901), ElementsDictionaryEntry("Volumetric Annotation Sequence", "VolumetricAnnotationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1903), ElementsDictionaryEntry("Referenced Structured Context Sequence", "ReferencedStructuredContextSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1904), ElementsDictionaryEntry("Referenced Content Item", "ReferencedContentItem",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1905), ElementsDictionaryEntry("Volumetric Presentation Input Annotation Sequence", "VolumetricPresentationInputAnnotationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1907), ElementsDictionaryEntry("Annotation Clipping", "AnnotationClipping",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1a01), ElementsDictionaryEntry("Presentation Animation Style", "PresentationAnimationStyle",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1a03), ElementsDictionaryEntry("Recommended Animation Rate", "RecommendedAnimationRate",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1a04), ElementsDictionaryEntry("Animation Curve Sequence", "AnimationCurveSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1a05), ElementsDictionaryEntry("Animation Step Size", "AnimationStepSize",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1a06), ElementsDictionaryEntry("Swivel Range", "SwivelRange",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1a07), ElementsDictionaryEntry("Volumetric Curve Up Directions", "VolumetricCurveUpDirections",  "OD", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1a08), ElementsDictionaryEntry("Volume Stream Sequence", "VolumeStreamSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1a09), ElementsDictionaryEntry("RGBA Transfer Function Description", "RGBATransferFunctionDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1b01), ElementsDictionaryEntry("Advanced Blending Sequence", "AdvancedBlendingSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1b02), ElementsDictionaryEntry("Blending Input Number", "BlendingInputNumber",  "US", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1b03), ElementsDictionaryEntry("Blending Display Input Sequence", "BlendingDisplayInputSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1b04), ElementsDictionaryEntry("Blending Display Sequence", "BlendingDisplaySequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1b06), ElementsDictionaryEntry("Blending Mode", "BlendingMode",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1b07), ElementsDictionaryEntry("Time Series Blending", "TimeSeriesBlending",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1b08), ElementsDictionaryEntry("Geometry for Display", "GeometryForDisplay",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1b11), ElementsDictionaryEntry("Threshold Sequence", "ThresholdSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1b12), ElementsDictionaryEntry("Threshold Value Sequence", "ThresholdValueSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1b13), ElementsDictionaryEntry("Threshold Type", "ThresholdType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0070, 0x1b14), ElementsDictionaryEntry("Threshold Value", "ThresholdValue",  "FD", "1"));

    public_tags.emplace("GraphicAnnotationSequence", Tag(0x0070, 0x0001));
    public_tags.emplace("GraphicLayer", Tag(0x0070, 0x0002));
    public_tags.emplace("BoundingBoxAnnotationUnits", Tag(0x0070, 0x0003));
    public_tags.emplace("AnchorPointAnnotationUnits", Tag(0x0070, 0x0004));
    public_tags.emplace("GraphicAnnotationUnits", Tag(0x0070, 0x0005));
    public_tags.emplace("UnformattedTextValue", Tag(0x0070, 0x0006));
    public_tags.emplace("TextObjectSequence", Tag(0x0070, 0x0008));
    public_tags.emplace("GraphicObjectSequence", Tag(0x0070, 0x0009));
    public_tags.emplace("BoundingBoxTopLeftHandCorner", Tag(0x0070, 0x0010));
    public_tags.emplace("BoundingBoxBottomRightHandCorner", Tag(0x0070, 0x0011));
    public_tags.emplace("BoundingBoxTextHorizontalJustification", Tag(0x0070, 0x0012));
    public_tags.emplace("AnchorPoint", Tag(0x0070, 0x0014));
    public_tags.emplace("AnchorPointVisibility", Tag(0x0070, 0x0015));
    public_tags.emplace("GraphicDimensions", Tag(0x0070, 0x0020));
    public_tags.emplace("NumberOfGraphicPoints", Tag(0x0070, 0x0021));
    public_tags.emplace("GraphicData", Tag(0x0070, 0x0022));
    public_tags.emplace("GraphicType", Tag(0x0070, 0x0023));
    public_tags.emplace("GraphicFilled", Tag(0x0070, 0x0024));
    public_tags.emplace("ImageRotationRetired", Tag(0x0070, 0x0040));
    public_tags.emplace("ImageHorizontalFlip", Tag(0x0070, 0x0041));
    public_tags.emplace("ImageRotation", Tag(0x0070, 0x0042));
    public_tags.emplace("DisplayedAreaTopLeftHandCornerTrial", Tag(0x0070, 0x0050));
    public_tags.emplace("DisplayedAreaBottomRightHandCornerTrial", Tag(0x0070, 0x0051));
    public_tags.emplace("DisplayedAreaTopLeftHandCorner", Tag(0x0070, 0x0052));
    public_tags.emplace("DisplayedAreaBottomRightHandCorner", Tag(0x0070, 0x0053));
    public_tags.emplace("DisplayedAreaSelectionSequence", Tag(0x0070, 0x005a));
    public_tags.emplace("GraphicLayerSequence", Tag(0x0070, 0x0060));
    public_tags.emplace("GraphicLayerOrder", Tag(0x0070, 0x0062));
    public_tags.emplace("GraphicLayerRecommendedDisplayGrayscaleValue", Tag(0x0070, 0x0066));
    public_tags.emplace("GraphicLayerRecommendedDisplayRGBValue", Tag(0x0070, 0x0067));
    public_tags.emplace("GraphicLayerDescription", Tag(0x0070, 0x0068));
    public_tags.emplace("ContentLabel", Tag(0x0070, 0x0080));
    public_tags.emplace("ContentDescription", Tag(0x0070, 0x0081));
    public_tags.emplace("PresentationCreationDate", Tag(0x0070, 0x0082));
    public_tags.emplace("PresentationCreationTime", Tag(0x0070, 0x0083));
    public_tags.emplace("ContentCreatorName", Tag(0x0070, 0x0084));
    public_tags.emplace("ContentCreatorIdentificationCodeSequence", Tag(0x0070, 0x0086));
    public_tags.emplace("AlternateContentDescriptionSequence", Tag(0x0070, 0x0087));
    public_tags.emplace("PresentationSizeMode", Tag(0x0070, 0x0100));
    public_tags.emplace("PresentationPixelSpacing", Tag(0x0070, 0x0101));
    public_tags.emplace("PresentationPixelAspectRatio", Tag(0x0070, 0x0102));
    public_tags.emplace("PresentationPixelMagnificationRatio", Tag(0x0070, 0x0103));
    public_tags.emplace("GraphicGroupLabel", Tag(0x0070, 0x0207));
    public_tags.emplace("GraphicGroupDescription", Tag(0x0070, 0x0208));
    public_tags.emplace("CompoundGraphicSequence", Tag(0x0070, 0x0209));
    public_tags.emplace("CompoundGraphicInstanceID", Tag(0x0070, 0x0226));
    public_tags.emplace("FontName", Tag(0x0070, 0x0227));
    public_tags.emplace("FontNameType", Tag(0x0070, 0x0228));
    public_tags.emplace("CSSFontName", Tag(0x0070, 0x0229));
    public_tags.emplace("RotationAngle", Tag(0x0070, 0x0230));
    public_tags.emplace("TextStyleSequence", Tag(0x0070, 0x0231));
    public_tags.emplace("LineStyleSequence", Tag(0x0070, 0x0232));
    public_tags.emplace("FillStyleSequence", Tag(0x0070, 0x0233));
    public_tags.emplace("GraphicGroupSequence", Tag(0x0070, 0x0234));
    public_tags.emplace("TextColorCIELabValue", Tag(0x0070, 0x0241));
    public_tags.emplace("HorizontalAlignment", Tag(0x0070, 0x0242));
    public_tags.emplace("VerticalAlignment", Tag(0x0070, 0x0243));
    public_tags.emplace("ShadowStyle", Tag(0x0070, 0x0244));
    public_tags.emplace("ShadowOffsetX", Tag(0x0070, 0x0245));
    public_tags.emplace("ShadowOffsetY", Tag(0x0070, 0x0246));
    public_tags.emplace("ShadowColorCIELabValue", Tag(0x0070, 0x0247));
    public_tags.emplace("Underlined", Tag(0x0070, 0x0248));
    public_tags.emplace("Bold", Tag(0x0070, 0x0249));
    public_tags.emplace("Italic", Tag(0x0070, 0x0250));
    public_tags.emplace("PatternOnColorCIELabValue", Tag(0x0070, 0x0251));
    public_tags.emplace("PatternOffColorCIELabValue", Tag(0x0070, 0x0252));
    public_tags.emplace("LineThickness", Tag(0x0070, 0x0253));
    public_tags.emplace("LineDashingStyle", Tag(0x0070, 0x0254));
    public_tags.emplace("LinePattern", Tag(0x0070, 0x0255));
    public_tags.emplace("FillPattern", Tag(0x0070, 0x0256));
    public_tags.emplace("FillMode", Tag(0x0070, 0x0257));
    public_tags.emplace("ShadowOpacity", Tag(0x0070, 0x0258));
    public_tags.emplace("GapLength", Tag(0x0070, 0x0261));
    public_tags.emplace("DiameterOfVisibility", Tag(0x0070, 0x0262));
    public_tags.emplace("RotationPoint", Tag(0x0070, 0x0273));
    public_tags.emplace("TickAlignment", Tag(0x0070, 0x0274));
    public_tags.emplace("ShowTickLabel", Tag(0x0070, 0x0278));
    public_tags.emplace("TickLabelAlignment", Tag(0x0070, 0x0279));
    public_tags.emplace("CompoundGraphicUnits", Tag(0x0070, 0x0282));
    public_tags.emplace("PatternOnOpacity", Tag(0x0070, 0x0284));
    public_tags.emplace("PatternOffOpacity", Tag(0x0070, 0x0285));
    public_tags.emplace("MajorTicksSequence", Tag(0x0070, 0x0287));
    public_tags.emplace("TickPosition", Tag(0x0070, 0x0288));
    public_tags.emplace("TickLabel", Tag(0x0070, 0x0289));
    public_tags.emplace("CompoundGraphicType", Tag(0x0070, 0x0294));
    public_tags.emplace("GraphicGroupID", Tag(0x0070, 0x0295));
    public_tags.emplace("ShapeType", Tag(0x0070, 0x0306));
    public_tags.emplace("RegistrationSequence", Tag(0x0070, 0x0308));
    public_tags.emplace("MatrixRegistrationSequence", Tag(0x0070, 0x0309));
    public_tags.emplace("MatrixSequence", Tag(0x0070, 0x030a));
    public_tags.emplace("FrameOfReferenceToDisplayedCoordinateSystemTransformationMatrix", Tag(0x0070, 0x030b));
    public_tags.emplace("FrameOfReferenceTransformationMatrixType", Tag(0x0070, 0x030c));
    public_tags.emplace("RegistrationTypeCodeSequence", Tag(0x0070, 0x030d));
    public_tags.emplace("FiducialDescription", Tag(0x0070, 0x030f));
    public_tags.emplace("FiducialIdentifier", Tag(0x0070, 0x0310));
    public_tags.emplace("FiducialIdentifierCodeSequence", Tag(0x0070, 0x0311));
    public_tags.emplace("ContourUncertaintyRadius", Tag(0x0070, 0x0312));
    public_tags.emplace("UsedFiducialsSequence", Tag(0x0070, 0x0314));
    public_tags.emplace("UsedRTStructureSetROISequence", Tag(0x0070, 0x0315));
    public_tags.emplace("GraphicCoordinatesDataSequence", Tag(0x0070, 0x0318));
    public_tags.emplace("FiducialUID", Tag(0x0070, 0x031a));
    public_tags.emplace("ReferencedFiducialUID", Tag(0x0070, 0x031b));
    public_tags.emplace("FiducialSetSequence", Tag(0x0070, 0x031c));
    public_tags.emplace("FiducialSequence", Tag(0x0070, 0x031e));
    public_tags.emplace("FiducialsPropertyCategoryCodeSequence", Tag(0x0070, 0x031f));
    public_tags.emplace("GraphicLayerRecommendedDisplayCIELabValue", Tag(0x0070, 0x0401));
    public_tags.emplace("BlendingSequence", Tag(0x0070, 0x0402));
    public_tags.emplace("RelativeOpacity", Tag(0x0070, 0x0403));
    public_tags.emplace("ReferencedSpatialRegistrationSequence", Tag(0x0070, 0x0404));
    public_tags.emplace("BlendingPosition", Tag(0x0070, 0x0405));
    public_tags.emplace("PresentationDisplayCollectionUID", Tag(0x0070, 0x1101));
    public_tags.emplace("PresentationSequenceCollectionUID", Tag(0x0070, 0x1102));
    public_tags.emplace("PresentationSequencePositionIndex", Tag(0x0070, 0x1103));
    public_tags.emplace("RenderedImageReferenceSequence", Tag(0x0070, 0x1104));
    public_tags.emplace("VolumetricPresentationStateInputSequence", Tag(0x0070, 0x1201));
    public_tags.emplace("PresentationInputType", Tag(0x0070, 0x1202));
    public_tags.emplace("InputSequencePositionIndex", Tag(0x0070, 0x1203));
    public_tags.emplace("Crop", Tag(0x0070, 0x1204));
    public_tags.emplace("CroppingSpecificationIndex", Tag(0x0070, 0x1205));
    public_tags.emplace("CompositingMethod", Tag(0x0070, 0x1206));
    public_tags.emplace("VolumetricPresentationInputNumber", Tag(0x0070, 0x1207));
    public_tags.emplace("ImageVolumeGeometry", Tag(0x0070, 0x1208));
    public_tags.emplace("VolumetricPresentationInputSetUID", Tag(0x0070, 0x1209));
    public_tags.emplace("VolumetricPresentationInputSetSequence", Tag(0x0070, 0x120a));
    public_tags.emplace("GlobalCrop", Tag(0x0070, 0x120b));
    public_tags.emplace("GlobalCroppingSpecificationIndex", Tag(0x0070, 0x120c));
    public_tags.emplace("RenderingMethod", Tag(0x0070, 0x120d));
    public_tags.emplace("VolumeCroppingSequence", Tag(0x0070, 0x1301));
    public_tags.emplace("VolumeCroppingMethod", Tag(0x0070, 0x1302));
    public_tags.emplace("BoundingBoxCrop", Tag(0x0070, 0x1303));
    public_tags.emplace("ObliqueCroppingPlaneSequence", Tag(0x0070, 0x1304));
    public_tags.emplace("Plane", Tag(0x0070, 0x1305));
    public_tags.emplace("PlaneNormal", Tag(0x0070, 0x1306));
    public_tags.emplace("CroppingSpecificationNumber", Tag(0x0070, 0x1309));
    public_tags.emplace("MultiPlanarReconstructionStyle", Tag(0x0070, 0x1501));
    public_tags.emplace("MPRThicknessType", Tag(0x0070, 0x1502));
    public_tags.emplace("MPRSlabThickness", Tag(0x0070, 0x1503));
    public_tags.emplace("MPRTopLeftHandCorner", Tag(0x0070, 0x1505));
    public_tags.emplace("MPRViewWidthDirection", Tag(0x0070, 0x1507));
    public_tags.emplace("MPRViewWidth", Tag(0x0070, 0x1508));
    public_tags.emplace("NumberOfVolumetricCurvePoints", Tag(0x0070, 0x150c));
    public_tags.emplace("VolumetricCurvePoints", Tag(0x0070, 0x150d));
    public_tags.emplace("MPRViewHeightDirection", Tag(0x0070, 0x1511));
    public_tags.emplace("MPRViewHeight", Tag(0x0070, 0x1512));
    public_tags.emplace("RenderProjection", Tag(0x0070, 0x1602));
    public_tags.emplace("ViewpointPosition", Tag(0x0070, 0x1603));
    public_tags.emplace("ViewpointLookAtPoint", Tag(0x0070, 0x1604));
    public_tags.emplace("ViewpointUpDirection", Tag(0x0070, 0x1605));
    public_tags.emplace("RenderFieldOfView", Tag(0x0070, 0x1606));
    public_tags.emplace("SamplingStepSize", Tag(0x0070, 0x1607));
    public_tags.emplace("ShadingStyle", Tag(0x0070, 0x1701));
    public_tags.emplace("AmbientReflectionIntensity", Tag(0x0070, 0x1702));
    public_tags.emplace("LightDirection", Tag(0x0070, 0x1703));
    public_tags.emplace("DiffuseReflectionIntensity", Tag(0x0070, 0x1704));
    public_tags.emplace("SpecularReflectionIntensity", Tag(0x0070, 0x1705));
    public_tags.emplace("Shininess", Tag(0x0070, 0x1706));
    public_tags.emplace("PresentationStateClassificationComponentSequence", Tag(0x0070, 0x1801));
    public_tags.emplace("ComponentType", Tag(0x0070, 0x1802));
    public_tags.emplace("ComponentInputSequence", Tag(0x0070, 0x1803));
    public_tags.emplace("VolumetricPresentationInputIndex", Tag(0x0070, 0x1804));
    public_tags.emplace("PresentationStateCompositorComponentSequence", Tag(0x0070, 0x1805));
    public_tags.emplace("WeightingTransferFunctionSequence", Tag(0x0070, 0x1806));
    public_tags.emplace("WeightingLookupTableDescriptor", Tag(0x0070, 0x1807));
    public_tags.emplace("WeightingLookupTableData", Tag(0x0070, 0x1808));
    public_tags.emplace("VolumetricAnnotationSequence", Tag(0x0070, 0x1901));
    public_tags.emplace("ReferencedStructuredContextSequence", Tag(0x0070, 0x1903));
    public_tags.emplace("ReferencedContentItem", Tag(0x0070, 0x1904));
    public_tags.emplace("VolumetricPresentationInputAnnotationSequence", Tag(0x0070, 0x1905));
    public_tags.emplace("AnnotationClipping", Tag(0x0070, 0x1907));
    public_tags.emplace("PresentationAnimationStyle", Tag(0x0070, 0x1a01));
    public_tags.emplace("RecommendedAnimationRate", Tag(0x0070, 0x1a03));
    public_tags.emplace("AnimationCurveSequence", Tag(0x0070, 0x1a04));
    public_tags.emplace("AnimationStepSize", Tag(0x0070, 0x1a05));
    public_tags.emplace("SwivelRange", Tag(0x0070, 0x1a06));
    public_tags.emplace("VolumetricCurveUpDirections", Tag(0x0070, 0x1a07));
    public_tags.emplace("VolumeStreamSequence", Tag(0x0070, 0x1a08));
    public_tags.emplace("RGBATransferFunctionDescription", Tag(0x0070, 0x1a09));
    public_tags.emplace("AdvancedBlendingSequence", Tag(0x0070, 0x1b01));
    public_tags.emplace("BlendingInputNumber", Tag(0x0070, 0x1b02));
    public_tags.emplace("BlendingDisplayInputSequence", Tag(0x0070, 0x1b03));
    public_tags.emplace("BlendingDisplaySequence", Tag(0x0070, 0x1b04));
    public_tags.emplace("BlendingMode", Tag(0x0070, 0x1b06));
    public_tags.emplace("TimeSeriesBlending", Tag(0x0070, 0x1b07));
    public_tags.emplace("GeometryForDisplay", Tag(0x0070, 0x1b08));
    public_tags.emplace("ThresholdSequence", Tag(0x0070, 0x1b11));
    public_tags.emplace("ThresholdValueSequence", Tag(0x0070, 0x1b12));
    public_tags.emplace("ThresholdType", Tag(0x0070, 0x1b13));
    public_tags.emplace("ThresholdValue", Tag(0x0070, 0x1b14));
}

}

}