// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BRepOffsetAPI_MakePipe_HeaderFile
#define _BRepOffsetAPI_MakePipe_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <BRepFill_Pipe.hxx>
#include <BRepPrimAPI_MakeSweep.hxx>
#include <GeomFill_Trihedron.hxx>
#include <Standard_Boolean.hxx>
#include <Standard_Real.hxx>
class TopoDS_Wire;
class TopoDS_Shape;
class BRepFill_Pipe;


//! Describes functions to build pipes.
//! A pipe is built a basis shape (called the profile) along
//! a wire (called the spine) by sweeping.
//! The profile must not contain solids.
//! A MakePipe object provides a framework for:
//! - defining the construction of a pipe,
//! - implementing the construction algorithm, and
//! - consulting the result.
//! Warning
//! The MakePipe class implements pipe constructions
//! with G1 continuous spines only.
class BRepOffsetAPI_MakePipe  : public BRepPrimAPI_MakeSweep
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Constructs a pipe by sweeping the shape Profile along
  //! the wire Spine.The angle made by the spine with the profile is
  //! maintained along the length of the pipe.
  //! Warning
  //! Spine must be G1 continuous; that is, on the connection
  //! vertex of two edges of the wire, the tangent vectors on
  //! the left and on the right must have the same direction,
  //! though not necessarily the same magnitude.
  //! Exceptions
  //! Standard_DomainError if the profile is a solid or a
  //! composite solid.
  Standard_EXPORT BRepOffsetAPI_MakePipe(const TopoDS_Wire& Spine, const TopoDS_Shape& Profile);
  
  //! the same as previous but with setting of
  //! mode of sweep and the flag that indicates attempt
  //! to approximate a C1-continuous surface if a swept
  //! surface proved to be C0.
  Standard_EXPORT BRepOffsetAPI_MakePipe(const TopoDS_Wire& Spine, const TopoDS_Shape& Profile, const GeomFill_Trihedron aMode, const Standard_Boolean ForceApproxC1 = Standard_False);
  
  Standard_EXPORT  const  BRepFill_Pipe& Pipe()  const;
  
  //! Builds the resulting shape (redefined from MakeShape).
  Standard_EXPORT virtual   void Build() ;
  
  //! Returns the  TopoDS  Shape of the bottom of the prism.
  Standard_EXPORT   TopoDS_Shape FirstShape() ;
  
  //! Returns the TopoDS Shape of the top of the prism.
  Standard_EXPORT   TopoDS_Shape LastShape() ;
  
  Standard_EXPORT   TopoDS_Shape Generated (const TopoDS_Shape& SSpine, const TopoDS_Shape& SProfile) ;
  
  Standard_EXPORT   Standard_Real ErrorOnSurface()  const;




protected:





private:



  BRepFill_Pipe myPipe;


};







#endif // _BRepOffsetAPI_MakePipe_HeaderFile
