/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.logging.jdbc;

import java.util.ArrayList;
import java.util.Hashtable;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.turbine.services.logging.jdbc.JDBCLogger;

public class JDBCAppender
extends AppenderSkeleton {
    public static final String LOGGER_CLASS_OPTION = "logger.class";
    public static final String LOGGER_OPTION = "logger.option";
    private String loggerClass = null;
    private Hashtable loggerOptions = new Hashtable();
    private JDBCLogger logger = null;
    private ArrayList buffer = new ArrayList();
    private int bufferSize = 1;
    private boolean ready = false;

    public void finalize() {
        this.close();
        super.finalize();
    }

    public String[] getOptionStrings() {
        return new String[]{LOGGER_CLASS_OPTION, LOGGER_OPTION};
    }

    public void setOption(String option, String value) {
        option = option.trim();
        value = value.trim();
        if (option == null || value == null) {
            return;
        }
        if (option.length() == 0 || value.length() == 0) {
            return;
        }
        value = value.trim();
        if (option.equals(LOGGER_CLASS_OPTION)) {
            this.loggerClass = value;
        } else if (option.equals(LOGGER_CLASS_OPTION)) {
            String loggerOptionKey = value.substring(0, value.indexOf(":") - 1);
            String loggerOptionValue = value.substring(value.indexOf(":"));
            this.loggerOptions.put(loggerOptionKey, loggerOptionValue);
        }
    }

    public void activateOptions() {
        try {
            this.logger = (JDBCLogger)Class.forName(this.loggerClass).newInstance();
            this.logger.init(this.loggerOptions);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean requiresLayout() {
        return true;
    }

    public void close() {
        this.flushBuffer();
        this.logger.close();
        this.closed = true;
    }

    public void append(LoggingEvent event) {
        if (!this.ready && !this.isReady()) {
            this.errorHandler.error("Not ready to append!");
            return;
        }
        this.buffer.add(event);
        if (this.buffer.size() >= this.bufferSize) {
            this.flushBuffer();
        }
    }

    public void flushBuffer() {
        try {
            int size = this.buffer.size();
            if (size < 1) {
                return;
            }
            int i = 0;
            while (i < size) {
                LoggingEvent event = (LoggingEvent)this.buffer.get(i);
                this.logger.append(this.layout.format(event));
                ++i;
            }
            this.buffer.clear();
        }
        catch (Exception e) {
            this.errorHandler.error("JDBCAppender.flushBuffer(), " + e + " : " + this.logger.getErrorMsg());
            return;
        }
    }

    public boolean isReady() {
        if (this.ready) {
            return true;
        }
        this.ready = this.logger.isReady();
        if (!this.ready) {
            this.errorHandler.error(this.logger.getErrorMsg());
        }
        return this.ready;
    }
}

