# Contributing to increment-filename

First and foremost, thank you! We appreciate that you want to contribute to `increment-filename`, your time is valuable, and your contributions mean a lot to us!



Please keep in mind that increment-filename is Free and Open-Source Software, build by people like you who spend their free time creating and maintaing tools for the rest of the community to use.


## Important!

By contributing to this project, you agree that:

1. _You have authored 100% of the content_
1. _You have the necessary rights to the content_
1. _You have received the necessary permissions from your employer to make the contributions (if applicable)_
1. _The content you contribute may be provided under the Project license(s)_


## Why you should contribute

Please consider contributing to this project if any of the following is true:

- You have (or want to gain) expertise in community development, communication, or education
- You want open source communities to be more collaborative and inclusive
- You want to help lower the burden to first time contributors
- You know how to improve the quality of this project or its documentation


## Getting started

**What does "contributing" mean?**

Creating an issue is the simplest form of contributing to a project. But there are many ways to contribute, including the following:

- Adding, updating or correcting documentation
- Significantly improving code performance, quality or readability
- Making feature requests on the [issue tracker](../../issues)
- Submiting a [bug report](../../issues)
- Star the project on Github
- Tweet a simple "thank you" to the project's author (`twitter.com/@jonschlinkert`)

**Showing support for increment-filename**

Don't have time to contribute? No worries! There are other ways to show your :heart: and support (and motivate the current maintainers to keep up the great work!):

- star the [project](https://github.com/jonschlinkert/increment-filename)
- follow the [project's author on GitHub](https://github.com/jonschlinkert)
- follow the [project's author on twitter](https://twitter.com/jonschlinkert)
- connect with the [project's author on LinkedIn](https://twitter.com/jonschlinkert)
- tweet your support! `thanks for creating https://github.com/jonschlinkert/increment-filename @jonschlinkert! #nodejs #github #javascript`

If you'd like to learn more about contributing in general, please see the [Guide to Idiomatic Contributing](https://github.com/jonschlinkert/idiomatic-contributing).

## Issues

### Before creating an issue

**TLDR;**

- Make sure you're using the latest version of `increment-filename`
- Make sure the issue is in this library, and not a dependency
- Search google, [GitHub]() and [stackoverflow.com]() for solutions
- Search existing issues, open and closed, for a solution before creating a new issue
- Use [stackoverflow.com][so] if you need implementation help or have general questions

**Make sure you are using the latest version**

It's common for users to create issues before checking the version they're using, only to find that their problem has been solved in a recently published version.

**Create the issue in the appropriate repository**

Please try to determine if the issue is caused by an underlying library, and if so, create the issue there. Sometimes this is difficult to know. We only ask that you give a reasonable attempt to find out first.

**Investigate the issue**

Check to see if any existing issues (open or closed) have been created about the same thing, or something similar.

If you find an open issue about the same or similar problem, and you can shed light on the problem, please add a comment to the existing issue (pull requests are also encouraged and very much appreciated).

**Avoid creating issues for implementation help**

Help us keep the issue tracker focused on bugs and feature requests by asking implementation-related questions on [stackoverflow.com][so]. StackOverflow was created for this purpose, and both you and the person that answers your question will get reputation points for answering the question.

**Avoid creating issues to bump dependency versions**

This is a time-wasting


- **Check the readme** - oftentimes you will find notes about creating issues, and where to go depending on the type of issue.

Please check the readme to see if there is additional advice about creating issues.

### Creating an issue

Please be as descriptive as possible when creating an issue. Give us the information we need to successfully answer your question or address your issue by answering the following in your issue:

- **operating system**: what OS are you using?
- **version**: what version of `increment-filename` are you using?
- **node version**: what version of `node.js` are you using?
- **extensions (plugins, helpers, middleware etc)**: if applicable, please list any extensions you're using.
- **error messages**: please paste any error messages, with as much detail as possible, into the issue itself or a [gist](https://gist.github.com/) if you prefer.


### Closing issues

The original poster or the maintainer's of `increment-filename` may close an issue at any time. Typically, but not exclusively, issues are closed when:

- The issue is resolved
- The project's maintainers have determined the issue is out of scope
- An issue is clearly a duplicate of another issue, in which case the duplicate issue will be linked.
- A discussion has clearly run its course


## Next steps

**Tips for creating idiomatic issues**

Spending just a little extra time to review best practices and brush up on your contributing skills will, at minimum, make your issue easier to read, easier to resolve, and more likely to be found by others who have the same or similar issue in the future. At best, it will open up doors and potential career opportunities by helping you be at your best.

The following resources were hand-picked to help you be the most effective contributor you can be:

- The [Guide to Idiomatic Contributing](https://github.com/jonschlinkert/idiomatic-contributing) is a great place for newcomers to start, but there is also information for experienced contributors there.
- Take some time to learn basic markdown. We can't stress this enough. Don't start pasting code into GitHub issues before you've taken a moment to review this [markdown cheatsheet](https://gist.github.com/jonschlinkert/5854601)
- The GitHub guide to [basic markdown](https://help.github.com/articles/markdown-basics/) is another great markdown resource.
- Learn about [GitHub Flavored Markdown](https://help.github.com/articles/github-flavored-markdown/). And if you want to really go above and beyond, read [mastering markdown](https://guides.github.com/features/mastering-markdown/).

At the very least, please try to:

- Use backticks to wrap code. This ensures that it retains its formatting and isn't modified when it's rendered by GitHub, and makes the code more readable to others
- When applicable, use syntax highlighting by adding the correct language name after the first "code fence"


[so]: http://stackoverflow.com/questions/tagged/increment-filename
