package org.jboss.cache.factories;

import org.jboss.cache.factories.annotations.DefaultFactoryFor;
import org.jboss.cache.lock.LockManager;
import org.jboss.cache.lock.NodeBasedLockManager;
import org.jboss.cache.lock.PessimisticNodeBasedLockManager;

/**
 * Creates lock managers
 *
 * @author Manik Surtani (<a href="mailto:manik@jboss.org">manik@jboss.org</a>)
 * @since 2.2.0
 */
@DefaultFactoryFor(classes = LockManager.class)
public class LockManagerFactory extends EmptyConstructorFactory
{
   @Override
   @SuppressWarnings({"unchecked", "deprecation"})
   protected <T> T construct(Class<T> componentType)
   {
      if (configuration.isNodeLockingOptimistic())
      {
         return (T) super.construct(NodeBasedLockManager.class);
      }
      else
      {
         return (T) super.construct(PessimisticNodeBasedLockManager.class);
      }
   }
}
