/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.api.Benchmark;
import com.google.caliper.api.SkipThisScenarioException;
import com.google.caliper.runner.BenchmarkClass;
import com.google.caliper.runner.BenchmarkMethod;
import com.google.caliper.runner.Instrument;
import com.google.caliper.runner.InvalidBenchmarkException;
import com.google.caliper.runner.UserCodeException;
import com.google.caliper.util.ShortDuration;
import com.google.caliper.worker.MicrobenchmarkWorker;
import com.google.caliper.worker.Worker;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class MicrobenchmarkInstrument
extends Instrument {
    @Override
    public ShortDuration estimateRuntimePerTrial() {
        return ShortDuration.valueOf((String)this.options.get((Object)"maxTotalRuntime"));
    }

    @Override
    public boolean isBenchmarkMethod(Method method) {
        return Instrument.isTimeMethod(method);
    }

    @Override
    public BenchmarkMethod createBenchmarkMethod(BenchmarkClass benchmarkClass, Method method) throws InvalidBenchmarkException {
        return Instrument.createBenchmarkMethodFromTimeMethod(benchmarkClass, method);
    }

    @Override
    public void dryRun(Benchmark benchmark, BenchmarkMethod benchmarkMethod) throws UserCodeException {
        Method m = benchmarkMethod.method();
        try {
            m.invoke((Object)benchmark, 1);
        }
        catch (IllegalAccessException impossible) {
            throw new AssertionError((Object)impossible);
        }
        catch (InvocationTargetException e) {
            Throwable userException = e.getCause();
            Throwables.propagateIfInstanceOf((Throwable)userException, SkipThisScenarioException.class);
            throw new UserCodeException(userException);
        }
    }

    @Override
    public Map<String, String> workerOptions() {
        return new ImmutableMap.Builder().put((Object)"warmupNanos", (Object)this.toNanosString("warmup")).put((Object)"timingIntervalNanos", (Object)this.toNanosString("timingInterval")).put((Object)"reportedIntervals", this.options.get((Object)"reportedIntervals")).put((Object)"shortCircuitTolerance", this.options.get((Object)"shortCircuitTolerance")).put((Object)"maxTotalRuntimeNanos", (Object)this.toNanosString("maxTotalRuntime")).put((Object)"gcBeforeEach", this.options.get((Object)"gcBeforeEach")).build();
    }

    @Override
    public Class<? extends Worker> workerClass() {
        return MicrobenchmarkWorker.class;
    }

    private String toNanosString(String optionName) {
        return String.valueOf(ShortDuration.valueOf((String)this.options.get((Object)optionName)).to(TimeUnit.NANOSECONDS));
    }

    public boolean equals(Object object) {
        return object instanceof MicrobenchmarkInstrument;
    }

    public int hashCode() {
        return 1609079866;
    }

    public String toString() {
        return "micro";
    }
}

