// SPDX-License-Identifier: GPL-2.0-or-later
/*
 * wm8400.c  --  WM8400 ALSA Soc Audio driver
 *
 * Copyright 2008-11 Wolfson Microelectronics PLC.
 * Author: Mark Brown <broonie@opensource.wolfsonmicro.com>
 */

#include <linux/module.h>
#include <linux/moduleparam.h>
#include <linux/kernel.h>
#include <linux/slab.h>
#include <linux/init.h>
#include <linux/delay.h>
#include <linux/pm.h>
#include <linux/platform_device.h>
#include <linux/regulator/consumer.h>
#include <linux/mfd/wm8400-audio.h>
#include <linux/mfd/wm8400-private.h>
#include <linux/mfd/core.h>
#include <sound/core.h>
#include <sound/pcm.h>
#include <sound/pcm_params.h>
#include <sound/soc.h>
#include <sound/initval.h>
#include <sound/tlv.h>

#include "wm8400.h"

static struct regulator_bulk_data power[] = {
	{
		.supply = "I2S1VDD",
	},
	{
		.supply = "I2S2VDD",
	},
	{
		.supply = "DCVDD",
	},
	{
		.supply = "AVDD",
	},
	{
		.supply = "FLLVDD",
	},
	{
		.supply = "HPVDD",
	},
	{
		.supply = "SPKVDD",
	},
};

/* codec private data */
struct wm8400_priv {
	struct wm8400 *wm8400;
	u16 fake_register;
	unsigned int sysclk;
	unsigned int pcmclk;
	int fll_in, fll_out;
};

static void wm8400_component_reset(struct snd_soc_component *component)
{
	struct wm8400_priv *wm8400 = snd_soc_component_get_drvdata(component);

	wm8400_reset_codec_reg_cache(wm8400->wm8400);
}

static const DECLARE_TLV_DB_SCALE(in_pga_tlv, -1650, 3000, 0);

static const DECLARE_TLV_DB_SCALE(out_mix_tlv, -2100, 0, 0);

static const DECLARE_TLV_DB_SCALE(out_pga_tlv, -7300, 600, 0);

