# Open WebUI

Open WebUI provides a highly polished chat interface in your browser for LLM interaction.

This guide walks through how to connect Lemonade Server to Open WebUI and highlights some great features you can start using right away:

- **Image Uploads to Vision-Language Models (VLMs)**: Upload images for analysis and interaction with your LLM-powered VLMs.
- **Built-in Python Code Interpreter**: Run and test Python code generated by your LLM directly within the interface.
- **Live Preview for Web Development**: Preview HTML, CSS, and JavaScript code generated by your LLM using the built-in preview server.

## Demo Video

▶️ [Watch on YouTube](https://www.youtube.com/watch?v=yZs-Yzl736E)

<iframe width="560" height="315" src="https://www.youtube.com/embed/yZs-Yzl736E?si=BFfxJYSqfu0wBMEP"
title="YouTube video player" frameborder="0" allowfullscreen></iframe>

## Installing Open WebUI

1. We recommend installing Open WebUI into a dedicated Python environment using the following commands:

    ```bash
    pip install open-webui
    ```

    > Note: Open WebUI also provides a variety of other installation options, such as Docker, on [their GitHub](https://github.com/open-webui/open-webui#how-to-install-).

2. Run this command to launch the Open WebUI HTTP server:

    ```bash
    open-webui serve
    ```

3. In a browser, navigate to <http://localhost:8080/>

4. Open WebUI will ask you to create a local administrator account. You can fill any username, password, and email you like. Once you are signed in, you will see the chat interface:

    ![Open WebUI interface](https://github.com/lemonade-sdk/assets/blob/main/webui/first_launch.png?raw=true)

## Configuring Open WebUI

1. Install and run Lemonade Server. Download [here](https://github.com/lemonade-sdk/lemonade/releases/latest/download/lemonade-server-minimal.msi).

2. Add Lemonade Server as a "connection" in Open WebUI using the following steps:
    1. Click the circular user profile button in the top-right of the UI, then click Settings:
        <div align="center">
          <br><em>Opening the settings menu.</em></br>
          <img src="https://github.com/lemonade-sdk/assets/blob/main/webui/open_settings.png?raw=true" alt="Opening the settings menu" width="300"/>
        </div>
    2. Click "Connections", then click the "+" button:
        <div align="center">
          <br><em>Navigating to the connection settings.</em></br>
          <img src="https://github.com/lemonade-sdk/assets/blob/main/webui/connection_settings.png?raw=true" alt="Navigating the settings menu" width="600"/>
        </div>
    3. Fill in the URL field with `http://localhost:8000/api/v1` (unless you're using a different port), API key (this is unused but required, suggest just putting a `-`), and then click "Save".
        <div align="center">
          <br><em>Filling in the connection details for Lemonade Server.</em></br>
          <img src="https://github.com/lemonade-sdk/assets/blob/main/webui/connection_form.png?raw=true" alt="Filling in the connection form" width="600"/>
        </div>
    4. Click "Save" in the settings menu, then exit the settings menu.

3. Apply the suggested settings. These help Open WebUI to be more responsive with local LLMs.
    1. Click the user profile button again, and choose "Admin Settings".
    2. Click the "Settings" tab at the top, then "Interface" (which will be on the top or the left, depending on your window size), then disable the following:
        - Title Generation
        - Follow Up Generation
        - Tags Generation
        <div align="center">
          <br><em>Admin Settings</em></br>
          <img src="https://github.com/lemonade-sdk/assets/blob/main/webui/admin_settings.png?raw=true" alt="Admin Settings" width="600"/>
        </div>
    3. Click the "Save" button in the bottom right of the page, then return to <http://localhost:8080>.

## Using Open WebUI with Lemonade

Now that everything is configured, you are ready to interact with an LLM!

### Chat

1. Click the dropdown menu in the top-left of the interface. This will display all of the Lemonade models you have installed. Select one to proceed.
    <div align="center">
      <br><em>Model Selection</em></br>
      <img src="https://github.com/lemonade-sdk/assets/blob/main/webui/model_selection.png?raw=true" alt="Model Selection" width="600"/>
    </div>

2. Enter a message to the LLM and click send (or hit enter). The LLM will take a few seconds to load into memory and then you will see the response stream in.

    <div align="center">
      <br><em>Sending a message</em></br>
      <img src="https://github.com/lemonade-sdk/assets/blob/main/webui/sending_a_message.png?raw=true" alt="Sending a message" width="600"/>
    </div>

    <div align="center">
      <br><em>LLM response</em></br>
      <img src="https://github.com/lemonade-sdk/assets/blob/main/webui/llm_response.png?raw=true" alt="LLM response" width="600"/>
    </div>

### Vision Language Models

Vision Language Models (VLMs) can take images as part of their input.

1. Install a VLM in Lemonade by opening the Lemonade Model Manager:
    1. Open <http://localhost:8000> in your browser.
    2. Select the Model Management tab.
    3. Scroll down until you see a model with the blue `VISION` label and click the "+" button to install it.

        <div align="center">
        <br><em>Installing a VLM</em></br>
        <img src="https://github.com/lemonade-sdk/assets/blob/main/webui/install_a_vlm.png?raw=true" alt="Installing a VLM" width="600"/>
        </div>

2. Return to Open WebUI in your browser and select your VLM in the models dropdown menu.
3. Paste an image into the chat box and type a prompt or question about your image. You can also use the "+" button in the chat box to upload images.

    <div align="center">
      <br><em>VLM prompt</em></br>
      <img src="https://github.com/lemonade-sdk/assets/blob/main/webui/vlm_prompt.png?raw=true" alt="VLM prompt" width="600"/>
    </div>

    <div align="center">
      <br><em>VLM response</em></br>
      <img src="https://github.com/lemonade-sdk/assets/blob/main/webui/vlm_response.png?raw=true" alt="VLM response" width="600"/>
    </div>

### Python Coding

Open WebUI allows you to run Python code generated by an LLM directly within the interface.

> Note: only certain Python modules are enabled in Open WebUI. `matplotlib` is one of our favorites.

1. Ask the LLM to write some Python, then click the **Run** button at the top of the Python code block.

    <div align="center">
      <br><em>Ask the LLM to write Python</em></br>
      <img src="https://github.com/lemonade-sdk/assets/blob/main/webui/generate_python.png?raw=true" alt="Ask the LLM to write Python" width="600"/>
    </div>

2. If all goes well, the result of running the Python code will appear below the code block.

    <div align="center">
      <br><em>Python result</em></br>
      <img src="https://github.com/lemonade-sdk/assets/blob/main/webui/python_result.png?raw=true" alt="Python result" width="600"/>
    </div>

    > Note: LLMs often produce incorrect code, so it might take a few chat iterations to fix any bugs. Copy-pasting the Python error message is usually enough to move things along.

### HTML Rendering

Open WebUI has a built-in rendering engine for HTML, CSS, and JavaScript pages.

Smaller LLMs can produce simple pages with tasteful styling and basic interactivity, while larger LLMs can accomplish tasks like 3D rendering in 3js.

1. Ask a small LLM to write a simple HTML+CSS page. The preview may pop up automatically, but if it doesn't you can click the **Preview** button above the HTML code block:

    <div align="center">
      <br><em>HTML rendering</em></br>
      <img src="https://github.com/lemonade-sdk/assets/blob/main/webui/html_rendering.png?raw=true" alt="HTML rendering" width="600"/>
    </div>

2. Ask a large LLM to create a 3D shape using 3js.

    <div align="center">
      <br><em>3D rendering</em></br>
      <img src="https://github.com/lemonade-sdk/assets/blob/main/webui/3d_rendering.png?raw=true" alt="3D rendering" width="600"/>
    </div>

### Image Generation

Open WebUI supports [image generation](https://docs.openwebui.com/features/image-generation-and-editing/usage/) using Stable Diffusion [models](https://lemonade-server.ai/models.html) through Lemonade Server.

**Configuring Image Generation**

1. Navigate to Admin > Settings > Images in Open WebUI to configure image generation:
    1. Toggle `Image Generation` on.
    2. Choose `Standard (Open AI)` as the Image Generation Engine.
    3. Toggle `Prompt Generation` on.
    4. For `OpenAI-API-Basis-URL`, fill in `http://localhost:8000/api/v1` (unless you're using a different port).
    5. Add a character like `-` for `OpenAI-API-Key`.
    6. If you want to add more parameters, add them to the text field as JSON. For example: `{ "steps": 4, "cfg_scale": 1 }`. See available parameters at [Image Generation (Stable Diffusion CPP)](https://lemonade-server.ai/models.html).
    7. Add your model name to `Model`, e.g., `SDXL-Turbo`.
    8. Click `Save`.

**Allow Image Generation for Model**

Enable Image Generation as a capability for your model:
    1. Go to Admin > Settings > Models and choose your model.
    2. Turn on `Image Generation`. If you want start chat always with image generation, also toggle the default option.

**Option 1: Using Image Generation Switch**

To generate an image:
    1. Toggle the `Image Generation` switch in the chat on.
    2. Enter your image generation prompt.
    3. Click `Send`.

**Option 2: Native Tool-Based Generation (Agentic)**

This mode uses tool calling for image generation and is recommended for high-quality models with tool calling capabilities. Normally the models will alter and improve your prompt.

1. Configure your model for native tool calling:
    1. Go to Admin > Settings > Models and choose your model.
    2. Go to `Advanced Parameters` and toggle `Function Calling` to `Native`.

    > Note: Open WebUI recommends using native mode only for high-quality models. See [Tool Calling Modes](https://docs.openwebui.com/features/plugin/tools/#tool-calling-modes-default-vs-native) for more information. (try out >30B models like GPT-OSS-120B, GLM-4.7-Flash or Qwen-3-Next-80B-A3B)

2. The LLM will automatically call the image generation tool when appropriate based on your prompts.

## Conclusion

These are just a few of our favorite ways to try out LLMs in Open WebUI. There are a lot more features to explore, such as voice interaction and chatting with documents, so be sure to check out the [Open WebUI documentation](https://docs.openwebui.com/) and YouTube content.
