// PixbufAnimation.cs - GdkPixbufAnimation class customizations
//
// Copyright (c) 2005 Novell, Inc.
//
// This code is inserted after the automatically generated code.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the Lesser GNU General 
// Public License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this program; if not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.

namespace Gdk {

	using System;

	public partial class PixbufAnimation {

		public PixbufAnimation (System.IO.Stream stream) : base (new PixbufLoader (stream).AnimationHandle) {}

		public PixbufAnimation (System.Reflection.Assembly assembly, string resource) : base (IntPtr.Zero)
		{
			if (assembly == null)
				assembly = System.Reflection.Assembly.GetCallingAssembly ();
			Raw = new PixbufLoader (assembly, resource).AnimationHandle;
		}

		static public PixbufAnimation LoadFromResource (string resource)
		{
			return new PixbufAnimation (System.Reflection.Assembly.GetCallingAssembly (), resource);
		}
	}
}

