/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.lazy.parallel;

import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.impl.block.procedure.CountProcedure;

public abstract class AbstractBatch<T> implements Batch<T>
{
    public int count(Predicate<? super T> predicate)
    {
        CountProcedure<T> procedure = new CountProcedure<T>(predicate);
        this.forEach(procedure);
        return procedure.getCount();
    }

    public String makeString(final String separator)
    {
        final StringBuilder stringBuilder = new StringBuilder();
        this.forEach(new Procedure<T>()
        {
            public void value(T each)
            {
                if (stringBuilder.length() != 0)
                {
                    stringBuilder.append(separator);
                }
                stringBuilder.append(each);
            }
        });
        return stringBuilder.toString();
    }
}
