#!/usr/local/bin/perl56 -I/usr/local/lib/metaps/perl
use Data::Dumper;
use metdb qw(prod);

use metdb::grib_parameters;


my @x = metdb::grib_parameters->all_fields;
print Dumper(\@x);
my $last;

foreach my $p ( metdb::grib_parameters->find(
	{ },
	[qw(grib_originating_centre grib_code_table grib_parameter)]))
{
	my ($centre,$table)     = ($p->get_grib_originating_centre,$p->get_grib_code_table);
	my ($param,$abbr,$name,$unit) = ($p->get_grib_parameter, $p->get_mars_abbreviation,$p->get_long_name,$p->get_unit);

	$abbr = "-" unless($abbr);

	my $file = "2.$centre.$table.table";
	if($file ne $last)
	{
		#system("p4 edit $file");
		open(OUT,">$file") or die "$file: $!";
		print OUT "# This file was automatically generated by $0\n";
		#system("p4 add $file");
		$last = $file;
	}

	print OUT join(" ",$param,lc($abbr),$name,"($unit)"), "\n";
}


__END__
'grib_originating_centre',
'grib_code_table',
'grib_parameter',
'mars_abbreviation',
'long_name',
'description',
'web_title',
'unit',
'comment',
'parameter_type',
'wind_corresponding_parameter',
'netcdf_name',
'netcdf_cf_approved',
'magics_abbreviated_text',
'magics_title',
'magics_offset',
'magics_factor',
'magics_scaled_unit',
'magics_contour_interval',
'magics_specification_group',
'magics_comment',
'dissemination_accuracy',
'dissemination',
'insert_date',
'update_date'

