// Package storagedatalake implements the Azure ARM Storagedatalake service API version 2019-10-31.
//
// Azure Data Lake Storage provides storage for Hadoop and other big data workloads.
package storagedatalake

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
)

const (
	// DefaultDNSSuffix is the default value for dns suffix
	DefaultDNSSuffix = "dfs.core.windows.net"
)

// BaseClient is the base client for Storagedatalake.
type BaseClient struct {
	autorest.Client
	XMsVersion  string
	AccountName string
	DNSSuffix   string
}

// New creates an instance of the BaseClient client.
func New(xMsVersion string, accountName string) BaseClient {
	return NewWithoutDefaults(xMsVersion, accountName, DefaultDNSSuffix)
}

// NewWithoutDefaults creates an instance of the BaseClient client.
func NewWithoutDefaults(xMsVersion string, accountName string, dNSSuffix string) BaseClient {
	return BaseClient{
		Client:      autorest.NewClientWithUserAgent(UserAgent()),
		XMsVersion:  xMsVersion,
		AccountName: accountName,
		DNSSuffix:   dNSSuffix,
	}
}
