package delegatednetwork

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ActionType enumerates the values for action type.
type ActionType string

const (
	// ActionTypeInternal ...
	ActionTypeInternal ActionType = "Internal"
)

// PossibleActionTypeValues returns an array of possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{ActionTypeInternal}
}

// ControllerState enumerates the values for controller state.
type ControllerState string

const (
	// ControllerStateDeleting ...
	ControllerStateDeleting ControllerState = "Deleting"
	// ControllerStateFailed ...
	ControllerStateFailed ControllerState = "Failed"
	// ControllerStateProvisioning ...
	ControllerStateProvisioning ControllerState = "Provisioning"
	// ControllerStateSucceeded ...
	ControllerStateSucceeded ControllerState = "Succeeded"
)

// PossibleControllerStateValues returns an array of possible values for the ControllerState const type.
func PossibleControllerStateValues() []ControllerState {
	return []ControllerState{ControllerStateDeleting, ControllerStateFailed, ControllerStateProvisioning, ControllerStateSucceeded}
}

// DelegatedSubnetState enumerates the values for delegated subnet state.
type DelegatedSubnetState string

const (
	// DelegatedSubnetStateDeleting ...
	DelegatedSubnetStateDeleting DelegatedSubnetState = "Deleting"
	// DelegatedSubnetStateFailed ...
	DelegatedSubnetStateFailed DelegatedSubnetState = "Failed"
	// DelegatedSubnetStateProvisioning ...
	DelegatedSubnetStateProvisioning DelegatedSubnetState = "Provisioning"
	// DelegatedSubnetStateSucceeded ...
	DelegatedSubnetStateSucceeded DelegatedSubnetState = "Succeeded"
)

// PossibleDelegatedSubnetStateValues returns an array of possible values for the DelegatedSubnetState const type.
func PossibleDelegatedSubnetStateValues() []DelegatedSubnetState {
	return []DelegatedSubnetState{DelegatedSubnetStateDeleting, DelegatedSubnetStateFailed, DelegatedSubnetStateProvisioning, DelegatedSubnetStateSucceeded}
}

// OrchestratorInstanceState enumerates the values for orchestrator instance state.
type OrchestratorInstanceState string

const (
	// OrchestratorInstanceStateDeleting ...
	OrchestratorInstanceStateDeleting OrchestratorInstanceState = "Deleting"
	// OrchestratorInstanceStateFailed ...
	OrchestratorInstanceStateFailed OrchestratorInstanceState = "Failed"
	// OrchestratorInstanceStateProvisioning ...
	OrchestratorInstanceStateProvisioning OrchestratorInstanceState = "Provisioning"
	// OrchestratorInstanceStateSucceeded ...
	OrchestratorInstanceStateSucceeded OrchestratorInstanceState = "Succeeded"
)

// PossibleOrchestratorInstanceStateValues returns an array of possible values for the OrchestratorInstanceState const type.
func PossibleOrchestratorInstanceStateValues() []OrchestratorInstanceState {
	return []OrchestratorInstanceState{OrchestratorInstanceStateDeleting, OrchestratorInstanceStateFailed, OrchestratorInstanceStateProvisioning, OrchestratorInstanceStateSucceeded}
}

// Origin enumerates the values for origin.
type Origin string

const (
	// OriginSystem ...
	OriginSystem Origin = "system"
	// OriginUser ...
	OriginUser Origin = "user"
	// OriginUsersystem ...
	OriginUsersystem Origin = "user,system"
)

// PossibleOriginValues returns an array of possible values for the Origin const type.
func PossibleOriginValues() []Origin {
	return []Origin{OriginSystem, OriginUser, OriginUsersystem}
}

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// ResourceIdentityTypeNone ...
	ResourceIdentityTypeNone ResourceIdentityType = "None"
	// ResourceIdentityTypeSystemAssigned ...
	ResourceIdentityTypeSystemAssigned ResourceIdentityType = "SystemAssigned"
)

// PossibleResourceIdentityTypeValues returns an array of possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{ResourceIdentityTypeNone, ResourceIdentityTypeSystemAssigned}
}
