/* gamepad-view.c generated by valac 0.36.12.13-3ae08, the Vala compiler
 * generated from gamepad-view.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <librsvg/rsvg.h>
#include <stdlib.h>
#include <string.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>


#define GAMES_TYPE_GAMEPAD_VIEW (games_gamepad_view_get_type ())
#define GAMES_GAMEPAD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAMEPAD_VIEW, GamesGamepadView))
#define GAMES_GAMEPAD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GAMEPAD_VIEW, GamesGamepadViewClass))
#define GAMES_IS_GAMEPAD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAMEPAD_VIEW))
#define GAMES_IS_GAMEPAD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GAMEPAD_VIEW))
#define GAMES_GAMEPAD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GAMEPAD_VIEW, GamesGamepadViewClass))

typedef struct _GamesGamepadView GamesGamepadView;
typedef struct _GamesGamepadViewClass GamesGamepadViewClass;
typedef struct _GamesGamepadViewPrivate GamesGamepadViewPrivate;

#define GAMES_TYPE_GAMEPAD_VIEW_CONFIGURATION (games_gamepad_view_configuration_get_type ())

#define GAMES_TYPE_GAMEPAD_INPUT_PATH (games_gamepad_input_path_get_type ())

#define GAMES_TYPE_GAMEPAD_INPUT (games_gamepad_input_get_type ())
typedef struct _GamesGamepadInput GamesGamepadInput;
typedef struct _GamesGamepadInputPath GamesGamepadInputPath;
typedef struct _GamesGamepadViewConfiguration GamesGamepadViewConfiguration;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GamesGamepadView {
	GtkDrawingArea parent_instance;
	GamesGamepadViewPrivate * priv;
};

struct _GamesGamepadViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _GamesGamepadInput {
	guint16 type;
	guint16 code;
};

struct _GamesGamepadInputPath {
	GamesGamepadInput input;
	gchar* path;
};

struct _GamesGamepadViewConfiguration {
	gchar* svg_path;
	GamesGamepadInputPath* input_paths;
	gint input_paths_length1;
	gint _input_paths_size_;
};

struct _GamesGamepadViewPrivate {
	RsvgHandle* handle;
	GamesGamepadViewConfiguration configuration;
	gboolean* input_highlights;
	gint input_highlights_length1;
	gint _input_highlights_size_;
};


static gpointer games_gamepad_view_parent_class = NULL;

GType games_gamepad_view_get_type (void) G_GNUC_CONST;
GType games_gamepad_view_configuration_get_type (void) G_GNUC_CONST;
GType games_gamepad_input_path_get_type (void) G_GNUC_CONST;
GType games_gamepad_input_get_type (void) G_GNUC_CONST;
GamesGamepadInput* games_gamepad_input_dup (const GamesGamepadInput* self);
void games_gamepad_input_free (GamesGamepadInput* self);
GamesGamepadInputPath* games_gamepad_input_path_dup (const GamesGamepadInputPath* self);
void games_gamepad_input_path_free (GamesGamepadInputPath* self);
void games_gamepad_input_path_copy (const GamesGamepadInputPath* self, GamesGamepadInputPath* dest);
void games_gamepad_input_path_destroy (GamesGamepadInputPath* self);
GamesGamepadViewConfiguration* games_gamepad_view_configuration_dup (const GamesGamepadViewConfiguration* self);
void games_gamepad_view_configuration_free (GamesGamepadViewConfiguration* self);
void games_gamepad_view_configuration_copy (const GamesGamepadViewConfiguration* self, GamesGamepadViewConfiguration* dest);
void games_gamepad_view_configuration_destroy (GamesGamepadViewConfiguration* self);
#define GAMES_GAMEPAD_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GAMES_TYPE_GAMEPAD_VIEW, GamesGamepadViewPrivate))
enum  {
	GAMES_GAMEPAD_VIEW_0_PROPERTY
};
#define GAMES_GAMEPAD_VIEW_DEFAULT_STATE GTK_STATE_FLAG_NORMAL
#define GAMES_GAMEPAD_VIEW_HIGHLIGHT_STATE GTK_STATE_FLAG_LINK
void games_gamepad_view_set_configuration (GamesGamepadView* self, GamesGamepadViewConfiguration* configuration, GError** error);
void games_gamepad_view_reset (GamesGamepadView* self);
gboolean games_gamepad_view_highlight (GamesGamepadView* self, GamesGamepadInput* input, gboolean highlight);
static gboolean _games_gamepad_input_equal (const GamesGamepadInput * s1, const GamesGamepadInput * s2);
static gboolean games_gamepad_view_real_draw (GtkWidget* base, cairo_t* context);
static void games_gamepad_view_calculate_image_dimensions (GamesGamepadView* self, gdouble* x, gdouble* y, gdouble* scale);
static cairo_t* games_gamepad_view_create_similar_context (GamesGamepadView* self, cairo_t* context, gdouble x, gdouble y, gdouble scale);
static void games_gamepad_view_color_gamepad (GamesGamepadView* self, cairo_t* gamepad_context, cairo_t* color_context);
static void games_gamepad_view_highlight_gamepad (GamesGamepadView* self, cairo_t* gamepad_context, cairo_t* highlight_context);
GamesGamepadView* games_gamepad_view_new (void);
GamesGamepadView* games_gamepad_view_construct (GType object_type);
static GObject * games_gamepad_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _vala_GamesGamepadInputPath_array_free (GamesGamepadInputPath * array, gint array_length);
static void games_gamepad_view_finalize (GObject * obj);


void games_gamepad_view_set_configuration (GamesGamepadView* self, GamesGamepadViewConfiguration* configuration, GError** error) {
	RsvgHandle* _tmp0_ = NULL;
	GamesGamepadViewConfiguration _tmp1_;
	const gchar* _tmp2_;
	RsvgHandle* _tmp3_;
	RsvgHandle* _tmp4_;
	RsvgHandle* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	RsvgHandle* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GamesGamepadViewConfiguration _tmp11_;
	GamesGamepadViewConfiguration _tmp12_ = {0};
	GamesGamepadViewConfiguration _tmp13_;
	GamesGamepadInputPath* _tmp14_;
	gint _tmp14__length1;
	gboolean* _tmp15_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (configuration != NULL);
	_tmp1_ = *configuration;
	_tmp2_ = _tmp1_.svg_path;
	_tmp3_ = rsvg_handle_new_from_file (_tmp2_, &_inner_error_);
	_tmp0_ = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp4_ = _tmp0_;
	_tmp0_ = NULL;
	_g_object_unref0 (self->priv->handle);
	self->priv->handle = _tmp4_;
	_tmp5_ = self->priv->handle;
	g_object_get (_tmp5_, "width", &_tmp6_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = self->priv->handle;
	g_object_get (_tmp8_, "height", &_tmp9_, NULL);
	_tmp10_ = _tmp9_;
	gtk_widget_set_size_request ((GtkWidget*) self, _tmp7_, _tmp10_);
	_tmp11_ = *configuration;
	games_gamepad_view_configuration_copy (&_tmp11_, &_tmp12_);
	games_gamepad_view_configuration_destroy (&self->priv->configuration);
	self->priv->configuration = _tmp12_;
	_tmp13_ = *configuration;
	_tmp14_ = _tmp13_.input_paths;
	_tmp14__length1 = _tmp13_.input_paths_length1;
	_tmp15_ = g_new0 (gboolean, _tmp14__length1);
	self->priv->input_highlights = (g_free (self->priv->input_highlights), NULL);
	self->priv->input_highlights = _tmp15_;
	self->priv->input_highlights_length1 = _tmp14__length1;
	self->priv->_input_highlights_size_ = self->priv->input_highlights_length1;
	games_gamepad_view_reset (self);
	_g_object_unref0 (_tmp0_);
}


void games_gamepad_view_reset (GamesGamepadView* self) {
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gboolean* _tmp3_;
				gint _tmp3__length1;
				gboolean* _tmp4_;
				gint _tmp4__length1;
				gint _tmp5_;
				gboolean _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->input_highlights;
				_tmp3__length1 = self->priv->input_highlights_length1;
				if (!(_tmp2_ < _tmp3__length1)) {
					break;
				}
				_tmp4_ = self->priv->input_highlights;
				_tmp4__length1 = self->priv->input_highlights_length1;
				_tmp5_ = i;
				_tmp4_[_tmp5_] = FALSE;
				_tmp6_ = _tmp4_[_tmp5_];
			}
		}
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static gboolean _games_gamepad_input_equal (const GamesGamepadInput * s1, const GamesGamepadInput * s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->type != s2->type) {
		return FALSE;
	}
	if (s1->code != s2->code) {
		return FALSE;
	}
	return TRUE;
}


gboolean games_gamepad_view_highlight (GamesGamepadView* self, GamesGamepadInput* input, gboolean highlight) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (input != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				GamesGamepadViewConfiguration _tmp3_;
				GamesGamepadInputPath* _tmp4_;
				gint _tmp4__length1;
				GamesGamepadViewConfiguration _tmp5_;
				GamesGamepadInputPath* _tmp6_;
				gint _tmp6__length1;
				gint _tmp7_;
				GamesGamepadInputPath _tmp8_;
				GamesGamepadInput _tmp9_;
				GamesGamepadInput _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->configuration;
				_tmp4_ = _tmp3_.input_paths;
				_tmp4__length1 = _tmp3_.input_paths_length1;
				if (!(_tmp2_ < _tmp4__length1)) {
					break;
				}
				_tmp5_ = self->priv->configuration;
				_tmp6_ = _tmp5_.input_paths;
				_tmp6__length1 = _tmp5_.input_paths_length1;
				_tmp7_ = i;
				_tmp8_ = _tmp6_[_tmp7_];
				_tmp9_ = _tmp8_.input;
				_tmp10_ = *input;
				if (_games_gamepad_input_equal (&_tmp9_, &_tmp10_) == TRUE) {
					gboolean* _tmp11_;
					gint _tmp11__length1;
					gint _tmp12_;
					gboolean _tmp13_;
					gboolean _tmp14_;
					_tmp11_ = self->priv->input_highlights;
					_tmp11__length1 = self->priv->input_highlights_length1;
					_tmp12_ = i;
					_tmp13_ = highlight;
					_tmp11_[_tmp12_] = _tmp13_;
					_tmp14_ = _tmp11_[_tmp12_];
					gtk_widget_queue_draw ((GtkWidget*) self);
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}


static gboolean games_gamepad_view_real_draw (GtkWidget* base, cairo_t* context) {
	GamesGamepadView * self;
	gboolean result = FALSE;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble scale = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	cairo_t* color_context = NULL;
	cairo_t* _tmp3_;
	cairo_t* _tmp4_;
	cairo_t* _tmp5_;
	cairo_t* highlight_context = NULL;
	cairo_t* _tmp6_;
	cairo_t* _tmp7_;
	cairo_t* _tmp8_;
	self = (GamesGamepadView*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	games_gamepad_view_calculate_image_dimensions (self, &_tmp0_, &_tmp1_, &_tmp2_);
	x = _tmp0_;
	y = _tmp1_;
	scale = _tmp2_;
	_tmp3_ = context;
	_tmp4_ = games_gamepad_view_create_similar_context (self, _tmp3_, x, y, scale);
	color_context = _tmp4_;
	_tmp5_ = context;
	games_gamepad_view_color_gamepad (self, _tmp5_, color_context);
	_tmp6_ = context;
	_tmp7_ = games_gamepad_view_create_similar_context (self, _tmp6_, x, y, scale);
	highlight_context = _tmp7_;
	_tmp8_ = context;
	games_gamepad_view_highlight_gamepad (self, _tmp8_, highlight_context);
	result = FALSE;
	_cairo_destroy0 (highlight_context);
	_cairo_destroy0 (color_context);
	return result;
}


static gpointer _cairo_surface_reference0 (gpointer self) {
	return self ? cairo_surface_reference (self) : NULL;
}


static void games_gamepad_view_color_gamepad (GamesGamepadView* self, cairo_t* gamepad_context, cairo_t* color_context) {
	cairo_surface_t* color_suface = NULL;
	cairo_t* _tmp0_;
	cairo_surface_t* _tmp1_;
	cairo_surface_t* _tmp2_;
	RsvgHandle* _tmp3_;
	cairo_t* _tmp4_;
	GdkRGBA color = {0};
	GtkStyleContext* _tmp5_;
	GdkRGBA _tmp6_ = {0};
	cairo_t* _tmp7_;
	GdkRGBA _tmp8_;
	gdouble _tmp9_;
	GdkRGBA _tmp10_;
	gdouble _tmp11_;
	GdkRGBA _tmp12_;
	gdouble _tmp13_;
	GdkRGBA _tmp14_;
	gdouble _tmp15_;
	cairo_t* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gamepad_context != NULL);
	g_return_if_fail (color_context != NULL);
	_tmp0_ = color_context;
	_tmp1_ = cairo_get_target (_tmp0_);
	_tmp2_ = _cairo_surface_reference0 (_tmp1_);
	color_suface = _tmp2_;
	_tmp3_ = self->priv->handle;
	_tmp4_ = color_context;
	rsvg_handle_render_cairo (_tmp3_, _tmp4_);
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_get_color (_tmp5_, GAMES_GAMEPAD_VIEW_DEFAULT_STATE, &_tmp6_);
	color = _tmp6_;
	_tmp7_ = gamepad_context;
	_tmp8_ = color;
	_tmp9_ = _tmp8_.red;
	_tmp10_ = color;
	_tmp11_ = _tmp10_.green;
	_tmp12_ = color;
	_tmp13_ = _tmp12_.blue;
	_tmp14_ = color;
	_tmp15_ = _tmp14_.alpha;
	cairo_set_source_rgba (_tmp7_, _tmp9_, _tmp11_, _tmp13_, _tmp15_);
	_tmp16_ = gamepad_context;
	cairo_mask_surface (_tmp16_, color_suface, (gdouble) 0, (gdouble) 0);
	_cairo_surface_destroy0 (color_suface);
}


static void games_gamepad_view_highlight_gamepad (GamesGamepadView* self, cairo_t* gamepad_context, cairo_t* highlight_context) {
	cairo_surface_t* highlight_suface = NULL;
	cairo_t* _tmp0_;
	cairo_surface_t* _tmp1_;
	cairo_surface_t* _tmp2_;
	GdkRGBA color = {0};
	GtkStyleContext* _tmp20_;
	GdkRGBA _tmp21_ = {0};
	cairo_t* _tmp22_;
	GdkRGBA _tmp23_;
	gdouble _tmp24_;
	GdkRGBA _tmp25_;
	gdouble _tmp26_;
	GdkRGBA _tmp27_;
	gdouble _tmp28_;
	GdkRGBA _tmp29_;
	gdouble _tmp30_;
	cairo_t* _tmp31_;
	cairo_surface_t* _tmp32_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gamepad_context != NULL);
	g_return_if_fail (highlight_context != NULL);
	_tmp0_ = highlight_context;
	_tmp1_ = cairo_get_target (_tmp0_);
	_tmp2_ = _cairo_surface_reference0 (_tmp1_);
	highlight_suface = _tmp2_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				GamesGamepadViewConfiguration _tmp6_;
				GamesGamepadInputPath* _tmp7_;
				gint _tmp7__length1;
				gboolean* _tmp8_;
				gint _tmp8__length1;
				gint _tmp9_;
				gboolean _tmp10_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = self->priv->configuration;
				_tmp7_ = _tmp6_.input_paths;
				_tmp7__length1 = _tmp6_.input_paths_length1;
				if (!(_tmp5_ < _tmp7__length1)) {
					break;
				}
				_tmp8_ = self->priv->input_highlights;
				_tmp8__length1 = self->priv->input_highlights_length1;
				_tmp9_ = i;
				_tmp10_ = _tmp8_[_tmp9_];
				if (_tmp10_) {
					RsvgHandle* _tmp11_;
					cairo_t* _tmp12_;
					GamesGamepadViewConfiguration _tmp13_;
					GamesGamepadInputPath* _tmp14_;
					gint _tmp14__length1;
					gint _tmp15_;
					GamesGamepadInputPath _tmp16_;
					const gchar* _tmp17_;
					gchar* _tmp18_;
					gchar* _tmp19_;
					_tmp11_ = self->priv->handle;
					_tmp12_ = highlight_context;
					_tmp13_ = self->priv->configuration;
					_tmp14_ = _tmp13_.input_paths;
					_tmp14__length1 = _tmp13_.input_paths_length1;
					_tmp15_ = i;
					_tmp16_ = _tmp14_[_tmp15_];
					_tmp17_ = _tmp16_.path;
					_tmp18_ = g_strconcat ("#", _tmp17_, NULL);
					_tmp19_ = _tmp18_;
					rsvg_handle_render_cairo_sub (_tmp11_, _tmp12_, _tmp19_);
					_g_free0 (_tmp19_);
				}
			}
		}
	}
	_tmp20_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_get_color (_tmp20_, GAMES_GAMEPAD_VIEW_HIGHLIGHT_STATE, &_tmp21_);
	color = _tmp21_;
	_tmp22_ = gamepad_context;
	_tmp23_ = color;
	_tmp24_ = _tmp23_.red;
	_tmp25_ = color;
	_tmp26_ = _tmp25_.green;
	_tmp27_ = color;
	_tmp28_ = _tmp27_.blue;
	_tmp29_ = color;
	_tmp30_ = _tmp29_.alpha;
	cairo_set_source_rgba (_tmp22_, _tmp24_, _tmp26_, _tmp28_, _tmp30_);
	_tmp31_ = gamepad_context;
	_tmp32_ = highlight_suface;
	cairo_mask_surface (_tmp31_, _tmp32_, (gdouble) 0, (gdouble) 0);
	_cairo_surface_destroy0 (highlight_suface);
}


static cairo_t* games_gamepad_view_create_similar_context (GamesGamepadView* self, cairo_t* context, gdouble x, gdouble y, gdouble scale) {
	cairo_t* result = NULL;
	gint w = 0;
	gint _tmp0_;
	gint h = 0;
	gint _tmp1_;
	cairo_surface_t* surface = NULL;
	cairo_t* _tmp2_;
	cairo_surface_t* _tmp3_;
	cairo_surface_t* _tmp4_;
	cairo_surface_t* similar_suface = NULL;
	cairo_surface_t* _tmp5_;
	cairo_t* similar_context = NULL;
	cairo_t* _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (context != NULL, NULL);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	w = _tmp0_;
	_tmp1_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	h = _tmp1_;
	_tmp2_ = context;
	_tmp3_ = cairo_get_target (_tmp2_);
	_tmp4_ = _cairo_surface_reference0 (_tmp3_);
	surface = _tmp4_;
	_tmp5_ = cairo_surface_create_similar (surface, CAIRO_CONTENT_COLOR_ALPHA, w, h);
	similar_suface = _tmp5_;
	_tmp6_ = cairo_create (similar_suface);
	similar_context = _tmp6_;
	_tmp7_ = x;
	_tmp8_ = y;
	cairo_translate (similar_context, _tmp7_, _tmp8_);
	_tmp9_ = scale;
	_tmp10_ = scale;
	cairo_scale (similar_context, _tmp9_, _tmp10_);
	result = similar_context;
	_cairo_surface_destroy0 (similar_suface);
	_cairo_surface_destroy0 (surface);
	return result;
}


static void games_gamepad_view_calculate_image_dimensions (GamesGamepadView* self, gdouble* x, gdouble* y, gdouble* scale) {
	gdouble _vala_x = 0.0;
	gdouble _vala_y = 0.0;
	gdouble _vala_scale = 0.0;
	gdouble w = 0.0;
	gint _tmp0_;
	gdouble h = 0.0;
	gint _tmp1_;
	gdouble allocation_ratio = 0.0;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble image_ratio = 0.0;
	RsvgHandle* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	RsvgHandle* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp20_;
	RsvgHandle* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gdouble _tmp24_;
	gdouble _tmp25_;
	RsvgHandle* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	gdouble _tmp29_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	w = (gdouble) _tmp0_;
	_tmp1_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	h = (gdouble) _tmp1_;
	_tmp2_ = w;
	_tmp3_ = h;
	allocation_ratio = _tmp2_ / _tmp3_;
	_tmp4_ = self->priv->handle;
	g_object_get (_tmp4_, "width", &_tmp5_, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = self->priv->handle;
	g_object_get (_tmp7_, "height", &_tmp8_, NULL);
	_tmp9_ = _tmp8_;
	image_ratio = ((gdouble) _tmp6_) / _tmp9_;
	_tmp10_ = allocation_ratio;
	_tmp11_ = image_ratio;
	if (_tmp10_ > _tmp11_) {
		gdouble _tmp12_;
		RsvgHandle* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		_tmp12_ = h;
		_tmp13_ = self->priv->handle;
		g_object_get (_tmp13_, "height", &_tmp14_, NULL);
		_tmp15_ = _tmp14_;
		_vala_scale = _tmp12_ / _tmp15_;
	} else {
		gdouble _tmp16_;
		RsvgHandle* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		_tmp16_ = w;
		_tmp17_ = self->priv->handle;
		g_object_get (_tmp17_, "width", &_tmp18_, NULL);
		_tmp19_ = _tmp18_;
		_vala_scale = _tmp16_ / _tmp19_;
	}
	_tmp20_ = w;
	_tmp21_ = self->priv->handle;
	g_object_get (_tmp21_, "width", &_tmp22_, NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = _vala_scale;
	_vala_x = (_tmp20_ - (_tmp23_ * _tmp24_)) / 2;
	_tmp25_ = h;
	_tmp26_ = self->priv->handle;
	g_object_get (_tmp26_, "height", &_tmp27_, NULL);
	_tmp28_ = _tmp27_;
	_tmp29_ = _vala_scale;
	_vala_y = (_tmp25_ - (_tmp28_ * _tmp29_)) / 2;
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
	if (scale) {
		*scale = _vala_scale;
	}
}


GamesGamepadView* games_gamepad_view_construct (GType object_type) {
	GamesGamepadView * self = NULL;
	self = (GamesGamepadView*) g_object_new (object_type, NULL);
	return self;
}


GamesGamepadView* games_gamepad_view_new (void) {
	return games_gamepad_view_construct (GAMES_TYPE_GAMEPAD_VIEW);
}


static void _vala_GamesGamepadInputPath_array_free (GamesGamepadInputPath * array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			games_gamepad_input_path_destroy (&array[i]);
		}
	}
	g_free (array);
}


static GObject * games_gamepad_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GamesGamepadView * self;
	RsvgHandle* _tmp0_;
	gchar* _tmp1_;
	GamesGamepadInputPath* _tmp2_;
	GamesGamepadViewConfiguration _tmp3_ = {0};
	gboolean* _tmp4_;
	parent_class = G_OBJECT_CLASS (games_gamepad_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_GAMEPAD_VIEW, GamesGamepadView);
	_tmp0_ = rsvg_handle_new ();
	_g_object_unref0 (self->priv->handle);
	self->priv->handle = _tmp0_;
	_tmp1_ = g_strdup ("");
	_tmp2_ = g_new0 (GamesGamepadInputPath, 0);
	_g_free0 (_tmp3_.svg_path);
	_tmp3_.svg_path = _tmp1_;
	_tmp3_.input_paths = (_vala_GamesGamepadInputPath_array_free (_tmp3_.input_paths, _tmp3_.input_paths_length1), NULL);
	_tmp3_.input_paths = _tmp2_;
	_tmp3_.input_paths_length1 = 0;
	_tmp3_._input_paths_size_ = _tmp3_.input_paths_length1;
	games_gamepad_view_configuration_destroy (&self->priv->configuration);
	self->priv->configuration = _tmp3_;
	_tmp4_ = g_new0 (gboolean, 0);
	self->priv->input_highlights = (g_free (self->priv->input_highlights), NULL);
	self->priv->input_highlights = _tmp4_;
	self->priv->input_highlights_length1 = 0;
	self->priv->_input_highlights_size_ = self->priv->input_highlights_length1;
	return obj;
}


static void games_gamepad_view_class_init (GamesGamepadViewClass * klass) {
	games_gamepad_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamesGamepadViewPrivate));
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget *, cairo_t*)) games_gamepad_view_real_draw;
	G_OBJECT_CLASS (klass)->constructor = games_gamepad_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = games_gamepad_view_finalize;
}


static void games_gamepad_view_instance_init (GamesGamepadView * self) {
	self->priv = GAMES_GAMEPAD_VIEW_GET_PRIVATE (self);
}


static void games_gamepad_view_finalize (GObject * obj) {
	GamesGamepadView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_GAMEPAD_VIEW, GamesGamepadView);
	_g_object_unref0 (self->priv->handle);
	games_gamepad_view_configuration_destroy (&self->priv->configuration);
	self->priv->input_highlights = (g_free (self->priv->input_highlights), NULL);
	G_OBJECT_CLASS (games_gamepad_view_parent_class)->finalize (obj);
}


GType games_gamepad_view_get_type (void) {
	static volatile gsize games_gamepad_view_type_id__volatile = 0;
	if (g_once_init_enter (&games_gamepad_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GamesGamepadViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_gamepad_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesGamepadView), 0, (GInstanceInitFunc) games_gamepad_view_instance_init, NULL };
		GType games_gamepad_view_type_id;
		games_gamepad_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "GamesGamepadView", &g_define_type_info, 0);
		g_once_init_leave (&games_gamepad_view_type_id__volatile, games_gamepad_view_type_id);
	}
	return games_gamepad_view_type_id__volatile;
}



