import Test.Cabal.Prelude

-- Test that setup shows all the 'autogen-modules' warnings.
main = setupAndCabalTest $ do

        configureResult <- fails $ setup' "configure" []
        sdistResult <- fails $ setup' "sdist" []

        -- Package check messages.
        let libAutogenMsg =
                   "An 'autogen-module' is neither on 'exposed-modules' or "
                ++ "'other-modules'"
        let exeAutogenMsg =
                   "On executable 'Exe' an 'autogen-module' is not on "
                ++ "'other-modules'"
        let testAutogenMsg =
                   "On test suite 'Test' an 'autogen-module' is not on "
                ++ "'other-modules'"
        let benchAutogenMsg =
                   "On benchmark 'Bench' an 'autogen-module' is not on "
                ++ "'other-modules'"
        let pathsAutogenMsg =
                "Packages using 'cabal-version: 2.0' and the autogenerated"

        -- Asserts for the desired check messages after configure.
        assertOutputContains libAutogenMsg   configureResult
        assertOutputContains exeAutogenMsg   configureResult
        assertOutputContains testAutogenMsg  configureResult
        assertOutputContains benchAutogenMsg configureResult

        -- Asserts for the desired check messages after sdist.
        assertOutputContains "Distribution quality errors:" sdistResult
        assertOutputContains libAutogenMsg   sdistResult
        assertOutputContains exeAutogenMsg   sdistResult
        assertOutputContains testAutogenMsg  sdistResult
        assertOutputContains benchAutogenMsg sdistResult
        assertOutputContains pathsAutogenMsg sdistResult
        -- Asserts for the undesired check messages after sdist.
        assertOutputDoesNotContain "Distribution quality warnings:" sdistResult

        -- Asserts for the error messages of the modules not found.
        assertOutputContains
            "Could not find module: MyLibHelperModule with any suffix"
            sdistResult
        assertOutputContains
            "module is autogenerated it should be added to 'autogen-modules'"
            sdistResult

        return ()
