.\" @(#)$RCSfile: gfal_get_results.man,v $ $Revision: 1.7 $ $Date: 2009/09/08 13:54:58 $ CERN Remi Mollon
.\" Copyright (C) 2007 by CERN
.\" All rights reserved
.\"
.TH GFAL_GET_RESULTS 3 "$Date: 2009/09/08 13:54:58 $" GFAL "Library Functions"
.SH NAME
gfal_get_results \- Extracts the results from the 'gfal_internal' object
.SH SYNOPSIS
\fB#include "gfal_api.h"\fR
.sp
.BI "int gfal_get_results (gfal_internal gfal, gfal_filestatus **filestatuses);
.SH DESCRIPTION
.B gfal_get_results
Extracts the results of the last called GFAL function from the 
.B gfal_internal
object.

As results are part of the 
.B gfal_internal
object, you don't have to free them, they will be free with the object by the function
.IR gfal_internal_free(3) .

.TP
.I gfal
.B gfal_internal
object generated from user parameters.
.TP
.I filestatuses
pointer to a non-allocated table of
.B gfal_filestats
objects.

.TP
Results will be stored in a table of the following stuctures:

 typedef struct gfal_filestatus {
    char *surl;
    char *turl;
    int status;
    char *explanation;
    int pinlifetime;
    struct stat64 stat;
    struct gfal_filestatus_ *subpaths;
    int nbsubpaths;
    TFileLocality locality;
    char *checksumtype;
    char *checksum;
    char **spacetokens;
    int nbspacetokens;
 } gfal_filestatus;

.SH RESULT STRUCTURE MEMBERS
Keep in mind that all fields are not fulfilled by all functions!
.TP
.B char *surl
The SURLs concerned. Fulfilled by all functions.
.TP
.B char *turl
The TURL associated to the SURL in 
.BR surl .
Fulfilled by 
.IR gfal_turlsfromsurls(3) ,
.IR gfal_getstatuses(3) .
.TP
.B int status
For almost all function it corresponds to 
.I errno
values ('0' means that all is ok). But for asynchronous functions, possible values are -1, 0 and 1,
what correspond respectively to error, pending and done. Fulfilled by all functions.
.TP
.B char *explanation
Error message associated with 
.BR status .
Can be fulfilled by all functions, but only when SRMv2 interface is used.
.TP
.B int pinlifetime
Remaining pin life time for 
.BR surl .
Fulfilled by 
.IR gfal_turlsfromsurls(3) ,
.IR gfal_getstatus(3) ,
.IR gfal_bringonline(3) ,
.I gfal_prestagestatus(3)
when SRMv2 interface is used.
.TP
.B struct stat64 stat
Stat information about the 
.BR surl .
It is 
.B ONLY
fulfilled by 
.IR gfal_ls(3).
.TP
.B struct gfal_filestatus *subpaths
Information about files in the directory (if there are ones)
.BR surl .
It is 
.B ONLY
fulfilled by 
.I gfal_ls(3)
when you define 
.B srmv2_lslevels
to '1' in the 
.B gfal_request
object.
.TP
.B int nbsubpaths
Number of elements in 
.BR subpaths .
It is 
.B ONLY
fulfilled by 
.I gfal_ls(3)
when you define 
.B srmv2_lslevels
to '1' in the 
.B gfal_request
object.
.TP
.B TFileLocality locality
File locality. Possible values are:
.IR GFAL_LOCALITY_ONLINE ,
.IR GFAL_LOCALITY_NEARLINE ,
.IR GFAL_LOCALITY_ONLINE_USCOREAND_USCORENEARLINE ,
.IR GFAL_LOCALITY_LOST ,
.IR GFAL_LOCALITY_NONE ,
.IR GFAL_LOCALITY_UNAVAILABLE ,
.IR GFAL_LOCALITY_UNKNOWN .
.TP
.B char *checksumtype
Name of the checksum algorithm (for example
.B ADLER32, MD5
). It is 
.B ONLY
filled by 
.I gfal_ls(3).
.TP
.B char *checksum
The checksum value. It is 
.B ONLY
filled by 
.I gfal_ls(3).
.TP
.B char **spacetokens
The list of space tokens. Filled by  
.I gfal_prestage(3) 
when SRMv2 interface is used.
.TP
.B int nbspacetokens
Number of elements in 
.BR spacetokens .
.SH RETURN VALUE
This routine returns the number of results on a success, or -1 in case of error. In the latter case,
.B results
is defined to NULL.
.SH SEE ALSO
.BR gfal (3),
.BR gfal_request_new (3),
.BR gfal_internal_free (3),
.BR gfal_init (3),
.BR gfal_deletesurls (3),
.BR gfal_removedir (3),
.BR gfal_turlsfromsurls (3),
.BR gfal_ls (3),
.BR gfal_get (3),
.BR gfal_getstatus (3),
.BR gfal_prestage (3),
.BR gfal_prestagestatus (3),
.BR gfal_pin (3),
.BR gfal_release (3),
.BR gfal_abortrequest (3),
.BR gfal_abortfiles (3),
.BR gfal_set_xfer_done (3),
.BR gfal_set_xfer_running (3),
.BR gfal_get_ids (3),
.BR gfal_set_ids (3),
.BR gfal_get_results (3),
