// Copyright 2016 The Gemmlowp Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "test_data.h"

namespace test_data {

extern const bool is_a_transposed = true;
extern const bool is_b_transposed = false;
extern const bool is_c_transposed = false;
extern const int m = 192;
extern const int n = 256;
extern const int k = 1152;
extern const int a_offset = -84;
extern const int b_offset = 0;
extern const int c_mult_int = 3401;
extern const int c_shift = 21;
extern const int c_offset = 74980;

extern const int a_count = (m * k);
extern const int b_count = (n * k);
extern const int c_count = (m * n);

unsigned char a_data[a_count] = {
  82, 81, 82, 72, 70, 90, 88, 77, 85, 68, 
  76, 88, 77, 90, 86, 94, 88, 88, 78, 74, 
  89, 80, 75, 81, 70, 89, 81, 77, 93, 95, 
  70, 81, 109, 71, 77, 80, 80, 94, 95, 95, 
  87, 87, 77, 73, 97, 75, 91, 92, 80, 90, 
  92, 79, 162, 95, 75, 87, 99, 86, 82, 72, 
  70, 84, 85, 80, 86, 75, 79, 68, 90, 94, 
  84, 79, 81, 75, 84, 94, 91, 88, 90, 87, 
  101, 72, 84, 76, 62, 82, 80, 81, 81, 65, 
  90, 85, 83, 72, 80, 81, 85, 88, 79, 101, 
  85, 86, 81, 70, 84, 89, 79, 72, 90, 62, 
  97, 90, 70, 79, 80, 83, 78, 86, 78, 88, 
  73, 85, 71, 68, 87, 66, 65, 83, 83, 77, 
  80, 77, 68, 81, 87, 81, 88, 68, 71, 89, 
  88, 85, 88, 94, 87, 93, 75, 76, 87, 80, 
  79, 80, 73, 96, 83, 74, 87, 88, 73, 80, 
  107, 71, 80, 84, 78, 93, 93, 93, 88, 86, 
  88, 71, 96, 78, 94, 85, 78, 91, 86, 77, 
  167, 91, 77, 86, 99, 83, 85, 76, 67, 88, 
  85, 81, 83, 76, 81, 76, 89, 92, 83, 74, 
  83, 75, 86, 89, 87, 90, 92, 87, 93, 64, 
  84, 79, 66, 81, 80, 80, 82, 65, 85, 84, 
  76, 75, 81, 82, 82, 88, 83, 97, 79, 87, 
  95, 71, 90, 86, 83, 76, 89, 57, 94, 89, 
  75, 82, 84, 84, 83, 86, 85, 92, 73, 83, 
  72, 70, 89, 66, 65, 83, 83, 68, 79, 74, 
  71, 80, 90, 76, 83, 67, 75, 86, 81, 88, 
  92, 93, 86, 91, 76, 74, 81, 81, 88, 78, 
  74, 91, 82, 75, 92, 83, 74, 77, 107, 73, 
  79, 76, 76, 91, 92, 87, 88, 86, 90, 71, 
  93, 74, 86, 88, 82, 89, 90, 75, 157, 90, 
  75, 87, 94, 89, 82, 74, 70, 83, 85, 79, 
  88, 76, 79, 71, 87, 91, 87, 79, 79, 78, 
  83, 96, 90, 93, 92, 86, 101, 69, 80, 75, 
  60, 79, 83, 84, 80, 64, 85, 87, 85, 74, 
  81, 84, 84, 90, 78, 96, 86, 85, 82, 70, 
  90, 85, 80, 73, 87, 63, 90, 90, 67, 78, 
  85, 79, 87, 86, 75, 86, 72, 84, 73, 70, 
  86, 68, 67, 82, 84, 86, 80, 69, 69, 90, 
  80, 72, 88, 70, 77, 85, 82, 83, 84, 93, 
  91, 84, 77, 77, 84, 79, 78, 86, 74, 84, 
  79, 77, 86, 92, 78, 79, 105, 73, 82, 80, 
  83, 86, 91, 92, 86, 87, 80, 76, 96, 78, 
  97, 93, 78, 93, 96, 81, 169, 88, 72, 91, 
  100, 88, 79, 74, 74, 87, 81, 80, 84, 74, 
  77, 72, 83, 94, 86, 78, 84, 72, 86, 94, 
  86, 88, 82, 86, 97, 73, 82, 79, 64, 77, 
  78, 83, 79, 73, 94, 85, 82, 68, 78, 75, 
  80, 90, 85, 93, 83, 89, 94, 68, 87, 80, 
  80, 76, 93, 70, 87, 91, 75, 85, 85, 82, 
  85, 82, 84, 92, 77, 86, 70, 71, 83, 79, 
  69, 80, 83, 83, 84, 73, 64, 82, 81, 73, 
  94, 73, 75, 85, 91, 81, 88, 99, 90, 94, 
  72, 81, 88, 80, 82, 87, 77, 89, 82, 76, 
  80, 85, 82, 77, 103, 72, 82, 85, 86, 90, 
  85, 89, 90, 85, 85, 76, 94, 77, 100, 85, 
  75, 97, 92, 77, 183, 83, 76, 89, 101, 85, 
  81, 79, 70, 89, 81, 80, 79, 70, 79, 78, 
  79, 92, 83, 73, 84, 67, 86, 91, 83, 92, 
  78, 84, 90, 65, 82, 77, 68, 76, 78, 81, 
  79, 79, 95, 83, 73, 67, 81, 74, 74, 89, 
  89, 91, 74, 88, 110, 70, 90, 81, 85, 81, 
  92, 66, 82, 88, 78, 85, 88, 84, 86, 83, 
  95, 96, 77, 83, 76, 74, 86, 79, 69, 77, 
  84, 76, 85, 73, 71, 78, 84, 71, 87, 71, 
  76, 82, 81, 87, 94, 90, 89, 87, 75, 78, 
  83, 81, 89, 86, 77, 85, 83, 75, 86, 87, 
  85, 74, 102, 74, 84, 80, 82, 85, 87, 86, 
  89, 87, 81, 72, 91, 71, 92, 87, 82, 92, 
  94, 77, 162, 86, 73, 88, 93, 92, 79, 77, 
  74, 83, 81, 81, 83, 75, 83, 73, 82, 93, 
  85, 76, 81, 79, 85, 95, 88, 95, 80, 87, 
  97, 72, 79, 79, 65, 78, 85, 86, 80, 73, 
  90, 86, 84, 71, 79, 79, 80, 92, 82, 89, 
  89, 85, 93, 69, 89, 79, 83, 76, 90, 69, 
  82, 91, 72, 79, 88, 82, 87, 81, 83, 92, 
  76, 87, 73, 73, 84, 81, 72, 81, 83, 91, 
  85, 74, 76, 89, 85, 67, 84, 71, 85, 82, 
  78, 89, 91, 88, 96, 75, 81, 74, 69, 76, 
  85, 84, 74, 80, 75, 76, 91, 86, 73, 82, 
  102, 73, 81, 78, 86, 87, 92, 97, 84, 91, 
  81, 80, 96, 78, 93, 92, 81, 88, 94, 80, 
  163, 88, 68, 87, 101, 90, 76, 68, 83, 90, 
  81, 83, 83, 73, 85, 72, 81, 97, 92, 84, 
  85, 79, 84, 96, 89, 89, 84, 89, 97, 81, 
  80, 76, 63, 80, 81, 88, 81, 78, 84, 96, 
  85, 66, 75, 83, 84, 93, 84, 96, 92, 89, 
  81, 71, 82, 82, 77, 74, 91, 70, 84, 91, 
  68, 83, 81, 79, 84, 77, 74, 83, 80, 88, 
  69, 71, 82, 85, 70, 84, 85, 85, 90, 76, 
  73, 86, 81, 70, 87, 71, 84, 84, 84, 92, 
  95, 92, 98, 83, 79, 76, 78, 78, 90, 84, 
  79, 81, 80, 77, 86, 82, 76, 78, 103, 76, 
  82, 83, 92, 88, 89, 94, 84, 88, 77, 76, 
  94, 74, 95, 91, 78, 95, 93, 77, 164, 86, 
  74, 86, 101, 87, 76, 74, 83, 90, 85, 86, 
  77, 73, 89, 76, 77, 102, 83, 81, 86, 76, 
  83, 95, 88, 93, 83, 89, 90, 77, 81, 82, 
  66, 82, 80, 86, 81, 82, 87, 94, 80, 67, 
  77, 82, 77, 91, 89, 94, 92, 90, 87, 73, 
  81, 79, 78, 79, 90, 68, 81, 86, 69, 85, 
  80, 82, 85, 79, 85, 86, 79, 89, 74, 71, 
  83, 90, 72, 83, 86, 77, 91, 78, 76, 83, 
  87, 69, 83, 73, 82, 80, 78, 93, 100, 86, 
  97, 79, 77, 73, 77, 79, 89, 86, 85, 80, 
  80, 78, 89, 85, 76, 76, 103, 75, 83, 79, 
  84, 87, 90, 90, 85, 89, 71, 76, 91, 71, 
  92, 88, 83, 87, 93, 73, 159, 88, 69, 94, 
  96, 92, 73, 71, 83, 88, 81, 86, 84, 76, 
  90, 76, 80, 101, 87, 81, 80, 82, 84, 92, 
  89, 93, 84, 91, 93, 81, 76, 85, 65, 81, 
  82, 88, 83, 77, 81, 90, 85, 69, 75, 85, 
  83, 93, 83, 91, 96, 87, 83, 71, 84, 81, 
  77, 77, 91, 67, 84, 88, 68, 80, 81, 79, 
  85, 79, 76, 84, 76, 89, 72, 72, 82, 89, 
  73, 85, 78, 81, 90, 85, 58, 89, 95, 79, 
  67, 75, 82, 81, 80, 73, 85, 84, 84, 89, 
  73, 81, 73, 81, 87, 83, 81, 89, 81, 95, 
  98, 87, 108, 86, 96, 90, 82, 98, 84, 106, 
  71, 79, 99, 86, 73, 73, 80, 63, 77, 73, 
  94, 83, 73, 72, 65, 85, 73, 68, 85, 80, 
  70, 97, 100, 94, 80, 99, 79, 79, 76, 103, 
  85, 87, 92, 98, 74, 86, 89, 73, 82, 83, 
  86, 80, 69, 78, 87, 91, 81, 80, 88, 93, 
  69, 107, 81, 84, 93, 85, 71, 98, 97, 110, 
  89, 70, 78, 80, 87, 93, 89, 97, 77, 76, 
  83, 77, 83, 105, 86, 89, 94, 89, 86, 87, 
  76, 94, 87, 82, 69, 69, 73, 78, 85, 71, 
  90, 82, 77, 82, 57, 80, 92, 73, 68, 70, 
  76, 83, 83, 67, 88, 75, 86, 99, 86, 70, 
  74, 83, 88, 78, 83, 95, 81, 99, 93, 88, 
  110, 85, 92, 82, 81, 79, 79, 103, 75, 77, 
  87, 95, 78, 77, 81, 68, 74, 79, 90, 77, 
  70, 68, 68, 87, 79, 81, 82, 80, 76, 81, 
  101, 96, 73, 96, 65, 90, 77, 92, 84, 77, 
  82, 88, 77, 86, 91, 71, 76, 80, 79, 86, 
  73, 72, 84, 76, 85, 72, 88, 85, 66, 107, 
  74, 91, 98, 92, 69, 103, 100, 120, 95, 65, 
  62, 71, 85, 95, 84, 96, 76, 72, 78, 82, 
  88, 106, 82, 83, 84, 81, 76, 89, 80, 89, 
  86, 76, 71, 66, 72, 79, 93, 67, 80, 83, 
  80, 89, 65, 82, 92, 80, 70, 78, 86, 80, 
  79, 74, 85, 88, 84, 90, 75, 81, 77, 80, 
  85, 79, 86, 85, 85, 93, 92, 87, 96, 91, 
  96, 90, 89, 86, 90, 105, 76, 78, 94, 86, 
  79, 76, 85, 76, 79, 90, 96, 84, 71, 78, 
  69, 84, 77, 92, 89, 77, 77, 93, 90, 86, 
  84, 93, 92, 80, 78, 107, 85, 73, 93, 97, 
  83, 83, 90, 81, 86, 80, 76, 78, 71, 73, 
  86, 82, 86, 83, 95, 93, 73, 104, 80, 105, 
  95, 86, 93, 101, 94, 102, 87, 72, 86, 86, 
  85, 92, 88, 94, 76, 85, 85, 79, 88, 102, 
  87, 84, 76, 86, 93, 88, 81, 90, 90, 81, 
  71, 74, 72, 79, 86, 67, 79, 77, 69, 91, 
  86, 76, 86, 83, 67, 83, 89, 78, 74, 66, 
  86, 78, 63, 80, 82, 87, 88, 78, 91, 91, 
  91, 81, 93, 83, 101, 95, 90, 92, 96, 87, 
  72, 90, 103, 97, 85, 75, 104, 71, 74, 75, 
  83, 78, 81, 68, 83, 78, 68, 76, 69, 92, 
  71, 101, 89, 83, 71, 92, 78, 82, 88, 88, 
  81, 78, 82, 95, 78, 72, 114, 100, 74, 82, 
  78, 75, 93, 84, 105, 73, 78, 96, 95, 88, 
  74, 79, 92, 80, 91, 91, 72, 68, 84, 90, 
  75, 94, 87, 93, 82, 69, 82, 79, 76, 85, 
  80, 80, 86, 80, 90, 65, 71, 79, 85, 84, 
  88, 103, 83, 84, 69, 88, 90, 71, 91, 72, 
  76, 84, 82, 75, 81, 78, 71, 94, 86, 69, 
  81, 74, 69, 79, 92, 80, 70, 81, 83, 80, 
  60, 81, 86, 80, 77, 77, 82, 84, 87, 80, 
  93, 83, 97, 85, 86, 99, 95, 85, 77, 79, 
  98, 94, 71, 73, 101, 66, 83, 73, 72, 71, 
  75, 71, 79, 77, 63, 73, 72, 106, 69, 83, 
  86, 90, 63, 84, 82, 89, 87, 87, 67, 86, 
  83, 90, 84, 65, 83, 98, 80, 77, 82, 75, 
  83, 75, 94, 76, 81, 99, 88, 80, 82, 77, 
  89, 77, 78, 89, 72, 71, 79, 88, 71, 99, 
  89, 102, 79, 68, 82, 84, 75, 84, 78, 82, 
  85, 70, 88, 61, 75, 76, 79, 85, 98, 97, 
  73, 84, 72, 92, 90, 66, 102, 67, 79, 88, 
  85, 66, 78, 82, 86, 91, 87, 78, 83, 78, 
  69, 83, 90, 79, 77, 99, 86, 75, 72, 79, 
  78, 89, 73, 85, 78, 87, 85, 77, 92, 83, 
  96, 80, 89, 97, 91, 84, 87, 83, 99, 94, 
  69, 76, 99, 77, 88, 78, 85, 78, 81, 91, 
  79, 78, 67, 91, 72, 91, 72, 66, 91, 86, 
  70, 90, 75, 82, 87, 88, 87, 80, 78, 93, 
  86, 69, 71, 102, 75, 80, 83, 76, 90, 78, 
  80, 77, 77, 98, 94, 74, 87, 81, 86, 83, 
  94, 88, 73, 76, 84, 90, 74, 91, 87, 97, 
  81, 64, 82, 89, 80, 84, 79, 82, 82, 83, 
  89, 68, 80, 84, 82, 88, 93, 98, 93, 84, 
  77, 88, 89, 70, 94, 74, 77, 81, 84, 73, 
  83, 83, 85, 82, 98, 89, 75, 98, 87, 90, 
  81, 92, 89, 97, 76, 76, 75, 87, 84, 90, 
  94, 89, 94, 111, 85, 72, 100, 80, 74, 106, 
  70, 78, 95, 80, 86, 84, 94, 79, 82, 83, 
  99, 70, 76, 91, 82, 98, 94, 84, 79, 76, 
  89, 99, 84, 82, 80, 96, 106, 77, 93, 73, 
  68, 69, 79, 76, 82, 85, 88, 89, 73, 90, 
  97, 72, 97, 79, 75, 74, 89, 94, 86, 67, 
  102, 88, 102, 85, 73, 78, 85, 76, 122, 68, 
  78, 73, 80, 74, 91, 70, 66, 71, 82, 88, 
  81, 89, 83, 80, 73, 91, 91, 95, 106, 90, 
  77, 67, 93, 74, 78, 102, 101, 78, 69, 83, 
  97, 84, 89, 96, 92, 82, 73, 104, 78, 86, 
  87, 81, 95, 82, 75, 96, 86, 89, 86, 93, 
  85, 99, 75, 76, 75, 85, 81, 93, 85, 86, 
  87, 109, 86, 68, 104, 81, 67, 94, 69, 76, 
  99, 86, 98, 76, 96, 67, 82, 82, 97, 67, 
  83, 87, 75, 90, 90, 84, 81, 86, 84, 111, 
  91, 80, 75, 99, 93, 75, 89, 70, 72, 69, 
  86, 69, 84, 85, 91, 88, 71, 97, 96, 82, 
  92, 81, 74, 76, 77, 85, 94, 73, 105, 90, 
  103, 89, 73, 77, 84, 82, 127, 71, 86, 75, 
  79, 67, 86, 72, 60, 70, 75, 93, 87, 96, 
  83, 77, 71, 90, 88, 92, 106, 92, 83, 63, 
  96, 82, 85, 99, 93, 76, 63, 97, 92, 82, 
  100, 96, 94, 82, 68, 103, 79, 84, 84, 77, 
  99, 91, 76, 93, 85, 92, 81, 93, 88, 88, 
  74, 75, 79, 84, 78, 93, 74, 90, 80, 109, 
  91, 67, 101, 82, 65, 85, 71, 81, 90, 87, 
  101, 76, 93, 79, 84, 85, 96, 75, 88, 95, 
  78, 97, 91, 93, 78, 78, 86, 107, 88, 79, 
  79, 82, 96, 80, 93, 72, 67, 71, 86, 75, 
  85, 86, 83, 83, 72, 89, 85, 78, 92, 77, 
  77, 73, 84, 82, 95, 73, 100, 91, 103, 94, 
  75, 75, 77, 80, 121, 77, 74, 73, 82, 77, 
  85, 69, 69, 70, 80, 85, 84, 89, 87, 81, 
  80, 88, 88, 96, 101, 92, 85, 68, 91, 88, 
  84, 90, 96, 79, 71, 87, 82, 83, 92, 91, 
  87, 79, 77, 104, 86, 78, 84, 86, 84, 84, 
  82, 82, 93, 83, 76, 95, 99, 84, 66, 93, 
  80, 89, 84, 105, 73, 89, 74, 80, 81, 84, 
  95, 84, 95, 79, 84, 82, 83, 81, 86, 86, 
  87, 94, 115, 86, 82, 87, 91, 85, 87, 80, 
  88, 87, 75, 84, 83, 83, 83, 78, 81, 94, 
  93, 90, 86, 77, 86, 72, 87, 128, 71, 82, 
  67, 85, 77, 87, 87, 78, 88, 85, 85, 80, 
  85, 70, 75, 94, 89, 84, 86, 83, 92, 94, 
  79, 72, 86, 82, 85, 91, 82, 83, 85, 88, 
  87, 79, 87, 77, 89, 74, 89, 80, 83, 83, 
  86, 85, 83, 79, 86, 73, 90, 86, 79, 85, 
  74, 76, 85, 93, 86, 87, 83, 81, 82, 87, 
  84, 75, 84, 76, 85, 78, 86, 71, 81, 70, 
  91, 89, 85, 99, 87, 80, 68, 81, 81, 85, 
  87, 82, 79, 89, 81, 86, 80, 73, 83, 82, 
  74, 82, 75, 84, 91, 82, 80, 94, 71, 84, 
  86, 71, 70, 88, 75, 86, 79, 78, 91, 85, 
  81, 90, 88, 78, 85, 71, 80, 78, 99, 81, 
  88, 77, 83, 66, 74, 128, 71, 62, 73, 105, 
  69, 91, 89, 98, 86, 81, 84, 84, 92, 88, 
  70, 100, 89, 79, 85, 88, 85, 81, 70, 96, 
  77, 83, 79, 78, 80, 76, 86, 80, 83, 79, 
  86, 78, 91, 101, 91, 80, 70, 79, 81, 88, 
  89, 88, 90, 79, 87, 76, 82, 84, 72, 79, 
  86, 85, 75, 80, 73, 79, 100, 74, 84, 73, 
  88, 73, 91, 89, 94, 74, 80, 86, 85, 84, 
  74, 91, 78, 95, 63, 91, 80, 89, 85, 86, 
  94, 89, 88, 84, 80, 80, 92, 84, 92, 84, 
  87, 79, 88, 93, 74, 82, 77, 100, 75, 88, 
  85, 81, 75, 88, 84, 95, 88, 76, 82, 77, 
  88, 83, 86, 74, 81, 89, 90, 83, 84, 80, 
  85, 77, 86, 113, 75, 77, 68, 89, 79, 83, 
  81, 69, 85, 85, 86, 89, 82, 94, 82, 93, 
  85, 88, 86, 91, 87, 88, 98, 74, 83, 83, 
  87, 96, 87, 80, 104, 86, 85, 77, 82, 79, 
  91, 72, 86, 82, 90, 83, 91, 86, 90, 80, 
  100, 75, 92, 87, 93, 83, 81, 72, 80, 89, 
  87, 85, 86, 82, 83, 92, 85, 81, 72, 78, 
  82, 89, 74, 93, 69, 80, 88, 77, 66, 93, 
  73, 91, 65, 92, 79, 99, 79, 109, 71, 66, 
  94, 75, 72, 80, 96, 85, 103, 83, 67, 92, 
  91, 73, 86, 94, 74, 87, 75, 69, 79, 43, 
  88, 81, 77, 96, 84, 86, 73, 82, 89, 79, 
  81, 70, 78, 76, 88, 71, 85, 77, 79, 84, 
  92, 62, 79, 44, 62, 75, 87, 98, 86, 64, 
  89, 92, 87, 69, 78, 82, 81, 80, 82, 77, 
  81, 108, 68, 90, 85, 68, 81, 87, 90, 93, 
  77, 73, 95, 82, 82, 66, 74, 69, 86, 83, 
  77, 85, 86, 79, 87, 85, 69, 74, 85, 80, 
  84, 93, 71, 72, 91, 69, 60, 91, 83, 80, 
  73, 71, 72, 95, 79, 75, 98, 89, 76, 80, 
  82, 42, 93, 68, 82, 95, 99, 111, 111, 93, 
  78, 79, 87, 65, 94, 68, 69, 101, 55, 102, 
  91, 83, 71, 88, 72, 96, 107, 83, 92, 109, 
  91, 76, 87, 87, 129, 64, 92, 155, 72, 81, 
  96, 57, 96, 88, 96, 101, 81, 83, 85, 64, 
  97, 97, 103, 97, 92, 76, 96, 84, 65, 255, 
  39, 112, 73, 95, 88, 68, 73, 120, 59, 90, 
  76, 78, 102, 74, 66, 111, 96, 83, 97, 60, 
  122, 92, 30, 108, 81, 73, 82, 59, 94, 102, 
  68, 89, 84, 85, 98, 81, 70, 87, 110, 79, 
  69, 80, 79, 88, 96, 93, 106, 84, 88, 32, 
  86, 94, 60, 92, 117, 96, 55, 86, 90, 90, 
  105, 61, 93, 90, 76, 76, 92, 90, 80, 97, 
  68, 85, 82, 76, 64, 90, 66, 87, 66, 96, 
  85, 99, 81, 85, 94, 62, 94, 81, 74, 77, 
  88, 81, 104, 91, 70, 79, 93, 83, 76, 84, 
  66, 92, 71, 70, 79, 56, 79, 86, 78, 93, 
  83, 85, 80, 77, 89, 72, 82, 70, 81, 88, 
  81, 70, 84, 82, 82, 81, 90, 62, 71, 50, 
  61, 86, 91, 85, 85, 66, 87, 90, 86, 75, 
  79, 103, 83, 83, 81, 75, 76, 89, 72, 82, 
  90, 70, 74, 81, 90, 105, 82, 74, 108, 81, 
  82, 68, 78, 73, 89, 84, 80, 86, 92, 83, 
  89, 88, 77, 79, 87, 81, 91, 84, 75, 87, 
  95, 68, 67, 88, 88, 81, 82, 72, 76, 96, 
  81, 82, 84, 77, 70, 89, 97, 86, 76, 84, 
  88, 82, 73, 90, 79, 98, 69, 90, 78, 95, 
  95, 107, 75, 91, 91, 80, 83, 87, 91, 88, 
  96, 79, 86, 90, 89, 76, 72, 88, 69, 88, 
  77, 85, 83, 78, 78, 79, 82, 89, 89, 84, 
  87, 81, 88, 87, 85, 76, 86, 80, 92, 83, 
  85, 80, 77, 76, 92, 109, 91, 76, 73, 86, 
  86, 90, 82, 77, 81, 87, 91, 81, 83, 87, 
  80, 91, 84, 71, 89, 93, 83, 86, 79, 74, 
  88, 81, 88, 87, 82, 85, 91, 84, 86, 79, 
  78, 74, 78, 88, 82, 86, 94, 78, 101, 86, 
  81, 85, 90, 71, 92, 89, 84, 82, 82, 77, 
  79, 85, 86, 86, 83, 78, 80, 92, 83, 80, 
  83, 76, 86, 87, 94, 72, 78, 70, 82, 85, 
  86, 97, 89, 85, 64, 85, 76, 83, 89, 92, 
  74, 73, 81, 96, 78, 72, 87, 88, 66, 85, 
  74, 84, 88, 95, 76, 84, 83, 76, 87, 70, 
  92, 94, 74, 80, 79, 74, 91, 76, 88, 91, 
  86, 86, 83, 66, 92, 76, 93, 81, 73, 80, 
  92, 71, 80, 145, 76, 66, 72, 91, 82, 81, 
  87, 103, 69, 92, 79, 82, 92, 85, 83, 104, 
  91, 78, 90, 87, 81, 90, 62, 92, 78, 72, 
  95, 76, 89, 90, 79, 86, 82, 82, 78, 79, 
  77, 86, 87, 82, 75, 74, 90, 88, 71, 90, 
  86, 73, 84, 69, 77, 75, 79, 84, 89, 95, 
  74, 80, 74, 82, 98, 76, 81, 79, 86, 92, 
  77, 92, 95, 87, 75, 82, 86, 81, 73, 91, 
  80, 85, 68, 91, 85, 95, 92, 93, 84, 78, 
  87, 86, 81, 83, 90, 88, 92, 83, 76, 83, 
  88, 87, 71, 79, 62, 84, 96, 83, 88, 83, 
  78, 86, 82, 83, 86, 79, 87, 82, 88, 86, 
  83, 79, 88, 90, 88, 82, 82, 83, 83, 77, 
  88, 108, 82, 71, 65, 92, 87, 87, 81, 82, 
  81, 88, 88, 85, 79, 88, 85, 93, 86, 72, 
  86, 87, 89, 84, 86, 73, 83, 82, 93, 101, 
  82, 88, 94, 81, 85, 77, 92, 77, 79, 93, 
  86, 86, 98, 77, 99, 93, 84, 84, 79, 74, 
  95, 75, 75, 83, 98, 75, 84, 83, 80, 84, 
  88, 79, 82, 87, 83, 80, 101, 80, 92, 98, 
  85, 82, 69, 77, 84, 81, 77, 90, 84, 109, 
  86, 71, 97, 82, 101, 82, 89, 92, 102, 80, 
  94, 66, 97, 79, 100, 88, 89, 81, 92, 64, 
  82, 92, 79, 67, 100, 76, 88, 76, 79, 86, 
  79, 97, 83, 84, 74, 82, 102, 84, 85, 97, 
  107, 100, 92, 55, 77, 95, 78, 91, 98, 95, 
  62, 92, 72, 97, 86, 55, 98, 76, 102, 87, 
  86, 78, 96, 95, 90, 80, 91, 78, 107, 85, 
  89, 82, 99, 69, 89, 86, 49, 84, 78, 87, 
  96, 71, 90, 89, 98, 64, 66, 85, 58, 85, 
  83, 100, 95, 80, 66, 73, 85, 101, 69, 88, 
  98, 112, 89, 70, 91, 88, 96, 83, 83, 73, 
  90, 85, 112, 84, 102, 87, 79, 93, 83, 95, 
  66, 80, 80, 79, 74, 94, 81, 100, 86, 66, 
  108, 86, 113, 80, 74, 103, 77, 72, 111, 66, 
  97, 73, 110, 94, 90, 91, 99, 73, 89, 91, 
  74, 59, 107, 73, 78, 78, 93, 91, 76, 100, 
  90, 88, 72, 75, 98, 88, 85, 102, 95, 86, 
  93, 54, 80, 88, 88, 93, 99, 85, 50, 93, 
  66, 96, 90, 61, 98, 74, 98, 78, 75, 73, 
  96, 78, 82, 80, 89, 79, 123, 109, 91, 74, 
  86, 73, 82, 91, 51, 83, 82, 85, 94, 73, 
  85, 93, 77, 65, 68, 85, 54, 93, 69, 98, 
  101, 78, 70, 66, 81, 102, 73, 97, 97, 102, 
  105, 62, 88, 82, 89, 88, 78, 73, 81, 83, 
  118, 82, 71, 92, 89, 87, 73, 93, 78, 82, 
  81, 86, 73, 88, 88, 87, 92, 83, 86, 79, 
  88, 87, 80, 80, 80, 102, 91, 86, 74, 92, 
  91, 93, 83, 75, 81, 91, 81, 92, 84, 89, 
  96, 86, 83, 84, 87, 81, 84, 86, 77, 98, 
  101, 80, 88, 90, 77, 76, 86, 82, 79, 71, 
  73, 89, 84, 84, 90, 67, 67, 83, 74, 83, 
  87, 85, 95, 83, 86, 89, 90, 83, 85, 73, 
  85, 82, 82, 80, 86, 98, 84, 74, 77, 88, 
  85, 89, 82, 88, 91, 92, 81, 84, 85, 85, 
  75, 79, 91, 100, 85, 85, 107, 89, 81, 84, 
  72, 69, 92, 81, 77, 96, 98, 88, 99, 90, 
  83, 80, 81, 85, 71, 87, 94, 83, 89, 86, 
  89, 82, 71, 75, 86, 77, 67, 87, 87, 83, 
  65, 83, 73, 91, 83, 78, 85, 74, 84, 77, 
  71, 86, 77, 91, 86, 79, 92, 92, 82, 91, 
  81, 79, 88, 69, 92, 84, 89, 61, 90, 83, 
  83, 67, 76, 71, 57, 73, 82, 76, 83, 82, 
  96, 86, 91, 87, 90, 103, 86, 68, 75, 95, 
  71, 79, 100, 89, 58, 85, 72, 88, 96, 66, 
  98, 96, 95, 77, 90, 85, 86, 90, 103, 76, 
  91, 75, 100, 83, 98, 74, 93, 81, 82, 82, 
  68, 75, 78, 78, 84, 71, 82, 83, 94, 72, 
  73, 91, 74, 79, 99, 93, 79, 81, 70, 71, 
  67, 95, 82, 79, 101, 89, 79, 77, 95, 76, 
  82, 84, 73, 91, 82, 79, 94, 80, 90, 77, 
  81, 75, 82, 70, 67, 87, 80, 76, 66, 83, 
  72, 97, 86, 73, 86, 79, 79, 77, 67, 90, 
  79, 84, 99, 77, 85, 86, 94, 108, 87, 79, 
  89, 72, 90, 79, 86, 54, 91, 79, 80, 65, 
  73, 79, 52, 74, 87, 86, 84, 81, 88, 90, 
  89, 83, 79, 83, 84, 69, 83, 86, 77, 82, 
  95, 82, 50, 83, 77, 86, 94, 70, 80, 92, 
  89, 72, 86, 79, 87, 80, 92, 68, 89, 78, 
  97, 95, 101, 83, 77, 85, 82, 79, 65, 73, 
  82, 77, 74, 73, 78, 87, 77, 74, 76, 79, 
  73, 83, 92, 95, 80, 82, 69, 72, 68, 95, 
  87, 86, 109, 88, 92, 75, 91, 73, 83, 89, 
  70, 91, 79, 83, 95, 80, 72, 80, 89, 82, 
  79, 79, 84, 78, 85, 77, 72, 82, 80, 83, 
  92, 89, 77, 77, 79, 83, 86, 83, 86, 108, 
  92, 88, 75, 95, 75, 84, 82, 75, 81, 88, 
  79, 82, 85, 87, 87, 100, 80, 82, 76, 83, 
  77, 77, 79, 91, 101, 85, 84, 84, 86, 72, 
  82, 78, 78, 87, 71, 78, 84, 82, 89, 65, 
  72, 83, 91, 68, 87, 83, 77, 82, 83, 83, 
  88, 81, 85, 79, 73, 82, 89, 75, 82, 83, 
  79, 77, 68, 87, 86, 77, 90, 75, 83, 77, 
  75, 85, 81, 80, 74, 86, 82, 79, 90, 79, 
  108, 89, 70, 88, 83, 79, 87, 80, 84, 85, 
  103, 85, 89, 90, 79, 81, 82, 83, 85, 87, 
  95, 80, 82, 89, 84, 83, 76, 73, 89, 85, 
  85, 80, 89, 79, 76, 81, 84, 85, 84, 84, 
  74, 81, 83, 81, 84, 79, 85, 109, 83, 90, 
  78, 103, 88, 89, 86, 78, 80, 85, 86, 79, 
  90, 80, 87, 92, 91, 75, 82, 71, 81, 73, 
  91, 83, 93, 91, 90, 83, 79, 71, 87, 93, 
  82, 85, 70, 79, 83, 76, 93, 81, 63, 83, 
  86, 74, 87, 80, 96, 85, 91, 83, 98, 85, 
  86, 83, 84, 76, 85, 75, 81, 88, 91, 78, 
  79, 93, 78, 78, 85, 79, 77, 74, 84, 81, 
  84, 81, 90, 82, 78, 95, 90, 81, 107, 81, 
  67, 91, 87, 80, 89, 84, 87, 80, 95, 87, 
  85, 99, 88, 87, 79, 83, 78, 89, 84, 79, 
  84, 94, 84, 79, 85, 78, 85, 77, 90, 81, 
  87, 76, 78, 86, 80, 88, 92, 84, 75, 81, 
  79, 89, 84, 76, 85, 102, 89, 90, 81, 98, 
  89, 89, 87, 81, 82, 84, 86, 72, 89, 74, 
  85, 89, 87, 77, 82, 78, 78, 69, 88, 82, 
  94, 90, 88, 82, 81, 68, 84, 90, 81, 84, 
  77, 78, 83, 78, 91, 80, 69, 86, 91, 72, 
  84, 82, 75, 82, 90, 82, 100, 78, 86, 81, 
  84, 72, 88, 80, 77, 84, 91, 83, 80, 91, 
  80, 74, 81, 79, 83, 76, 77, 82, 86, 84, 
  84, 84, 81, 94, 93, 83, 111, 82, 70, 94, 
  91, 80, 93, 81, 91, 76, 95, 81, 87, 96, 
  83, 87, 84, 85, 83, 90, 83, 82, 86, 92, 
  76, 75, 85, 88, 83, 86, 91, 76, 90, 75, 
  84, 92, 87, 81, 85, 87, 76, 84, 90, 86, 
  89, 86, 85, 107, 87, 88, 79, 92, 75, 78, 
  83, 82, 84, 85, 87, 79, 83, 87, 84, 96, 
  84, 85, 90, 85, 90, 82, 82, 84, 87, 88, 
  85, 84, 77, 75, 89, 80, 83, 90, 81, 82, 
  90, 89, 86, 81, 89, 89, 87, 78, 84, 87, 
  78, 78, 95, 79, 95, 81, 83, 82, 79, 84, 
  83, 79, 83, 82, 84, 74, 80, 89, 76, 75, 
  91, 76, 89, 81, 79, 84, 85, 82, 88, 91, 
  91, 93, 84, 81, 91, 88, 78, 94, 86, 83, 
  95, 86, 84, 80, 91, 84, 88, 98, 84, 87, 
  84, 83, 81, 82, 89, 77, 77, 90, 80, 79, 
  78, 82, 112, 83, 77, 68, 81, 96, 88, 87, 
  81, 87, 83, 70, 72, 75, 67, 88, 87, 82, 
  74, 88, 94, 97, 83, 80, 86, 97, 74, 76, 
  80, 88, 71, 70, 74, 79, 86, 104, 88, 94, 
  76, 99, 79, 91, 77, 78, 64, 77, 87, 75, 
  84, 97, 86, 82, 79, 95, 69, 87, 71, 89, 
  75, 87, 100, 82, 77, 73, 84, 96, 80, 86, 
  86, 76, 70, 84, 82, 65, 76, 107, 65, 85, 
  90, 83, 95, 74, 89, 88, 90, 67, 74, 88, 
  78, 81, 79, 115, 75, 93, 89, 86, 92, 85, 
  90, 80, 85, 81, 78, 80, 94, 77, 77, 84, 
  93, 86, 97, 84, 95, 85, 78, 78, 81, 81, 
  86, 92, 84, 84, 80, 82, 77, 89, 79, 84, 
  116, 75, 88, 74, 79, 98, 82, 83, 78, 88, 
  88, 68, 72, 79, 69, 94, 77, 78, 73, 92, 
  92, 97, 87, 82, 90, 87, 78, 69, 79, 78, 
  75, 77, 82, 76, 86, 103, 88, 101, 81, 96, 
  82, 82, 76, 69, 66, 77, 93, 66, 86, 90, 
  87, 87, 83, 86, 64, 90, 71, 94, 79, 89, 
  89, 79, 70, 71, 83, 94, 81, 91, 88, 81, 
  76, 80, 79, 65, 85, 101, 65, 88, 96, 74, 
  112, 75, 82, 88, 92, 61, 79, 88, 74, 80, 
  71, 118, 71, 87, 84, 86, 88, 78, 86, 81, 
  76, 80, 78, 80, 93, 76, 90, 92, 94, 86, 
  95, 81, 73, 87, 74, 83, 75, 75, 83, 92, 
  75, 83, 79, 77, 81, 97, 84, 83, 110, 75, 
  79, 74, 83, 95, 87, 87, 79, 94, 79, 72, 
  72, 78, 72, 101, 77, 86, 87, 85, 97, 98, 
  85, 78, 85, 74, 76, 75, 80, 69, 86, 86, 
  77, 78, 94, 102, 86, 91, 85, 93, 80, 90, 
  74, 67, 65, 76, 86, 69, 82, 96, 88, 90, 
  80, 95, 72, 81, 74, 91, 76, 89, 99, 80, 
  74, 74, 89, 95, 84, 89, 92, 79, 78, 85, 
  83, 74, 79, 109, 64, 85, 90, 77, 90, 82, 
  84, 88, 85, 74, 78, 88, 82, 84, 69, 113, 
  74, 92, 88, 93, 95, 93, 85, 78, 87, 82, 
  81, 77, 91, 76, 81, 84, 91, 90, 89, 83, 
  71, 86, 77, 82, 78, 83, 80, 92, 84, 80, 
  79, 82, 79, 74, 71, 78, 101, 91, 82, 69, 
  80, 92, 94, 81, 87, 91, 92, 83, 89, 76, 
  70, 83, 85, 89, 76, 88, 102, 95, 76, 84, 
  81, 95, 75, 82, 77, 97, 73, 71, 73, 73, 
  91, 96, 87, 99, 78, 98, 83, 85, 75, 83, 
  68, 75, 94, 78, 81, 94, 84, 82, 85, 96, 
  63, 92, 75, 89, 80, 100, 95, 80, 73, 62, 
  88, 84, 78, 93, 84, 79, 68, 85, 84, 60, 
  73, 112, 68, 107, 90, 77, 105, 77, 92, 87, 
  87, 69, 71, 89, 72, 80, 85, 117, 76, 100, 
  96, 97, 80, 87, 82, 86, 75, 86, 76, 82, 
  88, 78, 80, 89, 94, 78, 84, 84, 87, 86, 
  82, 76, 78, 82, 93, 92, 82, 81, 74, 83, 
  79, 92, 74, 79, 115, 73, 90, 75, 79, 93, 
  94, 78, 88, 93, 96, 90, 88, 75, 70, 81, 
  74, 87, 71, 96, 107, 102, 76, 87, 83, 77, 
  86, 80, 75, 89, 73, 71, 72, 63, 96, 104, 
  84, 112, 79, 99, 89, 74, 76, 69, 67, 77, 
  101, 74, 83, 95, 85, 83, 85, 91, 56, 92, 
  75, 93, 81, 115, 78, 84, 74, 58, 92, 82, 
  74, 101, 81, 84, 76, 79, 81, 63, 74, 112, 
  75, 119, 102, 66, 123, 85, 74, 87, 99, 64, 
  74, 79, 67, 76, 68, 124, 73, 91, 83, 96, 
  78, 78, 77, 85, 67, 84, 73, 80, 92, 79, 
  89, 95, 95, 77, 85, 80, 66, 87, 78, 77, 
  75, 75, 99, 95, 83, 79, 70, 74, 78, 94, 
  88, 79, 97, 78, 82, 72, 80, 91, 91, 83, 
  84, 92, 87, 84, 86, 80, 75, 101, 78, 93, 
  93, 84, 108, 95, 79, 84, 80, 74, 81, 86, 
  76, 73, 90, 87, 75, 71, 99, 94, 84, 91, 
  85, 92, 83, 83, 78, 67, 66, 75, 94, 74, 
  79, 92, 84, 76, 83, 100, 66, 89, 78, 94, 
  79, 98, 93, 81, 70, 65, 90, 88, 78, 93, 
  87, 80, 82, 83, 85, 82, 76, 109, 67, 102, 
  91, 72, 102, 85, 73, 88, 82, 73, 74, 80, 
  76, 76, 71, 114, 75, 102, 82, 100, 78, 82, 
  80, 84, 74, 85, 80, 78, 85, 80, 83, 93, 
  92, 93, 81, 80, 71, 87, 82, 79, 78, 87, 
  82, 92, 86, 80, 77, 86, 77, 72, 68, 87, 
  95, 90, 74, 65, 73, 93, 90, 77, 83, 88, 
  87, 95, 90, 82, 72, 81, 82, 84, 81, 78, 
  93, 88, 84, 81, 85, 84, 78, 87, 80, 94, 
  77, 73, 74, 70, 86, 92, 85, 83, 83, 92, 
  82, 85, 80, 85, 65, 75, 92, 66, 76, 98, 
  88, 76, 87, 100, 78, 79, 86, 76, 84, 91, 
  95, 78, 77, 64, 90, 90, 78, 84, 82, 79, 
  72, 77, 88, 69, 87, 97, 70, 88, 86, 79, 
  92, 74, 97, 87, 81, 84, 73, 94, 81, 71, 
  92, 103, 79, 97, 100, 93, 87, 93, 83, 85, 
  84, 80, 82, 77, 80, 87, 82, 86, 85, 80, 
  89, 87, 83, 83, 83, 83, 79, 85, 84, 91, 
  78, 83, 83, 87, 78, 80, 75, 85, 100, 80, 
  78, 66, 70, 91, 90, 74, 84, 91, 88, 92, 
  89, 84, 67, 82, 82, 82, 84, 84, 94, 96, 
  82, 83, 87, 77, 83, 87, 75, 88, 73, 80, 
  70, 68, 88, 91, 89, 88, 80, 94, 88, 73, 
  81, 78, 65, 73, 92, 68, 74, 93, 87, 81, 
  87, 89, 74, 79, 91, 84, 85, 89, 87, 75, 
  86, 68, 89, 96, 76, 90, 79, 84, 76, 72, 
  93, 72, 84, 100, 74, 93, 88, 67, 100, 84, 
  82, 93, 85, 77, 74, 94, 78, 69, 77, 109, 
  75, 92, 86, 96, 81, 95, 79, 86, 76, 80, 
  81, 78, 82, 84, 86, 94, 87, 80, 86, 90, 
  72, 84, 82, 83, 81, 86, 82, 91, 78, 85, 
  83, 77, 74, 85, 87, 85, 97, 81, 74, 69, 
  74, 92, 88, 79, 82, 87, 85, 93, 87, 88, 
  76, 95, 85, 87, 90, 77, 97, 86, 83, 83, 
  82, 78, 82, 86, 78, 77, 80, 85, 76, 70, 
  83, 90, 89, 83, 81, 90, 86, 83, 84, 72, 
  65, 77, 90, 62, 74, 94, 85, 78, 83, 105, 
  83, 79, 87, 80, 83, 91, 87, 77, 77, 70, 
  86, 92, 74, 86, 85, 82, 84, 79, 87, 79, 
  87, 99, 70, 87, 86, 71, 89, 82, 75, 84, 
  78, 82, 74, 83, 84, 68, 75, 103, 76, 99, 
  79, 96, 86, 85, 80, 84, 84, 81, 88, 73, 
  80, 88, 83, 89, 85, 92, 86, 87, 68, 85, 
  84, 82, 88, 89, 76, 91, 80, 85, 84, 88, 
  90, 69, 70, 81, 97, 84, 64, 90, 66, 79, 
  84, 85, 67, 77, 80, 84, 77, 78, 76, 88, 
  72, 69, 74, 75, 74, 91, 88, 88, 97, 100, 
  75, 85, 70, 93, 86, 94, 93, 86, 76, 72, 
  79, 87, 72, 118, 89, 89, 72, 95, 92, 83, 
  86, 77, 88, 73, 82, 85, 71, 62, 74, 71, 
  74, 91, 80, 92, 78, 74, 82, 91, 83, 92, 
  68, 88, 96, 94, 88, 75, 93, 74, 78, 52, 
  100, 100, 89, 86, 84, 83, 77, 105, 85, 78, 
  76, 83, 77, 73, 89, 79, 92, 87, 82, 90, 
  82, 77, 98, 99, 79, 78, 101, 138, 81, 76, 
  71, 76, 75, 73, 89, 78, 81, 93, 82, 89, 
  80, 91, 78, 81, 113, 85, 76, 77, 83, 73, 
  65, 85, 102, 79, 58, 95, 69, 78, 83, 87, 
  74, 88, 85, 85, 76, 79, 73, 94, 70, 61, 
  82, 72, 68, 95, 84, 88, 92, 93, 67, 83, 
  70, 81, 95, 90, 90, 81, 76, 65, 76, 81, 
  72, 136, 83, 84, 79, 85, 80, 81, 88, 90, 
  92, 79, 76, 92, 70, 70, 89, 67, 70, 78, 
  75, 88, 86, 77, 87, 81, 79, 96, 77, 81, 
  99, 90, 95, 68, 89, 82, 78, 48, 98, 100, 
  88, 90, 68, 81, 73, 107, 95, 82, 81, 80, 
  78, 68, 87, 77, 91, 90, 80, 90, 81, 78, 
  95, 100, 80, 89, 107, 148, 85, 76, 68, 75, 
  76, 77, 74, 85, 72, 87, 80, 95, 85, 94, 
  77, 80, 117, 84, 75, 78, 91, 79, 66, 82, 
  81, 73, 67, 89, 68, 75, 83, 80, 76, 87, 
  82, 86, 80, 82, 79, 89, 77, 73, 83, 73, 
  78, 98, 89, 84, 92, 82, 79, 81, 76, 79, 
  93, 98, 91, 88, 77, 72, 79, 82, 79, 95, 
  89, 86, 74, 89, 93, 87, 85, 82, 83, 75, 
  83, 91, 75, 58, 73, 78, 79, 93, 78, 88, 
  70, 80, 85, 90, 84, 95, 75, 93, 95, 93, 
  96, 79, 97, 88, 84, 59, 84, 95, 92, 85, 
  86, 84, 72, 92, 79, 79, 77, 80, 83, 80, 
  87, 76, 89, 82, 74, 99, 80, 75, 96, 99, 
  77, 83, 96, 116, 86, 75, 69, 76, 79, 76, 
  67, 92, 81, 92, 85, 91, 86, 87, 78, 84, 
  97, 89, 82, 84, 92, 61, 65, 89, 87, 99, 
  49, 79, 86, 76, 82, 82, 73, 81, 81, 92, 
  91, 70, 82, 77, 78, 74, 76, 82, 76, 111, 
  72, 90, 96, 94, 78, 89, 68, 98, 93, 86, 
  76, 88, 68, 87, 77, 91, 81, 158, 94, 92, 
  83, 99, 70, 79, 89, 85, 94, 81, 72, 86, 
  68, 72, 85, 59, 72, 94, 74, 96, 80, 77, 
  76, 89, 80, 85, 70, 76, 83, 85, 89, 66, 
  89, 83, 65, 71, 123, 120, 84, 87, 73, 74, 
  81, 111, 94, 88, 69, 84, 81, 69, 82, 85, 
  95, 94, 83, 84, 83, 77, 92, 93, 82, 77, 
  100, 173, 62, 79, 71, 71, 76, 78, 83, 75, 
  75, 87, 89, 84, 85, 85, 65, 82, 129, 78, 
  76, 73, 82, 79, 65, 92, 94, 84, 43, 78, 
  95, 84, 79, 87, 83, 71, 93, 84, 94, 66, 
  80, 83, 74, 63, 84, 83, 76, 116, 66, 99, 
  90, 91, 81, 85, 60, 80, 92, 78, 74, 103, 
  74, 84, 81, 101, 80, 187, 95, 77, 91, 80, 
  61, 73, 93, 92, 101, 92, 71, 88, 74, 85, 
  100, 50, 59, 80, 70, 109, 73, 83, 85, 89, 
  77, 76, 64, 80, 81, 84, 96, 64, 84, 87, 
  64, 82, 129, 129, 81, 82, 65, 76, 74, 114, 
  105, 85, 70, 69, 87, 67, 71, 92, 96, 112, 
  88, 80, 74, 69, 93, 93, 89, 79, 102, 181, 
  69, 79, 80, 69, 80, 73, 84, 82, 68, 87, 
  95, 80, 81, 88, 57, 87, 150, 75, 85, 73, 
  97, 83, 76, 90, 77, 78, 57, 77, 83, 74, 
  81, 79, 73, 73, 85, 89, 86, 77, 80, 91, 
  75, 80, 97, 79, 79, 103, 81, 86, 90, 87, 
  82, 82, 72, 81, 94, 92, 78, 88, 74, 82, 
  77, 87, 83, 129, 89, 90, 86, 89, 76, 82, 
  86, 82, 87, 81, 72, 80, 73, 67, 85, 64, 
  76, 96, 69, 84, 78, 79, 78, 91, 81, 88, 
  81, 82, 90, 89, 97, 67, 98, 92, 74, 75, 
  105, 117, 85, 84, 76, 76, 79, 106, 90, 83, 
  73, 73, 84, 75, 83, 80, 94, 93, 78, 89, 
  86, 74, 88, 94, 80, 84, 97, 147, 71, 78, 
  82, 75, 80, 79, 84, 85, 89, 91, 84, 90, 
  84, 83, 69, 84, 109, 83, 77, 75, 91, 70, 
  65, 91, 94, 90, 63, 84, 79, 80, 90, 74, 
  70, 82, 77, 98, 89, 70, 84, 84, 83, 69, 
  78, 89, 83, 103, 79, 84, 94, 91, 89, 86, 
  77, 105, 90, 85, 96, 80, 74, 78, 86, 83, 
  79, 107, 87, 95, 82, 93, 88, 95, 85, 74, 
  90, 83, 78, 89, 78, 62, 86, 76, 76, 99, 
  84, 94, 79, 82, 80, 91, 74, 75, 74, 82, 
  84, 70, 84, 78, 94, 82, 77, 52, 110, 87, 
  88, 87, 82, 79, 82, 97, 79, 104, 78, 94, 
  88, 74, 91, 72, 91, 79, 89, 96, 80, 88, 
  92, 94, 85, 84, 88, 125, 70, 89, 67, 72, 
  81, 81, 79, 87, 68, 87, 91, 86, 84, 91, 
  71, 84, 98, 85, 73, 87, 92, 74, 71, 94, 
  97, 81, 60, 80, 83, 83, 86, 77, 77, 78, 
  81, 95, 90, 74, 84, 86, 74, 58, 84, 85, 
  78, 96, 79, 87, 87, 91, 90, 85, 67, 88, 
  87, 77, 90, 86, 74, 71, 92, 81, 79, 123, 
  80, 92, 90, 76, 76, 83, 87, 83, 88, 82, 
  79, 80, 77, 72, 93, 67, 71, 91, 87, 94, 
  87, 77, 88, 81, 74, 89, 64, 80, 81, 73, 
  79, 67, 89, 87, 76, 53, 113, 93, 87, 89, 
  77, 82, 79, 105, 86, 95, 74, 89, 84, 73, 
  86, 71, 92, 89, 84, 90, 79, 86, 89, 93, 
  87, 87, 85, 136, 65, 88, 75, 71, 76, 83, 
  93, 90, 74, 84, 91, 90, 86, 88, 63, 82, 
  108, 86, 77, 86, 94, 83, 86, 87, 87, 81, 
  66, 77, 80, 83, 90, 71, 71, 81, 78, 98, 
  84, 72, 84, 90, 72, 76, 91, 87, 85, 97, 
  84, 86, 86, 85, 92, 83, 78, 85, 89, 88, 
  98, 80, 78, 79, 86, 88, 82, 92, 83, 93, 
  82, 81, 89, 97, 80, 80, 80, 82, 78, 66, 
  76, 60, 84, 80, 76, 97, 81, 88, 82, 80, 
  83, 92, 83, 75, 68, 85, 86, 75, 84, 76, 
  97, 95, 74, 61, 96, 93, 89, 86, 83, 80, 
  78, 91, 82, 91, 80, 82, 89, 81, 87, 68, 
  90, 79, 80, 96, 81, 80, 89, 94, 89, 85, 
  82, 111, 69, 86, 80, 72, 79, 83, 94, 87, 
  90, 92, 89, 89, 95, 86, 72, 84, 88, 87, 
  80, 88, 86, 82, 97, 87, 81, 98, 94, 78, 
  78, 88, 81, 92, 100, 97, 87, 88, 98, 102, 
  70, 83, 88, 101, 96, 81, 86, 92, 87, 83, 
  93, 78, 78, 83, 89, 89, 68, 78, 91, 92, 
  78, 92, 83, 85, 88, 90, 80, 89, 86, 84, 
  80, 95, 56, 100, 84, 63, 83, 77, 89, 75, 
  81, 87, 97, 75, 77, 76, 90, 67, 77, 86, 
  74, 91, 84, 84, 81, 88, 79, 91, 85, 83, 
  83, 76, 87, 72, 81, 83, 92, 72, 89, 73, 
  75, 80, 78, 71, 81, 88, 76, 83, 84, 86, 
  86, 86, 64, 69, 81, 74, 81, 69, 68, 99, 
  75, 82, 74, 85, 93, 89, 92, 81, 98, 81, 
  81, 79, 80, 84, 89, 90, 83, 78, 79, 96, 
  89, 91, 85, 88, 68, 88, 92, 83, 84, 90, 
  82, 99, 117, 71, 88, 99, 103, 112, 67, 90, 
  100, 83, 79, 83, 82, 88, 100, 91, 85, 62, 
  83, 78, 82, 85, 72, 67, 90, 96, 81, 104, 
  79, 88, 93, 96, 83, 91, 85, 67, 65, 97, 
  45, 94, 97, 56, 88, 86, 90, 75, 74, 88, 
  102, 66, 75, 86, 87, 65, 82, 86, 65, 88, 
  105, 72, 80, 96, 81, 83, 78, 81, 89, 74, 
  84, 67, 85, 77, 95, 67, 85, 68, 77, 84, 
  88, 70, 70, 86, 73, 89, 85, 83, 84, 84, 
  61, 72, 86, 71, 84, 68, 72, 102, 69, 83, 
  80, 90, 104, 87, 84, 77, 94, 76, 78, 87, 
  83, 80, 87, 99, 78, 77, 90, 95, 84, 83, 
  82, 80, 79, 96, 92, 82, 74, 83, 85, 85, 
  94, 70, 92, 89, 96, 91, 75, 93, 85, 102, 
  90, 81, 82, 93, 83, 85, 86, 68, 77, 89, 
  92, 86, 84, 89, 99, 88, 82, 92, 82, 86, 
  83, 84, 81, 85, 86, 77, 84, 99, 66, 85, 
  81, 69, 81, 80, 86, 80, 84, 89, 96, 75, 
  81, 71, 88, 71, 77, 86, 77, 79, 108, 90, 
  89, 86, 80, 91, 87, 87, 85, 83, 91, 82, 
  83, 81, 85, 65, 90, 79, 81, 79, 77, 84, 
  82, 81, 81, 85, 90, 87, 84, 89, 70, 85, 
  81, 75, 78, 66, 69, 87, 74, 82, 77, 84, 
  84, 91, 77, 82, 89, 81, 83, 74, 78, 86, 
  90, 82, 91, 77, 78, 95, 88, 94, 71, 89, 
  86, 93, 81, 72, 81, 87, 91, 92, 88, 77, 
  80, 94, 115, 90, 82, 78, 94, 91, 83, 88, 
  63, 83, 75, 81, 84, 66, 99, 76, 84, 90, 
  80, 82, 91, 91, 99, 79, 72, 81, 89, 80, 
  65, 80, 71, 91, 74, 84, 91, 81, 96, 70, 
  81, 94, 79, 86, 88, 91, 83, 72, 62, 74, 
  67, 80, 81, 92, 81, 62, 91, 78, 89, 91, 
  72, 87, 89, 104, 77, 82, 86, 76, 79, 78, 
  88, 81, 93, 82, 80, 77, 91, 75, 74, 82, 
  92, 73, 84, 76, 93, 88, 56, 75, 86, 79, 
  83, 96, 86, 86, 68, 77, 77, 82, 83, 81, 
  81, 93, 85, 83, 78, 91, 86, 78, 96, 88, 
  76, 77, 87, 88, 79, 90, 87, 95, 75, 81, 
  69, 74, 96, 86, 93, 104, 110, 75, 77, 99, 
  131, 97, 83, 81, 97, 71, 74, 89, 67, 70, 
  83, 86, 76, 67, 115, 79, 75, 87, 68, 73, 
  94, 94, 82, 79, 65, 82, 98, 85, 59, 79, 
  62, 76, 57, 77, 95, 78, 109, 68, 75, 79, 
  85, 75, 73, 93, 87, 64, 53, 81, 58, 77, 
  81, 101, 72, 63, 77, 59, 98, 96, 64, 80, 
  90, 93, 76, 78, 83, 75, 83, 86, 86, 82, 
  84, 79, 74, 77, 95, 73, 60, 74, 95, 70, 
  91, 72, 76, 88, 57, 71, 90, 82, 72, 112, 
  94, 95, 70, 74, 85, 79, 91, 81, 91, 88, 
  83, 79, 69, 87, 89, 78, 86, 96, 67, 76, 
  95, 84, 81, 78, 102, 84, 92, 97, 83, 73, 
  78, 84, 90, 80, 82, 98, 84, 95, 104, 81, 
  81, 79, 84, 97, 90, 89, 87, 84, 71, 81, 
  81, 86, 99, 87, 87, 93, 78, 98, 104, 89, 
  83, 77, 79, 83, 93, 81, 72, 85, 86, 102, 
  85, 85, 88, 84, 91, 74, 81, 64, 81, 84, 
  86, 83, 82, 74, 67, 73, 69, 83, 84, 84, 
  85, 65, 85, 83, 93, 86, 71, 81, 86, 87, 
  78, 86, 90, 86, 78, 91, 85, 82, 79, 90, 
  82, 75, 84, 71, 83, 77, 81, 77, 89, 74, 
  71, 91, 65, 80, 84, 81, 81, 92, 78, 82, 
  67, 75, 88, 84, 75, 89, 91, 89, 90, 82, 
  84, 90, 83, 80, 100, 81, 85, 74, 82, 86, 
  81, 88, 79, 86, 89, 78, 69, 80, 73, 74, 
  84, 77, 74, 96, 69, 89, 106, 59, 73, 72, 
  83, 86, 74, 82, 63, 76, 75, 79, 95, 68, 
  96, 91, 80, 86, 108, 92, 100, 96, 112, 77, 
  89, 61, 86, 64, 74, 77, 88, 77, 99, 76, 
  113, 78, 84, 84, 75, 81, 66, 100, 86, 89, 
  81, 93, 93, 80, 62, 85, 82, 88, 103, 85, 
  94, 91, 89, 79, 68, 81, 96, 92, 95, 95, 
  81, 93, 73, 89, 72, 97, 92, 87, 82, 77, 
  88, 101, 85, 79, 91, 86, 91, 83, 83, 99, 
  77, 97, 78, 87, 91, 94, 87, 53, 71, 73, 
  87, 80, 75, 78, 88, 104, 66, 85, 100, 91, 
  76, 89, 78, 79, 84, 95, 82, 76, 68, 77, 
  90, 79, 86, 74, 63, 73, 67, 71, 90, 81, 
  83, 123, 74, 68, 109, 56, 66, 68, 81, 84, 
  85, 77, 72, 72, 70, 77, 104, 94, 102, 81, 
  79, 87, 91, 83, 105, 89, 107, 74, 101, 61, 
  80, 68, 77, 67, 88, 74, 96, 75, 128, 86, 
  83, 85, 69, 101, 61, 93, 92, 94, 77, 91, 
  93, 85, 56, 102, 86, 105, 105, 90, 83, 91, 
  79, 74, 71, 80, 97, 85, 98, 102, 79, 99, 
  61, 83, 73, 102, 84, 90, 78, 69, 74, 90, 
  86, 73, 89, 94, 87, 83, 85, 108, 79, 95, 
  74, 91, 92, 114, 98, 60, 71, 67, 91, 74, 
  72, 78, 97, 115, 77, 90, 103, 91, 82, 84, 
  70, 78, 83, 91, 76, 77, 78, 68, 93, 85, 
  95, 78, 70, 77, 72, 80, 81, 67, 74, 111, 
  74, 87, 99, 65, 75, 72, 86, 78, 98, 82, 
  77, 79, 79, 80, 90, 108, 91, 87, 79, 85, 
  79, 95, 98, 97, 94, 74, 89, 71, 84, 72, 
  82, 77, 90, 93, 108, 77, 105, 69, 85, 82, 
  78, 87, 73, 89, 82, 81, 80, 89, 94, 82, 
  66, 84, 89, 81, 93, 80, 80, 90, 89, 85, 
  74, 80, 91, 87, 84, 92, 84, 88, 69, 87, 
  74, 103, 79, 89, 78, 75, 85, 78, 90, 79, 
  88, 86, 93, 86, 77, 89, 78, 86, 79, 85, 
  92, 91, 79, 63, 73, 77, 87, 84, 76, 89, 
  77, 89, 99, 83, 103, 89, 93, 83, 81, 77, 
  85, 90, 85, 75, 81, 70, 93, 72, 90, 79, 
  87, 82, 84, 82, 80, 72, 83, 94, 75, 91, 
  78, 69, 63, 76, 78, 106, 97, 102, 78, 76, 
  71, 81, 96, 86, 84, 88, 92, 69, 83, 95, 
  87, 85, 96, 90, 79, 104, 81, 71, 78, 91, 
  97, 88, 84, 88, 80, 83, 82, 80, 79, 86, 
  97, 71, 89, 81, 72, 153, 81, 115, 46, 98, 
  72, 74, 102, 79, 108, 87, 80, 74, 74, 83, 
  96, 81, 87, 99, 83, 76, 93, 71, 83, 70, 
  73, 74, 88, 81, 80, 77, 93, 79, 75, 91, 
  70, 71, 86, 106, 73, 79, 82, 84, 78, 74, 
  72, 71, 70, 82, 84, 70, 73, 73, 88, 87, 
  74, 91, 90, 90, 85, 75, 80, 78, 78, 98, 
  71, 91, 86, 69, 80, 93, 88, 66, 82, 83, 
  75, 80, 85, 81, 90, 106, 76, 86, 83, 83, 
  80, 72, 116, 109, 89, 92, 80, 92, 72, 84, 
  93, 76, 88, 85, 91, 91, 84, 73, 73, 94, 
  69, 85, 82, 92, 75, 87, 79, 89, 81, 82, 
  80, 87, 73, 100, 83, 83, 79, 73, 80, 70, 
  87, 93, 72, 97, 90, 87, 74, 79, 78, 83, 
  91, 89, 64, 85, 73, 81, 83, 68, 83, 88, 
  80, 80, 87, 83, 83, 78, 87, 74, 84, 79, 
  73, 89, 77, 75, 87, 85, 69, 89, 87, 71, 
  88, 74, 80, 69, 84, 83, 92, 71, 91, 98, 
  86, 83, 94, 82, 88, 85, 92, 92, 101, 86, 
  84, 93, 84, 81, 92, 82, 77, 93, 83, 80, 
  80, 78, 76, 104, 91, 81, 92, 88, 80, 89, 
  94, 92, 90, 76, 90, 85, 92, 101, 98, 98, 
  82, 74, 77, 80, 95, 99, 87, 95, 90, 79, 
  83, 89, 97, 88, 89, 74, 86, 95, 82, 75, 
  75, 61, 100, 107, 82, 89, 79, 71, 71, 78, 
  89, 89, 79, 90, 83, 85, 72, 90, 74, 93, 
  73, 67, 93, 73, 103, 71, 77, 94, 72, 97, 
  87, 70, 81, 92, 87, 72, 68, 88, 93, 74, 
  101, 92, 76, 76, 88, 84, 88, 82, 85, 93, 
  68, 86, 72, 80, 80, 95, 91, 88, 73, 66, 
  101, 93, 87, 82, 105, 75, 108, 101, 95, 97, 
  87, 83, 109, 96, 86, 82, 87, 84, 74, 94, 
  84, 90, 87, 91, 86, 96, 95, 84, 85, 80, 
  86, 70, 80, 88, 84, 84, 80, 82, 87, 70, 
  71, 89, 75, 72, 70, 65, 67, 79, 79, 109, 
  98, 94, 81, 86, 67, 80, 90, 73, 82, 87, 
  83, 70, 66, 96, 105, 85, 103, 75, 81, 104, 
  94, 72, 89, 76, 74, 100, 87, 85, 81, 86, 
  82, 82, 87, 97, 98, 75, 95, 82, 82, 133, 
  95, 115, 47, 103, 71, 72, 89, 81, 92, 91, 
  87, 86, 72, 87, 92, 76, 73, 99, 82, 66, 
  88, 78, 85, 81, 68, 82, 83, 75, 79, 76, 
  92, 76, 68, 92, 77, 71, 72, 111, 78, 93, 
  93, 83, 71, 81, 80, 71, 73, 77, 82, 63, 
  71, 66, 78, 81, 82, 84, 93, 97, 75, 72, 
  78, 79, 81, 79, 72, 93, 85, 64, 61, 91, 
  86, 74, 85, 80, 88, 80, 83, 77, 80, 70, 
  79, 89, 80, 75, 78, 73, 104, 90, 74, 91, 
  80, 91, 71, 79, 93, 71, 77, 88, 92, 89, 
  89, 77, 84, 88, 94, 84, 79, 82, 66, 81, 
  83, 92, 78, 85, 79, 86, 79, 73, 90, 83, 
  82, 110, 81, 78, 91, 87, 75, 101, 88, 89, 
  67, 89, 73, 81, 100, 77, 100, 86, 70, 72, 
  80, 79, 91, 92, 75, 83, 80, 81, 87, 73, 
  85, 77, 79, 79, 73, 89, 79, 86, 87, 83, 
  68, 87, 81, 74, 101, 84, 79, 78, 78, 83, 
  81, 81, 89, 90, 82, 85, 79, 78, 76, 82, 
  74, 90, 77, 84, 85, 77, 83, 78, 90, 79, 
  82, 79, 80, 81, 73, 78, 100, 107, 93, 73, 
  90, 75, 79, 93, 87, 90, 84, 86, 91, 96, 
  92, 96, 94, 94, 73, 77, 79, 86, 86, 98, 
  81, 91, 82, 91, 89, 88, 96, 87, 85, 67, 
  92, 101, 70, 81, 82, 67, 81, 95, 75, 86, 
  83, 75, 71, 81, 79, 81, 86, 91, 83, 90, 
  69, 97, 83, 87, 70, 75, 81, 80, 94, 83, 
  81, 88, 81, 97, 67, 73, 68, 74, 86, 73, 
  75, 78, 88, 76, 96, 92, 80, 81, 85, 85, 
  84, 79, 86, 95, 72, 83, 74, 83, 73, 83, 
  84, 87, 84, 62, 93, 76, 78, 82, 103, 86, 
  100, 97, 91, 99, 85, 79, 98, 93, 90, 88, 
  80, 84, 81, 76, 84, 87, 87, 87, 88, 90, 
  95, 86, 89, 95, 97, 95, 84, 87, 86, 101, 
  75, 87, 80, 72, 79, 87, 82, 82, 85, 90, 
  86, 97, 84, 98, 97, 89, 97, 108, 81, 91, 
  77, 76, 93, 79, 84, 83, 77, 82, 90, 97, 
  88, 75, 79, 92, 90, 86, 87, 61, 86, 97, 
  83, 82, 91, 86, 81, 93, 84, 71, 82, 88, 
  79, 103, 88, 75, 86, 92, 66, 72, 79, 80, 
  90, 92, 68, 83, 85, 95, 84, 82, 83, 81, 
  74, 83, 87, 85, 74, 90, 90, 87, 85, 88, 
  87, 78, 78, 88, 88, 86, 81, 80, 81, 76, 
  70, 69, 89, 82, 90, 82, 93, 72, 97, 83, 
  90, 98, 80, 80, 88, 72, 76, 79, 91, 81, 
  98, 82, 82, 94, 105, 89, 91, 82, 86, 91, 
  89, 73, 68, 84, 81, 87, 86, 85, 79, 87, 
  82, 75, 82, 73, 83, 74, 76, 74, 80, 85, 
  75, 93, 80, 92, 90, 93, 83, 84, 81, 69, 
  82, 95, 82, 78, 85, 87, 88, 83, 98, 87, 
  79, 99, 98, 78, 88, 76, 76, 86, 89, 81, 
  88, 79, 87, 82, 81, 85, 87, 81, 87, 84, 
  85, 100, 90, 96, 68, 86, 77, 76, 90, 84, 
  111, 95, 82, 84, 74, 88, 90, 86, 78, 90, 
  78, 86, 82, 79, 88, 80, 79, 86, 86, 83, 
  82, 89, 101, 76, 73, 88, 79, 80, 72, 86, 
  81, 106, 88, 85, 81, 78, 86, 80, 82, 91, 
  75, 77, 77, 72, 74, 91, 74, 88, 93, 88, 
  81, 79, 88, 78, 85, 78, 82, 89, 84, 64, 
  78, 88, 86, 81, 86, 71, 73, 93, 87, 82, 
  86, 86, 86, 83, 79, 79, 83, 86, 80, 85, 
  85, 99, 82, 84, 85, 88, 74, 79, 90, 90, 
  85, 80, 83, 74, 80, 84, 79, 87, 79, 89, 
  83, 82, 80, 80, 76, 75, 92, 82, 78, 83, 
  90, 72, 85, 93, 86, 88, 92, 83, 79, 92, 
  90, 87, 84, 84, 86, 84, 90, 94, 82, 95, 
  82, 76, 78, 85, 90, 85, 90, 87, 81, 94, 
  85, 79, 83, 79, 81, 84, 90, 88, 79, 87, 
  95, 74, 73, 94, 76, 82, 91, 73, 83, 84, 
  82, 84, 90, 81, 86, 81, 76, 96, 76, 74, 
  84, 81, 83, 108, 86, 90, 85, 92, 84, 79, 
  79, 79, 84, 86, 85, 93, 87, 88, 78, 86, 
  73, 90, 76, 65, 69, 73, 79, 74, 87, 78, 
  75, 92, 75, 96, 88, 87, 103, 85, 75, 77, 
  70, 89, 61, 105, 98, 78, 90, 74, 73, 74, 
  66, 71, 81, 88, 90, 76, 59, 55, 89, 88, 
  117, 73, 82, 102, 86, 95, 80, 75, 91, 83, 
  87, 76, 73, 77, 83, 82, 95, 70, 75, 81, 
  80, 82, 76, 86, 67, 92, 72, 72, 101, 95, 
  91, 84, 71, 83, 89, 71, 81, 82, 93, 89, 
  89, 95, 88, 103, 91, 104, 100, 78, 63, 73, 
  80, 102, 78, 97, 66, 85, 92, 74, 79, 76, 
  87, 94, 79, 93, 74, 84, 113, 96, 90, 76, 
  73, 77, 89, 92, 80, 119, 100, 86, 87, 72, 
  93, 85, 86, 89, 85, 91, 68, 87, 75, 86, 
  76, 69, 70, 73, 76, 77, 86, 83, 75, 87, 
  70, 93, 83, 86, 90, 85, 80, 77, 73, 89, 
  55, 105, 100, 72, 91, 68, 73, 72, 71, 78, 
  85, 86, 85, 75, 62, 67, 94, 86, 120, 71, 
  85, 98, 85, 99, 83, 73, 90, 84, 89, 76, 
  71, 75, 94, 82, 100, 74, 79, 84, 69, 88, 
  74, 85, 72, 85, 74, 75, 97, 85, 92, 77, 
  73, 85, 82, 69, 82, 84, 94, 80, 86, 93, 
  85, 97, 89, 98, 92, 78, 75, 75, 79, 103, 
  80, 97, 70, 81, 88, 77, 77, 77, 87, 95, 
  71, 91, 69, 90, 109, 99, 92, 79, 72, 82, 
  75, 93, 88, 112, 97, 87, 72, 76, 89, 86, 
  85, 92, 85, 91, 71, 82, 69, 83, 75, 79, 
  73, 75, 77, 73, 80, 88, 77, 96, 79, 90, 
  82, 93, 79, 78, 85, 76, 75, 94, 68, 99, 
  89, 68, 87, 72, 73, 70, 78, 86, 86, 85, 
  75, 74, 66, 61, 105, 86, 110, 75, 86, 88, 
  88, 91, 88, 76, 86, 80, 83, 82, 71, 88, 
  80, 84, 97, 73, 79, 76, 85, 85, 82, 83, 
  75, 80, 85, 72, 100, 90, 91, 85, 77, 83, 
  90, 75, 81, 84, 93, 86, 86, 90, 81, 92, 
  91, 100, 96, 85, 64, 77, 86, 97, 77, 104, 
  71, 93, 97, 83, 76, 76, 90, 91, 73, 92, 
  71, 86, 104, 92, 85, 84, 76, 79, 81, 89, 
  86, 114, 94, 87, 78, 73, 89, 89, 83, 88, 
  85, 82, 75, 89, 86, 84, 81, 71, 77, 74, 
  88, 79, 90, 77, 89, 101, 77, 93, 76, 83, 
  116, 82, 75, 79, 78, 77, 56, 102, 96, 81, 
  93, 70, 81, 79, 71, 75, 71, 90, 96, 70, 
  62, 69, 118, 93, 109, 84, 72, 105, 76, 88, 
  91, 72, 87, 86, 80, 86, 66, 82, 83, 86, 
  94, 66, 72, 75, 77, 76, 83, 81, 63, 68, 
  86, 71, 91, 113, 97, 73, 74, 88, 81, 70, 
  89, 84, 93, 83, 84, 93, 89, 95, 84, 98, 
  89, 63, 72, 80, 73, 94, 91, 90, 69, 75, 
  80, 83, 77, 72, 93, 84, 78, 86, 55, 84, 
  93, 89, 89, 82, 73, 78, 75, 90, 82, 101, 
  90, 82, 74, 77, 87, 93, 89, 85, 82, 94, 
  72, 91, 91, 83, 82, 72, 78, 76, 84, 79, 
  92, 88, 85, 105, 68, 88, 71, 86, 115, 81, 
  74, 78, 75, 75, 54, 102, 93, 77, 96, 70, 
  80, 78, 74, 80, 71, 81, 88, 65, 67, 76, 
  126, 91, 112, 83, 73, 95, 73, 89, 92, 70, 
  82, 86, 77, 77, 63, 76, 87, 84, 103, 72, 
  77, 76, 68, 77, 74, 77, 68, 65, 74, 64, 
  88, 104, 99, 60, 75, 91, 80, 67, 91, 85, 
  96, 82, 81, 92, 89, 87, 80, 99, 87, 62, 
  73, 78, 73, 95, 87, 90, 74, 65, 79, 77, 
  77, 73, 102, 78, 70, 85, 58, 90, 97, 93, 
  86, 83, 74, 79, 74, 86, 86, 98, 88, 87, 
  55, 79, 80, 93, 89, 87, 85, 96, 76, 83, 
  81, 89, 78, 78, 74, 76, 85, 80, 82, 96, 
  87, 99, 81, 87, 77, 87, 92, 82, 80, 80, 
  78, 78, 66, 96, 89, 75, 89, 72, 77, 75, 
  83, 86, 72, 88, 79, 72, 70, 72, 111, 90, 
  103, 79, 76, 86, 80, 88, 91, 82, 83, 85, 
  84, 76, 71, 90, 80, 84, 95, 73, 78, 70, 
  80, 80, 85, 80, 72, 75, 77, 74, 87, 95, 
  94, 82, 79, 89, 82, 72, 88, 81, 92, 88, 
  85, 86, 90, 92, 82, 92, 88, 70, 72, 80, 
  83, 92, 90, 94, 73, 85, 82, 87, 78, 73, 
  92, 88, 71, 84, 61, 82, 97, 90, 84, 86, 
  85, 85, 91, 87, 87, 100, 82, 84, 70, 78, 
  86, 90, 89, 87, 80, 76, 84, 85, 78, 83, 
  78, 78, 80, 73, 90, 94, 92, 88, 95, 96, 
  81, 86, 81, 85, 120, 84, 75, 81, 83, 74, 
  79, 88, 88, 74, 93, 73, 76, 83, 75, 86, 
  82, 78, 92, 76, 68, 73, 121, 94, 109, 92, 
  77, 101, 72, 85, 92, 71, 90, 88, 87, 100, 
  78, 77, 83, 89, 94, 71, 71, 79, 84, 73, 
  86, 83, 67, 79, 93, 86, 92, 121, 90, 78, 
  81, 89, 82, 77, 88, 87, 101, 80, 81, 91, 
  92, 92, 85, 97, 79, 72, 70, 76, 78, 104, 
  93, 86, 79, 86, 74, 96, 78, 75, 90, 102, 
  80, 80, 52, 83, 98, 85, 88, 89, 85, 81, 
  75, 91, 89, 98, 94, 82, 74, 80, 83, 87, 
  86, 76, 78, 84, 78, 87, 79, 81, 81, 76, 
  80, 77, 91, 86, 95, 95, 98, 96, 77, 82, 
  81, 83, 120, 86, 73, 84, 84, 73, 80, 91, 
  80, 75, 96, 76, 72, 83, 74, 84, 81, 71, 
  90, 75, 64, 77, 126, 90, 107, 99, 78, 98, 
  69, 84, 94, 72, 83, 84, 80, 90, 74, 76, 
  85, 89, 103, 71, 75, 81, 77, 72, 85, 83, 
  67, 78, 83, 81, 90, 120, 94, 69, 82, 89, 
  81, 79, 88, 86, 100, 87, 80, 92, 90, 85, 
  83, 94, 83, 69, 69, 75, 73, 96, 85, 88, 
  88, 77, 73, 87, 81, 77, 101, 98, 70, 81, 
  50, 86, 99, 88, 81, 84, 88, 85, 84, 88, 
  96, 96, 91, 82, 59, 82, 80, 84, 86, 83, 
  77, 90, 79, 83, 76, 86, 74, 80, 82, 78, 
  87, 93, 87, 92, 90, 96, 88, 83, 83, 80, 
  101, 79, 81, 83, 85, 77, 83, 82, 80, 82, 
  86, 78, 79, 83, 81, 85, 81, 81, 83, 77, 
  65, 72, 108, 91, 103, 87, 79, 87, 75, 89, 
  90, 79, 87, 85, 88, 86, 80, 87, 80, 87, 
  97, 74, 82, 73, 80, 75, 89, 83, 72, 90, 
  77, 84, 88, 107, 90, 85, 83, 90, 79, 77, 
  90, 83, 94, 93, 80, 85, 94, 93, 85, 96, 
  80, 72, 72, 81, 84, 99, 89, 87, 83, 89, 
  78, 85, 76, 75, 89, 96, 78, 81, 58, 84, 
  98, 84, 84, 88, 96, 87, 98, 92, 94, 95, 
  80, 83, 74, 83, 83, 81, 86, 79, 87, 89, 
  66, 77, 75, 94, 93, 76, 85, 90, 75, 78, 
  87, 86, 86, 87, 80, 86, 65, 80, 104, 78, 
  95, 107, 69, 94, 80, 85, 89, 81, 89, 77, 
  84, 82, 80, 83, 83, 92, 97, 84, 93, 103, 
  71, 87, 116, 84, 61, 88, 82, 92, 79, 76, 
  86, 75, 78, 79, 99, 91, 86, 76, 83, 85, 
  97, 89, 89, 96, 77, 84, 72, 87, 85, 83, 
  101, 94, 82, 89, 87, 92, 79, 82, 94, 83, 
  81, 94, 79, 80, 77, 79, 93, 83, 76, 88, 
  99, 76, 82, 93, 62, 80, 84, 91, 90, 85, 
  74, 82, 87, 90, 89, 87, 69, 94, 93, 91, 
  87, 73, 80, 92, 70, 94, 89, 96, 90, 88, 
  73, 84, 85, 84, 91, 90, 86, 90, 67, 77, 
  83, 63, 83, 91, 85, 87, 87, 78, 77, 85, 
  90, 80, 86, 83, 84, 81, 103, 78, 94, 99, 
  76, 92, 83, 85, 74, 89, 91, 73, 73, 83, 
  80, 78, 86, 83, 97, 84, 82, 82, 38, 79, 
  89, 78, 72, 88, 92, 90, 79, 82, 82, 86, 
  77, 76, 81, 92, 66, 88, 92, 87, 85, 104, 
  74, 96, 81, 82, 93, 69, 68, 81, 85, 80, 
  84, 75, 90, 87, 82, 86, 88, 90, 81, 92, 
  83, 92, 76, 82, 88, 84, 80, 74, 77, 80, 
  84, 73, 81, 88, 85, 88, 79, 79, 83, 85, 
  86, 88, 82, 84, 80, 90, 91, 84, 86, 71, 
  83, 78, 79, 88, 84, 82, 87, 88, 70, 84, 
  78, 90, 92, 89, 84, 93, 83, 81, 91, 70, 
  72, 106, 81, 84, 94, 85, 72, 93, 79, 76, 
  86, 92, 100, 89, 77, 68, 89, 91, 86, 78, 
  91, 87, 81, 80, 92, 83, 64, 79, 99, 100, 
  86, 72, 95, 73, 78, 64, 40, 76, 59, 77, 
  107, 83, 88, 91, 75, 87, 82, 104, 81, 81, 
  75, 94, 68, 95, 98, 88, 84, 87, 75, 80, 
  80, 77, 119, 80, 76, 73, 71, 73, 91, 73, 
  91, 99, 97, 79, 88, 89, 89, 90, 94, 95, 
  78, 94, 86, 77, 89, 76, 61, 79, 92, 63, 
  101, 87, 89, 83, 81, 77, 86, 81, 85, 89, 
  89, 79, 84, 83, 69, 89, 79, 81, 88, 81, 
  91, 79, 73, 69, 88, 92, 76, 84, 81, 98, 
  85, 81, 80, 79, 82, 82, 80, 89, 87, 94, 
  73, 87, 90, 80, 82, 90, 81, 88, 87, 96, 
  84, 75, 81, 72, 83, 88, 79, 96, 82, 95, 
  87, 88, 91, 82, 77, 68, 72, 87, 88, 83, 
  99, 76, 87, 89, 98, 80, 114, 78, 51, 77, 
  88, 86, 78, 79, 83, 90, 72, 75, 84, 77, 
  64, 74, 78, 84, 95, 78, 75, 90, 78, 86, 
  61, 75, 76, 72, 93, 103, 71, 78, 84, 99, 
  72, 91, 93, 77, 81, 96, 83, 79, 85, 83, 
  82, 81, 79, 80, 66, 83, 82, 92, 89, 92, 
  59, 95, 88, 82, 86, 85, 82, 75, 81, 94, 
  83, 88, 108, 89, 89, 80, 83, 92, 81, 84, 
  76, 92, 90, 89, 73, 89, 76, 84, 92, 92, 
  80, 77, 109, 80, 80, 78, 81, 91, 77, 87, 
  89, 83, 71, 89, 88, 80, 89, 76, 82, 74, 
  72, 85, 80, 91, 98, 86, 75, 86, 88, 90, 
  87, 92, 78, 72, 75, 89, 88, 76, 93, 69, 
  88, 75, 71, 83, 86, 84, 84, 77, 91, 84, 
  85, 79, 85, 91, 88, 72, 81, 72, 82, 85, 
  85, 90, 91, 80, 66, 82, 94, 83, 86, 66, 
  62, 81, 76, 79, 80, 80, 81, 95, 59, 85, 
  88, 86, 80, 91, 84, 92, 76, 81, 77, 83, 
  77, 66, 67, 77, 81, 71, 88, 88, 59, 88, 
  71, 69, 89, 83, 82, 95, 85, 89, 82, 81, 
  86, 74, 79, 81, 88, 90, 86, 83, 78, 76, 
  87, 82, 82, 81, 81, 86, 89, 82, 83, 83, 
  109, 83, 85, 85, 80, 83, 87, 83, 78, 80, 
  78, 93, 91, 80, 88, 82, 75, 86, 64, 87, 
  77, 94, 102, 66, 84, 80, 94, 78, 83, 93, 
  86, 80, 88, 90, 87, 77, 88, 69, 81, 74, 
  59, 86, 64, 87, 129, 85, 84, 92, 78, 86, 
  88, 86, 95, 87, 84, 85, 113, 89, 90, 94, 
  83, 81, 68, 79, 89, 76, 122, 69, 72, 84, 
  68, 68, 100, 82, 76, 87, 81, 75, 88, 92, 
  88, 81, 88, 92, 72, 87, 89, 82, 88, 80, 
  87, 73, 81, 67, 84, 92, 90, 80, 81, 76, 
  81, 79, 101, 104, 94, 83, 80, 80, 58, 81, 
  71, 80, 88, 86, 78, 88, 84, 66, 96, 86, 
  88, 74, 98, 90, 76, 76, 80, 80, 99, 83, 
  92, 90, 79, 98, 72, 83, 104, 85, 85, 88, 
  74, 82, 96, 101, 99, 76, 68, 69, 82, 82, 
  87, 90, 81, 95, 86, 78, 89, 91, 71, 75, 
  71, 95, 94, 74, 96, 81, 84, 77, 91, 76, 
  89, 74, 67, 80, 88, 84, 79, 82, 82, 106, 
  80, 85, 78, 75, 63, 84, 95, 83, 82, 70, 
  77, 80, 81, 77, 73, 80, 74, 74, 81, 86, 
  77, 76, 77, 101, 82, 96, 93, 78, 81, 84, 
  91, 86, 90, 91, 76, 75, 77, 86, 58, 84, 
  84, 86, 112, 98, 56, 89, 85, 92, 87, 83, 
  86, 73, 78, 90, 78, 81, 94, 83, 82, 85, 
  83, 84, 80, 79, 77, 75, 82, 91, 75, 86, 
  71, 98, 89, 94, 79, 71, 115, 81, 88, 98, 
  80, 84, 79, 87, 87, 89, 88, 91, 79, 83, 
  90, 87, 83, 73, 67, 98, 72, 83, 103, 82, 
  84, 81, 93, 74, 82, 99, 80, 78, 71, 100, 
  88, 74, 91, 77, 90, 84, 115, 88, 76, 90, 
  84, 75, 86, 85, 82, 86, 87, 91, 97, 89, 
  87, 71, 99, 75, 85, 93, 86, 65, 72, 72, 
  89, 75, 78, 81, 78, 77, 76, 79, 71, 81, 
  80, 102, 77, 86, 91, 77, 94, 79, 90, 88, 
  81, 86, 76, 80, 84, 72, 81, 76, 75, 80, 
  92, 87, 56, 83, 77, 82, 82, 82, 87, 84, 
  92, 90, 78, 76, 73, 79, 76, 92, 84, 87, 
  85, 85, 81, 80, 78, 84, 87, 76, 88, 88, 
  82, 80, 82, 77, 100, 83, 82, 97, 91, 73, 
  86, 91, 72, 87, 91, 90, 85, 84, 91, 81, 
  60, 82, 80, 89, 63, 92, 105, 68, 82, 74, 
  101, 79, 80, 94, 90, 81, 82, 89, 78, 89, 
  84, 81, 80, 84, 104, 99, 69, 99, 109, 77, 
  81, 98, 82, 76, 87, 69, 99, 91, 98, 83, 
  133, 76, 74, 101, 86, 72, 73, 77, 91, 83, 
  94, 82, 84, 89, 85, 80, 77, 90, 74, 91, 
  86, 79, 92, 84, 102, 82, 82, 91, 71, 82, 
  82, 86, 87, 80, 98, 73, 73, 79, 76, 90, 
  86, 88, 78, 82, 77, 85, 99, 89, 92, 85, 
  76, 80, 59, 83, 86, 86, 90, 92, 77, 99, 
  83, 85, 93, 82, 93, 75, 104, 81, 78, 73, 
  76, 71, 84, 83, 78, 85, 69, 94, 82, 83, 
  77, 92, 97, 91, 73, 65, 84, 94, 79, 99, 
  88, 94, 74, 82, 85, 74, 81, 76, 95, 99, 
  85, 76, 91, 65, 97, 80, 76, 79, 69, 77, 
  91, 64, 94, 62, 88, 92, 80, 80, 87, 82, 
  82, 76, 85, 77, 83, 99, 74, 97, 73, 74, 
  92, 76, 83, 85, 75, 85, 79, 90, 85, 83, 
  87, 92, 93, 94, 76, 94, 72, 78, 83, 75, 
  71, 85, 83, 81, 98, 74, 81, 74, 66, 79, 
  78, 77, 81, 95, 91, 90, 83, 84, 89, 75, 
  93, 87, 101, 97, 82, 85, 82, 91, 88, 89, 
  72, 80, 87, 77, 100, 74, 90, 74, 89, 83, 
  76, 98, 94, 78, 97, 87, 84, 66, 82, 81, 
  89, 81, 74, 81, 73, 98, 82, 86, 74, 91, 
  87, 77, 80, 59, 82, 98, 81, 92, 83, 92, 
  89, 83, 83, 64, 82, 78, 98, 96, 84, 81, 
  97, 58, 106, 66, 82, 84, 77, 67, 91, 61, 
  91, 64, 82, 87, 84, 82, 77, 85, 92, 75, 
  86, 74, 87, 90, 77, 86, 75, 68, 88, 81, 
  84, 78, 81, 83, 84, 85, 84, 86, 91, 86, 
  104, 94, 80, 88, 73, 76, 92, 72, 77, 86, 
  80, 96, 92, 69, 77, 83, 75, 78, 71, 83, 
  86, 88, 90, 87, 84, 72, 93, 77, 90, 71, 
  99, 93, 80, 87, 82, 94, 87, 94, 83, 86, 
  86, 80, 110, 84, 81, 75, 87, 81, 79, 95, 
  94, 80, 89, 85, 85, 73, 86, 88, 90, 83, 
  69, 81, 69, 93, 90, 79, 75, 86, 79, 72, 
  76, 70, 81, 92, 80, 94, 86, 93, 84, 85, 
  84, 76, 79, 74, 90, 76, 92, 79, 89, 72, 
  94, 73, 74, 77, 92, 82, 89, 66, 92, 70, 
  89, 93, 80, 85, 92, 85, 77, 79, 87, 81, 
  87, 73, 65, 92, 74, 77, 83, 78, 85, 79, 
  71, 89, 79, 85, 88, 82, 78, 94, 94, 86, 
  76, 90, 73, 74, 93, 79, 71, 92, 89, 80, 
  95, 78, 80, 85, 69, 75, 83, 77, 75, 95, 
  92, 89, 82, 89, 85, 87, 86, 82, 99, 93, 
  80, 87, 81, 78, 84, 91, 89, 77, 87, 84, 
  110, 81, 87, 74, 84, 85, 79, 95, 90, 80, 
  91, 79, 79, 72, 68, 71, 81, 77, 105, 87, 
  70, 75, 59, 84, 106, 75, 93, 64, 76, 69, 
  87, 77, 90, 144, 88, 87, 86, 75, 85, 59, 
  75, 82, 104, 92, 106, 74, 90, 99, 95, 57, 
  48, 81, 69, 64, 83, 80, 91, 77, 77, 73, 
  89, 79, 69, 72, 86, 73, 66, 74, 56, 113, 
  88, 134, 61, 91, 83, 74, 75, 74, 78, 64, 
  87, 72, 88, 80, 112, 87, 77, 89, 76, 86, 
  70, 81, 79, 78, 64, 64, 77, 79, 131, 81, 
  86, 83, 65, 85, 61, 80, 79, 76, 87, 83, 
  85, 74, 88, 76, 73, 93, 98, 102, 81, 83, 
  89, 138, 89, 76, 87, 97, 82, 76, 161, 67, 
  87, 77, 96, 75, 74, 99, 69, 64, 89, 80, 
  90, 67, 70, 98, 85, 73, 111, 82, 77, 72, 
  65, 85, 114, 78, 106, 65, 80, 78, 98, 77, 
  93, 162, 80, 87, 77, 78, 85, 56, 64, 78, 
  98, 76, 120, 78, 83, 84, 83, 55, 48, 78, 
  65, 58, 86, 96, 89, 96, 83, 67, 87, 74, 
  60, 62, 92, 67, 68, 79, 49, 124, 90, 150, 
  48, 76, 76, 71, 76, 79, 67, 70, 91, 76, 
  89, 72, 99, 81, 72, 78, 87, 72, 66, 69, 
  80, 84, 78, 69, 69, 51, 169, 83, 74, 90, 
  69, 80, 57, 72, 66, 70, 70, 97, 82, 68, 
  87, 79, 59, 79, 98, 98, 78, 77, 86, 147, 
  97, 69, 90, 94, 80, 75, 168, 66, 77, 72, 
  97, 71, 73, 99, 65, 60, 99, 77, 95, 51, 
  75, 100, 94, 81, 75, 99, 66, 80, 71, 82, 
  94, 75, 85, 82, 81, 74, 82, 80, 85, 140, 
  81, 90, 78, 83, 83, 68, 85, 86, 97, 84, 
  98, 79, 96, 69, 96, 76, 75, 81, 71, 72, 
  78, 79, 90, 66, 78, 76, 89, 95, 78, 87, 
  76, 86, 63, 77, 74, 92, 81, 106, 75, 90, 
  82, 76, 75, 61, 70, 72, 88, 79, 81, 91, 
  87, 96, 91, 85, 85, 92, 80, 78, 81, 78, 
  61, 69, 83, 60, 99, 90, 75, 87, 69, 83, 
  75, 88, 85, 82, 76, 78, 88, 76, 86, 83, 
  79, 85, 96, 100, 82, 84, 87, 109, 79, 90, 
  82, 85, 84, 87, 111, 84, 99, 75, 90, 85, 
  92, 105, 73, 68, 75, 79, 83, 88, 74, 81, 
  77, 84, 64, 89, 81, 83, 87, 86, 76, 99, 
  90, 76, 78, 87, 74, 83, 85, 96, 93, 91, 
  78, 99, 96, 64, 94, 82, 93, 87, 80, 88, 
  93, 91, 86, 85, 60, 87, 91, 77, 77, 61, 
  94, 64, 77, 99, 79, 91, 86, 90, 80, 80, 
  93, 89, 86, 79, 87, 78, 95, 81, 91, 85, 
  90, 81, 86, 74, 80, 76, 81, 78, 88, 83, 
  87, 78, 71, 87, 86, 82, 78, 73, 72, 88, 
  90, 75, 91, 86, 87, 78, 81, 98, 88, 84, 
  87, 82, 98, 74, 75, 80, 84, 91, 78, 95, 
  90, 91, 87, 82, 84, 82, 69, 94, 99, 79, 
  92, 91, 109, 92, 92, 82, 90, 77, 90, 89, 
  91, 76, 85, 94, 80, 67, 73, 93, 74, 82, 
  66, 82, 82, 79, 91, 89, 80, 98, 101, 93, 
  77, 90, 76, 86, 81, 94, 93, 88, 88, 102, 
  89, 57, 94, 84, 89, 88, 75, 85, 99, 91, 
  86, 76, 67, 83, 77, 67, 79, 57, 98, 68, 
  78, 86, 77, 84, 82, 89, 83, 89, 92, 85, 
  83, 95, 89, 80, 94, 78, 92, 86, 93, 75, 
  89, 75, 91, 76, 76, 90, 97, 77, 82, 76, 
  71, 83, 87, 79, 77, 70, 78, 84, 87, 84, 
  87, 90, 83, 76, 84, 101, 90, 80, 84, 74, 
  97, 69, 79, 71, 85, 93, 88, 95, 89, 88, 
  84, 93, 83, 94, 74, 94, 89, 83, 93, 81, 
  82, 94, 93, 78, 89, 83, 94, 90, 87, 73, 
  85, 92, 80, 72, 73, 92, 73, 84, 75, 79, 
  78, 81, 91, 85, 81, 94, 93, 97, 76, 90, 
  69, 80, 82, 98, 84, 94, 88, 95, 88, 71, 
  93, 82, 84, 86, 79, 85, 86, 86, 81, 87, 
  77, 85, 72, 84, 81, 63, 90, 73, 83, 83, 
  78, 84, 92, 87, 75, 86, 86, 96, 90, 89, 
  84, 85, 89, 83, 91, 89, 92, 77, 83, 84, 
  85, 86, 81, 80, 86, 89, 83, 77, 79, 86, 
  87, 74, 77, 74, 71, 82, 89, 75, 96, 91, 
  82, 71, 77, 95, 89, 80, 82, 81, 85, 70, 
  80, 84, 83, 94, 77, 82, 95, 90, 83, 83, 
  84, 81, 72, 91, 82, 77, 95, 80, 77, 88, 
  95, 77, 92, 82, 85, 93, 89, 76, 89, 91, 
  79, 73, 97, 78, 73, 89, 91, 86, 84, 87, 
  78, 86, 98, 82, 82, 96, 64, 68, 82, 83, 
  100, 76, 85, 84, 81, 83, 91, 70, 85, 107, 
  89, 79, 86, 79, 79, 70, 82, 93, 74, 69, 
  90, 73, 81, 81, 82, 75, 91, 97, 82, 75, 
  105, 86, 111, 72, 82, 81, 95, 81, 82, 72, 
  88, 72, 92, 81, 84, 85, 90, 106, 70, 83, 
  96, 82, 75, 76, 85, 73, 84, 88, 76, 93, 
  90, 95, 106, 80, 70, 81, 72, 81, 85, 75, 
  87, 98, 73, 74, 74, 72, 78, 90, 57, 95, 
  95, 85, 89, 78, 71, 77, 88, 96, 86, 68, 
  89, 95, 74, 80, 129, 84, 78, 103, 94, 87, 
  74, 71, 117, 79, 76, 110, 93, 91, 99, 83, 
  108, 91, 72, 91, 96, 73, 88, 81, 75, 84, 
  102, 74, 85, 94, 70, 71, 90, 80, 98, 71, 
  85, 83, 75, 91, 93, 73, 81, 106, 86, 82, 
  91, 85, 75, 63, 82, 81, 71, 69, 94, 61, 
  84, 86, 84, 77, 98, 100, 81, 73, 108, 81, 
  105, 76, 88, 79, 99, 84, 91, 73, 84, 65, 
  95, 84, 83, 84, 82, 111, 69, 84, 99, 75, 
  74, 76, 79, 72, 86, 86, 72, 80, 98, 96, 
  107, 82, 68, 86, 78, 73, 72, 70, 93, 113, 
  73, 68, 68, 78, 74, 96, 57, 95, 92, 82, 
  86, 83, 70, 77, 84, 104, 79, 67, 99, 90, 
  77, 79, 132, 75, 79, 106, 81, 93, 68, 70, 
  94, 79, 75, 108, 93, 86, 103, 80, 91, 92, 
  78, 94, 89, 81, 84, 82, 79, 85, 95, 86, 
  83, 87, 64, 73, 82, 83, 101, 77, 79, 86, 
  87, 81, 85, 71, 81, 105, 86, 84, 89, 86, 
  80, 77, 82, 93, 77, 68, 88, 77, 82, 81, 
  82, 79, 88, 100, 86, 90, 102, 86, 101, 72, 
  82, 81, 91, 84, 84, 68, 94, 71, 96, 84, 
  82, 81, 93, 104, 68, 90, 96, 79, 77, 74, 
  81, 72, 90, 86, 81, 75, 99, 92, 104, 79, 
  74, 102, 74, 76, 88, 80, 84, 104, 72, 74, 
  76, 74, 79, 90, 58, 92, 83, 82, 89, 89, 
  71, 77, 86, 89, 85, 71, 87, 92, 85, 79, 
  127, 94, 72, 96, 81, 90, 73, 74, 78, 80, 
  76, 105, 91, 85, 97, 86, 94, 79, 73, 84, 
  77, 87, 88, 93, 81, 80, 96, 77, 83, 91, 
  64, 71, 91, 84, 104, 75, 87, 82, 83, 83, 
  86, 74, 89, 97, 92, 80, 88, 81, 89, 76, 
  87, 90, 78, 69, 86, 70, 94, 86, 86, 80, 
  82, 94, 84, 77, 103, 85, 113, 77, 86, 82, 
  94, 88, 88, 64, 87, 70, 86, 83, 87, 88, 
  81, 104, 69, 78, 96, 75, 82, 77, 95, 78, 
  83, 78, 74, 87, 78, 107, 101, 83, 72, 77, 
  77, 87, 83, 73, 86, 81, 78, 76, 77, 72, 
  79, 100, 61, 93, 92, 97, 85, 81, 66, 78, 
  75, 80, 83, 73, 89, 97, 86, 88, 121, 73, 
  80, 96, 87, 92, 76, 80, 101, 81, 80, 113, 
  87, 75, 99, 89, 108, 88, 76, 82, 83, 77, 
  94, 86, 76, 76, 94, 73, 85, 89, 64, 68, 
  102, 79, 102, 70, 87, 84, 77, 87, 88, 77, 
  86, 91, 94, 88, 93, 83, 82, 72, 87, 82, 
  78, 68, 100, 62, 98, 94, 87, 83, 88, 97, 
  80, 73, 107, 78, 107, 82, 94, 82, 97, 92, 
  97, 64, 83, 62, 92, 88, 88, 86, 72, 111, 
  73, 73, 102, 76, 77, 75, 90, 74, 81, 68, 
  72, 82, 74, 114, 101, 88, 73, 76, 87, 88, 
  68, 69, 92, 82, 76, 67, 63, 77, 72, 109, 
  63, 93, 87, 96, 77, 77, 69, 79, 66, 87, 
  77, 72, 88, 91, 92, 89, 122, 66, 87, 98, 
  83, 93, 68, 84, 73, 81, 73, 108, 88, 68, 
  100, 85, 87, 90, 86, 89, 78, 83, 89, 87, 
  81, 83, 92, 78, 83, 82, 62, 74, 84, 81, 
  103, 73, 79, 81, 88, 81, 82, 76, 85, 100, 
  86, 95, 89, 88, 89, 79, 85, 93, 81, 68, 
  93, 76, 88, 84, 81, 82, 83, 97, 85, 82, 
  104, 88, 102, 77, 81, 80, 90, 79, 85, 67, 
  88, 74, 90, 77, 85, 82, 83, 102, 77, 82, 
  96, 81, 74, 79, 87, 79, 87, 79, 79, 81, 
  77, 101, 98, 83, 76, 99, 78, 88, 78, 78, 
  84, 91, 78, 72, 79, 78, 75, 96, 63, 89, 
  80, 94, 86, 77, 69, 79, 76, 77, 78, 74, 
  92, 95, 95, 86, 121, 87, 75, 91, 85, 93, 
  75, 83, 69, 87, 79, 108, 89, 77, 97, 92, 
  93, 77, 66, 91, 77, 84, 84, 97, 87, 78, 
  89, 78, 85, 86, 69, 74, 84, 81, 94, 81, 
  82, 92, 78, 80, 82, 80, 93, 89, 89, 83, 
  80, 78, 92, 71, 85, 86, 86, 81, 88, 66, 
  94, 90, 76, 84, 79, 91, 90, 83, 92, 93, 
  91, 77, 87, 82, 98, 84, 91, 62, 92, 71, 
  79, 81, 91, 87, 88, 99, 70, 84, 83, 87, 
  96, 73, 97, 78, 85, 80, 77, 92, 88, 85, 
  91, 65, 78, 75, 78, 80, 87, 87, 88, 71, 
  84, 89, 82, 81, 81, 78, 67, 76, 87, 89, 
  97, 85, 77, 79, 82, 77, 88, 83, 82, 90, 
  86, 89, 110, 80, 83, 94, 83, 85, 77, 73, 
  93, 76, 85, 109, 88, 77, 95, 83, 99, 79, 
  78, 87, 76, 79, 87, 94, 90, 77, 87, 81, 
  82, 90, 69, 74, 98, 83, 93, 75, 79, 89, 
  82, 81, 80, 79, 91, 85, 92, 85, 80, 81, 
  92, 69, 82, 81, 78, 75, 93, 58, 100, 90, 
  84, 83, 80, 91, 87, 77, 87, 91, 93, 75, 
  95, 81, 97, 80, 102, 62, 92, 65, 81, 87, 
  89, 83, 76, 98, 71, 78, 82, 83, 77, 68, 
  99, 75, 79, 76, 80, 86, 85, 89, 91, 69, 
  84, 83, 83, 81, 77, 81, 94, 75, 96, 85, 
  77, 85, 73, 78, 71, 80, 82, 88, 90, 74, 
  77, 81, 76, 81, 91, 79, 80, 90, 85, 89, 
  109, 75, 85, 94, 81, 82, 70, 75, 75, 80, 
  85, 105, 89, 74, 95, 78, 87, 80, 90, 90, 
  81, 78, 87, 89, 87, 84, 84, 80, 82, 86, 
  70, 77, 79, 78, 90, 72, 72, 94, 88, 82, 
  76, 80, 88, 92, 85, 93, 81, 81, 91, 79, 
  79, 92, 83, 79, 88, 73, 94, 92, 83, 82, 
  80, 91, 89, 80, 91, 96, 88, 79, 85, 83, 
  93, 77, 87, 66, 91, 72, 82, 85, 85, 88, 
  87, 96, 77, 83, 84, 94, 72, 74, 92, 83, 
  85, 80, 81, 79, 79, 86, 91, 68, 85, 102, 
  81, 83, 82, 87, 88, 80, 84, 81, 82, 80, 
  69, 81, 66, 74, 78, 87, 98, 79, 75, 80, 
  86, 79, 84, 81, 85, 91, 91, 88, 109, 88, 
  79, 92, 81, 85, 80, 77, 66, 76, 85, 101, 
  90, 81, 93, 84, 75, 66, 87, 71, 71, 71, 
  83, 83, 94, 95, 79, 71, 82, 67, 61, 72, 
  79, 116, 75, 72, 81, 85, 90, 86, 72, 78, 
  95, 88, 110, 72, 94, 78, 87, 72, 59, 80, 
  61, 81, 90, 82, 81, 85, 76, 71, 88, 74, 
  78, 80, 97, 87, 84, 62, 77, 77, 88, 66, 
  82, 63, 73, 78, 96, 90, 87, 97, 49, 74, 
  106, 125, 76, 124, 78, 81, 110, 73, 93, 79, 
  81, 57, 79, 68, 78, 62, 88, 109, 93, 86, 
  82, 94, 53, 101, 95, 91, 85, 84, 90, 82, 
  77, 84, 96, 65, 87, 85, 100, 98, 78, 106, 
  74, 82, 75, 86, 73, 149, 86, 84, 98, 105, 
  94, 76, 105, 78, 81, 66, 72, 76, 67, 84, 
  78, 77, 70, 74, 81, 71, 71, 85, 80, 87, 
  93, 100, 75, 89, 68, 79, 63, 71, 90, 119, 
  74, 77, 80, 85, 65, 84, 69, 77, 101, 88, 
  108, 65, 86, 82, 94, 74, 65, 92, 65, 80, 
  59, 68, 83, 74, 82, 76, 89, 74, 71, 88, 
  91, 87, 81, 61, 79, 77, 91, 61, 82, 59, 
  65, 74, 98, 88, 78, 96, 54, 69, 92, 136, 
  80, 109, 75, 70, 112, 75, 95, 72, 82, 62, 
  86, 59, 83, 60, 88, 75, 89, 80, 84, 94, 
  50, 100, 91, 122, 78, 83, 107, 86, 79, 82, 
  85, 66, 91, 126, 101, 97, 88, 109, 67, 79, 
  73, 83, 76, 151, 90, 82, 91, 88, 71, 73, 
  98, 71, 70, 66, 73, 72, 64, 85, 76, 74, 
  91, 81, 96, 72, 82, 82, 67, 104, 85, 92, 
  80, 84, 85, 88, 57, 81, 94, 100, 79, 77, 
  92, 87, 69, 78, 73, 82, 98, 83, 105, 71, 
  84, 84, 112, 77, 70, 90, 72, 88, 83, 96, 
  85, 76, 75, 77, 88, 97, 80, 85, 89, 90, 
  92, 92, 79, 75, 102, 78, 92, 62, 90, 71, 
  81, 93, 83, 75, 45, 88, 81, 105, 83, 74, 
  67, 74, 127, 81, 76, 81, 75, 75, 75, 80, 
  89, 71, 91, 80, 85, 82, 89, 81, 68, 88, 
  100, 118, 82, 88, 109, 83, 71, 82, 93, 78, 
  80, 92, 93, 87, 68, 101, 76, 88, 70, 95, 
  82, 104, 89, 88, 89, 99, 76, 77, 91, 72, 
  87, 77, 90, 88, 74, 75, 90, 98, 80, 80, 
  91, 88, 86, 80, 97, 76, 78, 85, 86, 75, 
  90, 77, 82, 75, 70, 80, 76, 74, 88, 85, 
  81, 87, 80, 79, 82, 91, 91, 84, 95, 79, 
  76, 98, 73, 85, 73, 79, 92, 91, 78, 76, 
  74, 85, 77, 75, 86, 83, 82, 77, 79, 86, 
  75, 91, 78, 87, 65, 82, 81, 82, 93, 79, 
  92, 95, 87, 61, 73, 69, 82, 108, 77, 97, 
  76, 77, 97, 68, 88, 69, 90, 80, 91, 73, 
  79, 89, 99, 86, 84, 98, 77, 82, 78, 68, 
  84, 88, 72, 69, 87, 99, 86, 84, 80, 75, 
  93, 88, 94, 84, 89, 84, 98, 84, 95, 100, 
  87, 81, 88, 102, 97, 79, 93, 99, 89, 71, 
  91, 82, 81, 88, 77, 72, 79, 95, 76, 87, 
  94, 77, 103, 71, 81, 87, 84, 89, 94, 93, 
  91, 80, 74, 77, 81, 73, 73, 84, 71, 91, 
  82, 82, 82, 99, 90, 61, 105, 73, 75, 99, 
  80, 82, 70, 75, 72, 89, 79, 77, 102, 90, 
  71, 69, 86, 79, 86, 81, 83, 84, 76, 98, 
  80, 94, 58, 86, 79, 89, 94, 73, 77, 95, 
  78, 58, 65, 63, 78, 80, 95, 96, 62, 74, 
  113, 63, 90, 87, 107, 72, 94, 83, 85, 58, 
  99, 85, 83, 91, 72, 94, 70, 76, 75, 94, 
  65, 71, 95, 105, 95, 81, 72, 88, 92, 91, 
  104, 80, 81, 82, 109, 85, 99, 96, 93, 84, 
  81, 90, 72, 81, 94, 93, 71, 66, 92, 77, 
  81, 86, 67, 70, 77, 92, 77, 78, 77, 103, 
  84, 83, 77, 99, 86, 82, 68, 101, 68, 69, 
  86, 88, 78, 90, 86, 79, 68, 82, 82, 81, 
  98, 93, 88, 73, 84, 74, 83, 79, 78, 98, 
  74, 80, 67, 75, 84, 78, 83, 79, 80, 85, 
  82, 97, 82, 78, 80, 75, 69, 78, 91, 72, 
  90, 74, 75, 74, 93, 97, 93, 85, 70, 67, 
  70, 99, 82, 86, 94, 81, 94, 86, 103, 82, 
  88, 88, 100, 77, 82, 66, 79, 63, 95, 77, 
  91, 84, 73, 90, 78, 104, 78, 86, 92, 75, 
  81, 93, 82, 76, 84, 120, 98, 92, 76, 91, 
  74, 76, 86, 81, 88, 114, 84, 86, 89, 88, 
  83, 77, 86, 76, 81, 69, 78, 80, 76, 73, 
  84, 79, 80, 84, 87, 86, 88, 91, 86, 84, 
  67, 85, 88, 90, 91, 80, 90, 72, 75, 82, 
  78, 80, 90, 91, 81, 86, 87, 81, 79, 80, 
  85, 88, 77, 80, 82, 98, 80, 90, 86, 85, 
  88, 93, 81, 66, 77, 86, 83, 77, 86, 79, 
  71, 74, 85, 107, 75, 90, 75, 84, 77, 77, 
  92, 80, 79, 89, 96, 87, 86, 74, 84, 79, 
  87, 85, 81, 91, 85, 76, 87, 71, 94, 83, 
  75, 86, 96, 80, 85, 85, 83, 82, 92, 80, 
  105, 81, 87, 78, 95, 97, 82, 77, 73, 92, 
  76, 92, 87, 78, 82, 75, 75, 85, 93, 89, 
  98, 90, 87, 80, 87, 81, 77, 85, 88, 81, 
  90, 101, 91, 87, 85, 87, 92, 79, 91, 83, 
  78, 89, 91, 86, 90, 81, 87, 79, 76, 81, 
  88, 99, 101, 89, 93, 77, 78, 84, 79, 79, 
  80, 90, 82, 93, 83, 76, 78, 84, 83, 77, 
  81, 83, 86, 92, 78, 86, 90, 92, 83, 96, 
  86, 72, 93, 88, 79, 76, 83, 74, 67, 80, 
  95, 108, 75, 92, 77, 85, 73, 73, 97, 78, 
  77, 86, 88, 86, 84, 74, 79, 76, 89, 82, 
  93, 90, 86, 78, 86, 76, 93, 89, 76, 90, 
  97, 86, 90, 80, 75, 83, 87, 81, 97, 89, 
  84, 77, 94, 96, 75, 74, 80, 98, 89, 99, 
  85, 80, 76, 76, 68, 84, 85, 89, 91, 95, 
  86, 75, 87, 89, 81, 76, 85, 82, 91, 98, 
  86, 83, 85, 84, 90, 76, 87, 84, 83, 108, 
  93, 83, 86, 98, 84, 86, 77, 85, 88, 86, 
  79, 98, 78, 72, 82, 85, 79, 80, 89, 81, 
  80, 87, 86, 85, 81, 85, 77, 72, 83, 83, 
  86, 85, 85, 96, 84, 82, 79, 83, 89, 78, 
  88, 78, 79, 84, 84, 88, 81, 76, 86, 85, 
  71, 82, 85, 86, 86, 82, 77, 76, 86, 91, 
  97, 93, 74, 76, 83, 84, 95, 76, 88, 82, 
  88, 77, 98, 81, 86, 90, 90, 83, 87, 78, 
  80, 70, 80, 79, 87, 80, 90, 88, 82, 80, 
  89, 95, 90, 74, 78, 96, 94, 81, 86, 92, 
  83, 80, 67, 87, 83, 79, 97, 90, 89, 84, 
  87, 91, 80, 81, 97, 80, 86, 82, 82, 77, 
  87, 86, 81, 81, 88, 85, 82, 79, 79, 105, 
  90, 79, 81, 71, 82, 70, 71, 90, 85, 82, 
  81, 80, 87, 93, 60, 81, 86, 81, 99, 77, 
  77, 65, 83, 116, 94, 79, 84, 85, 76, 85, 
  79, 82, 78, 79, 86, 82, 86, 82, 82, 85, 
  89, 75, 83, 94, 81, 82, 82, 78, 82, 94, 
  85, 90, 65, 83, 78, 83, 87, 104, 85, 88, 
  96, 75, 78, 92, 79, 97, 75, 88, 88, 84, 
  82, 77, 85, 86, 80, 82, 69, 83, 72, 93, 
  89, 82, 79, 79, 77, 77, 80, 88, 86, 77, 
  88, 81, 103, 90, 94, 82, 82, 81, 101, 90, 
  89, 92, 75, 105, 95, 80, 78, 81, 76, 77, 
  99, 90, 94, 77, 67, 78, 85, 75, 84, 71, 
  87, 80, 70, 99, 81, 87, 83, 114, 100, 92, 
  84, 63, 88, 60, 68, 82, 87, 82, 89, 87, 
  90, 94, 55, 83, 86, 74, 87, 79, 86, 65, 
  80, 129, 97, 85, 85, 95, 78, 83, 83, 84, 
  84, 69, 84, 84, 90, 85, 87, 89, 94, 74, 
  84, 83, 81, 83, 84, 76, 79, 96, 90, 85, 
  64, 79, 77, 80, 87, 98, 86, 81, 86, 67, 
  72, 89, 74, 97, 82, 90, 81, 85, 84, 75, 
  81, 87, 80, 90, 70, 80, 78, 77, 91, 81, 
  80, 83, 76, 88, 75, 87, 86, 80, 80, 90, 
  107, 89, 89, 81, 76, 87, 97, 90, 85, 90, 
  77, 110, 100, 85, 79, 89, 77, 75, 99, 88, 
  77, 72, 58, 83, 79, 75, 84, 78, 94, 76, 
  60, 102, 83, 92, 87, 103, 84, 95, 81, 72, 
  82, 73, 72, 89, 81, 82, 80, 84, 86, 86, 
  60, 83, 80, 74, 73, 78, 84, 71, 84, 114, 
  91, 77, 86, 91, 76, 77, 76, 91, 84, 81, 
  81, 84, 81, 85, 85, 83, 89, 79, 86, 82, 
  77, 79, 82, 77, 83, 91, 85, 83, 67, 88, 
  76, 84, 90, 101, 86, 90, 96, 75, 77, 90, 
  77, 91, 93, 85, 90, 85, 83, 81, 80, 89, 
  84, 85, 71, 84, 72, 83, 89, 80, 85, 77, 
  82, 86, 80, 96, 83, 78, 76, 80, 102, 92, 
  81, 87, 82, 98, 106, 89, 85, 89, 79, 100, 
  99, 82, 78, 82, 82, 79, 95, 85, 77, 79, 
  68, 78, 78, 74, 77, 74, 89, 79, 68, 95, 
  77, 75, 85, 118, 86, 88, 76, 75, 83, 67, 
  75, 81, 84, 84, 78, 94, 88, 86, 57, 81, 
  85, 77, 98, 77, 82, 66, 75, 132, 97, 89, 
  81, 86, 79, 80, 86, 80, 79, 86, 85, 77, 
  81, 85, 77, 89, 86, 75, 79, 101, 74, 81, 
  73, 84, 79, 94, 89, 93, 62, 93, 76, 84, 
  78, 99, 84, 84, 89, 73, 83, 86, 87, 86, 
  91, 81, 77, 80, 83, 72, 83, 81, 78, 76, 
  75, 95, 66, 80, 89, 80, 76, 85, 81, 71, 
  82, 87, 86, 79, 86, 83, 110, 89, 88, 87, 
  74, 79, 101, 85, 87, 93, 80, 106, 92, 72, 
  86, 86, 83, 83, 93, 87, 85, 80, 64, 81, 
  82, 75, 88, 73, 98, 79, 59, 99, 92, 90, 
  93, 123, 95, 88, 78, 78, 100, 58, 79, 76, 
  103, 80, 84, 105, 91, 82, 53, 80, 81, 68, 
  84, 86, 88, 70, 75, 148, 97, 83, 81, 99, 
  83, 74, 91, 74, 87, 82, 88, 87, 77, 107, 
  84, 86, 92, 66, 81, 86, 73, 83, 83, 85, 
  79, 97, 91, 93, 61, 90, 66, 75, 71, 88, 
  83, 98, 68, 76, 80, 72, 85, 73, 81, 86, 
  70, 87, 79, 70, 82, 90, 74, 93, 77, 100, 
  77, 72, 89, 83, 72, 85, 80, 76, 85, 82, 
  85, 74, 69, 88, 118, 85, 91, 92, 69, 74, 
  89, 82, 77, 92, 82, 112, 100, 79, 92, 82, 
  84, 66, 91, 85, 69, 77, 57, 81, 75, 74, 
  98, 86, 111, 72, 51, 107, 79, 92, 98, 116, 
  81, 98, 76, 74, 80, 71, 74, 83, 78, 81, 
  79, 91, 86, 83, 59, 91, 78, 77, 82, 77, 
  85, 72, 78, 126, 93, 76, 82, 90, 77, 73, 
  86, 89, 85, 86, 82, 80, 79, 85, 83, 84, 
  84, 75, 79, 82, 70, 77, 77, 79, 81, 91, 
  90, 88, 66, 94, 77, 85, 83, 96, 86, 84, 
  92, 73, 82, 87, 85, 90, 89, 81, 83, 81, 
  86, 74, 81, 93, 88, 79, 75, 94, 72, 84, 
  87, 80, 86, 82, 81, 82, 79, 89, 84, 79, 
  78, 83, 107, 90, 87, 91, 75, 88, 102, 85, 
  81, 92, 81, 99, 93, 73, 84, 85, 87, 75, 
  88, 84, 89, 84, 65, 81, 74, 76, 81, 72, 
  98, 80, 61, 92, 73, 75, 86, 121, 83, 82, 
  72, 75, 81, 74, 82, 85, 81, 78, 77, 91, 
  88, 82, 58, 85, 90, 77, 89, 76, 85, 78, 
  73, 114, 92, 82, 86, 89, 80, 88, 84, 84, 
  83, 101, 84, 85, 81, 87, 78, 82, 87, 91, 
  71, 96, 72, 85, 77, 79, 86, 90, 91, 91, 
  72, 87, 88, 78, 80, 89, 81, 83, 97, 82, 
  91, 87, 94, 79, 95, 92, 85, 84, 77, 83, 
  79, 86, 80, 84, 74, 84, 66, 79, 88, 85, 
  75, 75, 77, 76, 94, 83, 82, 83, 93, 75, 
  102, 87, 84, 101, 82, 81, 100, 84, 85, 94, 
  84, 95, 84, 65, 82, 85, 78, 94, 92, 85, 
  81, 87, 73, 94, 77, 74, 80, 66, 88, 84, 
  65, 94, 73, 83, 102, 124, 85, 90, 75, 74, 
  85, 73, 82, 79, 90, 80, 78, 92, 88, 85, 
  50, 89, 83, 67, 87, 79, 85, 83, 71, 130, 
  88, 77, 83, 97, 78, 87, 85, 82, 89, 115, 
  83, 90, 79, 86, 86, 81, 87, 80, 63, 91, 
  74, 84, 79, 81, 86, 91, 86, 90, 69, 73, 
  78, 71, 74, 88, 84, 78, 88, 77, 87, 82, 
  100, 88, 84, 95, 83, 87, 75, 79, 80, 96, 
  73, 94, 76, 83, 63, 78, 88, 85, 76, 82, 
  66, 74, 93, 88, 81, 83, 89, 78, 106, 84, 
  84, 102, 73, 80, 93, 83, 77, 101, 82, 99, 
  76, 67, 82, 83, 77, 79, 90, 88, 82, 91, 
  65, 88, 74, 74, 85, 63, 95, 81, 61, 90, 
  77, 83, 92, 117, 81, 89, 75, 78, 78, 76, 
  80, 88, 81, 84, 77, 86, 89, 83, 60, 86, 
  82, 76, 83, 75, 84, 80, 71, 109, 88, 76, 
  89, 90, 79, 90, 80, 87, 86, 98, 80, 84, 
  80, 83, 90, 82, 86, 84, 71, 88, 67, 83, 
  77, 79, 85, 87, 88, 86, 78, 86, 86, 80, 
  83, 84, 83, 84, 93, 84, 87, 86, 97, 85, 
  77, 87, 88, 85, 79, 84, 83, 95, 80, 81, 
  73, 83, 72, 78, 89, 77, 92, 77, 70, 80, 
  92, 92, 83, 86, 83, 74, 98, 89, 85, 96, 
  84, 81, 101, 85, 75, 91, 84, 88, 83, 70, 
  78, 83, 78, 77, 92, 83, 98, 89, 78, 92, 
  82, 77, 80, 69, 86, 88, 70, 90, 85, 76, 
  95, 78, 81, 92, 73, 91, 73, 81, 83, 83, 
  103, 78, 96, 73, 94, 82, 79, 113, 101, 88, 
  86, 86, 82, 78, 79, 83, 81, 80, 79, 79, 
  98, 67, 65, 86, 71, 74, 70, 97, 88, 80, 
  81, 74, 86, 78, 94, 83, 84, 64, 75, 98, 
  87, 80, 89, 77, 76, 80, 81, 124, 93, 76, 
  98, 89, 95, 88, 95, 81, 83, 87, 68, 87, 
  84, 96, 79, 77, 56, 87, 105, 75, 78, 78, 
  87, 90, 87, 72, 89, 85, 76, 89, 83, 94, 
  76, 87, 78, 75, 78, 70, 89, 83, 53, 46, 
  80, 126, 82, 83, 83, 97, 95, 90, 78, 86, 
  93, 92, 92, 80, 94, 80, 65, 94, 96, 88, 
  78, 82, 60, 98, 81, 80, 82, 77, 70, 76, 
  66, 75, 62, 82, 64, 82, 87, 76, 107, 76, 
  111, 52, 111, 80, 81, 121, 86, 63, 84, 79, 
  78, 75, 86, 82, 105, 80, 68, 81, 105, 70, 
  77, 64, 81, 76, 80, 77, 76, 88, 100, 60, 
  86, 64, 78, 79, 77, 65, 75, 70, 64, 79, 
  76, 83, 73, 72, 73, 139, 91, 75, 81, 91, 
  80, 82, 108, 112, 73, 83, 81, 90, 78, 98, 
  75, 70, 60, 63, 102, 71, 66, 68, 89, 102, 
  94, 68, 80, 87, 52, 69, 89, 110, 80, 89, 
  78, 79, 80, 58, 83, 85, 53, 92, 89, 119, 
  104, 76, 92, 104, 98, 85, 75, 86, 83, 81, 
  77, 85, 69, 88, 75, 77, 99, 104, 74, 69, 
  34, 91, 92, 102, 86, 105, 81, 85, 94, 78, 
  82, 87, 99, 84, 70, 92, 72, 74, 86, 83, 
  90, 92, 82, 76, 88, 87, 84, 91, 86, 81, 
  87, 82, 79, 69, 89, 76, 88, 89, 85, 88, 
  90, 77, 76, 97, 93, 87, 97, 95, 93, 81, 
  101, 95, 82, 71, 76, 103, 108, 85, 119, 89, 
  80, 79, 94, 88, 81, 89, 91, 64, 81, 92, 
  83, 75, 92, 87, 106, 84, 84, 83, 79, 82, 
  67, 85, 103, 83, 110, 71, 85, 85, 83, 77, 
  96, 81, 101, 80, 90, 92, 76, 91, 97, 80, 
  74, 81, 80, 85, 63, 64, 82, 115, 75, 91, 
  80, 91, 84, 94, 77, 79, 98, 88, 67, 81, 
  91, 78, 70, 92, 102, 65, 87, 98, 80, 87, 
  80, 85, 91, 57, 82, 77, 85, 80, 79, 88, 
  63, 84, 99, 69, 97, 62, 96, 77, 83, 72, 
  87, 111, 89, 83, 89, 81, 69, 88, 90, 88, 
  97, 70, 74, 82, 91, 83, 88, 87, 55, 82, 
  76, 86, 81, 83, 96, 69, 84, 78, 97, 86, 
  71, 65, 77, 81, 68, 84, 84, 91, 83, 81, 
  83, 148, 81, 87, 86, 89, 85, 75, 88, 81, 
  86, 63, 95, 107, 94, 84, 81, 81, 66, 86, 
  86, 86, 58, 71, 84, 103, 97, 77, 89, 83, 
  84, 103, 84, 88, 71, 82, 95, 82, 74, 56, 
  83, 79, 54, 87, 82, 120, 75, 79, 77, 100, 
  95, 92, 86, 78, 87, 87, 80, 77, 78, 85, 
  74, 80, 77, 106, 69, 73, 59, 79, 92, 73, 
  82, 76, 79, 78, 70, 72, 67, 76, 46, 88, 
  99, 67, 99, 77, 107, 65, 93, 65, 81, 138, 
  80, 68, 83, 74, 75, 87, 92, 86, 110, 104, 
  65, 86, 86, 77, 83, 75, 79, 95, 72, 69, 
  91, 89, 81, 55, 90, 55, 77, 74, 75, 72, 
  70, 50, 40, 85, 57, 71, 81, 72, 62, 162, 
  95, 81, 78, 97, 68, 67, 92, 102, 80, 64, 
  66, 128, 86, 74, 73, 76, 78, 69, 79, 81, 
  41, 68, 77, 95, 103, 92, 79, 89, 51, 93, 
  79, 90, 84, 75, 90, 85, 75, 44, 84, 85, 
  64, 79, 94, 114, 82, 69, 75, 108, 89, 86, 
  82, 74, 77, 80, 89, 85, 66, 97, 77, 78, 
  104, 120, 52, 63, 27, 70, 100, 94, 85, 107, 
  88, 86, 88, 89, 86, 86, 100, 84, 75, 85, 
  73, 91, 85, 91, 80, 94, 83, 68, 87, 103, 
  87, 85, 75, 78, 95, 87, 88, 74, 85, 81, 
  84, 77, 89, 85, 76, 82, 80, 95, 87, 88, 
  89, 89, 91, 80, 96, 76, 73, 74, 75, 104, 
  96, 83, 120, 74, 79, 72, 93, 91, 81, 90, 
  84, 53, 81, 87, 82, 70, 90, 82, 93, 89, 
  97, 86, 77, 80, 75, 81, 72, 94, 103, 65, 
  87, 90, 79, 83, 90, 83, 101, 76, 92, 84, 
  74, 81, 90, 81, 79, 75, 93, 76, 63, 46, 
  80, 111, 70, 88, 82, 85, 81, 92, 87, 83, 
  91, 88, 75, 95, 101, 78, 76, 88, 101, 73, 
  78, 90, 76, 85, 82, 84, 94, 68, 93, 93, 
  78, 90, 82, 89, 86, 93, 86, 86, 99, 80, 
  94, 88, 81, 87, 86, 80, 97, 78, 82, 92, 
  86, 85, 77, 85, 81, 81, 93, 92, 83, 78, 
  72, 87, 72, 87, 85, 87, 89, 68, 92, 97, 
  80, 97, 89, 93, 72, 89, 80, 101, 97, 93, 
  108, 88, 79, 83, 98, 96, 73, 91, 96, 85, 
  91, 78, 91, 83, 84, 85, 85, 76, 95, 90, 
  87, 82, 84, 83, 80, 74, 90, 94, 87, 82, 
  89, 85, 89, 82, 94, 108, 86, 97, 71, 74, 
  91, 71, 79, 84, 78, 80, 59, 108, 85, 109, 
  87, 89, 91, 78, 83, 89, 86, 77, 96, 83, 
  92, 95, 80, 84, 78, 84, 87, 81, 86, 86, 
  94, 87, 90, 68, 89, 83, 82, 93, 75, 77, 
  78, 79, 90, 88, 86, 84, 103, 95, 97, 90, 
  84, 91, 86, 74, 89, 82, 88, 99, 87, 75, 
  82, 90, 90, 86, 86, 81, 82, 70, 68, 67, 
  74, 84, 84, 84, 82, 72, 85, 88, 73, 101, 
  82, 69, 68, 98, 77, 100, 93, 92, 111, 91, 
  78, 88, 94, 78, 74, 87, 91, 82, 92, 76, 
  80, 71, 77, 93, 71, 69, 87, 87, 79, 79, 
  75, 77, 75, 67, 85, 88, 95, 87, 89, 87, 
  84, 82, 105, 119, 85, 95, 77, 62, 85, 66, 
  81, 73, 94, 83, 66, 101, 78, 105, 81, 96, 
  90, 81, 78, 88, 83, 79, 90, 86, 93, 98, 
  79, 80, 71, 89, 87, 83, 82, 81, 76, 81, 
  90, 78, 88, 101, 83, 90, 83, 83, 80, 87, 
  89, 94, 86, 89, 86, 85, 89, 96, 88, 82, 
  82, 80, 83, 84, 83, 87, 82, 79, 85, 78, 
  78, 80, 87, 81, 76, 83, 87, 92, 83, 85, 
  78, 89, 89, 79, 89, 99, 84, 85, 76, 87, 
  77, 79, 80, 85, 95, 90, 100, 82, 83, 84, 
  88, 97, 81, 89, 87, 72, 91, 88, 87, 89, 
  94, 83, 78, 82, 84, 84, 88, 82, 77, 87, 
  69, 85, 98, 82, 83, 92, 88, 84, 86, 84, 
  82, 99, 79, 98, 78, 79, 96, 78, 81, 89, 
  95, 75, 70, 88, 87, 103, 86, 83, 90, 86, 
  92, 77, 89, 79, 92, 89, 76, 94, 92, 84, 
  78, 86, 86, 81, 77, 89, 89, 87, 87, 73, 
  103, 83, 91, 88, 111, 80, 73, 88, 70, 89, 
  89, 85, 92, 90, 77, 69, 85, 82, 93, 102, 
  76, 79, 76, 73, 95, 92, 69, 79, 92, 87, 
  87, 87, 86, 86, 86, 94, 74, 71, 77, 92, 
  75, 76, 97, 71, 84, 75, 75, 83, 87, 74, 
  80, 70, 70, 95, 60, 87, 77, 89, 69, 98, 
  88, 88, 106, 68, 69, 79, 82, 105, 89, 81, 
  84, 93, 86, 79, 106, 76, 76, 75, 86, 87, 
  72, 88, 82, 74, 89, 71, 91, 96, 82, 81, 
  82, 88, 82, 102, 71, 107, 93, 94, 92, 89, 
  86, 93, 95, 90, 81, 74, 83, 91, 94, 77, 
  80, 82, 95, 89, 94, 70, 84, 84, 77, 81, 
  101, 78, 73, 80, 75, 79, 88, 67, 90, 91, 
  83, 89, 100, 93, 76, 90, 78, 94, 91, 91, 
  87, 94, 76, 71, 86, 78, 90, 104, 73, 73, 
  70, 80, 90, 85, 87, 84, 95, 88, 84, 92, 
  89, 73, 90, 108, 85, 78, 81, 80, 77, 75, 
  101, 75, 90, 90, 77, 87, 79, 78, 78, 83, 
  70, 86, 80, 99, 87, 83, 82, 101, 79, 79, 
  93, 58, 66, 71, 79, 102, 75, 72, 109, 86, 
  92, 87, 103, 77, 74, 79, 83, 71, 81, 77, 
  86, 72, 82, 77, 83, 85, 80, 75, 77, 101, 
  81, 102, 80, 95, 87, 84, 78, 87, 82, 105, 
  93, 86, 84, 79, 87, 87, 99, 78, 80, 85, 
  91, 84, 89, 72, 74, 79, 81, 79, 86, 86, 
  82, 81, 73, 77, 85, 82, 80, 97, 91, 86, 
  76, 103, 81, 79, 94, 89, 79, 90, 95, 87, 
  61, 78, 80, 83, 72, 90, 84, 94, 72, 91, 
  87, 78, 107, 88, 100, 84, 88, 91, 91, 63, 
  88, 94, 83, 84, 93, 74, 86, 74, 93, 90, 
  88, 129, 97, 92, 80, 97, 79, 110, 92, 71, 
  129, 106, 104, 71, 105, 85, 71, 80, 84, 65, 
  53, 73, 65, 77, 78, 93, 91, 75, 103, 99, 
  81, 85, 94, 94, 82, 62, 91, 68, 94, 76, 
  63, 87, 88, 70, 77, 65, 92, 108, 98, 85, 
  90, 71, 66, 77, 82, 90, 89, 88, 81, 83, 
  87, 89, 90, 81, 87, 96, 79, 85, 78, 81, 
  81, 100, 101, 83, 91, 85, 95, 100, 87, 76, 
  88, 85, 75, 112, 94, 78, 85, 89, 78, 82, 
  79, 91, 78, 89, 83, 90, 81, 85, 93, 71, 
  84, 91, 87, 76, 82, 79, 79, 77, 86, 85, 
  73, 78, 81, 80, 84, 88, 75, 83, 92, 81, 
  79, 82, 77, 87, 82, 90, 92, 78, 76, 79, 
  83, 84, 84, 71, 95, 73, 78, 91, 71, 80, 
  75, 87, 72, 68, 81, 91, 90, 80, 77, 93, 
  79, 69, 94, 85, 87, 89, 85, 84, 98, 70, 
  93, 75, 80, 109, 73, 88, 80, 64, 83, 72, 
  85, 91, 87, 76, 73, 85, 92, 83, 69, 103, 
  91, 96, 102, 94, 84, 83, 83, 87, 79, 78, 
  75, 83, 68, 83, 83, 84, 90, 77, 84, 73, 
  74, 84, 85, 93, 97, 75, 69, 74, 64, 77, 
  83, 68, 91, 89, 83, 88, 94, 83, 80, 92, 
  76, 93, 93, 89, 77, 96, 88, 79, 92, 81, 
  94, 91, 72, 73, 72, 81, 84, 92, 70, 80, 
  74, 79, 87, 91, 77, 86, 88, 95, 87, 82, 
  78, 84, 86, 85, 94, 78, 83, 73, 77, 85, 
  82, 70, 95, 71, 70, 95, 71, 85, 81, 85, 
  78, 89, 80, 78, 92, 66, 68, 81, 79, 86, 
  91, 78, 84, 87, 83, 80, 103, 72, 78, 76, 
  74, 94, 81, 86, 76, 67, 96, 82, 81, 90, 
  81, 73, 70, 79, 81, 98, 76, 103, 91, 95, 
  86, 83, 78, 86, 89, 83, 77, 72, 81, 85, 
  80, 75, 83, 83, 89, 83, 78, 73, 78, 77, 
  81, 85, 83, 75, 80, 82, 63, 76, 85, 67, 
  88, 96, 87, 84, 75, 108, 84, 83, 82, 97, 
  88, 87, 85, 88, 75, 80, 86, 86, 78, 91, 
  78, 81, 71, 80, 84, 85, 91, 86, 85, 74, 
  84, 92, 80, 64, 93, 97, 85, 76, 84, 73, 
  82, 73, 84, 84, 86, 106, 91, 89, 77, 92, 
  76, 103, 82, 78, 104, 94, 95, 76, 92, 87, 
  81, 79, 84, 68, 64, 74, 67, 86, 80, 92, 
  105, 72, 96, 91, 85, 85, 91, 91, 81, 71, 
  89, 75, 82, 73, 71, 78, 93, 81, 73, 67, 
  82, 98, 90, 87, 86, 82, 78, 79, 68, 90, 
  82, 93, 87, 76, 81, 80, 86, 80, 86, 88, 
  81, 85, 75, 85, 76, 83, 99, 79, 89, 86, 
  94, 91, 88, 74, 85, 82, 77, 100, 92, 79, 
  88, 89, 76, 86, 78, 89, 79, 93, 83, 91, 
  87, 81, 89, 77, 85, 92, 81, 93, 87, 82, 
  85, 81, 84, 86, 92, 85, 86, 86, 83, 87, 
  82, 76, 96, 87, 84, 88, 77, 87, 90, 94, 
  92, 83, 80, 77, 78, 78, 82, 75, 84, 77, 
  87, 84, 75, 80, 74, 99, 75, 78, 77, 85, 
  84, 82, 82, 89, 75, 81, 88, 90, 81, 86, 
  86, 89, 99, 77, 90, 77, 79, 88, 73, 85, 
  78, 68, 82, 70, 84, 92, 86, 69, 84, 88, 
  100, 84, 71, 91, 81, 86, 104, 94, 86, 90, 
  78, 84, 91, 75, 86, 87, 80, 89, 83, 87, 
  86, 73, 82, 75, 76, 80, 91, 87, 99, 86, 
  81, 69, 74, 86, 81, 76, 89, 77, 89, 90, 
  90, 81, 81, 90, 79, 88, 94, 89, 85, 90, 
  88, 83, 97, 88, 85, 90, 76, 80, 77, 83, 
  79, 90, 82, 86, 87, 88, 88, 91, 78, 89, 
  84, 90, 88, 91, 75, 87, 91, 95, 97, 85, 
  89, 70, 75, 86, 86, 69, 93, 75, 77, 89, 
  68, 79, 77, 89, 78, 89, 83, 74, 85, 72, 
  79, 82, 76, 83, 88, 86, 77, 84, 80, 85, 
  93, 77, 83, 74, 78, 93, 75, 84, 74, 67, 
  90, 82, 78, 90, 82, 67, 75, 78, 86, 97, 
  79, 97, 87, 93, 95, 87, 85, 82, 81, 80, 
  84, 74, 85, 89, 79, 83, 83, 88, 87, 79, 
  84, 76, 83, 78, 85, 84, 84, 83, 78, 78, 
  64, 82, 81, 70, 87, 100, 85, 87, 78, 108, 
  87, 83, 75, 93, 91, 85, 90, 92, 77, 77, 
  92, 91, 76, 96, 74, 83, 72, 84, 79, 86, 
  87, 88, 88, 79, 92, 94, 82, 69, 82, 96, 
  83, 78, 75, 82, 79, 83, 93, 89, 91, 93, 
  88, 100, 84, 87, 85, 93, 81, 79, 87, 81, 
  90, 82, 93, 88, 89, 78, 81, 72, 69, 74, 
  67, 77, 87, 87, 92, 73, 88, 92, 85, 88, 
  88, 82, 80, 80, 86, 86, 75, 68, 80, 76, 
  89, 79, 78, 62, 87, 83, 87, 90, 84, 81, 
  82, 82, 80, 86, 84, 90, 89, 75, 80, 76, 
  87, 83, 86, 87, 81, 89, 80, 86, 80, 77, 
  96, 79, 88, 85, 96, 87, 88, 78, 81, 77, 
  76, 87, 77, 102, 109, 80, 84, 83, 97, 94, 
  81, 76, 77, 88, 80, 90, 77, 83, 80, 85, 
  86, 80, 88, 79, 91, 69, 87, 93, 82, 68, 
  89, 81, 82, 82, 91, 81, 82, 88, 79, 82, 
  78, 87, 74, 67, 86, 85, 80, 113, 84, 90, 
  97, 73, 79, 82, 73, 85, 70, 67, 83, 73, 
  89, 80, 76, 81, 96, 82, 89, 84, 75, 79, 
  88, 89, 86, 81, 99, 75, 72, 94, 81, 84, 
  78, 104, 77, 81, 97, 81, 89, 97, 81, 68, 
  95, 83, 78, 80, 90, 104, 77, 85, 86, 78, 
  78, 90, 85, 86, 84, 81, 93, 90, 93, 84, 
  85, 80, 95, 92, 90, 79, 83, 88, 91, 91, 
  96, 93, 84, 78, 88, 79, 70, 85, 79, 85, 
  81, 90, 100, 74, 86, 94, 106, 80, 72, 67, 
  75, 89, 94, 92, 80, 80, 85, 78, 82, 84, 
  99, 77, 84, 76, 95, 91, 78, 65, 82, 82, 
  89, 87, 96, 83, 85, 88, 82, 71, 86, 93, 
  62, 63, 93, 97, 74, 109, 90, 99, 92, 78, 
  85, 85, 72, 89, 64, 89, 85, 75, 95, 79, 
  70, 84, 96, 81, 92, 91, 69, 81, 92, 77, 
  88, 85, 83, 69, 80, 79, 84, 92, 80, 112, 
  77, 87, 98, 71, 101, 100, 82, 64, 96, 91, 
  64, 65, 80, 106, 63, 86, 83, 78, 91, 91, 
  62, 83, 76, 81, 99, 84, 98, 81, 98, 81, 
  101, 93, 83, 80, 77, 99, 93, 91, 103, 96, 
  85, 81, 97, 72, 73, 88, 82, 96, 76, 78, 
  86, 79, 85, 90, 96, 85, 80, 75, 83, 81, 
  89, 86, 83, 89, 84, 85, 88, 81, 99, 76, 
  81, 71, 87, 92, 84, 70, 79, 88, 79, 82, 
  97, 95, 87, 83, 86, 79, 90, 86, 69, 69, 
  84, 88, 78, 106, 84, 90, 98, 76, 83, 83, 
  73, 90, 68, 96, 83, 82, 88, 80, 80, 84, 
  92, 84, 90, 88, 76, 80, 92, 85, 90, 85, 
  93, 81, 76, 88, 84, 91, 81, 107, 78, 81, 
  93, 73, 99, 102, 85, 72, 97, 87, 76, 81, 
  84, 96, 78, 83, 91, 80, 90, 89, 84, 78, 
  84, 85, 90, 92, 91, 83, 83, 77, 89, 94, 
  88, 81, 78, 93, 96, 87, 96, 91, 80, 81, 
  90, 78, 65, 83, 82, 92, 73, 100, 70, 94, 
  92, 80, 82, 102, 97, 88, 73, 98, 89, 62, 
  64, 90, 80, 86, 78, 83, 71, 92, 71, 70, 
  74, 89, 103, 87, 113, 69, 59, 79, 82, 88, 
  56, 90, 107, 91, 78, 100, 97, 66, 83, 70, 
  95, 97, 75, 81, 95, 70, 59, 76, 75, 65, 
  84, 101, 89, 64, 86, 80, 88, 68, 101, 82, 
  76, 60, 87, 86, 76, 116, 102, 80, 87, 70, 
  73, 92, 63, 74, 99, 74, 88, 60, 82, 79, 
  69, 75, 85, 86, 65, 87, 87, 93, 92, 93, 
  104, 78, 91, 78, 77, 94, 102, 86, 94, 73, 
  85, 76, 69, 91, 68, 82, 73, 73, 82, 92, 
  89, 75, 72, 82, 89, 72, 77, 67, 88, 91, 
  72, 82, 78, 57, 66, 84, 75, 95, 93, 83, 
  79, 113, 103, 90, 76, 106, 92, 71, 65, 87, 
  84, 88, 81, 82, 86, 91, 82, 72, 78, 93, 
  93, 94, 106, 66, 52, 82, 85, 89, 44, 87, 
  88, 109, 77, 103, 107, 63, 75, 72, 94, 102, 
  69, 71, 88, 74, 68, 78, 75, 67, 79, 68, 
  92, 62, 91, 88, 86, 78, 104, 81, 71, 59, 
  81, 86, 76, 106, 69, 79, 98, 80, 75, 103, 
  69, 82, 73, 73, 90, 65, 71, 88, 73, 85, 
  91, 82, 52, 84, 85, 94, 89, 95, 106, 78, 
  89, 77, 64, 101, 109, 75, 87, 72, 69, 76, 
  76, 85, 66, 81, 64, 70, 87, 93, 85, 75, 
  79, 83, 91, 62, 74, 66, 84, 96, 73, 79, 
  76, 57, 76, 76, 92, 92, 88, 72, 83, 100, 
  93, 89, 80, 96, 97, 89, 69, 88, 79, 86, 
  79, 78, 92, 93, 88, 68, 80, 91, 98, 91, 
  97, 72, 62, 82, 87, 88, 57, 79, 93, 99, 
  79, 101, 98, 63, 70, 70, 90, 89, 74, 68, 
  97, 71, 63, 86, 73, 66, 79, 65, 82, 70, 
  87, 81, 83, 78, 108, 85, 79, 68, 88, 80, 
  75, 123, 69, 77, 91, 81, 75, 85, 67, 87, 
  78, 80, 84, 66, 78, 94, 77, 88, 90, 83, 
  70, 86, 85, 85, 92, 94, 98, 80, 93, 76, 
  65, 92, 102, 74, 92, 74, 79, 76, 69, 85, 
  68, 81, 69, 68, 86, 89, 93, 78, 86, 81, 
  89, 66, 81, 72, 84, 92, 68, 86, 79, 66, 
  80, 95, 71, 73, 85, 81, 89, 85, 80, 84, 
  84, 86, 91, 84, 70, 90, 78, 80, 81, 90, 
  67, 89, 82, 81, 86, 84, 93, 84, 77, 83, 
  94, 78, 79, 66, 74, 76, 95, 75, 94, 73, 
  80, 104, 82, 85, 88, 77, 98, 79, 71, 78, 
  80, 92, 80, 79, 78, 97, 68, 85, 82, 94, 
  95, 63, 83, 83, 72, 68, 86, 88, 84, 83, 
  80, 97, 75, 73, 92, 63, 78, 78, 101, 84, 
  95, 91, 80, 85, 88, 83, 79, 91, 107, 68, 
  73, 74, 87, 81, 66, 75, 88, 92, 104, 63, 
  102, 70, 93, 89, 94, 80, 74, 102, 88, 81, 
  82, 82, 77, 77, 106, 108, 81, 75, 90, 89, 
  91, 88, 77, 87, 74, 85, 85, 101, 79, 85, 
  80, 76, 86, 81, 89, 85, 81, 90, 78, 95, 
  79, 88, 73, 98, 77, 90, 85, 85, 73, 85, 
  83, 82, 78, 89, 98, 84, 71, 73, 88, 72, 
  82, 67, 71, 76, 102, 65, 79, 71, 75, 96, 
  76, 88, 99, 72, 103, 77, 74, 82, 78, 97, 
  84, 82, 86, 100, 71, 74, 83, 94, 92, 59, 
  84, 83, 83, 65, 78, 87, 77, 84, 89, 95, 
  81, 76, 95, 72, 81, 71, 113, 82, 97, 99, 
  83, 83, 83, 78, 84, 91, 116, 69, 81, 78, 
  85, 73, 75, 76, 85, 90, 88, 60, 104, 83, 
  96, 89, 96, 82, 75, 103, 86, 85, 91, 85, 
  80, 79, 106, 104, 75, 72, 81, 89, 88, 86, 
  76, 91, 79, 81, 77, 101, 79, 80, 81, 75, 
  89, 82, 86, 88, 84, 88, 84, 89, 84, 92, 
  70, 90, 75, 82, 84, 85, 83, 83, 78, 80, 
  78, 83, 96, 85, 74, 68, 100, 72, 80, 74, 
  76, 78, 102, 70, 79, 75, 74, 107, 72, 84, 
  88, 78, 100, 88, 78, 75, 79, 92, 82, 79, 
  83, 89, 71, 77, 91, 89, 89, 67, 85, 81, 
  72, 75, 75, 80, 85, 75, 84, 91, 82, 75, 
  95, 67, 80, 74, 117, 87, 91, 95, 83, 83, 
  86, 73, 90, 85, 110, 74, 75, 81, 86, 76, 
  78, 78, 86, 87, 85, 71, 97, 101, 95, 88, 
  93, 82, 71, 101, 89, 84, 96, 85, 80, 77, 
  99, 98, 63, 78, 86, 83, 87, 89, 75, 90, 
  78, 85, 81, 99, 68, 89, 88, 88, 89, 74, 
  80, 95, 111, 95, 79, 82, 97, 74, 66, 113, 
  89, 85, 75, 84, 90, 83, 101, 86, 80, 85, 
  82, 87, 91, 81, 61, 92, 101, 75, 65, 93, 
  86, 99, 89, 76, 84, 72, 93, 80, 75, 98, 
  72, 83, 92, 79, 81, 87, 90, 109, 99, 84, 
  95, 70, 87, 82, 87, 77, 84, 85, 82, 87, 
  80, 80, 106, 85, 87, 81, 101, 76, 81, 87, 
  87, 84, 82, 76, 87, 70, 99, 80, 78, 83, 
  90, 75, 72, 73, 102, 80, 83, 82, 96, 83, 
  90, 70, 87, 101, 77, 92, 96, 93, 84, 105, 
  77, 84, 70, 62, 76, 77, 93, 84, 82, 95, 
  91, 82, 72, 80, 76, 74, 95, 85, 90, 81, 
  87, 95, 64, 87, 83, 93, 99, 72, 76, 92, 
  120, 93, 82, 85, 104, 78, 72, 106, 91, 90, 
  77, 84, 101, 86, 86, 82, 82, 75, 89, 88, 
  97, 78, 57, 102, 105, 79, 63, 90, 81, 106, 
  81, 63, 73, 65, 88, 79, 65, 105, 72, 82, 
  90, 75, 84, 87, 90, 113, 87, 71, 105, 65, 
  83, 84, 88, 84, 80, 90, 67, 86, 85, 81, 
  115, 79, 81, 71, 112, 74, 72, 77, 81, 82, 
  82, 68, 87, 67, 96, 82, 80, 84, 83, 80, 
  65, 69, 99, 70, 72, 91, 98, 76, 92, 66, 
  90, 103, 67, 84, 90, 90, 75, 108, 70, 87, 
  76, 56, 73, 71, 92, 86, 91, 91, 90, 88, 
  72, 80, 80, 69, 101, 81, 84, 79, 86, 99, 
  78, 77, 88, 86, 81, 91, 80, 91, 107, 91, 
  81, 76, 97, 85, 76, 116, 87, 90, 82, 82, 
  101, 80, 73, 85, 79, 90, 87, 79, 77, 74, 
  64, 101, 107, 78, 73, 86, 88, 100, 73, 77, 
  79, 74, 82, 75, 72, 96, 71, 76, 92, 83, 
  79, 91, 91, 107, 99, 61, 101, 79, 75, 84, 
  82, 82, 87, 84, 84, 86, 91, 81, 106, 90, 
  75, 76, 104, 82, 70, 83, 79, 78, 78, 79, 
  94, 71, 93, 91, 81, 86, 78, 73, 78, 69, 
  94, 76, 78, 86, 93, 76, 88, 73, 77, 89, 
  69, 82, 92, 87, 86, 101, 74, 82, 72, 69, 
  79, 71, 95, 85, 88, 90, 96, 82, 75, 80, 
  85, 75, 107, 86, 91, 80, 94, 104, 67, 85, 
  96, 78, 94, 81, 89, 82, 77, 91, 84, 71, 
  78, 87, 67, 82, 73, 76, 77, 82, 76, 85, 
  77, 92, 82, 82, 77, 83, 95, 91, 81, 83, 
  72, 85, 82, 79, 76, 78, 87, 71, 86, 72, 
  73, 85, 79, 67, 92, 66, 81, 76, 85, 84, 
  89, 75, 86, 91, 77, 82, 93, 86, 90, 74, 
  75, 82, 79, 80, 79, 71, 96, 90, 78, 87, 
  86, 82, 90, 72, 90, 93, 100, 74, 84, 92, 
  94, 79, 80, 86, 95, 94, 84, 75, 96, 70, 
  93, 80, 85, 90, 81, 81, 92, 75, 82, 87, 
  94, 98, 65, 105, 83, 84, 76, 81, 69, 89, 
  71, 75, 88, 96, 84, 82, 83, 66, 81, 96, 
  77, 83, 84, 75, 73, 79, 63, 88, 76, 81, 
  101, 72, 93, 84, 77, 84, 92, 77, 76, 91, 
  68, 71, 71, 74, 69, 88, 77, 83, 83, 88, 
  84, 80, 80, 78, 100, 91, 83, 83, 67, 86, 
  81, 80, 80, 69, 92, 62, 87, 69, 75, 93, 
  69, 68, 92, 80, 80, 73, 98, 88, 85, 72, 
  78, 93, 76, 73, 104, 88, 92, 67, 75, 79, 
  69, 79, 76, 73, 97, 84, 89, 88, 81, 75, 
  97, 67, 89, 80, 109, 66, 79, 99, 90, 71, 
  85, 90, 85, 97, 82, 73, 87, 69, 93, 80, 
  81, 92, 81, 77, 94, 68, 74, 96, 86, 98, 
  53, 102, 81, 87, 74, 81, 67, 86, 64, 87, 
  96, 101, 74, 87, 73, 65, 78, 97, 73, 79, 
  79, 77, 63, 78, 70, 80, 76, 87, 88, 78, 
  85, 86, 86, 91, 85, 72, 77, 88, 69, 87, 
  72, 79, 79, 84, 83, 78, 89, 92, 81, 80, 
  82, 87, 92, 86, 78, 84, 86, 84, 79, 87, 
  82, 84, 76, 72, 79, 73, 76, 83, 77, 82, 
  88, 103, 85, 76, 85, 85, 87, 84, 89, 79, 
  83, 74, 87, 83, 86, 70, 81, 72, 76, 76, 
  69, 76, 106, 86, 90, 86, 93, 80, 93, 77, 
  85, 75, 91, 77, 86, 88, 96, 78, 76, 84, 
  70, 91, 83, 73, 95, 67, 88, 79, 95, 84, 
  86, 85, 87, 80, 76, 97, 98, 95, 66, 108, 
  79, 84, 76, 76, 72, 81, 80, 90, 84, 94, 
  84, 88, 77, 67, 86, 89, 86, 85, 84, 74, 
  71, 88, 95, 91, 83, 82, 80, 89, 87, 84, 
  67, 93, 76, 76, 90, 89, 74, 70, 80, 80, 
  76, 76, 80, 96, 83, 84, 79, 93, 80, 87, 
  84, 86, 97, 85, 79, 93, 93, 85, 84, 77, 
  72, 87, 84, 83, 81, 86, 98, 78, 76, 74, 
  84, 79, 89, 87, 97, 74, 87, 83, 83, 98, 
  81, 84, 82, 79, 87, 91, 79, 85, 86, 76, 
  69, 80, 89, 87, 91, 89, 90, 75, 86, 100, 
  76, 86, 84, 91, 85, 76, 84, 82, 94, 80, 
  88, 73, 90, 78, 102, 88, 76, 84, 82, 99, 
  83, 71, 89, 89, 92, 101, 85, 84, 86, 91, 
  90, 94, 76, 88, 79, 80, 86, 84, 82, 86, 
  90, 71, 89, 98, 85, 89, 75, 75, 79, 73, 
  98, 93, 77, 76, 88, 86, 89, 81, 70, 91, 
  78, 79, 96, 80, 77, 67, 82, 81, 73, 76, 
  78, 98, 92, 85, 90, 96, 76, 86, 85, 93, 
  94, 86, 73, 92, 85, 79, 82, 69, 88, 90, 
  91, 83, 78, 95, 96, 80, 81, 77, 82, 83, 
  94, 90, 94, 71, 89, 84, 82, 98, 84, 86, 
  82, 76, 87, 88, 68, 89, 90, 73, 71, 79, 
  83, 89, 89, 87, 91, 70, 91, 89, 72, 87, 
  81, 92, 88, 77, 90, 87, 87, 83, 84, 66, 
  82, 73, 99, 92, 72, 95, 80, 97, 78, 67, 
  86, 95, 89, 103, 88, 79, 87, 94, 93, 102, 
  79, 90, 73, 84, 88, 83, 88, 86, 85, 66, 
  89, 102, 84, 86, 75, 72, 78, 78, 90, 85, 
  84, 88, 80, 80, 84, 88, 71, 91, 79, 76, 
  88, 71, 70, 70, 74, 81, 75, 74, 84, 92, 
  102, 84, 88, 98, 79, 89, 84, 95, 92, 84, 
  80, 89, 78, 84, 83, 73, 88, 87, 83, 82, 
  83, 82, 96, 81, 79, 97, 88, 78, 88, 88, 
  91, 79, 88, 85, 88, 88, 87, 84, 80, 80, 
  92, 83, 72, 87, 83, 78, 78, 79, 88, 88, 
  92, 89, 88, 78, 86, 82, 72, 88, 85, 90, 
  89, 89, 83, 83, 80, 82, 87, 71, 88, 76, 
  105, 85, 81, 86, 83, 94, 86, 75, 85, 92, 
  93, 98, 82, 87, 83, 92, 86, 92, 82, 84, 
  79, 90, 89, 87, 99, 91, 89, 71, 92, 97, 
  88, 89, 79, 77, 74, 77, 78, 73, 84, 86, 
  86, 76, 91, 77, 74, 84, 79, 93, 82, 83, 
  75, 85, 79, 88, 82, 102, 79, 81, 95, 87, 
  83, 72, 101, 80, 96, 73, 81, 66, 87, 90, 
  107, 92, 73, 82, 83, 86, 72, 96, 100, 86, 
  75, 91, 86, 80, 72, 80, 140, 74, 87, 73, 
  86, 88, 74, 84, 90, 89, 69, 90, 85, 82, 
  76, 73, 81, 68, 63, 84, 76, 86, 87, 78, 
  79, 95, 89, 111, 76, 108, 93, 52, 96, 92, 
  92, 76, 87, 82, 78, 91, 87, 77, 84, 81, 
  87, 71, 81, 87, 78, 86, 85, 90, 92, 85, 
  85, 74, 82, 90, 96, 79, 85, 80, 69, 99, 
  96, 84, 87, 91, 96, 89, 80, 93, 82, 75, 
  80, 99, 85, 82, 92, 84, 74, 88, 101, 75, 
  96, 69, 80, 83, 79, 89, 81, 94, 74, 79, 
  86, 75, 74, 108, 92, 76, 79, 88, 79, 66, 
  82, 80, 100, 84, 83, 85, 80, 85, 84, 85, 
  62, 81, 97, 68, 70, 110, 87, 86, 85, 87, 
  85, 97, 75, 65, 160, 61, 84, 77, 75, 104, 
  64, 94, 82, 91, 73, 87, 95, 77, 66, 78, 
  76, 56, 62, 71, 74, 101, 75, 66, 82, 79, 
  102, 87, 67, 140, 92, 51, 83, 89, 89, 74, 
  83, 78, 77, 95, 80, 64, 77, 92, 81, 95, 
  76, 105, 90, 82, 81, 89, 96, 88, 84, 77, 
  91, 92, 92, 78, 87, 74, 66, 87, 98, 91, 
  82, 93, 98, 84, 90, 108, 57, 84, 77, 95, 
  94, 81, 75, 94, 81, 85, 83, 95, 87, 76, 
  79, 85, 83, 101, 80, 83, 73, 84, 83, 90, 
  79, 99, 95, 89, 78, 87, 77, 69, 96, 80, 
  91, 103, 77, 76, 86, 73, 82, 79, 76, 83, 
  88, 92, 77, 89, 76, 86, 87, 98, 89, 106, 
  72, 81, 127, 79, 85, 76, 88, 91, 78, 85, 
  86, 93, 70, 88, 86, 77, 69, 77, 83, 69, 
  60, 82, 88, 83, 90, 79, 89, 98, 93, 73, 
  74, 97, 96, 61, 88, 95, 90, 82, 97, 80, 
  72, 84, 86, 87, 80, 78, 83, 74, 78, 84, 
  83, 78, 80, 76, 91, 87, 84, 71, 82, 88, 
  91, 85, 85, 77, 75, 88, 81, 79, 86, 85, 
  91, 90, 95, 91, 88, 79, 77, 96, 83, 87, 
  74, 73, 79, 88, 78, 81, 88, 76, 69, 77, 
  81, 89, 74, 76, 69, 87, 80, 90, 82, 99, 
  79, 83, 89, 86, 90, 73, 95, 80, 80, 80, 
  79, 75, 88, 82, 79, 94, 73, 77, 85, 95, 
  66, 89, 92, 87, 74, 82, 89, 91, 81, 84, 
  124, 80, 85, 74, 94, 74, 75, 87, 87, 83, 
  71, 81, 84, 80, 72, 72, 89, 65, 77, 91, 
  82, 91, 84, 83, 80, 93, 80, 92, 68, 118, 
  95, 56, 95, 90, 90, 75, 81, 78, 67, 73, 
  85, 67, 85, 71, 78, 73, 91, 84, 76, 80, 
  75, 87, 89, 84, 76, 78, 74, 87, 81, 74, 
  86, 87, 72, 90, 81, 79, 72, 86, 87, 85, 
  73, 88, 87, 77, 87, 80, 76, 79, 78, 71, 
  72, 85, 83, 74, 96, 70, 77, 78, 81, 88, 
  75, 90, 77, 77, 92, 77, 77, 92, 90, 83, 
  79, 84, 85, 68, 75, 81, 79, 73, 83, 89, 
  78, 81, 78, 80, 66, 75, 94, 76, 69, 126, 
  89, 88, 80, 82, 86, 97, 82, 72, 146, 74, 
  89, 80, 87, 96, 63, 96, 85, 85, 69, 80, 
  86, 82, 63, 86, 79, 54, 84, 77, 74, 108, 
  73, 72, 85, 81, 89, 86, 59, 165, 97, 57, 
  86, 84, 90, 71, 75, 73, 71, 74, 76, 57, 
  85, 86, 75, 92, 86, 111, 87, 77, 70, 74, 
  94, 84, 64, 82, 80, 89, 69, 78, 90, 78, 
  71, 77, 83, 91, 71, 85, 92, 81, 79, 100, 
  68, 87, 85, 67, 83, 79, 72, 77, 73, 88, 
  74, 83, 87, 79, 74, 77, 84, 93, 76, 82, 
  70, 88, 80, 93, 82, 92, 90, 87, 85, 84, 
  84, 69, 93, 80, 76, 76, 75, 79, 90, 78, 
  83, 75, 69, 77, 78, 95, 71, 89, 81, 87, 
  78, 89, 90, 97, 83, 88, 114, 84, 84, 75, 
  92, 79, 78, 84, 84, 88, 72, 83, 83, 77, 
  73, 75, 88, 74, 82, 91, 83, 88, 81, 83, 
  86, 99, 83, 85, 73, 105, 96, 59, 95, 83, 
  92, 80, 92, 83, 65, 74, 85, 83, 81, 71, 
  88, 73, 87, 85, 78, 77, 72, 77, 88, 84, 
  77, 73, 70, 89, 81, 81, 86, 82, 76, 80, 
  73, 81, 86, 82, 83, 92, 88, 87, 93, 79, 
  86, 82, 77, 86, 72, 71, 80, 94, 84, 89, 
  94, 82, 78, 74, 88, 84, 84, 85, 76, 92, 
  81, 91, 83, 104, 83, 89, 88, 88, 91, 71, 
  84, 82, 97, 76, 86, 76, 84, 92, 97, 102, 
  74, 91, 94, 87, 74, 89, 94, 85, 73, 84, 
  87, 86, 81, 77, 135, 78, 80, 79, 83, 83, 
  74, 95, 93, 95, 70, 80, 81, 78, 74, 73, 
  100, 69, 73, 82, 90, 86, 87, 83, 74, 92, 
  89, 116, 73, 115, 87, 61, 95, 93, 87, 97, 
  91, 85, 79, 78, 81, 79, 88, 83, 88, 76, 
  86, 85, 82, 76, 86, 76, 80, 87, 75, 77, 
  83, 88, 73, 78, 86, 81, 69, 91, 89, 90, 
  78, 89, 90, 79, 78, 92, 83, 77, 79, 85, 
  77, 87, 73, 83, 86, 96, 89, 78, 100, 75, 
  85, 79, 92, 82, 81, 96, 82, 82, 100, 76, 
  78, 102, 93, 74, 80, 84, 84, 69, 69, 80, 
  102, 89, 96, 91, 83, 93, 93, 88, 81, 101, 
  105, 68, 79, 117, 95, 84, 81, 78, 86, 101, 
  82, 65, 152, 67, 83, 83, 75, 98, 62, 104, 
  86, 102, 70, 73, 88, 74, 67, 82, 89, 57, 
  78, 71, 75, 90, 78, 70, 76, 76, 104, 88, 
  66, 149, 90, 61, 84, 90, 84, 102, 80, 78, 
  83, 81, 72, 77, 84, 101, 87, 95, 83, 105, 
  91, 78, 89, 79, 87, 89, 65, 71, 84, 91, 
  63, 78, 97, 74, 65, 80, 89, 92, 65, 91, 
  96, 71, 81, 101, 65, 81, 70, 77, 84, 90, 
  69, 92, 88, 93, 80, 93, 90, 81, 79, 74, 
  86, 88, 76, 90, 75, 89, 82, 96, 84, 97, 
  91, 88, 90, 86, 82, 69, 86, 79, 92, 81, 
  85, 83, 91, 90, 88, 84, 73, 91, 83, 87, 
  75, 94, 84, 84, 72, 88, 91, 117, 88, 80, 
  120, 80, 82, 81, 86, 85, 76, 90, 89, 94, 
  72, 81, 80, 74, 77, 72, 88, 78, 74, 85, 
  84, 85, 82, 83, 79, 98, 84, 78, 77, 106, 
  89, 65, 96, 85, 87, 97, 96, 84, 79, 77, 
  83, 94, 86, 80, 97, 70, 85, 84, 83, 75, 
  84, 99, 80, 88, 75, 74, 78, 87, 73, 82, 
  91, 78, 72, 84, 79, 84, 86, 84, 82, 82, 
  85, 86, 90, 77, 78, 86, 75, 88, 71, 80, 
  81, 77, 89, 73, 72, 73, 98, 79, 91, 90, 
  78, 101, 70, 72, 86, 74, 97, 78, 94, 92, 
  76, 83, 88, 94, 89, 86, 94, 72, 98, 81, 
  92, 79, 83, 78, 81, 77, 83, 70, 82, 84, 
  86, 85, 72, 84, 73, 76, 73, 78, 83, 94, 
  84, 122, 89, 76, 96, 77, 89, 80, 76, 84, 
  99, 78, 73, 91, 81, 92, 106, 89, 77, 81, 
  77, 97, 85, 79, 88, 116, 83, 86, 83, 74, 
  85, 91, 87, 73, 84, 80, 88, 93, 80, 79, 
  73, 78, 100, 106, 66, 76, 85, 80, 91, 85, 
  66, 74, 80, 75, 83, 91, 79, 75, 85, 95, 
  98, 90, 77, 76, 102, 76, 94, 94, 82, 90, 
  73, 70, 84, 78, 94, 74, 70, 84, 78, 74, 
  81, 79, 64, 68, 93, 78, 100, 88, 65, 96, 
  69, 75, 91, 84, 125, 65, 84, 78, 74, 80, 
  88, 91, 87, 86, 89, 84, 106, 86, 105, 80, 
  81, 85, 82, 69, 94, 63, 88, 85, 86, 75, 
  76, 85, 71, 89, 59, 77, 78, 76, 85, 136, 
  82, 79, 104, 69, 89, 88, 89, 87, 108, 85, 
  67, 85, 81, 108, 105, 91, 76, 82, 82, 98, 
  82, 83, 96, 87, 79, 95, 86, 74, 97, 90, 
  89, 72, 79, 83, 83, 96, 82, 83, 67, 77, 
  105, 107, 70, 74, 71, 83, 91, 96, 68, 79, 
  76, 80, 100, 82, 68, 69, 81, 98, 92, 86, 
  69, 81, 94, 76, 97, 94, 92, 84, 72, 68, 
  79, 78, 97, 78, 72, 88, 83, 83, 84, 83, 
  72, 77, 95, 78, 97, 84, 77, 79, 71, 78, 
  91, 77, 104, 73, 87, 86, 73, 80, 84, 92, 
  85, 92, 90, 89, 98, 92, 96, 82, 67, 103, 
  83, 73, 103, 69, 85, 81, 93, 85, 78, 78, 
  73, 93, 74, 75, 87, 85, 82, 117, 87, 85, 
  92, 81, 86, 79, 84, 83, 98, 80, 73, 89, 
  73, 91, 101, 91, 90, 83, 77, 99, 85, 82, 
  87, 72, 80, 85, 87, 77, 82, 91, 86, 74, 
  83, 73, 87, 90, 81, 76, 72, 78, 89, 102, 
  72, 73, 80, 80, 94, 92, 71, 74, 78, 82, 
  88, 85, 68, 74, 76, 89, 90, 81, 72, 69, 
  78, 76, 92, 87, 90, 92, 80, 70, 87, 83, 
  95, 73, 75, 74, 75, 77, 84, 74, 79, 79, 
  87, 82, 75, 92, 80, 74, 82, 70, 88, 90, 
  86, 79, 84, 88, 71, 83, 91, 87, 79, 80, 
  96, 76, 94, 75, 104, 84, 94, 77, 89, 75, 
  89, 85, 93, 82, 84, 83, 78, 83, 77, 79, 
  86, 73, 81, 84, 86, 114, 85, 86, 93, 73, 
  81, 94, 72, 80, 91, 83, 73, 78, 74, 108, 
  100, 85, 86, 91, 71, 94, 101, 77, 84, 95, 
  86, 83, 80, 71, 74, 88, 93, 73, 88, 79, 
  83, 89, 76, 81, 74, 77, 94, 93, 72, 83, 
  106, 77, 87, 76, 76, 85, 85, 77, 82, 93, 
  76, 79, 75, 110, 113, 94, 72, 74, 94, 79, 
  86, 79, 81, 97, 75, 83, 78, 79, 87, 61, 
  69, 81, 85, 75, 79, 77, 76, 79, 77, 79, 
  76, 94, 66, 85, 82, 66, 94, 99, 106, 70, 
  77, 75, 73, 81, 97, 81, 78, 76, 82, 94, 
  105, 74, 102, 76, 100, 89, 89, 71, 85, 76, 
  95, 79, 80, 77, 77, 76, 82, 75, 75, 61, 
  81, 78, 86, 126, 81, 75, 100, 64, 82, 107, 
  76, 83, 102, 88, 66, 73, 72, 126, 114, 79, 
  73, 91, 71, 91, 110, 72, 90, 81, 80, 89, 
  82, 71, 85, 82, 95, 75, 81, 75, 81, 92, 
  69, 80, 70, 80, 102, 91, 74, 85, 85, 77, 
  75, 85, 81, 91, 74, 80, 91, 87, 65, 74, 
  72, 121, 124, 84, 66, 77, 81, 78, 89, 76, 
  79, 86, 61, 88, 74, 81, 80, 61, 71, 91, 
  104, 83, 82, 78, 77, 77, 83, 83, 83, 89, 
  76, 95, 81, 72, 90, 87, 95, 73, 86, 86, 
  75, 85, 93, 82, 77, 84, 93, 96, 98, 80, 
  105, 79, 79, 103, 87, 71, 86, 81, 94, 82, 
  84, 80, 80, 83, 85, 80, 82, 69, 84, 83, 
  84, 112, 87, 71, 88, 74, 81, 90, 80, 81, 
  91, 86, 69, 83, 77, 104, 101, 85, 75, 93, 
  70, 93, 109, 80, 86, 77, 78, 85, 82, 68, 
  79, 87, 87, 80, 83, 75, 83, 93, 77, 82, 
  77, 77, 92, 89, 75, 82, 77, 80, 90, 90, 
  79, 83, 84, 83, 88, 89, 74, 79, 76, 111, 
  108, 79, 78, 74, 77, 78, 91, 76, 79, 95, 
  72, 80, 78, 85, 82, 66, 81, 75, 75, 73, 
  83, 86, 84, 79, 85, 79, 74, 87, 88, 75, 
  89, 86, 79, 90, 70, 76, 80, 77, 72, 92, 
  92, 73, 77, 83, 77, 77, 82, 80, 93, 90, 
  100, 74, 98, 83, 87, 97, 94, 73, 87, 80, 
  75, 85, 84, 81, 82, 78, 82, 80, 85, 95, 
  89, 83, 87, 81, 93, 82, 74, 75, 93, 86, 
  88, 79, 71, 78, 95, 78, 93, 85, 74, 84, 
  97, 75, 81, 90, 82, 80, 78, 85, 69, 84, 
  86, 78, 80, 79, 94, 79, 77, 87, 77, 74, 
  90, 88, 75, 81, 105, 83, 85, 75, 82, 86, 
  99, 78, 79, 88, 77, 91, 80, 90, 101, 86, 
  90, 79, 80, 78, 84, 96, 78, 97, 85, 85, 
  77, 92, 89, 76, 75, 81, 88, 70, 80, 75, 
  84, 84, 83, 82, 72, 85, 71, 85, 87, 89, 
  83, 93, 72, 73, 78, 67, 73, 86, 96, 82, 
  77, 83, 73, 88, 88, 76, 88, 86, 102, 75, 
  97, 94, 85, 81, 100, 70, 80, 74, 71, 79, 
  90, 68, 87, 67, 84, 83, 82, 107, 84, 89, 
  96, 75, 96, 92, 69, 75, 103, 83, 82, 74, 
  74, 83, 102, 72, 78, 89, 68, 83, 106, 82, 
  81, 79, 80, 81, 79, 90, 65, 73, 92, 82, 
  73, 79, 89, 77, 74, 81, 79, 81, 94, 89, 
  77, 82, 92, 85, 82, 76, 83, 88, 96, 81, 
  85, 86, 72, 87, 77, 82, 116, 76, 89, 84, 
  77, 82, 86, 94, 74, 94, 80, 94, 77, 105, 
  89, 69, 77, 88, 105, 73, 81, 82, 85, 78, 
  82, 85, 78, 83, 82, 93, 86, 88, 78, 91, 
  74, 75, 88, 80, 83, 90, 96, 73, 74, 84, 
  76, 92, 87, 81, 93, 77, 92, 90, 97, 87, 
  76, 88, 95, 70, 79, 76, 76, 84, 87, 75, 
  83, 74, 82, 84, 84, 95, 87, 80, 83, 78, 
  91, 78, 74, 74, 91, 84, 87, 82, 74, 80, 
  90, 83, 67, 84, 73, 82, 108, 75, 82, 80, 
  80, 80, 78, 82, 67, 79, 87, 82, 78, 78, 
  88, 80, 76, 79, 77, 74, 86, 86, 76, 82, 
  82, 81, 86, 74, 84, 85, 95, 79, 78, 86, 
  76, 88, 81, 91, 101, 74, 85, 84, 81, 77, 
  86, 94, 80, 94, 83, 84, 81, 103, 88, 76, 
  80, 69, 101, 78, 67, 88, 85, 86, 81, 89, 
  75, 93, 87, 86, 86, 71, 88, 79, 76, 88, 
  79, 74, 86, 91, 75, 79, 83, 78, 92, 72, 
  87, 84, 81, 70, 88, 81, 93, 94, 66, 77, 
  76, 88, 80, 91, 89, 93, 84, 72, 102, 85, 
  95, 82, 86, 75, 86, 78, 69, 85, 88, 78, 
  84, 77, 79, 89, 96, 77, 86, 96, 74, 64, 
  76, 90, 76, 97, 80, 84, 86, 107, 88, 81, 
  83, 84, 85, 82, 82, 83, 88, 82, 91, 81, 
  86, 84, 94, 73, 85, 96, 69, 91, 76, 87, 
  87, 101, 83, 93, 85, 75, 86, 82, 70, 86, 
  93, 86, 87, 85, 94, 94, 84, 85, 93, 82, 
  93, 92, 68, 86, 87, 85, 87, 85, 78, 77, 
  81, 69, 65, 76, 86, 80, 77, 87, 73, 82, 
  76, 88, 85, 70, 71, 74, 57, 78, 84, 68, 
  72, 93, 67, 82, 86, 70, 97, 70, 95, 87, 
  74, 67, 69, 72, 86, 99, 80, 58, 91, 89, 
  88, 82, 90, 94, 81, 85, 111, 72, 99, 72, 
  80, 83, 81, 97, 60, 81, 95, 75, 87, 85, 
  87, 91, 82, 83, 108, 86, 64, 52, 84, 105, 
  71, 116, 75, 65, 86, 76, 97, 76, 86, 76, 
  76, 73, 73, 95, 85, 85, 99, 80, 74, 72, 
  101, 87, 61, 121, 68, 82, 92, 78, 79, 93, 
  79, 94, 92, 87, 87, 85, 75, 74, 92, 90, 
  84, 79, 104, 111, 80, 90, 89, 121, 83, 91, 
  67, 80, 76, 92, 75, 82, 77, 93, 73, 76, 
  63, 93, 87, 82, 81, 93, 79, 90, 95, 80, 
  85, 71, 78, 77, 73, 86, 74, 75, 90, 93, 
  74, 85, 86, 79, 88, 82, 78, 84, 78, 67, 
  78, 80, 93, 98, 92, 71, 90, 88, 84, 89, 
  99, 86, 83, 111, 105, 85, 96, 70, 84, 80, 
  87, 96, 68, 87, 88, 79, 87, 79, 86, 91, 
  88, 80, 95, 99, 66, 70, 87, 101, 77, 103, 
  80, 80, 85, 70, 87, 75, 84, 81, 79, 89, 
  79, 90, 90, 87, 88, 84, 83, 70, 95, 79, 
  78, 101, 73, 90, 93, 80, 89, 90, 84, 94, 
  84, 76, 93, 85, 75, 84, 81, 83, 86, 80, 
  89, 94, 83, 87, 90, 100, 78, 92, 67, 86, 
  86, 87, 80, 86, 80, 66, 108, 77, 84, 78, 
  79, 86, 88, 87, 83, 92, 97, 103, 84, 69, 
  85, 72, 81, 81, 96, 94, 80, 81, 66, 83, 
  73, 79, 93, 81, 76, 80, 86, 83, 79, 88, 
  82, 82, 76, 84, 84, 83, 77, 81, 95, 91, 
  69, 86, 88, 88, 75, 90, 82, 77, 84, 73, 
  69, 64, 82, 89, 77, 87, 81, 87, 81, 85, 
  81, 96, 70, 61, 78, 83, 88, 93, 87, 85, 
  75, 82, 79, 81, 81, 73, 85, 81, 84, 77, 
  86, 88, 77, 85, 86, 79, 93, 79, 87, 110, 
  79, 91, 72, 86, 87, 85, 85, 97, 78, 82, 
  86, 91, 74, 74, 97, 76, 86, 89, 87, 88, 
  90, 84, 91, 85, 81, 77, 78, 86, 87, 83, 
  85, 79, 78, 79, 78, 74, 108, 73, 70, 88, 
  85, 78, 85, 86, 82, 84, 80, 59, 76, 71, 
  73, 83, 97, 101, 72, 67, 65, 101, 77, 74, 
  97, 70, 72, 76, 88, 88, 72, 95, 72, 75, 
  90, 66, 91, 70, 93, 80, 126, 100, 57, 85, 
  83, 71, 71, 61, 80, 95, 76, 79, 71, 60, 
  70, 102, 81, 107, 91, 81, 72, 83, 94, 108, 
  56, 50, 79, 85, 98, 106, 78, 76, 59, 76, 
  76, 72, 89, 66, 83, 81, 79, 84, 82, 85, 
  65, 76, 93, 70, 72, 97, 84, 137, 81, 97, 
  70, 81, 79, 92, 82, 98, 78, 94, 102, 93, 
  91, 59, 91, 76, 87, 85, 83, 79, 95, 87, 
  75, 115, 72, 72, 79, 86, 86, 87, 77, 76, 
  79, 92, 80, 79, 85, 78, 77, 85, 91, 89, 
  86, 88, 103, 68, 83, 63, 77, 71, 84, 80, 
  76, 96, 76, 72, 71, 91, 77, 82, 93, 73, 
  72, 79, 86, 74, 86, 94, 74, 81, 109, 82, 
  92, 76, 96, 83, 102, 91, 67, 81, 85, 87, 
  75, 77, 80, 89, 86, 96, 72, 68, 77, 91, 
  78, 94, 87, 89, 80, 90, 83, 98, 62, 66, 
  95, 89, 91, 98, 81, 79, 74, 85, 76, 76, 
  83, 70, 86, 89, 83, 83, 86, 89, 76, 84, 
  86, 74, 88, 85, 82, 110, 84, 94, 86, 84, 
  87, 79, 84, 98, 77, 81, 98, 89, 79, 74, 
  76, 74, 87, 87, 74, 80, 85, 82, 86, 90, 
  81, 79, 79, 86, 85, 84, 84, 79, 94, 80, 
  98, 79, 83, 81, 76, 86, 82, 90, 74, 93, 
  109, 94, 82, 73, 83, 77, 87, 82, 81, 87, 
  98, 90, 75, 82, 77, 89, 78, 78, 77, 84, 
  80, 86, 76, 75, 87, 80, 83, 94, 72, 84, 
  63, 83, 83, 85, 87, 83, 76, 84, 82, 87, 
  82, 68, 83, 94, 71, 69, 78, 85, 82, 82, 
  90, 88, 88, 88, 88, 79, 79, 78, 90, 82, 
  88, 92, 96, 79, 79, 81, 83, 85, 86, 88, 
  78, 75, 92, 81, 86, 83, 90, 89, 69, 88, 
  86, 88, 84, 92, 81, 86, 88, 84, 81, 86, 
  85, 96, 79, 90, 87, 93, 83, 87, 79, 72, 
  87, 89, 92, 93, 94, 81, 94, 83, 79, 76, 
  80, 88, 91, 79, 87, 84, 86, 85, 98, 80, 
  107, 80, 67, 88, 87, 84, 77, 90, 101, 81, 
  81, 70, 81, 75, 96, 77, 78, 100, 84, 76, 
  83, 91, 79, 86, 81, 74, 77, 82, 82, 95, 
  79, 82, 91, 84, 87, 103, 82, 77, 72, 82, 
  98, 79, 81, 75, 67, 76, 86, 93, 82, 94, 
  72, 87, 66, 68, 82, 97, 91, 82, 100, 73, 
  82, 99, 87, 81, 75, 65, 89, 83, 92, 84, 
  83, 77, 67, 79, 78, 84, 96, 87, 87, 83, 
  93, 84, 86, 80, 88, 89, 72, 85, 68, 102, 
  90, 90, 85, 97, 90, 88, 78, 84, 85, 94, 
  70, 93, 96, 91, 88, 80, 74, 72, 87, 88, 
  100, 86, 87, 79, 88, 88, 73, 77, 89, 88, 
  90, 79, 93, 83, 91, 98, 99, 82, 87, 99, 
  74, 81, 80, 92, 74, 89, 103, 83, 83, 70, 
  82, 76, 94, 75, 64, 93, 83, 85, 84, 85, 
  79, 91, 72, 72, 81, 86, 79, 82, 79, 84, 
  90, 83, 90, 100, 83, 82, 75, 83, 82, 86, 
  89, 71, 71, 85, 82, 91, 82, 74, 84, 82, 
  67, 71, 79, 85, 88, 82, 91, 85, 86, 88, 
  83, 74, 78, 76, 89, 87, 87, 92, 89, 78, 
  77, 84, 83, 86, 90, 86, 83, 89, 88, 83, 
  91, 83, 91, 88, 71, 89, 84, 89, 79, 88, 
  79, 90, 95, 87, 79, 96, 82, 95, 76, 88, 
  90, 90, 79, 89, 76, 71, 82, 85, 92, 87, 
  89, 81, 96, 79, 83, 74, 76, 88, 90, 87, 
  90, 85, 84, 82, 87, 94, 77, 89, 85, 76, 
  89, 89, 77, 79, 82, 73, 70, 95, 73, 70, 
  87, 96, 78, 70, 85, 106, 63, 74, 81, 83, 
  90, 82, 81, 88, 73, 100, 98, 98, 76, 90, 
  74, 69, 87, 67, 82, 67, 86, 96, 84, 106, 
  98, 80, 83, 71, 76, 69, 73, 100, 79, 93, 
  75, 85, 84, 101, 88, 77, 77, 62, 64, 72, 
  92, 68, 111, 89, 95, 87, 83, 77, 89, 90, 
  99, 77, 85, 87, 84, 88, 78, 78, 94, 84, 
  85, 86, 80, 110, 101, 88, 73, 79, 90, 80, 
  90, 73, 75, 85, 89, 92, 87, 74, 76, 76, 
  77, 74, 84, 76, 62, 90, 77, 87, 92, 89, 
  79, 75, 68, 78, 80, 77, 78, 91, 76, 84, 
  97, 84, 68, 89, 84, 88, 80, 81, 93, 74, 
  83, 90, 101, 80, 88, 81, 92, 84, 80, 79, 
  91, 77, 88, 87, 76, 75, 73, 86, 87, 81, 
  88, 70, 87, 95, 92, 86, 71, 80, 83, 81, 
  83, 83, 66, 83, 94, 83, 75, 109, 73, 94, 
  85, 81, 87, 85, 75, 99, 66, 92, 76, 86, 
  78, 78, 79, 80, 69, 76, 68, 72, 87, 75, 
  94, 90, 81, 80, 96, 69, 84, 83, 85, 90, 
  81, 93, 95, 77, 92, 82, 89, 95, 89, 80, 
  77, 90, 85, 91, 67, 82, 93, 102, 114, 80, 
  75, 83, 81, 89, 88, 88, 82, 83, 85, 81, 
  80, 80, 81, 80, 75, 95, 89, 90, 88, 72, 
  77, 90, 92, 79, 80, 80, 85, 94, 99, 74, 
  71, 79, 77, 90, 81, 89, 78, 70, 86, 91, 
  93, 81, 93, 70, 105, 99, 84, 79, 93, 88, 
  82, 81, 74, 69, 78, 82, 68, 82, 94, 73, 
  99, 81, 104, 79, 89, 68, 75, 88, 84, 92, 
  78, 81, 93, 73, 75, 99, 71, 100, 80, 85, 
  95, 86, 88, 89, 79, 82, 78, 77, 83, 83, 
  80, 77, 77, 88, 85, 83, 77, 93, 81, 76, 
  84, 78, 89, 73, 75, 85, 79, 84, 81, 86, 
  92, 81, 88, 74, 80, 89, 88, 81, 88, 88, 
  85, 87, 80, 78, 90, 98, 105, 89, 80, 90, 
  82, 89, 82, 99, 86, 87, 70, 87, 73, 92, 
  96, 81, 78, 93, 87, 92, 83, 80, 81, 91, 
  74, 83, 85, 79, 88, 90, 76, 86, 82, 88, 
  83, 76, 79, 79, 88, 89, 79, 77, 85, 72, 
  71, 80, 71, 74, 94, 99, 71, 73, 73, 100, 
  78, 79, 85, 75, 113, 68, 77, 110, 70, 89, 
  81, 91, 90, 82, 79, 73, 87, 71, 118, 70, 
  85, 93, 79, 81, 101, 80, 86, 84, 76, 73, 
  76, 89, 95, 77, 86, 75, 97, 93, 91, 64, 
  58, 65, 74, 90, 73, 76, 101, 80, 109, 94, 
  78, 93, 92, 77, 102, 83, 82, 78, 83, 88, 
  67, 72, 88, 80, 77, 93, 82, 102, 94, 87, 
  90, 83, 95, 76, 61, 78, 77, 94, 98, 87, 
  80, 83, 83, 74, 77, 76, 86, 77, 69, 102, 
  73, 90, 79, 88, 77, 98, 72, 83, 72, 81, 
  81, 92, 75, 76, 83, 83, 67, 96, 82, 81, 
  77, 70, 95, 89, 77, 72, 100, 73, 74, 91, 
  70, 63, 73, 87, 68, 70, 73, 101, 75, 76, 
  80, 83, 107, 65, 72, 89, 69, 103, 89, 95, 
  73, 91, 78, 84, 86, 63, 83, 77, 77, 90, 
  81, 110, 88, 86, 80, 84, 88, 72, 68, 97, 
  71, 85, 84, 87, 88, 80, 76, 55, 62, 66, 
  72, 73, 99, 69, 120, 85, 92, 75, 93, 78, 
  85, 82, 103, 84, 81, 89, 89, 80, 85, 83, 
  94, 87, 83, 86, 67, 105, 85, 82, 72, 81, 
  87, 79, 95, 81, 78, 97, 90, 85, 85, 86, 
  81, 74, 73, 68, 75, 75, 62, 95, 71, 84, 
  80, 89, 76, 69, 78, 79, 79, 75, 85, 84, 
  71, 79, 97, 79, 77, 88, 85, 79, 80, 76, 
  90, 75, 87, 85, 114, 82, 86, 83, 98, 89, 
  85, 80, 75, 80, 81, 86, 85, 75, 80, 90, 
  77, 77, 98, 84, 92, 85, 94, 76, 87, 72, 
  80, 93, 84, 93, 79, 88, 85, 69, 90, 82, 
  69, 96, 76, 89, 98, 89, 75, 87, 75, 96, 
  74, 86, 83, 78, 70, 74, 63, 82, 84, 80, 
  90, 79, 68, 81, 79, 70, 90, 67, 78, 80, 
  84, 89, 87, 90, 102, 81, 100, 84, 81, 86, 
  90, 87, 76, 85, 83, 94, 69, 77, 85, 104, 
  99, 85, 82, 88, 87, 85, 82, 99, 91, 88, 
  73, 84, 75, 86, 81, 76, 81, 95, 84, 95, 
  93, 69, 77, 87, 82, 79, 89, 79, 90, 90, 
  90, 91, 88, 74, 93, 64, 97, 89, 77, 72, 
  73, 91, 86, 83, 80, 71, 78, 99, 105, 88, 
  68, 90, 88, 84, 91, 90, 84, 72, 99, 68, 
  86, 106, 96, 80, 82, 78, 81, 75, 87, 78, 
  79, 81, 147, 86, 106, 88, 76, 61, 93, 81, 
  88, 97, 82, 83, 98, 78, 103, 89, 77, 81, 
  88, 76, 98, 73, 62, 81, 75, 89, 75, 81, 
  90, 72, 102, 99, 76, 93, 80, 80, 87, 90, 
  91, 82, 83, 81, 73, 71, 83, 77, 83, 89, 
  96, 77, 91, 87, 91, 81, 92, 91, 57, 76, 
  74, 62, 84, 83, 77, 76, 91, 88, 87, 94, 
  106, 83, 83, 87, 66, 93, 85, 81, 81, 103, 
  74, 93, 80, 91, 90, 82, 85, 80, 73, 89, 
  71, 83, 79, 71, 92, 76, 85, 91, 76, 75, 
  80, 85, 70, 84, 69, 71, 85, 93, 63, 74, 
  84, 96, 80, 85, 80, 77, 107, 56, 73, 101, 
  66, 96, 95, 96, 87, 84, 68, 76, 94, 70, 
  117, 69, 73, 93, 72, 92, 104, 77, 80, 86, 
  83, 71, 78, 76, 95, 81, 89, 80, 100, 90, 
  90, 58, 60, 65, 74, 88, 97, 76, 109, 76, 
  113, 89, 87, 98, 90, 88, 99, 84, 80, 79, 
  75, 85, 66, 78, 84, 83, 79, 81, 83, 97, 
  98, 81, 87, 77, 93, 73, 72, 82, 80, 91, 
  95, 82, 88, 83, 76, 76, 78, 72, 79, 79, 
  66, 100, 68, 81, 85, 85, 72, 89, 77, 81, 
  72, 83, 84, 81, 76, 75, 86, 73, 74, 89, 
  71, 69, 87, 69, 86, 85, 81, 79, 114, 85, 
  69, 83, 85, 76, 84, 85, 64, 75, 89, 87, 
  87, 75, 84, 87, 79, 71, 76, 98, 75, 101, 
  96, 86, 95, 75, 70, 99, 99, 82, 102, 79, 
  66, 75, 81, 87, 96, 87, 73, 88, 92, 79, 
  80, 80, 85, 80, 86, 83, 93, 85, 91, 62, 
  79, 72, 78, 86, 111, 88, 86, 83, 95, 70, 
  87, 79, 84, 84, 99, 92, 82, 77, 88, 83, 
  85, 80, 92, 81, 80, 81, 78, 95, 94, 86, 
  67, 69, 88, 79, 88, 89, 82, 92, 92, 85, 
  83, 92, 81, 84, 72, 71, 74, 75, 67, 84, 
  81, 86, 93, 89, 83, 85, 83, 77, 81, 82, 
  96, 82, 77, 82, 68, 83, 79, 92, 77, 97, 
  81, 84, 68, 82, 72, 81, 93, 65, 70, 99, 
  74, 93, 81, 100, 86, 91, 89, 75, 74, 82, 
  84, 84, 98, 77, 76, 84, 84, 75, 77, 93, 
  92, 83, 91, 95, 77, 86, 95, 80, 103, 95, 
  80, 83, 85, 83, 80, 68, 76, 92, 85, 100, 
  86, 77, 82, 76, 83, 90, 83, 65, 88, 79, 
  86, 93, 86, 92, 89, 94, 93, 78, 87, 81, 
  84, 79, 90, 69, 79, 86, 80, 98, 82, 70, 
  99, 80, 84, 85, 83, 81, 78, 84, 102, 70, 
  88, 89, 90, 79, 94, 85, 85, 84, 92, 87, 
  88, 84, 84, 80, 78, 100, 87, 101, 76, 83, 
  74, 78, 84, 86, 89, 87, 72, 81, 87, 84, 
  78, 84, 67, 73, 84, 81, 80, 90, 81, 74, 
  76, 78, 67, 89, 86, 79, 68, 95, 76, 90, 
  70, 94, 92, 87, 88, 74, 68, 82, 91, 81, 
  104, 81, 72, 78, 78, 78, 77, 91, 81, 77, 
  72, 84, 75, 64, 91, 85, 116, 98, 73, 71, 
  79, 79, 71, 60, 80, 85, 88, 59, 91, 64, 
  85, 78, 80, 91, 90, 61, 91, 63, 79, 81, 
  88, 90, 82, 77, 103, 83, 83, 78, 73, 80, 
  93, 61, 81, 83, 78, 94, 74, 60, 100, 79, 
  76, 88, 81, 93, 74, 76, 113, 68, 81, 93, 
  77, 75, 88, 69, 81, 83, 85, 87, 74, 87, 
  84, 83, 86, 91, 75, 101, 85, 64, 82, 73, 
  71, 85, 96, 80, 71, 76, 90, 79, 77, 77, 
  82, 80, 92, 90, 75, 90, 85, 81, 74, 82, 
  83, 82, 92, 95, 76, 91, 74, 92, 88, 97, 
  92, 91, 91, 72, 76, 81, 83, 84, 87, 75, 
  93, 87, 80, 87, 78, 84, 90, 80, 77, 95, 
  79, 110, 88, 81, 83, 96, 87, 85, 84, 84, 
  76, 79, 78, 89, 91, 61, 76, 69, 81, 76, 
  85, 86, 82, 65, 83, 86, 85, 85, 94, 83, 
  86, 105, 83, 85, 90, 82, 89, 89, 96, 77, 
  78, 94, 84, 86, 84, 69, 98, 90, 96, 78, 
  79, 89, 79, 88, 99, 79, 95, 92, 85, 86, 
  87, 91, 95, 80, 93, 88, 87, 88, 88, 84, 
  96, 97, 89, 97, 101, 87, 88, 84, 86, 83, 
  94, 91, 80, 83, 88, 75, 84, 88, 98, 78, 
  75, 74, 84, 82, 73, 83, 85, 87, 99, 87, 
  80, 83, 76, 71, 84, 66, 72, 87, 81, 79, 
  85, 83, 81, 66, 94, 82, 84, 63, 103, 75, 
  78, 101, 98, 82, 88, 82, 72, 72, 79, 151, 
  79, 88, 92, 68, 95, 90, 75, 87, 98, 93, 
  84, 73, 75, 101, 90, 88, 73, 85, 78, 90, 
  81, 82, 69, 88, 85, 78, 96, 66, 77, 132, 
  69, 76, 83, 64, 98, 82, 51, 78, 97, 91, 
  81, 76, 85, 66, 80, 90, 102, 66, 77, 65, 
  74, 63, 79, 73, 80, 96, 87, 80, 83, 83, 
  101, 82, 83, 81, 83, 76, 71, 88, 80, 104, 
  80, 79, 121, 89, 62, 81, 89, 70, 79, 99, 
  86, 89, 94, 72, 79, 100, 103, 84, 77, 74, 
  81, 86, 79, 82, 100, 89, 101, 97, 97, 106, 
  82, 79, 100, 64, 68, 74, 84, 80, 71, 86, 
  83, 69, 96, 79, 94, 67, 113, 84, 83, 100, 
  82, 81, 97, 83, 110, 76, 73, 211, 92, 101, 
  95, 47, 98, 87, 79, 83, 100, 97, 94, 76, 
  75, 135, 84, 81, 81, 74, 72, 77, 87, 84, 
  46, 115, 86, 64, 89, 44, 68, 150, 58, 76, 
  79, 60, 97, 84, 28, 100, 105, 89, 84, 71, 
  93, 69, 68, 89, 114, 59, 77, 44, 80, 65, 
  61, 69, 80, 107, 98, 78, 70, 70, 112, 82, 
  74, 76, 77, 85, 80, 96, 86, 89, 83, 71, 
  124, 102, 63, 89, 98, 77, 70, 98, 101, 95, 
  107, 53, 86, 97, 75, 79, 84, 83, 85, 91, 
  70, 82, 83, 89, 92, 87, 67, 68, 77, 76, 
  81, 74, 78, 92, 73, 71, 78, 78, 74, 67, 
  92, 81, 72, 87, 85, 78, 79, 91, 80, 82, 
  84, 87, 65, 76, 87, 103, 79, 85, 88, 82, 
  92, 88, 73, 85, 95, 80, 85, 73, 79, 100, 
  84, 79, 76, 94, 88, 94, 80, 69, 77, 75, 
  85, 81, 93, 78, 72, 116, 80, 86, 88, 73, 
  91, 88, 61, 73, 91, 87, 85, 92, 75, 74, 
  83, 79, 86, 76, 78, 69, 72, 75, 86, 76, 
  77, 94, 89, 81, 86, 83, 93, 83, 79, 77, 
  86, 82, 65, 87, 74, 109, 80, 83, 93, 76, 
  88, 78, 77, 76, 78, 93, 77, 85, 92, 83, 
  78, 84, 71, 93, 88, 79, 85, 79, 80, 72, 
  90, 75, 78, 79, 82, 94, 73, 75, 82, 83, 
  84, 96, 90, 83, 94, 85, 84, 94, 87, 78, 
  101, 82, 74, 96, 79, 87, 80, 81, 89, 89, 
  79, 84, 93, 79, 87, 74, 80, 114, 77, 85, 
  98, 95, 86, 76, 83, 81, 81, 65, 80, 69, 
  76, 76, 83, 83, 84, 68, 90, 77, 86, 95, 
  89, 89, 78, 72, 92, 82, 86, 82, 80, 71, 
  97, 80, 80, 92, 88, 94, 76, 90, 104, 86, 
  86, 89, 101, 74, 85, 82, 91, 80, 84, 80, 
  75, 89, 93, 85, 75, 83, 94, 85, 93, 83, 
  59, 80, 89, 83, 82, 106, 81, 79, 85, 86, 
  83, 84, 83, 91, 81, 84, 92, 108, 72, 75, 
  50, 76, 77, 77, 85, 88, 76, 70, 94, 76, 
  75, 92, 60, 82, 76, 75, 84, 86, 77, 100, 
  89, 76, 98, 86, 75, 97, 89, 73, 103, 69, 
  55, 81, 71, 80, 75, 92, 79, 77, 68, 75, 
  95, 49, 89, 75, 83, 124, 69, 70, 91, 92, 
  75, 71, 82, 79, 81, 70, 81, 64, 71, 79, 
  87, 90, 80, 63, 100, 65, 88, 96, 88, 104, 
  82, 56, 102, 81, 87, 82, 65, 74, 96, 70, 
  83, 92, 74, 92, 66, 88, 106, 85, 72, 92, 
  98, 85, 84, 80, 102, 77, 78, 84, 70, 84, 
  93, 84, 67, 83, 98, 86, 91, 84, 50, 75, 
  74, 77, 77, 111, 68, 73, 107, 80, 70, 81, 
  91, 83, 74, 83, 86, 112, 71, 64, 76, 80, 
  74, 79, 80, 81, 84, 79, 90, 79, 81, 77, 
  92, 89, 73, 76, 80, 83, 84, 95, 82, 88, 
  82, 81, 79, 93, 86, 80, 87, 74, 80, 85, 
  82, 84, 93, 96, 89, 84, 87, 91, 95, 95, 
  89, 77, 77, 103, 77, 78, 92, 97, 84, 92, 
  84, 86, 78, 97, 86, 76, 79, 78, 84, 84, 
  81, 75, 76, 91, 82, 96, 88, 83, 81, 85, 
  90, 86, 82, 84, 85, 78, 91, 78, 82, 94, 
  88, 76, 83, 86, 98, 79, 85, 84, 91, 81, 
  80, 84, 85, 78, 83, 88, 91, 89, 84, 87, 
  82, 84, 96, 83, 87, 84, 67, 83, 80, 89, 
  82, 97, 75, 85, 95, 81, 86, 84, 93, 86, 
  90, 90, 94, 103, 81, 81, 82, 85, 78, 74, 
  75, 72, 76, 85, 90, 87, 81, 87, 110, 76, 
  69, 84, 79, 78, 90, 89, 72, 76, 74, 94, 
  89, 79, 92, 84, 89, 90, 81, 93, 78, 75, 
  84, 96, 88, 97, 75, 85, 98, 76, 92, 91, 
  92, 94, 73, 83, 72, 80, 85, 98, 80, 80, 
  87, 80, 79, 70, 100, 84, 98, 58, 73, 87, 
  63, 77, 68, 78, 69, 99, 118, 88, 83, 71, 
  81, 91, 83, 97, 87, 74, 83, 80, 91, 80, 
  85, 90, 86, 92, 70, 83, 76, 94, 83, 93, 
  92, 78, 87, 86, 93, 80, 97, 93, 88, 90, 
  80, 66, 72, 87, 67, 76, 83, 72, 80, 89, 
  71, 95, 74, 82, 90, 79, 71, 87, 76, 80, 
  98, 80, 84, 75, 77, 65, 80, 90, 85, 91, 
  76, 111, 92, 90, 85, 85, 56, 74, 70, 83, 
  78, 76, 88, 74, 86, 83, 77, 90, 82, 86, 
  85, 87, 91, 87, 72, 83, 77, 82, 67, 92, 
  56, 97, 55, 77, 80, 65, 68, 77, 86, 94, 
  74, 64, 89, 67, 97, 89, 79, 77, 81, 52, 
  111, 96, 88, 98, 80, 80, 90, 73, 70, 83, 
  69, 88, 75, 59, 111, 68, 110, 77, 77, 109, 
  71, 82, 71, 69, 82, 93, 78, 82, 76, 86, 
  92, 79, 82, 80, 97, 87, 74, 86, 113, 69, 
  79, 80, 59, 95, 67, 84, 88, 87, 85, 79, 
  81, 88, 68, 78, 83, 80, 98, 80, 86, 80, 
  91, 76, 86, 72, 85, 82, 91, 102, 87, 91, 
  77, 74, 94, 59, 95, 72, 100, 63, 98, 82, 
  86, 73, 75, 90, 76, 76, 89, 83, 80, 89, 
  85, 75, 89, 82, 90, 77, 90, 86, 85, 78, 
  72, 83, 87, 84, 89, 82, 74, 89, 81, 79, 
  86, 87, 79, 70, 84, 100, 81, 91, 83, 70, 
  103, 80, 73, 91, 69, 93, 68, 96, 100, 120, 
  86, 79, 75, 96, 84, 75, 91, 122, 102, 89, 
  93, 76, 83, 68, 93, 86, 89, 64, 81, 76, 
  86, 97, 91, 102, 92, 85, 107, 95, 78, 71, 
  104, 74, 78, 68, 83, 81, 77, 96, 64, 88, 
  85, 103, 87, 74, 76, 90, 96, 93, 104, 86, 
  79, 90, 90, 88, 87, 77, 106, 91, 81, 76, 
  91, 104, 91, 87, 84, 84, 84, 93, 85, 88, 
  84, 105, 65, 86, 80, 68, 85, 61, 90, 76, 
  82, 82, 123, 83, 88, 77, 87, 82, 88, 98, 
  76, 73, 73, 94, 88, 89, 87, 79, 98, 92, 
  101, 101, 80, 85, 102, 79, 98, 95, 91, 79, 
  98, 90, 100, 100, 87, 91, 88, 84, 65, 83, 
  81, 103, 85, 89, 84, 118, 67, 68, 96, 84, 
  102, 68, 79, 91, 66, 71, 86, 87, 71, 95, 
  72, 90, 67, 84, 87, 70, 90, 84, 83, 91, 
  91, 79, 95, 82, 94, 92, 85, 85, 80, 78, 
  75, 77, 91, 101, 66, 85, 93, 98, 130, 70, 
  90, 72, 90, 92, 79, 73, 69, 96, 78, 89, 
  85, 83, 70, 84, 78, 98, 58, 85, 86, 93, 
  84, 88, 78, 73, 90, 76, 89, 92, 83, 71, 
  57, 92, 72, 106, 57, 93, 85, 96, 71, 80, 
  74, 72, 68, 78, 84, 87, 83, 92, 78, 76, 
  77, 86, 79, 71, 98, 82, 112, 73, 60, 86, 
  80, 77, 90, 99, 96, 75, 64, 78, 88, 70, 
  69, 76, 87, 108, 79, 80, 73, 79, 78, 75, 
  82, 64, 97, 72, 89, 60, 86, 89, 98, 69, 
  81, 53, 61, 62, 56, 87, 77, 99, 149, 72, 
  90, 77, 87, 90, 75, 112, 84, 62, 84, 61, 
  78, 89, 74, 78, 90, 97, 47, 80, 79, 97, 
  69, 72, 116, 62, 80, 78, 76, 67, 86, 102, 
  98, 92, 86, 75, 75, 83, 65, 68, 73, 91, 
  77, 97, 68, 85, 73, 73, 73, 70, 73, 85, 
  73, 84, 83, 82, 72, 70, 79, 65, 86, 84, 
  100, 68, 83, 110, 83, 83, 84, 90, 71, 80, 
  79, 79, 77, 81, 101, 84, 98, 87, 72, 87, 
  82, 94, 84, 89, 70, 80, 81, 87, 82, 89, 
  66, 84, 71, 88, 63, 105, 79, 78, 61, 82, 
  83, 83, 79, 67, 98, 80, 88, 80, 73, 82, 
  71, 61, 112, 89, 90, 81, 74, 85, 98, 54, 
  59, 90, 86, 85, 82, 73, 49, 70, 107, 94, 
  76, 95, 71, 80, 55, 96, 86, 90, 86, 87, 
  89, 87, 89, 69, 91, 75, 98, 74, 82, 93, 
  86, 81, 78, 81, 70, 93, 66, 66, 86, 92, 
  91, 81, 96, 85, 77, 85, 88, 71, 95, 76, 
  88, 87, 62, 78, 85, 86, 95, 92, 86, 107, 
  86, 89, 78, 82, 83, 91, 63, 104, 87, 96, 
  95, 67, 86, 67, 87, 84, 89, 87, 85, 79, 
  85, 82, 78, 88, 79, 79, 80, 93, 73, 78, 
  80, 69, 81, 103, 101, 92, 88, 102, 91, 77, 
  83, 95, 75, 65, 91, 86, 90, 92, 76, 77, 
  79, 79, 74, 67, 85, 99, 91, 105, 77, 92, 
  69, 89, 84, 77, 95, 110, 88, 88, 85, 81, 
  104, 79, 81, 68, 70, 73, 81, 89, 72, 67, 
  86, 71, 72, 91, 102, 85, 86, 88, 83, 92, 
  89, 89, 88, 70, 88, 82, 99, 95, 70, 90, 
  99, 83, 110, 95, 72, 76, 86, 88, 84, 83, 
  72, 99, 81, 83, 75, 93, 69, 77, 104, 96, 
  68, 90, 81, 100, 90, 68, 79, 80, 84, 87, 
  86, 96, 83, 101, 67, 85, 78, 78, 81, 66, 
  87, 82, 72, 88, 114, 86, 71, 74, 86, 73, 
  80, 90, 76, 69, 87, 90, 89, 80, 91, 81, 
  98, 88, 101, 93, 73, 69, 98, 92, 97, 88, 
  103, 85, 98, 87, 89, 89, 69, 94, 92, 95, 
  71, 82, 74, 100, 86, 73, 86, 104, 59, 72, 
  83, 92, 95, 64, 81, 81, 71, 66, 78, 93, 
  88, 79, 98, 88, 67, 77, 97, 60, 80, 99, 
  90, 74, 91, 75, 94, 96, 90, 85, 72, 96, 
  79, 71, 68, 73, 85, 88, 63, 75, 89, 89, 
  135, 74, 90, 75, 94, 93, 96, 75, 81, 91, 
  97, 77, 82, 84, 57, 90, 81, 99, 72, 83, 
  92, 75, 72, 79, 81, 68, 88, 87, 81, 81, 
  74, 69, 67, 83, 91, 103, 72, 98, 73, 86, 
  78, 82, 59, 89, 63, 76, 79, 92, 82, 90, 
  99, 84, 78, 90, 81, 89, 89, 83, 77, 79, 
  80, 86, 83, 80, 67, 93, 94, 84, 66, 94, 
  81, 81, 54, 77, 86, 89, 86, 102, 91, 77, 
  78, 76, 76, 79, 89, 70, 100, 70, 79, 79, 
  86, 67, 96, 50, 60, 74, 73, 97, 78, 82, 
  99, 75, 91, 90, 79, 104, 71, 88, 70, 86, 
  88, 72, 71, 92, 84, 74, 94, 82, 69, 76, 
  93, 85, 82, 82, 106, 72, 83, 78, 78, 87, 
  82, 83, 92, 96, 94, 72, 84, 81, 90, 74, 
  78, 72, 72, 89, 83, 86, 82, 82, 88, 80, 
  96, 83, 88, 92, 75, 87, 78, 76, 78, 78, 
  80, 81, 93, 80, 85, 92, 81, 93, 65, 89, 
  78, 82, 74, 104, 77, 91, 77, 95, 76, 82, 
  101, 81, 76, 72, 78, 79, 99, 92, 77, 82, 
  81, 87, 84, 80, 80, 88, 86, 86, 80, 77, 
  79, 88, 108, 83, 77, 76, 103, 70, 86, 77, 
  65, 85, 81, 79, 77, 92, 83, 82, 72, 77, 
  87, 84, 80, 80, 76, 74, 81, 80, 75, 67, 
  75, 87, 87, 75, 87, 73, 83, 85, 80, 74, 
  80, 98, 76, 75, 72, 78, 87, 88, 83, 87, 
  87, 85, 89, 66, 88, 77, 93, 84, 86, 86, 
  130, 96, 97, 77, 80, 90, 87, 81, 73, 95, 
  88, 78, 82, 74, 81, 74, 80, 75, 81, 90, 
  81, 123, 79, 70, 79, 82, 74, 75, 81, 82, 
  93, 84, 82, 92, 77, 100, 65, 87, 75, 84, 
  79, 104, 77, 90, 77, 99, 75, 78, 87, 85, 
  78, 72, 77, 82, 90, 94, 76, 87, 79, 83, 
  86, 81, 79, 86, 85, 82, 78, 81, 78, 86, 
  102, 77, 75, 74, 116, 65, 84, 77, 71, 81, 
  79, 80, 79, 86, 80, 78, 72, 83, 81, 77, 
  82, 82, 76, 75, 81, 81, 77, 67, 77, 79, 
  94, 75, 87, 79, 83, 91, 80, 73, 78, 83, 
  72, 73, 76, 79, 83, 93, 81, 88, 84, 86, 
  87, 69, 88, 74, 84, 85, 85, 78, 142, 96, 
  98, 77, 77, 92, 82, 73, 68, 90, 99, 74, 
  84, 73, 78, 74, 77, 73, 81, 86, 83, 129, 
  77, 69, 78, 77, 82, 72, 81, 81, 91, 93, 
  83, 91, 82, 91, 70, 92, 82, 90, 76, 98, 
  77, 90, 79, 101, 76, 82, 76, 82, 81, 74, 
  79, 75, 93, 92, 75, 87, 80, 80, 86, 81, 
  80, 84, 87, 80, 78, 79, 79, 89, 105, 81, 
  78, 73, 101, 72, 84, 80, 68, 83, 82, 77, 
  80, 89, 82, 81, 72, 82, 84, 85, 83, 82, 
  81, 78, 77, 82, 75, 70, 80, 83, 90, 75, 
  90, 85, 79, 85, 80, 77, 79, 79, 78, 74, 
  81, 83, 84, 88, 83, 97, 85, 89, 80, 67, 
  86, 77, 78, 83, 89, 81, 124, 94, 92, 81, 
  81, 89, 83, 81, 72, 94, 85, 67, 86, 81, 
  74, 73, 83, 75, 84, 90, 78, 124, 79, 75, 
  78, 83, 74, 81, 82, 88, 84, 85, 99, 95, 
  70, 95, 66, 86, 75, 84, 83, 111, 78, 85, 
  79, 96, 74, 80, 93, 88, 85, 74, 71, 79, 
  91, 90, 77, 77, 80, 95, 75, 79, 78, 93, 
  88, 93, 82, 75, 73, 86, 96, 78, 78, 79, 
  116, 70, 84, 75, 72, 78, 78, 73, 72, 93, 
  82, 78, 75, 73, 86, 91, 81, 76, 86, 78, 
  91, 78, 74, 65, 68, 72, 87, 76, 88, 77, 
  80, 79, 75, 78, 85, 92, 71, 71, 71, 79, 
  79, 84, 84, 82, 86, 84, 87, 72, 89, 71, 
  85, 84, 82, 82, 141, 96, 92, 78, 80, 89, 
  87, 78, 79, 88, 102, 81, 76, 77, 84, 76, 
  81, 80, 82, 86, 80, 136, 78, 78, 79, 76, 
  67, 81, 79, 99, 87, 79, 105, 96, 68, 104, 
  63, 82, 73, 84, 92, 117, 78, 75, 78, 97, 
  74, 79, 78, 97, 86, 79, 69, 89, 88, 81, 
  80, 78, 78, 95, 75, 81, 74, 96, 88, 95, 
  81, 78, 77, 81, 87, 75, 79, 81, 136, 62, 
  86, 76, 86, 77, 77, 76, 69, 85, 81, 74, 
  75, 75, 82, 81, 73, 76, 89, 78, 98, 72, 
  74, 67, 64, 67, 101, 71, 90, 80, 83, 85, 
  74, 78, 82, 70, 60, 71, 73, 81, 78, 90, 
  85, 81, 82, 88, 84, 74, 91, 64, 84, 82, 
  80, 73, 166, 98, 100, 73, 77, 89, 89, 70, 
  80, 83, 124, 76, 73, 77, 75, 76, 80, 79, 
  79, 84, 87, 150, 76, 79, 78, 75, 75, 76, 
  78, 88, 85, 91, 98, 94, 73, 92, 68, 89, 
  79, 88, 81, 106, 78, 81, 78, 103, 74, 78, 
  79, 88, 83, 76, 73, 78, 84, 80, 75, 79, 
  77, 85, 82, 85, 77, 87, 87, 86, 80, 75, 
  76, 88, 97, 82, 76, 81, 115, 70, 85, 79, 
  73, 78, 77, 74, 75, 89, 84, 78, 74, 75, 
  83, 90, 87, 76, 87, 84, 91, 78, 79, 65, 
  72, 73, 95, 75, 91, 89, 83, 81, 75, 81, 
  80, 73, 72, 70, 83, 84, 76, 85, 81, 93, 
  84, 88, 79, 73, 87, 72, 77, 81, 85, 81, 
  132, 93, 92, 78, 84, 86, 88, 79, 78, 86, 
  100, 72, 76, 84, 75, 75, 81, 80, 83, 88, 
  82, 134, 78, 83, 80, 79, 81, 73, 76, 80, 
  87, 88, 96, 101, 73, 86, 69, 86, 79, 84, 
  84, 99, 77, 77, 77, 92, 79, 82, 90, 83, 
  85, 85, 76, 71, 83, 83, 78, 84, 80, 98, 
  75, 81, 78, 94, 87, 90, 80, 85, 71, 87, 
  101, 77, 77, 76, 110, 72, 90, 79, 65, 78, 
  82, 80, 75, 95, 87, 76, 71, 70, 94, 92, 
  82, 80, 90, 74, 88, 79, 78, 74, 72, 74, 
  83, 80, 95, 90, 70, 80, 75, 78, 88, 87, 
  84, 68, 74, 83, 83, 80, 77, 80, 90, 87, 
  87, 73, 89, 77, 76, 89, 86, 83, 117, 95, 
  83, 87, 86, 90, 92, 87, 83, 80, 80, 73, 
  75, 78, 81, 78, 83, 81, 82, 85, 71, 132, 
  75, 81, 74, 81, 75, 77, 76, 83, 90, 80, 
  99, 98, 73, 85, 68, 83, 75, 83, 92, 102, 
  83, 72, 77, 89, 78, 80, 83, 86, 80, 89, 
  74, 73, 81, 81, 81, 84, 82, 100, 75, 80, 
  73, 101, 87, 89, 85, 88, 77, 86, 100, 77, 
  74, 84, 118, 67, 91, 80, 69, 75, 80, 78, 
  77, 90, 86, 76, 71, 76, 92, 85, 79, 79, 
  94, 76, 97, 78, 73, 70, 72, 77, 86, 81, 
  99, 85, 67, 83, 75, 79, 83, 75, 78, 70, 
  72, 86, 81, 83, 77, 85, 90, 93, 86, 79, 
  84, 76, 78, 88, 87, 79, 119, 97, 81, 84, 
  87, 89, 91, 86, 82, 78, 86, 74, 76, 80, 
  72, 79, 82, 79, 81, 87, 79, 136, 74, 85, 
  75, 80, 82, 76, 76, 80, 87, 90, 97, 99, 
  75, 87, 69, 88, 81, 84, 83, 98, 79, 76, 
  74, 97, 75, 82, 89, 81, 77, 84, 77, 74, 
  78, 79, 81, 85, 81, 88, 80, 84, 79, 96, 
  91, 82, 82, 87, 78, 88, 104, 83, 73, 91, 
  111, 71, 90, 85, 66, 77, 83, 72, 78, 91, 
  90, 77, 71, 72, 92, 91, 88, 80, 84, 79, 
  93, 81, 77, 71, 76, 76, 88, 80, 98, 85, 
  70, 82, 76, 80, 81, 77, 82, 68, 77, 87, 
  81, 81, 77, 87, 89, 91, 80, 74, 89, 77, 
  79, 86, 87, 79, 115, 92, 82, 86, 90, 87, 
  94, 87, 81, 79, 82, 78, 80, 84, 75, 77, 
  83, 82, 87, 87, 78, 128, 75, 84, 77, 82, 
  83, 72, 90, 88, 106, 91, 74, 63, 78, 90, 
  78, 72, 82, 96, 69, 82, 85, 100, 85, 80, 
  87, 91, 100, 96, 93, 78, 81, 87, 95, 90, 
  76, 86, 63, 77, 73, 93, 79, 77, 88, 82, 
  83, 80, 84, 73, 76, 92, 89, 96, 87, 66, 
  98, 80, 105, 73, 76, 83, 72, 75, 82, 86, 
  94, 86, 88, 81, 102, 72, 81, 91, 86, 111, 
  80, 83, 91, 85, 70, 73, 73, 75, 87, 93, 
  90, 86, 84, 82, 74, 74, 84, 99, 89, 83, 
  86, 74, 78, 71, 89, 78, 87, 74, 94, 87, 
  74, 72, 84, 84, 73, 77, 88, 101, 87, 56, 
  79, 89, 92, 77, 89, 91, 102, 87, 90, 97, 
  111, 74, 93, 90, 88, 84, 90, 77, 75, 98, 
  78, 90, 133, 82, 72, 59, 77, 87, 75, 74, 
  83, 107, 77, 80, 92, 85, 85, 71, 83, 73, 
  86, 112, 100, 71, 76, 89, 103, 78, 75, 85, 
  61, 75, 84, 71, 90, 70, 94, 86, 79, 76, 
  84, 84, 87, 95, 97, 78, 76, 52, 114, 80, 
  93, 77, 60, 84, 67, 72, 87, 81, 92, 76, 
  89, 82, 89, 69, 81, 82, 80, 102, 78, 76, 
  85, 77, 73, 67, 73, 75, 100, 105, 85, 105, 
  85, 86, 63, 66, 76, 100, 88, 101, 72, 79, 
  77, 69, 81, 75, 95, 77, 90, 100, 72, 86, 
  76, 84, 72, 71, 86, 104, 93, 55, 77, 85, 
  91, 76, 86, 80, 73, 90, 84, 104, 106, 65, 
  74, 94, 84, 78, 83, 83, 80, 101, 86, 85, 
  89, 95, 77, 71, 80, 89, 75, 78, 73, 80, 
  69, 86, 92, 95, 88, 77, 82, 90, 96, 88, 
  91, 82, 83, 82, 88, 68, 79, 88, 70, 83, 
  89, 96, 84, 80, 81, 84, 81, 85, 77, 71, 
  75, 84, 92, 80, 92, 77, 92, 77, 100, 68, 
  86, 84, 74, 80, 82, 83, 95, 94, 84, 78, 
  99, 72, 75, 94, 78, 91, 101, 89, 84, 88, 
  74, 79, 78, 87, 99, 86, 90, 84, 89, 105, 
  82, 70, 83, 95, 89, 87, 87, 90, 84, 70, 
  103, 74, 85, 79, 87, 80, 78, 92, 90, 85, 
  72, 76, 83, 103, 86, 70, 85, 91, 93, 84, 
  82, 85, 81, 87, 88, 93, 79, 81, 95, 87, 
  85, 77, 88, 84, 88, 75, 84, 91, 112, 94, 
  75, 67, 71, 88, 89, 80, 93, 104, 71, 82, 
  91, 92, 96, 74, 89, 84, 102, 96, 93, 80, 
  74, 87, 104, 86, 82, 84, 50, 76, 90, 93, 
  78, 67, 101, 87, 80, 72, 82, 83, 83, 90, 
  82, 105, 75, 61, 102, 76, 95, 67, 62, 93, 
  72, 73, 84, 84, 76, 95, 79, 83, 90, 67, 
  83, 85, 89, 81, 77, 76, 102, 89, 72, 71, 
  61, 75, 83, 90, 83, 116, 95, 72, 73, 79, 
  82, 97, 100, 80, 91, 88, 83, 71, 81, 79, 
  86, 71, 80, 94, 58, 82, 74, 83, 75, 73, 
  82, 94, 85, 60, 81, 93, 92, 75, 75, 74, 
  92, 93, 83, 85, 108, 72, 86, 99, 82, 81, 
  90, 70, 85, 98, 81, 87, 155, 79, 71, 59, 
  81, 76, 99, 79, 112, 122, 78, 77, 102, 69, 
  96, 63, 82, 64, 77, 115, 102, 70, 65, 82, 
  106, 85, 81, 83, 35, 67, 102, 67, 81, 67, 
  123, 99, 76, 72, 89, 96, 99, 96, 84, 81, 
  66, 29, 121, 77, 74, 80, 34, 88, 67, 64, 
  82, 75, 67, 85, 76, 94, 70, 69, 93, 67, 
  91, 67, 74, 67, 99, 72, 70, 60, 59, 79, 
  83, 123, 76, 147, 106, 83, 69, 87, 68, 90, 
  104, 92, 84, 78, 77, 76, 56, 80, 90, 70, 
  86, 118, 54, 71, 60, 85, 66, 64, 76, 90, 
  94, 45, 95, 88, 84, 70, 72, 69, 76, 101, 
  77, 89, 101, 56, 55, 101, 78, 69, 81, 75, 
  80, 107, 84, 90, 98, 99, 79, 69, 72, 88, 
  84, 82, 76, 89, 72, 83, 91, 87, 90, 76, 
  75, 85, 93, 86, 82, 80, 75, 85, 97, 77, 
  81, 88, 57, 72, 94, 90, 82, 73, 89, 86, 
  81, 74, 82, 82, 84, 83, 76, 77, 80, 74, 
  93, 71, 91, 68, 73, 83, 71, 78, 86, 83, 
  84, 95, 81, 75, 85, 68, 88, 86, 77, 75, 
  95, 80, 89, 89, 74, 70, 69, 94, 92, 83, 
  84, 110, 97, 102, 82, 82, 76, 94, 99, 80, 
  93, 84, 82, 70, 96, 77, 89, 79, 85, 85, 
  64, 79, 81, 86, 76, 73, 79, 100, 86, 72, 
  91, 94, 95, 84, 77, 75, 91, 91, 82, 89, 
  75, 76, 83, 89, 81, 79, 88, 81, 93, 75, 
  79, 93, 79, 91, 79, 68, 77, 97, 83, 89, 
  87, 92, 67, 91, 89, 98, 85, 81, 84, 89, 
  87, 80, 86, 79, 88, 91, 91, 76, 83, 86, 
  68, 81, 89, 93, 86, 76, 85, 95, 87, 71, 
  87, 77, 70, 79, 77, 93, 77, 83, 84, 83, 
  99, 61, 78, 93, 72, 84, 86, 80, 69, 96, 
  76, 86, 110, 73, 79, 100, 95, 89, 89, 86, 
  98, 97, 74, 75, 71, 82, 83, 68, 86, 84, 
  89, 69, 81, 84, 84, 88, 95, 78, 84, 114, 
  83, 70, 91, 69, 89, 73, 73, 79, 62, 91, 
  90, 86, 90, 94, 79, 92, 83, 69, 82, 81, 
  86, 78, 80, 94, 83, 91, 91, 80, 93, 82, 
  87, 95, 89, 82, 102, 78, 84, 88, 88, 95, 
  98, 78, 75, 63, 79, 93, 87, 92, 98, 99, 
  71, 88, 100, 87, 91, 68, 79, 72, 88, 87, 
  84, 71, 81, 86, 94, 87, 88, 83, 64, 78, 
  87, 76, 87, 84, 104, 101, 88, 61, 83, 86, 
  75, 80, 68, 80, 68, 62, 95, 82, 92, 65, 
  59, 86, 60, 75, 91, 76, 62, 88, 74, 86, 
  88, 63, 81, 84, 104, 93, 73, 71, 100, 93, 
  70, 67, 69, 74, 79, 79, 84, 104, 100, 92, 
  77, 95, 79, 86, 98, 81, 76, 112, 85, 67, 
  66, 67, 90, 77, 85, 90, 55, 82, 74, 87, 
  70, 98, 77, 87, 79, 66, 90, 67, 81, 76, 
  83, 99, 79, 102, 91, 77, 81, 71, 73, 95, 
  83, 74, 95, 73, 89, 97, 86, 93, 71, 91, 
  80, 68, 78, 97, 81, 87, 72, 79, 71, 93, 
  87, 92, 83, 75, 82, 89, 99, 78, 70, 79, 
  85, 87, 84, 94, 84, 92, 74, 79, 79, 97, 
  89, 79, 83, 93, 88, 66, 76, 74, 76, 77, 
  71, 85, 78, 91, 84, 78, 97, 65, 80, 77, 
  73, 85, 87, 88, 77, 87, 83, 81, 97, 74, 
  84, 101, 90, 93, 83, 88, 85, 99, 74, 80, 
  77, 79, 79, 65, 88, 81, 93, 114, 80, 84, 
  82, 83, 93, 84, 86, 97, 79, 69, 88, 70, 
  91, 78, 91, 75, 68, 80, 92, 89, 90, 86, 
  77, 90, 86, 74, 95, 78, 82, 84, 93, 90, 
  95, 87, 89, 81, 71, 86, 87, 87, 86, 85, 
  99, 86, 86, 67, 75, 96, 79, 91, 84, 82, 
  73, 82, 80, 72, 88, 80, 78, 84, 79, 81, 
  82, 77, 85, 91, 83, 87, 78, 85, 76, 85, 
  72, 90, 81, 81, 88, 86, 71, 84, 61, 69, 
  85, 82, 75, 71, 72, 83, 78, 85, 78, 90, 
  79, 87, 73, 86, 77, 79, 83, 69, 72, 82, 
  87, 81, 82, 90, 82, 75, 77, 74, 85, 92, 
  73, 64, 83, 74, 97, 87, 85, 83, 72, 77, 
  76, 73, 81, 67, 86, 95, 78, 89, 100, 75, 
  73, 83, 93, 78, 86, 79, 73, 81, 80, 80, 
  86, 76, 82, 81, 75, 80, 74, 80, 83, 83, 
  80, 81, 75, 80, 82, 81, 71, 85, 85, 82, 
  73, 86, 84, 79, 93, 80, 90, 77, 84, 83, 
  95, 82, 75, 97, 82, 67, 74, 94, 77, 86, 
  90, 77, 86, 90, 74, 84, 71, 88, 92, 96, 
  64, 77, 74, 89, 87, 75, 94, 93, 148, 76, 
  105, 95, 79, 87, 77, 83, 98, 97, 81, 40, 
  91, 45, 65, 79, 75, 65, 104, 85, 71, 69, 
  101, 75, 69, 84, 87, 88, 68, 100, 96, 91, 
  89, 76, 105, 71, 72, 71, 93, 89, 80, 104, 
  63, 56, 99, 86, 87, 79, 80, 84, 105, 46, 
  79, 84, 72, 99, 79, 97, 88, 85, 118, 80, 
  88, 111, 85, 81, 100, 75, 88, 80, 86, 73, 
  91, 99, 85, 81, 87, 103, 81, 86, 87, 80, 
  82, 84, 82, 85, 86, 102, 79, 87, 79, 94, 
  93, 90, 96, 85, 75, 85, 101, 92, 87, 93, 
  82, 94, 76, 76, 83, 80, 74, 81, 79, 79, 
  89, 86, 80, 82, 79, 76, 83, 87, 75, 92, 
  89, 91, 84, 82, 82, 84, 105, 69, 87, 90, 
  84, 72, 79, 89, 70, 69, 81, 78, 78, 69, 
  76, 87, 81, 85, 83, 79, 75, 86, 77, 96, 
  74, 80, 90, 71, 70, 82, 92, 77, 79, 81, 
  80, 81, 73, 76, 86, 89, 80, 70, 81, 73, 
  97, 82, 86, 78, 79, 82, 83, 71, 82, 66, 
  88, 81, 79, 87, 86, 74, 86, 88, 86, 81, 
  87, 81, 80, 80, 81, 83, 71, 85, 78, 96, 
  78, 82, 74, 84, 82, 85, 80, 80, 91, 79, 
  79, 93, 76, 87, 86, 81, 79, 89, 82, 81, 
  85, 82, 88, 73, 84, 82, 85, 68, 98, 88, 
  82, 74, 85, 76, 73, 89, 77, 66, 87, 94, 
  81, 93, 85, 79, 71, 72, 82, 88, 81, 90, 
  87, 86, 86, 89, 117, 87, 89, 79, 79, 81, 
  80, 66, 84, 74, 98, 73, 83, 77, 80, 92, 
  78, 80, 82, 80, 77, 69, 90, 105, 89, 80, 
  81, 111, 73, 80, 84, 77, 80, 77, 75, 57, 
  75, 64, 74, 84, 87, 74, 92, 79, 88, 88, 
  86, 86, 71, 80, 67, 82, 76, 72, 86, 89, 
  81, 82, 98, 88, 93, 78, 77, 78, 91, 77, 
  84, 71, 86, 81, 87, 90, 80, 81, 75, 78, 
  72, 78, 72, 89, 76, 76, 87, 77, 79, 87, 
  91, 77, 72, 85, 93, 91, 86, 74, 89, 83, 
  88, 79, 86, 79, 87, 81, 89, 85, 85, 64, 
  81, 77, 73, 93, 81, 68, 94, 99, 79, 88, 
  76, 80, 81, 91, 67, 77, 77, 96, 90, 78, 
  94, 92, 159, 82, 118, 87, 69, 85, 85, 77, 
  109, 91, 95, 43, 95, 66, 73, 91, 75, 63, 
  103, 80, 63, 52, 116, 98, 82, 75, 82, 109, 
  69, 90, 102, 89, 92, 67, 88, 59, 82, 59, 
  83, 87, 92, 102, 93, 64, 83, 86, 94, 74, 
  77, 79, 89, 55, 73, 93, 71, 95, 83, 88, 
  88, 93, 119, 72, 69, 98, 92, 82, 92, 68, 
  90, 82, 93, 79, 83, 99, 82, 79, 89, 105, 
  84, 85, 81, 72, 91, 85, 71, 90, 102, 88, 
  82, 92, 101, 103, 91, 85, 86, 78, 77, 91, 
  95, 88, 78, 87, 85, 83, 81, 71, 83, 78, 
  73, 89, 78, 70, 91, 94, 82, 92, 86, 72, 
  76, 80, 82, 86, 86, 97, 83, 83, 85, 88, 
  118, 80, 90, 82, 82, 66, 78, 81, 89, 69, 
  88, 74, 86, 78, 76, 91, 83, 80, 84, 69, 
  73, 76, 94, 99, 85, 77, 88, 93, 71, 77, 
  90, 75, 78, 76, 71, 59, 71, 64, 80, 86, 
  88, 71, 98, 78, 93, 85, 88, 87, 79, 77, 
  68, 79, 78, 70, 88, 80, 77, 81, 85, 78, 
  89, 82, 79, 76, 88, 81, 80, 72, 85, 85, 
  74, 89, 77, 91, 77, 80, 70, 76, 76, 83, 
  75, 73, 92, 77, 76, 92, 87, 76, 87, 84, 
  93, 91, 77, 79, 92, 84, 87, 75, 85, 78, 
  82, 72, 87, 90, 84, 98, 84, 81, 81, 81, 
  80, 70, 91, 87, 79, 85, 75, 80, 85, 80, 
  83, 89, 85, 87, 81, 88, 84, 84, 81, 87, 
  81, 84, 88, 91, 85, 79, 83, 79, 76, 80, 
  82, 70, 78, 87, 73, 90, 79, 88, 82, 83, 
  75, 93, 76, 83, 84, 87, 80, 85, 80, 78, 
  81, 96, 74, 77, 86, 76, 67, 83, 86, 76, 
  74, 71, 83, 89, 84, 89, 74, 82, 66, 72, 
  81, 73, 90, 89, 81, 78, 96, 88, 75, 85, 
  96, 84, 89, 79, 84, 81, 84, 81, 80, 82, 
  85, 70, 80, 79, 67, 69, 79, 82, 83, 82, 
  83, 89, 86, 92, 77, 77, 93, 77, 73, 80, 
  81, 80, 91, 88, 92, 91, 79, 85, 84, 90, 
  73, 91, 86, 70, 80, 76, 88, 88, 84, 70, 
  92, 84, 78, 79, 68, 87, 94, 99, 75, 68, 
  78, 97, 87, 81, 92, 96, 137, 92, 102, 92, 
  91, 95, 95, 86, 98, 97, 78, 49, 93, 58, 
  79, 82, 79, 83, 99, 81, 77, 73, 100, 68, 
  69, 80, 89, 92, 79, 93, 97, 86, 88, 90, 
  87, 75, 82, 72, 78, 86, 97, 85, 72, 65, 
  86, 87, 89, 90, 83, 80, 85, 54, 81, 83, 
  75, 93, 75, 82, 84, 84, 100, 84, 96, 93, 
  97, 87, 89, 84, 88, 84, 92, 80, 91, 81, 
  89, 83, 90, 98, 96, 76, 91, 84, 82, 95, 
  80, 89, 80, 92, 91, 91, 82, 97, 94, 91, 
  95, 88, 83, 105, 96, 96, 78, 83, 80, 85, 
  79, 82, 77, 80, 82, 82, 83, 74, 95, 84, 
  80, 83, 77, 77, 90, 82, 78, 85, 91, 88, 
  82, 85, 79, 88, 95, 82, 83, 85, 87, 74, 
  87, 94, 88, 77, 83, 78, 87, 68, 81, 87, 
  79, 85, 80, 70, 81, 84, 78, 86, 73, 82, 
  91, 79, 78, 80, 84, 76, 79, 89, 73, 78, 
  82, 76, 77, 82, 86, 71, 94, 71, 87, 86, 
  82, 85, 77, 83, 62, 70, 80, 70, 90, 79, 
  76, 80, 80, 78, 78, 85, 91, 81, 88, 83, 
  81, 82, 87, 83, 75, 85, 82, 67, 81, 81, 
  67, 71, 80, 78, 73, 76, 85, 84, 83, 91, 
  71, 75, 85, 77, 79, 79, 75, 83, 88, 87, 
  87, 87, 81, 84, 84, 85, 78, 82, 98, 96, 
  82, 79, 79, 85, 79, 74, 87, 60, 88, 80, 
  78, 97, 79, 110, 85, 83, 83, 85, 76, 87, 
  73, 80, 93, 95, 114, 80, 72, 104, 79, 74, 
  74, 80, 74, 84, 70, 77, 86, 113, 66, 77, 
  84, 101, 80, 79, 90, 91, 92, 88, 79, 89, 
  84, 104, 93, 82, 100, 72, 87, 75, 90, 68, 
  89, 95, 85, 90, 76, 68, 75, 73, 77, 75, 
  83, 73, 85, 78, 108, 67, 69, 87, 92, 76, 
  85, 89, 113, 93, 78, 77, 85, 62, 86, 92, 
  85, 62, 79, 74, 69, 78, 89, 81, 84, 85, 
  80, 154, 84, 87, 83, 78, 77, 83, 112, 73, 
  89, 87, 86, 84, 87, 73, 81, 86, 102, 91, 
  83, 69, 82, 96, 76, 81, 101, 82, 85, 79, 
  74, 84, 80, 77, 99, 66, 93, 87, 80, 96, 
  80, 121, 84, 90, 79, 85, 82, 87, 72, 78, 
  86, 74, 118, 78, 71, 93, 77, 73, 69, 77, 
  71, 87, 75, 83, 86, 126, 71, 67, 85, 76, 
  73, 83, 90, 102, 101, 93, 77, 103, 82, 117, 
  95, 77, 96, 69, 87, 89, 77, 78, 96, 99, 
  87, 77, 85, 69, 68, 79, 81, 74, 80, 84, 
  83, 80, 112, 67, 72, 68, 94, 80, 80, 87, 
  119, 101, 74, 70, 86, 55, 76, 96, 83, 66, 
  82, 80, 64, 72, 88, 81, 86, 86, 79, 161, 
  86, 85, 89, 74, 79, 79, 112, 61, 77, 81, 
  84, 81, 85, 71, 75, 94, 109, 88, 81, 69, 
  83, 94, 80, 79, 100, 94, 76, 84, 79, 85, 
  82, 72, 87, 73, 88, 81, 78, 98, 82, 123, 
  80, 86, 87, 88, 84, 90, 82, 78, 86, 69, 
  107, 80, 75, 79, 81, 94, 83, 81, 65, 83, 
  74, 77, 84, 93, 69, 76, 80, 72, 81, 82, 
  94, 84, 89, 91, 89, 93, 84, 110, 92, 80, 
  100, 79, 88, 75, 86, 75, 103, 96, 79, 88, 
  97, 74, 80, 78, 80, 77, 86, 99, 92, 82, 
  107, 65, 75, 66, 86, 83, 81, 83, 113, 92, 
  82, 69, 86, 63, 87, 86, 90, 66, 80, 79, 
  72, 80, 81, 82, 84, 91, 82, 129, 86, 88, 
  80, 80, 81, 85, 91, 71, 82, 86, 82, 86, 
  78, 76, 75, 84, 95, 93, 79, 71, 91, 85, 
  81, 89, 72, 84, 82, 74, 85, 83, 87, 82, 
  85, 68, 87, 82, 85, 77, 77, 98, 78, 90, 
  77, 98, 78, 73, 69, 80, 79, 69, 98, 75, 
  77, 91, 82, 80, 88, 80, 81, 74, 83, 79, 
  86, 89, 72, 94, 74, 103, 82, 87, 77, 91, 
  101, 86, 86, 67, 73, 71, 90, 89, 106, 84, 
  77, 87, 72, 74, 102, 97, 82, 65, 73, 81, 
  71, 73, 73, 77, 94, 78, 70, 80, 90, 79, 
  83, 76, 74, 87, 85, 86, 105, 82, 70, 85, 
  84, 75, 87, 93, 87, 84, 80, 88, 58, 100, 
  82, 84, 85, 87, 79, 109, 83, 83, 92, 73, 
  79, 82, 92, 93, 77, 87, 78, 73, 89, 77, 
  82, 86, 90, 81, 85, 84, 95, 90, 78, 91, 
  73, 80, 86, 70, 82, 88, 91, 82, 80, 81, 
  86, 92, 85, 81, 80, 98, 84, 96, 83, 97, 
  81, 64, 76, 80, 77, 73, 88, 75, 80, 86, 
  82, 79, 89, 86, 80, 64, 96, 70, 84, 79, 
  81, 88, 75, 84, 82, 87, 83, 79, 105, 87, 
  86, 84, 83, 70, 91, 86, 112, 91, 78, 96, 
  63, 82, 108, 100, 83, 67, 77, 80, 70, 85, 
  69, 76, 93, 94, 70, 74, 88, 75, 83, 79, 
  65, 95, 80, 82, 87, 82, 70, 80, 81, 70, 
  85, 90, 88, 90, 78, 94, 62, 91, 75, 86, 
  90, 89, 77, 104, 84, 81, 82, 78, 77, 81, 
  80, 85, 85, 87, 77, 80, 84, 80, 79, 82, 
  70, 85, 86, 86, 86, 101, 78, 84, 79, 88, 
  79, 72, 79, 86, 87, 78, 95, 90, 84, 85, 
  80, 81, 78, 93, 82, 87, 85, 98, 87, 73, 
  78, 78, 76, 73, 90, 78, 78, 81, 73, 86, 
  84, 86, 78, 71, 87, 79, 77, 78, 79, 87, 
  75, 81, 87, 88, 80, 75, 94, 91, 87, 100, 
  77, 78, 89, 88, 109, 89, 81, 85, 75, 82, 
  114, 103, 77, 68, 87, 90, 75, 77, 72, 77, 
  95, 89, 71, 78, 92, 77, 85, 88, 75, 93, 
  81, 78, 95, 85, 71, 68, 85, 77, 84, 88, 
  87, 85, 79, 82, 63, 89, 80, 86, 88, 88, 
  87, 95, 88, 84, 75, 79, 81, 82, 68, 88, 
  87, 92, 83, 78, 73, 81, 79, 83, 83, 85, 
  83, 83, 89, 84, 83, 87, 57, 80, 86, 86, 
  89, 85, 91, 87, 82, 88, 78, 79, 91, 79, 
  79, 78, 85, 95, 78, 94, 81, 72, 85, 78, 
  94, 66, 78, 80, 85, 70, 73, 94, 99, 81, 
  89, 74, 87, 67, 81, 63, 86, 97, 80, 89, 
  98, 92, 70, 82, 89, 85, 88, 72, 80, 51, 
  76, 98, 100, 86, 79, 99, 74, 88, 88, 91, 
  94, 85, 73, 80, 82, 80, 74, 77, 95, 84, 
  87, 86, 73, 92, 84, 69, 64, 95, 83, 68, 
  75, 77, 77, 86, 77, 85, 94, 89, 91, 108, 
  90, 88, 69, 93, 79, 83, 89, 81, 79, 69, 
  75, 87, 89, 81, 90, 83, 72, 96, 87, 84, 
  80, 73, 93, 85, 82, 90, 87, 87, 90, 83, 
  85, 86, 76, 84, 62, 82, 85, 82, 97, 86, 
  93, 86, 67, 89, 80, 75, 92, 87, 83, 69, 
  91, 93, 84, 96, 85, 64, 93, 82, 92, 73, 
  73, 74, 85, 74, 80, 87, 100, 86, 88, 61, 
  90, 63, 83, 55, 90, 112, 85, 82, 104, 88, 
  81, 69, 88, 82, 89, 73, 93, 57, 77, 93, 
  97, 99, 81, 99, 69, 93, 84, 83, 84, 79, 
  73, 82, 87, 89, 68, 87, 101, 91, 87, 79, 
  71, 89, 89, 88, 59, 98, 86, 65, 69, 78, 
  79, 82, 77, 85, 96, 92, 88, 112, 88, 85, 
  80, 89, 74, 86, 89, 82, 85, 63, 78, 87, 
  82, 87, 90, 85, 68, 92, 91, 88, 78, 83, 
  93, 88, 83, 83, 77, 90, 93, 82, 81, 92, 
  81, 84, 61, 83, 87, 81, 86, 84, 92, 83, 
  85, 90, 76, 81, 88, 79, 78, 64, 85, 89, 
  79, 94, 87, 69, 87, 78, 92, 77, 82, 82, 
  82, 86, 72, 88, 94, 84, 87, 73, 90, 69, 
  79, 61, 89, 95, 82, 87, 106, 88, 72, 73, 
  87, 82, 88, 82, 79, 53, 81, 94, 99, 90, 
  83, 96, 78, 91, 86, 87, 85, 79, 82, 88, 
  82, 85, 63, 80, 89, 78, 85, 85, 76, 92, 
  87, 99, 64, 96, 85, 68, 72, 79, 78, 85, 
  84, 84, 97, 89, 89, 104, 79, 84, 74, 87, 
  81, 87, 89, 81, 86, 64, 77, 89, 82, 83, 
  90, 82, 65, 94, 83, 89, 83, 77, 80, 88, 
  82, 90, 80, 88, 89, 83, 83, 75, 81, 73, 
  90, 93, 88, 75, 91, 58, 95, 73, 88, 73, 
  79, 103, 71, 85, 96, 82, 73, 78, 84, 76, 
  90, 77, 81, 72, 92, 87, 98, 85, 93, 101, 
  94, 81, 89, 88, 81, 81, 81, 100, 87, 95, 
  77, 84, 99, 99, 82, 80, 81, 77, 81, 89, 
  84, 88, 75, 87, 74, 92, 95, 85, 84, 81, 
  91, 83, 71, 75, 86, 78, 80, 97, 73, 89, 
  86, 84, 68, 87, 78, 80, 86, 74, 85, 82, 
  85, 79, 75, 85, 91, 86, 67, 83, 84, 75, 
  76, 78, 76, 97, 77, 76, 80, 86, 85, 84, 
  87, 82, 85, 89, 77, 81, 87, 81, 86, 77, 
  82, 74, 89, 92, 86, 89, 84, 89, 88, 82, 
  80, 81, 97, 84, 85, 80, 85, 65, 95, 84, 
  91, 68, 79, 60, 95, 77, 87, 83, 79, 90, 
  72, 84, 99, 91, 78, 77, 82, 67, 86, 73, 
  82, 74, 89, 87, 105, 77, 90, 100, 92, 85, 
  79, 73, 89, 76, 77, 103, 79, 101, 82, 77, 
  89, 86, 73, 76, 79, 74, 76, 89, 80, 88, 
  76, 82, 76, 96, 98, 83, 83, 78, 82, 85, 
  77, 80, 83, 78, 86, 98, 67, 85, 92, 85, 
  59, 91, 73, 77, 90, 74, 87, 74, 93, 79, 
  79, 98, 85, 81, 64, 83, 92, 67, 71, 75, 
  79, 96, 85, 81, 72, 88, 88, 83, 63, 84, 
  94, 92, 83, 78, 83, 83, 91, 80, 88, 79, 
  86, 94, 86, 84, 77, 91, 83, 85, 78, 77, 
  94, 80, 86, 87, 93, 74, 92, 87, 86, 75, 
  86, 56, 92, 77, 83, 83, 80, 106, 74, 83, 
  96, 86, 84, 79, 89, 80, 79, 81, 87, 74, 
  86, 88, 91, 87, 95, 87, 92, 87, 87, 94, 
  79, 81, 81, 99, 79, 93, 86, 79, 90, 82, 
  81, 81, 82, 75, 77, 88, 88, 81, 77, 86, 
  74, 87, 95, 87, 87, 76, 94, 79, 76, 80, 
  88, 79, 84, 100, 79, 89, 97, 86, 71, 97, 
  77, 86, 86, 73, 89, 80, 83, 81, 78, 81, 
  89, 87, 70, 79, 84, 77, 74, 81, 84, 97, 
  92, 86, 85, 75, 86, 82, 79, 83, 78, 84, 
  81, 80, 83, 83, 84, 79, 85, 82, 85, 89, 
  82, 87, 77, 86, 82, 82, 83, 82, 91, 85, 
  82, 75, 73, 70, 78, 86, 94, 70, 97, 52, 
  89, 77, 77, 71, 82, 114, 73, 81, 81, 81, 
  78, 81, 87, 75, 90, 87, 82, 70, 91, 81, 
  95, 87, 101, 89, 92, 89, 78, 102, 82, 80, 
  73, 88, 83, 92, 74, 95, 98, 103, 83, 74, 
  86, 76, 80, 90, 88, 86, 78, 84, 83, 102, 
  87, 84, 82, 82, 98, 85, 75, 77, 100, 68, 
  96, 82, 77, 80, 87, 75, 76, 93, 80, 85, 
  83, 79, 79, 79, 82, 77, 69, 82, 83, 94, 
  61, 88, 77, 70, 66, 77, 90, 94, 86, 79, 
  79, 99, 88, 80, 88, 83, 86, 83, 81, 76, 
  87, 78, 80, 77, 76, 66, 79, 95, 82, 80, 
  83, 78, 80, 71, 83, 82, 90, 85, 83, 85, 
  84, 68, 83, 81, 94, 64, 89, 46, 86, 80, 
  84, 88, 86, 109, 82, 85, 82, 88, 77, 83, 
  80, 63, 81, 79, 79, 74, 93, 83, 102, 85, 
  114, 85, 91, 81, 70, 81, 88, 76, 75, 88, 
  83, 99, 77, 89, 105, 89, 74, 77, 91, 73, 
  77, 95, 83, 84, 81, 84, 79, 119, 90, 85, 
  83, 76, 77, 88, 88, 78, 98, 66, 73, 81, 
  61, 73, 97, 66, 82, 94, 66, 91, 89, 80, 
  81, 81, 85, 83, 75, 88, 76, 93, 60, 81, 
  87, 62, 53, 75, 96, 99, 88, 81, 71, 88, 
  91, 80, 76, 73, 96, 84, 88, 75, 88, 81, 
  85, 72, 76, 74, 78, 96, 97, 70, 78, 81, 
  78, 74, 87, 82, 96, 87, 78, 87, 104, 73, 
  83, 92, 92, 63, 89, 51, 85, 76, 77, 90, 
  85, 112, 74, 77, 80, 77, 80, 88, 89, 82, 
  78, 88, 86, 70, 83, 90, 88, 88, 95, 77, 
  81, 80, 76, 109, 78, 77, 79, 81, 85, 90, 
  81, 85, 95, 79, 83, 75, 85, 81, 78, 87, 
  87, 80, 82, 85, 80, 94, 91, 90, 84, 81, 
  99, 80, 86, 80, 92, 76, 72, 84, 76, 85, 
  90, 77, 79, 94, 70, 88, 86, 77, 80, 97, 
  79, 83, 78, 82, 81, 97, 62, 83, 80, 71, 
  69, 80, 91, 96, 83, 86, 83, 71, 87, 78, 
  83, 86, 82, 80, 85, 78, 80, 81, 78, 68, 
  79, 79, 98, 92, 87, 83, 78, 78, 78, 71, 
  83, 87, 87, 85, 78, 80, 86, 68, 67, 89, 
  92, 66, 105, 55, 75, 82, 78, 75, 83, 124, 
  71, 77, 71, 77, 95, 84, 82, 85, 101, 89, 
  95, 70, 91, 82, 76, 92, 98, 86, 91, 102, 
  84, 118, 80, 87, 83, 80, 84, 85, 76, 107, 
  93, 98, 92, 81, 78, 72, 85, 89, 90, 87, 
  80, 82, 98, 97, 77, 87, 88, 88, 109, 76, 
  78, 82, 94, 74, 99, 71, 104, 85, 81, 79, 
  81, 91, 86, 79, 80, 87, 80, 80, 78, 73, 
  66, 74, 91, 98, 64, 100, 78, 70, 73, 84, 
  87, 90, 92, 97, 84, 100, 83, 72, 83, 94, 
  79, 77, 74, 82, 83, 68, 67, 103, 77, 72, 
  71, 91, 85, 78, 79, 76, 88, 64, 82, 88, 
  88, 87, 77, 87, 92, 68, 61, 76, 90, 64, 
  117, 49, 68, 86, 87, 86, 86, 123, 79, 73, 
  58, 69, 88, 86, 80, 81, 89, 84, 99, 77, 
  93, 86, 64, 102, 111, 74, 87, 86, 81, 125, 
  77, 90, 84, 74, 90, 84, 74, 115, 109, 89, 
  82, 89, 78, 75, 79, 88, 88, 81, 78, 89, 
  88, 98, 75, 86, 85, 80, 96, 76, 86, 73, 
  100, 75, 82, 67, 91, 79, 84, 62, 97, 90, 
  73, 86, 80, 83, 74, 95, 68, 78, 72, 73, 
  86, 101, 53, 93, 77, 66, 60, 77, 87, 91, 
  107, 98, 83, 89, 80, 70, 95, 85, 82, 72, 
  71, 83, 79, 70, 64, 76, 77, 72, 84, 94, 
  105, 69, 83, 73, 84, 69, 87, 88, 89, 96, 
  77, 85, 93, 71, 72, 86, 92, 62, 98, 60, 
  75, 80, 84, 95, 88, 118, 78, 72, 71, 74, 
  86, 87, 93, 87, 87, 85, 95, 72, 89, 92, 
  76, 91, 93, 84, 74, 78, 79, 121, 80, 85, 
  87, 76, 98, 85, 80, 93, 85, 81, 93, 85, 
  79, 77, 84, 86, 87, 76, 75, 88, 93, 97, 
  81, 90, 89, 85, 97, 75, 81, 86, 87, 84, 
  70, 76, 97, 96, 80, 81, 80, 94, 78, 78, 
  84, 88, 69, 100, 76, 84, 97, 81, 88, 93, 
  63, 89, 82, 70, 74, 85, 86, 90, 95, 84, 
  84, 79, 84, 72, 80, 95, 86, 78, 77, 78, 
  73, 72, 69, 68, 77, 88, 102, 95, 85, 85, 
  83, 75, 89, 70, 84, 95, 88, 88, 93, 76, 
  88, 75, 77, 86, 89, 76, 83, 80, 82, 78, 
  77, 91, 91, 73, 89, 89, 70, 88, 80, 84, 
  96, 92, 74, 62, 85, 78, 94, 91, 82, 79, 
  90, 69, 87, 91, 82, 81, 98, 85, 92, 80, 
  91, 74, 85, 80, 92, 86, 63, 88, 92, 75, 
  89, 90, 88, 73, 71, 86, 80, 93, 80, 78, 
  83, 70, 88, 60, 88, 95, 67, 85, 74, 95, 
  77, 90, 69, 75, 75, 66, 88, 93, 80, 82, 
  82, 84, 66, 85, 93, 85, 62, 79, 86, 81, 
  82, 83, 90, 71, 74, 182, 87, 75, 72, 69, 
  82, 76, 95, 91, 65, 72, 82, 73, 92, 91, 
  82, 81, 74, 86, 82, 91, 86, 87, 90, 75, 
  73, 80, 97, 98, 86, 142, 100, 82, 77, 79, 
  82, 88, 89, 75, 83, 76, 84, 75, 81, 81, 
  86, 76, 85, 92, 76, 86, 87, 90, 85, 94, 
  73, 64, 87, 80, 88, 77, 81, 92, 82, 71, 
  99, 76, 80, 74, 88, 83, 81, 76, 86, 79, 
  77, 88, 91, 83, 66, 81, 80, 80, 96, 102, 
  93, 76, 74, 97, 80, 89, 80, 83, 80, 83, 
  83, 65, 85, 92, 69, 81, 75, 86, 83, 85, 
  71, 75, 72, 68, 97, 97, 84, 89, 82, 77, 
  63, 77, 84, 75, 68, 82, 90, 83, 80, 94, 
  91, 81, 83, 181, 90, 70, 67, 62, 81, 74, 
  90, 92, 65, 71, 86, 75, 92, 93, 87, 85, 
  76, 75, 74, 89, 82, 90, 86, 76, 72, 82, 
  108, 91, 87, 131, 89, 90, 75, 77, 83, 96, 
  87, 76, 86, 83, 81, 85, 84, 86, 91, 73, 
  88, 88, 72, 95, 88, 87, 80, 91, 73, 61, 
  87, 77, 83, 71, 76, 81, 93, 76, 97, 87, 
  84, 79, 85, 88, 85, 76, 93, 76, 85, 84, 
  87, 90, 71, 92, 89, 83, 87, 87, 83, 85, 
  72, 85, 88, 88, 79, 77, 83, 68, 96, 63, 
  93, 93, 68, 82, 90, 89, 77, 85, 74, 74, 
  79, 72, 99, 93, 81, 83, 88, 78, 71, 81, 
  84, 91, 64, 85, 88, 101, 82, 80, 94, 74, 
  75, 166, 86, 72, 72, 76, 81, 78, 92, 81, 
  69, 78, 86, 77, 91, 86, 83, 102, 66, 90, 
  80, 90, 88, 85, 72, 74, 73, 82, 92, 95, 
  88, 126, 88, 80, 75, 82, 80, 93, 90, 78, 
  88, 79, 82, 79, 87, 92, 86, 73, 89, 93, 
  78, 82, 84, 79, 89, 94, 78, 59, 89, 80, 
  93, 74, 86, 86, 96, 80, 68, 85, 71, 81, 
  93, 89, 79, 84, 95, 82, 78, 84, 94, 86, 
  64, 89, 99, 80, 90, 100, 86, 80, 74, 86, 
  73, 97, 74, 82, 83, 70, 85, 73, 81, 76, 
  87, 80, 88, 85, 80, 86, 72, 79, 77, 71, 
  81, 107, 80, 76, 83, 80, 75, 84, 97, 82, 
  65, 77, 84, 87, 74, 86, 94, 76, 77, 161, 
  89, 78, 69, 78, 78, 79, 87, 83, 78, 78, 
  78, 76, 86, 87, 83, 80, 63, 81, 81, 82, 
  85, 90, 84, 77, 70, 81, 97, 88, 91, 125, 
  81, 83, 75, 85, 79, 84, 91, 78, 91, 78, 
  83, 84, 85, 86, 83, 70, 86, 99, 86, 75, 
  88, 73, 86, 93, 82, 60, 89, 84, 90, 64, 
  90, 95, 91, 77, 68, 73, 64, 79, 94, 85, 
  78, 88, 91, 91, 74, 84, 97, 82, 66, 82, 
  93, 86, 96, 109, 89, 78, 75, 96, 79, 96, 
  77, 83, 84, 84, 82, 81, 82, 69, 88, 82, 
  74, 79, 80, 88, 73, 82, 71, 75, 78, 106, 
  86, 87, 78, 75, 71, 82, 84, 78, 68, 73, 
  89, 84, 76, 89, 81, 89, 86, 158, 92, 75, 
  67, 72, 82, 75, 81, 82, 82, 81, 74, 76, 
  89, 91, 88, 81, 69, 75, 75, 85, 88, 91, 
  79, 80, 70, 84, 109, 82, 92, 108, 88, 91, 
  84, 81, 79, 89, 85, 75, 88, 79, 81, 86, 
  80, 86, 86, 73, 89, 90, 76, 91, 87, 80, 
  92, 89, 77, 61, 85, 76, 87, 77, 84, 87, 
  94, 75, 89, 88, 77, 82, 95, 89, 84, 83, 
  92, 82, 82, 86, 91, 87, 73, 88, 99, 83, 
  89, 96, 85, 79, 76, 87, 78, 85, 72, 81, 
  84, 69, 91, 72, 86, 78, 82, 82, 84, 85, 
  78, 85, 76, 77, 79, 77, 82, 107, 80, 79, 
  89, 80, 79, 90, 83, 88, 65, 77, 85, 87, 
  76, 84, 91, 79, 80, 152, 84, 78, 74, 77, 
  78, 80, 86, 77, 73, 82, 78, 76, 91, 86, 
  86, 94, 71, 83, 85, 83, 89, 91, 78, 76, 
  70, 83, 93, 88, 92, 111, 87, 76, 75, 80, 
  87, 83, 91, 82, 85, 86, 82, 87, 78, 82, 
  93, 77, 97, 85, 71, 82, 84, 96, 79, 103, 
  79, 64, 99, 81, 87, 76, 90, 78, 104, 77, 
  88, 93, 87, 85, 91, 88, 94, 75, 95, 80, 
  85, 93, 91, 85, 68, 97, 93, 79, 86, 89, 
  81, 86, 74, 80, 71, 86, 66, 76, 83, 74, 
  91, 70, 86, 74, 87, 79, 95, 92, 78, 83, 
  74, 73, 81, 78, 92, 84, 85, 69, 90, 85, 
  77, 89, 96, 84, 71, 84, 79, 93, 79, 89, 
  97, 69, 70, 136, 78, 76, 82, 85, 88, 85, 
  82, 86, 80, 76, 75, 75, 85, 85, 89, 77, 
  66, 86, 73, 85, 83, 97, 85, 74, 71, 84, 
  81, 84, 91, 120, 82, 79, 76, 83, 90, 82, 
  92, 80, 81, 84, 85, 90, 74, 89, 95, 74, 
  92, 86, 75, 78, 85, 90, 81, 98, 77, 63, 
  96, 78, 87, 83, 91, 76, 96, 79, 78, 87, 
  86, 82, 91, 85, 95, 67, 92, 82, 82, 84, 
  86, 89, 67, 95, 86, 79, 86, 93, 78, 78, 
  70, 88, 74, 96, 71, 76, 87, 79, 94, 75, 
  94, 75, 83, 87, 75, 85, 76, 83, 74, 74, 
  77, 75, 89, 79, 87, 80, 88, 88, 73, 92, 
  85, 87, 67, 84, 84, 91, 76, 86, 93, 68, 
  75, 130, 76, 75, 88, 92, 92, 81, 78, 87, 
  91, 75, 74, 72, 84, 86, 86, 83, 75, 95, 
  79, 90, 86, 98, 94, 76, 73, 85, 82, 81, 
  88, 111, 86, 85, 88, 82, 86, 81, 88, 81, 
  90, 81, 83, 95, 74, 91, 90, 74, 98, 85, 
  74, 87, 89, 92, 86, 98, 81, 64, 95, 78, 
  81, 88, 88, 76, 101, 75, 90, 90, 89, 88, 
  87, 89, 91, 78, 89, 83, 83, 90, 92, 82, 
  77, 92, 91, 83, 88, 85, 79, 69, 80, 84, 
  75, 83, 68, 74, 85, 78, 86, 72, 89, 76, 
  87, 83, 72, 87, 73, 82, 75, 75, 80, 75, 
  78, 87, 86, 72, 94, 88, 83, 102, 77, 86, 
  77, 85, 83, 84, 77, 90, 87, 70, 73, 128, 
  84, 73, 81, 75, 84, 85, 83, 83, 78, 83, 
  81, 79, 92, 82, 87, 88, 78, 89, 85, 82, 
  84, 98, 90, 76, 73, 84, 84, 84, 89, 113, 
  118, 82, 96, 92, 92, 70, 80, 94, 82, 89, 
  82, 91, 79, 102, 72, 75, 88, 72, 92, 83, 
  84, 86, 83, 86, 103, 75, 88, 81, 85, 81, 
  75, 96, 79, 74, 66, 74, 96, 78, 77, 74, 
  84, 78, 82, 73, 74, 91, 98, 68, 90, 80, 
  86, 82, 88, 73, 78, 93, 73, 78, 80, 82, 
  89, 63, 91, 77, 49, 87, 94, 93, 85, 107, 
  64, 77, 78, 89, 92, 80, 83, 91, 80, 72, 
  79, 92, 94, 88, 79, 88, 79, 103, 97, 71, 
  76, 83, 62, 83, 81, 74, 90, 76, 76, 80, 
  78, 82, 82, 95, 75, 115, 99, 81, 84, 93, 
  90, 67, 84, 70, 94, 118, 106, 79, 67, 62, 
  80, 81, 67, 87, 85, 97, 73, 84, 115, 91, 
  81, 93, 90, 74, 82, 97, 75, 88, 80, 90, 
  70, 101, 72, 72, 90, 77, 81, 91, 85, 67, 
  86, 88, 82, 82, 87, 76, 94, 85, 69, 89, 
  71, 76, 72, 74, 98, 76, 81, 63, 84, 70, 
  81, 73, 76, 83, 100, 63, 84, 82, 87, 77, 
  91, 66, 78, 102, 88, 78, 79, 89, 85, 70, 
  98, 85, 63, 82, 76, 100, 71, 114, 86, 76, 
  79, 89, 100, 77, 87, 74, 99, 62, 74, 90, 
  80, 89, 78, 86, 69, 96, 94, 71, 81, 90, 
  71, 89, 85, 75, 82, 80, 81, 71, 77, 100, 
  74, 98, 72, 114, 108, 78, 85, 96, 84, 69, 
  80, 77, 101, 107, 91, 82, 61, 64, 72, 97, 
  62, 88, 83, 98, 69, 73, 119, 90, 67, 93, 
  90, 79, 83, 93, 82, 86, 85, 92, 85, 92, 
  75, 75, 82, 71, 89, 84, 91, 80, 77, 85, 
  84, 82, 87, 81, 83, 77, 68, 90, 80, 78, 
  79, 78, 90, 82, 92, 79, 87, 72, 86, 77, 
  75, 86, 94, 87, 89, 78, 86, 82, 92, 76, 
  81, 97, 79, 80, 82, 80, 88, 78, 93, 80, 
  57, 86, 73, 95, 87, 91, 96, 69, 79, 82, 
  99, 73, 86, 72, 92, 72, 85, 92, 88, 92, 
  77, 79, 69, 98, 91, 77, 79, 92, 62, 83, 
  79, 75, 90, 77, 94, 83, 79, 110, 81, 96, 
  80, 110, 99, 80, 84, 90, 70, 65, 79, 85, 
  80, 101, 77, 78, 68, 69, 81, 84, 81, 85, 
  90, 92, 72, 86, 93, 87, 84, 80, 78, 104, 
  75, 81, 87, 81, 76, 90, 94, 84, 85, 80, 
  82, 82, 77, 71, 85, 82, 75, 78, 104, 90, 
  72, 75, 83, 96, 72, 86, 85, 89, 80, 93, 
  80, 73, 81, 106, 79, 77, 77, 83, 74, 87, 
  85, 84, 80, 92, 69, 77, 90, 66, 76, 79, 
  70, 70, 83, 94, 76, 79, 76, 73, 76, 95, 
  74, 102, 79, 90, 80, 86, 87, 64, 88, 87, 
  80, 93, 71, 95, 81, 85, 85, 87, 84, 77, 
  84, 98, 77, 88, 93, 75, 74, 83, 77, 92, 
  79, 86, 93, 81, 75, 77, 74, 85, 81, 107, 
  92, 87, 79, 96, 82, 77, 89, 74, 79, 94, 
  103, 85, 84, 66, 88, 82, 80, 87, 93, 92, 
  73, 64, 78, 106, 70, 74, 73, 98, 84, 79, 
  82, 87, 72, 92, 88, 74, 86, 95, 74, 97, 
  78, 79, 86, 65, 90, 83, 90, 108, 72, 73, 
  87, 81, 81, 82, 85, 84, 86, 79, 78, 72, 
  71, 96, 73, 73, 78, 91, 61, 86, 89, 77, 
  61, 103, 68, 73, 90, 55, 76, 82, 82, 79, 
  83, 119, 72, 84, 71, 83, 82, 87, 76, 110, 
  64, 92, 71, 85, 87, 75, 99, 103, 91, 82, 
  91, 93, 83, 87, 74, 78, 88, 78, 71, 88, 
  80, 100, 94, 78, 95, 93, 72, 114, 72, 78, 
  100, 70, 71, 88, 68, 83, 92, 83, 105, 90, 
  75, 101, 81, 84, 85, 74, 82, 76, 84, 94, 
  98, 73, 80, 105, 74, 88, 102, 89, 82, 61, 
  98, 93, 83, 84, 77, 82, 79, 82, 88, 82, 
  79, 95, 94, 83, 87, 83, 74, 81, 78, 80, 
  88, 88, 97, 79, 89, 91, 75, 76, 81, 73, 
  73, 87, 85, 80, 94, 89, 77, 70, 78, 104, 
  80, 74, 87, 87, 78, 79, 85, 97, 72, 92, 
  76, 78, 88, 69, 78, 78, 76, 71, 81, 91, 
  77, 89, 80, 74, 85, 92, 80, 100, 81, 89, 
  88, 82, 87, 62, 91, 84, 81, 83, 84, 96, 
  84, 83, 84, 91, 81, 79, 73, 93, 76, 86, 
  89, 78, 75, 86, 78, 93, 81, 88, 93, 85, 
  80, 93, 74, 85, 83, 98, 99, 88, 80, 90, 
  79, 75, 89, 88, 77, 82, 85, 89, 87, 69, 
  79, 83, 82, 85, 93, 86, 74, 72, 96, 83, 
  85, 86, 82, 84, 73, 81, 89, 84, 83, 87, 
  82, 80, 87, 81, 85, 86, 77, 77, 90, 84, 
  80, 70, 95, 88, 85, 81, 79, 80, 77, 83, 
  88, 90, 85, 95, 90, 83, 84, 97, 88, 96, 
  97, 83, 81, 84, 80, 88, 85, 86, 69, 84, 
  77, 83, 75, 81, 77, 82, 83, 86, 83, 80, 
  81, 83, 84, 93, 82, 92, 84, 91, 94, 86, 
  86, 70, 78, 83, 85, 78, 71, 106, 84, 81, 
  87, 88, 86, 83, 75, 92, 80, 80, 89, 85, 
  81, 80, 81, 93, 94, 90, 94, 88, 85, 91, 
  81, 84, 76, 91, 74, 89, 85, 73, 79, 89, 
  89, 77, 80, 83, 80, 83, 95, 80, 87, 83, 
  93, 80, 94, 89, 84, 75, 85, 88, 87, 73, 
  72, 94, 75, 76, 83, 87, 85, 82, 79, 84, 
  84, 98, 83, 97, 74, 82, 92, 73, 88, 76, 
  81, 88, 86, 77, 79, 68, 79, 80, 84, 96, 
  79, 81, 95, 92, 80, 91, 86, 97, 93, 90, 
  69, 91, 85, 79, 77, 95, 72, 90, 72, 74, 
  73, 87, 88, 86, 88, 101, 82, 81, 81, 85, 
  88, 90, 86, 91, 81, 96, 89, 84, 93, 83, 
  87, 93, 86, 75, 73, 110, 86, 77, 78, 82, 
  86, 87, 72, 87, 82, 85, 88, 97, 94, 80, 
  81, 105, 84, 87, 92, 81, 80, 87, 75, 82, 
  76, 87, 76, 91, 79, 74, 86, 89, 81, 75, 
  90, 77, 85, 94, 101, 83, 78, 93, 85, 81, 
  94, 85, 86, 75, 91, 81, 87, 83, 84, 75, 
  74, 79, 90, 86, 87, 88, 85, 88, 87, 83, 
  84, 82, 77, 80, 95, 84, 81, 71, 89, 85, 
  83, 82, 76, 72, 74, 82, 87, 85, 87, 92, 
  92, 85, 86, 96, 87, 93, 91, 82, 79, 82, 
  80, 87, 81, 87, 75, 87, 75, 87, 73, 74, 
  74, 81, 85, 90, 85, 83, 84, 80, 87, 95, 
  93, 94, 91, 93, 83, 86, 91, 66, 82, 86, 
  84, 79, 71, 111, 83, 76, 87, 90, 84, 84, 
  78, 92, 77, 80, 89, 79, 82, 85, 83, 95, 
  94, 89, 88, 89, 85, 81, 79, 84, 74, 91, 
  76, 89, 86, 71, 85, 85, 89, 80, 81, 87, 
  93, 89, 97, 79, 75, 88, 97, 78, 93, 87, 
  82, 75, 88, 71, 68, 90, 86, 62, 84, 80, 
  73, 95, 79, 57, 84, 71, 77, 79, 66, 89, 
  95, 78, 96, 102, 104, 108, 106, 94, 83, 89, 
  90, 85, 88, 74, 92, 64, 46, 64, 65, 73, 
  105, 69, 74, 92, 61, 69, 87, 94, 91, 55, 
  92, 92, 79, 68, 86, 80, 104, 57, 78, 75, 
  81, 74, 118, 81, 75, 87, 44, 87, 167, 92, 
  90, 133, 15, 90, 85, 91, 86, 83, 96, 129, 
  53, 79, 77, 85, 89, 71, 78, 97, 78, 123, 
  57, 80, 85, 68, 95, 76, 83, 71, 87, 77, 
  94, 88, 60, 69, 86, 90, 93, 97, 90, 90, 
  95, 98, 85, 92, 87, 71, 65, 143, 119, 86, 
  104, 89, 96, 97, 88, 82, 102, 82, 83, 114, 
  80, 87, 86, 89, 86, 58, 80, 93, 84, 86, 
  84, 69, 73, 58, 78, 93, 81, 77, 78, 88, 
  79, 81, 78, 77, 87, 81, 83, 83, 101, 97, 
  84, 77, 74, 69, 55, 73, 103, 88, 103, 68, 
  98, 72, 79, 77, 80, 77, 83, 56, 80, 71, 
  90, 80, 90, 84, 84, 99, 79, 96, 81, 79, 
  87, 75, 109, 107, 79, 84, 83, 79, 82, 104, 
  72, 78, 98, 92, 78, 69, 83, 58, 104, 60, 
  83, 95, 79, 78, 81, 98, 63, 80, 78, 79, 
  87, 91, 86, 76, 90, 74, 85, 80, 91, 74, 
  85, 78, 82, 90, 80, 89, 79, 92, 91, 81, 
  90, 84, 80, 76, 97, 81, 57, 78, 84, 89, 
  82, 84, 86, 81, 94, 83, 75, 77, 83, 85, 
  108, 88, 83, 82, 79, 103, 89, 84, 75, 73, 
  81, 80, 73, 97, 87, 90, 85, 87, 84, 83, 
  87, 77, 78, 84, 89, 81, 90, 91, 79, 86, 
  74, 79, 62, 95, 77, 95, 81, 82, 94, 69, 
  73, 89, 85, 82, 82, 69, 75, 80, 90, 99, 
  91, 93, 75, 85, 81, 93, 82, 79, 80, 81, 
  104, 93, 100, 68, 70, 84, 75, 83, 84, 82, 
  88, 82, 78, 83, 88, 78, 92, 75, 94, 81, 
  80, 93, 84, 89, 82, 74, 92, 80, 80, 82, 
  84, 86, 79, 78, 84, 81, 84, 78, 87, 72, 
  83, 86, 81, 80, 89, 83, 79, 85, 87, 74, 
  80, 90, 88, 80, 84, 81, 78, 82, 93, 84, 
  83, 90, 89, 83, 79, 81, 90, 76, 91, 90, 
  73, 101, 77, 82, 72, 93, 81, 67, 102, 79, 
  70, 77, 75, 81, 86, 83, 86, 102, 109, 92, 
  99, 87, 71, 89, 102, 94, 78, 83, 84, 80, 
  81, 112, 82, 83, 97, 85, 86, 105, 81, 72, 
  92, 97, 81, 98, 84, 77, 84, 85, 80, 78, 
  77, 74, 72, 54, 83, 79, 93, 80, 76, 65, 
  66, 80, 104, 68, 93, 81, 92, 105, 79, 82, 
  88, 74, 81, 131, 46, 105, 78, 78, 91, 98, 
  74, 94, 88, 101, 61, 72, 96, 63, 84, 70, 
  85, 77, 79, 75, 87, 89, 73, 48, 78, 87, 
  78, 79, 87, 82, 71, 74, 84, 80, 74, 86, 
  63, 110, 103, 81, 93, 72, 91, 85, 90, 79, 
  103, 75, 80, 89, 97, 74, 46, 79, 78, 78, 
  90, 71, 75, 95, 83, 70, 88, 47, 75, 78, 
  74, 70, 77, 75, 81, 75, 79, 92, 95, 82, 
  87, 92, 84, 85, 85, 70, 82, 74, 78, 85, 
  92, 73, 123, 71, 80, 94, 88, 73, 85, 99, 
  75, 67, 82, 68, 83, 74, 99, 79, 86, 129, 
  68, 70, 79, 81, 100, 82, 89, 101, 71, 87, 
  101, 72, 93, 94, 106, 99, 80, 91, 77, 78, 
  76, 112, 96, 71, 83, 91, 84, 66, 77, 88, 
  75, 99, 72, 84, 84, 78, 87, 74, 92, 82, 
  77, 81, 107, 89, 82, 78, 87, 90, 96, 90, 
  85, 86, 94, 78, 70, 95, 79, 72, 72, 119, 
  76, 86, 88, 96, 95, 89, 90, 79, 92, 87, 
  90, 88, 83, 74, 79, 85, 82, 69, 79, 89, 
  76, 81, 83, 73, 66, 69, 78, 95, 77, 76, 
  77, 82, 70, 73, 81, 79, 78, 75, 96, 82, 
  84, 97, 89, 78, 77, 77, 76, 77, 80, 90, 
  85, 68, 97, 77, 82, 85, 87, 75, 81, 60, 
  78, 77, 91, 89, 93, 86, 79, 113, 80, 90, 
  87, 83, 86, 86, 103, 100, 89, 70, 75, 83, 
  91, 88, 96, 87, 82, 87, 82, 83, 80, 77, 
  110, 58, 88, 93, 77, 86, 82, 93, 73, 73, 
  91, 85, 79, 97, 81, 75, 83, 75, 82, 85, 
  94, 79, 94, 66, 87, 87, 88, 85, 78, 89, 
  90, 79, 80, 91, 80, 82, 82, 87, 69, 85, 
  73, 91, 84, 86, 84, 86, 79, 92, 81, 88, 
  75, 88, 108, 94, 75, 80, 76, 88, 78, 83, 
  82, 91, 88, 83, 61, 79, 75, 78, 84, 97, 
  83, 96, 87, 76, 88, 84, 78, 81, 97, 88, 
  74, 89, 80, 76, 78, 95, 83, 87, 67, 91, 
  91, 90, 84, 92, 82, 90, 87, 100, 83, 77, 
  92, 96, 79, 82, 69, 79, 87, 62, 86, 80, 
  80, 85, 91, 70, 92, 72, 80, 73, 82, 83, 
  101, 82, 82, 83, 89, 78, 75, 65, 67, 90, 
  84, 87, 72, 95, 75, 88, 83, 78, 79, 86, 
  99, 77, 84, 69, 77, 78, 82, 68, 77, 83, 
  85, 75, 76, 85, 79, 85, 84, 86, 75, 70, 
  92, 68, 78, 81, 79, 75, 72, 72, 88, 84, 
  83, 91, 90, 87, 97, 87, 72, 75, 87, 74, 
  78, 81, 78, 97, 83, 70, 77, 84, 81, 91, 
  99, 77, 80, 74, 79, 82, 81, 84, 90, 81, 
  87, 79, 83, 81, 82, 89, 84, 99, 77, 84, 
  88, 82, 74, 110, 79, 80, 85, 89, 79, 98, 
  97, 89, 79, 94, 75, 100, 88, 87, 76, 85, 
  88, 78, 75, 83, 73, 56, 83, 83, 84, 89, 
  80, 84, 97, 76, 84, 84, 87, 70, 129, 95, 
  85, 88, 77, 75, 75, 84, 72, 78, 87, 84, 
  88, 87, 79, 82, 88, 81, 71, 84, 90, 81, 
  87, 88, 84, 87, 81, 80, 92, 80, 84, 82, 
  85, 87, 74, 74, 83, 81, 69, 80, 77, 78, 
  74, 87, 77, 80, 78, 83, 90, 87, 87, 98, 
  84, 81, 92, 84, 87, 75, 84, 71, 71, 86, 
  86, 87, 82, 78, 76, 75, 83, 82, 89, 91, 
  85, 78, 73, 86, 79, 83, 86, 69, 79, 78, 
  82, 86, 91, 83, 85, 102, 91, 79, 90, 87, 
  84, 86, 82, 91, 83, 75, 79, 86, 90, 93, 
  75, 73, 82, 83, 89, 82, 78, 87, 87, 84, 
  81, 101, 77, 71, 91, 92, 88, 89, 83, 94, 
  90, 67, 79, 93, 84, 76, 94, 81, 84, 84, 
  81, 82, 72, 77, 94, 67, 85, 75, 85, 85, 
  85, 79, 86, 71, 78, 86, 83, 88, 83, 98, 
  77, 90, 83, 80, 95, 71, 85, 75, 88, 86, 
  83, 82, 82, 83, 82, 76, 75, 86, 82, 94, 
  80, 78, 79, 94, 76, 89, 84, 91, 83, 84, 
  83, 89, 86, 78, 93, 71, 93, 68, 69, 81, 
  82, 81, 73, 71, 81, 100, 89, 65, 84, 74, 
  82, 77, 56, 82, 83, 81, 77, 71, 80, 86, 
  72, 79, 103, 86, 95, 84, 85, 97, 87, 102, 
  80, 83, 78, 86, 80, 90, 89, 78, 101, 63, 
  80, 82, 106, 80, 72, 65, 75, 86, 68, 75, 
  86, 91, 69, 94, 87, 77, 87, 92, 84, 84, 
  76, 103, 96, 90, 96, 101, 74, 80, 91, 76, 
  76, 96, 86, 83, 79, 76, 68, 101, 110, 86, 
  86, 82, 72, 83, 75, 83, 90, 82, 80, 86, 
  87, 93, 93, 66, 82, 86, 79, 83, 98, 83, 
  85, 85, 71, 81, 94, 90, 66, 94, 88, 82, 
  78, 84, 85, 74, 87, 88, 75, 79, 60, 82, 
  77, 56, 81, 68, 79, 82, 80, 96, 76, 76, 
  83, 80, 86, 94, 77, 87, 72, 75, 79, 88, 
  78, 81, 88, 90, 67, 77, 70, 74, 84, 77, 
  90, 84, 88, 87, 101, 80, 77, 82, 75, 85, 
  66, 83, 80, 90, 72, 88, 91, 80, 77, 88, 
  89, 75, 84, 85, 71, 89, 82, 67, 89, 74, 
  71, 93, 86, 79, 77, 80, 68, 94, 71, 98, 
  100, 79, 67, 80, 83, 72, 88, 87, 85, 102, 
  84, 79, 80, 80, 70, 69, 86, 74, 89, 76, 
  65, 76, 91, 106, 75, 79, 88, 88, 88, 79, 
  92, 82, 71, 85, 88, 79, 89, 84, 88, 87, 
  76, 79, 84, 85, 75, 88, 97, 82, 89, 83, 
  88, 81, 100, 86, 85, 84, 65, 80, 84, 73, 
  85, 77, 83, 92, 93, 98, 82, 83, 88, 88, 
  91, 83, 89, 93, 75, 90, 80, 92, 100, 87, 
  72, 89, 74, 90, 78, 78, 91, 77, 76, 85, 
  78, 94, 99, 87, 69, 77, 96, 94, 87, 80, 
  89, 85, 78, 93, 91, 84, 79, 92, 70, 79, 
  79, 119, 86, 93, 109, 87, 80, 85, 97, 83, 
  82, 81, 84, 65, 78, 96, 76, 81, 78, 85, 
  71, 66, 101, 81, 81, 93, 90, 86, 85, 92, 
  101, 86, 91, 74, 67, 86, 80, 66, 110, 67, 
  79, 105, 80, 89, 87, 78, 75, 80, 77, 105, 
  64, 69, 91, 66, 86, 86, 87, 89, 94, 91, 
  70, 80, 88, 94, 99, 95, 93, 81, 91, 100, 
  111, 87, 102, 100, 98, 86, 98, 111, 94, 78, 
  84, 61, 71, 79, 95, 82, 67, 73, 78, 98, 
  92, 72, 91, 73, 91, 73, 49, 85, 94, 69, 
  74, 71, 78, 93, 63, 75, 118, 83, 105, 86, 
  77, 108, 88, 83, 72, 82, 74, 89, 97, 91, 
  94, 80, 92, 65, 75, 83, 105, 77, 75, 63, 
  72, 83, 65, 81, 80, 91, 78, 88, 96, 79, 
  84, 85, 70, 81, 79, 87, 83, 71, 88, 95, 
  68, 78, 86, 77, 75, 89, 80, 94, 77, 76, 
  65, 95, 100, 89, 87, 90, 76, 79, 69, 70, 
  99, 78, 67, 106, 84, 97, 91, 65, 72, 96, 
  83, 90, 91, 80, 85, 86, 73, 81, 92, 82, 
  65, 95, 83, 90, 74, 100, 88, 89, 88, 83, 
  79, 70, 59, 81, 75, 53, 75, 72, 68, 86, 
  86, 88, 82, 76, 76, 78, 81, 91, 78, 77, 
  81, 72, 90, 85, 75, 93, 108, 72, 71, 81, 
  72, 76, 73, 76, 101, 82, 82, 79, 94, 77, 
  75, 74, 69, 83, 86, 78, 88, 88, 71, 93, 
  86, 85, 72, 98, 93, 75, 81, 72, 66, 86, 
  70, 83, 82, 65, 72, 90, 88, 76, 80, 68, 
  53, 79, 71, 103, 93, 77, 83, 73, 72, 72, 
  97, 79, 83, 97, 77, 85, 77, 79, 68, 69, 
  92, 81, 92, 89, 59, 74, 82, 89, 73, 81, 
  88, 100, 84, 79, 88, 75, 74, 86, 86, 87, 
  84, 86, 85, 84, 75, 74, 73, 88, 75, 92, 
  72, 88, 81, 88, 82, 81, 101, 79, 79, 78, 
  66, 80, 78, 65, 78, 71, 71, 104, 98, 94, 
  66, 87, 100, 89, 98, 85, 92, 84, 77, 89, 
  83, 94, 114, 85, 80, 86, 74, 96, 77, 66, 
  106, 91, 79, 87, 61, 86, 108, 77, 79, 69, 
  84, 93, 83, 73, 79, 90, 71, 87, 81, 92, 
  85, 97, 65, 88, 77, 106, 88, 102, 111, 96, 
  87, 70, 101, 76, 74, 83, 90, 63, 69, 90, 
  69, 78, 84, 85, 71, 58, 119, 86, 82, 91, 
  89, 84, 83, 87, 96, 82, 104, 75, 69, 80, 
  83, 66, 106, 71, 81, 113, 80, 86, 105, 69, 
  85, 75, 81, 102, 75, 68, 93, 73, 77, 98, 
  85, 85, 100, 96, 66, 77, 96, 94, 81, 86, 
  89, 79, 79, 89, 119, 83, 102, 105, 91, 78, 
  93, 111, 88, 80, 86, 68, 79, 81, 91, 80, 
  76, 89, 83, 86, 96, 77, 86, 70, 81, 76, 
  69, 89, 83, 86, 70, 88, 74, 75, 86, 87, 
  87, 76, 90, 87, 89, 99, 81, 87, 83, 90, 
  63, 91, 90, 85, 84, 83, 88, 81, 80, 82, 
  90, 88, 78, 87, 73, 87, 83, 79, 84, 93, 
  87, 92, 93, 91, 78, 82, 93, 86, 81, 79, 
  96, 77, 91, 80, 82, 72, 81, 88, 90, 90, 
  78, 88, 78, 84, 77, 95, 78, 82, 86, 88, 
  91, 74, 84, 71, 97, 81, 86, 86, 89, 93, 
  84, 81, 72, 89, 94, 85, 84, 88, 90, 91, 
  93, 81, 83, 91, 72, 92, 83, 77, 98, 93, 
  90, 100, 104, 83, 85, 73, 73, 84, 86, 79, 
  85, 76, 60, 83, 86, 86, 86, 81, 85, 85, 
  83, 79, 84, 82, 80, 72, 80, 80, 73, 83, 
  92, 78, 67, 90, 70, 75, 84, 85, 84, 80, 
  86, 87, 90, 88, 73, 78, 82, 87, 87, 83, 
  97, 82, 80, 83, 84, 88, 78, 83, 97, 84, 
  79, 78, 70, 87, 79, 86, 86, 85, 77, 90, 
  88, 87, 83, 84, 69, 87, 72, 85, 99, 81, 
  94, 76, 72, 73, 83, 87, 87, 86, 91, 81, 
  84, 86, 68, 71, 90, 85, 84, 89, 79, 72, 
  92, 86, 82, 81, 93, 91, 83, 83, 86, 78, 
  81, 86, 90, 80, 84, 83, 81, 85, 86, 79, 
  75, 87, 69, 88, 84, 81, 96, 84, 87, 91, 
  98, 77, 90, 77, 74, 87, 82, 76, 90, 74, 
  66, 95, 92, 100, 74, 83, 93, 83, 90, 77, 
  94, 95, 71, 86, 82, 95, 88, 88, 80, 82, 
  69, 97, 83, 77, 93, 87, 77, 84, 80, 87, 
  95, 86, 82, 75, 92, 89, 87, 77, 86, 86, 
  86, 83, 86, 88, 89, 86, 80, 80, 71, 96, 
  88, 95, 109, 99, 88, 84, 87, 84, 68, 78, 
  89, 77, 77, 89, 67, 86, 83, 97, 87, 69, 
  90, 85, 87, 79, 83, 88, 90, 81, 93, 88, 
  83, 73, 91, 89, 82, 64, 97, 74, 81, 109, 
  84, 81, 106, 75, 78, 76, 87, 86, 76, 82, 
  88, 71, 85, 90, 74, 87, 95, 89, 77, 85, 
  84, 93, 96, 94, 85, 80, 84, 80, 98, 83, 
  93, 91, 85, 90, 91, 91, 85, 75, 86, 77, 
  82, 91, 91, 83, 86, 83, 84, 68, 74, 78, 
  72, 91, 82, 85, 89, 85, 81, 82, 90, 89, 
  80, 74, 78, 91, 93, 88, 84, 74, 89, 87, 
  68, 99, 85, 87, 83, 75, 85, 68, 90, 74, 
  81, 76, 96, 93, 84, 84, 101, 83, 73, 81, 
  78, 74, 89, 110, 86, 96, 79, 87, 67, 85, 
  96, 66, 84, 80, 84, 65, 87, 85, 92, 91, 
  81, 93, 80, 86, 84, 55, 93, 81, 78, 74, 
  75, 86, 86, 83, 99, 71, 95, 81, 77, 70, 
  83, 86, 87, 88, 84, 80, 78, 81, 80, 74, 
  89, 88, 110, 82, 83, 83, 93, 69, 75, 74, 
  72, 97, 92, 84, 74, 97, 89, 84, 80, 77, 
  85, 83, 75, 99, 80, 82, 77, 76, 83, 80, 
  96, 79, 92, 83, 93, 67, 71, 73, 79, 96, 
  83, 86, 92, 82, 82, 76, 79, 92, 76, 74, 
  74, 89, 81, 77, 83, 79, 89, 86, 73, 84, 
  86, 83, 80, 60, 85, 69, 85, 76, 89, 71, 
  103, 79, 91, 76, 104, 83, 68, 80, 77, 87, 
  105, 104, 90, 92, 73, 85, 63, 81, 83, 65, 
  86, 77, 81, 61, 76, 76, 95, 92, 84, 90, 
  79, 71, 86, 56, 98, 83, 82, 85, 71, 89, 
  77, 73, 99, 75, 90, 77, 78, 77, 77, 86, 
  94, 88, 84, 83, 80, 73, 76, 76, 85, 87, 
  112, 84, 88, 83, 97, 65, 76, 75, 77, 91, 
  72, 78, 70, 104, 74, 81, 62, 84, 81, 79, 
  67, 107, 81, 84, 82, 79, 84, 98, 91, 73, 
  90, 88, 76, 74, 79, 80, 72, 94, 83, 88, 
  84, 86, 86, 85, 89, 90, 83, 76, 80, 88, 
  86, 69, 80, 82, 89, 96, 86, 93, 86, 87, 
  88, 77, 83, 70, 86, 79, 80, 75, 93, 83, 
  82, 84, 90, 89, 77, 82, 82, 84, 88, 109, 
  92, 89, 77, 89, 70, 84, 99, 69, 90, 82, 
  80, 76, 82, 84, 87, 87, 82, 88, 83, 85, 
  94, 60, 91, 79, 83, 100, 82, 84, 81, 88, 
  96, 79, 97, 79, 74, 74, 77, 88, 86, 87, 
  83, 82, 88, 77, 83, 75, 90, 86, 105, 86, 
  85, 81, 97, 71, 81, 89, 77, 95, 80, 86, 
  77, 101, 71, 90, 80, 79, 81, 79, 77, 92, 
  80, 77, 84, 84, 82, 96, 88, 84, 81, 81, 
  89, 58, 69, 77, 64, 99, 81, 84, 89, 81, 
  67, 84, 87, 93, 78, 72, 89, 85, 95, 92, 
  86, 79, 83, 86, 81, 98, 86, 91, 82, 79, 
  87, 68, 86, 76, 75, 83, 99, 92, 86, 74, 
  105, 80, 79, 77, 77, 79, 88, 119, 80, 99, 
  81, 86, 64, 83, 88, 65, 83, 79, 87, 68, 
  93, 76, 106, 85, 84, 93, 77, 91, 90, 56, 
  102, 88, 86, 72, 74, 82, 85, 68, 111, 75, 
  105, 84, 67, 66, 87, 74, 85, 85, 89, 83, 
  70, 88, 83, 79, 90, 89, 108, 82, 87, 82, 
  88, 69, 85, 78, 77, 88, 99, 75, 77, 85, 
  93, 81, 92, 77, 86, 84, 80, 100, 75, 86, 
  74, 81, 82, 81, 106, 84, 80, 80, 98, 49, 
  64, 77, 75, 105, 79, 92, 95, 79, 71, 77, 
  80, 100, 74, 75, 92, 83, 98, 85, 87, 81, 
  92, 80, 85, 81, 84, 92, 79, 65, 85, 69, 
  77, 75, 86, 79, 107, 79, 96, 64, 122, 73, 
  72, 75, 70, 87, 103, 118, 78, 100, 76, 81, 
  58, 77, 78, 60, 88, 78, 83, 66, 85, 65, 
  110, 84, 87, 93, 82, 65, 90, 55, 105, 96, 
  91, 84, 72, 88, 78, 53, 125, 83, 108, 76, 
  70, 69, 83, 75, 93, 85, 84, 77, 65, 74, 
  79, 82, 86, 86, 115, 81, 106, 85, 101, 64, 
  85, 79, 78, 86, 77, 68, 72, 93, 83, 80, 
  71, 83, 78, 82, 73, 116, 74, 87, 81, 82, 
  83, 96, 83, 73, 82, 88, 81, 63, 74, 88, 
  68, 102, 81, 85, 86, 86, 80, 85, 89, 95, 
  82, 73, 88, 82, 83, 78, 85, 87, 83, 90, 
  91, 91, 86, 93, 88, 76, 87, 71, 74, 78, 
  76, 77, 96, 87, 88, 72, 98, 83, 79, 78, 
  74, 82, 85, 115, 85, 90, 80, 85, 68, 83, 
  87, 66, 95, 84, 84, 78, 89, 73, 99, 81, 
  89, 88, 83, 78, 97, 59, 98, 91, 86, 100, 
  82, 84, 80, 75, 107, 82, 101, 77, 65, 70, 
  76, 76, 84, 82, 83, 81, 77, 73, 83, 81, 
  91, 86, 108, 87, 89, 79, 91, 67, 89, 89, 
  86, 94, 82, 77, 79, 91, 74, 85, 90, 79, 
  81, 82, 83, 94, 87, 80, 80, 82, 84, 95, 
  89, 90, 79, 80, 94, 76, 74, 81, 63, 95, 
  86, 88, 83, 82, 68, 84, 89, 85, 78, 69, 
  78, 76, 80, 96, 80, 78, 78, 83, 93, 95, 
  93, 84, 86, 85, 85, 69, 84, 80, 67, 85, 
  84, 100, 79, 75, 94, 81, 81, 73, 80, 81, 
  79, 109, 86, 90, 85, 87, 68, 83, 86, 80, 
  84, 81, 86, 78, 87, 81, 95, 86, 100, 85, 
  81, 90, 87, 62, 95, 87, 83, 74, 84, 81, 
  88, 82, 98, 81, 95, 87, 68, 69, 84, 73, 
  85, 84, 85, 71, 79, 93, 86, 83, 89, 78, 
  102, 80, 81, 78, 81, 80, 91, 85, 70, 86, 
  97, 77, 82, 78, 85, 86, 88, 74, 82, 92, 
  83, 93, 83, 82, 68, 83, 86, 84, 99, 94, 
  71, 79, 105, 70, 66, 77, 75, 97, 79, 93, 
  92, 84, 70, 81, 81, 91, 80, 76, 82, 74, 
  75, 90, 80, 83, 83, 76, 91, 85, 84, 86, 
  82, 77, 83, 71, 73, 81, 73, 79, 91, 83, 
  84, 72, 109, 76, 72, 72, 74, 82, 87, 103, 
  87, 89, 82, 85, 64, 75, 79, 73, 96, 80, 
  83, 73, 87, 75, 97, 84, 102, 88, 80, 74, 
  78, 66, 96, 89, 85, 78, 84, 82, 83, 70, 
  104, 85, 100, 75, 69, 71, 80, 68, 92, 81, 
  73, 68, 64, 83, 82, 83, 83, 77, 111, 81, 
  94, 82, 89, 77, 95, 82, 66, 89, 84, 69, 
  77, 81, 80, 83, 85, 80, 78, 87, 76, 105, 
  84, 74, 82, 84, 86, 96, 85, 88, 80, 84, 
  88, 83, 76, 85, 67, 98, 85, 91, 87, 88, 
  82, 87, 89, 87, 90, 70, 79, 76, 77, 86, 
  82, 86, 77, 84, 96, 93, 91, 84, 88, 82, 
  86, 72, 72, 80, 72, 84, 86, 82, 82, 74, 
  91, 81, 80, 72, 76, 85, 80, 109, 89, 82, 
  85, 86, 72, 88, 83, 82, 98, 83, 84, 91, 
  91, 80, 92, 84, 101, 84, 83, 92, 87, 65, 
  92, 90, 88, 90, 88, 81, 85, 86, 95, 86, 
  96, 78, 67, 71, 81, 73, 87, 82, 73, 75, 
  82, 70, 87, 84, 91, 78, 103, 85, 83, 76, 
  81, 76, 94, 90, 79, 93, 83, 78, 82, 81, 
  78, 88, 83, 75, 78, 92, 82, 88, 83, 87, 
  116, 94, 88, 81, 94, 83, 87, 87, 65, 87, 
  81, 104, 76, 73, 78, 51, 93, 84, 80, 97, 
  73, 77, 90, 82, 91, 81, 96, 84, 106, 103, 
  79, 75, 71, 91, 97, 92, 77, 81, 82, 57, 
  85, 99, 63, 98, 77, 68, 74, 84, 91, 93, 
  81, 77, 80, 87, 74, 82, 101, 80, 82, 79, 
  78, 73, 88, 65, 75, 81, 88, 73, 74, 65, 
  86, 83, 75, 76, 89, 84, 89, 70, 93, 82, 
  80, 80, 74, 95, 88, 81, 95, 84, 78, 75, 
  92, 87, 84, 81, 79, 79, 79, 79, 81, 77, 
  91, 76, 82, 104, 93, 97, 85, 79, 81, 80, 
  74, 77, 91, 111, 104, 75, 86, 122, 88, 84, 
  92, 72, 93, 86, 67, 72, 73, 94, 92, 88, 
  82, 84, 99, 85, 81, 94, 67, 86, 75, 93, 
  76, 74, 74, 45, 78, 81, 96, 79, 80, 81, 
  82, 81, 85, 81, 95, 79, 106, 99, 77, 80, 
  75, 88, 90, 84, 89, 78, 88, 46, 94, 89, 
  64, 102, 73, 77, 71, 90, 93, 88, 80, 75, 
  87, 99, 84, 83, 119, 74, 77, 81, 75, 72, 
  87, 68, 65, 75, 79, 68, 104, 55, 88, 89, 
  72, 89, 83, 80, 102, 77, 96, 85, 80, 78, 
  62, 91, 91, 80, 91, 95, 73, 78, 95, 79, 
  92, 81, 74, 77, 86, 83, 74, 73, 84, 76, 
  95, 106, 101, 89, 72, 79, 73, 85, 76, 87, 
  92, 114, 94, 78, 88, 140, 82, 77, 95, 72, 
  93, 92, 63, 67, 91, 93, 71, 92, 87, 75, 
  97, 92, 83, 89, 69, 81, 95, 81, 81, 72, 
  76, 59, 95, 80, 93, 80, 90, 83, 88, 83, 
  90, 84, 91, 76, 96, 103, 82, 96, 76, 88, 
  98, 92, 99, 81, 83, 58, 80, 97, 68, 92, 
  76, 87, 73, 87, 93, 83, 82, 77, 83, 90, 
  73, 88, 104, 79, 84, 78, 85, 76, 84, 70, 
  73, 85, 83, 71, 107, 66, 89, 83, 75, 75, 
  83, 82, 98, 70, 94, 79, 78, 83, 74, 86, 
  83, 84, 86, 94, 80, 73, 88, 89, 90, 79, 
  80, 84, 85, 73, 79, 85, 93, 76, 87, 102, 
  99, 92, 87, 80, 68, 83, 74, 92, 92, 103, 
  86, 75, 88, 114, 73, 81, 99, 76, 94, 78, 
  70, 77, 71, 85, 88, 79, 89, 90, 106, 84, 
  75, 89, 86, 91, 80, 85, 84, 72, 77, 77, 
  85, 88, 94, 85, 72, 67, 84, 95, 82, 85, 
  84, 76, 97, 74, 84, 77, 78, 92, 77, 81, 
  75, 76, 81, 66, 81, 90, 81, 92, 73, 75, 
  93, 78, 81, 89, 75, 86, 79, 71, 83, 70, 
  93, 91, 79, 87, 69, 76, 86, 81, 79, 94, 
  85, 70, 73, 71, 96, 84, 89, 75, 75, 87, 
  81, 71, 87, 83, 75, 79, 81, 84, 90, 70, 
  81, 74, 99, 80, 95, 97, 73, 88, 89, 87, 
  84, 84, 76, 78, 80, 82, 84, 76, 95, 93, 
  102, 69, 82, 87, 90, 87, 88, 102, 111, 76, 
  94, 95, 85, 76, 78, 79, 78, 93, 73, 76, 
  66, 94, 75, 71, 90, 79, 112, 81, 73, 88, 
  92, 94, 81, 75, 79, 75, 79, 89, 86, 87, 
  102, 57, 73, 65, 83, 98, 70, 87, 83, 79, 
  104, 80, 83, 81, 77, 84, 66, 74, 74, 70, 
  76, 61, 100, 92, 87, 110, 76, 81, 95, 76, 
  80, 77, 64, 83, 84, 79, 88, 70, 81, 103, 
  75, 87, 69, 78, 68, 69, 76, 102, 77, 66, 
  84, 75, 93, 88, 93, 76, 70, 77, 83, 81, 
  86, 86, 82, 80, 81, 82, 89, 69, 72, 89, 
  96, 80, 83, 108, 76, 93, 87, 84, 79, 84, 
  70, 82, 71, 85, 101, 65, 103, 90, 105, 68, 
  88, 95, 90, 83, 83, 96, 99, 84, 104, 86, 
  74, 81, 81, 79, 71, 97, 74, 78, 78, 83, 
  75, 78, 85, 76, 104, 85, 81, 90, 87, 90, 
  80, 76, 84, 71, 76, 79, 88, 84, 85, 79, 
  85, 72, 86, 94, 77, 90, 81, 85, 86, 80, 
  84, 87, 79, 84, 73, 81, 80, 74, 84, 64, 
  89, 88, 82, 94, 80, 92, 92, 76, 87, 85, 
  73, 84, 80, 91, 86, 79, 97, 90, 76, 86, 
  76, 79, 89, 86, 77, 95, 81, 72, 97, 72, 
  95, 83, 88, 77, 72, 83, 89, 72, 87, 84, 
  75, 85, 79, 81, 87, 76, 81, 83, 101, 78, 
  93, 95, 81, 82, 89, 88, 78, 80, 79, 83, 
  79, 83, 87, 79, 101, 89, 98, 76, 80, 81, 
  86, 90, 86, 93, 89, 78, 93, 93, 69, 76, 
  84, 84, 79, 86, 76, 78, 85, 86, 87, 78, 
  88, 98, 94, 82, 75, 89, 82, 89, 80, 70, 
  85, 67, 64, 84, 93, 83, 82, 82, 77, 67, 
  86, 99, 85, 86, 86, 84, 77, 76, 88, 84, 
  79, 92, 86, 76, 83, 79, 74, 84, 75, 87, 
  97, 90, 90, 88, 97, 74, 74, 87, 71, 78, 
  81, 84, 76, 79, 70, 81, 89, 86, 85, 83, 
  91, 96, 86, 88, 83, 84, 91, 89, 94, 84, 
  97, 73, 66, 80, 84, 82, 78, 90, 80, 82, 
  92, 78, 83, 81, 78, 78, 82, 80, 83, 97, 
  73, 89, 95, 89, 81, 81, 85, 91, 82, 85, 
  81, 83, 96, 85, 100, 80, 91, 90, 90, 91, 
  77, 89, 99, 78, 90, 82, 84, 80, 60, 86, 
  76, 88, 84, 85, 81, 91, 90, 71, 91, 91, 
  91, 80, 71, 87, 89, 91, 92, 74, 86, 72, 
  73, 91, 93, 81, 82, 66, 80, 71, 84, 98, 
  80, 86, 78, 83, 75, 70, 99, 94, 86, 84, 
  79, 74, 74, 79, 74, 80, 79, 91, 106, 91, 
  90, 93, 97, 73, 74, 83, 64, 79, 78, 78, 
  77, 78, 58, 96, 90, 78, 80, 82, 81, 90, 
  86, 90, 81, 89, 87, 95, 84, 81, 97, 73, 
  62, 87, 74, 93, 77, 96, 84, 84, 98, 81, 
  86, 84, 74, 81, 83, 80, 73, 103, 74, 86, 
  97, 88, 84, 90, 86, 95, 76, 85, 78, 78, 
  110, 85, 103, 82, 100, 91, 83, 83, 80, 84, 
  99, 88, 94, 67, 75, 83, 67, 84, 77, 85, 
  80, 91, 88, 76, 86, 78, 87, 79, 96, 84, 
  76, 90, 82, 87, 79, 85, 87, 65, 67, 80, 
  91, 77, 78, 87, 91, 71, 79, 95, 81, 87, 
  76, 79, 79, 75, 84, 91, 87, 88, 81, 79, 
  71, 78, 79, 83, 82, 88, 96, 88, 93, 89, 
  97, 72, 78, 90, 72, 74, 82, 78, 77, 82, 
  76, 79, 89, 88, 85, 84, 94, 96, 81, 89, 
  83, 84, 90, 85, 93, 83, 92, 73, 70, 91, 
  82, 82, 78, 88, 76, 87, 90, 73, 91, 83, 
  79, 85, 81, 81, 81, 95, 80, 82, 96, 89, 
  88, 79, 83, 88, 82, 85, 80, 85, 97, 82, 
  97, 79, 94, 91, 86, 84, 85, 92, 94, 79, 
  94, 81, 75, 84, 70, 89, 78, 87, 85, 81, 
  77, 84, 87, 87, 79, 93, 81, 86, 92, 89, 
  92, 81, 83, 85, 64, 95, 86, 84, 89, 87, 
  69, 88, 83, 91, 85, 76, 85, 91, 83, 78, 
  81, 86, 86, 95, 83, 90, 90, 81, 85, 88, 
  74, 86, 68, 85, 83, 79, 86, 86, 74, 93, 
  86, 80, 89, 75, 94, 85, 83, 100, 89, 81, 
  85, 82, 76, 100, 84, 89, 89, 84, 86, 88, 
  82, 81, 91, 78, 80, 94, 78, 101, 81, 84, 
  74, 85, 90, 88, 84, 92, 80, 79, 94, 80, 
  92, 94, 93, 75, 93, 71, 77, 84, 76, 98, 
  98, 88, 88, 87, 77, 72, 64, 88, 81, 83, 
  63, 79, 82, 73, 81, 80, 84, 90, 75, 65, 
  85, 85, 77, 82, 94, 94, 88, 93, 78, 90, 
  91, 84, 83, 82, 90, 79, 83, 89, 83, 80, 
  82, 92, 67, 88, 88, 83, 70, 85, 74, 81, 
  79, 90, 81, 73, 81, 78, 83, 79, 78, 77, 
  84, 91, 81, 85, 82, 79, 86, 89, 68, 88, 
  73, 96, 96, 73, 82, 85, 64, 92, 81, 88, 
  90, 66, 91, 88, 77, 97, 93, 74, 87, 69, 
  78, 95, 93, 80, 92, 86, 83, 108, 85, 88, 
  90, 79, 75, 87, 70, 85, 79, 84, 81, 82, 
  88, 86, 89, 98, 79, 85, 99, 85, 84, 88, 
  91, 67, 92, 80, 73, 82, 79, 95, 95, 89, 
  82, 86, 62, 78, 73, 87, 79, 92, 68, 82, 
  75, 74, 81, 87, 89, 92, 71, 66, 85, 75, 
  74, 81, 96, 102, 79, 81, 78, 85, 88, 87, 
  81, 83, 76, 86, 92, 92, 89, 82, 84, 81, 
  63, 91, 86, 80, 85, 84, 67, 85, 91, 91, 
  84, 70, 85, 94, 75, 84, 84, 80, 86, 88, 
  83, 82, 89, 86, 88, 82, 78, 82, 69, 85, 
  88, 79, 87, 99, 69, 92, 84, 81, 89, 76, 
  93, 84, 78, 99, 87, 83, 87, 82, 78, 94, 
  81, 84, 90, 93, 80, 88, 85, 84, 96, 78, 
  80, 93, 81, 86, 81, 80, 79, 80, 81, 83, 
  85, 96, 77, 81, 94, 80, 90, 94, 92, 74, 
  95, 76, 78, 81, 84, 95, 100, 82, 87, 86, 
  73, 76, 61, 89, 80, 83, 66, 79, 79, 84, 
  83, 85, 89, 85, 72, 72, 88, 86, 80, 82, 
  92, 96, 85, 87, 77, 85, 102, 87, 86, 90, 
  91, 79, 74, 85, 76, 84, 82, 100, 67, 91, 
  84, 80, 64, 90, 74, 78, 78, 93, 83, 77, 
  86, 79, 106, 85, 92, 85, 80, 94, 88, 97, 
  84, 70, 82, 95, 77, 94, 100, 93, 89, 85, 
  80, 79, 80, 82, 81, 79, 90, 67, 73, 88, 
  83, 93, 89, 76, 89, 75, 69, 91, 84, 83, 
  80, 80, 77, 90, 81, 76, 92, 97, 78, 84, 
  83, 107, 80, 79, 84, 74, 89, 90, 79, 93, 
  84, 85, 89, 86, 74, 90, 92, 76, 70, 85, 
  85, 77, 75, 90, 87, 88, 81, 86, 87, 75, 
  78, 87, 80, 82, 76, 91, 70, 75, 86, 84, 
  85, 98, 80, 83, 79, 65, 68, 87, 91, 88, 
  71, 78, 73, 87, 84, 76, 80, 76, 104, 73, 
  61, 83, 73, 85, 75, 95, 69, 101, 82, 79, 
  32, 85, 97, 70, 66, 89, 70, 72, 76, 56, 
  125, 90, 105, 80, 78, 92, 88, 88, 65, 62, 
  87, 90, 92, 88, 100, 102, 112, 84, 67, 93, 
  72, 87, 83, 75, 87, 60, 60, 85, 80, 89, 
  99, 76, 86, 58, 66, 90, 77, 81, 81, 91, 
  69, 75, 75, 73, 101, 107, 72, 79, 80, 93, 
  84, 74, 97, 68, 78, 84, 78, 101, 86, 76, 
  93, 96, 64, 82, 86, 69, 64, 102, 75, 73, 
  71, 76, 79, 90, 63, 85, 97, 82, 91, 82, 
  69, 89, 87, 100, 64, 81, 79, 107, 82, 111, 
  77, 100, 80, 55, 61, 83, 80, 91, 64, 65, 
  75, 80, 84, 83, 81, 75, 90, 79, 70, 83, 
  75, 83, 87, 76, 73, 90, 84, 80, 55, 87, 
  100, 72, 83, 89, 78, 74, 84, 73, 105, 91, 
  101, 84, 78, 89, 88, 78, 80, 76, 96, 90, 
  90, 89, 79, 97, 96, 90, 81, 108, 78, 80, 
  84, 81, 88, 71, 67, 90, 77, 88, 91, 78, 
  86, 70, 67, 88, 89, 82, 80, 91, 71, 77, 
  92, 74, 99, 96, 74, 77, 83, 87, 79, 78, 
  90, 74, 78, 80, 79, 94, 79, 83, 92, 88, 
  69, 91, 84, 77, 82, 96, 82, 76, 78, 86, 
  86, 86, 77, 84, 94, 86, 75, 90, 75, 84, 
  89, 91, 72, 89, 85, 92, 88, 90, 77, 92, 
  82, 62, 69, 82, 90, 88, 72, 73, 89, 91, 
  86, 90, 82, 73, 79, 76, 79, 81, 80, 83, 
  88, 93, 72, 84, 76, 87, 90, 89, 86, 90, 
  95, 86, 82, 81, 88, 89, 74, 87, 88, 93, 
  81, 87, 78, 111, 83, 80, 85, 85, 83, 81, 
  92, 84, 95, 86, 84, 84, 83, 80, 85, 70, 
  80, 86, 73, 81, 91, 89, 82, 78, 81, 80, 
  88, 86, 74, 82, 62, 89, 78, 81, 86, 84, 
  103, 102, 88, 89, 89, 98, 73, 71, 90, 75, 
  82, 89, 81, 92, 80, 88, 81, 84, 71, 79, 
  93, 87, 65, 83, 92, 81, 79, 82, 86, 85, 
  79, 81, 81, 86, 83, 92, 87, 80, 93, 99, 
  74, 87, 74, 80, 82, 89, 85, 85, 78, 74, 
  67, 83, 91, 83, 78, 83, 83, 87, 77, 77, 
  84, 77, 87, 70, 67, 78, 78, 82, 77, 89, 
  74, 90, 69, 100, 78, 87, 102, 82, 73, 74, 
  71, 75, 91, 72, 106, 89, 103, 95, 75, 89, 
  85, 106, 71, 87, 92, 66, 101, 80, 105, 98, 
  105, 100, 72, 98, 93, 67, 82, 64, 73, 83, 
  61, 85, 92, 80, 68, 75, 72, 81, 98, 90, 
  73, 76, 60, 96, 68, 66, 86, 88, 105, 117, 
  81, 75, 91, 98, 79, 62, 96, 74, 80, 91, 
  80, 94, 83, 82, 78, 88, 78, 73, 82, 89, 
  59, 96, 91, 76, 76, 66, 81, 78, 75, 78, 
  120, 80, 88, 94, 81, 68, 122, 113, 73, 80, 
  71, 84, 85, 104, 83, 104, 77, 68, 55, 75, 
  80, 75, 80, 74, 88, 73, 77, 88, 83, 89, 
  79, 76, 75, 78, 83, 82, 88, 76, 75, 83, 
  75, 88, 92, 85, 94, 87, 67, 81, 79, 81, 
  88, 79, 74, 87, 88, 104, 79, 92, 82, 88, 
  76, 84, 90, 77, 92, 83, 81, 88, 92, 88, 
  84, 98, 87, 72, 87, 71, 77, 93, 73, 86, 
  92, 87, 76, 82, 77, 87, 95, 89, 76, 84, 
  69, 97, 75, 72, 85, 83, 104, 100, 78, 87, 
  87, 89, 73, 73, 95, 77, 80, 89, 84, 93, 
  89, 94, 78, 83, 74, 81, 87, 91, 79, 86, 
  92, 82, 82, 84, 84, 83, 78, 77, 92, 88, 
  80, 91, 86, 78, 107, 93, 77, 83, 78, 84, 
  92, 87, 82, 85, 74, 74, 72, 78, 96, 76, 
  78, 78, 94, 63, 81, 85, 83, 73, 71, 77, 
  88, 83, 91, 81, 83, 72, 85, 68, 73, 81, 
  85, 101, 81, 82, 85, 71, 95, 89, 87, 83, 
  93, 89, 78, 86, 80, 83, 72, 81, 80, 79, 
  90, 73, 85, 78, 77, 89, 92, 73, 77, 67, 
  79, 82, 69, 88, 84, 80, 85, 79, 73, 84, 
  74, 79, 99, 75, 88, 82, 92, 74, 69, 88, 
  88, 76, 73, 100, 85, 78, 84, 110, 95, 71, 
  78, 76, 81, 88, 85, 100, 103, 81, 89, 84, 
  86, 89, 74, 91, 85, 80, 84, 83, 78, 83, 
  80, 75, 87, 75, 86, 89, 84, 81, 76, 102, 
  81, 107, 83, 83, 94, 79, 77, 91, 81, 69, 
  70, 70, 88, 95, 88, 98, 98, 98, 90, 74, 
  97, 72, 68, 85, 88, 74, 72, 77, 83, 89, 
  98, 78, 81, 82, 83, 66, 76, 86, 93, 105, 
  79, 83, 83, 74, 89, 96, 84, 84, 86, 81, 
  80, 84, 73, 92, 76, 79, 76, 72, 77, 67, 
  79, 76, 80, 88, 95, 73, 70, 67, 83, 74, 
  59, 80, 79, 76, 94, 74, 79, 92, 67, 81, 
  111, 87, 90, 85, 89, 79, 61, 98, 95, 84, 
  72, 105, 94, 80, 91, 116, 94, 72, 86, 77, 
  78, 84, 80, 87, 120, 71, 78, 94, 85, 93, 
  72, 100, 92, 91, 93, 88, 78, 78, 86, 74, 
  93, 87, 89, 92, 83, 85, 77, 99, 87, 102, 
  80, 88, 97, 85, 83, 94, 65, 75, 69, 67, 
  83, 91, 77, 96, 97, 96, 98, 71, 91, 83, 
  64, 84, 83, 90, 73, 77, 93, 84, 81, 80, 
  84, 92, 86, 67, 73, 78, 81, 91, 86, 90, 
  76, 73, 76, 86, 93, 85, 95, 69, 72, 82, 
  85, 84, 79, 88, 72, 90, 81, 79, 84, 85, 
  86, 86, 86, 65, 79, 85, 76, 82, 75, 84, 
  84, 86, 88, 79, 79, 77, 77, 76, 91, 74, 
  90, 70, 87, 75, 67, 85, 93, 77, 83, 89, 
  85, 76, 85, 95, 94, 83, 85, 78, 79, 88, 
  90, 88, 93, 73, 86, 80, 88, 89, 78, 90, 
  84, 81, 84, 83, 76, 82, 86, 76, 81, 75, 
  86, 88, 87, 87, 87, 93, 82, 108, 84, 81, 
  92, 99, 73, 83, 76, 73, 75, 77, 91, 93, 
  91, 90, 90, 93, 88, 86, 97, 66, 70, 84, 
  89, 84, 79, 90, 85, 97, 105, 78, 69, 81, 
  83, 73, 90, 85, 92, 110, 76, 76, 87, 77, 
  90, 86, 81, 84, 82, 84, 68, 70, 76, 102, 
  89, 78, 78, 71, 75, 65, 88, 93, 85, 82, 
  93, 71, 86, 79, 81, 85, 70, 88, 75, 79, 
  85, 74, 82, 92, 75, 95, 98, 71, 71, 86, 
  99, 75, 60, 96, 92, 74, 87, 120, 76, 76, 
  87, 118, 99, 80, 76, 91, 77, 82, 77, 101, 
  102, 69, 97, 82, 83, 73, 76, 74, 77, 100, 
  101, 103, 85, 72, 88, 77, 93, 90, 93, 94, 
  83, 84, 75, 100, 76, 96, 75, 79, 102, 81, 
  72, 94, 82, 85, 70, 70, 82, 98, 83, 103, 
  111, 71, 110, 74, 101, 71, 77, 89, 95, 85, 
  80, 87, 81, 117, 118, 75, 74, 76, 82, 75, 
  96, 81, 105, 125, 78, 75, 85, 81, 94, 93, 
  76, 86, 72, 93, 80, 72, 63, 107, 85, 81, 
  76, 77, 82, 57, 87, 101, 77, 85, 101, 73, 
  76, 74, 92, 81, 53, 90, 69, 71, 94, 76, 
  85, 96, 67, 95, 111, 75, 64, 95, 88, 85, 
  63, 109, 91, 82, 70, 137, 77, 73, 96, 125, 
  109, 85, 77, 96, 73, 78, 71, 81, 126, 72, 
  74, 97, 83, 76, 70, 73, 84, 113, 97, 112, 
  88, 58, 88, 76, 91, 89, 107, 95, 84, 87, 
  72, 103, 80, 88, 76, 78, 112, 79, 77, 103, 
  73, 95, 71, 72, 77, 97, 72, 112, 106, 68, 
  123, 70, 92, 73, 86, 83, 81, 99, 79, 85, 
  94, 90, 89, 76, 70, 79, 79, 74, 84, 84, 
  81, 103, 86, 82, 82, 75, 78, 79, 84, 82, 
  84, 86, 64, 73, 84, 79, 83, 93, 76, 78, 
  84, 73, 86, 92, 75, 81, 89, 71, 95, 84, 
  80, 86, 75, 91, 76, 82, 90, 73, 81, 80, 
  80, 81, 89, 71, 76, 64, 93, 79, 71, 94, 
  91, 80, 72, 104, 85, 76, 88, 105, 100, 93, 
  72, 87, 77, 82, 81, 93, 87, 81, 85, 82, 
  81, 79, 82, 78, 79, 82, 87, 92, 82, 77, 
  87, 77, 91, 72, 88, 92, 81, 86, 81, 89, 
  78, 100, 84, 79, 96, 98, 70, 95, 86, 84, 
  74, 74, 92, 96, 88, 94, 99, 78, 99, 90, 
  91, 76, 68, 86, 80, 71, 83, 101, 94, 85, 
  86, 84, 69, 88, 84, 79, 85, 82, 81, 89, 
  84, 88, 67, 70, 78, 80, 96, 82, 86, 73, 
  64, 75, 89, 84, 90, 85, 75, 76, 81, 71, 
  91, 77, 81, 82, 78, 75, 88, 89, 73, 93, 
  78, 90, 80, 93, 88, 73, 78, 90, 86, 84, 
  88, 73, 83, 86, 95, 76, 71, 84, 93, 81, 
  89, 84, 85, 74, 80, 94, 85, 72, 94, 72, 
  80, 87, 87, 86, 95, 76, 88, 70, 82, 87, 
  80, 80, 72, 83, 98, 79, 82, 86, 94, 79, 
  88, 90, 90, 95, 91, 77, 69, 88, 67, 95, 
  75, 88, 90, 80, 84, 78, 73, 75, 72, 82, 
  80, 97, 90, 86, 98, 81, 97, 81, 93, 76, 
  77, 83, 82, 69, 85, 95, 90, 88, 90, 82, 
  70, 82, 87, 79, 93, 83, 88, 94, 85, 81, 
  71, 73, 81, 83, 95, 80, 80, 93, 70, 71, 
  91, 80, 84, 80, 70, 72, 89, 62, 102, 72, 
  83, 83, 90, 85, 86, 74, 78, 95, 66, 89, 
  76, 86, 91, 77, 82, 91, 80, 87, 98, 84, 
  83, 90, 79, 79, 80, 97, 85, 95, 69, 84, 
  89, 71, 77, 95, 89, 74, 94, 69, 77, 84, 
  82, 86, 103, 88, 75, 80, 82, 94, 85, 79, 
  79, 89, 100, 83, 85, 87, 83, 76, 91, 77, 
  93, 96, 90, 80, 73, 88, 73, 98, 78, 99, 
  94, 78, 81, 95, 71, 77, 72, 88, 88, 96, 
  82, 89, 99, 87, 102, 85, 84, 84, 94, 84, 
  87, 76, 83, 88, 103, 80, 85, 79, 75, 75, 
  76, 79, 81, 77, 79, 90, 81, 94, 76, 74, 
  79, 82, 92, 80, 88, 95, 72, 73, 88, 73, 
  74, 85, 81, 78, 91, 76, 86, 78, 80, 82, 
  79, 74, 95, 78, 77, 94, 83, 96, 81, 94, 
  89, 81, 80, 87, 89, 82, 87, 71, 79, 75, 
  88, 81, 86, 78, 86, 84, 66, 82, 84, 73, 
  79, 88, 86, 88, 73, 77, 80, 90, 87, 97, 
  87, 93, 73, 78, 87, 87, 82, 79, 74, 79, 
  88, 80, 80, 86, 87, 81, 89, 70, 88, 92, 
  94, 85, 80, 87, 77, 97, 83, 81, 89, 81, 
  82, 88, 82, 75, 75, 84, 95, 96, 89, 82, 
  98, 87, 89, 85, 72, 84, 82, 82, 83, 88, 
  82, 71, 89, 65, 76, 69, 90, 83, 85, 68, 
  81, 79, 81, 81, 72, 92, 90, 94, 78, 79, 
  93, 65, 81, 80, 81, 89, 83, 88, 92, 77, 
  90, 101, 86, 75, 87, 92, 83, 69, 72, 80, 
  93, 89, 83, 70, 85, 98, 94, 112, 84, 73, 
  86, 80, 68, 89, 81, 96, 82, 67, 76, 100, 
  69, 76, 97, 81, 72, 89, 87, 73, 98, 80, 
  78, 103, 84, 88, 87, 91, 78, 82, 76, 78, 
  117, 79, 98, 84, 57, 86, 83, 98, 82, 83, 
  80, 74, 87, 86, 76, 82, 73, 79, 77, 76, 
  88, 84, 81, 96, 92, 83, 94, 77, 83, 73, 
  78, 87, 78, 103, 85, 90, 77, 79, 92, 105, 
  95, 94, 74, 87, 83, 89, 82, 89, 84, 75, 
  83, 79, 73, 81, 90, 79, 82, 81, 84, 73, 
  78, 87, 57, 90, 68, 83, 95, 80, 92, 80, 
  80, 82, 71, 100, 88, 85, 76, 64, 92, 97, 
  93, 80, 78, 86, 97, 81, 79, 79, 96, 80, 
  87, 72, 84, 95, 90, 96, 84, 78, 85, 77, 
  75, 89, 90, 88, 82, 60, 67, 81, 73, 90, 
  87, 83, 79, 88, 85, 66, 90, 77, 82, 98, 
  74, 87, 88, 88, 78, 83, 78, 75, 102, 78, 
  88, 80, 65, 83, 85, 95, 72, 73, 85, 85, 
  77, 73, 65, 78, 81, 82, 73, 88, 89, 86, 
  94, 85, 86, 79, 87, 65, 80, 89, 76, 93, 
  70, 87, 79, 83, 89, 86, 84, 88, 76, 93, 
  83, 79, 84, 82, 83, 89, 83, 81, 84, 93, 
  79, 93, 78, 78, 65, 87, 90, 68, 77, 93, 
  72, 83, 69, 83, 98, 86, 90, 87, 71, 74, 
  71, 97, 86, 87, 74, 64, 94, 80, 82, 82, 
  79, 76, 94, 84, 95, 76, 98, 92, 80, 80, 
  84, 88, 88, 80, 83, 84, 82, 86, 85, 88, 
  93, 88, 85, 66, 78, 80, 69, 110, 82, 85, 
  85, 88, 91, 71, 78, 85, 92, 90, 77, 76, 
  88, 85, 90, 86, 92, 73, 106, 87, 88, 79, 
  80, 94, 100, 91, 87, 81, 78, 91, 80, 73, 
  73, 92, 95, 85, 69, 104, 94, 86, 85, 78, 
  89, 85, 80, 64, 87, 100, 82, 102, 82, 84, 
  80, 80, 86, 91, 82, 84, 66, 84, 77, 83, 
  88, 85, 92, 84, 84, 84, 90, 65, 76, 71, 
  90, 81, 85, 80, 77, 78, 86, 81, 70, 85, 
  74, 94, 79, 81, 93, 70, 107, 84, 83, 93, 
  88, 87, 80, 74, 81, 102, 96, 75, 77, 87, 
  90, 69, 79, 87, 88, 84, 85, 74, 82, 98, 
  88, 109, 89, 80, 77, 88, 62, 78, 80, 89, 
  81, 67, 66, 95, 84, 69, 99, 75, 76, 74, 
  95, 81, 96, 77, 76, 101, 79, 90, 86, 83, 
  71, 93, 81, 87, 118, 87, 93, 82, 57, 87, 
  70, 99, 80, 80, 90, 86, 75, 87, 71, 78, 
  73, 82, 84, 81, 86, 78, 82, 97, 98, 90, 
  95, 73, 72, 69, 73, 78, 76, 85, 84, 91, 
  76, 70, 92, 96, 98, 92, 72, 86, 90, 85, 
  86, 90, 89, 81, 80, 80, 72, 83, 85, 78, 
  81, 87, 80, 76, 85, 88, 59, 94, 58, 78, 
  99, 83, 91, 83, 106, 77, 70, 100, 87, 83, 
  73, 61, 82, 91, 94, 78, 82, 91, 103, 82, 
  79, 87, 87, 77, 85, 72, 85, 100, 85, 88, 
  93, 81, 83, 75, 80, 86, 86, 85, 80, 54, 
  56, 73, 82, 90, 83, 85, 74, 77, 91, 74, 
  85, 76, 83, 116, 66, 86, 81, 84, 78, 96, 
  87, 81, 112, 83, 78, 82, 67, 78, 83, 96, 
  76, 74, 88, 90, 65, 74, 64, 72, 82, 84, 
  74, 96, 90, 83, 92, 79, 94, 86, 85, 60, 
  74, 86, 80, 89, 78, 81, 75, 76, 88, 80, 
  83, 81, 71, 85, 78, 72, 77, 70, 80, 95, 
  91, 81, 81, 94, 77, 97, 78, 77, 64, 86, 
  86, 80, 77, 93, 75, 80, 65, 75, 103, 82, 
  82, 89, 94, 86, 71, 105, 85, 82, 79, 61, 
  87, 75, 78, 78, 104, 80, 107, 85, 87, 75, 
  87, 91, 75, 78, 84, 85, 80, 75, 92, 83, 
  88, 75, 99, 85, 88, 85, 86, 55, 77, 75, 
  71, 116, 71, 95, 69, 90, 99, 68, 79, 99, 
  98, 107, 71, 75, 79, 82, 94, 96, 99, 84, 
  113, 96, 79, 90, 85, 89, 110, 85, 83, 83, 
  78, 90, 75, 71, 75, 79, 100, 86, 60, 109, 
  95, 91, 84, 72, 95, 93, 78, 61, 78, 110, 
  92, 106, 86, 86, 85, 71, 82, 102, 81, 77, 
  62, 72, 77, 83, 84, 91, 89, 83, 85, 83, 
  86, 70, 84, 79, 93, 74, 87, 89, 78, 76, 
  87, 92, 93, 82, 86, 91, 84, 81, 87, 71, 
  92, 81, 87, 84, 84, 91, 79, 78, 88, 83, 
  91, 78, 86, 89, 87, 76, 80, 88, 83, 80, 
  79, 75, 82, 90, 89, 109, 86, 91, 84, 92, 
  69, 78, 76, 92, 87, 72, 75, 91, 85, 80, 
  86, 85, 82, 84, 102, 81, 91, 82, 79, 104, 
  84, 88, 89, 82, 82, 97, 87, 85, 119, 83, 
  90, 88, 65, 86, 87, 94, 78, 90, 80, 81, 
  76, 77, 70, 87, 80, 79, 73, 86, 89, 85, 
  69, 91, 88, 88, 93, 77, 84, 81, 70, 75, 
  79, 91, 85, 88, 82, 74, 86, 87, 95, 88, 
  78, 90, 84, 89, 80, 87, 87, 79, 82, 85, 
  77, 89, 85, 77, 82, 95, 81, 77, 81, 92, 
  72, 90, 74, 83, 93, 79, 96, 82, 90, 81, 
  77, 99, 83, 77, 73, 68, 92, 90, 89, 77, 
  84, 85, 98, 82, 71, 87, 82, 75, 81, 77, 
  83, 92, 86, 94, 92, 77, 82, 81, 89, 80, 
  80, 86, 85, 68, 68, 79, 82, 88, 81, 90, 
  79, 83, 96, 80, 82, 80, 81, 108, 75, 81, 
  85, 85, 81, 90, 87, 81, 107, 82, 84, 84, 
  67, 75, 91, 90, 70, 81, 82, 84, 71, 70, 
  68, 88, 91, 79, 81, 91, 83, 89, 89, 79, 
  89, 83, 86, 66, 89, 88, 78, 84, 85, 90, 
  80, 76, 89, 78, 83, 80, 80, 81, 91, 79, 
  77, 73, 83, 95, 86, 80, 86, 103, 73, 97, 
  78, 87, 68, 88, 86, 79, 76, 87, 75, 79, 
  67, 75, 99, 76, 84, 89, 78, 95, 75, 101, 
  84, 75, 77, 64, 94, 83, 80, 87, 99, 73, 
  101, 90, 68, 79, 84, 80, 83, 84, 75, 80, 
  81, 82, 103, 86, 87, 85, 96, 82, 84, 86, 
  94, 63, 76, 85, 73, 100, 72, 99, 86, 95, 
  93, 70, 80, 96, 88, 103, 76, 72, 81, 81, 
  93, 88, 94, 79, 113, 102, 91, 88, 90, 79, 
  105, 78, 85, 89, 77, 88, 73, 75, 77, 87, 
  108, 81, 71, 94, 82, 96, 97, 78, 96, 86, 
  83, 62, 86, 100, 94, 99, 89, 89, 94, 76, 
  84, 95, 86, 75, 79, 76, 86, 81, 89, 89, 
  85, 67, 80, 96, 93, 85, 76, 82, 76, 89, 
  77, 88, 70, 64, 79, 89, 79, 110, 76, 92, 
  73, 75, 96, 90, 90, 91, 72, 93, 76, 89, 
  95, 78, 80, 94, 100, 84, 88, 65, 88, 88, 
  86, 81, 85, 78, 83, 81, 103, 85, 82, 72, 
  85, 81, 80, 83, 93, 80, 104, 96, 82, 105, 
  58, 65, 95, 97, 93, 90, 76, 83, 112, 86, 
  71, 75, 74, 67, 84, 76, 81, 90, 75, 96, 
  79, 100, 98, 96, 88, 96, 93, 94, 75, 68, 
  99, 67, 84, 76, 89, 81, 76, 66, 92, 92, 
  75, 98, 77, 94, 86, 75, 93, 94, 76, 83, 
  83, 86, 86, 78, 69, 95, 88, 82, 99, 85, 
  104, 96, 78, 95, 89, 78, 86, 76, 94, 65, 
  76, 89, 81, 83, 76, 83, 64, 99, 72, 75, 
  73, 59, 71, 83, 82, 110, 66, 91, 70, 74, 
  87, 83, 106, 85, 80, 106, 76, 91, 89, 93, 
  76, 88, 78, 85, 87, 67, 92, 83, 88, 80, 
  80, 84, 84, 84, 95, 74, 82, 71, 94, 84, 
  88, 80, 90, 77, 110, 103, 83, 109, 51, 70, 
  80, 97, 89, 87, 90, 81, 93, 91, 75, 84, 
  72, 75, 91, 69, 73, 84, 70, 80, 88, 84, 
  79, 115, 82, 83, 90, 100, 82, 55, 95, 69, 
  82, 72, 89, 85, 76, 99, 96, 93, 76, 83, 
  71, 88, 80, 75, 93, 105, 66, 86, 82, 79, 
  64, 75, 72, 87, 84, 86, 93, 77, 97, 98, 
  80, 88, 84, 74, 92, 84, 89, 90, 99, 108, 
  82, 86, 79, 77, 71, 87, 86, 90, 73, 89, 
  78, 83, 92, 76, 79, 95, 88, 89, 83, 77, 
  75, 91, 80, 86, 84, 94, 89, 87, 84, 89, 
  75, 90, 83, 82, 86, 89, 81, 87, 86, 88, 
  85, 93, 94, 93, 81, 81, 83, 81, 92, 84, 
  95, 81, 78, 78, 71, 69, 77, 77, 83, 90, 
  87, 85, 77, 80, 101, 71, 85, 80, 75, 87, 
  70, 98, 88, 89, 80, 89, 84, 77, 90, 75, 
  94, 83, 88, 78, 76, 88, 90, 85, 91, 73, 
  93, 93, 69, 88, 85, 94, 88, 87, 84, 85, 
  77, 73, 80, 75, 90, 100, 89, 84, 73, 82, 
  85, 78, 103, 78, 96, 87, 87, 91, 89, 90, 
  110, 78, 103, 85, 71, 71, 65, 85, 85, 88, 
  74, 82, 79, 97, 76, 75, 78, 59, 79, 93, 
  83, 119, 94, 88, 66, 82, 78, 87, 116, 94, 
  90, 97, 76, 88, 84, 89, 91, 79, 96, 78, 
  76, 71, 86, 84, 96, 80, 70, 95, 86, 78, 
  86, 87, 85, 63, 91, 69, 83, 75, 96, 62, 
  100, 113, 93, 110, 50, 70, 84, 89, 93, 73, 
  71, 82, 102, 95, 67, 81, 68, 62, 72, 70, 
  72, 75, 77, 99, 86, 94, 89, 102, 75, 85, 
  91, 83, 85, 71, 95, 63, 82, 82, 87, 80, 
  75, 49, 95, 92, 86, 80, 79, 87, 79, 77, 
  96, 99, 72, 73, 75, 85, 82, 83, 57, 93, 
  90, 83, 97, 72, 95, 86, 85, 85, 106, 79, 
  83, 76, 78, 67, 60, 79, 78, 87, 77, 83, 
  73, 91, 76, 66, 82, 52, 65, 85, 73, 120, 
  69, 89, 68, 80, 70, 83, 123, 70, 83, 113, 
  74, 86, 97, 97, 78, 70, 92, 82, 70, 64, 
  102, 81, 89, 87, 61, 75, 83, 73, 85, 83, 
  84, 57, 91, 87, 80, 67, 92, 62, 109, 118, 
  87, 107, 37, 77, 70, 90, 94, 58, 98, 77, 
  89, 89, 70, 85, 70, 92, 81, 64, 63, 73, 
  75, 80, 86, 84, 71, 115, 61, 84, 89, 99, 
  90, 64, 101, 66, 78, 71, 89, 83, 76, 71, 
  94, 93, 85, 69, 71, 81, 70, 72, 78, 117, 
  64, 78, 59, 76, 69, 82, 66, 87, 78, 81, 
  93, 66, 92, 83, 82, 72, 86, 75, 77, 91, 
  82, 86, 79, 105, 91, 87, 78, 79, 70, 77, 
  80, 85, 79, 76, 85, 81, 78, 82, 80, 90, 
  86, 94, 84, 80, 89, 78, 76, 86, 77, 92, 
  81, 87, 74, 96, 75, 94, 81, 72, 92, 86, 
  75, 91, 84, 70, 86, 94, 91, 96, 86, 69, 
  87, 83, 85, 77, 98, 74, 85, 81, 81, 61, 
  72, 67, 77, 88, 85, 86, 85, 77, 102, 73, 
  85, 85, 69, 98, 73, 92, 79, 83, 81, 86, 
  78, 81, 86, 85, 96, 89, 89, 101, 80, 87, 
  96, 87, 82, 62, 87, 89, 83, 82, 81, 92, 
  93, 79, 88, 86, 78, 84, 70, 79, 87, 97, 
  74, 84, 88, 80, 84, 83, 100, 75, 109, 89, 
  83, 78, 90, 78, 98, 70, 96, 81, 69, 95, 
  75, 78, 78, 82, 79, 88, 83, 79, 75, 73, 
  75, 85, 95, 109, 94, 93, 107, 90, 71, 84, 
  84, 93, 94, 90, 99, 104, 77, 85, 80, 100, 
  79, 69, 79, 66, 79, 78, 88, 84, 93, 90, 
  81, 90, 86, 80, 87, 81, 85, 69, 89, 74, 
  88, 64, 87, 84, 91, 104, 96, 99, 78, 58, 
  81, 95, 78, 87, 75, 98, 89, 88, 76, 83, 
  70, 72, 80, 72, 92, 85, 82, 96, 88, 88, 
  93, 84, 82, 91, 84, 82, 94, 88, 86, 73, 
  91, 80, 89, 76, 67, 62, 94, 96, 96, 77, 
  88, 93, 85, 81, 93, 77, 83, 86, 79, 100, 
  85, 94, 69, 86, 92, 83, 96, 73, 90, 98, 
  87, 84, 100, 80, 75, 80, 73, 88, 68, 76, 
  75, 87, 81, 93, 79, 80, 73, 70, 83, 78, 
  78, 103, 81, 94, 87, 88, 67, 80, 78, 89, 
  92, 78, 88, 111, 70, 82, 89, 95, 77, 67, 
  75, 71, 86, 72, 103, 79, 92, 97, 66, 74, 
  79, 76, 96, 86, 88, 66, 86, 76, 82, 63, 
  87, 79, 96, 101, 94, 101, 68, 64, 70, 89, 
  81, 64, 81, 94, 83, 86, 73, 88, 74, 87, 
  84, 69, 86, 83, 85, 88, 88, 90, 81, 93, 
  72, 94, 85, 101, 96, 82, 101, 69, 89, 79, 
  94, 77, 69, 69, 95, 96, 88, 76, 83, 85, 
  81, 76, 80, 92, 73, 81, 71, 90, 82, 90, 
  70, 84, 77, 78, 93, 68, 89, 86, 82, 75, 
  92, 75, 69, 90, 90, 97, 81, 92, 84, 91, 
  81, 79, 75, 83, 77, 83, 83, 78, 92, 93, 
  82, 80, 80, 88, 84, 93, 87, 90, 83, 83, 
  84, 88, 74, 101, 84, 93, 83, 84, 69, 90, 
  89, 80, 88, 87, 80, 91, 86, 86, 83, 86, 
  87, 89, 85, 75, 90, 87, 82, 75, 87, 74, 
  91, 82, 83, 82, 81, 72, 73, 84, 84, 91, 
  93, 77, 92, 76, 84, 88, 72, 83, 91, 90, 
  92, 75, 80, 79, 89, 82, 89, 87, 87, 90, 
  81, 107, 91, 92, 103, 86, 91, 66, 91, 86, 
  78, 86, 89, 94, 88, 76, 92, 95, 100, 76, 
  84, 76, 84, 88, 81, 85, 94, 85, 83, 79, 
  89, 77, 105, 87, 81, 78, 82, 83, 106, 98, 
  82, 88, 97, 83, 78, 68, 78, 76, 80, 84, 
  96, 73, 91, 98, 77, 79, 77, 89, 88, 75, 
  84, 86, 100, 82, 87, 77, 86, 84, 94, 101, 
  75, 79, 80, 84, 111, 74, 91, 89, 76, 81, 
  89, 84, 76, 77, 92, 86, 83, 71, 72, 89, 
  87, 88, 87, 102, 64, 107, 98, 87, 93, 86, 
  90, 83, 81, 79, 81, 77, 86, 84, 80, 106, 
  81, 86, 85, 80, 74, 81, 94, 95, 90, 82, 
  95, 81, 88, 79, 84, 69, 103, 85, 62, 91, 
  90, 102, 74, 89, 86, 83, 94, 71, 87, 75, 
  93, 89, 87, 84, 80, 83, 87, 86, 89, 83, 
  84, 90, 91, 80, 56, 97, 85, 88, 80, 79, 
  93, 86, 103, 83, 89, 72, 103, 62, 88, 93, 
  84, 116, 73, 70, 88, 91, 70, 91, 88, 90, 
  73, 78, 87, 99, 86, 109, 87, 65, 95, 78, 
  103, 75, 94, 91, 94, 81, 81, 99, 88, 83, 
  84, 94, 106, 74, 96, 78, 68, 98, 83, 91, 
  86, 81, 80, 85, 76, 72, 98, 80, 76, 75, 
  91, 97, 68, 74, 87, 95, 83, 70, 86, 62, 
  61, 73, 59, 94, 69, 84, 95, 98, 70, 82, 
  81, 85, 80, 111, 74, 97, 74, 87, 92, 102, 
  88, 77, 87, 99, 62, 80, 84, 101, 80, 84, 
  87, 100, 82, 69, 87, 74, 84, 103, 85, 90, 
  85, 69, 76, 86, 80, 77, 86, 77, 87, 102, 
  79, 100, 63, 88, 76, 73, 73, 66, 85, 76, 
  89, 78, 92, 71, 80, 69, 65, 73, 79, 125, 
  76, 92, 96, 84, 73, 96, 71, 83, 66, 79, 
  82, 92, 78, 112, 71, 78, 95, 81, 74, 89, 
  88, 87, 83, 96, 77, 85, 99, 85, 67, 101, 
  94, 78, 77, 91, 72, 97, 77, 82, 81, 74, 
  81, 109, 81, 74, 95, 78, 85, 77, 88, 82, 
  100, 63, 96, 92, 77, 77, 81, 58, 53, 90, 
  63, 84, 79, 75, 77, 85, 84, 85, 79, 86, 
  80, 92, 74, 109, 74, 81, 83, 100, 71, 77, 
  94, 87, 76, 86, 95, 88, 86, 77, 89, 87, 
  74, 69, 92, 87, 73, 90, 84, 83, 88, 83, 
  88, 87, 87, 96, 75, 74, 91, 97, 58, 99, 
  65, 72, 74, 96, 90, 93, 92, 88, 75, 83, 
  82, 112, 97, 81, 95, 91, 102, 72, 76, 69, 
  76, 76, 79, 94, 78, 71, 86, 91, 79, 70, 
  82, 92, 95, 61, 86, 84, 102, 76, 101, 85, 
  98, 78, 91, 91, 74, 87, 62, 76, 80, 85, 
  110, 69, 93, 69, 75, 85, 69, 88, 88, 80, 
  85, 68, 83, 71, 83, 87, 84, 100, 62, 99, 
  87, 85, 97, 97, 83, 77, 79, 71, 94, 79, 
  97, 91, 54, 89, 76, 102, 78, 74, 88, 89, 
  85, 86, 86, 76, 93, 93, 85, 103, 75, 76, 
  93, 67, 73, 86, 84, 107, 68, 93, 85, 83, 
  82, 76, 73, 67, 79, 93, 89, 94, 89, 80, 
  81, 76, 85, 94, 76, 91, 96, 93, 69, 96, 
  84, 107, 80, 69, 90, 82, 88, 88, 82, 71, 
  86, 56, 108, 92, 77, 97, 71, 69, 71, 95, 
  73, 92, 64, 74, 74, 74, 88, 98, 83, 123, 
  89, 58, 111, 77, 96, 63, 91, 94, 111, 121, 
  78, 91, 88, 66, 62, 89, 103, 91, 134, 57, 
  101, 83, 62, 90, 71, 78, 72, 89, 82, 78, 
  89, 78, 75, 74, 88, 89, 76, 67, 72, 84, 
  87, 76, 79, 62, 60, 73, 71, 95, 80, 108, 
  40, 82, 79, 83, 70, 84, 91, 94, 65, 86, 
  72, 80, 78, 113, 83, 103, 78, 102, 57, 67, 
  90, 70, 80, 79, 75, 90, 85, 61, 79, 79, 
  69, 58, 90, 88, 74, 89, 72, 86, 74, 84, 
  78, 92, 90, 91, 69, 110, 92, 84, 73, 88, 
  84, 70, 79, 83, 75, 81, 89, 80, 76, 74, 
  85, 73, 83, 98, 79, 88, 91, 80, 84, 88, 
  66, 78, 69, 85, 71, 97, 87, 102, 75, 74, 
  94, 79, 80, 81, 81, 83, 103, 124, 78, 76, 
  102, 76, 64, 89, 83, 86, 91, 96, 71, 95, 
  65, 85, 78, 74, 85, 106, 86, 87, 85, 79, 
  86, 79, 85, 85, 97, 67, 93, 92, 76, 75, 
  79, 46, 55, 98, 75, 73, 81, 66, 58, 93, 
  87, 80, 79, 84, 89, 81, 55, 105, 81, 83, 
  90, 97, 78, 88, 94, 83, 76, 81, 104, 72, 
  86, 81, 82, 77, 77, 71, 96, 87, 77, 56, 
  80, 82, 88, 76, 84, 89, 88, 104, 84, 76, 
  87, 88, 43, 99, 71, 75, 76, 89, 111, 98, 
  95, 92, 81, 78, 82, 111, 90, 77, 83, 69, 
  85, 100, 79, 84, 80, 89, 87, 91, 88, 78, 
  65, 72, 79, 72, 89, 90, 85, 93, 84, 83, 
  82, 83, 89, 89, 87, 91, 86, 78, 78, 81, 
  81, 95, 84, 80, 94, 80, 100, 71, 77, 82, 
  86, 90, 64, 83, 82, 75, 87, 84, 87, 87, 
  84, 83, 76, 78, 87, 87, 89, 96, 82, 86, 
  71, 94, 73, 87, 81, 79, 86, 81, 86, 92, 
  76, 90, 87, 113, 77, 87, 81, 81, 93, 92, 
  73, 92, 77, 79, 77, 77, 97, 77, 76, 83, 
  82, 77, 87, 82, 82, 88, 74, 69, 79, 88, 
  90, 98, 98, 80, 96, 86, 82, 86, 87, 98, 
  78, 80, 102, 81, 79, 91, 83, 78, 90, 82, 
  90, 83, 84, 84, 83, 73, 60, 73, 78, 96, 
  79, 85, 80, 85, 85, 86, 64, 81, 65, 76, 
  77, 93, 83, 89, 74, 81, 83, 82, 78, 79, 
  86, 86, 95, 112, 81, 73, 92, 73, 74, 91, 
  88, 79, 84, 75, 95, 59, 69, 84, 79, 79, 
  75, 73, 82, 87, 86, 81, 90, 81, 92, 70, 
  94, 85, 89, 90, 87, 83, 90, 81, 70, 90, 
  74, 84, 72, 91, 91, 70, 90, 80, 79, 96, 
  82, 103, 83, 68, 84, 86, 81, 88, 76, 89, 
  79, 82, 83, 88, 102, 80, 77, 71, 94, 76, 
  80, 71, 84, 90, 77, 74, 80, 79, 93, 84, 
  74, 88, 89, 100, 71, 81, 96, 82, 77, 90, 
  87, 72, 80, 79, 98, 82, 92, 92, 90, 88, 
  86, 94, 84, 81, 79, 69, 96, 66, 89, 97, 
  96, 75, 89, 85, 78, 93, 82, 90, 72, 86, 
  82, 78, 71, 82, 80, 83, 79, 89, 71, 70, 
  73, 83, 78, 72, 86, 86, 78, 79, 76, 87, 
  70, 102, 71, 68, 85, 94, 88, 80, 82, 70, 
  89, 79, 78, 104, 89, 88, 92, 89, 93, 106, 
  99, 87, 83, 81, 76, 66, 85, 105, 93, 74, 
  71, 87, 79, 84, 88, 76, 85, 81, 87, 91, 
  67, 89, 96, 82, 86, 79, 96, 87, 74, 73, 
  98, 89, 81, 87, 75, 87, 92, 85, 75, 90, 
  95, 91, 84, 77, 74, 79, 93, 72, 82, 89, 
  82, 90, 78, 73, 87, 85, 78, 93, 57, 78, 
  88, 77, 94, 94, 85, 94, 93, 85, 77, 87, 
  78, 77, 84, 85, 82, 100, 90, 94, 81, 91, 
  85, 93, 79, 68, 91, 78, 84, 95, 86, 72, 
  90, 76, 100, 89, 89, 84, 82, 93, 73, 101, 
  80, 84, 87, 81, 78, 96, 86, 82, 88, 78, 
  80, 77, 85, 89, 80, 91, 88, 101, 85, 83, 
  90, 97, 74, 81, 102, 81, 78, 87, 91, 76, 
  76, 99, 85, 84, 104, 81, 82, 90, 80, 89, 
  90, 81, 96, 81, 79, 95, 76, 82, 83, 91, 
  89, 86, 93, 113, 78, 80, 81, 90, 82, 92, 
  87, 92, 85, 77, 87, 89, 90, 82, 93, 88, 
  83, 85, 84, 95, 81, 77, 89, 78, 81, 82, 
  88, 83, 86, 95, 86, 79, 90, 84, 82, 83, 
  78, 79, 80, 84, 82, 92, 84, 74, 87, 80, 
  78, 89, 81, 82, 84, 92, 87, 93, 83, 96, 
  90, 69, 91, 81, 78, 81, 77, 79, 87, 87, 
  90, 94, 85, 88, 81, 98, 88, 97, 83, 91, 
  88, 83, 92, 89, 83, 86, 75, 70, 77, 80, 
  86, 85, 82, 83, 91, 87, 88, 81, 78, 90, 
  74, 82, 94, 73, 72, 84, 95, 77, 81, 82, 
  86, 97, 86, 75, 76, 89, 79, 75, 82, 102, 
  86, 76, 81, 92, 84, 75, 87, 80, 92, 81, 
  86, 89, 75, 77, 84, 89, 72, 96, 76, 80, 
  84, 69, 82, 86, 87, 81, 96, 75, 89, 75, 
  87, 92, 82, 78, 104, 86, 81, 84, 87, 84, 
  83, 89, 78, 79, 82, 85, 79, 80, 83, 81, 
  82, 79, 87, 84, 76, 80, 79, 96, 88, 88, 
  82, 88, 84, 89, 89, 100, 83, 111, 82, 80, 
  87, 79, 81, 82, 82, 89, 85, 80, 86, 93, 
  84, 84, 87, 97, 68, 75, 78, 84, 87, 71, 
  95, 104, 81, 86, 67, 69, 81, 75, 89, 88, 
  79, 91, 84, 77, 85, 87, 86, 93, 74, 81, 
  103, 81, 77, 85, 90, 72, 75, 95, 79, 94, 
  96, 71, 83, 96, 80, 80, 84, 91, 94, 85, 
  87, 93, 84, 108, 95, 80, 87, 82, 94, 79, 
  75, 79, 90, 87, 74, 89, 82, 90, 85, 74, 
  91, 84, 86, 84, 91, 78, 87, 83, 86, 91, 
  85, 77, 93, 84, 84, 81, 90, 89, 81, 80, 
  79, 80, 79, 84, 83, 80, 73, 79, 79, 82, 
  90, 89, 79, 76, 82, 67, 81, 78, 78, 71, 
  97, 93, 72, 88, 90, 100, 61, 82, 93, 71, 
  91, 84, 78, 82, 97, 66, 80, 92, 91, 82, 
  91, 90, 150, 96, 82, 87, 83, 86, 84, 81, 
  97, 90, 79, 67, 83, 78, 92, 84, 82, 81, 
  82, 93, 85, 78, 96, 61, 73, 85, 73, 88, 
  87, 81, 83, 103, 76, 95, 97, 87, 80, 80, 
  95, 95, 88, 90, 81, 84, 83, 78, 82, 88, 
  91, 81, 91, 104, 77, 86, 86, 98, 78, 82, 
  79, 95, 77, 93, 77, 92, 72, 80, 88, 92, 
  84, 94, 93, 88, 73, 97, 91, 97, 83, 93, 
  82, 82, 70, 84, 83, 79, 95, 87, 86, 92, 
  71, 90, 77, 85, 84, 93, 74, 79, 65, 90, 
  87, 83, 92, 75, 70, 84, 79, 63, 91, 94, 
  77, 84, 89, 110, 73, 78, 86, 76, 92, 72, 
  70, 88, 91, 71, 71, 93, 92, 93, 93, 91, 
  165, 87, 90, 91, 76, 88, 88, 70, 87, 89, 
  71, 67, 77, 84, 92, 82, 90, 77, 89, 78, 
  84, 63, 90, 52, 72, 90, 60, 83, 84, 86, 
  90, 108, 85, 78, 99, 109, 78, 79, 92, 89, 
  83, 73, 70, 102, 77, 80, 81, 78, 92, 73, 
  91, 98, 75, 92, 85, 82, 75, 82, 78, 95, 
  75, 98, 66, 86, 73, 77, 77, 88, 85, 97, 
  98, 75, 74, 80, 92, 99, 80, 92, 97, 90, 
  66, 86, 85, 80, 91, 78, 83, 79, 67, 89, 
  77, 85, 89, 92, 69, 79, 64, 84, 83, 83, 
  77, 95, 88, 80, 76, 70, 89, 87, 76, 91, 
  88, 114, 65, 87, 85, 74, 87, 74, 77, 98, 
  87, 66, 73, 90, 88, 87, 94, 93, 142, 79, 
  81, 89, 78, 72, 88, 89, 90, 92, 73, 62, 
  86, 74, 91, 82, 87, 81, 80, 72, 83, 75, 
  97, 61, 70, 87, 76, 75, 86, 83, 84, 102, 
  76, 87, 95, 98, 78, 73, 97, 102, 82, 87, 
  74, 96, 82, 84, 86, 85, 92, 98, 99, 96, 
  73, 89, 87, 84, 76, 85, 80, 96, 73, 91, 
  74, 83, 69, 82, 84, 86, 83, 98, 90, 80, 
  74, 83, 89, 94, 80, 89, 85, 86, 73, 81, 
  93, 83, 90, 73, 85, 85, 70, 88, 80, 82, 
  78, 94, 69, 77, 71, 87, 85, 83, 79, 70, 
  87, 81, 93, 91, 77, 84, 79, 87, 87, 77, 
  72, 79, 85, 84, 86, 84, 90, 67, 89, 86, 
  85, 96, 82, 72, 86, 95, 75, 81, 87, 86, 
  86, 89, 75, 84, 91, 81, 75, 84, 89, 81, 
  83, 83, 79, 95, 79, 96, 78, 88, 89, 105, 
  70, 79, 105, 78, 81, 85, 95, 79, 73, 86, 
  78, 75, 89, 80, 84, 70, 86, 91, 91, 75, 
  83, 78, 78, 88, 83, 85, 77, 84, 92, 68, 
  87, 90, 79, 80, 80, 82, 91, 83, 80, 83, 
  79, 77, 90, 77, 88, 77, 81, 82, 83, 89, 
  83, 87, 75, 86, 80, 75, 72, 87, 80, 85, 
  88, 87, 75, 83, 81, 86, 82, 83, 76, 76, 
  85, 74, 87, 83, 79, 83, 91, 72, 75, 86, 
  93, 81, 68, 85, 81, 81, 82, 76, 81, 71, 
  79, 91, 89, 79, 84, 73, 85, 86, 80, 88, 
  87, 71, 88, 102, 105, 72, 90, 94, 86, 92, 
  75, 78, 83, 90, 79, 79, 88, 85, 86, 77, 
  83, 93, 78, 87, 75, 84, 84, 90, 66, 81, 
  89, 78, 73, 80, 97, 86, 88, 78, 79, 82, 
  80, 76, 85, 79, 90, 79, 81, 90, 78, 77, 
  77, 85, 91, 78, 70, 86, 88, 68, 85, 81, 
  73, 82, 82, 82, 81, 88, 72, 78, 79, 77, 
  84, 76, 86, 81, 87, 69, 86, 84, 86, 89, 
  79, 89, 95, 77, 70, 88, 72, 92, 84, 82, 
  69, 80, 79, 87, 85, 82, 86, 82, 87, 75, 
  87, 79, 86, 86, 81, 85, 92, 79, 86, 84, 
  70, 73, 79, 86, 86, 87, 81, 75, 78, 85, 
  82, 77, 90, 74, 81, 88, 80, 93, 85, 74, 
  87, 98, 74, 71, 85, 87, 84, 76, 79, 87, 
  81, 87, 87, 77, 96, 79, 84, 78, 82, 93, 
  70, 73, 74, 91, 85, 101, 69, 80, 102, 71, 
  77, 82, 94, 79, 81, 82, 75, 83, 88, 75, 
  86, 84, 86, 96, 78, 87, 79, 80, 80, 90, 
  87, 104, 72, 82, 86, 66, 88, 76, 73, 84, 
  75, 86, 80, 82, 76, 75, 77, 80, 85, 73, 
  86, 84, 84, 76, 86, 74, 84, 84, 72, 86, 
  81, 76, 75, 85, 74, 89, 82, 74, 76, 81, 
  85, 84, 87, 79, 83, 80, 81, 74, 88, 80, 
  80, 85, 87, 82, 82, 90, 99, 88, 81, 89, 
  78, 84, 94, 75, 82, 91, 86, 74, 83, 91, 
  96, 85, 88, 87, 99, 73, 83, 73, 73, 86, 
  88, 96, 90, 90, 79, 93, 81, 85, 86, 65, 
  88, 80, 83, 77, 75, 95, 62, 75, 92, 79, 
  69, 78, 88, 78, 91, 86, 78, 78, 74, 73, 
  80, 93, 92, 93, 83, 82, 75, 90, 79, 87, 
  96, 74, 83, 73, 68, 94, 88, 71, 86, 100, 
  88, 78, 73, 77, 83, 91, 102, 83, 97, 93, 
  101, 85, 74, 90, 76, 79, 88, 66, 87, 78, 
  113, 94, 86, 73, 98, 79, 95, 86, 85, 101, 
  86, 77, 73, 83, 71, 80, 86, 88, 99, 76, 
  93, 76, 85, 64, 74, 86, 83, 93, 84, 93, 
  71, 84, 91, 86, 101, 82, 85, 97, 77, 78, 
  99, 87, 83, 85, 91, 75, 90, 105, 110, 88, 
  82, 81, 91, 61, 103, 80, 70, 81, 108, 90, 
  90, 92, 76, 81, 79, 84, 84, 61, 85, 97, 
  78, 77, 86, 103, 57, 75, 103, 77, 56, 77, 
  87, 72, 88, 102, 65, 77, 74, 69, 77, 96, 
  107, 92, 85, 86, 74, 91, 85, 92, 87, 63, 
  81, 64, 66, 83, 88, 61, 82, 89, 90, 77, 
  72, 79, 90, 82, 116, 88, 86, 100, 91, 86, 
  71, 96, 64, 73, 85, 70, 88, 77, 104, 93, 
  78, 80, 101, 79, 82, 78, 94, 103, 91, 73, 
  71, 78, 66, 82, 83, 85, 82, 81, 92, 74, 
  83, 65, 82, 78, 80, 90, 76, 92, 82, 96, 
  92, 89, 99, 92, 79, 97, 78, 85, 89, 75, 
  84, 80, 85, 79, 83, 88, 93, 97, 76, 86, 
  83, 75, 91, 80, 76, 84, 91, 80, 92, 98, 
  80, 83, 84, 97, 88, 66, 88, 87, 80, 76, 
  83, 89, 66, 79, 98, 87, 70, 80, 83, 75, 
  89, 89, 80, 85, 76, 75, 77, 86, 96, 88, 
  83, 81, 76, 92, 79, 85, 92, 68, 95, 73, 
  76, 91, 95, 72, 86, 83, 97, 80, 72, 75, 
  84, 80, 101, 88, 80, 89, 99, 85, 72, 99, 
  75, 81, 85, 68, 88, 79, 82, 97, 80, 88, 
  98, 79, 93, 89, 85, 98, 82, 77, 72, 82, 
  70, 88, 74, 82, 77, 77, 96, 74, 88, 69, 
  72, 86, 81, 89, 85, 91, 100, 82, 85, 91, 
  85, 92, 81, 85, 80, 90, 86, 73, 80, 76, 
  90, 90, 82, 84, 70, 81, 73, 84, 94, 90, 
  88, 73, 74, 87, 74, 85, 85, 98, 93, 101, 
  85, 86, 80, 63, 86, 75, 75, 81, 71, 90, 
  63, 74, 97, 89, 79, 85, 92, 82, 89, 85, 
  89, 80, 83, 89, 88, 100, 73, 76, 73, 88, 
  74, 86, 68, 91, 98, 64, 82, 83, 69, 86, 
  88, 77, 86, 105, 85, 82, 80, 96, 84, 83, 
  92, 76, 93, 88, 88, 85, 84, 76, 98, 72, 
  82, 71, 79, 83, 100, 90, 84, 77, 83, 79, 
  103, 94, 87, 89, 86, 82, 80, 82, 70, 84, 
  79, 89, 83, 89, 80, 66, 85, 82, 76, 83, 
  92, 89, 71, 85, 93, 81, 92, 95, 88, 90, 
  86, 87, 80, 91, 87, 81, 84, 82, 99, 93, 
  84, 94, 70, 85, 66, 80, 93, 83, 102, 69, 
  72, 91, 87, 87, 79, 96, 101, 89, 77, 79, 
  77, 55, 82, 84, 74, 86, 73, 103, 58, 71, 
  102, 89, 65, 82, 99, 79, 83, 93, 79, 84, 
  82, 87, 88, 94, 81, 76, 70, 92, 72, 91, 
  73, 92, 96, 53, 81, 73, 72, 79, 91, 73, 
  82, 95, 80, 80, 84, 98, 92, 82, 96, 79, 
  84, 86, 85, 91, 83, 75, 89, 56, 76, 75, 
  79, 90, 104, 88, 81, 70, 81, 78, 99, 97, 
  94, 90, 88, 83, 76, 76, 71, 82, 73, 85, 
  77, 97, 73, 63, 88, 73, 76, 82, 91, 84, 
  68, 83, 97, 94, 96, 89, 87, 94, 79, 87, 
  80, 91, 86, 72, 84, 87, 85, 96, 82, 81, 
  72, 93, 68, 85, 89, 89, 91, 75, 76, 85, 
  79, 91, 86, 100, 96, 83, 83, 93, 77, 60, 
  74, 77, 74, 80, 74, 93, 62, 71, 92, 93, 
  78, 85, 91, 76, 89, 89, 87, 83, 83, 91, 
  82, 97, 78, 78, 75, 89, 77, 87, 78, 91, 
  95, 58, 84, 84, 72, 86, 95, 80, 79, 86, 
  84, 82, 82, 94, 83, 85, 95, 87, 86, 86, 
  87, 88, 83, 76, 101, 69, 75, 71, 77, 87, 
  93, 90, 82, 73, 82, 78, 94, 99, 88, 89, 
  84, 84, 73, 80, 69, 82, 75, 90, 86, 89, 
  81, 65, 91, 78, 76, 83, 88, 86, 73, 82, 
  95, 84, 84, 80, 72, 89, 71, 77, 86, 90, 
  73, 74, 86, 71, 81, 92, 79, 69, 58, 81, 
  75, 80, 89, 110, 84, 75, 95, 76, 76, 84, 
  76, 92, 82, 107, 92, 84, 79, 73, 87, 74, 
  72, 67, 85, 71, 75, 88, 75, 81, 102, 91, 
  86, 81, 93, 66, 92, 80, 91, 104, 84, 89, 
  75, 75, 76, 89, 75, 86, 64, 84, 87, 86, 
  90, 85, 89, 93, 73, 86, 80, 88, 96, 82, 
  76, 87, 81, 87, 66, 86, 92, 82, 85, 94, 
  87, 78, 103, 80, 83, 76, 72, 83, 67, 79, 
  79, 85, 78, 85, 103, 89, 67, 70, 80, 92, 
  91, 75, 66, 87, 82, 90, 76, 92, 81, 86, 
  82, 101, 69, 79, 88, 93, 67, 77, 93, 84, 
  77, 88, 68, 84, 74, 76, 82, 99, 74, 77, 
  82, 86, 93, 96, 82, 75, 57, 84, 74, 74, 
  94, 111, 83, 71, 99, 80, 94, 91, 73, 87, 
  85, 98, 95, 77, 77, 81, 79, 80, 69, 65, 
  81, 76, 74, 90, 70, 81, 96, 95, 90, 85, 
  88, 62, 91, 77, 86, 104, 93, 89, 79, 75, 
  70, 90, 74, 89, 67, 82, 94, 84, 82, 83, 
  94, 92, 77, 85, 79, 84, 91, 74, 82, 86, 
  75, 78, 60, 96, 87, 75, 85, 96, 79, 79, 
  104, 73, 79, 80, 71, 91, 85, 69, 78, 78, 
  77, 85, 115, 94, 79, 68, 76, 96, 88, 73, 
  69, 81, 70, 90, 86, 97, 72, 88, 92, 100, 
  67, 76, 90, 95, 65, 75, 94, 85, 84, 84, 
  72, 84, 71, 79, 87, 92, 74, 72, 85, 97, 
  79, 98, 82, 67, 57, 88, 84, 81, 92, 106, 
  74, 73, 97, 76, 84, 96, 75, 91, 84, 95, 
  86, 85, 77, 73, 70, 81, 76, 66, 77, 77, 
  76, 86, 64, 86, 100, 90, 87, 76, 90, 70, 
  91, 83, 94, 102, 85, 88, 74, 76, 76, 87, 
  82, 85, 69, 82, 93, 82, 86, 87, 93, 93, 
  79, 86, 76, 79, 93, 80, 78, 85, 79, 75, 
  69, 99, 93, 79, 85, 88, 83, 77, 107, 77, 
  84, 74, 71, 87, 98, 76, 82, 75, 77, 83, 
  105, 93, 71, 74, 76, 89, 89, 75, 66, 78, 
  77, 93, 99, 92, 80, 93, 101, 95, 70, 79, 
  86, 95, 67, 79, 85, 80, 77, 90, 86, 86, 
  81, 70, 94, 65, 81, 74, 87, 91, 60, 76, 
  81, 91, 107, 82, 87, 83, 90, 69, 95, 96, 
  95, 65, 92, 87, 76, 81, 80, 83, 82, 96, 
  78, 86, 82, 83, 83, 75, 99, 84, 67, 84, 
  86, 96, 80, 87, 75, 81, 87, 77, 90, 80, 
  74, 83, 81, 85, 87, 76, 90, 76, 80, 80, 
  78, 79, 83, 82, 75, 92, 82, 89, 73, 82, 
  81, 87, 102, 73, 92, 78, 82, 90, 97, 94, 
  87, 103, 98, 79, 78, 83, 72, 82, 90, 73, 
  69, 82, 82, 63, 76, 77, 75, 94, 84, 77, 
  86, 82, 79, 92, 95, 83, 48, 98, 71, 69, 
  105, 81, 121, 96, 84, 94, 89, 83, 87, 73, 
  156, 88, 91, 93, 71, 80, 102, 79, 71, 62, 
  89, 41, 76, 77, 87, 94, 59, 72, 83, 98, 
  102, 82, 99, 80, 76, 63, 94, 90, 92, 50, 
  94, 88, 70, 93, 89, 69, 79, 86, 81, 89, 
  80, 80, 83, 67, 91, 84, 65, 79, 83, 83, 
  70, 86, 78, 77, 84, 77, 92, 81, 65, 86, 
  74, 80, 91, 75, 89, 76, 67, 84, 87, 74, 
  86, 89, 81, 89, 75, 87, 68, 71, 81, 82, 
  101, 76, 96, 72, 77, 80, 95, 88, 97, 102, 
  93, 76, 68, 85, 60, 79, 75, 71, 76, 80, 
  83, 75, 76, 91, 62, 93, 96, 82, 82, 80, 
  75, 93, 88, 87, 45, 90, 80, 77, 82, 79, 
  131, 87, 89, 94, 82, 76, 96, 79, 179, 87, 
  81, 92, 81, 90, 82, 98, 74, 78, 92, 72, 
  80, 81, 84, 87, 61, 78, 83, 93, 108, 89, 
  99, 85, 79, 71, 92, 94, 93, 67, 84, 85, 
  81, 81, 83, 79, 82, 115, 82, 91, 82, 84, 
  89, 76, 82, 85, 71, 81, 88, 77, 81, 91, 
  80, 77, 84, 77, 95, 81, 77, 80, 80, 83, 
  93, 81, 88, 72, 78, 80, 79, 86, 81, 78, 
  95, 93, 89, 88, 76, 88, 83, 96, 104, 73, 
  91, 75, 86, 81, 92, 92, 106, 98, 98, 80, 
  79, 81, 73, 83, 85, 73, 72, 81, 80, 70, 
  79, 78, 81, 93, 86, 75, 85, 91, 74, 88, 
  92, 81, 49, 79, 70, 74, 85, 79, 107, 93, 
  88, 95, 94, 88, 81, 74, 140, 86, 82, 71, 
  79, 72, 88, 87, 78, 64, 92, 50, 83, 73, 
  79, 81, 70, 82, 75, 88, 101, 84, 93, 79, 
  80, 71, 94, 97, 90, 63, 99, 83, 77, 82, 
  87, 81, 88, 94, 83, 80, 84, 76, 90, 79, 
  92, 83, 78, 92, 88, 93, 80, 80, 82, 81, 
  85, 90, 92, 90, 74, 88, 85, 87, 84, 79, 
  81, 76, 89, 87, 82, 71, 94, 74, 84, 97, 
  74, 84, 79, 74, 82, 91, 90, 84, 89, 82, 
  85, 86, 92, 78, 80, 93, 97, 82, 80, 83, 
  67, 80, 81, 73, 75, 85, 75, 78, 77, 81, 
  64, 91, 96, 81, 84, 81, 75, 92, 92, 82, 
  54, 99, 69, 71, 89, 90, 113, 86, 81, 88, 
  80, 72, 92, 84, 149, 86, 86, 85, 71, 63, 
  100, 80, 71, 57, 86, 20, 79, 75, 80, 89, 
  74, 88, 73, 97, 96, 84, 96, 82, 79, 62, 
  87, 87, 86, 43, 101, 93, 65, 88, 96, 74, 
  88, 71, 84, 80, 84, 73, 94, 79, 94, 88, 
  84, 85, 81, 86, 72, 82, 82, 78, 79, 91, 
  91, 77, 67, 94, 84, 90, 87, 78, 79, 76, 
  68, 96, 84, 77, 98, 73, 69, 104, 67, 81, 
  81, 59, 86, 82, 85, 92, 93, 81, 73, 76, 
  96, 81, 93, 90, 91, 80, 66, 77, 64, 75, 
  60, 71, 82, 87, 83, 84, 77, 87, 47, 92, 
  100, 86, 85, 81, 72, 89, 89, 88, 50, 88, 
  80, 84, 78, 97, 119, 76, 83, 86, 60, 68, 
  101, 84, 162, 98, 78, 92, 86, 81, 88, 89, 
  75, 66, 88, 55, 80, 79, 81, 93, 73, 83, 
  75, 85, 99, 86, 92, 80, 82, 72, 86, 93, 
  92, 60, 88, 89, 79, 77, 87, 79, 82, 95, 
  82, 80, 83, 77, 91, 78, 89, 85, 79, 88, 
  83, 87, 80, 82, 86, 81, 80, 88, 93, 70, 
  75, 85, 86, 83, 89, 82, 81, 73, 88, 85, 
  82, 77, 95, 77, 85, 95, 80, 86, 82, 80, 
  87, 92, 92, 84, 89, 75, 84, 86, 91, 83, 
  102, 91, 94, 80, 80, 82, 70, 82, 76, 71, 
  75, 85, 82, 76, 79, 77, 73, 91, 95, 86, 
  84, 86, 74, 86, 94, 82, 56, 81, 77, 76, 
  94, 89, 105, 86, 86, 84, 82, 79, 88, 88, 
  130, 85, 82, 75, 76, 76, 83, 80, 83, 73, 
  86, 75, 82, 76, 85, 80, 69, 86, 78, 86, 
  97, 87, 93, 84, 79, 80, 100, 94, 106, 81, 
  83, 77, 78, 89, 89, 85, 82, 93, 84, 78, 
  84, 85, 90, 73, 89, 80, 77, 86, 86, 91, 
  85, 85, 91, 86, 86, 88, 90, 81, 76, 82, 
  89, 82, 85, 78, 89, 78, 90, 88, 83, 82, 
  91, 84, 95, 92, 89, 80, 83, 73, 85, 86, 
  76, 75, 85, 88, 91, 88, 87, 78, 75, 93, 
  91, 88, 80, 91, 76, 81, 87, 72, 71, 82, 
  77, 68, 81, 80, 77, 86, 90, 88, 90, 77, 
  74, 93, 88, 76, 61, 108, 76, 75, 86, 89, 
  103, 85, 81, 90, 87, 79, 89, 97, 128, 80, 
  86, 83, 85, 75, 86, 77, 83, 69, 85, 62, 
  79, 78, 83, 88, 73, 86, 76, 84, 96, 81, 
  91, 83, 85, 76, 84, 93, 108, 73, 87, 85, 
  72, 86, 98, 84, 88, 85, 84, 82, 81, 78, 
  97, 74, 91, 83, 86, 79, 74, 82, 80, 90, 
  91, 85, 87, 84, 97, 85, 67, 81, 78, 77, 
  88, 73, 94, 79, 79, 87, 77, 82, 91, 89, 
  82, 92, 82, 78, 80, 62, 85, 78, 74, 76, 
  88, 87, 89, 83, 91, 79, 87, 91, 91, 86, 
  73, 90, 70, 79, 81, 66, 77, 83, 79, 73, 
  83, 82, 71, 85, 89, 89, 84, 78, 73, 91, 
  82, 82, 57, 90, 84, 77, 86, 94, 103, 81, 
  82, 87, 83, 76, 93, 98, 129, 85, 82, 87, 
  86, 82, 88, 85, 83, 75, 85, 75, 82, 78, 
  86, 90, 69, 86, 80, 82, 96, 82, 92, 83, 
  84, 80, 84, 91, 100, 78, 78, 86, 82, 81, 
  88, 87, 76, 94, 82, 78, 81, 87, 92, 77, 
  91, 83, 81, 80, 78, 85, 89, 83, 94, 84, 
  82, 86, 94, 74, 78, 83, 86, 78, 90, 81, 
  85, 75, 85, 86, 78, 82, 92, 84, 80, 89, 
  88, 83, 86, 77, 87, 88, 79, 74, 86, 85, 
  90, 93, 84, 76, 104, 86, 90, 82, 81, 92, 
  80, 85, 84, 69, 72, 82, 91, 68, 80, 78, 
  82, 84, 91, 92, 83, 82, 75, 89, 79, 77, 
  64, 85, 83, 76, 95, 91, 99, 88, 85, 88, 
  86, 82, 89, 100, 116, 79, 87, 99, 93, 82, 
  91, 88, 80, 70, 71, 99, 73, 83, 94, 83, 
  82, 83, 82, 99, 67, 77, 70, 72, 82, 87, 
  100, 83, 77, 79, 94, 84, 84, 92, 83, 91, 
  86, 88, 83, 76, 89, 90, 80, 93, 89, 77, 
  83, 73, 91, 73, 81, 81, 82, 85, 89, 63, 
  79, 82, 87, 87, 66, 86, 94, 83, 81, 81, 
  88, 90, 81, 76, 72, 91, 69, 91, 80, 81, 
  90, 77, 84, 97, 84, 81, 76, 80, 76, 99, 
  89, 81, 82, 89, 88, 79, 66, 82, 84, 84, 
  86, 78, 75, 92, 81, 74, 72, 85, 79, 81, 
  87, 93, 87, 80, 75, 113, 69, 85, 79, 79, 
  80, 87, 75, 94, 84, 78, 70, 95, 37, 86, 
  81, 94, 69, 87, 70, 97, 107, 84, 95, 98, 
  83, 84, 75, 93, 80, 84, 83, 83, 84, 86, 
  81, 88, 93, 72, 55, 85, 62, 84, 107, 89, 
  85, 73, 92, 80, 81, 100, 74, 76, 87, 99, 
  78, 76, 94, 74, 80, 87, 108, 81, 78, 85, 
  90, 54, 77, 78, 89, 95, 80, 78, 90, 82, 
  84, 82, 73, 89, 89, 81, 85, 69, 82, 82, 
  86, 79, 68, 79, 89, 94, 67, 83, 80, 76, 
  75, 100, 80, 85, 84, 79, 98, 127, 76, 84, 
  85, 80, 87, 91, 72, 80, 73, 85, 85, 70, 
  76, 88, 55, 85, 80, 71, 83, 78, 80, 83, 
  92, 90, 88, 93, 69, 86, 86, 91, 76, 85, 
  67, 89, 92, 72, 76, 84, 65, 82, 86, 88, 
  83, 83, 48, 92, 123, 93, 73, 107, 82, 92, 
  89, 82, 95, 86, 70, 92, 80, 96, 74, 71, 
  100, 91, 64, 111, 59, 88, 107, 85, 88, 81, 
  80, 83, 75, 102, 82, 85, 88, 104, 75, 101, 
  91, 68, 105, 80, 105, 96, 69, 91, 91, 61, 
  96, 86, 89, 101, 87, 99, 100, 91, 96, 77, 
  109, 83, 79, 104, 90, 83, 75, 81, 103, 99, 
  88, 79, 88, 84, 57, 72, 84, 83, 65, 117, 
  94, 80, 85, 90, 116, 138, 88, 82, 90, 90, 
  78, 91, 105, 79, 72, 83, 82, 75, 87, 84, 
  68, 148, 89, 66, 95, 82, 107, 88, 82, 100, 
  86, 61, 75, 91, 110, 88, 92, 98, 71, 70, 
  97, 103, 82, 65, 105, 75, 87, 85, 102, 91, 
  83, 82, 84, 79, 89, 91, 81, 75, 69, 100, 
  75, 80, 88, 80, 76, 84, 78, 99, 68, 77, 
  80, 75, 82, 88, 84, 82, 84, 77, 88, 92, 
  87, 88, 81, 86, 87, 87, 83, 81, 83, 82, 
  81, 92, 95, 79, 96, 82, 80, 78, 76, 79, 
  79, 73, 86, 65, 87, 74, 86, 92, 63, 85, 
  93, 87, 89, 81, 80, 93, 75, 78, 75, 95, 
  69, 85, 86, 85, 82, 81, 89, 90, 79, 84, 
  79, 84, 66, 87, 85, 80, 86, 88, 94, 82, 
  70, 88, 83, 85, 88, 82, 82, 85, 71, 69, 
  76, 88, 80, 84, 82, 71, 88, 86, 83, 111, 
  88, 92, 80, 79, 75, 81, 84, 92, 78, 89, 
  74, 95, 37, 87, 83, 92, 72, 87, 76, 86, 
  100, 80, 91, 96, 84, 87, 67, 95, 81, 78, 
  82, 77, 77, 81, 81, 92, 92, 73, 59, 81, 
  63, 83, 86, 92, 88, 73, 88, 78, 84, 89, 
  76, 76, 91, 95, 78, 73, 80, 72, 79, 91, 
  116, 77, 98, 83, 75, 63, 73, 76, 87, 84, 
  73, 77, 87, 80, 80, 84, 67, 85, 85, 85, 
  96, 66, 77, 82, 72, 78, 65, 78, 79, 90, 
  75, 92, 70, 79, 79, 95, 83, 93, 89, 79, 
  90, 114, 73, 83, 85, 77, 90, 86, 71, 85, 
  65, 86, 82, 78, 78, 89, 49, 74, 80, 80, 
  75, 80, 79, 69, 93, 88, 101, 91, 87, 86, 
  76, 97, 68, 78, 68, 92, 80, 81, 73, 89, 
  61, 84, 83, 86, 78, 84, 45, 88, 110, 94, 
  76, 100, 84, 87, 83, 91, 91, 84, 73, 78, 
  74, 88, 73, 72, 101, 85, 69, 113, 57, 80, 
  95, 89, 90, 81, 75, 75, 79, 95, 81, 84, 
  86, 107, 68, 101, 84, 73, 108, 79, 113, 100, 
  81, 76, 75, 66, 82, 84, 82, 104, 83, 105, 
  98, 94, 90, 77, 99, 85, 84, 106, 107, 79, 
  90, 85, 87, 103, 83, 82, 96, 81, 54, 86, 
  79, 79, 71, 115, 101, 81, 87, 86, 107, 127, 
  83, 80, 87, 88, 78, 83, 92, 82, 71, 80, 
  80, 81, 87, 85, 59, 129, 94, 78, 87, 82, 
  97, 73, 90, 103, 108, 58, 90, 94, 96, 97, 
  82, 96, 70, 78, 87, 99, 82, 71, 101, 77, 
  88, 86, 102, 84, 89, 78, 78, 84, 90, 91, 
  79, 77, 69, 94, 72, 72, 89, 77, 75, 87, 
  71, 95, 68, 74, 85, 73, 80, 88, 85, 79, 
  85, 73, 98, 83, 91, 93, 80, 86, 95, 82, 
  84, 80, 86, 87, 83, 94, 81, 77, 92, 79, 
  82, 75, 79, 78, 77, 65, 92, 60, 85, 77, 
  85, 86, 65, 91, 90, 84, 79, 87, 76, 91, 
  72, 81, 76, 83, 80, 89, 83, 81, 81, 87, 
  96, 94, 76, 77, 74, 79, 73, 93, 89, 82, 
  92, 81, 94, 86, 76, 88, 87, 86, 86, 85, 
  80, 80, 77, 66, 76, 90, 83, 86, 84, 79, 
  89, 88, 78, 106, 89, 89, 80, 84, 78, 85, 
  78, 91, 81, 90, 69, 89, 42, 88, 82, 83, 
  77, 79, 79, 78, 94, 81, 91, 96, 79, 84, 
  70, 92, 75, 77, 81, 79, 81, 82, 75, 94, 
  77, 72, 67, 84, 69, 85, 78, 84, 84, 73, 
  85, 72, 83, 94, 69, 75, 89, 89, 80, 71, 
  85, 80, 81, 89, 93, 74, 97, 80, 73, 66, 
  79, 77, 78, 81, 79, 67, 83, 80, 78, 79, 
  71, 88, 84, 84, 80, 79, 80, 88, 70, 78, 
  66, 81, 77, 90, 79, 90, 70, 80, 83, 88, 
  80, 86, 85, 75, 80, 105, 78, 83, 87, 74, 
  83, 86, 68, 86, 73, 88, 80, 83, 73, 91, 
  61, 68, 75, 89, 78, 80, 82, 78, 88, 87, 
  85, 100, 87, 80, 77, 87, 77, 80, 68, 90, 
  80, 85, 64, 92, 51, 87, 74, 79, 75, 73, 
  57, 90, 89, 92, 82, 84, 81, 87, 82, 91, 
  75, 88, 79, 72, 76, 87, 74, 81, 89, 74, 
  76, 94, 68, 78, 91, 89, 90, 80, 90, 63, 
  83, 90, 77, 79, 83, 100, 73, 84, 89, 80, 
  85, 79, 96, 89, 81, 82, 74, 69, 84, 77, 
  76, 89, 79, 92, 84, 88, 83, 74, 98, 86, 
  91, 95, 89, 77, 82, 81, 82, 88, 81, 80, 
  88, 79, 70, 98, 74, 83, 74, 103, 95, 82, 
  86, 81, 97, 116, 73, 84, 89, 83, 73, 89, 
  84, 86, 79, 85, 82, 85, 80, 93, 72, 88, 
  84, 79, 81, 80, 93, 73, 97, 93, 108, 73, 
  87, 82, 86, 89, 80, 86, 69, 88, 81, 85, 
  76, 84, 87, 80, 79, 85, 87, 72, 77, 77, 
  85, 87, 93, 80, 102, 75, 77, 95, 76, 100, 
  74, 86, 115, 70, 76, 114, 79, 88, 90, 75, 
  70, 98, 101, 91, 85, 69, 94, 86, 86, 74, 
  73, 74, 76, 73, 77, 80, 90, 97, 73, 91, 
  88, 116, 83, 69, 93, 81, 64, 106, 83, 66, 
  89, 90, 88, 78, 95, 85, 73, 96, 72, 75, 
  70, 78, 81, 71, 94, 78, 92, 85, 77, 82, 
  82, 92, 96, 92, 74, 74, 88, 68, 87, 78, 
  93, 71, 74, 77, 93, 71, 80, 88, 99, 80, 
  77, 78, 82, 91, 77, 70, 93, 74, 79, 78, 
  85, 71, 77, 86, 97, 86, 77, 81, 112, 96, 
  79, 89, 84, 75, 90, 85, 72, 86, 83, 70, 
  90, 70, 75, 93, 85, 87, 76, 88, 82, 88, 
  96, 76, 97, 70, 77, 99, 74, 102, 77, 87, 
  113, 73, 73, 110, 75, 93, 89, 76, 68, 99, 
  99, 87, 83, 69, 84, 79, 85, 78, 68, 78, 
  75, 74, 79, 84, 92, 96, 76, 95, 95, 122, 
  88, 67, 91, 80, 65, 105, 79, 62, 81, 89, 
  93, 82, 92, 91, 74, 92, 76, 78, 75, 74, 
  81, 73, 93, 82, 95, 85, 80, 84, 80, 87, 
  93, 89, 76, 79, 91, 69, 86, 75, 86, 71, 
  76, 82, 89, 69, 82, 88, 89, 83, 76, 80, 
  87, 91, 80, 74, 90, 74, 78, 78, 87, 74, 
  77, 89, 94, 90, 72, 74, 107, 95, 80, 93, 
  86, 77, 83, 88, 76, 85, 63, 68, 71, 74, 
  71, 90, 93, 88, 79, 92, 78, 84, 91, 74, 
  96, 72, 80, 89, 80, 95, 76, 91, 106, 76, 
  80, 106, 80, 86, 84, 78, 73, 97, 92, 86, 
  88, 70, 89, 77, 83, 75, 75, 76, 81, 70, 
  78, 78, 90, 97, 73, 84, 95, 110, 83, 71, 
  91, 82, 64, 98, 84, 71, 78, 91, 91, 83, 
  97, 92, 78, 92, 71, 74, 75, 80, 83, 71, 
  93, 76, 94, 87, 85, 80, 79, 91, 95, 92, 
  73, 84, 94, 69, 86, 80, 95, 80, 71, 83, 
  85, 75, 78, 93, 92, 84, 76, 79, 85, 86, 
  86, 73, 84, 80, 79, 73, 82, 72, 76, 86, 
  99, 83, 88, 82, 101, 98, 76, 96, 80, 74, 
  83, 86, 75, 87, 66, 71, 88, 73, 75, 92, 
  82, 88, 77, 75, 88, 88, 92, 83, 101, 77, 
  78, 90, 84, 102, 79, 91, 114, 76, 80, 116, 
  82, 88, 93, 75, 78, 89, 95, 84, 72, 73, 
  81, 75, 84, 79, 67, 79, 73, 77, 85, 79, 
  93, 95, 71, 88, 92, 124, 95, 64, 90, 84, 
  73, 112, 82, 68, 80, 93, 87, 80, 91, 81, 
  69, 88, 73, 78, 74, 80, 79, 75, 83, 74, 
  92, 84, 80, 84, 89, 88, 89, 90, 78, 79, 
  79, 71, 84, 89, 86, 69, 80, 85, 97, 67, 
  79, 67, 97, 79, 69, 81, 84, 96, 77, 78, 
  95, 79, 75, 82, 94, 73, 81, 77, 98, 90, 
  73, 74, 108, 92, 86, 90, 84, 79, 87, 87, 
  69, 82, 68, 73, 77, 82, 79, 90, 85, 87, 
  79, 78, 83, 93, 97, 80, 96, 73, 75, 96, 
  83, 102, 80, 93, 107, 76, 74, 109, 79, 89, 
  90, 76, 73, 89, 94, 74, 73, 75, 70, 78, 
  82, 83, 64, 86, 76, 80, 87, 82, 94, 94, 
  75, 90, 95, 126, 99, 60, 91, 83, 77, 113, 
  76, 72, 73, 92, 94, 81, 89, 85, 72, 83, 
  76, 82, 80, 77, 80, 76, 80, 78, 96, 88, 
  84, 87, 86, 80, 83, 86, 79, 82, 84, 71, 
  85, 82, 78, 67, 78, 90, 94, 68, 83, 61, 
  89, 79, 73, 83, 90, 94, 79, 80, 91, 80, 
  75, 86, 95, 76, 84, 79, 98, 94, 69, 67, 
  102, 92, 89, 95, 85, 83, 86, 88, 73, 85, 
  50, 72, 59, 89, 76, 91, 91, 90, 79, 83, 
  80, 89, 87, 78, 96, 75, 78, 87, 88, 98, 
  78, 94, 105, 83, 82, 109, 78, 87, 85, 78, 
  77, 89, 91, 79, 72, 75, 76, 75, 84, 79, 
  70, 81, 76, 78, 84, 80, 91, 93, 73, 85, 
  95, 117, 92, 66, 90, 85, 74, 103, 85, 73, 
  74, 95, 87, 80, 93, 88, 74, 86, 75, 80, 
  79, 83, 80, 77, 86, 76, 94, 81, 85, 83, 
  82, 86, 85, 88, 78, 83, 81, 75, 85, 93, 
  84, 80, 77, 90, 89, 72, 78, 75, 90, 80, 
  71, 81, 85, 92, 82, 80, 84, 84, 75, 80, 
  92, 75, 81, 78, 99, 86, 80, 76, 97, 94, 
  84, 93, 82, 81, 83, 86, 75, 84, 57, 76, 
  82, 84, 77, 90, 83, 87, 77, 78, 85, 87, 
  91, 84, 106, 76, 81, 79, 81, 106, 76, 93, 
  111, 78, 85, 119, 82, 86, 94, 73, 78, 79, 
  91, 87, 75, 74, 85, 78, 85, 82, 74, 77, 
  68, 76, 86, 81, 89, 87, 75, 82, 88, 119, 
  96, 67, 94, 84, 73, 101, 75, 74, 75, 96, 
  85, 81, 93, 81, 80, 76, 78, 72, 76, 81, 
  82, 76, 82, 74, 83, 86, 84, 76, 87, 83, 
  85, 90, 79, 75, 84, 67, 89, 80, 80, 71, 
  80, 88, 99, 72, 82, 75, 95, 91, 74, 73, 
  80, 93, 80, 79, 99, 83, 81, 82, 88, 72, 
  87, 80, 100, 89, 88, 78, 101, 88, 82, 85, 
  86, 85, 83, 86, 68, 80, 72, 72, 82, 77, 
  78, 85, 85, 84, 78, 81, 84, 90, 94, 80, 
  103, 76, 77, 86, 81, 106, 74, 89, 110, 77, 
  83, 115, 79, 89, 87, 72, 72, 78, 91, 85, 
  75, 77, 74, 78, 85, 82, 75, 82, 73, 79, 
  90, 82, 88, 84, 79, 84, 88, 117, 101, 61, 
  96, 81, 78, 102, 70, 71, 71, 94, 88, 82, 
  91, 82, 81, 76, 80, 78, 79, 81, 80, 76, 
  84, 81, 84, 88, 82, 79, 87, 75, 83, 89, 
  78, 79, 92, 67, 89, 71, 75, 69, 79, 90, 
  93, 74, 83, 73, 93, 89, 76, 81, 84, 94, 
  84, 81, 92, 84, 83, 87, 90, 76, 89, 80, 
  101, 91, 92, 73, 97, 90, 85, 91, 84, 88, 
  78, 88, 71, 82, 59, 75, 75, 80, 76, 88, 
  88, 86, 76, 79, 87, 88, 84, 76, 100, 76, 
  82, 77, 84, 102, 75, 90, 105, 86, 87, 115, 
  76, 87, 85, 77, 79, 81, 93, 82, 74, 78, 
  80, 72, 86, 81, 77, 79, 72, 79, 87, 80, 
  89, 84, 80, 81, 92, 112, 94, 66, 96, 82, 
  73, 98, 79, 76, 71, 97, 86, 82, 95, 87, 
  83, 78, 78, 79, 80, 84, 82, 77, 88, 76, 
  87, 89, 84, 76, 83, 81, 82, 87, 78, 85, 
  88, 70, 88, 84, 82, 82, 77, 90, 86, 79, 
  80, 82, 93, 87, 75, 73, 79, 94, 82, 79, 
  85, 91, 84, 81, 89, 74, 84, 78, 100, 85, 
  92, 77, 95, 89, 80, 91, 84, 85, 77, 84, 
  72, 84, 65, 74, 85, 79, 79, 85, 82, 86, 
  72, 72, 75, 89, 87, 81, 80, 92, 90, 84, 
  84, 155, 112, 92, 70, 79, 62, 60, 91, 74, 
  89, 94, 82, 77, 76, 76, 73, 89, 92, 89, 
  107, 88, 68, 96, 98, 89, 73, 90, 94, 76, 
  90, 73, 54, 76, 65, 73, 79, 73, 84, 75, 
  86, 91, 86, 87, 81, 96, 73, 60, 97, 93, 
  90, 92, 81, 105, 90, 49, 97, 88, 93, 111, 
  69, 84, 75, 80, 74, 74, 107, 69, 73, 82, 
  86, 118, 64, 75, 73, 93, 83, 98, 61, 95, 
  82, 90, 79, 70, 78, 75, 104, 104, 82, 77, 
  91, 67, 77, 70, 82, 74, 81, 82, 86, 85, 
  96, 62, 81, 88, 88, 94, 67, 77, 93, 66, 
  110, 106, 73, 88, 85, 92, 74, 81, 75, 81, 
  71, 82, 90, 62, 79, 86, 87, 85, 86, 144, 
  105, 87, 76, 86, 74, 68, 88, 80, 54, 87, 
  68, 75, 79, 78, 76, 89, 93, 87, 109, 107, 
  71, 92, 97, 90, 86, 89, 91, 78, 93, 87, 
  89, 77, 71, 69, 84, 74, 74, 76, 92, 93, 
  84, 90, 80, 87, 74, 65, 101, 94, 89, 88, 
  80, 99, 83, 64, 89, 84, 87, 100, 81, 83, 
  70, 81, 80, 73, 101, 80, 81, 77, 90, 108, 
  73, 70, 76, 90, 72, 95, 72, 97, 81, 102, 
  87, 72, 81, 72, 107, 109, 67, 74, 97, 98, 
  81, 71, 76, 73, 75, 84, 84, 85, 100, 68, 
  82, 78, 92, 77, 64, 79, 94, 64, 86, 97, 
  72, 89, 84, 85, 81, 83, 72, 85, 75, 91, 
  95, 81, 85, 78, 72, 91, 79, 81, 64, 89, 
  70, 89, 75, 80, 91, 82, 92, 65, 84, 94, 
  87, 90, 79, 87, 94, 78, 70, 92, 70, 82, 
  90, 85, 75, 87, 79, 80, 82, 80, 75, 81, 
  78, 86, 82, 107, 89, 81, 92, 81, 82, 83, 
  87, 84, 75, 79, 79, 75, 84, 103, 71, 73, 
  96, 70, 83, 85, 94, 86, 84, 86, 103, 86, 
  88, 100, 79, 83, 92, 86, 89, 81, 93, 78, 
  76, 74, 91, 90, 83, 94, 87, 92, 88, 78, 
  110, 84, 91, 81, 78, 90, 83, 83, 80, 75, 
  89, 74, 67, 75, 80, 62, 90, 78, 81, 79, 
  78, 94, 95, 87, 68, 82, 91, 71, 80, 81, 
  91, 89, 80, 80, 84, 80, 60, 76, 87, 77, 
  85, 118, 101, 79, 75, 185, 114, 87, 76, 69, 
  76, 71, 91, 76, 103, 100, 75, 73, 76, 81, 
  72, 81, 98, 77, 114, 84, 74, 105, 98, 85, 
  85, 92, 97, 78, 79, 86, 68, 83, 76, 84, 
  73, 78, 82, 77, 86, 90, 96, 89, 81, 108, 
  75, 45, 102, 79, 75, 84, 90, 98, 76, 50, 
  85, 86, 89, 83, 75, 78, 74, 80, 84, 64, 
  96, 74, 72, 89, 89, 124, 77, 67, 80, 89, 
  81, 97, 61, 80, 73, 76, 72, 64, 75, 78, 
  90, 105, 93, 68, 79, 76, 86, 69, 83, 97, 
  91, 91, 86, 104, 102, 71, 82, 82, 93, 77, 
  61, 78, 89, 70, 94, 102, 78, 95, 80, 84, 
  73, 89, 84, 89, 82, 72, 88, 60, 83, 101, 
  99, 80, 75, 161, 110, 109, 83, 78, 83, 80, 
  85, 80, 55, 84, 70, 70, 82, 81, 72, 83, 
  93, 94, 104, 97, 76, 91, 89, 84, 95, 89, 
  93, 79, 86, 83, 110, 85, 78, 76, 85, 65, 
  72, 80, 87, 85, 95, 95, 77, 87, 76, 54, 
  95, 80, 77, 82, 87, 93, 75, 60, 95, 80, 
  77, 91, 69, 81, 67, 76, 85, 63, 90, 80, 
  61, 80, 94, 110, 84, 84, 76, 99, 69, 92, 
  69, 89, 75, 75, 76, 65, 64, 77, 87, 109, 
  73, 64, 89, 74, 86, 72, 77, 95, 88, 85, 
  84, 101, 97, 75, 83, 76, 98, 69, 78, 79, 
  96, 71, 77, 94, 75, 93, 81, 82, 79, 88, 
  75, 99, 72, 84, 89, 75, 90, 84, 78, 84, 
  82, 99, 69, 100, 81, 83, 78, 80, 80, 79, 
  88, 72, 83, 93, 86, 87, 74, 80, 95, 81, 
  64, 84, 71, 84, 89, 87, 77, 86, 76, 86, 
  86, 84, 88, 80, 84, 85, 78, 107, 90, 83, 
  93, 81, 89, 85, 75, 80, 78, 73, 76, 73, 
  77, 102, 83, 76, 85, 74, 87, 78, 88, 82, 
  80, 89, 99, 82, 87, 88, 75, 82, 79, 91, 
  96, 83, 90, 85, 73, 86, 87, 86, 80, 90, 
  77, 82, 84, 75, 92, 84, 80, 87, 75, 84, 
  82, 72, 80, 74, 87, 79, 74, 80, 78, 74, 
  86, 79, 80, 85, 84, 77, 105, 87, 62, 83, 
  85, 69, 78, 79, 89, 90, 70, 80, 76, 75, 
  67, 79, 85, 77, 84, 103, 86, 83, 88, 124, 
  97, 79, 64, 75, 79, 79, 98, 82, 100, 90, 
  71, 82, 81, 94, 86, 83, 86, 73, 107, 88, 
  80, 96, 86, 90, 86, 88, 83, 83, 73, 80, 
  76, 72, 81, 78, 70, 91, 87, 77, 85, 92, 
  93, 78, 87, 90, 79, 51, 100, 83, 72, 86, 
  87, 101, 83, 63, 85, 94, 85, 77, 84, 77, 
  101, 90, 82, 78, 76, 69, 88, 87, 80, 104, 
  80, 82, 82, 84, 82, 89, 68, 80, 76, 83, 
  87, 80, 81, 77, 91, 87, 78, 89, 87, 90, 
  89, 71, 85, 89, 80, 98, 84, 85, 96, 81, 
  75, 87, 87, 83, 60, 79, 81, 86, 86, 87, 
  78, 90, 91, 86, 80, 87, 76, 90, 79, 77, 
  83, 61, 80, 89, 82, 80, 84, 108, 97, 97, 
  71, 79, 86, 84, 89, 81, 65, 81, 75, 79, 
  84, 91, 86, 86, 80, 95, 98, 91, 82, 86, 
  79, 84, 95, 87, 92, 82, 80, 79, 101, 76, 
  81, 75, 80, 66, 82, 79, 87, 89, 90, 83, 
  82, 75, 81, 61, 95, 87, 78, 85, 83, 100, 
  82, 70, 95, 93, 79, 89, 66, 80, 94, 83, 
  84, 75, 78, 85, 77, 82, 85, 96, 86, 91, 
  83, 97, 72, 86, 73, 84, 79, 75, 87, 77, 
  73, 78, 86, 92, 85, 84, 91, 84, 88, 74, 
  82, 96, 81, 91, 84, 88, 87, 81, 78, 77, 
  94, 84, 93, 81, 89, 87, 86, 92, 71, 89, 
  89, 87, 83, 88, 77, 97, 71, 88, 80, 82, 
  89, 80, 71, 85, 83, 69, 78, 90, 68, 80, 
  77, 85, 89, 78, 84, 76, 90, 90, 80, 90, 
  85, 84, 84, 81, 81, 83, 72, 86, 86, 81, 
  78, 81, 83, 81, 87, 85, 81, 82, 84, 79, 
  83, 98, 89, 75, 91, 92, 90, 78, 87, 80, 
  86, 76, 78, 79, 83, 85, 84, 80, 87, 79, 
  85, 81, 90, 79, 90, 83, 109, 80, 81, 94, 
  72, 88, 81, 86, 89, 71, 91, 79, 80, 89, 
  88, 82, 85, 89, 85, 89, 91, 81, 95, 80, 
  84, 80, 85, 90, 80, 87, 87, 76, 83, 80, 
  74, 90, 87, 79, 83, 78, 80, 86, 88, 84, 
  109, 85, 72, 88, 91, 78, 75, 81, 92, 92, 
  75, 82, 73, 91, 85, 74, 79, 79, 66, 82, 
  96, 86, 83, 96, 81, 91, 66, 87, 67, 63, 
  79, 95, 85, 82, 92, 84, 83, 68, 96, 92, 
  93, 72, 92, 85, 78, 81, 74, 84, 120, 75, 
  98, 79, 79, 82, 76, 75, 80, 88, 82, 72, 
  70, 76, 65, 82, 77, 77, 88, 101, 80, 74, 
  87, 75, 95, 82, 85, 81, 67, 74, 102, 100, 
  87, 108, 80, 80, 81, 83, 75, 82, 74, 79, 
  70, 64, 86, 92, 73, 88, 79, 86, 75, 112, 
  71, 95, 89, 102, 79, 74, 93, 59, 80, 83, 
  77, 100, 88, 86, 101, 76, 88, 97, 63, 96, 
  82, 86, 85, 77, 77, 90, 87, 104, 76, 77, 
  80, 92, 96, 84, 80, 89, 80, 82, 86, 87, 
  95, 83, 82, 80, 82, 82, 72, 77, 93, 82, 
  86, 95, 76, 107, 72, 92, 69, 68, 90, 86, 
  81, 80, 91, 81, 78, 74, 98, 93, 96, 71, 
  97, 88, 76, 88, 81, 78, 120, 74, 86, 81, 
  75, 92, 77, 80, 81, 81, 91, 60, 59, 69, 
  71, 99, 81, 72, 93, 92, 84, 76, 84, 68, 
  90, 77, 97, 87, 66, 81, 86, 84, 89, 103, 
  92, 76, 70, 75, 74, 80, 70, 73, 71, 68, 
  86, 89, 63, 81, 76, 84, 82, 100, 63, 94, 
  88, 112, 85, 79, 99, 66, 89, 91, 78, 80, 
  74, 79, 105, 78, 90, 87, 65, 91, 83, 88, 
  86, 66, 69, 84, 98, 84, 84, 68, 65, 93, 
  100, 74, 80, 80, 85, 83, 89, 75, 78, 69, 
  70, 80, 83, 80, 72, 79, 92, 85, 83, 93, 
  83, 100, 73, 81, 67, 69, 81, 88, 83, 78, 
  87, 86, 82, 72, 100, 95, 85, 69, 101, 80, 
  82, 92, 87, 83, 121, 82, 72, 82, 75, 85, 
  78, 78, 79, 87, 84, 77, 66, 77, 65, 88, 
  79, 78, 89, 71, 82, 72, 88, 73, 93, 78, 
  88, 81, 69, 78, 93, 101, 93, 111, 78, 79, 
  78, 76, 76, 78, 81, 75, 76, 65, 86, 89, 
  74, 89, 80, 80, 86, 99, 70, 104, 84, 112, 
  80, 75, 94, 68, 79, 83, 87, 94, 81, 97, 
  103, 80, 98, 95, 65, 94, 85, 89, 86, 73, 
  77, 86, 97, 98, 83, 78, 74, 93, 95, 85, 
  84, 84, 83, 85, 91, 89, 74, 94, 83, 65, 
  90, 94, 85, 77, 80, 80, 82, 93, 72, 123, 
  81, 71, 72, 66, 79, 86, 82, 85, 100, 82, 
  87, 75, 87, 82, 95, 76, 102, 88, 90, 71, 
  69, 103, 106, 90, 82, 79, 84, 88, 90, 71, 
  82, 74, 81, 72, 87, 84, 75, 80, 82, 82, 
  84, 87, 77, 62, 84, 85, 100, 85, 92, 75, 
  95, 78, 80, 111, 77, 86, 64, 103, 64, 76, 
  82, 87, 77, 71, 77, 78, 81, 80, 78, 69, 
  70, 86, 87, 99, 71, 106, 76, 75, 93, 104, 
  78, 74, 78, 98, 97, 83, 74, 90, 95, 74, 
  91, 93, 79, 79, 84, 81, 80, 72, 67, 94, 
  99, 105, 64, 98, 70, 94, 98, 90, 91, 77, 
  72, 74, 84, 88, 90, 85, 56, 71, 84, 82, 
  88, 77, 75, 73, 87, 93, 78, 97, 88, 79, 
  79, 79, 95, 72, 80, 73, 89, 82, 93, 80, 
  82, 81, 89, 72, 111, 106, 85, 68, 75, 74, 
  84, 101, 85, 79, 74, 88, 83, 76, 81, 81, 
  83, 61, 78, 85, 75, 84, 81, 84, 81, 84, 
  86, 65, 82, 99, 114, 74, 91, 87, 80, 76, 
  88, 117, 77, 70, 66, 88, 62, 78, 73, 82, 
  72, 69, 79, 83, 83, 71, 75, 77, 57, 75, 
  91, 69, 67, 121, 72, 75, 96, 129, 71, 80, 
  77, 124, 93, 73, 67, 72, 87, 76, 85, 100, 
  78, 67, 70, 82, 73, 74, 72, 89, 84, 92, 
  69, 105, 55, 94, 106, 79, 86, 76, 66, 74, 
  96, 84, 81, 73, 55, 77, 89, 90, 86, 75, 
  81, 78, 86, 88, 81, 76, 84, 74, 72, 80, 
  85, 81, 88, 78, 100, 82, 95, 77, 84, 82, 
  85, 74, 101, 96, 86, 83, 85, 89, 104, 97, 
  96, 81, 80, 85, 87, 75, 82, 81, 84, 83, 
  81, 89, 70, 86, 82, 88, 79, 93, 76, 64, 
  83, 80, 97, 74, 86, 77, 86, 79, 84, 118, 
  73, 87, 87, 97, 62, 75, 74, 86, 79, 74, 
  81, 79, 86, 74, 79, 97, 74, 73, 91, 90, 
  74, 110, 75, 85, 89, 101, 85, 80, 80, 94, 
  89, 84, 73, 80, 91, 79, 89, 95, 78, 75, 
  74, 81, 79, 74, 72, 86, 85, 111, 83, 99, 
  69, 85, 91, 84, 94, 78, 72, 78, 92, 84, 
  78, 98, 90, 80, 100, 96, 87, 86, 79, 81, 
  87, 77, 71, 86, 86, 76, 77, 75, 81, 90, 
  79, 83, 90, 90, 84, 78, 81, 81, 89, 79, 
  98, 86, 101, 79, 82, 106, 80, 84, 92, 80, 
  87, 77, 84, 82, 83, 85, 85, 76, 87, 91, 
  78, 85, 78, 91, 96, 97, 81, 70, 84, 90, 
  96, 103, 76, 81, 96, 80, 79, 99, 82, 77, 
  79, 87, 81, 77, 92, 80, 72, 86, 82, 83, 
  90, 73, 99, 74, 77, 74, 83, 84, 90, 100, 
  92, 78, 89, 107, 88, 78, 85, 88, 98, 80, 
  76, 93, 84, 87, 81, 92, 90, 87, 86, 79, 
  82, 76, 78, 85, 86, 90, 84, 91, 72, 89, 
  89, 77, 80, 84, 69, 86, 77, 88, 80, 84, 
  70, 90, 89, 98, 91, 89, 72, 70, 89, 74, 
  83, 84, 101, 85, 87, 86, 78, 81, 79, 79, 
  96, 80, 85, 80, 80, 74, 84, 77, 106, 83, 
  94, 74, 74, 77, 73, 67, 85, 70, 80, 81, 
  86, 88, 75, 91, 82, 77, 87, 86, 78, 90, 
  75, 89, 93, 83, 83, 72, 80, 110, 107, 88, 
  77, 87, 96, 84, 87, 105, 84, 79, 75, 74, 
  72, 84, 84, 72, 71, 88, 78, 89, 90, 73, 
  99, 77, 71, 71, 87, 66, 89, 99, 81, 85, 
  82, 127, 82, 84, 82, 105, 82, 73, 73, 86, 
  74, 89, 77, 101, 98, 81, 70, 67, 83, 78, 
  84, 88, 90, 86, 96, 90, 64, 88, 84, 73, 
  67, 89, 57, 87, 79, 81, 75, 79, 73, 93, 
  96, 90, 87, 81, 80, 79, 92, 77, 80, 95, 
  95, 81, 75, 79, 80, 86, 86, 77, 100, 85, 
  90, 76, 81, 80, 83, 89, 93, 90, 93, 80, 
  82, 84, 78, 85, 81, 73, 91, 78, 79, 77, 
  83, 91, 86, 95, 86, 92, 81, 87, 79, 95, 
  94, 78, 76, 69, 79, 90, 97, 89, 80, 81, 
  94, 80, 95, 101, 84, 76, 86, 89, 73, 76, 
  86, 86, 80, 80, 77, 85, 97, 77, 94, 91, 
  75, 74, 81, 80, 93, 102, 85, 80, 87, 108, 
  93, 81, 87, 86, 86, 76, 78, 74, 83, 90, 
  87, 100, 87, 87, 79, 76, 87, 75, 83, 83, 
  93, 96, 98, 90, 78, 82, 79, 74, 82, 86, 
  66, 86, 82, 87, 76, 91, 98, 75, 73, 83, 
  115, 93, 78, 85, 85, 72, 94, 75, 96, 89, 
  90, 86, 89, 82, 76, 87, 82, 83, 83, 75, 
  76, 82, 91, 81, 90, 76, 82, 68, 83, 86, 
  91, 80, 84, 90, 73, 87, 80, 100, 82, 94, 
  84, 81, 80, 95, 97, 96, 90, 87, 74, 97, 
  77, 93, 90, 89, 73, 84, 81, 91, 92, 78, 
  74, 73, 84, 84, 87, 74, 78, 78, 81, 82, 
  98, 74, 83, 99, 99, 83, 74, 69, 84, 78, 
  80, 66, 94, 89, 83, 71, 74, 66, 78, 84, 
  82, 87, 83, 97, 105, 81, 84, 76, 78, 84, 
  76, 91, 84, 74, 78, 87, 89, 80, 80, 80, 
  74, 84, 85, 96, 106, 77, 75, 88, 111, 78, 
  78, 87, 77, 81, 100, 80, 81, 79, 115, 84, 
  76, 80, 79, 81, 113, 81, 97, 91, 95, 87, 
  85, 78, 86, 91, 80, 82, 85, 69, 72, 79, 
  81, 76, 97, 82, 83, 73, 78, 71, 91, 78, 
  85, 96, 71, 86, 81, 111, 82, 103, 82, 73, 
  77, 91, 94, 105, 90, 85, 72, 91, 68, 91, 
  90, 90, 75, 79, 80, 99, 86, 80, 73, 76, 
  82, 80, 88, 71, 71, 77, 84, 72, 99, 75, 
  86, 98, 96, 81, 75, 80, 83, 77, 85, 58, 
  96, 101, 75, 74, 72, 70, 79, 90, 79, 91, 
  86, 93, 104, 75, 79, 76, 77, 83, 72, 95, 
  88, 69, 84, 87, 88, 88, 91, 81, 74, 81, 
  87, 92, 88, 80, 71, 90, 113, 80, 79, 92, 
  79, 71, 87, 78, 79, 76, 111, 85, 79, 85, 
  81, 69, 85, 75, 94, 86, 92, 87, 93, 68, 
  86, 90, 81, 83, 76, 75, 76, 82, 89, 78, 
  91, 82, 77, 83, 89, 73, 90, 81, 77, 94, 
  72, 89, 77, 97, 78, 99, 84, 73, 77, 94, 
  97, 90, 87, 85, 71, 81, 77, 92, 89, 86, 
  75, 83, 81, 91, 90, 80, 76, 75, 80, 81, 
  83, 77, 74, 80, 78, 87, 97, 89, 87, 97, 
  98, 85, 75, 94, 85, 81, 83, 75, 96, 98, 
  84, 79, 77, 71, 88, 85, 85, 87, 84, 94, 
  108, 81, 83, 72, 81, 83, 74, 93, 86, 74, 
  84, 88, 87, 83, 89, 82, 91, 81, 82, 88, 
  73, 78, 81, 86, 105, 76, 81, 92, 79, 89, 
  102, 75, 81, 88, 118, 94, 76, 80, 79, 72, 
  93, 78, 97, 82, 100, 87, 90, 82, 81, 82, 
  86, 79, 86, 76, 73, 75, 85, 71, 100, 75, 
  77, 71, 84, 87, 86, 77, 80, 88, 72, 86, 
  78, 110, 83, 91, 88, 84, 79, 83, 100, 100, 
  83, 85, 74, 102, 76, 99, 90, 87, 73, 84, 
  79, 87, 91, 75, 74, 77, 85, 80, 86, 70, 
  79, 79, 81, 72, 97, 72, 75, 108, 93, 87, 
  69, 69, 93, 80, 82, 61, 99, 71, 77, 74, 
  77, 76, 76, 90, 84, 94, 83, 86, 90, 86, 
  83, 74, 82, 84, 78, 89, 81, 78, 87, 92, 
  85, 75, 89, 78, 72, 87, 83, 85, 89, 79, 
  69, 87, 108, 85, 78, 86, 80, 83, 97, 81, 
  86, 81, 120, 85, 76, 71, 75, 83, 124, 84, 
  101, 81, 108, 88, 83, 78, 85, 85, 78, 76, 
  91, 70, 67, 73, 73, 72, 108, 78, 78, 76, 
  79, 70, 85, 73, 86, 96, 72, 96, 82, 122, 
  87, 95, 93, 74, 78, 80, 100, 109, 83, 84, 
  75, 104, 67, 100, 85, 87, 72, 82, 77, 104, 
  83, 83, 74, 82, 82, 77, 90, 67, 72, 78, 
  87, 62, 100, 72, 74, 107, 88, 84, 73, 76, 
  97, 84, 81, 53, 102, 76, 67, 71, 74, 80, 
  72, 102, 81, 102, 90, 83, 83, 80, 75, 73, 
  81, 86, 74, 91, 89, 74, 92, 96, 86, 83, 
  97, 79, 75, 85, 91, 80, 68, 86, 64, 93, 
  111, 83, 78, 94, 74, 75, 87, 79, 86, 81, 
  112, 87, 77, 81, 77, 67, 88, 82, 94, 84, 
  95, 87, 92, 70, 79, 82, 86, 79, 79, 77, 
  72, 78, 79, 75, 93, 77, 72, 80, 85, 74, 
  82, 81, 78, 91, 72, 85, 84, 105, 81, 94, 
  88, 76, 76, 82, 102, 89, 84, 84, 68, 96, 
  76, 100, 88, 84, 75, 83, 78, 88, 90, 75, 
  80, 80, 79, 77, 88, 72, 76, 84, 81, 80, 
  94, 89, 74, 102, 96, 89, 71, 94, 89, 82, 
  79, 70, 97, 89, 78, 79, 82, 80, 85, 89, 
  89, 93, 80, 81, 98, 76, 82, 70, 84, 81, 
  81, 88, 83, 80, 82, 93, 87, 88, 87, 80, 
  95, 85, 83, 81, 62, 79, 80, 86, 104, 81, 
  82, 87, 80, 92, 95, 82, 82, 89, 110, 100, 
  84, 83, 79, 77, 91, 72, 91, 81, 100, 88, 
  92, 77, 85, 81, 87, 70, 83, 81, 76, 78, 
  90, 75, 86, 77, 76, 64, 87, 88, 94, 80, 
  79, 92, 72, 86, 72, 102, 76, 96, 78, 87, 
  75, 90, 94, 91, 84, 81, 71, 83, 69, 90, 
  94, 78, 73, 87, 81, 86, 90, 78, 82, 81, 
  81, 80, 85, 76, 86, 90, 74, 87, 95, 75, 
  75, 100, 85, 79, 67, 72, 88, 81, 84, 75, 
  88, 63, 90, 88, 79, 79, 82, 86, 90, 88, 
  72, 90, 100, 96, 87, 72, 80, 76, 80, 88, 
  77, 80, 85, 82, 83, 84, 86, 86, 75, 85, 
  84, 82, 83, 76, 86, 85, 99, 87, 83, 84, 
  79, 88, 91, 84, 85, 80, 113, 98, 85, 77, 
  77, 87, 117, 84, 94, 82, 103, 87, 87, 74, 
  82, 80, 80, 68, 82, 76, 74, 79, 79, 77, 
  83, 83, 82, 71, 85, 74, 97, 77, 82, 94, 
  77, 86, 80, 108, 79, 97, 82, 72, 75, 90, 
  93, 89, 86, 82, 69, 86, 68, 88, 90, 78, 
  70, 84, 84, 94, 82, 74, 87, 86, 78, 75, 
  82, 72, 81, 87, 77, 78, 95, 77, 78, 97, 
  83, 77, 67, 84, 90, 86, 85, 64, 86, 70, 
  83, 82, 74, 83, 77, 90, 86, 92, 83, 89, 
  98, 87, 84, 73, 82, 81, 81, 91, 83, 78, 
  85, 86, 87, 82, 86, 86, 79, 85, 96, 78, 
  68, 82, 81, 90, 99, 83, 84, 91, 73, 74, 
  85, 79, 86, 80, 106, 93, 82, 83, 77, 70, 
  93, 88, 89, 82, 92, 88, 94, 66, 73, 83, 
  92, 73, 79, 80, 76, 81, 87, 72, 78, 79, 
  75, 74, 86, 75, 90, 82, 76, 90, 75, 88, 
  88, 98, 77, 93, 80, 77, 74, 90, 95, 85, 
  85, 82, 70, 90, 72, 89, 92, 76, 74, 90, 
  81, 90, 88, 76, 91, 85, 77, 82, 87, 77, 
  79, 91, 76, 89, 90, 91, 73, 97, 87, 81, 
  72, 95, 85, 83, 86, 79, 82, 77, 87, 82, 
  82, 81, 82, 86, 90, 88, 77, 86, 105, 80, 
  85, 73, 82, 76, 84, 87, 80, 82, 78, 86, 
  86, 84, 79, 90, 94, 83, 86, 81, 61, 78, 
  85, 84, 97, 82, 81, 89, 85, 89, 97, 87, 
  96, 99, 79, 86, 92, 84, 97, 76, 92, 80, 
  82, 82, 95, 87, 82, 99, 91, 92, 89, 94, 
  86, 68, 79, 85, 59, 77, 78, 71, 88, 69, 
  88, 89, 90, 82, 89, 79, 88, 78, 86, 79, 
  81, 88, 85, 81, 68, 81, 86, 98, 82, 78, 
  111, 88, 77, 75, 85, 88, 62, 82, 72, 85, 
  82, 69, 84, 84, 85, 79, 82, 75, 110, 79, 
  90, 77, 90, 99, 69, 74, 85, 93, 76, 81, 
  79, 92, 75, 72, 93, 65, 86, 78, 78, 105, 
  86, 73, 78, 87, 87, 91, 71, 78, 80, 101, 
  81, 82, 99, 87, 85, 86, 83, 70, 84, 87, 
  98, 97, 97, 81, 88, 76, 90, 84, 88, 76, 
  100, 77, 92, 101, 80, 92, 96, 81, 104, 93, 
  82, 86, 116, 79, 93, 75, 105, 88, 89, 83, 
  97, 90, 82, 86, 101, 122, 82, 101, 81, 63, 
  90, 85, 89, 77, 81, 65, 92, 69, 87, 80, 
  97, 87, 93, 91, 90, 73, 90, 82, 76, 109, 
  102, 84, 49, 87, 90, 123, 86, 77, 112, 97, 
  74, 79, 95, 83, 67, 74, 74, 84, 74, 76, 
  83, 74, 86, 73, 88, 59, 122, 77, 79, 61, 
  95, 87, 76, 71, 94, 96, 87, 89, 64, 88, 
  79, 63, 113, 69, 77, 75, 64, 96, 82, 71, 
  60, 88, 87, 96, 71, 86, 78, 101, 87, 79, 
  107, 82, 86, 100, 93, 69, 84, 81, 98, 93, 
  95, 82, 103, 83, 96, 86, 80, 72, 97, 72, 
  92, 126, 77, 100, 81, 90, 98, 94, 79, 85, 
  102, 83, 98, 72, 89, 83, 89, 89, 97, 91, 
  80, 93, 87, 102, 91, 99, 80, 67, 82, 86, 
  84, 74, 81, 69, 90, 86, 89, 77, 100, 86, 
  84, 87, 88, 78, 95, 80, 79, 101, 94, 99, 
  61, 83, 87, 109, 86, 76, 114, 89, 77, 82, 
  89, 84, 67, 77, 74, 85, 80, 75, 78, 84, 
  87, 67, 94, 64, 116, 79, 92, 74, 93, 72, 
  84, 70, 94, 97, 84, 101, 72, 92, 90, 65, 
  111, 68, 82, 81, 69, 103, 94, 74, 68, 88, 
  87, 94, 69, 101, 83, 99, 86, 80, 99, 88, 
  84, 92, 92, 69, 85, 76, 94, 83, 98, 83, 
  89, 79, 77, 87, 87, 76, 97, 79, 83, 104, 
  90, 79, 85, 86, 85, 97, 65, 90, 82, 83, 
  88, 77, 84, 83, 91, 74, 94, 79, 80, 92, 
  82, 79, 88, 79, 78, 83, 75, 80, 53, 74, 
  81, 86, 82, 75, 87, 94, 74, 83, 74, 69, 
  89, 83, 93, 80, 78, 73, 72, 92, 77, 73, 
  89, 83, 78, 83, 85, 88, 72, 79, 69, 83, 
  71, 87, 73, 82, 76, 74, 86, 106, 85, 66, 
  77, 84, 89, 86, 92, 84, 83, 92, 69, 75, 
  79, 90, 76, 77, 94, 82, 81, 84, 84, 61, 
  86, 85, 89, 101, 83, 84, 87, 88, 80, 77, 
  59, 93, 84, 94, 78, 86, 82, 83, 71, 76, 
  79, 75, 81, 86, 73, 86, 83, 86, 88, 73, 
  80, 86, 92, 83, 88, 81, 85, 77, 101, 82, 
  84, 78, 88, 86, 67, 93, 84, 76, 93, 78, 
  97, 83, 92, 66, 96, 81, 82, 76, 83, 94, 
  84, 80, 72, 83, 88, 75, 79, 86, 84, 83, 
  82, 65, 91, 87, 78, 87, 86, 64, 93, 87, 
  82, 76, 76, 75, 76, 84, 69, 69, 91, 82, 
  75, 81, 79, 94, 74, 84, 75, 80, 65, 84, 
  78, 91, 59, 80, 91, 92, 77, 61, 74, 88, 
  96, 89, 86, 70, 86, 82, 68, 72, 83, 94, 
  81, 94, 94, 81, 78, 77, 82, 62, 78, 80, 
  92, 116, 77, 79, 78, 86, 82, 74, 46, 87, 
  86, 92, 75, 87, 81, 86, 75, 85, 81, 72, 
  88, 74, 82, 92, 82, 82, 97, 71, 82, 85, 
  94, 82, 79, 81, 85, 88, 91, 90, 81, 86, 
  84, 86, 67, 87, 83, 81, 95, 73, 90, 78, 
  90, 78, 92, 83, 83, 82, 84, 82, 96, 80, 
  74, 78, 79, 78, 75, 80, 82, 82, 88, 78, 
  88, 86, 81, 86, 86, 72, 90, 79, 84, 80, 
  78, 79, 74, 91, 74, 77, 91, 92, 77, 79, 
  88, 86, 74, 82, 75, 83, 71, 87, 78, 83, 
  72, 82, 93, 96, 83, 71, 79, 83, 91, 92, 
  86, 83, 85, 79, 63, 73, 82, 92, 82, 105, 
  90, 90, 78, 80, 90, 65, 88, 84, 85, 105, 
  84, 79, 80, 86, 79, 82, 57, 88, 83, 92, 
  77, 83, 79, 88, 68, 80, 81, 70, 83, 77, 
  84, 86, 95, 84, 90, 76, 76, 86, 90, 82, 
  82, 85, 81, 82, 100, 70, 82, 79, 83, 88, 
  73, 83, 77, 81, 83, 86, 87, 78, 96, 84, 
  93, 85, 76, 91, 84, 68, 78, 72, 75, 92, 
  87, 85, 76, 92, 88, 90, 81, 83, 91, 89, 
  86, 86, 69, 74, 86, 79, 106, 80, 93, 63, 
  75, 95, 86, 73, 78, 61, 67, 92, 67, 80, 
  80, 83, 67, 82, 82, 99, 79, 98, 78, 78, 
  89, 114, 95, 79, 82, 82, 88, 88, 94, 87, 
  72, 83, 82, 85, 72, 78, 73, 89, 105, 77, 
  79, 98, 70, 71, 89, 101, 92, 87, 77, 80, 
  89, 87, 86, 80, 66, 92, 78, 91, 82, 83, 
  87, 95, 80, 72, 92, 77, 84, 81, 80, 67, 
  78, 96, 89, 84, 76, 82, 87, 84, 76, 92, 
  89, 57, 99, 75, 80, 79, 73, 86, 70, 85, 
  73, 72, 79, 95, 81, 78, 93, 77, 99, 85, 
  73, 91, 90, 57, 86, 66, 77, 109, 83, 77, 
  112, 94, 88, 86, 75, 77, 90, 96, 83, 81, 
  74, 69, 89, 74, 98, 80, 89, 53, 63, 85, 
  100, 64, 74, 49, 64, 96, 55, 82, 82, 78, 
  57, 79, 81, 102, 95, 88, 76, 73, 95, 117, 
  91, 78, 86, 88, 83, 90, 98, 76, 66, 82, 
  94, 83, 70, 87, 66, 91, 125, 81, 85, 104, 
  59, 66, 81, 98, 96, 92, 83, 85, 91, 83, 
  74, 67, 55, 81, 81, 90, 80, 80, 79, 96, 
  73, 68, 90, 78, 94, 79, 83, 70, 85, 97, 
  78, 82, 77, 81, 84, 84, 64, 100, 86, 49, 
  106, 82, 90, 82, 82, 82, 78, 86, 77, 80, 
  89, 86, 88, 71, 92, 85, 99, 88, 82, 88, 
  99, 66, 94, 73, 77, 93, 84, 85, 102, 87, 
  89, 86, 79, 73, 97, 92, 85, 85, 88, 78, 
  89, 83, 89, 80, 97, 64, 68, 83, 87, 71, 
  81, 66, 66, 87, 69, 82, 80, 79, 66, 82, 
  81, 97, 84, 92, 77, 85, 95, 113, 93, 86, 
  84, 80, 90, 94, 98, 86, 76, 84, 81, 89, 
  68, 81, 71, 85, 113, 83, 77, 99, 70, 71, 
  90, 98, 92, 93, 85, 80, 90, 86, 80, 81, 
  66, 77, 83, 90, 87, 85, 86, 97, 75, 71, 
  88, 81, 88, 77, 87, 78, 98, 98, 90, 83, 
  84, 81, 81, 85, 70, 95, 91, 58, 85, 78, 
  98, 70, 68, 84, 94, 78, 100, 47, 78, 98, 
  93, 98, 63, 69, 84, 86, 69, 95, 87, 87, 
  79, 104, 89, 77, 87, 57, 92, 74, 79, 87, 
  72, 85, 70, 115, 94, 75, 85, 75, 83, 87, 
  91, 67, 81, 91, 88, 79, 64, 93, 85, 89, 
  98, 67, 96, 87, 82, 89, 73, 72, 86, 79, 
  79, 87, 73, 71, 81, 80, 87, 124, 79, 79, 
  76, 74, 85, 72, 89, 76, 75, 72, 81, 77, 
  74, 86, 76, 94, 81, 101, 82, 89, 78, 82, 
  63, 84, 114, 82, 101, 103, 98, 90, 78, 75, 
  78, 72, 113, 84, 82, 79, 75, 89, 89, 80, 
  63, 104, 90, 86, 76, 90, 90, 100, 94, 76, 
  83, 90, 86, 93, 89, 90, 84, 91, 86, 63, 
  60, 78, 85, 74, 105, 30, 71, 101, 92, 87, 
  67, 63, 85, 85, 55, 93, 82, 91, 76, 99, 
  83, 78, 84, 47, 99, 73, 76, 90, 74, 79, 
  71, 82, 96, 71, 84, 80, 86, 84, 87, 67, 
  74, 91, 94, 76, 65, 93, 84, 93, 94, 70, 
  95, 98, 71, 92, 64, 67, 78, 76, 80, 74, 
  76, 71, 82, 76, 81, 116, 107, 78, 67, 69, 
  89, 64, 89, 77, 79, 74, 82, 81, 65, 89, 
  69, 80, 87, 97, 84, 83, 64, 84, 60, 81, 
  111, 81, 110, 105, 77, 95, 75, 77, 64, 69, 
  125, 77, 77, 63, 75, 87, 94, 82, 60, 85, 
  94, 76, 80, 94, 88, 99, 97, 78, 74, 82, 
  88, 97, 83, 88, 83, 86, 83, 88, 86, 83, 
  92, 96, 93, 72, 83, 85, 74, 83, 67, 76, 
  80, 78, 91, 98, 89, 87, 74, 96, 86, 87, 
  90, 89, 75, 71, 87, 87, 68, 101, 71, 72, 
  89, 74, 90, 81, 79, 85, 80, 78, 88, 83, 
  89, 93, 69, 87, 94, 77, 88, 74, 88, 86, 
  81, 91, 81, 78, 90, 91, 80, 77, 68, 77, 
  70, 91, 88, 95, 78, 83, 82, 79, 90, 84, 
  88, 84, 78, 78, 81, 82, 87, 91, 87, 86, 
  107, 106, 81, 79, 85, 79, 70, 84, 126, 86, 
  96, 99, 85, 84, 79, 82, 102, 75, 91, 84, 
  79, 85, 70, 90, 92, 80, 73, 81, 78, 87, 
  93, 89, 91, 94, 89, 81, 85, 99, 84, 89, 
  93, 86, 85, 65, 89, 61, 70, 92, 99, 60, 
  94, 26, 69, 74, 94, 95, 70, 69, 84, 87, 
  43, 85, 104, 87, 88, 99, 89, 77, 91, 33, 
  111, 80, 92, 94, 79, 78, 96, 106, 90, 110, 
  86, 78, 76, 92, 88, 74, 73, 84, 104, 81, 
  75, 80, 85, 86, 104, 70, 89, 101, 69, 78, 
  69, 82, 74, 88, 90, 83, 86, 70, 87, 70, 
  84, 86, 95, 76, 79, 92, 82, 67, 93, 79, 
  79, 79, 90, 78, 64, 79, 71, 95, 76, 87, 
  96, 76, 63, 76, 65, 92, 78, 85, 105, 98, 
  93, 95, 65, 84, 60, 64, 109, 75, 86, 78, 
  73, 92, 97, 89, 61, 92, 83, 74, 69, 101, 
  101, 83, 102, 66, 96, 68, 81, 99, 83, 91, 
  84, 102, 78, 51, 69, 66, 96, 53, 100, 5, 
  61, 78, 112, 94, 73, 66, 87, 91, 28, 87, 
  80, 93, 72, 97, 77, 79, 86, 24, 114, 85, 
  93, 103, 89, 67, 89, 72, 92, 120, 91, 87, 
  76, 96, 100, 75, 66, 79, 110, 75, 77, 78, 
  84, 86, 102, 73, 74, 91, 62, 83, 60, 74, 
  74, 86, 89, 88, 62, 75, 94, 72, 90, 74, 
  84, 75, 71, 88, 91, 51, 92, 75, 77, 84, 
  90, 82, 61, 88, 74, 94, 74, 80, 102, 81, 
  58, 71, 57, 97, 62, 85, 108, 104, 101, 91, 
  65, 75, 40, 64, 102, 63, 76, 62, 76, 91, 
  103, 96, 59, 72, 89, 67, 73, 108, 116, 73, 
  87, 66, 88, 61, 81, 97, 76, 95, 84, 96, 
  79, 79, 81, 91, 87, 73, 89, 48, 77, 73, 
  73, 92, 69, 77, 76, 78, 69, 94, 83, 87, 
  89, 94, 80, 87, 98, 61, 91, 83, 79, 90, 
  69, 92, 79, 63, 96, 93, 85, 83, 78, 86, 
  93, 75, 86, 75, 82, 98, 82, 81, 91, 85, 
  83, 74, 97, 86, 77, 85, 77, 85, 82, 91, 
  87, 78, 87, 77, 75, 76, 76, 81, 101, 83, 
  85, 92, 88, 85, 84, 86, 76, 80, 86, 80, 
  72, 95, 79, 92, 98, 99, 97, 74, 78, 91, 
  75, 82, 109, 89, 103, 94, 84, 84, 78, 81, 
  89, 68, 94, 75, 87, 83, 77, 86, 92, 80, 
  69, 76, 82, 79, 110, 89, 73, 89, 80, 78, 
  82, 87, 81, 95, 81, 88, 89, 68, 70, 78, 
  86, 82, 94, 73, 91, 68, 75, 85, 79, 87, 
  64, 80, 82, 77, 91, 90, 88, 85, 79, 81, 
  93, 82, 93, 63, 86, 84, 84, 78, 71, 90, 
  97, 107, 87, 97, 83, 83, 84, 81, 85, 82, 
  79, 78, 94, 81, 75, 88, 80, 75, 97, 83, 
  90, 92, 70, 75, 72, 80, 80, 93, 93, 86, 
  95, 78, 75, 93, 82, 77, 92, 84, 98, 90, 
  76, 90, 93, 87, 95, 76, 88, 80, 88, 98, 
  84, 84, 77, 98, 82, 81, 83, 88, 74, 81, 
  88, 83, 86, 93, 78, 93, 77, 93, 96, 73, 
  67, 90, 86, 89, 83, 86, 82, 88, 78, 100, 
  88, 77, 78, 104, 91, 88, 82, 73, 99, 84, 
  84, 98, 83, 83, 89, 84, 73, 72, 82, 71, 
  89, 65, 91, 56, 74, 84, 86, 90, 65, 81, 
  83, 74, 85, 93, 74, 92, 83, 74, 83, 82, 
  90, 52, 89, 100, 78, 78, 75, 80, 84, 93, 
  87, 96, 88, 84, 92, 80, 78, 79, 75, 69, 
  87, 77, 79, 91, 80, 87, 96, 82, 87, 82, 
  68, 82, 69, 81, 82, 97, 99, 82, 92, 88, 
  75, 90, 79, 85, 82, 88, 95, 88, 73, 80, 
  94, 85, 90, 73, 89, 79, 76, 100, 92, 88, 
  84, 102, 78, 67, 68, 79, 74, 72, 82, 82, 
  89, 95, 79, 87, 77, 93, 86, 70, 57, 86, 
  78, 79, 74, 81, 80, 89, 69, 89, 97, 72, 
  105, 102, 89, 83, 82, 75, 92, 81, 82, 91, 
  73, 86, 88, 88, 70, 87, 91, 87, 89, 86, 
  88, 75, 79, 88, 81, 95, 61, 83, 75, 76, 
  88, 90, 88, 78, 83, 86, 86, 80, 97, 80, 
  76, 91, 86, 80, 69, 88, 77, 82, 87, 94, 
  89, 84, 84, 80, 89, 83, 88, 79, 88, 92, 
  82, 85, 89, 77, 88, 85, 90, 78, 81, 77, 
  75, 77, 80, 86, 91, 81, 88, 81, 70, 90, 
  76, 70, 85, 86, 92, 87, 82, 89, 88, 81, 
  80, 77, 83, 84, 91, 93, 76, 85, 93, 90, 
  86, 77, 95, 90, 78, 79, 96, 81, 91, 90, 
  89, 73, 76, 81, 102, 77, 72, 86, 87, 90, 
  84, 88, 85, 85, 86, 85, 84, 82, 104, 101, 
  85, 90, 87, 83, 83, 95, 80, 95, 83, 85, 
  75, 82, 95, 72, 71, 84, 79, 77, 70, 81, 
  76, 93, 77, 83, 82, 68, 73, 79, 78, 85, 
  90, 72, 86, 81, 73, 99, 71, 79, 105, 92, 
  93, 95, 77, 85, 66, 84, 94, 72, 78, 75, 
  55, 72, 84, 82, 93, 57, 82, 89, 96, 69, 
  78, 71, 84, 85, 67, 86, 79, 83, 87, 71, 
  125, 92, 88, 86, 92, 80, 77, 88, 76, 78, 
  75, 93, 84, 81, 75, 81, 88, 86, 96, 95, 
  80, 97, 81, 104, 87, 95, 92, 100, 81, 92, 
  77, 79, 92, 86, 79, 100, 87, 83, 87, 82, 
  62, 90, 92, 92, 80, 91, 77, 80, 92, 74, 
  89, 74, 76, 78, 88, 93, 92, 97, 87, 92, 
  86, 77, 70, 88, 77, 84, 82, 59, 71, 74, 
  81, 66, 70, 76, 82, 74, 61, 71, 75, 99, 
  80, 84, 84, 70, 68, 80, 71, 89, 82, 62, 
  87, 76, 74, 109, 62, 69, 106, 85, 103, 83, 
  70, 92, 79, 84, 104, 59, 79, 75, 58, 69, 
  95, 88, 100, 57, 79, 77, 94, 66, 83, 66, 
  79, 88, 53, 87, 78, 81, 95, 71, 122, 87, 
  95, 84, 83, 83, 76, 92, 81, 63, 81, 99, 
  81, 82, 78, 81, 81, 93, 108, 90, 81, 107, 
  71, 87, 101, 95, 92, 101, 80, 92, 77, 86, 
  93, 83, 75, 111, 77, 82, 80, 74, 54, 85, 
  84, 94, 76, 95, 74, 82, 87, 68, 100, 72, 
  73, 85, 93, 101, 72, 88, 81, 96, 86, 72, 
  65, 79, 74, 85, 89, 52, 79, 64, 75, 80, 
  78, 82, 80, 81, 76, 82, 77, 90, 83, 84, 
  85, 72, 76, 77, 79, 81, 82, 68, 89, 83, 
  78, 95, 77, 81, 98, 79, 85, 83, 80, 71, 
  84, 95, 87, 73, 78, 76, 64, 76, 84, 89, 
  100, 69, 89, 89, 88, 75, 83, 79, 86, 80, 
  69, 80, 82, 79, 94, 72, 111, 85, 85, 84, 
  91, 80, 78, 85, 79, 73, 91, 97, 87, 79, 
  77, 84, 95, 97, 98, 92, 81, 91, 80, 79, 
  79, 87, 85, 92, 88, 92, 79, 95, 96, 87, 
  89, 96, 89, 83, 78, 89, 64, 87, 92, 91, 
  79, 90, 79, 84, 91, 79, 85, 78, 79, 92, 
  90, 89, 78, 96, 91, 86, 91, 74, 78, 92, 
  77, 83, 83, 69, 78, 82, 84, 73, 88, 83, 
  100, 73, 79, 82, 84, 88, 79, 107, 93, 70, 
  67, 81, 90, 79, 99, 81, 77, 88, 74, 82, 
  80, 84, 91, 84, 90, 83, 88, 89, 68, 78, 
  75, 70, 60, 70, 81, 79, 79, 90, 92, 64, 
  88, 82, 78, 68, 83, 82, 77, 86, 66, 73, 
  76, 71, 85, 82, 111, 94, 78, 84, 78, 82, 
  77, 87, 76, 60, 72, 87, 79, 73, 86, 87, 
  84, 90, 78, 92, 70, 87, 85, 83, 79, 92, 
  86, 93, 84, 86, 84, 75, 76, 82, 73, 96, 
  78, 87, 87, 87, 59, 89, 90, 83, 87, 80, 
  88, 81, 105, 71, 87, 84, 79, 86, 85, 91, 
  94, 86, 98, 84, 89, 80, 76, 84, 80, 91, 
  80, 79, 80, 85, 73, 80, 81, 78, 99, 72, 
  92, 88, 83, 91, 87, 77, 94, 77, 65, 89, 
  92, 77, 84, 72, 83, 98, 79, 70, 90, 90, 
  84, 77, 84, 88, 86, 88, 69, 72, 82, 72, 
  80, 64, 81, 85, 93, 89, 96, 72, 96, 83, 
  71, 69, 86, 75, 82, 85, 64, 88, 78, 71, 
  85, 80, 118, 87, 76, 87, 69, 86, 77, 83, 
  75, 58, 73, 90, 81, 78, 84, 89, 87, 89, 
  74, 86, 71, 86, 87, 80, 64, 92, 81, 89, 
  85, 94, 87, 76, 74, 79, 69, 88, 74, 92, 
  84, 90, 57, 83, 97, 86, 106, 79, 89, 79, 
  106, 76, 81, 75, 89, 84, 76, 88, 93, 82, 
  96, 86, 94, 72, 72, 89, 72, 85, 88, 82, 
  80, 81, 73, 77, 84, 78, 93, 76, 81, 82, 
  81, 83, 80, 63, 91, 73, 71, 76, 85, 80, 
  76, 79, 83, 91, 86, 85, 79, 87, 85, 86, 
  78, 89, 86, 84, 76, 93, 78, 69, 103, 72, 
  86, 77, 94, 94, 94, 66, 91, 93, 79, 74, 
  85, 78, 80, 85, 73, 98, 78, 74, 87, 80, 
  96, 88, 73, 80, 81, 78, 81, 89, 76, 64, 
  91, 86, 82, 74, 81, 89, 83, 83, 87, 88, 
  74, 88, 82, 78, 79, 92, 86, 89, 85, 86, 
  86, 78, 79, 85, 77, 93, 77, 86, 76, 85, 
  62, 88, 86, 81, 87, 84, 85, 83, 99, 79, 
  84, 84, 83, 87, 69, 84, 92, 85, 94, 85, 
  81, 77, 83, 87, 82, 86, 79, 82, 94, 87, 
  90, 91, 98, 94, 91, 75, 90, 84, 84, 74, 
  88, 86, 85, 79, 70, 84, 97, 84, 86, 102, 
  81, 97, 86, 74, 107, 90, 87, 87, 70, 89, 
  102, 83, 89, 94, 78, 81, 67, 82, 95, 87, 
  70, 91, 91, 89, 98, 77, 57, 90, 72, 95, 
  80, 83, 93, 81, 77, 73, 93, 80, 88, 94, 
  72, 82, 83, 80, 77, 83, 74, 80, 95, 74, 
  85, 67, 91, 81, 73, 86, 74, 82, 79, 71, 
  97, 82, 75, 85, 81, 77, 89, 85, 82, 80, 
  72, 76, 90, 79, 84, 78, 97, 92, 74, 90, 
  86, 75, 97, 84, 96, 83, 113, 95, 80, 92, 
  88, 86, 74, 80, 98, 74, 93, 82, 95, 87, 
  92, 85, 91, 92, 81, 93, 99, 94, 92, 104, 
  84, 87, 86, 77, 103, 96, 83, 72, 100, 78, 
  94, 84, 73, 86, 99, 82, 73, 110, 85, 104, 
  93, 62, 119, 104, 76, 89, 62, 95, 109, 76, 
  96, 82, 87, 94, 77, 82, 94, 95, 80, 86, 
  85, 94, 103, 85, 49, 100, 76, 96, 86, 80, 
  93, 80, 74, 68, 96, 78, 83, 88, 71, 87, 
  79, 87, 74, 78, 70, 81, 84, 71, 94, 72, 
  86, 77, 77, 75, 69, 79, 82, 72, 101, 91, 
  58, 86, 76, 67, 83, 90, 76, 81, 70, 74, 
  86, 71, 89, 82, 97, 92, 73, 73, 87, 75, 
  108, 88, 99, 76, 109, 103, 79, 91, 93, 77, 
  77, 80, 104, 72, 92, 82, 88, 85, 92, 85, 
  89, 83, 79, 98, 91, 102, 85, 90, 84, 87, 
  91, 82, 91, 89, 83, 78, 88, 76, 83, 81, 
  75, 81, 95, 82, 73, 99, 88, 95, 96, 79, 
  100, 87, 78, 88, 69, 94, 101, 90, 88, 86, 
  80, 81, 91, 79, 100, 85, 84, 91, 83, 84, 
  95, 87, 70, 91, 74, 97, 84, 84, 93, 82, 
  79, 79, 89, 82, 86, 87, 75, 79, 85, 83, 
  82, 84, 77, 82, 88, 80, 84, 68, 84, 87, 
  74, 75, 74, 83, 84, 73, 92, 89, 79, 93, 
  91, 74, 88, 89, 81, 85, 74, 80, 91, 80, 
  81, 78, 87, 88, 74, 83, 85, 76, 94, 85, 
  89, 82, 103, 90, 80, 86, 89, 81, 76, 86, 
  105, 76, 92, 83, 79, 86, 91, 87, 92, 92, 
  80, 85, 93, 84, 73, 92, 86, 71, 83, 81, 
  80, 90, 79, 71, 75, 95, 80, 105, 92, 73, 
  79, 92, 67, 73, 77, 91, 81, 82, 74, 79, 
  87, 86, 100, 74, 84, 88, 104, 72, 82, 83, 
  81, 80, 81, 80, 86, 96, 72, 108, 115, 82, 
  89, 82, 75, 69, 87, 96, 80, 99, 91, 94, 
  98, 82, 93, 114, 97, 90, 74, 69, 101, 76, 
  136, 74, 80, 57, 68, 84, 75, 82, 80, 69, 
  86, 79, 97, 88, 86, 73, 94, 95, 81, 78, 
  94, 74, 67, 86, 82, 84, 70, 66, 79, 86, 
  98, 75, 73, 83, 89, 81, 99, 91, 84, 83, 
  97, 76, 70, 81, 85, 74, 86, 88, 83, 77, 
  79, 85, 88, 80, 91, 85, 92, 97, 79, 85, 
  88, 88, 51, 82, 75, 70, 86, 82, 85, 88, 
  87, 76, 95, 102, 86, 74, 83, 81, 82, 76, 
  93, 81, 81, 95, 72, 87, 70, 82, 87, 79, 
  89, 79, 77, 92, 103, 73, 84, 87, 72, 79, 
  73, 91, 89, 89, 75, 89, 71, 98, 91, 87, 
  83, 78, 85, 91, 70, 100, 96, 75, 83, 86, 
  88, 93, 89, 90, 65, 73, 83, 85, 107, 72, 
  70, 77, 74, 82, 75, 79, 87, 70, 77, 82, 
  85, 86, 89, 65, 92, 77, 77, 77, 77, 86, 
  63, 83, 78, 96, 64, 73, 86, 81, 104, 81, 
  71, 92, 86, 82, 91, 83, 88, 89, 95, 79, 
  68, 80, 87, 78, 73, 71, 64, 86, 90, 90, 
  74, 79, 77, 91, 81, 88, 88, 90, 83, 88, 
  66, 80, 71, 99, 84, 80, 84, 89, 96, 78, 
  93, 87, 85, 71, 80, 103, 84, 81, 100, 75, 
  83, 93, 76, 90, 79, 89, 89, 81, 86, 87, 
  76, 83, 94, 81, 85, 81, 78, 81, 76, 89, 
  84, 79, 84, 80, 63, 88, 92, 86, 86, 87, 
  87, 90, 73, 88, 84, 81, 73, 79, 86, 79, 
  90, 79, 87, 91, 81, 85, 83, 82, 84, 85, 
  90, 82, 80, 76, 85, 86, 83, 101, 83, 82, 
  81, 81, 81, 74, 76, 87, 81, 94, 72, 85, 
  77, 93, 85, 84, 88, 92, 84, 91, 84, 99, 
  85, 83, 77, 85, 78, 85, 86, 89, 79, 80, 
  93, 88, 77, 79, 66, 82, 85, 100, 83, 83, 
  77, 88, 82, 85, 98, 89, 89, 80, 78, 75, 
  75, 57, 82, 80, 81, 101, 70, 87, 65, 96, 
  73, 91, 78, 70, 66, 95, 79, 102, 105, 83, 
  89, 64, 79, 76, 89, 65, 64, 72, 92, 75, 
  89, 77, 82, 84, 86, 77, 100, 76, 95, 80, 
  100, 111, 97, 93, 92, 87, 81, 60, 85, 73, 
  111, 86, 120, 64, 158, 69, 74, 147, 106, 76, 
  86, 78, 85, 101, 104, 78, 73, 56, 101, 67, 
  65, 118, 80, 60, 81, 77, 78, 72, 104, 85, 
  75, 76, 81, 78, 74, 82, 73, 93, 94, 76, 
  78, 55, 70, 86, 95, 116, 73, 78, 92, 84, 
  98, 99, 93, 76, 82, 85, 59, 73, 85, 80, 
  78, 101, 77, 86, 76, 92, 70, 65, 87, 87, 
  86, 73, 75, 83, 101, 85, 67, 87, 74, 58, 
  79, 83, 89, 88, 83, 80, 100, 100, 76, 77, 
  78, 82, 79, 77, 112, 96, 104, 82, 75, 83, 
  71, 80, 91, 77, 71, 87, 78, 97, 85, 81, 
  88, 83, 88, 87, 81, 96, 72, 92, 85, 83, 
  68, 127, 87, 91, 83, 97, 87, 87, 86, 84, 
  91, 64, 103, 77, 68, 86, 92, 66, 73, 72, 
  72, 89, 83, 85, 89, 81, 76, 76, 57, 87, 
  84, 57, 63, 84, 80, 77, 94, 79, 96, 73, 
  87, 87, 67, 86, 62, 75, 84, 82, 77, 74, 
  89, 83, 83, 94, 73, 82, 81, 82, 79, 77, 
  93, 86, 91, 80, 76, 78, 79, 91, 84, 83, 
  77, 90, 79, 84, 79, 75, 89, 88, 86, 71, 
  74, 82, 93, 93, 78, 91, 71, 90, 87, 81, 
  82, 85, 90, 82, 105, 78, 92, 73, 84, 106, 
  89, 88, 101, 80, 87, 89, 78, 96, 75, 85, 
  96, 82, 99, 96, 81, 91, 93, 87, 85, 88, 
  84, 83, 71, 93, 83, 87, 84, 74, 75, 93, 
  88, 89, 90, 95, 91, 98, 73, 81, 73, 80, 
  60, 83, 85, 72, 79, 71, 79, 89, 90, 79, 
  78, 73, 82, 83, 79, 83, 81, 63, 82, 94, 
  74, 95, 87, 85, 80, 80, 90, 88, 81, 91, 
  80, 92, 69, 68, 67, 82, 79, 90, 93, 94, 
  70, 81, 81, 91, 86, 84, 79, 69, 88, 92, 
  90, 91, 93, 80, 91, 89, 76, 79, 74, 88, 
  87, 87, 87, 90, 77, 89, 84, 80, 97, 89, 
  100, 92, 79, 77, 76, 60, 72, 88, 86, 92, 
  82, 89, 79, 90, 64, 87, 75, 90, 84, 90, 
  74, 97, 112, 76, 84, 79, 76, 77, 83, 75, 
  84, 86, 77, 73, 87, 94, 82, 85, 90, 78, 
  83, 79, 94, 99, 83, 69, 93, 96, 86, 82, 
  82, 80, 85, 79, 92, 81, 95, 83, 113, 90, 
  75, 104, 112, 85, 76, 68, 76, 99, 78, 99, 
  60, 64, 97, 79, 73, 96, 92, 55, 80, 71, 
  84, 74, 93, 92, 84, 84, 83, 88, 89, 88, 
  81, 90, 98, 80, 90, 79, 81, 78, 81, 84, 
  88, 78, 98, 85, 80, 79, 100, 80, 114, 93, 
  77, 87, 81, 86, 94, 81, 90, 84, 82, 96, 
  74, 82, 100, 83, 87, 72, 82, 79, 98, 81, 
  86, 90, 74, 71, 79, 80, 92, 84, 82, 71, 
  101, 79, 81, 79, 76, 89, 79, 73, 81, 90, 
  102, 84, 88, 89, 74, 82, 83, 84, 92, 98, 
  64, 92, 85, 91, 94, 88, 87, 85, 78, 92, 
  79, 97, 72, 71, 94, 103, 82, 87, 86, 94, 
  90, 87, 80, 60, 74, 83, 84, 96, 77, 81, 
  90, 72, 79, 64, 82, 77, 81, 82, 90, 83, 
  83, 84, 69, 74, 83, 69, 69, 81, 86, 78, 
  83, 79, 91, 87, 87, 89, 81, 85, 55, 78, 
  80, 88, 74, 88, 87, 78, 61, 79, 77, 68, 
  86, 80, 81, 69, 88, 84, 100, 91, 97, 85, 
  81, 89, 95, 81, 78, 87, 81, 80, 90, 81, 
  98, 87, 91, 70, 81, 78, 90, 82, 84, 92, 
  67, 79, 87, 74, 79, 85, 87, 74, 91, 68, 
  97, 69, 83, 103, 88, 86, 84, 89, 95, 96, 
  82, 84, 77, 84, 82, 84, 97, 99, 81, 95, 
  89, 85, 94, 88, 88, 78, 83, 89, 82, 86, 
  74, 73, 91, 92, 84, 86, 90, 89, 88, 90, 
  75, 71, 75, 90, 75, 84, 92, 86, 79, 80, 
  90, 88, 92, 75, 81, 78, 76, 80, 89, 78, 
  81, 68, 81, 87, 77, 95, 90, 80, 74, 79, 
  79, 95, 79, 88, 81, 85, 67, 76, 76, 82, 
  71, 93, 84, 92, 65, 83, 78, 87, 82, 82, 
  89, 80, 83, 89, 69, 96, 93, 87, 90, 82, 
  82, 88, 88, 91, 88, 85, 88, 87, 73, 92, 
  78, 79, 95, 87, 83, 72, 104, 86, 75, 86, 
  73, 81, 80, 78, 89, 84, 70, 74, 76, 82, 
  85, 77, 82, 76, 85, 81, 100, 90, 61, 72, 
  87, 75, 76, 82, 90, 80, 85, 74, 79, 106, 
  97, 75, 83, 77, 88, 74, 76, 70, 97, 75, 
  89, 60, 89, 78, 87, 80, 81, 79, 90, 89, 
  79, 69, 74, 122, 77, 77, 82, 83, 88, 86, 
  94, 102, 79, 90, 83, 105, 83, 88, 78, 83, 
  77, 97, 80, 77, 82, 82, 81, 75, 67, 98, 
  78, 90, 89, 105, 82, 94, 86, 132, 82, 90, 
  86, 92, 96, 92, 74, 78, 80, 71, 93, 94, 
  95, 68, 87, 75, 90, 90, 75, 83, 78, 101, 
  84, 96, 80, 85, 92, 66, 71, 94, 78, 79, 
  69, 87, 84, 71, 75, 77, 72, 83, 72, 77, 
  69, 66, 84, 73, 68, 76, 69, 79, 86, 71, 
  73, 45, 78, 83, 83, 94, 69, 74, 85, 63, 
  103, 74, 95, 87, 83, 75, 80, 74, 76, 68, 
  80, 70, 77, 70, 91, 65, 95, 81, 90, 77, 
  85, 71, 69, 92, 78, 82, 85, 82, 71, 68, 
  74, 116, 83, 82, 69, 106, 77, 85, 90, 102, 
  73, 87, 93, 96, 72, 94, 70, 75, 72, 61, 
  82, 78, 81, 71, 84, 83, 72, 85, 75, 89, 
  77, 106, 65, 96, 94, 139, 85, 95, 97, 92, 
  81, 89, 66, 106, 71, 71, 104, 94, 95, 55, 
  91, 76, 91, 106, 66, 75, 90, 113, 74, 104, 
  85, 80, 97, 59, 64, 86, 75, 83, 62, 77, 
  79, 85, 82, 90, 80, 100, 76, 87, 87, 90, 
  85, 95, 70, 87, 77, 83, 85, 79, 81, 65, 
  81, 78, 88, 86, 84, 74, 85, 83, 77, 93, 
  80, 90, 88, 97, 90, 89, 91, 83, 78, 86, 
  84, 81, 93, 84, 98, 79, 91, 107, 86, 85, 
  87, 94, 89, 78, 80, 76, 84, 73, 79, 103, 
  81, 83, 87, 65, 87, 88, 72, 94, 81, 69, 
  83, 92, 83, 74, 73, 84, 84, 71, 80, 76, 
  91, 82, 79, 95, 78, 90, 92, 85, 96, 100, 
  89, 101, 86, 108, 102, 81, 72, 86, 81, 90, 
  78, 75, 82, 78, 87, 93, 88, 79, 72, 80, 
  94, 79, 77, 89, 82, 92, 94, 87, 88, 74, 
  85, 72, 81, 89, 86, 76, 73, 95, 80, 62, 
  94, 74, 75, 83, 71, 83, 80, 60, 83, 87, 
  75, 82, 74, 93, 94, 83, 85, 73, 84, 58, 
  106, 96, 61, 75, 85, 67, 106, 78, 84, 80, 
  83, 79, 71, 119, 84, 80, 78, 79, 80, 73, 
  79, 64, 78, 91, 89, 77, 82, 61, 83, 75, 
  73, 84, 86, 86, 79, 53, 68, 147, 89, 95, 
  84, 73, 90, 64, 78, 100, 99, 100, 104, 96, 
  98, 82, 73, 77, 64, 79, 76, 89, 80, 76, 
  82, 102, 73, 88, 72, 91, 83, 101, 72, 77, 
  73, 131, 88, 84, 89, 88, 92, 80, 53, 90, 
  77, 83, 94, 83, 91, 51, 90, 77, 93, 89, 
  59, 90, 80, 78, 65, 109, 87, 72, 86, 51, 
  70, 83, 86, 78, 76, 77, 65, 69, 81, 62, 
  64, 78, 67, 77, 66, 42, 80, 83, 67, 80, 
  70, 91, 104, 71, 73, 44, 78, 53, 79, 90, 
  62, 83, 78, 55, 124, 79, 83, 78, 75, 73, 
  68, 84, 65, 93, 81, 63, 70, 67, 82, 60, 
  72, 76, 81, 70, 80, 50, 83, 74, 66, 88, 
  68, 85, 69, 54, 59, 176, 101, 86, 68, 86, 
  77, 59, 74, 109, 97, 77, 81, 109, 89, 82, 
  75, 73, 43, 74, 73, 94, 80, 88, 78, 106, 
  86, 92, 70, 88, 77, 94, 64, 78, 61, 137, 
  76, 86, 97, 88, 77, 75, 45, 87, 60, 85, 
  105, 74, 92, 41, 87, 72, 102, 87, 45, 72, 
  80, 80, 82, 125, 91, 67, 102, 39, 62, 75, 
  90, 81, 86, 65, 79, 89, 90, 88, 86, 100, 
  75, 83, 85, 78, 78, 97, 70, 85, 81, 91, 
  93, 83, 82, 69, 79, 77, 73, 91, 79, 70, 
  82, 77, 98, 97, 76, 86, 88, 92, 81, 80, 
  82, 80, 79, 89, 86, 88, 86, 81, 85, 96, 
  90, 83, 97, 81, 83, 88, 83, 76, 88, 88, 
  85, 60, 73, 102, 92, 92, 95, 65, 80, 73, 
  68, 96, 82, 91, 75, 84, 93, 80, 76, 83, 
  85, 83, 70, 75, 87, 66, 79, 95, 80, 85, 
  99, 104, 86, 93, 80, 102, 82, 105, 115, 80, 
  81, 85, 85, 80, 65, 75, 79, 82, 84, 90, 
  83, 73, 82, 87, 100, 88, 73, 83, 74, 89, 
  114, 93, 84, 79, 95, 65, 84, 85, 82, 86, 
  75, 90, 90, 76, 84, 91, 78, 76, 70, 82, 
  80, 74, 76, 81, 83, 92, 77, 91, 95, 91, 
  91, 85, 86, 75, 85, 112, 76, 72, 103, 81, 
  81, 73, 94, 86, 78, 81, 93, 104, 88, 81, 
  86, 83, 89, 76, 78, 74, 69, 91, 93, 82, 
  89, 77, 78, 76, 78, 79, 84, 85, 74, 73, 
  83, 115, 81, 100, 94, 85, 93, 69, 74, 81, 
  89, 113, 92, 80, 107, 87, 78, 76, 84, 93, 
  86, 75, 81, 79, 98, 91, 76, 86, 75, 104, 
  83, 86, 75, 76, 83, 121, 84, 67, 85, 84, 
  92, 79, 58, 87, 95, 78, 76, 80, 92, 70, 
  79, 92, 83, 92, 75, 86, 84, 97, 70, 80, 
  90, 93, 84, 67, 70, 90, 83, 74, 77, 93, 
  82, 76, 85, 84, 69, 76, 70, 79, 72, 62, 
  80, 75, 70, 93, 87, 95, 101, 82, 87, 62, 
  79, 71, 75, 103, 73, 74, 101, 70, 101, 95, 
  87, 71, 75, 71, 80, 87, 78, 96, 94, 71, 
  83, 73, 82, 73, 65, 77, 80, 80, 89, 71, 
  83, 80, 72, 81, 77, 84, 68, 75, 75, 138, 
  89, 91, 78, 93, 94, 70, 67, 82, 91, 89, 
  87, 91, 100, 83, 75, 72, 72, 80, 83, 78, 
  81, 88, 100, 97, 88, 96, 75, 108, 69, 80, 
  62, 71, 75, 119, 78, 64, 95, 91, 81, 77, 
  58, 90, 88, 77, 69, 78, 97, 52, 68, 87, 
  87, 87, 63, 77, 80, 79, 90, 90, 82, 90, 
  91, 57, 61, 89, 80, 78, 83, 85, 83, 88, 
  81, 92, 87, 93, 79, 85, 83, 85, 76, 89, 
  78, 83, 75, 88, 95, 87, 87, 76, 81, 73, 
  71, 105, 83, 73, 96, 92, 77, 103, 83, 80, 
  84, 95, 75, 81, 90, 79, 87, 92, 94, 89, 
  86, 89, 76, 100, 100, 88, 92, 79, 79, 83, 
  87, 80, 93, 87, 79, 75, 86, 91, 85, 97, 
  100, 63, 79, 74, 69, 86, 85, 103, 85, 77, 
  91, 83, 86, 82, 95, 77, 76, 70, 89, 74, 
  95, 85, 78, 80, 93, 103, 88, 82, 87, 87, 
  90, 99, 104, 74, 79, 79, 100, 78, 66, 102, 
  88, 77, 76, 83, 76, 90, 83, 96, 91, 90, 
  85, 77, 91, 95, 92, 81, 89, 88, 85, 75, 
  89, 86, 87, 86, 76, 93, 85, 82, 99, 89, 
  84, 80, 80, 94, 92, 70, 85, 88, 98, 76, 
  74, 83, 99, 97, 97, 89, 47, 74, 96, 95, 
  100, 69, 81, 84, 88, 90, 75, 87, 99, 75, 
  84, 87, 71, 81, 91, 86, 69, 82, 97, 84, 
  82, 83, 105, 70, 76, 93, 90, 97, 83, 84, 
  96, 89, 89, 94, 90, 81, 78, 82, 73, 77, 
  69, 98, 95, 82, 89, 93, 91, 80, 95, 67, 
  84, 80, 82, 95, 60, 91, 87, 84, 90, 99, 
  79, 87, 78, 88, 91, 76, 94, 77, 93, 84, 
  92, 71, 94, 96, 80, 99, 78, 88, 75, 97, 
  84, 103, 81, 79, 71, 84, 74, 86, 85, 85, 
  73, 85, 82, 98, 93, 77, 89, 88, 84, 83, 
  97, 79, 85, 81, 75, 83, 113, 95, 93, 81, 
  80, 79, 84, 84, 78, 79, 74, 101, 74, 80, 
  69, 70, 75, 92, 76, 70, 99, 101, 86, 82, 
  79, 81, 109, 106, 78, 89, 72, 84, 77, 102, 
  79, 87, 86, 73, 80, 66, 66, 71, 88, 89, 
  90, 73, 103, 68, 81, 70, 79, 72, 76, 69, 
  85, 85, 80, 78, 86, 98, 89, 73, 55, 74, 
  93, 79, 80, 90, 82, 99, 92, 77, 85, 72, 
  87, 94, 69, 83, 80, 92, 81, 101, 91, 100, 
  83, 95, 79, 82, 74, 79, 99, 83, 92, 77, 
  90, 84, 66, 69, 68, 66, 77, 96, 79, 87, 
  78, 78, 73, 68, 102, 78, 67, 84, 80, 82, 
  108, 90, 73, 79, 81, 81, 73, 79, 77, 94, 
  73, 74, 77, 66, 97, 85, 86, 84, 80, 75, 
  83, 84, 78, 81, 91, 100, 71, 74, 68, 77, 
  82, 89, 90, 68, 79, 98, 73, 80, 92, 85, 
  83, 95, 82, 90, 80, 75, 86, 98, 93, 84, 
  88, 78, 85, 70, 73, 76, 100, 84, 75, 76, 
  96, 77, 83, 78, 82, 72, 77, 80, 85, 87, 
  80, 85, 97, 91, 102, 67, 69, 76, 87, 79, 
  74, 83, 86, 92, 96, 88, 78, 71, 90, 103, 
  88, 83, 84, 98, 82, 92, 88, 92, 91, 83, 
  81, 89, 84, 96, 99, 81, 85, 82, 91, 89, 
  76, 70, 75, 73, 91, 89, 84, 92, 84, 81, 
  85, 80, 101, 78, 76, 88, 87, 91, 86, 89, 
  74, 95, 104, 81, 77, 84, 82, 107, 76, 85, 
  78, 79, 109, 95, 88, 74, 70, 80, 82, 83, 
  77, 73, 87, 97, 72, 81, 91, 75, 78, 89, 
  81, 66, 100, 91, 95, 81, 75, 83, 118, 101, 
  78, 95, 72, 84, 71, 94, 88, 85, 95, 95, 
  84, 73, 61, 74, 75, 79, 88, 83, 105, 73, 
  75, 68, 76, 72, 73, 81, 80, 88, 78, 78, 
  89, 90, 84, 66, 53, 77, 96, 86, 91, 83, 
  68, 85, 96, 74, 85, 74, 86, 85, 74, 85, 
  79, 87, 77, 99, 91, 98, 85, 100, 75, 66, 
  76, 74, 97, 84, 93, 71, 89, 91, 78, 76, 
  70, 79, 81, 93, 85, 96, 76, 82, 66, 66, 
  79, 80, 68, 91, 75, 88, 93, 96, 78, 72, 
  94, 79, 71, 81, 82, 92, 76, 69, 70, 64, 
  105, 85, 90, 75, 78, 66, 82, 90, 78, 76, 
  75, 107, 80, 76, 77, 67, 73, 85, 116, 70, 
  88, 93, 78, 82, 79, 83, 108, 97, 85, 89, 
  67, 78, 66, 85, 85, 80, 86, 76, 97, 68, 
  48, 70, 79, 82, 78, 80, 92, 78, 74, 74, 
  75, 66, 62, 76, 71, 81, 77, 84, 98, 79, 
  88, 66, 45, 67, 92, 74, 75, 70, 65, 89, 
  87, 87, 84, 76, 96, 88, 79, 82, 80, 91, 
  82, 85, 85, 96, 89, 99, 76, 80, 64, 70, 
  90, 79, 82, 78, 89, 88, 75, 67, 66, 65, 
  90, 85, 87, 84, 83, 87, 74, 64, 94, 76, 
  65, 80, 81, 72, 93, 83, 69, 86, 94, 75, 
  74, 77, 75, 95, 78, 75, 79, 68, 85, 77, 
  85, 83, 85, 72, 92, 77, 87, 78, 94, 88, 
  92, 73, 85, 91, 93, 83, 106, 82, 79, 92, 
  71, 69, 88, 86, 92, 86, 96, 95, 94, 67, 
  84, 79, 93, 81, 91, 82, 92, 77, 79, 84, 
  96, 81, 79, 80, 78, 91, 81, 96, 86, 82, 
  85, 95, 89, 87, 86, 93, 92, 82, 96, 71, 
  71, 90, 76, 84, 69, 77, 84, 79, 89, 91, 
  82, 78, 92, 90, 87, 82, 89, 85, 81, 77, 
  85, 79, 85, 85, 85, 90, 84, 74, 85, 79, 
  77, 78, 91, 99, 85, 80, 77, 89, 95, 78, 
  82, 91, 90, 89, 85, 89, 88, 84, 88, 87, 
  72, 86, 76, 85, 82, 94, 107, 88, 89, 84, 
  88, 92, 88, 97, 80, 80, 96, 87, 85, 95, 
  78, 74, 73, 86, 80, 79, 90, 98, 66, 78, 
  86, 73, 85, 87, 119, 70, 88, 91, 83, 83, 
  79, 83, 93, 88, 88, 101, 76, 87, 68, 104, 
  86, 80, 96, 100, 93, 65, 55, 73, 72, 79, 
  85, 89, 103, 75, 80, 76, 74, 69, 73, 86, 
  75, 88, 77, 81, 98, 92, 93, 65, 72, 72, 
  90, 83, 97, 73, 82, 86, 93, 83, 84, 73, 
  80, 101, 73, 87, 80, 86, 78, 88, 93, 101, 
  91, 96, 87, 70, 76, 77, 95, 80, 87, 73, 
  88, 87, 82, 73, 65, 89, 85, 93, 85, 86, 
  81, 86, 82, 67, 79, 79, 65, 91, 73, 83, 
  90, 84, 73, 73, 109, 76, 76, 78, 82, 94, 
  79, 77, 82, 69, 80, 86, 80, 88, 89, 70, 
  87, 81, 82, 89, 84, 94, 83, 82, 82, 88, 
  92, 73, 129, 77, 77, 90, 74, 75, 84, 82, 
  99, 89, 92, 93, 91, 76, 79, 80, 87, 85, 
  92, 76, 90, 75, 51, 79, 79, 84, 81, 84, 
  79, 87, 85, 98, 80, 80, 78, 89, 83, 86, 
  82, 89, 90, 74, 89, 73, 67, 80, 84, 76, 
  82, 74, 85, 83, 89, 96, 83, 76, 92, 88, 
  78, 86, 89, 91, 90, 82, 81, 89, 84, 88, 
  92, 81, 76, 75, 93, 84, 80, 81, 91, 92, 
  95, 82, 69, 87, 88, 85, 78, 94, 76, 89, 
  79, 84, 91, 86, 76, 84, 77, 79, 85, 86, 
  77, 87, 102, 84, 84, 84, 82, 87, 89, 88, 
  86, 76, 81, 78, 76, 86, 91, 79, 81, 75, 
  85, 85, 93, 90, 92, 73, 81, 103, 87, 84, 
  113, 89, 79, 90, 72, 72, 94, 84, 81, 99, 
  95, 93, 105, 77, 92, 81, 90, 91, 91, 76, 
  85, 86, 78, 92, 93, 80, 86, 91, 76, 89, 
  80, 107, 96, 88, 96, 90, 101, 90, 86, 88, 
  78, 86, 89, 79, 72, 97, 71, 93, 76, 83, 
  95, 79, 88, 91, 88, 83, 75, 87, 79, 73, 
  100, 86, 80, 75, 87, 82, 74, 75, 86, 79, 
  89, 69, 82, 77, 78, 88, 84, 85, 87, 90, 
  78, 102, 87, 81, 79, 101, 82, 88, 76, 96, 
  94, 90, 89, 92, 82, 89, 85, 88, 85, 96, 
  100, 90, 81, 82, 103, 77, 91, 92, 101, 95, 
  81, 80, 83, 87, 66, 93, 96, 109, 75, 78, 
  95, 87, 80, 85, 106, 83, 66, 65, 91, 103, 
  80, 66, 83, 80, 97, 81, 81, 81, 93, 80, 
  72, 91, 100, 89, 91, 76, 93, 90, 73, 71, 
  81, 86, 77, 70, 86, 80, 66, 79, 90, 75, 
  91, 75, 70, 85, 75, 92, 89, 105, 104, 80, 
  73, 90, 90, 94, 80, 91, 73, 97, 81, 90, 
  96, 86, 83, 57, 88, 88, 79, 90, 84, 85, 
  104, 93, 88, 93, 77, 104, 90, 96, 105, 86, 
  89, 86, 83, 90, 93, 88, 89, 73, 88, 79, 
  97, 87, 80, 73, 95, 95, 79, 74, 86, 81, 
  57, 69, 79, 108, 80, 90, 98, 83, 96, 101, 
  78, 93, 90, 82, 72, 72, 90, 95, 80, 82, 
  82, 76, 70, 86, 90, 107, 74, 83, 91, 90, 
  77, 76, 91, 78, 66, 71, 78, 89, 76, 62, 
  102, 86, 90, 80, 91, 91, 87, 70, 73, 73, 
  91, 94, 93, 76, 80, 91, 78, 66, 85, 88, 
  74, 78, 84, 89, 61, 81, 85, 80, 90, 72, 
  71, 86, 65, 80, 89, 101, 109, 65, 69, 84, 
  75, 97, 71, 96, 73, 91, 92, 96, 97, 78, 
  92, 57, 87, 78, 88, 86, 82, 83, 105, 84, 
  91, 92, 74, 103, 77, 89, 98, 85, 97, 81, 
  86, 94, 90, 80, 86, 71, 84, 101, 89, 89, 
  69, 71, 98, 94, 72, 74, 96, 81, 49, 87, 
  76, 104, 79, 101, 98, 80, 93, 94, 78, 77, 
  99, 76, 72, 64, 91, 78, 90, 92, 82, 86, 
  76, 105, 88, 92, 81, 80, 73, 84, 81, 89, 
  83, 82, 75, 86, 79, 93, 94, 76, 101, 84, 
  90, 90, 82, 96, 79, 94, 84, 79, 81, 95, 
  95, 82, 69, 78, 98, 74, 85, 83, 85, 90, 
  85, 99, 87, 79, 83, 76, 83, 84, 92, 85, 
  91, 84, 78, 84, 94, 70, 77, 67, 75, 90, 
  84, 82, 94, 68, 84, 84, 96, 84, 91, 67, 
  87, 86, 77, 95, 83, 84, 82, 73, 75, 80, 
  66, 66, 84, 87, 96, 97, 106, 86, 94, 83, 
  109, 82, 88, 76, 71, 83, 96, 84, 91, 86, 
  66, 92, 82, 79, 88, 85, 73, 83, 75, 82, 
  89, 89, 77, 79, 96, 83, 94, 101, 90, 78, 
  78, 89, 82, 82, 76, 81, 75, 94, 81, 73, 
  86, 101, 75, 84, 76, 88, 78, 83, 91, 77, 
  69, 76, 84, 86, 72, 66, 95, 81, 82, 81, 
  94, 80, 100, 85, 71, 99, 109, 83, 89, 52, 
  76, 75, 106, 54, 85, 87, 58, 78, 80, 76, 
  64, 83, 92, 79, 88, 73, 90, 94, 72, 90, 
  97, 97, 98, 69, 86, 90, 98, 90, 75, 96, 
  73, 64, 96, 91, 90, 77, 84, 67, 81, 76, 
  78, 80, 90, 87, 83, 89, 90, 83, 87, 92, 
  87, 105, 99, 98, 113, 86, 83, 95, 90, 85, 
  81, 71, 74, 72, 90, 83, 80, 72, 92, 88, 
  77, 76, 90, 82, 56, 66, 80, 107, 60, 94, 
  83, 83, 83, 80, 77, 97, 89, 74, 71, 64, 
  71, 87, 86, 81, 73, 76, 88, 69, 77, 97, 
  75, 92, 79, 90, 78, 79, 81, 75, 65, 85, 
  82, 76, 97, 64, 101, 82, 73, 81, 108, 98, 
  109, 78, 70, 84, 92, 90, 91, 44, 83, 67, 
  131, 57, 80, 89, 57, 75, 75, 97, 58, 82, 
  92, 85, 91, 69, 83, 85, 61, 71, 100, 89, 
  103, 59, 78, 86, 75, 93, 73, 106, 74, 66, 
  78, 100, 79, 76, 95, 62, 83, 69, 73, 74, 
  86, 84, 82, 80, 91, 94, 72, 98, 74, 95, 
  85, 86, 116, 86, 69, 104, 86, 84, 93, 61, 
  76, 81, 82, 82, 64, 64, 95, 88, 77, 70, 
  102, 80, 51, 91, 81, 110, 85, 99, 81, 82, 
  84, 78, 78, 77, 93, 68, 69, 63, 82, 75, 
  88, 94, 84, 82, 80, 91, 81, 92, 82, 80, 
  75, 88, 71, 84, 80, 81, 85, 93, 83, 76, 
  101, 81, 89, 80, 77, 92, 101, 88, 79, 104, 
  85, 82, 78, 93, 92, 75, 72, 70, 107, 69, 
  74, 86, 73, 100, 75, 95, 82, 81, 77, 75, 
  88, 86, 97, 80, 87, 82, 72, 74, 88, 72, 
  91, 70, 68, 88, 75, 77, 90, 61, 81, 77, 
  86, 83, 88, 78, 75, 77, 73, 87, 84, 75, 
  79, 81, 70, 78, 65, 73, 74, 89, 100, 83, 
  99, 90, 97, 82, 99, 79, 99, 74, 72, 79, 
  96, 80, 100, 78, 73, 87, 85, 76, 93, 76, 
  74, 93, 83, 87, 108, 88, 72, 83, 90, 75, 
  103, 87, 93, 74, 80, 85, 95, 81, 88, 84, 
  88, 71, 82, 72, 89, 82, 83, 91, 78, 85, 
  65, 78, 84, 78, 99, 86, 84, 89, 86, 81, 
  98, 63, 109, 91, 89, 84, 80, 112, 94, 102, 
  80, 86, 84, 72, 71, 70, 109, 61, 89, 83, 
  79, 108, 75, 77, 94, 82, 86, 89, 91, 81, 
  99, 73, 94, 88, 77, 80, 94, 69, 91, 78, 
  78, 89, 71, 83, 84, 75, 86, 87, 101, 78, 
  75, 81, 93, 65, 76, 78, 95, 85, 83, 87, 
  79, 77, 80, 67, 76, 93, 102, 83, 103, 92, 
  81, 78, 100, 87, 72, 77, 70, 73, 95, 78, 
  123, 93, 74, 79, 102, 74, 86, 83, 76, 70, 
  77, 79, 71, 95, 75, 100, 82, 77, 82, 100, 
  92, 82, 79, 90, 86, 76, 74, 86, 89, 73, 
  84, 71, 85, 85, 80, 91, 80, 81, 70, 74, 
  76, 83, 93, 91, 94, 87, 84, 87, 89, 64, 
  107, 89, 101, 86, 83, 105, 93, 88, 80, 75, 
  81, 63, 86, 59, 127, 58, 79, 84, 88, 111, 
  65, 78, 91, 83, 87, 86, 92, 83, 103, 86, 
  94, 77, 73, 74, 95, 74, 88, 84, 65, 89, 
  77, 83, 81, 81, 76, 85, 96, 80, 80, 83, 
  91, 67, 80, 70, 90, 82, 82, 74, 74, 89, 
  70, 71, 67, 90, 97, 76, 96, 94, 79, 79, 
  95, 88, 96, 76, 73, 75, 91, 76, 136, 79, 
  67, 80, 110, 71, 96, 77, 79, 78, 81, 79, 
  82, 101, 77, 94, 86, 79, 85, 88, 94, 84, 
  75, 94, 86, 76, 68, 94, 90, 96, 83, 85, 
  81, 74, 84, 83, 80, 83, 68, 82, 83, 83, 
  108, 86, 89, 81, 74, 88, 87, 84, 95, 69, 
  83, 76, 73, 107, 102, 84, 79, 83, 85, 80, 
  80, 69, 92, 73, 77, 88, 84, 98, 73, 77, 
  83, 80, 85, 82, 93, 101, 97, 77, 95, 91, 
  62, 75, 82, 75, 90, 68, 70, 91, 78, 74, 
  87, 72, 78, 79, 95, 80, 80, 85, 78, 75, 
  83, 83, 94, 84, 89, 75, 75, 82, 77, 62, 
  78, 83, 81, 78, 86, 91, 89, 77, 88, 80, 
  100, 73, 66, 80, 91, 76, 106, 92, 78, 85, 
  88, 91, 82, 70, 89, 87, 92, 79, 86, 90, 
  84, 93, 95, 80, 95, 95, 91, 78, 86, 97, 
  101, 95, 91, 80, 72, 78, 82, 95, 93, 84, 
  77, 94, 85, 97, 67, 70, 70, 56, 81, 82, 
  69, 117, 93, 76, 81, 91, 103, 80, 100, 89, 
  81, 84, 76, 81, 91, 86, 108, 86, 74, 69, 
  96, 80, 68, 75, 85, 74, 81, 86, 87, 79, 
  85, 92, 92, 81, 98, 100, 74, 90, 99, 83, 
  88, 83, 113, 73, 60, 84, 79, 77, 59, 136, 
  80, 101, 75, 95, 82, 80, 79, 87, 66, 74, 
  83, 72, 84, 80, 75, 80, 74, 114, 85, 90, 
  86, 81, 90, 90, 99, 78, 85, 81, 89, 81, 
  98, 81, 87, 88, 82, 65, 87, 79, 111, 72, 
  84, 60, 85, 77, 116, 101, 99, 85, 106, 77, 
  70, 72, 97, 93, 89, 85, 72, 84, 102, 79, 
  93, 87, 63, 86, 72, 91, 104, 90, 75, 98, 
  100, 89, 65, 68, 77, 64, 103, 70, 58, 102, 
  83, 77, 84, 83, 104, 85, 98, 85, 69, 84, 
  80, 89, 89, 75, 116, 88, 79, 76, 98, 81, 
  60, 78, 78, 70, 98, 87, 79, 81, 86, 93, 
  90, 82, 119, 111, 77, 85, 94, 83, 91, 84, 
  112, 77, 62, 94, 74, 80, 58, 151, 113, 100, 
  72, 91, 77, 85, 77, 81, 59, 78, 77, 62, 
  83, 81, 77, 76, 77, 120, 86, 88, 78, 95, 
  96, 80, 98, 76, 95, 77, 89, 90, 101, 110, 
  94, 91, 86, 60, 88, 87, 117, 73, 81, 63, 
  78, 82, 121, 104, 97, 82, 118, 70, 77, 72, 
  101, 91, 97, 85, 74, 80, 89, 69, 78, 79, 
  81, 90, 82, 103, 93, 84, 77, 95, 83, 77, 
  73, 72, 72, 63, 78, 74, 68, 95, 79, 74, 
  85, 96, 98, 88, 88, 80, 83, 86, 85, 86, 
  81, 81, 105, 97, 86, 70, 92, 79, 80, 77, 
  88, 74, 83, 83, 85, 79, 86, 78, 84, 86, 
  93, 87, 75, 89, 98, 83, 82, 83, 109, 75, 
  59, 83, 74, 82, 70, 109, 103, 93, 79, 94, 
  76, 80, 80, 85, 72, 76, 84, 81, 81, 85, 
  76, 77, 79, 96, 83, 95, 89, 79, 90, 86, 
  97, 79, 88, 79, 83, 82, 94, 97, 84, 88, 
  83, 74, 81, 78, 108, 81, 81, 73, 88, 79, 
  110, 89, 77, 83, 96, 84, 88, 76, 98, 93, 
  90, 88, 73, 82, 98, 95, 98, 80, 84, 86, 
  87, 86, 79, 89, 75, 94, 92, 85, 85, 81, 
  78, 84, 86, 85, 63, 93, 106, 85, 91, 98, 
  76, 74, 86, 96, 93, 86, 81, 81, 82, 87, 
  79, 83, 79, 78, 80, 77, 82, 78, 81, 84, 
  94, 87, 85, 75, 76, 91, 91, 80, 90, 84, 
  82, 82, 65, 88, 84, 74, 80, 73, 82, 78, 
  80, 90, 78, 111, 75, 91, 73, 83, 88, 73, 
  70, 73, 65, 72, 89, 78, 93, 86, 87, 82, 
  78, 92, 89, 96, 77, 87, 68, 93, 86, 81, 
  88, 76, 87, 84, 77, 69, 85, 82, 88, 71, 
  85, 89, 92, 78, 74, 90, 79, 76, 97, 79, 
  103, 85, 84, 79, 92, 72, 83, 92, 73, 74, 
  95, 88, 87, 97, 85, 91, 81, 82, 83, 91, 
  77, 87, 76, 92, 110, 78, 77, 87, 86, 90, 
  94, 91, 73, 70, 80, 94, 98, 87, 80, 72, 
  78, 84, 96, 91, 86, 82, 87, 72, 79, 94, 
  75, 80, 74, 73, 72, 93, 79, 97, 106, 76, 
  80, 70, 82, 66, 85, 78, 74, 93, 79, 79, 
  52, 89, 82, 81, 76, 80, 62, 72, 74, 110, 
  80, 73, 78, 78, 75, 80, 98, 69, 72, 74, 
  61, 78, 85, 85, 94, 76, 92, 80, 79, 73, 
  89, 118, 82, 86, 55, 97, 74, 77, 89, 68, 
  102, 80, 63, 76, 80, 83, 92, 61, 84, 97, 
  98, 71, 73, 91, 77, 78, 88, 70, 75, 84, 
  87, 73, 86, 70, 73, 92, 72, 79, 99, 81, 
  95, 86, 85, 82, 85, 105, 89, 95, 80, 89, 
  75, 94, 79, 80, 91, 77, 80, 82, 85, 84, 
  83, 95, 82, 81, 91, 100, 84, 79, 77, 80, 
  91, 81, 83, 80, 90, 83, 82, 87, 79, 78, 
  81, 81, 72, 78, 87, 80, 85, 74, 82, 77, 
  76, 81, 85, 84, 95, 97, 80, 80, 72, 79, 
  82, 79, 88, 76, 82, 82, 78, 87, 78, 95, 
  112, 88, 76, 87, 83, 79, 79, 86, 74, 75, 
  92, 82, 95, 88, 84, 80, 81, 89, 87, 87, 
  74, 89, 76, 89, 97, 89, 91, 75, 89, 88, 
  82, 91, 86, 87, 88, 74, 86, 88, 90, 85, 
  76, 86, 86, 82, 85, 75, 80, 89, 82, 84, 
  82, 76, 81, 89, 72, 78, 89, 88, 85, 77, 
  85, 86, 85, 88, 78, 87, 74, 94, 77, 95, 
  99, 76, 89, 73, 75, 89, 76, 77, 76, 81, 
  97, 75, 88, 93, 71, 82, 81, 87, 83, 84, 
  96, 88, 86, 89, 72, 80, 85, 85, 80, 80, 
  90, 90, 79, 89, 84, 87, 82, 79, 81, 81, 
  79, 88, 80, 83, 75, 78, 79, 79, 75, 76, 
  74, 73, 87, 86, 83, 83, 82, 73, 84, 87, 
  82, 77, 83, 68, 87, 79, 87, 80, 90, 83, 
  94, 84, 77, 72, 82, 81, 89, 102, 75, 90, 
  83, 82, 83, 83, 84, 75, 76, 91, 76, 82, 
  85, 89, 78, 75, 84, 89, 80, 87, 76, 96, 
  86, 84, 80, 80, 82, 88, 79, 90, 92, 80, 
  79, 80, 71, 87, 95, 87, 75, 87, 81, 90, 
  88, 86, 87, 83, 72, 84, 78, 88, 110, 91, 
  94, 83, 80, 96, 67, 87, 87, 77, 88, 78, 
  87, 92, 63, 73, 79, 90, 83, 81, 91, 88, 
  82, 73, 78, 86, 82, 97, 82, 83, 88, 103, 
  77, 92, 81, 79, 84, 72, 87, 84, 73, 86, 
  66, 80, 68, 80, 74, 81, 67, 81, 74, 81, 
  75, 87, 79, 89, 92, 70, 74, 76, 80, 81, 
  93, 58, 90, 82, 85, 85, 91, 99, 94, 71, 
  85, 77, 84, 73, 91, 93, 66, 88, 80, 85, 
  72, 90, 81, 65, 88, 88, 65, 75, 79, 90, 
  74, 76, 78, 91, 65, 80, 80, 94, 85, 83, 
  83, 78, 72, 90, 72, 91, 84, 78, 64, 79, 
  65, 90, 96, 81, 89, 97, 80, 88, 82, 97, 
  84, 89, 74, 95, 79, 90, 90, 89, 87, 70, 
  74, 81, 76, 84, 87, 91, 84, 75, 82, 98, 
  82, 84, 77, 89, 81, 79, 94, 75, 87, 79, 
  74, 84, 80, 81, 81, 79, 76, 84, 87, 86, 
  73, 74, 83, 81, 83, 86, 82, 88, 82, 74, 
  76, 79, 79, 74, 79, 77, 81, 72, 83, 85, 
  80, 81, 84, 79, 87, 87, 83, 85, 87, 78, 
  89, 89, 82, 82, 94, 83, 98, 89, 75, 73, 
  78, 85, 89, 91, 76, 83, 84, 79, 86, 84, 
  86, 74, 90, 89, 82, 81, 88, 92, 79, 79, 
  87, 83, 80, 90, 77, 88, 88, 82, 86, 80, 
  89, 86, 80, 91, 86, 82, 83, 85, 72, 89, 
  90, 89, 72, 81, 79, 80, 92, 89, 73, 91, 
  90, 87, 80, 90, 68, 85, 58, 95, 90, 78, 
  94, 96, 79, 73, 89, 83, 94, 96, 91, 86, 
  88, 85, 84, 85, 77, 83, 80, 114, 82, 86, 
  88, 79, 78, 82, 66, 94, 97, 81, 84, 74, 
  78, 89, 81, 90, 76, 86, 87, 92, 93, 83, 
  97, 89, 85, 88, 82, 65, 63, 82, 72, 112, 
  89, 86, 104, 82, 88, 79, 75, 95, 88, 73, 
  87, 86, 85, 87, 95, 97, 87, 86, 60, 89, 
  88, 79, 112, 76, 82, 88, 98, 83, 83, 84, 
  86, 80, 87, 99, 89, 88, 65, 86, 101, 89, 
  72, 78, 76, 86, 82, 120, 79, 94, 59, 83, 
  80, 84, 74, 80, 71, 100, 81, 76, 87, 82, 
  80, 85, 94, 67, 85, 86, 86, 63, 79, 43, 
  62, 87, 104, 78, 78, 96, 86, 84, 54, 82, 
  82, 79, 86, 117, 82, 77, 85, 67, 110, 96, 
  73, 89, 72, 76, 88, 92, 77, 100, 87, 91, 
  75, 92, 95, 87, 84, 88, 89, 93, 75, 89, 
  67, 89, 86, 84, 80, 92, 78, 64, 86, 89, 
  73, 72, 76, 98, 67, 90, 87, 76, 84, 83, 
  98, 87, 75, 77, 83, 65, 79, 80, 79, 84, 
  84, 84, 53, 86, 76, 87, 66, 87, 81, 96, 
  67, 76, 59, 94, 73, 94, 99, 80, 98, 80, 
  76, 77, 77, 86, 137, 70, 77, 85, 82, 90, 
  91, 101, 75, 86, 80, 99, 81, 101, 81, 74, 
  80, 91, 82, 59, 76, 87, 81, 86, 79, 90, 
  83, 79, 92, 77, 93, 74, 79, 52, 72, 83, 
  82, 78, 70, 93, 88, 89, 67, 91, 85, 84, 
  80, 97, 89, 82, 86, 73, 88, 96, 80, 84, 
  75, 77, 89, 78, 91, 87, 71, 81, 80, 83, 
  83, 81, 83, 82, 88, 91, 71, 88, 73, 84, 
  88, 93, 85, 80, 84, 76, 90, 87, 80, 79, 
  89, 91, 90, 82, 85, 86, 82, 83, 87, 88, 
  88, 80, 84, 78, 77, 83, 84, 84, 83, 79, 
  70, 89, 83, 93, 91, 84, 89, 97, 69, 94, 
  69, 99, 102, 95, 92, 81, 84, 85, 91, 89, 
  85, 88, 92, 84, 86, 84, 80, 89, 90, 107, 
  83, 72, 91, 90, 99, 97, 75, 83, 82, 88, 
  77, 89, 79, 88, 95, 78, 80, 74, 96, 82, 
  91, 81, 81, 99, 91, 90, 80, 94, 68, 94, 
  61, 91, 85, 79, 101, 93, 74, 81, 97, 76, 
  86, 94, 82, 84, 87, 89, 84, 81, 80, 87, 
  70, 112, 93, 48, 84, 76, 87, 72, 67, 85, 
  104, 85, 75, 73, 83, 83, 75, 92, 72, 86, 
  91, 82, 91, 85, 94, 88, 84, 85, 89, 66, 
  68, 76, 66, 104, 87, 101, 72, 79, 88, 88, 
  77, 102, 90, 62, 75, 83, 83, 77, 95, 100, 
  81, 93, 63, 91, 80, 73, 106, 76, 91, 83, 
  105, 83, 84, 92, 77, 79, 93, 97, 93, 90, 
  68, 84, 101, 86, 83, 75, 80, 76, 88, 133, 
  82, 89, 74, 76, 76, 83, 82, 85, 70, 102, 
  84, 82, 81, 79, 84, 80, 102, 70, 83, 81, 
  89, 66, 79, 43, 62, 83, 108, 88, 88, 90, 
  87, 77, 54, 79, 86, 83, 78, 114, 82, 81, 
  75, 63, 110, 96, 78, 92, 77, 79, 80, 94, 
  66, 102, 75, 91, 74, 94, 97, 80, 84, 86, 
  86, 98, 78, 84, 70, 92, 84, 87, 75, 79, 
  73, 69, 81, 83, 76, 73, 76, 93, 64, 92, 
  87, 70, 86, 67, 85, 81, 68, 86, 77, 70, 
  75, 75, 69, 88, 87, 83, 55, 87, 73, 95, 
  65, 83, 79, 83, 64, 68, 56, 92, 64, 85, 
  99, 87, 80, 80, 65, 83, 77, 86, 108, 76, 
  77, 83, 70, 95, 96, 91, 71, 89, 80, 82, 
  86, 98, 75, 72, 80, 97, 89, 52, 75, 83, 
  73, 87, 86, 84, 79, 81, 86, 71, 99, 73, 
  83, 56, 75, 85, 83, 82, 78, 88, 85, 84, 
  69, 91, 83, 91, 81, 91, 94, 87, 76, 73, 
  90, 85, 77, 79, 82, 78, 94, 84, 78, 77, 
  82, 79, 78, 84, 88, 77, 83, 75, 90, 74, 
  69, 87, 70, 88, 86, 97, 83, 87, 78, 80, 
  89, 86, 82, 81, 93, 90, 81, 91, 84, 90, 
  87, 74, 87, 85, 84, 87, 79, 81, 79, 95, 
  84, 84, 87, 78, 74, 87, 89, 95, 90, 88, 
  94, 85, 69, 83, 69, 90, 88, 87, 91, 83, 
  83, 86, 77, 93, 87, 86, 73, 83, 82, 79, 
  68, 97, 92, 97, 80, 73, 84, 86, 96, 102, 
  74, 79, 71, 93, 83, 81, 77, 87, 88, 83, 
  91, 81, 104, 85, 84, 75, 82, 92, 86, 89, 
  77, 92, 74, 94, 77, 92, 82, 82, 89, 92, 
  71, 79, 102, 89, 94, 86, 85, 85, 76, 89, 
  82, 81, 84, 77, 68, 89, 98, 73, 90, 79, 
  84, 84, 84, 85, 86, 90, 96, 84, 84, 81, 
  78, 92, 79, 86, 91, 99, 85, 88, 91, 77, 
  83, 73, 84, 70, 77, 79, 76, 81, 83, 98, 
  64, 76, 84, 87, 86, 90, 91, 66, 89, 77, 
  80, 83, 86, 90, 85, 82, 68, 87, 90, 81, 
  86, 73, 82, 85, 94, 78, 92, 89, 78, 77, 
  89, 94, 98, 90, 94, 83, 85, 85, 91, 85, 
  89, 83, 87, 109, 87, 91, 86, 85, 91, 88, 
  86, 87, 78, 85, 73, 99, 84, 91, 83, 84, 
  97, 86, 77, 79, 90, 69, 75, 56, 65, 83, 
  93, 81, 93, 83, 84, 80, 67, 84, 87, 79, 
  86, 111, 89, 82, 82, 65, 95, 93, 78, 88, 
  76, 83, 83, 84, 79, 120, 75, 90, 84, 90, 
  94, 83, 81, 84, 89, 94, 74, 88, 78, 88, 
  84, 87, 82, 82, 78, 78, 84, 78, 77, 75, 
  84, 97, 80, 89, 91, 71, 84, 78, 82, 78, 
  78, 87, 80, 78, 79, 73, 80, 82, 85, 89, 
  61, 91, 77, 83, 71, 85, 82, 84, 74, 69, 
  65, 89, 77, 85, 98, 83, 76, 84, 77, 93, 
  82, 85, 82, 81, 79, 89, 68, 99, 86, 98, 
  79, 80, 83, 81, 84, 94, 80, 82, 83, 90, 
  82, 62, 72, 91, 89, 95, 87, 87, 78, 91, 
  83, 81, 96, 77, 86, 70, 75, 90, 83, 79, 
  80, 86, 82, 81, 79, 94, 84, 79, 84, 100, 
  90, 88, 83, 78, 79, 84, 80, 81, 79, 83, 
  92, 82, 82, 90, 81, 83, 81, 79, 85, 82, 
  83, 89, 83, 73, 65, 93, 78, 89, 85, 94, 
  89, 81, 85, 87, 85, 78, 81, 78, 94, 87, 
  92, 82, 82, 85, 83, 90, 78, 84, 92, 87, 
  82, 90, 83, 95, 89, 80, 87, 81, 77, 86, 
  87, 81, 93, 85, 96, 91, 86, 76, 77, 89, 
  92, 84, 88, 76, 83, 89, 85, 95, 85, 84, 
  80, 83, 80, 87, 76, 96, 81, 97, 85, 79, 
  87, 84, 92, 93, 81, 88, 79, 90, 74, 86, 
  71, 93, 100, 87, 76, 99, 86, 72, 87, 85, 
  79, 92, 91, 82, 90, 78, 81, 88, 72, 84, 
  80, 79, 78, 84, 67, 69, 90, 99, 66, 99, 
  81, 81, 87, 79, 91, 66, 81, 70, 93, 90, 
  86, 86, 67, 84, 77, 78, 87, 80, 78, 85, 
  77, 83, 74, 88, 72, 85, 88, 79, 76, 80, 
  72, 102, 90, 92, 89, 92, 88, 74, 86, 88, 
  87, 86, 74, 95, 94, 77, 99, 72, 95, 90, 
  81, 86, 104, 91, 74, 89, 87, 87, 83, 74, 
  86, 91, 91, 89, 101, 79, 95, 85, 86, 103, 
  76, 78, 90, 102, 97, 91, 83, 93, 114, 71, 
  98, 79, 75, 72, 83, 73, 94, 70, 84, 84, 
  69, 82, 88, 100, 78, 93, 87, 86, 89, 94, 
  80, 94, 122, 99, 80, 84, 81, 61, 75, 86, 
  83, 82, 74, 89, 77, 79, 74, 84, 78, 75, 
  89, 102, 81, 88, 113, 87, 74, 90, 79, 86, 
  94, 75, 86, 87, 81, 81, 75, 88, 72, 85, 
  86, 77, 79, 71, 82, 89, 87, 82, 72, 83, 
  74, 85, 77, 85, 81, 80, 90, 98, 86, 70, 
  94, 76, 88, 74, 92, 67, 61, 79, 73, 98, 
  80, 77, 105, 81, 86, 73, 87, 90, 92, 77, 
  85, 82, 79, 84, 77, 79, 81, 78, 92, 84, 
  80, 76, 79, 85, 92, 69, 82, 86, 86, 74, 
  93, 69, 84, 85, 72, 86, 90, 89, 94, 85, 
  61, 77, 76, 77, 96, 83, 72, 93, 64, 72, 
  71, 87, 78, 79, 66, 88, 89, 95, 102, 82, 
  130, 85, 86, 96, 86, 92, 76, 80, 90, 84, 
  83, 73, 92, 87, 83, 93, 79, 79, 92, 97, 
  99, 94, 91, 79, 98, 82, 87, 92, 94, 87, 
  82, 116, 92, 84, 76, 86, 80, 78, 80, 75, 
  87, 81, 66, 79, 83, 85, 90, 89, 81, 82, 
  75, 91, 88, 98, 92, 91, 88, 70, 77, 79, 
  89, 78, 92, 98, 76, 93, 69, 94, 97, 76, 
  84, 89, 80, 75, 91, 81, 102, 73, 72, 83, 
  81, 81, 89, 77, 87, 83, 91, 82, 77, 85, 
  71, 107, 82, 76, 64, 77, 89, 80, 102, 74, 
  90, 73, 68, 79, 62, 87, 74, 81, 89, 80, 
  82, 80, 88, 90, 76, 99, 82, 69, 73, 77, 
  87, 69, 86, 84, 87, 98, 94, 91, 71, 100, 
  91, 76, 87, 95, 71, 85, 96, 93, 85, 79, 
  74, 77, 73, 99, 81, 80, 80, 87, 72, 73, 
  75, 100, 75, 99, 75, 90, 84, 77, 94, 67, 
  79, 83, 78, 95, 83, 113, 76, 81, 94, 78, 
  73, 84, 65, 83, 89, 74, 76, 90, 77, 75, 
  90, 71, 81, 80, 75, 97, 98, 93, 93, 88, 
  85, 67, 72, 86, 91, 87, 66, 84, 87, 74, 
  91, 72, 96, 96, 83, 86, 86, 84, 81, 84, 
  80, 85, 87, 83, 83, 88, 91, 97, 93, 92, 
  102, 79, 81, 109, 71, 75, 84, 102, 94, 91, 
  87, 90, 96, 73, 93, 89, 80, 83, 68, 77, 
  95, 68, 72, 73, 73, 89, 99, 88, 77, 94, 
  81, 86, 86, 83, 81, 92, 119, 94, 95, 78, 
  83, 59, 75, 84, 77, 88, 73, 90, 69, 84, 
  78, 91, 76, 82, 92, 105, 89, 91, 130, 85, 
  73, 91, 75, 90, 98, 83, 94, 81, 72, 78, 
  62, 89, 78, 85, 77, 72, 92, 73, 64, 93, 
  99, 83, 74, 84, 76, 79, 71, 82, 83, 78, 
  95, 74, 88, 66, 97, 74, 82, 71, 89, 66, 
  55, 85, 66, 88, 75, 75, 86, 80, 81, 79, 
  88, 92, 85, 74, 74, 87, 85, 86, 77, 81, 
  85, 82, 94, 90, 69, 79, 73, 72, 93, 79, 
  76, 96, 84, 87, 85, 71, 79, 71, 76, 83, 
  77, 84, 87, 87, 63, 76, 89, 87, 92, 80, 
  78, 83, 71, 81, 77, 85, 82, 74, 62, 88, 
  85, 82, 113, 78, 136, 79, 78, 91, 88, 97, 
  77, 80, 83, 80, 85, 69, 103, 88, 85, 90, 
  86, 84, 96, 88, 104, 91, 77, 74, 88, 87, 
  84, 93, 94, 86, 84, 118, 92, 83, 85, 85, 
  83, 60, 78, 70, 77, 76, 72, 80, 104, 89, 
  79, 76, 87, 83, 75, 93, 89, 105, 99, 85, 
  73, 71, 70, 79, 83, 77, 93, 96, 74, 97, 
  69, 91, 90, 61, 85, 90, 76, 81, 84, 78, 
  89, 78, 72, 92, 86, 75, 99, 76, 92, 85, 
  94, 83, 77, 81, 72, 79, 78, 83, 70, 81, 
  87, 93, 87, 77, 77, 69, 66, 79, 58, 91, 
  82, 78, 82, 75, 99, 90, 80, 91, 77, 101, 
  80, 72, 70, 80, 85, 70, 86, 73, 84, 86, 
  93, 87, 87, 90, 95, 84, 88, 81, 69, 88, 
  94, 81, 82, 84, 72, 84, 77, 92, 80, 82, 
  75, 87, 85, 81, 89, 90, 82, 82, 82, 86, 
  78, 79, 85, 78, 81, 82, 75, 98, 83, 109, 
  94, 82, 96, 79, 72, 86, 76, 79, 100, 80, 
  90, 73, 86, 76, 81, 80, 77, 81, 87, 99, 
  97, 79, 84, 87, 85, 69, 80, 88, 87, 82, 
  73, 88, 89, 68, 92, 67, 96, 79, 89, 87, 
  85, 83, 86, 86, 83, 87, 84, 86, 89, 81, 
  89, 88, 89, 81, 96, 79, 84, 99, 84, 80, 
  85, 96, 89, 97, 76, 91, 81, 84, 82, 81, 
  87, 75, 69, 83, 92, 68, 78, 83, 75, 81, 
  82, 88, 79, 83, 73, 87, 78, 94, 81, 88, 
  110, 88, 82, 83, 81, 66, 79, 90, 81, 91, 
  85, 86, 83, 81, 78, 87, 76, 83, 93, 92, 
  86, 88, 102, 84, 82, 82, 81, 94, 92, 86, 
  86, 87, 87, 78, 66, 83, 91, 80, 76, 77, 
  88, 82, 71, 92, 96, 85, 87, 89, 86, 73, 
  81, 87, 83, 88, 86, 76, 87, 76, 89, 86, 
  79, 73, 86, 75, 69, 83, 73, 88, 75, 69, 
  76, 80, 83, 76, 92, 91, 90, 74, 84, 89, 
  89, 90, 85, 82, 87, 80, 83, 87, 83, 75, 
  73, 69, 85, 78, 71, 90, 92, 89, 80, 81, 
  88, 81, 74, 85, 68, 91, 90, 84, 79, 77, 
  96, 87, 87, 74, 88, 98, 69, 78, 85, 88, 
  82, 72, 73, 87, 87, 89, 96, 85, 96, 78, 
  67, 89, 83, 87, 81, 87, 85, 92, 89, 72, 
  98, 82, 84, 93, 79, 86, 87, 89, 93, 78, 
  90, 85, 80, 83, 91, 95, 87, 89, 74, 101, 
  92, 85, 80, 81, 99, 64, 72, 75, 81, 86, 
  76, 74, 96, 82, 82, 89, 83, 85, 76, 95, 
  91, 107, 87, 80, 70, 76, 68, 99, 79, 85, 
  97, 97, 85, 91, 81, 97, 79, 69, 83, 98, 
  87, 79, 87, 87, 90, 82, 83, 88, 89, 77, 
  95, 80, 86, 82, 85, 79, 84, 80, 64, 75, 
  78, 81, 70, 88, 87, 84, 87, 88, 78, 81, 
  79, 79, 69, 92, 89, 82, 75, 77, 99, 80, 
  82, 90, 92, 109, 79, 77, 85, 90, 90, 73, 
  84, 79, 83, 85, 91, 88, 74, 81, 89, 96, 
  89, 76, 87, 70, 80, 86, 77, 88, 72, 86, 
  84, 79, 88, 77, 102, 76, 61, 84, 73, 82, 
  74, 80, 95, 89, 100, 106, 89, 87, 92, 88, 
  97, 78, 80, 81, 85, 89, 87, 82, 74, 91, 
  72, 82, 78, 98, 89, 98, 89, 84, 71, 76, 
  70, 80, 66, 86, 87, 76, 75, 97, 104, 76, 
  97, 83, 94, 83, 78, 99, 81, 81, 78, 72, 
  69, 100, 68, 89, 101, 97, 81, 84, 73, 88, 
  93, 94, 82, 91, 81, 90, 100, 87, 72, 78, 
  96, 91, 55, 87, 73, 72, 80, 79, 82, 107, 
  97, 76, 88, 76, 85, 79, 84, 83, 73, 93, 
  94, 92, 92, 79, 87, 65, 73, 78, 90, 82, 
  86, 64, 83, 82, 71, 86, 88, 91, 92, 83, 
  79, 74, 90, 94, 71, 86, 72, 88, 84, 66, 
  81, 81, 107, 78, 61, 81, 83, 81, 74, 87, 
  105, 95, 88, 105, 88, 80, 83, 86, 105, 96, 
  80, 79, 88, 86, 86, 84, 70, 89, 71, 72, 
  72, 93, 81, 98, 85, 90, 69, 77, 80, 90, 
  68, 80, 87, 73, 69, 91, 97, 74, 103, 92, 
  88, 75, 72, 106, 95, 77, 77, 75, 70, 95, 
  69, 97, 105, 96, 72, 80, 77, 90, 89, 90, 
  82, 92, 71, 76, 110, 79, 70, 78, 92, 83, 
  52, 86, 79, 81, 79, 85, 88, 99, 100, 77, 
  94, 82, 84, 82, 76, 84, 76, 83, 91, 90, 
  90, 79, 89, 61, 90, 79, 92, 85, 94, 59, 
  88, 89, 79, 81, 84, 94, 85, 81, 93, 79, 
  83, 87, 74, 92, 74, 91, 88, 77, 84, 80, 
  100, 83, 72, 77, 82, 81, 76, 80, 93, 92, 
  94, 92, 90, 77, 91, 84, 95, 110, 87, 81, 
  82, 90, 86, 84, 70, 90, 73, 79, 73, 86, 
  88, 98, 86, 79, 74, 77, 77, 86, 71, 88, 
  89, 73, 75, 93, 98, 83, 90, 84, 95, 78, 
  79, 93, 94, 84, 75, 81, 69, 100, 71, 94, 
  102, 91, 81, 84, 74, 83, 89, 92, 92, 81, 
  79, 80, 102, 83, 78, 79, 79, 90, 59, 89, 
  85, 82, 81, 93, 79, 109, 96, 76, 91, 73, 
  79, 81, 72, 81, 74, 79, 82, 90, 83, 77, 
  87, 66, 96, 78, 92, 84, 89, 65, 79, 76, 
  73, 87, 77, 90, 86, 88, 77, 70, 97, 86, 
  87, 83, 84, 78, 84, 73, 94, 89, 116, 71, 
  58, 82, 75, 90, 77, 72, 88, 102, 88, 103, 
  80, 86, 85, 82, 83, 83, 80, 69, 86, 81, 
  80, 87, 78, 86, 74, 77, 70, 97, 79, 102, 
  85, 88, 63, 75, 77, 79, 72, 91, 72, 77, 
  87, 92, 90, 74, 88, 92, 95, 81, 78, 90, 
  87, 78, 85, 78, 68, 102, 81, 85, 87, 95, 
  77, 84, 79, 79, 81, 81, 84, 91, 82, 106, 
  102, 93, 61, 83, 102, 86, 49, 84, 70, 80, 
  90, 74, 79, 99, 93, 80, 85, 84, 77, 98, 
  84, 79, 88, 88, 83, 84, 91, 81, 76, 68, 
  89, 81, 81, 102, 87, 69, 86, 101, 75, 101, 
  73, 85, 84, 79, 64, 85, 110, 85, 104, 81, 
  81, 76, 79, 73, 95, 93, 137, 65, 63, 75, 
  84, 107, 72, 76, 89, 112, 102, 87, 80, 86, 
  84, 77, 91, 81, 80, 74, 76, 80, 75, 82, 
  63, 77, 72, 83, 69, 83, 73, 126, 82, 81, 
  57, 74, 97, 77, 84, 77, 74, 67, 83, 90, 
  82, 68, 62, 88, 96, 66, 70, 84, 71, 60, 
  100, 89, 72, 115, 88, 88, 86, 99, 73, 76, 
  93, 96, 72, 77, 73, 82, 77, 117, 130, 83, 
  59, 75, 98, 71, 66, 78, 81, 89, 98, 85, 
  82, 95, 85, 80, 97, 84, 76, 118, 70, 74, 
  103, 76, 77, 82, 78, 78, 72, 64, 116, 83, 
  78, 115, 102, 65, 90, 126, 74, 85, 91, 92, 
  87, 83, 86, 76, 91, 88, 84, 84, 79, 89, 
  88, 69, 89, 84, 108, 87, 78, 81, 94, 86, 
  69, 71, 94, 97, 84, 76, 85, 73, 87, 83, 
  90, 113, 79, 72, 80, 76, 83, 84, 65, 85, 
  74, 72, 66, 78, 81, 102, 84, 80, 68, 75, 
  74, 88, 76, 86, 79, 73, 82, 90, 90, 74, 
  81, 86, 91, 76, 80, 90, 87, 79, 75, 86, 
  71, 96, 77, 96, 91, 92, 76, 81, 80, 89, 
  83, 82, 82, 79, 79, 97, 102, 85, 62, 82, 
  84, 86, 50, 82, 86, 85, 90, 95, 76, 102, 
  91, 77, 91, 83, 75, 89, 77, 77, 88, 83, 
  81, 83, 72, 78, 76, 65, 97, 80, 84, 96, 
  90, 74, 85, 91, 80, 89, 79, 88, 92, 90, 
  89, 73, 87, 79, 82, 80, 86, 79, 86, 69, 
  89, 87, 97, 80, 67, 78, 76, 89, 78, 73, 
  76, 92, 82, 88, 81, 88, 89, 84, 77, 83, 
  77, 83, 88, 84, 78, 87, 89, 84, 80, 77, 
  69, 95, 80, 99, 86, 92, 70, 79, 64, 89, 
  78, 97, 75, 77, 85, 87, 88, 80, 95, 87, 
  95, 83, 85, 78, 87, 79, 80, 85, 69, 96, 
  85, 89, 83, 91, 85, 84, 74, 77, 84, 86, 
  89, 76, 89, 104, 97, 111, 69, 85, 107, 88, 
  60, 83, 71, 79, 81, 78, 69, 104, 86, 79, 
  82, 81, 83, 91, 85, 79, 89, 84, 81, 88, 
  85, 85, 82, 87, 97, 77, 70, 97, 78, 76, 
  87, 85, 86, 93, 87, 85, 94, 82, 83, 81, 
  94, 78, 98, 77, 83, 82, 88, 77, 89, 87, 
  112, 75, 74, 75, 87, 92, 72, 68, 70, 94, 
  92, 80, 84, 85, 88, 79, 83, 86, 79, 85, 
  81, 84, 79, 80, 77, 80, 76, 77, 67, 88, 
  74, 114, 83, 86, 66, 75, 74, 85, 80, 89, 
  78, 72, 83, 84, 82, 77, 77, 86, 96, 76, 
  78, 83, 76, 67, 87, 98, 69, 94, 90, 89, 
  79, 95, 79, 81, 86, 88, 79, 78, 76, 75, 
  82, 115, 100, 107, 66, 84, 108, 78, 69, 82, 
  79, 81, 92, 86, 70, 98, 74, 81, 87, 82, 
  78, 99, 80, 79, 93, 75, 84, 91, 75, 84, 
  83, 82, 105, 84, 70, 106, 76, 76, 85, 106, 
  81, 83, 96, 94, 96, 78, 96, 75, 86, 81, 
  80, 80, 80, 90, 95, 68, 89, 83, 99, 86, 
  90, 77, 102, 85, 69, 72, 82, 84, 86, 78, 
  86, 74, 93, 83, 82, 111, 79, 83, 82, 86, 
  78, 85, 71, 83, 78, 77, 63, 80, 80, 102, 
  87, 85, 74, 77, 64, 78, 76, 90, 79, 74, 
  87, 82, 89, 81, 89, 83, 89, 76, 87, 86, 
  80, 78, 73, 94, 69, 91, 84, 95, 84, 87, 
  84, 83, 83, 85, 87, 83, 85, 71, 87, 98, 
  94, 91, 72, 84, 90, 88, 62, 82, 83, 78, 
  87, 87, 67, 106, 90, 75, 89, 77, 81, 88, 
  85, 75, 83, 84, 84, 89, 77, 81, 80, 84, 
  89, 78, 72, 90, 80, 86, 87, 80, 85, 93, 
  77, 90, 83, 80, 82, 91, 78, 85, 83, 69, 
  88, 85, 74, 71, 75, 95, 91, 75, 85, 78, 
  94, 70, 93, 82, 91, 96, 94, 81, 94, 80, 
  88, 77, 83, 73, 86, 90, 89, 85, 84, 66, 
  101, 79, 64, 91, 93, 83, 75, 94, 86, 92, 
  85, 90, 92, 83, 84, 86, 82, 96, 96, 82, 
  103, 88, 99, 67, 82, 89, 72, 103, 76, 83, 
  87, 97, 88, 80, 83, 76, 102, 76, 90, 80, 
  68, 97, 67, 72, 107, 93, 84, 79, 76, 75, 
  83, 83, 92, 93, 91, 66, 82, 73, 84, 71, 
  82, 83, 77, 83, 87, 90, 100, 72, 84, 95, 
  73, 85, 93, 77, 98, 94, 87, 97, 84, 80, 
  88, 84, 101, 104, 85, 79, 81, 89, 75, 84, 
  98, 68, 77, 90, 83, 82, 86, 60, 72, 83, 
  70, 71, 74, 74, 82, 76, 93, 83, 73, 73, 
  83, 73, 78, 93, 88, 88, 87, 81, 77, 76, 
  83, 78, 92, 85, 78, 91, 83, 67, 89, 73, 
  67, 86, 108, 70, 84, 92, 78, 84, 79, 98, 
  91, 89, 95, 94, 77, 89, 99, 116, 108, 109, 
  78, 80, 77, 93, 91, 88, 71, 84, 76, 93, 
  98, 82, 82, 76, 104, 73, 83, 75, 68, 89, 
  70, 70, 83, 98, 82, 75, 83, 78, 87, 81, 
  83, 99, 89, 63, 81, 90, 85, 87, 78, 83, 
  80, 82, 83, 92, 96, 63, 84, 88, 72, 88, 
  92, 69, 79, 93, 79, 90, 90, 76, 84, 86, 
  100, 102, 85, 87, 83, 82, 87, 87, 84, 89, 
  82, 88, 75, 87, 78, 71, 79, 89, 79, 70, 
  74, 100, 88, 77, 100, 70, 82, 73, 81, 82, 
  93, 96, 89, 88, 95, 86, 87, 74, 86, 86, 
  90, 88, 75, 84, 83, 68, 83, 75, 70, 89, 
  91, 68, 75, 94, 90, 85, 82, 83, 100, 93, 
  84, 84, 85, 96, 96, 73, 96, 88, 100, 65, 
  73, 87, 74, 94, 91, 82, 84, 98, 94, 79, 
  81, 89, 91, 74, 95, 81, 71, 86, 67, 71, 
  82, 87, 86, 78, 81, 85, 88, 84, 90, 90, 
  90, 63, 84, 74, 82, 93, 81, 82, 80, 80, 
  86, 86, 95, 75, 86, 92, 73, 106, 82, 69, 
  67, 93, 85, 89, 93, 81, 91, 83, 97, 99, 
  87, 78, 74, 99, 73, 95, 96, 75, 82, 84, 
  79, 75, 94, 73, 94, 95, 77, 76, 84, 87, 
  95, 77, 92, 74, 75, 77, 97, 76, 78, 102, 
  96, 79, 101, 78, 85, 72, 84, 67, 72, 82, 
  110, 89, 65, 67, 95, 74, 70, 98, 90, 83, 
  69, 86, 89, 84, 83, 105, 62, 81, 70, 78, 
  70, 88, 96, 99, 95, 90, 72, 70, 98, 95, 
  94, 70, 65, 77, 89, 97, 89, 67, 80, 80, 
  99, 92, 72, 97, 72, 96, 85, 79, 107, 94, 
  97, 83, 70, 79, 68, 93, 71, 104, 90, 76, 
  85, 88, 77, 62, 77, 82, 89, 73, 79, 86, 
  91, 61, 87, 100, 71, 76, 78, 69, 83, 100, 
  82, 91, 104, 77, 60, 83, 86, 83, 85, 90, 
  70, 91, 69, 82, 109, 60, 67, 84, 80, 69, 
  105, 65, 82, 99, 64, 67, 80, 58, 76, 71, 
  94, 90, 62, 82, 89, 57, 62, 93, 85, 83, 
  93, 83, 68, 78, 84, 69, 85, 74, 103, 98, 
  73, 71, 83, 60, 78, 93, 96, 84, 80, 88, 
  81, 83, 72, 111, 63, 83, 87, 78, 74, 83, 
  103, 137, 99, 134, 55, 98, 90, 104, 121, 58, 
  61, 78, 75, 91, 96, 74, 79, 83, 99, 95, 
  59, 84, 74, 85, 85, 80, 71, 99, 83, 77, 
  82, 78, 82, 91, 65, 102, 86, 74, 87, 119, 
  79, 77, 77, 81, 92, 78, 70, 85, 85, 45, 
  84, 93, 73, 70, 75, 62, 66, 103, 78, 86, 
  102, 73, 43, 88, 81, 78, 80, 100, 75, 94, 
  85, 91, 102, 74, 83, 90, 75, 78, 86, 72, 
  85, 100, 82, 77, 87, 95, 88, 81, 97, 72, 
  82, 82, 86, 79, 80, 101, 91, 86, 97, 93, 
  88, 73, 85, 83, 72, 80, 91, 88, 70, 66, 
  89, 76, 77, 100, 84, 77, 70, 88, 91, 83, 
  80, 94, 67, 87, 69, 80, 74, 87, 100, 87, 
  88, 91, 78, 67, 86, 92, 94, 65, 75, 74, 
  89, 94, 97, 68, 77, 86, 93, 90, 79, 93, 
  72, 89, 83, 83, 78, 89, 94, 81, 75, 83, 
  73, 90, 69, 98, 90, 75, 88, 83, 81, 88, 
  77, 82, 88, 73, 81, 87, 83, 68, 83, 102, 
  70, 99, 75, 63, 58, 99, 79, 88, 101, 83, 
  74, 78, 86, 79, 87, 86, 71, 90, 80, 101, 
  68, 86, 78, 82, 88, 82, 93, 98, 84, 85, 
  79, 83, 84, 99, 86, 85, 95, 85, 83, 68, 
  95, 75, 78, 97, 88, 76, 89, 74, 85, 81, 
  76, 72, 79, 89, 99, 89, 76, 70, 92, 77, 
  70, 84, 74, 83, 74, 94, 92, 86, 93, 97, 
  71, 80, 75, 79, 83, 83, 87, 102, 86, 82, 
  93, 72, 90, 89, 100, 83, 76, 81, 84, 103, 
  82, 77, 77, 83, 89, 90, 72, 85, 75, 92, 
  91, 85, 105, 94, 90, 87, 83, 107, 81, 89, 
  88, 95, 80, 78, 85, 86, 88, 78, 81, 80, 
  92, 87, 86, 89, 83, 79, 87, 82, 74, 81, 
  81, 78, 81, 96, 81, 87, 90, 82, 69, 82, 
  85, 96, 79, 88, 68, 81, 77, 93, 68, 85, 
  68, 83, 87, 79, 96, 90, 69, 87, 60, 73, 
  80, 77, 76, 82, 98, 101, 80, 69, 87, 60, 
  71, 90, 79, 76, 86, 81, 74, 82, 72, 78, 
  87, 81, 87, 93, 76, 74, 87, 70, 76, 85, 
  81, 84, 79, 92, 85, 82, 91, 97, 84, 80, 
  93, 82, 80, 83, 90, 124, 92, 106, 72, 84, 
  72, 86, 114, 79, 76, 83, 75, 99, 84, 80, 
  77, 84, 81, 91, 63, 71, 81, 81, 92, 87, 
  73, 97, 85, 85, 96, 98, 89, 83, 82, 87, 
  76, 80, 78, 106, 87, 83, 84, 80, 92, 88, 
  80, 88, 82, 71, 84, 77, 76, 74, 76, 68, 
  82, 98, 81, 87, 88, 79, 65, 86, 84, 90, 
  77, 91, 72, 79, 98, 97, 73, 86, 79, 86, 
  80, 84, 84, 92, 85, 94, 84, 83, 88, 105, 
  78, 86, 92, 79, 87, 75, 87, 78, 78, 97, 
  82, 84, 88, 90, 88, 80, 78, 88, 79, 86, 
  84, 92, 78, 72, 93, 77, 77, 85, 68, 80, 
  77, 96, 93, 80, 92, 89, 78, 84, 70, 81, 
  86, 78, 86, 88, 85, 84, 95, 71, 78, 84, 
  92, 83, 78, 81, 83, 97, 86, 77, 75, 79, 
  86, 88, 76, 83, 77, 91, 85, 91, 79, 88, 
  89, 89, 85, 101, 86, 83, 78, 90, 81, 78, 
  89, 82, 92, 90, 78, 82, 94, 89, 88, 89, 
  79, 85, 86, 82, 68, 97, 80, 77, 67, 97, 
  81, 86, 94, 86, 82, 78, 87, 91, 82, 86, 
  97, 91, 86, 83, 92, 73, 77, 74, 82, 87, 
  76, 80, 121, 69, 70, 79, 84, 91, 86, 92, 
  69, 99, 68, 81, 86, 80, 105, 85, 100, 83, 
  75, 73, 78, 91, 80, 92, 102, 84, 86, 106, 
  88, 86, 99, 85, 103, 81, 83, 91, 88, 90, 
  75, 81, 85, 74, 75, 87, 76, 62, 102, 81, 
  77, 79, 96, 88, 67, 84, 88, 91, 72, 85, 
  102, 90, 80, 78, 74, 92, 82, 104, 73, 70, 
  84, 68, 92, 104, 84, 82, 91, 82, 82, 93, 
  74, 78, 86, 88, 98, 65, 86, 85, 95, 94, 
  71, 72, 79, 82, 93, 60, 77, 84, 71, 76, 
  93, 71, 81, 87, 79, 84, 89, 86, 95, 73, 
  80, 72, 77, 82, 82, 72, 77, 77, 77, 77, 
  84, 85, 94, 77, 72, 84, 74, 95, 87, 77, 
  68, 76, 68, 85, 71, 78, 79, 94, 89, 96, 
  68, 81, 78, 75, 102, 86, 98, 90, 66, 77, 
  87, 109, 81, 116, 100, 96, 82, 81, 106, 71, 
  75, 73, 130, 86, 83, 90, 108, 78, 61, 57, 
  77, 77, 68, 64, 105, 64, 124, 86, 80, 146, 
  113, 72, 71, 83, 93, 112, 79, 79, 71, 90, 
  100, 70, 74, 119, 86, 90, 57, 58, 81, 61, 
  85, 95, 74, 82, 94, 94, 58, 89, 87, 92, 
  96, 89, 122, 65, 82, 99, 81, 108, 76, 81, 
  94, 84, 85, 62, 80, 74, 68, 62, 73, 68, 
  92, 92, 74, 79, 96, 89, 95, 70, 79, 63, 
  71, 99, 73, 76, 63, 67, 91, 75, 101, 81, 
  85, 79, 82, 80, 81, 84, 79, 80, 113, 87, 
  68, 77, 87, 85, 83, 86, 98, 89, 75, 81, 
  77, 78, 99, 86, 92, 87, 83, 89, 77, 93, 
  86, 101, 105, 86, 84, 102, 77, 85, 78, 89, 
  96, 86, 86, 103, 86, 86, 81, 89, 82, 73, 
  73, 69, 79, 76, 108, 85, 76, 79, 94, 83, 
  77, 82, 83, 91, 79, 91, 82, 86, 82, 79, 
  79, 89, 84, 88, 69, 71, 88, 80, 87, 86, 
  83, 81, 89, 83, 84, 87, 81, 76, 85, 84, 
  85, 73, 87, 83, 86, 89, 76, 79, 78, 82, 
  91, 66, 78, 82, 72, 78, 93, 71, 84, 92, 
  83, 82, 74, 79, 93, 71, 96, 76, 80, 80, 
  87, 75, 72, 75, 97, 88, 52, 77, 74, 83, 
  78, 73, 67, 88, 87, 70, 109, 74, 70, 83, 
  78, 94, 83, 83, 70, 84, 73, 87, 77, 79, 
  103, 92, 89, 95, 79, 75, 70, 71, 97, 83, 
  99, 84, 91, 79, 93, 87, 80, 94, 85, 76, 
  97, 84, 79, 79, 93, 76, 90, 78, 80, 112, 
  70, 92, 75, 85, 90, 70, 84, 81, 70, 74, 
  90, 85, 77, 73, 100, 89, 71, 78, 86, 68, 
  78, 85, 86, 75, 87, 96, 82, 75, 86, 75, 
  80, 74, 90, 88, 62, 71, 82, 89, 82, 69, 
  95, 85, 118, 70, 67, 86, 69, 84, 98, 75, 
  74, 84, 94, 88, 85, 75, 74, 74, 98, 89, 
  74, 88, 91, 68, 81, 72, 65, 88, 80, 80, 
  88, 107, 100, 81, 85, 71, 71, 68, 76, 82, 
  66, 86, 89, 76, 84, 83, 62, 85, 68, 93, 
  85, 76, 71, 82, 68, 79, 76, 77, 114, 88, 
  86, 91, 83, 87, 67, 75, 91, 79, 106, 77, 
  79, 68, 102, 84, 71, 87, 91, 71, 114, 78, 
  84, 69, 92, 81, 84, 78, 81, 98, 79, 94, 
  82, 92, 87, 76, 104, 71, 72, 69, 86, 79, 
  72, 83, 83, 86, 74, 72, 85, 65, 76, 78, 
  91, 65, 81, 102, 81, 74, 86, 76, 72, 77, 
  104, 92, 67, 75, 84, 83, 100, 65, 98, 93, 
  82, 67, 75, 76, 67, 82, 92, 80, 70, 81, 
  98, 79, 98, 70, 76, 73, 102, 87, 74, 82, 
  82, 64, 87, 70, 74, 89, 76, 87, 74, 105, 
  88, 82, 113, 76, 76, 76, 81, 75, 72, 86, 
  82, 73, 100, 91, 71, 83, 79, 95, 81, 83, 
  77, 82, 80, 87, 80, 79, 94, 89, 86, 92, 
  93, 95, 68, 71, 91, 79, 95, 87, 73, 80, 
  89, 90, 76, 92, 83, 82, 109, 92, 79, 80, 
  93, 87, 88, 78, 78, 74, 65, 97, 81, 85, 
  88, 68, 81, 83, 75, 71, 92, 86, 76, 76, 
  70, 85, 73, 79, 87, 70, 80, 73, 83, 75, 
  89, 100, 79, 80, 87, 78, 72, 76, 93, 89, 
  61, 60, 81, 89, 83, 75, 98, 83, 67, 73, 
  73, 77, 69, 83, 98, 81, 68, 80, 93, 89, 
  107, 77, 79, 79, 99, 90, 68, 89, 87, 64, 
  89, 71, 72, 87, 85, 80, 86, 99, 71, 85, 
  67, 95, 86, 94, 67, 74, 88, 88, 79, 78, 
  90, 85, 81, 84, 86, 96, 83, 75, 93, 89, 
  78, 84, 84, 86, 82, 87, 91, 98, 85, 85, 
  78, 79, 82, 90, 92, 87, 76, 83, 91, 91, 
  80, 97, 80, 87, 74, 81, 76, 89, 85, 87, 
  90, 90, 92, 90, 74, 83, 80, 78, 85, 95, 
  78, 74, 95, 90, 88, 84, 93, 70, 88, 95, 
  78, 85, 87, 74, 78, 85, 75, 84, 86, 94, 
  84, 83, 83, 84, 82, 84, 80, 85, 81, 91, 
  83, 89, 90, 85, 84, 79, 99, 93, 76, 100, 
  76, 86, 86, 79, 81, 93, 76, 89, 77, 97, 
  85, 85, 90, 81, 79, 92, 80, 87, 91, 83, 
  79, 89, 91, 80, 91, 102, 71, 87, 78, 94, 
  82, 75, 71, 80, 91, 80, 82, 85, 96, 88, 
  85, 83, 88, 100, 87, 72, 84, 87, 79, 83, 
  93, 88, 85, 86, 87, 84, 94, 96, 82, 78, 
  81, 79, 84, 85, 88, 75, 86, 100, 84, 98, 
  79, 75, 87, 86, 77, 83, 85, 86, 89, 89, 
  87, 87, 76, 90, 81, 83, 82, 88, 77, 74, 
  82, 91, 103, 85, 96, 70, 74, 87, 75, 84, 
  88, 68, 79, 88, 78, 81, 87, 98, 85, 79, 
  85, 85, 78, 79, 89, 88, 83, 83, 84, 89, 
  86, 82, 83, 87, 92, 85, 71, 97, 68, 85, 
  88, 92, 84, 90, 84, 93, 76, 96, 86, 79, 
  91, 91, 78, 91, 85, 80, 88, 87, 87, 90, 
  94, 82, 96, 110, 68, 86, 95, 93, 88, 74, 
  70, 76, 90, 87, 74, 79, 91, 81, 82, 85, 
  90, 97, 82, 78, 80, 91, 90, 84, 91, 84, 
  79, 85, 85, 83, 83, 93, 79, 79, 89, 77, 
  88, 86, 83, 84, 94, 90, 93, 94, 82, 82, 
  85, 89, 77, 87, 84, 79, 87, 88, 84, 76, 
  72, 84, 86, 80, 85, 90, 76, 81, 92, 88, 
  92, 91, 90, 84, 78, 94, 83, 84, 85, 76, 
  80, 84, 76, 85, 83, 94, 79, 88, 87, 84, 
  79, 86, 78, 87, 77, 74, 85, 88, 86, 89, 
  79, 79, 74, 91, 76, 76, 77, 86, 87, 82, 
  81, 90, 75, 90, 72, 98, 85, 81, 95, 85, 
  93, 94, 79, 86, 86, 85, 80, 90, 95, 81, 
  90, 96, 70, 94, 87, 90, 82, 85, 85, 76, 
  72, 92, 74, 75, 80, 115, 69, 68, 71, 98, 
  83, 90, 87, 86, 90, 80, 86, 78, 87, 100, 
  116, 93, 73, 97, 75, 86, 74, 97, 87, 64, 
  94, 69, 87, 61, 79, 69, 70, 80, 83, 86, 
  83, 73, 88, 86, 73, 75, 72, 73, 65, 82, 
  83, 97, 82, 78, 96, 84, 103, 63, 91, 78, 
  82, 122, 73, 78, 104, 71, 77, 72, 74, 76, 
  119, 61, 82, 106, 76, 94, 82, 95, 80, 104, 
  79, 92, 82, 85, 69, 76, 93, 73, 82, 70, 
  72, 76, 78, 79, 94, 110, 125, 81, 79, 86, 
  94, 72, 78, 70, 84, 95, 81, 114, 105, 91, 
  83, 90, 89, 73, 78, 75, 85, 70, 84, 89, 
  75, 95, 78, 82, 92, 77, 85, 74, 77, 85, 
  71, 84, 84, 99, 81, 70, 72, 88, 67, 86, 
  87, 75, 78, 80, 87, 80, 80, 107, 93, 98, 
  73, 92, 75, 81, 83, 77, 93, 71, 95, 80, 
  72, 65, 85, 72, 73, 79, 75, 75, 80, 72, 
  91, 90, 75, 78, 66, 74, 54, 85, 90, 94, 
  75, 73, 99, 71, 95, 66, 95, 68, 79, 89, 
  83, 75, 92, 68, 82, 63, 70, 89, 126, 69, 
  84, 111, 67, 90, 75, 87, 87, 99, 85, 95, 
  81, 89, 68, 79, 76, 76, 81, 78, 80, 78, 
  78, 89, 88, 107, 137, 77, 75, 90, 93, 81, 
  87, 64, 89, 79, 74, 103, 84, 93, 73, 84, 
  101, 77, 84, 69, 90, 79, 79, 88, 81, 73, 
  76, 78, 84, 82, 87, 74, 71, 83, 71, 83, 
  77, 89, 80, 68, 71, 90, 81, 90, 83, 79, 
  70, 81, 79, 82, 89, 93, 95, 91, 77, 86, 
  78, 80, 82, 85, 104, 65, 87, 78, 84, 70, 
  80, 72, 74, 91, 85, 81, 83, 73, 91, 79, 
  77, 80, 75, 76, 68, 86, 84, 94, 81, 85, 
  96, 92, 114, 71, 89, 74, 85, 96, 100, 75, 
  104, 67, 81, 69, 74, 93, 120, 69, 84, 102, 
  75, 88, 83, 81, 100, 95, 79, 94, 81, 98, 
  74, 77, 91, 78, 89, 79, 78, 78, 78, 104, 
  92, 106, 122, 76, 79, 88, 93, 78, 88, 74, 
  87, 79, 79, 100, 75, 90, 81, 88, 95, 77, 
  80, 71, 85, 78, 85, 84, 82, 86, 80, 92, 
  86, 90, 87, 67, 83, 78, 78, 73, 86, 103, 
  86, 71, 80, 81, 82, 72, 86, 79, 75, 89, 
  83, 87, 76, 94, 88, 88, 85, 88, 82, 85, 
  83, 89, 83, 76, 89, 77, 77, 68, 73, 77, 
  82, 83, 84, 87, 84, 74, 95, 79, 73, 80, 
  68, 93, 64, 92, 71, 94, 83, 83, 81, 99, 
  96, 86, 78, 67, 79, 77, 79, 82, 79, 87, 
  81, 71, 80, 77, 97, 81, 84, 96, 73, 83, 
  82, 80, 77, 89, 86, 90, 75, 70, 75, 75, 
  73, 84, 87, 94, 79, 78, 74, 75, 76, 99, 
  106, 84, 84, 80, 92, 83, 95, 82, 100, 80, 
  66, 88, 93, 95, 83, 99, 103, 86, 70, 77, 
  80, 96, 83, 92, 98, 83, 74, 82, 86, 74, 
  83, 72, 82, 69, 80, 86, 96, 88, 96, 71, 
  88, 85, 80, 73, 79, 80, 78, 85, 77, 81, 
  75, 92, 78, 87, 89, 97, 93, 82, 97, 70, 
  87, 73, 94, 82, 76, 77, 79, 85, 94, 84, 
  79, 87, 86, 72, 96, 83, 73, 78, 68, 85, 
  74, 90, 79, 92, 81, 85, 80, 93, 75, 99, 
  83, 75, 81, 73, 74, 77, 75, 86, 80, 68, 
  77, 93, 81, 91, 84, 88, 77, 87, 83, 77, 
  73, 83, 73, 96, 72, 69, 79, 80, 68, 86, 
  82, 108, 80, 89, 76, 86, 75, 96, 77, 91, 
  83, 79, 87, 90, 94, 79, 104, 71, 74, 85, 
  81, 102, 73, 90, 100, 88, 72, 79, 75, 95, 
  77, 100, 90, 80, 79, 88, 84, 81, 82, 67, 
  80, 76, 73, 81, 84, 81, 90, 68, 79, 80, 
  81, 80, 79, 80, 77, 85, 78, 80, 79, 88, 
  77, 81, 86, 104, 91, 82, 95, 84, 87, 78, 
  91, 76, 80, 78, 88, 86, 87, 83, 88, 98, 
  83, 71, 92, 81, 78, 80, 72, 78, 73, 88, 
  77, 84, 82, 88, 85, 105, 100, 88, 77, 69, 
  88, 77, 89, 80, 83, 84, 82, 73, 77, 89, 
  94, 84, 88, 92, 81, 80, 87, 73, 77, 83, 
  89, 87, 79, 75, 76, 79, 78, 87, 86, 92, 
  79, 79, 71, 82, 77, 94, 98, 77, 82, 80, 
  88, 86, 101, 85, 100, 79, 80, 82, 81, 98, 
  83, 91, 92, 84, 75, 78, 82, 94, 89, 89, 
  85, 82, 78, 95, 84, 99, 84, 75, 82, 80, 
  80, 77, 89, 87, 84, 68, 87, 84, 86, 79, 
  84, 82, 73, 86, 79, 87, 88, 87, 83, 90, 
  92, 85, 86, 90, 89, 90, 84, 81, 85, 77, 
  83, 94, 76, 85, 89, 86, 93, 87, 80, 81, 
  99, 82, 83, 83, 86, 94, 68, 87, 70, 89, 
  93, 86, 80, 100, 95, 92, 79, 75, 82, 77, 
  95, 98, 84, 88, 85, 81, 85, 81, 87, 90, 
  88, 78, 80, 85, 89, 84, 80, 84, 87, 76, 
  74, 79, 79, 74, 81, 84, 82, 89, 94, 80, 
  75, 83, 76, 98, 83, 83, 89, 86, 83, 91, 
  94, 90, 93, 76, 79, 83, 93, 89, 81, 93, 
  90, 87, 72, 75, 81, 97, 91, 91, 95, 80, 
  82, 90, 78, 84, 82, 80, 80, 75, 84, 90, 
  100, 85, 82, 63, 94, 92, 89, 87, 81, 85, 
  82, 79, 79, 82, 94, 81, 76, 88, 96, 93, 
  92, 86, 97, 81, 90, 75, 83, 64, 85, 102, 
  83, 97, 94, 86, 91, 87, 83, 76, 89, 79, 
  88, 79, 92, 88, 82, 82, 75, 84, 94, 88, 
  82, 95, 79, 98, 79, 83, 83, 80, 82, 92, 
  82, 87, 92, 83, 75, 93, 80, 87, 87, 68, 
  88, 85, 96, 81, 80, 82, 75, 81, 79, 76, 
  79, 76, 79, 83, 76, 85, 90, 82, 80, 84, 
  77, 96, 59, 85, 90, 87, 76, 95, 90, 86, 
  95, 76, 86, 84, 90, 92, 75, 93, 86, 82, 
  77, 79, 80, 90, 87, 95, 86, 83, 86, 92, 
  83, 84, 79, 77, 81, 80, 81, 81, 86, 83, 
  81, 67, 88, 86, 87, 87, 78, 82, 87, 82, 
  80, 81, 90, 85, 76, 77, 90, 94, 92, 84, 
  98, 87, 84, 85, 80, 71, 87, 97, 83, 92, 
  87, 85, 93, 88, 82, 76, 92, 81, 90, 82, 
  94, 82, 79, 84, 77, 87, 90, 94, 84, 103, 
  95, 89, 79, 77, 85, 79, 85, 93, 89, 84, 
  87, 93, 80, 94, 87, 87, 91, 73, 90, 79, 
  94, 84, 81, 85, 87, 79, 81, 76, 82, 77, 
  84, 85, 80, 80, 82, 80, 76, 82, 75, 95, 
  85, 81, 84, 86, 82, 93, 92, 93, 92, 83, 
  84, 85, 90, 88, 82, 95, 84, 90, 78, 76, 
  89, 94, 96, 90, 89, 78, 85, 82, 103, 97, 
  91, 81, 81, 71, 79, 72, 71, 76, 86, 81, 
  85, 77, 78, 81, 82, 65, 65, 74, 87, 93, 
  82, 74, 87, 90, 81, 86, 91, 83, 69, 80, 
  83, 87, 83, 80, 84, 100, 86, 92, 84, 80, 
  97, 98, 94, 91, 86, 85, 80, 89, 74, 79, 
  100, 83, 87, 95, 77, 87, 85, 78, 85, 90, 
  74, 83, 88, 70, 72, 84, 90, 77, 85, 83, 
  87, 61, 84, 102, 86, 89, 85, 86, 93, 81, 
  81, 73, 91, 81, 75, 78, 74, 97, 85, 92, 
  79, 95, 90, 84, 82, 72, 84, 82, 83, 84, 
  93, 84, 89, 86, 84, 91, 86, 87, 86, 84, 
  82, 83, 90, 85, 70, 90, 90, 95, 79, 82, 
  90, 78, 77, 86, 93, 81, 75, 79, 80, 84, 
  94, 79, 74, 77, 74, 74, 74, 79, 73, 77, 
  84, 88, 92, 86, 95, 82, 78, 101, 85, 82, 
  97, 72, 78, 90, 81, 65, 72, 85, 76, 93, 
  85, 86, 72, 89, 84, 85, 82, 83, 84, 90, 
  85, 88, 88, 92, 86, 74, 83, 67, 112, 80, 
  100, 89, 80, 72, 82, 79, 80, 72, 85, 82, 
  79, 83, 67, 78, 103, 82, 81, 90, 80, 65, 
  73, 94, 79, 86, 87, 102, 78, 72, 86, 81, 
  83, 87, 86, 72, 78, 86, 83, 80, 76, 83, 
  86, 84, 73, 72, 84, 77, 85, 78, 92, 88, 
  75, 94, 85, 77, 88, 87, 62, 83, 93, 75, 
  86, 90, 82, 87, 90, 89, 84, 80, 90, 78, 
  99, 83, 101, 90, 81, 82, 72, 79, 90, 78, 
  79, 80, 98, 82, 74, 87, 70, 83, 89, 89, 
  95, 105, 98, 80, 82, 81, 97, 83, 83, 80, 
  90, 82, 82, 91, 88, 87, 90, 93, 88, 87, 
  83, 90, 79, 80, 91, 76, 77, 96, 79, 83, 
  75, 100, 78, 76, 73, 70, 86, 79, 96, 93, 
  92, 74, 84, 87, 75, 76, 69, 85, 84, 104, 
  67, 93, 93, 86, 76, 83, 77, 86, 77, 78, 
  78, 86, 89, 90, 82, 73, 94, 94, 72, 79, 
  82, 88, 80, 85, 79, 74, 87, 90, 95, 73, 
  90, 78, 79, 79, 75, 71, 80, 89, 75, 88, 
  87, 74, 77, 80, 73, 77, 89, 81, 80, 79, 
  87, 73, 85, 86, 88, 87, 93, 74, 84, 76, 
  73, 78, 99, 97, 96, 85, 79, 71, 82, 78, 
  78, 86, 80, 80, 83, 86, 81, 78, 83, 76, 
  79, 84, 80, 86, 79, 75, 88, 90, 80, 83, 
  95, 85, 66, 87, 62, 79, 78, 73, 73, 93, 
  90, 90, 88, 88, 90, 106, 90, 97, 88, 88, 
  79, 82, 78, 64, 88, 79, 89, 96, 81, 81, 
  82, 60, 70, 90, 69, 74, 88, 68, 73, 88, 
  86, 82, 86, 86, 86, 75, 69, 108, 88, 86, 
  85, 84, 84, 80, 83, 69, 87, 82, 85, 71, 
  73, 85, 82, 91, 77, 95, 88, 81, 77, 67, 
  80, 81, 86, 79, 88, 84, 88, 89, 87, 89, 
  86, 91, 62, 89, 90, 83, 85, 88, 76, 91, 
  93, 95, 80, 77, 89, 88, 89, 80, 82, 83, 
  72, 87, 75, 77, 84, 84, 75, 78, 80, 95, 
  74, 70, 73, 89, 82, 91, 90, 88, 127, 80, 
  77, 89, 86, 83, 92, 65, 68, 89, 84, 69, 
  101, 98, 75, 78, 74, 72, 60, 103, 90, 85, 
  77, 86, 78, 86, 78, 97, 77, 83, 82, 67, 
  81, 50, 96, 67, 99, 95, 83, 65, 76, 63, 
  71, 77, 93, 82, 79, 85, 73, 92, 87, 90, 
  84, 83, 93, 114, 62, 96, 78, 72, 81, 105, 
  74, 72, 99, 92, 65, 88, 83, 63, 76, 83, 
  99, 79, 74, 78, 81, 78, 76, 63, 88, 77, 
  82, 70, 83, 87, 76, 99, 78, 76, 82, 98, 
  45, 104, 105, 76, 80, 81, 85, 100, 89, 78, 
  77, 71, 89, 95, 121, 72, 84, 107, 81, 73, 
  73, 72, 88, 81, 87, 79, 100, 109, 74, 81, 
  63, 77, 96, 85, 99, 85, 98, 84, 91, 74, 
  100, 83, 79, 80, 102, 90, 88, 106, 111, 73, 
  114, 92, 80, 60, 84, 104, 84, 83, 81, 79, 
  91, 78, 79, 79, 69, 88, 76, 75, 77, 78, 
  72, 77, 92, 99, 89, 78, 84, 92, 83, 76, 
  86, 95, 89, 97, 71, 91, 73, 97, 78, 75, 
  94, 109, 92, 67, 77, 86, 83, 69, 89, 87, 
  96, 108, 83, 76, 81, 90, 85, 92, 87, 81, 
  91, 74, 91, 71, 96, 81, 86, 80, 93, 81, 
  75, 101, 94, 84, 84, 83, 75, 77, 95, 104, 
  79, 91, 85, 75, 94, 66, 82, 79, 85, 88, 
  96, 84, 89, 71, 59, 78, 101, 106, 94, 87, 
  81, 71, 86, 75, 71, 76, 84, 79, 82, 96, 
  86, 75, 79, 73, 74, 75, 77, 83, 86, 75, 
  87, 86, 83, 88, 98, 95, 73, 89, 77, 87, 
  83, 74, 81, 103, 94, 93, 88, 84, 90, 108, 
  94, 86, 87, 87, 77, 85, 79, 80, 91, 84, 
  86, 96, 86, 76, 80, 67, 76, 95, 82, 70, 
  92, 69, 92, 98, 83, 77, 83, 83, 96, 91, 
  60, 113, 89, 87, 90, 79, 86, 74, 89, 66, 
  86, 82, 88, 90, 67, 88, 87, 91, 89, 103, 
  88, 87, 81, 77, 80, 82, 82, 75, 85, 86, 
  88, 87, 78, 88, 83, 91, 62, 89, 82, 93, 
  93, 81, 69, 93, 87, 88, 76, 70, 91, 90, 
  91, 86, 52, 85, 80, 86, 86, 83, 79, 84, 
  79, 84, 75, 81, 76, 75, 73, 92, 90, 78, 
  75, 78, 86, 71, 76, 90, 92, 85, 92, 58, 
  71, 92, 96, 78, 120, 94, 95, 88, 73, 77, 
  75, 100, 100, 89, 79, 94, 87, 77, 86, 99, 
  80, 81, 85, 74, 83, 70, 98, 75, 98, 91, 
  89, 72, 80, 73, 70, 82, 81, 82, 80, 67, 
  103, 86, 88, 91, 85, 90, 85, 111, 82, 92, 
  82, 77, 85, 84, 80, 66, 96, 83, 75, 87, 
  93, 80, 75, 87, 109, 76, 78, 83, 79, 87, 
  79, 75, 93, 76, 76, 69, 78, 94, 79, 96, 
  68, 80, 83, 87, 56, 93, 61, 79, 87, 82, 
  70, 95, 90, 80, 82, 66, 87, 105, 102, 75, 
  61, 101, 93, 74, 79, 77, 75, 80, 76, 88, 
  81, 87, 64, 79, 62, 71, 87, 81, 94, 76, 
  93, 81, 86, 76, 106, 88, 87, 73, 88, 90, 
  87, 106, 85, 76, 87, 91, 83, 70, 88, 84, 
  80, 82, 75, 95, 90, 78, 92, 85, 78, 85, 
  85, 79, 77, 96, 80, 77, 91, 77, 101, 98, 
  89, 87, 85, 79, 84, 93, 90, 83, 91, 67, 
  86, 101, 78, 81, 90, 96, 113, 66, 80, 88, 
  76, 70, 77, 86, 92, 103, 86, 78, 92, 100, 
  84, 90, 98, 82, 82, 72, 76, 81, 79, 91, 
  84, 79, 93, 98, 79, 99, 90, 83, 77, 86, 
  80, 77, 91, 104, 70, 76, 79, 95, 84, 73, 
  82, 80, 90, 92, 82, 81, 94, 87, 75, 72, 
  93, 66, 81, 93, 81, 81, 79, 92, 88, 83, 
  77, 82, 85, 73, 86, 86, 79, 89, 73, 69, 
  89, 91, 94, 63, 86, 82, 93, 67, 91, 92, 
  74, 69, 88, 74, 88, 92, 77, 63, 91, 97, 
  96, 83, 95, 88, 95, 96, 75, 80, 84, 80, 
  83, 86, 90, 76, 94, 93, 71, 82, 103, 52, 
  81, 80, 83, 100, 74, 71, 87, 65, 107, 62, 
  82, 73, 75, 85, 71, 81, 95, 93, 101, 96, 
  90, 142, 70, 69, 94, 89, 91, 78, 83, 98, 
  90, 83, 92, 75, 98, 86, 80, 71, 91, 87, 
  66, 70, 92, 92, 73, 87, 83, 81, 58, 134, 
  88, 105, 82, 88, 99, 97, 83, 80, 76, 89, 
  78, 55, 76, 96, 88, 83, 81, 87, 71, 69, 
  86, 76, 83, 83, 75, 93, 68, 80, 72, 85, 
  67, 87, 92, 88, 85, 96, 102, 65, 79, 80, 
  91, 86, 104, 80, 88, 76, 73, 90, 64, 74, 
  75, 66, 89, 69, 83, 54, 78, 92, 80, 80, 
  81, 94, 83, 90, 82, 82, 77, 71, 84, 84, 
  81, 72, 97, 77, 91, 80, 99, 63, 74, 80, 
  83, 98, 63, 76, 77, 71, 97, 80, 77, 87, 
  101, 88, 65, 70, 91, 80, 84, 94, 88, 117, 
  73, 92, 79, 79, 85, 90, 97, 84, 81, 94, 
  94, 71, 91, 80, 80, 69, 119, 87, 104, 65, 
  86, 90, 61, 84, 76, 82, 70, 102, 81, 95, 
  94, 100, 80, 94, 74, 83, 74, 78, 84, 46, 
  76, 82, 99, 81, 83, 94, 86, 81, 84, 77, 
  89, 67, 74, 90, 89, 76, 69, 83, 74, 88, 
  104, 85, 90, 96, 91, 74, 93, 84, 87, 91, 
  87, 74, 96, 92, 74, 97, 72, 82, 85, 75, 
  84, 75, 82, 62, 74, 87, 83, 84, 89, 86, 
  78, 74, 89, 87, 72, 81, 89, 81, 71, 77, 
  83, 75, 94, 83, 98, 78, 75, 86, 83, 92, 
  73, 82, 80, 73, 85, 76, 78, 80, 94, 89, 
  65, 77, 88, 76, 82, 91, 94, 103, 78, 94, 
  77, 84, 69, 99, 96, 84, 78, 83, 98, 85, 
  93, 90, 88, 81, 108, 90, 118, 77, 78, 95, 
  84, 88, 76, 92, 87, 84, 94, 87, 86, 87, 
  83, 91, 86, 80, 85, 81, 94, 59, 84, 81, 
  85, 88, 83, 72, 83, 65, 80, 78, 79, 78, 
  78, 91, 74, 83, 78, 81, 82, 73, 88, 89, 
  75, 91, 72, 71, 87, 84, 84, 77, 92, 82, 
  87, 83, 82, 88, 68, 69, 82, 74, 86, 88, 
  78, 72, 80, 89, 80, 82, 88, 88, 96, 91, 
  77, 81, 84, 79, 84, 79, 82, 77, 91, 87, 
  73, 88, 100, 55, 76, 84, 76, 100, 82, 91, 
  82, 78, 92, 71, 83, 84, 84, 97, 72, 81, 
  89, 87, 88, 93, 86, 105, 72, 80, 86, 88, 
  92, 75, 86, 91, 88, 77, 93, 79, 92, 86, 
  80, 70, 87, 89, 93, 79, 94, 90, 71, 86, 
  74, 83, 74, 143, 85, 93, 88, 88, 87, 96, 
  78, 86, 81, 86, 80, 68, 80, 89, 85, 83, 
  84, 94, 67, 74, 86, 60, 92, 61, 75, 89, 
  73, 75, 80, 86, 71, 86, 91, 87, 95, 92, 
  99, 71, 80, 77, 84, 109, 105, 83, 83, 94, 
  63, 84, 72, 74, 80, 90, 82, 69, 75, 75, 
  70, 83, 80, 88, 77, 95, 81, 81, 86, 78, 
  74, 76, 87, 75, 70, 80, 81, 85, 78, 82, 
  86, 68, 86, 86, 73, 91, 76, 88, 80, 79, 
  77, 83, 85, 90, 105, 95, 72, 82, 84, 81, 
  71, 86, 79, 77, 69, 100, 74, 71, 75, 79, 
  92, 89, 70, 87, 82, 89, 84, 78, 78, 65, 
  111, 90, 135, 85, 89, 89, 75, 82, 81, 84, 
  84, 97, 77, 79, 86, 102, 68, 91, 78, 91, 
  82, 76, 89, 64, 76, 81, 96, 85, 74, 101, 
  79, 81, 87, 68, 90, 44, 82, 81, 92, 74, 
  78, 85, 80, 88, 98, 81, 94, 92, 82, 75, 
  88, 84, 90, 103, 88, 82, 79, 103, 83, 83, 
  86, 76, 87, 97, 82, 72, 73, 86, 80, 82, 
  89, 82, 84, 82, 74, 80, 97, 75, 74, 90, 
  96, 79, 63, 92, 73, 80, 80, 91, 89, 84, 
  84, 96, 81, 83, 77, 84, 81, 75, 72, 76, 
  83, 80, 87, 91, 79, 89, 87, 84, 76, 90, 
  87, 80, 76, 86, 79, 79, 73, 76, 83, 84, 
  68, 81, 83, 101, 90, 89, 80, 78, 89, 90, 
  116, 93, 84, 94, 89, 95, 89, 90, 95, 75, 
  85, 82, 77, 95, 79, 95, 75, 84, 103, 81, 
  102, 77, 74, 90, 83, 97, 83, 73, 88, 75, 
  78, 76, 84, 69, 83, 83, 75, 78, 74, 75, 
  83, 71, 96, 83, 79, 89, 69, 74, 98, 85, 
  85, 73, 82, 78, 90, 93, 80, 94, 75, 68, 
  83, 75, 87, 87, 86, 72, 85, 84, 84, 84, 
  90, 87, 92, 85, 85, 83, 75, 87, 79, 88, 
  85, 85, 90, 88, 76, 88, 98, 71, 84, 83, 
  83, 89, 79, 82, 87, 79, 91, 77, 83, 84, 
  82, 104, 70, 85, 87, 82, 94, 99, 83, 98, 
  73, 78, 87, 90, 91, 75, 86, 90, 83, 69, 
  95, 82, 91, 88, 84, 74, 83, 89, 88, 80, 
  89, 88, 89, 91, 82, 86, 81, 126, 80, 89, 
  88, 83, 94, 91, 80, 87, 86, 93, 79, 83, 
  91, 84, 82, 92, 82, 91, 73, 83, 81, 65, 
  87, 53, 83, 86, 80, 75, 69, 82, 71, 80, 
  95, 85, 97, 89, 94, 74, 93, 83, 91, 89, 
  95, 77, 88, 94, 76, 92, 73, 71, 84, 86, 
  75, 78, 85, 77, 74, 83, 85, 92, 84, 92, 
  81, 81, 87, 83, 70, 87, 86, 80, 83, 78, 
  85, 88, 72, 86, 91, 77, 90, 87, 78, 86, 
  82, 76, 90, 81, 85, 83, 84, 95, 83, 89, 
  79, 91, 85, 81, 81, 93, 79, 88, 75, 91, 
  72, 83, 83, 77, 86, 84, 71, 78, 85, 81, 
  84, 86, 83, 78, 82, 87, 100, 84, 86, 88, 
  85, 95, 94, 89, 90, 88, 75, 84, 83, 85, 
  80, 91, 81, 94, 90, 84, 91, 90, 82, 77, 
  86, 86, 72, 94, 80, 87, 79, 74, 80, 49, 
  92, 81, 97, 79, 65, 83, 71, 87, 104, 83, 
  96, 85, 98, 70, 87, 86, 97, 81, 78, 78, 
  86, 95, 87, 92, 80, 69, 86, 84, 77, 78, 
  85, 90, 79, 88, 97, 83, 86, 86, 70, 84, 
  89, 78, 68, 94, 88, 82, 72, 82, 69, 85, 
  77, 84, 94, 86, 91, 95, 82, 87, 84, 76, 
  94, 90, 82, 81, 84, 85, 71, 85, 84, 96, 
  83, 85, 88, 95, 89, 94, 82, 86, 76, 80, 
  81, 76, 80, 84, 72, 80, 83, 84, 87, 93, 
  82, 80, 84, 88, 87, 80, 84, 88, 75, 98, 
  99, 90, 97, 82, 81, 84, 85, 82, 94, 94, 
  74, 85, 92, 84, 101, 91, 88, 82, 88, 62, 
  99, 91, 87, 85, 81, 76, 63, 78, 87, 90, 
  90, 74, 65, 86, 76, 72, 75, 90, 79, 97, 
  93, 94, 89, 107, 86, 88, 93, 104, 89, 85, 
  98, 96, 89, 87, 89, 86, 67, 90, 80, 71, 
  86, 90, 72, 77, 78, 99, 77, 81, 74, 92, 
  81, 89, 92, 82, 82, 78, 82, 75, 83, 86, 
  77, 67, 83, 88, 80, 102, 88, 79, 75, 90, 
  85, 91, 72, 77, 71, 80, 89, 72, 74, 94, 
  75, 82, 67, 78, 92, 82, 104, 94, 77, 89, 
  82, 85, 74, 88, 77, 90, 78, 70, 80, 95, 
  86, 86, 99, 92, 82, 84, 71, 76, 80, 84, 
  80, 86, 97, 86, 96, 94, 75, 95, 96, 80, 
  88, 87, 97, 93, 80, 90, 77, 83, 87, 98, 
  97, 81, 85, 68, 60, 74, 78, 81, 75, 81, 
  68, 71, 76, 76, 76, 93, 93, 81, 89, 91, 
  102, 107, 88, 97, 106, 100, 76, 95, 109, 83, 
  98, 79, 86, 98, 73, 81, 70, 70, 87, 95, 
  70, 77, 77, 93, 62, 73, 78, 69, 84, 96, 
  82, 81, 77, 72, 70, 78, 89, 88, 77, 70, 
  66, 80, 86, 90, 90, 77, 76, 78, 76, 89, 
  77, 64, 67, 85, 84, 79, 66, 100, 80, 87, 
  74, 80, 91, 94, 106, 91, 81, 84, 73, 94, 
  65, 108, 70, 84, 89, 71, 74, 74, 74, 85, 
  91, 84, 89, 86, 74, 74, 79, 85, 83, 91, 
  79, 78, 76, 104, 74, 92, 83, 78, 79, 81, 
  81, 84, 95, 97, 86, 97, 79, 87, 84, 91, 
  81, 79, 60, 79, 82, 88, 91, 69, 65, 93, 
  79, 77, 76, 95, 87, 95, 84, 86, 78, 106, 
  90, 90, 82, 91, 88, 90, 100, 80, 100, 78, 
  88, 87, 70, 91, 77, 68, 83, 84, 79, 79, 
  76, 82, 72, 80, 80, 79, 74, 96, 97, 98, 
  81, 79, 78, 75, 87, 86, 84, 59, 80, 91, 
  87, 97, 88, 83, 97, 91, 87, 90, 76, 74, 
  74, 91, 91, 83, 72, 92, 77, 88, 64, 85, 
  88, 91, 101, 99, 79, 85, 85, 86, 74, 88, 
  80, 91, 88, 68, 80, 65, 86, 84, 94, 94, 
  85, 90, 76, 80, 81, 82, 85, 94, 84, 97, 
  74, 91, 82, 93, 80, 81, 82, 92, 98, 92, 
  78, 91, 85, 63, 78, 99, 102, 82, 77, 66, 
  71, 82, 80, 94, 97, 77, 69, 113, 83, 94, 
  86, 91, 93, 84, 94, 106, 89, 100, 90, 97, 
  114, 98, 91, 82, 98, 101, 78, 82, 74, 94, 
  70, 86, 81, 82, 89, 98, 71, 87, 83, 105, 
  78, 85, 61, 84, 82, 98, 83, 88, 84, 66, 
  78, 81, 85, 75, 73, 61, 80, 77, 92, 97, 
  86, 68, 88, 80, 86, 82, 78, 68, 67, 70, 
  81, 71, 72, 107, 85, 81, 71, 79, 94, 89, 
  86, 93, 74, 93, 71, 86, 64, 77, 78, 72, 
  87, 71, 70, 86, 75, 80, 97, 87, 80, 95, 
  67, 81, 78, 95, 79, 87, 82, 79, 88, 89, 
  76, 77, 89, 77, 102, 75, 84, 87, 85, 85, 
  71, 86, 80, 117, 126, 75, 71, 55, 64, 79, 
  70, 85, 75, 78, 78, 98, 79, 100, 78, 103, 
  100, 69, 81, 94, 108, 112, 82, 107, 119, 92, 
  75, 87, 100, 89, 92, 69, 70, 90, 72, 84, 
  69, 79, 99, 107, 70, 76, 77, 80, 58, 84, 
  68, 58, 73, 112, 70, 73, 69, 57, 69, 86, 
  94, 71, 71, 61, 73, 65, 95, 91, 91, 66, 
  63, 68, 81, 80, 89, 48, 57, 80, 87, 72, 
  66, 123, 90, 82, 82, 85, 94, 98, 87, 92, 
  78, 80, 59, 95, 51, 95, 74, 67, 91, 62, 
  67, 75, 64, 80, 94, 77, 85, 95, 64, 73, 
  81, 94, 81, 96, 69, 69, 64, 95, 68, 81, 
  83, 71, 89, 71, 63, 81, 105, 84, 84, 100, 
  87, 93, 101, 89, 75, 67, 68, 82, 76, 95, 
  88, 70, 66, 111, 85, 96, 87, 93, 89, 93, 
  80, 93, 91, 97, 95, 98, 103, 80, 91, 81, 
  97, 78, 88, 70, 74, 89, 72, 86, 78, 80, 
  91, 92, 72, 82, 79, 71, 70, 83, 67, 78, 
  73, 101, 87, 82, 83, 70, 77, 82, 86, 81, 
  78, 57, 79, 78, 86, 98, 90, 75, 74, 83, 
  85, 83, 85, 64, 74, 94, 83, 76, 71, 106, 
  93, 89, 66, 84, 86, 96, 87, 91, 79, 86, 
  74, 84, 65, 77, 82, 81, 88, 72, 72, 72, 
  73, 80, 96, 88, 86, 95, 73, 82, 81, 92, 
  86, 95, 88, 87, 76, 87, 83, 83, 86, 78, 
  87, 80, 86, 85, 86, 84, 88, 60, 72, 91, 
  82, 86, 78, 72, 74, 84, 84, 84, 93, 71, 
  57, 122, 80, 81, 83, 87, 78, 83, 90, 107, 
  77, 87, 99, 85, 90, 83, 98, 82, 87, 95, 
  72, 102, 95, 87, 78, 90, 80, 72, 73, 81, 
  68, 79, 94, 104, 102, 92, 69, 81, 81, 93, 
  96, 102, 96, 84, 87, 88, 77, 91, 92, 80, 
  81, 93, 101, 91, 77, 87, 98, 85, 91, 77, 
  67, 75, 89, 80, 79, 69, 68, 85, 83, 91, 
  75, 85, 95, 84, 87, 92, 68, 115, 74, 72, 
  73, 65, 73, 69, 79, 85, 63, 113, 99, 80, 
  98, 96, 69, 86, 63, 84, 70, 89, 86, 83, 
  94, 89, 79, 88, 93, 84, 83, 74, 99, 77, 
  92, 87, 72, 82, 70, 82, 81, 110, 97, 79, 
  66, 58, 80, 84, 76, 77, 80, 74, 59, 135, 
  85, 87, 81, 97, 78, 68, 87, 107, 89, 87, 
  98, 93, 109, 85, 97, 80, 92, 89, 74, 84, 
  82, 82, 67, 83, 79, 65, 80, 91, 68, 77, 
  93, 88, 87, 88, 71, 68, 78, 98, 81, 85, 
  81, 71, 82, 83, 78, 96, 82, 81, 71, 80, 
  98, 87, 83, 77, 75, 74, 84, 80, 74, 57, 
  81, 93, 73, 68, 63, 88, 88, 87, 77, 99, 
  88, 88, 91, 93, 72, 112, 65, 74, 55, 66, 
  73, 67, 84, 78, 61, 91, 77, 79, 110, 88, 
  72, 87, 60, 84, 71, 90, 81, 90, 97, 86, 
  73, 86, 80, 84, 83, 68, 93, 65, 86, 83, 
  80, 77, 94, 95, 87, 88, 83, 82, 72, 71, 
  68, 85, 84, 84, 87, 73, 57, 119, 89, 78, 
  85, 86, 74, 98, 94, 99, 83, 82, 102, 83, 
  80, 75, 102, 77, 89, 84, 72, 87, 84, 83, 
  66, 93, 77, 71, 79, 77, 70, 67, 88, 77, 
  96, 88, 71, 91, 73, 96, 96, 77, 91, 85, 
  84, 84, 81, 100, 94, 73, 82, 92, 91, 90, 
  83, 91, 71, 85, 87, 80, 74, 70, 88, 104, 
  80, 70, 71, 81, 88, 92, 72, 96, 79, 89, 
  90, 84, 71, 105, 73, 71, 71, 60, 75, 77, 
  81, 87, 63, 93, 94, 79, 103, 91, 75, 84, 
  70, 83, 71, 90, 87, 93, 110, 98, 94, 86, 
  93, 89, 85, 75, 91, 79, 91, 83, 73, 82, 
  101, 78, 92, 80, 82, 94, 96, 88, 87, 85, 
  72, 89, 81, 94, 81, 86, 87, 71, 68, 76, 
  76, 89, 81, 96, 79, 89, 73, 72, 91, 104, 
  80, 83, 81, 88, 88, 93, 95, 79, 73, 89, 
  89, 85, 87, 76, 87, 82, 82, 91, 75, 85, 
  78, 103, 76, 76, 86, 83, 74, 86, 80, 83, 
  77, 84, 73, 82, 84, 98, 87, 72, 84, 80, 
  80, 80, 77, 80, 82, 88, 80, 82, 88, 90, 
  67, 85, 80, 83, 84, 83, 79, 87, 94, 87, 
  92, 83, 80, 72, 86, 87, 87, 67, 92, 77, 
  72, 83, 77, 89, 85, 87, 87, 84, 80, 79, 
  84, 90, 86, 81, 93, 76, 96, 85, 91, 83, 
  75, 87, 86, 84, 83, 68, 88, 94, 84, 89, 
  86, 81, 70, 89, 104, 95, 89, 81, 66, 87, 
  63, 80, 92, 92, 85, 77, 53, 91, 78, 70, 
  87, 101, 85, 105, 74, 69, 89, 101, 72, 82, 
  80, 80, 92, 91, 92, 77, 74, 82, 89, 78, 
  81, 73, 89, 75, 78, 81, 94, 79, 76, 91, 
  82, 76, 89, 93, 89, 84, 74, 78, 70, 87, 
  75, 72, 97, 85, 92, 78, 74, 82, 92, 81, 
  83, 79, 89, 90, 68, 80, 90, 99, 69, 87, 
  71, 83, 77, 84, 79, 80, 98, 91, 101, 76, 
  72, 78, 89, 86, 88, 59, 82, 85, 66, 82, 
  80, 84, 88, 85, 86, 88, 87, 80, 79, 91, 
  94, 77, 84, 73, 86, 78, 78, 90, 71, 86, 
  81, 98, 82, 68, 86, 97, 102, 89, 91, 79, 
  85, 81, 90, 88, 87, 89, 70, 95, 86, 82, 
  79, 85, 87, 73, 74, 85, 84, 91, 79, 91, 
  91, 84, 79, 73, 85, 91, 76, 80, 82, 85, 
  86, 82, 92, 82, 87, 89, 83, 77, 80, 76, 
  89, 80, 80, 84, 76, 86, 78, 91, 75, 75, 
  87, 98, 71, 92, 76, 80, 76, 82, 81, 85, 
  83, 93, 92, 74, 79, 83, 90, 85, 85, 80, 
  83, 83, 79, 92, 86, 88, 69, 86, 76, 82, 
  83, 85, 77, 89, 90, 84, 91, 77, 79, 75, 
  77, 84, 85, 69, 80, 77, 74, 79, 76, 85, 
  88, 88, 92, 84, 81, 75, 79, 88, 87, 72, 
  79, 83, 84, 84, 92, 83, 74, 88, 82, 78, 
  88, 67, 85, 89, 81, 82, 81, 84, 74, 101, 
  112, 94, 86, 79, 70, 84, 81, 73, 87, 99, 
  82, 88, 47, 80, 81, 87, 80, 96, 77, 92, 
  70, 70, 98, 106, 81, 75, 77, 82, 77, 94, 
  90, 78, 73, 90, 87, 76, 80, 73, 89, 80, 
  78, 101, 83, 87, 78, 83, 87, 74, 84, 73, 
  83, 93, 73, 88, 79, 80, 78, 81, 83, 91, 
  92, 78, 87, 88, 87, 68, 83, 73, 83, 95, 
  64, 71, 93, 81, 67, 79, 76, 86, 89, 81, 
  77, 77, 88, 90, 106, 91, 69, 76, 90, 85, 
  90, 60, 91, 81, 66, 81, 90, 87, 90, 86, 
  83, 96, 76, 77, 86, 88, 99, 78, 90, 75, 
  100, 75, 87, 95, 83, 83, 83, 103, 81, 80, 
  85, 95, 73, 103, 83, 100, 60, 88, 124, 111, 
  93, 78, 63, 80, 64, 62, 96, 121, 82, 96, 
  35, 98, 78, 63, 82, 114, 86, 111, 76, 72, 
  97, 84, 79, 79, 85, 77, 86, 88, 84, 79, 
  65, 85, 77, 70, 79, 67, 85, 72, 77, 82, 
  103, 86, 74, 63, 100, 73, 82, 74, 99, 88, 
  62, 87, 76, 75, 72, 70, 83, 66, 106, 80, 
  83, 79, 80, 68, 93, 76, 97, 109, 54, 87, 
  90, 95, 74, 82, 72, 81, 80, 82, 77, 66, 
  97, 92, 149, 78, 64, 87, 100, 83, 96, 47, 
  83, 90, 56, 76, 94, 79, 93, 77, 88, 102, 
  91, 82, 83, 84, 117, 74, 78, 67, 84, 71, 
  81, 94, 79, 80, 88, 131, 82, 80, 84, 96, 
  85, 87, 91, 81, 82, 79, 101, 97, 87, 84, 
  72, 89, 79, 79, 85, 95, 85, 85, 59, 89, 
  80, 93, 85, 89, 87, 83, 79, 72, 86, 77, 
  76, 76, 75, 84, 92, 84, 90, 82, 78, 85, 
  82, 72, 81, 75, 88, 75, 77, 81, 78, 84, 
  75, 87, 78, 74, 83, 85, 78, 95, 72, 81, 
  79, 86, 86, 86, 88, 89, 98, 80, 83, 91, 
  92, 74, 94, 75, 89, 86, 68, 105, 100, 80, 
  69, 80, 70, 81, 91, 84, 78, 90, 90, 84, 
  93, 84, 74, 76, 82, 85, 86, 63, 78, 80, 
  74, 75, 86, 84, 88, 85, 92, 94, 80, 71, 
  84, 88, 94, 73, 86, 86, 87, 77, 90, 86, 
  73, 86, 75, 91, 83, 78, 84, 88, 87, 89, 
  87, 86, 80, 96, 105, 80, 87, 82, 72, 95, 
  86, 74, 94, 107, 88, 78, 63, 81, 87, 85, 
  81, 93, 82, 88, 73, 74, 90, 93, 89, 77, 
  75, 81, 73, 101, 85, 84, 92, 90, 82, 82, 
  77, 79, 91, 77, 77, 96, 78, 88, 75, 86, 
  85, 74, 83, 89, 73, 88, 82, 79, 75, 75, 
  86, 75, 82, 92, 97, 76, 80, 93, 99, 82, 
  77, 80, 80, 88, 76, 78, 79, 75, 73, 78, 
  71, 86, 89, 87, 75, 81, 95, 91, 95, 101, 
  68, 79, 85, 84, 89, 69, 90, 80, 73, 87, 
  80, 90, 87, 87, 84, 89, 87, 71, 90, 81, 
  92, 81, 85, 84, 87, 84, 92, 87, 79, 84, 
  82, 95, 77, 78, 81, 90, 78, 95, 100, 99, 
  73, 97, 106, 93, 96, 81, 65, 93, 71, 81, 
  101, 111, 89, 85, 51, 91, 81, 71, 90, 100, 
  83, 99, 74, 76, 88, 75, 82, 76, 73, 82, 
  77, 88, 80, 81, 74, 92, 66, 77, 84, 77, 
  87, 79, 76, 92, 87, 83, 73, 86, 87, 72, 
  84, 82, 84, 83, 72, 71, 73, 70, 81, 64, 
  85, 81, 103, 73, 84, 99, 89, 78, 80, 84, 
  87, 95, 64, 95, 72, 86, 73, 79, 70, 84, 
  80, 82, 82, 75, 98, 91, 110, 103, 64, 79, 
  99, 82, 87, 60, 84, 88, 73, 82, 78, 83, 
  82, 83, 87, 94, 86, 77, 87, 78, 102, 80, 
  81, 76, 87, 79, 84, 84, 83, 78, 80, 119, 
  75, 74, 77, 88, 88, 90, 91, 87, 87, 78, 
  98, 92, 89, 85, 75, 96, 81, 94, 92, 101, 
  90, 76, 75, 86, 84, 89, 84, 85, 85, 80, 
  77, 77, 87, 72, 88, 77, 77, 88, 86, 86, 
  88, 86, 78, 85, 78, 83, 92, 75, 87, 80, 
  75, 86, 75, 86, 74, 92, 77, 74, 77, 79, 
  69, 91, 78, 77, 80, 82, 91, 81, 85, 86, 
  92, 81, 83, 90, 90, 80, 88, 79, 86, 83, 
  78, 102, 88, 77, 73, 81, 68, 75, 92, 78, 
  86, 92, 94, 82, 88, 95, 74, 80, 88, 86, 
  88, 73, 85, 76, 74, 86, 81, 87, 81, 82, 
  88, 86, 89, 70, 87, 82, 90, 76, 85, 88, 
  88, 86, 95, 84, 81, 88, 79, 88, 79, 75, 
  80, 90, 90, 88, 95, 76, 90, 80, 82, 96, 
  92, 76, 82, 88, 88, 92, 82, 73, 100, 87, 
  90, 81, 64, 79, 86, 91, 89, 89, 75, 85, 
  92, 68, 72, 104, 86, 83, 104, 91, 80, 85, 
  78, 100, 77, 79, 98, 85, 75, 88, 88, 82, 
  86, 82, 75, 83, 79, 100, 93, 75, 85, 66, 
  80, 82, 81, 89, 85, 45, 74, 73, 83, 76, 
  80, 73, 93, 80, 95, 83, 97, 73, 76, 92, 
  74, 100, 85, 90, 75, 91, 79, 71, 86, 77, 
  92, 112, 78, 69, 68, 86, 92, 80, 85, 81, 
  77, 82, 72, 82, 87, 76, 98, 90, 76, 85, 
  78, 91, 83, 80, 93, 90, 67, 88, 71, 84, 
  66, 80, 78, 83, 93, 97, 83, 91, 95, 91, 
  81, 80, 85, 82, 74, 98, 97, 77, 93, 81, 
  73, 75, 80, 80, 73, 76, 75, 67, 75, 82, 
  72, 88, 84, 77, 96, 82, 92, 89, 130, 68, 
  81, 87, 80, 96, 143, 87, 99, 83, 70, 68, 
  110, 78, 113, 81, 80, 98, 77, 81, 85, 77, 
  62, 76, 85, 74, 97, 94, 81, 62, 88, 83, 
  87, 85, 89, 64, 64, 57, 58, 102, 73, 72, 
  115, 89, 84, 79, 82, 85, 84, 119, 79, 68, 
  73, 73, 80, 89, 92, 71, 101, 98, 83, 106, 
  82, 99, 89, 80, 111, 72, 88, 72, 77, 85, 
  73, 72, 101, 77, 88, 77, 86, 93, 84, 58, 
  90, 86, 67, 88, 65, 96, 74, 93, 81, 84, 
  78, 67, 92, 80, 76, 74, 74, 80, 77, 74, 
  89, 92, 74, 83, 88, 79, 107, 79, 75, 80, 
  86, 83, 76, 92, 80, 65, 72, 82, 93, 77, 
  76, 72, 91, 79, 95, 85, 106, 90, 107, 81, 
  84, 96, 82, 82, 90, 96, 79, 76, 103, 81, 
  97, 92, 70, 86, 85, 96, 73, 80, 75, 78, 
  79, 77, 73, 74, 73, 81, 99, 92, 78, 79, 
  76, 84, 70, 71, 69, 112, 77, 92, 66, 84, 
  86, 68, 74, 98, 97, 101, 85, 67, 73, 83, 
  95, 88, 109, 94, 98, 99, 89, 107, 90, 99, 
  104, 87, 94, 82, 79, 82, 77, 93, 87, 76, 
  93, 80, 88, 83, 102, 102, 83, 56, 104, 78, 
  60, 88, 92, 100, 90, 100, 96, 96, 82, 70, 
  90, 83, 74, 75, 76, 70, 84, 75, 79, 74, 
  91, 74, 77, 89, 89, 71, 94, 86, 79, 88, 
  95, 72, 95, 98, 95, 75, 87, 86, 85, 92, 
  71, 88, 70, 77, 85, 71, 80, 89, 92, 87, 
  71, 82, 75, 81, 78, 93, 69, 85, 81, 91, 
  97, 79, 80, 92, 78, 87, 84, 95, 78, 104, 
  82, 74, 89, 88, 78, 88, 85, 87, 77, 73, 
  83, 104, 79, 90, 84, 73, 76, 90, 80, 76, 
  96, 79, 85, 78, 67, 102, 94, 96, 79, 76, 
  91, 67, 82, 78, 90, 108, 76, 69, 79, 87, 
  74, 94, 73, 97, 79, 81, 78, 101, 87, 78, 
  83, 89, 87, 90, 72, 101, 80, 81, 99, 84, 
  79, 86, 81, 90, 84, 78, 73, 92, 72, 94, 
  85, 84, 96, 88, 79, 85, 61, 77, 93, 65, 
  85, 86, 79, 76, 84, 78, 72, 91, 87, 74, 
  82, 92, 100, 76, 69, 72, 68, 88, 79, 95, 
  90, 88, 105, 60, 78, 99, 96, 88, 112, 76, 
  88, 76, 70, 68, 74, 60, 110, 84, 89, 101, 
  72, 83, 83, 86, 70, 89, 81, 95, 93, 80, 
  84, 75, 71, 78, 91, 95, 91, 74, 65, 66, 
  65, 86, 73, 71, 100, 70, 88, 88, 93, 78, 
  71, 83, 88, 72, 90, 83, 83, 72, 82, 69, 
  80, 79, 87, 111, 87, 81, 64, 92, 98, 81, 
  90, 82, 83, 80, 66, 94, 88, 77, 93, 75, 
  70, 88, 90, 84, 84, 83, 91, 84, 65, 77, 
  58, 79, 77, 79, 76, 80, 95, 84, 82, 85, 
  90, 97, 81, 81, 70, 80, 91, 71, 81, 76, 
  87, 85, 80, 73, 78, 76, 70, 77, 79, 74, 
  80, 88, 80, 78, 77, 85, 79, 80, 85, 91, 
  81, 69, 86, 83, 73, 91, 88, 83, 82, 83, 
  88, 75, 106, 61, 86, 79, 78, 91, 72, 76, 
  92, 82, 59, 88, 79, 82, 84, 91, 83, 80, 
  78, 73, 89, 82, 90, 88, 76, 70, 69, 92, 
  76, 94, 82, 79, 96, 85, 82, 86, 79, 89, 
  98, 62, 85, 75, 85, 75, 86, 88, 82, 83, 
  77, 101, 78, 92, 85, 87, 98, 78, 83, 73, 
  74, 83, 76, 81, 95, 77, 95, 92, 71, 91, 
  95, 71, 88, 75, 82, 86, 79, 96, 81, 81, 
  77, 92, 80, 69, 90, 84, 81, 83, 79, 81, 
  83, 75, 95, 87, 84, 86, 74, 84, 91, 82, 
  89, 85, 85, 73, 87, 82, 91, 96, 80, 91, 
  96, 82, 97, 96, 75, 82, 82, 74, 72, 92, 
  85, 79, 90, 97, 87, 87, 87, 74, 79, 82, 
  88, 99, 65, 89, 95, 81, 87, 85, 77, 78, 
  84, 92, 79, 91, 80, 82, 88, 100, 84, 90, 
  84, 92, 81, 99, 99, 112, 78, 82, 80, 90, 
  78, 101, 80, 72, 98, 82, 93, 83, 81, 86, 
  89, 99, 82, 75, 95, 78, 90, 81, 90, 89, 
  71, 81, 101, 88, 87, 90, 66, 87, 90, 82, 
  91, 97, 84, 84, 82, 82, 85, 89, 65, 102, 
  81, 81, 100, 86, 88, 88, 90, 89, 88, 83, 
  77, 82, 64, 87, 84, 78, 92, 92, 79, 79, 
  83, 81, 96, 68, 72, 90, 85, 78, 88, 83, 
  80, 89, 86, 76, 85, 98, 98, 82, 77, 77, 
  80, 90, 70, 91, 83, 80, 82, 78, 78, 89, 
  100, 89, 89, 73, 80, 82, 73, 87, 70, 71, 
  76, 81, 99, 90, 76, 91, 79, 89, 93, 96, 
  73, 104, 81, 82, 80, 93, 80, 83, 79, 94, 
  80, 91, 85, 99, 76, 76, 75, 75, 83, 77, 
  79, 74, 90, 85, 79, 69, 81, 88, 91, 98, 
  80, 72, 86, 77, 87, 77, 98, 99, 78, 84, 
  80, 93, 83, 88, 79, 90, 90, 86, 79, 96, 
  78, 83, 90, 76, 77, 89, 73, 106, 87, 85, 
  99, 84, 80, 70, 69, 82, 86, 79, 81, 85, 
  73, 89, 86, 83, 97, 96, 88, 89, 90, 78, 
  93, 70, 77, 83, 79, 82, 82, 79, 81, 82, 
  78, 70, 84, 86, 94, 82, 67, 82, 88, 90, 
  73, 89, 75, 77, 78, 70, 84, 87, 84, 87, 
  93, 87, 83, 83, 83, 76, 84, 66, 74, 75, 
  96, 88, 77, 79, 86, 83, 81, 90, 75, 96, 
  82, 89, 86, 91, 75, 84, 84, 86, 91, 100, 
  90, 84, 79, 89, 76, 87, 88, 72, 89, 77, 
  87, 85, 78, 71, 95, 81, 90, 90, 82, 83, 
  84, 85, 82, 77, 94, 90, 74, 83, 78, 94, 
  95, 83, 76, 81, 83, 84, 80, 90, 82, 82, 
  89, 87, 80, 89, 80, 98, 87, 84, 96, 86, 
  77, 80, 88, 82, 87, 86, 81, 82, 74, 89, 
  85, 84, 90, 87, 69, 79, 76, 88, 81, 94, 
  87, 97, 112, 83, 79, 118, 92, 68, 75, 100, 
  83, 86, 85, 74, 105, 88, 92, 75, 83, 75, 
  80, 85, 92, 89, 85, 80, 104, 72, 76, 89, 
  92, 73, 109, 83, 75, 80, 74, 76, 70, 93, 
  104, 87, 86, 68, 81, 74, 88, 102, 66, 105, 
  86, 83, 85, 80, 75, 79, 82, 67, 89, 93, 
  79, 91, 85, 73, 88, 101, 98, 95, 87, 79, 
  89, 78, 79, 82, 89, 67, 72, 85, 77, 68, 
  99, 98, 68, 82, 89, 83, 81, 80, 88, 92, 
  70, 79, 94, 91, 82, 79, 87, 93, 92, 75, 
  78, 90, 88, 89, 88, 87, 82, 94, 84, 78, 
  85, 86, 82, 100, 76, 75, 78, 88, 85, 99, 
  79, 92, 58, 80, 88, 76, 87, 73, 76, 90, 
  124, 77, 87, 117, 85, 97, 77, 80, 79, 74, 
  85, 66, 90, 81, 76, 79, 80, 71, 80, 82, 
  104, 71, 83, 88, 82, 76, 77, 88, 85, 55, 
  89, 74, 52, 88, 103, 66, 72, 73, 93, 81, 
  76, 60, 93, 84, 86, 118, 61, 75, 95, 75, 
  87, 85, 74, 92, 78, 68, 73, 114, 82, 85, 
  89, 60, 76, 81, 102, 89, 84, 77, 78, 88, 
  79, 97, 87, 62, 71, 94, 77, 57, 87, 119, 
  62, 68, 93, 80, 69, 73, 84, 96, 68, 76, 
  90, 119, 79, 89, 102, 93, 79, 83, 66, 91, 
  89, 89, 98, 68, 70, 92, 100, 63, 73, 81, 
  73, 96, 86, 70, 63, 82, 74, 84, 83, 113, 
  74, 89, 101, 83, 83, 88, 87, 99, 100, 85, 
  79, 116, 85, 106, 78, 95, 80, 88, 85, 79, 
  74, 86, 91, 75, 79, 79, 87, 86, 87, 74, 
  97, 92, 100, 85, 88, 84, 86, 71, 74, 82, 
  75, 84, 103, 78, 73, 95, 96, 79, 80, 70, 
  75, 83, 88, 88, 79, 62, 83, 77, 84, 79, 
  79, 82, 86, 69, 89, 89, 78, 87, 89, 77, 
  88, 109, 91, 100, 89, 74, 80, 91, 97, 81, 
  91, 70, 68, 84, 76, 73, 91, 98, 77, 80, 
  90, 83, 88, 81, 82, 84, 75, 83, 93, 89, 
  79, 95, 89, 93, 94, 77, 81, 86, 86, 91, 
  90, 90, 83, 98, 95, 78, 77, 90, 85, 90, 
  85, 77, 86, 87, 83, 92, 79, 95, 77, 78, 
  70, 77, 78, 82, 78, 82, 116, 86, 94, 128, 
  83, 113, 71, 78, 70, 65, 91, 73, 92, 89, 
  92, 85, 77, 73, 83, 82, 94, 80, 84, 83, 
  87, 84, 86, 76, 83, 75, 75, 72, 79, 79, 
  85, 72, 81, 98, 92, 82, 81, 58, 91, 83, 
  83, 110, 67, 80, 84, 83, 81, 85, 87, 87, 
  84, 69, 71, 92, 85, 80, 96, 62, 70, 99, 
  80, 85, 84, 75, 83, 82, 67, 90, 81, 81, 
  76, 77, 74, 84, 88, 115, 69, 98, 94, 81, 
  75, 68, 90, 90, 71, 79, 89, 107, 81, 78, 
  91, 97, 78, 60, 73, 86, 79, 78, 90, 76, 
  69, 83, 93, 77, 83, 84, 79, 95, 68, 73, 
  71, 80, 78, 87, 80, 98, 68, 74, 79, 67, 
  84, 74, 72, 73, 119, 86, 105, 132, 79, 122, 
  67, 54, 64, 50, 86, 66, 84, 79, 73, 82, 
  80, 61, 77, 75, 107, 75, 78, 92, 64, 86, 
  77, 85, 86, 73, 128, 64, 82, 107, 90, 62, 
  78, 56, 88, 81, 84, 50, 116, 90, 75, 141, 
  70, 118, 83, 86, 96, 82, 82, 87, 93, 76, 
  49, 147, 97, 75, 82, 42, 80, 104, 71, 72, 
  83, 72, 79, 82, 52, 121, 79, 84, 59, 66, 
  74, 97, 73, 147, 68, 69, 81, 67, 78, 58, 
  81, 101, 69, 68, 89, 139, 70, 86, 118, 96, 
  54, 48, 58, 95, 64, 75, 92, 63, 61, 73, 
  100, 80, 75, 84, 85, 96, 75, 68, 49, 77, 
  67, 69, 86, 115, 70, 82, 91, 80, 79, 90, 
  81, 93, 105, 87, 89, 119, 78, 75, 73, 81, 
  72, 76, 89, 81, 81, 72, 85, 79, 78, 78, 
  87, 84, 86, 85, 82, 98, 93, 81, 82, 80, 
  85, 78, 101, 72, 81, 73, 88, 81, 83, 99, 
  86, 79, 82, 62, 81, 69, 85, 95, 77, 92, 
  81, 86, 82, 88, 82, 77, 90, 67, 78, 84, 
  79, 87, 89, 71, 84, 108, 88, 91, 86, 77, 
  74, 77, 69, 80, 82, 80, 70, 76, 75, 91, 
  81, 95, 66, 95, 98, 74, 82, 70, 85, 83, 
  77, 82, 89, 96, 82, 89, 89, 96, 75, 61, 
  78, 85, 71, 83, 81, 83, 73, 86, 68, 67, 
  81, 86, 79, 90, 90, 73, 83, 85, 84, 89, 
  78, 94, 78, 75, 81, 94, 78, 105, 96, 77, 
  82, 88, 89, 86, 94, 95, 78, 89, 66, 92, 
  88, 80, 87, 90, 101, 93, 84, 90, 91, 82, 
  87, 91, 89, 83, 96, 78, 81, 89, 88, 83, 
  80, 89, 91, 77, 71, 85, 85, 105, 78, 87, 
  91, 85, 77, 79, 91, 92, 76, 89, 75, 89, 
  86, 83, 83, 78, 78, 79, 93, 83, 78, 85, 
  85, 74, 95, 83, 77, 78, 88, 79, 79, 75, 
  85, 75, 83, 71, 73, 77, 95, 90, 101, 89, 
  77, 101, 90, 92, 84, 83, 108, 77, 72, 78, 
  94, 81, 93, 87, 82, 89, 92, 71, 94, 86, 
  71, 93, 97, 90, 78, 84, 91, 86, 85, 89, 
  88, 87, 84, 79, 87, 94, 87, 84, 77, 87, 
  63, 80, 96, 103, 79, 99, 92, 79, 94, 86, 
  82, 84, 84, 78, 82, 82, 62, 102, 91, 84, 
  77, 72, 92, 104, 87, 89, 99, 86, 90, 74, 
  75, 95, 100, 73, 80, 85, 76, 84, 78, 78, 
  79, 66, 79, 74, 82, 105, 76, 84, 84, 89, 
  78, 67, 101, 96, 73, 73, 80, 78, 76, 85, 
  88, 65, 77, 70, 88, 77, 84, 87, 85, 74, 
  79, 64, 85, 76, 90, 78, 70, 81, 75, 72, 
  88, 69, 74, 90, 78, 92, 97, 75, 75, 120, 
  97, 98, 71, 82, 107, 73, 74, 70, 81, 81, 
  95, 74, 72, 89, 79, 67, 92, 82, 75, 98, 
  92, 79, 80, 92, 84, 76, 82, 81, 74, 80, 
  99, 78, 77, 99, 80, 78, 79, 96, 77, 85, 
  100, 86, 78, 99, 97, 81, 77, 90, 90, 88, 
  93, 84, 81, 88, 71, 96, 89, 88, 73, 95, 
  101, 91, 80, 92, 92, 86, 83, 78, 92, 93, 
  97, 85, 97, 84, 88, 80, 87, 86, 94, 76, 
  90, 84, 82, 100, 75, 77, 94, 85, 71, 87, 
  85, 91, 80, 82, 79, 85, 86, 80, 83, 80, 
  81, 79, 90, 82, 70, 87, 90, 83, 85, 87, 
  80, 82, 84, 81, 80, 87, 82, 68, 82, 75, 
  75, 82, 94, 93, 88, 81, 81, 95, 82, 90, 
  90, 82, 92, 81, 75, 80, 81, 86, 88, 83, 
  82, 89, 91, 73, 97, 83, 74, 88, 93, 90, 
  77, 89, 89, 96, 87, 90, 92, 88, 81, 81, 
  86, 95, 88, 84, 81, 87, 99, 84, 89, 85, 
  84, 87, 81, 97, 74, 97, 78, 83, 90, 90, 
  86, 85, 88, 78, 77, 78, 78, 86, 85, 77, 
  94, 96, 84, 92, 97, 84, 82, 72, 87, 84, 
  82, 99, 86, 63, 80, 81, 81, 79, 83, 85, 
  89, 75, 98, 75, 79, 83, 83, 83, 91, 76, 
  88, 86, 85, 82, 82, 89, 81, 82, 90, 58, 
  76, 83, 87, 85, 90, 89, 81, 79, 80, 98, 
  83, 69, 86, 78, 85, 80, 84, 91, 94, 91, 
  92, 81, 58, 87, 79, 75, 87, 80, 88, 84, 
  86, 86, 82, 81, 87, 76, 91, 90, 87, 84, 
  66, 81, 78, 91, 92, 75, 86, 89, 73, 132, 
  89, 93, 87, 84, 93, 88, 86, 88, 72, 98, 
  79, 78, 65, 85, 95, 81, 81, 89, 85, 91, 
  74, 92, 73, 100, 85, 90, 87, 86, 79, 76, 
  81, 77, 83, 88, 81, 87, 81, 86, 104, 89, 
  88, 80, 101, 80, 87, 75, 85, 86, 85, 99, 
  76, 101, 78, 77, 82, 76, 69, 89, 87, 85, 
  86, 66, 84, 86, 83, 90, 86, 82, 97, 86, 
  92, 73, 90, 86, 86, 78, 89, 50, 58, 81, 
  74, 86, 82, 91, 85, 88, 81, 91, 77, 89, 
  86, 84, 86, 84, 83, 84, 100, 86, 82, 76, 
  65, 90, 77, 78, 91, 81, 99, 84, 82, 87, 
  86, 82, 77, 77, 86, 86, 79, 86, 76, 80, 
  76, 89, 72, 77, 78, 86, 87, 129, 83, 90, 
  87, 81, 81, 86, 86, 83, 80, 88, 86, 83, 
  88, 83, 84, 70, 92, 89, 91, 91, 65, 87, 
  79, 81, 87, 83, 86, 83, 72, 83, 71, 82, 
  77, 95, 88, 85, 94, 95, 97, 82, 82, 63, 
  87, 78, 98, 87, 89, 86, 94, 102, 79, 129, 
  78, 70, 89, 71, 78, 90, 91, 87, 80, 69, 
  88, 79, 84, 94, 82, 95, 97, 87, 89, 83, 
  88, 88, 84, 78, 91, 65, 71, 87, 75, 92, 
  82, 103, 67, 84, 92, 87, 83, 86, 84, 86, 
  93, 78, 84, 81, 105, 89, 78, 91, 52, 82, 
  73, 81, 94, 84, 94, 94, 74, 92, 96, 81, 
  79, 89, 80, 74, 74, 94, 134, 87, 84, 83, 
  72, 78, 82, 90, 105, 158, 89, 89, 81, 76, 
  79, 93, 96, 76, 81, 76, 80, 96, 101, 84, 
  93, 90, 79, 75, 84, 88, 81, 95, 73, 93, 
  77, 80, 96, 85, 87, 89, 91, 77, 65, 72, 
  85, 81, 82, 84, 92, 98, 77, 94, 83, 87, 
  90, 77, 82, 87, 82, 85, 85, 62, 77, 82, 
  83, 80, 88, 85, 89, 79, 97, 83, 81, 81, 
  78, 81, 92, 72, 78, 91, 84, 83, 78, 95, 
  82, 80, 83, 67, 74, 84, 89, 86, 90, 79, 
  80, 76, 74, 100, 81, 61, 86, 76, 80, 88, 
  87, 91, 87, 85, 95, 86, 61, 81, 79, 84, 
  94, 80, 82, 84, 77, 89, 83, 83, 84, 81, 
  86, 91, 89, 83, 59, 85, 76, 92, 96, 78, 
  86, 87, 68, 111, 81, 92, 78, 87, 97, 90, 
  89, 84, 70, 95, 82, 65, 64, 85, 92, 87, 
  76, 84, 81, 88, 82, 89, 73, 96, 83, 88, 
  87, 86, 81, 80, 85, 75, 85, 84, 81, 86, 
  72, 81, 100, 89, 78, 85, 83, 81, 87, 77, 
  82, 85, 76, 91, 81, 78, 80, 78, 80, 77, 
  76, 93, 86, 79, 88, 74, 83, 84, 81, 85, 
  86, 77, 92, 93, 96, 76, 92, 85, 81, 74, 
  87, 55, 57, 81, 75, 81, 86, 87, 82, 83, 
  77, 92, 75, 79, 88, 81, 79, 87, 88, 85, 
  99, 79, 89, 76, 71, 84, 75, 72, 92, 80, 
  94, 86, 78, 86, 85, 81, 75, 79, 80, 88, 
  76, 84, 63, 79, 80, 92, 80, 83, 76, 83, 
  78, 116, 76, 89, 84, 77, 81, 88, 84, 81, 
  81, 82, 87, 71, 81, 85, 77, 70, 80, 94, 
  86, 97, 70, 88, 79, 92, 81, 80, 82, 89, 
  75, 86, 77, 75, 83, 90, 84, 85, 83, 92, 
  92, 79, 89, 77, 66, 78, 96, 82, 79, 89, 
  89, 94, 78, 119, 81, 73, 86, 72, 68, 90, 
  82, 80, 90, 71, 90, 77, 81, 84, 79, 85, 
  98, 87, 98, 81, 90, 81, 79, 79, 98, 69, 
  68, 84, 76, 87, 90, 97, 75, 79, 96, 87, 
  83, 86, 86, 84, 92, 80, 82, 81, 100, 81, 
  78, 85, 57, 84, 72, 70, 92, 83, 94, 97, 
  80, 85, 89, 79, 78, 90, 75, 84, 77, 93, 
  118, 81, 84, 84, 76, 83, 76, 95, 99, 144, 
  87, 89, 75, 75, 87, 90, 88, 81, 82, 75, 
  79, 88, 95, 84, 89, 91, 77, 78, 79, 89, 
  81, 98, 75, 107, 75, 86, 91, 87, 87, 85, 
  91, 80, 63, 68, 88, 86, 85, 91, 86, 94, 
  82, 93, 91, 79, 86, 76, 79, 87, 83, 93, 
  90, 71, 76, 85, 83, 82, 89, 80, 82, 82, 
  92, 83, 81, 81, 80, 78, 97, 75, 81, 93, 
  90, 82, 83, 94, 86, 86, 93, 73, 85, 85, 
  88, 91, 87, 86, 84, 75, 76, 89, 82, 69, 
  87, 80, 86, 83, 85, 91, 88, 94, 90, 72, 
  57, 82, 80, 91, 98, 82, 93, 80, 86, 85, 
  86, 75, 81, 79, 90, 93, 105, 85, 60, 85, 
  85, 90, 89, 76, 81, 90, 75, 115, 79, 99, 
  79, 99, 102, 90, 90, 79, 66, 99, 75, 69, 
  66, 79, 95, 88, 75, 82, 81, 87, 85, 91, 
  78, 98, 85, 86, 89, 85, 85, 80, 87, 75, 
  79, 72, 88, 85, 70, 82, 93, 90, 75, 87, 
  100, 78, 85, 81, 81, 85, 76, 89, 89, 70, 
  79, 82, 85, 76, 89, 87, 81, 80, 84, 82, 
  84, 85, 82, 85, 86, 78, 87, 93, 96, 77, 
  90, 84, 81, 81, 89, 62, 62, 80, 82, 86, 
  88, 85, 79, 79, 74, 86, 75, 76, 88, 75, 
  81, 86, 88, 84, 101, 84, 89, 69, 70, 82, 
  75, 78, 93, 85, 95, 85, 78, 86, 87, 79, 
  72, 78, 85, 94, 82, 84, 60, 84, 82, 89, 
  88, 82, 77, 83, 78, 105, 81, 92, 84, 81, 
  86, 88, 86, 77, 75, 89, 83, 78, 74, 80, 
  76, 76, 72, 95, 87, 89, 79, 90, 81, 91, 
  83, 79, 84, 89, 76, 84, 80, 77, 76, 81, 
  87, 83, 83, 85, 91, 85, 81, 82, 91, 73, 
  92, 81, 79, 83, 82, 90, 85, 101, 89, 80, 
  86, 69, 81, 85, 75, 82, 87, 76, 92, 78, 
  79, 85, 81, 83, 92, 86, 99, 82, 92, 85, 
  76, 81, 91, 68, 70, 83, 79, 86, 90, 86, 
  88, 82, 85, 84, 81, 86, 82, 75, 90, 77, 
  83, 81, 97, 89, 81, 81, 56, 83, 71, 76, 
  93, 83, 99, 92, 83, 86, 90, 78, 80, 89, 
  82, 89, 79, 86, 98, 81, 81, 84, 87, 87, 
  80, 88, 95, 130, 91, 90, 79, 75, 91, 90, 
  93, 84, 86, 80, 81, 95, 85, 82, 87, 92, 
  93, 64, 79, 102, 84, 89, 88, 67, 85, 79, 
  79, 85, 80, 97, 94, 68, 82, 73, 75, 79, 
  69, 92, 72, 91, 75, 75, 91, 78, 94, 65, 
  91, 84, 73, 92, 77, 89, 82, 90, 104, 68, 
  74, 89, 87, 78, 78, 77, 88, 94, 70, 84, 
  88, 69, 96, 86, 79, 87, 96, 97, 95, 92, 
  84, 95, 86, 86, 93, 70, 80, 84, 100, 82, 
  94, 51, 81, 91, 82, 88, 69, 78, 85, 81, 
  88, 83, 87, 81, 86, 84, 85, 81, 100, 103, 
  93, 92, 71, 87, 92, 89, 81, 107, 69, 79, 
  79, 84, 79, 66, 85, 95, 78, 75, 80, 72, 
  81, 96, 84, 93, 85, 86, 103, 70, 87, 78, 
  92, 81, 85, 77, 79, 85, 85, 98, 94, 62, 
  79, 73, 87, 91, 88, 70, 85, 82, 88, 81, 
  73, 99, 88, 63, 77, 74, 72, 83, 76, 104, 
  73, 88, 80, 72, 90, 71, 104, 55, 87, 85, 
  67, 83, 78, 103, 82, 95, 115, 51, 67, 85, 
  82, 79, 83, 78, 84, 96, 72, 77, 88, 59, 
  83, 86, 86, 87, 113, 93, 95, 94, 92, 93, 
  59, 86, 102, 67, 60, 83, 80, 75, 102, 52, 
  77, 97, 77, 83, 66, 68, 83, 82, 75, 84, 
  86, 78, 84, 80, 87, 92, 89, 109, 99, 96, 
  66, 90, 87, 83, 84, 98, 56, 73, 78, 83, 
  64, 52, 81, 92, 78, 81, 84, 68, 84, 93, 
  86, 85, 86, 87, 109, 63, 84, 78, 87, 92, 
  79, 76, 72, 87, 85, 91, 94, 70, 80, 82, 
  81, 91, 85, 73, 83, 78, 81, 83, 80, 94, 
  90, 72, 87, 73, 75, 82, 94, 93, 86, 86, 
  83, 77, 89, 71, 95, 64, 87, 84, 80, 80, 
  83, 91, 85, 92, 106, 64, 72, 87, 78, 79, 
  85, 84, 88, 92, 72, 89, 87, 68, 92, 79, 
  83, 87, 98, 89, 96, 97, 84, 88, 87, 88, 
  100, 69, 80, 92, 95, 84, 93, 53, 79, 88, 
  81, 89, 65, 79, 85, 80, 78, 96, 84, 82, 
  89, 89, 89, 89, 93, 95, 96, 86, 77, 90, 
  88, 88, 76, 95, 69, 75, 85, 82, 69, 63, 
  80, 91, 75, 78, 86, 74, 83, 88, 92, 89, 
  99, 82, 100, 75, 78, 87, 87, 79, 84, 77, 
  79, 85, 95, 87, 83, 85, 80, 83, 70, 83, 
  90, 80, 82, 82, 66, 81, 75, 86, 73, 63, 
  89, 82, 76, 87, 107, 89, 75, 79, 84, 80, 
  87, 83, 85, 83, 76, 75, 84, 99, 72, 96, 
  81, 71, 106, 68, 90, 88, 92, 72, 80, 85, 
  89, 75, 86, 81, 90, 72, 95, 91, 82, 92, 
  84, 81, 94, 88, 98, 76, 74, 76, 83, 85, 
  73, 77, 98, 80, 78, 72, 82, 82, 89, 86, 
  75, 65, 94, 84, 80, 78, 87, 82, 87, 91, 
  74, 67, 80, 96, 90, 79, 80, 84, 92, 82, 
  78, 87, 78, 82, 79, 88, 71, 70, 80, 97, 
  93, 73, 81, 73, 74, 81, 93, 84, 85, 76, 
  89, 78, 87, 75, 72, 81, 82, 82, 99, 79, 
  103, 81, 88, 86, 77, 76, 69, 85, 95, 80, 
  83, 92, 63, 87, 78, 85, 68, 60, 94, 83, 
  90, 92, 89, 84, 72, 74, 89, 76, 113, 67, 
  94, 93, 69, 78, 77, 84, 81, 108, 80, 53, 
  134, 63, 84, 90, 102, 72, 80, 82, 83, 67, 
  100, 84, 89, 72, 102, 98, 93, 89, 90, 79, 
  93, 84, 110, 87, 57, 76, 84, 88, 56, 89, 
  90, 75, 77, 88, 74, 84, 101, 81, 72, 53, 
  95, 94, 69, 81, 93, 85, 84, 94, 72, 70, 
  73, 106, 95, 86, 80, 95, 100, 81, 72, 74, 
  78, 90, 71, 89, 53, 51, 76, 101, 94, 66, 
  96, 73, 71, 81, 100, 82, 85, 75, 89, 72, 
  79, 74, 66, 82, 78, 85, 93, 71, 94, 78, 
  79, 82, 81, 104, 72, 84, 87, 85, 86, 81, 
  73, 85, 75, 88, 69, 64, 97, 77, 91, 80, 
  80, 91, 78, 78, 91, 81, 91, 72, 89, 95, 
  74, 84, 82, 85, 84, 94, 77, 71, 108, 72, 
  69, 87, 93, 74, 82, 87, 87, 74, 88, 83, 
  93, 77, 93, 77, 86, 90, 86, 83, 96, 89, 
  98, 75, 68, 76, 78, 83, 70, 78, 87, 83, 
  80, 69, 79, 87, 95, 82, 75, 71, 94, 85, 
  81, 97, 81, 81, 78, 92, 79, 79, 78, 100, 
  94, 77, 85, 86, 91, 81, 78, 82, 77, 90, 
  84, 86, 66, 70, 78, 95, 100, 74, 97, 72, 
  81, 87, 86, 83, 86, 75, 85, 75, 72, 81, 
  73, 82, 85, 80, 94, 79, 86, 89, 82, 88, 
  82, 74, 69, 90, 82, 89, 91, 77, 89, 89, 
  83, 78, 70, 81, 91, 86, 85, 86, 101, 94, 
  79, 80, 89, 89, 77, 85, 84, 90, 83, 76, 
  91, 105, 82, 80, 82, 76, 93, 78, 89, 88, 
  87, 88, 71, 89, 90, 74, 85, 89, 92, 92, 
  85, 89, 72, 86, 72, 81, 92, 84, 82, 75, 
  87, 78, 80, 83, 88, 64, 95, 90, 94, 79, 
  94, 71, 81, 91, 80, 86, 94, 86, 93, 87, 
  84, 87, 91, 90, 74, 73, 70, 81, 80, 83, 
  77, 81, 79, 86, 82, 81, 75, 92, 90, 90, 
  83, 96, 90, 90, 78, 85, 91, 87, 91, 75, 
  80, 90, 83, 70, 68, 91, 90, 77, 86, 80, 
  76, 73, 95, 94, 93, 87, 87, 99, 89, 69, 
  67, 89, 90, 83, 97, 82, 98, 88, 88, 76, 
  73, 92, 99, 83, 101, 83, 67, 89, 85, 79, 
  93, 86, 101, 84, 85, 105, 92, 74, 87, 90, 
  84, 79, 89, 70, 90, 75, 96, 94, 93, 99, 
  70, 88, 90, 75, 96, 89, 94, 106, 86, 88, 
  67, 88, 58, 83, 89, 79, 83, 91, 80, 77, 
  87, 89, 80, 59, 87, 83, 89, 85, 86, 64, 
  94, 83, 87, 82, 97, 88, 98, 91, 89, 90, 
  89, 89, 76, 77, 69, 78, 68, 89, 72, 82, 
  85, 90, 82, 74, 72, 85, 84, 93, 90, 98, 
  95, 91, 93, 86, 113, 89, 95, 78, 76, 89, 
  88, 67, 60, 90, 83, 80, 90, 77, 80, 72, 
  91, 94, 86, 87, 79, 86, 87, 97, 69, 83, 
  82, 89, 89, 75, 90, 80, 82, 83, 70, 84, 
  95, 81, 93, 85, 72, 91, 84, 80, 88, 86, 
  80, 85, 80, 95, 84, 85, 87, 87, 78, 78, 
  91, 80, 97, 78, 79, 87, 87, 85, 71, 89, 
  92, 76, 85, 85, 97, 96, 82, 77, 73, 85, 
  75, 81, 91, 86, 86, 76, 87, 81, 82, 81, 
  82, 69, 91, 87, 94, 75, 91, 76, 84, 86, 
  86, 86, 93, 83, 99, 104, 81, 88, 84, 88, 
  79, 79, 70, 86, 79, 81, 82, 79, 80, 82, 
  88, 83, 74, 84, 95, 90, 86, 95, 89, 91, 
  81, 88, 96, 77, 95, 88, 81, 89, 101, 71, 
  69, 90, 72, 79, 83, 82, 80, 70, 93, 93, 
  84, 87, 86, 88, 77, 92, 79, 93, 86, 80, 
  70, 83, 86, 74, 70, 99, 87, 79, 80, 89, 
  89, 75, 68, 81, 79, 78, 85, 85, 97, 84, 
  81, 80, 84, 93, 82, 78, 87, 83, 92, 89, 
  86, 79, 82, 84, 79, 92, 84, 80, 74, 74, 
  76, 84, 87, 79, 79, 97, 85, 91, 92, 82, 
  86, 69, 83, 86, 79, 85, 78, 69, 84, 86, 
  123, 68, 84, 79, 84, 85, 71, 72, 83, 86, 
  74, 87, 78, 72, 74, 79, 88, 83, 85, 75, 
  84, 92, 80, 79, 89, 81, 83, 88, 78, 79, 
  79, 99, 84, 79, 83, 96, 77, 80, 87, 85, 
  83, 92, 76, 87, 76, 60, 72, 85, 92, 92, 
  79, 83, 80, 82, 93, 86, 85, 76, 103, 83, 
  119, 101, 74, 106, 89, 96, 87, 84, 78, 77, 
  94, 82, 64, 98, 85, 83, 87, 81, 95, 82, 
  88, 76, 81, 89, 88, 88, 78, 103, 84, 77, 
  80, 103, 132, 90, 114, 84, 87, 68, 97, 80, 
  92, 78, 95, 92, 65, 90, 77, 66, 83, 72, 
  87, 73, 76, 74, 70, 77, 84, 86, 80, 71, 
  67, 71, 81, 90, 73, 82, 82, 83, 98, 73, 
  86, 82, 81, 81, 77, 96, 75, 96, 74, 84, 
  79, 80, 75, 88, 92, 95, 72, 66, 73, 81, 
  80, 83, 99, 88, 87, 86, 79, 79, 89, 60, 
  80, 83, 78, 89, 89, 79, 76, 81, 96, 88, 
  74, 93, 65, 61, 109, 95, 87, 88, 83, 89, 
  79, 87, 74, 84, 87, 94, 86, 76, 92, 85, 
  77, 74, 85, 93, 84, 77, 71, 89, 83, 89, 
  69, 83, 79, 76, 83, 80, 82, 75, 94, 86, 
  83, 77, 89, 83, 87, 55, 82, 79, 78, 92, 
  81, 78, 82, 79, 79, 86, 76, 79, 88, 92, 
  76, 85, 86, 69, 78, 75, 84, 93, 88, 81, 
  76, 68, 85, 91, 86, 89, 86, 77, 90, 94, 
  81, 87, 99, 70, 83, 102, 80, 70, 73, 83, 
  80, 80, 76, 78, 91, 85, 81, 92, 81, 83, 
  79, 83, 79, 89, 94, 76, 80, 79, 75, 75, 
  86, 85, 84, 81, 88, 80, 72, 73, 89, 78, 
  86, 99, 74, 86, 86, 84, 93, 85, 72, 91, 
  93, 78, 106, 85, 91, 97, 85, 81, 86, 84, 
  99, 86, 85, 78, 95, 83, 71, 87, 80, 84, 
  75, 75, 90, 82, 82, 76, 91, 69, 62, 87, 
  78, 77, 92, 88, 93, 84, 73, 79, 80, 76, 
  92, 88, 89, 60, 88, 75, 76, 87, 145, 81, 
  93, 80, 87, 77, 84, 78, 86, 85, 72, 102, 
  95, 76, 70, 88, 70, 69, 88, 80, 99, 105, 
  75, 93, 98, 82, 93, 89, 74, 75, 72, 86, 
  77, 82, 91, 78, 122, 65, 94, 82, 93, 76, 
  84, 91, 76, 73, 73, 73, 75, 65, 75, 83, 
  83, 95, 84, 94, 97, 94, 82, 78, 105, 77, 
  80, 79, 111, 80, 83, 87, 91, 76, 87, 92, 
  68, 81, 81, 91, 80, 99, 76, 79, 51, 81, 
  74, 81, 88, 92, 81, 93, 83, 81, 103, 80, 
  82, 76, 105, 88, 132, 93, 67, 84, 76, 78, 
  86, 92, 95, 61, 79, 85, 57, 82, 82, 78, 
  95, 97, 85, 67, 74, 75, 82, 73, 106, 94, 
  67, 132, 93, 84, 76, 97, 193, 76, 170, 92, 
  79, 58, 118, 73, 84, 73, 71, 94, 95, 82, 
  75, 81, 79, 53, 83, 74, 99, 60, 66, 78, 
  87, 80, 92, 94, 74, 77, 71, 94, 64, 78, 
  98, 82, 69, 66, 100, 85, 82, 79, 95, 86, 
  81, 73, 70, 60, 67, 83, 76, 100, 71, 99, 
  59, 81, 80, 96, 81, 78, 105, 79, 81, 80, 
  92, 75, 92, 59, 92, 79, 76, 99, 67, 83, 
  75, 91, 100, 100, 76, 70, 64, 74, 81, 86, 
  86, 102, 81, 101, 72, 84, 86, 81, 80, 96, 
  86, 84, 113, 86, 79, 82, 75, 77, 88, 83, 
  76, 85, 76, 92, 61, 82, 78, 76, 90, 87, 
  81, 80, 91, 86, 87, 74, 91, 88, 80, 85, 
  93, 88, 72, 79, 76, 85, 66, 80, 78, 83, 
  79, 78, 82, 90, 67, 82, 97, 88, 77, 86, 
  85, 84, 91, 83, 86, 64, 77, 97, 91, 80, 
  93, 89, 87, 86, 75, 88, 83, 69, 83, 93, 
  71, 70, 81, 84, 84, 77, 80, 58, 77, 72, 
  83, 84, 76, 103, 76, 92, 70, 87, 93, 94, 
  91, 76, 78, 76, 84, 84, 83, 76, 85, 85, 
  81, 94, 95, 74, 95, 100, 70, 85, 79, 86, 
  102, 85, 79, 79, 98, 83, 108, 79, 86, 95, 
  80, 87, 82, 85, 108, 83, 82, 67, 83, 66, 
  63, 86, 98, 83, 87, 76, 89, 74, 90, 92, 
  93, 72, 84, 82, 76, 86, 84, 90, 94, 74, 
  67, 79, 89, 95, 86, 78, 85, 80, 94, 75, 
  99, 88, 105, 68, 95, 83, 74, 83, 79, 77, 
  90, 94, 86, 96, 85, 90, 81, 91, 71, 75, 
  95, 98, 94, 77, 84, 76, 97, 82, 90, 95, 
  87, 87, 81, 84, 88, 99, 80, 80, 76, 75, 
  85, 83, 97, 83, 83, 62, 74, 83, 76, 78, 
  83, 63, 79, 78, 84, 75, 81, 101, 93, 91, 
  86, 105, 92, 90, 85, 83, 96, 86, 73, 80, 
  88, 77, 91, 77, 69, 80, 72, 83, 76, 87, 
  83, 77, 61, 85, 80, 87, 70, 81, 77, 99, 
  90, 77, 95, 91, 80, 78, 83, 83, 79, 82, 
  88, 55, 90, 75, 81, 81, 97, 86, 88, 70, 
  80, 81, 71, 90, 86, 94, 84, 58, 69, 85, 
  97, 91, 96, 80, 78, 96, 94, 81, 98, 72, 
  102, 51, 107, 82, 76, 78, 84, 79, 86, 78, 
  81, 96, 95, 65, 85, 98, 75, 56, 97, 89, 
  94, 66, 82, 76, 98, 77, 93, 96, 98, 101, 
  61, 89, 83, 86, 74, 93, 35, 72, 86, 86, 
  92, 89, 85, 59, 88, 74, 74, 78, 84, 68, 
  71, 83, 67, 69, 83, 106, 89, 90, 89, 100, 
  80, 81, 83, 81, 91, 86, 71, 74, 86, 78, 
  89, 86, 69, 84, 69, 85, 80, 86, 80, 69, 
  82, 94, 51, 92, 70, 88, 73, 93, 90, 73, 
  88, 94, 74, 87, 79, 86, 96, 83, 89, 75, 
  83, 76, 84, 80, 81, 91, 83, 77, 85, 84, 
  78, 84, 86, 92, 86, 73, 90, 84, 99, 88, 
  83, 79, 85, 87, 92, 78, 91, 72, 96, 88, 
  75, 84, 89, 90, 74, 77, 91, 94, 87, 89, 
  83, 68, 80, 88, 84, 82, 92, 98, 89, 73, 
  85, 84, 95, 80, 88, 90, 83, 86, 83, 85, 
  86, 92, 75, 80, 67, 80, 79, 83, 93, 80, 
  81, 88, 68, 87, 84, 79, 88, 82, 77, 85, 
  75, 76, 85, 104, 88, 79, 83, 98, 83, 88, 
  90, 77, 83, 92, 73, 78, 87, 78, 101, 83, 
  77, 79, 76, 81, 80, 83, 87, 87, 74, 90, 
  79, 81, 67, 80, 73, 97, 86, 76, 94, 94, 
  82, 73, 93, 74, 96, 83, 91, 92, 87, 81, 
  90, 92, 73, 79, 79, 96, 82, 98, 78, 85, 
  77, 83, 83, 97, 91, 89, 90, 81, 108, 76, 
  88, 71, 71, 95, 69, 74, 77, 96, 52, 81, 
  72, 86, 87, 95, 84, 83, 95, 80, 79, 75, 
  92, 84, 72, 79, 94, 92, 86, 77, 85, 75, 
  96, 72, 87, 63, 86, 92, 74, 86, 77, 83, 
  86, 94, 81, 80, 73, 109, 84, 92, 77, 114, 
  73, 77, 79, 76, 72, 79, 87, 80, 85, 85, 
  89, 79, 90, 76, 93, 70, 78, 67, 95, 87, 
  78, 73, 81, 53, 87, 76, 97, 98, 89, 94, 
  88, 73, 76, 79, 73, 75, 77, 86, 87, 100, 
  68, 77, 91, 85, 91, 75, 94, 92, 67, 84, 
  111, 77, 76, 87, 86, 74, 86, 75, 78, 86, 
  58, 94, 84, 91, 88, 77, 83, 82, 69, 78, 
  86, 108, 75, 87, 103, 65, 101, 73, 103, 86, 
  68, 105, 86, 76, 81, 79, 59, 50, 81, 71, 
  83, 98, 74, 92, 117, 76, 85, 102, 63, 93, 
  94, 70, 85, 81, 80, 86, 69, 83, 113, 64, 
  117, 55, 95, 102, 83, 88, 81, 127, 85, 107, 
  77, 83, 67, 96, 64, 83, 82, 88, 81, 69, 
  85, 76, 97, 86, 75, 80, 86, 93, 66, 74, 
  88, 91, 108, 61, 77, 57, 84, 123, 78, 92, 
  101, 108, 71, 81, 83, 110, 127, 86, 79, 68, 
  66, 89, 53, 89, 80, 103, 75, 110, 65, 61, 
  88, 74, 78, 66, 86, 84, 48, 93, 88, 92, 
  81, 85, 86, 77, 87, 84, 94, 90, 76, 84, 
  78, 61, 84, 94, 77, 84, 81, 82, 81, 93, 
  90, 85, 83, 85, 99, 81, 88, 83, 79, 98, 
  62, 87, 71, 79, 74, 84, 77, 83, 83, 88, 
  81, 88, 94, 83, 84, 104, 91, 80, 82, 74, 
  90, 97, 86, 87, 78, 79, 90, 82, 90, 60, 
  78, 93, 79, 86, 55, 92, 88, 75, 99, 80, 
  78, 87, 78, 89, 81, 76, 89, 81, 83, 83, 
  63, 84, 84, 71, 83, 82, 86, 75, 89, 99, 
  94, 77, 88, 70, 93, 85, 88, 72, 73, 92, 
  83, 81, 96, 82, 86, 90, 86, 69, 77, 73, 
  75, 96, 68, 81, 88, 97, 69, 72, 81, 86, 
  99, 79, 88, 85, 71, 79, 90, 78, 85, 89, 
  87, 93, 92, 82, 81, 84, 79, 76, 87, 78, 
  81, 87, 73, 77, 70, 87, 76, 95, 81, 82, 
  98, 90, 97, 71, 97, 65, 78, 92, 75, 84, 
  115, 102, 55, 82, 86, 85, 93, 84, 90, 93, 
  100, 90, 96, 81, 93, 76, 75, 75, 86, 86, 
  90, 97, 79, 77, 79, 72, 81, 75, 87, 87, 
  69, 78, 56, 75, 80, 68, 109, 73, 84, 90, 
  92, 81, 76, 116, 79, 81, 73, 80, 79, 88, 
  89, 81, 92, 86, 82, 87, 83, 87, 95, 84, 
  79, 71, 87, 82, 70, 74, 69, 57, 88, 83, 
  100, 94, 79, 85, 91, 63, 85, 80, 69, 83, 
  68, 80, 66, 99, 75, 71, 84, 73, 92, 75, 
  85, 79, 69, 85, 102, 73, 78, 92, 76, 72, 
  104, 80, 67, 83, 81, 86, 86, 87, 79, 79, 
  67, 76, 60, 81, 85, 105, 74, 83, 97, 69, 
  97, 64, 93, 122, 72, 95, 88, 76, 135, 82, 
  83, 78, 83, 59, 128, 98, 86, 98, 126, 87, 
  76, 105, 75, 67, 90, 61, 76, 71, 89, 82, 
  68, 84, 99, 59, 76, 73, 107, 103, 81, 84, 
  55, 93, 72, 71, 85, 91, 99, 80, 75, 78, 
  81, 83, 72, 79, 76, 82, 96, 94, 75, 86, 
  83, 77, 67, 95, 76, 89, 127, 85, 67, 67, 
  74, 112, 82, 86, 80, 65, 76, 86, 86, 100, 
  83, 84, 84, 53, 98, 77, 53, 85, 83, 79, 
  74, 115, 72, 74, 92, 55, 79, 76, 79, 65, 
  59, 89, 82, 82, 96, 89, 84, 81, 91, 81, 
  84, 84, 79, 83, 83, 87, 82, 83, 72, 75, 
  73, 88, 74, 90, 97, 81, 76, 90, 90, 72, 
  89, 107, 86, 95, 76, 83, 83, 80, 77, 81, 
  76, 82, 91, 84, 75, 97, 90, 92, 84, 115, 
  97, 75, 76, 83, 85, 90, 86, 70, 78, 82, 
  76, 78, 84, 61, 84, 79, 73, 78, 63, 75, 
  87, 61, 85, 78, 81, 82, 81, 85, 74, 67, 
  72, 83, 77, 85, 84, 96, 91, 82, 83, 82, 
  84, 84, 80, 71, 96, 86, 79, 72, 87, 81, 
  103, 73, 67, 65, 85, 83, 100, 87, 78, 83, 
  83, 65, 110, 76, 74, 96, 72, 71, 103, 94, 
  71, 73, 85, 76, 100, 71, 84, 74, 75, 82, 
  67, 73, 75, 92, 86, 82, 84, 78, 93, 85, 
  91, 76, 90, 78, 86, 83, 70, 82, 96, 90, 
  82, 81, 95, 95, 80, 94, 80, 77, 83, 74, 
  88, 89, 83, 82, 89, 86, 79, 91, 83, 83, 
  83, 73, 61, 92, 83, 82, 85, 89, 89, 81, 
  82, 83, 82, 108, 86, 82, 93, 89, 75, 89, 
  85, 83, 85, 83, 85, 85, 85, 76, 80, 71, 
  90, 72, 91, 77, 85, 81, 86, 82, 87, 78, 
  79, 94, 78, 88, 95, 79, 93, 79, 85, 95, 
  75, 90, 80, 97, 86, 78, 82, 73, 77, 80, 
  71, 91, 98, 79, 96, 89, 78, 83, 80, 80, 
  89, 77, 86, 93, 78, 81, 63, 85, 91, 75, 
  85, 95, 81, 88, 74, 77, 84, 104, 76, 76, 
  77, 98, 87, 63, 85, 83, 91, 79, 101, 72, 
  91, 86, 83, 83, 70, 91, 102, 97, 73, 77, 
  77, 87, 81, 92, 88, 76, 78, 96, 83, 90, 
  83, 74, 94, 77, 86, 91, 86, 78, 103, 70, 
  72, 85, 83, 83, 72, 67, 91, 79, 82, 84, 
  87, 105, 80, 91, 90, 92, 69, 82, 80, 76, 
  99, 88, 80, 80, 89, 77, 74, 67, 75, 72, 
  96, 74, 79, 72, 82, 68, 91, 65, 80, 99, 
  81, 84, 100, 83, 91, 76, 92, 93, 73, 93, 
  88, 100, 83, 71, 90, 79, 84, 77, 66, 85, 
  99, 79, 106, 95, 64, 87, 90, 72, 105, 68, 
  83, 88, 98, 94, 68, 81, 80, 81, 85, 94, 
  94, 80, 75, 81, 84, 101, 67, 78, 84, 89, 
  80, 88, 82, 79, 96, 84, 92, 74, 89, 86, 
  88, 81, 72, 82, 100, 93, 64, 83, 83, 93, 
  79, 91, 82, 75, 80, 93, 90, 95, 88, 75, 
  81, 82, 86, 86, 79, 80, 85, 73, 76, 90, 
  79, 83, 74, 79, 90, 80, 83, 92, 83, 108, 
  85, 72, 93, 90, 69, 94, 85, 80, 84, 81, 
  83, 89, 87, 73, 82, 76, 63, 68, 90, 70, 
  86, 82, 87, 81, 78, 74, 81, 86, 88, 80, 
  98, 79, 92, 79, 84, 86, 71, 81, 80, 98, 
  79, 77, 80, 76, 94, 81, 77, 77, 99, 80, 
  101, 95, 82, 82, 79, 85, 101, 82, 86, 93, 
  82, 85, 85, 84, 90, 75, 98, 95, 74, 87, 
  76, 79, 85, 102, 78, 78, 75, 79, 78, 72, 
  78, 92, 92, 97, 93, 83, 89, 84, 75, 83, 
  105, 95, 95, 90, 99, 85, 79, 86, 83, 80, 
  89, 103, 95, 86, 99, 71, 76, 83, 84, 84, 
  83, 76, 92, 78, 86, 73, 88, 75, 84, 89, 
  84, 93, 82, 56, 96, 89, 93, 55, 74, 87, 
  89, 81, 79, 82, 94, 79, 87, 77, 70, 67, 
  80, 88, 92, 81, 78, 95, 88, 93, 80, 90, 
  76, 84, 84, 68, 90, 76, 74, 90, 95, 78, 
  93, 85, 76, 92, 90, 78, 60, 71, 93, 83, 
  89, 79, 88, 91, 81, 69, 67, 73, 70, 74, 
  85, 84, 99, 98, 90, 83, 91, 81, 76, 96, 
  90, 90, 82, 79, 109, 106, 60, 70, 82, 94, 
  90, 89, 71, 80, 76, 70, 78, 67, 66, 92, 
  90, 88, 92, 96, 96, 87, 77, 80, 122, 93, 
  81, 92, 90, 65, 68, 94, 78, 73, 96, 100, 
  97, 77, 107, 67, 61, 88, 80, 77, 87, 74, 
  91, 70, 82, 73, 97, 65, 96, 80, 81, 77, 
  80, 48, 99, 83, 79, 48, 69, 87, 98, 79, 
  75, 93, 94, 63, 87, 89, 52, 65, 77, 84, 
  87, 78, 70, 89, 82, 102, 84, 89, 82, 84, 
  89, 68, 80, 81, 64, 95, 90, 84, 80, 80, 
  69, 96, 91, 90, 66, 75, 92, 83, 90, 81, 
  76, 81, 80, 81, 66, 77, 70, 75, 89, 91, 
  106, 122, 89, 83, 91, 84, 81, 86, 70, 86, 
  76, 73, 98, 126, 40, 78, 68, 95, 85, 90, 
  72, 84, 88, 79, 78, 84, 82, 87, 91, 94, 
  83, 81, 81, 84, 81, 86, 101, 92, 94, 81, 
  90, 83, 75, 89, 85, 82, 89, 94, 90, 77, 
  92, 87, 78, 80, 89, 90, 84, 75, 87, 77, 
  91, 76, 99, 79, 92, 85, 85, 84, 84, 68, 
  96, 97, 92, 63, 87, 78, 84, 82, 80, 76, 
  92, 85, 85, 73, 77, 72, 79, 85, 91, 77, 
  93, 96, 87, 95, 82, 93, 76, 85, 95, 68, 
  100, 75, 84, 94, 94, 81, 82, 80, 82, 95, 
  87, 84, 63, 73, 90, 85, 93, 84, 79, 98, 
  86, 87, 66, 73, 71, 72, 78, 92, 99, 92, 
  87, 80, 90, 99, 77, 89, 69, 90, 82, 83, 
  93, 94, 72, 69, 80, 92, 88, 90, 84, 81, 
  77, 82, 86, 73, 84, 110, 100, 94, 88, 95, 
  97, 80, 79, 70, 120, 96, 89, 84, 90, 82, 
  81, 94, 82, 79, 90, 99, 97, 90, 95, 70, 
  65, 84, 100, 83, 87, 75, 86, 84, 83, 68, 
  84, 66, 84, 97, 103, 91, 75, 48, 100, 84, 
  93, 55, 70, 86, 85, 79, 82, 83, 85, 86, 
  75, 79, 64, 66, 79, 88, 89, 67, 84, 85, 
  82, 80, 86, 68, 68, 91, 71, 61, 82, 86, 
  74, 86, 85, 91, 95, 75, 89, 82, 93, 78, 
  58, 64, 89, 78, 77, 75, 110, 76, 82, 82, 
  72, 73, 66, 73, 94, 78, 101, 121, 88, 80, 
  91, 74, 84, 79, 88, 87, 73, 56, 94, 110, 
  46, 81, 75, 83, 93, 94, 91, 75, 85, 73, 
  88, 71, 72, 115, 91, 80, 81, 110, 114, 91, 
  75, 61, 143, 92, 78, 91, 81, 78, 73, 104, 
  70, 69, 98, 91, 98, 94, 109, 68, 37, 92, 
  93, 76, 98, 80, 96, 77, 78, 69, 88, 52, 
  91, 82, 110, 69, 75, 28, 106, 76, 74, 44, 
  71, 95, 103, 75, 71, 94, 93, 71, 71, 96, 
  51, 63, 76, 83, 77, 78, 76, 78, 71, 76, 
  89, 60, 74, 86, 70, 56, 64, 89, 60, 92, 
  80, 108, 78, 72, 77, 88, 91, 82, 55, 62, 
  92, 79, 70, 77, 86, 62, 81, 80, 68, 79, 
  61, 74, 94, 85, 107, 156, 83, 83, 99, 76, 
  86, 71, 74, 83, 68, 49, 91, 141, 0, 91, 
  59, 79, 88, 97, 73, 89, 96, 84, 82, 89, 
  87, 97, 95, 93, 85, 85, 91, 86, 83, 77, 
  104, 93, 86, 82, 88, 88, 76, 98, 89, 80, 
  87, 91, 93, 97, 84, 83, 69, 80, 94, 88, 
  88, 75, 92, 80, 87, 71, 88, 71, 87, 91, 
  104, 81, 79, 61, 98, 87, 98, 63, 79, 87, 
  86, 83, 78, 75, 91, 90, 71, 76, 67, 73, 
  88, 85, 82, 72, 79, 89, 84, 79, 89, 74, 
  70, 84, 72, 65, 96, 82, 84, 101, 83, 94, 
  76, 75, 90, 90, 89, 81, 58, 67, 78, 81, 
  80, 82, 82, 85, 86, 72, 68, 73, 66, 73, 
  91, 85, 100, 107, 76, 79, 89, 98, 79, 81, 
  78, 87, 76, 65, 84, 94, 60, 80, 79, 80, 
  87, 90, 69, 79, 81, 94, 79, 75, 86, 91, 
  101, 102, 86, 86, 87, 79, 86, 82, 93, 78, 
  89, 83, 88, 80, 75, 73, 86, 87, 78, 94, 
  84, 79, 77, 82, 91, 78, 99, 82, 85, 88, 
  77, 99, 98, 70, 95, 86, 86, 103, 80, 108, 
  75, 88, 85, 93, 91, 70, 73, 82, 73, 75, 
  87, 78, 84, 101, 83, 75, 88, 69, 84, 94, 
  84, 79, 95, 82, 98, 86, 80, 76, 75, 83, 
  87, 72, 93, 83, 90, 77, 90, 94, 92, 76, 
  80, 82, 94, 97, 56, 69, 85, 92, 83, 76, 
  104, 100, 82, 96, 86, 67, 79, 94, 83, 78, 
  79, 66, 80, 85, 90, 79, 82, 99, 83, 86, 
  74, 75, 88, 82, 74, 75, 109, 80, 97, 87, 
  79, 81, 88, 92, 82, 70, 86, 89, 106, 97, 
  78, 94, 102, 84, 87, 78, 99, 79, 90, 80, 
  84, 81, 73, 79, 85, 84, 86, 92, 86, 88, 
  79, 80, 89, 81, 90, 77, 92, 84, 85, 107, 
  89, 63, 84, 77, 90, 95, 100, 86, 70, 89, 
  89, 89, 93, 62, 71, 79, 79, 70, 84, 80, 
  88, 86, 83, 78, 69, 66, 90, 89, 74, 86, 
  80, 76, 90, 87, 80, 72, 77, 85, 87, 70, 
  88, 83, 97, 91, 87, 105, 84, 71, 85, 85, 
  104, 89, 56, 65, 76, 91, 74, 74, 90, 85, 
  84, 89, 79, 68, 65, 90, 90, 81, 76, 89, 
  75, 82, 88, 80, 83, 94, 80, 80, 75, 73, 
  88, 92, 59, 76, 106, 75, 89, 96, 65, 88, 
  96, 91, 77, 85, 87, 85, 97, 103, 85, 78, 
  85, 82, 89, 92, 84, 83, 85, 83, 96, 86, 
  83, 79, 94, 85, 74, 89, 84, 94, 71, 86, 
  94, 74, 90, 87, 88, 87, 85, 97, 99, 70, 
  82, 86, 88, 96, 81, 88, 78, 95, 82, 88, 
  93, 73, 74, 78, 75, 80, 85, 74, 88, 99, 
  78, 73, 85, 74, 96, 90, 79, 91, 82, 82, 
  97, 86, 86, 74, 78, 83, 78, 71, 101, 82, 
  98, 106, 88, 100, 80, 78, 81, 87, 91, 84, 
  58, 71, 73, 93, 82, 80, 87, 102, 83, 75, 
  79, 68, 81, 94, 87, 85, 76, 64, 76, 86, 
  91, 93, 85, 102, 91, 88, 76, 84, 80, 79, 
  83, 73, 109, 81, 93, 86, 78, 83, 76, 81, 
  84, 86, 69, 80, 84, 96, 84, 98, 85, 89, 
  82, 83, 82, 97, 70, 73, 88, 72, 85, 88, 
  85, 80, 93, 72, 97, 87, 98, 68, 65, 83, 
  84, 81, 84, 83, 89, 86, 80, 81, 77, 84, 
  96, 74, 82, 100, 76, 100, 84, 77, 87, 92, 
  91, 89, 77, 71, 86, 84, 88, 83, 73, 84, 
  84, 79, 93, 79, 77, 98, 79, 93, 88, 77, 
  88, 82, 74, 89, 84, 86, 79, 83, 101, 88, 
  87, 99, 94, 86, 89, 78, 88, 80, 68, 97, 
  86, 72, 78, 87, 84, 86, 92, 93, 83, 86, 
  82, 75, 93, 81, 78, 50, 92, 72, 86, 90, 
  78, 87, 84, 76, 88, 91, 90, 72, 74, 69, 
  84, 103, 76, 83, 82, 84, 76, 80, 87, 75, 
  68, 78, 88, 94, 83, 92, 92, 88, 88, 75, 
  85, 92, 67, 71, 84, 67, 77, 90, 94, 83, 
  91, 65, 86, 82, 95, 64, 61, 78, 86, 76, 
  85, 83, 89, 84, 83, 82, 85, 83, 100, 69, 
  87, 98, 77, 97, 83, 81, 86, 87, 92, 82, 
  76, 72, 82, 87, 89, 84, 72, 89, 75, 82, 
  94, 87, 80, 92, 77, 96, 86, 69, 92, 74, 
  71, 88, 85, 90, 80, 81, 104, 87, 92, 102, 
  91, 81, 87, 77, 86, 74, 64, 95, 81, 72, 
  76, 86, 84, 89, 85, 97, 81, 84, 81, 77, 
  96, 81, 75, 38, 95, 70, 86, 93, 76, 87, 
  79, 74, 88, 89, 89, 64, 64, 68, 87, 105, 
  79, 84, 81, 85, 82, 74, 85, 82, 78, 81, 
  80, 93, 86, 95, 79, 84, 84, 83, 85, 94, 
  72, 78, 71, 72, 102, 90, 93, 82, 95, 75, 
  78, 82, 95, 61, 65, 73, 89, 81, 81, 77, 
  85, 81, 82, 78, 92, 82, 90, 75, 80, 89, 
  81, 92, 83, 85, 90, 86, 88, 79, 78, 77, 
  92, 87, 84, 80, 75, 85, 91, 80, 101, 81, 
  72, 89, 82, 91, 89, 82, 86, 83, 78, 99, 
  94, 84, 80, 80, 92, 84, 87, 89, 89, 87, 
  85, 77, 83, 88, 76, 91, 83, 76, 76, 90, 
  71, 83, 87, 97, 82, 87, 85, 73, 97, 83, 
  81, 59, 95, 76, 83, 97, 84, 83, 82, 74, 
  88, 92, 88, 75, 73, 69, 85, 103, 74, 83, 
  70, 85, 77, 79, 87, 90, 84, 78, 82, 85, 
  91, 95, 86, 88, 96, 82, 88, 83, 55, 74, 
  89, 67, 85, 93, 84, 82, 92, 60, 105, 86, 
  102, 60, 65, 74, 87, 73, 82, 75, 87, 97, 
  97, 79, 73, 88, 86, 76, 75, 90, 80, 99, 
  85, 81, 89, 76, 91, 93, 79, 77, 86, 88, 
  89, 85, 78, 84, 83, 77, 98, 76, 78, 88, 
  85, 85, 89, 74, 84, 75, 76, 88, 85, 85, 
  83, 78, 99, 81, 86, 89, 95, 89, 101, 85, 
  79, 107, 79, 90, 77, 75, 68, 86, 80, 76, 
  83, 86, 75, 88, 74, 58, 98, 86, 78, 60, 
  93, 79, 79, 89, 78, 73, 82, 67, 88, 91, 
  87, 72, 59, 79, 80, 103, 70, 83, 71, 87, 
  82, 77, 87, 73, 83, 81, 85, 82, 95, 92, 
  92, 89, 97, 77, 93, 75, 53, 69, 85, 62, 
  81, 97, 93, 81, 90, 52, 103, 88, 100, 55, 
  65, 73, 88, 71, 81, 76, 87, 93, 99, 70, 
  80, 85, 84, 75, 76, 90, 84, 96, 85, 85, 
  90, 65, 86, 80, 80, 73, 78, 92, 89, 89, 
  80, 87, 66, 73, 105, 82, 80, 77, 74, 82, 
  93, 70, 87, 63, 76, 91, 84, 89, 80, 75, 
  101, 85, 86, 96, 88, 87, 97, 84, 81, 99, 
  65, 86, 69, 76, 64, 88, 76, 82, 70, 88, 
  72, 88, 75, 59, 98, 86, 72, 55, 96, 76, 
  82, 95, 80, 77, 81, 59, 87, 92, 83, 70, 
  53, 83, 81, 105, 74, 84, 72, 92, 89, 73, 
  86, 81, 87, 82, 80, 89, 91, 93, 82, 85, 
  92, 79, 90, 79, 60, 75, 76, 72, 107, 92, 
  94, 80, 91, 65, 100, 82, 101, 55, 63, 71, 
  85, 77, 79, 72, 85, 95, 104, 76, 85, 89, 
  75, 81, 75, 87, 83, 94, 83, 88, 92, 71, 
  87, 78, 82, 82, 90, 93, 88, 81, 84, 83, 
  83, 74, 106, 76, 76, 86, 82, 82, 89, 89, 
  85, 79, 79, 97, 89, 84, 80, 77, 89, 83, 
  84, 81, 81, 94, 99, 89, 77, 117, 86, 84, 
  75, 80, 65, 89, 68, 75, 82, 83, 74, 89, 
  80, 61, 97, 87, 80, 74, 91, 83, 78, 102, 
  90, 68, 83, 71, 93, 94, 80, 80, 67, 79, 
  83, 99, 71, 86, 80, 83, 85, 72, 94, 99, 
  80, 74, 71, 84, 84, 93, 80, 91, 89, 98, 
  88, 84, 66, 80, 89, 84, 110, 87, 84, 83, 
  84, 73, 85, 83, 103, 86, 69, 74, 85, 73, 
  86, 67, 78, 106, 96, 62, 76, 89, 70, 81, 
  80, 80, 79, 104, 75, 84, 95, 73, 104, 85, 
  81, 85, 89, 88, 89, 75, 97, 75, 75, 81, 
  99, 78, 78, 90, 92, 92, 77, 91, 80, 84, 
  89, 84, 76, 80, 91, 79, 80, 91, 83, 76, 
  91, 91, 92, 85, 78, 125, 90, 84, 79, 78, 
  72, 83, 75, 68, 79, 86, 78, 90, 92, 63, 
  94, 86, 87, 85, 85, 76, 75, 86, 82, 68, 
  81, 80, 92, 92, 80, 83, 79, 79, 90, 91, 
  72, 84, 79, 84, 89, 66, 86, 90, 82, 76, 
  77, 86, 86, 92, 78, 90, 88, 97, 87, 74, 
  64, 78, 90, 84, 118, 87, 82, 81, 78, 67, 
  84, 83, 102, 82, 73, 73, 81, 77, 90, 71, 
  75, 105, 102, 58, 83, 87, 69, 79, 77, 81, 
  82, 106, 78, 88, 99, 67, 100, 88, 84, 83, 
  88, 94, 89, 74, 102, 82, 71, 75, 98, 86, 
  72, 91, 86, 93, 80, 103, 78, 88, 94, 89, 
  76, 83, 90, 74, 72, 85, 80, 73, 85, 99, 
  91, 80, 81, 135, 93, 81, 74, 80, 68, 84, 
  74, 76, 82, 92, 74, 89, 102, 65, 89, 89, 
  85, 92, 83, 73, 71, 87, 88, 66, 86, 86, 
  101, 99, 75, 86, 75, 81, 95, 92, 73, 83, 
  89, 85, 82, 70, 88, 97, 88, 78, 75, 90, 
  85, 92, 76, 90, 87, 98, 87, 79, 72, 81, 
  88, 92, 121, 88, 82, 85, 86, 74, 93, 78, 
  98, 92, 72, 74, 81, 85, 90, 70, 82, 104, 
  102, 64, 88, 92, 69, 87, 79, 82, 81, 101, 
  82, 86, 98, 73, 106, 88, 84, 96, 93, 92, 
  87, 75, 102, 76, 72, 78, 92, 81, 74, 82, 
  90, 91, 79, 109, 80, 95, 89, 94, 80, 81, 
  91, 79, 69, 75, 81, 69, 81, 96, 92, 86, 
  76, 135, 102, 77, 77, 85, 70, 90, 77, 71, 
  80, 93, 80, 88, 101, 65, 87, 88, 94, 100, 
  87, 78, 71, 90, 85, 58, 84, 90, 98, 99, 
  83, 87, 87, 86, 94, 84, 72, 90, 86, 77, 
  80, 67, 87, 93, 91, 77, 67, 60, 93, 85, 
  86, 89, 74, 82, 87, 99, 84, 89, 88, 103, 
  86, 76, 89, 88, 79, 115, 92, 85, 84, 83, 
  81, 88, 81, 73, 86, 83, 79, 88, 76, 79, 
  90, 86, 82, 76, 88, 79, 80, 87, 87, 83, 
  61, 75, 87, 83, 73, 93, 81, 83, 88, 85, 
  80, 78, 90, 77, 75, 89, 89, 83, 72, 81, 
  89, 84, 84, 74, 74, 70, 85, 90, 81, 78, 
  76, 91, 94, 71, 79, 89, 85, 88, 83, 84, 
  71, 88, 80, 93, 77, 80, 90, 99, 80, 84, 
  84, 79, 88, 87, 79, 93, 86, 100, 87, 85, 
  105, 82, 95, 76, 83, 155, 93, 87, 96, 95, 
  81, 93, 97, 78, 88, 86, 84, 84, 73, 71, 
  86, 75, 94, 76, 72, 54, 99, 84, 89, 79, 
  74, 79, 91, 91, 72, 90, 92, 95, 82, 94, 
  92, 86, 82, 109, 89, 85, 85, 85, 86, 81, 
  82, 73, 82, 89, 81, 83, 77, 79, 90, 83, 
  84, 79, 95, 70, 83, 83, 92, 78, 61, 78, 
  89, 82, 75, 90, 82, 81, 90, 84, 81, 77, 
  75, 81, 78, 88, 94, 80, 72, 79, 82, 80, 
  92, 70, 71, 77, 83, 91, 82, 85, 79, 76, 
  82, 71, 74, 85, 89, 93, 84, 87, 63, 89, 
  74, 103, 77, 77, 93, 101, 78, 83, 72, 81, 
  77, 88, 76, 92, 94, 108, 88, 80, 109, 75, 
  93, 75, 71, 160, 80, 85, 92, 93, 77, 91, 
  91, 78, 71, 88, 87, 94, 79, 72, 84, 79, 
  89, 76, 71, 68, 88, 84, 81, 83, 77, 85, 
  89, 93, 85, 90, 87, 97, 93, 78, 88, 92, 
  85, 113, 93, 80, 82, 83, 82, 77, 87, 91, 
  86, 89, 85, 88, 78, 83, 87, 87, 85, 79, 
  86, 78, 80, 86, 92, 81, 62, 78, 87, 90, 
  78, 92, 83, 81, 80, 82, 79, 68, 101, 72, 
  79, 88, 84, 84, 97, 78, 88, 83, 88, 77, 
  75, 86, 85, 91, 86, 75, 73, 82, 93, 74, 
  82, 85, 86, 89, 81, 87, 69, 86, 83, 95, 
  78, 82, 85, 97, 82, 84, 85, 78, 85, 92, 
  76, 93, 84, 93, 89, 83, 99, 80, 89, 73, 
  74, 135, 88, 88, 83, 94, 85, 91, 91, 72, 
  90, 87, 83, 79, 74, 79, 79, 90, 91, 82, 
  73, 62, 95, 85, 83, 88, 78, 77, 85, 87, 
  68, 89, 91, 92, 89, 79, 90, 83, 79, 109, 
  86, 81, 81, 84, 85, 87, 77, 75, 87, 82, 
  84, 85, 87, 79, 86, 80, 81, 78, 93, 84, 
  83, 90, 92, 79, 65, 72, 87, 80, 78, 86, 
  84, 82, 95, 89, 86, 79, 78, 79, 82, 86, 
  87, 71, 72, 81, 82, 88, 85, 69, 80, 76, 
  80, 94, 81, 80, 78, 87, 79, 75, 81, 85, 
  80, 85, 84, 84, 75, 88, 79, 92, 74, 76, 
  85, 99, 84, 87, 70, 80, 68, 78, 86, 89, 
  90, 97, 83, 83, 116, 81, 82, 79, 78, 156, 
  78, 87, 99, 95, 82, 92, 97, 76, 73, 86, 
  85, 83, 72, 85, 74, 77, 94, 81, 81, 60, 
  100, 82, 89, 83, 78, 72, 91, 86, 58, 87, 
  93, 92, 82, 93, 95, 77, 76, 100, 81, 83, 
  84, 93, 90, 84, 79, 76, 88, 80, 85, 77, 
  87, 84, 90, 79, 85, 83, 98, 78, 85, 88, 
  95, 81, 64, 70, 89, 78, 81, 82, 88, 76, 
  100, 88, 87, 78, 66, 88, 86, 87, 95, 69, 
  68, 81, 78, 83, 89, 63, 80, 86, 75, 96, 
  79, 85, 81, 80, 73, 80, 77, 84, 80, 91, 
  84, 83, 68, 89, 77, 98, 74, 75, 91, 99, 
  86, 81, 62, 81, 62, 80, 92, 89, 89, 101, 
  84, 82, 120, 79, 81, 81, 70, 162, 67, 85, 
  89, 94, 75, 87, 84, 71, 59, 86, 88, 96, 
  80, 82, 82, 84, 88, 79, 76, 68, 89, 84, 
  81, 82, 75, 81, 87, 85, 72, 82, 83, 91, 
  95, 81, 90, 87, 82, 111, 85, 78, 84, 87, 
  84, 80, 79, 85, 86, 93, 84, 83, 87, 82, 
  86, 86, 84, 81, 91, 83, 84, 86, 91, 84, 
  62, 75, 85, 84, 80, 87, 86, 78, 90, 85, 
  81, 72, 79, 76, 84, 85, 87, 75, 83, 79, 
  80, 87, 88, 76, 78, 90, 83, 93, 86, 74, 
  75, 88, 83, 80, 78, 84, 79, 87, 81, 86, 
  72, 88, 80, 85, 77, 78, 87, 96, 84, 75, 
  71, 78, 68, 82, 83, 90, 94, 90, 87, 82, 
  109, 82, 82, 80, 78, 136, 80, 85, 89, 93, 
  82, 94, 91, 74, 80, 89, 84, 81, 79, 81, 
  77, 91, 88, 78, 77, 75, 83, 89, 85, 88, 
  70, 78, 90, 86, 84, 87, 88, 96, 85, 71, 
  90, 83, 75, 116, 88, 77, 80, 85, 82, 82, 
  72, 74, 82, 90, 88, 88, 89, 81, 79, 83, 
  78, 82, 90, 86, 79, 89, 89, 76, 68, 70, 
  87, 83, 76, 83, 85, 86, 92, 89, 87, 82, 
  89, 74, 85, 83, 83, 79, 79, 81, 91, 83, 
  80, 70, 74, 78, 77, 87, 85, 82, 75, 90, 
  83, 73, 78, 85, 87, 84, 83, 87, 79, 85, 
  83, 81, 74, 78, 81, 99, 81, 90, 78, 77, 
  65, 79, 83, 93, 90, 89, 81, 88, 100, 84, 
  82, 77, 80, 139, 81, 83, 89, 88, 83, 94, 
  105, 81, 93, 87, 82, 85, 78, 87, 76, 77, 
  92, 80, 81, 73, 87, 85, 95, 84, 70, 77, 
  97, 85, 77, 86, 89, 93, 83, 76, 94, 78, 
  71, 111, 83, 81, 86, 86, 81, 80, 75, 78, 
  86, 81, 90, 80, 91, 86, 84, 86, 79, 83, 
  92, 81, 84, 87, 87, 77, 62, 72, 88, 81, 
  76, 81, 93, 83, 94, 90, 89, 84, 73, 80, 
  85, 83, 91, 77, 70, 81, 89, 82, 83, 63, 
  74, 82, 80, 88, 82, 88, 77, 83, 81, 80, 
  78, 86, 88, 82, 79, 90, 82, 92, 79, 89, 
  73, 75, 89, 99, 79, 77, 72, 77, 63, 78, 
  85, 91, 83, 89, 80, 88, 104, 82, 81, 80, 
  74, 142, 77, 81, 86, 89, 80, 90, 97, 75, 
  85, 86, 88, 95, 84, 84, 80, 84, 85, 79, 
  80, 80, 83, 88, 83, 85, 70, 80, 89, 81, 
  86, 80, 78, 92, 92, 75, 85, 87, 75, 112, 
  86, 75, 84, 81, 76, 77, 74, 83, 85, 97, 
  85, 88, 89, 82, 82, 89, 83, 83, 88, 82, 
  79, 84, 89, 85, 63, 74, 85, 81, 74, 84, 
  87, 83, 91, 81, 82, 73, 86, 73, 84, 80, 
  83, 77, 82, 81, 84, 83, 80, 73, 76, 83, 
  83, 90, 86, 79, 74, 82, 83, 77, 82, 83, 
  87, 88, 80, 88, 74, 89, 83, 76, 78, 81, 
  83, 95, 78, 75, 74, 76, 66, 78, 82, 90, 
  89, 85, 82, 87, 95, 83, 83, 82, 83, 123, 
  82, 84, 94, 88, 78, 94, 97, 81, 97, 88, 
  91, 91, 92, 80, 82, 70, 78, 66, 93, 86, 
  77, 93, 120, 103, 77, 83, 73, 65, 85, 95, 
  98, 64, 82, 95, 85, 85, 85, 87, 103, 83, 
  102, 100, 67, 76, 103, 103, 81, 82, 87, 88, 
  83, 92, 89, 90, 86, 111, 86, 92, 70, 83, 
  94, 89, 97, 73, 82, 71, 63, 64, 89, 89, 
  86, 72, 82, 90, 78, 66, 67, 74, 71, 76, 
  108, 93, 73, 81, 91, 64, 80, 108, 78, 84, 
  86, 87, 104, 78, 87, 86, 84, 91, 92, 79, 
  71, 86, 87, 103, 75, 86, 81, 93, 74, 61, 
  87, 93, 90, 84, 83, 84, 70, 91, 79, 85, 
  95, 91, 74, 98, 85, 102, 73, 88, 81, 75, 
  90, 87, 82, 74, 83, 80, 89, 92, 69, 57, 
  92, 86, 69, 104, 77, 97, 84, 95, 77, 72, 
  61, 92, 66, 84, 77, 67, 90, 83, 62, 76, 
  105, 100, 67, 92, 80, 81, 111, 89, 77, 81, 
  66, 79, 71, 110, 74, 90, 65, 82, 90, 72, 
  66, 68, 85, 96, 90, 106, 96, 70, 78, 86, 
  78, 72, 89, 75, 115, 72, 71, 87, 85, 88, 
  93, 58, 76, 72, 52, 80, 92, 88, 54, 81, 
  92, 86, 79, 94, 62, 96, 74, 70, 93, 81, 
  87, 90, 64, 80, 84, 99, 70, 81, 95, 90, 
  77, 85, 114, 75, 81, 78, 79, 77, 80, 88, 
  91, 84, 93, 84, 101, 70, 75, 64, 88, 94, 
  77, 91, 66, 97, 123, 82, 82, 75, 81, 84, 
  91, 92, 83, 91, 79, 77, 80, 63, 89, 72, 
  79, 76, 75, 92, 91, 75, 89, 75, 68, 79, 
  83, 89, 89, 90, 93, 81, 37, 72, 91, 81, 
  82, 97, 82, 79, 68, 87, 77, 82, 91, 95, 
  70, 98, 89, 85, 93, 94, 90, 64, 87, 83, 
  91, 78, 97, 91, 100, 89, 70, 85, 73, 93, 
  82, 98, 118, 88, 87, 80, 76, 99, 81, 72, 
  73, 106, 87, 89, 103, 75, 77, 72, 111, 87, 
  80, 93, 71, 75, 87, 83, 95, 93, 84, 73, 
  94, 86, 83, 70, 86, 89, 115, 86, 85, 92, 
  100, 77, 73, 88, 90, 99, 86, 83, 83, 91, 
  98, 81, 98, 85, 81, 78, 74, 68, 84, 77, 
  78, 91, 74, 83, 88, 76, 88, 81, 87, 98, 
  84, 91, 79, 81, 79, 87, 91, 78, 85, 66, 
  77, 65, 93, 86, 82, 87, 114, 106, 73, 83, 
  73, 65, 84, 97, 94, 62, 83, 96, 80, 87, 
  79, 89, 80, 81, 88, 88, 71, 74, 98, 100, 
  72, 80, 83, 90, 85, 77, 90, 84, 83, 107, 
  80, 80, 75, 94, 89, 83, 91, 75, 80, 75, 
  71, 67, 87, 90, 83, 66, 72, 86, 73, 68, 
  76, 74, 75, 84, 78, 89, 70, 82, 88, 68, 
  76, 110, 71, 84, 89, 83, 109, 85, 83, 90, 
  80, 91, 75, 73, 81, 79, 94, 98, 66, 85, 
  87, 91, 90, 64, 86, 70, 85, 84, 86, 89, 
  84, 83, 78, 84, 79, 87, 72, 96, 73, 85, 
  92, 83, 67, 72, 76, 87, 77, 71, 84, 79, 
  79, 91, 60, 63, 69, 86, 70, 94, 72, 94, 
  91, 91, 80, 75, 60, 77, 62, 81, 79, 74, 
  85, 87, 71, 74, 85, 99, 59, 90, 75, 78, 
  103, 78, 76, 75, 57, 81, 55, 103, 67, 93, 
  69, 74, 82, 70, 62, 65, 88, 90, 82, 83, 
  88, 70, 88, 82, 82, 75, 84, 71, 131, 70, 
  76, 94, 88, 75, 93, 67, 62, 82, 59, 79, 
  88, 79, 65, 74, 93, 90, 82, 98, 63, 97, 
  70, 63, 91, 75, 84, 82, 72, 81, 86, 92, 
  69, 86, 91, 94, 71, 80, 118, 75, 89, 78, 
  93, 79, 77, 75, 90, 86, 99, 94, 110, 78, 
  79, 65, 75, 94, 79, 82, 61, 74, 127, 80, 
  82, 78, 78, 83, 79, 92, 74, 90, 78, 77, 
  84, 83, 87, 69, 91, 66, 87, 84, 89, 67, 
  79, 84, 85, 85, 86, 80, 89, 87, 90, 80, 
  57, 76, 77, 79, 85, 98, 84, 76, 79, 71, 
  88, 88, 91, 88, 72, 93, 88, 85, 91, 91, 
  77, 73, 90, 95, 83, 80, 93, 72, 93, 84, 
  75, 85, 77, 85, 75, 95, 113, 86, 85, 85, 
  79, 90, 86, 78, 72, 108, 79, 74, 93, 75, 
  88, 81, 96, 95, 85, 78, 81, 75, 95, 78, 
  87, 90, 93, 74, 100, 88, 81, 71, 101, 97, 
  98, 81, 83, 93, 85, 82, 79, 87, 96, 93, 
  86, 79, 81, 93, 91, 81, 100, 88, 94, 82, 
  85, 71, 80, 68, 90, 90, 52, 79, 91, 87, 
  86, 83, 89, 87, 77, 92, 79, 93, 74, 103, 
  100, 81, 89, 82, 84, 67, 82, 87, 80, 88, 
  104, 110, 62, 74, 73, 64, 81, 94, 100, 75, 
  88, 94, 78, 75, 85, 93, 95, 95, 84, 88, 
  73, 71, 91, 99, 89, 83, 83, 89, 97, 78, 
  91, 84, 80, 108, 67, 80, 81, 91, 96, 86, 
  91, 73, 82, 78, 76, 64, 80, 83, 92, 70, 
  77, 87, 78, 66, 79, 77, 82, 81, 74, 84, 
  75, 81, 89, 70, 78, 107, 73, 87, 87, 90, 
  105, 94, 80, 94, 80, 87, 79, 81, 87, 73, 
  91, 86, 67, 84, 91, 86, 105, 77, 84, 75, 
  90, 81, 88, 92, 88, 84, 82, 81, 69, 91, 
  76, 96, 84, 71, 97, 80, 75, 75, 80, 80, 
  71, 75, 89, 76, 83, 87, 71, 68, 63, 83, 
  74, 106, 79, 97, 90, 87, 74, 73, 53, 80, 
  65, 83, 76, 74, 83, 76, 99, 79, 79, 89, 
  64, 93, 77, 77, 103, 92, 78, 86, 68, 82, 
  53, 102, 82, 91, 74, 73, 85, 73, 61, 72, 
  84, 100, 77, 89, 92, 65, 95, 80, 89, 73, 
  83, 75, 125, 77, 72, 93, 93, 71, 97, 64, 
  66, 78, 72, 81, 89, 72, 92, 78, 99, 93, 
  83, 99, 69, 94, 77, 66, 97, 87, 85, 81, 
  80, 82, 97, 85, 71, 86, 86, 97, 77, 81, 
  117, 81, 90, 84, 103, 78, 82, 78, 87, 87, 
  95, 80, 108, 79, 83, 69, 72, 88, 79, 78, 
  73, 76, 110, 84, 89, 85, 83, 83, 78, 93, 
  76, 94, 84, 80, 86, 81, 82, 73, 94, 87, 
  94, 84, 81, 71, 72, 78, 76, 84, 94, 81, 
  79, 90, 83, 77, 90, 80, 81, 81, 86, 98, 
  81, 73, 59, 91, 81, 87, 90, 83, 70, 83, 
  85, 80, 86, 87, 73, 83, 85, 97, 85, 87, 
  90, 80, 97, 78, 80, 91, 73, 83, 78, 82, 
  105, 90, 80, 73, 77, 87, 84, 74, 71, 104, 
  77, 76, 81, 83, 86, 84, 95, 97, 89, 89, 
  85, 78, 93, 77, 94, 93, 84, 86, 98, 81, 
  93, 74, 91, 77, 89, 82, 91, 89, 86, 89, 
  85, 92, 94, 83, 91, 80, 81, 95, 80, 70, 
  103, 88, 98, 78, 98, 69, 78, 71, 91, 99, 
  74, 82, 93, 93, 85, 81, 77, 91, 70, 97, 
  79, 88, 85, 88, 104, 85, 79, 83, 80, 84, 
  90, 82, 79, 87, 73, 87, 82, 82, 81, 83, 
  83, 95, 77, 77, 89, 81, 95, 78, 76, 79, 
  86, 85, 86, 85, 76, 80, 76, 93, 99, 92, 
  87, 78, 92, 78, 87, 78, 77, 72, 92, 82, 
  78, 81, 85, 78, 94, 92, 91, 79, 83, 78, 
  79, 84, 86, 80, 78, 80, 86, 81, 86, 84, 
  83, 85, 82, 84, 74, 67, 83, 78, 84, 75, 
  83, 83, 75, 88, 76, 79, 90, 79, 88, 82, 
  84, 86, 80, 77, 69, 81, 90, 81, 75, 88, 
  71, 80, 84, 85, 83, 83, 83, 83, 79, 87, 
  79, 86, 92, 79, 88, 85, 88, 79, 85, 86, 
  83, 78, 90, 87, 80, 86, 87, 92, 86, 76, 
  74, 93, 91, 82, 78, 87, 97, 77, 99, 80, 
  79, 78, 78, 78, 85, 88, 83, 76, 89, 86, 
  98, 80, 87, 90, 75, 88, 79, 78, 80, 81, 
  71, 65, 84, 77, 79, 84, 78, 85, 78, 114, 
  82, 81, 86, 82, 82, 92, 85, 80, 69, 93, 
  82, 92, 106, 89, 91, 85, 87, 74, 88, 89, 
  75, 86, 67, 83, 86, 83, 90, 79, 88, 72, 
  88, 83, 88, 92, 84, 92, 75, 82, 71, 91, 
  82, 93, 82, 83, 81, 71, 85, 73, 86, 83, 
  89, 76, 82, 81, 72, 85, 74, 91, 76, 82, 
  76, 79, 75, 80, 84, 77, 89, 87, 80, 85, 
  99, 82, 81, 88, 78, 66, 89, 79, 76, 79, 
  78, 80, 90, 80, 102, 93, 77, 80, 84, 84, 
  77, 83, 81, 86, 80, 81, 86, 80, 77, 85, 
  72, 79, 81, 86, 83, 83, 81, 80, 85, 79, 
  78, 79, 81, 77, 75, 79, 87, 76, 81, 81, 
  75, 93, 82, 80, 91, 86, 84, 81, 85, 77, 
  78, 74, 76, 71, 83, 70, 76, 82, 83, 73, 
  91, 90, 90, 93, 85, 79, 80, 87, 85, 84, 
  74, 81, 86, 81, 83, 84, 83, 87, 88, 83, 
  66, 70, 84, 79, 82, 86, 88, 77, 74, 88, 
  79, 85, 87, 79, 81, 86, 83, 88, 87, 78, 
  69, 76, 93, 77, 77, 89, 95, 76, 85, 82, 
  80, 80, 86, 82, 82, 86, 86, 82, 83, 82, 
  90, 90, 81, 80, 72, 83, 80, 76, 69, 87, 
  81, 87, 82, 92, 83, 78, 77, 95, 93, 83, 
  86, 75, 89, 82, 97, 77, 77, 83, 74, 82, 
  82, 84, 84, 88, 92, 83, 77, 69, 89, 83, 
  90, 95, 84, 79, 102, 78, 76, 75, 80, 73, 
  72, 87, 84, 84, 80, 100, 79, 77, 96, 83, 
  79, 74, 80, 80, 79, 81, 82, 92, 99, 93, 
  106, 78, 85, 83, 85, 75, 86, 74, 87, 77, 
  96, 85, 88, 75, 81, 93, 80, 86, 88, 81, 
  78, 80, 79, 71, 94, 81, 86, 77, 83, 73, 
  84, 75, 83, 77, 106, 82, 80, 90, 81, 86, 
  80, 88, 80, 92, 75, 84, 83, 82, 80, 85, 
  85, 88, 80, 86, 75, 80, 89, 81, 84, 76, 
  94, 61, 80, 81, 73, 93, 84, 80, 76, 87, 
  86, 77, 81, 79, 72, 87, 82, 82, 85, 82, 
  113, 88, 111, 78, 84, 80, 77, 76, 84, 93, 
  90, 90, 120, 80, 105, 76, 81, 93, 78, 101, 
  98, 82, 212, 84, 68, 70, 107, 83, 70, 78, 
  77, 85, 71, 141, 79, 75, 96, 89, 87, 106, 
  77, 79, 81, 102, 80, 101, 109, 96, 120, 78, 
  95, 92, 98, 86, 80, 82, 84, 72, 87, 94, 
  95, 75, 87, 79, 87, 101, 115, 99, 80, 113, 
  82, 79, 97, 83, 95, 83, 92, 74, 87, 73, 
  80, 76, 120, 84, 96, 83, 105, 87, 84, 95, 
  90, 96, 82, 86, 80, 69, 76, 85, 87, 93, 
  96, 91, 80, 85, 95, 87, 80, 81, 85, 55, 
  89, 77, 68, 98, 77, 88, 83, 81, 88, 77, 
  83, 96, 73, 74, 70, 78, 86, 83, 87, 77, 
  93, 75, 76, 76, 70, 73, 83, 85, 82, 87, 
  94, 68, 91, 72, 70, 79, 81, 90, 83, 78, 
  109, 77, 73, 74, 81, 81, 76, 69, 79, 81, 
  79, 101, 77, 76, 83, 79, 75, 73, 71, 66, 
  80, 83, 81, 88, 96, 91, 105, 79, 88, 90, 
  85, 74, 84, 76, 84, 71, 92, 86, 87, 74, 
  77, 96, 85, 89, 85, 82, 78, 88, 78, 75, 
  95, 76, 89, 77, 80, 77, 82, 81, 72, 84, 
  106, 84, 84, 82, 84, 80, 80, 83, 82, 90, 
  89, 80, 88, 62, 75, 82, 83, 87, 81, 85, 
  81, 77, 80, 81, 84, 81, 88, 64, 74, 79, 
  68, 94, 70, 84, 80, 86, 82, 77, 80, 82, 
  89, 93, 86, 83, 81, 76, 79, 78, 77, 79, 
  82, 83, 82, 80, 82, 81, 87, 86, 75, 95, 
  74, 79, 87, 78, 84, 80, 73, 82, 83, 81, 
  80, 78, 75, 79, 75, 99, 85, 82, 89, 78, 
  78, 78, 97, 76, 88, 67, 79, 93, 79, 83, 
  76, 77, 79, 86, 81, 86, 78, 74, 75, 82, 
  83, 76, 77, 77, 93, 75, 82, 91, 82, 87, 
  90, 88, 86, 73, 90, 81, 81, 73, 85, 84, 
  75, 80, 70, 73, 86, 88, 85, 82, 81, 77, 
  79, 83, 70, 87, 87, 88, 77, 86, 74, 70, 
  81, 96, 85, 88, 89, 87, 84, 82, 79, 75, 
  87, 78, 86, 84, 74, 85, 81, 84, 78, 86, 
  78, 84, 73, 89, 85, 80, 87, 82, 77, 80, 
  87, 81, 79, 83, 93, 70, 94, 78, 83, 76, 
  78, 75, 86, 88, 87, 81, 91, 84, 95, 88, 
  83, 84, 69, 83, 77, 81, 105, 77, 61, 66, 
  88, 80, 69, 85, 78, 79, 78, 113, 72, 77, 
  82, 86, 79, 83, 77, 86, 71, 93, 69, 93, 
  86, 85, 90, 79, 84, 81, 79, 86, 75, 81, 
  68, 77, 90, 77, 84, 79, 85, 86, 95, 95, 
  95, 88, 82, 98, 75, 82, 77, 87, 79, 82, 
  81, 77, 79, 85, 82, 77, 93, 80, 82, 73, 
  82, 83, 76, 91, 81, 89, 72, 82, 83, 83, 
  73, 84, 83, 83, 91, 86, 73, 78, 91, 79, 
  78, 82, 73, 70, 83, 80, 73, 85, 69, 80, 
  76, 80, 96, 71, 79, 87, 84, 77, 81, 83, 
  83, 82, 81, 73, 76, 76, 78, 78, 72, 84, 
  83, 84, 81, 90, 78, 81, 92, 79, 72, 74, 
  76, 76, 74, 80, 105, 78, 77, 77, 78, 87, 
  78, 79, 79, 80, 77, 86, 74, 74, 76, 74, 
  82, 67, 73, 70, 79, 80, 75, 75, 79, 86, 
  79, 74, 80, 83, 69, 83, 82, 80, 76, 76, 
  91, 76, 88, 88, 77, 97, 83, 90, 76, 77, 
  81, 83, 80, 85, 79, 77, 76, 78, 72, 89, 
  83, 93, 79, 87, 85, 78, 82, 74, 70, 82, 
  89, 85, 82, 87, 82, 71, 84, 80, 82, 85, 
  92, 87, 83, 82, 80, 72, 83, 80, 87, 84, 
  79, 88, 83, 82, 74, 89, 64, 86, 71, 87, 
  81, 80, 85, 84, 85, 82, 62, 81, 91, 80, 
  85, 83, 72, 85, 90, 70, 71, 97, 78, 73, 
  89, 89, 84, 80, 88, 81, 82, 82, 80, 79, 
  81, 83, 99, 94, 98, 88, 76, 74, 84, 91, 
  95, 77, 92, 69, 98, 119, 78, 80, 100, 75, 
  72, 91, 109, 87, 99, 91, 85, 95, 66, 104, 
  84, 87, 88, 74, 89, 89, 115, 100, 87, 80, 
  77, 78, 78, 72, 75, 86, 79, 80, 84, 85, 
  93, 71, 91, 87, 95, 82, 102, 89, 84, 58, 
  85, 84, 95, 77, 69, 77, 76, 74, 66, 74, 
  87, 71, 83, 102, 74, 79, 74, 91, 80, 74, 
  79, 79, 102, 74, 90, 101, 77, 79, 92, 92, 
  88, 87, 73, 86, 113, 81, 79, 82, 66, 86, 
  77, 82, 97, 84, 69, 81, 89, 73, 86, 82, 
  69, 90, 92, 72, 79, 105, 83, 75, 96, 85, 
  84, 77, 73, 81, 74, 84, 87, 86, 82, 82, 
  97, 84, 93, 100, 76, 74, 86, 74, 100, 70, 
  102, 70, 97, 131, 91, 83, 104, 72, 68, 85, 
  111, 84, 99, 100, 88, 99, 74, 96, 86, 86, 
  79, 77, 89, 82, 117, 110, 82, 90, 76, 77, 
  74, 71, 84, 93, 67, 75, 83, 84, 96, 80, 
  89, 99, 96, 84, 106, 78, 88, 59, 73, 84, 
  100, 82, 69, 73, 72, 79, 66, 70, 90, 84, 
  74, 106, 70, 75, 82, 93, 83, 71, 84, 79, 
  114, 81, 99, 95, 79, 76, 98, 90, 75, 87, 
  73, 78, 98, 73, 88, 88, 76, 74, 78, 82, 
  82, 78, 76, 83, 92, 76, 78, 75, 76, 83, 
  92, 77, 68, 88, 75, 81, 86, 85, 85, 85, 
  82, 83, 82, 80, 85, 88, 81, 78, 93, 77, 
  87, 97, 81, 73, 87, 82, 89, 79, 81, 72, 
  99, 105, 97, 79, 96, 84, 79, 93, 96, 88, 
  90, 89, 77, 98, 70, 72, 85, 83, 95, 77, 
  87, 97, 107, 94, 94, 78, 74, 83, 81, 75, 
  85, 86, 92, 76, 89, 90, 94, 97, 97, 82, 
  90, 82, 100, 85, 91, 70, 81, 86, 87, 87, 
  67, 85, 80, 82, 77, 75, 81, 74, 84, 101, 
  77, 75, 74, 89, 79, 78, 82, 80, 93, 78, 
  88, 96, 81, 91, 96, 95, 74, 89, 82, 90, 
  93, 83, 77, 84, 74, 82, 79, 81, 112, 85, 
  79, 88, 85, 77, 82, 86, 74, 82, 88, 73, 
  79, 111, 88, 74, 94, 77, 88, 76, 67, 88, 
  77, 86, 89, 79, 87, 88, 89, 72, 86, 98, 
  78, 90, 88, 76, 76, 89, 70, 81, 87, 108, 
  71, 84, 77, 78, 82, 90, 98, 89, 98, 97, 
  76, 75, 70, 70, 78, 90, 82, 78, 91, 81, 
  110, 96, 82, 79, 84, 68, 109, 75, 65, 85, 
  79, 75, 90, 83, 91, 74, 83, 79, 89, 92, 
  94, 78, 83, 87, 78, 86, 96, 68, 75, 73, 
  69, 79, 75, 67, 83, 81, 80, 80, 82, 80, 
  75, 84, 84, 102, 93, 79, 84, 83, 87, 91, 
  77, 69, 86, 98, 89, 85, 72, 73, 89, 79, 
  81, 88, 81, 77, 68, 84, 100, 85, 77, 91, 
  73, 74, 82, 87, 75, 85, 84, 78, 75, 88, 
  90, 75, 100, 78, 91, 74, 74, 76, 70, 85, 
  91, 76, 92, 89, 87, 72, 66, 97, 80, 87, 
  81, 72, 78, 92, 94, 75, 89, 89, 58, 87, 
  70, 81, 83, 85, 98, 89, 95, 84, 80, 72, 
  71, 91, 76, 87, 71, 89, 103, 81, 104, 89, 
  77, 76, 90, 78, 128, 79, 75, 82, 73, 78, 
  92, 82, 91, 71, 74, 71, 90, 87, 91, 85, 
  77, 91, 70, 81, 82, 66, 73, 75, 68, 76, 
  74, 61, 80, 90, 80, 74, 85, 87, 79, 88, 
  78, 106, 101, 78, 72, 83, 66, 91, 77, 72, 
  70, 93, 85, 83, 71, 64, 80, 73, 78, 92, 
  81, 70, 69, 76, 98, 91, 73, 89, 87, 85, 
  81, 81, 76, 84, 93, 79, 86, 78, 76, 78, 
  90, 75, 88, 80, 78, 85, 80, 84, 86, 84, 
  82, 89, 90, 77, 77, 109, 78, 81, 90, 82, 
  79, 89, 103, 81, 89, 105, 80, 81, 95, 78, 
  75, 84, 96, 88, 97, 83, 78, 83, 77, 107, 
  77, 89, 83, 78, 90, 85, 103, 107, 86, 85, 
  79, 75, 95, 81, 93, 85, 77, 73, 81, 83, 
  96, 90, 88, 88, 88, 89, 101, 83, 91, 88, 
  75, 84, 87, 73, 72, 68, 69, 83, 74, 69, 
  88, 84, 79, 92, 83, 85, 78, 86, 85, 98, 
  86, 84, 89, 87, 72, 88, 84, 81, 71, 93, 
  75, 84, 79, 76, 82, 82, 83, 87, 86, 77, 
  77, 87, 84, 93, 89, 85, 88, 96, 73, 68, 
  83, 89, 73, 83, 79, 87, 89, 74, 89, 85, 
  83, 81, 80, 80, 81, 89, 95, 91, 84, 92, 
  89, 84, 85, 87, 83, 83, 89, 89, 71, 86, 
  84, 91, 82, 92, 90, 95, 81, 95, 78, 89, 
  74, 91, 86, 83, 78, 71, 84, 79, 90, 73, 
  94, 78, 85, 92, 87, 81, 84, 75, 86, 84, 
  86, 90, 78, 64, 85, 70, 87, 98, 85, 92, 
  80, 82, 84, 93, 75, 88, 89, 87, 87, 94, 
  79, 94, 88, 76, 92, 85, 89, 89, 77, 80, 
  84, 77, 87, 80, 76, 81, 95, 69, 92, 82, 
  72, 84, 80, 85, 83, 75, 68, 89, 108, 88, 
  91, 82, 91, 94, 88, 77, 94, 80, 78, 71, 
  70, 97, 81, 82, 74, 98, 83, 70, 80, 90, 
  66, 85, 72, 84, 87, 77, 80, 92, 85, 85, 
  96, 82, 95, 85, 86, 92, 84, 92, 87, 82, 
  79, 74, 82, 85, 94, 89, 80, 80, 74, 82, 
  97, 87, 81, 95, 76, 105, 74, 92, 73, 98, 
  77, 80, 77, 64, 86, 78, 96, 65, 110, 83, 
  83, 100, 86, 69, 95, 70, 83, 95, 86, 93, 
  83, 68, 89, 71, 92, 107, 84, 86, 87, 72, 
  82, 90, 68, 88, 84, 79, 88, 88, 70, 97, 
  88, 83, 104, 84, 90, 94, 72, 74, 97, 69, 
  97, 77, 74, 82, 96, 71, 97, 79, 60, 83, 
  72, 89, 83, 91, 72, 92, 95, 86, 92, 89, 
  89, 93, 85, 80, 96, 77, 79, 69, 90, 99, 
  77, 87, 88, 86, 78, 71, 87, 93, 80, 84, 
  94, 91, 77, 77, 88, 79, 85, 84, 84, 86, 
  99, 87, 79, 87, 86, 96, 86, 77, 80, 92, 
  77, 80, 93, 90, 73, 84, 87, 92, 82, 101, 
  77, 89, 88, 88, 68, 91, 83, 96, 85, 84, 
  78, 80, 80, 84, 78, 73, 88, 76, 92, 89, 
  85, 89, 86, 74, 82, 78, 96, 92, 90, 74, 
  80, 70, 85, 97, 91, 87, 91, 91, 86, 92, 
  84, 84, 95, 87, 86, 88, 81, 86, 81, 78, 
  85, 88, 84, 85, 87, 84, 88, 87, 85, 81, 
  76, 82, 95, 76, 87, 81, 75, 82, 74, 93, 
  84, 89, 72, 84, 84, 89, 91, 84, 88, 85, 
  80, 80, 95, 76, 80, 78, 85, 83, 89, 87, 
  93, 88, 90, 77, 95, 84, 75, 85, 91, 81, 
  94, 82, 86, 83, 73, 79, 85, 81, 69, 72, 
  92, 88, 85, 78, 80, 87, 82, 77, 86, 84, 
  77, 81, 91, 85, 81, 89, 102, 88, 91, 101, 
  84, 88, 75, 91, 84, 79, 90, 94, 85, 92, 
  77, 93, 90, 86, 81, 84, 82, 80, 77, 76, 
  107, 94, 69, 85, 83, 79, 68, 75, 77, 68, 
  91, 82, 91, 74, 82, 92, 78, 92, 77, 78, 
  104, 81, 88, 80, 85, 85, 60, 69, 77, 97, 
  84, 91, 88, 99, 100, 88, 87, 74, 86, 86, 
  86, 81, 84, 95, 87, 74, 80, 78, 86, 79, 
  100, 68, 93, 84, 82, 86, 73, 87, 85, 87, 
  81, 77, 84, 75, 81, 90, 83, 85, 87, 68, 
  93, 80, 88, 82, 81, 78, 93, 86, 87, 77, 
  81, 89, 83, 81, 93, 76, 64, 76, 90, 93, 
  88, 81, 73, 93, 80, 75, 102, 78, 75, 62, 
  78, 71, 78, 94, 91, 66, 87, 94, 74, 82, 
  70, 70, 87, 103, 80, 102, 88, 82, 86, 86, 
  83, 91, 79, 75, 83, 68, 85, 80, 89, 101, 
  94, 88, 73, 90, 40, 61, 83, 80, 79, 82, 
  83, 53, 81, 83, 78, 93, 82, 74, 93, 87, 
  82, 74, 93, 85, 70, 70, 73, 96, 72, 88, 
  83, 92, 89, 91, 74, 71, 80, 78, 85, 85, 
  89, 96, 84, 85, 84, 81, 85, 77, 103, 77, 
  77, 79, 76, 90, 84, 92, 99, 95, 92, 81, 
  81, 88, 79, 90, 84, 80, 90, 62, 90, 84, 
  85, 80, 77, 81, 92, 81, 82, 77, 79, 89, 
  82, 84, 92, 76, 74, 72, 91, 91, 85, 82, 
  83, 84, 79, 78, 93, 77, 93, 76, 76, 75, 
  79, 93, 90, 64, 95, 97, 74, 86, 65, 60, 
  80, 96, 83, 91, 83, 86, 84, 95, 86, 87, 
  85, 76, 88, 72, 86, 82, 91, 101, 92, 92, 
  73, 77, 73, 61, 86, 73, 82, 68, 79, 77, 
  79, 84, 80, 87, 83, 75, 90, 85, 78, 69, 
  85, 87, 74, 77, 68, 95, 79, 85, 79, 92, 
  83, 89, 73, 80, 76, 76, 89, 86, 98, 91, 
  85, 84, 81, 81, 85, 86, 88, 76, 60, 76, 
  75, 92, 77, 93, 88, 92, 92, 76, 85, 87, 
  80, 78, 89, 80, 85, 80, 97, 92, 86, 81, 
  82, 70, 81, 83, 81, 92, 80, 89, 83, 79, 
  83, 77, 89, 72, 86, 103, 85, 76, 80, 92, 
  85, 79, 86, 71, 65, 79, 85, 78, 78, 102, 
  93, 80, 75, 98, 88, 87, 80, 84, 84, 88, 
  90, 94, 86, 83, 86, 71, 92, 86, 82, 84, 
  79, 67, 79, 51, 74, 94, 82, 69, 85, 73, 
  72, 76, 91, 70, 86, 86, 80, 79, 66, 96, 
  87, 97, 78, 91, 89, 80, 76, 71, 95, 83, 
  81, 70, 72, 87, 75, 85, 80, 86, 90, 80, 
  66, 45, 78, 83, 79, 62, 89, 95, 90, 94, 
  99, 74, 90, 76, 79, 71, 101, 76, 82, 89, 
  79, 87, 87, 93, 89, 79, 85, 95, 94, 73, 
  68, 74, 71, 60, 72, 83, 78, 88, 81, 62, 
  77, 83, 68, 79, 78, 77, 83, 70, 86, 94, 
  94, 100, 87, 81, 92, 82, 74, 87, 83, 82, 
  100, 68, 75, 72, 75, 72, 91, 70, 77, 67, 
  65, 77, 74, 87, 83, 72, 88, 104, 76, 83, 
  83, 75, 93, 49, 73, 84, 86, 81, 112, 82, 
  94, 104, 41, 92, 154, 87, 83, 129, 34, 76, 
  100, 95, 67, 80, 96, 95, 68, 68, 83, 81, 
  81, 92, 76, 89, 71, 113, 73, 76, 80, 90, 
  83, 78, 71, 65, 81, 73, 69, 78, 64, 85, 
  91, 82, 83, 81, 89, 92, 83, 109, 84, 96, 
  79, 70, 66, 118, 108, 77, 97, 91, 95, 101, 
  85, 80, 84, 94, 83, 118, 93, 92, 61, 77, 
  80, 67, 69, 94, 82, 85, 79, 68, 68, 64, 
  64, 88, 80, 71, 79, 76, 80, 85, 65, 87, 
  81, 77, 90, 86, 75, 78, 75, 85, 90, 81, 
  73, 76, 93, 73, 86, 75, 76, 60, 85, 78, 
  72, 101, 84, 102, 83, 87, 86, 79, 86, 81, 
  96, 77, 80, 86, 94, 73, 113, 90, 103, 109, 
  63, 88, 110, 97, 88, 103, 84, 65, 102, 96, 
  77, 77, 82, 79, 93, 57, 86, 78, 80, 72, 
  73, 76, 72, 102, 83, 75, 84, 120, 80, 76, 
  94, 59, 81, 73, 77, 77, 74, 140, 87, 84, 
  85, 78, 85, 92, 82, 96, 71, 110, 78, 74, 
  57, 96, 60, 71, 91, 85, 75, 83, 85, 79, 
  84, 87, 77, 102, 85, 81, 86, 83, 76, 82, 
  80, 91, 88, 80, 76, 77, 73, 85, 70, 93, 
  81, 87, 78, 96, 74, 85, 98, 63, 85, 91, 
  82, 85, 87, 80, 81, 85, 86, 74, 82, 95, 
  101, 90, 85, 89, 89, 78, 73, 93, 89, 77, 
  84, 78, 83, 73, 86, 96, 78, 85, 80, 86, 
  96, 86, 83, 82, 86, 81, 88, 50, 78, 86, 
  78, 70, 79, 87, 75, 69, 88, 73, 91, 82, 
  82, 90, 66, 96, 82, 83, 67, 97, 77, 77, 
  82, 84, 94, 89, 87, 93, 69, 76, 94, 80, 
  81, 81, 82, 81, 77, 60, 83, 83, 80, 65, 
  80, 90, 87, 85, 83, 82, 96, 78, 73, 83, 
  89, 70, 74, 86, 74, 81, 93, 89, 85, 81, 
  87, 92, 103, 69, 92, 86, 70, 93, 69, 71, 
  86, 85, 76, 79, 84, 96, 69, 81, 74, 70, 
  75, 91, 90, 85, 99, 85, 101, 77, 75, 85, 
  89, 88, 95, 86, 84, 94, 103, 108, 86, 85, 
  100, 62, 76, 71, 79, 74, 84, 93, 84, 94, 
  82, 67, 92, 93, 76, 81, 74, 76, 58, 77, 
  81, 93, 102, 88, 87, 93, 79, 73, 89, 87, 
  92, 80, 90, 107, 79, 85, 80, 83, 90, 118, 
  72, 78, 79, 71, 75, 112, 83, 88, 89, 107, 
  82, 87, 89, 76, 89, 77, 91, 72, 77, 71, 
  72, 87, 85, 77, 86, 85, 92, 74, 83, 95, 
  81, 79, 79, 94, 76, 87, 69, 103, 88, 91, 
  85, 91, 91, 73, 74, 73, 88, 97, 84, 81, 
  103, 80, 65, 82, 82, 91, 73, 74, 84, 81, 
  76, 84, 79, 84, 68, 82, 74, 64, 81, 89, 
  95, 76, 79, 75, 88, 83, 80, 88, 94, 83, 
  94, 84, 85, 99, 72, 106, 88, 82, 98, 64, 
  71, 63, 89, 73, 77, 101, 82, 111, 83, 55, 
  91, 81, 80, 80, 79, 97, 55, 79, 85, 87, 
  105, 97, 93, 88, 81, 72, 74, 91, 102, 79, 
  112, 107, 80, 90, 86, 90, 82, 97, 94, 69, 
  81, 78, 79, 86, 87, 87, 90, 108, 81, 85, 
  93, 98, 86, 92, 100, 73, 76, 76, 92, 84, 
  82, 102, 88, 90, 99, 69, 85, 94, 82, 74, 
  72, 102, 77, 88, 69, 98, 86, 94, 81, 94, 
  89, 65, 77, 72, 90, 96, 85, 83, 81, 94, 
  88, 81, 92, 83, 75, 78, 83, 78, 88, 88, 
  96, 78, 80, 81, 88, 85, 90, 83, 80, 79, 
  86, 82, 91, 76, 76, 80, 81, 87, 99, 83, 
  83, 81, 102, 82, 87, 68, 94, 88, 76, 93, 
  82, 88, 77, 79, 90, 82, 82, 87, 86, 90, 
  85, 85, 87, 83, 83, 75, 92, 84, 91, 94, 
  92, 82, 91, 96, 87, 70, 96, 86, 83, 87, 
  81, 78, 80, 78, 92, 89, 81, 95, 84, 92, 
  84, 91, 67, 82, 88, 93, 88, 71, 81, 82, 
  81, 84, 83, 70, 97, 86, 72, 89, 78, 87, 
  85, 89, 83, 84, 85, 90, 83, 86, 85, 85, 
  85, 70, 78, 73, 80, 83, 81, 85, 90, 99, 
  68, 73, 101, 93, 88, 93, 79, 96, 84, 74, 
  106, 79, 77, 68, 81, 75, 93, 83, 93, 79, 
  86, 80, 90, 75, 83, 78, 86, 82, 80, 84, 
  84, 79, 75, 82, 99, 92, 105, 79, 85, 86, 
  102, 82, 80, 58, 92, 94, 75, 83, 84, 77, 
  92, 88, 95, 87, 88, 87, 80, 85, 81, 88, 
  79, 79, 81, 67, 93, 91, 98, 110, 84, 94, 
  69, 98, 89, 70, 109, 71, 76, 85, 81, 82, 
  86, 82, 89, 94, 76, 89, 81, 77, 88, 82, 
  72, 90, 75, 92, 74, 79, 70, 78, 87, 88, 
  70, 74, 83, 87, 80, 88, 73, 84, 82, 92, 
  78, 82, 84, 90, 85, 85, 88, 88, 83, 73, 
  72, 71, 77, 88, 80, 82, 90, 98, 64, 75, 
  90, 90, 89, 94, 81, 90, 82, 81, 101, 95, 
  76, 71, 84, 78, 92, 84, 95, 85, 79, 86, 
  93, 85, 91, 78, 91, 74, 85, 82, 72, 71, 
  77, 87, 84, 93, 99, 78, 82, 87, 91, 91, 
  83, 61, 77, 90, 77, 82, 80, 81, 79, 82, 
  86, 87, 88, 87, 84, 86, 80, 85, 87, 90, 
  81, 72, 81, 88, 94, 93, 83, 94, 94, 88, 
  79, 73, 106, 76, 80, 79, 79, 85, 85, 79, 
  88, 98, 82, 82, 87, 85, 83, 75, 73, 90, 
  70, 82, 80, 78, 75, 91, 85, 84, 80, 71, 
  91, 88, 97, 79, 74, 87, 78, 91, 82, 84, 
  79, 94, 87, 88, 86, 90, 86, 92, 76, 72, 
  73, 78, 80, 79, 84, 98, 73, 73, 86, 91, 
  90, 93, 89, 98, 92, 89, 83, 83, 81, 80, 
  80, 83, 84, 94, 92, 86, 75, 83, 90, 81, 
  87, 83, 82, 73, 78, 86, 93, 79, 84, 86, 
  85, 84, 91, 80, 81, 87, 92, 76, 96, 88, 
  91, 79, 88, 84, 79, 81, 75, 83, 84, 89, 
  81, 85, 81, 84, 82, 82, 81, 89, 72, 81, 
  81, 87, 95, 81, 79, 84, 99, 85, 97, 74, 
  101, 85, 80, 83, 74, 89, 83, 74, 85, 85, 
  76, 94, 86, 100, 81, 93, 77, 93, 82, 91, 
  96, 69, 72, 89, 78, 94, 85, 73, 90, 85, 
  68, 90, 69, 93, 89, 97, 82, 92, 81, 83, 
  77, 81, 88, 77, 82, 73, 78, 77, 69, 98, 
  86, 75, 80, 84, 77, 71, 85, 89, 92, 86, 
  86, 91, 102, 94, 88, 76, 78, 73, 76, 84, 
  86, 90, 80, 80, 85, 95, 87, 72, 84, 84, 
  82, 74, 74, 88, 94, 79, 86, 86, 105, 86, 
  82, 69, 77, 93, 86, 78, 86, 93, 90, 76, 
  87, 63, 75, 71, 80, 91, 90, 82, 96, 82, 
  74, 74, 80, 85, 72, 79, 69, 73, 74, 91, 
  98, 100, 68, 94, 83, 73, 102, 84, 126, 72, 
  74, 73, 73, 98, 91, 79, 79, 88, 71, 71, 
  86, 89, 95, 90, 86, 101, 70, 90, 77, 72, 
  63, 88, 82, 88, 71, 66, 73, 86, 76, 80, 
  61, 78, 92, 99, 80, 96, 83, 82, 76, 79, 
  89, 83, 81, 70, 71, 72, 76, 103, 75, 73, 
  78, 72, 77, 73, 67, 90, 78, 79, 85, 82, 
  86, 96, 85, 84, 78, 70, 83, 90, 87, 86, 
  89, 84, 77, 87, 93, 81, 92, 87, 81, 68, 
  80, 89, 84, 73, 88, 91, 90, 89, 82, 71, 
  77, 90, 80, 95, 83, 101, 84, 81, 92, 73, 
  74, 78, 75, 84, 75, 87, 91, 83, 77, 78, 
  80, 81, 82, 91, 71, 76, 72, 90, 98, 84, 
  69, 94, 104, 72, 93, 85, 121, 91, 77, 73, 
  76, 99, 85, 75, 87, 92, 80, 74, 90, 95, 
  87, 76, 81, 94, 72, 86, 75, 74, 69, 103, 
  85, 89, 79, 70, 83, 85, 96, 76, 62, 77, 
  87, 98, 83, 100, 81, 82, 78, 84, 88, 84, 
  81, 86, 77, 82, 75, 95, 82, 78, 74, 78, 
  84, 71, 69, 94, 87, 81, 80, 97, 99, 86, 
  80, 81, 81, 75, 78, 92, 78, 95, 96, 93, 
  61, 88, 92, 83, 92, 90, 94, 74, 79, 82, 
  96, 74, 92, 94, 80, 84, 82, 87, 83, 93, 
  83, 78, 88, 100, 80, 85, 99, 83, 89, 81, 
  70, 82, 66, 82, 94, 89, 73, 87, 88, 76, 
  90, 74, 78, 78, 84, 75, 104, 83, 80, 80, 
  103, 80, 81, 90, 89, 90, 79, 77, 84, 93, 
  73, 82, 74, 85, 88, 81, 82, 89, 81, 93, 
  83, 88, 85, 90, 74, 85, 82, 80, 86, 85, 
  85, 81, 94, 76, 75, 95, 59, 89, 88, 100, 
  78, 103, 86, 90, 85, 83, 95, 81, 77, 88, 
  75, 84, 80, 93, 80, 83, 77, 77, 85, 69, 
  88, 96, 89, 77, 61, 83, 89, 88, 66, 76, 
  86, 72, 74, 99, 74, 97, 69, 74, 71, 92, 
  87, 89, 86, 105, 99, 75, 87, 72, 90, 70, 
  98, 91, 105, 79, 80, 71, 76, 101, 71, 86, 
  87, 102, 72, 66, 112, 75, 85, 71, 75, 84, 
  67, 73, 117, 78, 69, 68, 87, 73, 84, 68, 
  99, 68, 82, 84, 105, 103, 80, 88, 99, 69, 
  83, 119, 105, 93, 79, 81, 91, 99, 78, 98, 
  77, 80, 86, 60, 78, 84, 87, 86, 84, 91, 
  83, 85, 50, 78, 83, 80, 81, 78, 92, 74, 
  78, 76, 82, 85, 50, 76, 93, 104, 76, 109, 
  95, 83, 77, 84, 83, 88, 85, 80, 77, 86, 
  93, 87, 71, 95, 76, 73, 83, 77, 68, 101, 
  79, 71, 74, 75, 69, 86, 70, 78, 86, 69, 
  80, 96, 80, 89, 84, 78, 63, 89, 93, 91, 
  95, 98, 93, 72, 70, 80, 77, 70, 93, 94, 
  93, 89, 83, 77, 81, 94, 79, 94, 81, 102, 
  78, 71, 107, 74, 84, 81, 83, 82, 63, 85, 
  98, 83, 72, 73, 85, 77, 90, 82, 100, 79, 
  84, 80, 98, 86, 78, 87, 99, 76, 73, 106, 
  107, 96, 94, 74, 90, 98, 72, 95, 74, 80, 
  98, 66, 83, 95, 85, 72, 77, 91, 87, 88, 
  58, 88, 90, 90, 81, 80, 90, 77, 83, 77, 
  92, 86, 55, 75, 82, 101, 77, 96, 96, 83, 
  82, 90, 83, 90, 82, 93, 74, 86, 83, 79, 
  71, 93, 81, 74, 86, 74, 77, 104, 88, 79, 
  87, 75, 100, 99, 82, 90, 79, 81, 79, 95, 
  84, 85, 87, 81, 89, 89, 84, 93, 84, 82, 
  83, 78, 97, 76, 77, 93, 76, 80, 99, 91, 
  89, 77, 88, 69, 91, 104, 81, 103, 87, 89, 
  82, 78, 73, 87, 85, 83, 72, 75, 73, 81, 
  82, 81, 88, 77, 76, 87, 77, 80, 93, 80, 
  91, 75, 83, 84, 105, 78, 84, 75, 79, 105, 
  85, 83, 70, 97, 73, 80, 83, 73, 92, 75, 
  86, 82, 78, 93, 85, 63, 142, 83, 80, 89, 
  81, 92, 83, 89, 88, 79, 83, 91, 87, 77, 
  89, 78, 76, 85, 69, 74, 73, 85, 82, 77, 
  78, 89, 82, 73, 87, 91, 87, 90, 84, 88, 
  82, 86, 77, 86, 83, 166, 76, 80, 92, 76, 
  86, 81, 94, 80, 80, 78, 73, 76, 83, 77, 
  94, 91, 88, 82, 87, 87, 72, 92, 75, 80, 
  80, 69, 80, 95, 68, 70, 101, 92, 103, 87, 
  83, 68, 93, 74, 81, 78, 85, 88, 80, 86, 
  84, 87, 88, 81, 80, 85, 63, 77, 85, 91, 
  84, 73, 77, 82, 77, 79, 98, 72, 82, 81, 
  84, 85, 88, 80, 73, 79, 74, 82, 99, 87, 
  73, 84, 82, 78, 81, 84, 95, 85, 81, 83, 
  75, 85, 89, 57, 92, 76, 89, 83, 83, 84, 
  74, 96, 79, 88, 77, 95, 82, 85, 69, 79, 
  56, 88, 76, 78, 68, 86, 78, 80, 87, 78, 
  73, 104, 83, 92, 80, 105, 80, 87, 78, 81, 
  69, 78, 81, 153, 67, 86, 84, 72, 91, 89, 
  90, 80, 79, 81, 78, 100, 86, 86, 80, 86, 
  94, 86, 87, 87, 89, 94, 78, 82, 83, 80, 
  79, 90, 83, 82, 87, 88, 90, 87, 86, 72, 
  87, 63, 88, 95, 73, 93, 87, 79, 85, 84, 
  77, 82, 81, 89, 73, 80, 82, 81, 92, 78, 
  77, 71, 76, 80, 97, 76, 86, 86, 81, 84, 
  105, 77, 78, 79, 77, 86, 94, 81, 82, 86, 
  81, 81, 81, 95, 100, 76, 85, 84, 69, 83, 
  84, 74, 67, 86, 88, 90, 81, 98, 87, 86, 
  95, 82, 82, 93, 78, 72, 81, 87, 80, 84, 
  72, 81, 79, 78, 77, 80, 88, 89, 82, 142, 
  85, 82, 90, 87, 86, 86, 82, 86, 84, 95, 
  86, 146, 82, 79, 89, 84, 84, 89, 86, 87, 
  81, 74, 72, 72, 90, 81, 84, 90, 83, 80, 
  81, 90, 73, 72, 87, 87, 91, 75, 79, 88, 
  71, 70, 108, 93, 102, 80, 91, 66, 97, 103, 
  78, 89, 86, 86, 82, 78, 74, 91, 85, 81, 
  82, 82, 69, 85, 88, 89, 85, 80, 85, 86, 
  70, 80, 90, 86, 95, 80, 85, 84, 80, 76, 
  78, 86, 80, 83, 83, 82, 67, 89, 81, 73, 
  74, 64, 92, 83, 86, 88, 83, 88, 84, 98, 
  138, 77, 80, 77, 87, 84, 81, 84, 69, 83, 
  83, 95, 91, 80, 79, 85, 64, 89, 73, 84, 
  76, 90, 82, 85, 78, 87, 74, 51, 89, 90, 
  80, 103, 81, 82, 85, 75, 67, 73, 75, 97, 
  63, 92, 89, 84, 74, 75, 97, 80, 85, 72, 
  62, 70, 90, 74, 95, 81, 77, 74, 87, 87, 
  66, 81, 80, 89, 82, 75, 84, 89, 63, 66, 
  123, 92, 121, 98, 85, 71, 99, 68, 87, 88, 
  88, 87, 78, 83, 81, 94, 97, 78, 87, 92, 
  63, 79, 88, 80, 81, 75, 80, 81, 71, 73, 
  86, 87, 99, 83, 75, 93, 60, 80, 78, 101, 
  82, 68, 80, 90, 71, 81, 90, 75, 81, 88, 
  84, 104, 80, 87, 77, 87, 83, 103, 69, 75, 
  79, 72, 87, 78, 57, 96, 64, 96, 77, 111, 
  91, 95, 75, 83, 61, 92, 81, 92, 70, 89, 
  85, 88, 78, 79, 78, 70, 80, 85, 81, 131, 
  83, 78, 77, 77, 48, 79, 69, 63, 68, 106, 
  85, 77, 83, 82, 86, 79, 80, 74, 75, 77, 
  84, 83, 77, 78, 90, 80, 82, 88, 80, 86, 
  79, 85, 85, 76, 81, 88, 79, 71, 94, 79, 
  93, 96, 88, 67, 91, 59, 87, 81, 87, 86, 
  85, 76, 92, 88, 81, 80, 90, 90, 69, 85, 
  85, 84, 88, 74, 88, 87, 72, 78, 90, 81, 
  88, 88, 84, 83, 92, 75, 73, 92, 79, 78, 
  93, 78, 82, 82, 84, 77, 79, 97, 95, 80, 
  85, 89, 74, 85, 87, 109, 64, 85, 81, 83, 
  82, 87, 90, 79, 80, 83, 83, 96, 85, 74, 
  77, 85, 70, 86, 74, 85, 80, 83, 77, 86, 
  85, 88, 75, 127, 83, 84, 95, 96, 81, 81, 
  79, 74, 73, 77, 79, 85, 68, 83, 94, 80, 
  77, 93, 87, 94, 79, 73, 76, 93, 87, 84, 
  79, 88, 87, 82, 79, 92, 87, 74, 84, 84, 
  99, 78, 82, 86, 91, 77, 90, 86, 88, 88, 
  88, 69, 99, 118, 78, 78, 78, 88, 78, 76, 
  79, 91, 80, 84, 79, 86, 81, 82, 90, 82, 
  89, 79, 84, 90, 70, 79, 84, 84, 93, 81, 
  89, 79, 97, 75, 79, 81, 78, 82, 94, 81, 
  79, 81, 83, 83, 73, 64, 92, 79, 86, 85, 
  83, 89, 83, 137, 155, 78, 83, 85, 82, 100, 
  102, 84, 83, 83, 92, 88, 89, 76, 80, 101, 
  84, 85, 100, 85, 85, 98, 76, 92, 70, 92, 
  89, 58, 88, 86, 83, 90, 91, 85, 92, 77, 
  72, 78, 74, 74, 85, 84, 97, 78, 82, 93, 
  86, 89, 79, 69, 72, 79, 83, 81, 89, 84, 
  83, 81, 81, 90, 81, 78, 80, 92, 99, 79, 
  86, 77, 84, 69, 94, 86, 84, 100, 87, 73, 
  91, 82, 84, 70, 78, 86, 75, 79, 79, 96, 
  79, 88, 84, 89, 69, 81, 87, 84, 85, 78, 
  83, 86, 66, 70, 85, 79, 93, 80, 83, 78, 
  85, 75, 83, 84, 78, 76, 85, 80, 79, 73, 
  87, 77, 75, 80, 85, 90, 85, 86, 83, 93, 
  81, 158, 111, 76, 85, 86, 79, 89, 93, 84, 
  77, 86, 93, 90, 88, 80, 78, 87, 65, 83, 
  82, 86, 81, 93, 76, 89, 73, 84, 81, 92, 
  88, 91, 97, 104, 84, 84, 84, 74, 63, 72, 
  73, 52, 72, 86, 91, 82, 82, 84, 87, 90, 
  78, 75, 79, 98, 82, 82, 79, 80, 89, 82, 
  80, 93, 92, 80, 80, 86, 94, 78, 85, 88, 
  95, 81, 76, 82, 84, 99, 88, 74, 88, 69, 
  84, 69, 81, 87, 80, 75, 87, 90, 77, 84, 
  87, 92, 77, 83, 88, 83, 92, 77, 85, 87, 
  68, 77, 85, 82, 89, 84, 89, 78, 98, 74, 
  82, 86, 77, 86, 86, 80, 84, 81, 89, 86, 
  73, 90, 92, 80, 87, 86, 77, 92, 83, 152, 
  84, 87, 89, 89, 79, 94, 105, 84, 86, 82, 
  94, 87, 85, 77, 78, 90, 87, 83, 100, 83, 
  85, 93, 76, 91, 80, 90, 86, 130, 89, 84, 
  107, 89, 94, 84, 83, 78, 76, 78, 81, 66, 
  86, 81, 78, 80, 73, 91, 80, 79, 67, 95, 
  84, 82, 77, 99, 87, 72, 68, 87, 74, 71, 
  84, 91, 87, 70, 77, 88, 79, 68, 101, 84, 
  111, 91, 79, 83, 77, 82, 70, 90, 111, 86, 
  73, 72, 88, 88, 82, 62, 78, 70, 93, 86, 
  83, 64, 141, 72, 85, 88, 83, 70, 94, 91, 
  116, 75, 82, 69, 126, 76, 74, 77, 91, 79, 
  74, 77, 70, 115, 87, 84, 74, 67, 73, 89, 
  101, 94, 86, 92, 73, 81, 77, 80, 85, 85, 
  95, 80, 72, 99, 92, 68, 90, 69, 97, 84, 
  90, 91, 88, 72, 92, 91, 88, 79, 71, 90, 
  91, 77, 74, 75, 71, 85, 115, 102, 74, 80, 
  76, 87, 94, 95, 69, 74, 72, 90, 85, 83, 
  74, 86, 69, 95, 79, 85, 72, 95, 92, 86, 
  74, 100, 84, 66, 76, 95, 79, 77, 83, 90, 
  84, 71, 83, 84, 81, 74, 97, 88, 73, 76, 
  65, 86, 76, 86, 57, 89, 88, 87, 72, 74, 
  78, 80, 86, 68, 83, 69, 93, 77, 77, 64, 
  132, 74, 90, 89, 79, 61, 99, 89, 100, 81, 
  85, 68, 125, 78, 80, 74, 87, 77, 77, 65, 
  72, 105, 88, 86, 78, 71, 71, 86, 94, 93, 
  90, 88, 74, 85, 76, 82, 83, 78, 84, 85, 
  75, 92, 82, 71, 90, 77, 91, 88, 87, 86, 
  86, 66, 94, 90, 85, 66, 75, 86, 93, 79, 
  74, 75, 72, 82, 105, 82, 76, 79, 77, 81, 
  78, 92, 74, 78, 74, 84, 85, 67, 76, 84, 
  74, 93, 80, 78, 64, 90, 89, 85, 77, 103, 
  85, 76, 70, 84, 69, 74, 81, 91, 80, 68, 
  78, 89, 76, 69, 107, 86, 96, 77, 81, 87, 
  77, 84, 71, 91, 118, 85, 73, 71, 88, 87, 
  84, 63, 78, 69, 92, 76, 86, 66, 139, 79, 
  87, 85, 86, 65, 95, 93, 110, 77, 83, 74, 
  123, 75, 79, 74, 90, 76, 78, 84, 67, 111, 
  90, 81, 80, 70, 80, 91, 109, 88, 88, 94, 
  75, 96, 79, 81, 82, 77, 92, 86, 75, 94, 
  89, 70, 89, 68, 96, 87, 91, 88, 85, 73, 
  92, 91, 90, 79, 70, 90, 99, 75, 74, 77, 
  72, 86, 108, 91, 74, 84, 76, 90, 78, 94, 
  73, 73, 72, 91, 83, 83, 82, 79, 73, 87, 
  81, 82, 79, 83, 82, 81, 85, 85, 95, 84, 
  79, 78, 72, 88, 89, 84, 86, 75, 76, 94, 
  82, 89, 85, 84, 95, 82, 81, 81, 89, 77, 
  74, 79, 80, 82, 88, 80, 87, 76, 87, 71, 
  76, 87, 76, 80, 85, 83, 106, 75, 98, 87, 
  89, 86, 88, 78, 92, 77, 86, 71, 102, 79, 
  79, 90, 86, 83, 76, 74, 78, 93, 90, 69, 
  85, 84, 71, 87, 86, 76, 85, 65, 83, 77, 
  79, 82, 83, 84, 68, 88, 83, 78, 80, 87, 
  82, 78, 83, 85, 89, 82, 76, 77, 89, 88, 
  81, 78, 91, 88, 95, 84, 62, 83, 87, 85, 
  81, 91, 87, 84, 79, 80, 87, 87, 84, 84, 
  85, 89, 82, 92, 81, 87, 75, 87, 79, 82, 
  85, 83, 81, 86, 83, 81, 90, 89, 87, 85, 
  80, 89, 90, 82, 85, 79, 77, 87, 78, 95, 
  81, 83, 70, 77, 83, 87, 87, 76, 70, 79, 
  80, 86, 84, 84, 85, 77, 85, 73, 76, 80, 
  76, 80, 84, 83, 99, 82, 99, 86, 90, 83, 
  91, 79, 88, 79, 80, 71, 103, 82, 80, 93, 
  80, 81, 81, 68, 77, 88, 90, 70, 86, 83, 
  72, 74, 84, 77, 84, 68, 85, 84, 82, 81, 
  81, 75, 59, 85, 84, 75, 76, 90, 80, 85, 
  79, 86, 87, 81, 70, 77, 91, 88, 80, 71, 
  86, 83, 93, 80, 70, 85, 90, 79, 78, 81, 
  74, 85, 81, 76, 74, 86, 86, 86, 88, 83, 
  80, 87, 83, 92, 84, 86, 82, 85, 76, 79, 
  85, 83, 85, 87, 93, 89, 79, 80, 72, 88, 
  90, 83, 84, 75, 77, 92, 72, 87, 86, 81, 
  90, 77, 90, 85, 88, 77, 72, 84, 88, 84, 
  80, 79, 85, 81, 82, 73, 74, 82, 76, 83, 
  89, 80, 106, 84, 94, 85, 93, 84, 87, 76, 
  96, 71, 82, 75, 102, 74, 78, 91, 83, 78, 
  83, 76, 77, 90, 87, 68, 86, 82, 78, 76, 
  88, 75, 82, 65, 82, 86, 81, 81, 83, 77, 
  71, 85, 84, 71, 82, 85, 81, 76, 83, 85, 
  89, 83, 73, 92, 87, 90, 81, 82, 91, 85, 
  93, 80, 70, 86, 87, 83, 83, 82, 79, 86, 
  81, 84, 77, 87, 82, 82, 87, 90, 80, 90, 
  83, 82, 76, 90, 87, 85, 82, 74, 78, 82, 
  85, 68, 91, 87, 89, 81, 82, 91, 92, 85, 
  82, 88, 85, 88, 85, 98, 90, 83, 86, 84, 
  85, 82, 100, 84, 85, 79, 80, 79, 84, 88, 
  81, 86, 90, 89, 85, 98, 76, 83, 86, 98, 
  68, 88, 93, 91, 91, 95, 87, 78, 76, 77, 
  88, 77, 85, 75, 82, 90, 88, 87, 84, 82, 
  92, 88, 83, 87, 82, 92, 83, 89, 81, 80, 
  87, 70, 88, 89, 86, 83, 81, 77, 91, 88, 
  73, 82, 80, 96, 84, 85, 80, 84, 86, 84, 
  92, 89, 87, 83, 78, 78, 93, 81, 97, 92, 
  74, 99, 94, 87, 99, 82, 95, 84, 85, 87, 
  88, 84, 83, 88, 91, 80, 88, 92, 85, 85, 
  86, 88, 81, 94, 84, 74, 69, 82, 81, 66, 
  82, 94, 91, 84, 88, 88, 89, 88, 83, 89, 
  91, 79, 80, 100, 88, 79, 74, 83, 86, 83, 
  92, 79, 84, 85, 84, 84, 85, 84, 83, 85, 
  84, 88, 80, 88, 73, 89, 89, 92, 67, 88, 
  84, 87, 88, 94, 89, 81, 77, 79, 84, 79, 
  85, 76, 86, 92, 85, 90, 85, 86, 91, 88, 
  79, 86, 81, 89, 83, 80, 78, 82, 84, 77, 
  88, 90, 87, 86, 85, 77, 86, 79, 74, 80, 
  78, 98, 82, 87, 81, 84, 82, 77, 90, 88, 
  88, 82, 81, 76, 86, 79, 87, 86, 83, 98, 
  92, 80, 98, 86, 87, 85, 82, 86, 86, 86, 
  78, 86, 89, 81, 87, 92, 86, 93, 94, 90, 
  85, 92, 82, 70, 78, 83, 83, 69, 85, 93, 
  88, 81, 80, 89, 91, 88, 86, 87, 90, 85, 
  81, 92, 90, 83, 80, 82, 82, 82, 100, 74, 
  83, 90, 81, 82, 83, 85, 82, 87, 79, 90, 
  88, 96, 76, 88, 90, 94, 69, 89, 88, 87, 
  90, 91, 88, 79, 78, 76, 87, 78, 80, 73, 
  88, 90, 88, 90, 86, 90, 82, 83, 84, 87, 
  84, 94, 86, 74, 79, 80, 87, 67, 88, 85, 
  85, 83, 86, 78, 92, 86, 76, 72, 82, 94, 
  82, 83, 82, 84, 86, 84, 93, 88, 83, 85, 
  84, 83, 98, 79, 93, 90, 81, 99, 89, 77, 
  97, 85, 89, 83, 84, 90, 92, 85, 81, 86, 
  93, 85, 87, 92, 80, 86, 90, 83, 90, 88, 
  76, 76, 68, 76, 79, 75, 101, 80, 83, 92, 
  76, 70, 81, 71, 72, 84, 97, 81, 81, 74, 
  79, 78, 102, 77, 82, 94, 78, 90, 70, 81, 
  83, 84, 94, 82, 79, 76, 83, 85, 81, 76, 
  84, 89, 81, 75, 83, 107, 81, 77, 74, 104, 
  90, 73, 91, 83, 88, 75, 82, 71, 83, 63, 
  85, 97, 92, 90, 91, 71, 88, 81, 79, 90, 
  87, 86, 87, 78, 74, 79, 73, 92, 83, 81, 
  85, 82, 73, 80, 77, 84, 78, 80, 83, 71, 
  83, 77, 90, 84, 76, 92, 82, 83, 93, 81, 
  96, 96, 89, 66, 86, 88, 81, 100, 79, 86, 
  75, 86, 91, 91, 70, 86, 74, 85, 84, 72, 
  89, 78, 78, 84, 128, 88, 113, 82, 76, 76, 
  64, 86, 77, 64, 121, 86, 85, 76, 69, 36, 
  88, 61, 75, 106, 78, 70, 80, 70, 64, 84, 
  94, 78, 84, 82, 68, 98, 79, 97, 88, 87, 
  95, 114, 77, 74, 73, 84, 77, 63, 82, 100, 
  80, 85, 77, 129, 79, 91, 44, 97, 44, 72, 
  98, 77, 91, 71, 74, 67, 82, 79, 85, 85, 
  80, 76, 118, 72, 63, 77, 81, 69, 89, 109, 
  86, 67, 87, 70, 64, 81, 96, 77, 97, 117, 
  98, 76, 63, 89, 79, 68, 73, 73, 86, 71, 
  85, 82, 78, 89, 77, 84, 85, 74, 91, 105, 
  77, 53, 105, 82, 68, 101, 91, 81, 91, 80, 
  84, 87, 77, 87, 76, 75, 103, 71, 72, 80, 
  79, 76, 106, 81, 90, 90, 81, 75, 71, 78, 
  75, 78, 87, 94, 79, 94, 84, 73, 84, 66, 
  90, 82, 83, 87, 77, 74, 82, 74, 87, 75, 
  95, 90, 73, 78, 66, 85, 88, 81, 82, 79, 
  76, 78, 76, 82, 87, 89, 83, 85, 85, 71, 
  85, 89, 87, 78, 79, 64, 94, 75, 80, 90, 
  98, 77, 81, 77, 83, 65, 93, 110, 84, 87, 
  86, 78, 97, 83, 84, 90, 89, 90, 81, 80, 
  68, 76, 76, 70, 78, 74, 104, 82, 71, 83, 
  80, 93, 83, 82, 81, 75, 88, 76, 91, 88, 
  70, 95, 91, 81, 92, 82, 78, 88, 87, 75, 
  91, 96, 79, 83, 87, 83, 88, 84, 87, 91, 
  85, 85, 79, 86, 78, 78, 87, 80, 79, 86, 
  100, 89, 91, 95, 72, 77, 74, 81, 84, 77, 
  99, 93, 81, 80, 71, 70, 81, 72, 80, 89, 
  94, 85, 95, 74, 82, 82, 101, 96, 85, 94, 
  78, 83, 89, 82, 102, 92, 79, 70, 89, 76, 
  80, 77, 80, 94, 91, 87, 82, 76, 79, 98, 
  89, 74, 76, 83, 86, 74, 91, 92, 91, 83, 
  71, 73, 89, 60, 82, 106, 81, 79, 87, 73, 
  91, 83, 83, 92, 90, 85, 73, 76, 71, 75, 
  70, 92, 83, 81, 81, 80, 67, 89, 78, 69, 
  82, 91, 82, 71, 91, 80, 82, 76, 81, 74, 
  80, 82, 78, 86, 86, 95, 89, 75, 93, 92, 
  81, 101, 89, 75, 83, 93, 97, 86, 74, 86, 
  82, 89, 82, 76, 91, 76, 78, 83, 118, 85, 
  113, 92, 77, 76, 65, 88, 76, 65, 124, 88, 
  88, 69, 66, 43, 77, 63, 84, 107, 82, 71, 
  80, 71, 66, 87, 96, 81, 81, 77, 74, 99, 
  97, 97, 95, 88, 98, 114, 93, 75, 83, 78, 
  85, 74, 89, 101, 82, 88, 75, 115, 79, 91, 
  51, 106, 42, 75, 99, 79, 79, 80, 67, 66, 
  86, 75, 77, 90, 73, 61, 112, 68, 70, 84, 
  86, 76, 83, 102, 75, 66, 86, 72, 65, 79, 
  90, 70, 91, 106, 97, 71, 69, 77, 87, 75, 
  67, 72, 91, 76, 89, 73, 81, 82, 71, 83, 
  87, 72, 80, 107, 80, 57, 108, 80, 73, 97, 
  89, 64, 92, 82, 84, 81, 81, 86, 80, 74, 
  101, 72, 75, 73, 87, 85, 86, 87, 88, 93, 
  78, 76, 80, 85, 81, 80, 100, 80, 81, 84, 
  78, 77, 83, 69, 87, 76, 92, 85, 79, 73, 
  85, 79, 90, 82, 86, 88, 74, 83, 88, 88, 
  113, 87, 97, 65, 84, 83, 84, 78, 85, 95, 
  82, 89, 88, 72, 77, 75, 88, 79, 84, 81, 
  94, 75, 86, 93, 90, 90, 73, 78, 83, 68, 
  76, 104, 79, 76, 100, 78, 102, 83, 87, 85, 
  91, 85, 80, 82, 71, 76, 76, 75, 77, 70, 
  101, 76, 70, 85, 80, 81, 85, 92, 85, 75, 
  92, 80, 100, 77, 78, 92, 87, 80, 79, 77, 
  71, 89, 87, 82, 81, 88, 82, 87, 80, 67, 
  97, 88, 92, 87, 85, 88, 89, 87, 79, 76, 
  90, 79, 83, 89, 99, 87, 79, 99, 79, 75, 
  71, 75, 84, 68, 92, 91, 77, 72, 72, 64, 
  81, 82, 85, 84, 92, 80, 89, 72, 89, 81, 
  93, 93, 91, 88, 93, 82, 90, 90, 115, 91, 
  69, 78, 90, 71, 72, 76, 77, 91, 101, 90, 
  84, 67, 83, 99, 86, 76, 80, 66, 90, 79, 
  85, 86, 94, 82, 79, 61, 91, 61, 88, 89, 
  82, 80, 95, 74, 85, 84, 82, 88, 78, 91, 
  69, 78, 71, 88, 70, 84, 81, 84, 80, 84, 
  80, 87, 91, 76, 86, 86, 88, 74, 97, 75, 
  78, 75, 76, 80, 79, 81, 79, 79, 89, 87, 
  87, 74, 96, 85, 78, 90, 88, 79, 83, 90, 
  92, 87, 80, 83, 80, 80, 92, 82, 83, 86, 
  87, 88, 105, 89, 84, 102, 78, 74, 71, 85, 
  83, 54, 108, 69, 84, 72, 71, 54, 85, 71, 
  86, 90, 86, 78, 82, 73, 78, 92, 83, 84, 
  84, 82, 82, 91, 117, 100, 117, 89, 83, 98, 
  85, 75, 84, 73, 78, 86, 102, 111, 93, 76, 
  76, 85, 83, 88, 74, 84, 64, 76, 86, 85, 
  91, 87, 69, 51, 76, 72, 88, 79, 84, 68, 
  103, 71, 80, 82, 78, 72, 75, 115, 56, 71, 
  80, 71, 77, 86, 78, 74, 83, 98, 70, 82, 
  79, 79, 93, 82, 78, 67, 98, 77, 84, 75, 
  70, 79, 73, 83, 80, 80, 82, 88, 92, 71, 
  97, 73, 74, 86, 66, 77, 103, 89, 89, 84, 
  88, 90, 80, 72, 98, 77, 77, 99, 89, 85, 
  79, 87, 74, 89, 84, 78, 76, 82, 82, 76, 
  99, 75, 81, 75, 73, 74, 84, 75, 82, 74, 
  94, 84, 79, 76, 85, 81, 83, 72, 86, 85, 
  87, 88, 89, 92, 121, 87, 93, 75, 90, 76, 
  92, 78, 76, 88, 93, 94, 87, 69, 86, 88, 
  83, 80, 87, 88, 95, 84, 85, 83, 91, 86, 
  85, 68, 88, 64, 85, 90, 85, 87, 91, 75, 
  89, 83, 83, 80, 79, 85, 83, 77, 75, 94, 
  76, 78, 76, 76, 90, 82, 84, 80, 87, 85, 
  85, 88, 84, 76, 94, 77, 98, 73, 73, 84, 
  86, 78, 74, 74, 71, 88, 82, 76, 79, 80, 
  82, 82, 83, 78, 104, 86, 89, 84, 84, 85, 
  85, 80, 94, 80, 84, 87, 80, 106, 84, 93, 
  76, 75, 75, 87, 80, 78, 74, 78, 91, 80, 
  64, 97, 80, 83, 84, 101, 75, 66, 79, 76, 
  72, 64, 90, 77, 107, 98, 92, 79, 87, 83, 
  76, 95, 95, 87, 114, 80, 79, 92, 83, 87, 
  76, 75, 88, 92, 81, 76, 94, 86, 86, 79, 
  77, 110, 87, 92, 97, 83, 74, 85, 97, 81, 
  82, 73, 93, 73, 71, 94, 108, 82, 83, 89, 
  67, 79, 74, 73, 99, 75, 84, 86, 81, 95, 
  88, 80, 89, 89, 86, 81, 89, 94, 80, 74, 
  89, 84, 83, 78, 86, 88, 95, 91, 87, 78, 
  85, 90, 80, 85, 77, 72, 77, 80, 76, 77, 
  84, 90, 49, 90, 87, 92, 83, 94, 81, 73, 
  84, 95, 74, 79, 81, 111, 68, 91, 74, 90, 
  77, 85, 76, 85, 79, 83, 95, 58, 66, 93, 
  73, 84, 78, 87, 74, 79, 88, 84, 80, 77, 
  88, 86, 79, 107, 85, 79, 84, 85, 87, 100, 
  83, 85, 115, 81, 84, 99, 81, 81, 89, 78, 
  84, 97, 85, 75, 90, 82, 87, 84, 77, 101, 
  94, 72, 85, 84, 76, 86, 81, 74, 68, 83, 
  87, 76, 69, 77, 117, 83, 84, 80, 80, 86, 
  75, 94, 90, 89, 82, 86, 83, 84, 85, 71, 
  83, 90, 61, 78, 88, 82, 85, 71, 92, 80, 
  85, 88, 88, 90, 86, 99, 84, 77, 85, 86, 
  83, 83, 84, 73, 76, 76, 80, 79, 67, 91, 
  60, 83, 90, 86, 90, 89, 81, 80, 81, 87, 
  76, 92, 79, 104, 72, 87, 83, 83, 86, 94, 
  82, 77, 78, 78, 89, 64, 78, 88, 85, 88, 
  86, 78, 82, 96, 93, 85, 83, 91, 79, 89, 
  88, 99, 84, 80, 84, 88, 79, 82, 66, 82, 
  98, 93, 87, 91, 86, 81, 91, 85, 89, 82, 
  80, 88, 91, 86, 90, 88, 81, 82, 87, 69, 
  73, 82, 93, 76, 78, 65, 78, 78, 93, 83, 
  90, 83, 93, 79, 84, 80, 91, 83, 86, 81, 
  95, 94, 91, 80, 80, 81, 86, 70, 86, 80, 
  69, 76, 79, 86, 83, 77, 82, 76, 82, 97, 
  88, 86, 75, 100, 76, 78, 86, 85, 81, 83, 
  86, 79, 78, 84, 88, 90, 63, 92, 86, 85, 
  91, 83, 99, 91, 83, 79, 86, 91, 77, 92, 
  79, 95, 85, 86, 71, 66, 80, 83, 85, 74, 
  71, 91, 78, 100, 58, 82, 75, 77, 90, 88, 
  79, 70, 78, 72, 72, 73, 98, 79, 82, 76, 
  88, 77, 81, 79, 49, 78, 74, 82, 83, 79, 
  72, 88, 75, 80, 74, 78, 90, 82, 84, 78, 
  96, 85, 87, 82, 73, 102, 86, 93, 84, 80, 
  73, 88, 109, 87, 87, 70, 100, 86, 80, 92, 
  73, 83, 78, 82, 71, 77, 85, 54, 104, 72, 
  82, 89, 73, 90, 87, 85, 88, 90, 102, 86, 
  86, 95, 77, 80, 82, 86, 81, 79, 80, 83, 
  89, 102, 89, 78, 87, 87, 83, 85, 92, 79, 
  82, 72, 76, 78, 89, 108, 66, 94, 90, 98, 
  93, 86, 81, 77, 80, 94, 76, 72, 86, 110, 
  96, 91, 79, 68, 81, 82, 79, 86, 87, 78, 
  85, 78, 63, 89, 78, 77, 82, 80, 82, 74, 
  80, 82, 82, 75, 85, 83, 64, 126, 89, 71, 
  83, 78, 78, 86, 114, 96, 111, 77, 100, 100, 
  62, 73, 80, 76, 88, 101, 87, 70, 88, 74, 
  81, 87, 83, 98, 87, 79, 72, 82, 77, 89, 
  78, 89, 57, 94, 82, 70, 73, 80, 62, 74, 
  79, 79, 78, 77, 87, 64, 87, 83, 76, 78, 
  77, 80, 93, 92, 72, 97, 71, 71, 77, 80, 
  88, 80, 87, 82, 90, 84, 93, 84, 90, 102, 
  89, 78, 77, 87, 73, 83, 87, 78, 88, 81, 
  77, 67, 74, 90, 57, 89, 96, 92, 99, 79, 
  82, 77, 78, 83, 82, 86, 85, 109, 119, 93, 
  93, 106, 84, 89, 83, 85, 90, 72, 89, 75, 
  82, 88, 92, 87, 86, 81, 87, 98, 102, 85, 
  91, 91, 71, 89, 83, 148, 91, 82, 86, 80, 
  94, 96, 96, 82, 98, 83, 96, 94, 70, 77, 
  91, 90, 92, 123, 81, 85, 81, 74, 81, 86, 
  94, 54, 81, 74, 67, 81, 91, 77, 63, 58, 
  56, 85, 75, 76, 80, 69, 70, 82, 81, 81, 
  93, 83, 92, 64, 61, 91, 83, 68, 84, 101, 
  91, 87, 77, 89, 56, 74, 81, 66, 86, 83, 
  82, 77, 87, 93, 83, 77, 84, 87, 78, 80, 
  81, 77, 75, 80, 80, 84, 98, 90, 82, 79, 
  53, 76, 78, 90, 92, 81, 93, 92, 86, 79, 
  79, 78, 82, 100, 86, 87, 92, 92, 72, 90, 
  80, 81, 89, 75, 66, 84, 84, 97, 71, 75, 
  80, 79, 94, 81, 78, 88, 79, 76, 82, 89, 
  86, 89, 90, 75, 87, 79, 72, 82, 70, 90, 
  58, 91, 72, 88, 73, 82, 76, 82, 81, 82, 
  82, 91, 87, 79, 93, 91, 82, 80, 78, 86, 
  87, 83, 83, 86, 85, 82, 94, 86, 94, 74, 
  86, 94, 78, 77, 78, 83, 82, 83, 79, 78, 
  86, 82, 84, 78, 87, 84, 73, 95, 87, 85, 
  93, 90, 100, 92, 82, 91, 80, 82, 90, 77, 
  83, 76, 76, 73, 87, 90, 86, 73, 94, 84, 
  89, 88, 88, 80, 93, 68, 82, 84, 81, 101, 
  101, 88, 84, 88, 92, 91, 84, 89, 76, 94, 
  79, 71, 85, 75, 77, 92, 81, 69, 76, 80, 
  80, 82, 83, 73, 86, 95, 86, 82, 85, 82, 
  84, 79, 87, 81, 63, 84, 85, 87, 88, 79, 
  75, 84, 79, 66, 83, 80, 78, 69, 83, 92, 
  79, 84, 83, 80, 69, 82, 80, 82, 83, 65, 
  87, 82, 84, 84, 86, 85, 87, 92, 80, 86, 
  77, 86, 85, 92, 90, 97, 77, 86, 93, 85, 
  79, 89, 63, 73, 87, 84, 80, 76, 89, 72, 
  96, 79, 84, 79, 76, 68, 96, 87, 78, 86, 
  89, 81, 71, 95, 81, 87, 84, 81, 84, 87, 
  86, 79, 79, 78, 81, 74, 91, 94, 73, 88, 
  77, 84, 96, 83, 81, 66, 82, 104, 72, 88, 
  87, 83, 104, 80, 79, 85, 84, 91, 78, 80, 
  83, 83, 102, 94, 88, 63, 82, 91, 85, 87, 
  93, 74, 83, 90, 95, 101, 92, 88, 90, 82, 
  93, 87, 79, 90, 88, 92, 84, 86, 81, 142, 
  82, 70, 99, 80, 96, 69, 122, 95, 83, 84, 
  95, 77, 66, 82, 89, 90, 89, 88, 82, 89, 
  76, 77, 83, 88, 103, 57, 88, 91, 75, 83, 
  91, 84, 77, 87, 70, 87, 78, 84, 77, 94, 
  39, 75, 91, 86, 93, 89, 88, 68, 76, 82, 
  88, 66, 86, 82, 98, 89, 64, 74, 77, 82, 
  72, 88, 85, 87, 81, 85, 85, 93, 82, 85, 
  87, 73, 75, 78, 89, 93, 72, 86, 68, 93, 
  103, 92, 87, 68, 81, 83, 63, 91, 93, 83, 
  88, 86, 76, 85, 85, 83, 78, 101, 91, 123, 
  66, 92, 87, 82, 81, 84, 81, 82, 82, 74, 
  88, 76, 70, 62, 75, 84, 85, 84, 74, 85, 
  82, 89, 79, 81, 102, 88, 98, 90, 95, 102, 
  67, 89, 76, 81, 113, 84, 80, 93, 86, 72, 
  102, 67, 89, 80, 90, 99, 68, 79, 76, 88, 
  87, 81, 71, 83, 64, 70, 68, 88, 101, 82, 
  89, 84, 75, 72, 69, 91, 78, 100, 78, 89, 
  81, 82, 90, 68, 86, 68, 109, 79, 80, 93, 
  85, 93, 88, 86, 96, 88, 74, 105, 77, 98, 
  92, 82, 87, 76, 92, 86, 88, 75, 87, 76, 
  94, 85, 81, 82, 83, 74, 91, 81, 95, 70, 
  85, 100, 89, 90, 72, 85, 78, 100, 88, 81, 
  83, 78, 89, 91, 79, 89, 81, 101, 39, 90, 
  90, 90, 67, 85, 95, 87, 75, 72, 75, 47, 
  65, 75, 77, 81, 82, 83, 70, 77, 75, 90, 
  84, 75, 101, 94, 125, 65, 69, 95, 53, 97, 
  81, 80, 112, 78, 82, 82, 81, 78, 104, 69, 
  84, 97, 89, 91, 72, 75, 70, 92, 88, 69, 
  89, 96, 64, 60, 74, 85, 85, 74, 85, 71, 
  49, 54, 45, 81, 83, 95, 117, 92, 76, 77, 
  96, 70, 89, 88, 117, 72, 80, 79, 95, 81, 
  98, 75, 87, 96, 61, 83, 72, 115, 79, 69, 
  107, 71, 85, 75, 97, 77, 80, 130, 94, 85, 
  83, 69, 79, 85, 76, 73, 78, 57, 77, 95, 
  82, 88, 72, 74, 73, 83, 65, 73, 77, 76, 
  90, 82, 82, 69, 75, 78, 44, 75, 73, 102, 
  73, 103, 76, 90, 79, 65, 61, 64, 75, 80, 
  91, 97, 90, 91, 83, 74, 71, 94, 81, 89, 
  87, 85, 110, 55, 68, 83, 87, 90, 64, 76, 
  74, 84, 56, 84, 80, 84, 85, 77, 86, 102, 
  76, 70, 88, 83, 85, 80, 84, 73, 109, 67, 
  101, 73, 85, 70, 72, 85, 85, 72, 31, 72, 
  73, 74, 95, 76, 98, 74, 109, 89, 81, 98, 
  75, 89, 74, 86, 82, 88, 95, 84, 94, 73, 
  91, 89, 69, 74, 112, 94, 74, 88, 120, 74, 
  89, 80, 83, 80, 58, 140, 81, 90, 76, 69, 
  75, 81, 70, 81, 78, 69, 84, 78, 72, 95, 
  60, 83, 89, 77, 75, 83, 90, 86, 95, 76, 
  82, 86, 90, 94, 73, 85, 84, 78, 86, 77, 
  71, 74, 87, 82, 78, 87, 93, 75, 87, 90, 
  89, 90, 79, 80, 84, 85, 77, 76, 91, 82, 
  79, 93, 101, 100, 94, 84, 98, 73, 91, 88, 
  88, 77, 83, 74, 92, 80, 83, 75, 93, 75, 
  71, 75, 71, 85, 89, 89, 79, 86, 63, 84, 
  78, 85, 99, 86, 90, 86, 83, 91, 87, 87, 
  77, 84, 78, 78, 77, 95, 84, 71, 80, 94, 
  93, 76, 91, 83, 79, 82, 84, 87, 97, 86, 
  97, 91, 88, 75, 97, 87, 72, 81, 87, 94, 
  84, 80, 74, 64, 82, 80, 75, 99, 92, 89, 
  74, 84, 84, 94, 84, 84, 86, 93, 74, 95, 
  82, 100, 80, 88, 67, 74, 79, 82, 79, 109, 
  84, 114, 79, 95, 98, 75, 86, 68, 93, 78, 
  84, 82, 84, 85, 94, 83, 82, 78, 93, 79, 
  72, 62, 92, 91, 90, 82, 79, 101, 87, 85, 
  103, 98, 80, 90, 90, 68, 95, 94, 84, 78, 
  94, 82, 102, 67, 73, 75, 105, 89, 67, 83, 
  76, 87, 85, 82, 77, 72, 45, 81, 73, 99, 
  91, 63, 83, 78, 79, 70, 75, 85, 72, 83, 
  64, 99, 65, 88, 88, 65, 95, 82, 96, 75, 
  86, 92, 86, 88, 89, 97, 86, 86, 81, 87, 
  78, 79, 97, 95, 63, 81, 90, 93, 103, 68, 
  76, 68, 89, 80, 78, 78, 94, 96, 84, 79, 
  90, 87, 74, 90, 94, 89, 75, 91, 84, 88, 
  85, 81, 82, 76, 78, 83, 87, 87, 77, 106, 
  62, 88, 72, 122, 71, 76, 88, 94, 74, 64, 
  65, 70, 70, 71, 87, 76, 85, 99, 78, 75, 
  103, 95, 84, 83, 86, 88, 101, 84, 78, 96, 
  69, 83, 67, 101, 101, 78, 84, 75, 85, 91, 
  90, 69, 77, 96, 88, 136, 87, 76, 74, 67, 
  85, 66, 100, 64, 75, 64, 73, 79, 85, 78, 
  91, 67, 49, 64, 59, 84, 91, 79, 98, 101, 
  81, 83, 89, 82, 79, 81, 89, 78, 79, 87, 
  101, 95, 94, 88, 96, 100, 71, 72, 86, 79, 
  77, 77, 92, 63, 86, 78, 92, 69, 72, 136, 
  92, 89, 74, 72, 79, 82, 77, 63, 72, 83, 
  69, 95, 76, 97, 84, 84, 80, 68, 73, 70, 
  84, 71, 87, 72, 85, 81, 86, 91, 85, 85, 
  80, 81, 77, 82, 74, 91, 81, 100, 83, 85, 
  82, 78, 94, 77, 78, 95, 78, 82, 92, 80, 
  76, 74, 101, 76, 79, 94, 89, 86, 93, 78, 
  85, 80, 81, 79, 98, 77, 79, 85, 90, 93, 
  83, 77, 87, 74, 85, 81, 78, 94, 94, 89, 
  85, 88, 83, 82, 94, 88, 85, 93, 86, 89, 
  79, 96, 90, 93, 84, 87, 80, 77, 76, 90, 
  92, 72, 79, 77, 76, 73, 97, 89, 94, 93, 
  79, 83, 87, 87, 90, 86, 95, 70, 93, 77, 
  72, 82, 81, 80, 88, 85, 73, 84, 77, 84, 
  88, 94, 92, 79, 91, 80, 80, 88, 80, 85, 
  83, 84, 85, 87, 89, 92, 73, 94, 69, 74, 
  97, 82, 87, 84, 85, 94, 98, 89, 91, 83, 
  82, 74, 82, 85, 75, 95, 96, 94, 83, 76, 
  88, 73, 77, 82, 81, 83, 95, 85, 70, 74, 
  88, 91, 81, 82, 86, 83, 92, 84, 85, 78, 
  84, 85, 88, 83, 86, 85, 91, 72, 75, 71, 
  86, 78, 91, 84, 80, 93, 89, 82, 81, 76, 
  70, 84, 83, 82, 83, 86, 81, 77, 86, 89, 
  92, 81, 78, 93, 87, 90, 73, 81, 83, 68, 
  84, 89, 74, 81, 89, 82, 91, 96, 80, 93, 
  85, 90, 77, 93, 91, 76, 94, 85, 71, 82, 
  84, 79, 90, 90, 74, 70, 80, 83, 82, 87, 
  85, 85, 95, 73, 85, 89, 79, 82, 94, 84, 
  90, 85, 88, 88, 80, 89, 79, 77, 94, 86, 
  85, 79, 76, 105, 87, 88, 88, 94, 80, 79, 
  90, 89, 80, 82, 76, 91, 62, 69, 80, 76, 
  84, 83, 96, 89, 108, 93, 77, 82, 79, 89, 
  86, 86, 82, 84, 76, 78, 69, 90, 88, 90, 
  83, 85, 101, 84, 98, 72, 82, 88, 87, 116, 
  90, 78, 87, 72, 81, 72, 88, 70, 76, 77, 
  77, 77, 84, 76, 94, 70, 66, 84, 87, 82, 
  94, 78, 83, 98, 77, 80, 87, 76, 86, 94, 
  72, 83, 86, 85, 93, 95, 85, 92, 91, 97, 
  79, 90, 88, 77, 85, 81, 84, 75, 84, 78, 
  99, 84, 75, 77, 86, 87, 73, 77, 80, 85, 
  93, 66, 77, 86, 78, 83, 82, 88, 104, 84, 
  85, 78, 81, 76, 86, 78, 91, 83, 86, 80, 
  104, 107, 89, 83, 44, 92, 83, 84, 83, 83, 
  84, 98, 86, 96, 86, 78, 86, 106, 90, 95, 
  81, 77, 89, 85, 82, 89, 93, 87, 90, 85, 
  82, 89, 83, 76, 73, 78, 90, 87, 68, 75, 
  81, 68, 83, 76, 93, 82, 77, 73, 68, 80, 
  85, 88, 96, 90, 94, 76, 84, 88, 80, 77, 
  89, 63, 112, 88, 90, 85, 84, 88, 81, 76, 
  74, 84, 81, 84, 81, 88, 64, 72, 89, 76, 
  89, 115, 80, 85, 82, 89, 78, 83, 100, 94, 
  73, 90, 84, 83, 84, 83, 89, 95, 81, 88, 
  74, 86, 86, 76, 82, 75, 81, 67, 88, 92, 
  81, 75, 76, 80, 90, 80, 80, 83, 62, 81, 
  80, 81, 83, 76, 81, 82, 88, 78, 99, 102, 
  63, 79, 65, 88, 80, 84, 81, 85, 86, 95, 
  92, 53, 85, 82, 86, 93, 89, 88, 84, 70, 
  76, 97, 88, 81, 92, 86, 88, 83, 82, 89, 
  85, 80, 82, 83, 86, 79, 114, 76, 77, 76, 
  72, 80, 93, 84, 87, 65, 74, 76, 78, 89, 
  88, 87, 92, 83, 79, 78, 87, 85, 82, 71, 
  106, 71, 61, 86, 78, 84, 83, 80, 81, 80, 
  76, 79, 81, 84, 75, 80, 92, 78, 76, 104, 
  76, 86, 81, 78, 75, 93, 85, 91, 71, 87, 
  85, 90, 81, 87, 85, 89, 71, 90, 71, 102, 
  85, 81, 83, 75, 82, 75, 89, 87, 80, 75, 
  78, 76, 76, 87, 69, 87, 73, 84, 82, 87, 
  77, 76, 82, 85, 89, 101, 81, 94, 86, 78, 
  138, 93, 71, 87, 76, 85, 92, 76, 80, 82, 
  70, 91, 82, 73, 86, 70, 76, 87, 82, 101, 
  79, 76, 70, 84, 77, 93, 93, 86, 79, 91, 
  101, 104, 86, 78, 92, 92, 78, 83, 78, 79, 
  100, 88, 100, 90, 98, 76, 78, 89, 72, 92, 
  87, 67, 80, 82, 91, 83, 86, 97, 88, 70, 
  61, 94, 67, 74, 100, 72, 68, 74, 79, 80, 
  95, 82, 87, 98, 92, 83, 76, 83, 83, 95, 
  91, 80, 73, 120, 72, 85, 66, 88, 93, 90, 
  88, 87, 90, 67, 72, 88, 75, 94, 78, 82, 
  81, 65, 77, 86, 86, 76, 95, 86, 77, 80, 
  69, 85, 91, 92, 87, 79, 87, 93, 67, 84, 
  83, 89, 80, 110, 92, 90, 87, 88, 40, 94, 
  98, 76, 85, 81, 83, 81, 78, 66, 98, 85, 
  99, 111, 75, 86, 75, 75, 84, 92, 82, 88, 
  93, 81, 97, 85, 91, 88, 99, 72, 79, 81, 
  86, 88, 63, 71, 76, 78, 77, 77, 86, 85, 
  82, 78, 65, 79, 77, 79, 96, 87, 95, 68, 
  79, 77, 82, 108, 86, 72, 79, 88, 85, 86, 
  77, 115, 84, 84, 86, 85, 75, 88, 85, 95, 
  81, 89, 80, 76, 93, 68, 83, 74, 84, 86, 
  84, 75, 71, 89, 94, 90, 85, 89, 81, 78, 
  82, 102, 90, 86, 69, 108, 86, 77, 93, 85, 
  97, 76, 77, 93, 84, 87, 73, 87, 77, 88, 
  87, 89, 78, 81, 83, 84, 77, 82, 76, 81, 
  86, 79, 87, 86, 68, 83, 76, 83, 84, 76, 
  85, 85, 85, 89, 83, 61, 87, 87, 95, 91, 
  74, 84, 79, 75, 73, 98, 77, 79, 92, 81, 
  93, 83, 82, 91, 89, 78, 62, 86, 75, 86, 
  93, 70, 73, 86, 68, 81, 87, 82, 88, 78, 
  78, 79, 78, 80, 98, 85, 88, 74, 84, 73, 
  83, 105, 87, 77, 75, 70, 61, 81, 76, 95, 
  85, 78, 73, 84, 71, 86, 86, 88, 86, 77, 
  73, 83, 82, 71, 82, 86, 84, 76, 80, 83, 
  72, 89, 85, 83, 80, 100, 76, 81, 81, 93, 
  79, 91, 72, 113, 84, 81, 93, 77, 96, 84, 
  84, 92, 81, 85, 76, 85, 79, 79, 71, 86, 
  78, 80, 82, 82, 83, 82, 79, 80, 84, 91, 
  71, 86, 81, 75, 156, 89, 66, 84, 80, 79, 
  94, 79, 82, 91, 67, 90, 84, 69, 70, 74, 
  74, 99, 83, 93, 80, 67, 70, 77, 89, 80, 
  85, 87, 79, 99, 83, 111, 83, 85, 97, 111, 
  81, 89, 85, 85, 101, 80, 103, 81, 110, 79, 
  81, 91, 74, 94, 76, 81, 85, 79, 85, 84, 
  81, 90, 81, 65, 58, 85, 69, 66, 97, 67, 
  76, 76, 73, 84, 99, 81, 91, 95, 79, 87, 
  82, 74, 88, 96, 91, 85, 74, 106, 77, 75, 
  70, 78, 82, 85, 81, 84, 84, 62, 76, 89, 
  78, 79, 78, 83, 80, 66, 80, 91, 79, 80, 
  85, 97, 81, 88, 72, 75, 93, 83, 78, 74, 
  83, 83, 69, 87, 91, 86, 74, 95, 79, 91, 
  86, 92, 54, 82, 98, 85, 86, 84, 77, 86, 
  72, 61, 100, 100, 96, 95, 71, 77, 82, 74, 
  80, 81, 76, 92, 89, 78, 87, 89, 84, 88, 
  101, 84, 81, 88, 98, 85, 76, 79, 84, 79, 
  77, 89, 79, 89, 71, 79, 67, 78, 69, 87, 
  84, 90, 89, 77, 83, 89, 86, 93, 73, 73, 
  86, 87, 93, 83, 68, 106, 77, 88, 101, 81, 
  88, 86, 86, 100, 89, 74, 88, 70, 88, 87, 
  86, 73, 80, 81, 89, 73, 87, 83, 86, 83, 
  91, 90, 86, 86, 86, 88, 90, 84, 84, 102, 
  90, 78, 98, 90, 91, 84, 70, 76, 87, 87, 
  83, 89, 94, 74, 72, 99, 95, 91, 82, 83, 
  75, 88, 77, 92, 78, 67, 74, 90, 86, 86, 
  88, 79, 86, 76, 80, 80, 83, 87, 75, 97, 
  84, 93, 88, 78, 68, 87, 84, 85, 73, 85, 
  69, 81, 83, 76, 84, 104, 79, 88, 91, 83, 
  65, 89, 95, 82, 79, 81, 89, 83, 66, 93, 
  84, 85, 72, 68, 87, 79, 78, 94, 83, 88, 
  80, 71, 83, 83, 83, 97, 78, 79, 85, 68, 
  72, 79, 82, 85, 80, 87, 82, 81, 77, 92, 
  88, 81, 86, 72, 74, 83, 81, 87, 83, 81, 
  84, 89, 81, 82, 85, 79, 72, 77, 81, 92, 
  76, 88, 81, 78, 86, 88, 84, 90, 83, 80, 
  92, 84, 84, 89, 81, 78, 90, 87, 84, 88, 
  93, 74, 72, 84, 80, 89, 83, 84, 79, 85, 
  82, 90, 79, 80, 69, 94, 89, 81, 143, 91, 
  66, 82, 81, 79, 89, 73, 76, 105, 60, 86, 
  75, 64, 72, 74, 74, 105, 90, 89, 78, 72, 
  73, 76, 77, 84, 80, 87, 80, 92, 85, 105, 
  96, 81, 91, 108, 91, 85, 83, 88, 98, 84, 
  86, 79, 111, 87, 79, 88, 68, 93, 79, 77, 
  81, 75, 88, 83, 82, 85, 85, 71, 67, 74, 
  78, 63, 88, 87, 93, 74, 74, 92, 95, 77, 
  86, 99, 73, 91, 80, 75, 90, 91, 85, 100, 
  77, 105, 80, 68, 68, 83, 87, 81, 83, 81, 
  90, 64, 83, 89, 89, 75, 80, 81, 88, 74, 
  75, 85, 83, 73, 91, 104, 89, 91, 70, 79, 
  91, 81, 83, 87, 91, 81, 71, 86, 93, 94, 
  77, 95, 80, 85, 75, 77, 79, 74, 81, 78, 
  71, 85, 76, 79, 81, 83, 73, 78, 79, 81, 
  76, 86, 91, 74, 67, 82, 77, 86, 84, 88, 
  84, 82, 84, 76, 83, 81, 80, 71, 86, 78, 
  78, 81, 78, 71, 81, 83, 84, 82, 64, 69, 
  87, 80, 88, 94, 76, 82, 79, 89, 76, 76, 
  88, 82, 72, 74, 93, 67, 88, 76, 86, 81, 
  81, 88, 69, 80, 91, 85, 74, 85, 75, 83, 
  85, 93, 78, 84, 76, 87, 73, 79, 81, 70, 
  89, 82, 88, 90, 83, 84, 80, 85, 80, 81, 
  81, 88, 87, 72, 78, 81, 77, 85, 78, 78, 
  85, 76, 80, 72, 77, 83, 85, 86, 78, 82, 
  75, 91, 86, 85, 96, 77, 92, 77, 80, 83, 
  80, 90, 89, 78, 81, 67, 81, 73, 73, 89, 
  75, 82, 91, 85, 76, 78, 77, 77, 75, 79, 
  84, 70, 70, 86, 87, 86, 83, 85, 103, 80, 
  92, 81, 80, 75, 78, 70, 87, 76, 84, 78, 
  79, 63, 83, 86, 77, 82, 70, 69, 84, 84, 
  82, 106, 85, 81, 85, 93, 75, 78, 87, 79, 
  80, 75, 89, 75, 80, 76, 80, 77, 77, 88, 
  81, 70, 79, 84, 77, 78, 71, 77, 89, 81, 
  79, 79, 81, 78, 74, 78, 74, 81, 91, 83, 
  85, 89, 87, 83, 80, 74, 81, 82, 80, 88, 
  86, 81, 72, 78, 75, 82, 73, 81, 86, 75, 
  76, 72, 76, 74, 82, 79, 69, 78, 79, 83, 
  81, 84, 99, 74, 93, 72, 80, 79, 80, 88, 
  80, 77, 76, 71, 85, 87, 71, 86, 76, 83, 
  75, 80, 76, 79, 77, 80, 77, 86, 84, 71, 
  74, 81, 86, 88, 88, 86, 79, 84, 86, 83, 
  81, 76, 75, 88, 93, 82, 75, 80, 81, 71, 
  83, 81, 83, 83, 72, 83, 88, 77, 89, 84, 
  74, 84, 83, 83, 78, 77, 84, 81, 77, 75, 
  90, 65, 88, 76, 83, 83, 80, 86, 76, 79, 
  93, 82, 79, 84, 77, 75, 89, 90, 82, 85, 
  73, 75, 77, 77, 86, 67, 87, 82, 88, 88, 
  83, 85, 82, 86, 83, 80, 74, 85, 83, 90, 
  79, 83, 81, 82, 80, 77, 82, 74, 79, 75, 
  80, 81, 83, 81, 73, 81, 77, 87, 85, 87, 
  90, 76, 85, 75, 84, 82, 99, 101, 105, 90, 
  92, 109, 55, 68, 80, 89, 84, 88, 124, 93, 
  74, 81, 87, 79, 87, 95, 90, 107, 103, 86, 
  85, 67, 77, 96, 172, 84, 87, 101, 90, 98, 
  96, 93, 74, 92, 88, 90, 84, 73, 91, 86, 
  88, 106, 72, 91, 70, 94, 77, 103, 71, 79, 
  73, 78, 67, 57, 95, 90, 84, 89, 79, 42, 
  78, 68, 81, 92, 77, 71, 99, 73, 91, 84, 
  84, 81, 77, 105, 66, 84, 72, 90, 86, 119, 
  66, 89, 95, 102, 59, 83, 90, 76, 84, 85, 
  96, 88, 81, 77, 88, 81, 108, 84, 85, 76, 
  91, 75, 105, 80, 91, 77, 76, 77, 74, 105, 
  65, 96, 96, 89, 77, 71, 79, 85, 94, 70, 
  92, 83, 91, 87, 100, 95, 100, 88, 92, 105, 
  59, 59, 77, 91, 80, 90, 139, 91, 79, 70, 
  79, 73, 77, 89, 88, 100, 109, 86, 92, 72, 
  76, 89, 173, 84, 96, 93, 80, 93, 94, 93, 
  79, 82, 92, 85, 86, 70, 90, 89, 81, 99, 
  71, 97, 68, 94, 74, 119, 80, 72, 74, 90, 
  70, 55, 92, 93, 85, 88, 75, 55, 77, 71, 
  74, 92, 72, 71, 110, 66, 75, 79, 85, 76, 
  74, 106, 73, 75, 68, 83, 87, 96, 71, 86, 
  94, 108, 63, 79, 74, 81, 92, 90, 92, 77, 
  79, 77, 87, 81, 106, 91, 81, 72, 88, 75, 
  91, 81, 84, 72, 74, 78, 66, 97, 66, 85, 
  99, 85, 83, 71, 86, 81, 89, 66, 93, 81, 
  86, 83, 98, 92, 86, 90, 84, 94, 68, 81, 
  80, 92, 86, 86, 111, 81, 78, 80, 81, 80, 
  89, 87, 89, 99, 101, 85, 92, 75, 76, 96, 
  139, 87, 87, 94, 91, 89, 79, 105, 75, 91, 
  84, 88, 80, 75, 85, 82, 85, 103, 77, 102, 
  75, 95, 76, 100, 70, 80, 80, 76, 68, 64, 
  89, 91, 85, 84, 80, 46, 80, 76, 81, 92, 
  81, 64, 97, 74, 92, 79, 89, 85, 78, 95, 
  70, 83, 81, 93, 80, 77, 72, 83, 100, 87, 
  63, 79, 85, 81, 83, 90, 96, 88, 85, 76, 
  84, 79, 96, 93, 85, 77, 93, 75, 100, 75, 
  86, 77, 74, 78, 76, 97, 62, 89, 105, 89, 
  81, 71, 95, 83, 94, 71, 89, 82, 92, 86, 
  83, 79, 84, 87, 74, 82, 80, 81, 78, 80, 
  82, 77, 91, 91, 77, 86, 87, 79, 85, 81, 
  83, 82, 75, 81, 76, 83, 82, 87, 121, 72, 
  90, 88, 79, 89, 85, 69, 75, 79, 74, 98, 
  89, 77, 79, 76, 75, 77, 77, 68, 78, 80, 
  89, 100, 80, 81, 85, 81, 76, 80, 81, 79, 
  80, 72, 84, 70, 80, 77, 85, 71, 82, 86, 
  76, 72, 88, 85, 76, 81, 77, 85, 78, 84, 
  78, 89, 82, 89, 80, 83, 77, 87, 91, 84, 
  85, 94, 81, 82, 87, 74, 84, 81, 82, 91, 
  94, 78, 82, 77, 77, 87, 69, 87, 82, 79, 
  82, 75, 78, 82, 91, 83, 80, 75, 81, 75, 
  80, 81, 88, 81, 75, 87, 83, 81, 86, 85, 
  87, 88, 75, 68, 78, 75, 82, 82, 81, 78, 
  95, 84, 81, 81, 83, 74, 77, 80, 80, 72, 
  84, 84, 78, 85, 81, 83, 132, 78, 92, 91, 
  80, 78, 85, 64, 75, 72, 81, 87, 93, 69, 
  84, 76, 77, 80, 72, 70, 74, 81, 92, 108, 
  86, 79, 91, 93, 79, 79, 79, 78, 80, 74, 
  77, 77, 72, 73, 80, 72, 76, 82, 81, 61, 
  82, 82, 78, 81, 75, 79, 82, 77, 75, 85, 
  84, 81, 83, 83, 71, 91, 86, 85, 84, 94, 
  87, 87, 84, 65, 85, 83, 81, 92, 92, 84, 
  76, 73, 72, 87, 62, 86, 83, 76, 85, 74, 
  74, 72, 84, 78, 71, 75, 85, 73, 79, 78, 
  90, 80, 77, 89, 80, 76, 82, 86, 85, 92, 
  74, 68, 84, 88, 81, 84, 81, 77, 83, 74, 
  78, 85, 84, 78, 83, 85, 80, 75, 90, 81, 
  80, 84, 83, 89, 113, 81, 87, 89, 82, 80, 
  72, 80, 82, 80, 80, 96, 87, 74, 80, 78, 
  76, 81, 80, 84, 78, 80, 89, 93, 78, 82, 
  86, 87, 78, 81, 78, 78, 79, 70, 80, 65, 
  88, 75, 82, 72, 78, 83, 77, 70, 93, 84, 
  84, 80, 79, 78, 80, 81, 83, 91, 83, 79, 
  81, 81, 78, 77, 87, 79, 82, 94, 80, 81, 
  86, 74, 82, 79, 82, 88, 91, 87, 81, 79, 
  75, 85, 74, 86, 78, 75, 81, 76, 78, 78, 
  85, 77, 78, 75, 81, 75, 83, 80, 81, 82, 
  75, 91, 83, 75, 78, 86, 85, 96, 76, 76, 
  75, 76, 96, 82, 67, 80, 84, 73, 87, 73, 
  81, 81, 61, 85, 98, 85, 87, 88, 86, 106, 
  89, 70, 104, 91, 78, 79, 98, 80, 75, 97, 
  88, 79, 85, 87, 108, 81, 99, 90, 71, 98, 
  100, 96, 82, 101, 93, 89, 82, 88, 72, 86, 
  91, 74, 83, 80, 80, 83, 86, 73, 88, 68, 
  85, 91, 87, 92, 84, 81, 83, 79, 90, 75, 
  79, 88, 85, 87, 80, 78, 75, 70, 85, 86, 
  90, 81, 87, 87, 102, 79, 66, 68, 85, 80, 
  82, 84, 83, 77, 82, 82, 67, 61, 83, 73, 
  93, 88, 92, 72, 99, 80, 84, 83, 78, 96, 
  77, 68, 78, 109, 105, 86, 92, 63, 96, 77, 
  77, 91, 82, 89, 85, 97, 86, 74, 71, 72, 
  111, 72, 53, 80, 89, 79, 88, 67, 76, 79, 
  38, 83, 107, 93, 68, 90, 79, 105, 102, 64, 
  102, 84, 71, 83, 106, 83, 83, 80, 89, 74, 
  81, 84, 102, 77, 105, 85, 70, 109, 110, 76, 
  75, 109, 87, 94, 95, 83, 74, 89, 90, 78, 
  79, 77, 79, 92, 90, 74, 82, 68, 86, 81, 
  89, 91, 91, 70, 82, 84, 82, 61, 80, 76, 
  93, 88, 85, 74, 85, 85, 77, 87, 89, 71, 
  87, 98, 96, 76, 53, 57, 78, 70, 52, 84, 
  86, 74, 85, 82, 62, 57, 82, 77, 95, 93, 
  98, 82, 100, 85, 71, 82, 84, 95, 77, 62, 
  83, 116, 102, 88, 89, 61, 104, 85, 65, 101, 
  80, 79, 84, 90, 77, 89, 78, 77, 89, 83, 
  73, 78, 80, 83, 87, 74, 79, 81, 68, 86, 
  95, 84, 72, 86, 83, 102, 90, 68, 96, 80, 
  76, 79, 90, 94, 80, 80, 83, 79, 78, 88, 
  98, 81, 93, 85, 79, 89, 88, 86, 84, 95, 
  89, 84, 80, 87, 75, 79, 91, 74, 80, 83, 
  79, 84, 84, 71, 90, 71, 89, 89, 84, 86, 
  91, 83, 76, 81, 83, 76, 78, 91, 89, 87, 
  74, 80, 83, 101, 87, 80, 87, 82, 87, 94, 
  101, 80, 71, 68, 85, 80, 87, 85, 87, 80, 
  83, 90, 71, 62, 85, 71, 95, 89, 96, 70, 
  93, 90, 85, 88, 78, 89, 81, 73, 79, 105, 
  79, 85, 87, 65, 94, 82, 82, 88, 78, 83, 
  79, 87, 83, 90, 73, 77, 119, 76, 67, 85, 
  85, 81, 86, 73, 92, 86, 47, 83, 104, 89, 
  87, 87, 79, 97, 85, 66, 100, 87, 72, 74, 
  107, 72, 76, 104, 87, 72, 85, 86, 88, 83, 
  104, 88, 78, 103, 103, 111, 83, 106, 87, 85, 
  84, 88, 73, 87, 95, 74, 82, 79, 77, 89, 
  80, 70, 83, 74, 84, 93, 92, 74, 86, 80, 
  84, 81, 82, 75, 88, 99, 75, 88, 87, 73, 
  76, 66, 84, 90, 88, 81, 84, 78, 97, 90, 
  58, 62, 88, 77, 72, 84, 83, 82, 88, 95, 
  69, 62, 80, 88, 87, 82, 84, 73, 90, 79, 
  83, 82, 80, 92, 80, 71, 82, 103, 102, 83, 
  89, 61, 95, 82, 67, 99, 80, 90, 83, 88, 
  89, 78, 68, 83, 148, 63, 56, 86, 92, 77, 
  84, 73, 94, 90, 22, 77, 111, 93, 72, 87, 
  72, 96, 98, 59, 110, 80, 64, 75, 122, 70, 
  81, 84, 82, 72, 83, 85, 78, 74, 110, 81, 
  81, 119, 118, 82, 74, 119, 84, 82, 106, 86, 
  75, 87, 97, 77, 77, 71, 69, 97, 81, 72, 
  64, 73, 95, 79, 96, 72, 80, 64, 92, 87, 
  70, 61, 89, 87, 81, 91, 97, 71, 93, 92, 
  75, 88, 87, 63, 86, 87, 96, 85, 41, 48, 
  75, 66, 41, 79, 88, 76, 82, 85, 61, 57, 
  76, 94, 92, 86, 82, 83, 90, 80, 68, 83, 
  87, 93, 84, 66, 88, 105, 93, 84, 89, 59, 
  98, 83, 52, 110, 85, 81, 86, 82, 85, 88, 
  74, 78, 104, 79, 73, 82, 78, 81, 85, 74, 
  89, 87, 57, 88, 94, 88, 84, 85, 81, 98, 
  83, 68, 92, 79, 77, 76, 97, 90, 83, 85, 
  88, 76, 82, 84, 85, 81, 95, 84, 86, 89, 
  90, 87, 85, 96, 82, 84, 83, 85, 73, 79, 
  90, 75, 84, 84, 80, 88, 80, 69, 86, 78, 
  100, 89, 84, 79, 87, 87, 75, 87, 77, 71, 
  84, 100, 78, 86, 82, 77, 83, 115, 86, 86, 
  84, 84, 83, 86, 94, 80, 67, 68, 83, 80, 
  80, 86, 82, 80, 87, 80, 73, 65, 84, 81, 
  91, 83, 86, 69, 87, 86, 84, 89, 85, 89, 
  88, 77, 79, 100, 70, 86, 85, 66, 89, 83, 
  74, 90, 81, 83, 74, 89, 80, 80, 85, 75, 
  99, 86, 74, 76, 81, 95, 79, 80, 97, 83, 
  69, 82, 91, 78, 78, 77, 83, 93, 80, 72, 
  91, 84, 83, 76, 89, 73, 70, 90, 89, 74, 
  84, 87, 91, 79, 95, 82, 85, 86, 89, 100, 
  93, 97, 85, 90, 71, 78, 71, 89, 87, 83, 
  86, 83, 81, 83, 88, 76, 85, 75, 89, 102, 
  90, 81, 86, 88, 84, 90, 76, 76, 87, 89, 
  85, 85, 73, 92, 72, 67, 95, 88, 86, 89, 
  86, 76, 83, 103, 77, 78, 92, 85, 96, 89, 
  76, 82, 84, 85, 78, 68, 80, 84, 82, 72, 
  78, 61, 88, 82, 95, 86, 87, 83, 80, 82, 
  77, 97, 82, 81, 92, 69, 91, 79, 78, 79, 
  87, 87, 83, 86, 85, 75, 78, 75, 107, 80, 
  67, 80, 86, 89, 74, 77, 96, 83, 52, 87, 
  91, 87, 76, 75, 78, 91, 86, 65, 95, 83, 
  74, 79, 95, 73, 73, 88, 88, 76, 89, 82, 
  84, 70, 92, 78, 83, 80, 93, 83, 89, 106, 
  81, 90, 80, 76, 73, 91, 91, 81, 87, 81, 
  75, 90, 87, 80, 78, 73, 101, 103, 92, 96, 
  74, 82, 90, 88, 69, 69, 83, 89, 87, 82, 
  75, 93, 74, 87, 94, 84, 87, 82, 86, 74, 
  80, 99, 67, 70, 87, 76, 80, 83, 76, 83, 
  86, 92, 75, 63, 82, 95, 78, 80, 81, 62, 
  85, 84, 85, 90, 97, 88, 81, 76, 79, 94, 
  75, 82, 89, 66, 94, 78, 73, 86, 87, 83, 
  90, 84, 80, 77, 87, 78, 93, 89, 75, 75, 
  79, 84, 79, 83, 92, 84, 72, 84, 86, 79, 
  82, 79, 91, 92, 78, 73, 84, 81, 86, 82, 
  88, 80, 79, 86, 93, 77, 86, 87, 87, 78, 
  89, 77, 83, 81, 87, 82, 93, 95, 82, 89, 
  75, 78, 75, 83, 85, 80, 87, 85, 81, 82, 
  84, 77, 86, 76, 97, 96, 85, 86, 80, 94, 
  80, 94, 73, 76, 85, 101, 86, 83, 70, 91, 
  77, 92, 92, 86, 84, 87, 86, 81, 85, 83, 
  82, 77, 83, 84, 97, 88, 72, 86, 84, 83, 
  80, 70, 89, 78, 85, 69, 81, 60, 89, 85, 
  93, 91, 86, 84, 81, 85, 79, 96, 71, 80, 
  86, 70, 87, 77, 82, 76, 78, 86, 89, 93, 
  77, 75, 85, 89, 75, 71, 90, 76, 103, 70, 
  76, 82, 86, 78, 86, 82, 92, 92, 90, 79, 
  83, 74, 98, 71, 101, 85, 90, 93, 72, 87, 
  79, 89, 83, 91, 85, 80, 81, 72, 89, 74, 
  72, 67, 94, 95, 83, 71, 85, 92, 66, 96, 
  79, 90, 73, 90, 79, 86, 87, 93, 87, 79, 
  84, 76, 91, 91, 82, 87, 84, 93, 92, 79, 
  77, 70, 77, 78, 84, 80, 80, 84, 67, 88, 
  67, 79, 79, 82, 83, 89, 76, 81, 65, 97, 
  80, 77, 85, 72, 90, 71, 74, 88, 96, 85, 
  89, 88, 85, 91, 91, 80, 93, 88, 156, 81, 
  100, 81, 90, 69, 81, 100, 94, 90, 87, 108, 
  92, 84, 90, 78, 80, 88, 86, 93, 80, 74, 
  85, 79, 77, 56, 85, 80, 114, 79, 81, 81, 
  91, 81, 82, 78, 98, 88, 81, 78, 87, 69, 
  95, 63, 102, 87, 96, 101, 73, 87, 82, 81, 
  88, 89, 78, 86, 84, 73, 95, 77, 71, 63, 
  95, 80, 80, 67, 83, 93, 67, 99, 74, 90, 
  75, 92, 82, 86, 83, 85, 83, 78, 72, 70, 
  87, 81, 78, 81, 85, 94, 86, 80, 79, 64, 
  74, 83, 88, 79, 85, 79, 69, 81, 64, 77, 
  79, 75, 83, 97, 72, 82, 68, 89, 78, 81, 
  86, 69, 96, 71, 64, 82, 84, 84, 91, 86, 
  79, 90, 91, 84, 96, 88, 156, 82, 100, 79, 
  79, 69, 78, 103, 87, 97, 84, 111, 89, 80, 
  92, 69, 77, 90, 86, 92, 78, 82, 87, 88, 
  75, 73, 91, 80, 103, 84, 76, 82, 84, 78, 
  82, 77, 87, 89, 83, 80, 84, 75, 95, 72, 
  95, 78, 90, 95, 72, 87, 80, 96, 85, 92, 
  68, 80, 84, 77, 93, 76, 78, 74, 93, 78, 
  80, 72, 81, 93, 66, 94, 80, 92, 72, 88, 
  80, 86, 93, 96, 86, 80, 79, 77, 92, 87, 
  79, 81, 94, 93, 93, 79, 81, 75, 75, 96, 
  88, 83, 83, 87, 71, 91, 71, 73, 81, 78, 
  87, 93, 78, 87, 65, 95, 88, 82, 86, 78, 
  82, 73, 71, 88, 95, 85, 88, 89, 77, 95, 
  92, 79, 92, 91, 145, 86, 96, 76, 88, 70, 
  81, 97, 82, 85, 86, 104, 89, 84, 91, 79, 
  80, 81, 92, 86, 80, 83, 80, 90, 71, 58, 
  92, 76, 102, 76, 85, 80, 92, 78, 88, 79, 
  96, 87, 81, 76, 85, 81, 86, 71, 95, 84, 
  93, 92, 76, 93, 83, 82, 78, 86, 73, 84, 
  82, 77, 87, 72, 78, 65, 99, 97, 81, 64, 
  88, 84, 71, 96, 79, 92, 77, 93, 79, 90, 
  79, 83, 81, 79, 79, 75, 94, 81, 91, 78, 
  87, 86, 86, 83, 78, 73, 78, 74, 78, 94, 
  77, 89, 68, 78, 64, 77, 81, 79, 77, 86, 
  79, 79, 75, 92, 74, 80, 77, 73, 91, 74, 
  65, 92, 71, 87, 84, 93, 89, 83, 77, 89, 
  90, 82, 153, 76, 89, 78, 79, 78, 87, 89, 
  94, 94, 88, 107, 91, 81, 88, 76, 85, 85, 
  83, 66, 86, 78, 75, 79, 70, 40, 90, 77, 
  96, 73, 87, 72, 99, 83, 87, 79, 96, 85, 
  79, 73, 84, 78, 78, 64, 96, 85, 91, 98, 
  76, 89, 83, 74, 85, 87, 73, 83, 86, 78, 
  95, 75, 80, 60, 91, 75, 82, 55, 86, 81, 
  72, 103, 79, 89, 84, 90, 84, 89, 73, 82, 
  82, 79, 73, 74, 93, 79, 85, 80, 82, 89, 
  83, 85, 76, 67, 75, 80, 81, 98, 79, 87, 
  68, 77, 63, 80, 76, 77, 77, 90, 75, 77, 
  78, 82, 69, 88, 77, 69, 95, 77, 61, 85, 
  53, 86, 85, 92, 79, 82, 72, 94, 89, 89, 
  141, 74, 94, 77, 74, 79, 86, 89, 84, 99, 
  77, 99, 84, 76, 99, 69, 78, 93, 89, 89, 
  81, 83, 84, 83, 71, 62, 94, 79, 93, 75, 
  84, 83, 87, 75, 85, 78, 85, 83, 84, 79, 
  84, 78, 85, 72, 88, 79, 87, 94, 78, 90, 
  79, 87, 79, 87, 75, 82, 84, 81, 96, 75, 
  82, 70, 94, 75, 79, 66, 82, 83, 69, 91, 
  79, 87, 76, 91, 82, 88, 78, 85, 83, 76, 
  76, 74, 93, 80, 92, 78, 86, 85, 84, 81, 
  79, 77, 76, 98, 82, 91, 81, 92, 76, 88, 
  67, 76, 75, 78, 81, 91, 82, 78, 71, 94, 
  77, 84, 78, 79, 88, 78, 66, 84, 69, 86, 
  84, 91, 82, 87, 81, 88, 88, 85, 135, 85, 
  89, 78, 90, 77, 86, 89, 86, 89, 86, 104, 
  86, 80, 91, 79, 81, 83, 91, 120, 85, 83, 
  74, 100, 75, 75, 88, 83, 100, 86, 77, 82, 
  85, 73, 83, 85, 91, 87, 84, 84, 84, 81, 
  91, 80, 91, 81, 85, 85, 74, 106, 78, 86, 
  80, 87, 71, 88, 87, 80, 86, 72, 79, 81, 
  95, 100, 76, 75, 82, 87, 75, 90, 78, 92, 
  72, 90, 84, 86, 77, 76, 86, 78, 87, 79, 
  93, 86, 92, 90, 93, 87, 89, 83, 78, 76, 
  83, 76, 84, 89, 82, 82, 65, 84, 70, 93, 
  82, 82, 85, 93, 78, 90, 76, 94, 98, 77, 
  72, 76, 82, 70, 71, 93, 82, 86, 86, 88, 
  86, 81, 79, 87, 81, 77, 155, 85, 89, 82, 
  77, 80, 84, 88, 88, 88, 85, 119, 93, 93, 
  88, 81, 87, 88, 89, 104, 90, 77, 72, 93, 
  78, 62, 94, 83, 100, 77, 81, 80, 95, 75, 
  89, 84, 91, 83, 82, 82, 82, 79, 85, 80, 
  93, 81, 85, 92, 78, 99, 74, 80, 83, 93, 
  76, 88, 85, 81, 91, 75, 81, 75, 85, 81, 
  76, 73, 83, 84, 74, 92, 78, 86, 74, 90, 
  83, 86, 71, 74, 86, 79, 74, 71, 97, 86, 
  86, 90, 82, 90, 82, 86, 76, 74, 80, 84, 
  87, 93, 81, 81, 68, 83, 68, 97, 80, 82, 
  83, 95, 83, 86, 79, 88, 88, 78, 79, 73, 
  88, 74, 67, 87, 63, 83, 83, 83, 80, 81, 
  77, 91, 78, 83, 148, 79, 87, 82, 75, 81, 
  83, 87, 86, 92, 85, 112, 89, 87, 93, 81, 
  80, 88, 97, 119, 84, 83, 76, 93, 76, 77, 
  93, 86, 96, 73, 77, 82, 81, 71, 84, 84, 
  82, 85, 84, 86, 79, 78, 86, 80, 86, 79, 
  82, 91, 77, 94, 74, 94, 80, 90, 84, 86, 
  88, 81, 92, 73, 81, 81, 90, 76, 77, 77, 
  79, 88, 72, 86, 81, 87, 75, 91, 88, 84, 
  74, 79, 87, 80, 84, 76, 90, 87, 89, 92, 
  87, 86, 90, 82, 77, 80, 84, 98, 86, 86, 
  83, 84, 73, 90, 72, 92, 77, 83, 83, 94, 
  80, 86, 71, 96, 89, 76, 75, 76, 84, 74, 
  74, 84, 77, 83, 85, 87, 82, 83, 82, 86, 
  80, 81, 136, 87, 88, 87, 92, 79, 81, 91, 
  87, 89, 87, 117, 86, 92, 89, 85, 76, 76, 
  92, 83, 83, 99, 101, 79, 84, 48, 87, 83, 
  93, 80, 87, 89, 88, 82, 93, 86, 91, 87, 
  78, 92, 82, 83, 77, 82, 91, 77, 79, 76, 
  83, 92, 92, 90, 87, 97, 75, 87, 81, 75, 
  89, 85, 81, 86, 76, 103, 63, 92, 83, 91, 
  73, 80, 75, 86, 65, 95, 68, 105, 90, 79, 
  81, 89, 93, 89, 83, 81, 90, 92, 89, 80, 
  88, 85, 75, 70, 85, 85, 80, 82, 75, 96, 
  79, 85, 85, 77, 75, 76, 89, 81, 82, 85, 
  74, 90, 73, 89, 78, 92, 81, 89, 78, 77, 
  80, 90, 102, 79, 74, 83, 78, 76, 79, 81, 
  99, 91, 93, 78, 87, 109, 75, 74, 78, 83, 
  87, 78, 82, 78, 72, 105, 81, 80, 87, 75, 
  92, 81, 107, 85, 85, 48, 98, 81, 91, 73, 
  93, 81, 94, 84, 85, 87, 83, 82, 86, 99, 
  85, 79, 72, 74, 84, 82, 75, 77, 95, 81, 
  96, 72, 91, 75, 76, 85, 87, 81, 90, 84, 
  91, 81, 81, 90, 69, 95, 87, 95, 70, 87, 
  77, 81, 70, 97, 74, 101, 84, 84, 77, 91, 
  94, 98, 87, 84, 90, 91, 79, 83, 91, 79, 
  75, 72, 85, 86, 78, 93, 78, 88, 81, 75, 
  86, 85, 76, 76, 90, 80, 79, 75, 75, 85, 
  77, 89, 83, 95, 80, 101, 82, 85, 73, 86, 
  93, 81, 83, 90, 95, 82, 83, 84, 97, 70, 
  95, 86, 89, 111, 71, 81, 87, 85, 85, 79, 
  87, 77, 60, 102, 86, 72, 90, 79, 84, 95, 
  94, 83, 79, 60, 96, 83, 80, 74, 78, 80, 
  93, 92, 92, 82, 85, 81, 80, 86, 95, 75, 
  71, 55, 76, 86, 83, 77, 90, 85, 87, 76, 
  92, 77, 83, 80, 83, 96, 90, 81, 87, 87, 
  83, 92, 73, 88, 85, 90, 68, 90, 75, 81, 
  70, 98, 73, 93, 89, 87, 78, 99, 104, 107, 
  85, 86, 91, 87, 81, 86, 86, 76, 76, 77, 
  86, 82, 72, 84, 73, 83, 83, 75, 89, 88, 
  77, 76, 86, 80, 81, 90, 82, 87, 89, 87, 
  83, 89, 81, 94, 90, 78, 81, 86, 95, 77, 
  77, 89, 87, 79, 82, 85, 92, 74, 93, 81, 
  99, 95, 76, 85, 93, 85, 79, 82, 85, 81, 
  82, 93, 76, 79, 87, 109, 80, 93, 81, 75, 
  93, 70, 67, 85, 67, 92, 76, 102, 67, 76, 
  92, 88, 85, 84, 76, 98, 78, 84, 98, 93, 
  109, 69, 94, 71, 62, 103, 78, 95, 77, 150, 
  80, 69, 92, 58, 86, 84, 71, 97, 73, 98, 
  75, 79, 77, 77, 82, 70, 89, 96, 70, 88, 
  73, 74, 108, 81, 86, 83, 78, 75, 86, 86, 
  80, 86, 99, 72, 87, 100, 73, 75, 87, 76, 
  71, 54, 88, 86, 59, 82, 77, 85, 74, 95, 
  79, 87, 75, 110, 71, 91, 83, 85, 74, 77, 
  82, 64, 62, 87, 86, 86, 77, 86, 80, 80, 
  64, 77, 77, 92, 99, 113, 82, 78, 81, 97, 
  93, 71, 66, 79, 74, 82, 84, 87, 94, 89, 
  75, 84, 85, 105, 88, 78, 93, 85, 91, 61, 
  75, 79, 81, 79, 85, 107, 80, 71, 80, 80, 
  83, 82, 84, 109, 77, 93, 84, 93, 95, 71, 
  84, 70, 78, 92, 83, 80, 69, 145, 75, 82, 
  94, 63, 78, 84, 73, 91, 74, 92, 80, 89, 
  83, 85, 86, 75, 81, 88, 70, 94, 73, 85, 
  91, 77, 79, 83, 83, 82, 93, 75, 85, 83, 
  82, 73, 93, 91, 74, 72, 83, 82, 71, 75, 
  88, 88, 61, 79, 75, 92, 74, 87, 87, 83, 
  81, 88, 71, 93, 68, 88, 73, 79, 81, 83, 
  67, 80, 78, 82, 84, 91, 82, 83, 69, 91, 
  81, 80, 102, 78, 84, 76, 90, 101, 86, 75, 
  74, 82, 88, 79, 92, 77, 73, 94, 88, 84, 
  89, 91, 88, 82, 95, 87, 85, 60, 85, 82, 
  77, 82, 75, 94, 88, 79, 87, 77, 82, 80, 
  81, 94, 87, 84, 80, 67, 79, 76, 86, 77, 
  88, 88, 84, 78, 80, 102, 86, 87, 94, 77, 
  82, 80, 83, 93, 79, 82, 81, 86, 85, 91, 
  80, 80, 80, 87, 73, 100, 75, 88, 88, 88, 
  84, 89, 91, 99, 90, 80, 92, 86, 84, 78, 
  89, 80, 79, 76, 87, 81, 76, 81, 81, 82, 
  67, 75, 79, 96, 78, 85, 93, 75, 83, 89, 
  81, 95, 80, 90, 77, 83, 80, 92, 77, 80, 
  84, 81, 96, 85, 83, 87, 77, 83, 84, 82, 
  92, 76, 88, 82, 96, 90, 89, 84, 90, 83, 
  85, 79, 94, 82, 93, 88, 106, 78, 82, 98, 
  79, 71, 78, 69, 87, 80, 71, 108, 71, 99, 
  68, 76, 77, 84, 125, 92, 86, 89, 78, 67, 
  92, 80, 102, 79, 105, 64, 114, 88, 77, 108, 
  74, 81, 86, 88, 91, 60, 82, 57, 105, 89, 
  94, 89, 84, 92, 74, 78, 87, 80, 83, 80, 
  94, 88, 91, 77, 88, 74, 105, 66, 94, 89, 
  58, 81, 66, 99, 69, 79, 83, 87, 81, 96, 
  74, 79, 96, 81, 79, 61, 96, 83, 92, 80, 
  87, 70, 76, 101, 87, 89, 79, 90, 85, 97, 
  92, 80, 83, 83, 74, 53, 63, 66, 86, 87, 
  46, 72, 94, 84, 91, 79, 83, 94, 75, 115, 
  86, 104, 85, 64, 91, 88, 81, 84, 65, 77, 
  79, 114, 98, 89, 84, 76, 76, 111, 73, 97, 
  77, 68, 84, 78, 69, 94, 64, 89, 73, 92, 
  74, 71, 104, 92, 95, 80, 75, 79, 79, 85, 
  96, 83, 93, 70, 99, 74, 66, 100, 83, 83, 
  88, 106, 87, 72, 83, 65, 87, 82, 81, 89, 
  77, 93, 80, 82, 83, 77, 83, 74, 85, 87, 
  93, 75, 88, 67, 95, 70, 91, 72, 63, 78, 
  71, 93, 67, 74, 94, 86, 85, 89, 69, 83, 
  94, 80, 76, 69, 92, 75, 79, 83, 79, 71, 
  72, 95, 84, 92, 73, 90, 81, 92, 86, 79, 
  82, 76, 70, 68, 70, 79, 88, 83, 49, 72, 
  84, 84, 76, 77, 79, 88, 81, 101, 82, 90, 
  88, 72, 83, 92, 82, 84, 67, 79, 76, 103, 
  94, 85, 95, 75, 82, 101, 80, 89, 90, 81, 
  78, 70, 78, 85, 80, 88, 68, 93, 82, 76, 
  98, 84, 87, 83, 79, 82, 80, 87, 89, 74, 
  78, 76, 91, 77, 80, 95, 78, 85, 87, 80, 
  78, 97, 84, 76, 87, 79, 89, 90, 83, 93, 
  80, 85, 83, 91, 83, 76, 84, 89, 88, 80, 
  85, 78, 95, 78, 88, 69, 76, 82, 77, 86, 
  85, 84, 93, 87, 86, 84, 72, 79, 87, 75, 
  79, 79, 86, 72, 81, 76, 82, 76, 76, 83, 
  90, 81, 83, 85, 84, 91, 85, 80, 85, 76, 
  72, 85, 78, 96, 91, 79, 67, 84, 84, 84, 
  83, 81, 83, 84, 86, 90, 81, 87, 83, 81, 
  93, 96, 98, 81, 86, 87, 86, 95, 84, 86, 
  88, 79, 97, 79, 58, 102, 79, 88, 94, 85, 
  72, 81, 77, 89, 55, 71, 85, 103, 85, 96, 
  78, 76, 122, 82, 82, 77, 89, 99, 98, 72, 
  76, 83, 77, 78, 84, 92, 76, 79, 70, 77, 
  70, 101, 87, 62, 92, 83, 83, 109, 80, 80, 
  93, 68, 80, 69, 90, 65, 95, 68, 79, 76, 
  80, 88, 72, 75, 62, 82, 79, 98, 81, 87, 
  63, 101, 72, 84, 84, 85, 94, 102, 69, 95, 
  79, 86, 84, 99, 80, 80, 86, 93, 72, 79, 
  94, 73, 79, 73, 94, 98, 79, 68, 83, 69, 
  74, 84, 89, 104, 86, 82, 63, 70, 79, 78, 
  92, 73, 87, 102, 77, 130, 102, 88, 75, 88, 
  75, 71, 84, 66, 81, 88, 86, 84, 101, 75, 
  112, 94, 90, 96, 86, 89, 89, 80, 78, 75, 
  101, 96, 73, 88, 85, 90, 95, 84, 91, 78, 
  97, 80, 87, 90, 82, 94, 84, 107, 90, 89, 
  85, 88, 80, 86, 86, 81, 81, 84, 79, 91, 
  88, 78, 81, 72, 90, 102, 77, 78, 83, 92, 
  87, 79, 77, 74, 76, 83, 82, 83, 72, 71, 
  79, 83, 79, 79, 66, 82, 84, 106, 62, 84, 
  80, 88, 78, 89, 77, 79, 76, 90, 86, 89, 
  83, 87, 88, 81, 96, 98, 82, 79, 82, 76, 
  82, 82, 89, 88, 77, 75, 82, 75, 88, 67, 
  80, 98, 84, 72, 75, 85, 79, 81, 94, 70, 
  86, 80, 95, 92, 94, 89, 79, 77, 101, 73, 
  98, 87, 97, 90, 90, 82, 96, 65, 91, 78, 
  98, 80, 81, 96, 78, 77, 85, 76, 89, 84, 
  95, 83, 84, 82, 79, 74, 96, 83, 84, 79, 
  82, 81, 82, 71, 71, 102, 94, 84, 88, 89, 
  96, 83, 92, 79, 93, 89, 86, 81, 83, 84, 
  84, 77, 90, 80, 78, 76, 74, 105, 86, 86, 
  72, 75, 77, 95, 93, 78, 79, 89, 86, 88, 
  81, 93, 88, 83, 88, 88, 81, 78, 91, 83, 
  83, 77, 78, 88, 87, 82, 90, 86, 85, 78, 
  86, 84, 86, 75, 102, 79, 75, 88, 83, 90, 
  99, 84, 78, 84, 77, 87, 86, 72, 77, 89, 
  82, 84, 81, 87, 78, 86, 89, 76, 85, 85, 
  84, 86, 84, 84, 76, 87, 105, 94, 81, 86, 
  98, 90, 87, 94, 83, 72, 63, 76, 65, 102, 
  78, 86, 79, 86, 72, 82, 71, 66, 64, 68, 
  81, 105, 82, 100, 75, 68, 108, 81, 89, 81, 
  91, 98, 116, 53, 70, 72, 80, 85, 151, 106, 
  92, 77, 61, 75, 69, 104, 92, 61, 78, 107, 
  74, 78, 83, 76, 77, 59, 81, 73, 82, 68, 
  100, 53, 79, 71, 73, 104, 69, 71, 66, 78, 
  54, 92, 92, 64, 99, 92, 83, 80, 91, 88, 
  90, 143, 87, 98, 78, 76, 95, 87, 84, 74, 
  94, 105, 54, 89, 93, 77, 80, 77, 113, 93, 
  81, 69, 90, 71, 60, 55, 88, 105, 75, 73, 
  59, 63, 81, 81, 79, 79, 84, 113, 63, 117, 
  54, 81, 62, 78, 58, 67, 81, 67, 71, 70, 
  78, 83, 91, 68, 53, 103, 78, 96, 81, 85, 
  87, 88, 71, 81, 76, 86, 76, 82, 87, 91, 
  90, 83, 90, 60, 76, 85, 90, 82, 93, 104, 
  99, 58, 84, 75, 82, 113, 87, 76, 80, 90, 
  58, 66, 83, 91, 94, 75, 77, 83, 83, 72, 
  77, 69, 78, 64, 88, 77, 77, 106, 78, 69, 
  69, 87, 83, 84, 76, 75, 81, 69, 69, 97, 
  106, 85, 96, 82, 74, 92, 80, 91, 87, 95, 
  94, 87, 81, 83, 80, 57, 88, 89, 100, 105, 
  77, 74, 86, 108, 84, 82, 103, 93, 83, 75, 
  84, 70, 73, 98, 85, 99, 91, 92, 77, 76, 
  79, 77, 79, 82, 85, 79, 89, 110, 61, 93, 
  80, 74, 85, 64, 90, 85, 84, 79, 88, 70, 
  93, 74, 67, 83, 94, 70, 86, 97, 88, 75, 
  82, 83, 76, 91, 93, 91, 87, 81, 92, 74, 
  85, 77, 83, 86, 74, 80, 89, 85, 82, 73, 
  90, 82, 86, 92, 79, 72, 76, 85, 71, 84, 
  80, 81, 93, 82, 78, 76, 91, 84, 77, 77, 
  79, 84, 84, 85, 79, 85, 80, 93, 85, 81, 
  83, 91, 90, 74, 79, 83, 89, 81, 95, 86, 
  86, 78, 86, 90, 86, 78, 87, 73, 89, 80, 
  91, 82, 87, 73, 84, 90, 85, 76, 115, 79, 
  80, 98, 84, 90, 88, 81, 82, 84, 84, 83, 
  79, 99, 75, 88, 96, 92, 90, 86, 91, 89, 
  91, 74, 78, 82, 87, 93, 73, 88, 83, 88, 
  97, 84, 92, 83, 91, 86, 89, 93, 84, 101, 
  92, 79, 93, 86, 96, 93, 79, 81, 87, 78, 
  69, 80, 70, 78, 85, 104, 89, 96, 77, 63, 
  87, 77, 83, 88, 87, 87, 99, 106, 87, 90, 
  97, 80, 87, 75, 77, 90, 75, 82, 82, 84, 
  80, 88, 77, 95, 88, 88, 81, 75, 90, 89, 
  87, 88, 90, 80, 92, 86, 96, 68, 74, 77, 
  87, 77, 79, 80, 67, 77, 79, 84, 60, 75, 
  96, 76, 93, 95, 85, 67, 100, 85, 96, 93, 
  85, 88, 85, 83, 88, 90, 98, 96, 99, 73, 
  81, 81, 95, 84, 85, 79, 94, 83, 65, 76, 
  83, 100, 74, 70, 65, 87, 91, 87, 85, 73, 
  83, 92, 84, 96, 56, 74, 76, 78, 68, 75, 
  99, 83, 91, 80, 83, 84, 91, 85, 75, 82, 
  80, 100, 82, 90, 85, 92, 73, 84, 66, 87, 
  64, 71, 84, 92, 85, 98, 81, 82, 91, 77, 
  82, 82, 93, 96, 92, 90, 86, 82, 86, 96, 
  82, 93, 86, 81, 66, 75, 84, 84, 84, 78, 
  78, 89, 83, 119, 86, 69, 81, 86, 85, 79, 
  82, 88, 86, 76, 76, 77, 88, 96, 81, 76, 
  80, 81, 55, 89, 80, 76, 84, 86, 87, 83, 
  82, 96, 84, 70, 102, 88, 88, 84, 81, 78, 
  84, 85, 92, 95, 77, 82, 97, 85, 79, 73, 
  97, 87, 86, 72, 82, 79, 68, 103, 88, 98, 
  83, 84, 72, 76, 90, 82, 85, 74, 84, 89, 
  77, 89, 76, 81, 78, 78, 79, 68, 93, 78, 
  87, 84, 84, 72, 84, 74, 72, 81, 89, 82, 
  82, 94, 92, 87, 83, 82, 84, 93, 76, 81, 
  81, 81, 86, 85, 85, 90, 89, 78, 80, 86, 
  86, 91, 78, 76, 87, 75, 79, 94, 91, 93, 
  83, 85, 75, 90, 87, 85, 93, 77, 93, 82, 
  84, 100, 86, 73, 86, 89, 79, 83, 78, 79, 
  83, 81, 81, 86, 84, 92, 80, 76, 79, 91, 
  77, 94, 80, 82, 91, 82, 82, 85, 80, 76, 
  89, 82, 83, 85, 91, 79, 87, 85, 80, 88, 
  94, 78, 86, 81, 89, 88, 84, 79, 92, 89, 
  84, 80, 83, 81, 77, 96, 80, 94, 89, 91, 
  86, 79, 93, 85, 88, 74, 78, 83, 82, 85, 
  89, 87, 86, 80, 91, 79, 87, 82, 88, 87, 
  86, 87, 89, 76, 77, 88, 86, 88, 99, 74, 
  70, 67, 89, 78, 87, 81, 83, 84, 88, 85, 
  65, 87, 89, 88, 88, 92, 95, 71, 83, 61, 
  85, 83, 88, 88, 85, 80, 99, 76, 94, 81, 
  82, 76, 72, 83, 77, 79, 101, 62, 87, 75, 
  66, 92, 83, 87, 84, 103, 91, 91, 66, 91, 
  85, 94, 96, 91, 76, 82, 82, 89, 89, 88, 
  74, 88, 65, 85, 98, 95, 81, 74, 78, 100, 
  80, 101, 83, 85, 98, 92, 83, 94, 84, 92, 
  98, 79, 85, 81, 77, 102, 80, 88, 93, 88, 
  74, 107, 84, 87, 92, 86, 89, 85, 70, 86, 
  81, 77, 79, 88, 84, 87, 92, 69, 68, 103, 
  72, 81, 85, 84, 77, 77, 75, 78, 82, 89, 
  76, 94, 90, 83, 94, 75, 97, 67, 71, 60, 
  74, 90, 99, 87, 82, 101, 82, 73, 61, 92, 
  100, 70, 86, 110, 86, 80, 89, 68, 92, 83, 
  96, 71, 75, 74, 89, 78, 85, 100, 94, 93, 
  79, 73, 73, 95, 88, 92, 81, 72, 79, 86, 
  80, 93, 82, 82, 81, 79, 60, 81, 93, 93, 
  87, 74, 76, 74, 79, 69, 79, 79, 65, 78, 
  78, 83, 76, 99, 89, 60, 76, 98, 82, 88, 
  83, 87, 85, 95, 71, 90, 86, 73, 96, 88, 
  71, 78, 77, 98, 69, 89, 87, 85, 92, 80, 
  77, 74, 74, 86, 103, 77, 54, 78, 67, 91, 
  100, 85, 73, 85, 83, 98, 69, 92, 74, 81, 
  84, 89, 77, 65, 83, 81, 82, 92, 80, 79, 
  101, 97, 92, 83, 78, 89, 86, 83, 83, 93, 
  77, 93, 64, 102, 89, 72, 105, 99, 65, 89, 
  80, 94, 80, 75, 100, 91, 86, 90, 97, 81, 
  76, 86, 70, 83, 92, 94, 90, 79, 85, 66, 
  77, 90, 79, 96, 87, 92, 90, 78, 82, 74, 
  77, 82, 100, 87, 85, 82, 69, 87, 92, 83, 
  96, 70, 63, 74, 69, 99, 83, 75, 80, 85, 
  86, 97, 84, 78, 84, 101, 79, 76, 84, 72, 
  77, 88, 68, 92, 99, 81, 85, 77, 82, 92, 
  76, 77, 103, 84, 90, 81, 92, 71, 84, 79, 
  89, 86, 88, 77, 71, 87, 67, 80, 93, 103, 
  86, 85, 88, 100, 101, 91, 84, 75, 79, 94, 
  78, 88, 88, 88, 88, 84, 73, 91, 76, 94, 
  85, 94, 100, 65, 69, 61, 75, 83, 88, 88, 
  86, 105, 86, 76, 56, 85, 109, 81, 87, 102, 
  78, 73, 90, 68, 95, 83, 93, 78, 79, 91, 
  91, 78, 75, 83, 82, 85, 78, 79, 76, 86, 
  87, 77, 78, 85, 80, 92, 84, 91, 91, 90, 
  85, 73, 66, 83, 93, 91, 89, 89, 77, 85, 
  74, 75, 91, 86, 71, 67, 74, 74, 93, 95, 
  80, 65, 82, 93, 79, 94, 86, 91, 90, 86, 
  77, 97, 87, 87, 98, 76, 75, 74, 90, 101, 
  64, 82, 85, 88, 84, 90, 75, 91, 77, 85, 
  95, 86, 64, 78, 74, 91, 82, 92, 83, 80, 
  84, 75, 62, 94, 77, 87, 82, 100, 82, 74, 
  82, 85, 83, 89, 72, 98, 86, 86, 80, 71, 
  79, 68, 68, 77, 67, 93, 94, 94, 74, 95, 
  78, 68, 73, 88, 112, 75, 103, 95, 63, 76, 
  93, 73, 115, 80, 105, 57, 59, 78, 81, 82, 
  76, 109, 88, 88, 91, 70, 71, 93, 79, 103, 
  67, 89, 91, 84, 74, 96, 83, 71, 88, 74, 
  73, 68, 98, 69, 87, 72, 84, 60, 60, 64, 
  69, 82, 65, 84, 74, 77, 64, 104, 83, 65, 
  83, 108, 73, 78, 85, 78, 74, 81, 63, 94, 
  92, 85, 78, 72, 64, 68, 77, 92, 72, 90, 
  84, 83, 107, 55, 70, 61, 73, 85, 88, 68, 
  67, 71, 52, 86, 103, 92, 76, 86, 82, 97, 
  98, 81, 77, 82, 67, 107, 65, 74, 84, 83, 
  93, 85, 86, 71, 74, 99, 83, 79, 69, 91, 
  89, 91, 86, 82, 71, 90, 56, 80, 85, 82, 
  121, 95, 69, 90, 82, 76, 76, 77, 93, 100, 
  101, 88, 87, 96, 86, 83, 61, 79, 87, 85, 
  80, 65, 90, 65, 78, 85, 84, 99, 89, 90, 
  88, 69, 86, 78, 79, 88, 118, 88, 111, 65, 
  82, 85, 89, 88, 96, 55, 51, 81, 59, 111, 
  80, 72, 82, 70, 85, 91, 85, 96, 86, 101, 
  75, 75, 82, 67, 74, 73, 63, 82, 106, 92, 
  69, 75, 96, 84, 73, 73, 123, 96, 92, 84, 
  99, 72, 77, 83, 95, 85, 71, 80, 88, 90, 
  84, 72, 81, 96, 95, 79, 75, 89, 106, 80, 
  93, 69, 77, 88, 76, 102, 93, 82, 102, 76, 
  77, 91, 79, 101, 78, 86, 88, 70, 71, 71, 
  74, 80, 94, 97, 75, 86, 82, 78, 80, 84, 
  106, 89, 78, 96, 75, 75, 100, 77, 83, 84, 
  90, 80, 73, 95, 95, 80, 82, 92, 79, 90, 
  80, 73, 83, 83, 77, 87, 80, 70, 83, 83, 
  90, 88, 86, 89, 94, 85, 80, 82, 97, 79, 
  86, 89, 86, 91, 85, 73, 77, 81, 74, 81, 
  87, 77, 91, 91, 78, 73, 85, 106, 82, 81, 
  82, 85, 92, 87, 81, 89, 86, 89, 89, 85, 
  88, 71, 85, 93, 73, 81, 85, 90, 87, 86, 
  71, 94, 88, 83, 84, 92, 65, 88, 84, 82, 
  76, 99, 79, 81, 94, 87, 78, 87, 78, 87, 
  75, 101, 73, 74, 92, 89, 90, 82, 81, 99, 
  75, 92, 72, 82, 82, 78, 75, 84, 74, 93, 
  96, 92, 66, 72, 72, 79, 97, 89, 102, 88, 
  80, 91, 68, 76, 95, 87, 103, 87, 95, 77, 
  68, 80, 76, 80, 78, 108, 90, 81, 101, 70, 
  76, 87, 78, 98, 71, 71, 86, 83, 83, 93, 
  83, 84, 102, 90, 96, 70, 97, 73, 90, 74, 
  86, 82, 70, 77, 72, 87, 72, 82, 84, 68, 
  69, 100, 82, 80, 79, 100, 83, 69, 83, 86, 
  85, 90, 71, 86, 91, 91, 76, 76, 85, 72, 
  84, 86, 93, 94, 94, 84, 116, 69, 73, 78, 
  88, 84, 70, 75, 84, 87, 81, 80, 80, 96, 
  79, 79, 83, 86, 107, 82, 85, 85, 62, 92, 
  62, 77, 84, 83, 99, 88, 77, 90, 67, 87, 
  76, 104, 82, 93, 86, 91, 83, 80, 80, 95, 
  59, 84, 74, 88, 105, 86, 71, 85, 70, 91, 
  78, 97, 83, 110, 72, 86, 83, 102, 91, 87, 
  64, 79, 87, 82, 71, 72, 88, 72, 79, 90, 
  89, 93, 104, 81, 83, 73, 95, 75, 77, 88, 
  103, 86, 103, 81, 85, 90, 83, 79, 91, 62, 
  64, 99, 74, 98, 83, 69, 93, 69, 82, 89, 
  96, 92, 70, 85, 81, 82, 89, 90, 79, 82, 
  82, 85, 92, 85, 86, 84, 87, 82, 82, 74, 
  109, 90, 87, 85, 107, 83, 78, 94, 89, 87, 
  66, 78, 91, 92, 88, 85, 77, 82, 85, 77, 
  75, 92, 83, 85, 95, 74, 79, 74, 79, 99, 
  91, 77, 89, 89, 93, 88, 83, 88, 85, 87, 
  84, 93, 88, 86, 89, 87, 72, 85, 77, 90, 
  74, 74, 87, 81, 87, 84, 84, 89, 81, 78, 
  85, 89, 87, 93, 84, 89, 80, 92, 78, 84, 
  88, 90, 92, 77, 87, 81, 79, 87, 79, 92, 
  79, 89, 93, 76, 86, 84, 80, 75, 93, 83, 
  81, 86, 88, 83, 83, 77, 94, 77, 81, 73, 
  84, 73, 78, 80, 107, 95, 90, 105, 81, 90, 
  82, 88, 77, 76, 93, 95, 93, 84, 75, 87, 
  91, 100, 91, 66, 80, 87, 92, 85, 92, 77, 
  84, 86, 74, 86, 74, 82, 88, 92, 82, 88, 
  74, 94, 78, 85, 90, 81, 76, 83, 93, 97, 
  97, 82, 80, 79, 84, 85, 85, 81, 77, 88, 
  86, 84, 79, 91, 78, 82, 81, 77, 101, 97, 
  91, 79, 93, 89, 79, 83, 88, 102, 87, 86, 
  92, 82, 89, 76, 82, 88, 89, 90, 80, 84, 
  79, 89, 86, 87, 91, 80, 74, 80, 69, 81, 
  82, 81, 87, 71, 77, 91, 74, 89, 85, 80, 
  80, 84, 86, 85, 81, 80, 83, 36, 89, 91, 
  88, 87, 76, 83, 92, 84, 79, 87, 84, 85, 
  80, 79, 96, 83, 93, 95, 87, 87, 82, 75, 
  80, 84, 88, 84, 94, 80, 84, 84, 88, 71, 
  88, 75, 79, 68, 86, 92, 74, 87, 84, 85, 
  87, 79, 65, 76, 84, 88, 79, 87, 84, 86, 
  80, 84, 90, 90, 83, 84, 99, 85, 83, 83, 
  86, 82, 87, 88, 83, 81, 78, 87, 83, 81, 
  87, 81, 83, 76, 82, 86, 104, 88, 74, 80, 
  87, 83, 79, 76, 91, 96, 83, 97, 81, 86, 
  86, 89, 84, 86, 92, 90, 76, 80, 75, 87, 
  82, 87, 94, 77, 81, 88, 80, 83, 90, 83, 
  85, 76, 78, 92, 78, 81, 92, 88, 81, 92, 
  82, 92, 76, 85, 85, 52, 90, 97, 86, 82, 
  77, 84, 88, 82, 93, 100, 86, 90, 86, 95, 
  108, 86, 86, 87, 91, 73, 80, 83, 86, 86, 
  88, 79, 87, 90, 88, 80, 86, 76, 82, 73, 
  77, 74, 87, 82, 81, 99, 85, 75, 93, 83, 
  76, 88, 83, 86, 85, 90, 97, 81, 72, 82, 
  88, 99, 81, 81, 98, 88, 81, 87, 89, 82, 
  83, 90, 77, 73, 87, 85, 82, 81, 88, 76, 
  68, 83, 91, 78, 68, 80, 91, 84, 73, 87, 
  64, 66, 76, 70, 69, 74, 76, 90, 83, 83, 
  86, 99, 94, 77, 92, 86, 112, 82, 74, 92, 
  71, 85, 71, 79, 98, 83, 91, 87, 79, 88, 
  87, 82, 85, 109, 84, 91, 91, 70, 84, 89, 
  89, 73, 100, 166, 82, 63, 88, 80, 96, 82, 
  87, 67, 66, 62, 68, 86, 86, 103, 80, 89, 
  80, 81, 89, 82, 79, 94, 83, 78, 80, 87, 
  89, 83, 64, 84, 91, 108, 73, 81, 79, 91, 
  90, 74, 106, 79, 80, 87, 79, 87, 86, 88, 
  89, 95, 97, 84, 71, 92, 79, 80, 80, 69, 
  76, 94, 79, 100, 76, 80, 77, 78, 81, 79, 
  74, 72, 85, 83, 88, 80, 74, 80, 59, 86, 
  81, 83, 70, 85, 96, 87, 80, 76, 67, 65, 
  76, 74, 80, 65, 79, 85, 79, 69, 81, 90, 
  85, 75, 94, 88, 110, 83, 75, 85, 69, 90, 
  70, 75, 96, 86, 94, 75, 87, 88, 89, 84, 
  80, 100, 77, 85, 93, 64, 84, 87, 85, 69, 
  95, 171, 74, 65, 85, 79, 86, 76, 84, 67, 
  64, 62, 72, 72, 85, 97, 112, 77, 88, 89, 
  83, 81, 85, 90, 86, 79, 77, 89, 91, 80, 
  73, 85, 89, 110, 77, 69, 73, 96, 86, 77, 
  102, 74, 83, 85, 79, 85, 78, 101, 90, 92, 
  81, 82, 65, 92, 75, 76, 79, 73, 75, 87, 
  67, 89, 69, 76, 79, 80, 80, 83, 75, 74, 
  76, 81, 82, 77, 82, 83, 73, 87, 87, 75, 
  84, 91, 97, 88, 85, 80, 84, 70, 83, 100, 
  91, 73, 86, 81, 84, 89, 83, 89, 81, 82, 
  85, 86, 83, 85, 83, 87, 82, 85, 65, 80, 
  85, 89, 87, 96, 87, 83, 87, 84, 76, 85, 
  78, 91, 88, 80, 79, 94, 85, 78, 83, 82, 
  80, 83, 88, 89, 77, 83, 83, 73, 77, 82, 
  82, 77, 79, 82, 78, 82, 94, 96, 84, 81, 
  83, 77, 80, 83, 83, 78, 95, 87, 81, 88, 
  88, 85, 76, 70, 77, 75, 83, 87, 83, 83, 
  87, 89, 83, 80, 72, 84, 87, 88, 82, 70, 
  79, 79, 70, 83, 83, 77, 80, 83, 70, 85, 
  79, 78, 85, 80, 76, 91, 91, 81, 80, 83, 
  85, 84, 79, 77, 79, 80, 89, 75, 86, 82, 
  89, 84, 85, 91, 83, 74, 84, 84, 76, 98, 
  85, 84, 92, 87, 86, 88, 96, 87, 73, 80, 
  77, 81, 90, 91, 90, 78, 71, 86, 75, 88, 
  78, 94, 81, 74, 77, 82, 84, 95, 90, 85, 
  79, 92, 86, 94, 88, 85, 88, 60, 77, 84, 
  83, 88, 90, 93, 92, 93, 81, 82, 93, 93, 
  83, 82, 62, 80, 83, 84, 74, 85, 77, 81, 
  59, 79, 93, 78, 89, 90, 79, 86, 93, 69, 
  73, 88, 95, 80, 84, 94, 87, 89, 76, 94, 
  81, 79, 76, 56, 83, 91, 84, 81, 83, 87, 
  73, 79, 80, 86, 80, 82, 97, 85, 83, 88, 
  88, 68, 89, 84, 89, 79, 91, 85, 83, 80, 
  73, 87, 70, 80, 84, 73, 74, 82, 92, 90, 
  79, 91, 69, 86, 78, 71, 74, 76, 88, 88, 
  84, 74, 92, 94, 96, 87, 82, 85, 94, 82, 
  82, 96, 77, 73, 84, 86, 79, 85, 84, 79, 
  79, 78, 76, 78, 83, 94, 80, 78, 85, 78, 
  92, 83, 88, 84, 94, 105, 79, 80, 90, 79, 
  93, 87, 89, 84, 70, 66, 79, 94, 91, 86, 
  64, 77, 89, 76, 81, 90, 84, 83, 73, 79, 
  83, 91, 90, 91, 75, 83, 88, 95, 81, 89, 
  97, 80, 91, 85, 92, 82, 81, 92, 80, 82, 
  79, 72, 90, 93, 88, 82, 75, 86, 91, 79, 
  83, 82, 83, 83, 86, 88, 75, 82, 75, 73, 
  82, 84, 82, 79, 84, 86, 87, 76, 79, 79, 
  74, 80, 83, 89, 66, 86, 87, 91, 78, 91, 
  71, 83, 66, 72, 75, 64, 80, 94, 82, 73, 
  99, 90, 85, 78, 93, 88, 90, 96, 78, 93, 
  73, 82, 81, 92, 104, 83, 97, 84, 80, 82, 
  85, 76, 79, 89, 71, 95, 101, 75, 87, 76, 
  82, 84, 85, 139, 80, 71, 88, 76, 86, 84, 
  86, 74, 81, 65, 75, 79, 89, 100, 80, 84, 
  88, 76, 79, 88, 84, 91, 93, 82, 77, 92, 
  94, 98, 72, 91, 87, 109, 83, 75, 87, 87, 
  87, 80, 97, 78, 88, 86, 72, 88, 86, 88, 
  91, 93, 93, 79, 74, 80, 86, 75, 84, 75, 
  78, 89, 77, 94, 85, 75, 69, 84, 83, 86, 
  81, 74, 78, 89, 87, 89, 76, 74, 89, 89, 
  79, 80, 70, 76, 72, 76, 69, 93, 79, 101, 
  69, 83, 81, 68, 84, 81, 83, 101, 95, 81, 
  82, 94, 80, 78, 100, 86, 122, 98, 82, 93, 
  90, 85, 86, 82, 95, 84, 80, 89, 74, 93, 
  74, 68, 80, 81, 88, 83, 87, 73, 78, 87, 
  80, 87, 80, 78, 83, 73, 81, 87, 88, 83, 
  90, 70, 83, 98, 89, 86, 79, 84, 64, 98, 
  80, 84, 70, 89, 89, 70, 82, 76, 60, 100, 
  95, 84, 90, 98, 74, 81, 72, 78, 94, 77, 
  86, 81, 81, 101, 97, 68, 81, 91, 72, 75, 
  82, 83, 87, 80, 72, 95, 82, 91, 89, 79, 
  73, 83, 81, 84, 98, 93, 75, 141, 76, 88, 
  73, 89, 94, 77, 87, 73, 82, 82, 85, 88, 
  75, 78, 75, 75, 61, 97, 81, 92, 72, 85, 
  89, 71, 84, 84, 82, 101, 84, 77, 82, 100, 
  73, 75, 107, 90, 134, 94, 80, 86, 89, 83, 
  86, 76, 92, 89, 80, 91, 83, 98, 77, 71, 
  84, 77, 78, 82, 94, 81, 80, 91, 78, 82, 
  78, 81, 86, 66, 77, 79, 91, 79, 83, 75, 
  84, 94, 89, 76, 81, 79, 64, 96, 80, 81, 
  69, 91, 91, 74, 85, 80, 61, 78, 93, 77, 
  87, 95, 75, 83, 69, 83, 86, 79, 75, 85, 
  80, 106, 86, 68, 79, 90, 72, 75, 83, 83, 
  88, 80, 73, 90, 86, 88, 89, 84, 73, 81, 
  77, 80, 95, 90, 82, 137, 77, 82, 71, 84, 
  98, 73, 82, 77, 88, 89, 82, 87, 69, 81, 
  72, 76, 75, 85, 83, 86, 71, 84, 80, 80, 
  86, 91, 78, 86, 83, 84, 77, 92, 79, 78, 
  97, 87, 117, 97, 82, 79, 82, 95, 94, 83, 
  85, 86, 87, 86, 88, 88, 73, 82, 88, 90, 
  87, 85, 91, 75, 79, 91, 84, 85, 76, 76, 
  78, 75, 83, 80, 92, 78, 84, 75, 82, 95, 
  89, 85, 89, 83, 76, 93, 85, 89, 72, 83, 
  97, 73, 81, 78, 61, 72, 97, 78, 85, 95, 
  76, 81, 77, 99, 94, 78, 85, 81, 83, 97, 
  91, 70, 80, 99, 76, 76, 81, 82, 79, 86, 
  75, 98, 84, 92, 85, 88, 79, 83, 83, 84, 
  92, 87, 94, 131, 77, 86, 74, 85, 93, 70, 
  89, 86, 77, 81, 81, 82, 77, 73, 73, 78, 
  75, 91, 81, 89, 82, 83, 82, 73, 80, 81, 
  87, 96, 85, 87, 85, 81, 81, 78, 91, 80, 
  114, 90, 85, 97, 95, 82, 91, 83, 88, 84, 
  85, 90, 72, 93, 77, 80, 92, 84, 80, 89, 
  91, 79, 86, 82, 83, 84, 83, 80, 79, 74, 
  87, 79, 91, 79, 83, 69, 86, 87, 79, 74, 
  82, 92, 67, 89, 89, 81, 62, 90, 86, 74, 
  87, 79, 62, 84, 96, 80, 87, 100, 83, 91, 
  73, 76, 89, 68, 79, 84, 81, 101, 98, 71, 
  78, 84, 76, 75, 93, 81, 86, 75, 85, 103, 
  84, 81, 89, 80, 78, 75, 80, 85, 102, 83, 
  80, 112, 82, 87, 73, 87, 100, 78, 98, 89, 
  81, 76, 82, 89, 78, 75, 76, 83, 71, 93, 
  89, 84, 84, 84, 88, 73, 83, 86, 77, 96, 
  88, 87, 87, 77, 77, 79, 97, 89, 115, 84, 
  85, 88, 94, 76, 91, 84, 89, 85, 89, 94, 
  80, 99, 83, 80, 95, 78, 73, 88, 94, 83, 
  88, 84, 90, 83, 83, 82, 85, 65, 85, 76, 
  91, 76, 74, 75, 90, 79, 76, 70, 79, 87, 
  67, 83, 88, 79, 65, 89, 79, 78, 89, 76, 
  65, 76, 89, 76, 76, 93, 84, 96, 71, 74, 
  86, 65, 72, 83, 80, 101, 89, 77, 79, 86, 
  87, 75, 89, 87, 86, 79, 85, 96, 81, 76, 
  93, 76, 72, 69, 79, 79, 94, 81, 84, 98, 
  80, 87, 70, 79, 105, 80, 87, 86, 86, 84, 
  84, 89, 75, 78, 75, 79, 79, 86, 87, 84, 
  80, 83, 76, 77, 82, 84, 74, 83, 83, 92, 
  86, 78, 79, 80, 87, 82, 104, 90, 87, 82, 
  81, 92, 86, 81, 90, 81, 87, 87, 90, 91, 
  79, 87, 90, 85, 80, 88, 93, 77, 85, 88, 
  85, 85, 81, 75, 78, 72, 86, 82, 92, 76, 
  75, 75, 86, 90, 75, 68, 87, 90, 73, 86, 
  85, 86, 66, 80, 84, 77, 86, 79, 62, 74, 
  91, 83, 82, 91, 81, 89, 76, 84, 92, 71, 
  79, 87, 82, 91, 87, 76, 74, 95, 78, 77, 
  89, 82, 81, 82, 83, 100, 84, 81, 86, 84, 
  79, 76, 83, 85, 91, 85, 91, 105, 75, 84, 
  73, 86, 98, 73, 86, 86, 72, 84, 83, 94, 
  72, 73, 68, 77, 86, 82, 85, 83, 86, 89, 
  75, 75, 82, 79, 80, 92, 88, 94, 91, 77, 
  82, 80, 86, 81, 97, 95, 84, 99, 94, 90, 
  91, 84, 92, 89, 94, 81, 75, 83, 82, 72, 
  88, 86, 84, 83, 87, 77, 85, 82, 86, 84, 
  75, 83, 73, 81, 92, 84, 85, 83, 83, 74, 
  85, 90, 79, 75, 94, 87, 76, 81, 90, 79, 
  69, 86, 90, 74, 85, 84, 61, 83, 88, 87, 
  87, 100, 81, 84, 79, 81, 97, 77, 86, 93, 
  86, 97, 94, 79, 78, 85, 83, 77, 89, 76, 
  80, 78, 85, 100, 89, 77, 82, 76, 81, 81, 
  82, 87, 96, 85, 78, 113, 79, 94, 79, 96, 
  97, 77, 83, 92, 82, 83, 83, 90, 73, 76, 
  72, 82, 86, 82, 88, 88, 83, 87, 75, 77, 
  86, 84, 77, 87, 90, 98, 87, 76, 88, 81, 
  89, 89, 89, 91, 93, 85, 92, 81, 90, 85, 
  86, 86, 94, 80, 78, 85, 84, 76, 88, 81, 
  82, 86, 84, 79, 88, 82, 90, 85, 77, 83, 
  78, 73, 86, 87, 89, 81, 75, 74, 90, 83, 
  77, 78, 83, 84, 78, 76, 92, 79, 69, 83, 
  87, 76, 87, 82, 66, 77, 81, 86, 79, 92, 
  85, 86, 80, 76, 99, 77, 86, 93, 88, 91, 
  89, 80, 83, 84, 86, 77, 81, 78, 80, 81, 
  81, 101, 87, 72, 88, 75, 78, 76, 88, 84, 
  89, 88, 85, 101, 80, 93, 79, 92, 101, 81, 
  86, 86, 86, 83, 84, 91, 74, 78, 67, 79, 
  88, 81, 91, 93, 80, 86, 70, 79, 86, 86, 
  73, 89, 94, 98, 81, 74, 80, 84, 82, 81, 
  92, 95, 88, 83, 82, 92, 85, 80, 87, 84, 
  92, 79, 77, 83, 81, 71, 88, 85, 80, 83, 
  88, 78, 85, 86, 81, 82, 77, 81, 75, 84, 
  92, 88, 88, 81, 75, 77, 85, 89, 76, 70, 
  79, 89, 80, 80, 92, 83, 72, 81, 84, 79, 
  87, 84, 63, 77, 89, 94, 77, 91, 84, 80, 
  80, 80, 93, 77, 83, 92, 88, 91, 86, 79, 
  73, 89, 89, 79, 84, 84, 78, 84, 86, 97, 
  87, 76, 82, 80, 84, 86, 90, 85, 91, 86, 
  91, 102, 76, 89, 82, 92, 96, 81, 94, 70, 
  93, 84, 76, 93, 75, 86, 85, 83, 74, 86, 
  77, 90, 72, 83, 82, 82, 96, 92, 84, 84, 
  82, 79, 82, 85, 81, 94, 97, 73, 101, 105, 
  95, 96, 87, 96, 86, 74, 93, 70, 92, 67, 
  80, 88, 91, 81, 76, 75, 87, 76, 91, 75, 
  84, 87, 103, 93, 91, 70, 84, 76, 97, 84, 
  95, 84, 83, 88, 81, 87, 80, 83, 75, 83, 
  86, 88, 83, 80, 86, 74, 76, 83, 86, 77, 
  86, 97, 73, 81, 85, 82, 91, 86, 91, 90, 
  93, 69, 73, 112, 93, 85, 84, 72, 69, 76, 
  92, 84, 83, 78, 76, 91, 79, 81, 89, 99, 
  91, 98, 90, 96, 84, 83, 80, 91, 79, 96, 
  71, 86, 86, 88, 102, 75, 80, 80, 79, 72, 
  83, 101, 76, 85, 79, 81, 70, 83, 83, 91, 
  79, 80, 87, 76, 70, 84, 76, 81, 66, 83, 
  71, 97, 73, 80, 91, 83, 97, 89, 74, 88, 
  84, 89, 90, 88, 83, 74, 79, 65, 91, 88, 
  93, 74, 68, 73, 92, 93, 84, 80, 86, 72, 
  96, 89, 70, 76, 94, 84, 94, 79, 88, 73, 
  76, 78, 77, 75, 65, 78, 88, 88, 82, 83, 
  77, 66, 84, 76, 78, 77, 85, 78, 71, 81, 
  78, 72, 82, 84, 90, 87, 80, 88, 97, 76, 
  65, 109, 91, 87, 74, 64, 71, 89, 91, 90, 
  89, 68, 65, 81, 68, 93, 81, 89, 88, 97, 
  84, 86, 76, 91, 74, 91, 81, 111, 76, 85, 
  78, 83, 90, 75, 81, 76, 77, 69, 82, 86, 
  78, 92, 80, 86, 78, 81, 99, 84, 79, 83, 
  91, 79, 60, 84, 82, 77, 79, 92, 84, 88, 
  78, 75, 78, 91, 95, 76, 77, 79, 87, 78, 
  91, 89, 84, 77, 83, 70, 92, 83, 96, 75, 
  79, 96, 89, 99, 76, 76, 87, 70, 93, 88, 
  60, 86, 93, 93, 92, 80, 80, 83, 92, 82, 
  92, 79, 56, 82, 86, 92, 100, 82, 85, 65, 
  79, 86, 71, 86, 79, 78, 78, 85, 80, 76, 
  81, 92, 96, 84, 74, 79, 94, 92, 83, 94, 
  83, 97, 71, 88, 79, 82, 94, 94, 91, 68, 
  67, 81, 76, 84, 88, 75, 88, 95, 88, 89, 
  96, 98, 82, 88, 91, 104, 90, 78, 78, 90, 
  74, 84, 88, 74, 89, 87, 77, 92, 76, 85, 
  88, 86, 86, 79, 78, 84, 71, 74, 81, 92, 
  114, 84, 73, 82, 78, 73, 98, 78, 83, 98, 
  104, 69, 83, 104, 110, 91, 91, 94, 83, 70, 
  83, 65, 97, 76, 98, 79, 89, 93, 92, 81, 
  78, 79, 91, 82, 82, 107, 114, 84, 97, 57, 
  85, 82, 89, 93, 101, 71, 68, 101, 75, 86, 
  78, 69, 82, 73, 81, 75, 86, 76, 75, 76, 
  77, 86, 84, 84, 93, 96, 74, 83, 84, 80, 
  86, 80, 90, 82, 81, 72, 81, 102, 89, 80, 
  81, 89, 69, 73, 86, 83, 69, 77, 85, 87, 
  88, 66, 89, 94, 93, 85, 88, 95, 79, 77, 
  79, 74, 79, 71, 83, 73, 101, 85, 104, 83, 
  79, 80, 77, 78, 89, 104, 68, 80, 81, 83, 
  72, 84, 76, 94, 77, 75, 90, 83, 93, 84, 
  70, 90, 59, 74, 87, 87, 75, 86, 113, 69, 
  96, 101, 86, 95, 87, 94, 77, 86, 81, 64, 
  106, 72, 110, 91, 93, 85, 71, 73, 91, 82, 
  86, 83, 82, 87, 104, 88, 84, 67, 89, 69, 
  93, 89, 97, 70, 54, 77, 75, 83, 69, 67, 
  87, 72, 67, 83, 75, 71, 76, 76, 80, 79, 
  86, 88, 73, 81, 81, 80, 75, 80, 82, 80, 
  89, 88, 96, 76, 70, 123, 97, 84, 70, 63, 
  71, 87, 85, 86, 76, 63, 78, 85, 73, 81, 
  80, 105, 92, 86, 84, 80, 72, 87, 75, 87, 
  70, 92, 70, 79, 90, 80, 107, 72, 75, 81, 
  77, 72, 85, 94, 71, 80, 82, 82, 70, 82, 
  96, 87, 84, 87, 93, 75, 66, 80, 79, 88, 
  78, 88, 91, 92, 72, 80, 93, 86, 92, 88, 
  77, 85, 84, 87, 79, 93, 88, 84, 101, 69, 
  102, 88, 83, 81, 80, 81, 93, 98, 73, 81, 
  88, 73, 91, 86, 68, 88, 96, 79, 91, 87, 
  91, 70, 77, 81, 90, 81, 63, 75, 79, 78, 
  85, 75, 78, 64, 79, 77, 82, 80, 84, 84, 
  71, 88, 84, 83, 76, 86, 91, 83, 77, 79, 
  108, 85, 71, 110, 80, 91, 73, 72, 78, 87, 
  84, 91, 86, 73, 76, 82, 70, 96, 81, 87, 
  85, 88, 86, 89, 97, 94, 80, 97, 82, 111, 
  87, 82, 86, 87, 87, 76, 77, 84, 86, 92, 
  73, 71, 92, 84, 78, 92, 87, 68, 86, 78, 
  70, 87, 67, 90, 101, 79, 79, 89, 86, 93, 
  91, 83, 97, 96, 79, 64, 77, 92, 106, 89, 
  81, 90, 83, 75, 83, 69, 91, 82, 86, 73, 
  96, 98, 101, 87, 79, 93, 87, 90, 84, 100, 
  98, 81, 85, 76, 80, 98, 83, 86, 93, 79, 
  73, 111, 81, 86, 78, 73, 86, 84, 85, 75, 
  93, 72, 77, 81, 91, 85, 92, 85, 95, 91, 
  78, 84, 93, 77, 96, 81, 70, 76, 78, 80, 
  75, 79, 77, 77, 78, 91, 76, 81, 91, 78, 
  69, 82, 91, 86, 81, 73, 95, 77, 86, 76, 
  90, 97, 88, 73, 82, 86, 82, 71, 84, 78, 
  102, 82, 88, 95, 76, 77, 83, 90, 77, 93, 
  77, 81, 79, 86, 86, 82, 76, 85, 66, 79, 
  78, 89, 104, 82, 79, 97, 63, 82, 86, 76, 
  94, 88, 99, 64, 87, 110, 102, 94, 93, 91, 
  70, 89, 83, 62, 106, 71, 89, 89, 97, 96, 
  80, 79, 85, 82, 86, 88, 79, 100, 102, 78, 
  94, 71, 76, 80, 84, 91, 92, 80, 66, 92, 
  78, 85, 76, 78, 89, 66, 74, 83, 79, 71, 
  76, 81, 83, 85, 85, 87, 87, 86, 75, 85, 
  75, 81, 80, 78, 94, 79, 80, 81, 77, 102, 
  96, 79, 77, 82, 78, 80, 89, 79, 65, 76, 
  85, 89, 82, 69, 90, 103, 94, 81, 95, 88, 
  84, 74, 73, 88, 75, 71, 75, 78, 97, 78, 
  103, 85, 86, 74, 81, 88, 74, 103, 76, 75, 
  81, 84, 76, 80, 93, 90, 75, 84, 82, 80, 
  80, 79, 87, 93, 73, 94, 85, 87, 86, 85, 
  94, 90, 91, 104, 86, 93, 83, 91, 75, 99, 
  91, 83, 113, 75, 81, 89, 87, 85, 86, 88, 
  91, 88, 79, 84, 84, 85, 96, 80, 90, 87, 
  81, 79, 87, 83, 91, 76, 76, 89, 84, 80, 
  80, 89, 76, 72, 85, 80, 81, 73, 85, 72, 
  77, 85, 86, 88, 75, 88, 82, 93, 67, 84, 
  87, 75, 92, 76, 100, 85, 77, 98, 88, 88, 
  83, 81, 81, 82, 93, 81, 84, 81, 75, 91, 
  77, 86, 88, 92, 88, 87, 92, 88, 105, 84, 
  80, 87, 88, 86, 81, 81, 90, 82, 97, 80, 
  99, 83, 74, 79, 89, 88, 69, 86, 91, 80, 
  81, 80, 92, 82, 68, 81, 87, 89, 86, 75, 
  83, 91, 73, 83, 85, 74, 85, 87, 84, 101, 
  88, 92, 72, 80, 79, 91, 73, 84, 92, 81, 
  85, 76, 90, 77, 84, 83, 78, 79, 80, 81, 
  93, 88, 86, 79, 80, 84, 83, 93, 89, 91, 
  90, 80, 96, 88, 87, 87, 98, 93, 75, 87, 
  97, 90, 98, 91, 71, 79, 78, 95, 79, 87, 
  88, 93, 74, 78, 74, 85, 84, 92, 92, 76, 
  82, 100, 74, 85, 88, 91, 91, 87, 71, 82, 
  73, 84, 80, 87, 86, 76, 83, 84, 80, 73, 
  79, 65, 80, 82, 84, 84, 77, 79, 79, 81, 
  103, 79, 84, 88, 92, 94, 95, 89, 83, 86, 
  53, 79, 85, 72, 88, 83, 92, 84, 72, 80, 
  88, 66, 80, 80, 89, 94, 82, 74, 85, 87, 
  72, 85, 88, 90, 88, 83, 80, 78, 88, 79, 
  84, 93, 76, 83, 79, 79, 82, 89, 84, 76, 
  83, 96, 76, 89, 94, 68, 76, 85, 75, 90, 
  95, 80, 88, 88, 99, 86, 87, 79, 83, 74, 
  80, 76, 82, 87, 84, 88, 87, 80, 96, 73, 
  86, 84, 86, 80, 88, 94, 88, 74, 88, 80, 
  85, 67, 79, 65, 79, 77, 88, 82, 75, 91, 
  74, 84, 80, 80, 86, 73, 70, 85, 64, 79, 
  81, 87, 86, 79, 84, 96, 82, 80, 81, 72, 
  89, 82, 67, 78, 73, 76, 81, 89, 95, 82, 
  89, 90, 94, 81, 90, 91, 88, 95, 83, 86, 
  90, 73, 96, 78, 92, 87, 76, 85, 76, 69, 
  93, 82, 92, 93, 84, 81, 81, 83, 74, 78, 
  93, 97, 85, 84, 75, 94, 89, 80, 85, 97, 
  86, 83, 95, 90, 75, 71, 95, 76, 75, 108, 
  78, 91, 97, 74, 81, 83, 70, 98, 88, 87, 
  97, 97, 103, 95, 83, 85, 84, 77, 81, 81, 
  97, 77, 80, 88, 95, 91, 95, 73, 83, 74, 
  93, 82, 97, 86, 99, 75, 92, 80, 80, 81, 
  96, 77, 87, 78, 87, 80, 72, 73, 79, 84, 
  78, 94, 85, 82, 74, 82, 79, 78, 87, 91, 
  90, 84, 86, 98, 86, 79, 82, 80, 90, 80, 
  74, 78, 83, 87, 86, 88, 83, 87, 88, 90, 
  96, 77, 83, 80, 112, 86, 69, 84, 94, 92, 
  67, 71, 76, 83, 85, 86, 81, 114, 59, 77, 
  78, 63, 75, 88, 76, 73, 70, 85, 85, 64, 
  89, 89, 102, 133, 78, 103, 71, 81, 86, 90, 
  129, 82, 116, 57, 94, 85, 77, 61, 94, 64, 
  75, 96, 90, 59, 111, 59, 71, 80, 69, 94, 
  80, 72, 81, 103, 88, 89, 101, 92, 68, 88, 
  93, 103, 95, 93, 68, 96, 96, 85, 66, 76, 
  87, 79, 88, 95, 78, 102, 70, 91, 63, 103, 
  84, 114, 73, 79, 78, 105, 93, 83, 98, 87, 
  92, 95, 85, 92, 81, 124, 81, 93, 89, 85, 
  71, 84, 88, 69, 67, 64, 67, 82, 79, 101, 
  48, 89, 84, 87, 111, 70, 63, 77, 68, 94, 
  91, 92, 95, 93, 63, 78, 77, 125, 89, 80, 
  71, 91, 74, 79, 85, 79, 66, 79, 78, 87, 
  80, 80, 78, 89, 70, 97, 74, 78, 93, 88, 
  88, 108, 84, 89, 87, 86, 80, 87, 105, 69, 
  94, 88, 80, 105, 77, 79, 83, 73, 82, 127, 
  83, 94, 76, 76, 80, 75, 90, 65, 96, 63, 
  78, 94, 88, 78, 66, 68, 47, 87, 78, 93, 
  81, 64, 70, 86, 86, 80, 84, 86, 92, 69, 
  69, 87, 78, 73, 92, 93, 66, 71, 80, 91, 
  60, 80, 81, 81, 86, 74, 88, 69, 90, 73, 
  80, 88, 56, 126, 81, 93, 78, 71, 70, 89, 
  83, 90, 79, 70, 86, 89, 46, 80, 53, 83, 
  83, 85, 107, 89, 88, 84, 73, 75, 85, 124, 
  77, 93, 87, 75, 79, 88, 104, 82, 89, 93, 
  76, 82, 68, 70, 85, 84, 85, 103, 89, 73, 
  80, 99, 72, 83, 84, 95, 89, 88, 77, 79, 
  91, 73, 93, 88, 82, 83, 59, 81, 83, 85, 
  82, 80, 84, 106, 84, 95, 89, 87, 77, 87, 
  69, 103, 90, 81, 102, 83, 92, 88, 78, 89, 
  85, 77, 64, 66, 76, 81, 77, 83, 94, 71, 
  97, 76, 82, 82, 99, 87, 81, 80, 81, 83, 
  92, 78, 91, 80, 86, 73, 85, 79, 88, 79, 
  95, 69, 76, 72, 72, 89, 80, 77, 80, 80, 
  70, 77, 82, 95, 86, 71, 80, 99, 83, 85, 
  85, 87, 93, 83, 56, 69, 73, 85, 82, 90, 
  87, 77, 95, 92, 97, 78, 78, 90, 104, 83, 
  76, 84, 91, 91, 76, 75, 70, 82, 83, 87, 
  88, 118, 62, 80, 75, 72, 80, 79, 74, 88, 
  74, 83, 72, 78, 90, 93, 90, 107, 88, 97, 
  85, 85, 72, 89, 89, 78, 77, 73, 91, 81, 
  85, 74, 80, 77, 74, 99, 90, 73, 100, 87, 
  86, 81, 67, 79, 80, 75, 80, 88, 90, 93, 
  101, 80, 71, 86, 65, 82, 100, 84, 63, 84, 
  90, 83, 65, 77, 87, 83, 85, 81, 83, 92, 
  76, 85, 79, 92, 85, 106, 93, 100, 89, 92, 
  82, 74, 91, 83, 85, 86, 89, 84, 74, 91, 
  78, 93, 82, 83, 92, 86, 81, 83, 80, 73, 
  78, 85, 89, 92, 82, 74, 81, 85, 109, 81, 
  80, 83, 85, 84, 90, 83, 93, 84, 94, 89, 
  73, 83, 90, 83, 84, 89, 80, 84, 88, 97, 
  71, 90, 79, 89, 81, 80, 78, 95, 76, 85, 
  67, 85, 90, 87, 82, 111, 87, 86, 86, 81, 
  71, 68, 104, 83, 66, 88, 85, 89, 76, 97, 
  81, 78, 87, 86, 79, 84, 80, 92, 85, 76, 
  86, 58, 93, 73, 79, 91, 78, 74, 78, 73, 
  63, 90, 71, 81, 85, 80, 42, 73, 83, 85, 
  82, 82, 85, 73, 69, 81, 83, 75, 83, 88, 
  83, 79, 71, 82, 81, 83, 80, 93, 76, 73, 
  81, 77, 87, 66, 79, 82, 72, 69, 79, 91, 
  68, 73, 78, 99, 73, 86, 89, 79, 85, 89, 
  80, 79, 84, 78, 83, 77, 97, 86, 90, 88, 
  88, 70, 87, 97, 83, 92, 97, 84, 81, 82, 
  92, 84, 93, 91, 79, 81, 75, 83, 89, 89, 
  87, 101, 85, 80, 77, 94, 80, 72, 79, 93, 
  82, 87, 74, 92, 89, 77, 90, 90, 79, 84, 
  75, 92, 78, 79, 85, 74, 82, 110, 85, 90, 
  86, 82, 80, 74, 68, 100, 77, 85, 96, 70, 
  95, 94, 85, 90, 79, 84, 66, 72, 91, 78, 
  87, 82, 93, 96, 70, 72, 73, 83, 100, 82, 
  87, 77, 63, 87, 91, 74, 81, 84, 90, 81, 
  77, 80, 82, 81, 84, 98, 76, 77, 78, 92, 
  85, 74, 85, 80, 84, 72, 82, 92, 85, 78, 
  78, 92, 80, 84, 84, 86, 91, 85, 82, 82, 
  84, 88, 85, 74, 77, 86, 88, 91, 99, 78, 
  85, 82, 106, 67, 100, 116, 72, 120, 81, 79, 
  90, 88, 76, 97, 87, 78, 70, 92, 93, 98, 
  121, 109, 77, 122, 71, 69, 83, 73, 81, 116, 
  107, 107, 103, 149, 74, 83, 74, 99, 89, 106, 
  84, 73, 76, 79, 97, 95, 79, 107, 95, 81, 
  87, 83, 84, 88, 81, 75, 101, 90, 87, 93, 
  90, 88, 89, 67, 82, 71, 70, 75, 83, 98, 
  72, 90, 87, 103, 73, 106, 76, 101, 90, 77, 
  91, 69, 75, 82, 71, 64, 86, 76, 79, 110, 
  83, 83, 87, 107, 100, 68, 89, 84, 95, 81, 
  64, 52, 89, 85, 95, 85, 85, 103, 79, 89, 
  74, 111, 79, 96, 64, 80, 93, 78, 84, 106, 
  77, 80, 98, 119, 89, 94, 83, 71, 82, 71, 
  77, 62, 100, 95, 75, 115, 96, 82, 77, 83, 
  72, 83, 97, 81, 79, 84, 73, 83, 80, 84, 
  66, 84, 65, 83, 83, 82, 72, 87, 94, 108, 
  83, 114, 71, 81, 79, 106, 83, 101, 79, 87, 
  74, 76, 98, 82, 82, 93, 87, 90, 76, 98, 
  80, 95, 91, 71, 80, 84, 71, 84, 99, 86, 
  83, 75, 74, 54, 83, 69, 86, 85, 68, 92, 
  76, 100, 80, 87, 75, 94, 84, 72, 89, 90, 
  86, 81, 77, 78, 74, 81, 97, 94, 84, 83, 
  89, 89, 92, 89, 85, 87, 88, 83, 65, 74, 
  80, 81, 83, 82, 84, 96, 78, 75, 73, 86, 
  79, 85, 67, 95, 81, 89, 93, 87, 86, 91, 
  109, 102, 88, 86, 89, 80, 83, 77, 77, 62, 
  84, 79, 83, 91, 95, 84, 79, 73, 87, 82, 
  90, 82, 85, 88, 81, 93, 71, 78, 70, 69, 
  69, 87, 86, 79, 75, 70, 85, 100, 81, 78, 
  79, 80, 87, 91, 85, 93, 87, 83, 76, 88, 
  95, 80, 95, 79, 92, 91, 79, 99, 86, 96, 
  80, 87, 85, 81, 73, 79, 94, 89, 84, 88, 
  76, 64, 84, 88, 89, 80, 80, 90, 83, 87, 
  93, 63, 77, 79, 78, 69, 84, 91, 86, 84, 
  89, 80, 88, 81, 94, 78, 87, 80, 96, 77, 
  75, 91, 79, 93, 89, 89, 66, 95, 83, 81, 
  74, 87, 79, 87, 78, 80, 82, 57, 90, 83, 
  77, 84, 87, 89, 85, 83, 77, 94, 98, 86, 
  74, 77, 86, 90, 82, 83, 93, 80, 105, 106, 
  73, 115, 84, 73, 82, 92, 70, 94, 86, 76, 
  74, 82, 77, 89, 97, 98, 69, 102, 77, 77, 
  84, 76, 85, 102, 83, 103, 80, 128, 72, 79, 
  71, 99, 81, 97, 92, 79, 75, 66, 87, 93, 
  74, 96, 100, 81, 79, 90, 74, 80, 92, 68, 
  82, 83, 83, 90, 87, 85, 88, 70, 73, 77, 
  86, 74, 84, 89, 70, 91, 75, 94, 70, 100, 
  86, 94, 81, 76, 113, 69, 88, 86, 66, 69, 
  80, 92, 82, 101, 82, 85, 86, 91, 89, 76, 
  84, 81, 90, 77, 81, 61, 91, 79, 90, 79, 
  82, 98, 84, 87, 82, 105, 74, 90, 71, 82, 
  78, 86, 83, 100, 78, 78, 101, 101, 91, 92, 
  87, 85, 84, 71, 77, 73, 89, 83, 81, 92, 
  93, 78, 80, 84, 74, 86, 97, 84, 88, 80, 
  72, 76, 59, 76, 63, 81, 66, 85, 87, 85, 
  80, 76, 80, 97, 79, 86, 75, 80, 74, 97, 
  78, 91, 87, 90, 71, 71, 86, 84, 78, 86, 
  99, 91, 78, 98, 84, 83, 95, 66, 71, 80, 
  74, 85, 96, 86, 80, 81, 72, 65, 77, 72, 
  93, 82, 70, 80, 79, 91, 87, 88, 85, 79, 
  79, 73, 92, 94, 93, 89, 77, 76, 74, 88, 
  100, 82, 86, 79, 84, 84, 80, 91, 84, 79, 
  82, 82, 74, 85, 76, 76, 81, 82, 83, 81, 
  83, 81, 79, 80, 75, 81, 78, 86, 81, 93, 
  78, 83, 85, 86, 111, 84, 78, 86, 88, 92, 
  86, 82, 80, 72, 76, 78, 87, 71, 90, 81, 
  86, 75, 94, 86, 93, 89, 89, 81, 85, 88, 
  62, 80, 74, 73, 71, 88, 93, 80, 85, 65, 
  78, 95, 81, 64, 83, 78, 87, 88, 76, 82, 
  94, 79, 70, 89, 84, 85, 97, 81, 92, 93, 
  81, 98, 87, 87, 79, 89, 84, 85, 84, 83, 
  87, 92, 82, 92, 72, 81, 82, 96, 96, 85, 
  85, 86, 81, 82, 100, 66, 82, 70, 78, 71, 
  75, 89, 90, 88, 93, 73, 93, 82, 91, 76, 
  86, 77, 96, 74, 72, 95, 79, 81, 86, 86, 
  79, 101, 77, 82, 76, 87, 77, 81, 88, 85, 
  92, 56, 85, 82, 84, 80, 91, 86, 85, 83, 
  76, 88, 96, 77, 65, 76, 81, 93, 83, 84, 
  94, 81, 83, 92, 76, 113, 82, 77, 87, 80, 
  80, 94, 86, 90, 79, 80, 73, 88, 89, 84, 
  68, 86, 84, 86, 79, 82, 83, 89, 95, 102, 
  77, 113, 76, 78, 72, 89, 90, 88, 93, 96, 
  84, 69, 82, 92, 80, 87, 91, 86, 77, 88, 
  85, 85, 90, 71, 90, 95, 81, 87, 80, 79, 
  84, 77, 75, 82, 85, 77, 95, 83, 72, 87, 
  68, 86, 77, 92, 88, 85, 79, 74, 96, 75, 
  93, 83, 73, 71, 80, 89, 88, 86, 83, 88, 
  85, 95, 78, 82, 77, 80, 96, 82, 81, 76, 
  89, 80, 81, 85, 82, 79, 79, 88, 89, 80, 
  72, 81, 76, 83, 75, 92, 83, 91, 77, 68, 
  103, 83, 85, 86, 90, 98, 84, 81, 82, 72, 
  72, 86, 83, 88, 89, 78, 89, 77, 87, 85, 
  93, 91, 90, 81, 75, 87, 66, 78, 64, 81, 
  70, 83, 84, 83, 79, 72, 84, 92, 82, 85, 
  78, 80, 78, 85, 79, 85, 86, 94, 79, 76, 
  87, 93, 80, 79, 90, 89, 80, 91, 90, 90, 
  84, 78, 83, 87, 77, 86, 88, 87, 85, 84, 
  75, 76, 90, 85, 96, 80, 75, 83, 81, 86, 
  87, 75, 84, 72, 77, 73, 74, 91, 92, 90, 
  84, 71, 84, 82, 95, 73, 84, 80, 90, 88, 
  74, 90, 77, 78, 86, 88, 77, 94, 78, 83, 
  81, 85, 80, 74, 81, 83, 88, 65, 75, 79, 
  82, 81, 86, 88, 76, 87, 83, 76, 106, 76, 
  65, 83, 83, 93, 87, 91, 80, 75, 73, 84, 
  86, 80, 82, 83, 87, 74, 95, 87, 87, 91, 
  82, 84, 78, 95, 71, 81, 75, 74, 79, 81, 
  94, 69, 86, 69, 78, 95, 83, 72, 82, 77, 
  84, 85, 80, 82, 93, 79, 81, 91, 82, 88, 
  94, 83, 95, 97, 80, 92, 86, 91, 71, 97, 
  86, 87, 83, 84, 83, 86, 87, 91, 81, 86, 
  87, 96, 89, 82, 82, 84, 78, 83, 97, 56, 
  81, 69, 79, 69, 70, 80, 87, 90, 95, 70, 
  93, 75, 90, 73, 82, 77, 98, 76, 71, 89, 
  76, 78, 89, 85, 81, 101, 82, 92, 82, 85, 
  79, 77, 81, 86, 99, 57, 78, 78, 81, 80, 
  91, 91, 94, 78, 76, 85, 98, 74, 70, 72, 
  78, 91, 87, 90, 79, 86, 84, 83, 71, 91, 
  92, 66, 83, 65, 70, 72, 87, 85, 80, 68, 
  79, 86, 70, 85, 84, 89, 86, 102, 71, 82, 
  82, 87, 89, 86, 91, 81, 87, 74, 71, 80, 
  73, 113, 85, 83, 80, 69, 92, 87, 71, 77, 
  76, 83, 87, 83, 83, 96, 92, 96, 91, 75, 
  79, 87, 85, 84, 104, 83, 86, 76, 71, 81, 
  89, 91, 80, 71, 66, 83, 79, 86, 69, 80, 
  77, 79, 80, 66, 93, 80, 83, 86, 90, 81, 
  75, 86, 99, 86, 66, 73, 85, 102, 71, 100, 
  90, 83, 82, 81, 70, 82, 81, 79, 104, 88, 
  70, 91, 78, 72, 79, 76, 83, 95, 93, 92, 
  105, 98, 70, 97, 96, 78, 77, 67, 89, 71, 
  77, 119, 76, 97, 72, 86, 73, 67, 84, 73, 
  81, 63, 74, 71, 91, 85, 81, 70, 85, 92, 
  62, 102, 90, 84, 72, 95, 70, 83, 85, 86, 
  94, 66, 86, 85, 88, 73, 76, 62, 75, 125, 
  87, 81, 85, 69, 84, 90, 75, 74, 85, 72, 
  88, 81, 82, 90, 100, 98, 87, 86, 74, 95, 
  86, 91, 102, 77, 92, 84, 57, 88, 93, 93, 
  79, 61, 80, 78, 76, 86, 68, 73, 80, 70, 
  85, 63, 94, 80, 88, 79, 86, 70, 82, 79, 
  116, 81, 69, 82, 78, 107, 63, 96, 91, 94, 
  82, 77, 73, 87, 87, 84, 96, 94, 73, 91, 
  70, 73, 75, 76, 83, 77, 89, 84, 78, 93, 
  61, 96, 90, 76, 74, 68, 88, 78, 73, 128, 
  74, 100, 70, 73, 78, 88, 91, 74, 83, 66, 
  70, 85, 92, 79, 84, 76, 81, 82, 72, 99, 
  89, 86, 87, 103, 67, 87, 88, 83, 79, 61, 
  87, 84, 85, 72, 85, 79, 84, 108, 82, 79, 
  80, 65, 81, 86, 81, 81, 81, 84, 95, 80, 
  78, 83, 89, 98, 93, 84, 78, 90, 88, 83, 
  97, 83, 82, 74, 82, 82, 87, 87, 83, 65, 
  107, 85, 95, 82, 74, 77, 80, 85, 85, 71, 
  97, 75, 82, 84, 82, 74, 94, 85, 93, 91, 
  68, 81, 86, 103, 82, 103, 94, 76, 80, 81, 
  73, 89, 84, 81, 101, 87, 74, 90, 84, 75, 
  78, 77, 86, 75, 71, 87, 70, 99, 78, 96, 
  89, 85, 78, 72, 88, 77, 77, 106, 89, 88, 
  76, 103, 83, 95, 83, 71, 85, 79, 66, 79, 
  82, 85, 76, 77, 89, 82, 87, 70, 94, 89, 
  74, 98, 85, 85, 85, 86, 87, 74, 98, 77, 
  77, 83, 61, 81, 73, 127, 89, 84, 89, 73, 
  82, 84, 70, 83, 74, 83, 79, 76, 100, 82, 
  86, 95, 97, 83, 82, 82, 89, 90, 106, 67, 
  69, 70, 60, 92, 83, 89, 88, 55, 75, 90, 
  77, 93, 71, 85, 91, 117, 68, 68, 89, 89, 
  94, 73, 93, 81, 85, 85, 89, 79, 65, 76, 
  85, 114, 70, 88, 86, 88, 91, 79, 66, 84, 
  69, 81, 75, 110, 91, 80, 78, 65, 75, 77, 
  79, 89, 79, 95, 101, 86, 76, 80, 83, 63, 
  85, 64, 85, 80, 81, 95, 87, 94, 73, 106, 
  81, 76, 76, 79, 75, 71, 66, 81, 79, 87, 
  72, 69, 91, 93, 85, 78, 85, 85, 76, 85, 
  91, 89, 80, 76, 91, 66, 100, 86, 74, 87, 
  66, 69, 72, 104, 88, 74, 91, 65, 84, 87, 
  75, 83, 76, 88, 75, 64, 102, 80, 83, 97, 
  99, 88, 93, 81, 105, 85, 110, 76, 82, 78, 
  59, 98, 80, 98, 88, 56, 64, 80, 77, 81, 
  58, 83, 93, 98, 71, 55, 86, 86, 100, 80, 
  96, 79, 88, 78, 81, 68, 67, 76, 79, 117, 
  70, 92, 82, 107, 79, 74, 68, 96, 67, 86, 
  64, 126, 106, 75, 63, 61, 70, 72, 78, 91, 
  78, 100, 84, 77, 69, 81, 82, 66, 75, 64, 
  77, 86, 70, 100, 85, 95, 81, 95, 82, 86, 
  77, 73, 87, 80, 68, 83, 88, 80, 81, 82, 
  89, 82, 90, 78, 77, 91, 88, 98, 82, 81, 
  87, 89, 81, 61, 93, 87, 78, 84, 80, 83, 
  74, 122, 82, 84, 90, 70, 90, 84, 75, 77, 
  83, 103, 85, 76, 89, 80, 89, 93, 92, 86, 
  81, 84, 91, 85, 99, 75, 68, 67, 77, 89, 
  81, 83, 92, 53, 85, 89, 82, 88, 69, 77, 
  88, 83, 76, 71, 92, 86, 91, 90, 87, 85, 
  84, 80, 88, 86, 65, 71, 84, 118, 68, 91, 
  87, 84, 77, 72, 70, 83, 74, 84, 80, 103, 
  89, 84, 76, 72, 74, 81, 83, 94, 73, 83, 
  79, 90, 87, 83, 86, 73, 84, 65, 83, 85, 
  80, 94, 88, 100, 74, 93, 84, 93, 75, 82, 
  81, 92, 69, 88, 78, 81, 72, 79, 93, 71, 
  92, 71, 90, 97, 66, 79, 87, 79, 102, 86, 
  88, 78, 95, 72, 76, 83, 75, 95, 95, 101, 
  93, 90, 92, 70, 68, 87, 78, 82, 84, 88, 
  76, 80, 93, 82, 88, 94, 86, 89, 89, 66, 
  82, 76, 90, 67, 84, 75, 64, 80, 84, 93, 
  106, 78, 97, 93, 94, 81, 69, 90, 95, 108, 
  79, 67, 89, 88, 105, 79, 95, 85, 103, 76, 
  72, 88, 79, 89, 94, 91, 79, 72, 83, 76, 
  87, 72, 75, 93, 83, 80, 58, 94, 98, 80, 
  87, 78, 74, 95, 97, 81, 86, 85, 93, 81, 
  93, 75, 89, 75, 94, 79, 101, 82, 73, 75, 
  82, 91, 81, 94, 80, 89, 69, 86, 70, 82, 
  71, 92, 72, 90, 65, 66, 85, 81, 90, 71, 
  81, 85, 80, 68, 95, 79, 97, 76, 98, 87, 
  106, 77, 79, 89, 79, 86, 95, 64, 77, 72, 
  96, 61, 79, 96, 90, 88, 86, 97, 76, 73, 
  84, 75, 80, 94, 89, 83, 95, 68, 103, 73, 
  94, 77, 97, 79, 73, 86, 83, 109, 103, 77, 
  76, 89, 90, 74, 58, 90, 93, 102, 78, 57, 
  91, 86, 115, 87, 101, 90, 96, 77, 59, 79, 
  82, 87, 95, 85, 85, 78, 72, 88, 80, 69, 
  80, 93, 74, 81, 55, 102, 120, 78, 77, 75, 
  76, 92, 94, 104, 90, 95, 102, 70, 88, 80, 
  95, 74, 83, 89, 98, 83, 67, 74, 93, 87, 
  95, 95, 83, 70, 71, 77, 84, 87, 71, 86, 
  84, 91, 83, 78, 99, 72, 93, 71, 64, 97, 
  87, 82, 88, 79, 96, 88, 82, 81, 95, 83, 
  81, 85, 79, 86, 88, 97, 74, 91, 86, 74, 
  87, 90, 76, 80, 93, 98, 80, 83, 84, 76, 
  89, 90, 88, 81, 81, 74, 86, 77, 93, 78, 
  87, 75, 75, 76, 88, 88, 104, 80, 78, 91, 
  85, 84, 65, 85, 93, 82, 80, 70, 92, 87, 
  98, 94, 93, 99, 75, 75, 71, 82, 78, 77, 
  88, 96, 81, 78, 86, 81, 72, 60, 72, 79, 
  85, 81, 66, 97, 90, 82, 81, 85, 80, 94, 
  97, 118, 83, 88, 100, 88, 94, 81, 95, 81, 
  93, 78, 100, 82, 79, 80, 82, 96, 88, 69, 
  87, 76, 87, 74, 68, 72, 72, 87, 88, 82, 
  85, 75, 90, 79, 72, 81, 71, 83, 87, 96, 
  59, 92, 82, 71, 80, 83, 89, 81, 79, 73, 
  92, 72, 79, 83, 85, 93, 76, 84, 75, 73, 
  89, 73, 80, 92, 83, 92, 81, 94, 84, 79, 
  83, 88, 80, 80, 83, 82, 83, 90, 81, 60, 
  81, 70, 82, 80, 80, 84, 79, 91, 86, 78, 
  97, 66, 77, 90, 108, 95, 86, 76, 84, 79, 
  87, 70, 89, 94, 84, 91, 88, 69, 78, 98, 
  79, 81, 89, 89, 100, 85, 84, 84, 77, 89, 
  88, 76, 81, 84, 91, 71, 88, 82, 74, 94, 
  83, 86, 83, 91, 75, 86, 71, 80, 70, 84, 
  88, 100, 85, 89, 79, 114, 81, 87, 81, 75, 
  94, 79, 74, 82, 69, 90, 92, 81, 79, 78, 
  76, 75, 74, 87, 74, 76, 105, 100, 63, 88, 
  87, 77, 106, 83, 80, 81, 69, 81, 103, 88, 
  87, 87, 76, 91, 72, 69, 67, 76, 75, 88, 
  86, 79, 76, 85, 86, 89, 97, 67, 82, 97, 
  73, 74, 99, 80, 78, 76, 80, 56, 67, 47, 
  69, 71, 72, 86, 114, 95, 77, 86, 97, 77, 
  77, 108, 120, 84, 82, 80, 78, 83, 72, 69, 
  104, 97, 84, 97, 77, 82, 89, 99, 106, 74, 
  85, 85, 114, 68, 83, 76, 70, 91, 90, 91, 
  84, 76, 85, 85, 80, 94, 68, 99, 81, 85, 
  70, 84, 78, 79, 72, 92, 78, 83, 93, 94, 
  84, 82, 95, 99, 82, 111, 83, 74, 82, 85, 
  87, 88, 86, 99, 82, 94, 67, 78, 85, 81, 
  123, 90, 95, 110, 112, 83, 68, 75, 97, 97, 
  124, 87, 83, 110, 72, 91, 75, 82, 81, 94, 
  78, 76, 74, 61, 74, 101, 70, 100, 86, 71, 
  73, 75, 89, 86, 96, 71, 107, 87, 96, 74, 
  91, 85, 80, 75, 83, 59, 59, 54, 66, 90, 
  83, 82, 122, 86, 79, 95, 80, 92, 80, 115, 
  119, 70, 78, 81, 71, 90, 75, 80, 95, 102, 
  70, 103, 67, 81, 86, 77, 126, 71, 88, 80, 
  114, 60, 92, 79, 82, 95, 89, 102, 90, 76, 
  84, 95, 80, 112, 66, 90, 86, 77, 77, 85, 
  82, 70, 85, 96, 77, 94, 94, 82, 79, 74, 
  86, 71, 89, 78, 80, 82, 83, 73, 79, 71, 
  85, 87, 88, 89, 88, 77, 89, 87, 74, 83, 
  83, 89, 74, 86, 75, 83, 84, 68, 79, 85, 
  96, 82, 90, 74, 90, 72, 82, 81, 87, 76, 
  76, 97, 82, 83, 96, 67, 79, 90, 87, 97, 
  87, 90, 82, 93, 89, 80, 89, 85, 76, 92, 
  88, 92, 79, 86, 87, 96, 86, 89, 92, 81, 
  79, 91, 86, 74, 83, 70, 84, 84, 71, 88, 
  89, 83, 96, 88, 95, 76, 83, 81, 82, 80, 
  91, 65, 77, 88, 78, 84, 87, 89, 87, 99, 
  85, 94, 84, 85, 76, 78, 81, 92, 94, 59, 
  98, 79, 82, 92, 88, 86, 85, 96, 76, 85, 
  71, 80, 60, 86, 81, 80, 85, 100, 81, 95, 
  76, 78, 82, 80, 91, 71, 83, 70, 76, 90, 
  87, 87, 90, 77, 83, 78, 67, 77, 78, 78, 
  73, 95, 72, 95, 77, 67, 86, 82, 88, 82, 
  88, 83, 96, 72, 83, 85, 72, 89, 69, 71, 
  77, 81, 84, 77, 82, 78, 86, 92, 91, 87, 
  90, 81, 73, 82, 79, 81, 86, 89, 85, 82, 
  76, 76, 67, 76, 86, 82, 85, 77, 82, 88, 
  79, 82, 96, 73, 79, 88, 95, 91, 90, 86, 
  87, 78, 82, 74, 93, 82, 88, 92, 81, 76, 
  84, 102, 86, 86, 86, 91, 100, 90, 82, 83, 
  79, 90, 85, 75, 80, 90, 86, 67, 85, 81, 
  81, 96, 86, 87, 70, 98, 76, 83, 75, 75, 
  68, 81, 80, 91, 87, 92, 85, 104, 77, 94, 
  79, 69, 89, 71, 79, 86, 74, 94, 87, 91, 
  76, 75, 75, 77, 87, 77, 77, 91, 100, 91, 
  70, 87, 94, 85, 91, 86, 86, 90, 72, 87, 
  88, 77, 85, 85, 73, 85, 71, 57, 72, 83, 
  68, 78, 90, 71, 81, 90, 80, 85, 96, 72, 
  77, 81, 79, 80, 84, 85, 86, 82, 77, 76, 
  75, 66, 82, 80, 76, 82, 112, 80, 73, 94, 
  92, 81, 78, 111, 132, 64, 90, 84, 73, 76, 
  78, 83, 82, 90, 83, 89, 73, 79, 89, 91, 
  109, 83, 86, 76, 104, 64, 82, 71, 91, 91, 
  89, 83, 79, 82, 90, 80, 83, 92, 75, 94, 
  90, 72, 79, 90, 80, 77, 81, 85, 76, 84, 
  85, 90, 84, 77, 85, 76, 90, 84, 82, 77, 
  79, 79, 83, 81, 87, 90, 83, 81, 75, 82, 
  74, 98, 79, 88, 78, 85, 89, 83, 77, 67, 
  95, 79, 82, 87, 92, 79, 92, 76, 89, 74, 
  83, 84, 89, 74, 91, 92, 90, 82, 90, 72, 
  87, 83, 82, 96, 92, 88, 82, 94, 94, 79, 
  93, 87, 78, 93, 88, 90, 82, 89, 95, 95, 
  85, 87, 85, 89, 74, 89, 86, 72, 86, 73, 
  81, 89, 83, 74, 85, 87, 98, 96, 91, 80, 
  78, 81, 83, 88, 102, 70, 80, 80, 77, 85, 
  83, 80, 84, 93, 97, 95, 85, 83, 81, 81, 
  83, 88, 101, 65, 92, 84, 81, 95, 87, 82, 
  91, 89, 77, 90, 77, 76, 67, 79, 86, 80, 
  90, 95, 88, 86, 81, 84, 85, 80, 88, 73, 
  88, 73, 85, 91, 92, 89, 93, 78, 82, 94, 
  73, 85, 74, 84, 77, 87, 77, 77, 79, 72, 
  77, 89, 92, 82, 91, 85, 91, 71, 82, 84, 
  82, 86, 82, 92, 93, 84, 86, 72, 85, 78, 
  80, 97, 97, 92, 87, 88, 85, 82, 85, 87, 
  81, 91, 90, 83, 77, 90, 77, 93, 85, 81, 
  90, 83, 78, 91, 81, 71, 87, 68, 81, 78, 
  83, 90, 88, 84, 96, 83, 89, 75, 88, 81, 
  84, 90, 88, 75, 80, 91, 78, 85, 86, 94, 
  87, 98, 87, 94, 82, 90, 78, 79, 78, 93, 
  95, 67, 84, 82, 79, 96, 85, 84, 77, 99, 
  80, 82, 78, 74, 65, 75, 78, 86, 89, 96, 
  79, 100, 79, 89, 80, 74, 90, 70, 88, 76, 
  82, 97, 86, 92, 87, 72, 78, 90, 82, 76, 
  70, 78, 107, 85, 73, 86, 78, 80, 80, 78, 
  86, 85, 77, 83, 89, 76, 84, 79, 75, 91, 
  78, 67, 83, 86, 71, 85, 88, 76, 82, 92, 
  89, 83, 87, 81, 81, 82, 80, 95, 79, 86, 
  93, 91, 73, 82, 90, 74, 92, 80, 85, 79, 
  104, 79, 76, 85, 90, 71, 77, 102, 111, 77, 
  91, 85, 84, 85, 79, 80, 82, 84, 88, 89, 
  78, 75, 86, 93, 91, 83, 88, 89, 93, 80, 
  82, 83, 87, 93, 76, 85, 75, 90, 89, 75, 
  82, 86, 76, 96, 83, 81, 78, 91, 74, 74, 
  81, 76, 72, 80, 79, 95, 86, 90, 71, 82, 
  76, 72, 90, 103, 69, 97, 70, 83, 70, 96, 
  76, 84, 89, 66, 95, 91, 89, 75, 93, 74, 
  67, 90, 71, 104, 72, 83, 98, 93, 82, 79, 
  75, 91, 88, 84, 86, 80, 90, 96, 73, 87, 
  65, 77, 96, 81, 69, 79, 75, 83, 83, 92, 
  92, 95, 86, 81, 81, 90, 82, 81, 86, 80, 
  69, 85, 105, 79, 90, 81, 69, 84, 77, 76, 
  91, 81, 83, 76, 75, 78, 92, 91, 83, 79, 
  80, 89, 85, 80, 81, 106, 99, 73, 75, 78, 
  60, 80, 93, 82, 91, 89, 76, 76, 85, 81, 
  76, 86, 92, 94, 101, 76, 88, 102, 98, 81, 
  78, 87, 73, 79, 88, 82, 76, 87, 84, 88, 
  96, 73, 76, 85, 74, 91, 74, 85, 75, 67, 
  89, 88, 73, 106, 69, 80, 65, 93, 76, 85, 
  84, 66, 92, 89, 84, 78, 76, 73, 79, 92, 
  72, 104, 77, 85, 95, 91, 83, 73, 78, 81, 
  91, 84, 85, 82, 93, 92, 71, 87, 90, 72, 
  108, 81, 63, 83, 79, 85, 86, 85, 85, 97, 
  79, 83, 79, 85, 78, 81, 84, 82, 72, 79, 
  97, 80, 87, 79, 66, 82, 78, 76, 93, 85, 
  82, 77, 73, 88, 96, 93, 81, 86, 77, 79, 
  83, 85, 81, 108, 103, 69, 75, 76, 60, 81, 
  92, 81, 96, 92, 69, 75, 84, 74, 77, 86, 
  89, 87, 103, 77, 92, 108, 113, 80, 84, 84, 
  66, 75, 74, 83, 76, 91, 83, 92, 77, 73, 
  70, 87, 75, 98, 76, 99, 80, 71, 89, 78, 
  77, 95, 76, 81, 68, 92, 75, 88, 91, 65, 
  91, 87, 86, 88, 63, 75, 90, 93, 82, 97, 
  73, 82, 91, 85, 79, 74, 80, 76, 86, 81, 
  85, 81, 89, 90, 72, 81, 98, 80, 90, 82, 
  71, 85, 74, 87, 81, 83, 83, 95, 90, 86, 
  81, 92, 82, 79, 82, 89, 73, 87, 111, 77, 
  92, 80, 71, 83, 91, 79, 99, 80, 90, 80, 
  76, 91, 96, 93, 83, 79, 75, 75, 86, 84, 
  82, 106, 94, 70, 80, 77, 62, 79, 96, 84, 
  88, 86, 73, 81, 81, 76, 78, 84, 90, 94, 
  98, 78, 89, 96, 97, 79, 74, 79, 68, 81, 
  78, 77, 79, 89, 88, 82, 87, 74, 78, 83, 
  78, 90, 69, 85, 72, 79, 91, 96, 71, 99, 
  64, 76, 74, 96, 81, 95, 89, 80, 103, 84, 
  84, 76, 86, 75, 66, 93, 72, 93, 77, 82, 
  98, 92, 86, 75, 70, 96, 86, 84, 90, 82, 
  92, 103, 77, 83, 54, 77, 95, 84, 76, 80, 
  77, 84, 80, 86, 100, 92, 79, 83, 79, 87, 
  75, 82, 91, 77, 70, 95, 92, 82, 104, 73, 
  79, 78, 77, 74, 82, 71, 85, 73, 78, 80, 
  89, 85, 85, 78, 76, 82, 90, 87, 87, 101, 
  99, 78, 69, 87, 67, 79, 90, 74, 92, 93, 
  83, 76, 84, 78, 79, 89, 99, 79, 89, 76, 
  81, 103, 91, 76, 81, 87, 76, 74, 86, 79, 
  77, 78, 87, 95, 84, 74, 66, 90, 73, 94, 
  73, 91, 77, 78, 93, 82, 72, 113, 61, 72, 
  69, 96, 86, 91, 82, 77, 101, 82, 81, 75, 
  63, 74, 74, 94, 77, 96, 82, 84, 101, 85, 
  93, 72, 67, 90, 93, 82, 89, 82, 98, 113, 
  72, 86, 68, 71, 97, 81, 76, 84, 83, 86, 
  84, 81, 92, 93, 72, 81, 77, 81, 72, 90, 
  90, 77, 66, 92, 84, 90, 104, 71, 76, 75, 
  74, 76, 81, 70, 89, 72, 76, 89, 92, 87, 
  79, 90, 74, 77, 97, 90, 89, 104, 107, 74, 
  64, 81, 68, 79, 87, 72, 100, 98, 75, 72, 
  84, 79, 79, 90, 98, 73, 86, 74, 87, 107, 
  103, 76, 87, 91, 72, 69, 73, 81, 76, 72, 
  87, 100, 63, 72, 56, 92, 72, 99, 72, 103, 
  85, 80, 91, 72, 72, 97, 69, 77, 71, 93, 
  77, 87, 89, 82, 96, 82, 81, 86, 60, 76, 
  88, 96, 85, 95, 79, 81, 89, 75, 87, 72, 
  73, 82, 90, 79, 90, 83, 95, 94, 79, 81, 
  91, 80, 87, 85, 82, 85, 76, 84, 79, 80, 
  88, 90, 83, 78, 81, 89, 79, 78, 88, 88, 
  72, 96, 95, 79, 97, 74, 76, 80, 86, 72, 
  87, 71, 88, 78, 77, 90, 94, 86, 84, 79, 
  76, 75, 91, 86, 87, 100, 95, 77, 72, 83, 
  69, 79, 92, 78, 89, 89, 73, 82, 81, 79, 
  82, 87, 92, 79, 85, 77, 82, 93, 94, 76, 
  80, 88, 75, 75, 79, 75, 78, 80, 92, 86, 
  78, 76, 71, 86, 77, 90, 70, 87, 74, 83, 
  85, 98, 72, 99, 73, 78, 76, 90, 80, 98, 
  96, 88, 113, 92, 84, 76, 81, 78, 68, 95, 
  77, 89, 81, 84, 92, 85, 81, 75, 65, 91, 
  80, 85, 89, 90, 93, 102, 85, 83, 68, 85, 
  83, 83, 83, 83, 73, 87, 82, 88, 97, 96, 
  89, 91, 81, 84, 82, 82, 83, 81, 77, 90, 
  94, 74, 102, 71, 91, 85, 88, 81, 83, 69, 
  87, 73, 79, 80, 81, 80, 91, 77, 79, 83, 
  92, 88, 89, 91, 94, 87, 75, 99, 64, 80, 
  80, 74, 88, 80, 88, 84, 85, 78, 79, 90, 
  92, 75, 90, 80, 83, 96, 87, 77, 81, 90, 
  73, 70, 86, 73, 77, 74, 81, 86, 101, 71, 
  70, 78, 73, 90, 70, 89, 85, 84, 88, 83, 
  70, 104, 69, 78, 72, 87, 82, 96, 92, 86, 
  109, 87, 80, 73, 71, 77, 78, 101, 81, 86, 
  86, 89, 85, 78, 86, 72, 65, 85, 87, 78, 
  90, 93, 101, 106, 84, 89, 65, 80, 80, 79, 
  87, 83, 79, 86, 82, 83, 92, 90, 82, 84, 
  77, 77, 78, 84, 85, 82, 72, 92, 84, 76, 
  106, 68, 92, 86, 79, 80, 84, 68, 93, 72, 
  78, 87, 80, 87, 82, 83, 79, 78, 96, 90, 
  91, 92, 98, 85, 72, 92, 64, 84, 75, 73, 
  91, 84, 76, 87, 84, 78, 81, 90, 94, 68, 
  85, 76, 83, 98, 89, 78, 89, 89, 73, 67, 
  79, 76, 78, 67, 85, 83, 85, 71, 63, 77, 
  72, 91, 71, 95, 97, 84, 82, 70, 75, 98, 
  74, 81, 77, 90, 75, 90, 97, 89, 105, 89, 
  83, 83, 78, 80, 95, 97, 84, 93, 85, 86, 
  81, 70, 86, 70, 68, 78, 85, 72, 85, 91, 
  98, 96, 91, 86, 75, 85, 79, 82, 89, 85, 
  74, 87, 79, 85, 91, 87, 92, 77, 81, 84, 
  85, 81, 84, 89, 78, 96, 96, 75, 102, 71, 
  85, 94, 83, 77, 88, 75, 88, 75, 80, 93, 
  85, 83, 91, 77, 79, 81, 93, 87, 91, 91, 
  93, 82, 75, 88, 66, 81, 82, 79, 84, 81, 
  71, 88, 83, 74, 81, 88, 87, 72, 88, 79, 
  83, 88, 92, 78, 84, 88, 80, 75, 87, 71, 
  79, 81, 93, 79, 92, 72, 74, 78, 74, 87, 
  78, 78, 94, 93, 75, 82, 107, 67, 73, 93, 
  85, 67, 79, 96, 81, 87, 81, 83, 81, 87, 
  72, 94, 80, 78, 92, 75, 90, 95, 95, 94, 
  93, 77, 91, 88, 82, 93, 90, 88, 84, 87, 
  89, 80, 81, 85, 93, 88, 86, 88, 68, 73, 
  76, 93, 104, 71, 98, 84, 90, 83, 87, 93, 
  77, 78, 84, 78, 95, 84, 80, 80, 79, 92, 
  72, 84, 74, 78, 87, 80, 70, 99, 92, 88, 
  98, 68, 94, 73, 85, 93, 88, 80, 88, 102, 
  61, 86, 69, 86, 78, 92, 86, 82, 80, 100, 
  74, 88, 86, 70, 78, 79, 107, 74, 87, 64, 
  77, 94, 84, 94, 81, 85, 88, 87, 98, 68, 
  128, 77, 91, 87, 56, 76, 82, 81, 74, 89, 
  82, 101, 51, 85, 118, 60, 65, 94, 81, 60, 
  82, 77, 79, 97, 85, 99, 78, 89, 82, 70, 
  79, 76, 93, 77, 102, 95, 107, 97, 92, 74, 
  96, 84, 88, 79, 85, 96, 78, 81, 83, 82, 
  82, 83, 86, 97, 87, 90, 57, 64, 75, 73, 
  129, 70, 85, 83, 87, 78, 83, 92, 85, 74, 
  82, 82, 93, 82, 84, 74, 78, 84, 82, 72, 
  62, 70, 81, 70, 70, 88, 92, 81, 106, 61, 
  100, 84, 86, 82, 95, 65, 97, 102, 67, 80, 
  68, 81, 67, 91, 87, 72, 87, 81, 60, 80, 
  96, 70, 63, 82, 116, 70, 92, 69, 79, 101, 
  82, 89, 83, 85, 86, 85, 94, 65, 94, 68, 
  92, 83, 44, 83, 81, 75, 78, 90, 72, 95, 
  80, 89, 97, 73, 73, 89, 83, 72, 85, 75, 
  80, 86, 89, 77, 80, 78, 80, 95, 93, 77, 
  83, 79, 89, 94, 85, 88, 92, 82, 84, 95, 
  94, 82, 97, 90, 85, 90, 83, 81, 75, 89, 
  92, 94, 74, 90, 70, 79, 78, 89, 90, 72, 
  94, 89, 81, 84, 93, 93, 82, 80, 92, 69, 
  93, 82, 91, 88, 82, 82, 87, 84, 68, 78, 
  78, 83, 74, 78, 102, 92, 98, 77, 97, 113, 
  77, 87, 95, 81, 97, 107, 64, 88, 66, 88, 
  94, 88, 82, 90, 78, 101, 77, 81, 84, 69, 
  84, 80, 97, 75, 92, 71, 83, 89, 86, 90, 
  82, 88, 88, 86, 98, 81, 73, 87, 88, 78, 
  68, 89, 84, 88, 88, 75, 86, 87, 76, 86, 
  107, 74, 78, 89, 86, 74, 85, 77, 80, 96, 
  99, 97, 73, 85, 75, 89, 82, 76, 78, 69, 
  93, 94, 101, 88, 94, 82, 89, 82, 78, 92, 
  78, 84, 85, 89, 80, 75, 83, 86, 77, 89, 
  90, 87, 67, 77, 76, 79, 104, 76, 91, 90, 
  87, 77, 88, 101, 69, 73, 80, 77, 88, 71, 
  88, 86, 79, 70, 85, 74, 94, 83, 89, 67, 
  74, 92, 87, 89, 99, 66, 88, 68, 86, 86, 
  84, 86, 87, 81, 64, 84, 74, 85, 67, 82, 
  82, 77, 96, 83, 61, 78, 78, 70, 81, 74, 
  104, 82, 79, 82, 74, 98, 82, 92, 76, 79, 
  94, 87, 91, 64, 119, 85, 102, 81, 53, 83, 
  79, 82, 81, 87, 81, 93, 52, 81, 120, 67, 
  65, 95, 80, 67, 82, 69, 81, 109, 105, 117, 
  68, 89, 79, 67, 77, 78, 88, 67, 105, 96, 
  111, 86, 93, 76, 89, 77, 77, 75, 67, 79, 
  70, 76, 86, 75, 87, 84, 70, 97, 92, 82, 
  57, 68, 71, 62, 121, 76, 74, 79, 83, 70, 
  79, 98, 79, 69, 75, 82, 80, 67, 94, 84, 
  85, 62, 75, 64, 84, 81, 86, 58, 73, 87, 
  90, 78, 104, 55, 95, 75, 90, 76, 92, 72, 
  90, 74, 73, 84, 74, 88, 54, 82, 80, 71, 
  88, 70, 47, 75, 87, 71, 80, 71, 111, 80, 
  78, 80, 73, 105, 81, 88, 77, 76, 80, 82, 
  88, 62, 72, 80, 87, 80, 37, 89, 82, 77, 
  83, 98, 75, 88, 83, 90, 93, 73, 77, 84, 
  83, 80, 89, 84, 77, 95, 98, 85, 74, 73, 
  81, 96, 89, 78, 89, 74, 92, 98, 95, 79, 
  92, 84, 84, 86, 85, 85, 79, 83, 81, 87, 
  81, 77, 86, 87, 77, 92, 80, 86, 73, 77, 
  75, 86, 87, 77, 84, 76, 85, 82, 91, 97, 
  74, 73, 80, 71, 87, 76, 99, 89, 86, 66, 
  80, 78, 84, 82, 81, 74, 76, 85, 94, 89, 
  98, 76, 93, 111, 79, 80, 90, 91, 93, 93, 
  67, 81, 75, 88, 83, 79, 80, 86, 76, 88, 
  68, 78, 76, 69, 87, 73, 96, 82, 82, 83, 
  78, 92, 82, 87, 80, 82, 91, 84, 91, 73, 
  63, 92, 91, 76, 65, 87, 83, 85, 101, 76, 
  74, 84, 92, 85, 89, 83, 82, 82, 91, 84, 
  83, 88, 79, 90, 99, 80, 72, 87, 84, 88, 
  83, 81, 75, 71, 89, 86, 82, 88, 90, 86, 
  68, 80, 81, 92, 80, 79, 91, 89, 80, 73, 
  76, 94, 77, 83, 78, 95, 74, 93, 77, 85, 
  76, 86, 98, 87, 78, 90, 95, 89, 58, 85, 
  88, 86, 90, 77, 88, 91, 82, 82, 88, 89, 
  109, 89, 92, 76, 83, 82, 80, 91, 91, 99, 
  83, 75, 86, 85, 78, 105, 94, 73, 63, 92, 
  84, 87, 74, 88, 81, 89, 83, 95, 58, 95, 
  73, 67, 90, 85, 84, 83, 76, 78, 82, 82, 
  88, 92, 82, 86, 90, 94, 90, 73, 104, 100, 
  94, 83, 74, 87, 75, 84, 99, 87, 73, 88, 
  81, 79, 97, 82, 81, 85, 92, 81, 82, 86, 
  87, 97, 104, 86, 73, 85, 76, 84, 83, 83, 
  89, 70, 90, 86, 96, 85, 82, 83, 65, 77, 
  79, 83, 77, 79, 83, 90, 87, 69, 81, 96, 
  71, 89, 80, 79, 66, 90, 74, 85, 83, 83, 
  97, 81, 75, 94, 91, 83, 63, 88, 88, 90, 
  85, 79, 92, 92, 81, 87, 81, 87, 100, 91, 
  92, 73, 82, 86, 83, 84, 94, 88, 83, 91, 
  87, 78, 80, 101, 100, 71, 68, 90, 80, 84, 
  66, 87, 78, 87, 78, 89, 54, 95, 78, 66, 
  93, 80, 85, 84, 78, 76, 86, 84, 88, 79, 
  82, 82, 90, 89, 89, 75, 79, 97, 86, 89, 
  73, 90, 79, 84, 94, 97, 70, 87, 92, 87, 
  86, 81, 83, 80, 88, 84, 83, 88, 76, 88, 
  95, 75, 71, 79, 72, 87, 87, 83, 97, 73, 
  88, 91, 76, 84, 84, 87, 73, 84, 85, 88, 
  83, 85, 88, 83, 80, 73, 88, 92, 75, 86, 
  73, 78, 81, 88, 82, 87, 71, 83, 96, 72, 
  80, 96, 94, 83, 62, 86, 87, 85, 86, 82, 
  100, 90, 84, 84, 82, 89, 99, 88, 87, 81, 
  80, 95, 87, 92, 91, 101, 84, 107, 82, 81, 
  84, 106, 94, 79, 66, 83, 82, 87, 81, 83, 
  77, 91, 76, 96, 64, 90, 72, 67, 88, 86, 
  84, 85, 83, 72, 85, 80, 87, 81, 88, 88, 
  100, 88, 87, 79, 67, 97, 84, 82, 83, 88, 
  77, 82, 89, 76, 65, 88, 71, 85, 75, 85, 
  75, 92, 84, 77, 96, 91, 68, 75, 73, 87, 
  81, 78, 90, 81, 88, 97, 74, 82, 88, 80, 
  100, 104, 88, 83, 85, 102, 76, 79, 93, 83, 
  81, 93, 84, 70, 84, 75, 81, 85, 95, 93, 
  91, 78, 75, 73, 74, 87, 76, 98, 91, 82, 
  80, 100, 96, 89, 80, 76, 80, 79, 76, 96, 
  84, 95, 92, 80, 95, 90, 85, 81, 81, 70, 
  85, 81, 66, 73, 84, 121, 78, 82, 84, 88, 
  82, 88, 80, 73, 97, 86, 77, 82, 81, 74, 
  89, 85, 90, 84, 92, 80, 86, 85, 95, 96, 
  96, 81, 71, 78, 83, 79, 70, 71, 89, 80, 
  95, 96, 68, 93, 84, 90, 98, 87, 83, 73, 
  92, 80, 82, 89, 32, 78, 65, 79, 68, 84, 
  89, 98, 142, 74, 67, 65, 101, 87, 75, 78, 
  76, 66, 92, 77, 82, 86, 75, 73, 118, 76, 
  89, 84, 68, 78, 67, 80, 81, 79, 68, 105, 
  73, 65, 85, 118, 86, 57, 84, 76, 77, 70, 
  83, 70, 61, 90, 58, 87, 82, 83, 68, 98, 
  70, 64, 72, 88, 84, 79, 71, 103, 81, 93, 
  105, 77, 59, 80, 106, 62, 69, 93, 82, 78, 
  60, 95, 71, 90, 121, 73, 79, 101, 84, 77, 
  67, 72, 82, 70, 63, 95, 87, 68, 82, 73, 
  79, 93, 97, 82, 87, 82, 101, 121, 96, 64, 
  121, 64, 79, 79, 97, 64, 87, 64, 90, 76, 
  83, 92, 72, 71, 133, 76, 77, 62, 92, 81, 
  88, 87, 84, 82, 75, 80, 77, 91, 82, 79, 
  72, 72, 72, 77, 83, 79, 83, 84, 81, 85, 
  75, 97, 96, 83, 88, 79, 90, 72, 97, 88, 
  84, 67, 89, 97, 91, 88, 86, 91, 83, 80, 
  85, 77, 86, 94, 97, 72, 94, 81, 80, 89, 
  82, 79, 87, 71, 89, 79, 84, 100, 98, 88, 
  77, 64, 76, 73, 77, 95, 85, 88, 74, 81, 
  104, 88, 99, 87, 80, 100, 90, 81, 70, 63, 
  82, 57, 78, 88, 81, 84, 81, 76, 85, 86, 
  103, 89, 93, 81, 79, 78, 87, 96, 88, 88, 
  93, 82, 84, 94, 88, 95, 92, 82, 94, 81, 
  77, 75, 100, 86, 89, 90, 95, 90, 117, 91, 
  85, 91, 86, 87, 90, 79, 93, 66, 65, 87, 
  68, 87, 78, 83, 82, 90, 87, 78, 72, 93, 
  76, 80, 81, 89, 84, 64, 98, 86, 95, 93, 
  72, 75, 88, 80, 95, 100, 85, 82, 90, 97, 
  78, 73, 89, 82, 79, 92, 86, 69, 87, 81, 
  80, 91, 94, 107, 85, 78, 82, 85, 77, 83, 
  77, 76, 97, 71, 87, 87, 95, 90, 83, 64, 
  83, 72, 76, 80, 89, 90, 80, 68, 92, 93, 
  78, 81, 87, 70, 74, 84, 75, 70, 88, 128, 
  71, 76, 87, 84, 79, 86, 75, 81, 90, 80, 
  79, 81, 83, 76, 84, 85, 86, 89, 85, 83, 
  85, 86, 94, 98, 74, 81, 87, 81, 84, 88, 
  82, 77, 78, 83, 90, 96, 72, 91, 86, 88, 
  84, 83, 82, 74, 92, 81, 82, 92, 28, 77, 
  66, 73, 76, 86, 94, 98, 146, 76, 81, 80, 
  114, 80, 79, 70, 75, 67, 86, 77, 87, 80, 
  72, 73, 111, 70, 102, 86, 70, 86, 64, 71, 
  76, 85, 71, 105, 80, 77, 87, 134, 87, 59, 
  86, 81, 69, 66, 88, 65, 72, 94, 51, 96, 
  88, 83, 70, 84, 74, 63, 64, 93, 60, 84, 
  74, 81, 91, 79, 91, 65, 56, 77, 100, 59, 
  80, 102, 64, 91, 70, 94, 77, 70, 124, 82, 
  74, 98, 78, 77, 58, 68, 79, 66, 57, 91, 
  91, 84, 78, 76, 68, 81, 92, 84, 79, 82, 
  99, 125, 76, 66, 121, 59, 78, 77, 87, 68, 
  79, 66, 94, 73, 87, 91, 69, 74, 134, 71, 
  77, 62, 84, 82, 79, 88, 86, 88, 77, 84, 
  86, 94, 85, 81, 64, 79, 73, 80, 87, 82, 
  81, 78, 86, 88, 77, 94, 95, 78, 98, 84, 
  86, 79, 73, 91, 91, 44, 88, 101, 88, 85, 
  89, 92, 92, 76, 95, 74, 94, 103, 95, 70, 
  87, 83, 85, 90, 80, 77, 98, 80, 95, 69, 
  93, 85, 92, 94, 77, 56, 76, 68, 71, 86, 
  80, 94, 78, 71, 109, 93, 95, 92, 92, 114, 
  78, 83, 77, 53, 84, 62, 62, 86, 82, 70, 
  74, 77, 78, 87, 101, 85, 91, 77, 80, 77, 
  81, 92, 91, 78, 81, 86, 83, 96, 87, 91, 
  72, 88, 82, 88, 81, 84, 69, 90, 94, 89, 
  90, 98, 120, 90, 81, 91, 74, 87, 84, 82, 
  99, 70, 84, 82, 77, 87, 78, 79, 73, 90, 
  93, 82, 78, 92, 71, 94, 90, 89, 90, 78, 
  92, 77, 82, 95, 81, 77, 86, 79, 83, 82, 
  97, 88, 90, 103, 78, 86, 86, 87, 79, 91, 
  96, 72, 85, 77, 78, 87, 92, 91, 86, 82, 
  85, 84, 78, 83, 83, 68, 96, 83, 86, 95, 
  93, 89, 91, 74, 78, 77, 77, 88, 89, 91, 
  70, 70, 85, 85, 83, 83, 81, 68, 78, 83, 
  74, 70, 88, 121, 87, 83, 83, 85, 91, 83, 
  83, 88, 84, 87, 85, 82, 82, 76, 82, 87, 
  82, 91, 92, 84, 88, 89, 105, 95, 80, 84, 
  104, 82, 86, 90, 95, 79, 61, 89, 88, 90, 
  75, 84, 84, 87, 86, 91, 85, 76, 85, 72, 
  84, 89, 46, 81, 70, 67, 67, 95, 99, 102, 
  119, 82, 81, 89, 101, 79, 73, 75, 73, 70, 
  92, 93, 83, 71, 80, 75, 98, 71, 76, 82, 
  76, 101, 66, 79, 86, 91, 69, 101, 105, 66, 
  85, 100, 75, 74, 82, 81, 72, 77, 84, 79, 
  66, 86, 69, 86, 87, 82, 86, 91, 93, 77, 
  74, 93, 78, 89, 75, 90, 93, 92, 98, 67, 
  59, 71, 92, 68, 83, 97, 68, 83, 66, 83, 
  75, 86, 91, 94, 79, 95, 87, 82, 57, 82, 
  84, 81, 80, 82, 89, 81, 86, 81, 78, 83, 
  88, 84, 81, 90, 93, 105, 74, 81, 104, 62, 
  78, 78, 73, 76, 86, 80, 89, 82, 95, 83, 
  71, 76, 109, 82, 77, 72, 92, 80, 72, 86, 
  94, 77, 82, 82, 74, 91, 94, 81, 77, 91, 
  69, 91, 93, 86, 86, 85, 86, 74, 77, 93, 
  89, 82, 92, 83, 75, 77, 82, 90, 90, 62, 
  78, 99, 93, 81, 86, 85, 103, 73, 88, 78, 
  86, 94, 88, 73, 90, 81, 82, 80, 79, 82, 
  92, 107, 93, 89, 86, 98, 87, 88, 92, 69, 
  73, 73, 73, 100, 85, 88, 83, 73, 97, 87, 
  97, 90, 84, 100, 79, 83, 80, 55, 82, 60, 
  90, 89, 91, 73, 80, 74, 83, 93, 90, 88, 
  99, 76, 79, 72, 87, 84, 84, 83, 90, 84, 
  83, 90, 96, 89, 83, 83, 83, 92, 86, 77, 
  74, 83, 96, 89, 89, 88, 106, 87, 85, 91, 
  82, 86, 86, 81, 72, 84, 89, 91, 79, 82, 
  86, 74, 88, 90, 84, 82, 79, 89, 71, 77, 
  71, 73, 91, 85, 104, 92, 80, 85, 83, 99, 
  67, 84, 89, 87, 87, 76, 78, 100, 78, 85, 
  91, 91, 84, 76, 95, 80, 85, 76, 76, 76, 
  77, 76, 90, 86, 75, 95, 69, 78, 77, 90, 
  82, 83, 80, 82, 93, 83, 82, 84, 90, 74, 
  79, 80, 93, 105, 80, 84, 76, 81, 81, 82, 
  78, 93, 88, 83, 75, 88, 81, 69, 85, 95, 
  86, 87, 87, 94, 69, 81, 88, 80, 87, 89, 
  85, 81, 78, 84, 82, 76, 81, 59, 87, 79, 
  92, 79, 90, 86, 75, 66, 88, 89, 86, 79, 
  77, 68, 81, 106, 90, 75, 86, 86, 93, 78, 
  84, 80, 69, 89, 76, 88, 67, 78, 80, 74, 
  95, 92, 85, 96, 93, 85, 78, 78, 70, 84, 
  89, 85, 90, 88, 75, 80, 93, 98, 72, 95, 
  95, 93, 88, 81, 89, 101, 79, 79, 98, 92, 
  80, 73, 93, 76, 94, 76, 71, 74, 82, 80, 
  81, 85, 71, 97, 72, 78, 82, 90, 83, 75, 
  84, 85, 100, 78, 89, 87, 87, 73, 84, 80, 
  82, 110, 89, 77, 69, 84, 86, 75, 84, 81, 
  91, 80, 84, 77, 74, 67, 84, 91, 83, 89, 
  86, 92, 56, 81, 75, 77, 87, 79, 94, 76, 
  70, 83, 85, 92, 88, 55, 95, 84, 95, 83, 
  96, 89, 80, 70, 89, 84, 87, 86, 70, 61, 
  85, 105, 90, 80, 91, 86, 99, 74, 84, 85, 
  72, 85, 81, 86, 86, 85, 81, 77, 86, 88, 
  83, 78, 77, 90, 76, 78, 74, 78, 87, 86, 
  85, 92, 81, 82, 93, 104, 69, 87, 81, 87, 
  91, 81, 80, 110, 70, 84, 95, 88, 79, 80, 
  92, 83, 94, 81, 80, 75, 77, 88, 94, 83, 
  80, 86, 67, 79, 78, 81, 79, 81, 84, 83, 
  92, 87, 87, 83, 85, 73, 81, 84, 89, 91, 
  89, 82, 77, 82, 85, 87, 71, 81, 96, 84, 
  73, 83, 81, 69, 85, 91, 92, 86, 88, 92, 
  72, 78, 87, 78, 101, 86, 81, 83, 71, 88, 
  83, 86, 78, 59, 86, 79, 85, 81, 87, 90, 
  81, 68, 87, 90, 89, 79, 82, 69, 81, 102, 
  81, 79, 81, 80, 95, 74, 85, 81, 68, 75, 
  86, 83, 67, 82, 93, 86, 101, 79, 94, 94, 
  86, 78, 80, 89, 74, 93, 84, 81, 126, 105, 
  76, 70, 84, 99, 63, 78, 107, 82, 93, 77, 
  98, 77, 89, 96, 83, 81, 75, 73, 85, 88, 
  77, 71, 71, 92, 82, 84, 80, 106, 64, 90, 
  73, 83, 87, 82, 76, 67, 80, 92, 79, 88, 
  83, 67, 95, 69, 82, 80, 86, 91, 87, 87, 
  84, 76, 81, 75, 95, 100, 68, 79, 99, 61, 
  76, 69, 78, 85, 83, 75, 82, 82, 63, 83, 
  77, 79, 58, 78, 89, 73, 98, 70, 80, 84, 
  86, 56, 95, 83, 97, 82, 86, 97, 73, 78, 
  81, 83, 95, 84, 84, 67, 93, 91, 91, 84, 
  98, 92, 94, 88, 77, 97, 58, 100, 79, 78, 
  47, 75, 98, 91, 99, 82, 101, 122, 96, 69, 
  86, 97, 83, 113, 82, 82, 97, 91, 70, 68, 
  99, 95, 75, 84, 112, 100, 104, 77, 121, 71, 
  94, 74, 84, 94, 72, 71, 80, 90, 103, 63, 
  66, 98, 94, 83, 72, 110, 56, 71, 86, 89, 
  92, 81, 78, 53, 85, 101, 87, 83, 83, 77, 
  76, 67, 96, 85, 74, 84, 72, 78, 74, 70, 
  95, 62, 114, 86, 69, 77, 114, 43, 70, 76, 
  77, 83, 80, 68, 78, 94, 52, 76, 66, 78, 
  51, 63, 97, 67, 89, 60, 76, 91, 98, 57, 
  102, 76, 102, 84, 98, 105, 73, 92, 88, 83, 
  88, 94, 75, 64, 115, 86, 82, 97, 96, 100, 
  90, 88, 81, 107, 69, 92, 95, 81, 78, 80, 
  87, 84, 101, 78, 92, 94, 81, 78, 81, 90, 
  76, 94, 81, 79, 77, 102, 86, 69, 94, 103, 
  69, 80, 98, 87, 87, 85, 96, 88, 76, 79, 
  84, 80, 74, 77, 81, 89, 114, 76, 74, 90, 
  84, 93, 86, 94, 69, 79, 70, 87, 84, 85, 
  74, 71, 86, 85, 81, 95, 88, 71, 92, 72, 
  90, 79, 77, 77, 95, 87, 79, 75, 85, 81, 
  80, 81, 76, 83, 97, 64, 79, 83, 83, 81, 
  83, 83, 88, 88, 69, 79, 78, 79, 78, 76, 
  86, 80, 73, 76, 86, 87, 86, 56, 91, 83, 
  89, 84, 89, 97, 75, 81, 83, 88, 90, 82, 
  94, 71, 95, 91, 58, 87, 87, 88, 96, 82, 
  78, 92, 77, 73, 81, 96, 75, 89, 92, 82, 
  87, 78, 90, 88, 90, 73, 67, 100, 89, 96, 
  86, 80, 103, 92, 67, 69, 90, 89, 76, 76, 
  84, 76, 91, 80, 92, 85, 89, 93, 85, 81, 
  80, 80, 80, 91, 77, 73, 78, 83, 92, 92, 
  89, 98, 61, 84, 72, 88, 84, 86, 76, 74, 
  85, 92, 84, 86, 87, 74, 103, 74, 88, 85, 
  90, 85, 101, 81, 97, 69, 72, 69, 85, 96, 
  80, 85, 96, 64, 85, 73, 78, 79, 85, 69, 
  89, 83, 66, 100, 90, 81, 71, 83, 81, 73, 
  109, 78, 87, 88, 81, 57, 89, 90, 93, 79, 
  81, 104, 71, 73, 85, 79, 95, 83, 76, 75, 
  88, 77, 87, 87, 93, 93, 96, 92, 79, 91, 
  71, 92, 93, 91, 64, 76, 93, 89, 85, 78, 
  94, 109, 95, 75, 70, 108, 101, 113, 90, 80, 
  77, 89, 74, 61, 95, 89, 80, 77, 88, 87, 
  89, 75, 99, 72, 93, 77, 87, 89, 74, 81, 
  83, 83, 86, 71, 76, 84, 113, 81, 80, 94, 
  53, 83, 76, 94, 87, 86, 76, 64, 82, 97, 
  86, 84, 83, 79, 96, 71, 102, 92, 85, 89, 
  81, 67, 87, 65, 88, 51, 93, 81, 83, 82, 
  107, 54, 83, 80, 82, 76, 82, 71, 87, 79, 
  57, 96, 77, 87, 57, 74, 84, 65, 93, 73, 
  88, 86, 93, 60, 90, 82, 90, 82, 83, 102, 
  71, 82, 91, 81, 95, 83, 81, 68, 112, 75, 
  75, 89, 83, 99, 92, 88, 88, 96, 79, 95, 
  103, 92, 82, 72, 91, 81, 85, 78, 88, 87, 
  86, 89, 72, 100, 88, 94, 85, 81, 79, 90, 
  93, 70, 91, 92, 78, 77, 74, 87, 89, 82, 
  97, 81, 78, 83, 83, 81, 73, 79, 81, 92, 
  99, 77, 80, 80, 94, 86, 94, 93, 64, 88, 
  71, 92, 75, 80, 73, 80, 86, 83, 85, 88, 
  87, 77, 100, 79, 98, 83, 83, 83, 77, 79, 
  88, 69, 82, 71, 78, 86, 80, 85, 95, 66, 
  85, 84, 81, 72, 80, 84, 89, 85, 69, 85, 
  91, 82, 82, 79, 79, 80, 76, 78, 90, 76, 
  80, 57, 87, 91, 89, 82, 86, 96, 73, 72, 
  87, 89, 92, 85, 101, 76, 87, 83, 67, 86, 
  86, 90, 94, 89, 80, 90, 77, 84, 73, 95, 
  89, 92, 79, 91, 70, 83, 84, 72, 91, 83, 
  82, 110, 108, 107, 96, 93, 86, 89, 88, 80, 
  83, 83, 79, 94, 88, 85, 78, 88, 96, 86, 
  82, 82, 74, 88, 86, 95, 79, 76, 86, 89, 
  61, 88, 93, 86, 83, 87, 84, 82, 80, 81, 
  88, 87, 73, 92, 75, 79, 83, 65, 74, 72, 
  100, 66, 84, 87, 94, 80, 80, 74, 100, 92, 
  73, 84, 73, 79, 83, 68, 96, 85, 75, 85, 
  86, 77, 104, 73, 78, 75, 87, 82, 82, 88, 
  98, 80, 85, 92, 97, 77, 87, 97, 86, 81, 
  85, 87, 86, 93, 82, 90, 71, 87, 101, 93, 
  85, 82, 87, 80, 81, 83, 78, 90, 91, 84, 
  90, 92, 81, 88, 76, 84, 87, 94, 94, 74, 
  80, 91, 84, 79, 88, 66, 98, 78, 79, 109, 
  102, 99, 98, 98, 90, 85, 77, 81, 87, 85, 
  82, 97, 95, 84, 76, 106, 106, 86, 81, 77, 
  65, 95, 86, 90, 76, 72, 84, 86, 57, 96, 
  102, 74, 76, 85, 82, 81, 86, 83, 90, 79, 
  73, 77, 72, 82, 87, 74, 71, 67, 90, 70, 
  90, 81, 97, 76, 81, 63, 109, 85, 78, 87, 
  71, 86, 81, 64, 96, 80, 78, 89, 84, 77, 
  92, 70, 76, 76, 90, 72, 67, 90, 96, 84, 
  87, 85, 93, 82, 89, 90, 82, 82, 79, 93, 
  88, 92, 86, 82, 64, 76, 94, 94, 79, 75, 
  88, 77, 78, 80, 94, 84, 88, 82, 84, 82, 
  85, 94, 81, 82, 94, 89, 86, 85, 76, 94, 
  77, 83, 88, 74, 91, 85, 80, 102, 97, 104, 
  90, 97, 84, 89, 93, 77, 87, 82, 83, 92, 
  79, 77, 78, 96, 95, 83, 85, 76, 71, 89, 
  85, 93, 87, 83, 85, 89, 68, 94, 96, 73, 
  85, 87, 81, 72, 82, 81, 92, 83, 71, 91, 
  80, 79, 82, 77, 80, 79, 103, 70, 92, 87, 
  89, 88, 87, 84, 98, 93, 79, 80, 73, 88, 
  84, 70, 94, 85, 81, 87, 82, 88, 88, 78, 
  80, 68, 84, 75, 85, 84, 90, 81, 83, 96, 
  78, 76, 81, 93, 82, 82, 87, 89, 86, 87, 
  81, 91, 76, 87, 95, 102, 86, 86, 82, 82, 
  83, 78, 88, 90, 87, 80, 93, 89, 82, 87, 
  67, 73, 84, 71, 85, 78, 77, 80, 88, 80, 
  82, 81, 72, 83, 78, 93, 80, 78, 84, 79, 
  82, 91, 78, 100, 79, 70, 85, 80, 88, 81, 
  81, 95, 93, 77, 83, 92, 91, 67, 100, 62, 
  76, 103, 81, 72, 73, 75, 78, 84, 99, 68, 
  110, 83, 83, 76, 86, 106, 77, 85, 85, 81, 
  89, 90, 81, 86, 66, 76, 99, 86, 94, 66, 
  80, 108, 80, 79, 68, 77, 84, 81, 55, 86, 
  81, 83, 77, 77, 86, 58, 89, 84, 70, 78, 
  90, 66, 87, 78, 79, 91, 78, 77, 98, 115, 
  74, 99, 96, 89, 92, 76, 67, 87, 81, 79, 
  72, 85, 88, 87, 108, 83, 75, 82, 84, 97, 
  88, 91, 83, 73, 81, 75, 96, 86, 58, 74, 
  74, 59, 78, 72, 79, 74, 84, 78, 87, 80, 
  66, 106, 75, 77, 70, 66, 79, 77, 85, 94, 
  78, 102, 81, 66, 77, 77, 95, 84, 89, 100, 
  84, 73, 85, 91, 96, 54, 101, 60, 74, 148, 
  83, 66, 73, 65, 74, 88, 99, 61, 121, 82, 
  82, 81, 84, 104, 75, 74, 102, 81, 83, 96, 
  85, 74, 47, 101, 100, 88, 84, 41, 82, 113, 
  72, 62, 68, 82, 92, 83, 46, 108, 76, 77, 
  72, 71, 96, 53, 82, 83, 71, 72, 82, 48, 
  92, 79, 67, 99, 75, 73, 105, 133, 66, 95, 
  104, 90, 83, 87, 66, 90, 68, 74, 83, 71, 
  83, 88, 122, 86, 72, 85, 91, 93, 87, 90, 
  70, 76, 77, 55, 98, 94, 76, 81, 80, 76, 
  86, 83, 74, 85, 85, 84, 86, 79, 74, 97, 
  76, 88, 77, 81, 81, 82, 78, 89, 89, 93, 
  83, 72, 90, 79, 76, 76, 86, 96, 98, 81, 
  84, 82, 84, 68, 77, 71, 79, 96, 77, 76, 
  77, 81, 78, 84, 95, 74, 97, 78, 84, 74, 
  87, 82, 70, 89, 85, 82, 86, 86, 91, 85, 
  75, 71, 89, 86, 91, 83, 83, 111, 81, 83, 
  76, 75, 81, 82, 67, 80, 85, 82, 84, 79, 
  83, 74, 88, 88, 73, 77, 94, 62, 92, 78, 
  90, 88, 80, 84, 85, 100, 71, 89, 93, 89, 
  97, 78, 73, 85, 82, 82, 87, 87, 85, 93, 
  101, 84, 77, 86, 86, 89, 83, 85, 88, 74, 
  88, 76, 88, 85, 78, 75, 74, 87, 83, 85, 
  81, 101, 81, 80, 86, 84, 79, 113, 81, 78, 
  80, 95, 95, 85, 95, 94, 96, 86, 78, 85, 
  93, 82, 97, 87, 76, 96, 89, 80, 86, 94, 
  76, 87, 85, 72, 98, 119, 78, 91, 88, 90, 
  74, 95, 84, 71, 117, 83, 81, 85, 80, 77, 
  77, 84, 95, 80, 87, 77, 94, 68, 75, 82, 
  90, 67, 81, 65, 86, 94, 95, 87, 71, 67, 
  77, 81, 63, 82, 87, 91, 85, 71, 88, 79, 
  106, 80, 79, 88, 82, 85, 86, 77, 83, 90, 
  81, 79, 92, 95, 75, 89, 85, 85, 64, 67, 
  80, 97, 88, 85, 80, 84, 87, 97, 103, 85, 
  89, 79, 91, 100, 72, 97, 90, 77, 85, 73, 
  94, 89, 75, 82, 75, 87, 82, 75, 81, 101, 
  86, 80, 84, 87, 80, 93, 79, 81, 74, 95, 
  89, 85, 89, 81, 83, 82, 83, 83, 97, 84, 
  102, 87, 71, 110, 88, 74, 82, 85, 77, 87, 
  95, 64, 101, 112, 95, 90, 96, 85, 70, 80, 
  77, 66, 122, 69, 85, 88, 78, 90, 72, 72, 
  85, 77, 88, 77, 104, 60, 61, 82, 100, 55, 
  70, 64, 80, 78, 102, 88, 67, 68, 75, 84, 
  59, 82, 87, 89, 79, 79, 78, 92, 96, 70, 
  80, 89, 85, 79, 70, 77, 82, 102, 83, 72, 
  83, 98, 78, 81, 87, 85, 48, 54, 80, 103, 
  83, 77, 85, 73, 85, 96, 92, 68, 90, 75, 
  85, 107, 77, 94, 80, 77, 78, 64, 94, 85, 
  81, 80, 85, 84, 85, 99, 79, 97, 84, 83, 
  90, 81, 82, 75, 81, 80, 77, 93, 93, 87, 
  65, 92, 86, 88, 85, 88, 101, 81, 84, 81, 
  76, 105, 90, 75, 84, 82, 82, 84, 104, 78, 
  91, 110, 92, 92, 86, 86, 77, 80, 87, 76, 
  102, 77, 80, 81, 86, 96, 80, 91, 97, 78, 
  86, 80, 87, 71, 80, 85, 91, 74, 76, 80, 
  83, 99, 94, 90, 74, 69, 77, 87, 66, 76, 
  88, 90, 86, 91, 89, 97, 98, 79, 80, 83, 
  77, 74, 97, 77, 87, 82, 85, 84, 84, 91, 
  74, 84, 85, 87, 71, 77, 85, 93, 84, 91, 
  82, 88, 84, 101, 82, 92, 92, 84, 94, 96, 
  77, 97, 87, 75, 90, 76, 93, 90, 87, 89, 
  97, 76, 90, 74, 90, 83, 91, 77, 90, 83, 
  87, 82, 89, 89, 95, 80, 93, 85, 56, 87, 
  97, 99, 89, 72, 80, 81, 84, 88, 88, 95, 
  94, 92, 86, 87, 86, 79, 80, 86, 86, 86, 
  81, 96, 63, 92, 100, 86, 91, 85, 78, 86, 
  90, 77, 91, 81, 89, 101, 91, 80, 92, 90, 
  96, 91, 85, 71, 84, 92, 87, 98, 83, 88, 
  66, 79, 77, 85, 79, 83, 88, 83, 90, 82, 
  74, 81, 96, 80, 79, 92, 91, 111, 66, 93, 
  91, 77, 90, 83, 71, 88, 74, 74, 76, 82, 
  86, 63, 89, 94, 77, 80, 73, 73, 68, 79, 
  82, 82, 81, 94, 84, 90, 81, 73, 104, 90, 
  84, 82, 94, 79, 88, 70, 80, 90, 84, 79, 
  90, 85, 86, 83, 86, 76, 91, 83, 87, 85, 
  86, 90, 90, 74, 88, 85, 73, 85, 80, 92, 
  86, 68, 79, 81, 83, 91, 88, 93, 90, 91, 
  82, 81, 91, 79, 78, 85, 91, 89, 65, 90, 
  63, 84, 87, 85, 90, 84, 77, 84, 88, 79, 
  84, 86, 86, 94, 89, 85, 99, 89, 93, 90, 
  77, 70, 86, 92, 85, 91, 84, 86, 59, 75, 
  79, 86, 82, 82, 85, 82, 85, 86, 79, 84, 
  97, 78, 82, 92, 86, 108, 67, 92, 86, 77, 
  92, 80, 76, 87, 85, 82, 75, 87, 88, 70, 
  89, 87, 75, 83, 74, 72, 67, 77, 81, 78, 
  79, 89, 82, 89, 79, 72, 93, 83, 88, 82, 
  88, 81, 88, 71, 80, 86, 79, 83, 92, 100, 
  85, 92, 93, 80, 96, 83, 83, 85, 86, 76, 
  93, 88, 93, 79, 82, 88, 77, 92, 82, 74, 
  83, 88, 79, 83, 79, 93, 88, 88, 78, 80, 
  90, 81, 78, 94, 91, 86, 68, 85, 69, 90, 
  89, 73, 88, 94, 81, 78, 77, 80, 92, 81, 
  85, 94, 85, 80, 85, 88, 89, 83, 76, 84, 
  83, 92, 84, 92, 85, 83, 74, 77, 83, 88, 
  81, 88, 82, 86, 85, 88, 80, 91, 92, 79, 
  86, 90, 85, 99, 76, 93, 83, 81, 89, 84, 
  76, 89, 92, 71, 77, 85, 87, 72, 84, 75, 
  77, 84, 83, 81, 77, 82, 84, 83, 79, 84, 
  84, 91, 78, 66, 77, 88, 85, 89, 91, 79, 
  89, 81, 79, 83, 95, 76, 87, 70, 87, 98, 
  88, 68, 83, 81, 85, 77, 97, 72, 88, 67, 
  69, 84, 68, 79, 75, 97, 80, 79, 84, 80, 
  93, 101, 100, 81, 94, 84, 107, 95, 72, 105, 
  90, 64, 68, 88, 140, 83, 76, 124, 71, 94, 
  82, 75, 99, 77, 92, 86, 66, 88, 94, 71, 
  84, 87, 78, 73, 72, 89, 75, 73, 80, 81, 
  80, 64, 73, 74, 80, 115, 76, 79, 86, 100, 
  90, 84, 99, 82, 76, 71, 81, 88, 81, 69, 
  86, 110, 49, 83, 67, 87, 74, 86, 71, 80, 
  55, 80, 81, 81, 73, 69, 92, 114, 84, 68, 
  63, 76, 86, 85, 90, 89, 75, 96, 80, 81, 
  81, 123, 115, 95, 60, 77, 80, 84, 100, 80, 
  79, 89, 70, 73, 85, 75, 84, 85, 82, 68, 
  82, 82, 84, 84, 91, 76, 79, 55, 63, 83, 
  105, 78, 77, 88, 66, 72, 83, 75, 92, 109, 
  100, 76, 85, 92, 101, 78, 74, 99, 83, 65, 
  69, 89, 85, 77, 82, 109, 59, 94, 84, 73, 
  94, 78, 92, 78, 64, 90, 89, 78, 84, 91, 
  91, 72, 76, 84, 69, 70, 82, 77, 78, 67, 
  80, 79, 69, 107, 74, 86, 93, 90, 91, 87, 
  93, 82, 78, 95, 83, 87, 83, 75, 84, 111, 
  49, 82, 73, 86, 79, 82, 76, 81, 67, 85, 
  80, 73, 73, 75, 90, 107, 78, 69, 61, 75, 
  89, 85, 83, 83, 76, 92, 83, 83, 77, 124, 
  90, 92, 65, 75, 75, 86, 98, 79, 85, 86, 
  73, 83, 85, 106, 80, 90, 92, 79, 91, 87, 
  84, 90, 91, 68, 89, 81, 85, 88, 97, 83, 
  84, 91, 77, 78, 83, 83, 90, 102, 79, 93, 
  90, 95, 85, 78, 85, 88, 76, 84, 82, 88, 
  58, 86, 71, 90, 85, 73, 90, 93, 89, 79, 
  85, 87, 86, 90, 85, 92, 81, 84, 82, 79, 
  85, 71, 75, 80, 77, 93, 88, 88, 90, 91, 
  70, 78, 88, 92, 84, 88, 80, 86, 92, 85, 
  81, 104, 95, 80, 92, 93, 88, 94, 71, 85, 
  82, 79, 88, 81, 82, 85, 93, 71, 79, 75, 
  84, 72, 87, 84, 82, 81, 84, 83, 87, 88, 
  85, 84, 76, 89, 91, 91, 80, 66, 68, 84, 
  81, 83, 95, 85, 85, 85, 84, 78, 82, 93, 
  92, 68, 88, 108, 85, 69, 88, 83, 90, 85, 
  95, 73, 86, 91, 94, 80, 92, 77, 80, 94, 
  77, 96, 85, 84, 90, 93, 85, 75, 108, 89, 
  88, 90, 87, 96, 87, 73, 65, 84, 123, 87, 
  91, 121, 65, 99, 71, 86, 79, 86, 93, 98, 
  92, 89, 88, 65, 68, 74, 74, 65, 71, 91, 
  80, 74, 75, 86, 72, 66, 76, 67, 106, 120, 
  82, 77, 79, 93, 79, 74, 112, 88, 91, 65, 
  92, 93, 90, 72, 89, 76, 56, 77, 58, 94, 
  82, 100, 77, 89, 56, 79, 82, 92, 73, 70, 
  66, 98, 92, 82, 57, 74, 98, 84, 90, 91, 
  80, 93, 78, 80, 75, 105, 104, 74, 55, 78, 
  95, 89, 84, 95, 82, 86, 60, 84, 89, 68, 
  88, 100, 74, 69, 88, 83, 87, 85, 90, 74, 
  81, 79, 91, 79, 107, 84, 81, 86, 67, 91, 
  86, 77, 93, 96, 89, 67, 102, 86, 90, 80, 
  83, 97, 86, 72, 65, 83, 92, 78, 95, 106, 
  56, 88, 74, 80, 74, 85, 89, 91, 84, 80, 
  81, 71, 69, 80, 80, 61, 76, 87, 73, 77, 
  77, 80, 72, 74, 72, 70, 94, 120, 80, 80, 
  85, 86, 84, 72, 105, 86, 94, 101, 89, 92, 
  78, 78, 88, 77, 59, 79, 61, 91, 79, 89, 
  82, 90, 66, 81, 84, 78, 74, 74, 66, 93, 
  88, 80, 63, 76, 107, 85, 86, 88, 82, 93, 
  88, 80, 76, 112, 79, 80, 61, 81, 88, 88, 
  86, 93, 82, 90, 68, 91, 85, 107, 78, 85, 
  88, 80, 91, 82, 89, 91, 86, 82, 82, 86, 
  89, 80, 79, 87, 89, 92, 77, 77, 78, 88, 
  82, 91, 75, 87, 96, 96, 85, 77, 90, 89, 
  73, 92, 84, 88, 64, 82, 77, 86, 82, 72, 
  87, 97, 80, 85, 82, 84, 92, 74, 82, 87, 
  78, 83, 81, 76, 82, 78, 81, 84, 82, 90, 
  82, 94, 80, 85, 82, 92, 89, 92, 84, 87, 
  79, 81, 97, 84, 83, 108, 90, 88, 84, 87, 
  88, 86, 73, 85, 80, 82, 88, 82, 86, 91, 
  88, 77, 85, 78, 81, 75, 91, 88, 76, 84, 
  75, 81, 84, 87, 92, 88, 85, 92, 93, 94, 
  82, 68, 68, 76, 78, 87, 99, 87, 76, 90, 
  78, 79, 77, 92, 88, 82, 82, 80, 98, 87, 
  77, 84, 71, 88, 78, 84, 78, 89, 93, 75, 
  93, 88, 73, 83, 89, 90, 86, 85, 79, 79, 
  97, 81, 85, 73, 84, 85, 97, 82, 79, 94, 
  99, 79, 85, 80, 78, 96, 79, 93, 85, 76, 
  72, 107, 114, 87, 106, 70, 90, 79, 93, 80, 
  80, 86, 90, 75, 83, 89, 98, 82, 85, 88, 
  81, 70, 93, 82, 87, 93, 83, 83, 80, 65, 
  95, 88, 95, 85, 72, 100, 75, 79, 79, 82, 
  85, 85, 86, 75, 89, 77, 80, 80, 88, 92, 
  70, 71, 84, 88, 81, 78, 73, 78, 88, 84, 
  89, 77, 81, 87, 83, 90, 84, 85, 80, 90, 
  85, 87, 83, 81, 86, 71, 84, 91, 89, 81, 
  91, 93, 73, 70, 76, 85, 89, 85, 68, 87, 
  89, 95, 82, 77, 79, 93, 82, 72, 86, 86, 
  73, 88, 86, 72, 90, 79, 82, 81, 90, 83, 
  89, 68, 94, 79, 90, 80, 78, 74, 95, 71, 
  84, 66, 73, 90, 80, 72, 81, 84, 75, 103, 
  99, 80, 88, 85, 83, 85, 84, 79, 85, 77, 
  101, 94, 80, 82, 112, 82, 72, 75, 73, 81, 
  93, 94, 84, 83, 82, 61, 79, 57, 81, 94, 
  91, 88, 66, 94, 75, 86, 94, 82, 80, 84, 
  85, 82, 85, 68, 80, 83, 88, 82, 75, 70, 
  82, 89, 77, 74, 88, 74, 95, 84, 95, 88, 
  82, 85, 81, 99, 79, 84, 75, 93, 83, 84, 
  80, 80, 71, 86, 86, 91, 90, 91, 78, 94, 
  73, 87, 72, 88, 91, 86, 67, 91, 88, 90, 
  74, 77, 76, 88, 77, 76, 80, 83, 73, 86, 
  87, 76, 84, 80, 85, 81, 78, 89, 88, 79, 
  101, 73, 84, 84, 88, 72, 95, 70, 92, 69, 
  72, 100, 82, 81, 87, 84, 81, 90, 94, 87, 
  88, 98, 85, 89, 80, 79, 89, 86, 98, 92, 
  87, 79, 103, 84, 78, 73, 99, 84, 94, 97, 
  88, 85, 81, 66, 87, 62, 83, 105, 89, 89, 
  62, 91, 82, 84, 91, 79, 85, 78, 85, 79, 
  91, 68, 80, 83, 86, 83, 80, 80, 86, 87, 
  79, 76, 89, 66, 96, 81, 77, 93, 81, 87, 
  79, 93, 75, 81, 74, 92, 77, 82, 79, 82, 
  81, 86, 79, 82, 90, 69, 85, 74, 79, 83, 
  76, 79, 84, 84, 76, 87, 78, 95, 77, 91, 
  82, 96, 86, 74, 97, 91, 100, 92, 92, 81, 
  104, 81, 86, 78, 80, 77, 101, 67, 73, 78, 
  85, 78, 87, 98, 84, 90, 85, 64, 87, 95, 
  92, 99, 80, 86, 61, 96, 102, 79, 92, 50, 
  82, 44, 92, 96, 80, 89, 80, 46, 69, 85, 
  100, 66, 93, 85, 76, 86, 90, 84, 87, 86, 
  89, 99, 76, 80, 73, 70, 113, 109, 56, 82, 
  84, 77, 77, 89, 84, 73, 95, 83, 82, 73, 
  83, 72, 90, 90, 66, 67, 80, 98, 86, 83, 
  79, 76, 81, 97, 93, 79, 85, 94, 51, 99, 
  95, 82, 77, 85, 89, 85, 74, 67, 72, 88, 
  84, 120, 90, 70, 75, 70, 100, 77, 72, 85, 
  46, 94, 104, 80, 98, 81, 84, 80, 91, 85, 
  86, 121, 85, 77, 97, 90, 94, 87, 77, 79, 
  96, 81, 77, 74, 76, 96, 78, 64, 79, 74, 
  72, 62, 81, 82, 79, 61, 97, 79, 82, 63, 
  95, 43, 77, 71, 68, 75, 63, 81, 95, 78, 
  74, 118, 80, 82, 90, 91, 68, 83, 105, 77, 
  77, 73, 66, 99, 80, 84, 96, 91, 67, 82, 
  76, 73, 57, 79, 80, 101, 99, 77, 80, 94, 
  60, 78, 71, 83, 86, 106, 100, 94, 91, 68, 
  78, 92, 65, 65, 94, 99, 95, 76, 102, 117, 
  92, 78, 73, 79, 92, 76, 95, 86, 88, 83, 
  74, 76, 73, 104, 52, 76, 72, 93, 102, 76, 
  85, 109, 76, 68, 105, 89, 74, 84, 52, 92, 
  107, 81, 85, 76, 86, 80, 80, 79, 82, 139, 
  75, 81, 84, 80, 87, 83, 67, 76, 97, 75, 
  71, 77, 73, 87, 79, 72, 70, 74, 79, 60, 
  81, 79, 91, 78, 90, 84, 80, 78, 89, 47, 
  96, 70, 67, 81, 71, 99, 96, 113, 72, 97, 
  82, 81, 86, 101, 95, 80, 90, 72, 76, 69, 
  91, 93, 85, 86, 104, 94, 66, 61, 91, 75, 
  63, 105, 75, 92, 102, 80, 79, 83, 85, 78, 
  72, 87, 85, 87, 87, 85, 90, 80, 83, 89, 
  71, 103, 89, 94, 92, 78, 95, 105, 91, 73, 
  61, 86, 84, 84, 105, 71, 75, 76, 80, 76, 
  71, 91, 51, 73, 88, 88, 92, 68, 87, 73, 
  74, 78, 92, 83, 74, 88, 87, 81, 80, 79, 
  83, 74, 69, 99, 84, 85, 80, 70, 92, 94, 
  81, 84, 80, 88, 103, 77, 79, 74, 73, 80, 
  93, 79, 97, 79, 98, 72, 91, 101, 83, 91, 
  91, 67, 87, 81, 92, 102, 78, 73, 69, 96, 
  97, 91, 91, 88, 86, 49, 95, 92, 68, 89, 
  77, 52, 80, 87, 86, 75, 94, 83, 90, 85, 
  94, 91, 89, 85, 87, 108, 81, 89, 73, 72, 
  105, 96, 53, 79, 89, 77, 79, 87, 82, 85, 
  95, 84, 83, 76, 86, 74, 97, 86, 75, 83, 
  78, 93, 82, 80, 74, 73, 81, 81, 85, 77, 
  84, 98, 55, 85, 84, 82, 84, 87, 79, 84, 
  80, 71, 81, 85, 86, 100, 84, 68, 71, 73, 
  96, 71, 73, 91, 61, 84, 98, 75, 103, 70, 
  86, 95, 97, 78, 83, 97, 76, 84, 88, 79, 
  77, 96, 85, 80, 84, 71, 56, 78, 82, 108, 
  90, 67, 86, 83, 82, 76, 86, 87, 89, 69, 
  87, 76, 81, 72, 80, 52, 79, 73, 68, 89, 
  68, 93, 99, 83, 85, 108, 79, 76, 82, 89, 
  84, 87, 82, 78, 96, 86, 87, 86, 90, 79, 
  84, 86, 73, 76, 91, 87, 63, 85, 80, 93, 
  88, 89, 83, 90, 78, 88, 76, 90, 85, 98, 
  111, 98, 86, 77, 89, 87, 83, 76, 91, 92, 
  79, 77, 95, 92, 81, 80, 76, 75, 84, 79, 
  95, 72, 74, 80, 85, 86, 71, 100, 58, 83, 
  89, 78, 97, 69, 83, 94, 104, 68, 99, 88, 
  74, 84, 59, 85, 98, 72, 95, 87, 91, 83, 
  85, 78, 76, 107, 84, 92, 95, 81, 81, 89, 
  75, 78, 80, 86, 65, 82, 78, 91, 81, 88, 
  72, 86, 85, 75, 83, 86, 81, 79, 85, 77, 
  84, 76, 77, 56, 90, 85, 71, 91, 70, 90, 
  94, 103, 80, 84, 81, 72, 78, 99, 96, 88, 
  88, 73, 88, 90, 82, 88, 87, 84, 90, 93, 
  80, 72, 81, 91, 69, 96, 73, 97, 88, 98, 
  81, 87, 91, 82, 80, 87, 84, 83, 92, 86, 
  85, 87, 82, 82, 85, 83, 91, 89, 79, 83, 
  93, 81, 83, 78, 81, 76, 79, 83, 94, 75, 
  90, 76, 91, 85, 76, 87, 61, 75, 101, 75, 
  89, 70, 92, 84, 76, 78, 74, 82, 110, 88, 
  76, 69, 81, 65, 79, 95, 71, 91, 89, 105, 
  58, 84, 92, 97, 81, 91, 87, 71, 83, 77, 
  90, 76, 98, 83, 79, 82, 73, 86, 80, 71, 
  87, 85, 75, 87, 113, 70, 92, 79, 81, 88, 
  74, 88, 105, 79, 77, 75, 79, 89, 84, 95, 
  79, 106, 90, 84, 81, 70, 80, 79, 84, 92, 
  70, 72, 83, 77, 91, 76, 90, 87, 82, 84, 
  65, 65, 82, 88, 79, 96, 98, 81, 81, 85, 
  92, 97, 80, 77, 78, 84, 74, 74, 84, 90, 
  92, 73, 75, 86, 105, 81, 91, 88, 81, 87, 
  84, 97, 89, 87, 77, 83, 102, 76, 104, 104, 
  81, 74, 86, 80, 70, 90, 75, 80, 89, 70, 
  88, 85, 69, 77, 73, 73, 104, 82, 76, 70, 
  79, 68, 79, 87, 72, 91, 92, 107, 62, 90, 
  97, 87, 80, 88, 89, 70, 79, 76, 96, 76, 
  96, 78, 81, 73, 83, 86, 85, 68, 88, 77, 
  81, 90, 101, 77, 94, 76, 74, 83, 68, 96, 
  94, 69, 88, 77, 77, 86, 78, 85, 87, 113, 
  98, 75, 75, 69, 68, 73, 91, 100, 66, 64, 
  76, 80, 86, 70, 85, 81, 83, 81, 67, 59, 
  83, 84, 79, 89, 99, 72, 84, 84, 92, 109, 
  79, 80, 78, 75, 74, 79, 79, 97, 91, 68, 
  77, 85, 102, 82, 78, 88, 86, 91, 80, 100, 
  86, 84, 78, 84, 99, 77, 82, 109, 86, 71, 
  80, 86, 67, 92, 72, 80, 91, 76, 89, 84, 
  83, 81, 75, 85, 103, 88, 83, 72, 87, 69, 
  75, 85, 77, 92, 88, 99, 63, 91, 97, 95, 
  82, 92, 90, 75, 83, 79, 84, 72, 87, 85, 
  75, 69, 90, 110, 86, 74, 85, 82, 77, 86, 
  91, 76, 95, 89, 81, 88, 77, 88, 100, 81, 
  77, 81, 85, 90, 85, 99, 83, 96, 88, 83, 
  80, 75, 92, 76, 97, 91, 71, 67, 101, 86, 
  98, 73, 84, 90, 87, 81, 66, 69, 85, 90, 
  83, 94, 93, 76, 77, 85, 92, 97, 83, 82, 
  74, 86, 86, 81, 86, 93, 83, 82, 84, 85, 
  100, 79, 88, 93, 77, 88, 89, 98, 88, 88, 
  80, 83, 100, 78, 88, 96, 82, 78, 82, 81, 
  75, 90, 80, 87, 88, 76, 90, 77, 70, 84, 
  76, 87, 111, 90, 75, 74, 79, 71, 81, 82, 
  67, 98, 85, 100, 65, 90, 98, 94, 81, 92, 
  87, 60, 86, 79, 88, 74, 101, 92, 85, 86, 
  68, 81, 84, 87, 90, 78, 82, 87, 105, 73, 
  91, 85, 72, 91, 78, 81, 115, 66, 75, 83, 
  74, 95, 78, 95, 76, 96, 88, 85, 80, 70, 
  65, 73, 84, 75, 76, 55, 94, 80, 81, 75, 
  87, 82, 88, 92, 66, 68, 74, 102, 78, 71, 
  90, 74, 79, 80, 87, 85, 80, 71, 83, 84, 
  75, 84, 92, 88, 83, 68, 69, 91, 101, 84, 
  118, 92, 82, 86, 90, 92, 91, 85, 69, 90, 
  91, 80, 93, 95, 71, 70, 80, 70, 72, 79, 
  77, 85, 80, 67, 89, 82, 73, 85, 75, 77, 
  104, 78, 73, 75, 75, 73, 82, 91, 65, 97, 
  90, 105, 69, 92, 103, 89, 82, 89, 82, 54, 
  85, 80, 91, 71, 94, 95, 90, 79, 69, 74, 
  84, 82, 87, 72, 86, 89, 107, 79, 94, 89, 
  64, 83, 74, 82, 105, 73, 79, 82, 74, 88, 
  75, 84, 77, 94, 92, 80, 81, 72, 59, 75, 
  85, 68, 72, 62, 80, 83, 70, 76, 82, 74, 
  94, 79, 63, 61, 71, 104, 78, 70, 87, 70, 
  79, 78, 86, 89, 78, 80, 80, 76, 70, 87, 
  87, 91, 78, 63, 73, 86, 103, 87, 120, 88, 
  81, 87, 93, 91, 94, 84, 65, 83, 92, 78, 
  81, 96, 66, 68, 79, 71, 59, 80, 76, 88, 
  82, 71, 86, 89, 86, 79, 74, 89, 102, 84, 
  73, 73, 82, 77, 78, 89, 69, 94, 90, 97, 
  67, 97, 92, 96, 82, 88, 84, 65, 86, 77, 
  85, 72, 90, 99, 83, 78, 83, 96, 87, 88, 
  84, 77, 81, 84, 96, 76, 91, 92, 66, 90, 
  78, 81, 106, 80, 74, 87, 78, 84, 82, 97, 
  81, 90, 87, 84, 83, 74, 77, 74, 90, 73, 
  80, 67, 85, 85, 88, 70, 85, 84, 88, 80, 
  61, 69, 77, 100, 80, 83, 88, 80, 82, 80, 
  85, 87, 81, 77, 80, 87, 76, 83, 94, 92, 
  81, 71, 75, 80, 97, 81, 109, 95, 77, 85, 
  90, 95, 92, 86, 73, 81, 97, 83, 93, 89, 
  75, 76, 80, 77, 76, 81, 78, 91, 80, 69, 
  92, 77, 79, 87, 77, 88, 93, 103, 75, 74, 
  84, 75, 79, 88, 75, 102, 86, 87, 76, 93, 
  92, 99, 82, 85, 92, 75, 96, 78, 81, 83, 
  93, 88, 88, 94, 83, 83, 90, 95, 87, 91, 
  89, 89, 84, 76, 78, 92, 84, 91, 79, 85, 
  104, 73, 75, 91, 83, 93, 82, 97, 81, 89, 
  84, 82, 80, 79, 86, 71, 99, 76, 91, 85, 
  96, 77, 94, 72, 91, 82, 79, 86, 75, 72, 
  77, 90, 89, 83, 90, 76, 86, 89, 87, 81, 
  78, 82, 85, 97, 81, 70, 102, 82, 95, 75, 
  84, 89, 91, 83, 96, 92, 83, 87, 79, 92, 
  89, 88, 88, 94, 93, 81, 90, 93, 85, 74, 
  83, 71, 94, 84, 89, 100, 75, 74, 91, 77, 
  77, 89, 76, 81, 89, 93, 75, 74, 85, 76, 
  79, 98, 74, 98, 87, 85, 81, 90, 86, 93, 
  82, 81, 92, 72, 97, 75, 85, 82, 88, 102, 
  93, 88, 84, 79, 83, 91, 89, 84, 82, 89, 
  87, 77, 79, 89, 81, 81, 81, 83, 98, 78, 
  73, 93, 82, 95, 83, 89, 83, 83, 81, 84, 
  78, 75, 81, 70, 103, 68, 92, 84, 88, 75, 
  84, 70, 94, 79, 86, 78, 72, 69, 76, 91, 
  93, 83, 91, 73, 81, 86, 87, 82, 75, 84, 
  85, 91, 79, 76, 108, 80, 87, 70, 80, 88, 
  92, 84, 98, 104, 83, 88, 85, 98, 89, 83, 
  86, 88, 94, 88, 90, 88, 77, 74, 81, 76, 
  87, 81, 90, 105, 72, 74, 83, 82, 88, 83, 
  76, 90, 88, 94, 78, 76, 87, 80, 78, 86, 
  74, 98, 89, 83, 77, 98, 78, 99, 86, 83, 
  91, 77, 98, 75, 78, 85, 86, 98, 88, 85, 
  89, 90, 85, 92, 85, 87, 85, 85, 88, 80, 
  78, 90, 86, 90, 80, 84, 99, 77, 72, 94, 
  79, 88, 85, 99, 87, 86, 83, 84, 82, 79, 
  88, 75, 108, 75, 90, 85, 86, 81, 91, 68, 
  96, 83, 81, 85, 70, 73, 79, 86, 93, 89, 
  88, 82, 79, 86, 84, 84, 79, 86, 82, 98, 
  79, 72, 105, 80, 82, 77, 89, 73, 91, 80, 
  97, 94, 86, 91, 88, 95, 79, 86, 88, 89, 
  96, 89, 99, 88, 84, 77, 82, 75, 90, 85, 
  92, 104, 78, 81, 92, 100, 91, 85, 70, 73, 
  90, 78, 86, 92, 102, 106, 88, 74, 93, 68, 
  80, 87, 85, 98, 92, 82, 87, 82, 89, 86, 
  82, 88, 81, 94, 104, 80, 92, 86, 89, 70, 
  90, 80, 98, 81, 94, 85, 94, 91, 85, 73, 
  80, 74, 74, 88, 86, 92, 93, 80, 85, 91, 
  66, 84, 76, 90, 89, 69, 93, 72, 78, 86, 
  83, 93, 76, 95, 68, 92, 84, 89, 84, 78, 
  89, 74, 81, 82, 85, 87, 76, 71, 94, 84, 
  84, 93, 93, 97, 70, 80, 92, 76, 65, 98, 
  99, 92, 67, 75, 91, 87, 84, 83, 85, 93, 
  79, 105, 72, 98, 81, 84, 97, 79, 92, 94, 
  77, 87, 78, 91, 101, 85, 65, 89, 80, 87, 
  91, 94, 86, 107, 95, 87, 81, 75, 79, 75, 
  88, 85, 86, 82, 74, 74, 71, 80, 87, 79, 
  80, 100, 70, 85, 77, 89, 95, 95, 76, 82, 
  91, 85, 84, 83, 84, 73, 87, 85, 74, 81, 
  111, 78, 85, 87, 92, 85, 86, 103, 97, 89, 
  90, 84, 80, 81, 89, 82, 85, 87, 68, 72, 
  80, 89, 77, 115, 82, 70, 73, 70, 78, 76, 
  85, 80, 99, 94, 75, 81, 85, 71, 91, 82, 
  83, 89, 80, 79, 88, 81, 86, 89, 84, 77, 
  90, 79, 65, 83, 84, 88, 63, 88, 93, 81, 
  58, 80, 77, 97, 90, 83, 91, 81, 68, 83, 
  83, 77, 80, 88, 79, 83, 75, 79, 86, 79, 
  72, 78, 86, 72, 85, 79, 82, 87, 87, 81, 
  91, 85, 107, 87, 83, 102, 72, 77, 81, 85, 
  73, 65, 85, 85, 50, 96, 94, 75, 78, 91, 
  89, 100, 85, 96, 81, 78, 72, 82, 84, 99, 
  83, 87, 77, 82, 85, 86, 78, 89, 90, 80, 
  81, 81, 67, 84, 84, 108, 102, 92, 95, 86, 
  80, 79, 84, 73, 85, 86, 99, 75, 81, 92, 
  70, 128, 85, 81, 74, 68, 62, 69, 113, 77, 
  69, 84, 82, 79, 78, 91, 84, 77, 74, 82, 
  82, 77, 83, 95, 76, 88, 82, 67, 78, 74, 
  87, 93, 99, 81, 87, 80, 84, 73, 76, 77, 
  80, 73, 80, 89, 89, 78, 70, 70, 78, 86, 
  83, 92, 68, 80, 73, 84, 90, 85, 78, 79, 
  88, 84, 88, 79, 96, 88, 79, 78, 88, 98, 
  88, 89, 69, 77, 95, 76, 75, 88, 103, 119, 
  110, 76, 95, 78, 93, 95, 92, 100, 85, 79, 
  75, 78, 85, 90, 74, 90, 87, 85, 114, 73, 
  104, 90, 99, 72, 77, 83, 98, 88, 81, 84, 
  101, 100, 81, 79, 81, 67, 62, 97, 84, 89, 
  89, 96, 85, 83, 63, 91, 73, 94, 81, 69, 
  85, 71, 72, 89, 88, 97, 82, 80, 77, 79, 
  77, 88, 82, 64, 68, 92, 74, 77, 93, 88, 
  82, 75, 101, 80, 87, 97, 93, 86, 72, 73, 
  72, 73, 66, 93, 93, 95, 80, 76, 79, 88, 
  83, 82, 85, 84, 80, 109, 74, 103, 91, 100, 
  95, 77, 87, 85, 72, 88, 92, 71, 91, 101, 
  66, 87, 83, 86, 97, 92, 82, 101, 101, 94, 
  84, 70, 78, 71, 96, 83, 87, 85, 91, 92, 
  69, 93, 82, 75, 78, 99, 59, 85, 75, 90, 
  87, 89, 70, 90, 97, 75, 75, 77, 81, 75, 
  90, 84, 71, 78, 90, 88, 75, 80, 104, 78, 
  80, 104, 93, 72, 87, 99, 78, 74, 87, 87, 
  74, 79, 73, 70, 85, 90, 78, 123, 78, 61, 
  68, 66, 83, 72, 98, 72, 90, 90, 70, 87, 
  82, 68, 86, 111, 75, 86, 85, 76, 98, 90, 
  81, 91, 83, 79, 82, 74, 57, 82, 81, 81, 
  55, 81, 89, 79, 68, 86, 69, 75, 85, 82, 
  81, 76, 76, 77, 85, 80, 79, 91, 66, 91, 
  68, 84, 110, 77, 73, 76, 85, 78, 90, 79, 
  84, 86, 71, 88, 87, 78, 77, 81, 73, 90, 
  66, 74, 86, 85, 69, 72, 85, 94, 57, 87, 
  75, 66, 79, 86, 101, 106, 74, 97, 74, 73, 
  77, 77, 93, 82, 75, 84, 68, 87, 69, 82, 
  81, 89, 82, 78, 88, 73, 56, 76, 89, 106, 
  79, 76, 96, 90, 79, 72, 86, 74, 82, 87, 
  106, 71, 100, 85, 79, 138, 99, 76, 57, 76, 
  64, 76, 107, 87, 73, 77, 92, 92, 78, 96, 
  84, 93, 82, 73, 78, 68, 82, 91, 71, 85, 
  88, 68, 72, 76, 79, 104, 99, 75, 93, 69, 
  86, 75, 95, 87, 82, 70, 88, 92, 84, 98, 
  79, 65, 78, 79, 79, 91, 66, 86, 75, 92, 
  98, 82, 69, 83, 83, 78, 84, 77, 93, 90, 
  69, 81, 81, 100, 87, 104, 67, 76, 90, 65, 
  79, 90, 97, 106, 112, 87, 81, 95, 94, 91, 
  92, 91, 83, 75, 79, 80, 69, 88, 79, 88, 
  84, 86, 94, 80, 88, 85, 90, 78, 90, 82, 
  90, 94, 89, 82, 82, 96, 77, 73, 82, 66, 
  71, 89, 78, 79, 93, 92, 81, 72, 69, 88, 
  83, 95, 83, 83, 79, 73, 81, 84, 92, 92, 
  97, 76, 82, 82, 87, 79, 82, 71, 76, 81, 
  75, 84, 86, 91, 80, 74, 86, 76, 90, 88, 
  95, 91, 66, 94, 86, 80, 70, 81, 90, 87, 
  95, 79, 83, 95, 81, 81, 88, 85, 81, 100, 
  71, 99, 81, 94, 87, 86, 96, 84, 68, 90, 
  96, 65, 89, 85, 68, 88, 89, 79, 101, 84, 
  84, 105, 94, 92, 78, 67, 81, 74, 83, 87, 
  80, 76, 92, 113, 62, 88, 76, 73, 77, 86, 
  73, 94, 99, 94, 70, 81, 79, 88, 96, 86, 
  73, 77, 68, 76, 68, 84, 89, 77, 75, 87, 
  93, 85, 87, 76, 76, 92, 79, 87, 104, 97, 
  77, 77, 89, 79, 72, 76, 82, 72, 91, 79, 
  86, 128, 87, 64, 68, 66, 85, 74, 105, 81, 
  79, 95, 87, 93, 82, 79, 89, 87, 70, 88, 
  81, 72, 92, 92, 75, 88, 82, 80, 83, 75, 
  61, 84, 96, 74, 66, 76, 86, 73, 74, 82, 
  77, 77, 87, 83, 77, 83, 71, 76, 86, 78, 
  74, 88, 68, 96, 83, 86, 127, 84, 75, 79, 
  84, 69, 88, 81, 87, 80, 72, 84, 94, 76, 
  60, 77, 70, 96, 75, 84, 79, 84, 68, 79, 
  84, 83, 61, 80, 70, 77, 83, 81, 119, 94, 
  67, 91, 72, 81, 81, 80, 84, 72, 81, 90, 
  64, 98, 48, 83, 83, 83, 75, 76, 81, 76, 
  59, 81, 91, 96, 67, 85, 97, 89, 87, 74, 
  87, 82, 90, 94, 98, 77, 89, 86, 83, 109, 
  108, 76, 65, 81, 68, 83, 95, 76, 100, 83, 
  95, 97, 79, 103, 79, 77, 91, 85, 80, 71, 
  80, 83, 72, 77, 88, 74, 79, 77, 87, 103, 
  100, 79, 100, 68, 87, 77, 86, 79, 82, 87, 
  91, 91, 89, 80, 86, 70, 95, 83, 78, 86, 
  71, 84, 69, 77, 81, 80, 66, 86, 86, 79, 
  91, 85, 96, 89, 76, 78, 86, 89, 68, 89, 
  89, 106, 93, 92, 84, 82, 80, 90, 87, 86, 
  79, 82, 83, 98, 82, 79, 86, 85, 82, 74, 
  72, 90, 82, 88, 85, 92, 84, 75, 99, 80, 
  112, 104, 77, 91, 94, 81, 75, 79, 79, 78, 
  78, 83, 88, 88, 91, 90, 67, 91, 79, 82, 
  80, 89, 75, 86, 80, 92, 78, 83, 78, 79, 
  76, 80, 87, 86, 87, 79, 101, 103, 104, 77, 
  87, 92, 79, 103, 86, 66, 76, 85, 92, 77, 
  85, 85, 86, 88, 81, 69, 83, 89, 87, 103, 
  81, 84, 89, 86, 80, 89, 63, 76, 80, 88, 
  81, 77, 80, 84, 70, 86, 84, 75, 89, 89, 
  79, 91, 94, 86, 89, 82, 87, 80, 84, 93, 
  74, 81, 88, 83, 81, 95, 66, 91, 70, 95, 
  90, 100, 97, 86, 74, 84, 73, 74, 85, 82, 
  88, 106, 81, 74, 90, 79, 95, 84, 79, 82, 
  93, 94, 75, 103, 79, 94, 91, 59, 106, 89, 
  73, 105, 71, 63, 77, 74, 85, 74, 74, 108, 
  84, 95, 87, 88, 64, 80, 86, 62, 96, 65, 
  90, 68, 80, 102, 82, 84, 78, 76, 81, 72, 
  93, 91, 77, 78, 77, 96, 118, 85, 90, 93, 
  87, 95, 79, 58, 65, 70, 93, 104, 55, 75, 
  85, 55, 64, 87, 88, 77, 89, 119, 87, 77, 
  89, 90, 79, 92, 62, 95, 82, 86, 94, 89, 
  87, 82, 78, 94, 86, 81, 89, 90, 66, 89, 
  94, 93, 97, 88, 96, 82, 94, 94, 61, 80, 
  93, 86, 85, 87, 90, 89, 87, 89, 92, 90, 
  83, 79, 79, 93, 81, 102, 82, 83, 81, 93, 
  83, 77, 77, 89, 98, 76, 81, 88, 83, 86, 
  79, 102, 88, 83, 98, 87, 99, 96, 83, 87, 
  85, 75, 76, 81, 85, 80, 74, 83, 84, 102, 
  91, 88, 64, 98, 78, 79, 85, 82, 72, 87, 
  82, 87, 79, 83, 76, 81, 84, 79, 90, 85, 
  87, 70, 76, 103, 103, 84, 85, 87, 76, 90, 
  86, 73, 77, 92, 95, 92, 88, 87, 86, 91, 
  85, 73, 87, 81, 86, 94, 84, 83, 89, 86, 
  80, 93, 62, 92, 82, 88, 80, 80, 79, 86, 
  73, 83, 102, 78, 85, 87, 91, 81, 91, 87, 
  86, 82, 74, 76, 80, 87, 75, 79, 84, 82, 
  88, 85, 58, 87, 92, 88, 61, 88, 103, 78, 
  81, 108, 86, 88, 74, 73, 81, 75, 80, 77, 
  75, 72, 68, 72, 77, 76, 81, 82, 94, 86, 
  72, 81, 90, 100, 93, 82, 79, 93, 117, 74, 
  78, 71, 90, 97, 80, 77, 84, 91, 78, 80, 
  89, 93, 78, 94, 67, 132, 82, 100, 90, 70, 
  76, 72, 92, 67, 70, 72, 88, 74, 78, 73, 
  97, 92, 90, 74, 79, 81, 77, 69, 83, 73, 
  71, 121, 84, 92, 88, 85, 85, 104, 88, 78, 
  68, 93, 81, 77, 88, 73, 89, 88, 73, 83, 
  73, 71, 80, 87, 65, 73, 77, 90, 72, 89, 
  82, 75, 77, 81, 106, 77, 70, 80, 71, 77, 
  75, 66, 70, 86, 86, 83, 86, 79, 85, 81, 
  86, 76, 103, 75, 57, 85, 108, 73, 85, 105, 
  82, 124, 74, 70, 90, 59, 83, 83, 76, 85, 
  75, 70, 71, 67, 75, 78, 103, 80, 82, 73, 
  69, 86, 85, 79, 70, 91, 112, 68, 82, 75, 
  80, 105, 86, 59, 82, 76, 72, 70, 94, 116, 
  72, 86, 65, 115, 78, 102, 89, 72, 68, 67, 
  92, 71, 62, 78, 85, 71, 78, 66, 91, 85, 
  79, 72, 85, 66, 73, 76, 80, 69, 68, 122, 
  84, 85, 100, 82, 72, 121, 106, 71, 67, 84, 
  84, 63, 79, 67, 84, 89, 76, 88, 66, 67, 
  83, 84, 63, 80, 69, 103, 74, 90, 103, 75, 
  70, 76, 124, 67, 74, 75, 71, 71, 83, 67, 
  62, 87, 89, 80, 81, 78, 82, 84, 103, 89, 
  88, 76, 65, 93, 100, 78, 78, 111, 74, 116, 
  78, 75, 82, 72, 81, 83, 88, 76, 88, 79, 
  72, 78, 87, 83, 87, 83, 87, 80, 90, 79, 
  94, 87, 88, 92, 79, 71, 88, 75, 76, 90, 
  79, 86, 77, 79, 78, 84, 75, 91, 83, 87, 
  79, 76, 83, 93, 86, 70, 78, 75, 84, 71, 
  74, 71, 93, 73, 79, 76, 72, 91, 101, 84, 
  86, 81, 79, 92, 75, 78, 71, 114, 90, 74, 
  81, 87, 78, 98, 85, 77, 77, 80, 86, 83, 
  82, 73, 91, 89, 86, 88, 70, 69, 85, 87, 
  71, 74, 76, 89, 74, 93, 100, 83, 74, 87, 
  107, 77, 84, 79, 76, 84, 91, 69, 79, 86, 
  78, 86, 84, 81, 86, 87, 81, 89, 79, 89, 
  76, 81, 95, 82, 84, 101, 78, 115, 78, 80, 
  83, 82, 86, 77, 80, 79, 70, 79, 81, 69, 
  82, 89, 91, 77, 86, 87, 89, 100, 74, 77, 
  71, 94, 86, 79, 81, 77, 103, 93, 84, 99, 
  84, 92, 79, 87, 97, 99, 88, 83, 70, 59, 
  88, 92, 87, 72, 87, 87, 88, 73, 85, 72, 
  92, 82, 85, 80, 71, 83, 86, 78, 89, 83, 
  78, 66, 74, 84, 69, 99, 87, 90, 83, 97, 
  90, 101, 81, 111, 72, 105, 83, 70, 90, 72, 
  88, 87, 77, 86, 76, 75, 83, 88, 89, 73, 
  83, 84, 62, 95, 98, 85, 79, 92, 112, 79, 
  70, 88, 73, 88, 79, 68, 74, 78, 83, 93, 
  86, 75, 87, 84, 86, 80, 98, 78, 78, 79, 
  95, 81, 88, 93, 94, 115, 78, 68, 86, 65, 
  78, 86, 89, 82, 76, 78, 71, 67, 78, 80, 
  96, 67, 86, 78, 79, 112, 71, 88, 64, 85, 
  120, 90, 87, 75, 90, 105, 101, 71, 83, 76, 
  77, 78, 104, 107, 80, 82, 58, 99, 86, 100, 
  84, 65, 74, 79, 83, 80, 77, 77, 88, 79, 
  98, 70, 93, 75, 80, 74, 91, 76, 74, 79, 
  74, 89, 69, 96, 79, 74, 99, 109, 86, 121, 
  83, 92, 69, 98, 76, 58, 76, 71, 82, 92, 
  75, 87, 73, 66, 85, 85, 79, 74, 78, 91, 
  61, 91, 97, 76, 76, 84, 88, 70, 78, 82, 
  63, 85, 86, 61, 60, 83, 95, 86, 77, 72, 
  84, 88, 80, 93, 76, 76, 77, 85, 95, 87, 
  83, 101, 84, 81, 86, 83, 83, 85, 87, 91, 
  100, 69, 97, 78, 79, 75, 85, 92, 81, 71, 
  87, 90, 93, 83, 78, 86, 80, 94, 104, 77, 
  88, 74, 84, 89, 85, 97, 78, 73, 83, 92, 
  85, 78, 90, 84, 77, 117, 92, 92, 82, 78, 
  84, 90, 95, 75, 80, 72, 93, 91, 82, 89, 
  87, 90, 96, 79, 96, 82, 81, 90, 81, 82, 
  69, 94, 86, 78, 80, 97, 90, 85, 68, 103, 
  80, 92, 82, 79, 75, 73, 90, 89, 91, 85, 
  75, 80, 87, 89, 92, 73, 86, 84, 64, 93, 
  78, 91, 81, 88, 75, 83, 86, 85, 83, 84, 
  101, 71, 84, 81, 79, 94, 92, 82, 89, 60, 
  91, 101, 83, 98, 78, 99, 82, 84, 82, 76, 
  89, 88, 76, 100, 83, 86, 80, 82, 89, 88, 
  79, 81, 86, 81, 80, 79, 93, 74, 76, 84, 
  77, 89, 94, 86, 89, 89, 81, 76, 93, 79, 
  90, 85, 91, 88, 76, 79, 75, 86, 93, 94, 
  93, 87, 81, 87, 89, 95, 83, 80, 87, 84, 
  96, 96, 95, 75, 83, 86, 89, 73, 60, 75, 
  113, 84, 83, 72, 82, 92, 94, 68, 90, 84, 
  82, 71, 88, 76, 94, 77, 96, 75, 84, 103, 
  85, 70, 108, 78, 81, 83, 82, 70, 86, 52, 
  79, 88, 81, 80, 84, 86, 78, 91, 88, 83, 
  78, 90, 98, 74, 106, 77, 80, 77, 86, 91, 
  92, 82, 96, 84, 82, 81, 94, 108, 46, 82, 
  77, 71, 79, 91, 65, 93, 85, 84, 84, 100, 
  75, 77, 72, 86, 87, 79, 81, 67, 60, 107, 
  85, 81, 95, 90, 93, 56, 74, 81, 100, 86, 
  65, 50, 65, 73, 78, 53, 76, 88, 86, 68, 
  85, 82, 85, 97, 81, 90, 89, 57, 91, 77, 
  102, 78, 84, 85, 92, 73, 116, 80, 104, 98, 
  53, 84, 145, 82, 95, 122, 42, 66, 102, 105, 
  81, 75, 84, 81, 89, 60, 82, 82, 90, 69, 
  71, 86, 78, 106, 75, 77, 89, 123, 98, 70, 
  91, 67, 88, 78, 78, 83, 77, 153, 88, 86, 
  93, 102, 97, 82, 99, 101, 73, 87, 78, 70, 
  83, 99, 59, 82, 99, 79, 87, 99, 95, 79, 
  88, 86, 85, 119, 86, 109, 69, 88, 79, 108, 
  85, 102, 83, 91, 80, 86, 79, 67, 86, 89, 
  77, 91, 90, 88, 80, 79, 73, 92, 87, 95, 
  92, 83, 80, 67, 74, 84, 91, 102, 77, 83, 
  64, 77, 82, 86, 86, 94, 99, 87, 90, 93, 
  87, 108, 88, 96, 94, 78, 85, 90, 101, 85, 
  100, 84, 90, 80, 102, 79, 74, 63, 59, 87, 
  77, 83, 94, 66, 90, 83, 100, 83, 97, 77, 
  90, 83, 71, 88, 83, 87, 91, 82, 81, 75, 
  88, 84, 87, 75, 77, 81, 91, 82, 88, 76, 
  80, 80, 82, 84, 63, 123, 88, 88, 89, 78, 
  89, 89, 91, 94, 83, 73, 85, 90, 59, 67, 
  43, 77, 96, 79, 76, 100, 88, 89, 98, 73, 
  91, 108, 87, 78, 104, 92, 78, 74, 83, 77, 
  77, 87, 81, 79, 83, 123, 79, 87, 78, 67, 
  74, 82, 81, 81, 70, 77, 79, 75, 97, 87, 
  91, 74, 85, 80, 75, 75, 81, 79, 85, 82, 
  77, 76, 89, 92, 84, 85, 80, 74, 80, 79, 
  84, 69, 87, 92, 90, 85, 77, 72, 79, 91, 
  84, 71, 90, 92, 100, 90, 85, 78, 66, 63, 
  105, 91, 45, 80, 90, 81, 80, 75, 66, 73, 
  102, 64, 87, 92, 79, 71, 83, 87, 84, 83, 
  97, 89, 91, 103, 83, 67, 95, 84, 86, 86, 
  81, 75, 92, 80, 84, 91, 91, 81, 83, 85, 
  79, 73, 87, 80, 76, 79, 102, 70, 81, 86, 
  79, 86, 75, 79, 81, 73, 90, 95, 82, 82, 
  113, 101, 85, 79, 85, 113, 82, 69, 59, 93, 
  86, 86, 99, 129, 67, 67, 81, 72, 85, 84, 
  81, 90, 80, 97, 84, 72, 91, 91, 87, 61, 
  79, 89, 86, 95, 74, 97, 66, 75, 84, 51, 
  74, 100, 81, 78, 89, 87, 75, 135, 84, 55, 
  72, 63, 82, 79, 74, 59, 67, 65, 85, 68, 
  109, 99, 87, 72, 70, 87, 109, 67, 117, 92, 
  59, 83, 82, 86, 83, 69, 67, 93, 68, 83, 
  82, 77, 89, 88, 80, 91, 87, 123, 52, 79, 
  78, 87, 91, 74, 88, 90, 81, 84, 83, 80, 
  70, 137, 90, 88, 86, 88, 105, 81, 79, 69, 
  77, 87, 69, 86, 71, 89, 80, 97, 91, 74, 
  73, 81, 75, 71, 96, 83, 88, 99, 89, 73, 
  90, 89, 68, 107, 78, 98, 83, 81, 83, 77, 
  86, 83, 79, 86, 85, 89, 84, 74, 82, 85, 
  81, 77, 78, 79, 89, 82, 86, 72, 73, 77, 
  86, 98, 90, 96, 81, 97, 97, 87, 100, 93, 
  85, 97, 88, 80, 82, 85, 88, 78, 94, 86, 
  80, 86, 76, 84, 86, 74, 80, 84, 77, 88, 
  86, 61, 74, 87, 77, 66, 95, 67, 98, 84, 
  95, 85, 86, 76, 77, 87, 73, 91, 82, 84, 
  83, 89, 78, 84, 97, 89, 76, 73, 88, 93, 
  84, 68, 93, 81, 78, 86, 82, 76, 68, 57, 
  82, 86, 61, 79, 76, 86, 67, 81, 80, 71, 
  78, 92, 70, 71, 92, 79, 80, 69, 81, 80, 
  92, 77, 90, 74, 85, 89, 82, 70, 99, 83, 
  89, 84, 89, 74, 73, 79, 74, 89, 85, 107, 
  79, 87, 84, 85, 81, 80, 84, 80, 84, 79, 
  86, 74, 100, 84, 92, 74, 90, 82, 86, 80, 
  81, 97, 78, 88, 88, 74, 81, 100, 94, 98, 
  67, 82, 80, 77, 94, 73, 80, 98, 88, 80, 
  65, 85, 78, 71, 86, 77, 96, 89, 73, 81, 
  89, 69, 79, 77, 96, 83, 68, 76, 84, 80, 
  86, 81, 71, 90, 88, 74, 89, 80, 88, 84, 
  88, 83, 92, 86, 72, 90, 96, 87, 85, 84, 
  77, 89, 82, 87, 88, 72, 85, 73, 82, 90, 
  88, 74, 86, 78, 75, 74, 85, 72, 82, 94, 
  85, 82, 94, 83, 84, 92, 76, 86, 85, 74, 
  88, 91, 86, 79, 85, 75, 91, 82, 91, 87, 
  83, 75, 77, 82, 79, 84, 94, 87, 75, 77, 
  88, 82, 87, 77, 90, 99, 86, 70, 77, 70, 
  86, 85, 84, 67, 68, 86, 80, 90, 104, 99, 
  85, 82, 92, 81, 93, 96, 91, 95, 79, 89, 
  74, 81, 89, 76, 88, 95, 82, 79, 59, 71, 
  68, 60, 84, 77, 84, 92, 80, 77, 89, 82, 
  72, 76, 102, 73, 87, 87, 86, 85, 76, 84, 
  74, 95, 84, 84, 89, 78, 86, 90, 74, 82, 
  94, 95, 60, 81, 85, 83, 86, 79, 88, 90, 
  81, 83, 84, 74, 81, 66, 81, 86, 73, 74, 
  81, 82, 69, 73, 80, 75, 76, 94, 82, 68, 
  114, 76, 83, 86, 84, 88, 82, 76, 96, 82, 
  84, 81, 81, 66, 82, 94, 88, 70, 79, 96, 
  80, 75, 80, 84, 79, 87, 73, 87, 88, 83, 
  86, 79, 81, 82, 80, 77, 79, 84, 94, 77, 
  83, 74, 83, 81, 84, 89, 77, 86, 90, 94, 
  100, 80, 91, 97, 83, 98, 72, 80, 90, 64, 
  86, 76, 96, 91, 84, 87, 72, 81, 87, 80, 
  82, 80, 86, 80, 90, 75, 80, 88, 87, 74, 
  95, 87, 101, 67, 85, 88, 83, 82, 82, 75, 
  97, 86, 87, 81, 83, 82, 78, 81, 87, 84, 
  78, 88, 84, 97, 88, 77, 86, 80, 85, 83, 
  86, 82, 76, 77, 82, 85, 84, 83, 78, 84, 
  78, 82, 80, 69, 86, 80, 93, 83, 99, 78, 
  81, 83, 83, 79, 96, 82, 85, 85, 81, 83, 
  88, 83, 81, 85, 83, 85, 79, 78, 79, 82, 
  81, 78, 85, 88, 81, 88, 89, 79, 83, 89, 
  85, 87, 84, 96, 88, 84, 83, 86, 82, 89, 
  85, 80, 86, 85, 87, 89, 82, 86, 87, 81, 
  79, 90, 87, 91, 91, 86, 91, 85, 78, 81, 
  82, 82, 79, 87, 77, 83, 80, 91, 85, 95, 
  78, 88, 91, 85, 86, 77, 82, 86, 80, 91, 
  85, 79, 75, 76, 82, 82, 88, 83, 77, 86, 
  90, 84, 87, 89, 77, 78, 93, 82, 85, 82, 
  81, 83, 78, 90, 82, 78, 75, 87, 85, 82, 
  85, 84, 89, 84, 87, 75, 81, 85, 80, 85, 
  86, 84, 88, 87, 85, 83, 86, 75, 87, 83, 
  95, 86, 80, 74, 87, 82, 82, 80, 85, 84, 
  86, 81, 80, 85, 75, 73, 79, 80, 79, 76, 
  83, 86, 84, 86, 89, 77, 81, 88, 83, 88, 
  86, 94, 85, 80, 83, 85, 72, 87, 79, 79, 
  89, 80, 87, 83, 85, 81, 86, 76, 78, 90, 
  80, 89, 86, 84, 92, 83, 80, 79, 82, 79, 
  77, 84, 76, 83, 80, 85, 83, 91, 79, 89, 
  89, 82, 87, 76, 80, 86, 80, 90, 83, 79, 
  75, 72, 84, 80, 91, 84, 79, 87, 85, 83, 
  84, 84, 75, 76, 90, 83, 80, 87, 79, 81, 
  76, 84, 81, 74, 74, 88, 84, 79, 86, 85, 
  88, 81, 86, 77, 83, 83, 76, 85, 83, 87, 
  82, 90, 80, 83, 82, 73, 87, 80, 89, 86, 
  77, 77, 86, 78, 83, 82, 87, 85, 89, 83, 
  82, 83, 81, 77, 80, 85, 84, 78, 85, 87, 
  83, 91, 89, 84, 84, 95, 90, 83, 87, 92, 
  85, 81, 88, 86, 82, 82, 87, 86, 89, 85, 
  85, 90, 80, 82, 83, 84, 83, 87, 88, 92, 
  91, 84, 87, 83, 78, 82, 80, 80, 78, 86, 
  78, 89, 81, 87, 90, 90, 82, 89, 91, 88, 
  87, 80, 78, 87, 79, 90, 86, 80, 80, 75, 
  88, 86, 85, 92, 82, 83, 90, 81, 88, 82, 
  76, 77, 89, 83, 82, 89, 81, 86, 84, 90, 
  82, 83, 81, 87, 85, 76, 86, 84, 86, 80, 
  88, 78, 86, 86, 81, 87, 84, 87, 84, 95, 
  81, 80, 84, 76, 83, 82, 91, 86, 82, 78, 
  91, 79, 81, 80, 85, 77, 79, 85, 80, 87, 
  77, 83, 80, 79, 84, 80, 80, 84, 84, 82, 
  84, 82, 84, 84, 82, 79, 79, 99, 91, 93, 
  82, 89, 81, 91, 90, 85, 89, 82, 89, 87, 
  85, 78, 85, 83, 79, 99, 91, 86, 92, 77, 
  87, 82, 82, 84, 90, 81, 84, 86, 83, 84, 
  84, 86, 84, 88, 84, 88, 92, 89, 83, 79, 
  84, 86, 80, 90, 77, 77, 75, 74, 80, 85, 
  93, 82, 72, 94, 87, 73, 85, 86, 80, 82, 
  85, 83, 88, 84, 82, 84, 81, 93, 77, 77, 
  84, 90, 83, 94, 76, 82, 88, 87, 86, 81, 
  79, 81, 81, 81, 87, 84, 88, 85, 87, 85, 
  84, 78, 88, 86, 91, 80, 72, 82, 82, 87, 
  79, 77, 81, 78, 77, 79, 75, 82, 77, 79, 
  78, 80, 85, 82, 75, 84, 87, 81, 81, 79, 
  81, 81, 82, 81, 85, 101, 83, 90, 79, 89, 
  65, 87, 83, 82, 92, 76, 85, 80, 89, 77, 
  85, 78, 82, 101, 79, 85, 90, 72, 85, 83, 
  86, 85, 85, 81, 81, 83, 87, 83, 87, 83, 
  87, 84, 83, 92, 91, 91, 79, 84, 80, 88, 
  84, 85, 79, 81, 76, 72, 83, 90, 96, 81, 
  75, 96, 83, 75, 81, 79, 82, 80, 81, 86, 
  85, 87, 83, 79, 81, 88, 73, 72, 80, 92, 
  88, 100, 75, 83, 92, 84, 87, 84, 79, 77, 
  77, 79, 86, 83, 84, 81, 84, 88, 78, 82, 
  92, 85, 80, 73, 71, 85, 84, 80, 78, 81, 
  88, 82, 79, 86, 82, 82, 75, 80, 79, 84, 
  87, 81, 83, 87, 83, 83, 86, 86, 85, 92, 
  89, 75, 90, 92, 82, 89, 87, 88, 80, 81, 
  93, 88, 92, 83, 87, 85, 85, 79, 83, 77, 
  82, 87, 87, 89, 86, 78, 80, 84, 80, 82, 
  85, 78, 82, 82, 82, 88, 81, 85, 90, 91, 
  85, 83, 90, 86, 84, 76, 77, 86, 81, 88, 
  82, 78, 80, 76, 86, 86, 91, 93, 80, 86, 
  86, 78, 85, 78, 79, 85, 86, 83, 84, 89, 
  81, 85, 85, 91, 82, 79, 89, 88, 87, 84, 
  79, 83, 85, 83, 88, 81, 84, 82, 86, 83, 
  88, 86, 88, 87, 83, 78, 79, 81, 84, 83, 
  84, 86, 74, 80, 84, 86, 80, 79, 87, 78, 
  85, 94, 84, 75, 97, 87, 81, 84, 89, 80, 
  89, 89, 70, 91, 91, 91, 87, 88, 94, 84, 
  79, 82, 84, 83, 86, 90, 171, 80, 94, 90, 
  86, 94, 86, 81, 85, 96, 81, 115, 93, 77, 
  90, 87, 82, 75, 77, 83, 80, 86, 79, 94, 
  83, 96, 77, 81, 79, 95, 80, 102, 82, 82, 
  91, 94, 81, 86, 96, 80, 76, 84, 76, 80, 
  81, 82, 78, 81, 91, 83, 92, 67, 89, 72, 
  86, 83, 78, 89, 86, 86, 96, 80, 81, 94, 
  82, 87, 90, 85, 85, 88, 79, 85, 87, 80, 
  81, 88, 80, 79, 86, 91, 86, 81, 81, 82, 
  85, 85, 86, 78, 84, 83, 83, 81, 84, 92, 
  68, 78, 78, 82, 90, 80, 86, 78, 83, 87, 
  79, 76, 97, 85, 80, 83, 90, 81, 85, 82, 
  70, 83, 90, 91, 86, 85, 92, 84, 80, 79, 
  81, 82, 86, 90, 181, 85, 85, 88, 87, 83, 
  75, 78, 92, 96, 86, 118, 100, 76, 89, 87, 
  83, 76, 73, 80, 84, 84, 75, 90, 80, 93, 
  84, 80, 82, 93, 81, 94, 86, 86, 93, 100, 
  80, 91, 93, 79, 76, 90, 82, 80, 79, 87, 
  78, 86, 91, 81, 89, 66, 84, 72, 84, 77, 
  81, 88, 79, 90, 94, 78, 84, 94, 82, 82, 
  86, 83, 87, 87, 80, 94, 92, 82, 84, 85, 
  76, 79, 85, 89, 79, 77, 78, 81, 80, 77, 
  79, 84, 82, 87, 85, 82, 80, 83, 65, 77, 
  78, 77, 87, 82, 86, 83, 89, 93, 86, 79, 
  94, 87, 81, 85, 89, 81, 92, 80, 70, 89, 
  90, 96, 88, 96, 90, 76, 81, 78, 85, 79, 
  90, 88, 167, 89, 91, 95, 87, 86, 75, 81, 
  82, 100, 89, 112, 90, 68, 91, 89, 77, 79, 
  78, 80, 78, 84, 74, 84, 80, 92, 80, 89, 
  83, 94, 87, 101, 80, 76, 87, 91, 83, 86, 
  85, 79, 75, 87, 86, 77, 83, 81, 83, 87, 
  89, 87, 93, 64, 85, 75, 85, 81, 76, 92, 
  84, 85, 90, 82, 80, 90, 84, 84, 87, 81, 
  86, 85, 87, 79, 87, 76, 80, 86, 79, 84, 
  91, 90, 85, 88, 79, 83, 84, 81, 82, 78, 
  79, 84, 82, 79, 92, 99, 72, 80, 81, 86, 
  90, 79, 79, 102, 74, 94, 70, 71, 77, 94, 
  100, 92, 72, 78, 99, 72, 66, 79, 81, 80, 
  81, 83, 68, 92, 90, 85, 79, 91, 106, 94, 
  111, 88, 60, 81, 71, 83, 60, 91, 112, 82, 
  96, 80, 91, 69, 106, 70, 72, 89, 71, 94, 
  91, 83, 82, 87, 89, 74, 100, 96, 95, 60, 
  79, 81, 86, 85, 53, 90, 62, 68, 94, 90, 
  83, 113, 89, 77, 116, 66, 82, 98, 84, 78, 
  82, 77, 85, 77, 91, 90, 83, 78, 94, 71, 
  69, 85, 81, 99, 73, 98, 112, 82, 88, 78, 
  77, 112, 94, 91, 95, 92, 70, 80, 64, 79, 
  82, 66, 77, 41, 79, 92, 106, 91, 80, 75, 
  79, 91, 78, 86, 83, 89, 78, 73, 85, 61, 
  78, 78, 82, 94, 71, 80, 66, 99, 100, 96, 
  73, 72, 81, 85, 65, 72, 76, 66, 71, 82, 
  89, 95, 93, 82, 75, 76, 111, 93, 112, 81, 
  48, 81, 59, 82, 61, 96, 110, 86, 82, 72, 
  95, 63, 69, 62, 72, 97, 78, 78, 97, 75, 
  91, 96, 83, 64, 108, 88, 98, 55, 77, 78, 
  77, 96, 49, 81, 66, 66, 77, 74, 77, 114, 
  123, 75, 113, 71, 85, 101, 88, 94, 74, 73, 
  80, 71, 92, 99, 76, 86, 90, 73, 67, 69, 
  81, 94, 76, 84, 130, 79, 87, 76, 62, 118, 
  96, 84, 87, 93, 64, 76, 66, 76, 67, 68, 
  80, 38, 74, 87, 120, 83, 91, 79, 68, 83, 
  74, 83, 72, 87, 74, 72, 76, 58, 74, 74, 
  78, 88, 81, 79, 70, 94, 91, 94, 78, 79, 
  90, 89, 67, 78, 88, 73, 82, 79, 109, 84, 
  81, 96, 88, 84, 102, 90, 91, 78, 79, 73, 
  80, 81, 61, 88, 85, 87, 76, 83, 84, 74, 
  55, 74, 82, 86, 85, 72, 90, 85, 87, 86, 
  90, 73, 97, 76, 99, 66, 84, 81, 76, 85, 
  73, 92, 64, 75, 94, 87, 82, 108, 65, 66, 
  122, 68, 83, 103, 90, 80, 64, 84, 83, 79, 
  91, 99, 83, 84, 91, 68, 82, 79, 86, 81, 
  83, 94, 115, 86, 87, 82, 65, 108, 84, 86, 
  93, 96, 81, 79, 68, 75, 79, 78, 87, 47, 
  75, 91, 106, 97, 83, 82, 81, 84, 84, 81, 
  87, 84, 83, 81, 90, 59, 71, 82, 78, 77, 
  61, 91, 88, 74, 90, 79, 79, 64, 90, 108, 
  83, 72, 85, 81, 69, 82, 92, 88, 83, 82, 
  84, 94, 91, 91, 96, 107, 109, 74, 72, 75, 
  78, 75, 94, 79, 77, 72, 81, 85, 91, 89, 
  68, 68, 81, 90, 79, 87, 82, 102, 80, 80, 
  87, 86, 74, 87, 66, 103, 97, 78, 55, 89, 
  87, 63, 99, 89, 79, 98, 60, 82, 77, 90, 
  91, 66, 83, 73, 93, 75, 86, 90, 76, 81, 
  84, 88, 89, 90, 87, 84, 68, 78, 72, 96, 
  70, 88, 97, 92, 80, 65, 90, 72, 95, 78, 
  84, 75, 79, 94, 84, 76, 85, 70, 84, 77, 
  91, 80, 87, 79, 82, 124, 108, 94, 87, 80, 
  76, 85, 81, 86, 66, 91, 64, 78, 66, 72, 
  85, 75, 108, 74, 78, 62, 95, 74, 80, 76, 
  85, 81, 65, 90, 95, 72, 84, 84, 86, 100, 
  100, 97, 97, 84, 107, 68, 64, 68, 90, 74, 
  99, 76, 77, 85, 74, 68, 103, 94, 55, 82, 
  87, 71, 70, 82, 89, 96, 79, 72, 77, 94, 
  70, 87, 58, 110, 82, 66, 54, 87, 65, 42, 
  93, 86, 76, 71, 102, 71, 75, 88, 93, 60, 
  81, 83, 118, 67, 84, 92, 81, 83, 86, 86, 
  81, 80, 107, 80, 71, 89, 75, 94, 73, 92, 
  89, 88, 62, 55, 91, 68, 87, 76, 84, 63, 
  78, 99, 98, 78, 94, 64, 78, 79, 92, 64, 
  69, 73, 68, 115, 96, 95, 88, 78, 75, 90, 
  77, 87, 68, 84, 62, 77, 77, 79, 72, 79, 
  104, 88, 80, 65, 73, 61, 82, 75, 81, 71, 
  73, 85, 81, 81, 85, 90, 92, 92, 86, 85, 
  92, 66, 110, 78, 68, 74, 84, 85, 102, 76, 
  81, 73, 79, 91, 77, 80, 77, 93, 93, 81, 
  88, 79, 81, 90, 81, 72, 100, 90, 82, 74, 
  75, 95, 88, 85, 65, 83, 72, 59, 85, 82, 
  89, 93, 117, 74, 90, 75, 98, 78, 91, 91, 
  109, 70, 81, 85, 82, 89, 81, 81, 82, 82, 
  87, 82, 65, 82, 77, 88, 103, 85, 89, 84, 
  63, 85, 91, 89, 97, 80, 81, 74, 78, 88, 
  93, 70, 85, 60, 78, 82, 85, 82, 73, 81, 
  74, 107, 82, 88, 85, 80, 81, 81, 84, 79, 
  94, 66, 73, 88, 70, 101, 92, 78, 70, 83, 
  78, 83, 82, 82, 87, 82, 92, 92, 81, 88, 
  88, 87, 82, 69, 71, 95, 76, 84, 91, 105, 
  118, 84, 96, 90, 92, 88, 83, 89, 88, 71, 
  78, 86, 85, 96, 83, 70, 93, 99, 79, 85, 
  89, 81, 87, 100, 91, 86, 73, 96, 94, 74, 
  93, 89, 77, 84, 97, 88, 91, 84, 89, 64, 
  93, 87, 75, 99, 94, 72, 73, 95, 83, 86, 
  82, 76, 78, 91, 83, 84, 87, 94, 78, 83, 
  77, 77, 88, 84, 70, 87, 97, 93, 102, 76, 
  78, 90, 88, 82, 93, 85, 90, 97, 65, 81, 
  82, 96, 94, 74, 69, 77, 72, 90, 88, 96, 
  88, 78, 86, 84, 88, 78, 82, 85, 94, 79, 
  77, 88, 65, 82, 90, 72, 72, 81, 76, 84, 
  92, 86, 95, 80, 97, 99, 84, 98, 86, 88, 
  83, 67, 75, 88, 72, 83, 84, 89, 128, 84, 
  108, 94, 93, 82, 88, 91, 84, 72, 78, 101, 
  96, 101, 83, 59, 101, 87, 66, 89, 91, 81, 
  83, 102, 80, 79, 78, 95, 93, 76, 85, 79, 
  78, 84, 79, 83, 101, 89, 91, 69, 71, 84, 
  69, 92, 92, 68, 70, 101, 77, 87, 82, 68, 
  72, 86, 98, 85, 78, 86, 80, 82, 76, 77, 
  93, 89, 63, 91, 93, 94, 89, 69, 71, 65, 
  85, 78, 85, 91, 84, 101, 65, 84, 83, 99, 
  89, 76, 80, 86, 68, 95, 100, 79, 78, 82, 
  78, 87, 78, 77, 86, 91, 80, 96, 86, 87, 
  80, 83, 76, 79, 88, 85, 80, 80, 77, 82, 
  83, 85, 89, 83, 84, 89, 79, 92, 94, 75, 
  82, 96, 71, 81, 86, 80, 118, 83, 86, 84, 
  90, 98, 83, 90, 81, 81, 85, 82, 89, 84, 
  84, 81, 104, 104, 81, 83, 88, 85, 83, 86, 
  86, 65, 75, 91, 86, 79, 82, 95, 80, 77, 
  98, 72, 93, 83, 95, 75, 100, 87, 80, 89, 
  87, 77, 83, 95, 93, 76, 79, 77, 81, 95, 
  78, 90, 75, 87, 84, 85, 71, 82, 90, 87, 
  80, 86, 90, 88, 71, 79, 85, 71, 87, 79, 
  91, 83, 85, 91, 83, 78, 79, 87, 83, 82, 
  87, 87, 106, 88, 83, 95, 87, 83, 85, 86, 
  78, 78, 85, 84, 73, 82, 74, 77, 78, 87, 
  78, 98, 80, 83, 80, 74, 67, 77, 76, 90, 
  85, 85, 77, 90, 102, 89, 84, 77, 75, 86, 
  104, 78, 92, 79, 83, 84, 100, 84, 90, 94, 
  83, 82, 95, 75, 93, 65, 78, 92, 77, 86, 
  84, 83, 91, 76, 99, 79, 87, 78, 87, 80, 
  92, 91, 78, 80, 80, 86, 81, 85, 99, 74, 
  91, 84, 56, 80, 91, 97, 82, 101, 77, 67, 
  68, 90, 88, 68, 83, 83, 75, 93, 76, 85, 
  96, 75, 86, 93, 105, 81, 98, 82, 97, 118, 
  75, 77, 101, 68, 80, 81, 87, 92, 93, 76, 
  79, 81, 62, 81, 84, 89, 87, 81, 81, 88, 
  76, 97, 82, 80, 86, 92, 84, 85, 81, 93, 
  98, 84, 68, 85, 84, 72, 86, 69, 71, 94, 
  84, 80, 101, 77, 63, 86, 76, 83, 80, 72, 
  78, 74, 88, 84, 76, 79, 78, 76, 79, 74, 
  87, 85, 87, 94, 104, 82, 81, 104, 78, 74, 
  74, 75, 100, 68, 100, 95, 78, 90, 84, 91, 
  84, 87, 96, 85, 88, 86, 86, 76, 82, 78, 
  83, 82, 73, 87, 75, 82, 96, 69, 95, 81, 
  48, 82, 88, 101, 85, 97, 78, 66, 64, 92, 
  87, 75, 84, 76, 69, 96, 73, 77, 84, 88, 
  74, 82, 91, 73, 99, 74, 89, 123, 73, 73, 
  84, 76, 79, 98, 91, 92, 79, 79, 73, 83, 
  60, 79, 88, 85, 80, 84, 82, 92, 97, 90, 
  76, 85, 88, 91, 86, 77, 82, 87, 98, 83, 
  68, 70, 89, 84, 94, 85, 82, 102, 81, 83, 
  78, 75, 63, 86, 70, 87, 85, 94, 81, 83, 
  71, 78, 90, 80, 85, 88, 96, 84, 89, 90, 
  92, 89, 98, 87, 76, 91, 86, 83, 87, 81, 
  96, 71, 103, 92, 79, 90, 79, 88, 90, 75, 
  89, 77, 78, 86, 88, 88, 87, 93, 80, 82, 
  77, 92, 74, 76, 94, 80, 85, 73, 65, 90, 
  85, 86, 75, 94, 80, 75, 68, 75, 91, 68, 
  93, 89, 74, 87, 85, 88, 86, 69, 91, 80, 
  93, 75, 100, 76, 95, 94, 83, 81, 78, 69, 
  77, 82, 85, 92, 101, 81, 87, 83, 71, 83, 
  76, 79, 84, 91, 88, 80, 87, 94, 88, 77, 
  87, 91, 89, 90, 83, 91, 90, 90, 40, 86, 
  77, 85, 75, 69, 65, 72, 92, 82, 108, 65, 
  56, 94, 73, 90, 82, 75, 74, 80, 100, 90, 
  59, 74, 70, 79, 85, 82, 100, 79, 78, 94, 
  100, 72, 92, 81, 73, 83, 105, 70, 87, 72, 
  74, 92, 55, 81, 79, 92, 83, 80, 90, 97, 
  84, 99, 72, 84, 99, 78, 88, 65, 68, 126, 
  82, 86, 63, 123, 87, 75, 94, 65, 69, 58, 
  93, 99, 68, 64, 54, 80, 97, 68, 81, 86, 
  69, 111, 76, 81, 91, 85, 85, 96, 107, 81, 
  79, 62, 100, 128, 74, 60, 94, 74, 85, 82, 
  86, 87, 81, 66, 90, 90, 71, 70, 76, 77, 
  73, 68, 75, 94, 70, 75, 69, 84, 84, 100, 
  80, 78, 88, 84, 101, 95, 32, 84, 90, 70, 
  103, 32, 67, 62, 85, 78, 142, 73, 79, 102, 
  66, 77, 76, 54, 70, 70, 82, 99, 43, 69, 
  77, 70, 58, 73, 102, 92, 98, 104, 87, 70, 
  84, 110, 68, 81, 125, 82, 103, 74, 93, 97, 
  52, 61, 85, 105, 74, 87, 87, 117, 81, 118, 
  63, 94, 73, 70, 115, 56, 61, 136, 70, 100, 
  40, 170, 86, 72, 92, 45, 82, 62, 80, 96, 
  74, 54, 41, 100, 104, 78, 81, 74, 55, 95, 
  87, 85, 63, 117, 74, 75, 83, 75, 92, 56, 
  72, 155, 67, 51, 101, 86, 76, 98, 95, 86, 
  63, 65, 73, 95, 53, 70, 81, 80, 60, 65, 
  85, 106, 92, 78, 88, 89, 88, 101, 77, 68, 
  93, 73, 109, 93, 56, 60, 85, 93, 81, 69, 
  69, 96, 84, 84, 95, 61, 50, 82, 66, 97, 
  84, 99, 81, 84, 75, 73, 80, 84, 81, 86, 
  100, 91, 83, 81, 79, 105, 103, 74, 82, 88, 
  75, 89, 75, 75, 82, 70, 89, 87, 66, 95, 
  82, 84, 90, 78, 86, 73, 87, 90, 85, 69, 
  97, 80, 83, 87, 73, 116, 87, 52, 77, 93, 
  77, 81, 91, 89, 75, 65, 91, 99, 79, 70, 
  51, 77, 87, 73, 90, 92, 75, 92, 77, 82, 
  80, 55, 87, 95, 96, 81, 69, 69, 108, 95, 
  83, 66, 75, 72, 83, 93, 85, 87, 95, 76, 
  91, 82, 79, 77, 60, 70, 80, 94, 71, 77, 
  85, 74, 68, 74, 99, 90, 96, 91, 90, 81, 
  90, 104, 61, 81, 80, 91, 79, 77, 78, 79, 
  79, 90, 92, 81, 60, 100, 77, 87, 89, 94, 
  71, 85, 91, 94, 75, 94, 88, 83, 100, 87, 
  87, 75, 87, 80, 103, 72, 95, 85, 73, 87, 
  69, 76, 81, 75, 83, 85, 66, 87, 89, 97, 
  84, 78, 93, 85, 88, 79, 79, 79, 105, 81, 
  79, 71, 80, 96, 67, 88, 82, 92, 77, 94, 
  104, 80, 78, 66, 88, 92, 86, 72, 69, 85, 
  106, 64, 82, 94, 75, 113, 102, 76, 102, 86, 
  96, 108, 97, 83, 86, 65, 104, 91, 82, 69, 
  99, 71, 79, 85, 87, 90, 87, 74, 92, 84, 
  82, 71, 67, 78, 76, 82, 80, 91, 69, 85, 
  75, 72, 93, 90, 85, 81, 79, 89, 91, 87, 
  52, 83, 89, 84, 86, 54, 80, 72, 79, 84, 
  115, 87, 62, 88, 72, 75, 80, 74, 68, 80, 
  75, 84, 60, 92, 89, 71, 84, 80, 84, 92, 
  85, 92, 103, 71, 94, 104, 69, 78, 110, 70, 
  104, 84, 85, 82, 64, 59, 97, 99, 79, 88, 
  93, 89, 83, 87, 82, 85, 95, 75, 86, 66, 
  77, 100, 54, 91, 65, 119, 75, 92, 109, 68, 
  77, 74, 87, 86, 88, 66, 66, 87, 105, 71, 
  83, 85, 65, 107, 98, 89, 79, 105, 83, 93, 
  97, 83, 91, 61, 88, 108, 75, 66, 97, 82, 
  82, 84, 87, 88, 71, 78, 75, 85, 69, 70, 
  60, 83, 62, 79, 84, 84, 92, 83, 85, 80, 
  101, 89, 78, 72, 84, 84, 93, 92, 67, 73, 
  89, 86, 79, 88, 86, 88, 79, 88, 82, 77, 
  64, 86, 79, 89, 86, 110, 72, 83, 79, 79, 
  79, 99, 92, 87, 106, 87, 78, 82, 92, 83, 
  99, 76, 91, 88, 81, 86, 95, 76, 83, 83, 
  89, 89, 70, 81, 88, 91, 88, 74, 96, 86, 
  87, 79, 79, 80, 102, 89, 87, 84, 81, 91, 
  68, 71, 85, 87, 66, 91, 94, 96, 73, 77, 
  82, 96, 91, 72, 67, 72, 92, 73, 90, 99, 
  76, 91, 101, 78, 86, 65, 96, 97, 87, 86, 
  86, 67, 92, 80, 84, 80, 88, 68, 76, 95, 
  86, 90, 90, 84, 91, 81, 80, 87, 68, 71, 
  80, 95, 80, 93, 82, 90, 87, 74, 98, 89, 
  82, 85, 79, 83, 86, 91, 90, 84, 87, 82, 
  82, 89, 82, 73, 86, 100, 79, 89, 95, 91, 
  84, 80, 71, 93, 63, 84, 89, 79, 91, 85, 
  92, 78, 93, 74, 94, 92, 80, 82, 78, 92, 
  94, 84, 85, 81, 84, 91, 80, 87, 95, 79, 
  77, 91, 89, 82, 89, 91, 85, 96, 95, 63, 
  87, 85, 77, 73, 68, 87, 83, 83, 76, 82, 
  78, 88, 82, 82, 81, 95, 80, 79, 84, 87, 
  92, 80, 83, 81, 88, 73, 85, 82, 70, 73, 
  80, 101, 93, 91, 88, 68, 74, 81, 87, 89, 
  81, 82, 77, 86, 75, 56, 87, 81, 81, 72, 
  93, 87, 96, 85, 82, 101, 93, 86, 75, 85, 
  90, 78, 88, 91, 83, 71, 78, 91, 58, 74, 
  93, 100, 69, 90, 92, 86, 80, 78, 83, 87, 
  84, 68, 75, 105, 78, 87, 96, 86, 84, 79, 
  68, 89, 59, 87, 96, 73, 93, 88, 81, 77, 
  90, 78, 84, 92, 77, 83, 77, 92, 95, 81, 
  93, 85, 86, 95, 83, 87, 89, 81, 82, 92, 
  87, 77, 84, 89, 88, 92, 95, 64, 88, 88, 
  74, 71, 64, 86, 89, 87, 79, 84, 73, 90, 
  76, 80, 84, 90, 81, 76, 80, 84, 97, 75, 
  86, 84, 89, 74, 86, 80, 63, 73, 76, 101, 
  90, 85, 89, 65, 63, 83, 85, 84, 82, 82, 
  70, 87, 82, 60, 85, 86, 79, 75, 88, 81, 
  92, 88, 82, 104, 92, 84, 69, 85, 84, 80, 
  88, 92, 83, 69, 74, 91, 51, 75, 94, 96, 
  69, 93, 85, 86, 78, 77, 86, 86, 83, 77, 
  82, 95, 82, 91, 92, 82, 83, 87, 75, 89, 
  64, 84, 94, 77, 91, 87, 82, 79, 94, 75, 
  85, 90, 81, 81, 78, 87, 96, 80, 92, 82, 
  91, 100, 84, 82, 86, 79, 79, 91, 85, 80, 
  88, 88, 87, 89, 93, 65, 86, 94, 73, 75, 
  69, 89, 89, 84, 77, 80, 77, 84, 81, 84, 
  89, 84, 88, 76, 83, 87, 96, 81, 87, 90, 
  93, 76, 84, 82, 71, 84, 76, 100, 90, 86, 
  90, 75, 70, 89, 84, 87, 79, 78, 75, 86, 
  91, 66, 90, 84, 80, 75, 90, 84, 90, 87, 
  85, 98, 91, 84, 73, 92, 82, 76, 85, 86, 
  84, 73, 71, 90, 58, 79, 87, 95, 72, 91, 
  95, 76, 92, 82, 81, 81, 70, 85, 103, 91, 
  81, 85, 93, 83, 78, 90, 88, 83, 73, 79, 
  77, 76, 77, 81, 94, 77, 90, 72, 96, 80, 
  78, 84, 75, 85, 82, 76, 96, 65, 91, 78, 
  62, 75, 83, 79, 67, 94, 98, 86, 86, 93, 
  88, 93, 90, 72, 84, 83, 76, 79, 72, 94, 
  88, 75, 62, 85, 72, 80, 87, 80, 93, 81, 
  79, 78, 85, 87, 87, 71, 81, 80, 85, 75, 
  95, 77, 92, 78, 79, 100, 96, 90, 86, 73, 
  73, 88, 67, 83, 86, 77, 65, 85, 78, 64, 
  86, 86, 85, 74, 97, 108, 83, 79, 59, 93, 
  79, 87, 83, 88, 85, 83, 84, 81, 86, 70, 
  80, 95, 65, 73, 86, 98, 68, 84, 100, 76, 
  87, 85, 80, 81, 68, 86, 97, 89, 82, 83, 
  93, 85, 76, 94, 85, 75, 76, 84, 80, 71, 
  80, 84, 84, 73, 88, 73, 81, 82, 75, 86, 
  84, 82, 81, 80, 95, 63, 87, 73, 57, 75, 
  78, 76, 70, 96, 99, 84, 85, 92, 85, 89, 
  88, 71, 86, 80, 76, 73, 68, 97, 89, 80, 
  65, 88, 67, 80, 83, 81, 99, 78, 75, 77, 
  85, 82, 93, 67, 81, 87, 83, 75, 94, 73, 
  96, 86, 73, 95, 92, 84, 81, 70, 68, 85, 
  62, 81, 84, 74, 64, 82, 85, 68, 90, 87, 
  88, 76, 98, 108, 80, 84, 56, 91, 75, 83, 
  85, 88, 80, 85, 86, 80, 85, 67, 72, 88, 
  64, 77, 82, 96, 67, 91, 91, 81, 89, 84, 
  80, 80, 72, 89, 97, 87, 83, 87, 89, 91, 
  76, 93, 86, 79, 83, 81, 86, 79, 82, 84, 
  83, 79, 92, 73, 85, 83, 82, 82, 78, 79, 
  87, 83, 101, 68, 88, 83, 66, 72, 79, 80, 
  68, 90, 92, 80, 88, 89, 90, 94, 87, 74, 
  87, 85, 78, 78, 74, 95, 88, 79, 62, 83, 
  73, 78, 86, 84, 99, 85, 83, 76, 81, 83, 
  92, 77, 84, 89, 85, 75, 94, 80, 95, 96, 
  76, 92, 91, 85, 86, 76, 72, 87, 66, 83, 
  82, 77, 69, 83, 88, 70, 89, 86, 83, 76, 
  100, 107, 84, 82, 64, 85, 79, 87, 84, 94, 
  86, 84, 82, 78, 86, 72, 72, 91, 72, 74, 
  82, 93, 73, 87, 77, 83, 99, 81, 88, 90, 
  77, 93, 110, 77, 95, 93, 86, 84, 74, 85, 
  100, 81, 94, 86, 80, 72, 66, 78, 91, 84, 
  87, 74, 84, 81, 88, 83, 73, 76, 71, 79, 
  93, 72, 94, 70, 78, 63, 93, 82, 65, 90, 
  85, 88, 106, 83, 97, 94, 78, 100, 95, 87, 
  87, 82, 98, 85, 87, 84, 69, 87, 80, 71, 
  98, 95, 101, 85, 71, 91, 76, 80, 94, 75, 
  79, 88, 96, 68, 94, 88, 111, 100, 86, 97, 
  94, 92, 86, 82, 85, 92, 64, 90, 87, 88, 
  87, 86, 87, 103, 86, 68, 82, 83, 130, 112, 
  74, 82, 60, 58, 74, 80, 116, 98, 95, 78, 
  79, 68, 80, 81, 83, 87, 82, 71, 78, 99, 
  94, 69, 76, 83, 87, 85, 88, 83, 77, 93, 
  103, 80, 98, 92, 83, 89, 69, 80, 98, 76, 
  102, 96, 83, 70, 74, 81, 87, 82, 79, 73, 
  60, 77, 87, 81, 75, 79, 75, 82, 93, 76, 
  90, 65, 82, 68, 87, 80, 71, 87, 78, 97, 
  106, 79, 93, 94, 75, 104, 96, 91, 92, 76, 
  97, 90, 82, 90, 68, 92, 80, 73, 94, 102, 
  105, 80, 72, 94, 74, 70, 109, 78, 76, 93, 
  96, 68, 89, 82, 105, 98, 92, 92, 97, 91, 
  82, 80, 84, 90, 61, 96, 89, 87, 89, 81, 
  90, 119, 88, 68, 90, 87, 138, 115, 69, 89, 
  61, 55, 71, 82, 130, 93, 92, 76, 72, 68, 
  84, 78, 79, 76, 79, 80, 75, 99, 104, 71, 
  80, 83, 82, 87, 90, 72, 81, 100, 112, 79, 
  100, 89, 85, 92, 74, 86, 102, 77, 102, 86, 
  91, 73, 79, 81, 87, 88, 86, 76, 75, 75, 
  89, 78, 77, 74, 85, 85, 94, 73, 83, 72, 
  83, 65, 83, 85, 69, 86, 84, 98, 103, 84, 
  97, 94, 77, 101, 95, 88, 86, 83, 92, 85, 
  86, 84, 67, 88, 81, 70, 103, 93, 99, 84, 
  83, 88, 73, 77, 98, 78, 79, 95, 101, 71, 
  92, 89, 108, 93, 86, 90, 98, 92, 85, 81, 
  91, 90, 63, 89, 84, 92, 89, 86, 88, 108, 
  90, 72, 77, 84, 132, 105, 76, 85, 66, 54, 
  74, 82, 115, 90, 91, 80, 73, 71, 84, 78, 
  80, 84, 90, 70, 77, 96, 93, 78, 85, 75, 
  78, 86, 139, 84, 71, 79, 73, 81, 78, 91, 
  74, 106, 77, 77, 76, 77, 85, 80, 82, 87, 
  100, 73, 88, 75, 88, 86, 94, 94, 77, 91, 
  77, 95, 88, 85, 81, 85, 89, 77, 83, 82, 
  86, 89, 76, 83, 78, 85, 79, 84, 80, 77, 
  78, 77, 87, 95, 70, 75, 91, 74, 83, 79, 
  94, 69, 91, 76, 88, 78, 86, 99, 67, 85, 
  93, 91, 76, 74, 80, 88, 72, 76, 80, 89, 
  80, 83, 57, 79, 86, 91, 74, 95, 76, 76, 
  88, 81, 93, 78, 90, 92, 79, 81, 82, 78, 
  82, 82, 83, 77, 81, 103, 80, 74, 85, 78, 
  75, 76, 96, 86, 91, 91, 84, 82, 89, 92, 
  79, 72, 97, 82, 85, 88, 83, 79, 66, 86, 
  164, 75, 66, 81, 68, 77, 82, 107, 84, 103, 
  78, 79, 77, 76, 87, 82, 84, 81, 80, 75, 
  87, 74, 90, 84, 89, 91, 84, 99, 81, 98, 
  95, 93, 86, 76, 99, 82, 84, 79, 82, 107, 
  86, 78, 86, 73, 72, 85, 79, 86, 78, 83, 
  77, 93, 66, 80, 103, 70, 88, 71, 101, 72, 
  87, 76, 89, 77, 88, 94, 77, 84, 91, 87, 
  80, 65, 85, 83, 83, 78, 82, 93, 78, 79, 
  54, 82, 86, 91, 84, 104, 73, 85, 94, 80, 
  89, 83, 94, 100, 79, 78, 88, 90, 80, 83, 
  84, 80, 75, 108, 85, 82, 82, 78, 73, 81, 
  105, 76, 75, 87, 78, 85, 95, 99, 74, 71, 
  106, 80, 83, 89, 83, 86, 77, 85, 116, 91, 
  74, 82, 78, 78, 83, 89, 83, 88, 74, 80, 
  80, 81, 87, 78, 86, 82, 78, 76, 81, 76, 
  88, 84, 92, 82, 78, 91, 77, 78, 95, 95, 
  82, 86, 89, 80, 86, 84, 80, 85, 83, 85, 
  79, 91, 80, 85, 82, 78, 82, 77, 85, 86, 
  77, 71, 88, 80, 85, 81, 88, 74, 81, 80, 
  73, 78, 81, 89, 94, 89, 99, 90, 79, 78, 
  82, 89, 79, 76, 80, 85, 86, 79, 63, 76, 
  78, 84, 76, 95, 79, 89, 86, 81, 89, 80, 
  87, 91, 81, 83, 80, 95, 79, 84, 82, 76, 
  80, 93, 79, 77, 77, 74, 73, 88, 92, 83, 
  86, 89, 83, 81, 95, 88, 83, 77, 90, 82, 
  85, 86, 79, 79, 74, 80, 172, 87, 63, 81, 
  80, 74, 75, 93, 85, 100, 78, 76, 87, 70, 
  82, 75, 81, 87, 83, 78, 86, 74, 73, 76, 
  98, 90, 75, 88, 78, 107, 81, 81, 73, 82, 
  98, 82, 85, 81, 87, 99, 86, 84, 86, 85, 
  72, 79, 84, 84, 81, 82, 77, 96, 64, 79, 
  103, 69, 74, 73, 88, 67, 85, 81, 81, 76, 
  91, 76, 69, 72, 83, 87, 75, 71, 77, 92, 
  75, 75, 91, 83, 76, 82, 56, 80, 85, 95, 
  76, 89, 71, 79, 98, 74, 94, 81, 84, 100, 
  82, 88, 90, 86, 80, 78, 82, 80, 85, 103, 
  73, 79, 80, 83, 70, 82, 112, 65, 79, 87, 
  80, 83, 90, 80, 72, 65, 102, 80, 84, 75, 
  71, 82, 72, 76, 199, 74, 55, 83, 77, 73, 
  81, 106, 101, 108, 81, 78, 89, 71, 84, 83, 
  86, 88, 78, 81, 85, 70, 72, 77, 95, 89, 
  86, 93, 77, 109, 81, 90, 80, 80, 118, 89, 
  87, 85, 81, 122, 100, 74, 91, 72, 71, 74, 
  79, 90, 80, 87, 69, 97, 69, 83, 112, 63, 
  75, 66, 91, 71, 69, 86, 85, 71, 93, 75, 
  61, 67, 83, 84, 80, 63, 80, 92, 77, 84, 
  93, 86, 74, 80, 55, 86, 83, 93, 83, 93, 
  68, 80, 103, 75, 85, 85, 82, 115, 82, 84, 
  89, 80, 82, 80, 80, 78, 78, 105, 75, 86, 
  80, 81, 68, 81, 117, 60, 65, 81, 81, 83, 
  90, 88, 65, 72, 112, 78, 83, 75, 81, 84, 
  81, 83, 135, 87, 67, 80, 81, 74, 83, 87, 
  86, 90, 76, 77, 84, 74, 80, 80, 82, 84, 
  85, 81, 78, 75, 77, 73, 93, 82, 77, 85, 
  76, 81, 86, 97, 72, 86, 100, 81, 88, 81, 
  74, 88, 88, 79, 86, 84, 74, 86, 82, 85, 
  84, 87, 77, 89, 80, 78, 94, 78, 80, 77, 
  87, 73, 80, 83, 76, 74, 83, 83, 79, 80, 
  92, 86, 78, 76, 82, 94, 76, 79, 89, 80, 
  79, 82, 63, 85, 80, 96, 73, 87, 75, 82, 
  96, 82, 80, 83, 84, 96, 77, 85, 86, 87, 
  81, 82, 82, 82, 85, 91, 72, 78, 76, 81, 
  70, 86, 103, 74, 85, 85, 81, 82, 88, 79, 
  79, 72, 88, 85, 83, 74, 76, 82, 76, 83, 
  129, 84, 72, 82, 75, 75, 84, 90, 82, 89, 
  76, 76, 91, 82, 83, 73, 83, 76, 85, 82, 
  81, 80, 90, 79, 84, 77, 84, 83, 82, 105, 
  83, 80, 93, 85, 92, 75, 81, 82, 88, 78, 
  84, 93, 83, 85, 83, 81, 80, 91, 82, 82, 
  87, 89, 74, 67, 97, 80, 77, 87, 83, 76, 
  86, 78, 86, 85, 87, 85, 93, 81, 85, 85, 
  77, 81, 80, 92, 85, 74, 81, 93, 79, 78, 
  63, 85, 86, 93, 76, 88, 84, 83, 101, 82, 
  97, 85, 83, 87, 77, 82, 76, 93, 78, 78, 
  81, 86, 81, 93, 79, 74, 85, 76, 75, 84, 
  94, 89, 73, 83, 79, 85, 84, 83, 81, 72, 
  92, 80, 86, 90, 72, 85, 80, 86, 139, 75, 
  70, 80, 73, 73, 86, 99, 90, 94, 81, 81, 
  95, 81, 86, 85, 85, 73, 84, 80, 80, 80, 
  88, 77, 82, 90, 82, 91, 80, 102, 73, 84, 
  108, 89, 103, 79, 81, 80, 88, 90, 93, 82, 
  84, 74, 80, 78, 74, 91, 80, 84, 82, 89, 
  76, 72, 97, 80, 77, 80, 89, 78, 84, 75, 
  91, 80, 88, 93, 74, 76, 86, 81, 78, 72, 
  82, 84, 91, 74, 82, 99, 75, 79, 57, 89, 
  85, 87, 84, 84, 82, 86, 103, 84, 92, 86, 
  83, 94, 79, 76, 84, 87, 77, 79, 78, 82, 
  75, 94, 77, 80, 83, 74, 74, 83, 108, 79, 
  70, 80, 82, 86, 93, 85, 77, 74, 95, 84, 
  84, 91, 78, 81, 92, 88, 101, 89, 77, 77, 
  76, 75, 88, 86, 84, 96, 75, 80, 89, 83, 
  86, 79, 81, 74, 86, 86, 78, 80, 89, 76, 
  84, 87, 83, 87, 81, 81, 76, 94, 96, 84, 
  96, 76, 82, 83, 80, 72, 85, 88, 85, 87, 
  80, 86, 81, 92, 84, 83, 90, 84, 89, 66, 
  87, 88, 84, 80, 80, 78, 75, 78, 81, 84, 
  83, 85, 79, 86, 90, 86, 78, 85, 85, 88, 
  75, 73, 78, 92, 82, 82, 68, 93, 81, 91, 
  77, 86, 86, 79, 96, 86, 79, 85, 83, 85, 
  83, 81, 72, 89, 77, 80, 84, 87, 79, 86, 
  81, 74, 87, 76, 78, 86, 84, 88, 91, 83, 
  83, 86, 91, 82, 86, 78, 82, 86, 89, 90, 
  97, 89, 68, 94, 98, 81, 70, 98, 74, 89, 
  102, 91, 100, 77, 76, 82, 84, 87, 99, 75, 
  83, 83, 83, 78, 72, 87, 88, 105, 97, 77, 
  91, 102, 68, 94, 73, 96, 94, 100, 88, 80, 
  90, 82, 74, 80, 78, 65, 72, 84, 81, 71, 
  72, 85, 71, 83, 92, 96, 74, 80, 77, 105, 
  79, 84, 80, 97, 78, 72, 70, 82, 70, 91, 
  95, 76, 76, 96, 71, 85, 89, 100, 94, 90, 
  84, 89, 62, 82, 85, 75, 87, 89, 79, 75, 
  81, 89, 79, 88, 98, 80, 96, 81, 74, 70, 
  73, 77, 86, 93, 86, 103, 71, 96, 68, 78, 
  78, 67, 81, 90, 87, 88, 79, 76, 82, 89, 
  98, 74, 82, 86, 81, 96, 98, 86, 93, 88, 
  81, 91, 92, 85, 74, 95, 70, 87, 107, 90, 
  106, 84, 82, 79, 91, 91, 107, 79, 73, 80, 
  90, 77, 74, 84, 82, 101, 82, 74, 98, 108, 
  69, 93, 68, 89, 86, 96, 83, 78, 90, 79, 
  84, 81, 77, 70, 70, 80, 77, 72, 73, 94, 
  72, 85, 87, 78, 73, 81, 66, 120, 80, 81, 
  81, 101, 68, 64, 72, 88, 66, 84, 75, 69, 
  68, 100, 72, 85, 93, 91, 87, 91, 81, 89, 
  66, 84, 87, 79, 88, 89, 67, 77, 77, 90, 
  76, 86, 93, 82, 95, 85, 68, 71, 77, 84, 
  84, 93, 79, 90, 75, 96, 72, 80, 84, 73, 
  80, 91, 87, 78, 76, 73, 83, 84, 90, 75, 
  80, 88, 80, 98, 97, 85, 86, 80, 86, 91, 
  91, 90, 72, 93, 72, 92, 97, 90, 95, 92, 
  71, 83, 81, 82, 94, 79, 69, 88, 90, 81, 
  73, 87, 85, 101, 94, 78, 96, 113, 75, 91, 
  73, 101, 107, 99, 85, 81, 90, 81, 85, 81, 
  79, 69, 76, 87, 82, 69, 71, 100, 77, 79, 
  87, 71, 83, 80, 73, 98, 80, 87, 90, 91, 
  78, 76, 64, 78, 79, 94, 68, 73, 79, 89, 
  75, 90, 83, 89, 90, 89, 84, 88, 72, 87, 
  88, 77, 85, 88, 81, 77, 80, 84, 75, 84, 
  92, 80, 94, 82, 75, 80, 78, 77, 87, 90, 
  81, 100, 71, 92, 68, 78, 82, 70, 80, 93, 
  90, 85, 81, 78, 86, 90, 88, 76, 82, 82, 
  83, 94, 97, 86, 83, 88, 89, 86, 81, 84, 
  72, 87, 86, 84, 81, 99, 87, 85, 71, 74, 
  79, 70, 70, 73, 79, 88, 86, 81, 83, 83, 
  84, 87, 101, 85, 82, 90, 79, 78, 79, 88, 
  98, 83, 84, 75, 69, 80, 86, 82, 70, 79, 
  75, 83, 89, 79, 80, 88, 86, 78, 104, 91, 
  91, 82, 111, 84, 69, 78, 61, 79, 72, 77, 
  62, 76, 92, 80, 86, 77, 78, 75, 72, 85, 
  76, 104, 98, 85, 84, 92, 70, 75, 82, 94, 
  85, 82, 81, 82, 83, 81, 108, 78, 91, 76, 
  90, 65, 89, 67, 85, 70, 69, 92, 80, 136, 
  76, 89, 80, 81, 81, 53, 68, 85, 106, 102, 
  64, 87, 78, 87, 82, 88, 90, 65, 91, 99, 
  81, 71, 77, 86, 96, 81, 78, 88, 74, 85, 
  85, 83, 79, 90, 92, 93, 75, 72, 77, 70, 
  67, 76, 81, 90, 86, 79, 79, 85, 85, 85, 
  86, 87, 90, 96, 81, 84, 74, 75, 94, 81, 
  84, 76, 73, 89, 85, 85, 72, 71, 78, 86, 
  87, 79, 80, 109, 87, 76, 98, 106, 90, 81, 
  106, 89, 68, 75, 59, 78, 81, 74, 63, 78, 
  89, 77, 96, 75, 71, 77, 73, 85, 80, 87, 
  103, 86, 80, 91, 75, 75, 82, 103, 81, 86, 
  86, 78, 86, 79, 106, 78, 83, 79, 86, 69, 
  89, 69, 90, 73, 65, 93, 87, 138, 71, 90, 
  82, 78, 85, 60, 68, 80, 106, 91, 73, 84, 
  82, 95, 79, 88, 90, 60, 90, 98, 79, 69, 
  78, 85, 81, 86, 83, 86, 73, 80, 84, 88, 
  81, 88, 89, 87, 73, 72, 77, 71, 70, 75, 
  84, 81, 88, 88, 78, 88, 84, 88, 91, 85, 
  88, 93, 75, 84, 70, 84, 106, 84, 76, 75, 
  70, 84, 81, 80, 73, 67, 83, 101, 89, 79, 
  81, 84, 89, 80, 96, 90, 97, 81, 104, 83, 
  72, 83, 68, 80, 70, 74, 69, 77, 83, 80, 
  76, 76, 80, 75, 77, 88, 76, 81, 97, 85, 
  87, 87, 74, 87, 85, 99, 79, 79, 80, 82, 
  81, 79, 100, 80, 88, 80, 88, 72, 89, 71, 
  81, 72, 75, 90, 81, 127, 73, 83, 87, 77, 
  72, 60, 71, 87, 83, 91, 85, 89, 83, 84, 
  80, 83, 93, 71, 90, 90, 80, 79, 76, 86, 
  94, 82, 79, 90, 75, 76, 86, 85, 73, 80, 
  91, 92, 83, 81, 83, 85, 55, 75, 96, 88, 
  80, 89, 86, 91, 83, 82, 89, 84, 95, 76, 
  97, 79, 91, 88, 87, 80, 82, 83, 73, 78, 
  97, 87, 83, 88, 88, 87, 88, 92, 75, 94, 
  88, 82, 107, 70, 91, 72, 100, 87, 78, 101, 
  84, 75, 86, 76, 90, 84, 90, 81, 77, 76, 
  91, 77, 75, 85, 67, 88, 78, 79, 86, 79, 
  89, 82, 82, 82, 81, 72, 77, 90, 84, 89, 
  106, 85, 80, 88, 75, 74, 96, 79, 75, 85, 
  79, 92, 81, 106, 90, 87, 84, 76, 76, 79, 
  76, 85, 85, 87, 80, 92, 92, 91, 80, 80, 
  97, 67, 93, 86, 78, 86, 73, 87, 85, 81, 
  80, 78, 74, 77, 89, 88, 77, 75, 99, 88, 
  84, 85, 86, 86, 53, 76, 104, 82, 84, 90, 
  86, 91, 82, 81, 89, 87, 98, 73, 98, 76, 
  87, 78, 84, 87, 93, 80, 75, 80, 100, 91, 
  83, 94, 87, 86, 84, 91, 74, 90, 91, 82, 
  104, 81, 95, 70, 97, 90, 79, 102, 86, 77, 
  79, 77, 91, 88, 83, 81, 83, 72, 90, 80, 
  71, 79, 71, 81, 73, 81, 82, 77, 92, 87, 
  81, 86, 79, 73, 72, 89, 85, 86, 96, 86, 
  79, 86, 75, 77, 100, 81, 75, 81, 80, 94, 
  76, 93, 84, 87, 88, 73, 75, 82, 79, 76, 
  83, 86, 84, 90, 95, 96, 77, 81, 101, 67, 
  91, 83, 80, 86, 84, 84, 82, 84, 80, 72, 
  77, 71, 87, 87, 77, 81, 95, 82, 81, 82, 
  77, 84, 63, 77, 98, 82, 95, 89, 81, 89, 
  82, 82, 88, 89, 89, 71, 96, 79, 86, 85, 
  89, 80, 91, 81, 75, 77, 89, 90, 86, 84, 
  92, 90, 87, 90, 79, 81, 88, 87, 100, 84, 
  88, 78, 98, 86, 78, 94, 85, 77, 87, 82, 
  91, 82, 80, 86, 87, 80, 88, 76, 75, 82, 
  71, 85, 74, 77, 89, 78, 91, 93, 85, 86, 
  80, 73, 80, 84, 87, 81, 106, 86, 79, 92, 
  77, 77, 100, 75, 82, 74, 84, 89, 77, 100, 
  90, 83, 83, 74, 76, 78, 74, 80, 81, 85, 
  98, 89, 88, 83, 78, 82, 96, 72, 92, 83, 
  76, 87, 93, 83, 77, 95, 81, 91, 86, 78, 
  73, 105, 94, 85, 82, 81, 80, 80, 91, 90, 
  74, 76, 80, 78, 84, 72, 85, 80, 88, 84, 
  93, 88, 78, 90, 96, 79, 72, 85, 72, 70, 
  82, 78, 82, 94, 73, 88, 78, 80, 68, 85, 
  78, 97, 77, 80, 80, 82, 95, 79, 77, 89, 
  78, 80, 84, 89, 79, 89, 84, 81, 67, 73, 
  89, 82, 79, 94, 82, 79, 80, 106, 83, 81, 
  90, 86, 69, 82, 87, 85, 83, 100, 91, 99, 
  84, 85, 79, 85, 110, 83, 71, 81, 92, 84, 
  74, 78, 75, 74, 73, 77, 84, 84, 86, 86, 
  89, 102, 85, 88, 82, 80, 78, 78, 91, 81, 
  71, 81, 96, 80, 86, 74, 87, 99, 82, 91, 
  85, 85, 78, 88, 78, 90, 83, 82, 74, 115, 
  89, 80, 82, 81, 71, 80, 95, 83, 76, 78, 
  74, 76, 86, 75, 85, 74, 90, 86, 89, 83, 
  76, 87, 94, 81, 79, 84, 76, 72, 79, 83, 
  78, 94, 73, 86, 74, 70, 70, 87, 75, 99, 
  78, 79, 73, 79, 101, 79, 77, 86, 86, 86, 
  78, 88, 80, 86, 84, 75, 67, 83, 95, 77, 
  79, 95, 84, 77, 81, 107, 84, 84, 92, 87, 
  67, 78, 86, 90, 85, 100, 86, 105, 85, 89, 
  77, 90, 115, 79, 73, 71, 92, 78, 76, 79, 
  79, 81, 77, 76, 82, 87, 91, 88, 83, 100, 
  89, 88, 84, 87, 75, 81, 81, 83, 76, 76, 
  88, 81, 86, 74, 98, 95, 84, 96, 91, 85, 
  80, 92, 82, 82, 83, 81, 75, 100, 94, 83, 
  81, 78, 80, 79, 92, 91, 76, 79, 74, 81, 
  93, 75, 89, 81, 90, 87, 91, 80, 81, 93, 
  96, 87, 81, 76, 77, 75, 77, 79, 81, 94, 
  81, 92, 73, 80, 72, 87, 81, 93, 73, 76, 
  84, 83, 97, 74, 80, 84, 79, 84, 86, 87, 
  81, 89, 90, 79, 66, 77, 88, 81, 88, 89, 
  84, 79, 80, 99, 80, 90, 95, 86, 64, 87, 
  87, 93, 82, 94, 85, 93, 85, 90, 81, 83, 
  106, 88, 74, 81, 90, 85, 79, 79, 77, 85, 
  74, 78, 81, 84, 85, 86, 90, 101, 89, 89, 
  87, 93, 78, 77, 79, 84, 72, 82, 80, 85, 
  83, 77, 88, 92, 81, 87, 88, 80, 80, 83, 
  82, 86, 85, 81, 78, 119, 95, 85, 79, 80, 
  73, 80, 93, 92, 69, 83, 71, 87, 77, 75, 
  87, 76, 85, 84, 87, 84, 75, 85, 91, 77, 
  81, 88, 76, 78, 84, 69, 85, 100, 77, 83, 
  80, 81, 69, 82, 77, 105, 73, 78, 76, 85, 
  101, 85, 78, 97, 92, 78, 83, 88, 80, 89, 
  80, 85, 70, 84, 82, 81, 81, 101, 79, 85, 
  76, 114, 75, 86, 81, 80, 75, 76, 87, 91, 
  91, 85, 89, 96, 81, 79, 71, 90, 109, 77, 
  79, 81, 83, 87, 77, 81, 77, 74, 86, 75, 
  81, 94, 87, 84, 88, 108, 76, 84, 83, 82, 
  86, 79, 85, 77, 79, 80, 93, 82, 88, 81, 
  98, 78, 94, 88, 85, 79, 77, 73, 77, 82, 
  84, 85, 84, 140, 98, 86, 76, 82, 64, 77, 
  90, 77, 70, 86, 70, 99, 81, 82, 85, 69, 
  85, 86, 81, 83, 72, 80, 86, 83, 83, 93, 
  83, 82, 84, 69, 95, 114, 65, 76, 80, 70, 
  61, 84, 76, 126, 73, 83, 68, 80, 117, 85, 
  80, 99, 113, 87, 78, 90, 83, 91, 82, 85, 
  65, 98, 78, 80, 73, 125, 79, 79, 75, 127, 
  78, 84, 77, 83, 71, 71, 80, 92, 97, 79, 
  81, 109, 84, 80, 70, 86, 128, 66, 81, 75, 
  85, 82, 77, 83, 80, 86, 101, 76, 82, 102, 
  88, 86, 86, 109, 83, 78, 85, 85, 85, 88, 
  76, 77, 87, 78, 83, 90, 86, 84, 111, 74, 
  98, 101, 92, 84, 81, 82, 85, 75, 81, 84, 
  78, 111, 97, 83, 79, 81, 75, 78, 90, 95, 
  72, 83, 78, 86, 90, 79, 86, 77, 84, 88, 
  83, 86, 80, 87, 95, 85, 77, 85, 77, 78, 
  81, 69, 87, 98, 71, 87, 78, 82, 67, 90, 
  80, 100, 70, 78, 83, 83, 105, 81, 79, 94, 
  84, 80, 83, 84, 81, 88, 85, 86, 68, 83, 
  84, 82, 80, 98, 79, 84, 81, 105, 76, 89, 
  84, 82, 70, 81, 87, 97, 89, 82, 87, 93, 
  83, 85, 78, 86, 101, 83, 79, 85, 81, 90, 
  87, 83, 80, 87, 85, 78, 81, 90, 84, 85, 
  87, 102, 82, 84, 86, 94, 87, 81, 80, 79, 
  78, 80, 80, 83, 83, 79, 103, 76, 91, 84, 
  85, 81, 78, 84, 76, 91, 87, 84, 77, 103, 
  94, 82, 83, 83, 80, 76, 88, 96, 64, 79, 
  74, 76, 79, 74, 84, 80, 92, 84, 92, 83, 
  78, 90, 91, 72, 80, 89, 77, 79, 81, 76, 
  83, 99, 76, 82, 82, 79, 77, 94, 77, 102, 
  79, 73, 83, 86, 88, 84, 80, 83, 84, 75, 
  86, 93, 84, 86, 83, 89, 72, 78, 79, 84, 
  83, 96, 78, 97, 79, 103, 78, 85, 74, 86, 
  72, 83, 91, 80, 89, 84, 89, 87, 78, 83, 
  73, 99, 108, 82, 78, 87, 83, 90, 80, 79, 
  77, 81, 78, 76, 74, 85, 78, 83, 84, 99, 
  72, 93, 87, 81, 83, 84, 81, 84, 76, 74, 
  92, 81, 91, 79, 82, 81, 87, 87, 81, 78, 
  85, 79, 73, 80, 88, 86, 85, 112, 97, 85, 
  83, 79, 71, 76, 82, 89, 64, 80, 74, 83, 
  84, 79, 80, 76, 93, 84, 85, 82, 71, 87, 
  94, 73, 83, 86, 78, 82, 82, 74, 88, 98, 
  75, 81, 86, 72, 70, 86, 74, 110, 76, 74, 
  78, 84, 106, 85, 81, 83, 90, 76, 82, 100, 
  88, 87, 89, 91, 69, 76, 76, 90, 79, 103, 
  82, 94, 74, 106, 80, 86, 72, 87, 71, 75, 
  86, 85, 89, 80, 79, 93, 81, 81, 72, 90, 
  113, 74, 80, 87, 86, 86, 76, 84, 83, 80, 
  83, 78, 74, 83, 74, 84, 84, 96, 78, 89, 
  87, 82, 84, 85, 80, 80, 78, 78, 85, 79, 
  88, 82, 96, 81, 95, 93, 91, 80, 83, 84, 
  76, 74, 87, 85, 77, 97, 94, 81, 83, 80, 
  85, 74, 83, 99, 67, 82, 72, 77, 93, 75, 
  85, 80, 88, 88, 88, 82, 77, 91, 92, 82, 
  76, 81, 78, 79, 83, 76, 79, 92, 75, 84, 
  81, 76, 77, 85, 80, 99, 75, 69, 85, 85, 
  92, 83, 80, 83, 76, 80, 88, 93, 84, 87, 
  85, 93, 73, 78, 78, 85, 78, 96, 80, 95, 
  81, 95, 77, 95, 77, 87, 67, 86, 87, 98, 
  89, 88, 82, 88, 79, 84, 76, 92, 102, 88, 
  83, 91, 81, 93, 87, 81, 78, 81, 79, 81, 
  76, 83, 80, 84, 86, 96, 74, 91, 87, 90, 
  86, 85, 85, 87, 74, 74, 83, 83, 84, 75, 
  86, 82, 85, 87, 90, 89, 84, 101, 71, 72, 
  94, 76, 73, 92, 89, 81, 77, 61, 85, 79, 
  85, 82, 105, 89, 54, 86, 96, 99, 94, 86, 
  99, 97, 99, 82, 100, 93, 83, 78, 74, 93, 
  88, 77, 86, 79, 80, 77, 72, 89, 70, 90, 
  119, 87, 68, 88, 89, 83, 92, 93, 92, 77, 
  88, 91, 95, 72, 78, 74, 105, 81, 84, 61, 
  93, 74, 88, 99, 75, 93, 82, 69, 96, 86, 
  80, 76, 83, 78, 103, 85, 65, 69, 78, 81, 
  83, 80, 88, 72, 76, 79, 72, 90, 78, 68, 
  91, 78, 71, 74, 85, 75, 101, 67, 104, 71, 
  93, 76, 88, 89, 82, 84, 92, 85, 84, 75, 
  91, 69, 75, 67, 109, 89, 73, 75, 84, 86, 
  97, 100, 92, 85, 69, 102, 69, 72, 96, 75, 
  62, 83, 81, 63, 82, 77, 88, 75, 82, 76, 
  102, 83, 49, 74, 69, 112, 82, 83, 120, 95, 
  96, 81, 101, 96, 84, 80, 71, 78, 88, 79, 
  68, 70, 76, 86, 51, 78, 61, 91, 146, 78, 
  76, 82, 88, 81, 98, 90, 97, 84, 94, 92, 
  97, 66, 88, 72, 109, 94, 80, 64, 99, 67, 
  98, 105, 76, 87, 70, 62, 110, 85, 73, 76, 
  96, 77, 98, 69, 70, 82, 77, 75, 78, 65, 
  94, 76, 82, 72, 73, 101, 74, 64, 102, 77, 
  102, 79, 87, 76, 93, 71, 118, 82, 98, 78, 
  87, 84, 71, 92, 94, 76, 82, 71, 79, 73, 
  83, 55, 94, 78, 69, 76, 83, 85, 95, 95, 
  80, 88, 69, 100, 78, 95, 95, 77, 70, 96, 
  89, 82, 74, 90, 85, 77, 82, 76, 101, 77, 
  76, 83, 72, 102, 71, 92, 103, 98, 89, 78, 
  98, 91, 81, 94, 77, 82, 90, 77, 57, 79, 
  80, 78, 64, 83, 72, 83, 102, 71, 66, 88, 
  86, 76, 91, 96, 93, 86, 85, 94, 91, 72, 
  88, 77, 110, 86, 83, 68, 93, 80, 86, 85, 
  90, 84, 78, 76, 100, 90, 80, 86, 96, 79, 
  103, 85, 77, 99, 81, 79, 93, 75, 90, 84, 
  82, 75, 69, 92, 94, 75, 92, 80, 92, 78, 
  95, 81, 91, 66, 103, 71, 91, 74, 90, 84, 
  74, 88, 90, 94, 67, 73, 77, 77, 78, 72, 
  71, 87, 73, 78, 86, 81, 98, 98, 103, 79, 
  101, 93, 64, 76, 92, 79, 71, 85, 84, 88, 
  100, 84, 85, 67, 88, 75, 74, 79, 60, 98, 
  74, 97, 96, 92, 86, 86, 87, 84, 93, 96, 
  95, 85, 78, 85, 81, 86, 72, 78, 76, 85, 
  104, 85, 93, 101, 85, 88, 74, 86, 76, 84, 
  94, 80, 86, 61, 79, 82, 84, 86, 68, 83, 
  85, 73, 85, 70, 108, 77, 91, 88, 74, 90, 
  78, 79, 79, 85, 81, 95, 78, 85, 90, 88, 
  75, 70, 84, 81, 81, 78, 77, 71, 82, 72, 
  72, 112, 70, 79, 79, 91, 62, 81, 77, 78, 
  90, 70, 94, 98, 80, 88, 81, 82, 76, 70, 
  91, 79, 73, 88, 96, 87, 87, 65, 93, 81, 
  66, 86, 89, 81, 101, 85, 89, 98, 67, 85, 
  59, 71, 100, 76, 64, 72, 76, 70, 83, 70, 
  87, 69, 78, 63, 67, 82, 81, 78, 66, 110, 
  86, 101, 83, 83, 77, 77, 90, 92, 96, 79, 
  72, 69, 73, 102, 74, 68, 75, 91, 79, 76, 
  101, 97, 81, 91, 78, 80, 81, 64, 93, 81, 
  85, 68, 85, 77, 97, 97, 73, 81, 83, 79, 
  79, 64, 126, 88, 93, 81, 62, 84, 71, 80, 
  85, 93, 82, 88, 87, 82, 82, 82, 73, 78, 
  86, 83, 74, 70, 69, 75, 79, 76, 92, 137, 
  67, 83, 82, 91, 94, 91, 78, 98, 82, 76, 
  97, 104, 87, 92, 74, 78, 64, 73, 88, 71, 
  62, 95, 70, 110, 94, 62, 84, 71, 60, 90, 
  86, 77, 104, 87, 97, 101, 72, 96, 65, 86, 
  94, 79, 69, 85, 82, 91, 90, 73, 86, 71, 
  81, 67, 72, 76, 100, 91, 80, 97, 71, 92, 
  94, 82, 83, 79, 93, 96, 93, 87, 79, 81, 
  85, 87, 84, 79, 76, 87, 62, 86, 101, 96, 
  79, 95, 75, 91, 77, 78, 94, 84, 88, 89, 
  78, 86, 87, 83, 77, 80, 86, 78, 83, 75, 
  93, 83, 92, 79, 99, 89, 71, 83, 85, 84, 
  82, 86, 86, 81, 94, 88, 85, 88, 84, 80, 
  84, 75, 76, 74, 83, 73, 75, 107, 77, 81, 
  81, 90, 106, 79, 81, 93, 87, 69, 94, 96, 
  80, 82, 82, 77, 67, 74, 88, 86, 60, 78, 
  73, 86, 83, 66, 71, 81, 70, 86, 89, 74, 
  96, 87, 92, 79, 86, 92, 92, 70, 85, 88, 
  85, 86, 83, 94, 98, 82, 75, 63, 76, 71, 
  78, 82, 90, 91, 82, 89, 85, 87, 85, 76, 
  83, 88, 77, 84, 89, 83, 88, 86, 90, 78, 
  80, 86, 66, 97, 89, 93, 89, 92, 75, 93, 
  80, 97, 73, 86, 83, 81, 82, 83, 77, 90, 
  87, 89, 68, 89, 81, 74, 85, 83, 98, 89, 
  85, 86, 86, 86, 87, 86, 78, 92, 87, 96, 
  89, 86, 88, 91, 86, 79, 82, 83, 87, 90, 
  79, 86, 83, 76, 78, 96, 78, 94, 73, 81, 
  79, 83, 78, 91, 78, 68, 72, 98, 81, 90, 
  88, 78, 83, 86, 82, 77, 78, 79, 92, 91, 
  86, 89, 79, 83, 74, 85, 102, 85, 96, 73, 
  92, 84, 78, 88, 91, 83, 81, 88, 82, 79, 
  76, 80, 84, 82, 74, 63, 72, 73, 78, 83, 
  105, 80, 81, 79, 84, 97, 78, 72, 80, 82, 
  81, 88, 95, 82, 71, 79, 79, 78, 82, 81, 
  69, 92, 96, 94, 96, 80, 66, 90, 76, 91, 
  73, 77, 74, 81, 81, 78, 78, 86, 90, 87, 
  76, 85, 87, 69, 83, 75, 94, 92, 83, 87, 
  81, 79, 79, 93, 63, 87, 91, 93, 82, 80, 
  80, 84, 92, 85, 85, 89, 77, 90, 82, 85, 
  84, 81, 80, 102, 83, 101, 74, 79, 78, 79, 
  78, 103, 79, 73, 62, 92, 88, 94, 83, 69, 
  85, 95, 80, 79, 79, 88, 82, 102, 87, 99, 
  80, 76, 75, 91, 97, 83, 99, 71, 90, 91, 
  79, 88, 89, 89, 86, 86, 84, 85, 84, 94, 
  95, 77, 78, 68, 72, 70, 79, 79, 99, 93, 
  76, 82, 82, 84, 87, 75, 76, 93, 80, 90, 
  88, 83, 88, 86, 86, 84, 80, 86, 67, 92, 
  82, 93, 93, 83, 74, 88, 82, 101, 72, 85, 
  79, 83, 77, 74, 81, 91, 87, 90, 73, 94, 
  86, 73, 85, 85, 86, 91, 86, 87, 86, 89, 
  83, 90, 72, 90, 86, 91, 88, 83, 87, 91, 
  87, 91, 83, 87, 77, 89, 82, 82, 88, 78, 
  78, 96, 79, 87, 76, 86, 90, 80, 79, 91, 
  80, 68, 76, 98, 88, 88, 84, 77, 82, 86, 
  82, 87, 83, 78, 88, 91, 90, 94, 82, 85, 
  75, 86, 99, 79, 94, 74, 89, 76, 84, 79, 
  74, 89, 94, 82, 88, 74, 88, 83, 86, 73, 
  78, 74, 106, 99, 88, 74, 88, 84, 89, 76, 
  82, 92, 81, 69, 87, 77, 81, 81, 101, 82, 
  85, 94, 91, 72, 90, 72, 75, 104, 83, 80, 
  89, 81, 71, 90, 91, 93, 90, 81, 74, 92, 
  69, 83, 90, 85, 82, 84, 81, 92, 79, 88, 
  92, 97, 90, 73, 86, 76, 81, 86, 98, 80, 
  70, 95, 85, 85, 69, 92, 92, 89, 81, 72, 
  95, 90, 94, 70, 85, 59, 76, 90, 81, 81, 
  84, 95, 83, 76, 80, 85, 81, 88, 79, 85, 
  78, 73, 90, 87, 69, 79, 86, 77, 83, 72, 
  86, 83, 79, 78, 77, 80, 75, 76, 80, 85, 
  71, 84, 91, 87, 91, 78, 84, 78, 87, 71, 
  96, 74, 82, 76, 86, 85, 95, 84, 72, 72, 
  110, 93, 80, 76, 88, 87, 76, 89, 86, 90, 
  81, 65, 85, 83, 83, 86, 96, 87, 91, 86, 
  92, 68, 90, 79, 78, 113, 88, 77, 97, 88, 
  76, 87, 97, 96, 86, 90, 70, 91, 72, 88, 
  89, 84, 80, 89, 81, 98, 81, 90, 74, 108, 
  89, 80, 95, 77, 81, 91, 96, 63, 71, 87, 
  93, 83, 70, 98, 89, 88, 84, 78, 100, 96, 
  78, 69, 86, 69, 74, 75, 78, 87, 82, 96, 
  88, 73, 85, 91, 69, 88, 78, 87, 82, 76, 
  90, 88, 77, 73, 89, 78, 87, 79, 89, 83, 
  80, 90, 81, 88, 70, 77, 66, 84, 70, 88, 
  91, 92, 86, 80, 84, 83, 74, 81, 93, 76, 
  85, 77, 82, 86, 81, 84, 79, 77, 105, 99, 
  84, 77, 85, 88, 92, 77, 84, 94, 79, 76, 
  83, 77, 80, 87, 99, 83, 85, 88, 85, 82, 
  83, 76, 78, 100, 85, 83, 89, 79, 75, 83, 
  90, 88, 87, 80, 71, 94, 73, 81, 88, 85, 
  84, 84, 85, 91, 84, 93, 95, 95, 86, 77, 
  86, 76, 81, 88, 95, 73, 73, 88, 86, 86, 
  64, 86, 91, 92, 81, 88, 93, 99, 72, 71, 
  87, 65, 80, 79, 75, 87, 83, 93, 84, 79, 
  82, 82, 84, 85, 81, 86, 80, 75, 93, 88, 
  71, 74, 82, 78, 81, 85, 85, 89, 81, 81, 
  77, 82, 69, 78, 79, 84, 68, 79, 89, 91, 
  82, 83, 76, 78, 81, 92, 92, 93, 89, 68, 
  91, 87, 84, 84, 90, 65, 102, 88, 89, 71, 
  83, 81, 75, 70, 75, 88, 78, 77, 87, 83, 
  91, 76, 99, 75, 85, 92, 77, 93, 86, 89, 
  85, 74, 81, 81, 82, 89, 62, 82, 91, 91, 
  93, 84, 71, 83, 68, 88, 89, 85, 77, 83, 
  83, 89, 79, 87, 92, 89, 89, 76, 81, 77, 
  85, 80, 99, 86, 70, 101, 79, 82, 81, 91, 
  80, 85, 73, 69, 81, 92, 91, 69, 86, 80, 
  79, 117, 78, 89, 88, 94, 76, 91, 79, 89, 
  78, 89, 77, 82, 75, 83, 85, 78, 76, 86, 
  82, 74, 87, 69, 73, 81, 75, 83, 88, 76, 
  90, 77, 80, 98, 71, 79, 90, 82, 86, 88, 
  79, 74, 82, 67, 98, 92, 83, 62, 95, 86, 
  103, 90, 78, 62, 112, 71, 81, 74, 82, 84, 
  67, 79, 82, 92, 72, 72, 82, 88, 99, 86, 
  100, 81, 84, 76, 82, 96, 102, 91, 92, 68, 
  83, 74, 85, 97, 64, 85, 103, 94, 94, 94, 
  72, 77, 66, 88, 93, 83, 77, 92, 83, 93, 
  82, 86, 57, 94, 93, 82, 82, 66, 75, 85, 
  94, 72, 69, 91, 81, 87, 78, 103, 76, 87, 
  77, 78, 83, 109, 73, 63, 83, 85, 76, 80, 
  70, 108, 76, 96, 79, 95, 77, 102, 48, 78, 
  72, 81, 76, 84, 87, 75, 77, 78, 91, 71, 
  91, 69, 76, 86, 73, 90, 94, 80, 82, 79, 
  76, 100, 68, 78, 94, 87, 76, 89, 94, 89, 
  80, 74, 91, 85, 92, 72, 86, 83, 84, 87, 
  90, 68, 95, 88, 88, 82, 84, 86, 94, 72, 
  84, 89, 79, 81, 77, 86, 86, 83, 94, 76, 
  78, 82, 72, 107, 93, 86, 89, 75, 82, 85, 
  83, 84, 70, 81, 90, 92, 90, 86, 75, 85, 
  72, 85, 83, 85, 77, 82, 87, 88, 84, 90, 
  105, 85, 88, 79, 76, 94, 76, 82, 94, 84, 
  73, 88, 81, 84, 74, 85, 84, 86, 74, 98, 
  80, 109, 71, 75, 87, 84, 83, 95, 73, 89, 
  86, 96, 75, 91, 72, 86, 83, 77, 75, 83, 
  73, 85, 89, 80, 73, 81, 81, 71, 82, 83, 
  79, 86, 83, 80, 86, 80, 78, 79, 78, 93, 
  72, 78, 93, 87, 75, 83, 86, 102, 90, 101, 
  86, 89, 96, 78, 84, 91, 78, 93, 80, 97, 
  86, 88, 94, 94, 84, 91, 72, 64, 75, 80, 
  80, 92, 95, 82, 91, 84, 82, 71, 70, 100, 
  73, 102, 72, 82, 91, 69, 77, 94, 65, 77, 
  74, 76, 72, 85, 88, 75, 72, 74, 74, 83, 
  77, 81, 89, 84, 77, 73, 97, 71, 122, 63, 
  99, 88, 74, 115, 111, 77, 92, 110, 76, 92, 
  75, 85, 97, 75, 85, 76, 76, 81, 81, 93, 
  93, 100, 78, 86, 84, 147, 76, 87, 83, 79, 
  82, 78, 69, 70, 98, 93, 90, 83, 80, 99, 
  78, 93, 75, 84, 80, 68, 76, 86, 92, 85, 
  86, 79, 82, 76, 80, 69, 100, 98, 78, 73, 
  80, 75, 69, 81, 97, 97, 77, 88, 80, 102, 
  95, 83, 86, 91, 77, 92, 76, 87, 88, 84, 
  91, 91, 80, 83, 92, 60, 79, 82, 72, 97, 
  72, 81, 91, 86, 89, 77, 70, 86, 79, 114, 
  87, 80, 91, 69, 77, 85, 57, 73, 75, 79, 
  73, 89, 89, 78, 74, 69, 74, 83, 81, 76, 
  87, 91, 84, 70, 101, 59, 96, 57, 84, 82, 
  67, 112, 92, 77, 94, 113, 72, 94, 74, 91, 
  91, 82, 81, 74, 72, 99, 69, 105, 92, 98, 
  72, 92, 83, 136, 65, 94, 77, 71, 85, 79, 
  72, 77, 96, 88, 81, 83, 69, 95, 84, 86, 
  74, 86, 79, 65, 77, 82, 84, 87, 89, 78, 
  90, 72, 86, 70, 102, 102, 78, 75, 85, 75, 
  77, 76, 91, 98, 87, 69, 84, 91, 93, 82, 
  83, 93, 77, 90, 86, 92, 79, 88, 100, 92, 
  84, 96, 109, 64, 81, 81, 84, 91, 84, 82, 
  86, 83, 87, 76, 66, 85, 74, 100, 96, 81, 
  89, 72, 80, 95, 70, 75, 73, 78, 75, 89, 
  85, 76, 76, 78, 76, 83, 74, 82, 87, 88, 
  80, 79, 101, 74, 114, 67, 83, 85, 73, 121, 
  77, 75, 88, 113, 74, 89, 81, 85, 83, 76, 
  88, 76, 80, 102, 81, 101, 92, 104, 76, 83, 
  82, 132, 75, 82, 82, 83, 80, 78, 77, 65, 
  95, 82, 91, 85, 82, 98, 80, 95, 80, 81, 
  77, 66, 71, 83, 82, 88, 88, 75, 81, 77, 
  78, 76, 95, 92, 81, 83, 83, 79, 100, 62, 
  85, 49, 84, 68, 74, 66, 71, 55, 79, 87, 
  72, 91, 96, 81, 72, 71, 82, 86, 79, 82, 
  91, 76, 66, 65, 71, 83, 82, 82, 59, 88, 
  84, 75, 94, 105, 88, 132, 94, 72, 70, 62, 
  81, 62, 92, 71, 83, 82, 53, 67, 99, 79, 
  71, 77, 76, 83, 54, 70, 86, 129, 91, 68, 
  100, 87, 78, 87, 81, 88, 77, 73, 80, 111, 
  92, 94, 77, 93, 77, 92, 81, 67, 86, 74, 
  80, 92, 106, 74, 67, 119, 66, 92, 80, 85, 
  88, 72, 87, 72, 79, 71, 79, 97, 86, 84, 
  160, 92, 119, 75, 83, 86, 78, 84, 88, 85, 
  62, 86, 91, 96, 77, 111, 141, 77, 78, 66, 
  71, 63, 103, 73, 144, 57, 93, 92, 73, 58, 
  87, 86, 76, 64, 70, 39, 74, 88, 68, 100, 
  95, 81, 76, 71, 75, 79, 73, 83, 65, 80, 
  74, 73, 73, 84, 99, 95, 64, 82, 84, 73, 
  83, 105, 83, 123, 87, 76, 66, 70, 81, 65, 
  92, 82, 80, 92, 59, 68, 93, 74, 76, 80, 
  75, 86, 57, 69, 83, 109, 93, 73, 98, 85, 
  69, 90, 74, 83, 76, 70, 82, 105, 86, 90, 
  76, 88, 85, 75, 78, 69, 89, 70, 80, 81, 
  103, 74, 77, 110, 64, 86, 77, 94, 92, 72, 
  85, 69, 86, 77, 81, 90, 77, 91, 145, 91, 
  116, 77, 89, 84, 71, 84, 83, 89, 65, 66, 
  88, 95, 86, 106, 132, 77, 94, 65, 72, 67, 
  92, 78, 130, 62, 81, 93, 89, 68, 87, 89, 
  85, 96, 73, 70, 100, 85, 85, 88, 78, 90, 
  79, 69, 93, 94, 79, 84, 71, 85, 89, 78, 
  84, 82, 88, 88, 96, 91, 82, 93, 76, 93, 
  86, 87, 81, 86, 92, 80, 80, 86, 85, 96, 
  92, 82, 97, 79, 86, 86, 81, 87, 95, 87, 
  91, 81, 88, 87, 78, 86, 93, 61, 79, 78, 
  72, 84, 88, 86, 87, 86, 78, 89, 83, 87, 
  92, 76, 75, 76, 85, 84, 97, 79, 80, 72, 
  105, 77, 77, 93, 101, 95, 93, 87, 83, 88, 
  85, 75, 96, 89, 76, 78, 74, 87, 71, 91, 
  78, 86, 79, 88, 86, 78, 98, 67, 88, 88, 
  88, 72, 77, 88, 99, 88, 80, 79, 86, 84, 
  72, 89, 86, 72, 76, 66, 78, 67, 81, 74, 
  77, 65, 86, 89, 72, 81, 89, 89, 66, 74, 
  81, 88, 82, 80, 85, 93, 79, 75, 91, 83, 
  88, 95, 79, 93, 79, 90, 95, 93, 80, 119, 
  85, 76, 64, 69, 84, 69, 82, 88, 81, 81, 
  78, 74, 94, 80, 84, 84, 82, 84, 76, 76, 
  86, 97, 76, 78, 89, 88, 69, 88, 69, 71, 
  84, 72, 85, 99, 95, 80, 80, 90, 86, 89, 
  90, 61, 80, 87, 94, 85, 91, 69, 73, 101, 
  83, 96, 89, 65, 83, 81, 95, 75, 79, 73, 
  71, 79, 66, 78, 119, 88, 99, 90, 83, 77, 
  68, 89, 82, 87, 74, 97, 82, 103, 78, 82, 
  95, 83, 79, 65, 71, 65, 90, 91, 106, 70, 
  85, 84, 73, 68, 79, 80, 82, 75, 76, 55, 
  82, 92, 71, 87, 89, 88, 67, 76, 75, 82, 
  76, 82, 72, 95, 74, 77, 92, 80, 95, 104, 
  86, 86, 76, 83, 85, 89, 78, 108, 85, 80, 
  68, 71, 82, 69, 79, 82, 76, 90, 85, 74, 
  90, 80, 87, 86, 80, 81, 77, 77, 82, 87, 
  83, 81, 89, 86, 68, 91, 73, 70, 82, 76, 
  74, 96, 88, 80, 78, 88, 89, 77, 84, 64, 
  84, 83, 92, 75, 93, 73, 82, 99, 83, 90, 
  83, 72, 85, 84, 89, 75, 85, 76, 87, 76, 
  67, 78, 108, 85, 91, 86, 88, 77, 62, 89, 
  80, 85, 75, 75, 88, 99, 87, 79, 93, 88, 
  90, 67, 74, 70, 85, 98, 94, 74, 77, 81, 
  87, 71, 80, 82, 89, 98, 80, 79, 97, 84, 
  88, 84, 82, 94, 82, 78, 87, 88, 79, 89, 
  73, 89, 90, 83, 85, 83, 88, 85, 98, 90, 
  82, 93, 82, 87, 83, 81, 83, 89, 84, 79, 
  87, 91, 84, 90, 83, 85, 92, 81, 85, 91, 
  86, 89, 91, 80, 88, 84, 86, 84, 75, 87, 
  87, 62, 77, 83, 80, 86, 86, 84, 80, 79, 
  77, 83, 83, 80, 89, 76, 71, 79, 84, 86, 
  93, 81, 76, 71, 103, 81, 84, 90, 97, 82, 
  83, 93, 83, 84, 83, 80, 97, 86, 78, 87, 
  77, 82, 59, 90, 84, 85, 72, 86, 92, 81, 
  97, 65, 91, 89, 82, 66, 71, 86, 90, 78, 
  83, 81, 88, 85, 68, 87, 83, 84, 85, 72, 
  83, 87, 82, 92, 87, 84, 88, 90, 95, 86, 
  80, 84, 76, 74, 98, 90, 86, 91, 89, 99, 
  90, 87, 92, 70, 83, 88, 96, 102, 85, 103, 
  90, 74, 83, 84, 81, 76, 88, 67, 87, 92, 
  82, 89, 85, 88, 95, 82, 91, 86, 90, 90, 
  98, 89, 91, 84, 91, 87, 72, 88, 73, 79, 
  80, 83, 81, 90, 84, 84, 88, 72, 83, 75, 
  82, 81, 86, 82, 77, 74, 80, 91, 110, 81, 
  82, 67, 67, 81, 77, 104, 90, 68, 85, 95, 
  92, 88, 80, 84, 84, 83, 78, 81, 68, 81, 
  54, 93, 93, 78, 81, 91, 84, 85, 94, 83, 
  86, 96, 83, 59, 66, 82, 86, 80, 77, 70, 
  86, 101, 61, 96, 86, 87, 85, 72, 81, 89, 
  85, 95, 85, 86, 85, 92, 91, 85, 83, 81, 
  72, 78, 92, 87, 85, 86, 85, 98, 87, 88, 
  94, 70, 85, 91, 96, 96, 87, 97, 90, 75, 
  83, 81, 84, 77, 86, 67, 86, 90, 81, 85, 
  82, 86, 96, 83, 90, 88, 91, 88, 93, 90, 
  88, 85, 85, 85, 74, 88, 74, 78, 83, 84, 
  84, 86, 83, 83, 81, 73, 79, 76, 80, 77, 
  85, 81, 76, 75, 83, 89, 112, 81, 81, 69, 
  63, 81, 82, 102, 89, 75, 86, 96, 93, 86, 
  81, 83, 95, 84, 82, 78, 71, 81, 51, 90, 
  93, 79, 82, 90, 83, 82, 92, 80, 85, 93, 
  80, 60, 67, 85, 82, 82, 81, 76, 85, 111, 
  61, 92, 81, 81, 83, 69, 77, 89, 82, 88, 
  88, 89, 80, 83, 88, 81, 79, 87, 82, 83, 
  99, 84, 86, 86, 83, 87, 94, 89, 85, 81, 
  78, 88, 87, 96, 87, 97, 86, 91, 89, 87, 
  85, 84, 87, 77, 91, 97, 84, 86, 82, 86, 
  88, 84, 86, 84, 83, 87, 87, 80, 82, 94, 
  83, 89, 71, 92, 76, 77, 84, 84, 87, 95, 
  80, 84, 82, 71, 78, 75, 89, 69, 84, 78, 
  73, 81, 79, 83, 96, 78, 78, 60, 74, 86, 
  76, 100, 78, 79, 87, 90, 92, 90, 78, 82, 
  102, 87, 88, 85, 82, 78, 68, 88, 90, 86, 
  77, 87, 93, 85, 82, 72, 89, 86, 80, 66, 
  74, 82, 89, 82, 77, 66, 85, 90, 75, 90, 
  91, 80, 88, 91, 86, 85, 78, 79, 72, 90, 
  78, 83, 92, 81, 92, 81, 70, 98, 76, 80, 
  84, 70, 72, 83, 86, 108, 79, 83, 108, 85, 
  87, 80, 72, 108, 65, 83, 79, 81, 72, 94, 
  77, 80, 81, 88, 98, 60, 79, 87, 87, 73, 
  76, 75, 74, 95, 60, 80, 81, 82, 64, 91, 
  104, 85, 92, 104, 81, 101, 85, 85, 81, 77, 
  70, 69, 77, 80, 82, 72, 80, 78, 92, 95, 
  78, 102, 88, 78, 91, 85, 87, 109, 77, 101, 
  86, 81, 80, 61, 96, 86, 89, 98, 81, 88, 
  75, 76, 87, 81, 78, 83, 75, 94, 68, 83, 
  83, 87, 85, 80, 70, 69, 86, 92, 66, 90, 
  102, 84, 75, 90, 69, 89, 78, 67, 86, 90, 
  79, 82, 81, 78, 81, 74, 76, 86, 80, 89, 
  84, 72, 92, 78, 72, 94, 71, 79, 89, 71, 
  76, 86, 89, 106, 78, 81, 91, 79, 81, 83, 
  78, 90, 67, 88, 73, 78, 82, 93, 76, 79, 
  86, 96, 103, 67, 82, 76, 81, 77, 69, 69, 
  75, 91, 64, 73, 85, 77, 69, 83, 103, 86, 
  90, 96, 78, 100, 85, 86, 82, 71, 72, 67, 
  85, 82, 86, 69, 85, 83, 89, 91, 81, 97, 
  88, 78, 84, 81, 86, 97, 74, 105, 80, 77, 
  83, 59, 81, 86, 88, 102, 78, 83, 73, 76, 
  81, 83, 80, 83, 75, 94, 67, 85, 83, 90, 
  82, 84, 64, 67, 81, 87, 62, 87, 99, 81, 
  71, 88, 63, 89, 80, 68, 81, 88, 85, 84, 
  72, 77, 74, 81, 71, 87, 83, 84, 94, 81, 
  87, 91, 79, 99, 79, 93, 83, 79, 85, 89, 
  86, 104, 85, 85, 98, 71, 87, 90, 75, 88, 
  76, 88, 79, 81, 90, 96, 86, 75, 86, 93, 
  92, 69, 83, 78, 83, 83, 75, 77, 72, 84, 
  70, 78, 80, 85, 70, 97, 105, 79, 89, 99, 
  92, 95, 83, 88, 87, 89, 83, 71, 81, 82, 
  89, 73, 80, 91, 90, 96, 76, 91, 83, 81, 
  78, 80, 80, 93, 77, 99, 84, 81, 76, 66, 
  88, 84, 92, 101, 78, 92, 75, 82, 92, 80, 
  85, 85, 75, 93, 67, 84, 85, 88, 84, 86, 
  73, 73, 88, 90, 72, 87, 96, 92, 80, 92, 
  73, 87, 80, 71, 80, 75, 75, 87, 90, 85, 
  75, 75, 72, 88, 83, 79, 79, 80, 82, 88, 
  81, 90, 76, 86, 88, 74, 72, 87, 86, 89, 
  95, 83, 87, 83, 84, 85, 77, 105, 65, 82, 
  85, 86, 75, 83, 86, 74, 79, 87, 76, 77, 
  85, 82, 81, 79, 75, 67, 81, 88, 72, 100, 
  86, 85, 78, 91, 104, 78, 86, 87, 80, 88, 
  76, 86, 84, 82, 89, 76, 68, 69, 77, 76, 
  75, 75, 82, 81, 69, 89, 80, 80, 79, 87, 
  85, 85, 81, 101, 77, 74, 76, 72, 93, 78, 
  92, 90, 87, 86, 67, 85, 86, 80, 86, 82, 
  76, 86, 67, 84, 79, 94, 83, 80, 81, 74, 
  80, 93, 74, 79, 101, 84, 80, 84, 70, 93, 
  82, 70, 80, 83, 84, 81, 78, 83, 77, 72, 
  75, 89, 85, 86, 79, 83, 77, 89, 86, 89, 
  78, 91, 88, 83, 84, 92, 88, 81, 90, 82, 
  64, 75, 85, 89, 82, 94, 70, 87, 76, 86, 
  80, 79, 83, 74, 91, 94, 73, 84, 79, 77, 
  75, 83, 72, 75, 83, 87, 76, 84, 88, 84, 
  84, 83, 105, 83, 83, 83, 83, 85, 71, 89, 
  85, 83, 77, 73, 76, 69, 81, 76, 81, 84, 
  75, 77, 78, 80, 84, 72, 74, 88, 82, 80, 
  76, 97, 73, 70, 75, 68, 86, 72, 90, 88, 
  78, 86, 60, 77, 83, 81, 83, 85, 78, 82, 
  71, 82, 77, 93, 81, 80, 81, 79, 83, 90, 
  78, 81, 98, 83, 87, 82, 74, 90, 84, 74, 
  81, 81, 86, 84, 75, 82, 74, 72, 74, 87, 
  86, 86, 88, 93, 74, 91, 84, 91, 86, 93, 
  82, 91, 84, 95, 88, 86, 98, 86, 75, 73, 
  86, 98, 79, 93, 76, 74, 86, 85, 86, 83, 
  83, 73, 90, 92, 68, 89, 85, 85, 74, 89, 
  79, 87, 81, 88, 86, 76, 84, 85, 89, 91, 
  105, 79, 84, 91, 85, 83, 72, 85, 87, 94, 
  78, 76, 68, 70, 83, 78, 87, 95, 83, 83, 
  73, 81, 84, 76, 74, 89, 78, 80, 83, 94, 
  82, 73, 78, 70, 88, 73, 91, 87, 78, 95, 
  67, 77, 90, 81, 86, 92, 74, 81, 78, 87, 
  79, 92, 81, 84, 93, 87, 90, 90, 84, 80, 
  97, 90, 84, 87, 83, 87, 86, 83, 79, 86, 
  88, 88, 94, 84, 68, 68, 80, 82, 87, 80, 
  83, 95, 69, 90, 75, 82, 82, 96, 89, 91, 
  90, 100, 87, 77, 99, 78, 90, 81, 83, 96, 
  87, 104, 79, 99, 77, 89, 89, 71, 92, 83, 
  82, 87, 72, 96, 99, 88, 74, 93, 93, 85, 
  91, 88, 95, 92, 86, 83, 106, 91, 113, 78, 
  81, 80, 75, 81, 75, 82, 82, 95, 85, 89, 
  69, 70, 73, 82, 86, 92, 75, 78, 83, 79, 
  79, 82, 68, 97, 88, 68, 100, 98, 89, 77, 
  91, 74, 97, 75, 89, 90, 94, 86, 71, 85, 
  87, 82, 90, 81, 87, 73, 84, 96, 81, 95, 
  73, 84, 91, 95, 96, 92, 88, 77, 103, 86, 
  82, 87, 83, 91, 81, 92, 78, 89, 98, 83, 
  81, 93, 75, 66, 88, 82, 87, 84, 84, 94, 
  65, 87, 80, 83, 84, 100, 92, 102, 89, 100, 
  85, 75, 100, 78, 64, 81, 78, 101, 91, 94, 
  82, 93, 73, 89, 88, 65, 85, 83, 92, 96, 
  69, 111, 95, 91, 66, 96, 94, 94, 95, 83, 
  103, 97, 86, 86, 111, 86, 110, 80, 77, 80, 
  90, 83, 71, 80, 86, 96, 95, 84, 70, 69, 
  76, 80, 90, 96, 77, 77, 90, 75, 78, 82, 
  60, 101, 88, 68, 96, 87, 92, 77, 96, 68, 
  95, 68, 83, 87, 91, 88, 80, 88, 84, 83, 
  92, 79, 87, 72, 85, 97, 79, 93, 69, 87, 
  88, 91, 96, 91, 97, 83, 105, 90, 81, 82, 
  94, 90, 82, 98, 80, 88, 88, 89, 85, 95, 
  73, 62, 86, 77, 86, 84, 86, 93, 65, 92, 
  71, 81, 80, 101, 86, 107, 82, 104, 80, 72, 
  103, 83, 78, 82, 77, 101, 97, 99, 77, 81, 
  83, 89, 88, 71, 92, 84, 87, 87, 69, 111, 
  104, 99, 69, 103, 99, 88, 95, 86, 110, 97, 
  83, 84, 114, 91, 108, 83, 82, 89, 82, 87, 
  66, 79, 86, 85, 96, 87, 70, 71, 79, 85, 
  98, 96, 87, 80, 88, 77, 77, 87, 56, 106, 
  86, 61, 95, 89, 97, 83, 100, 70, 105, 70, 
  85, 83, 93, 90, 80, 93, 93, 82, 91, 83, 
  84, 68, 89, 98, 72, 95, 77, 91, 87, 94, 
  92, 89, 95, 84, 101, 88, 89, 87, 95, 86, 
  86, 103, 79, 86, 84, 72, 84, 87, 96, 72, 
  103, 75, 80, 85, 89, 94, 72, 88, 72, 78, 
  71, 78, 88, 89, 111, 70, 89, 89, 69, 68, 
  86, 86, 93, 88, 89, 80, 72, 104, 90, 72, 
  86, 72, 103, 78, 92, 85, 80, 94, 85, 90, 
  82, 90, 79, 74, 78, 85, 90, 88, 88, 73, 
  85, 82, 84, 85, 74, 74, 86, 71, 81, 89, 
  78, 88, 74, 82, 84, 74, 88, 81, 103, 92, 
  80, 66, 88, 87, 77, 75, 95, 85, 81, 82, 
  77, 91, 70, 85, 83, 84, 85, 113, 100, 90, 
  90, 79, 66, 77, 83, 80, 104, 77, 80, 88, 
  98, 66, 73, 79, 78, 91, 75, 94, 75, 79, 
  85, 106, 87, 71, 87, 91, 77, 86, 77, 80, 
  71, 90, 75, 51, 84, 85, 95, 66, 108, 70, 
  81, 85, 96, 86, 65, 89, 69, 90, 64, 76, 
  93, 91, 98, 61, 87, 73, 59, 48, 92, 85, 
  79, 109, 104, 81, 78, 76, 93, 68, 88, 67, 
  112, 64, 92, 81, 84, 109, 93, 84, 76, 91, 
  68, 84, 82, 93, 84, 82, 81, 75, 76, 92, 
  88, 89, 82, 73, 79, 69, 91, 90, 70, 90, 
  76, 71, 77, 74, 95, 68, 129, 90, 77, 65, 
  93, 83, 64, 73, 93, 71, 83, 88, 81, 96, 
  53, 95, 80, 84, 73, 115, 102, 81, 82, 87, 
  64, 87, 63, 82, 126, 63, 89, 83, 105, 56, 
  81, 75, 74, 84, 83, 94, 75, 95, 106, 104, 
  88, 61, 86, 90, 86, 90, 73, 88, 83, 86, 
  69, 63, 85, 102, 94, 69, 95, 76, 83, 85, 
  85, 84, 76, 88, 72, 81, 70, 76, 85, 87, 
  84, 71, 95, 84, 70, 67, 82, 82, 86, 107, 
  93, 96, 77, 75, 91, 71, 89, 74, 104, 74, 
  82, 82, 82, 102, 89, 92, 79, 90, 77, 72, 
  80, 89, 90, 70, 84, 74, 80, 85, 84, 88, 
  75, 75, 84, 68, 76, 87, 76, 78, 80, 81, 
  82, 74, 93, 82, 101, 90, 78, 70, 92, 85, 
  71, 90, 95, 81, 82, 88, 80, 98, 61, 98, 
  88, 85, 99, 111, 96, 88, 82, 77, 73, 82, 
  79, 80, 104, 77, 77, 84, 93, 72, 81, 78, 
  75, 89, 82, 95, 76, 85, 94, 102, 71, 71, 
  85, 91, 85, 86, 79, 82, 70, 82, 83, 69, 
  85, 83, 92, 71, 96, 67, 84, 74, 80, 90, 
  73, 88, 69, 80, 62, 85, 99, 86, 110, 76, 
  85, 88, 75, 52, 97, 85, 74, 83, 88, 75, 
  74, 109, 87, 89, 85, 64, 99, 78, 68, 81, 
  80, 101, 83, 88, 84, 77, 89, 82, 80, 93, 
  79, 92, 80, 78, 75, 100, 80, 82, 77, 71, 
  81, 64, 85, 88, 87, 73, 86, 80, 90, 74, 
  89, 84, 96, 90, 89, 80, 94, 85, 69, 76, 
  87, 81, 77, 84, 86, 87, 59, 73, 75, 78, 
  74, 96, 96, 96, 90, 86, 70, 92, 77, 80, 
  100, 93, 88, 77, 94, 66, 84, 84, 79, 86, 
  89, 80, 75, 86, 87, 106, 100, 62, 105, 86, 
  85, 83, 84, 87, 77, 95, 81, 53, 94, 78, 
  96, 68, 79, 67, 84, 68, 97, 93, 62, 97, 
  70, 77, 48, 84, 85, 102, 80, 73, 80, 83, 
  70, 36, 101, 91, 66, 117, 115, 83, 76, 78, 
  84, 97, 96, 63, 75, 79, 74, 72, 79, 101, 
  93, 94, 80, 75, 86, 80, 86, 113, 70, 87, 
  73, 87, 70, 114, 81, 84, 74, 73, 66, 66, 
  91, 80, 98, 68, 73, 75, 84, 64, 93, 70, 
  98, 91, 78, 99, 105, 93, 66, 78, 85, 74, 
  70, 90, 89, 85, 49, 66, 69, 84, 54, 81, 
  105, 88, 84, 95, 54, 87, 56, 88, 118, 89, 
  84, 68, 117, 50, 101, 74, 80, 70, 93, 75, 
  71, 104, 100, 93, 99, 48, 106, 85, 105, 76, 
  83, 109, 70, 100, 79, 62, 88, 102, 89, 65, 
  89, 72, 82, 73, 80, 88, 77, 87, 69, 79, 
  57, 83, 68, 91, 81, 74, 93, 86, 76, 52, 
  89, 83, 71, 111, 97, 87, 78, 71, 85, 88, 
  87, 65, 92, 81, 89, 75, 80, 102, 84, 82, 
  85, 75, 89, 79, 82, 96, 80, 81, 79, 82, 
  72, 100, 80, 90, 79, 74, 86, 64, 87, 87, 
  84, 73, 73, 86, 92, 74, 92, 83, 90, 93, 
  82, 87, 97, 89, 70, 99, 87, 85, 80, 92, 
  92, 90, 56, 82, 76, 78, 82, 91, 94, 92, 
  77, 80, 71, 81, 74, 84, 99, 96, 84, 75, 
  89, 69, 94, 85, 82, 80, 92, 83, 90, 88, 
  92, 99, 74, 65, 98, 88, 89, 82, 85, 91, 
  69, 77, 84, 85, 82, 83, 89, 68, 99, 73, 
  84, 75, 87, 93, 75, 87, 61, 81, 71, 85, 
  89, 88, 93, 79, 94, 88, 88, 67, 89, 89, 
  76, 80, 89, 77, 77, 105, 77, 93, 79, 73, 
  92, 90, 76, 81, 78, 95, 78, 84, 87, 77, 
  77, 83, 79, 96, 91, 83, 80, 76, 74, 93, 
  78, 82, 79, 81, 95, 68, 84, 92, 90, 84, 
  87, 89, 94, 78, 86, 96, 88, 87, 92, 82, 
  95, 80, 82, 85, 83, 90, 87, 90, 90, 83, 
  60, 77, 86, 74, 81, 89, 83, 100, 76, 85, 
  81, 97, 84, 79, 86, 94, 78, 84, 78, 82, 
  88, 82, 90, 86, 84, 82, 73, 74, 89, 87, 
  90, 79, 101, 88, 84, 74, 92, 90, 65, 86, 
  78, 74, 79, 81, 82, 68, 87, 71, 87, 70, 
  96, 89, 76, 96, 65, 80, 57, 81, 79, 94, 
  84, 80, 85, 86, 92, 46, 92, 87, 66, 98, 
  104, 77, 71, 93, 70, 103, 88, 74, 71, 92, 
  73, 71, 76, 96, 76, 91, 83, 80, 76, 82, 
  81, 109, 81, 84, 71, 82, 69, 98, 78, 81, 
  76, 75, 100, 66, 90, 83, 103, 87, 86, 85, 
  100, 78, 85, 88, 83, 92, 86, 95, 102, 79, 
  77, 88, 82, 90, 81, 94, 86, 76, 43, 80, 
  78, 71, 66, 74, 86, 102, 73, 91, 75, 100, 
  72, 82, 90, 97, 69, 68, 71, 76, 91, 77, 
  88, 80, 85, 79, 80, 72, 87, 81, 88, 72, 
  99, 86, 92, 62, 92, 100, 70, 92, 73, 77, 
  83, 88, 90, 67, 93, 72, 80, 79, 90, 82, 
  79, 87, 64, 81, 66, 82, 77, 85, 87, 81, 
  91, 87, 92, 62, 85, 86, 75, 95, 99, 85, 
  81, 78, 75, 95, 98, 73, 85, 93, 87, 77, 
  76, 93, 73, 80, 90, 76, 78, 84, 77, 102, 
  90, 86, 77, 82, 72, 93, 81, 81, 85, 82, 
  101, 68, 79, 89, 91, 91, 75, 96, 96, 82, 
  88, 93, 82, 92, 87, 85, 96, 80, 83, 92, 
  84, 98, 86, 96, 90, 78, 54, 83, 83, 75, 
  83, 82, 85, 99, 87, 84, 80, 86, 86, 81, 
  89, 95, 75, 81, 77, 79, 90, 81, 92, 85, 
  86, 87, 95, 73, 90, 86, 82, 83, 96, 90, 
  82, 71, 97, 92, 99, 85, 81, 83, 84, 88, 
  107, 96, 78, 79, 66, 88, 85, 88, 83, 85, 
  93, 90, 92, 80, 70, 82, 99, 91, 85, 85, 
  80, 65, 95, 85, 81, 84, 101, 83, 84, 87, 
  89, 77, 83, 84, 93, 78, 92, 84, 94, 94, 
  87, 80, 90, 84, 78, 90, 81, 76, 74, 81, 
  89, 88, 74, 84, 79, 83, 77, 94, 92, 81, 
  84, 78, 85, 75, 73, 75, 89, 94, 68, 93, 
  94, 73, 84, 86, 84, 87, 80, 75, 89, 84, 
  81, 77, 90, 81, 60, 81, 86, 102, 82, 86, 
  76, 87, 77, 64, 68, 85, 82, 81, 69, 86, 
  87, 90, 65, 110, 87, 86, 92, 74, 79, 74, 
  73, 82, 99, 79, 60, 95, 57, 93, 83, 85, 
  104, 90, 100, 79, 78, 79, 92, 80, 101, 103, 
  82, 76, 64, 86, 96, 86, 85, 91, 101, 89, 
  89, 79, 89, 82, 83, 91, 84, 87, 82, 64, 
  79, 86, 80, 85, 103, 77, 83, 79, 83, 79, 
  88, 89, 84, 64, 91, 82, 80, 98, 90, 70, 
  88, 88, 82, 89, 80, 84, 71, 84, 82, 91, 
  63, 84, 73, 78, 75, 88, 74, 80, 81, 74, 
  82, 61, 69, 68, 94, 89, 69, 86, 88, 78, 
  88, 95, 84, 88, 83, 71, 80, 83, 80, 63, 
  93, 85, 69, 70, 71, 105, 72, 79, 73, 86, 
  81, 67, 59, 71, 80, 79, 66, 73, 81, 90, 
  69, 107, 81, 83, 91, 76, 76, 63, 74, 80, 
  93, 76, 77, 96, 63, 91, 86, 86, 109, 90, 
  97, 77, 73, 80, 89, 96, 105, 92, 77, 79, 
  66, 86, 87, 85, 86, 84, 90, 86, 98, 84, 
  95, 82, 82, 90, 77, 86, 83, 62, 81, 89, 
  84, 79, 99, 80, 90, 88, 85, 76, 90, 85, 
  92, 73, 71, 86, 92, 91, 89, 65, 93, 83, 
  80, 87, 84, 84, 76, 87, 96, 87, 74, 82, 
  76, 80, 74, 96, 90, 79, 85, 86, 84, 81, 
  78, 73, 88, 94, 70, 88, 91, 89, 87, 84, 
  87, 85, 85, 67, 89, 83, 74, 77, 90, 76, 
  66, 83, 84, 99, 83, 82, 76, 86, 83, 71, 
  64, 77, 78, 80, 69, 88, 88, 87, 67, 105, 
  77, 84, 89, 83, 77, 78, 86, 79, 93, 79, 
  79, 93, 63, 92, 83, 87, 105, 90, 75, 92, 
  76, 96, 86, 72, 84, 97, 91, 81, 67, 86, 
  77, 71, 73, 102, 81, 82, 89, 84, 70, 84, 
  78, 90, 83, 78, 88, 81, 87, 81, 73, 88, 
  90, 75, 70, 85, 87, 75, 102, 84, 78, 73, 
  80, 78, 72, 81, 84, 88, 87, 81, 75, 86, 
  75, 76, 78, 87, 81, 82, 94, 82, 84, 83, 
  71, 79, 95, 71, 93, 93, 93, 85, 77, 82, 
  91, 101, 74, 88, 79, 80, 77, 76, 84, 83, 
  94, 95, 84, 82, 81, 84, 85, 88, 76, 89, 
  76, 98, 86, 75, 76, 80, 80, 94, 64, 89, 
  100, 82, 78, 121, 75, 83, 64, 83, 75, 70, 
  77, 75, 90, 95, 76, 76, 86, 84, 81, 75, 
  85, 90, 87, 78, 91, 91, 75, 86, 83, 101, 
  89, 69, 70, 97, 111, 85, 74, 89, 78, 82, 
  74, 99, 84, 80, 97, 79, 83, 87, 65, 90, 
  81, 71, 87, 96, 97, 79, 70, 93, 92, 76, 
  73, 80, 80, 81, 86, 72, 66, 63, 77, 82, 
  59, 83, 78, 84, 79, 83, 73, 94, 81, 76, 
  82, 84, 79, 74, 83, 79, 87, 81, 64, 84, 
  80, 61, 97, 95, 100, 85, 73, 66, 101, 104, 
  74, 83, 73, 87, 84, 63, 82, 83, 104, 96, 
  86, 84, 75, 88, 79, 80, 92, 82, 61, 93, 
  91, 67, 86, 78, 76, 116, 64, 93, 109, 78, 
  68, 137, 72, 90, 68, 70, 67, 67, 74, 75, 
  93, 90, 77, 75, 75, 88, 84, 65, 93, 85, 
  85, 74, 91, 97, 77, 77, 74, 93, 90, 79, 
  84, 99, 97, 81, 69, 86, 78, 100, 78, 102, 
  81, 81, 90, 82, 84, 86, 71, 91, 74, 81, 
  91, 84, 82, 77, 80, 87, 97, 82, 83, 91, 
  82, 80, 71, 83, 75, 77, 72, 81, 70, 83, 
  86, 83, 89, 86, 76, 91, 83, 79, 82, 77, 
  84, 79, 93, 79, 81, 84, 71, 78, 87, 71, 
  87, 97, 97, 89, 68, 78, 91, 99, 77, 81, 
  74, 84, 85, 73, 86, 82, 91, 84, 91, 83, 
  75, 83, 85, 82, 79, 80, 78, 97, 86, 78, 
  77, 81, 84, 98, 64, 94, 96, 81, 82, 122, 
  75, 85, 69, 81, 69, 69, 75, 86, 85, 98, 
  80, 75, 83, 86, 86, 73, 91, 89, 86, 76, 
  94, 97, 62, 97, 95, 83, 77, 89, 77, 83, 
  98, 81, 81, 91, 84, 84, 66, 92, 84, 79, 
  94, 97, 80, 92, 75, 79, 69, 71, 90, 87, 
  81, 80, 88, 85, 71, 72, 72, 98, 79, 75, 
  95, 79, 78, 73, 78, 84, 69, 67, 83, 93, 
  87, 76, 88, 93, 75, 76, 72, 83, 78, 82, 
  107, 80, 88, 89, 89, 69, 93, 72, 83, 99, 
  91, 85, 70, 100, 81, 92, 85, 82, 87, 93, 
  75, 82, 83, 87, 95, 114, 98, 71, 88, 101, 
  80, 93, 89, 75, 79, 88, 81, 86, 76, 81, 
  86, 97, 80, 79, 100, 89, 86, 94, 80, 95, 
  81, 69, 75, 66, 67, 89, 100, 103, 82, 88, 
  74, 91, 82, 84, 99, 80, 98, 83, 83, 89, 
  44, 89, 86, 80, 81, 85, 67, 79, 103, 86, 
  95, 92, 83, 97, 65, 85, 81, 83, 87, 103, 
  77, 99, 75, 79, 66, 75, 90, 100, 99, 83, 
  93, 81, 72, 78, 82, 88, 84, 79, 97, 67, 
  86, 83, 78, 87, 61, 63, 83, 102, 79, 74, 
  88, 101, 77, 68, 72, 100, 70, 77, 116, 85, 
  93, 90, 78, 79, 97, 80, 86, 110, 100, 78, 
  86, 101, 77, 94, 88, 73, 89, 95, 88, 68, 
  76, 88, 91, 101, 115, 72, 83, 114, 72, 84, 
  97, 82, 90, 82, 82, 85, 75, 85, 90, 112, 
  82, 92, 111, 90, 90, 114, 77, 103, 82, 64, 
  73, 73, 65, 87, 104, 118, 81, 89, 71, 90, 
  86, 77, 97, 79, 92, 81, 85, 97, 67, 77, 
  72, 87, 82, 76, 79, 93, 101, 83, 87, 89, 
  85, 92, 75, 88, 81, 84, 88, 95, 79, 83, 
  84, 76, 66, 81, 92, 89, 80, 77, 92, 81, 
  75, 74, 76, 99, 80, 81, 76, 76, 76, 81, 
  80, 85, 67, 65, 87, 100, 91, 79, 89, 81, 
  83, 77, 77, 88, 76, 82, 111, 80, 82, 82, 
  89, 65, 92, 76, 78, 101, 94, 75, 94, 100, 
  87, 95, 87, 85, 85, 87, 83, 82, 82, 84, 
  87, 92, 96, 74, 87, 94, 80, 90, 89, 78, 
  83, 86, 91, 90, 75, 85, 87, 93, 77, 98, 
  99, 88, 89, 98, 78, 94, 81, 71, 72, 66, 
  71, 93, 89, 101, 80, 88, 78, 82, 93, 78, 
  104, 83, 96, 79, 85, 89, 94, 73, 98, 94, 
  70, 75, 88, 73, 77, 74, 83, 82, 96, 81, 
  81, 85, 77, 68, 91, 85, 90, 87, 86, 86, 
  91, 63, 100, 84, 92, 73, 107, 99, 78, 93, 
  85, 70, 90, 89, 73, 79, 75, 107, 68, 95, 
  81, 81, 91, 83, 73, 82, 75, 94, 83, 74, 
  76, 101, 70, 72, 84, 95, 84, 86, 77, 74, 
  79, 74, 102, 75, 85, 72, 68, 87, 83, 105, 
  77, 63, 82, 70, 84, 75, 92, 96, 97, 86, 
  110, 76, 85, 78, 91, 80, 73, 80, 85, 88, 
  66, 83, 91, 75, 88, 74, 72, 91, 79, 83, 
  92, 85, 77, 88, 86, 77, 94, 79, 67, 83, 
  90, 90, 72, 90, 94, 75, 87, 90, 86, 72, 
  78, 73, 85, 103, 75, 82, 87, 93, 76, 60, 
  85, 77, 76, 77, 80, 76, 86, 97, 89, 91, 
  71, 70, 80, 84, 72, 68, 70, 91, 91, 67, 
  106, 84, 102, 69, 109, 95, 79, 92, 76, 61, 
  98, 101, 99, 76, 81, 95, 78, 95, 81, 70, 
  94, 67, 70, 76, 81, 87, 79, 76, 69, 92, 
  57, 76, 88, 99, 87, 103, 90, 77, 71, 78, 
  103, 69, 92, 79, 77, 89, 81, 109, 76, 67, 
  81, 65, 93, 62, 99, 95, 86, 79, 101, 91, 
  75, 79, 95, 75, 80, 78, 94, 88, 71, 86, 
  87, 80, 101, 57, 70, 87, 86, 83, 93, 86, 
  85, 94, 87, 71, 88, 86, 65, 71, 89, 104, 
  63, 88, 91, 71, 89, 89, 81, 74, 78, 80, 
  83, 91, 88, 87, 77, 95, 76, 86, 87, 79, 
  80, 76, 83, 81, 103, 84, 83, 80, 77, 71, 
  89, 86, 66, 76, 76, 83, 93, 66, 105, 85, 
  83, 76, 98, 94, 75, 84, 82, 79, 90, 93, 
  89, 85, 78, 100, 87, 91, 85, 81, 82, 88, 
  68, 85, 77, 85, 83, 84, 79, 75, 64, 77, 
  87, 95, 84, 91, 83, 69, 78, 74, 95, 79, 
  79, 89, 85, 91, 85, 109, 79, 65, 79, 85, 
  73, 71, 92, 84, 94, 77, 103, 89, 77, 75, 
  91, 77, 75, 74, 86, 85, 74, 82, 86, 76, 
  101, 74, 74, 87, 82, 84, 93, 90, 84, 91, 
  90, 80, 70, 75, 70, 83, 95, 87, 69, 90, 
  91, 79, 93, 89, 81, 79, 76, 70, 86, 98, 
  64, 81, 103, 82, 88, 63, 71, 69, 93, 87, 
  78, 100, 95, 107, 68, 72, 78, 68, 78, 81, 
  92, 89, 79, 80, 79, 70, 99, 75, 105, 83, 
  87, 93, 76, 81, 78, 91, 76, 95, 69, 79, 
  87, 78, 73, 81, 85, 98, 68, 75, 92, 81, 
  83, 91, 88, 77, 76, 69, 68, 63, 93, 76, 
  74, 100, 82, 86, 74, 103, 81, 94, 75, 100, 
  56, 71, 84, 87, 71, 90, 75, 84, 91, 76, 
  87, 75, 80, 78, 91, 82, 84, 88, 74, 92, 
  86, 81, 80, 78, 80, 88, 77, 74, 78, 84, 
  78, 73, 86, 82, 92, 81, 80, 83, 73, 76, 
  104, 59, 69, 93, 98, 113, 107, 82, 94, 66, 
  92, 95, 77, 85, 92, 93, 75, 83, 36, 90, 
  72, 85, 86, 71, 60, 78, 98, 97, 68, 92, 
  42, 86, 72, 74, 68, 75, 91, 90, 67, 57, 
  87, 91, 71, 80, 107, 72, 107, 66, 67, 86, 
  73, 81, 73, 78, 62, 84, 71, 57, 86, 55, 
  63, 70, 90, 100, 76, 57, 107, 70, 94, 66, 
  84, 81, 94, 80, 81, 57, 88, 78, 69, 118, 
  99, 56, 92, 83, 72, 91, 67, 130, 78, 63, 
  100, 67, 89, 116, 76, 66, 104, 64, 86, 78, 
  69, 87, 65, 74, 93, 94, 56, 80, 112, 95, 
  64, 72, 117, 75, 85, 71, 76, 75, 75, 112, 
  95, 79, 116, 81, 110, 81, 80, 60, 89, 61, 
  92, 94, 82, 95, 110, 68, 64, 56, 90, 87, 
  71, 114, 100, 102, 70, 59, 69, 94, 58, 78, 
  82, 78, 77, 75, 93, 86, 82, 99, 109, 70, 
  73, 73, 75, 66, 83, 82, 68, 73, 79, 81, 
  78, 77, 101, 82, 101, 78, 81, 90, 80, 88, 
  87, 95, 78, 100, 114, 80, 96, 80, 93, 86, 
  79, 84, 61, 87, 88, 82, 81, 86, 90, 82, 
  88, 95, 78, 71, 92, 78, 75, 106, 83, 86, 
  77, 111, 69, 90, 72, 102, 102, 78, 86, 82, 
  71, 87, 77, 70, 106, 73, 93, 77, 75, 88, 
  96, 86, 89, 81, 77, 96, 97, 84, 82, 80, 
  80, 79, 82, 76, 103, 84, 77, 108, 88, 82, 
  95, 83, 91, 86, 81, 80, 78, 60, 76, 84, 
  83, 85, 72, 81, 92, 70, 88, 95, 75, 90, 
  91, 87, 75, 79, 73, 95, 101, 72, 86, 83, 
  89, 85, 89, 75, 76, 86, 87, 78, 92, 77, 
  80, 81, 76, 84, 63, 83, 80, 73, 86, 86, 
  75, 78, 83, 91, 77, 87, 99, 78, 75, 100, 
  87, 90, 96, 85, 81, 80, 76, 91, 94, 99, 
  72, 75, 88, 87, 83, 86, 83, 79, 80, 98, 
  85, 79, 96, 78, 79, 90, 86, 103, 73, 110, 
  77, 90, 78, 88, 97, 68, 92, 75, 73, 95, 
  80, 88, 83, 95, 88, 83, 87, 84, 94, 78, 
  83, 79, 87, 112, 85, 78, 79, 93, 104, 81, 
  76, 93, 100, 76, 89, 61, 82, 89, 84, 93, 
  74, 86, 84, 101, 84, 84, 89, 87, 82, 78, 
  115, 81, 93, 80, 85, 89, 81, 88, 80, 83, 
  81, 95, 68, 106, 92, 74, 98, 96, 79, 99, 
  97, 72, 80, 75, 62, 84, 80, 85, 72, 76, 
  91, 80, 62, 64, 86, 78, 86, 103, 62, 82, 
  74, 56, 88, 90, 81, 86, 66, 94, 79, 73, 
  75, 72, 72, 71, 57, 86, 106, 105, 85, 79, 
  106, 80, 94, 82, 81, 84, 78, 83, 113, 81, 
  95, 79, 70, 89, 95, 73, 72, 95, 67, 89, 
  74, 73, 92, 60, 88, 75, 83, 114, 77, 81, 
  61, 105, 86, 91, 97, 85, 89, 75, 92, 82, 
  86, 114, 96, 84, 70, 90, 118, 70, 79, 86, 
  85, 83, 83, 69, 99, 86, 83, 72, 95, 78, 
  85, 97, 80, 75, 113, 91, 77, 73, 95, 67, 
  74, 70, 93, 75, 87, 121, 94, 78, 75, 87, 
  80, 87, 97, 74, 90, 85, 92, 85, 85, 74, 
  81, 86, 90, 90, 92, 71, 73, 79, 78, 88, 
  78, 81, 84, 79, 82, 85, 76, 80, 75, 67, 
  80, 86, 99, 92, 95, 100, 85, 86, 69, 81, 
  82, 83, 66, 95, 92, 105, 74, 94, 91, 92, 
  77, 90, 82, 79, 82, 78, 84, 75, 94, 74, 
  77, 89, 84, 104, 78, 105, 74, 87, 82, 94, 
  108, 72, 87, 79, 69, 85, 83, 78, 82, 96, 
  91, 83, 76, 92, 99, 77, 90, 81, 84, 108, 
  85, 78, 81, 91, 93, 83, 77, 90, 91, 78, 
  89, 87, 83, 89, 83, 87, 79, 80, 80, 91, 
  90, 82, 87, 89, 92, 70, 70, 80, 91, 76, 
  96, 88, 93, 90, 77, 81, 79, 94, 85, 73, 
  87, 92, 96, 84, 89, 86, 72, 92, 91, 64, 
  61, 93, 89, 74, 85, 88, 96, 87, 82, 68, 
  91, 81, 106, 107, 82, 86, 93, 76, 77, 92, 
  93, 76, 70, 79, 80, 79, 83, 100, 83, 73, 
  75, 66, 93, 72, 69, 73, 94, 78, 71, 74, 
  67, 73, 78, 70, 83, 90, 74, 88, 84, 71, 
  93, 79, 95, 87, 81, 96, 77, 90, 76, 77, 
  86, 85, 82, 87, 94, 79, 101, 98, 69, 101, 
  97, 96, 64, 86, 97, 68, 80, 89, 90, 90, 
  97, 113, 78, 89, 75, 110, 80, 89, 88, 63, 
  81, 88, 91, 77, 76, 68, 77, 104, 82, 85, 
  95, 91, 71, 75, 89, 84, 60, 65, 97, 98, 
  95, 84, 62, 89, 90, 82, 82, 82, 75, 89, 
  99, 78, 85, 75, 75, 93, 96, 75, 67, 91, 
  92, 72, 89, 86, 97, 82, 83, 68, 87, 87, 
  100, 104, 75, 86, 88, 74, 79, 91, 90, 80, 
  65, 75, 79, 77, 81, 97, 85, 77, 73, 73, 
  99, 73, 69, 78, 89, 80, 66, 73, 75, 74, 
  80, 73, 78, 90, 76, 77, 92, 74, 88, 82, 
  85, 84, 75, 95, 79, 84, 78, 83, 82, 80, 
  84, 81, 99, 65, 102, 99, 71, 101, 95, 81, 
  68, 86, 94, 68, 80, 96, 83, 91, 99, 108, 
  75, 91, 81, 115, 79, 87, 80, 65, 76, 90, 
  92, 77, 74, 67, 75, 105, 82, 86, 92, 89, 
  73, 81, 73, 84, 59, 70, 89, 102, 89, 80, 
  68, 83, 91, 78, 83, 84, 78, 92, 94, 84, 
  85, 81, 75, 92, 93, 67, 70, 87, 87, 76, 
  88, 85, 94, 88, 79, 71, 91, 84, 91, 97, 
  80, 88, 90, 77, 76, 95, 97, 78, 78, 90, 
  84, 81, 81, 96, 85, 76, 77, 76, 92, 76, 
  70, 90, 93, 79, 73, 76, 71, 74, 78, 76, 
  87, 83, 76, 82, 79, 71, 92, 79, 98, 85, 
  78, 99, 80, 85, 88, 74, 85, 82, 87, 86, 
  96, 71, 99, 92, 70, 98, 96, 91, 68, 84, 
  94, 74, 79, 94, 91, 103, 94, 112, 81, 90, 
  75, 105, 79, 92, 88, 78, 79, 88, 91, 78, 
  83, 72, 75, 101, 82, 87, 96, 94, 68, 76, 
  79, 84, 61, 68, 86, 94, 91, 84, 63, 87, 
  92, 80, 87, 72, 85, 88, 103, 88, 93, 92, 
  76, 90, 85, 69, 64, 91, 93, 83, 87, 87, 
  93, 91, 83, 67, 86, 84, 104, 103, 83, 86, 
  89, 73, 83, 91, 92, 82, 79, 83, 78, 79, 
  77, 92, 84, 82, 78, 75, 100, 69, 74, 76, 
  90, 77, 77, 71, 70, 77, 81, 73, 77, 92, 
  78, 85, 84, 76, 84, 86, 90, 91, 79, 77, 
  79, 81, 82, 80, 87, 81, 85, 86, 90, 83, 
  89, 107, 67, 93, 95, 80, 68, 82, 89, 74, 
  81, 81, 81, 82, 99, 112, 78, 100, 81, 109, 
  88, 81, 77, 63, 81, 90, 86, 70, 80, 72, 
  71, 95, 81, 82, 93, 87, 66, 83, 85, 86, 
  66, 66, 89, 98, 95, 84, 65, 91, 97, 77, 
  89, 77, 77, 85, 102, 78, 93, 79, 79, 90, 
  89, 78, 65, 89, 99, 80, 92, 88, 94, 81, 
  84, 68, 81, 91, 106, 93, 78, 84, 84, 78, 
  82, 89, 86, 81, 76, 74, 80, 77, 82, 89, 
  86, 90, 77, 79, 102, 73, 81, 80, 83, 79, 
  77, 73, 77, 76, 84, 74, 75, 93, 82, 76, 
  88, 79, 80, 94, 82, 94, 77, 73, 81, 80, 
  77, 81, 85, 78, 89, 77, 94, 69, 89, 109, 
  68, 96, 93, 75, 72, 80, 87, 74, 82, 83, 
  71, 80, 96, 103, 72, 99, 88, 112, 86, 75, 
  74, 63, 77, 91, 85, 72, 77, 73, 63, 97, 
  81, 83, 88, 83, 72, 86, 74, 89, 68, 71, 
  74, 100, 84, 75, 70, 89, 97, 75, 81, 86, 
  84, 88, 99, 83, 89, 86, 80, 88, 90, 70, 
  66, 86, 88, 88, 88, 86, 92, 87, 81, 70, 
  88, 87, 99, 95, 79, 85, 86, 81, 84, 92, 
  96, 83, 78, 87, 80, 80, 84, 90, 84, 85, 
  76, 81, 96, 75, 78, 94, 88, 79, 80, 77, 
  73, 78, 81, 72, 81, 89, 83, 81, 80, 75, 
  84, 86, 94, 90, 81, 81, 79, 81, 84, 74, 
  86, 80, 85, 89, 90, 72, 90, 103, 70, 93, 
  97, 89, 71, 81, 92, 76, 83, 91, 85, 85, 
  94, 110, 78, 97, 82, 103, 81, 84, 84, 69, 
  79, 89, 84, 71, 80, 73, 70, 94, 82, 84, 
  94, 88, 66, 80, 82, 86, 68, 71, 77, 95, 
  95, 85, 63, 90, 96, 78, 89, 70, 82, 81, 
  91, 90, 96, 103, 80, 85, 81, 74, 66, 85, 
  88, 85, 85, 82, 86, 87, 80, 72, 83, 77, 
  99, 100, 95, 86, 89, 79, 79, 87, 99, 85, 
  84, 87, 79, 81, 74, 87, 81, 88, 76, 79, 
  93, 70, 80, 76, 89, 75, 72, 77, 67, 74, 
  85, 76, 82, 78, 82, 82, 78, 74, 84, 74, 
  100, 92, 79, 80, 80, 94, 93, 80, 83, 84, 
  88, 85, 88, 77, 92, 99, 66, 86, 95, 83, 
  65, 80, 87, 81, 87, 83, 85, 82, 92, 117, 
  79, 96, 71, 106, 86, 84, 91, 69, 82, 90, 
  83, 73, 78, 75, 79, 97, 81, 80, 94, 84, 
  70, 83, 83, 95, 71, 68, 87, 95, 98, 81, 
  59, 92, 88, 84, 90, 76, 79, 78, 90, 73, 
  99, 92, 83, 86, 86, 82, 65, 83, 92, 85, 
  86, 81, 91, 83, 79, 71, 79, 83, 103, 92, 
  91, 85, 85, 87, 75, 88, 98, 79, 82, 76, 
  80, 82, 77, 86, 81, 89, 76, 80, 92, 71, 
  83, 77, 87, 79, 74, 78, 73, 76, 84, 78, 
  81, 82, 83, 82, 77, 76, 81, 77, 88, 92, 
  81, 84, 85, 90, 78, 80, 83, 83, 94, 86, 
  89, 68, 92, 102, 71, 90, 96, 79, 69, 78, 
  87, 79, 86, 84, 81, 82, 95, 114, 71, 97, 
  79, 105, 88, 80, 89, 68, 80, 90, 83, 73, 
  77, 75, 79, 98, 80, 81, 89, 81, 75, 81, 
  74, 98, 74, 71, 77, 95, 97, 73, 66, 93, 
  87, 81, 83, 83, 86, 81, 92, 79, 92, 93, 
  84, 85, 84, 77, 66, 85, 84, 84, 84, 80, 
  86, 89, 80, 73, 90, 82, 99, 89, 88, 83, 
  86, 86, 76, 91, 98, 83, 77, 88, 81, 82, 
  85, 83, 81, 83, 77, 83, 93, 76, 83, 90, 
  86, 77, 74, 87, 70, 76, 88, 74, 84, 76, 
  88, 78, 77, 73, 85, 80, 107, 91, 80, 79, 
  79, 96, 84, 74, 82, 82, 89, 86, 89, 73, 
  89, 92, 71, 87, 97, 89, 70, 81, 88, 88, 
  86, 87, 86, 84, 89, 113, 79, 92, 76, 101, 
  85, 85, 95, 72, 80, 88, 84, 76, 79, 78, 
  79, 92, 79, 81, 92, 86, 69, 82, 87, 95, 
  73, 73, 80, 90, 97, 81, 57, 91, 89, 80, 
  73, 104, 73, 88, 71, 84, 87, 87, 84, 86, 
  74, 76, 79, 71, 87, 74, 79, 83, 88, 86, 
  97, 82, 91, 92, 103, 79, 88, 85, 98, 112, 
  74, 85, 83, 79, 78, 84, 89, 88, 148, 90, 
  84, 93, 67, 91, 86, 83, 87, 76, 84, 76, 
  86, 76, 90, 77, 75, 114, 76, 78, 83, 86, 
  85, 75, 96, 83, 66, 76, 84, 83, 76, 83, 
  81, 103, 78, 83, 91, 75, 86, 89, 79, 78, 
  83, 81, 85, 99, 78, 94, 84, 98, 84, 90, 
  87, 70, 73, 79, 80, 80, 90, 78, 73, 89, 
  80, 71, 96, 94, 87, 85, 85, 88, 88, 77, 
  80, 79, 76, 84, 79, 99, 77, 85, 85, 91, 
  81, 87, 84, 74, 80, 91, 89, 88, 66, 89, 
  63, 79, 90, 74, 74, 86, 82, 83, 77, 75, 
  71, 63, 75, 72, 87, 70, 76, 76, 92, 77, 
  84, 89, 101, 69, 81, 81, 120, 106, 78, 79, 
  81, 74, 68, 100, 84, 78, 156, 89, 87, 78, 
  79, 92, 98, 93, 83, 79, 86, 73, 82, 78, 
  84, 77, 67, 104, 76, 80, 94, 81, 84, 82, 
  90, 100, 50, 79, 79, 82, 81, 83, 116, 92, 
  86, 92, 86, 80, 77, 83, 88, 75, 77, 74, 
  85, 80, 85, 97, 82, 110, 73, 81, 75, 88, 
  81, 81, 82, 73, 87, 80, 78, 95, 83, 82, 
  90, 95, 88, 77, 71, 87, 82, 73, 77, 81, 
  70, 77, 72, 92, 72, 85, 76, 87, 88, 95, 
  81, 72, 77, 83, 84, 91, 68, 87, 79, 96, 
  68, 78, 87, 95, 87, 89, 75, 75, 77, 68, 
  86, 91, 83, 93, 84, 82, 90, 74, 92, 88, 
  97, 78, 83, 90, 61, 84, 82, 84, 89, 70, 
  77, 94, 57, 85, 93, 87, 96, 72, 77, 90, 
  85, 93, 90, 77, 71, 89, 84, 90, 83, 78, 
  91, 74, 81, 96, 90, 87, 83, 71, 83, 68, 
  91, 65, 85, 86, 78, 98, 70, 79, 109, 88, 
  83, 75, 77, 77, 81, 73, 102, 76, 76, 89, 
  77, 96, 88, 67, 77, 82, 81, 87, 84, 78, 
  82, 74, 89, 79, 70, 80, 85, 83, 76, 96, 
  83, 89, 85, 87, 78, 73, 71, 93, 81, 92, 
  79, 78, 87, 84, 81, 81, 88, 83, 100, 92, 
  96, 82, 83, 78, 84, 102, 76, 95, 54, 88, 
  95, 89, 95, 81, 78, 77, 87, 70, 93, 81, 
  85, 89, 86, 92, 100, 88, 106, 97, 100, 83, 
  89, 87, 90, 93, 76, 86, 81, 78, 89, 78, 
  80, 80, 98, 84, 82, 78, 68, 84, 78, 91, 
  85, 80, 75, 85, 79, 86, 88, 73, 95, 95, 
  77, 89, 85, 90, 81, 72, 89, 73, 81, 72, 
  82, 78, 79, 83, 85, 78, 84, 87, 92, 75, 
  84, 90, 77, 78, 96, 72, 81, 98, 75, 89, 
  76, 78, 87, 94, 91, 77, 80, 81, 87, 78, 
  82, 70, 75, 86, 82, 67, 80, 88, 80, 87, 
  88, 85, 83, 89, 73, 80, 89, 90, 71, 73, 
  80, 81, 83, 82, 80, 76, 94, 92, 81, 87, 
  77, 78, 76, 105, 61, 83, 75, 78, 78, 77, 
  88, 82, 78, 75, 71, 58, 79, 68, 87, 70, 
  75, 80, 91, 76, 91, 89, 100, 74, 84, 83, 
  119, 97, 76, 84, 77, 73, 73, 92, 84, 79, 
  149, 83, 86, 73, 75, 83, 87, 92, 85, 71, 
  85, 74, 81, 81, 87, 78, 76, 99, 67, 79, 
  83, 83, 85, 85, 91, 93, 57, 73, 74, 72, 
  85, 67, 108, 88, 78, 89, 86, 75, 85, 87, 
  90, 75, 74, 74, 82, 90, 78, 93, 75, 105, 
  73, 84, 78, 79, 84, 80, 83, 79, 87, 81, 
  74, 83, 75, 75, 90, 91, 79, 72, 69, 75, 
  74, 75, 77, 78, 71, 80, 65, 82, 61, 86, 
  76, 84, 87, 85, 84, 67, 69, 83, 80, 80, 
  78, 87, 57, 83, 80, 75, 77, 82, 80, 82, 
  76, 76, 75, 67, 74, 75, 89, 83, 84, 79, 
  91, 74, 86, 85, 97, 77, 84, 81, 104, 88, 
  90, 93, 82, 70, 75, 105, 90, 82, 135, 87, 
  98, 79, 84, 83, 92, 93, 90, 75, 91, 80, 
  72, 83, 85, 78, 81, 75, 72, 82, 85, 84, 
  91, 93, 93, 96, 62, 72, 72, 93, 92, 84, 
  92, 90, 93, 92, 86, 80, 76, 81, 96, 76, 
  82, 80, 80, 79, 85, 89, 78, 98, 63, 72, 
  79, 92, 86, 78, 88, 73, 87, 87, 78, 80, 
  78, 79, 82, 95, 86, 73, 70, 77, 79, 67, 
  81, 94, 74, 83, 71, 94, 72, 90, 77, 89, 
  93, 93, 85, 71, 78, 86, 86, 81, 98, 96, 
  84, 81, 59, 89, 95, 83, 80, 85, 78, 86, 
  93, 82, 83, 83, 85, 85, 88, 102, 99, 89, 
  106, 88, 96, 89, 82, 88, 80, 94, 86, 86, 
  83, 83, 89, 85, 96, 88, 109, 88, 91, 83, 
  73, 91, 83, 87, 80, 82, 75, 87, 86, 88, 
  79, 77, 103, 101, 86, 103, 93, 88, 83, 79, 
  95, 81, 87, 92, 78, 85, 73, 92, 102, 95, 
  80, 80, 86, 82, 80, 89, 75, 82, 100, 78, 
  76, 90, 92, 90, 74, 85, 85, 82, 81, 75, 
  82, 73, 85, 87, 78, 75, 75, 90, 77, 79, 
  83, 94, 87, 94, 85, 92, 86, 92, 79, 82, 
  88, 84, 75, 91, 87, 89, 92, 93, 80, 89, 
  87, 92, 91, 91, 83, 78, 86, 106, 83, 91, 
  59, 96, 90, 81, 88, 84, 81, 81, 74, 81, 
  85, 83, 89, 88, 83, 95, 93, 71, 103, 95, 
  91, 80, 89, 84, 85, 85, 85, 87, 87, 75, 
  83, 88, 87, 82, 91, 76, 85, 79, 76, 77, 
  81, 94, 84, 77, 80, 90, 93, 80, 85, 76, 
  89, 75, 75, 95, 79, 90, 87, 83, 93, 79, 
  88, 67, 81, 80, 80, 84, 87, 96, 85, 83, 
  86, 81, 86, 92, 84, 77, 90, 78, 83, 97, 
  78, 91, 82, 83, 89, 90, 90, 76, 82, 80, 
  89, 79, 87, 81, 74, 79, 80, 82, 83, 95, 
  87, 87, 86, 73, 80, 82, 79, 85, 81, 89, 
  74, 87, 80, 88, 79, 84, 90, 83, 91, 78, 
  80, 93, 75, 77, 79, 90, 68, 92, 74, 86, 
  82, 74, 80, 85, 83, 75, 86, 79, 73, 71, 
  89, 79, 84, 90, 85, 65, 98, 93, 93, 76, 
  92, 84, 86, 85, 98, 85, 81, 78, 70, 99, 
  89, 90, 120, 86, 92, 84, 76, 73, 77, 88, 
  96, 83, 93, 77, 81, 79, 83, 78, 73, 63, 
  74, 85, 80, 97, 93, 91, 92, 100, 79, 63, 
  80, 87, 95, 86, 93, 107, 80, 86, 87, 79, 
  79, 86, 87, 76, 80, 78, 85, 92, 94, 90, 
  80, 95, 78, 86, 82, 85, 86, 86, 83, 75, 
  90, 86, 77, 82, 72, 69, 86, 96, 87, 81, 
  71, 74, 81, 62, 83, 86, 77, 85, 78, 98, 
  84, 90, 85, 82, 99, 94, 81, 67, 75, 97, 
  79, 82, 107, 92, 78, 92, 85, 88, 78, 84, 
  75, 79, 68, 81, 86, 97, 97, 90, 90, 86, 
  76, 69, 76, 83, 101, 83, 87, 78, 88, 90, 
  90, 88, 83, 80, 75, 108, 89, 83, 85, 88, 
  83, 80, 85, 76, 98, 79, 80, 75, 88, 88, 
  85, 82, 89, 77, 78, 82, 83, 87, 76, 88, 
  82, 81, 81, 85, 83, 82, 87, 88, 84, 78, 
  102, 80, 95, 91, 84, 79, 83, 80, 79, 82, 
  86, 78, 86, 89, 82, 76, 73, 80, 83, 86, 
  89, 72, 65, 85, 82, 99, 80, 74, 90, 84, 
  91, 76, 76, 85, 81, 102, 77, 79, 78, 88, 
  82, 75, 73, 92, 78, 86, 71, 77, 82, 86, 
  86, 88, 74, 75, 94, 83, 88, 88, 87, 73, 
  131, 94, 88, 90, 99, 94, 76, 75, 67, 75, 
  72, 79, 93, 83, 97, 82, 86, 85, 73, 70, 
  81, 85, 88, 84, 110, 79, 94, 82, 91, 85, 
  94, 89, 80, 88, 90, 83, 78, 92, 95, 81, 
  84, 82, 82, 91, 96, 84, 87, 80, 78, 75, 
  83, 79, 78, 85, 86, 79, 66, 85, 82, 78, 
  83, 72, 87, 82, 74, 86, 100, 77, 89, 74, 
  79, 99, 77, 76, 85, 74, 69, 97, 69, 80, 
  84, 92, 95, 71, 75, 88, 79, 91, 83, 76, 
  52, 73, 74, 115, 71, 75, 86, 94, 88, 77, 
  69, 86, 78, 103, 82, 72, 72, 90, 104, 76, 
  85, 93, 77, 80, 78, 87, 84, 96, 90, 81, 
  79, 68, 104, 75, 91, 92, 88, 74, 88, 73, 
  98, 86, 80, 99, 78, 88, 90, 88, 70, 93, 
  69, 84, 92, 89, 90, 79, 75, 83, 95, 78, 
  82, 83, 91, 75, 88, 89, 87, 91, 81, 78, 
  77, 82, 87, 98, 81, 89, 81, 84, 82, 76, 
  73, 89, 78, 78, 83, 79, 92, 80, 88, 82, 
  78, 74, 82, 86, 86, 88, 91, 82, 76, 90, 
  80, 72, 91, 86, 86, 81, 92, 71, 79, 78, 
  86, 75, 82, 85, 85, 89, 72, 73, 83, 95, 
  80, 73, 80, 91, 85, 82, 90, 76, 75, 87, 
  86, 88, 89, 78, 84, 81, 89, 83, 83, 65, 
  82, 98, 81, 79, 83, 85, 80, 85, 87, 81, 
  84, 86, 80, 82, 99, 76, 81, 89, 89, 84, 
  95, 93, 80, 87, 87, 77, 119, 84, 84, 69, 
  97, 74, 72, 87, 69, 81, 73, 78, 75, 108, 
  81, 76, 81, 79, 77, 83, 75, 78, 91, 87, 
  78, 80, 87, 88, 105, 94, 93, 84, 76, 127, 
  91, 83, 112, 84, 72, 74, 84, 76, 99, 86, 
  63, 68, 73, 86, 91, 78, 85, 76, 83, 81, 
  64, 87, 87, 82, 84, 80, 88, 81, 81, 80, 
  90, 81, 80, 90, 99, 67, 107, 83, 79, 75, 
  75, 77, 82, 75, 113, 73, 84, 73, 77, 83, 
  104, 80, 90, 95, 78, 72, 73, 84, 79, 89, 
  91, 74, 75, 78, 81, 83, 81, 100, 94, 99, 
  78, 91, 76, 90, 68, 88, 71, 105, 71, 87, 
  89, 71, 65, 93, 84, 99, 69, 67, 82, 71, 
  83, 90, 78, 70, 148, 82, 97, 82, 119, 78, 
  67, 81, 58, 81, 74, 70, 89, 84, 90, 74, 
  85, 80, 84, 92, 80, 88, 70, 82, 112, 77, 
  84, 75, 103, 105, 101, 92, 81, 125, 85, 93, 
  95, 98, 118, 71, 86, 69, 73, 99, 69, 61, 
  76, 68, 83, 73, 80, 76, 82, 85, 56, 88, 
  75, 86, 75, 93, 101, 72, 80, 84, 69, 81, 
  92, 96, 108, 70, 74, 88, 76, 74, 72, 73, 
  80, 90, 84, 74, 82, 67, 91, 78, 125, 101, 
  79, 106, 72, 68, 67, 75, 63, 110, 76, 80, 
  71, 83, 82, 69, 67, 73, 97, 98, 71, 104, 
  76, 91, 76, 81, 76, 117, 68, 83, 100, 80, 
  84, 100, 84, 86, 68, 61, 81, 64, 86, 99, 
  76, 60, 94, 72, 82, 70, 79, 102, 74, 87, 
  89, 85, 79, 86, 71, 77, 75, 74, 82, 75, 
  77, 86, 97, 82, 73, 87, 87, 73, 87, 87, 
  96, 102, 80, 83, 72, 86, 81, 99, 97, 81, 
  98, 75, 82, 81, 66, 83, 68, 71, 71, 71, 
  86, 89, 89, 82, 84, 74, 75, 88, 92, 81, 
  96, 75, 85, 78, 77, 63, 82, 82, 87, 87, 
  89, 82, 68, 82, 86, 79, 70, 83, 93, 96, 
  79, 75, 78, 80, 75, 76, 87, 87, 83, 94, 
  84, 77, 76, 83, 84, 82, 85, 73, 75, 74, 
  89, 85, 87, 59, 90, 96, 90, 87, 83, 82, 
  71, 98, 78, 87, 84, 87, 89, 92, 102, 76, 
  86, 103, 99, 78, 82, 87, 81, 87, 81, 87, 
  84, 84, 82, 54, 77, 82, 81, 84, 84, 87, 
  80, 90, 78, 94, 73, 71, 68, 78, 82, 73, 
  88, 91, 74, 95, 70, 80, 93, 89, 92, 81, 
  82, 85, 98, 99, 99, 79, 105, 76, 73, 78, 
  83, 67, 94, 78, 64, 90, 71, 61, 86, 108, 
  81, 89, 87, 82, 80, 81, 89, 74, 90, 71, 
  84, 85, 71, 78, 85, 83, 74, 79, 85, 81, 
  92, 68, 93, 80, 73, 93, 88, 85, 116, 68, 
  79, 84, 86, 85, 84, 76, 87, 89, 90, 103, 
  93, 75, 81, 67, 93, 77, 89, 71, 70, 101, 
  90, 81, 85, 93, 91, 67, 80, 95, 100, 102, 
  80, 95, 92, 79, 80, 82, 72, 74, 89, 105, 
  77, 85, 83, 86, 86, 89, 73, 107, 89, 76, 
  79, 60, 79, 74, 76, 84, 75, 84, 78, 86, 
  66, 87, 78, 69, 68, 78, 75, 83, 87, 96, 
  80, 90, 72, 75, 94, 77, 89, 109, 76, 78, 
  85, 102, 91, 80, 107, 71, 92, 72, 90, 62, 
  79, 80, 61, 83, 70, 67, 79, 106, 78, 86, 
  85, 78, 71, 80, 92, 70, 93, 77, 89, 87, 
  79, 83, 83, 81, 74, 87, 79, 94, 81, 68, 
  95, 79, 71, 91, 93, 72, 106, 61, 79, 80, 
  80, 82, 86, 91, 84, 92, 86, 88, 83, 76, 
  84, 67, 94, 71, 84, 71, 74, 87, 85, 76, 
  88, 93, 95, 77, 84, 90, 78, 103, 76, 100, 
  95, 85, 92, 83, 86, 72, 82, 109, 98, 85, 
  74, 84, 77, 98, 74, 105, 83, 84, 77, 63, 
  77, 77, 85, 79, 98, 82, 82, 93, 86, 84, 
  72, 75, 67, 79, 81, 72, 92, 86, 83, 101, 
  75, 82, 88, 92, 84, 111, 80, 85, 98, 89, 
  77, 85, 102, 79, 94, 84, 75, 72, 86, 87, 
  70, 94, 75, 83, 82, 103, 80, 95, 88, 82, 
  86, 86, 89, 75, 88, 80, 82, 79, 68, 68, 
  85, 83, 79, 74, 79, 89, 76, 76, 89, 81, 
  72, 83, 90, 74, 76, 72, 79, 92, 85, 75, 
  88, 85, 75, 86, 98, 91, 90, 78, 76, 76, 
  78, 81, 87, 73, 96, 107, 82, 72, 85, 92, 
  98, 69, 84, 88, 97, 99, 89, 81, 96, 78, 
  75, 79, 84, 67, 93, 93, 118, 84, 91, 93, 
  87, 85, 79, 108, 89, 84, 79, 78, 90, 75, 
  73, 82, 86, 79, 78, 91, 80, 85, 73, 83, 
  75, 84, 76, 99, 84, 73, 100, 87, 77, 89, 
  68, 82, 88, 69, 74, 68, 75, 82, 89, 96, 
  82, 76, 77, 102, 84, 91, 81, 93, 93, 80, 
  84, 87, 79, 81, 80, 98, 87, 67, 88, 74, 
  82, 84, 97, 80, 82, 90, 94, 67, 74, 71, 
  75, 81, 102, 77, 78, 84, 87, 67, 91, 86, 
  79, 95, 88, 96, 95, 93, 87, 78, 84, 86, 
  80, 81, 104, 79, 94, 81, 70, 80, 88, 86, 
  82, 81, 95, 90, 76, 77, 67, 82, 79, 104, 
  76, 78, 84, 76, 78, 80, 76, 92, 76, 83, 
  82, 74, 73, 84, 87, 71, 92, 84, 96, 89, 
  80, 85, 94, 78, 80, 90, 82, 77, 63, 77, 
  94, 85, 73, 77, 82, 92, 103, 69, 87, 92, 
  96, 90, 89, 83, 131, 71, 72, 77, 83, 94, 
  87, 82, 100, 91, 63, 78, 98, 85, 90, 84, 
  82, 70, 64, 91, 77, 67, 84, 76, 81, 83, 
  93, 92, 73, 80, 77, 72, 79, 72, 67, 67, 
  89, 100, 104, 103, 85, 90, 64, 68, 85, 89, 
  91, 90, 72, 100, 67, 89, 80, 79, 187, 105, 
  86, 73, 78, 82, 67, 78, 77, 89, 77, 94, 
  65, 79, 79, 108, 84, 96, 79, 95, 113, 60, 
  86, 56, 81, 109, 93, 84, 107, 68, 97, 69, 
  89, 88, 92, 99, 79, 80, 76, 87, 77, 99, 
  100, 87, 85, 142, 84, 77, 68, 91, 82, 67, 
  93, 87, 87, 85, 80, 115, 67, 70, 85, 75, 
  73, 82, 89, 80, 87, 76, 88, 90, 98, 92, 
  77, 80, 80, 79, 91, 77, 78, 88, 86, 105, 
  92, 105, 67, 79, 80, 83, 89, 81, 84, 78, 
  74, 85, 88, 70, 86, 83, 89, 88, 90, 87, 
  75, 86, 80, 72, 85, 70, 63, 71, 81, 91, 
  103, 94, 86, 89, 67, 60, 67, 83, 86, 83, 
  77, 93, 67, 83, 81, 85, 139, 82, 86, 78, 
  82, 87, 78, 83, 79, 90, 81, 89, 74, 79, 
  91, 112, 83, 90, 87, 91, 107, 66, 81, 71, 
  82, 111, 83, 80, 94, 75, 87, 74, 84, 84, 
  90, 91, 78, 83, 80, 78, 73, 91, 93, 81, 
  79, 114, 89, 79, 80, 92, 83, 65, 88, 87, 
  83, 73, 89, 76, 84, 84, 81, 82, 83, 81, 
  84, 84, 76, 86, 74, 85, 78, 90, 78, 80, 
  77, 93, 83, 94, 72, 81, 85, 71, 79, 72, 
  81, 87, 94, 92, 74, 82, 75, 105, 85, 90, 
  94, 96, 84, 84, 81, 88, 81, 82, 84, 107, 
  86, 72, 84, 69, 83, 87, 96, 80, 76, 85, 
  90, 69, 78, 78, 74, 74, 92, 78, 80, 70, 
  91, 80, 91, 85, 73, 93, 84, 94, 93, 91, 
  95, 76, 84, 80, 83, 80, 104, 87, 100, 79, 
  71, 83, 89, 85, 80, 90, 88, 97, 76, 85, 
  71, 84, 75, 91, 75, 83, 90, 79, 83, 87, 
  83, 90, 72, 82, 78, 79, 81, 81, 74, 72, 
  91, 85, 93, 77, 80, 88, 89, 74, 79, 87, 
  83, 73, 73, 89, 84, 89, 71, 71, 69, 81, 
  97, 74, 76, 78, 82, 95, 81, 81, 97, 81, 
  79, 86, 92, 88, 88, 91, 77, 91, 80, 90, 
  122, 98, 88, 100, 76, 76, 68, 81, 78, 72, 
  61, 89, 86, 77, 101, 96, 73, 86, 81, 70, 
  72, 70, 75, 74, 87, 97, 84, 100, 81, 82, 
  69, 73, 66, 90, 104, 79, 84, 94, 97, 83, 
  88, 91, 132, 106, 105, 73, 78, 79, 81, 81, 
  84, 88, 88, 95, 67, 79, 86, 81, 82, 88, 
  95, 80, 85, 70, 87, 74, 77, 89, 90, 87, 
  87, 98, 83, 76, 80, 76, 72, 99, 78, 84, 
  74, 83, 73, 90, 83, 102, 72, 105, 75, 77, 
  71, 78, 73, 74, 86, 83, 92, 82, 76, 95, 
  73, 81, 81, 80, 74, 72, 73, 75, 89, 76, 
  76, 80, 86, 98, 88, 80, 85, 83, 83, 87, 
  85, 88, 89, 127, 74, 102, 80, 83, 83, 89, 
  83, 95, 85, 82, 75, 80, 80, 72, 71, 84, 
  81, 87, 100, 92, 75, 82, 80, 71, 78, 75, 
  69, 78, 77, 95, 80, 96, 88, 88, 78, 69, 
  65, 89, 97, 88, 69, 94, 92, 85, 84, 96, 
  122, 80, 88, 80, 79, 84, 83, 93, 84, 101, 
  83, 91, 69, 75, 95, 79, 81, 83, 88, 80, 
  91, 76, 82, 81, 81, 89, 84, 84, 82, 99, 
  83, 78, 77, 72, 74, 95, 76, 77, 78, 83, 
  90, 85, 84, 97, 83, 95, 78, 79, 79, 84, 
  75, 71, 85, 86, 82, 78, 84, 93, 86, 75, 
  81, 84, 82, 78, 90, 85, 81, 84, 74, 81, 
  87, 85, 81, 88, 69, 84, 97, 81, 82, 83, 
  79, 80, 78, 79, 83, 83, 76, 80, 81, 84, 
  83, 89, 85, 88, 90, 100, 96, 86, 79, 86, 
  82, 76, 83, 100, 81, 79, 80, 80, 85, 92, 
  88, 84, 85, 82, 87, 84, 87, 90, 85, 80, 
  82, 84, 81, 62, 80, 79, 86, 77, 80, 85, 
  83, 93, 88, 92, 93, 83, 90, 81, 77, 78, 
  90, 85, 95, 80, 72, 87, 84, 82, 95, 97, 
  83, 100, 84, 90, 78, 85, 82, 82, 75, 88, 
  89, 73, 94, 86, 84, 79, 85, 87, 87, 83, 
  90, 75, 81, 78, 79, 82, 88, 81, 88, 89, 
  89, 81, 75, 77, 87, 76, 90, 75, 79, 85, 
  75, 71, 82, 84, 80, 85, 67, 81, 84, 83, 
  84, 84, 73, 91, 89, 92, 84, 84, 81, 75, 
  77, 83, 93, 80, 72, 81, 79, 72, 87, 94, 
  81, 86, 89, 92, 93, 93, 80, 84, 85, 84, 
  82, 100, 84, 72, 84, 80, 90, 93, 90, 78, 
  80, 83, 87, 79, 77, 90, 82, 78, 75, 93, 
  76, 60, 90, 90, 82, 89, 76, 79, 88, 83, 
  91, 92, 93, 77, 89, 77, 81, 81, 83, 90, 
  101, 82, 78, 79, 81, 82, 84, 94, 82, 103, 
  77, 87, 74, 84, 75, 84, 73, 88, 86, 72, 
  80, 91, 82, 78, 81, 82, 74, 80, 82, 79, 
  85, 73, 83, 80, 96, 90, 77, 85, 93, 89, 
  75, 78, 83, 64, 87, 74, 83, 83, 76, 71, 
  80, 82, 74, 86, 65, 82, 85, 87, 87, 85, 
  92, 89, 79, 94, 81, 88, 83, 71, 75, 88, 
  91, 79, 78, 78, 78, 78, 86, 94, 80, 86, 
  89, 90, 100, 89, 77, 91, 82, 81, 79, 95, 
  82, 76, 86, 76, 84, 93, 84, 78, 82, 81, 
  87, 84, 83, 89, 77, 77, 79, 91, 74, 61, 
  90, 87, 82, 90, 81, 82, 82, 87, 89, 92, 
  93, 73, 88, 76, 74, 77, 79, 90, 102, 84, 
  74, 81, 83, 83, 90, 91, 82, 103, 78, 85, 
  77, 84, 77, 84, 77, 86, 90, 66, 81, 88, 
  82, 78, 82, 80, 79, 79, 81, 82, 87, 72, 
  84, 83, 94, 88, 81, 85, 94, 68, 98, 66, 
  82, 81, 78, 73, 82, 83, 70, 84, 86, 80, 
  68, 79, 78, 82, 71, 81, 78, 75, 102, 82, 
  83, 92, 80, 63, 97, 102, 81, 69, 74, 91, 
  96, 77, 79, 84, 91, 84, 82, 77, 89, 72, 
  91, 88, 93, 79, 87, 73, 85, 84, 77, 78, 
  77, 81, 86, 84, 86, 95, 70, 79, 79, 80, 
  100, 90, 88, 96, 82, 99, 73, 102, 96, 97, 
  82, 86, 77, 77, 76, 73, 84, 79, 84, 111, 
  72, 71, 93, 86, 87, 79, 87, 82, 67, 82, 
  84, 74, 85, 94, 90, 88, 91, 93, 72, 98, 
  95, 85, 77, 99, 93, 71, 71, 71, 65, 96, 
  100, 99, 109, 67, 73, 80, 72, 71, 91, 71, 
  88, 107, 81, 80, 97, 79, 85, 67, 85, 71, 
  77, 74, 86, 73, 59, 86, 92, 78, 77, 77, 
  85, 82, 60, 98, 86, 74, 82, 82, 84, 87, 
  91, 51, 101, 106, 75, 77, 75, 81, 103, 69, 
  87, 79, 83, 88, 86, 82, 84, 70, 88, 75, 
  84, 71, 106, 67, 85, 85, 75, 79, 75, 84, 
  88, 81, 91, 86, 62, 75, 81, 85, 88, 88, 
  87, 86, 81, 106, 86, 117, 103, 94, 95, 75, 
  74, 84, 85, 81, 81, 77, 70, 85, 72, 71, 
  83, 92, 91, 85, 98, 93, 64, 84, 86, 80, 
  89, 93, 88, 83, 91, 89, 71, 104, 104, 82, 
  75, 108, 96, 71, 79, 68, 72, 88, 90, 79, 
  75, 62, 63, 81, 69, 71, 82, 83, 84, 104, 
  68, 74, 92, 83, 80, 61, 81, 89, 80, 75, 
  92, 86, 67, 87, 87, 84, 76, 78, 78, 81, 
  80, 105, 90, 74, 73, 80, 83, 93, 92, 66, 
  92, 79, 85, 83, 73, 68, 94, 79, 88, 86, 
  83, 86, 85, 76, 75, 69, 94, 87, 91, 87, 
  84, 74, 84, 86, 78, 81, 79, 85, 86, 89, 
  83, 89, 72, 86, 79, 81, 99, 89, 86, 89, 
  79, 85, 95, 104, 123, 89, 97, 86, 79, 95, 
  86, 77, 83, 83, 79, 81, 75, 73, 92, 87, 
  84, 82, 87, 95, 72, 82, 75, 79, 83, 97, 
  96, 86, 88, 100, 74, 100, 86, 86, 78, 93, 
  92, 74, 81, 73, 67, 102, 85, 95, 82, 74, 
  81, 75, 78, 76, 92, 78, 88, 99, 86, 80, 
  82, 75, 82, 88, 89, 90, 87, 66, 81, 70, 
  71, 78, 87, 81, 78, 86, 73, 88, 69, 85, 
  88, 77, 92, 82, 81, 93, 66, 50, 107, 101, 
  98, 76, 73, 109, 96, 78, 79, 96, 82, 84, 
  84, 87, 97, 81, 97, 85, 93, 95, 93, 75, 
  81, 87, 76, 73, 76, 85, 86, 90, 85, 107, 
  87, 78, 82, 92, 98, 90, 85, 93, 93, 89, 
  91, 78, 75, 91, 76, 74, 77, 71, 78, 73, 
  81, 72, 78, 85, 74, 78, 91, 82, 86, 70, 
  96, 76, 63, 82, 99, 78, 96, 94, 81, 90, 
  77, 97, 81, 100, 99, 76, 80, 111, 81, 57, 
  76, 81, 71, 93, 82, 82, 103, 63, 64, 91, 
  79, 64, 80, 66, 85, 95, 70, 78, 79, 97, 
  82, 92, 94, 71, 92, 66, 86, 54, 49, 80, 
  95, 75, 95, 86, 81, 87, 56, 90, 90, 78, 
  74, 83, 76, 102, 68, 40, 112, 89, 109, 91, 
  79, 91, 92, 67, 83, 110, 88, 93, 76, 102, 
  101, 83, 100, 66, 90, 76, 114, 66, 84, 81, 
  86, 76, 69, 83, 86, 84, 89, 100, 73, 68, 
  79, 102, 73, 92, 102, 98, 90, 83, 73, 91, 
  73, 95, 83, 60, 77, 76, 70, 83, 79, 76, 
  73, 60, 74, 89, 77, 85, 92, 76, 121, 63, 
  54, 82, 86, 85, 100, 89, 84, 87, 63, 76, 
  88, 106, 111, 73, 78, 121, 86, 60, 89, 81, 
  79, 76, 72, 68, 69, 58, 54, 91, 71, 67, 
  68, 75, 70, 91, 67, 78, 86, 89, 92, 74, 
  82, 95, 87, 69, 84, 69, 66, 78, 81, 81, 
  83, 85, 75, 85, 77, 115, 83, 82, 77, 75, 
  74, 88, 77, 51, 93, 73, 95, 85, 69, 74, 
  98, 79, 88, 87, 83, 84, 83, 82, 88, 75, 
  92, 75, 93, 86, 85, 74, 80, 83, 73, 73, 
  77, 79, 89, 95, 84, 96, 82, 82, 82, 83, 
  100, 85, 82, 88, 85, 93, 94, 81, 103, 86, 
  88, 70, 80, 101, 81, 75, 82, 73, 76, 74, 
  78, 89, 89, 93, 85, 74, 89, 79, 65, 78, 
  88, 69, 95, 98, 85, 85, 80, 86, 80, 102, 
  88, 79, 81, 104, 84, 62, 88, 85, 71, 93, 
  79, 83, 98, 69, 67, 90, 78, 68, 78, 72, 
  81, 96, 71, 81, 74, 78, 74, 83, 75, 93, 
  76, 74, 78, 78, 83, 90, 86, 75, 70, 78, 
  74, 82, 87, 86, 94, 75, 93, 83, 76, 93, 
  90, 65, 87, 84, 94, 79, 79, 110, 93, 85, 
  90, 98, 80, 96, 83, 77, 89, 73, 90, 94, 
  95, 89, 83, 82, 83, 90, 78, 76, 78, 92, 
  92, 84, 84, 100, 96, 76, 88, 77, 96, 86, 
  79, 83, 91, 94, 102, 79, 77, 83, 76, 88, 
  86, 77, 92, 68, 78, 77, 82, 100, 73, 87, 
  105, 72, 97, 78, 84, 83, 72, 80, 104, 76, 
  90, 83, 81, 102, 96, 103, 78, 104, 94, 76, 
  87, 93, 74, 69, 79, 84, 78, 86, 77, 87, 
  81, 72, 79, 91, 91, 68, 79, 60, 97, 80, 
  78, 85, 75, 81, 87, 97, 84, 79, 72, 69, 
  81, 60, 71, 88, 92, 79, 82, 88, 83, 86, 
  78, 102, 88, 81, 83, 78, 72, 98, 86, 52, 
  84, 83, 100, 92, 78, 103, 84, 76, 86, 110, 
  80, 94, 91, 80, 102, 77, 89, 72, 90, 77, 
  94, 78, 81, 89, 81, 75, 78, 84, 86, 77, 
  93, 99, 92, 67, 91, 83, 82, 86, 91, 94, 
  89, 102, 78, 85, 72, 89, 77, 83, 83, 78, 
  84, 69, 75, 75, 76, 76, 76, 108, 92, 79, 
  94, 73, 86, 79, 72, 81, 104, 86, 93, 79, 
  81, 98, 84, 85, 74, 109, 89, 75, 86, 102, 
  61, 66, 82, 87, 73, 85, 80, 83, 76, 68, 
  67, 90, 85, 71, 70, 64, 88, 78, 73, 82, 
  75, 83, 92, 74, 78, 96, 79, 71, 82, 77, 
  79, 87, 89, 81, 76, 82, 78, 81, 85, 105, 
  81, 81, 84, 79, 73, 95, 91, 65, 75, 74, 
  94, 88, 78, 81, 88, 85, 87, 92, 80, 98, 
  86, 78, 93, 75, 88, 78, 91, 85, 82, 78, 
  82, 92, 75, 77, 76, 73, 91, 87, 85, 94, 
  87, 79, 86, 73, 94, 83, 87, 87, 85, 98, 
  77, 80, 96, 81, 85, 85, 84, 98, 91, 69, 
  80, 80, 80, 83, 78, 103, 84, 79, 96, 76, 
  83, 77, 73, 83, 93, 75, 90, 87, 85, 95, 
  92, 77, 81, 107, 89, 77, 87, 92, 78, 72, 
  86, 86, 77, 102, 88, 87, 113, 75, 82, 89, 
  98, 73, 80, 70, 97, 79, 81, 88, 75, 72, 
  81, 86, 82, 98, 64, 95, 91, 96, 67, 81, 
  57, 89, 67, 82, 80, 78, 80, 100, 71, 77, 
  97, 83, 78, 77, 101, 85, 101, 74, 82, 90, 
  78, 91, 109, 84, 92, 100, 77, 82, 82, 74, 
  39, 81, 77, 85, 95, 77, 96, 80, 77, 71, 
  76, 77, 93, 92, 103, 65, 91, 82, 75, 83, 
  84, 58, 65, 73, 71, 88, 85, 85, 108, 80, 
  99, 96, 86, 86, 71, 103, 80, 81, 84, 69, 
  86, 94, 77, 79, 85, 92, 73, 84, 99, 87, 
  75, 84, 120, 76, 77, 76, 76, 88, 81, 101, 
  91, 96, 90, 91, 100, 88, 73, 76, 80, 84, 
  83, 86, 81, 98, 70, 83, 91, 59, 77, 81, 
  84, 87, 94, 102, 80, 77, 87, 86, 69, 82, 
  84, 84, 78, 72, 94, 86, 72, 93, 117, 88, 
  79, 93, 77, 64, 87, 84, 60, 65, 86, 93, 
  96, 70, 105, 90, 107, 85, 100, 81, 61, 99, 
  83, 77, 79, 104, 93, 92, 88, 78, 110, 92, 
  81, 98, 80, 93, 78, 73, 79, 93, 83, 77, 
  81, 90, 64, 69, 79, 92, 92, 76, 81, 69, 
  58, 61, 69, 76, 84, 85, 105, 85, 72, 103, 
  73, 62, 78, 93, 89, 76, 88, 79, 98, 77, 
  78, 82, 93, 93, 77, 79, 67, 81, 79, 88, 
  79, 76, 87, 86, 110, 65, 82, 90, 87, 90, 
  92, 85, 88, 76, 81, 81, 80, 97, 70, 84, 
  85, 108, 69, 81, 82, 64, 86, 86, 76, 66, 
  83, 93, 82, 80, 81, 93, 61, 91, 84, 84, 
  93, 59, 87, 73, 81, 83, 89, 92, 92, 87, 
  75, 78, 81, 81, 81, 82, 86, 82, 93, 82, 
  91, 75, 70, 103, 100, 85, 81, 79, 92, 81, 
  92, 89, 81, 78, 86, 93, 98, 88, 90, 84, 
  76, 92, 66, 79, 85, 83, 92, 102, 83, 87, 
  73, 85, 86, 91, 84, 88, 74, 81, 78, 71, 
  94, 85, 62, 74, 70, 89, 82, 104, 76, 74, 
  82, 71, 83, 101, 92, 87, 93, 70, 94, 86, 
  85, 84, 88, 90, 68, 76, 80, 97, 72, 91, 
  92, 88, 105, 81, 78, 83, 92, 82, 86, 99, 
  62, 86, 82, 88, 80, 98, 83, 80, 101, 83, 
  75, 86, 76, 85, 94, 82, 82, 83, 80, 78, 
  96, 88, 65, 86, 76, 75, 91, 72, 67, 97, 
  90, 86, 77, 74, 59, 74, 64, 88, 84, 84, 
  83, 84, 89, 81, 77, 82, 84, 97, 68, 79, 
  88, 73, 88, 104, 86, 75, 68, 77, 80, 82, 
  79, 90, 69, 77, 16, 79, 92, 88, 99, 64, 
  105, 86, 88, 72, 84, 85, 80, 60, 118, 72, 
  92, 90, 79, 79, 93, 68, 52, 91, 78, 88, 
  89, 81, 60, 71, 95, 88, 91, 103, 77, 70, 
  81, 90, 86, 84, 82, 93, 86, 81, 73, 79, 
  83, 110, 118, 61, 71, 90, 113, 80, 74, 81, 
  69, 93, 82, 68, 85, 97, 94, 81, 90, 93, 
  82, 83, 80, 70, 99, 83, 75, 79, 79, 85, 
  91, 77, 82, 86, 82, 107, 98, 90, 82, 83, 
  75, 90, 77, 79, 73, 103, 59, 86, 82, 99, 
  67, 86, 67, 71, 69, 74, 76, 80, 74, 109, 
  68, 75, 78, 91, 76, 73, 108, 81, 124, 65, 
  73, 90, 65, 79, 94, 95, 77, 87, 80, 76, 
  79, 65, 79, 66, 82, 95, 73, 86, 85, 76, 
  77, 72, 87, 70, 104, 94, 95, 53, 80, 74, 
  91, 86, 80, 59, 55, 65, 50, 94, 74, 102, 
  142, 69, 86, 87, 84, 80, 72, 92, 79, 63, 
  78, 67, 82, 98, 60, 80, 91, 105, 49, 71, 
  98, 87, 68, 72, 127, 72, 84, 74, 71, 71, 
  84, 116, 89, 92, 90, 89, 106, 74, 72, 64, 
  77, 102, 80, 100, 70, 88, 60, 74, 73, 57, 
  77, 86, 67, 74, 83, 87, 69, 72, 78, 91, 
  64, 91, 87, 76, 80, 66, 90, 87, 80, 91, 
  118, 82, 81, 85, 75, 72, 83, 80, 81, 68, 
  86, 94, 91, 83, 106, 88, 88, 95, 103, 83, 
  66, 91, 79, 80, 84, 90, 87, 91, 84, 81, 
  113, 91, 81, 100, 66, 87, 77, 82, 86, 102, 
  96, 89, 82, 101, 66, 72, 84, 83, 83, 84, 
  70, 94, 71, 71, 84, 84, 72, 77, 69, 89, 
  79, 102, 71, 74, 76, 78, 80, 92, 91, 83, 
  100, 87, 83, 88, 90, 88, 78, 80, 67, 75, 
  86, 103, 66, 90, 92, 85, 99, 67, 81, 85, 
  82, 86, 86, 77, 65, 75, 73, 88, 87, 89, 
  73, 81, 86, 96, 83, 79, 75, 78, 90, 92, 
  83, 70, 85, 81, 87, 77, 79, 79, 88, 68, 
  99, 83, 98, 98, 85, 75, 73, 81, 74, 71, 
  81, 93, 77, 93, 67, 71, 91, 82, 84, 81, 
  91, 88, 63, 69, 71, 83, 81, 89, 100, 74, 
  67, 83, 78, 89, 99, 100, 70, 89, 70, 103, 
  91, 87, 95, 78, 108, 82, 94, 92, 75, 80, 
  67, 89, 103, 101, 89, 84, 72, 77, 92, 74, 
  74, 115, 85, 68, 91, 91, 79, 81, 84, 90, 
  83, 75, 87, 69, 88, 97, 103, 94, 81, 82, 
  99, 86, 78, 81, 104, 116, 73, 80, 79, 82, 
  98, 92, 72, 93, 77, 87, 94, 65, 70, 107, 
  88, 74, 87, 94, 87, 86, 91, 81, 79, 81, 
  82, 89, 88, 85, 101, 91, 71, 84, 76, 96, 
  81, 95, 77, 101, 75, 90, 104, 67, 71, 82, 
  73, 99, 87, 96, 76, 93, 55, 80, 67, 76, 
  77, 84, 81, 99, 73, 92, 84, 92, 89, 84, 
  86, 82, 88, 54, 79, 105, 81, 67, 75, 92, 
  77, 86, 66, 68, 80, 72, 65, 69, 82, 82, 
  84, 80, 88, 77, 103, 82, 97, 74, 94, 63, 
  119, 74, 98, 88, 95, 78, 94, 78, 68, 84, 
  66, 83, 77, 84, 92, 68, 96, 87, 91, 98, 
  72, 82, 73, 66, 89, 86, 81, 102, 81, 88, 
  78, 95, 79, 96, 107, 73, 75, 80, 119, 72, 
  80, 78, 57, 86, 90, 76, 86, 94, 93, 79, 
  110, 91, 78, 74, 80, 85, 83, 96, 82, 76, 
  81, 76, 92, 75, 74, 86, 77, 94, 82, 91, 
  82, 90, 80, 80, 77, 79, 87, 74, 78, 75, 
  82, 96, 78, 93, 123, 76, 63, 66, 70, 72, 
  86, 91, 85, 86, 83, 90, 86, 82, 97, 87, 
  80, 86, 93, 88, 72, 91, 88, 91, 92, 88, 
  90, 92, 87, 76, 101, 88, 79, 104, 65, 103, 
  83, 82, 89, 100, 96, 78, 89, 80, 79, 66, 
  92, 81, 94, 84, 83, 98, 69, 78, 70, 80, 
  80, 85, 104, 81, 89, 93, 73, 82, 77, 77, 
  80, 77, 91, 81, 93, 94, 80, 83, 88, 99, 
  72, 79, 89, 79, 86, 99, 83, 91, 88, 78, 
  73, 74, 82, 94, 84, 88, 80, 85, 80, 85, 
  71, 84, 87, 83, 70, 75, 84, 81, 91, 78, 
  82, 77, 90, 87, 83, 74, 85, 82, 84, 84, 
  70, 77, 81, 86, 62, 97, 86, 76, 91, 101, 
  80, 88, 89, 87, 73, 80, 77, 75, 87, 86, 
  78, 84, 85, 91, 87, 93, 83, 88, 98, 99, 
  76, 86, 73, 89, 75, 95, 94, 89, 81, 64, 
  97, 76, 84, 75, 75, 83, 81, 108, 75, 80, 
  73, 86, 94, 84, 92, 83, 90, 80, 79, 93, 
  89, 105, 85, 84, 94, 72, 76, 78, 77, 86, 
  86, 82, 82, 80, 84, 76, 91, 80, 88, 84, 
  86, 81, 92, 73, 73, 93, 81, 108, 84, 95, 
  79, 80, 77, 87, 104, 89, 80, 73, 100, 102, 
  93, 104, 89, 85, 85, 93, 90, 90, 83, 79, 
  74, 88, 77, 86, 77, 85, 73, 78, 83, 90, 
  79, 82, 103, 96, 71, 90, 83, 82, 69, 91, 
  72, 77, 48, 93, 91, 68, 82, 85, 80, 102, 
  112, 65, 81, 75, 80, 93, 80, 85, 89, 74, 
  91, 85, 91, 97, 80, 64, 102, 98, 88, 82, 
  90, 79, 98, 82, 88, 93, 71, 81, 85, 96, 
  90, 86, 66, 80, 71, 106, 55, 95, 69, 83, 
  99, 87, 80, 72, 79, 71, 81, 93, 90, 76, 
  72, 108, 85, 76, 96, 88, 59, 68, 79, 80, 
  76, 85, 87, 68, 88, 102, 74, 93, 92, 86, 
  101, 76, 87, 88, 82, 97, 82, 88, 53, 67, 
  75, 89, 75, 96, 81, 70, 74, 95, 76, 84, 
  76, 86, 73, 89, 87, 88, 74, 76, 93, 86, 
  69, 83, 82, 96, 73, 77, 89, 99, 83, 85, 
  89, 85, 65, 88, 87, 100, 73, 83, 93, 90, 
  65, 73, 85, 80, 91, 95, 73, 88, 84, 83, 
  69, 87, 81, 71, 82, 81, 80, 87, 95, 91, 
  93, 87, 90, 87, 90, 82, 83, 87, 76, 79, 
  90, 78, 87, 87, 81, 71, 87, 80, 73, 80, 
  74, 85, 92, 74, 85, 79, 69, 79, 85, 77, 
  85, 86, 76, 80, 80, 91, 88, 102, 93, 80, 
  86, 67, 86, 81, 83, 80, 78, 79, 74, 75, 
  90, 84, 95, 91, 84, 78, 82, 78, 103, 86, 
  75, 97, 79, 102, 85, 84, 74, 77, 80, 91, 
  113, 85, 75, 81, 78, 98, 90, 76, 91, 85, 
  85, 93, 87, 93, 83, 76, 89, 85, 80, 74, 
  84, 107, 98, 77, 90, 89, 77, 82, 90, 95, 
  69, 97, 80, 83, 89, 68, 87, 75, 63, 88, 
  82, 82, 86, 93, 77, 83, 80, 76, 69, 76, 
  76, 78, 83, 86, 83, 97, 95, 92, 79, 87, 
  83, 82, 100, 95, 74, 86, 74, 92, 69, 104, 
  84, 89, 82, 61, 100, 67, 80, 75, 87, 76, 
  74, 113, 78, 80, 75, 96, 79, 76, 93, 81, 
  89, 75, 79, 92, 80, 102, 80, 80, 83, 70, 
  84, 77, 73, 81, 85, 80, 91, 86, 86, 80, 
  86, 77, 78, 74, 79, 78, 80, 68, 73, 92, 
  83, 103, 78, 84, 73, 80, 77, 77, 101, 82, 
  83, 77, 84, 94, 90, 105, 90, 82, 94, 103, 
  92, 90, 74, 72, 80, 92, 75, 80, 79, 79, 
  81, 78, 72, 82, 88, 80, 100, 87, 70, 91, 
  70, 81, 91, 95, 81, 73, 47, 81, 96, 77, 
  81, 76, 78, 93, 138, 64, 87, 77, 86, 91, 
  78, 84, 91, 97, 73, 94, 82, 89, 78, 62, 
  101, 88, 97, 87, 94, 85, 89, 80, 72, 92, 
  80, 74, 80, 112, 97, 92, 77, 60, 67, 99, 
  50, 88, 72, 83, 94, 81, 76, 76, 74, 67, 
  75, 89, 79, 70, 65, 123, 57, 80, 93, 80, 
  63, 59, 72, 75, 71, 94, 84, 65, 83, 106, 
  62, 85, 93, 79, 107, 65, 92, 91, 75, 76, 
  91, 80, 54, 51, 69, 81, 60, 88, 83, 73, 
  75, 81, 51, 76, 70, 82, 79, 96, 87, 87, 
  77, 68, 109, 92, 69, 73, 81, 80, 72, 88, 
  98, 80, 75, 86, 90, 77, 63, 80, 77, 108, 
  83, 82, 87, 82, 76, 91, 74, 81, 91, 90, 
  71, 80, 73, 83, 63, 84, 83, 73, 84, 80, 
  77, 108, 79, 92, 80, 83, 88, 87, 93, 81, 
  63, 86, 74, 88, 89, 84, 79, 87, 72, 67, 
  101, 67, 81, 77, 89, 77, 78, 63, 88, 82, 
  72, 86, 70, 74, 89, 85, 81, 77, 84, 88, 
  79, 107, 87, 73, 86, 63, 89, 82, 78, 77, 
  88, 77, 84, 83, 89, 88, 87, 104, 79, 72, 
  75, 74, 95, 96, 72, 95, 79, 101, 73, 81, 
  73, 87, 82, 85, 120, 85, 80, 84, 68, 96, 
  99, 81, 92, 84, 94, 100, 88, 93, 74, 65, 
  83, 94, 78, 82, 77, 97, 108, 74, 75, 91, 
  62, 83, 80, 92, 70, 94, 71, 75, 99, 73, 
  96, 83, 69, 83, 87, 87, 97, 86, 79, 87, 
  92, 79, 76, 80, 82, 74, 86, 87, 78, 96, 
  94, 93, 85, 82, 83, 81, 89, 82, 91, 87, 
  78, 91, 74, 98, 75, 91, 78, 68, 88, 84, 
  85, 73, 84, 75, 86, 103, 76, 87, 74, 92, 
  84, 67, 95, 83, 85, 74, 82, 96, 80, 95, 
  86, 96, 85, 68, 89, 82, 73, 85, 91, 83, 
  105, 91, 88, 89, 88, 78, 84, 79, 76, 76, 
  87, 77, 80, 85, 83, 105, 85, 82, 76, 94, 
  77, 82, 90, 89, 85, 86, 81, 88, 87, 108, 
  93, 82, 98, 97, 97, 95, 79, 78, 97, 85, 
  84, 77, 88, 78, 71, 82, 83, 83, 97, 79, 
  98, 90, 76, 94, 74, 84, 86, 98, 93, 82, 
  55, 78, 90, 82, 97, 75, 76, 93, 135, 72, 
  88, 83, 89, 89, 75, 75, 87, 100, 81, 97, 
  76, 75, 73, 59, 90, 91, 80, 89, 88, 83, 
  86, 87, 76, 95, 84, 78, 87, 92, 84, 92, 
  70, 58, 76, 89, 46, 95, 72, 94, 94, 67, 
  82, 87, 70, 65, 79, 91, 77, 74, 75, 131, 
  84, 76, 92, 82, 71, 80, 100, 77, 91, 94, 
  83, 65, 86, 94, 72, 80, 87, 75, 97, 81, 
  88, 92, 77, 87, 90, 73, 55, 78, 72, 78, 
  61, 89, 75, 79, 87, 78, 71, 95, 72, 78, 
  82, 108, 86, 87, 66, 76, 104, 93, 69, 75, 
  88, 78, 84, 87, 104, 75, 75, 82, 94, 73, 
  66, 88, 78, 91, 96, 96, 67, 83, 77, 88, 
  87, 86, 96, 87, 70, 84, 93, 90, 72, 86, 
  88, 73, 88, 79, 86, 98, 82, 92, 78, 83, 
  85, 88, 81, 82, 81, 88, 81, 79, 83, 81, 
  75, 90, 92, 72, 89, 83, 72, 75, 85, 66, 
  78, 58, 86, 86, 75, 88, 78, 71, 93, 90, 
  80, 77, 79, 94, 84, 92, 94, 85, 81, 65, 
  91, 83, 77, 86, 92, 81, 90, 91, 90, 88, 
  82, 93, 74, 79, 74, 78, 96, 96, 81, 91, 
  75, 91, 78, 82, 75, 97, 80, 85, 100, 92, 
  82, 88, 89, 83, 90, 94, 92, 83, 99, 98, 
  92, 96, 87, 73, 84, 91, 85, 83, 72, 85, 
  106, 80, 85, 92, 65, 82, 84, 93, 71, 96, 
  72, 85, 88, 72, 95, 80, 78, 72, 79, 76, 
  86, 91, 97, 76, 86, 95, 80, 78, 78, 79, 
  79, 82, 76, 93, 77, 79, 99, 88, 96, 85, 
  87, 82, 80, 93, 84, 101, 81, 73, 81, 89, 
  80, 86, 94, 84, 99, 84, 95, 81, 88, 81, 
  86, 80, 97, 83, 82, 62, 71, 72, 86, 84, 
  89, 81, 68, 91, 92, 77, 84, 66, 84, 91, 
  95, 82, 91, 87, 96, 73, 96, 85, 92, 84, 
  76, 85, 74, 85, 93, 97, 83, 85, 92, 87, 
  78, 91, 86, 81, 82, 81, 76, 66, 82, 91, 
  83, 93, 91, 85, 87, 79, 82, 97, 78, 86, 
  84, 77, 79, 87, 99, 78, 94, 79, 91, 84, 
  89, 67, 90, 72, 85, 82, 90, 85, 81, 69, 
  89, 76, 83, 83, 92, 77, 76, 71, 81, 85, 
  89, 79, 93, 92, 78, 73, 80, 82, 76, 90, 
  87, 100, 77, 79, 98, 90, 92, 83, 88, 81, 
  79, 82, 66, 106, 79, 81, 82, 73, 90, 91, 
  95, 92, 83, 97, 101, 62, 81, 76, 84, 92, 
  99, 87, 81, 60, 63, 91, 79, 89, 96, 89, 
  66, 73, 92, 78, 83, 68, 89, 108, 97, 86, 
  84, 102, 89, 79, 105, 73, 88, 83, 82, 78, 
  77, 88, 92, 95, 86, 90, 85, 99, 85, 85, 
  78, 81, 76, 70, 69, 66, 76, 98, 83, 83, 
  92, 103, 94, 78, 67, 108, 84, 89, 81, 86, 
  83, 81, 107, 80, 90, 77, 76, 80, 78, 69, 
  86, 75, 80, 93, 85, 79, 75, 66, 87, 82, 
  83, 87, 80, 77, 73, 79, 89, 91, 96, 82, 
  88, 77, 79, 79, 82, 82, 81, 85, 96, 94, 
  80, 84, 89, 85, 93, 88, 86, 80, 83, 85, 
  74, 89, 75, 97, 84, 83, 91, 89, 94, 86, 
  67, 86, 95, 77, 87, 79, 86, 80, 97, 86, 
  82, 68, 71, 90, 85, 84, 88, 82, 72, 81, 
  88, 79, 77, 72, 81, 94, 99, 83, 86, 89, 
  97, 75, 96, 82, 93, 73, 84, 82, 74, 86, 
  92, 88, 84, 84, 78, 86, 79, 89, 87, 86, 
  81, 77, 73, 67, 80, 93, 87, 92, 89, 98, 
  89, 78, 83, 94, 77, 82, 82, 78, 78, 85, 
  101, 88, 76, 82, 87, 80, 84, 70, 92, 75, 
  87, 84, 89, 82, 88, 67, 91, 71, 89, 77, 
  92, 75, 88, 79, 74, 92, 98, 76, 89, 83, 
  82, 78, 79, 77, 75, 90, 80, 94, 71, 78, 
  101, 85, 76, 89, 90, 86, 91, 90, 73, 127, 
  74, 71, 73, 74, 87, 77, 96, 87, 123, 92, 
  106, 80, 80, 80, 80, 76, 89, 81, 80, 64, 
  65, 82, 87, 90, 88, 90, 75, 83, 91, 73, 
  76, 70, 79, 97, 82, 81, 90, 83, 85, 75, 
  88, 91, 82, 84, 77, 84, 77, 90, 84, 96, 
  83, 82, 88, 95, 74, 89, 72, 87, 84, 73, 
  71, 70, 78, 95, 69, 87, 78, 82, 87, 81, 
  85, 93, 79, 88, 81, 80, 80, 94, 111, 82, 
  88, 74, 84, 75, 84, 72, 78, 79, 77, 89, 
  86, 77, 87, 58, 91, 77, 74, 80, 101, 70, 
  90, 73, 69, 85, 93, 76, 90, 92, 76, 79, 
  80, 74, 68, 109, 100, 97, 74, 84, 97, 89, 
  70, 81, 91, 84, 88, 70, 60, 132, 93, 83, 
  77, 66, 92, 87, 121, 101, 100, 108, 123, 58, 
  80, 72, 86, 95, 85, 85, 79, 59, 54, 92, 
  84, 98, 95, 99, 67, 62, 97, 80, 73, 77, 
  83, 117, 83, 70, 78, 98, 77, 77, 98, 72, 
  73, 88, 83, 79, 82, 97, 81, 78, 87, 85, 
  85, 98, 79, 78, 67, 82, 76, 56, 64, 64, 
  69, 95, 74, 77, 86, 88, 88, 82, 73, 95, 
  85, 91, 69, 84, 87, 84, 113, 80, 90, 59, 
  71, 68, 70, 80, 82, 70, 70, 106, 76, 74, 
  74, 60, 90, 89, 84, 83, 92, 69, 88, 80, 
  75, 92, 98, 79, 92, 87, 79, 79, 82, 78, 
  76, 102, 118, 92, 87, 86, 88, 88, 77, 86, 
  89, 79, 91, 74, 68, 99, 76, 100, 75, 75, 
  95, 83, 101, 88, 74, 92, 111, 73, 76, 76, 
  80, 79, 86, 88, 78, 68, 66, 82, 85, 90, 
  84, 88, 75, 75, 91, 78, 74, 76, 81, 99, 
  85, 76, 85, 85, 86, 77, 91, 85, 87, 80, 
  80, 86, 77, 92, 86, 76, 86, 83, 81, 89, 
  73, 86, 71, 75, 82, 74, 71, 71, 77, 96, 
  85, 85, 77, 93, 85, 81, 81, 89, 80, 82, 
  77, 78, 90, 91, 110, 85, 81, 69, 92, 76, 
  79, 79, 94, 80, 77, 87, 83, 84, 88, 63, 
  84, 76, 78, 84, 71, 82, 88, 86, 85, 85, 
  102, 77, 88, 64, 77, 89, 78, 80, 92, 85, 
  78, 83, 75, 80, 84, 81, 88, 86, 84, 78, 
  81, 93, 90, 108, 80, 79, 84, 85, 81, 72, 
  98, 72, 109, 80, 95, 90, 84, 86, 71, 69, 
  90, 75, 78, 75, 77, 85, 88, 82, 81, 87, 
  78, 87, 85, 84, 77, 68, 75, 80, 76, 78, 
  82, 84, 89, 77, 89, 89, 88, 94, 92, 84, 
  76, 89, 88, 88, 79, 87, 89, 83, 81, 83, 
  75, 86, 85, 83, 78, 75, 86, 92, 72, 96, 
  82, 82, 88, 79, 96, 85, 81, 83, 83, 75, 
  94, 85, 100, 84, 85, 86, 77, 77, 82, 72, 
  81, 78, 84, 80, 85, 87, 92, 77, 81, 80, 
  77, 79, 75, 75, 90, 77, 81, 86, 100, 80, 
  86, 84, 74, 93, 77, 87, 90, 93, 96, 76, 
  84, 79, 82, 83, 87, 85, 90, 80, 77, 83, 
  81, 103, 85, 81, 82, 87, 81, 74, 119, 67, 
  100, 93, 103, 80, 77, 81, 69, 71, 92, 79, 
  74, 76, 70, 90, 91, 86, 83, 85, 70, 73, 
  98, 73, 75, 68, 80, 83, 76, 76, 80, 86, 
  85, 78, 91, 75, 81, 85, 90, 82, 79, 102, 
  80, 84, 85, 90, 88, 78, 90, 87, 70, 88, 
  90, 75, 73, 76, 76, 95, 73, 87, 83, 71, 
  79, 77, 98, 74, 81, 85, 80, 77, 101, 77, 
  101, 82, 88, 75, 75, 79, 77, 80, 94, 71, 
  76, 78, 79, 92, 93, 81, 84, 86, 82, 84, 
  73, 78, 89, 85, 83, 88, 102, 77, 90, 87, 
  74, 87, 77, 83, 95, 91, 101, 81, 91, 82, 
  77, 86, 90, 86, 82, 83, 84, 81, 88, 94, 
  79, 87, 83, 85, 82, 75, 103, 72, 76, 80, 
  100, 81, 76, 88, 73, 69, 88, 82, 78, 80, 
  76, 80, 88, 83, 79, 82, 77, 81, 89, 80, 
  79, 72, 79, 79, 78, 82, 76, 86, 90, 75, 
  92, 85, 88, 80, 84, 84, 76, 86, 86, 84, 
  84, 90, 85, 79, 79, 80, 74, 75, 87, 85, 
  77, 77, 85, 93, 84, 90, 82, 73, 89, 77, 
  96, 86, 84, 80, 83, 77, 105, 84, 100, 83, 
  88, 82, 90, 80, 83, 79, 93, 80, 81, 82, 
  81, 96, 91, 83, 84, 84, 88, 81, 83, 77, 
  74, 95, 93, 72, 86, 90, 110, 87, 58, 104, 
  75, 82, 83, 99, 70, 99, 98, 102, 66, 85, 
  102, 70, 85, 81, 83, 74, 109, 79, 86, 84, 
  86, 97, 82, 95, 83, 59, 87, 75, 79, 106, 
  81, 86, 87, 93, 84, 119, 88, 77, 113, 90, 
  85, 85, 98, 81, 78, 79, 85, 58, 66, 99, 
  82, 87, 77, 62, 94, 70, 109, 86, 68, 83, 
  85, 95, 71, 74, 107, 85, 95, 101, 69, 90, 
  85, 64, 115, 67, 96, 100, 71, 75, 94, 65, 
  67, 78, 93, 104, 71, 76, 81, 71, 84, 84, 
  82, 100, 77, 106, 80, 57, 90, 76, 81, 90, 
  79, 72, 87, 94, 63, 94, 100, 94, 116, 92, 
  78, 128, 89, 72, 86, 83, 84, 73, 70, 81, 
  85, 86, 82, 101, 83, 73, 64, 85, 76, 101, 
  89, 106, 70, 92, 117, 82, 78, 72, 105, 83, 
  91, 84, 94, 93, 111, 77, 80, 89, 69, 100, 
  107, 73, 84, 69, 76, 72, 87, 81, 75, 76, 
  84, 84, 85, 76, 80, 80, 88, 83, 95, 80, 
  85, 82, 84, 86, 93, 69, 55, 89, 112, 103, 
  78, 78, 88, 81, 93, 89, 74, 80, 88, 109, 
  67, 61, 85, 85, 87, 124, 81, 88, 80, 77, 
  75, 74, 96, 91, 88, 76, 86, 78, 81, 73, 
  85, 82, 75, 71, 83, 81, 83, 83, 83, 90, 
  73, 107, 74, 81, 95, 80, 73, 86, 83, 78, 
  88, 80, 74, 86, 89, 87, 78, 89, 83, 92, 
  90, 74, 99, 84, 83, 87, 69, 75, 84, 86, 
  79, 92, 86, 76, 71, 84, 76, 96, 84, 90, 
  88, 83, 89, 75, 86, 73, 88, 83, 83, 87, 
  95, 94, 91, 73, 78, 93, 73, 90, 105, 74, 
  85, 74, 71, 74, 91, 76, 79, 88, 87, 81, 
  80, 73, 80, 85, 77, 91, 84, 78, 76, 90, 
  87, 94, 95, 71, 70, 82, 89, 105, 81, 85, 
  85, 87, 84, 86, 86, 76, 92, 89, 78, 71, 
  70, 80, 79, 109, 93, 79, 91, 84, 71, 79, 
  84, 102, 94, 79, 83, 89, 88, 88, 82, 69, 
  84, 86, 89, 84, 84, 93, 82, 77, 70, 92, 
  82, 111, 86, 80, 76, 83, 80, 81, 86, 75, 
  83, 78, 76, 84, 66, 89, 78, 72, 84, 72, 
  84, 83, 84, 68, 68, 89, 79, 79, 87, 88, 
  93, 79, 59, 81, 82, 102, 85, 107, 68, 85, 
  110, 86, 77, 67, 101, 76, 94, 83, 87, 81, 
  106, 81, 77, 82, 80, 97, 95, 75, 89, 71, 
  79, 74, 83, 90, 77, 79, 83, 83, 71, 88, 
  82, 75, 87, 85, 95, 77, 88, 80, 83, 86, 
  105, 65, 56, 82, 107, 112, 81, 100, 79, 71, 
  96, 98, 70, 88, 85, 105, 72, 77, 88, 71, 
  89, 115, 74, 84, 88, 79, 69, 79, 91, 103, 
  84, 75, 91, 81, 84, 75, 86, 87, 87, 85, 
  87, 83, 70, 86, 86, 87, 64, 96, 70, 99, 
  92, 79, 90, 86, 84, 79, 85, 83, 76, 84, 
  83, 81, 84, 86, 83, 89, 86, 75, 87, 82, 
  89, 77, 82, 76, 72, 91, 79, 97, 74, 66, 
  86, 78, 89, 101, 83, 98, 90, 78, 100, 72, 
  93, 78, 78, 83, 95, 88, 101, 92, 78, 78, 
  69, 79, 60, 90, 119, 70, 86, 75, 65, 92, 
  96, 77, 75, 71, 83, 68, 81, 68, 74, 91, 
  71, 76, 85, 84, 70, 88, 81, 82, 101, 73, 
  60, 75, 92, 103, 88, 90, 75, 81, 70, 84, 
  84, 72, 91, 98, 68, 84, 81, 86, 77, 95, 
  98, 84, 81, 95, 61, 71, 73, 70, 78, 84, 
  70, 101, 90, 90, 80, 67, 67, 69, 90, 90, 
  80, 89, 76, 72, 66, 77, 85, 111, 85, 77, 
  81, 70, 77, 78, 81, 78, 86, 70, 67, 72, 
  66, 88, 84, 56, 94, 76, 88, 82, 91, 80, 
  80, 77, 79, 90, 86, 86, 91, 80, 91, 84, 
  86, 81, 83, 73, 96, 79, 66, 76, 89, 72, 
  80, 84, 92, 93, 93, 82, 78, 79, 81, 79, 
  64, 75, 98, 79, 83, 86, 76, 83, 88, 78, 
  86, 82, 87, 72, 82, 76, 79, 97, 62, 87, 
  75, 88, 76, 86, 85, 91, 91, 79, 78, 82, 
  77, 73, 92, 79, 82, 87, 73, 85, 89, 75, 
  90, 89, 86, 95, 73, 82, 82, 79, 92, 78, 
  87, 95, 70, 80, 78, 88, 87, 83, 72, 87, 
  87, 104, 81, 82, 83, 88, 91, 89, 85, 91, 
  82, 72, 82, 81, 91, 101, 80, 76, 79, 77, 
  82, 77, 85, 88, 98, 72, 79, 76, 68, 89, 
  77, 70, 95, 79, 88, 75, 86, 73, 79, 84, 
  79, 84, 89, 83, 92, 86, 71, 74, 89, 100, 
  86, 95, 72, 81, 98, 83, 94, 75, 87, 88, 
  86, 85, 90, 90, 91, 92, 72, 76, 78, 85, 
  99, 79, 88, 79, 81, 77, 83, 87, 84, 81, 
  80, 81, 78, 82, 75, 83, 86, 86, 92, 87, 
  88, 84, 80, 74, 99, 81, 65, 87, 93, 83, 
  88, 83, 83, 82, 80, 88, 76, 82, 86, 104, 
  71, 87, 80, 76, 80, 107, 82, 86, 89, 83, 
  73, 81, 84, 81, 93, 85, 84, 88, 94, 86, 
  85, 78, 83, 79, 87, 86, 84, 86, 89, 81, 
  75, 83, 73, 91, 84, 81, 91, 86, 72, 81, 
  88, 78, 87, 73, 77, 73, 78, 94, 81, 82, 
  89, 81, 84, 72, 84, 76, 82, 77, 71, 89, 
  86, 94, 81, 81, 92, 80, 90, 93, 78, 83, 
  93, 77, 93, 79, 98, 77, 78, 90, 92, 92, 
  93, 86, 77, 91, 76, 75, 76, 82, 97, 78, 
  92, 81, 76, 83, 84, 82, 85, 76, 83, 76, 
  89, 73, 75, 93, 70, 78, 79, 94, 81, 86, 
  82, 81, 93, 78, 84, 83, 87, 73, 98, 74, 
  84, 92, 74, 81, 84, 77, 86, 91, 68, 92, 
  80, 89, 79, 92, 86, 89, 81, 97, 74, 69, 
  78, 76, 88, 90, 75, 91, 89, 93, 74, 78, 
  79, 74, 87, 88, 82, 86, 91, 74, 80, 80, 
  86, 83, 79, 81, 81, 75, 74, 81, 86, 85, 
  98, 73, 79, 72, 68, 92, 74, 71, 80, 79, 
  84, 79, 82, 74, 76, 79, 73, 97, 87, 95, 
  100, 82, 91, 78, 79, 88, 81, 73, 92, 82, 
  87, 87, 98, 76, 85, 91, 86, 92, 84, 84, 
  81, 96, 79, 82, 84, 81, 93, 85, 87, 84, 
  85, 79, 79, 80, 84, 88, 82, 80, 83, 94, 
  82, 94, 73, 82, 76, 88, 91, 85, 86, 88, 
  91, 78, 92, 90, 91, 74, 97, 84, 91, 93, 
  83, 82, 91, 78, 86, 85, 75, 88, 77, 84, 
  84, 98, 81, 75, 84, 91, 84, 77, 86, 83, 
  96, 89, 81, 76, 83, 89, 76, 93, 86, 89, 
  95, 84, 79, 87, 89, 80, 79, 78, 82, 77, 
  79, 85, 79, 76, 96, 86, 89, 90, 94, 80, 
  91, 73, 81, 87, 77, 84, 80, 98, 87, 75, 
  95, 89, 91, 104, 89, 69, 72, 84, 88, 92, 
  75, 88, 88, 83, 97, 72, 82, 82, 73, 75, 
  82, 87, 82, 82, 73, 65, 78, 85, 101, 97, 
  70, 85, 76, 89, 53, 107, 89, 62, 82, 86, 
  91, 104, 74, 92, 101, 87, 89, 91, 67, 83, 
  67, 93, 92, 95, 85, 66, 75, 74, 77, 77, 
  71, 115, 92, 79, 95, 76, 97, 66, 87, 88, 
  74, 91, 75, 73, 93, 102, 82, 102, 91, 79, 
  94, 83, 82, 74, 88, 96, 79, 93, 85, 90, 
  91, 88, 57, 80, 86, 107, 90, 75, 76, 101, 
  91, 86, 92, 86, 80, 97, 98, 71, 94, 76, 
  83, 109, 81, 82, 93, 93, 70, 84, 91, 86, 
  91, 89, 81, 90, 63, 92, 82, 94, 72, 99, 
  78, 117, 89, 92, 85, 81, 60, 73, 65, 87, 
  82, 73, 109, 106, 81, 77, 95, 84, 71, 93, 
  91, 93, 90, 69, 61, 96, 85, 90, 72, 106, 
  62, 111, 70, 78, 89, 51, 77, 70, 89, 89, 
  57, 84, 91, 70, 102, 70, 78, 83, 81, 87, 
  112, 89, 78, 84, 84, 78, 82, 71, 71, 86, 
  79, 88, 82, 73, 95, 71, 107, 74, 78, 109, 
  63, 79, 63, 87, 82, 98, 77, 93, 83, 96, 
  79, 84, 73, 82, 112, 80, 68, 87, 109, 79, 
  64, 71, 80, 89, 70, 49, 98, 99, 76, 86, 
  103, 77, 65, 77, 80, 69, 104, 90, 64, 88, 
  92, 81, 85, 71, 74, 80, 89, 103, 93, 78, 
  79, 73, 79, 72, 95, 79, 74, 94, 80, 88, 
  91, 91, 75, 89, 126, 86, 60, 79, 75, 78, 
  93, 87, 90, 78, 79, 93, 78, 80, 102, 91, 
  77, 101, 84, 95, 83, 93, 80, 82, 70, 99, 
  82, 81, 92, 66, 82, 85, 86, 87, 74, 99, 
  70, 92, 79, 96, 80, 76, 90, 83, 86, 84, 
  91, 78, 109, 66, 76, 102, 62, 79, 95, 82, 
  74, 112, 82, 88, 89, 77, 67, 81, 74, 77, 
  71, 69, 84, 99, 79, 84, 80, 81, 87, 93, 
  72, 83, 94, 86, 82, 90, 92, 79, 81, 81, 
  92, 76, 83, 70, 80, 99, 87, 89, 73, 80, 
  67, 85, 93, 81, 73, 79, 81, 109, 89, 83, 
  87, 83, 88, 89, 88, 77, 93, 81, 79, 85, 
  83, 90, 66, 93, 89, 74, 73, 109, 89, 89, 
  83, 77, 75, 72, 57, 88, 83, 78, 101, 103, 
  58, 80, 77, 85, 74, 87, 100, 89, 97, 74, 
  68, 87, 75, 77, 72, 90, 93, 92, 76, 84, 
  85, 63, 82, 69, 95, 89, 77, 75, 91, 72, 
  83, 67, 81, 74, 88, 107, 100, 71, 85, 74, 
  92, 74, 82, 56, 49, 86, 79, 94, 82, 97, 
  101, 72, 95, 79, 86, 102, 72, 70, 91, 70, 
  85, 81, 77, 91, 81, 84, 84, 81, 75, 91, 
  87, 86, 71, 89, 107, 69, 73, 75, 93, 81, 
  84, 72, 93, 96, 95, 82, 84, 80, 75, 75, 
  83, 70, 86, 88, 90, 101, 79, 81, 79, 86, 
  83, 84, 82, 98, 87, 78, 79, 75, 86, 72, 
  123, 95, 69, 91, 55, 98, 80, 102, 80, 75, 
  65, 80, 55, 80, 81, 73, 96, 111, 70, 83, 
  98, 81, 71, 72, 113, 93, 118, 77, 62, 93, 
  62, 74, 66, 98, 90, 81, 68, 63, 96, 56, 
  67, 56, 90, 66, 84, 86, 78, 64, 81, 68, 
  80, 65, 97, 78, 100, 61, 76, 80, 106, 79, 
  72, 59, 62, 63, 60, 86, 74, 117, 61, 79, 
  93, 78, 86, 87, 76, 73, 81, 54, 84, 72, 
  72, 106, 73, 98, 83, 101, 55, 73, 87, 78, 
  63, 76, 113, 59, 80, 77, 69, 54, 86, 53, 
  107, 93, 89, 89, 94, 72, 63, 58, 91, 73, 
  70, 86, 92, 81, 99, 69, 58, 81, 82, 84, 
  70, 89, 78, 85, 72, 62, 84, 65, 101, 77, 
  84, 77, 82, 70, 87, 79, 77, 80, 134, 79, 
  69, 81, 84, 71, 85, 90, 94, 69, 70, 99, 
  92, 82, 100, 89, 94, 97, 106, 90, 69, 82, 
  105, 86, 80, 82, 79, 90, 86, 85, 87, 91, 
  81, 88, 106, 104, 67, 87, 80, 94, 90, 73, 
  87, 73, 78, 79, 96, 78, 101, 79, 75, 88, 
  57, 69, 80, 87, 74, 84, 69, 86, 75, 76, 
  85, 63, 79, 73, 95, 69, 91, 91, 91, 88, 
  85, 69, 89, 79, 91, 91, 77, 72, 84, 100, 
  80, 85, 92, 93, 78, 66, 82, 88, 79, 91, 
  106, 67, 72, 88, 77, 82, 106, 80, 58, 78, 
  105, 98, 62, 80, 82, 82, 83, 92, 75, 70, 
  97, 81, 93, 89, 74, 95, 78, 74, 110, 82, 
  75, 76, 93, 78, 84, 78, 86, 88, 57, 76, 
  83, 84, 74, 100, 65, 79, 87, 89, 96, 93, 
  88, 82, 79, 83, 104, 94, 78, 66, 84, 82, 
  106, 87, 86, 80, 82, 81, 85, 85, 86, 80, 
  105, 79, 83, 78, 83, 83, 89, 81, 101, 100, 
  84, 68, 85, 73, 96, 86, 79, 75, 66, 75, 
  87, 88, 86, 79, 76, 88, 85, 95, 100, 85, 
  85, 79, 82, 66, 101, 79, 84, 85, 86, 85, 
  82, 83, 83, 79, 72, 79, 83, 98, 95, 79, 
  98, 90, 111, 71, 82, 71, 80, 94, 89, 66, 
  85, 92, 104, 72, 73, 77, 64, 81, 95, 92, 
  82, 92, 92, 92, 100, 87, 78, 85, 75, 89, 
  83, 83, 81, 80, 98, 72, 100, 84, 85, 64, 
  85, 68, 81, 83, 106, 75, 74, 70, 86, 77, 
  80, 85, 90, 81, 80, 91, 101, 89, 84, 85, 
  93, 77, 122, 94, 78, 79, 89, 80, 93, 86, 
  87, 80, 82, 81, 80, 90, 74, 85, 115, 93, 
  69, 74, 84, 90, 95, 79, 89, 90, 78, 71, 
  87, 78, 102, 91, 79, 83, 74, 66, 95, 88, 
  87, 62, 60, 82, 80, 92, 96, 65, 85, 69, 
  91, 64, 101, 85, 88, 83, 87, 73, 77, 85, 
  81, 77, 68, 75, 88, 106, 82, 84, 102, 101, 
  91, 68, 76, 61, 76, 89, 91, 74, 92, 95, 
  97, 79, 91, 86, 62, 76, 88, 83, 75, 91, 
  87, 88, 90, 86, 80, 74, 78, 97, 85, 92, 
  75, 82, 84, 92, 90, 84, 89, 66, 82, 71, 
  81, 84, 104, 79, 75, 74, 90, 78, 70, 92, 
  92, 89, 97, 92, 91, 81, 78, 78, 75, 84, 
  104, 85, 94, 81, 103, 81, 78, 95, 104, 75, 
  81, 85, 88, 93, 81, 81, 96, 104, 74, 88, 
  91, 94, 98, 95, 84, 84, 76, 80, 98, 77, 
  89, 98, 78, 80, 83, 77, 100, 89, 84, 70, 
  67, 83, 78, 86, 87, 61, 82, 83, 85, 83, 
  98, 101, 92, 79, 80, 67, 82, 84, 82, 85, 
  82, 67, 94, 96, 71, 92, 97, 88, 77, 95, 
  71, 80, 79, 84, 80, 60, 76, 93, 85, 81, 
  86, 88, 74, 87, 103, 96, 86, 101, 80, 90, 
  74, 78, 73, 77, 82, 87, 90, 99, 83, 76, 
  85, 83, 82, 94, 93, 71, 88, 72, 83, 81, 
  101, 84, 89, 74, 79, 92, 73, 79, 74, 89, 
  66, 93, 97, 79, 82, 76, 102, 100, 102, 89, 
  73, 87, 85, 79, 92, 72, 115, 86, 73, 118, 
  89, 77, 72, 74, 99, 90, 72, 76, 91, 79, 
  85, 76, 71, 95, 92, 94, 103, 88, 80, 87, 
  83, 113, 68, 81, 66, 75, 100, 95, 106, 103, 
  76, 89, 86, 76, 86, 63, 85, 78, 81, 87, 
  84, 88, 92, 64, 81, 85, 89, 74, 82, 79, 
  87, 72, 86, 84, 75, 91, 87, 56, 84, 84, 
  85, 84, 89, 102, 69, 92, 85, 89, 72, 97, 
  85, 74, 79, 77, 73, 81, 100, 81, 90, 80, 
  73, 64, 90, 82, 93, 75, 73, 87, 85, 72, 
  91, 69, 97, 65, 78, 76, 82, 88, 107, 107, 
  98, 65, 81, 78, 63, 73, 79, 107, 74, 106, 
  83, 85, 81, 72, 97, 88, 115, 95, 69, 81, 
  97, 80, 93, 68, 86, 100, 59, 155, 84, 85, 
  67, 70, 92, 78, 73, 80, 75, 97, 93, 75, 
  70, 77, 88, 87, 111, 80, 83, 85, 78, 125, 
  59, 83, 64, 70, 113, 75, 90, 111, 71, 77, 
  96, 69, 91, 83, 91, 83, 82, 85, 89, 68, 
  100, 59, 70, 80, 91, 76, 82, 66, 92, 79, 
  78, 90, 70, 93, 101, 63, 77, 83, 84, 86, 
  88, 100, 59, 90, 91, 91, 95, 96, 82, 75, 
  86, 75, 75, 82, 100, 86, 85, 83, 80, 59, 
  97, 70, 94, 82, 94, 83, 87, 86, 84, 79, 
  83, 81, 86, 80, 80, 71, 72, 105, 78, 75, 
  79, 91, 84, 82, 95, 88, 91, 82, 77, 78, 
  87, 90, 87, 77, 94, 87, 83, 71, 90, 92, 
  90, 77, 72, 81, 85, 99, 77, 70, 81, 84, 
  90, 73, 74, 72, 96, 78, 80, 83, 77, 75, 
  89, 82, 96, 99, 84, 78, 94, 79, 73, 71, 
  64, 86, 97, 87, 77, 88, 84, 89, 96, 86, 
  78, 96, 96, 75, 83, 81, 84, 76, 82, 68, 
  84, 83, 89, 80, 92, 83, 96, 76, 100, 88, 
  90, 87, 84, 69, 91, 105, 81, 83, 88, 97, 
  74, 90, 87, 86, 93, 90, 87, 90, 85, 74, 
  97, 90, 90, 81, 96, 71, 77, 71, 92, 82, 
  103, 83, 74, 78, 84, 84, 78, 96, 91, 83, 
  92, 74, 90, 75, 93, 100, 93, 77, 79, 81, 
  75, 68, 80, 96, 60, 99, 86, 79, 93, 80, 
  94, 78, 104, 84, 74, 99, 96, 75, 75, 79, 
  70, 80, 98, 117, 103, 75, 80, 84, 97, 89, 
  82, 79, 100, 90, 81, 76, 80, 90, 78, 94, 
  96, 87, 90, 90, 89, 106, 84, 74, 76, 73, 
  93, 85, 91, 107, 74, 104, 81, 71, 92, 74, 
  78, 83, 94, 88, 86, 71, 84, 84, 80, 81, 
  92, 66, 88, 98, 95, 80, 72, 83, 73, 94, 
  73, 71, 93, 100, 78, 89, 86, 78, 73, 88, 
  81, 79, 87, 84, 76, 76, 89, 91, 65, 85, 
  105, 89, 78, 80, 79, 65, 81, 74, 83, 78, 
  62, 81, 80, 79, 82, 70, 90, 78, 88, 71, 
  90, 76, 103, 88, 98, 85, 77, 76, 66, 69, 
  95, 88, 85, 103, 73, 75, 85, 74, 90, 81, 
  93, 89, 70, 85, 85, 73, 70, 83, 98, 85, 
  108, 125, 89, 85, 85, 77, 85, 76, 81, 90, 
  91, 106, 78, 73, 78, 95, 67, 90, 104, 81, 
  95, 85, 83, 102, 71, 80, 80, 68, 86, 80, 
  89, 112, 70, 110, 78, 65, 100, 83, 70, 90, 
  96, 81, 82, 70, 82, 95, 72, 76, 91, 58, 
  82, 83, 97, 81, 63, 93, 69, 96, 86, 75, 
  87, 99, 73, 94, 75, 70, 65, 86, 75, 79, 
  92, 87, 72, 71, 91, 86, 91, 83, 112, 97, 
  69, 86, 71, 59, 83, 69, 78, 80, 80, 84, 
  83, 85, 82, 80, 82, 81, 88, 77, 85, 73, 
  87, 88, 87, 77, 82, 84, 88, 81, 91, 82, 
  94, 92, 79, 80, 92, 91, 84, 93, 91, 86, 
  83, 78, 87, 92, 78, 79, 100, 77, 93, 97, 
  77, 71, 87, 84, 91, 84, 78, 76, 104, 72, 
  77, 82, 79, 93, 84, 88, 96, 100, 90, 75, 
  93, 83, 76, 72, 67, 88, 95, 84, 82, 96, 
  77, 96, 94, 75, 85, 84, 74, 80, 90, 83, 
  88, 77, 84, 87, 80, 76, 85, 76, 97, 74, 
  90, 81, 76, 74, 84, 91, 98, 73, 96, 103, 
  85, 89, 87, 87, 80, 85, 86, 80, 88, 83, 
  85, 78, 84, 87, 103, 87, 84, 88, 80, 84, 
  85, 74, 83, 76, 89, 82, 87, 79, 84, 90, 
  82, 82, 81, 86, 80, 85, 81, 93, 89, 92, 
  78, 73, 73, 89, 90, 85, 102, 97, 91, 76, 
  84, 83, 96, 99, 94, 71, 82, 83, 95, 86, 
  82, 84, 82, 80, 72, 81, 98, 89, 83, 73, 
  85, 100, 68, 86, 85, 84, 78, 73, 79, 84, 
  80, 76, 89, 69, 82, 85, 93, 73, 83, 86, 
  81, 74, 62, 99, 86, 84, 77, 86, 83, 92, 
  88, 85, 83, 80, 82, 79, 91, 78, 87, 80, 
  82, 89, 94, 87, 74, 74, 90, 80, 92, 85, 
  91, 68, 87, 86, 77, 71, 93, 76, 92, 87, 
  98, 89, 87, 87, 89, 73, 81, 75, 87, 83, 
  78, 75, 81, 88, 84, 81, 80, 76, 80, 76, 
  77, 79, 93, 72, 86, 81, 72, 89, 87, 87, 
  68, 82, 82, 85, 82, 92, 94, 80, 80, 71, 
  72, 86, 92, 84, 90, 97, 90, 73, 78, 79, 
  101, 98, 87, 77, 70, 92, 96, 81, 81, 89, 
  85, 76, 81, 83, 97, 81, 95, 76, 84, 103, 
  69, 69, 77, 94, 80, 81, 80, 84, 88, 76, 
  81, 67, 80, 92, 101, 78, 76, 83, 80, 74, 
  60, 103, 85, 91, 86, 87, 83, 89, 84, 78, 
  83, 80, 82, 82, 89, 74, 88, 82, 73, 92, 
  88, 85, 67, 81, 93, 81, 82, 86, 88, 72, 
  87, 89, 70, 75, 94, 84, 85, 90, 100, 88, 
  88, 86, 97, 72, 76, 83, 80, 80, 81, 63, 
  98, 80, 84, 84, 79, 82, 74, 71, 82, 77, 
  95, 75, 81, 85, 73, 89, 84, 86, 76, 83, 
  79, 86, 82, 83, 98, 85, 85, 80, 76, 88, 
  89, 88, 80, 84, 83, 80, 84, 84, 90, 104, 
  86, 85, 82, 89, 93, 77, 80, 94, 77, 77, 
  104, 77, 102, 94, 96, 76, 86, 93, 70, 75, 
  80, 80, 81, 72, 79, 89, 86, 90, 91, 74, 
  84, 83, 87, 74, 81, 84, 78, 72, 61, 93, 
  91, 86, 84, 85, 82, 88, 90, 78, 79, 81, 
  83, 79, 84, 76, 86, 85, 85, 88, 93, 75, 
  78, 80, 86, 86, 94, 85, 78, 66, 92, 86, 
  82, 78, 97, 85, 87, 86, 96, 87, 87, 84, 
  86, 73, 77, 79, 89, 85, 78, 80, 88, 91, 
  88, 86, 80, 82, 83, 80, 77, 77, 92, 75, 
  71, 77, 81, 80, 94, 85, 83, 79, 77, 89, 
  82, 82, 126, 84, 83, 82, 83, 97, 86, 77, 
  90, 98, 88, 78, 99, 79, 89, 98, 105, 101, 
  79, 79, 56, 73, 75, 79, 89, 73, 97, 87, 
  81, 72, 98, 78, 78, 61, 83, 99, 76, 97, 
  78, 101, 83, 89, 75, 82, 66, 78, 82, 80, 
  88, 67, 82, 121, 92, 76, 80, 72, 69, 99, 
  92, 87, 82, 78, 82, 66, 95, 73, 96, 86, 
  82, 66, 87, 76, 90, 82, 92, 78, 71, 78, 
  58, 76, 71, 84, 84, 76, 85, 79, 91, 84, 
  102, 73, 94, 79, 72, 66, 70, 93, 89, 78, 
  87, 99, 84, 86, 86, 80, 67, 77, 87, 100, 
  100, 99, 76, 98, 77, 77, 86, 86, 72, 73, 
  79, 79, 93, 76, 81, 76, 80, 93, 82, 88, 
  106, 104, 78, 80, 85, 83, 85, 79, 78, 94, 
  72, 85, 97, 82, 83, 97, 92, 76, 93, 88, 
  65, 72, 86, 87, 88, 79, 61, 98, 85, 94, 
  102, 92, 84, 82, 90, 76, 73, 97, 80, 104, 
  81, 84, 82, 59, 69, 80, 86, 79, 84, 79, 
  92, 111, 74, 78, 70, 87, 76, 74, 88, 79, 
  80, 78, 94, 78, 95, 104, 92, 81, 88, 77, 
  94, 72, 88, 76, 82, 73, 82, 82, 60, 85, 
  75, 85, 85, 78, 90, 89, 71, 89, 95, 96, 
  94, 80, 77, 73, 63, 91, 93, 80, 106, 100, 
  81, 80, 96, 86, 74, 85, 90, 86, 76, 86, 
  79, 91, 85, 73, 79, 86, 75, 59, 97, 82, 
  80, 84, 76, 76, 87, 85, 78, 86, 68, 100, 
  77, 88, 92, 79, 80, 93, 81, 65, 80, 84, 
  89, 85, 80, 82, 93, 84, 80, 78, 80, 81, 
  78, 90, 82, 85, 74, 77, 73, 73, 84, 85, 
  83, 103, 97, 90, 80, 80, 85, 72, 80, 84, 
  83, 83, 96, 97, 99, 89, 76, 91, 101, 75, 
  80, 77, 75, 95, 88, 70, 68, 62, 92, 74, 
  90, 99, 83, 85, 82, 80, 94, 91, 86, 79, 
  79, 81, 97, 79, 86, 86, 86, 90, 93, 91, 
  97, 77, 75, 88, 80, 86, 98, 84, 87, 80, 
  98, 81, 86, 85, 81, 82, 87, 78, 71, 79, 
  89, 79, 89, 82, 74, 79, 85, 82, 84, 82, 
  82, 83, 74, 76, 108, 88, 95, 92, 88, 92, 
  84, 81, 76, 83, 84, 81, 118, 101, 97, 77, 
  84, 73, 96, 66, 81, 97, 76, 91, 97, 79, 
  90, 100, 97, 87, 102, 70, 64, 86, 90, 69, 
  75, 81, 91, 82, 78, 105, 85, 80, 63, 51, 
  95, 123, 85, 89, 85, 117, 90, 84, 76, 102, 
  65, 88, 68, 81, 86, 62, 77, 134, 84, 68, 
  80, 66, 93, 74, 82, 115, 59, 94, 76, 70, 
  99, 63, 81, 98, 96, 72, 114, 66, 101, 87, 
  83, 71, 94, 61, 62, 70, 72, 88, 64, 75, 
  98, 88, 100, 92, 79, 75, 94, 76, 81, 85, 
  79, 87, 100, 85, 95, 80, 89, 71, 100, 85, 
  57, 90, 99, 83, 96, 85, 92, 118, 83, 73, 
  86, 94, 78, 79, 86, 83, 85, 77, 83, 77, 
  74, 88, 80, 91, 97, 74, 80, 79, 89, 80, 
  95, 78, 69, 70, 82, 85, 104, 82, 86, 99, 
  83, 84, 80, 88, 69, 64, 73, 87, 79, 80, 
  90, 93, 85, 82, 92, 96, 77, 80, 89, 75, 
  79, 89, 89, 99, 81, 78, 84, 95, 63, 80, 
  77, 85, 80, 72, 84, 86, 86, 61, 77, 77, 
  89, 76, 95, 103, 69, 86, 85, 78, 96, 116, 
  84, 87, 91, 81, 109, 83, 86, 85, 75, 69, 
  83, 76, 67, 66, 76, 91, 63, 78, 94, 96, 
  85, 95, 86, 86, 87, 82, 78, 78, 67, 84, 
  96, 78, 89, 86, 87, 83, 85, 83, 94, 87, 
  88, 80, 62, 78, 75, 99, 86, 75, 81, 79, 
  70, 59, 75, 77, 80, 100, 79, 77, 80, 86, 
  74, 94, 60, 85, 69, 86, 86, 94, 86, 99, 
  87, 59, 78, 80, 87, 88, 79, 83, 81, 85, 
  71, 78, 76, 85, 69, 90, 83, 88, 67, 72, 
  86, 63, 87, 83, 90, 104, 92, 87, 83, 75, 
  92, 63, 78, 83, 88, 78, 97, 88, 103, 88, 
  76, 88, 106, 69, 97, 75, 73, 102, 83, 82, 
  75, 69, 95, 68, 82, 106, 82, 94, 78, 77, 
  86, 89, 80, 86, 73, 76, 105, 78, 77, 89, 
  78, 83, 89, 90, 93, 83, 73, 95, 87, 91, 
  99, 86, 78, 82, 95, 80, 86, 79, 70, 80, 
  79, 75, 73, 94, 83, 84, 85, 84, 77, 85, 
  83, 81, 79, 81, 77, 87, 76, 72, 92, 79, 
  93, 90, 97, 91, 83, 75, 65, 83, 81, 87, 
  88, 80, 83, 80, 83, 80, 90, 80, 86, 100, 
  77, 88, 84, 84, 81, 92, 96, 77, 79, 80, 
  67, 90, 83, 84, 82, 80, 60, 87, 88, 77, 
  76, 71, 81, 83, 75, 120, 84, 91, 76, 83, 
  86, 77, 76, 76, 76, 74, 76, 78, 93, 106, 
  94, 112, 91, 66, 88, 88, 87, 91, 77, 80, 
  86, 91, 65, 78, 95, 73, 88, 93, 87, 66, 
  98, 87, 97, 85, 86, 76, 62, 71, 64, 76, 
  73, 94, 76, 89, 86, 91, 85, 102, 75, 85, 
  91, 77, 96, 84, 82, 85, 75, 75, 80, 90, 
  77, 87, 82, 82, 66, 90, 81, 93, 86, 83, 
  85, 98, 85, 82, 88, 84, 87, 94, 75, 86, 
  84, 80, 83, 74, 70, 82, 81, 91, 99, 60, 
  76, 77, 89, 79, 86, 85, 78, 86, 77, 85, 
  100, 82, 76, 89, 84, 87, 75, 92, 73, 71, 
  71, 94, 79, 90, 123, 88, 95, 85, 70, 85, 
  81, 87, 75, 66, 80, 93, 75, 89, 84, 78, 
  78, 92, 77, 81, 85, 85, 89, 95, 88, 101, 
  83, 78, 89, 87, 93, 84, 86, 80, 83, 89, 
  69, 85, 98, 114, 79, 94, 88, 76, 104, 76, 
  88, 89, 78, 74, 68, 74, 64, 81, 73, 98, 
  71, 82, 86, 99, 94, 98, 80, 72, 85, 81, 
  86, 94, 75, 81, 89, 85, 75, 87, 80, 77, 
  77, 85, 102, 89, 88, 86, 71, 82, 79, 95, 
  83, 79, 87, 85, 78, 74, 62, 84, 74, 102, 
  81, 77, 83, 80, 73, 89, 79, 89, 71, 89, 
  91, 90, 82, 89, 92, 69, 73, 82, 92, 82, 
  80, 79, 91, 81, 84, 78, 77, 81, 71, 88, 
  78, 89, 102, 71, 87, 82, 85, 84, 78, 89, 
  87, 78, 86, 81, 88, 78, 80, 83, 78, 98, 
  95, 93, 94, 83, 77, 78, 103, 76, 87, 79, 
  77, 88, 77, 83, 96, 77, 82, 77, 72, 102, 
  87, 98, 83, 81, 82, 90, 91, 74, 73, 78, 
  97, 80, 91, 92, 77, 86, 81, 86, 86, 75, 
  84, 97, 93, 87, 99, 71, 83, 81, 86, 87, 
  80, 81, 87, 88, 92, 74, 81, 80, 86, 91, 
  85, 82, 83, 83, 95, 79, 88, 91, 71, 83, 
  75, 81, 74, 70, 115, 96, 64, 93, 90, 76, 
  87, 91, 77, 84, 94, 84, 56, 81, 72, 84, 
  85, 102, 110, 95, 100, 82, 78, 73, 89, 79, 
  127, 122, 102, 91, 81, 84, 80, 92, 104, 97, 
  91, 67, 115, 76, 75, 100, 69, 112, 94, 118, 
  77, 88, 75, 99, 88, 79, 110, 87, 89, 73, 
  106, 82, 72, 76, 80, 64, 69, 54, 74, 93, 
  70, 89, 94, 86, 85, 93, 65, 80, 85, 80, 
  94, 64, 86, 71, 96, 101, 74, 92, 92, 91, 
  74, 88, 86, 80, 96, 89, 89, 77, 80, 64, 
  103, 81, 91, 91, 99, 85, 89, 86, 91, 80, 
  80, 68, 81, 94, 74, 93, 80, 90, 103, 92, 
  89, 95, 77, 72, 98, 74, 89, 85, 77, 92, 
  72, 68, 104, 87, 90, 95, 88, 86, 73, 86, 
  78, 80, 89, 96, 72, 75, 85, 88, 88, 88, 
  111, 69, 100, 80, 92, 90, 75, 85, 106, 122, 
  82, 79, 81, 77, 79, 88, 82, 84, 91, 82, 
  83, 79, 68, 79, 78, 92, 79, 102, 84, 84, 
  83, 84, 80, 90, 90, 70, 86, 75, 79, 86, 
  77, 77, 87, 42, 72, 62, 80, 72, 71, 78, 
  75, 84, 85, 89, 77, 68, 75, 84, 76, 98, 
  86, 84, 87, 99, 76, 80, 97, 85, 83, 88, 
  73, 65, 71, 97, 75, 84, 86, 75, 89, 79, 
  73, 73, 84, 85, 81, 74, 84, 77, 84, 79, 
  95, 83, 87, 93, 70, 73, 106, 85, 74, 81, 
  89, 82, 97, 82, 76, 90, 86, 85, 83, 68, 
  81, 83, 99, 69, 81, 91, 77, 76, 84, 83, 
  93, 94, 86, 65, 94, 91, 87, 75, 97, 75, 
  87, 79, 94, 86, 69, 83, 95, 96, 74, 78, 
  82, 74, 76, 76, 61, 78, 102, 103, 67, 88, 
  72, 79, 78, 74, 78, 80, 89, 86, 89, 90, 
  81, 96, 63, 81, 80, 80, 72, 86, 87, 81, 
  85, 57, 79, 91, 93, 80, 78, 75, 72, 87, 
  77, 76, 91, 70, 80, 80, 78, 107, 82, 91, 
  81, 85, 89, 70, 97, 87, 83, 88, 78, 62, 
  71, 92, 72, 90, 90, 98, 93, 84, 76, 66, 
  74, 84, 83, 82, 84, 81, 74, 88, 83, 82, 
  92, 92, 73, 80, 91, 88, 75, 72, 88, 89, 
  70, 85, 67, 97, 85, 81, 77, 72, 100, 90, 
  82, 83, 89, 86, 79, 91, 83, 82, 84, 88, 
  65, 74, 78, 85, 88, 85, 109, 90, 97, 78, 
  88, 86, 84, 88, 99, 116, 87, 84, 77, 76, 
  67, 79, 72, 79, 96, 70, 88, 53, 73, 81, 
  76, 89, 83, 86, 84, 86, 69, 85, 80, 85, 
  90, 89, 82, 86, 84, 90, 83, 85, 93, 83, 
  69, 65, 76, 80, 62, 89, 71, 75, 91, 93, 
  68, 72, 75, 80, 92, 67, 91, 76, 85, 100, 
  71, 92, 85, 86, 78, 83, 85, 69, 76, 90, 
  74, 87, 81, 68, 75, 84, 79, 78, 91, 75, 
  77, 84, 79, 88, 106, 74, 83, 85, 84, 82, 
  78, 82, 113, 82, 85, 96, 93, 84, 96, 80, 
  83, 88, 83, 78, 77, 78, 88, 82, 90, 68, 
  87, 91, 86, 86, 90, 89, 83, 92, 89, 76, 
  93, 89, 92, 78, 98, 81, 77, 77, 98, 83, 
  75, 88, 88, 94, 81, 80, 88, 75, 80, 83, 
  63, 81, 108, 90, 72, 74, 67, 76, 92, 73, 
  80, 71, 86, 85, 94, 84, 75, 95, 82, 86, 
  83, 99, 79, 87, 82, 92, 93, 71, 67, 93, 
  86, 71, 72, 77, 70, 85, 83, 79, 84, 71, 
  81, 87, 64, 98, 90, 92, 80, 87, 93, 89, 
  84, 80, 90, 80, 78, 62, 75, 95, 71, 93, 
  83, 91, 74, 88, 77, 63, 88, 79, 79, 83, 
  81, 94, 88, 83, 94, 84, 93, 79, 78, 78, 
  81, 86, 84, 82, 90, 93, 69, 84, 67, 88, 
  89, 76, 84, 81, 80, 85, 79, 84, 78, 90, 
  92, 81, 91, 85, 93, 84, 92, 74, 91, 95, 
  77, 75, 84, 89, 86, 80, 94, 76, 76, 83, 
  77, 82, 78, 85, 82, 78, 87, 85, 75, 86, 
  99, 89, 74, 101, 84, 81, 84, 77, 88, 82, 
  87, 91, 91, 85, 85, 88, 76, 84, 84, 100, 
  80, 75, 89, 92, 84, 89, 91, 110, 95, 70, 
  80, 84, 79, 89, 78, 82, 88, 79, 89, 88, 
  65, 95, 86, 88, 76, 84, 95, 80, 82, 88, 
  81, 77, 78, 77, 85, 80, 78, 89, 80, 97, 
  84, 89, 90, 80, 80, 82, 80, 89, 84, 89, 
  64, 90, 75, 88, 94, 85, 82, 91, 80, 87, 
  86, 83, 79, 88, 61, 80, 70, 81, 89, 88, 
  78, 71, 94, 88, 82, 96, 81, 85, 76, 84, 
  89, 87, 83, 86, 81, 74, 79, 100, 86, 79, 
  101, 79, 83, 83, 100, 83, 82, 87, 97, 102, 
  90, 83, 78, 77, 71, 82, 62, 81, 103, 82, 
  76, 58, 69, 76, 86, 83, 92, 66, 88, 82, 
  89, 85, 78, 90, 73, 94, 74, 94, 81, 93, 
  86, 84, 88, 92, 83, 83, 91, 74, 63, 76, 
  85, 80, 87, 84, 76, 69, 77, 83, 72, 80, 
  89, 92, 79, 96, 75, 89, 87, 82, 90, 85, 
  76, 73, 77, 96, 72, 91, 79, 82, 66, 83, 
  81, 71, 87, 77, 85, 84, 74, 88, 92, 89, 
  97, 89, 88, 81, 77, 80, 108, 82, 83, 86, 
  94, 88, 71, 83, 72, 89, 84, 73, 84, 75, 
  84, 87, 82, 74, 81, 85, 86, 84, 89, 94, 
  84, 84, 95, 76, 88, 96, 82, 77, 82, 79, 
  80, 79, 100, 79, 84, 85, 81, 99, 85, 82, 
  88, 77, 91, 79, 76, 83, 102, 91, 76, 93, 
  77, 80, 99, 70, 87, 67, 92, 80, 92, 82, 
  84, 90, 81, 89, 85, 99, 81, 84, 82, 96, 
  88, 87, 80, 106, 87, 78, 71, 86, 74, 94, 
  81, 76, 87, 77, 90, 83, 60, 91, 84, 91, 
  74, 85, 92, 86, 79, 84, 88, 80, 77, 76, 
  88, 98, 78, 92, 84, 96, 73, 90, 86, 71, 
  84, 84, 84, 85, 83, 89, 81, 90, 91, 89, 
  93, 77, 83, 83, 71, 90, 85, 86, 85, 90, 
  54, 84, 66, 83, 85, 82, 87, 83, 79, 91, 
  76, 87, 76, 83, 93, 85, 86, 86, 96, 78, 
  88, 76, 85, 99, 76, 78, 81, 84, 92, 83, 
  99, 75, 92, 82, 69, 92, 86, 87, 86, 82, 
  95, 80, 85, 77, 86, 81, 81, 111, 91, 83, 
  85, 74, 100, 82, 86, 86, 84, 76, 93, 82, 
  86, 89, 87, 100, 82, 82, 84, 96, 96, 97, 
  97, 102, 83, 82, 73, 93, 84, 98, 80, 83, 
  91, 84, 92, 86, 77, 77, 80, 87, 79, 90, 
  92, 74, 80, 86, 85, 80, 86, 92, 97, 89, 
  89, 85, 76, 86, 82, 84, 92, 90, 80, 83, 
  83, 84, 86, 93, 77, 87, 76, 93, 88, 85, 
  84, 84, 79, 85, 90, 87, 76, 85, 68, 77, 
  81, 75, 85, 92, 107, 78, 97, 92, 71, 103, 
  76, 79, 69, 90, 76, 88, 86, 74, 73, 85, 
  85, 85, 93, 76, 86, 70, 106, 87, 94, 77, 
  83, 85, 93, 95, 87, 86, 80, 73, 90, 88, 
  91, 77, 66, 82, 79, 89, 70, 88, 81, 86, 
  81, 84, 77, 78, 99, 90, 91, 79, 89, 99, 
  82, 90, 60, 81, 73, 73, 87, 79, 95, 61, 
  83, 89, 86, 66, 85, 85, 68, 77, 76, 80, 
  86, 107, 96, 96, 81, 96, 76, 72, 72, 76, 
  94, 81, 107, 69, 67, 80, 84, 72, 87, 78, 
  83, 83, 89, 80, 86, 91, 75, 86, 97, 95, 
  72, 83, 83, 79, 81, 74, 92, 79, 109, 103, 
  87, 92, 85, 79, 108, 68, 84, 91, 81, 100, 
  91, 83, 123, 94, 102, 92, 73, 83, 74, 81, 
  72, 83, 76, 95, 106, 88, 76, 84, 82, 72, 
  89, 67, 80, 82, 81, 84, 83, 77, 85, 83, 
  92, 91, 92, 98, 79, 81, 90, 79, 94, 77, 
  83, 76, 74, 85, 82, 92, 80, 73, 85, 93, 
  76, 73, 93, 108, 93, 90, 83, 114, 77, 84, 
  49, 84, 76, 67, 89, 78, 87, 60, 89, 74, 
  89, 61, 99, 87, 54, 80, 79, 72, 84, 88, 
  101, 97, 79, 110, 88, 82, 73, 86, 79, 83, 
  125, 73, 68, 80, 79, 67, 71, 75, 91, 74, 
  90, 82, 83, 82, 74, 85, 98, 95, 78, 88, 
  98, 76, 89, 70, 91, 75, 112, 96, 80, 101, 
  93, 85, 98, 70, 81, 89, 80, 92, 86, 95, 
  97, 97, 88, 93, 74, 104, 77, 80, 64, 89, 
  81, 84, 86, 86, 71, 86, 83, 85, 99, 80, 
  76, 74, 97, 86, 85, 78, 84, 83, 94, 87, 
  84, 99, 77, 84, 90, 82, 92, 73, 73, 81, 
  84, 83, 82, 91, 82, 75, 80, 106, 77, 81, 
  101, 81, 90, 87, 95, 92, 89, 88, 66, 82, 
  78, 81, 88, 85, 100, 62, 90, 85, 73, 73, 
  95, 88, 69, 78, 88, 82, 83, 80, 96, 90, 
  83, 96, 80, 90, 78, 80, 86, 81, 103, 83, 
  70, 84, 85, 75, 83, 78, 87, 81, 84, 72, 
  87, 80, 77, 83, 97, 90, 80, 85, 84, 79, 
  68, 80, 90, 94, 102, 91, 83, 92, 89, 92, 
  88, 74, 79, 94, 86, 90, 91, 84, 96, 77, 
  99, 84, 87, 95, 69, 77, 88, 87, 78, 89, 
  83, 82, 74, 75, 74, 72, 75, 77, 93, 76, 
  81, 85, 88, 85, 83, 81, 97, 78, 79, 92, 
  87, 86, 85, 95, 75, 85, 57, 78, 74, 88, 
  91, 78, 88, 100, 69, 89, 88, 84, 93, 82, 
  87, 93, 83, 67, 79, 78, 64, 81, 71, 96, 
  68, 79, 82, 86, 85, 98, 86, 49, 88, 90, 
  77, 81, 63, 88, 79, 83, 77, 91, 80, 78, 
  80, 75, 73, 92, 88, 77, 96, 74, 75, 76, 
  86, 81, 90, 90, 78, 90, 76, 97, 73, 100, 
  77, 86, 78, 111, 74, 83, 82, 67, 83, 75, 
  76, 85, 112, 91, 70, 92, 79, 101, 84, 79, 
  80, 80, 83, 89, 81, 86, 90, 79, 89, 78, 
  96, 75, 66, 77, 90, 84, 84, 92, 73, 68, 
  73, 75, 70, 66, 62, 75, 96, 80, 78, 90, 
  80, 82, 91, 78, 100, 83, 68, 86, 83, 87, 
  81, 94, 73, 89, 71, 67, 76, 75, 93, 70, 
  100, 102, 59, 88, 89, 74, 85, 56, 89, 98, 
  64, 100, 86, 70, 61, 81, 70, 105, 63, 81, 
  67, 91, 95, 97, 85, 43, 90, 91, 80, 78, 
  57, 80, 83, 83, 80, 94, 81, 78, 82, 85, 
  76, 100, 81, 77, 72, 77, 74, 73, 80, 72, 
  74, 87, 79, 95, 91, 107, 72, 87, 79, 88, 
  78, 128, 83, 73, 87, 64, 67, 68, 73, 80, 
  108, 100, 85, 99, 76, 119, 80, 82, 71, 79, 
  78, 83, 84, 89, 94, 79, 84, 87, 86, 81, 
  73, 75, 84, 87, 86, 84, 92, 68, 72, 80, 
  76, 74, 77, 82, 92, 75, 97, 87, 79, 84, 
  85, 80, 97, 88, 74, 86, 86, 81, 85, 88, 
  73, 85, 90, 77, 75, 80, 89, 83, 94, 83, 
  64, 88, 88, 84, 96, 69, 87, 96, 82, 118, 
  89, 82, 66, 85, 71, 86, 69, 85, 81, 91, 
  93, 101, 82, 75, 84, 97, 77, 80, 67, 86, 
  80, 84, 78, 84, 83, 79, 82, 83, 77, 92, 
  84, 83, 92, 83, 73, 76, 84, 76, 73, 83, 
  79, 91, 102, 91, 82, 72, 78, 84, 83, 108, 
  88, 78, 87, 65, 59, 78, 79, 83, 91, 94, 
  93, 88, 77, 103, 81, 85, 73, 88, 87, 86, 
  81, 83, 93, 76, 98, 86, 96, 86, 74, 76, 
  83, 85, 76, 86, 88, 85, 63, 86, 80, 85, 
  90, 83, 86, 86, 84, 79, 90, 87, 83, 81, 
  89, 70, 78, 91, 97, 96, 73, 83, 88, 78, 
  74, 91, 78, 90, 82, 83, 86, 98, 81, 88, 
  78, 89, 68, 71, 87, 82, 96, 76, 83, 62, 
  79, 80, 82, 89, 87, 71, 87, 85, 90, 99, 
  76, 83, 98, 81, 86, 86, 76, 88, 69, 66, 
  73, 89, 74, 77, 83, 87, 86, 91, 86, 95, 
  80, 79, 81, 79, 96, 86, 91, 85, 77, 92, 
  80, 82, 89, 94, 79, 81, 68, 94, 97, 95, 
  82, 89, 86, 91, 76, 98, 83, 74, 87, 88, 
  90, 81, 84, 90, 92, 80, 88, 75, 77, 78, 
  92, 78, 95, 77, 105, 71, 75, 77, 89, 87, 
  81, 85, 82, 81, 65, 86, 81, 86, 82, 84, 
  92, 96, 79, 76, 86, 91, 77, 83, 86, 69, 
  74, 84, 98, 100, 78, 91, 92, 86, 82, 83, 
  79, 82, 86, 73, 100, 98, 67, 77, 69, 89, 
  62, 57, 87, 84, 79, 78, 83, 66, 74, 87, 
  84, 93, 87, 80, 76, 91, 88, 98, 72, 81, 
  90, 81, 92, 81, 73, 85, 75, 70, 66, 92, 
  75, 69, 83, 89, 83, 90, 85, 87, 65, 78, 
  77, 77, 89, 92, 85, 83, 81, 100, 82, 81, 
  86, 80, 82, 82, 66, 96, 98, 86, 81, 83, 
  78, 90, 70, 87, 82, 63, 96, 92, 95, 87, 
  84, 93, 97, 81, 80, 73, 86, 73, 90, 77, 
  95, 87, 91, 78, 78, 72, 88, 87, 83, 81, 
  88, 87, 67, 86, 80, 86, 87, 84, 85, 89, 
  95, 83, 84, 87, 82, 82, 86, 76, 75, 87, 
  93, 91, 80, 91, 87, 83, 90, 88, 82, 85, 
  79, 78, 85, 95, 74, 76, 77, 88, 65, 73, 
  85, 86, 94, 86, 88, 68, 81, 82, 82, 85, 
  83, 78, 85, 83, 87, 98, 74, 98, 90, 87, 
  83, 85, 77, 90, 75, 76, 69, 85, 75, 76, 
  87, 82, 82, 91, 93, 92, 76, 78, 81, 84, 
  98, 87, 78, 86, 81, 92, 93, 80, 93, 84, 
  79, 80, 73, 97, 99, 84, 77, 85, 75, 93, 
  77, 81, 80, 79, 100, 84, 88, 79, 91, 97, 
  90, 88, 88, 80, 79, 76, 87, 80, 118, 91, 
  82, 87, 75, 71, 101, 89, 86, 81, 97, 76, 
  61, 79, 86, 76, 84, 88, 101, 88, 86, 86, 
  93, 86, 92, 88, 94, 97, 93, 93, 89, 81, 
  99, 104, 97, 94, 88, 70, 93, 84, 106, 73, 
  60, 95, 94, 90, 92, 94, 82, 69, 94, 91, 
  65, 88, 109, 70, 124, 85, 66, 125, 74, 76, 
  74, 76, 83, 91, 91, 60, 93, 101, 86, 81, 
  87, 100, 80, 87, 73, 68, 83, 55, 88, 87, 
  78, 79, 91, 76, 87, 92, 82, 82, 95, 94, 
  78, 94, 80, 78, 95, 83, 75, 84, 89, 88, 
  85, 81, 91, 80, 74, 83, 76, 67, 81, 93, 
  97, 97, 74, 86, 82, 91, 74, 83, 94, 78, 
  91, 89, 71, 76, 78, 76, 113, 97, 75, 84, 
  73, 65, 102, 92, 92, 79, 103, 84, 62, 78, 
  85, 75, 82, 78, 107, 85, 87, 83, 91, 82, 
  86, 91, 85, 94, 92, 89, 85, 86, 98, 102, 
  84, 108, 87, 66, 102, 79, 105, 75, 54, 105, 
  81, 95, 89, 92, 79, 79, 90, 89, 60, 91, 
  100, 68, 129, 89, 67, 128, 72, 78, 87, 78, 
  84, 91, 95, 69, 87, 98, 82, 79, 84, 100, 
  89, 89, 64, 70, 77, 55, 86, 96, 75, 82, 
  93, 86, 79, 88, 85, 93, 93, 95, 77, 93, 
  79, 84, 111, 87, 78, 88, 91, 91, 84, 87, 
  90, 78, 69, 77, 82, 69, 80, 97, 95, 101, 
  94, 95, 86, 85, 75, 84, 91, 72, 89, 89, 
  71, 74, 87, 73, 94, 94, 84, 80, 72, 69, 
  100, 89, 91, 76, 91, 83, 58, 84, 91, 76, 
  84, 81, 98, 88, 85, 81, 84, 84, 88, 87, 
  91, 101, 93, 85, 89, 80, 98, 91, 87, 85, 
  82, 76, 93, 81, 103, 77, 66, 95, 80, 84, 
  94, 90, 87, 82, 93, 86, 67, 93, 105, 72, 
  117, 87, 65, 102, 82, 70, 78, 79, 81, 92, 
  89, 67, 79, 96, 88, 86, 84, 98, 81, 90, 
  65, 70, 80, 57, 95, 87, 75, 80, 94, 73, 
  82, 97, 82, 81, 94, 94, 83, 86, 79, 83, 
  106, 78, 79, 79, 89, 87, 83, 84, 88, 80, 
  70, 83, 80, 76, 83, 94, 91, 103, 84, 83, 
  78, 91, 72, 87, 93, 81, 88, 92, 77, 81, 
  87, 73, 77, 72, 81, 73, 101, 86, 84, 84, 
  90, 85, 77, 87, 65, 74, 72, 84, 75, 76, 
  110, 79, 85, 74, 86, 114, 84, 80, 92, 100, 
  82, 95, 87, 71, 84, 80, 108, 83, 78, 57, 
  95, 74, 112, 87, 78, 77, 72, 74, 94, 76, 
  93, 74, 90, 85, 74, 89, 110, 79, 98, 78, 
  81, 90, 95, 75, 63, 79, 77, 81, 73, 71, 
  69, 77, 99, 102, 75, 94, 76, 85, 93, 69, 
  85, 71, 86, 69, 85, 72, 82, 70, 89, 77, 
  79, 77, 83, 85, 74, 69, 84, 87, 78, 86, 
  78, 79, 92, 86, 79, 71, 82, 96, 97, 81, 
  72, 65, 75, 71, 99, 87, 70, 84, 83, 100, 
  75, 74, 89, 92, 81, 74, 69, 92, 81, 70, 
  75, 77, 77, 72, 102, 80, 84, 84, 91, 86, 
  75, 87, 66, 71, 78, 84, 71, 74, 119, 76, 
  82, 66, 89, 105, 81, 82, 88, 106, 82, 95, 
  91, 73, 81, 76, 107, 82, 82, 56, 97, 74, 
  110, 91, 68, 86, 65, 76, 93, 76, 94, 87, 
  87, 85, 75, 90, 110, 76, 101, 77, 76, 94, 
  108, 72, 69, 79, 70, 86, 73, 76, 64, 77, 
  97, 92, 75, 95, 76, 80, 93, 73, 82, 75, 
  89, 73, 83, 77, 74, 74, 83, 78, 84, 79, 
  78, 85, 73, 67, 81, 87, 83, 90, 84, 73, 
  87, 88, 77, 71, 82, 94, 94, 77, 79, 61, 
  74, 77, 104, 96, 73, 86, 79, 93, 74, 77, 
  88, 88, 84, 76, 62, 91, 90, 71, 72, 76, 
  82, 74, 96, 75, 90, 86, 86, 78, 75, 76, 
  66, 79, 75, 86, 74, 75, 103, 80, 81, 75, 
  83, 106, 78, 78, 88, 104, 87, 97, 92, 70, 
  87, 79, 97, 81, 87, 69, 91, 78, 97, 90, 
  81, 85, 70, 80, 93, 75, 93, 81, 91, 84, 
  75, 82, 102, 77, 91, 83, 76, 79, 92, 75, 
  70, 83, 76, 80, 77, 77, 62, 82, 93, 98, 
  80, 94, 76, 80, 77, 74, 83, 71, 90, 75, 
  82, 78, 70, 77, 82, 79, 82, 78, 85, 90, 
  73, 67, 85, 85, 85, 85, 86, 70, 91, 84, 
  86, 77, 88, 90, 91, 83, 85, 69, 80, 84, 
  91, 91, 64, 85, 81, 95, 76, 77, 84, 91, 
  81, 81, 76, 90, 101, 67, 63, 80, 96, 96, 
  89, 91, 77, 77, 83, 83, 90, 86, 88, 87, 
  67, 109, 84, 79, 83, 84, 74, 80, 87, 111, 
  84, 76, 78, 97, 83, 89, 91, 74, 85, 77, 
  79, 84, 86, 85, 91, 72, 86, 88, 95, 62, 
  77, 77, 85, 78, 93, 82, 84, 79, 84, 83, 
  88, 97, 63, 79, 95, 75, 80, 91, 77, 96, 
  74, 81, 74, 75, 89, 73, 99, 104, 87, 89, 
  70, 81, 94, 77, 89, 66, 84, 72, 95, 71, 
  86, 84, 84, 77, 64, 91, 69, 83, 80, 71, 
  96, 97, 79, 84, 82, 92, 92, 86, 81, 79, 
  82, 92, 78, 105, 108, 86, 90, 73, 75, 82, 
  62, 79, 85, 78, 78, 84, 77, 93, 83, 80, 
  94, 87, 96, 76, 76, 77, 97, 80, 90, 90, 
  77, 78, 81, 83, 83, 88, 93, 82, 71, 110, 
  85, 82, 78, 79, 83, 82, 87, 106, 79, 76, 
  77, 99, 83, 93, 93, 72, 86, 64, 77, 82, 
  91, 84, 86, 77, 86, 87, 91, 64, 76, 75, 
  88, 76, 101, 91, 81, 82, 85, 82, 92, 89, 
  63, 76, 93, 75, 80, 91, 78, 95, 79, 78, 
  78, 80, 76, 73, 96, 93, 88, 89, 73, 78, 
  91, 85, 85, 76, 87, 74, 94, 75, 76, 91, 
  86, 81, 67, 82, 67, 88, 76, 70, 93, 95, 
  77, 88, 82, 78, 92, 87, 75, 82, 83, 88, 
  82, 101, 113, 80, 87, 77, 80, 90, 59, 79, 
  83, 73, 78, 83, 79, 92, 87, 83, 94, 89, 
  96, 79, 86, 78, 91, 76, 80, 83, 78, 80, 
  82, 82, 87, 72, 91, 84, 67, 101, 80, 85, 
  74, 88, 94, 79, 86, 101, 78, 77, 70, 97, 
  82, 94, 88, 68, 91, 71, 79, 84, 93, 84, 
  95, 73, 85, 89, 100, 69, 79, 82, 85, 74, 
  87, 85, 80, 79, 85, 81, 88, 88, 64, 80, 
  87, 76, 78, 93, 84, 94, 76, 80, 74, 88, 
  66, 79, 95, 99, 91, 87, 72, 82, 85, 79, 
  85, 72, 84, 85, 87, 78, 70, 90, 80, 78, 
  64, 82, 74, 88, 77, 68, 93, 92, 75, 84, 
  86, 71, 94, 85, 85, 80, 87, 90, 75, 100, 
  105, 83, 89, 83, 83, 86, 68, 83, 88, 79, 
  83, 81, 70, 94, 84, 84, 95, 86, 74, 86, 
  78, 79, 73, 82, 124, 115, 55, 90, 89, 85, 
  82, 78, 71, 90, 93, 66, 77, 92, 72, 93, 
  92, 65, 78, 73, 80, 88, 87, 83, 75, 75, 
  98, 72, 79, 92, 75, 86, 88, 80, 75, 78, 
  75, 82, 77, 110, 79, 75, 76, 83, 77, 81, 
  105, 88, 90, 81, 83, 72, 98, 80, 85, 79, 
  83, 86, 84, 81, 76, 69, 75, 83, 82, 76, 
  89, 77, 87, 98, 142, 81, 84, 90, 133, 74, 
  81, 87, 73, 86, 78, 81, 99, 69, 84, 86, 
  75, 88, 84, 86, 73, 95, 74, 89, 116, 72, 
  85, 115, 83, 90, 101, 81, 76, 74, 73, 76, 
  70, 80, 79, 73, 81, 77, 94, 73, 86, 81, 
  66, 86, 83, 79, 79, 86, 77, 80, 84, 82, 
  74, 78, 120, 101, 52, 84, 87, 89, 91, 87, 
  78, 92, 93, 68, 76, 86, 79, 99, 79, 67, 
  75, 73, 75, 81, 81, 82, 81, 75, 85, 75, 
  81, 80, 78, 85, 80, 81, 79, 78, 80, 76, 
  76, 112, 87, 81, 76, 84, 71, 75, 99, 86, 
  84, 80, 74, 69, 93, 83, 91, 82, 84, 84, 
  78, 76, 76, 75, 81, 76, 78, 78, 86, 72, 
  92, 89, 139, 80, 87, 92, 120, 69, 90, 91, 
  73, 89, 84, 71, 96, 83, 78, 88, 72, 100, 
  93, 85, 67, 100, 77, 86, 107, 76, 86, 112, 
  75, 88, 99, 78, 74, 68, 81, 74, 72, 84, 
  83, 78, 75, 76, 102, 76, 80, 80, 73, 91, 
  82, 79, 76, 92, 73, 75, 83, 82, 73, 87, 
  123, 101, 58, 87, 84, 83, 82, 88, 76, 88, 
  95, 64, 76, 87, 78, 91, 83, 71, 70, 77, 
  82, 87, 80, 81, 79, 72, 98, 77, 88, 81, 
  77, 87, 75, 80, 74, 85, 73, 85, 77, 111, 
  75, 80, 75, 82, 79, 78, 105, 85, 91, 77, 
  90, 70, 96, 73, 87, 76, 83, 83, 82, 78, 
  78, 74, 79, 77, 78, 72, 87, 77, 91, 101, 
  140, 89, 89, 89, 130, 75, 87, 88, 74, 84, 
  84, 87, 96, 73, 84, 87, 78, 93, 91, 86, 
  71, 96, 71, 85, 113, 78, 85, 102, 82, 92, 
  101, 82, 77, 78, 80, 75, 75, 79, 81, 72, 
  78, 79, 92, 68, 85, 80, 67, 84, 82, 80, 
  78, 87, 86, 87, 83, 79, 81, 84, 108, 110, 
  59, 87, 89, 84, 78, 88, 79, 90, 92, 64, 
  85, 90, 80, 90, 92, 66, 83, 69, 80, 87, 
  83, 76, 85, 73, 89, 83, 82, 90, 80, 80, 
  81, 76, 70, 71, 86, 79, 81, 109, 82, 77, 
  70, 79, 80, 78, 101, 87, 79, 76, 78, 76, 
  92, 82, 93, 73, 84, 80, 86, 77, 80, 74, 
  74, 77, 78, 82, 79, 75, 80, 94, 135, 86, 
  85, 93, 119, 80, 79, 84, 72, 79, 79, 79, 
  96, 86, 90, 86, 76, 89, 91, 89, 79, 104, 
  82, 88, 103, 74, 89, 108, 85, 87, 102, 78, 
  82, 77, 79, 70, 70, 85, 82, 79, 80, 74, 
  97, 72, 91, 82, 65, 90, 83, 87, 79, 95, 
  95, 83, 83, 88, 81, 80, 109, 99, 58, 86, 
  92, 92, 95, 91, 86, 97, 93, 67, 89, 87, 
  87, 98, 72, 67, 84, 67, 73, 84, 75, 83, 
  89, 76, 81, 82, 82, 81, 81, 81, 91, 78, 
  73, 80, 89, 77, 80, 107, 91, 82, 75, 83, 
  76, 76, 94, 84, 74, 86, 71, 76, 84, 87, 
  96, 72, 84, 90, 77, 81, 79, 83, 77, 72, 
  80, 91, 72, 76, 85, 85, 133, 78, 83, 96, 
  107, 77, 85, 86, 75, 82, 81, 71, 96, 87, 
  87, 80, 73, 108, 97, 85, 83, 112, 87, 84, 
  87, 79, 98, 104, 88, 93, 100, 78, 84, 72, 
  88, 68, 77, 85, 82, 83, 76, 75, 110, 77, 
  79, 82, 73, 98, 84, 90, 84, 103, 78, 79, 
  83, 85, 79, 93, 104, 91, 62, 83, 87, 80, 
  80, 85, 80, 91, 92, 66, 85, 87, 83, 82, 
  85, 73, 75, 73, 80, 86, 79, 83, 81, 71, 
  88, 80, 78, 84, 75, 78, 85, 76, 72, 71, 
  76, 83, 80, 109, 81, 81, 71, 78, 82, 73, 
  101, 85, 80, 86, 86, 76, 93, 73, 91, 73, 
  83, 77, 85, 74, 83, 76, 75, 77, 77, 74, 
  77, 80, 83, 97, 128, 85, 87, 86, 116, 76, 
  80, 92, 72, 78, 85, 88, 95, 92, 92, 85, 
  79, 89, 91, 88, 77, 97, 76, 85, 109, 81, 
  88, 92, 86, 87, 102, 80, 78, 80, 75, 70, 
  73, 82, 77, 74, 82, 73, 91, 70, 91, 78, 
  68, 88, 82, 87, 80, 93, 81, 90, 84, 77, 
  87, 82, 106, 105, 52, 87, 88, 79, 79, 95, 
  86, 90, 94, 59, 75, 84, 75, 94, 78, 69, 
  80, 74, 81, 85, 87, 76, 80, 69, 94, 83, 
  76, 86, 75, 70, 70, 80, 71, 81, 79, 88, 
  82, 113, 77, 83, 69, 77, 86, 92, 111, 88, 
  87, 72, 78, 78, 93, 73, 98, 74, 78, 88, 
  89, 90, 82, 68, 72, 84, 79, 72, 75, 74, 
  82, 99, 138, 78, 88, 91, 124, 72, 77, 84, 
  71, 72, 74, 84, 90, 84, 89, 95, 77, 85, 
  88, 100, 79, 101, 78, 91, 105, 79, 87, 114, 
  89, 85, 98, 77, 81, 84, 84, 73, 78, 86, 
  85, 76, 79, 76, 90, 75, 90, 83, 62, 91, 
  79, 83, 76, 87, 83, 81, 80, 85, 86, 73, 
  99, 105, 54, 85, 92, 92, 85, 84, 86, 92, 
  90, 63, 79, 81, 81, 92, 76, 66, 78, 69, 
  83, 85, 85, 86, 74, 70, 90, 82, 74, 80, 
  76, 70, 85, 77, 77, 72, 76, 82, 80, 118, 
  80, 82, 75, 77, 83, 83, 102, 87, 85, 83, 
  82, 77, 85, 76, 100, 77, 78, 84, 87, 86, 
  82, 71, 69, 89, 79, 75, 76, 83, 82, 98, 
  126, 78, 85, 87, 110, 70, 75, 98, 70, 74, 
  77, 80, 87, 86, 98, 94, 74, 91, 95, 94, 
  82, 101, 79, 91, 109, 79, 90, 112, 87, 90, 
  100, 77, 84, 83, 84, 73, 78, 84, 82, 74, 
  85, 74, 93, 80, 87, 85, 66, 95, 77, 89, 
  78, 92, 74, 77, 77, 79, 84, 77, 108, 91, 
  57, 85, 89, 77, 86, 83, 87, 90, 91, 64, 
  76, 81, 82, 86, 91, 75, 79, 77, 78, 83, 
  87, 81, 79, 68, 90, 80, 75, 80, 73, 74, 
  98, 79, 76, 83, 67, 89, 82, 108, 77, 76, 
  72, 74, 88, 83, 111, 88, 88, 96, 83, 81, 
  95, 73, 96, 76, 77, 86, 87, 92, 81, 69, 
  74, 91, 85, 72, 71, 78, 80, 99, 139, 83, 
  81, 88, 121, 71, 77, 92, 75, 74, 78, 93, 
  93, 91, 90, 89, 77, 86, 82, 98, 75, 98, 
  77, 90, 108, 74, 87, 99, 90, 85, 97, 76, 
  78, 85, 74, 72, 75, 73, 80, 74, 82, 76, 
  89, 78, 93, 82, 66, 87, 79, 86, 78, 85, 
  80, 83, 88, 82, 76, 89, 99, 81, 82, 92, 
  80, 84, 86, 75, 81, 87, 84, 96, 95, 92, 
  79, 97, 87, 81, 86, 93, 82, 81, 87, 77, 
  96, 76, 89, 80, 93, 74, 68, 82, 77, 92, 
  91, 72, 81, 104, 75, 86, 90, 82, 75, 90, 
  66, 115, 96, 77, 94, 55, 92, 89, 73, 93, 
  93, 74, 72, 68, 85, 78, 81, 88, 95, 92, 
  65, 69, 82, 88, 102, 83, 89, 98, 98, 76, 
  98, 77, 73, 84, 96, 73, 83, 82, 86, 78, 
  79, 64, 78, 74, 80, 85, 81, 80, 84, 75, 
  72, 77, 87, 87, 88, 82, 75, 102, 92, 88, 
  92, 86, 90, 82, 78, 85, 92, 80, 83, 91, 
  87, 98, 82, 85, 103, 90, 85, 95, 84, 71, 
  88, 75, 86, 79, 80, 82, 73, 88, 77, 84, 
  93, 113, 59, 87, 87, 77, 79, 81, 73, 101, 
  76, 99, 90, 76, 95, 80, 90, 76, 96, 81, 
  79, 76, 88, 88, 71, 69, 72, 95, 80, 104, 
  81, 76, 85, 82, 90, 79, 87, 78, 88, 91, 
  93, 76, 72, 51, 94, 63, 81, 79, 87, 85, 
  82, 72, 51, 79, 113, 77, 85, 73, 38, 78, 
  83, 89, 81, 78, 81, 124, 89, 91, 80, 83, 
  87, 89, 76, 75, 85, 78, 66, 86, 80, 67, 
  83, 81, 79, 78, 90, 85, 84, 98, 65, 87, 
  82, 80, 85, 82, 66, 86, 101, 72, 98, 70, 
  82, 92, 83, 94, 90, 86, 88, 81, 84, 83, 
  85, 79, 73, 89, 84, 103, 92, 74, 90, 83, 
  87, 74, 68, 84, 80, 84, 74, 81, 83, 126, 
  54, 95, 90, 71, 79, 77, 80, 91, 81, 87, 
  84, 62, 87, 84, 96, 84, 89, 92, 82, 82, 
  94, 89, 88, 80, 91, 68, 84, 85, 87, 75, 
  88, 82, 83, 95, 91, 65, 113, 90, 85, 80, 
  62, 80, 90, 75, 97, 80, 72, 94, 103, 74, 
  69, 80, 100, 82, 78, 80, 48, 73, 93, 93, 
  67, 86, 64, 117, 98, 90, 79, 94, 76, 92, 
  68, 94, 84, 84, 67, 80, 83, 92, 85, 83, 
  102, 85, 89, 92, 88, 98, 88, 104, 88, 79, 
  87, 88, 79, 82, 89, 69, 88, 73, 72, 99, 
  96, 96, 92, 94, 81, 77, 85, 75, 83, 74, 
  71, 95, 84, 81, 76, 81, 74, 82, 75, 87, 
  100, 82, 86, 95, 88, 82, 96, 60, 85, 92, 
  82, 98, 92, 89, 81, 96, 84, 80, 77, 85, 
  79, 85, 89, 77, 95, 71, 98, 85, 100, 80, 
  65, 80, 81, 85, 81, 75, 87, 99, 80, 90, 
  85, 83, 76, 89, 66, 102, 86, 80, 93, 67, 
  87, 89, 74, 95, 90, 78, 59, 69, 72, 81, 
  84, 87, 94, 64, 95, 80, 79, 90, 105, 86, 
  85, 114, 84, 74, 93, 75, 85, 78, 89, 72, 
  85, 86, 79, 79, 82, 73, 79, 71, 82, 80, 
  87, 79, 89, 80, 76, 76, 80, 88, 86, 79, 
  76, 95, 85, 93, 91, 96, 85, 75, 53, 74, 
  78, 82, 82, 84, 70, 93, 90, 90, 100, 81, 
  85, 102, 102, 69, 54, 80, 78, 72, 86, 82, 
  74, 93, 93, 79, 97, 80, 56, 84, 78, 76, 
  83, 72, 67, 104, 72, 90, 85, 79, 90, 85, 
  87, 83, 84, 80, 87, 80, 123, 90, 100, 78, 
  101, 80, 91, 104, 87, 73, 95, 70, 79, 65, 
  84, 78, 87, 75, 80, 84, 85, 65, 87, 64, 
  72, 83, 84, 92, 79, 79, 36, 94, 93, 83, 
  83, 63, 64, 85, 91, 76, 84, 78, 83, 153, 
  89, 88, 73, 74, 92, 80, 73, 75, 79, 93, 
  64, 96, 78, 76, 87, 74, 92, 78, 90, 86, 
  80, 98, 70, 82, 81, 84, 72, 75, 65, 82, 
  92, 76, 81, 80, 78, 80, 67, 83, 79, 86, 
  92, 85, 64, 81, 80, 84, 69, 74, 81, 114, 
  104, 67, 68, 86, 82, 75, 74, 80, 76, 85, 
  74, 83, 79, 100, 48, 75, 78, 64, 80, 65, 
  72, 78, 80, 86, 84, 72, 90, 85, 89, 93, 
  78, 100, 80, 81, 88, 83, 94, 83, 112, 61, 
  94, 85, 79, 68, 94, 75, 81, 81, 89, 66, 
  110, 64, 78, 86, 78, 94, 82, 75, 83, 72, 
  78, 103, 111, 85, 65, 86, 92, 84, 84, 84, 
  68, 79, 97, 75, 69, 79, 83, 113, 105, 91, 
  72, 88, 74, 77, 62, 93, 71, 103, 84, 94, 
  81, 93, 87, 73, 99, 78, 86, 93, 73, 95, 
  84, 105, 83, 84, 83, 87, 79, 82, 95, 77, 
  86, 75, 73, 94, 95, 101, 80, 84, 87, 90, 
  85, 69, 73, 80, 72, 88, 76, 81, 77, 77, 
  82, 91, 79, 78, 94, 79, 86, 90, 84, 80, 
  87, 61, 101, 94, 82, 93, 85, 93, 86, 76, 
  78, 80, 75, 88, 81, 79, 80, 82, 83, 84, 
  93, 83, 95, 75, 83, 85, 69, 80, 86, 73, 
  71, 98, 81, 85, 85, 71, 81, 82, 74, 91, 
  74, 86, 89, 89, 96, 100, 91, 92, 85, 84, 
  82, 80, 103, 77, 89, 87, 83, 93, 102, 84, 
  79, 86, 99, 83, 89, 104, 90, 81, 91, 78, 
  75, 82, 89, 79, 85, 85, 85, 82, 71, 88, 
  89, 87, 88, 87, 83, 84, 86, 83, 88, 92, 
  82, 87, 100, 85, 82, 91, 79, 94, 89, 96, 
  80, 68, 71, 80, 66, 89, 83, 81, 64, 92, 
  78, 86, 100, 86, 86, 85, 83, 80, 68, 91, 
  72, 62, 93, 82, 84, 86, 85, 73, 95, 64, 
  86, 95, 80, 90, 87, 88, 80, 72, 68, 86, 
  71, 94, 95, 77, 79, 88, 79, 88, 90, 73, 
  84, 68, 87, 88, 92, 89, 84, 83, 71, 94, 
  80, 74, 84, 72, 84, 86, 88, 91, 88, 83, 
  81, 98, 90, 87, 87, 82, 84, 76, 89, 89, 
  66, 82, 85, 83, 78, 86, 89, 80, 85, 84, 
  91, 76, 88, 91, 96, 77, 88, 78, 81, 77, 
  93, 84, 78, 77, 95, 98, 70, 91, 79, 81, 
  75, 79, 87, 80, 89, 77, 78, 91, 75, 86, 
  79, 81, 77, 92, 76, 87, 84, 85, 83, 73, 
  78, 73, 57, 85, 87, 78, 65, 89, 80, 86, 
  90, 83, 82, 91, 90, 81, 91, 89, 71, 83, 
  85, 79, 77, 84, 79, 79, 89, 79, 73, 81, 
  79, 87, 86, 87, 84, 79, 97, 87, 74, 94, 
  93, 84, 83, 90, 89, 98, 84, 72, 84, 91, 
  82, 96, 97, 78, 89, 83, 69, 83, 84, 72, 
  90, 89, 87, 83, 95, 85, 91, 83, 79, 99, 
  85, 84, 91, 84, 85, 88, 95, 86, 75, 80, 
  79, 87, 80, 83, 83, 81, 90, 80, 88, 74, 
  95, 100, 94, 78, 89, 85, 77, 93, 86, 88, 
  72, 93, 96, 101, 80, 82, 77, 78, 83, 74, 
  90, 76, 85, 64, 77, 86, 80, 84, 82, 80, 
  95, 87, 84, 95, 88, 77, 84, 91, 90, 90, 
  73, 82, 90, 81, 77, 92, 83, 87, 93, 90, 
  83, 83, 66, 69, 70, 93, 79, 62, 72, 101, 
  96, 76, 83, 84, 73, 89, 77, 89, 84, 76, 
  87, 93, 90, 97, 79, 83, 86, 78, 84, 79, 
  61, 97, 86, 84, 80, 74, 80, 91, 81, 90, 
  77, 70, 94, 82, 75, 92, 58, 82, 94, 130, 
  87, 76, 88, 89, 76, 84, 90, 79, 86, 82, 
  100, 98, 71, 80, 85, 77, 81, 79, 89, 104, 
  92, 77, 84, 78, 85, 76, 86, 73, 68, 82, 
  88, 84, 86, 85, 82, 56, 88, 81, 85, 93, 
  75, 83, 95, 74, 76, 85, 87, 84, 89, 79, 
  97, 90, 79, 79, 86, 81, 76, 82, 79, 88, 
  78, 70, 82, 81, 92, 87, 81, 80, 96, 83, 
  89, 81, 107, 76, 115, 72, 77, 79, 90, 81, 
  90, 70, 72, 83, 89, 67, 76, 83, 80, 87, 
  78, 86, 79, 87, 83, 83, 81, 91, 87, 76, 
  85, 83, 89, 82, 80, 82, 90, 71, 70, 83, 
  87, 70, 80, 86, 78, 89, 82, 77, 78, 75, 
  81, 84, 68, 84, 77, 84, 97, 105, 81, 74, 
  87, 88, 81, 69, 81, 81, 91, 82, 73, 97, 
  78, 68, 82, 76, 77, 87, 80, 88, 85, 78, 
  81, 84, 84, 93, 80, 77, 80, 79, 83, 91, 
  88, 78, 69, 64, 80, 82, 85, 78, 84, 81, 
  63, 78, 76, 88, 83, 82, 79, 79, 99, 66, 
  70, 81, 77, 77, 75, 79, 89, 82, 81, 102, 
  84, 79, 77, 88, 73, 72, 92, 92, 87, 69, 
  107, 92, 70, 81, 81, 84, 81, 83, 98, 80, 
  81, 83, 91, 87, 83, 71, 77, 92, 72, 80, 
  89, 86, 85, 87, 79, 94, 74, 76, 75, 68, 
  88, 86, 93, 81, 85, 75, 80, 84, 88, 84, 
  82, 95, 78, 88, 82, 81, 85, 78, 85, 93, 
  73, 87, 92, 84, 99, 91, 87, 75, 81, 82, 
  86, 63, 81, 83, 90, 84, 72, 91, 81, 76, 
  84, 90, 85, 88, 81, 84, 83, 88, 86, 84, 
  86, 94, 87, 84, 88, 83, 78, 87, 83, 82, 
  65, 74, 87, 83, 82, 76, 88, 66, 62, 95, 
  84, 89, 89, 84, 82, 84, 100, 81, 72, 89, 
  74, 83, 85, 89, 86, 85, 73, 109, 74, 79, 
  81, 86, 79, 86, 78, 92, 89, 76, 89, 96, 
  49, 87, 86, 90, 79, 84, 59, 75, 65, 93, 
  87, 48, 73, 97, 96, 76, 93, 81, 73, 96, 
  74, 83, 73, 71, 98, 102, 109, 105, 95, 79, 
  79, 75, 89, 84, 89, 97, 84, 82, 85, 76, 
  74, 97, 89, 95, 82, 75, 97, 85, 58, 101, 
  64, 87, 78, 156, 90, 79, 86, 110, 81, 99, 
  91, 94, 78, 81, 103, 89, 69, 88, 81, 71, 
  101, 80, 91, 121, 98, 81, 105, 88, 69, 86, 
  91, 74, 66, 83, 92, 79, 86, 80, 89, 56, 
  94, 77, 92, 106, 74, 76, 100, 81, 75, 83, 
  89, 80, 93, 79, 117, 121, 82, 84, 94, 85, 
  105, 99, 79, 89, 83, 50, 87, 91, 103, 88, 
  94, 91, 103, 74, 89, 85, 110, 61, 124, 73, 
  80, 75, 107, 88, 87, 71, 67, 83, 92, 58, 
  78, 90, 71, 83, 80, 78, 82, 91, 79, 84, 
  77, 97, 95, 79, 100, 76, 92, 79, 69, 88, 
  88, 69, 91, 80, 88, 65, 80, 85, 77, 91, 
  87, 73, 68, 80, 75, 85, 63, 81, 80, 91, 
  84, 126, 78, 75, 91, 87, 83, 76, 85, 86, 
  80, 82, 68, 92, 79, 66, 77, 62, 77, 86, 
  78, 95, 88, 74, 89, 87, 90, 97, 84, 77, 
  75, 81, 82, 94, 90, 77, 69, 60, 76, 79, 
  101, 81, 90, 81, 73, 83, 69, 91, 91, 77, 
  78, 79, 106, 68, 67, 91, 76, 81, 85, 82, 
  93, 75, 79, 95, 88, 80, 82, 91, 76, 74, 
  92, 88, 83, 60, 112, 86, 74, 81, 80, 80, 
  84, 84, 91, 77, 80, 76, 90, 79, 84, 74, 
  71, 92, 70, 76, 89, 88, 79, 85, 76, 100, 
  75, 74, 83, 70, 93, 83, 84, 87, 87, 72, 
  78, 85, 91, 70, 90, 89, 83, 87, 85, 80, 
  77, 82, 80, 85, 72, 80, 93, 89, 93, 95, 
  82, 77, 82, 83, 82, 66, 92, 89, 85, 88, 
  67, 87, 88, 80, 83, 77, 82, 92, 77, 80, 
  84, 93, 91, 79, 90, 87, 85, 83, 86, 79, 
  81, 86, 84, 84, 62, 70, 85, 80, 85, 76, 
  98, 79, 70, 91, 73, 88, 88, 84, 81, 88, 
  98, 72, 71, 87, 77, 86, 86, 84, 89, 81, 
  74, 109, 81, 77, 83, 87, 84, 78, 82, 85, 
  85, 74, 91, 98, 42, 87, 86, 84, 77, 83, 
  60, 79, 66, 98, 85, 47, 75, 96, 87, 80, 
  94, 85, 75, 88, 76, 81, 73, 76, 94, 92, 
  107, 97, 87, 76, 80, 82, 97, 80, 97, 96, 
  90, 77, 84, 68, 68, 92, 87, 98, 87, 71, 
  102, 85, 60, 97, 73, 88, 72, 150, 97, 81, 
  82, 104, 74, 104, 86, 85, 83, 80, 108, 85, 
  81, 89, 97, 72, 86, 75, 88, 111, 86, 83, 
  95, 96, 64, 92, 84, 84, 70, 79, 89, 82, 
  84, 83, 88, 59, 88, 89, 88, 103, 74, 82, 
  96, 87, 77, 83, 85, 81, 88, 86, 101, 116, 
  97, 79, 88, 84, 93, 89, 88, 93, 97, 55, 
  95, 90, 105, 87, 91, 91, 99, 74, 82, 93, 
  119, 65, 114, 75, 79, 82, 103, 82, 84, 75, 
  65, 82, 89, 62, 77, 90, 68, 88, 83, 78, 
  83, 85, 78, 85, 73, 96, 86, 80, 103, 80, 
  94, 81, 73, 85, 84, 70, 99, 93, 90, 63, 
  72, 79, 71, 90, 86, 74, 79, 85, 87, 91, 
  59, 82, 93, 86, 71, 128, 81, 79, 79, 89, 
  82, 82, 87, 77, 84, 82, 75, 83, 82, 72, 
  83, 71, 75, 86, 76, 95, 80, 78, 94, 98, 
  89, 95, 80, 88, 83, 80, 76, 91, 89, 77, 
  69, 62, 77, 88, 94, 76, 89, 80, 71, 84, 
  73, 89, 94, 80, 78, 82, 93, 74, 77, 84, 
  81, 80, 84, 79, 92, 78, 76, 97, 91, 78, 
  83, 90, 79, 80, 90, 86, 81, 78, 106, 86, 
  63, 84, 78, 78, 83, 81, 91, 81, 74, 76, 
  90, 75, 79, 76, 65, 91, 69, 70, 91, 90, 
  80, 89, 72, 99, 71, 77, 92, 72, 96, 83, 
  84, 86, 84, 70, 84, 94, 93, 71, 87, 84, 
  81, 86, 86, 79, 81, 84, 86, 91, 77, 82, 
  101, 85, 78, 103, 78, 78, 76, 82, 84, 69, 
  86, 81, 90, 84, 68, 87, 92, 80, 83, 79, 
  76, 90, 75, 82, 79, 92, 77, 84, 92, 84, 
  84, 91, 93, 78, 74, 91, 85, 80, 59, 71, 
  86, 86, 86, 67, 99, 79, 77, 84, 77, 91, 
  87, 88, 80, 84, 87, 66, 76, 87, 84, 87, 
  83, 72, 92, 82, 73, 106, 83, 75, 78, 91, 
  79, 80, 87, 84, 83, 86, 93, 93, 36, 87, 
  85, 83, 77, 82, 70, 83, 90, 80, 97, 81, 
  84, 84, 75, 70, 75, 77, 78, 81, 78, 83, 
  72, 75, 73, 84, 104, 79, 62, 71, 79, 89, 
  81, 76, 97, 71, 108, 76, 75, 73, 67, 72, 
  75, 78, 87, 83, 82, 75, 68, 90, 89, 93, 
  96, 70, 79, 87, 86, 87, 88, 95, 79, 79, 
  70, 82, 93, 92, 98, 69, 93, 90, 93, 84, 
  75, 78, 75, 69, 56, 70, 82, 106, 81, 63, 
  84, 78, 89, 83, 95, 97, 85, 87, 90, 105, 
  78, 84, 99, 82, 74, 83, 79, 75, 62, 93, 
  77, 85, 74, 85, 86, 70, 80, 69, 95, 73, 
  99, 83, 81, 96, 83, 97, 72, 83, 90, 97, 
  84, 95, 90, 102, 96, 84, 86, 74, 90, 84, 
  79, 85, 70, 91, 63, 81, 96, 71, 84, 87, 
  71, 74, 76, 67, 84, 85, 81, 85, 72, 74, 
  73, 81, 74, 79, 71, 75, 76, 89, 77, 79, 
  97, 70, 101, 75, 74, 84, 68, 78, 73, 82, 
  87, 79, 88, 75, 104, 85, 88, 95, 93, 81, 
  84, 85, 90, 85, 86, 94, 82, 89, 73, 82, 
  95, 96, 100, 76, 96, 89, 94, 86, 70, 77, 
  74, 68, 81, 71, 85, 106, 84, 67, 84, 70, 
  95, 83, 89, 92, 82, 75, 85, 96, 83, 83, 
  95, 85, 76, 102, 77, 77, 69, 93, 77, 85, 
  74, 84, 90, 89, 85, 72, 103, 74, 101, 81, 
  83, 94, 73, 102, 74, 79, 84, 90, 74, 97, 
  94, 96, 81, 86, 85, 80, 88, 81, 80, 83, 
  78, 87, 55, 86, 89, 69, 80, 86, 83, 75, 
  79, 80, 89, 88, 83, 76, 72, 80, 73, 78, 
  71, 75, 86, 74, 83, 85, 81, 72, 95, 70, 
  80, 73, 76, 87, 68, 90, 79, 86, 83, 78, 
  79, 77, 104, 83, 90, 78, 92, 95, 73, 81, 
  88, 81, 85, 89, 76, 85, 80, 83, 84, 90, 
  91, 72, 91, 85, 87, 83, 69, 78, 81, 72, 
  82, 69, 91, 80, 88, 69, 73, 79, 90, 83, 
  83, 94, 90, 77, 92, 92, 102, 76, 96, 90, 
  84, 88, 73, 78, 82, 91, 74, 86, 74, 93, 
  84, 86, 78, 76, 74, 79, 88, 82, 87, 82, 
  76, 82, 71, 86, 85, 92, 80, 89, 82, 85, 
  78, 78, 83, 79, 86, 75, 75, 90, 89, 84, 
  75, 88, 85, 78, 74, 91, 82, 82, 82, 89, 
  76, 76, 78, 81, 88, 80, 94, 82, 124, 97, 
  86, 65, 79, 90, 81, 95, 82, 84, 95, 83, 
  85, 80, 86, 82, 78, 87, 84, 75, 92, 80, 
  84, 93, 86, 112, 82, 73, 89, 87, 83, 84, 
  90, 98, 108, 77, 95, 74, 90, 91, 69, 72, 
  90, 92, 86, 82, 71, 101, 77, 71, 64, 79, 
  79, 97, 84, 93, 99, 90, 66, 82, 86, 85, 
  86, 76, 80, 77, 75, 82, 79, 69, 87, 76, 
  82, 79, 71, 87, 108, 92, 84, 80, 87, 64, 
  111, 65, 106, 79, 87, 86, 88, 88, 67, 88, 
  82, 79, 82, 87, 104, 101, 88, 88, 78, 103, 
  83, 98, 88, 78, 96, 77, 93, 91, 77, 92, 
  83, 91, 71, 96, 83, 91, 77, 83, 77, 80, 
  84, 85, 92, 76, 100, 82, 96, 99, 76, 65, 
  79, 85, 84, 100, 75, 93, 96, 102, 86, 80, 
  80, 92, 82, 92, 79, 69, 90, 78, 115, 89, 
  81, 119, 80, 68, 94, 86, 85, 79, 87, 97, 
  116, 81, 97, 78, 86, 90, 77, 82, 94, 85, 
  86, 78, 68, 104, 71, 71, 77, 86, 79, 101, 
  84, 103, 108, 77, 68, 83, 82, 81, 88, 75, 
  76, 74, 71, 82, 74, 71, 90, 84, 80, 78, 
  74, 88, 114, 92, 68, 83, 87, 89, 122, 66, 
  113, 80, 91, 85, 87, 80, 66, 96, 85, 69, 
  83, 86, 81, 102, 92, 86, 68, 107, 83, 105, 
  90, 72, 96, 76, 76, 91, 82, 86, 86, 74, 
  84, 86, 82, 73, 85, 97, 92, 81, 83, 83, 
  75, 85, 78, 76, 83, 88, 87, 68, 86, 80, 
  74, 80, 93, 92, 83, 81, 81, 82, 72, 100, 
  77, 88, 83, 82, 93, 82, 115, 88, 80, 100, 
  87, 93, 79, 91, 92, 86, 91, 87, 87, 82, 
  83, 75, 82, 85, 78, 77, 88, 87, 94, 84, 
  72, 86, 76, 69, 91, 83, 83, 86, 88, 76, 
  72, 76, 76, 82, 85, 91, 83, 85, 86, 76, 
  98, 74, 85, 81, 82, 82, 85, 75, 70, 85, 
  83, 87, 74, 81, 88, 78, 82, 71, 87, 78, 
  86, 80, 80, 93, 68, 76, 75, 84, 84, 89, 
  88, 99, 90, 80, 70, 89, 87, 83, 87, 76, 
  78, 76, 87, 75, 81, 91, 85, 75, 74, 81, 
  80, 67, 77, 86, 78, 82, 75, 73, 90, 81, 
  87, 79, 103, 86, 85, 77, 74, 101, 88, 80, 
  80, 86, 82, 91, 78, 83, 72, 86, 83, 94, 
  84, 82, 73, 88, 90, 94, 96, 100, 88, 81, 
  91, 77, 78, 82, 93, 86, 102, 86, 97, 70, 
  98, 86, 79, 70, 89, 95, 84, 79, 86, 87, 
  82, 76, 82, 73, 67, 89, 85, 83, 75, 82, 
  87, 89, 79, 92, 86, 77, 83, 78, 77, 85, 
  83, 74, 83, 77, 87, 85, 69, 85, 109, 100, 
  97, 80, 78, 72, 95, 62, 71, 89, 86, 81, 
  85, 100, 78, 83, 76, 83, 80, 85, 95, 91, 
  83, 90, 75, 89, 86, 102, 87, 77, 89, 82, 
  99, 84, 96, 96, 85, 85, 72, 88, 83, 75, 
  78, 82, 73, 84, 81, 79, 98, 78, 96, 87, 
  94, 87, 79, 75, 71, 92, 92, 86, 72, 89, 
  80, 106, 82, 79, 76, 90, 83, 103, 83, 71, 
  70, 83, 101, 90, 94, 102, 89, 72, 93, 74, 
  82, 76, 90, 84, 103, 80, 97, 76, 90, 85, 
  80, 75, 93, 83, 81, 80, 80, 93, 86, 73, 
  75, 76, 71, 88, 84, 91, 83, 82, 80, 91, 
  77, 90, 85, 79, 79, 80, 73, 90, 80, 74, 
  85, 74, 83, 81, 78, 86, 113, 99, 79, 82, 
  78, 83, 105, 61, 72, 102, 94, 82, 87, 90, 
  79, 88, 78, 74, 84, 90, 77, 91, 76, 92, 
  74, 90, 83, 108, 91, 76, 91, 80, 77, 85, 
  98, 88, 92, 69, 83, 83, 86, 69, 85, 93, 
  90, 86, 76, 79, 81, 79, 78, 80, 86, 89, 
  85, 74, 75, 84, 82, 79, 91, 81, 86, 83, 
  77, 76, 80, 92, 83, 96, 81, 93, 86, 86, 
  103, 88, 83, 96, 96, 88, 82, 86, 86, 85, 
  88, 77, 78, 80, 88, 76, 85, 91, 82, 76, 
  88, 98, 95, 79, 80, 80, 84, 75, 89, 82, 
  78, 89, 83, 81, 69, 84, 77, 81, 74, 96, 
  81, 83, 88, 77, 89, 81, 85, 81, 80, 87, 
  91, 84, 71, 84, 84, 93, 83, 79, 84, 84, 
  82, 64, 80, 75, 84, 87, 87, 95, 83, 82, 
  75, 81, 91, 83, 80, 94, 92, 85, 79, 93, 
  86, 87, 85, 83, 79, 82, 86, 85, 81, 71, 
  74, 77, 82, 82, 91, 85, 80, 78, 89, 86, 
  79, 83, 74, 83, 83, 92, 77, 90, 90, 82, 
  94, 82, 81, 124, 92, 85, 84, 86, 93, 90, 
  79, 91, 78, 82, 90, 82, 99, 84, 84, 90, 
  82, 92, 95, 95, 74, 85, 85, 82, 79, 89, 
  87, 79, 77, 81, 80, 85, 85, 84, 89, 78, 
  87, 70, 79, 97, 83, 88, 75, 88, 79, 77, 
  79, 77, 81, 82, 75, 79, 88, 80, 79, 80, 
  85, 86, 79, 80, 88, 64, 73, 75, 91, 88, 
  86, 69, 78, 91, 86, 82, 75, 77, 74, 77, 
  89, 85, 75, 80, 82, 74, 85, 93, 80, 90, 
  90, 85, 81, 87, 99, 68, 81, 80, 91, 83, 
  90, 60, 80, 108, 86, 88, 76, 70, 75, 83, 
  83, 83, 103, 102, 80, 82, 93, 89, 80, 82, 
  74, 86, 78, 92, 82, 97, 78, 80, 83, 79, 
  82, 141, 86, 82, 79, 90, 100, 87, 84, 86, 
  77, 93, 87, 80, 96, 84, 92, 80, 79, 100, 
  94, 79, 70, 94, 85, 80, 77, 89, 97, 88, 
  73, 82, 71, 81, 86, 87, 87, 84, 84, 78, 
  80, 91, 73, 90, 75, 82, 80, 81, 76, 72, 
  84, 86, 79, 76, 92, 74, 78, 74, 76, 79, 
  72, 76, 89, 65, 74, 83, 91, 87, 78, 66, 
  75, 92, 88, 84, 80, 73, 84, 78, 115, 77, 
  72, 84, 83, 77, 78, 94, 88, 73, 90, 84, 
  71, 101, 109, 73, 83, 73, 96, 82, 99, 61, 
  88, 114, 85, 84, 78, 72, 81, 90, 85, 85, 
  85, 81, 80, 74, 88, 89, 80, 83, 79, 79, 
  81, 92, 87, 89, 72, 83, 82, 85, 80, 114, 
  91, 83, 88, 83, 91, 92, 83, 97, 84, 84, 
  81, 81, 93, 85, 79, 86, 83, 94, 91, 79, 
  79, 78, 87, 79, 81, 89, 86, 89, 83, 79, 
  81, 87, 83, 82, 88, 79, 86, 70, 82, 94, 
  82, 86, 82, 85, 81, 80, 83, 77, 78, 87, 
  83, 82, 82, 79, 84, 82, 84, 82, 98, 77, 
  86, 72, 77, 86, 94, 88, 83, 75, 84, 88, 
  91, 87, 75, 77, 74, 76, 86, 80, 75, 82, 
  82, 74, 82, 91, 80, 73, 82, 86, 79, 88, 
  97, 70, 81, 85, 86, 87, 93, 66, 79, 97, 
  86, 84, 80, 78, 78, 77, 73, 77, 106, 96, 
  74, 73, 81, 86, 68, 91, 73, 78, 73, 91, 
  81, 94, 90, 81, 87, 79, 84, 136, 84, 75, 
  76, 78, 86, 78, 79, 88, 73, 107, 95, 82, 
  82, 94, 75, 85, 91, 97, 93, 94, 66, 85, 
  84, 82, 83, 87, 87, 86, 72, 88, 90, 72, 
  77, 87, 80, 78, 89, 80, 78, 89, 91, 78, 
  88, 82, 87, 75, 72, 74, 90, 85, 72, 74, 
  95, 78, 79, 72, 85, 80, 81, 79, 97, 68, 
  78, 72, 77, 84, 84, 74, 67, 90, 84, 87, 
  84, 79, 73, 77, 101, 92, 76, 74, 86, 71, 
  94, 88, 75, 99, 85, 87, 80, 95, 98, 70, 
  84, 86, 102, 79, 95, 63, 92, 106, 92, 91, 
  87, 89, 74, 81, 69, 80, 127, 121, 73, 73, 
  93, 91, 71, 94, 71, 79, 68, 91, 81, 105, 
  75, 83, 72, 72, 89, 160, 79, 77, 63, 95, 
  100, 72, 74, 80, 71, 126, 99, 82, 70, 97, 
  84, 74, 87, 94, 92, 77, 64, 102, 87, 87, 
  80, 87, 98, 89, 71, 91, 73, 61, 72, 86, 
  79, 86, 80, 95, 73, 78, 84, 83, 78, 77, 
  92, 75, 66, 73, 107, 77, 71, 70, 100, 69, 
  82, 83, 74, 82, 74, 73, 103, 67, 79, 69, 
  74, 76, 73, 69, 66, 92, 86, 91, 93, 75, 
  86, 78, 130, 93, 77, 76, 94, 72, 85, 83, 
  85, 76, 86, 83, 79, 113, 104, 74, 81, 81, 
  107, 79, 106, 59, 95, 115, 77, 89, 81, 73, 
  84, 96, 77, 83, 94, 86, 77, 68, 80, 91, 
  71, 92, 81, 80, 73, 91, 80, 94, 73, 84, 
  77, 85, 83, 124, 85, 85, 79, 83, 85, 88, 
  76, 95, 74, 99, 88, 81, 81, 86, 82, 82, 
  86, 85, 92, 78, 75, 77, 84, 76, 86, 87, 
  88, 82, 79, 86, 86, 81, 80, 88, 79, 74, 
  90, 77, 83, 88, 88, 83, 82, 82, 85, 80, 
  80, 79, 83, 77, 78, 75, 88, 80, 83, 91, 
  83, 86, 100, 76, 91, 72, 82, 76, 82, 88, 
  73, 79, 72, 88, 87, 87, 82, 83, 74, 75, 
  96, 87, 77, 77, 82, 71, 82, 86, 75, 73, 
  81, 83, 90, 93, 95, 76, 73, 87, 98, 85, 
  97, 70, 88, 95, 82, 85, 82, 72, 77, 80, 
  77, 72, 93, 92, 70, 81, 79, 87, 74, 86, 
  70, 74, 84, 87, 82, 87, 80, 77, 92, 85, 
  86, 113, 91, 78, 69, 72, 81, 86, 96, 76, 
  81, 106, 89, 84, 84, 82, 85, 85, 88, 93, 
  83, 80, 69, 75, 90, 75, 86, 82, 80, 83, 
  82, 70, 92, 80, 88, 87, 81, 82, 86, 79, 
  72, 95, 89, 78, 86, 81, 89, 68, 72, 86, 
  85, 90, 79, 70, 96, 85, 80, 71, 87, 84, 
  80, 76, 91, 78, 75, 68, 75, 89, 87, 73, 
  71, 90, 75, 92, 75, 76, 77, 76, 81, 97, 
  81, 75, 81, 71, 89, 76, 62, 103, 86, 94, 
  84, 81, 89, 75, 80, 84, 96, 83, 83, 88, 
  96, 85, 81, 90, 85, 74, 70, 84, 75, 76, 
  100, 104, 69, 85, 85, 91, 73, 86, 66, 74, 
  77, 89, 81, 87, 79, 81, 81, 80, 86, 127, 
  84, 89, 63, 82, 86, 79, 84, 77, 82, 123, 
  90, 83, 80, 77, 82, 81, 83, 88, 77, 76, 
  72, 86, 91, 77, 81, 86, 87, 87, 81, 69, 
  83, 74, 84, 80, 79, 86, 101, 86, 71, 87, 
  92, 87, 75, 80, 101, 65, 73, 86, 88, 79, 
  83, 66, 100, 84, 76, 77, 84, 86, 81, 73, 
  91, 72, 75, 66, 76, 86, 81, 68, 72, 89, 
  78, 94, 80, 78, 84, 75, 97, 113, 77, 78, 
  83, 70, 81, 71, 69, 84, 84, 91, 88, 88, 
  90, 78, 76, 82, 100, 78, 91, 86, 100, 86, 
  79, 87, 76, 73, 80, 90, 80, 80, 90, 84, 
  72, 75, 81, 92, 79, 86, 75, 76, 84, 86, 
  84, 86, 87, 82, 82, 90, 82, 111, 93, 102, 
  77, 77, 82, 86, 86, 88, 83, 102, 88, 87, 
  86, 80, 85, 84, 87, 83, 81, 80, 77, 72, 
  88, 73, 87, 85, 87, 84, 87, 72, 91, 82, 
  87, 84, 79, 79, 88, 81, 74, 90, 86, 80, 
  77, 79, 87, 73, 79, 87, 81, 78, 76, 72, 
  90, 83, 81, 82, 84, 84, 99, 69, 86, 82, 
  79, 70, 82, 90, 81, 76, 79, 88, 86, 93, 
  78, 82, 77, 75, 79, 84, 83, 76, 79, 73, 
  84, 76, 65, 78, 78, 79, 86, 77, 87, 78, 
  78, 82, 92, 85, 84, 92, 93, 85, 94, 83, 
  83, 84, 87, 72, 84, 71, 74, 53, 75, 90, 
  81, 99, 70, 77, 86, 94, 72, 85, 98, 97, 
  107, 71, 91, 87, 88, 72, 95, 88, 89, 97, 
  94, 81, 91, 100, 87, 97, 82, 72, 78, 82, 
  88, 83, 79, 97, 92, 87, 80, 84, 94, 75, 
  74, 86, 96, 92, 79, 73, 78, 81, 82, 81, 
  84, 86, 83, 70, 78, 93, 87, 84, 89, 68, 
  78, 94, 75, 81, 81, 93, 92, 86, 83, 82, 
  87, 83, 76, 82, 72, 81, 88, 83, 65, 76, 
  99, 93, 69, 86, 96, 79, 104, 76, 91, 88, 
  95, 76, 82, 97, 88, 85, 72, 103, 72, 85, 
  68, 100, 83, 73, 81, 86, 59, 81, 89, 71, 
  75, 68, 96, 87, 92, 82, 101, 95, 83, 91, 
  98, 82, 87, 67, 77, 46, 81, 76, 86, 91, 
  70, 83, 92, 89, 74, 92, 90, 113, 89, 81, 
  94, 73, 90, 69, 102, 88, 84, 121, 102, 71, 
  89, 83, 91, 125, 89, 78, 80, 73, 94, 90, 
  73, 113, 110, 87, 85, 81, 83, 77, 79, 93, 
  87, 85, 78, 74, 73, 74, 83, 80, 81, 91, 
  70, 70, 85, 85, 90, 80, 85, 61, 62, 91, 
  80, 72, 98, 97, 84, 92, 84, 84, 89, 79, 
  70, 79, 72, 82, 84, 79, 57, 84, 86, 101, 
  53, 86, 111, 89, 98, 77, 83, 83, 111, 73, 
  99, 93, 82, 80, 75, 95, 78, 91, 63, 72, 
  85, 68, 87, 86, 44, 77, 90, 70, 72, 59, 
  98, 82, 94, 89, 90, 87, 79, 83, 90, 93, 
  87, 76, 73, 61, 79, 90, 86, 84, 74, 73, 
  84, 94, 76, 91, 84, 90, 75, 69, 93, 90, 
  82, 72, 88, 95, 92, 108, 91, 87, 87, 86, 
  89, 94, 90, 73, 77, 82, 90, 77, 81, 96, 
  88, 87, 76, 86, 93, 78, 77, 86, 85, 85, 
  73, 75, 76, 80, 86, 76, 92, 79, 78, 76, 
  77, 97, 75, 81, 84, 72, 89, 86, 75, 91, 
  73, 83, 82, 85, 86, 87, 80, 93, 85, 79, 
  97, 87, 91, 83, 70, 96, 96, 93, 80, 86, 
  90, 77, 82, 74, 88, 81, 89, 77, 74, 98, 
  81, 83, 74, 104, 83, 80, 76, 78, 79, 79, 
  94, 84, 63, 84, 83, 75, 81, 76, 94, 97, 
  89, 78, 91, 83, 71, 79, 88, 75, 88, 88, 
  82, 74, 77, 90, 73, 104, 75, 87, 88, 94, 
  69, 83, 89, 94, 88, 75, 82, 86, 82, 81, 
  96, 84, 84, 97, 85, 86, 88, 98, 88, 101, 
  80, 72, 79, 75, 79, 81, 69, 89, 89, 78, 
  87, 88, 92, 75, 80, 79, 91, 93, 83, 76, 
  87, 85, 78, 76, 81, 86, 84, 76, 72, 87, 
  95, 83, 90, 72, 92, 83, 80, 82, 91, 89, 
  91, 82, 86, 73, 83, 82, 82, 77, 73, 86, 
  94, 81, 80, 70, 95, 96, 82, 91, 96, 82, 
  100, 77, 86, 90, 96, 80, 71, 97, 91, 84, 
  74, 97, 76, 88, 70, 104, 81, 79, 78, 100, 
  66, 78, 85, 82, 74, 76, 94, 77, 70, 78, 
  98, 87, 77, 92, 97, 78, 92, 83, 80, 73, 
  81, 81, 72, 90, 76, 88, 91, 96, 70, 89, 
  78, 109, 82, 77, 85, 71, 83, 77, 98, 92, 
  80, 116, 85, 82, 93, 87, 91, 139, 94, 70, 
  84, 63, 81, 87, 58, 93, 108, 73, 97, 83, 
  81, 82, 87, 79, 86, 85, 87, 76, 84, 81, 
  84, 80, 80, 91, 75, 74, 77, 87, 109, 80, 
  84, 65, 82, 75, 83, 76, 99, 87, 89, 76, 
  89, 72, 88, 86, 79, 77, 72, 90, 93, 77, 
  71, 67, 82, 106, 73, 93, 98, 90, 94, 74, 
  72, 79, 106, 76, 67, 111, 86, 79, 73, 90, 
  73, 101, 65, 75, 82, 78, 84, 100, 58, 78, 
  88, 77, 73, 68, 95, 76, 71, 76, 83, 80, 
  79, 81, 87, 78, 90, 85, 83, 80, 80, 89, 
  78, 81, 79, 83, 83, 91, 72, 83, 76, 92, 
  72, 73, 83, 88, 79, 81, 89, 89, 82, 96, 
  85, 84, 87, 87, 85, 105, 90, 74, 81, 77, 
  87, 79, 72, 88, 90, 86, 81, 86, 91, 81, 
  82, 79, 86, 82, 77, 74, 88, 83, 80, 71, 
  84, 78, 77, 81, 79, 95, 84, 82, 77, 77, 
  94, 81, 78, 85, 81, 80, 73, 82, 89, 83, 
  76, 93, 85, 78, 98, 93, 96, 82, 86, 84, 
  95, 94, 82, 95, 93, 81, 84, 78, 86, 74, 
  91, 78, 66, 95, 89, 83, 73, 97, 86, 79, 
  74, 77, 83, 85, 92, 100, 74, 80, 83, 87, 
  76, 77, 94, 88, 74, 77, 87, 82, 62, 80, 
  79, 78, 79, 89, 85, 91, 73, 85, 73, 98, 
  84, 81, 83, 84, 70, 81, 86, 87, 72, 71, 
  81, 97, 70, 78, 79, 80, 88, 88, 81, 93, 
  84, 81, 96, 96, 87, 78, 80, 70, 88, 76, 
  77, 72, 95, 87, 91, 88, 92, 67, 80, 80, 
  91, 86, 85, 85, 90, 86, 75, 79, 89, 98, 
  79, 89, 79, 87, 88, 84, 84, 71, 99, 79, 
  75, 79, 77, 83, 88, 83, 83, 79, 87, 88, 
  94, 66, 76, 92, 93, 89, 101, 72, 90, 94, 
  93, 87, 94, 86, 89, 81, 86, 89, 91, 84, 
  65, 80, 84, 94, 89, 87, 82, 81, 68, 85, 
  78, 92, 73, 99, 85, 77, 87, 90, 74, 84, 
  91, 96, 72, 94, 87, 88, 72, 88, 85, 72, 
  90, 86, 80, 84, 76, 80, 73, 94, 81, 79, 
  85, 88, 75, 88, 82, 89, 77, 74, 86, 89, 
  67, 73, 95, 87, 89, 89, 82, 86, 80, 78, 
  90, 103, 94, 80, 82, 64, 80, 84, 66, 68, 
  111, 73, 95, 91, 85, 82, 88, 74, 85, 79, 
  89, 88, 98, 84, 80, 83, 92, 93, 72, 86, 
  82, 86, 102, 78, 77, 65, 95, 78, 76, 81, 
  79, 80, 91, 72, 84, 81, 84, 87, 98, 68, 
  73, 100, 97, 87, 95, 68, 95, 101, 93, 92, 
  91, 86, 89, 72, 77, 80, 84, 81, 45, 82, 
  90, 92, 86, 94, 77, 90, 64, 81, 81, 98, 
  80, 103, 82, 74, 94, 85, 80, 78, 94, 100, 
  67, 91, 88, 84, 75, 81, 76, 74, 78, 89, 
  81, 92, 75, 83, 77, 90, 85, 77, 82, 83, 
  65, 86, 83, 91, 84, 72, 81, 92, 70, 81, 
  75, 87, 85, 85, 81, 79, 84, 88, 89, 98, 
  90, 80, 82, 72, 85, 80, 82, 75, 91, 86, 
  88, 86, 89, 76, 80, 80, 86, 74, 84, 86, 
  90, 83, 78, 79, 87, 87, 79, 90, 86, 93, 
  83, 88, 67, 76, 93, 80, 74, 80, 75, 85, 
  76, 84, 82, 84, 83, 85, 96, 68, 77, 93, 
  90, 89, 103, 74, 94, 90, 88, 90, 94, 81, 
  88, 82, 88, 78, 92, 83, 68, 86, 78, 91, 
  85, 82, 90, 80, 71, 81, 84, 93, 88, 99, 
  88, 80, 97, 87, 72, 84, 90, 93, 76, 93, 
  96, 69, 80, 88, 89, 84, 81, 87, 80, 84, 
  89, 84, 80, 74, 85, 69, 79, 77, 80, 90, 
  91, 82, 81, 83, 92, 77, 87, 82, 91, 81, 
  81, 77, 71, 91, 76, 87, 76, 86, 93, 80, 
  78, 95, 88, 91, 89, 93, 85, 80, 80, 79, 
  97, 86, 82, 80, 87, 221, 79, 86, 83, 84, 
  87, 78, 78, 85, 88, 84, 79, 94, 83, 75, 
  92, 84, 79, 81, 90, 78, 75, 103, 92, 87, 
  77, 87, 85, 80, 86, 87, 87, 92, 75, 80, 
  74, 85, 78, 85, 94, 87, 82, 84, 105, 85, 
  78, 81, 83, 94, 93, 88, 83, 90, 95, 86, 
  79, 81, 92, 83, 69, 97, 89, 87, 84, 82, 
  87, 87, 82, 80, 88, 85, 86, 88, 83, 79, 
  84, 88, 86, 73, 82, 90, 89, 87, 83, 93, 
  77, 75, 82, 85, 78, 80, 86, 92, 87, 76, 
  78, 82, 83, 74, 101, 81, 87, 82, 75, 83, 
  73, 82, 79, 80, 86, 84, 67, 76, 85, 86, 
  86, 93, 86, 85, 86, 81, 75, 77, 99, 82, 
  82, 79, 83, 159, 79, 88, 82, 84, 82, 74, 
  87, 74, 87, 78, 72, 83, 73, 84, 69, 76, 
  92, 86, 89, 82, 76, 84, 90, 85, 84, 92, 
  86, 92, 75, 86, 85, 81, 82, 81, 75, 95, 
  78, 79, 89, 78, 83, 83, 85, 79, 85, 82, 
  78, 91, 90, 82, 88, 90, 91, 87, 78, 79, 
  90, 85, 80, 74, 79, 85, 75, 84, 86, 82, 
  82, 81, 79, 83, 81, 85, 87, 82, 97, 81, 
  89, 74, 80, 81, 85, 83, 87, 88, 85, 78, 
  86, 89, 80, 87, 90, 99, 88, 81, 82, 81, 
  81, 80, 93, 78, 92, 88, 84, 84, 77, 86, 
  79, 86, 87, 89, 70, 88, 93, 83, 87, 91, 
  85, 78, 88, 89, 74, 88, 88, 76, 82, 80, 
  77, 87, 82, 87, 83, 84, 88, 87, 88, 90, 
  85, 72, 83, 87, 80, 98, 72, 85, 85, 93, 
  90, 84, 79, 86, 82, 77, 88, 83, 84, 95, 
  93, 88, 91, 88, 79, 77, 74, 90, 85, 81, 
  90, 78, 84, 89, 72, 71, 80, 86, 79, 92, 
  85, 87, 85, 85, 85, 86, 89, 85, 82, 82, 
  94, 77, 82, 88, 87, 81, 79, 86, 81, 82, 
  84, 86, 84, 90, 87, 74, 80, 91, 84, 79, 
  85, 84, 81, 85, 91, 84, 80, 76, 89, 81, 
  84, 82, 85, 89, 89, 80, 76, 84, 86, 81, 
  85, 83, 88, 81, 75, 81, 84, 86, 88, 89, 
  78, 86, 83, 86, 78, 77, 83, 85, 85, 94, 
  74, 84, 79, 94, 93, 82, 86, 84, 85, 115, 
  79, 81, 86, 92, 85, 84, 83, 84, 84, 83, 
  78, 92, 85, 70, 80, 79, 83, 81, 82, 84, 
  77, 82, 86, 87, 82, 77, 87, 84, 82, 87, 
  87, 81, 76, 92, 79, 80, 86, 92, 87, 81, 
  83, 84, 91, 82, 80, 89, 83, 90, 79, 83, 
  90, 84, 83, 82, 81, 81, 86, 87, 70, 77, 
  82, 83, 82, 81, 88, 90, 88, 87, 87, 84, 
  82, 84, 88, 83, 90, 89, 83, 72, 80, 81, 
  84, 87, 84, 87, 78, 87, 82, 84, 79, 76, 
  85, 90, 81, 74, 80, 89, 81, 74, 94, 83, 
  83, 86, 81, 89, 85, 78, 88, 83, 86, 89, 
  73, 80, 83, 87, 86, 86, 83, 85, 88, 90, 
  82, 89, 96, 79, 88, 83, 85, 110, 81, 85, 
  87, 80, 80, 76, 85, 78, 81, 81, 78, 80, 
  81, 71, 53, 77, 83, 83, 85, 79, 85, 77, 
  83, 84, 86, 81, 83, 91, 83, 83, 79, 81, 
  86, 91, 72, 79, 79, 82, 77, 78, 86, 79, 
  88, 78, 78, 92, 87, 89, 83, 80, 91, 87, 
  92, 81, 84, 78, 90, 79, 79, 73, 72, 82, 
  80, 89, 85, 85, 80, 84, 81, 82, 82, 88, 
  89, 82, 90, 84, 91, 79, 77, 75, 78, 82, 
  90, 83, 79, 82, 83, 78, 74, 75, 87, 97, 
  86, 82, 79, 86, 83, 77, 92, 79, 91, 87, 
  93, 88, 82, 89, 89, 90, 85, 93, 73, 91, 
  90, 91, 87, 85, 83, 76, 98, 98, 88, 90, 
  94, 76, 86, 81, 78, 77, 83, 86, 84, 79, 
  85, 89, 82, 89, 75, 80, 82, 90, 86, 80, 
  51, 88, 78, 86, 91, 78, 85, 85, 83, 81, 
  86, 85, 85, 89, 93, 85, 85, 94, 81, 79, 
  74, 73, 85, 79, 83, 83, 85, 86, 83, 76, 
  73, 87, 89, 92, 88, 81, 91, 82, 92, 82, 
  92, 86, 85, 74, 87, 83, 80, 84, 87, 92, 
  81, 85, 77, 79, 85, 85, 83, 95, 94, 84, 
  79, 82, 84, 86, 84, 75, 75, 88, 90, 81, 
  90, 92, 82, 75, 78, 79, 84, 89, 81, 83, 
  75, 85, 84, 77, 81, 85, 86, 91, 81, 82, 
  83, 85, 98, 84, 86, 87, 97, 82, 80, 94, 
  76, 83, 85, 82, 83, 86, 78, 99, 91, 81, 
  82, 83, 88, 83, 79, 78, 84, 84, 83, 79, 
  83, 82, 85, 96, 80, 82, 82, 80, 94, 84, 
  72, 81, 84, 81, 79, 78, 76, 92, 80, 76, 
  82, 83, 88, 88, 81, 84, 88, 86, 73, 77, 
  83, 85, 85, 76, 84, 78, 86, 81, 85, 88, 
  87, 90, 84, 84, 88, 84, 82, 81, 79, 80, 
  82, 80, 93, 77, 78, 82, 87, 84, 84, 88, 
  77, 88, 86, 81, 81, 93, 87, 92, 98, 87, 
  88, 76, 83, 75, 82, 87, 87, 78, 83, 101, 
  80, 77, 78, 78, 91, 90, 77, 76, 86, 88, 
  83, 80, 85, 85, 84, 93, 83, 85, 85, 77, 
  96, 79, 82, 86, 85, 84, 82, 87, 81, 82, 
  82, 87, 85, 86, 82, 98, 87, 78, 84, 85, 
  87, 76, 77, 78, 86, 79, 81, 86, 82, 77, 
  82, 88, 84, 74, 78, 78, 66, 75, 78, 86, 
  83, 80, 83, 76, 78, 90, 83, 72, 83, 84, 
  88, 87, 79, 83, 90, 87, 72, 81, 84, 89, 
  80, 83, 87, 78, 79, 81, 79, 88, 84, 86, 
  81, 75, 87, 82, 85, 81, 89, 79, 84, 78, 
  90, 73, 70, 82, 83, 86, 84, 88, 78, 88, 
  86, 82, 84, 91, 84, 86, 98, 90, 91, 83, 
  84, 73, 78, 84, 87, 75, 78, 88, 84, 76, 
  74, 81, 89, 94, 83, 86, 90, 87, 85, 82, 
  86, 83, 91, 84, 83, 84, 89, 83, 85, 90, 
  71, 87, 78, 94, 85, 76, 85, 84, 83, 82, 
  86, 88, 89, 101, 84, 78, 85, 81, 81, 62, 
  83, 75, 82, 80, 85, 93, 78, 76, 86, 81, 
  85, 84, 80, 79, 62, 81, 80, 89, 87, 84, 
  83, 81, 80, 84, 82, 73, 86, 88, 87, 89, 
  90, 83, 77, 83, 81, 75, 89, 87, 85, 91, 
  86, 81, 80, 79, 77, 89, 80, 89, 81, 74, 
  96, 78, 85, 77, 92, 85, 83, 81, 75, 77, 
  80, 82, 83, 85, 85, 88, 77, 83, 89, 86, 
  82, 91, 88, 68, 98, 87, 79, 76, 91, 83, 
  68, 85, 78, 81, 100, 90, 80, 92, 85, 81, 
  78, 94, 80, 93, 85, 85, 90, 87, 70, 84, 
  88, 99, 99, 84, 79, 85, 92, 80, 69, 82, 
  92, 83, 77, 73, 95, 98, 91, 87, 92, 94, 
  80, 83, 95, 78, 85, 85, 73, 81, 79, 80, 
  81, 98, 80, 81, 96, 74, 82, 76, 84, 81, 
  79, 94, 95, 82, 88, 82, 89, 72, 81, 95, 
  87, 87, 83, 72, 97, 82, 79, 79, 88, 86, 
  73, 102, 82, 86, 79, 75, 76, 101, 86, 85, 
  83, 87, 80, 76, 102, 73, 89, 77, 79, 94, 
  86, 62, 85, 89, 81, 81, 79, 73, 96, 88, 
  85, 83, 93, 70, 65, 82, 95, 97, 84, 75, 
  80, 84, 77, 82, 81, 75, 94, 75, 56, 84, 
  88, 87, 105, 96, 78, 86, 87, 78, 85, 115, 
  89, 88, 80, 76, 82, 77, 56, 78, 98, 99, 
  94, 87, 60, 97, 84, 76, 61, 74, 93, 75, 
  74, 63, 89, 122, 105, 71, 81, 82, 66, 60, 
  102, 61, 75, 81, 54, 86, 76, 81, 72, 112, 
  92, 76, 100, 81, 75, 76, 80, 88, 75, 78, 
  88, 81, 79, 80, 98, 59, 77, 86, 93, 83, 
  83, 93, 89, 84, 97, 78, 82, 91, 69, 104, 
  81, 92, 79, 70, 81, 137, 87, 86, 84, 81, 
  70, 90, 96, 71, 81, 69, 84, 115, 84, 68, 
  87, 77, 76, 79, 77, 60, 81, 94, 92, 79, 
  92, 70, 40, 76, 90, 96, 86, 61, 85, 98, 
  90, 89, 72, 84, 86, 85, 69, 85, 78, 86, 
  95, 87, 80, 90, 88, 77, 80, 88, 86, 96, 
  70, 81, 79, 88, 78, 81, 84, 96, 93, 83, 
  77, 76, 95, 78, 75, 78, 86, 82, 75, 74, 
  79, 92, 94, 84, 86, 87, 76, 83, 94, 84, 
  81, 89, 77, 80, 81, 80, 80, 97, 86, 84, 
  92, 69, 82, 80, 73, 78, 79, 86, 91, 89, 
  86, 82, 89, 73, 84, 87, 93, 90, 82, 68, 
  96, 84, 78, 81, 83, 83, 71, 97, 83, 96, 
  87, 77, 87, 96, 88, 84, 94, 88, 82, 90, 
  97, 71, 89, 78, 73, 89, 84, 70, 94, 90, 
  83, 92, 71, 74, 98, 87, 88, 83, 91, 74, 
  68, 81, 90, 94, 83, 83, 103, 70, 81, 83, 
  78, 79, 91, 78, 66, 86, 95, 88, 91, 76, 
  74, 98, 82, 74, 87, 86, 84, 88, 86, 92, 
  83, 88, 79, 88, 91, 94, 94, 76, 88, 94, 
  96, 89, 75, 69, 99, 70, 65, 76, 94, 80, 
  91, 96, 81, 102, 74, 76, 100, 75, 86, 91, 
  74, 98, 69, 76, 86, 98, 85, 84, 81, 79, 
  72, 77, 77, 78, 73, 73, 112, 87, 82, 79, 
  85, 76, 80, 89, 87, 85, 84, 77, 95, 83, 
  83, 84, 87, 89, 75, 92, 76, 71, 81, 72, 
  80, 98, 85, 83, 82, 94, 72, 85, 95, 76, 
  91, 89, 80, 79, 82, 73, 85, 85, 77, 86, 
  71, 71, 77, 80, 73, 80, 88, 75, 72, 77, 
  88, 84, 89, 76, 96, 87, 77, 82, 77, 69, 
  93, 70, 55, 93, 120, 90, 103, 93, 71, 109, 
  88, 75, 105, 106, 97, 77, 69, 88, 69, 72, 
  70, 85, 101, 101, 93, 80, 70, 104, 92, 81, 
  66, 75, 91, 50, 60, 66, 105, 96, 105, 81, 
  66, 81, 59, 51, 115, 63, 71, 84, 45, 88, 
  69, 79, 65, 140, 94, 73, 73, 93, 56, 75, 
  72, 94, 65, 60, 80, 85, 74, 84, 85, 65, 
  77, 90, 95, 83, 86, 99, 87, 85, 104, 93, 
  80, 96, 70, 99, 79, 72, 73, 60, 84, 122, 
  80, 84, 74, 91, 73, 78, 96, 79, 84, 74, 
  82, 105, 76, 73, 95, 70, 65, 79, 80, 60, 
  73, 77, 71, 83, 95, 77, 36, 66, 81, 84, 
  96, 68, 96, 98, 99, 85, 74, 91, 90, 78, 
  67, 88, 89, 92, 87, 99, 74, 89, 83, 70, 
  90, 82, 85, 101, 70, 87, 72, 90, 83, 84, 
  88, 97, 95, 86, 84, 82, 95, 87, 80, 72, 
  82, 71, 56, 74, 82, 84, 96, 88, 77, 81, 
  77, 76, 98, 92, 80, 94, 76, 66, 72, 74, 
  79, 93, 89, 84, 79, 69, 73, 76, 76, 80, 
  78, 78, 75, 93, 78, 78, 85, 78, 86, 91, 
  84, 85, 84, 73, 95, 88, 82, 87, 83, 86, 
  74, 89, 78, 77, 80, 70, 82, 95, 87, 81, 
  89, 95, 74, 71, 94, 78, 86, 91, 76, 78, 
  77, 77, 97, 84, 79, 92, 83, 79, 106, 79, 
  76, 86, 90, 79, 74, 80, 83, 83, 90, 84, 
  96, 74, 82, 85, 73, 84, 79, 86, 84, 81, 
  84, 95, 83, 87, 64, 105, 82, 77, 95, 82, 
  87, 93, 82, 101, 78, 89, 94, 84, 77, 92, 
  84, 78, 87, 78, 100, 92, 87, 78, 97, 79, 
  75, 73, 73, 72, 76, 100, 86, 91, 79, 98, 
  89, 84, 96, 95, 99, 94, 74, 80, 108, 81, 
  86, 89, 80, 87, 81, 78, 75, 77, 75, 89, 
  93, 88, 83, 76, 85, 81, 86, 87, 87, 60, 
  80, 65, 96, 74, 66, 98, 84, 80, 91, 89, 
  77, 80, 91, 82, 85, 72, 82, 75, 92, 96, 
  78, 93, 87, 73, 103, 98, 75, 69, 77, 89, 
  92, 86, 90, 84, 76, 92, 69, 75, 77, 72, 
  98, 83, 89, 83, 83, 82, 86, 88, 94, 79, 
  76, 87, 65, 70, 79, 79, 82, 86, 102, 97, 
  86, 95, 72, 106, 81, 83, 104, 77, 83, 85, 
  70, 100, 76, 75, 98, 84, 90, 95, 84, 86, 
  100, 78, 104, 74, 84, 82, 91, 65, 69, 62, 
  89, 72, 76, 100, 75, 81, 67, 97, 91, 95, 
  92, 92, 87, 93, 69, 85, 94, 94, 89, 81, 
  63, 93, 73, 73, 72, 81, 65, 82, 87, 78, 
  80, 77, 82, 75, 88, 75, 94, 50, 82, 67, 
  97, 87, 70, 98, 80, 83, 95, 102, 72, 75, 
  86, 79, 84, 73, 92, 76, 80, 96, 82, 79, 
  82, 76, 106, 110, 76, 75, 77, 90, 107, 82, 
  86, 79, 80, 94, 73, 70, 66, 77, 96, 84, 
  81, 79, 72, 86, 86, 103, 88, 83, 87, 82, 
  77, 82, 81, 80, 81, 86, 82, 95, 81, 96, 
  68, 103, 80, 75, 91, 77, 72, 94, 80, 101, 
  81, 91, 92, 82, 76, 93, 89, 87, 89, 87, 
  99, 77, 87, 75, 78, 81, 71, 72, 91, 79, 
  76, 97, 86, 89, 79, 99, 88, 88, 95, 96, 
  96, 80, 75, 82, 96, 82, 91, 89, 77, 79, 
  81, 76, 79, 80, 71, 89, 70, 86, 79, 72, 
  86, 84, 85, 80, 90, 58, 85, 64, 89, 97, 
  67, 93, 85, 82, 90, 93, 76, 75, 89, 85, 
  90, 76, 79, 74, 85, 93, 80, 70, 89, 74, 
  108, 97, 74, 74, 82, 94, 92, 84, 91, 85, 
  83, 98, 94, 77, 80, 76, 84, 83, 93, 86, 
  85, 86, 91, 89, 81, 79, 81, 76, 72, 78, 
  79, 86, 89, 76, 87, 83, 76, 84, 75, 81, 
  73, 86, 89, 80, 89, 74, 88, 79, 80, 79, 
  92, 86, 101, 79, 91, 82, 99, 76, 79, 95, 
  82, 79, 82, 73, 91, 83, 78, 87, 80, 93, 
  71, 87, 84, 84, 82, 87, 68, 92, 97, 80, 
  78, 84, 76, 76, 75, 83, 79, 85, 92, 89, 
  81, 84, 84, 85, 85, 78, 73, 73, 89, 84, 
  101, 84, 82, 87, 76, 78, 86, 77, 85, 80, 
  81, 76, 82, 85, 95, 77, 78, 86, 77, 85, 
  87, 88, 85, 96, 94, 80, 84, 73, 91, 75, 
  75, 86, 80, 71, 79, 92, 90, 81, 89, 89, 
  85, 81, 86, 88, 89, 87, 81, 76, 91, 83, 
  88, 94, 80, 80, 83, 80, 74, 78, 74, 90, 
  98, 71, 94, 76, 75, 83, 75, 81, 73, 82, 
  102, 86, 79, 76, 80, 75, 87, 73, 94, 85, 
  93, 79, 82, 93, 111, 79, 77, 83, 85, 72, 
  83, 74, 86, 84, 76, 85, 71, 90, 72, 86, 
  86, 93, 92, 87, 68, 98, 107, 85, 88, 76, 
  68, 72, 80, 95, 82, 90, 91, 89, 79, 80, 
  81, 90, 82, 76, 76, 73, 85, 99, 114, 83, 
  82, 91, 80, 75, 89, 80, 82, 83, 88, 76, 
  78, 77, 106, 82, 80, 78, 82, 81, 104, 86, 
  79, 95, 96, 86, 86, 73, 84, 72, 79, 86, 
  81, 77, 72, 99, 93, 86, 86, 91, 85, 77, 
  81, 93, 81, 88, 84, 77, 99, 83, 85, 98, 
  83, 78, 82, 72, 72, 85, 78, 86, 85, 75, 
  83, 82, 78, 83, 74, 80, 79, 87, 87, 82, 
  81, 76, 76, 78, 85, 79, 93, 84, 99, 83, 
  90, 91, 97, 84, 78, 81, 85, 79, 80, 73, 
  87, 80, 88, 85, 77, 91, 73, 86, 82, 80, 
  84, 88, 70, 92, 97, 86, 79, 85, 74, 80, 
  79, 83, 82, 82, 97, 90, 80, 87, 83, 86, 
  89, 73, 78, 71, 86, 77, 96, 81, 80, 84, 
  77, 74, 88, 86, 83, 81, 82, 76, 84, 86, 
  93, 80, 80, 88, 73, 84, 81, 86, 80, 90, 
  91, 85, 84, 78, 88, 75, 74, 90, 78, 73, 
  79, 90, 92, 82, 80, 92, 82, 81, 86, 90, 
  78, 82, 80, 77, 86, 82, 85, 91, 79, 80, 
  82, 79, 77, 77, 74, 84, 98, 73, 101, 82, 
  74, 85, 78, 76, 73, 81, 97, 80, 86, 82, 
  86, 79, 85, 75, 81, 90, 84, 78, 74, 86, 
  108, 71, 82, 98, 76, 84, 79, 66, 77, 87, 
  78, 82, 73, 95, 73, 85, 84, 85, 88, 87, 
  67, 101, 104, 87, 84, 77, 76, 73, 74, 96, 
  76, 81, 89, 84, 74, 84, 94, 78, 85, 74, 
  79, 77, 92, 90, 112, 91, 80, 81, 82, 75, 
  88, 73, 89, 82, 79, 78, 78, 71, 98, 80, 
  80, 78, 85, 90, 105, 90, 90, 96, 92, 76, 
  82, 75, 83, 82, 80, 79, 78, 76, 80, 92, 
  93, 81, 80, 87, 87, 76, 80, 99, 91, 91, 
  81, 76, 92, 81, 88, 100, 77, 77, 90, 83, 
  79, 85, 72, 88, 120, 71, 109, 72, 75, 83, 
  84, 72, 70, 78, 118, 81, 82, 84, 82, 78, 
  88, 70, 86, 99, 81, 81, 62, 103, 126, 70, 
  82, 85, 77, 79, 83, 68, 70, 86, 76, 76, 
  72, 100, 71, 86, 81, 101, 101, 101, 61, 108, 
  123, 85, 83, 75, 69, 67, 69, 114, 73, 90, 
  88, 93, 68, 75, 94, 78, 80, 69, 89, 84, 
  83, 106, 135, 82, 79, 85, 81, 74, 91, 87, 
  90, 83, 85, 79, 79, 67, 106, 79, 80, 67, 
  99, 89, 127, 90, 83, 105, 96, 81, 85, 77, 
  73, 83, 83, 76, 78, 82, 79, 92, 99, 84, 
  79, 90, 88, 73, 76, 101, 81, 92, 78, 70, 
  100, 80, 87, 112, 78, 76, 87, 75, 79, 85, 
  72, 89, 97, 72, 96, 84, 76, 79, 78, 76, 
  79, 85, 97, 83, 84, 76, 76, 82, 85, 75, 
  80, 89, 81, 87, 80, 97, 103, 82, 79, 82, 
  82, 80, 84, 69, 76, 82, 83, 83, 75, 94, 
  80, 88, 84, 82, 88, 86, 68, 101, 102, 82, 
  80, 82, 72, 80, 76, 93, 76, 80, 86, 84, 
  77, 85, 90, 79, 93, 73, 80, 81, 90, 87, 
  103, 73, 77, 80, 80, 77, 92, 98, 91, 81, 
  81, 80, 80, 80, 101, 78, 84, 81, 79, 87, 
  97, 88, 79, 94, 92, 82, 85, 79, 78, 80, 
  78, 82, 79, 77, 84, 88, 98, 81, 78, 85, 
  85, 76, 79, 94, 76, 88, 81, 78, 90, 82, 
  86, 95, 78, 87, 83, 74, 71, 77, 80, 88, 
  89, 72, 88, 93, 81, 85, 77, 75, 76, 84, 
  83, 81, 81, 83, 78, 78, 87, 78, 84, 84, 
  90, 77, 74, 86, 100, 77, 78, 98, 83, 87, 
  74, 75, 79, 85, 78, 83, 77, 93, 80, 91, 
  87, 72, 87, 88, 72, 101, 96, 85, 83, 74, 
  79, 74, 78, 84, 83, 81, 87, 85, 76, 88, 
  88, 80, 83, 80, 71, 80, 93, 80, 97, 83, 
  83, 84, 83, 85, 94, 80, 89, 84, 77, 75, 
  79, 75, 91, 80, 80, 82, 85, 90, 84, 86, 
  93, 98, 90, 76, 80, 78, 83, 79, 75, 80, 
  75, 75, 83, 92, 90, 82, 85, 90, 78, 79, 
  82, 92, 90, 85, 82, 78, 83, 80, 87, 85, 
  81, 84, 91, 78, 75, 79, 76, 91, 97, 72, 
  92, 85, 84, 80, 80, 69, 72, 84, 95, 82, 
  82, 81, 78, 75, 88, 75, 91, 91, 85, 78, 
  70, 98, 113, 74, 76, 88, 82, 86, 81, 75, 
  70, 85, 83, 84, 79, 93, 82, 90, 84, 81, 
  92, 90, 70, 102, 103, 82, 81, 72, 66, 74, 
  73, 88, 79, 88, 90, 89, 73, 84, 89, 84, 
  85, 76, 71, 87, 89, 89, 105, 87, 81, 84, 
  81, 87, 95, 93, 90, 84, 81, 73, 76, 76, 
  103, 80, 80, 77, 89, 87, 92, 88, 89, 100, 
  96, 76, 79, 77, 75, 85, 80, 81, 78, 77, 
  81, 91, 94, 82, 84, 88, 84, 75, 76, 89, 
  81, 88, 82, 74, 92, 79, 87, 91, 77, 80, 
  84, 72, 75, 74, 79, 92, 90, 73, 83, 93, 
  82, 75, 76, 77, 79, 85, 87, 76, 84, 77, 
  73, 78, 90, 78, 82, 84, 88, 81, 83, 94, 
  91, 83, 78, 83, 85, 82, 82, 78, 77, 83, 
  82, 83, 77, 92, 87, 87, 87, 70, 85, 82, 
  71, 98, 96, 82, 76, 78, 75, 76, 80, 87, 
  82, 80, 79, 86, 82, 87, 85, 83, 88, 81, 
  69, 81, 93, 80, 97, 86, 82, 84, 77, 87, 
  94, 95, 93, 82, 82, 79, 83, 85, 92, 82, 
  84, 87, 83, 89, 78, 87, 85, 101, 91, 76, 
  83, 79, 81, 79, 75, 84, 79, 73, 83, 87, 
  91, 78, 87, 93, 79, 80, 82, 89, 83, 87, 
  83, 80, 83, 80, 86, 81, 87, 76, 82, 89, 
  80, 75, 102, 87, 106, 81, 77, 94, 67, 91, 
  117, 78, 76, 84, 74, 72, 78, 69, 73, 80, 
  91, 70, 92, 88, 94, 62, 85, 74, 80, 88, 
  75, 83, 72, 85, 96, 88, 70, 130, 77, 94, 
  101, 75, 81, 86, 67, 101, 83, 76, 91, 94, 
  78, 82, 84, 63, 80, 88, 67, 77, 81, 105, 
  93, 104, 79, 89, 73, 97, 75, 86, 79, 67, 
  93, 86, 112, 82, 73, 76, 93, 89, 93, 78, 
  91, 84, 75, 79, 82, 75, 91, 81, 86, 76, 
  70, 86, 74, 96, 79, 77, 98, 67, 90, 74, 
  85, 86, 86, 90, 77, 88, 86, 93, 88, 92, 
  74, 80, 95, 76, 76, 64, 95, 83, 67, 82, 
  72, 78, 88, 77, 95, 83, 80, 87, 85, 79, 
  94, 83, 91, 82, 82, 90, 69, 91, 111, 82, 
  76, 89, 75, 79, 73, 78, 70, 81, 86, 76, 
  91, 90, 80, 69, 83, 74, 83, 85, 77, 82, 
  74, 85, 95, 91, 78, 114, 75, 92, 107, 74, 
  79, 85, 77, 108, 79, 79, 83, 90, 82, 79, 
  73, 72, 82, 96, 75, 79, 81, 94, 89, 106, 
  80, 96, 77, 104, 74, 95, 81, 66, 95, 77, 
  110, 73, 80, 71, 94, 81, 92, 74, 90, 75, 
  82, 73, 78, 87, 81, 86, 88, 88, 75, 85, 
  72, 108, 83, 73, 102, 79, 86, 80, 86, 88, 
  78, 85, 78, 87, 85, 100, 89, 84, 73, 75, 
  82, 78, 76, 59, 80, 84, 54, 79, 76, 82, 
  85, 85, 85, 89, 75, 88, 86, 85, 94, 87, 
  99, 82, 78, 99, 68, 97, 111, 79, 75, 81, 
  79, 72, 79, 74, 69, 79, 82, 73, 91, 86, 
  92, 71, 82, 73, 82, 86, 74, 104, 73, 82, 
  90, 88, 73, 122, 83, 93, 101, 75, 81, 88, 
  70, 100, 83, 77, 88, 95, 76, 84, 92, 62, 
  86, 85, 76, 76, 86, 102, 92, 101, 78, 90, 
  74, 91, 84, 83, 83, 70, 95, 85, 109, 75, 
  79, 74, 93, 84, 94, 85, 89, 78, 95, 75, 
  76, 89, 93, 84, 86, 76, 74, 83, 76, 95, 
  86, 81, 100, 76, 90, 74, 82, 83, 88, 89, 
  75, 86, 90, 89, 91, 81, 69, 77, 78, 79, 
  76, 69, 67, 81, 70, 82, 72, 78, 88, 79, 
  100, 79, 76, 88, 72, 84, 102, 92, 100, 86, 
  76, 85, 75, 100, 112, 74, 84, 87, 83, 76, 
  76, 59, 83, 80, 89, 71, 84, 89, 74, 63, 
  81, 70, 82, 88, 99, 86, 73, 84, 80, 78, 
  73, 127, 92, 90, 97, 78, 82, 90, 72, 97, 
  87, 80, 77, 95, 85, 79, 81, 66, 76, 93, 
  61, 80, 76, 93, 85, 106, 85, 76, 78, 87, 
  80, 92, 76, 79, 90, 82, 105, 90, 76, 77, 
  91, 87, 82, 78, 86, 81, 75, 80, 85, 64, 
  85, 70, 83, 82, 80, 95, 73, 96, 83, 70, 
  84, 72, 82, 73, 81, 83, 85, 92, 72, 87, 
  90, 96, 89, 86, 68, 88, 94, 78, 71, 72, 
  86, 88, 64, 77, 74, 76, 91, 90, 122, 85, 
  80, 90, 77, 84, 104, 86, 95, 95, 86, 79, 
  82, 84, 118, 87, 92, 83, 86, 84, 80, 70, 
  70, 88, 93, 86, 82, 94, 62, 79, 83, 83, 
  87, 92, 96, 76, 75, 95, 93, 89, 81, 152, 
  80, 91, 111, 82, 83, 93, 85, 117, 77, 94, 
  76, 92, 102, 80, 79, 83, 75, 111, 74, 76, 
  70, 120, 80, 126, 96, 92, 86, 89, 76, 118, 
  69, 75, 99, 79, 114, 75, 76, 78, 94, 83, 
  85, 66, 95, 82, 72, 75, 90, 71, 80, 66, 
  81, 106, 77, 105, 75, 112, 90, 69, 87, 82, 
  79, 78, 87, 88, 82, 85, 83, 89, 100, 101, 
  92, 71, 64, 85, 79, 85, 74, 71, 64, 99, 
  52, 69, 87, 76, 92, 115, 90, 86, 87, 87, 
  76, 99, 95, 89, 95, 87, 74, 85, 70, 80, 
  106, 83, 85, 86, 86, 74, 89, 57, 74, 76, 
  81, 74, 78, 86, 72, 89, 79, 80, 84, 81, 
  80, 100, 79, 85, 100, 84, 76, 115, 77, 89, 
  94, 80, 84, 96, 74, 95, 90, 82, 75, 94, 
  85, 81, 83, 65, 81, 89, 68, 77, 76, 87, 
  83, 102, 86, 80, 78, 84, 84, 86, 80, 77, 
  97, 84, 103, 83, 80, 78, 91, 86, 83, 93, 
  83, 80, 86, 76, 83, 80, 84, 73, 83, 83, 
  77, 91, 74, 95, 83, 74, 82, 77, 86, 74, 
  80, 81, 85, 88, 74, 84, 101, 92, 91, 76, 
  66, 88, 81, 80, 71, 72, 57, 89, 65, 80, 
  74, 79, 90, 92, 99, 85, 73, 86, 80, 81, 
  100, 99, 99, 85, 76, 95, 75, 98, 113, 77, 
  86, 83, 86, 78, 86, 73, 74, 77, 82, 69, 
  92, 87, 84, 69, 82, 70, 83, 90, 89, 86, 
  77, 84, 86, 77, 87, 135, 90, 99, 92, 79, 
  87, 94, 73, 89, 90, 81, 83, 94, 78, 88, 
  87, 65, 81, 88, 64, 82, 75, 98, 92, 111, 
  86, 72, 76, 88, 85, 83, 80, 83, 90, 83, 
  99, 82, 86, 72, 96, 78, 82, 71, 94, 76, 
  76, 79, 75, 76, 93, 75, 84, 84, 82, 93, 
  69, 92, 87, 75, 90, 73, 93, 71, 79, 79, 
  89, 106, 77, 83, 85, 94, 92, 83, 77, 82, 
  84, 79, 74, 79, 79, 84, 66, 81, 77, 88, 
  84, 81, 108, 81, 80, 83, 82, 83, 100, 95, 
  89, 80, 76, 90, 76, 83, 109, 86, 90, 86, 
  90, 84, 88, 82, 71, 77, 78, 66, 94, 90, 
  74, 86, 80, 79, 92, 86, 91, 79, 80, 84, 
  89, 80, 93, 122, 86, 96, 91, 84, 93, 86, 
  77, 91, 89, 86, 77, 91, 86, 81, 80, 74, 
  78, 90, 77, 85, 73, 90, 81, 109, 97, 77, 
  79, 97, 75, 80, 79, 84, 90, 75, 92, 78, 
  95, 66, 98, 76, 84, 71, 89, 80, 76, 73, 
  80, 75, 90, 75, 79, 90, 80, 92, 67, 99, 
  87, 73, 91, 70, 81, 77, 72, 86, 82, 104, 
  81, 84, 90, 105, 91, 75, 81, 78, 82, 80, 
  72, 79, 69, 83, 57, 72, 81, 90, 77, 96, 
  96, 86, 91, 82, 81, 88, 99, 94, 97, 85, 
  76, 93, 72, 82, 110, 85, 87, 82, 90, 77, 
  87, 72, 73, 77, 81, 72, 87, 85, 82, 88, 
  82, 78, 83, 89, 78, 98, 80, 86, 98, 80, 
  89, 130, 79, 95, 96, 80, 86, 86, 75, 87, 
  89, 81, 79, 92, 77, 82, 85, 69, 80, 83, 
  75, 79, 72, 99, 84, 110, 93, 74, 77, 86, 
  81, 83, 80, 83, 87, 84, 97, 80, 84, 74, 
  96, 85, 85, 89, 95, 79, 81, 77, 78, 83, 
  89, 67, 87, 86, 80, 90, 73, 91, 81, 78, 
  86, 72, 93, 71, 79, 80, 86, 100, 80, 84, 
  92, 93, 94, 75, 77, 87, 84, 82, 77, 79, 
  56, 81, 69, 79, 80, 95, 86, 82, 83, 88, 
  87, 95, 81, 84, 81, 76, 79, 60, 86, 89, 
  71, 78, 79, 90, 76, 83, 84, 97, 92, 88, 
  80, 77, 87, 83, 88, 91, 92, 86, 80, 83, 
  75, 83, 86, 63, 80, 97, 80, 78, 80, 76, 
  89, 83, 75, 90, 84, 96, 77, 77, 78, 89, 
  75, 88, 94, 83, 74, 84, 82, 79, 93, 78, 
  78, 81, 96, 77, 69, 78, 92, 93, 86, 82, 
  89, 85, 90, 71, 81, 100, 77, 90, 83, 77, 
  83, 79, 85, 86, 81, 81, 90, 76, 89, 77, 
  89, 86, 75, 87, 72, 82, 89, 100, 79, 71, 
  74, 81, 80, 85, 70, 79, 81, 90, 80, 85, 
  105, 117, 85, 77, 86, 76, 92, 88, 83, 90, 
  71, 78, 89, 105, 98, 86, 85, 93, 88, 112, 
  79, 90, 83, 72, 82, 60, 93, 93, 87, 79, 
  83, 99, 79, 88, 87, 99, 93, 91, 76, 74, 
  88, 79, 94, 113, 98, 86, 79, 58, 80, 90, 
  91, 82, 78, 96, 80, 72, 83, 82, 95, 89, 
  73, 80, 87, 82, 64, 83, 78, 88, 76, 79, 
  89, 88, 74, 85, 87, 90, 106, 70, 79, 79, 
  72, 78, 78, 86, 84, 90, 81, 85, 69, 84, 
  84, 74, 90, 82, 82, 89, 86, 75, 89, 69, 
  89, 79, 88, 92, 94, 73, 80, 73, 78, 85, 
  65, 96, 73, 91, 89, 89, 79, 79, 104, 82, 
  68, 87, 75, 83, 75, 91, 76, 94, 104, 82, 
  79, 91, 81, 77, 92, 82, 81, 89, 72, 83, 
  93, 90, 107, 93, 80, 79, 91, 105, 84, 99, 
  83, 82, 77, 70, 90, 91, 80, 79, 82, 92, 
  83, 83, 76, 89, 88, 81, 85, 84, 86, 86, 
  84, 91, 79, 91, 85, 67, 80, 91, 87, 125, 
  82, 93, 81, 72, 78, 78, 92, 89, 80, 93, 
  83, 78, 81, 79, 80, 82, 76, 80, 88, 89, 
  80, 83, 87, 82, 94, 70, 82, 77, 82, 78, 
  82, 84, 93, 93, 91, 77, 81, 88, 73, 79, 
  89, 71, 87, 88, 81, 80, 84, 82, 80, 78, 
  116, 79, 90, 77, 88, 80, 91, 90, 80, 91, 
  77, 83, 79, 91, 81, 81, 82, 81, 87, 83, 
  70, 85, 78, 86, 74, 91, 99, 74, 83, 81, 
  88, 78, 95, 88, 73, 91, 72, 75, 87, 114, 
  91, 83, 82, 86, 91, 96, 77, 85, 82, 79, 
  76, 74, 86, 87, 65, 80, 79, 90, 73, 69, 
  92, 93, 95, 91, 75, 75, 85, 90, 87, 94, 
  99, 82, 79, 91, 80, 81, 80, 52, 83, 74, 
  82, 73, 93, 72, 85, 82, 71, 88, 90, 95, 
  75, 78, 80, 82, 81, 80, 88, 83, 79, 86, 
  95, 78, 83, 87, 70, 73, 92, 76, 78, 81, 
  79, 76, 92, 81, 91, 80, 87, 76, 83, 108, 
  74, 92, 84, 77, 84, 74, 84, 73, 79, 91, 
  88, 78, 91, 79, 101, 90, 80, 84, 80, 83, 
  89, 91, 77, 76, 80, 79, 88, 84, 78, 84, 
  87, 86, 81, 92, 87, 126, 85, 89, 78, 80, 
  96, 77, 81, 84, 80, 91, 85, 112, 89, 84, 
  89, 88, 92, 115, 75, 81, 85, 77, 80, 76, 
  96, 97, 79, 84, 78, 94, 74, 70, 118, 88, 
  88, 100, 77, 69, 83, 90, 90, 118, 111, 87, 
  78, 60, 79, 84, 87, 76, 77, 66, 80, 73, 
  100, 70, 93, 89, 71, 78, 95, 87, 55, 85, 
  83, 81, 78, 71, 87, 93, 75, 83, 98, 85, 
  86, 71, 65, 75, 73, 76, 80, 83, 74, 62, 
  85, 84, 78, 79, 82, 77, 86, 85, 81, 90, 
  85, 78, 91, 71, 92, 64, 89, 97, 94, 76, 
  80, 82, 91, 92, 64, 89, 74, 90, 94, 82, 
  77, 72, 114, 80, 70, 79, 82, 92, 83, 82, 
  79, 90, 81, 84, 89, 93, 80, 69, 100, 72, 
  81, 75, 72, 99, 86, 96, 99, 89, 82, 81, 
  83, 104, 81, 90, 83, 81, 77, 86, 92, 89, 
  79, 90, 81, 94, 76, 75, 94, 81, 81, 85, 
  98, 82, 88, 92, 83, 95, 89, 92, 81, 68, 
  84, 88, 86, 131, 85, 70, 81, 73, 85, 71, 
  87, 86, 77, 86, 89, 79, 77, 84, 78, 84, 
  85, 76, 84, 86, 79, 81, 98, 83, 86, 67, 
  69, 72, 69, 75, 89, 83, 83, 82, 79, 72, 
  80, 80, 74, 81, 88, 70, 78, 87, 81, 79, 
  84, 86, 80, 66, 118, 79, 85, 78, 89, 75, 
  100, 94, 76, 83, 83, 82, 79, 83, 77, 79, 
  92, 78, 90, 82, 76, 92, 84, 84, 76, 90, 
  82, 73, 88, 89, 94, 76, 96, 81, 74, 83, 
  84, 88, 81, 118, 86, 85, 88, 91, 91, 90, 
  80, 80, 74, 77, 87, 80, 74, 91, 74, 90, 
  74, 80, 79, 68, 88, 87, 90, 85, 83, 78, 
  91, 91, 86, 67, 67, 79, 76, 103, 86, 95, 
  62, 59, 98, 65, 81, 77, 83, 60, 97, 77, 
  81, 82, 90, 102, 85, 80, 82, 84, 88, 74, 
  83, 79, 83, 81, 90, 81, 78, 86, 78, 80, 
  79, 79, 83, 80, 76, 80, 80, 76, 96, 85, 
  82, 72, 86, 97, 71, 84, 75, 85, 97, 82, 
  90, 59, 67, 80, 82, 79, 92, 79, 106, 93, 
  91, 85, 90, 80, 88, 86, 72, 79, 77, 71, 
  105, 87, 77, 76, 101, 79, 82, 82, 71, 121, 
  89, 95, 75, 91, 87, 77, 85, 82, 90, 95, 
  73, 173, 79, 74, 90, 87, 87, 98, 77, 84, 
  80, 71, 86, 89, 79, 99, 81, 89, 75, 81, 
  73, 73, 97, 80, 90, 92, 82, 76, 88, 94, 
  85, 79, 74, 77, 79, 87, 86, 93, 67, 83, 
  88, 61, 81, 75, 87, 51, 94, 85, 81, 82, 
  88, 93, 74, 82, 83, 87, 88, 68, 85, 87, 
  81, 79, 99, 88, 81, 81, 68, 84, 75, 78, 
  81, 91, 77, 81, 84, 73, 96, 83, 78, 78, 
  82, 84, 78, 79, 74, 90, 96, 77, 95, 54, 
  82, 87, 79, 79, 85, 85, 113, 99, 91, 91, 
  87, 82, 96, 84, 75, 76, 78, 72, 104, 92, 
  76, 80, 103, 77, 82, 84, 64, 86, 92, 100, 
  77, 92, 91, 76, 82, 86, 85, 92, 76, 194, 
  85, 77, 92, 82, 76, 92, 78, 90, 74, 80, 
  86, 89, 76, 92, 81, 88, 76, 82, 82, 71, 
  85, 74, 86, 88, 89, 83, 90, 91, 78, 65, 
  57, 83, 82, 84, 89, 91, 80, 121, 91, 67, 
  87, 72, 81, 60, 89, 78, 86, 85, 91, 84, 
  88, 87, 84, 86, 92, 75, 76, 85, 82, 80, 
  97, 84, 81, 75, 78, 80, 68, 78, 87, 84, 
  80, 83, 76, 73, 87, 82, 72, 75, 91, 80, 
  74, 80, 74, 82, 93, 74, 89, 52, 106, 73, 
  76, 83, 89, 81, 103, 96, 91, 81, 90, 79, 
  90, 83, 70, 74, 85, 69, 106, 90, 74, 79, 
  94, 81, 78, 80, 72, 71, 91, 107, 81, 92, 
  87, 81, 80, 84, 95, 93, 70, 184, 79, 81, 
  87, 73, 92, 82, 91, 104, 75, 78, 81, 81, 
  80, 94, 77, 103, 80, 81, 77, 88, 77, 86, 
  106, 77, 60, 87, 79, 103, 87, 93, 87, 103, 
  83, 69, 78, 84, 89, 74, 86, 88, 76, 72, 
  88, 73, 71, 80, 82, 80, 71, 87, 80, 102, 
  67, 95, 81, 86, 83, 84, 74, 70, 83, 92, 
  94, 83, 79, 78, 86, 90, 87, 94, 82, 90, 
  75, 86, 93, 87, 77, 80, 84, 86, 75, 84, 
  91, 82, 87, 94, 96, 87, 90, 88, 92, 91, 
  76, 79, 77, 91, 65, 77, 81, 87, 114, 87, 
  80, 85, 96, 82, 86, 78, 77, 86, 89, 77, 
  78, 81, 90, 84, 93, 88, 80, 77, 80, 95, 
  80, 95, 79, 84, 92, 85, 88, 94, 105, 74, 
  72, 75, 82, 76, 85, 86, 73, 69, 86, 128, 
  90, 87, 76, 83, 81, 112, 92, 86, 99, 78, 
  68, 73, 90, 108, 87, 91, 89, 93, 99, 63, 
  76, 72, 89, 64, 86, 75, 81, 82, 75, 84, 
  92, 94, 92, 81, 76, 81, 59, 81, 75, 89, 
  90, 82, 91, 86, 82, 59, 87, 97, 101, 63, 
  86, 93, 69, 89, 85, 89, 66, 86, 63, 68, 
  75, 86, 74, 75, 83, 74, 79, 82, 83, 83, 
  94, 80, 114, 75, 86, 89, 92, 104, 85, 82, 
  66, 91, 66, 82, 73, 95, 86, 75, 77, 84, 
  96, 87, 61, 76, 84, 93, 79, 85, 76, 89, 
  93, 79, 90, 84, 72, 81, 86, 79, 88, 100, 
  74, 88, 70, 83, 108, 85, 100, 76, 78, 81, 
  87, 52, 74, 88, 76, 77, 88, 120, 84, 65, 
  76, 86, 73, 105, 84, 85, 69, 76, 87, 82, 
  101, 113, 90, 93, 87, 78, 93, 72, 76, 69, 
  106, 85, 86, 83, 87, 79, 76, 83, 107, 83, 
  88, 83, 87, 81, 65, 93, 71, 90, 82, 90, 
  84, 86, 77, 64, 98, 90, 96, 68, 83, 87, 
  82, 83, 88, 92, 71, 82, 87, 77, 90, 88, 
  81, 81, 87, 83, 94, 83, 92, 78, 94, 81, 
  100, 71, 86, 90, 89, 100, 79, 85, 70, 97, 
  70, 81, 79, 92, 62, 74, 78, 81, 98, 80, 
  73, 78, 76, 89, 84, 82, 74, 86, 90, 92, 
  95, 88, 71, 73, 78, 93, 76, 98, 84, 83, 
  79, 82, 99, 92, 90, 75, 89, 80, 95, 99, 
  82, 75, 85, 77, 87, 86, 78, 92, 83, 79, 
  82, 98, 75, 84, 108, 82, 57, 87, 75, 95, 
  75, 88, 93, 91, 87, 73, 86, 89, 82, 77, 
  80, 91, 88, 79, 92, 75, 62, 84, 80, 86, 
  79, 87, 84, 100, 66, 93, 79, 87, 80, 82, 
  80, 68, 89, 87, 86, 83, 80, 67, 84, 85, 
  79, 90, 77, 75, 82, 91, 84, 87, 82, 78, 
  73, 85, 77, 85, 90, 67, 87, 85, 97, 83, 
  89, 87, 91, 87, 78, 82, 87, 93, 66, 82, 
  76, 89, 122, 83, 77, 90, 86, 83, 87, 84, 
  75, 89, 89, 84, 77, 91, 88, 82, 85, 81, 
  76, 85, 80, 87, 81, 89, 74, 87, 89, 83, 
  80, 88, 104, 76, 74, 61, 73, 74, 90, 91, 
  80, 61, 98, 129, 102, 81, 70, 74, 107, 124, 
  107, 86, 94, 77, 69, 69, 85, 101, 81, 80, 
  86, 80, 111, 66, 79, 73, 77, 60, 80, 68, 
  85, 84, 77, 108, 85, 101, 92, 88, 76, 75, 
  56, 78, 64, 79, 88, 83, 99, 82, 96, 53, 
  92, 102, 96, 64, 79, 102, 72, 86, 74, 93, 
  57, 69, 60, 74, 66, 79, 77, 75, 76, 71, 
  77, 88, 70, 70, 104, 74, 119, 77, 86, 90, 
  80, 90, 83, 74, 73, 95, 61, 84, 74, 100, 
  93, 71, 71, 78, 83, 92, 63, 81, 78, 97, 
  77, 86, 79, 101, 91, 81, 82, 76, 67, 91, 
  93, 76, 81, 102, 66, 92, 61, 76, 118, 81, 
  94, 75, 90, 71, 87, 58, 78, 85, 81, 70, 
  97, 111, 92, 77, 71, 84, 92, 115, 91, 87, 
  63, 73, 89, 79, 98, 102, 82, 87, 91, 77, 
  97, 78, 77, 68, 88, 78, 77, 82, 86, 84, 
  82, 94, 115, 95, 87, 89, 89, 76, 65, 90, 
  64, 84, 83, 91, 88, 83, 88, 63, 101, 90, 
  92, 69, 80, 86, 78, 79, 85, 99, 62, 68, 
  79, 80, 75, 80, 86, 80, 81, 80, 84, 83, 
  86, 64, 97, 87, 102, 76, 83, 91, 82, 91, 
  81, 74, 76, 96, 66, 84, 77, 95, 72, 72, 
  70, 72, 87, 85, 73, 82, 69, 92, 78, 84, 
  69, 98, 89, 94, 85, 81, 68, 85, 85, 85, 
  68, 98, 72, 87, 73, 74, 102, 85, 88, 76, 
  75, 86, 88, 99, 81, 71, 72, 86, 91, 82, 
  78, 89, 79, 90, 96, 98, 94, 79, 95, 84, 
  64, 88, 78, 86, 77, 89, 86, 77, 94, 79, 
  83, 98, 76, 82, 78, 93, 96, 77, 83, 75, 
  63, 79, 75, 74, 89, 93, 89, 97, 76, 85, 
  77, 84, 79, 71, 79, 81, 87, 85, 86, 81, 
  88, 71, 89, 81, 80, 85, 82, 82, 85, 87, 
  91, 82, 77, 86, 76, 84, 86, 92, 78, 88, 
  88, 79, 90, 82, 80, 86, 92, 85, 81, 87, 
  85, 98, 78, 78, 89, 85, 99, 88, 78, 95, 
  86, 84, 93, 84, 74, 81, 83, 81, 80, 94, 
  80, 88, 86, 88, 77, 84, 84, 92, 89, 87, 
  81, 87, 92, 84, 83, 78, 95, 79, 79, 77, 
  63, 74, 87, 83, 68, 74, 96, 115, 91, 86, 
  70, 87, 118, 120, 107, 82, 87, 73, 73, 74, 
  83, 91, 80, 89, 84, 72, 98, 77, 86, 81, 
  66, 68, 84, 68, 88, 78, 80, 87, 77, 96, 
  84, 76, 84, 74, 59, 79, 78, 83, 78, 79, 
  92, 83, 80, 69, 91, 92, 92, 64, 86, 94, 
  84, 84, 82, 88, 70, 87, 72, 73, 77, 75, 
  80, 79, 78, 77, 95, 86, 61, 96, 92, 78, 
  98, 78, 82, 91, 91, 84, 83, 91, 75, 99, 
  82, 83, 92, 92, 88, 83, 78, 87, 85, 93, 
  94, 84, 80, 90, 73, 87, 76, 101, 85, 84, 
  82, 83, 66, 90, 94, 82, 85, 91, 67, 94, 
  71, 79, 110, 77, 85, 77, 87, 81, 77, 62, 
  80, 76, 65, 79, 94, 100, 84, 97, 72, 95, 
  106, 108, 98, 80, 63, 73, 92, 82, 90, 92, 
  81, 92, 82, 77, 97, 81, 82, 78, 75, 81, 
  80, 82, 83, 77, 88, 81, 106, 88, 81, 74, 
  91, 74, 73, 86, 77, 89, 76, 86, 86, 83, 
  80, 80, 97, 86, 94, 76, 86, 88, 89, 83, 
  91, 93, 68, 82, 72, 78, 80, 78, 85, 82, 
  81, 82, 94, 86, 73, 85, 86, 82, 91, 82, 
  84, 86, 91, 89, 82, 84, 83, 98, 80, 87, 
  92, 92, 82, 83, 76, 85, 85, 86, 94, 88, 
  72, 87, 74, 83, 70, 99, 86, 84, 84, 87, 
  70, 86, 92, 88, 79, 91, 74, 90, 77, 81, 
  97, 79, 71, 78, 90, 82, 76, 72, 76, 91, 
  77, 84, 65, 135, 75, 119, 72, 90, 85, 93, 
  82, 120, 91, 70, 103, 85, 70, 73, 89, 89, 
  94, 73, 69, 85, 90, 94, 91, 78, 95, 74, 
  101, 75, 82, 82, 76, 103, 94, 84, 84, 91, 
  82, 74, 93, 72, 80, 80, 84, 92, 87, 87, 
  85, 101, 83, 90, 101, 72, 74, 74, 75, 99, 
  84, 85, 85, 77, 78, 76, 80, 75, 74, 92, 
  80, 82, 84, 95, 86, 105, 75, 75, 89, 82, 
  81, 76, 93, 84, 85, 83, 82, 81, 65, 82, 
  76, 84, 99, 79, 79, 79, 92, 85, 88, 90, 
  72, 83, 89, 92, 81, 96, 72, 82, 77, 82, 
  75, 80, 95, 76, 81, 86, 61, 90, 82, 94, 
  81, 97, 83, 96, 67, 90, 81, 78, 84, 82, 
  72, 99, 102, 99, 90, 91, 75, 87, 88, 95, 
  85, 75, 86, 90, 81, 67, 82, 90, 85, 80, 
  68, 81, 79, 84, 85, 67, 97, 73, 95, 91, 
  82, 88, 80, 88, 85, 87, 78, 100, 75, 84, 
  92, 100, 87, 89, 93, 91, 66, 90, 81, 90, 
  84, 70, 86, 79, 84, 80, 70, 79, 78, 93, 
  85, 91, 74, 76, 77, 83, 78, 73, 80, 100, 
  94, 91, 89, 80, 78, 73, 98, 76, 87, 76, 
  73, 83, 80, 92, 70, 69, 79, 82, 79, 81, 
  84, 74, 84, 76, 83, 79, 88, 83, 88, 87, 
  80, 80, 86, 94, 78, 85, 84, 87, 87, 77, 
  91, 75, 98, 81, 80, 80, 81, 89, 80, 89, 
  75, 88, 63, 74, 80, 78, 88, 74, 70, 71, 
  90, 69, 97, 81, 81, 81, 90, 73, 87, 84, 
  92, 87, 83, 77, 80, 81, 83, 92, 91, 80, 
  70, 83, 93, 73, 103, 75, 92, 92, 85, 87, 
  73, 69, 70, 81, 84, 90, 77, 77, 78, 100, 
  83, 98, 94, 90, 68, 100, 75, 84, 86, 79, 
  74, 76, 92, 96, 93, 87, 89, 85, 83, 106, 
  81, 81, 79, 78, 80, 75, 88, 110, 92, 73, 
  78, 73, 84, 84, 88, 78, 98, 82, 58, 81, 
  78, 101, 73, 72, 77, 77, 84, 89, 79, 82, 
  92, 77, 81, 83, 80, 92, 80, 88, 90, 81, 
  87, 86, 82, 83, 88, 88, 89, 99, 92, 96, 
  82, 89, 89, 80, 92, 87, 61, 69, 75, 76, 
  81, 69, 78, 91, 60, 92, 68, 128, 67, 161, 
  68, 79, 97, 100, 77, 123, 88, 61, 94, 79, 
  74, 77, 90, 95, 99, 59, 68, 87, 91, 86, 
  104, 79, 103, 66, 82, 76, 70, 82, 102, 118, 
  78, 78, 76, 94, 76, 71, 109, 66, 72, 79, 
  86, 83, 107, 67, 91, 95, 74, 85, 98, 56, 
  74, 73, 63, 105, 93, 79, 79, 72, 78, 71, 
  94, 74, 74, 95, 78, 89, 72, 87, 84, 105, 
  76, 66, 87, 77, 68, 80, 87, 86, 83, 78, 
  76, 93, 75, 77, 81, 83, 87, 100, 86, 83, 
  85, 86, 90, 88, 62, 80, 83, 108, 87, 107, 
  66, 77, 66, 81, 73, 85, 84, 72, 64, 87, 
  60, 79, 81, 84, 90, 87, 76, 104, 99, 88, 
  77, 75, 72, 88, 72, 88, 99, 160, 86, 81, 
  91, 84, 89, 93, 83, 77, 70, 89, 91, 79, 
  84, 96, 92, 75, 74, 83, 90, 92, 82, 59, 
  98, 79, 65, 83, 83, 95, 100, 106, 76, 87, 
  83, 113, 83, 73, 93, 84, 88, 87, 90, 79, 
  75, 84, 75, 83, 88, 82, 78, 71, 65, 71, 
  75, 77, 98, 76, 78, 86, 68, 78, 87, 80, 
  76, 68, 76, 100, 89, 74, 103, 67, 93, 76, 
  94, 72, 75, 69, 69, 92, 85, 106, 80, 89, 
  82, 84, 77, 78, 74, 89, 85, 78, 81, 89, 
  89, 79, 84, 80, 80, 112, 84, 87, 81, 78, 
  70, 92, 80, 79, 83, 66, 103, 78, 76, 75, 
  75, 80, 83, 91, 77, 95, 90, 62, 78, 84, 
  87, 74, 76, 73, 82, 80, 94, 93, 83, 76, 
  87, 79, 80, 87, 88, 88, 94, 83, 83, 86, 
  89, 81, 88, 84, 79, 89, 94, 75, 86, 83, 
  87, 81, 87, 75, 85, 76, 72, 79, 78, 84, 
  84, 79, 77, 90, 91, 89, 95, 89, 73, 104, 
  71, 76, 96, 88, 70, 80, 82, 81, 97, 85, 
  97, 83, 80, 89, 81, 85, 79, 83, 82, 77, 
  88, 94, 95, 58, 87, 72, 91, 89, 83, 81, 
  85, 89, 69, 90, 85, 104, 76, 77, 79, 77, 
  80, 87, 78, 81, 87, 76, 81, 93, 75, 84, 
  76, 82, 89, 98, 86, 79, 86, 82, 78, 92, 
  76, 94, 73, 87, 99, 87, 88, 87, 85, 80, 
  71, 75, 71, 70, 61, 70, 86, 110, 74, 87, 
  74, 116, 70, 124, 64, 89, 91, 94, 78, 102, 
  78, 78, 87, 90, 69, 74, 88, 91, 92, 61, 
  76, 87, 88, 85, 106, 92, 108, 82, 87, 87, 
  83, 82, 100, 89, 55, 74, 80, 90, 77, 88, 
  97, 79, 82, 76, 83, 82, 101, 73, 95, 95, 
  69, 76, 93, 65, 65, 83, 62, 86, 78, 72, 
  69, 75, 97, 72, 95, 89, 75, 102, 105, 76, 
  81, 84, 83, 102, 85, 69, 82, 88, 86, 83, 
  112, 77, 87, 71, 75, 84, 74, 65, 79, 84, 
  86, 83, 88, 83, 84, 71, 90, 99, 76, 98, 
  91, 78, 83, 107, 76, 88, 82, 86, 85, 81, 
  69, 79, 76, 93, 73, 81, 82, 94, 81, 75, 
  70, 89, 94, 87, 84, 92, 64, 90, 75, 90, 
  85, 146, 70, 74, 95, 90, 83, 101, 77, 84, 
  75, 85, 79, 69, 79, 92, 89, 73, 83, 82, 
  81, 98, 94, 76, 102, 84, 64, 82, 94, 80, 
  93, 99, 64, 90, 75, 109, 81, 77, 78, 81, 
  86, 82, 82, 66, 103, 83, 80, 83, 85, 99, 
  86, 89, 78, 71, 75, 90, 80, 71, 77, 67, 
  93, 81, 88, 82, 80, 72, 104, 79, 83, 68, 
  92, 80, 88, 84, 85, 74, 68, 72, 79, 76, 
  80, 96, 87, 84, 81, 77, 68, 79, 68, 91, 
  78, 78, 73, 88, 93, 95, 72, 87, 80, 123, 
  79, 87, 96, 74, 77, 92, 78, 84, 74, 71, 
  88, 84, 79, 85, 79, 81, 84, 84, 83, 90, 
  86, 77, 79, 89, 76, 78, 80, 77, 97, 98, 
  79, 79, 84, 82, 86, 90, 78, 94, 96, 85, 
  89, 75, 79, 82, 78, 82, 85, 88, 78, 87, 
  88, 84, 95, 80, 90, 90, 93, 79, 85, 80, 
  67, 90, 74, 98, 80, 81, 75, 97, 88, 84, 
  88, 74, 94, 85, 78, 78, 88, 92, 84, 83, 
  86, 83, 86, 86, 83, 84, 82, 81, 97, 85, 
  80, 87, 84, 76, 89, 84, 82, 62, 90, 82, 
  83, 84, 83, 87, 75, 91, 75, 87, 79, 102, 
  80, 74, 83, 79, 71, 85, 73, 86, 81, 76, 
  78, 90, 80, 93, 72, 80, 90, 102, 77, 83, 
  99, 82, 89, 92, 73, 92, 78, 80, 91, 82, 
  87, 95, 79, 85, 83, 73, 89, 107, 80, 78, 
  98, 55, 65, 69, 79, 89, 83, 81, 101, 84, 
  98, 94, 88, 79, 83, 85, 81, 83, 93, 89, 
  81, 72, 97, 92, 87, 91, 76, 90, 85, 76, 
  84, 89, 89, 87, 76, 76, 92, 72, 70, 67, 
  102, 86, 105, 77, 92, 82, 82, 75, 85, 90, 
  82, 81, 79, 78, 87, 91, 77, 78, 80, 71, 
  83, 79, 88, 86, 79, 83, 84, 73, 85, 84, 
  76, 79, 85, 86, 75, 83, 67, 89, 83, 81, 
  85, 93, 84, 95, 71, 77, 89, 104, 70, 109, 
  99, 69, 87, 85, 77, 83, 78, 107, 94, 79, 
  88, 92, 89, 64, 84, 69, 70, 101, 97, 79, 
  103, 95, 81, 81, 91, 79, 78, 100, 79, 84, 
  77, 79, 76, 95, 83, 117, 76, 67, 110, 57, 
  69, 63, 75, 84, 81, 80, 113, 87, 100, 94, 
  86, 83, 93, 79, 73, 89, 90, 93, 80, 69, 
  102, 89, 87, 86, 77, 78, 87, 80, 86, 88, 
  84, 83, 76, 75, 95, 75, 73, 70, 104, 81, 
  116, 73, 97, 70, 93, 77, 81, 89, 72, 81, 
  72, 77, 91, 90, 75, 78, 70, 75, 91, 78, 
  89, 78, 81, 74, 81, 73, 94, 69, 72, 82, 
  88, 83, 80, 90, 68, 75, 78, 81, 90, 95, 
  85, 102, 70, 74, 71, 100, 69, 109, 89, 75, 
  99, 85, 78, 86, 74, 109, 90, 73, 90, 95, 
  92, 62, 88, 67, 76, 85, 83, 81, 83, 86, 
  77, 82, 89, 79, 73, 111, 71, 84, 78, 75, 
  82, 97, 86, 99, 82, 77, 93, 62, 65, 73, 
  81, 94, 82, 90, 100, 88, 98, 90, 93, 91, 
  81, 84, 80, 78, 84, 88, 85, 72, 90, 84, 
  80, 86, 78, 73, 87, 93, 89, 86, 84, 85, 
  77, 73, 80, 77, 76, 69, 97, 75, 97, 81, 
  88, 83, 78, 81, 86, 91, 85, 83, 76, 75, 
  92, 91, 78, 74, 76, 72, 81, 76, 89, 81, 
  102, 84, 87, 74, 88, 88, 78, 88, 88, 87, 
  75, 82, 70, 78, 84, 82, 97, 93, 85, 97, 
  71, 81, 93, 99, 73, 101, 103, 78, 93, 89, 
  77, 84, 72, 106, 89, 84, 83, 88, 86, 67, 
  86, 71, 72, 83, 84, 78, 79, 89, 87, 85, 
  86, 80, 74, 93, 81, 84, 82, 79, 74, 72, 
  79, 106, 83, 83, 98, 65, 69, 69, 79, 84, 
  84, 81, 102, 94, 104, 91, 90, 77, 93, 78, 
  78, 78, 92, 90, 74, 70, 104, 88, 84, 94, 
  76, 94, 73, 83, 88, 89, 93, 86, 81, 76, 
  91, 74, 77, 73, 91, 89, 99, 80, 84, 74, 
  87, 80, 80, 88, 79, 77, 80, 81, 82, 98, 
  78, 79, 70, 72, 90, 79, 88, 71, 85, 76, 
  84, 74, 68, 82, 77, 79, 82, 90, 76, 75, 
  73, 80, 87, 83, 87, 103, 76, 102, 77, 91, 
  93, 102, 69, 109, 98, 68, 76, 87, 71, 82, 
  73, 101, 82, 69, 89, 88, 82, 66, 92, 77, 
  64, 98, 84, 80, 88, 92, 79, 72, 87, 81, 
  73, 102, 79, 88, 80, 79, 71, 82, 77, 115, 
  79, 71, 104, 66, 73, 62, 73, 79, 80, 86, 
  111, 96, 103, 90, 88, 80, 97, 77, 74, 82, 
  82, 92, 71, 66, 106, 82, 80, 81, 78, 81, 
  77, 83, 87, 85, 85, 81, 80, 75, 101, 73, 
  79, 74, 90, 82, 108, 75, 88, 68, 92, 82, 
  76, 83, 74, 76, 75, 79, 89, 102, 78, 80, 
  69, 78, 94, 79, 96, 69, 78, 65, 81, 68, 
  69, 62, 74, 84, 87, 85, 77, 81, 75, 75, 
  79, 82, 86, 108, 77, 107, 74, 83, 78, 95, 
  68, 108, 88, 75, 89, 89, 73, 78, 68, 102, 
  78, 64, 91, 86, 79, 63, 97, 74, 63, 86, 
  77, 81, 78, 83, 71, 76, 88, 80, 60, 111, 
  68, 85, 77, 77, 79, 90, 84, 97, 88, 79, 
  97, 71, 67, 75, 81, 92, 81, 93, 94, 93, 
  100, 91, 93, 90, 85, 83, 87, 74, 76, 86, 
  78, 70, 95, 76, 82, 85, 80, 74, 80, 93, 
  86, 90, 82, 81, 81, 75, 89, 82, 81, 77, 
  82, 75, 95, 82, 81, 80, 77, 82, 83, 84, 
  84, 79, 82, 78, 83, 97, 84, 75, 65, 72, 
  83, 80, 97, 74, 86, 77, 81, 76, 78, 85, 
  82, 91, 85, 83, 73, 75, 78, 80, 86, 82, 
  91, 100, 77, 96, 76, 82, 94, 96, 73, 98, 
  99, 77, 92, 90, 73, 79, 71, 100, 80, 76, 
  87, 85, 85, 68, 93, 80, 71, 85, 86, 81, 
  81, 91, 84, 75, 87, 82, 71, 97, 81, 86, 
  81, 78, 81, 77, 80, 98, 85, 87, 81, 72, 
  68, 79, 80, 90, 82, 84, 96, 94, 98, 78, 
  90, 77, 97, 89, 76, 70, 87, 82, 86, 73, 
  86, 79, 85, 102, 83, 98, 63, 91, 89, 95, 
  93, 85, 87, 80, 94, 80, 88, 78, 83, 86, 
  83, 89, 82, 83, 77, 81, 87, 89, 90, 82, 
  92, 80, 80, 90, 86, 75, 75, 74, 90, 79, 
  84, 77, 91, 82, 85, 86, 64, 85, 90, 82, 
  79, 86, 79, 77, 77, 84, 83, 84, 88, 92, 
  85, 103, 78, 101, 102, 88, 75, 105, 107, 73, 
  75, 90, 73, 84, 76, 99, 88, 80, 90, 84, 
  83, 77, 86, 77, 72, 91, 86, 79, 81, 96, 
  89, 70, 85, 79, 71, 97, 89, 95, 83, 85, 
  79, 76, 80, 99, 82, 71, 81, 71, 71, 77, 
  81, 88, 80, 85, 90, 95, 98, 75, 92, 75, 
  96, 87, 80, 71, 76, 75, 84, 70, 86, 78, 
  88, 93, 85, 86, 66, 85, 93, 91, 88, 80, 
  88, 81, 94, 78, 85, 77, 75, 81, 90, 87, 
  84, 80, 79, 81, 81, 86, 93, 81, 90, 82, 
  79, 100, 90, 82, 68, 77, 86, 80, 86, 76, 
  81, 75, 83, 81, 57, 75, 91, 82, 85, 84, 
  79, 80, 77, 81, 83, 81, 82, 95, 84, 100, 
  75, 95, 101, 80, 71, 102, 104, 76, 84, 90, 
  73, 83, 71, 98, 83, 78, 90, 81, 78, 74, 
  85, 76, 70, 86, 88, 83, 78, 90, 85, 72, 
  85, 82, 64, 100, 88, 90, 78, 86, 88, 83, 
  87, 92, 89, 78, 81, 76, 66, 83, 81, 96, 
  78, 88, 89, 92, 96, 82, 90, 84, 88, 92, 
  87, 69, 76, 78, 89, 73, 77, 71, 88, 95, 
  88, 84, 75, 90, 86, 96, 88, 80, 84, 76, 
  90, 83, 89, 84, 76, 82, 85, 87, 79, 87, 
  71, 80, 87, 81, 94, 82, 92, 81, 78, 89, 
  91, 72, 76, 73, 84, 78, 87, 82, 82, 83, 
  83, 86, 70, 86, 89, 88, 84, 82, 74, 78, 
  81, 92, 82, 85, 85, 89, 82, 93, 78, 89, 
  102, 89, 76, 92, 105, 78, 89, 85, 78, 83, 
  77, 98, 85, 83, 91, 82, 84, 78, 84, 82, 
  78, 91, 89, 81, 89, 97, 88, 70, 88, 83, 
  72, 97, 88, 93, 85, 87, 64, 84, 89, 68, 
  79, 95, 77, 80, 73, 78, 70, 94, 85, 96, 
  78, 77, 86, 91, 67, 74, 83, 87, 90, 78, 
  91, 93, 65, 83, 103, 88, 93, 71, 70, 74, 
  82, 97, 84, 78, 89, 88, 79, 66, 70, 68, 
  80, 93, 87, 86, 69, 77, 91, 75, 96, 75, 
  70, 89, 78, 80, 77, 101, 82, 75, 88, 80, 
  112, 69, 95, 87, 86, 109, 85, 67, 91, 79, 
  85, 101, 77, 78, 103, 78, 79, 90, 69, 93, 
  70, 73, 108, 100, 81, 137, 82, 80, 71, 80, 
  80, 89, 85, 76, 100, 97, 78, 84, 72, 77, 
  87, 72, 78, 81, 100, 72, 77, 78, 65, 73, 
  88, 81, 97, 82, 83, 87, 127, 80, 107, 88, 
  65, 118, 87, 84, 66, 94, 79, 63, 93, 74, 
  85, 76, 64, 67, 66, 93, 86, 87, 86, 79, 
  99, 87, 60, 74, 78, 70, 76, 89, 97, 93, 
  62, 77, 100, 88, 97, 77, 77, 65, 99, 70, 
  82, 67, 85, 91, 76, 69, 84, 61, 93, 97, 
  86, 81, 77, 67, 88, 67, 91, 72, 66, 79, 
  79, 81, 59, 93, 87, 88, 92, 85, 87, 62, 
  94, 93, 93, 95, 81, 66, 88, 70, 92, 94, 
  80, 76, 106, 89, 75, 92, 83, 88, 75, 76, 
  76, 83, 81, 150, 86, 81, 64, 91, 74, 90, 
  93, 77, 90, 113, 63, 76, 63, 81, 79, 68, 
  72, 74, 107, 61, 89, 83, 69, 86, 82, 73, 
  65, 89, 79, 81, 113, 69, 96, 89, 47, 122, 
  93, 87, 69, 98, 90, 73, 74, 84, 73, 73, 
  79, 79, 68, 95, 73, 80, 82, 84, 87, 87, 
  77, 82, 74, 94, 87, 77, 82, 90, 72, 88, 
  104, 74, 89, 85, 82, 72, 88, 71, 87, 76, 
  78, 87, 77, 67, 87, 76, 76, 90, 94, 81, 
  65, 86, 81, 81, 89, 78, 77, 78, 75, 85, 
  82, 91, 82, 79, 90, 84, 117, 68, 86, 81, 
  87, 102, 101, 67, 84, 78, 88, 95, 74, 88, 
  102, 75, 83, 90, 71, 96, 77, 76, 69, 108, 
  85, 129, 78, 92, 79, 75, 93, 85, 88, 76, 
  83, 93, 88, 89, 79, 80, 83, 76, 95, 81, 
  92, 86, 83, 74, 67, 119, 92, 79, 75, 78, 
  80, 91, 93, 83, 101, 87, 75, 102, 83, 90, 
  77, 72, 82, 77, 86, 96, 88, 94, 67, 74, 
  79, 83, 81, 94, 91, 82, 102, 90, 72, 77, 
  85, 90, 92, 87, 89, 95, 71, 83, 90, 87, 
  99, 77, 74, 82, 83, 101, 77, 77, 87, 87, 
  78, 89, 75, 79, 87, 81, 86, 89, 81, 66, 
  94, 70, 96, 68, 74, 88, 81, 77, 71, 93, 
  85, 77, 76, 92, 98, 74, 96, 77, 94, 76, 
  85, 88, 103, 79, 77, 107, 73, 79, 83, 91, 
  82, 86, 79, 82, 83, 97, 108, 80, 82, 115, 
  85, 87, 79, 78, 77, 90, 85, 79, 95, 95, 
  61, 87, 75, 76, 71, 71, 80, 83, 97, 63, 
  82, 84, 67, 61, 76, 69, 89, 91, 83, 78, 
  112, 69, 99, 88, 58, 92, 85, 78, 85, 78, 
  73, 73, 105, 76, 102, 90, 54, 65, 77, 82, 
  93, 91, 97, 83, 124, 78, 69, 79, 79, 80, 
  76, 102, 100, 94, 69, 78, 87, 85, 105, 91, 
  78, 74, 89, 75, 71, 67, 95, 98, 73, 110, 
  80, 72, 98, 90, 86, 87, 89, 55, 91, 69, 
  90, 63, 67, 76, 82, 83, 59, 79, 91, 84, 
  74, 105, 79, 73, 107, 72, 107, 74, 75, 85, 
  104, 74, 76, 93, 76, 84, 74, 107, 77, 89, 
  99, 79, 93, 111, 71, 64, 83, 106, 80, 77, 
  75, 102, 66, 90, 93, 80, 85, 109, 45, 76, 
  71, 78, 57, 74, 69, 75, 96, 51, 88, 89, 
  75, 71, 76, 67, 67, 104, 82, 76, 90, 63, 
  91, 85, 35, 87, 89, 79, 75, 92, 80, 79, 
  83, 89, 86, 82, 74, 73, 76, 80, 74, 80, 
  88, 88, 99, 89, 80, 88, 81, 91, 89, 82, 
  87, 88, 77, 87, 88, 76, 94, 91, 84, 75, 
  85, 79, 71, 81, 82, 85, 79, 83, 90, 83, 
  87, 88, 94, 84, 80, 71, 88, 78, 85, 70, 
  75, 76, 80, 80, 77, 85, 84, 80, 78, 90, 
  102, 75, 92, 76, 86, 80, 87, 79, 97, 81, 
  85, 96, 69, 98, 77, 85, 81, 86, 79, 97, 
  84, 101, 65, 87, 86, 116, 83, 83, 84, 82, 
  85, 87, 84, 77, 85, 86, 76, 80, 76, 78, 
  66, 72, 92, 79, 93, 72, 82, 79, 71, 112, 
  83, 73, 79, 83, 79, 81, 82, 72, 92, 89, 
  64, 85, 87, 82, 79, 75, 87, 80, 72, 97, 
  86, 87, 79, 86, 77, 90, 88, 89, 94, 86, 
  95, 85, 82, 84, 82, 101, 86, 76, 81, 93, 
  83, 91, 90, 91, 87, 78, 81, 86, 79, 104, 
  76, 80, 80, 86, 78, 91, 86, 83, 77, 65, 
  86, 89, 75, 75, 82, 79, 94, 76, 79, 88, 
  78, 87, 85, 83, 87, 71, 81, 83, 118, 74, 
  88, 73, 86, 87, 84, 88, 95, 79, 80, 91, 
  78, 83, 96, 77, 89, 77, 78, 83, 79, 91, 
  105, 87, 88, 99, 80, 94, 90, 75, 77, 89, 
  79, 72, 93, 74, 85, 85, 86, 80, 82, 75, 
  85, 93, 88, 73, 85, 78, 66, 69, 89, 76, 
  93, 82, 82, 90, 97, 73, 95, 84, 70, 78, 
  84, 82, 78, 74, 82, 80, 81, 79, 93, 82, 
  67, 79, 74, 88, 90, 83, 99, 81, 109, 78, 
  78, 82, 88, 94, 80, 79, 87, 91, 81, 84, 
  86, 94, 81, 91, 85, 77, 83, 81, 71, 79, 
  86, 95, 79, 101, 87, 81, 83, 77, 84, 83, 
  81, 65, 77, 78, 95, 74, 76, 81, 78, 92, 
  80, 69, 90, 81, 85, 83, 109, 70, 90, 70, 
  95, 94, 82, 82, 98, 78, 80, 80, 79, 88, 
  93, 85, 88, 72, 87, 89, 83, 103, 80, 77, 
  83, 94, 74, 93, 87, 82, 69, 91, 84, 73, 
  86, 85, 81, 85, 78, 82, 73, 84, 81, 83, 
  79, 70, 85, 85, 67, 76, 88, 74, 79, 88, 
  83, 86, 80, 69, 79, 81, 56, 75, 85, 77, 
  76, 83, 79, 83, 72, 83, 89, 78, 79, 84, 
  77, 85, 80, 82, 97, 85, 92, 80, 85, 88, 
  89, 102, 88, 73, 79, 89, 86, 92, 88, 84, 
  81, 88, 86, 82, 81, 82, 75, 85, 81, 90, 
  80, 89, 86, 84, 82, 76, 85, 82, 76, 76, 
  82, 84, 88, 79, 77, 79, 76, 91, 88, 82, 
  86, 78, 83, 82, 113, 77, 83, 75, 83, 81, 
  93, 85, 93, 83, 85, 87, 75, 102, 84, 78, 
  90, 80, 79, 100, 79, 94, 76, 88, 88, 98, 
  81, 87, 93, 79, 85, 91, 80, 75, 88, 72, 
  89, 86, 87, 83, 76, 75, 91, 87, 85, 74, 
  85, 72, 71, 103, 90, 78, 82, 76, 78, 90, 
  79, 78, 86, 84, 75, 78, 84, 81, 103, 88, 
  84, 81, 75, 92, 80, 81, 90, 81, 72, 73, 
  76, 71, 72, 84, 70, 92, 82, 103, 80, 92, 
  77, 76, 77, 93, 86, 80, 92, 94, 73, 70, 
  84, 82, 82, 79, 87, 97, 105, 83, 76, 57, 
  86, 75, 93, 91, 96, 63, 99, 78, 89, 71, 
  72, 86, 80, 81, 87, 100, 68, 95, 71, 93, 
  104, 80, 77, 108, 88, 82, 89, 78, 85, 71, 
  107, 68, 80, 94, 81, 68, 95, 83, 80, 88, 
  78, 89, 60, 92, 85, 80, 81, 88, 93, 89, 
  81, 89, 103, 64, 80, 81, 86, 92, 97, 76, 
  79, 83, 85, 103, 88, 86, 74, 76, 62, 87, 
  61, 96, 70, 76, 73, 100, 81, 75, 76, 85, 
  80, 75, 74, 87, 73, 71, 138, 83, 85, 77, 
  84, 68, 71, 88, 82, 83, 84, 79, 124, 88, 
  71, 80, 74, 74, 79, 85, 80, 126, 66, 89, 
  82, 79, 74, 84, 85, 85, 92, 74, 80, 91, 
  77, 94, 75, 71, 98, 105, 75, 61, 89, 77, 
  110, 74, 98, 90, 102, 99, 74, 99, 80, 79, 
  80, 70, 56, 98, 80, 74, 89, 62, 96, 116, 
  68, 111, 85, 63, 77, 71, 86, 87, 72, 80, 
  91, 74, 79, 88, 83, 79, 70, 62, 83, 74, 
  47, 86, 81, 99, 76, 77, 71, 76, 75, 91, 
  71, 56, 95, 78, 83, 84, 90, 82, 106, 83, 
  83, 107, 72, 81, 86, 83, 85, 84, 84, 84, 
  70, 78, 79, 95, 89, 73, 77, 105, 74, 108, 
  71, 83, 77, 91, 81, 79, 91, 83, 78, 75, 
  82, 81, 87, 81, 71, 70, 64, 95, 70, 85, 
  76, 89, 83, 104, 93, 91, 92, 79, 82, 95, 
  83, 80, 87, 93, 81, 81, 75, 81, 85, 86, 
  83, 99, 71, 84, 80, 68, 78, 85, 82, 100, 
  87, 77, 101, 78, 82, 69, 73, 86, 79, 76, 
  93, 93, 78, 96, 76, 94, 88, 80, 85, 99, 
  79, 80, 94, 81, 63, 69, 103, 66, 90, 91, 
  81, 71, 98, 75, 84, 92, 84, 84, 72, 86, 
  96, 79, 78, 86, 96, 89, 87, 84, 99, 62, 
  86, 83, 83, 95, 97, 83, 77, 84, 87, 94, 
  85, 81, 77, 72, 82, 92, 68, 88, 82, 77, 
  89, 93, 83, 76, 73, 84, 87, 77, 76, 92, 
  75, 80, 103, 89, 86, 81, 72, 89, 78, 81, 
  89, 78, 67, 76, 48, 91, 74, 83, 73, 88, 
  75, 101, 86, 81, 79, 76, 76, 92, 72, 73, 
  90, 81, 78, 65, 81, 87, 74, 76, 71, 85, 
  71, 73, 74, 53, 89, 75, 103, 98, 85, 70, 
  94, 76, 91, 65, 76, 84, 81, 70, 91, 96, 
  67, 100, 70, 88, 110, 64, 84, 90, 93, 89, 
  85, 83, 65, 59, 105, 74, 80, 101, 81, 63, 
  91, 78, 75, 87, 72, 89, 60, 87, 91, 83, 
  72, 88, 89, 98, 80, 82, 102, 62, 80, 93, 
  72, 88, 90, 79, 75, 82, 85, 94, 99, 83, 
  74, 75, 75, 88, 62, 103, 61, 75, 71, 88, 
  71, 76, 83, 81, 78, 80, 64, 92, 68, 65, 
  168, 86, 96, 99, 87, 71, 69, 95, 91, 83, 
  76, 83, 141, 106, 74, 86, 78, 57, 73, 81, 
  79, 141, 64, 96, 80, 74, 64, 81, 90, 88, 
  99, 86, 93, 96, 80, 93, 73, 93, 130, 100, 
  64, 59, 89, 82, 106, 68, 92, 90, 105, 91, 
  74, 133, 84, 84, 88, 92, 57, 112, 78, 70, 
  65, 61, 93, 124, 66, 132, 73, 57, 84, 50, 
  99, 78, 53, 83, 84, 71, 80, 88, 77, 88, 
  68, 67, 98, 68, 47, 88, 76, 117, 86, 69, 
  69, 65, 75, 86, 68, 55, 108, 86, 92, 87, 
  74, 57, 114, 83, 72, 117, 87, 83, 89, 80, 
  99, 79, 90, 79, 64, 73, 88, 89, 82, 64, 
  73, 93, 74, 123, 65, 72, 66, 94, 80, 71, 
  79, 84, 79, 81, 82, 81, 92, 77, 66, 74, 
  48, 86, 74, 88, 77, 93, 80, 101, 96, 70, 
  92, 79, 79, 98, 78, 72, 85, 83, 72, 83, 
  76, 86, 72, 84, 75, 90, 85, 75, 82, 61, 
  84, 79, 95, 108, 75, 66, 93, 78, 88, 59, 
  75, 84, 82, 73, 95, 90, 78, 103, 80, 95, 
  98, 64, 83, 86, 86, 94, 87, 86, 64, 62, 
  101, 77, 84, 98, 78, 77, 90, 69, 79, 89, 
  79, 89, 69, 88, 98, 77, 66, 92, 85, 104, 
  81, 80, 98, 62, 83, 90, 79, 87, 92, 86, 
  70, 84, 86, 92, 90, 77, 74, 75, 75, 95, 
  64, 95, 62, 78, 94, 85, 78, 80, 68, 81, 
  83, 76, 66, 94, 72, 71, 103, 77, 88, 91, 
  87, 89, 83, 77, 82, 79, 73, 78, 86, 98, 
  71, 76, 74, 95, 90, 90, 94, 108, 78, 78, 
  85, 88, 84, 80, 85, 82, 95, 78, 82, 89, 
  80, 73, 76, 83, 79, 88, 82, 69, 93, 75, 
  81, 87, 86, 77, 91, 78, 93, 79, 74, 90, 
  83, 86, 78, 93, 67, 100, 86, 86, 97, 87, 
  78, 100, 94, 96, 85, 91, 75, 65, 102, 82, 
  82, 97, 90, 70, 93, 81, 76, 92, 79, 92, 
  69, 78, 86, 90, 78, 87, 85, 88, 81, 81, 
  90, 79, 88, 76, 82, 92, 81, 78, 82, 80, 
  89, 71, 107, 88, 89, 72, 97, 87, 76, 97, 
  74, 85, 69, 85, 94, 90, 86, 93, 79, 87, 
  65, 97, 76, 81, 97, 84, 78, 100, 84, 71, 
  75, 88, 75, 75, 82, 90, 90, 74, 83, 78, 
  79, 72, 84, 87, 85, 105, 73, 82, 79, 81, 
  82, 72, 80, 89, 71, 88, 89, 77, 78, 93, 
  74, 86, 85, 86, 77, 64, 85, 72, 86, 81, 
  77, 82, 90, 87, 88, 79, 80, 84, 84, 67, 
  57, 80, 67, 99, 81, 87, 97, 99, 81, 95, 
  83, 96, 78, 77, 83, 73, 91, 82, 85, 75, 
  89, 84, 92, 79, 72, 84, 73, 79, 53, 86, 
  92, 96, 67, 83, 71, 82, 70, 96, 86, 84, 
  90, 89, 77, 85, 79, 70, 89, 84, 77, 88, 
  92, 77, 80, 75, 92, 82, 74, 92, 70, 72, 
  88, 76, 80, 78, 79, 95, 73, 100, 60, 94, 
  72, 83, 88, 79, 82, 88, 87, 78, 88, 74, 
  89, 78, 72, 80, 82, 91, 73, 83, 79, 100, 
  95, 94, 95, 91, 80, 79, 77, 93, 91, 80, 
  80, 83, 85, 90, 83, 76, 77, 84, 80, 84, 
  104, 94, 83, 72, 98, 80, 80, 94, 74, 82, 
  87, 81, 91, 82, 73, 88, 87, 77, 86, 95, 
  77, 99, 86, 83, 89, 78, 78, 97, 79, 97, 
  83, 86, 88, 66, 95, 83, 85, 96, 86, 78, 
  84, 72, 79, 94, 87, 80, 70, 79, 94, 83, 
  77, 86, 82, 106, 80, 80, 89, 74, 88, 80, 
  93, 92, 79, 94, 81, 81, 89, 75, 100, 83, 
  86, 72, 95, 89, 77, 87, 74, 79, 75, 80, 
  92, 91, 72, 90, 81, 86, 66, 90, 81, 79, 
  83, 80, 103, 69, 73, 87, 86, 73, 72, 87, 
  84, 78, 83, 48, 57, 82, 87, 103, 85, 78, 
  77, 74, 95, 84, 81, 106, 83, 88, 92, 88, 
  96, 87, 74, 88, 87, 79, 86, 80, 82, 78, 
  72, 74, 83, 78, 76, 73, 88, 85, 78, 75, 
  72, 86, 65, 73, 87, 83, 102, 74, 74, 98, 
  76, 79, 94, 70, 96, 69, 76, 102, 72, 118, 
  87, 86, 98, 96, 75, 82, 76, 87, 82, 68, 
  81, 79, 91, 118, 80, 84, 89, 85, 73, 85, 
  85, 87, 84, 86, 82, 82, 77, 56, 100, 83, 
  93, 85, 104, 93, 77, 87, 81, 80, 81, 72, 
  81, 92, 77, 86, 121, 71, 119, 88, 104, 76, 
  65, 72, 96, 85, 82, 80, 89, 69, 69, 84, 
  90, 72, 82, 83, 86, 67, 64, 87, 88, 66, 
  87, 69, 57, 77, 86, 116, 94, 91, 86, 58, 
  85, 85, 95, 122, 84, 98, 94, 95, 100, 79, 
  70, 74, 88, 69, 82, 77, 60, 73, 63, 76, 
  86, 83, 74, 62, 90, 78, 81, 69, 68, 82, 
  65, 80, 83, 91, 90, 68, 79, 104, 72, 78, 
  88, 62, 96, 61, 73, 102, 61, 114, 99, 90, 
  90, 81, 88, 80, 69, 75, 84, 82, 78, 78, 
  80, 85, 96, 76, 76, 79, 71, 100, 85, 89, 
  82, 96, 70, 97, 94, 55, 96, 82, 73, 83, 
  108, 97, 90, 92, 74, 80, 90, 70, 87, 96, 
  80, 73, 109, 60, 84, 89, 104, 83, 70, 72, 
  89, 85, 85, 82, 83, 63, 79, 80, 86, 74, 
  78, 92, 84, 75, 76, 91, 89, 81, 83, 82, 
  55, 86, 90, 100, 91, 91, 89, 76, 79, 86, 
  86, 101, 92, 90, 87, 80, 94, 79, 75, 65, 
  96, 108, 95, 82, 52, 74, 71, 74, 80, 82, 
  79, 72, 91, 84, 79, 77, 76, 81, 70, 75, 
  90, 99, 106, 76, 75, 94, 76, 85, 92, 69, 
  97, 68, 92, 105, 67, 97, 109, 89, 104, 89, 
  90, 86, 79, 86, 84, 70, 85, 83, 85, 79, 
  85, 81, 84, 85, 75, 90, 86, 105, 83, 91, 
  89, 84, 81, 59, 80, 87, 94, 90, 99, 93, 
  81, 99, 81, 84, 80, 76, 84, 93, 77, 87, 
  97, 68, 84, 87, 105, 81, 78, 69, 89, 87, 
  81, 82, 89, 71, 76, 78, 97, 83, 70, 96, 
  96, 73, 68, 76, 83, 73, 79, 73, 81, 89, 
  84, 101, 91, 71, 85, 79, 87, 87, 91, 112, 
  83, 91, 97, 90, 102, 80, 71, 103, 80, 69, 
  79, 80, 67, 87, 79, 71, 78, 75, 81, 62, 
  90, 87, 79, 61, 63, 80, 64, 84, 82, 80, 
  91, 95, 72, 108, 92, 78, 79, 89, 108, 74, 
  87, 92, 86, 90, 97, 77, 80, 84, 75, 80, 
  74, 78, 91, 78, 72, 88, 79, 87, 84, 71, 
  99, 80, 73, 78, 85, 83, 80, 91, 79, 81, 
  87, 69, 99, 93, 73, 90, 102, 93, 95, 82, 
  82, 78, 79, 74, 93, 85, 77, 89, 85, 67, 
  99, 90, 104, 86, 84, 76, 99, 80, 94, 77, 
  88, 56, 70, 100, 82, 92, 87, 71, 93, 71, 
  75, 66, 87, 63, 87, 64, 81, 85, 87, 89, 
  97, 57, 88, 63, 75, 100, 120, 136, 79, 100, 
  98, 90, 121, 84, 73, 87, 80, 59, 78, 94, 
  66, 92, 86, 84, 83, 61, 79, 64, 100, 77, 
  87, 60, 60, 71, 69, 104, 74, 71, 73, 94, 
  82, 92, 104, 78, 75, 90, 73, 67, 105, 88, 
  86, 77, 69, 93, 74, 86, 79, 80, 79, 70, 
  86, 98, 68, 91, 84, 53, 90, 81, 75, 73, 
  75, 90, 78, 76, 86, 100, 68, 99, 102, 78, 
  110, 91, 68, 76, 103, 97, 98, 77, 77, 73, 
  75, 76, 93, 77, 81, 68, 66, 72, 63, 98, 
  101, 92, 86, 82, 101, 83, 95, 75, 79, 58, 
  69, 105, 100, 84, 71, 89, 94, 68, 71, 77, 
  85, 75, 82, 68, 76, 93, 89, 98, 91, 84, 
  85, 82, 88, 87, 100, 107, 84, 91, 89, 75, 
  100, 82, 68, 72, 87, 96, 85, 86, 68, 83, 
  81, 74, 81, 83, 86, 57, 95, 80, 78, 65, 
  71, 76, 65, 88, 81, 85, 91, 92, 78, 97, 
  88, 75, 81, 82, 103, 72, 97, 94, 79, 92, 
  102, 82, 82, 84, 92, 80, 79, 82, 94, 79, 
  73, 88, 81, 72, 86, 83, 85, 83, 72, 86, 
  85, 79, 80, 91, 78, 85, 86, 78, 90, 90, 
  74, 84, 92, 93, 88, 87, 84, 78, 81, 75, 
  95, 79, 74, 88, 78, 68, 90, 89, 101, 90, 
  78, 77, 87, 78, 91, 81, 86, 57, 86, 79, 
  92, 83, 69, 88, 82, 76, 74, 83, 86, 86, 
  79, 88, 80, 87, 79, 86, 91, 84, 91, 91, 
  97, 90, 87, 96, 88, 85, 91, 84, 92, 90, 
  77, 110, 76, 90, 82, 78, 59, 84, 84, 74, 
  84, 67, 73, 59, 90, 80, 77, 76, 69, 76, 
  71, 85, 84, 88, 93, 90, 85, 91, 91, 80, 
  89, 84, 110, 79, 90, 76, 90, 85, 107, 87, 
  78, 81, 72, 78, 83, 87, 92, 81, 66, 72, 
  81, 89, 75, 80, 94, 77, 95, 89, 75, 77, 
  90, 101, 89, 83, 70, 75, 92, 85, 92, 90, 
  89, 86, 88, 70, 88, 78, 76, 84, 84, 79, 
  69, 86, 75, 72, 88, 89, 91, 90, 90, 75, 
  93, 81, 90, 87, 92, 82, 83, 80, 90, 93, 
  84, 78, 77, 75, 76, 83, 84, 77, 78, 72, 
  82, 81, 84, 88, 95, 81, 91, 77, 86, 89, 
  99, 94, 82, 92, 85, 87, 95, 93, 74, 98, 
  75, 78, 79, 84, 64, 81, 93, 71, 88, 60, 
  70, 68, 89, 82, 81, 75, 65, 76, 68, 95, 
  80, 81, 83, 84, 86, 76, 99, 86, 92, 73, 
  91, 69, 89, 77, 89, 103, 86, 91, 75, 87, 
  72, 75, 93, 78, 95, 100, 58, 62, 79, 70, 
  75, 87, 79, 86, 89, 98, 72, 87, 99, 101, 
  85, 91, 76, 84, 95, 82, 92, 89, 87, 87, 
  84, 69, 85, 75, 64, 80, 82, 90, 71, 77, 
  80, 76, 78, 91, 88, 97, 91, 79, 87, 75, 
  88, 95, 89, 76, 90, 97, 91, 89, 69, 100, 
  79, 72, 78, 88, 90, 89, 81, 61, 76, 86, 
  83, 84, 91, 87, 84, 94, 83, 92, 94, 87, 
  85, 87, 81, 80, 89, 95, 72, 92, 80, 100, 
  82, 83, 85, 81, 82, 77, 80, 72, 79, 68, 
  89, 84, 81, 79, 69, 89, 66, 83, 82, 77, 
  93, 87, 89, 88, 93, 80, 91, 79, 100, 74, 
  86, 76, 90, 95, 92, 90, 79, 81, 76, 80, 
  89, 81, 91, 86, 64, 71, 82, 76, 74, 85, 
  82, 89, 94, 91, 76, 79, 92, 98, 88, 76, 
  72, 81, 93, 83, 88, 82, 86, 86, 87, 75, 
  84, 77, 75, 84, 86, 77, 67, 90, 85, 78, 
  100, 86, 89, 96, 94, 78, 85, 78, 84, 96, 
  89, 80, 83, 81, 89, 86, 90, 88, 83, 86, 
  76, 87, 88, 82, 86, 82, 78, 91, 100, 88, 
  75, 77, 89, 81, 92, 83, 85, 83, 79, 81, 
  87, 82, 84, 79, 89, 83, 88, 92, 89, 78, 
  68, 76, 78, 113, 78, 88, 96, 95, 79, 88, 
  86, 75, 87, 80, 88, 83, 68, 83, 84, 77, 
  82, 98, 67, 77, 84, 93, 99, 95, 82, 89, 
  94, 84, 87, 92, 87, 78, 83, 88, 84, 91, 
  80, 91, 89, 87, 75, 81, 77, 89, 93, 75, 
  91, 76, 71, 82, 86, 88, 83, 83, 85, 77, 
  85, 82, 82, 93, 85, 76, 93, 84, 86, 88, 
  83, 89, 78, 78, 87, 79, 93, 92, 80, 81, 
  81, 75, 71, 79, 84, 81, 77, 89, 95, 88, 
  96, 80, 85, 81, 102, 96, 92, 86, 66, 84, 
  94, 74, 93, 85, 82, 87, 99, 85, 86, 76, 
  82, 76, 85, 84, 94, 88, 72, 83, 79, 91, 
  76, 80, 87, 82, 97, 78, 96, 60, 78, 79, 
  84, 108, 87, 80, 114, 96, 74, 96, 92, 73, 
  83, 77, 78, 84, 75, 88, 73, 78, 74, 95, 
  60, 78, 84, 91, 93, 94, 80, 91, 93, 77, 
  87, 106, 87, 81, 82, 88, 71, 91, 84, 115, 
  90, 84, 92, 80, 72, 92, 85, 76, 92, 76, 
  69, 85, 73, 96, 80, 90, 90, 77, 82, 97, 
  80, 77, 79, 75, 90, 82, 87, 77, 89, 83, 
  79, 82, 86, 79, 90, 85, 82, 84, 76, 72, 
  79, 71, 86, 82, 75, 94, 91, 98, 84, 83, 
  79, 82, 81, 94, 85, 89, 77, 85, 88, 84, 
  83, 75, 77, 86, 96, 89, 82, 80, 78, 81, 
  84, 80, 90, 80, 79, 81, 80, 81, 83, 89, 
  88, 87, 83, 82, 87, 76, 80, 79, 72, 109, 
  88, 85, 102, 89, 81, 89, 83, 74, 89, 80, 
  80, 82, 71, 89, 91, 82, 78, 96, 71, 82, 
  84, 94, 96, 95, 81, 91, 90, 83, 85, 93, 
  87, 80, 85, 89, 86, 93, 76, 96, 89, 86, 
  77, 86, 80, 97, 80, 75, 94, 75, 69, 81, 
  77, 90, 85, 84, 86, 80, 86, 81, 82, 81, 
  82, 75, 97, 90, 89, 87, 82, 86, 76, 77, 
  88, 90, 84, 97, 88, 77, 82, 73, 75, 82, 
  82, 85, 79, 87, 100, 86, 80, 76, 77, 80, 
  85, 82, 82, 88, 82, 78, 97, 82, 93, 80, 
  77, 85, 107, 90, 83, 79, 93, 73, 85, 78, 
  83, 86, 82, 77, 87, 72, 85, 77, 88, 90, 
  94, 87, 75, 84, 68, 73, 75, 96, 74, 96, 
  93, 92, 68, 92, 98, 77, 82, 82, 81, 82, 
  79, 90, 83, 75, 89, 102, 76, 75, 72, 92, 
  96, 93, 79, 86, 107, 84, 93, 87, 85, 76, 
  78, 90, 75, 86, 73, 86, 87, 79, 76, 76, 
  82, 102, 94, 74, 82, 75, 87, 79, 84, 94, 
  83, 90, 87, 88, 95, 90, 74, 93, 80, 76, 
  88, 90, 75, 88, 83, 84, 72, 75, 86, 80, 
  75, 93, 78, 98, 90, 71, 69, 81, 88, 84, 
  85, 76, 90, 75, 88, 85, 84, 77, 99, 84, 
  89, 87, 70, 74, 109, 81, 104, 77, 75, 99, 
  116, 83, 102, 79, 82, 67, 78, 83, 98, 100, 
  81, 81, 81, 89, 82, 91, 93, 86, 98, 70, 
  89, 88, 76, 76, 69, 85, 80, 86, 108, 93, 
  55, 86, 102, 75, 81, 74, 84, 86, 82, 76, 
  77, 73, 73, 113, 77, 68, 71, 95, 83, 78, 
  84, 84, 107, 77, 75, 95, 95, 70, 71, 97, 
  61, 78, 65, 110, 88, 85, 97, 78, 72, 118, 
  78, 74, 86, 78, 99, 72, 68, 109, 75, 88, 
  96, 89, 73, 100, 67, 71, 72, 76, 83, 85, 
  72, 79, 89, 79, 80, 80, 89, 70, 74, 79, 
  73, 107, 89, 67, 81, 76, 102, 83, 90, 78, 
  92, 85, 77, 83, 106, 80, 77, 86, 83, 87, 
  81, 74, 93, 78, 84, 75, 78, 82, 98, 91, 
  87, 87, 74, 76, 76, 77, 98, 78, 78, 77, 
  82, 86, 85, 100, 86, 85, 84, 76, 81, 92, 
  88, 72, 70, 91, 86, 91, 93, 88, 74, 88, 
  99, 76, 89, 86, 78, 81, 83, 78, 88, 76, 
  84, 94, 80, 83, 70, 90, 91, 90, 83, 83, 
  97, 89, 78, 89, 90, 77, 77, 90, 77, 87, 
  64, 90, 87, 78, 78, 92, 87, 113, 77, 79, 
  86, 69, 87, 77, 79, 91, 79, 89, 86, 90, 
  77, 88, 75, 74, 75, 75, 79, 99, 74, 88, 
  80, 82, 81, 75, 85, 87, 81, 97, 81, 95, 
  90, 72, 70, 84, 85, 86, 88, 80, 93, 78, 
  71, 73, 68, 80, 80, 77, 85, 80, 97, 88, 
  89, 82, 80, 71, 66, 91, 91, 79, 79, 86, 
  83, 86, 75, 64, 75, 79, 85, 89, 86, 72, 
  84, 82, 88, 83, 96, 91, 91, 81, 72, 64, 
  76, 70, 77, 91, 76, 80, 96, 72, 96, 81, 
  75, 75, 79, 81, 85, 83, 87, 83, 110, 91, 
  76, 81, 86, 84, 89, 86, 66, 87, 104, 81, 
  93, 66, 90, 76, 82, 79, 91, 79, 109, 60, 
  87, 66, 72, 79, 89, 105, 94, 78, 91, 69, 
  92, 81, 91, 76, 86, 80, 81, 78, 113, 79, 
  88, 85, 98, 77, 86, 80, 76, 99, 72, 85, 
  69, 83, 70, 81, 85, 101, 72, 86, 89, 89, 
  69, 94, 84, 81, 86, 73, 83, 75, 67, 70, 
  89, 81, 79, 70, 84, 79, 92, 89, 94, 84, 
  78, 77, 69, 94, 88, 79, 90, 87, 74, 76, 
  72, 66, 84, 75, 87, 82, 89, 87, 84, 92, 
  88, 81, 87, 76, 91, 105, 78, 56, 68, 61, 
  69, 80, 69, 77, 97, 65, 106, 77, 74, 74, 
  84, 87, 87, 84, 84, 72, 99, 94, 86, 79, 
  83, 82, 81, 71, 70, 84, 115, 92, 81, 67, 
  100, 71, 83, 82, 95, 66, 104, 55, 87, 71, 
  74, 84, 82, 121, 90, 84, 90, 72, 92, 77, 
  87, 84, 89, 73, 93, 79, 92, 80, 79, 77, 
  95, 78, 79, 103, 72, 88, 72, 83, 73, 88, 
  75, 74, 95, 95, 68, 97, 92, 87, 73, 95, 
  84, 78, 84, 77, 82, 72, 64, 74, 105, 80, 
  77, 69, 85, 79, 94, 85, 86, 78, 79, 77, 
  68, 90, 83, 81, 76, 87, 79, 88, 79, 69, 
  90, 75, 83, 86, 83, 105, 89, 90, 90, 81, 
  82, 81, 92, 85, 82, 67, 76, 71, 79, 88, 
  75, 81, 108, 84, 103, 81, 82, 84, 81, 75, 
  84, 70, 82, 81, 112, 86, 75, 87, 81, 79, 
  84, 88, 69, 83, 95, 86, 70, 68, 92, 80, 
  81, 79, 90, 71, 89, 61, 85, 72, 72, 95, 
  89, 110, 88, 87, 92, 69, 92, 76, 96, 76, 
  81, 82, 78, 77, 82, 76, 90, 75, 95, 78, 
  86, 89, 73, 95, 73, 83, 82, 77, 74, 81, 
  94, 103, 80, 85, 92, 90, 69, 96, 85, 81, 
  90, 82, 83, 76, 86, 86, 81, 65, 85, 76, 
  78, 70, 87, 51, 86, 82, 77, 84, 82, 85, 
  69, 83, 83, 76, 91, 93, 88, 80, 84, 84, 
  84, 70, 81, 80, 86, 75, 85, 74, 88, 76, 
  80, 73, 88, 80, 82, 67, 88, 71, 87, 89, 
  77, 88, 88, 75, 83, 91, 71, 67, 102, 84, 
  79, 69, 97, 94, 85, 68, 120, 79, 81, 76, 
  76, 91, 87, 79, 81, 74, 82, 96, 82, 84, 
  81, 81, 73, 70, 86, 87, 90, 91, 97, 140, 
  77, 96, 88, 79, 88, 98, 92, 83, 81, 83, 
  90, 83, 89, 80, 92, 86, 148, 78, 69, 75, 
  78, 85, 80, 82, 79, 80, 94, 81, 83, 88, 
  95, 74, 91, 89, 81, 84, 74, 73, 87, 53, 
  77, 78, 82, 85, 82, 73, 85, 85, 78, 70, 
  85, 49, 91, 86, 76, 86, 86, 85, 69, 86, 
  75, 81, 91, 92, 74, 77, 85, 85, 84, 77, 
  90, 76, 88, 69, 87, 79, 94, 99, 84, 75, 
  86, 72, 78, 69, 86, 75, 91, 85, 77, 78, 
  85, 72, 88, 87, 73, 66, 100, 88, 77, 66, 
  94, 96, 91, 67, 125, 75, 71, 75, 72, 92, 
  85, 78, 88, 73, 75, 93, 78, 83, 87, 70, 
  81, 69, 88, 85, 85, 86, 99, 130, 82, 97, 
  86, 75, 82, 96, 90, 84, 76, 87, 88, 89, 
  77, 76, 88, 94, 158, 81, 69, 77, 81, 88, 
  79, 77, 78, 79, 94, 68, 85, 87, 82, 70, 
  83, 91, 84, 81, 73, 73, 87, 47, 71, 78, 
  83, 80, 79, 74, 86, 95, 83, 78, 92, 58, 
  83, 82, 84, 78, 83, 85, 76, 83, 85, 78, 
  88, 80, 77, 93, 92, 87, 84, 62, 83, 81, 
  88, 71, 93, 77, 91, 115, 75, 81, 80, 76, 
  79, 71, 79, 77, 94, 96, 93, 83, 99, 82, 
  83, 86, 72, 74, 100, 84, 92, 75, 89, 86, 
  78, 74, 110, 77, 71, 79, 91, 90, 89, 82, 
  76, 72, 86, 83, 78, 82, 79, 67, 83, 75, 
  87, 79, 95, 93, 96, 114, 110, 79, 83, 83, 
  91, 88, 92, 87, 76, 89, 88, 78, 72, 96, 
  88, 89, 113, 75, 85, 77, 68, 89, 81, 87, 
  76, 76, 84, 65, 87, 90, 85, 84, 93, 91, 
  89, 89, 91, 68, 86, 70, 85, 88, 88, 77, 
  94, 65, 93, 74, 70, 75, 77, 29, 105, 88, 
  79, 95, 92, 86, 82, 81, 84, 89, 97, 105, 
  81, 77, 78, 90, 79, 90, 95, 83, 85, 80, 
  70, 79, 89, 60, 92, 79, 88, 81, 85, 75, 
  83, 69, 84, 87, 88, 92, 74, 73, 84, 74, 
  76, 70, 87, 81, 71, 71, 94, 111, 87, 70, 
  100, 82, 82, 67, 73, 85, 80, 76, 90, 76, 
  69, 78, 84, 82, 95, 97, 81, 80, 84, 92, 
  75, 70, 99, 82, 67, 107, 85, 68, 69, 80, 
  86, 86, 86, 82, 83, 97, 98, 70, 74, 80, 
  182, 81, 51, 83, 84, 86, 74, 81, 82, 80, 
  91, 104, 77, 87, 89, 52, 78, 88, 88, 86, 
  68, 85, 87, 63, 62, 82, 81, 82, 87, 75, 
  89, 79, 69, 74, 75, 26, 115, 90, 78, 93, 
  97, 87, 88, 86, 86, 87, 82, 111, 70, 78, 
  81, 92, 80, 97, 109, 87, 85, 65, 71, 82, 
  94, 102, 95, 78, 94, 79, 82, 86, 94, 67, 
  87, 81, 85, 77, 66, 76, 88, 73, 78, 66, 
  79, 80, 70, 67, 98, 110, 93, 68, 98, 79, 
  64, 73, 81, 82, 75, 70, 84, 76, 62, 74, 
  72, 82, 101, 79, 84, 82, 86, 91, 74, 74, 
  99, 66, 77, 99, 82, 65, 66, 79, 81, 83, 
  79, 83, 81, 99, 85, 64, 71, 92, 221, 84, 
  51, 81, 91, 84, 70, 77, 81, 82, 95, 70, 
  79, 84, 82, 45, 69, 89, 77, 76, 67, 83, 
  83, 57, 51, 80, 85, 77, 82, 77, 91, 95, 
  76, 82, 88, 52, 90, 85, 92, 85, 87, 95, 
  82, 81, 76, 76, 80, 75, 80, 95, 96, 87, 
  74, 80, 96, 78, 88, 77, 80, 84, 92, 126, 
  89, 86, 85, 85, 84, 72, 87, 77, 92, 100, 
  96, 80, 92, 77, 89, 89, 73, 71, 97, 83, 
  88, 70, 91, 89, 79, 67, 93, 74, 74, 75, 
  89, 85, 95, 83, 81, 68, 74, 83, 71, 86, 
  78, 69, 90, 80, 87, 90, 85, 95, 90, 79, 
  123, 81, 86, 80, 80, 88, 88, 89, 73, 85, 
  82, 83, 75, 93, 79, 95, 98, 78, 79, 88, 
  73, 89, 76, 82, 80, 81, 84, 62, 86, 88, 
  96, 76, 90, 92, 90, 81, 85, 69, 90, 91, 
  75, 83, 90, 82, 85, 61, 90, 78, 76, 86, 
  69, 50, 83, 89, 77, 93, 83, 78, 73, 80, 
  81, 83, 90, 94, 79, 79, 80, 93, 90, 88, 
  79, 80, 82, 96, 85, 85, 81, 69, 94, 78, 
  82, 83, 87, 79, 87, 71, 87, 93, 97, 95, 
  76, 79, 82, 74, 72, 73, 94, 82, 84, 78, 
  89, 96, 84, 79, 90, 83, 83, 74, 86, 90, 
  92, 86, 91, 79, 83, 72, 85, 86, 89, 86, 
  83, 81, 82, 90, 82, 75, 101, 74, 67, 102, 
  82, 84, 83, 79, 91, 93, 93, 85, 76, 83, 
  93, 81, 85, 88, 116, 77, 70, 88, 74, 88, 
  94, 86, 84, 92, 82, 104, 80, 87, 81, 70, 
  90, 87, 87, 85, 75, 81, 91, 108, 71, 83, 
  92, 83, 88, 69, 91, 80, 78, 84, 70, 48, 
  89, 89, 82, 88, 85, 86, 74, 84, 79, 77, 
  86, 95, 76, 80, 81, 92, 90, 95, 92, 93, 
  80, 85, 84, 82, 81, 89, 89, 80, 92, 80, 
  84, 78, 90, 72, 84, 91, 91, 80, 72, 79, 
  80, 83, 76, 70, 93, 83, 87, 74, 89, 100, 
  86, 75, 85, 81, 77, 77, 93, 86, 92, 90, 
  86, 77, 78, 74, 78, 85, 89, 78, 85, 81, 
  83, 92, 80, 81, 97, 72, 74, 95, 81, 80, 
  77, 74, 94, 95, 85, 86, 75, 81, 93, 78, 
  82, 77, 118, 79, 77, 88, 74, 87, 88, 88, 
  84, 87, 80, 76, 86, 86, 88, 66, 87, 88, 
  84, 82, 72, 76, 87, 121, 70, 83, 83, 76, 
  80, 69, 85, 94, 78, 86, 85, 66, 75, 81, 
  90, 86, 87, 84, 79, 76, 81, 74, 84, 78, 
  83, 94, 86, 93, 80, 79, 82, 78, 85, 89, 
  87, 84, 88, 119, 87, 84, 89, 88, 88, 77, 
  90, 81, 92, 93, 97, 81, 90, 83, 85, 88, 
  69, 77, 91, 81, 96, 78, 86, 81, 80, 73, 
  85, 70, 72, 84, 97, 88, 97, 90, 80, 73, 
  82, 81, 74, 90, 90, 69, 85, 82, 83, 84, 
  79, 86, 88, 72, 106, 83, 83, 90, 88, 81, 
  90, 92, 84, 83, 78, 78, 84, 88, 83, 88, 
  99, 75, 79, 87, 67, 90, 90, 85, 85, 86, 
  82, 71, 91, 96, 86, 80, 91, 85, 95, 83, 
  92, 78, 90, 110, 84, 84, 88, 77, 93, 84, 
  86, 92, 70, 96, 77, 88, 93, 86, 88, 83, 
  75, 68, 77, 85, 76, 103, 76, 80, 93, 75, 
  67, 73, 64, 85, 83, 94, 84, 81, 84, 79, 
  83, 90, 70, 79, 91, 73, 73, 78, 70, 82, 
  82, 80, 85, 86, 74, 71, 92, 95, 86, 79, 
  70, 93, 91, 77, 95, 91, 76, 91, 84, 83, 
  91, 67, 83, 85, 84, 67, 85, 87, 83, 85, 
  75, 76, 83, 89, 82, 54, 70, 115, 76, 92, 
  81, 92, 75, 97, 121, 76, 79, 100, 85, 77, 
  95, 85, 84, 90, 89, 72, 89, 77, 89, 81, 
  82, 76, 77, 91, 90, 70, 77, 82, 71, 91, 
  85, 109, 95, 87, 66, 72, 92, 96, 73, 79, 
  87, 89, 85, 86, 79, 85, 97, 81, 93, 87, 
  72, 98, 82, 88, 93, 86, 87, 91, 82, 68, 
  75, 82, 75, 102, 72, 80, 86, 83, 71, 76, 
  67, 85, 90, 89, 81, 80, 79, 80, 80, 84, 
  72, 81, 89, 73, 77, 83, 72, 91, 87, 75, 
  89, 77, 68, 72, 91, 104, 89, 84, 72, 100, 
  88, 80, 99, 89, 75, 89, 87, 90, 92, 76, 
  81, 74, 75, 61, 85, 83, 80, 84, 78, 74, 
  84, 77, 88, 59, 72, 115, 79, 90, 79, 87, 
  80, 91, 130, 87, 77, 95, 81, 75, 89, 85, 
  82, 94, 86, 76, 86, 83, 92, 82, 79, 78, 
  76, 98, 98, 72, 85, 80, 69, 79, 86, 96, 
  75, 84, 64, 76, 79, 90, 75, 78, 88, 87, 
  85, 88, 83, 82, 85, 83, 87, 97, 75, 93, 
  78, 86, 81, 86, 88, 93, 77, 71, 78, 88, 
  78, 97, 72, 80, 90, 77, 77, 83, 69, 86, 
  85, 87, 93, 89, 86, 81, 88, 96, 88, 76, 
  78, 78, 71, 79, 77, 70, 77, 83, 83, 95, 
  81, 75, 87, 84, 86, 79, 81, 77, 90, 76, 
  87, 89, 81, 95, 76, 75, 84, 64, 90, 87, 
  83, 75, 90, 92, 85, 81, 80, 76, 83, 82, 
  88, 61, 72, 106, 80, 95, 83, 83, 92, 89, 
  100, 86, 80, 100, 92, 80, 93, 83, 87, 90, 
  81, 80, 86, 97, 85, 84, 81, 82, 69, 87, 
  95, 73, 81, 91, 76, 80, 82, 95, 80, 89, 
  72, 73, 74, 94, 73, 80, 83, 91, 87, 86, 
  74, 81, 96, 75, 83, 90, 57, 87, 67, 82, 
  89, 95, 83, 106, 87, 71, 77, 64, 71, 105, 
  79, 77, 85, 86, 68, 67, 61, 79, 91, 89, 
  82, 82, 75, 87, 89, 86, 80, 83, 82, 75, 
  86, 61, 69, 90, 75, 86, 80, 94, 65, 70, 
  99, 103, 85, 91, 65, 97, 77, 95, 104, 79, 
  76, 74, 89, 82, 83, 58, 87, 72, 77, 52, 
  82, 86, 70, 76, 77, 74, 80, 87, 81, 76, 
  71, 151, 79, 70, 84, 89, 77, 97, 151, 68, 
  66, 84, 89, 72, 98, 85, 89, 84, 75, 69, 
  74, 77, 88, 81, 90, 81, 74, 85, 85, 66, 
  89, 71, 66, 85, 96, 113, 77, 85, 59, 83, 
  91, 104, 79, 68, 96, 83, 82, 89, 73, 89, 
  93, 72, 88, 81, 62, 91, 75, 83, 90, 91, 
  87, 102, 93, 74, 77, 68, 72, 106, 71, 79, 
  80, 91, 71, 69, 69, 81, 94, 78, 75, 74, 
  74, 85, 76, 82, 75, 82, 99, 76, 83, 67, 
  77, 97, 74, 78, 79, 80, 61, 69, 95, 104, 
  90, 95, 64, 123, 78, 95, 99, 73, 72, 73, 
  83, 85, 76, 66, 91, 65, 75, 58, 93, 79, 
  73, 78, 77, 67, 81, 80, 87, 81, 72, 150, 
  83, 73, 84, 84, 78, 91, 155, 68, 69, 78, 
  82, 69, 84, 84, 87, 83, 74, 75, 72, 78, 
  92, 82, 86, 82, 74, 86, 95, 66, 94, 71, 
  68, 73, 94, 99, 74, 82, 56, 86, 76, 96, 
  81, 67, 97, 81, 78, 93, 75, 90, 78, 80, 
  78, 99, 67, 88, 72, 83, 85, 94, 83, 85, 
  85, 75, 77, 74, 71, 102, 71, 71, 89, 85, 
  81, 78, 70, 81, 87, 88, 86, 87, 81, 90, 
  90, 95, 96, 79, 84, 73, 89, 65, 81, 73, 
  75, 86, 76, 100, 74, 75, 92, 79, 85, 87, 
  79, 95, 82, 89, 96, 77, 83, 84, 82, 74, 
  77, 60, 95, 78, 80, 78, 82, 94, 79, 75, 
  80, 70, 87, 89, 88, 83, 73, 127, 80, 88, 
  88, 87, 89, 88, 107, 79, 70, 75, 94, 82, 
  88, 86, 88, 86, 75, 74, 73, 91, 83, 86, 
  85, 80, 73, 79, 86, 69, 87, 78, 74, 78, 
  87, 102, 85, 84, 68, 85, 72, 99, 74, 72, 
  89, 85, 81, 90, 90, 81, 85, 85, 85, 88, 
  74, 87, 88, 85, 87, 81, 85, 87, 77, 73, 
  86, 85, 76, 85, 87, 78, 75, 91, 76, 72, 
  84, 84, 83, 87, 82, 82, 85, 91, 86, 83, 
  83, 97, 69, 77, 97, 76, 79, 73, 82, 98, 
  84, 94, 80, 70, 88, 79, 98, 85, 91, 77, 
  105, 87, 80, 81, 88, 95, 95, 90, 82, 73, 
  94, 90, 88, 75, 86, 86, 88, 77, 84, 88, 
  76, 80, 78, 62, 76, 79, 91, 70, 76, 85, 
  77, 76, 99, 89, 87, 90, 95, 86, 106, 79, 
  88, 86, 83, 83, 81, 88, 94, 84, 86, 90, 
  73, 75, 92, 82, 73, 92, 79, 89, 87, 96, 
  92, 92, 81, 87, 87, 84, 74, 82, 81, 92, 
  89, 79, 93, 89, 78, 81, 82, 80, 69, 87, 
  93, 85, 90, 78, 85, 78, 81, 74, 87, 87, 
  79, 92, 82, 79, 75, 94, 83, 73, 86, 86, 
  78, 81, 73, 84, 83, 91, 78, 81, 84, 95, 
  79, 71, 91, 74, 79, 74, 83, 93, 83, 88, 
  78, 71, 85, 74, 102, 85, 89, 85, 109, 83, 
  83, 81, 88, 99, 94, 92, 76, 76, 99, 95, 
  86, 79, 80, 82, 92, 76, 86, 82, 79, 77, 
  76, 66, 77, 74, 92, 79, 79, 82, 79, 69, 
  86, 90, 87, 80, 91, 87, 95, 79, 87, 88, 
  80, 89, 82, 91, 97, 85, 83, 93, 77, 71, 
  98, 82, 71, 91, 80, 83, 87, 94, 87, 90, 
  79, 83, 79, 82, 76, 82, 83, 93, 89, 84, 
  90, 87, 81, 81, 88, 87, 78, 82, 88, 87, 
  87, 86, 91, 72, 73, 79, 86, 90, 80, 86, 
  81, 79, 87, 86, 85, 75, 82, 85, 83, 90, 
  83, 83, 86, 94, 88, 86, 95, 91, 79, 82, 
  97, 71, 84, 72, 79, 93, 83, 91, 85, 76, 
  85, 78, 93, 85, 93, 78, 92, 84, 79, 74, 
  89, 97, 89, 82, 81, 74, 93, 89, 85, 92, 
  78, 88, 88, 79, 82, 77, 79, 92, 85, 65, 
  86, 80, 90, 86, 77, 87, 84, 80, 84, 83, 
  86, 70, 100, 86, 88, 79, 86, 84, 78, 79, 
  84, 83, 90, 87, 85, 81, 81, 74, 90, 80, 
  74, 96, 83, 80, 90, 85, 97, 94, 83, 88, 
  76, 84, 71, 80, 85, 91, 90, 80, 85, 87, 
  85, 78, 79, 91, 80, 97, 82, 58, 90, 94, 
  78, 86, 68, 85, 74, 87, 88, 85, 92, 88, 
  78, 79, 88, 79, 84, 67, 78, 73, 94, 85, 
  84, 87, 77, 91, 83, 75, 94, 73, 90, 59, 
  82, 96, 84, 90, 84, 88, 78, 89, 80, 83, 
  78, 91, 89, 86, 85, 87, 97, 89, 94, 80, 
  81, 86, 77, 83, 86, 95, 81, 77, 92, 83, 
  92, 87, 90, 81, 85, 89, 62, 75, 85, 85, 
  95, 86, 81, 107, 95, 86, 76, 90, 98, 95, 
  107, 89, 84, 96, 98, 81, 91, 96, 92, 79, 
  84, 88, 103, 78, 75, 85, 76, 82, 89, 90, 
  96, 65, 87, 83, 84, 83, 76, 83, 76, 75, 
  78, 92, 85, 61, 86, 83, 88, 91, 80, 77, 
  82, 83, 76, 103, 84, 84, 83, 89, 73, 88, 
  75, 82, 77, 78, 83, 83, 78, 91, 72, 71, 
  91, 91, 87, 73, 86, 81, 93, 80, 83, 89, 
  85, 86, 82, 75, 83, 78, 74, 56, 83, 93, 
  85, 76, 87, 84, 84, 96, 81, 83, 87, 82, 
  85, 88, 95, 86, 89, 90, 94, 81, 81, 76, 
  74, 88, 77, 91, 76, 84, 80, 86, 87, 78, 
  81, 81, 85, 80, 71, 86, 85, 89, 89, 83, 
  80, 102, 95, 85, 83, 88, 102, 83, 94, 89, 
  76, 90, 93, 81, 76, 80, 85, 71, 84, 86, 
  85, 72, 81, 88, 62, 80, 86, 83, 79, 62, 
  88, 90, 96, 84, 81, 85, 86, 83, 71, 96, 
  80, 63, 80, 83, 102, 84, 87, 82, 85, 78, 
  77, 107, 88, 101, 77, 84, 89, 88, 87, 79, 
  89, 71, 83, 82, 88, 82, 81, 67, 101, 96, 
  91, 83, 75, 91, 90, 69, 87, 82, 85, 90, 
  92, 71, 87, 81, 80, 71, 83, 93, 91, 76, 
  95, 80, 95, 92, 73, 83, 84, 80, 85, 88, 
  98, 82, 85, 89, 87, 86, 83, 79, 90, 92, 
  85, 92, 80, 94, 89, 79, 88, 86, 83, 64, 
  79, 87, 79, 78, 84, 84, 96, 79, 90, 87, 
  124, 80, 84, 90, 94, 81, 78, 89, 81, 85, 
  95, 79, 92, 75, 96, 79, 100, 83, 65, 84, 
  84, 96, 81, 77, 93, 83, 68, 53, 88, 96, 
  87, 80, 105, 92, 98, 84, 65, 103, 74, 77, 
  75, 85, 83, 94, 91, 80, 78, 86, 83, 71, 
  85, 41, 69, 87, 80, 95, 77, 89, 71, 92, 
  66, 92, 86, 95, 78, 94, 79, 70, 93, 83, 
  101, 75, 70, 96, 77, 76, 70, 91, 94, 124, 
  98, 72, 86, 76, 89, 85, 88, 86, 84, 94, 
  79, 74, 84, 80, 75, 84, 80, 87, 63, 80, 
  85, 71, 78, 79, 90, 83, 70, 92, 75, 73, 
  77, 84, 86, 74, 83, 84, 88, 64, 94, 93, 
  66, 79, 84, 84, 62, 71, 67, 69, 97, 87, 
  79, 78, 62, 89, 95, 97, 75, 89, 91, 85, 
  93, 85, 70, 85, 80, 90, 148, 85, 83, 79, 
  88, 82, 92, 92, 90, 78, 81, 80, 67, 106, 
  63, 80, 76, 73, 77, 60, 93, 77, 73, 91, 
  80, 85, 78, 76, 76, 96, 72, 74, 77, 72, 
  67, 84, 69, 92, 75, 88, 76, 83, 80, 90, 
  72, 97, 65, 78, 91, 75, 86, 75, 110, 77, 
  81, 103, 70, 88, 77, 86, 85, 95, 83, 79, 
  83, 75, 81, 92, 80, 81, 81, 90, 87, 82, 
  82, 84, 84, 75, 83, 82, 82, 73, 89, 76, 
  85, 82, 87, 55, 59, 85, 63, 87, 79, 91, 
  68, 81, 86, 86, 78, 85, 96, 87, 65, 86, 
  86, 84, 64, 77, 70, 66, 124, 92, 72, 82, 
  85, 93, 94, 102, 94, 90, 90, 79, 68, 75, 
  74, 81, 84, 86, 118, 78, 93, 85, 65, 71, 
  86, 90, 84, 60, 73, 86, 95, 99, 63, 84, 
  73, 78, 62, 76, 83, 68, 80, 79, 104, 76, 
  80, 76, 87, 64, 78, 100, 81, 95, 79, 84, 
  92, 91, 84, 84, 91, 63, 93, 83, 84, 79, 
  74, 66, 102, 101, 85, 74, 92, 81, 94, 79, 
  87, 90, 80, 88, 95, 59, 83, 91, 88, 76, 
  75, 97, 82, 77, 93, 88, 94, 89, 79, 86, 
  91, 79, 88, 86, 95, 79, 93, 93, 82, 80, 
  83, 55, 69, 85, 75, 96, 91, 86, 74, 80, 
  83, 88, 78, 70, 77, 80, 67, 84, 92, 95, 
  104, 75, 94, 75, 165, 78, 79, 86, 106, 88, 
  86, 89, 79, 87, 88, 75, 86, 78, 87, 86, 
  80, 82, 49, 79, 94, 96, 76, 81, 93, 76, 
  70, 51, 78, 98, 80, 75, 95, 90, 93, 81, 
  78, 106, 81, 85, 71, 82, 84, 96, 89, 92, 
  82, 83, 72, 65, 87, 40, 75, 82, 78, 102, 
  75, 88, 73, 78, 75, 93, 86, 88, 86, 93, 
  86, 74, 102, 88, 84, 81, 80, 87, 87, 78, 
  67, 93, 83, 135, 80, 72, 89, 85, 82, 81, 
  75, 89, 84, 91, 73, 80, 81, 89, 73, 89, 
  77, 90, 70, 81, 75, 83, 62, 83, 101, 90, 
  79, 91, 74, 80, 87, 79, 78, 83, 93, 79, 
  93, 75, 89, 88, 87, 80, 87, 81, 72, 77, 
  78, 70, 109, 84, 80, 70, 64, 81, 90, 103, 
  65, 68, 91, 79, 97, 90, 75, 88, 68, 89, 
  110, 90, 88, 78, 77, 96, 86, 96, 80, 94, 
  81, 98, 82, 98, 90, 91, 81, 84, 95, 64, 
  97, 102, 82, 85, 81, 93, 76, 86, 77, 87, 
  70, 70, 87, 68, 72, 91, 74, 83, 74, 89, 
  79, 75, 85, 86, 81, 87, 76, 80, 100, 73, 
  98, 88, 98, 77, 81, 102, 80, 89, 72, 85, 
  84, 109, 91, 77, 84, 76, 78, 88, 73, 85, 
  84, 83, 86, 80, 83, 93, 81, 81, 78, 79, 
  85, 74, 86, 76, 68, 78, 96, 68, 69, 88, 
  66, 86, 87, 86, 75, 79, 90, 88, 87, 89, 
  88, 91, 75, 86, 87, 83, 74, 79, 75, 69, 
  115, 83, 74, 77, 87, 84, 90, 100, 83, 70, 
  99, 76, 75, 82, 80, 86, 81, 84, 107, 85, 
  92, 85, 77, 81, 83, 90, 79, 68, 83, 92, 
  92, 86, 80, 91, 79, 79, 75, 76, 89, 94, 
  85, 80, 97, 75, 81, 79, 87, 69, 73, 91, 
  82, 94, 81, 85, 87, 95, 83, 88, 87, 60, 
  84, 84, 90, 82, 80, 69, 102, 92, 89, 78, 
  81, 77, 95, 87, 91, 97, 80, 91, 91, 66, 
  86, 88, 91, 74, 74, 97, 76, 84, 88, 93, 
  91, 90, 77, 91, 84, 81, 86, 80, 90, 81, 
  96, 91, 75, 78, 88, 61, 84, 89, 74, 99, 
  93, 91, 71, 84, 81, 88, 80, 73, 84, 79, 
  68, 78, 87, 89, 98, 76, 92, 73, 144, 72, 
  78, 87, 104, 84, 89, 89, 78, 76, 100, 76, 
  86, 79, 86, 92, 93, 85, 71, 87, 87, 89, 
  85, 78, 93, 82, 80, 59, 86, 98, 78, 74, 
  102, 86, 94, 82, 67, 115, 79, 90, 78, 82, 
  71, 99, 86, 93, 100, 83, 89, 90, 89, 86, 
  71, 64, 58, 89, 87, 91, 85, 105, 97, 112, 
  82, 67, 102, 94, 73, 97, 92, 91, 80, 75, 
  90, 88, 93, 76, 95, 86, 93, 92, 58, 81, 
  89, 74, 88, 97, 74, 104, 82, 73, 86, 81, 
  89, 87, 65, 91, 93, 89, 84, 113, 82, 82, 
  76, 86, 74, 66, 111, 73, 69, 72, 82, 90, 
  87, 65, 94, 77, 98, 84, 83, 80, 91, 85, 
  97, 93, 85, 96, 86, 84, 95, 71, 92, 88, 
  78, 90, 83, 95, 91, 88, 97, 80, 84, 99, 
  80, 88, 75, 83, 99, 84, 90, 74, 85, 78, 
  82, 83, 91, 99, 89, 79, 70, 79, 90, 76, 
  67, 86, 89, 97, 84, 83, 84, 85, 100, 91, 
  79, 76, 74, 69, 78, 84, 75, 80, 80, 86, 
  83, 70, 73, 71, 76, 79, 74, 84, 84, 102, 
  79, 77, 75, 69, 88, 78, 95, 80, 83, 68, 
  93, 91, 82, 84, 80, 84, 89, 81, 83, 78, 
  93, 83, 73, 86, 85, 86, 72, 83, 89, 78, 
  83, 81, 77, 91, 71, 91, 59, 87, 88, 108, 
  75, 114, 71, 73, 68, 84, 66, 73, 98, 105, 
  76, 78, 76, 73, 78, 72, 82, 81, 79, 77, 
  76, 89, 82, 86, 86, 89, 78, 86, 85, 82, 
  85, 88, 82, 89, 77, 75, 91, 84, 82, 92, 
  89, 86, 77, 90, 80, 87, 77, 76, 89, 85, 
  77, 81, 62, 90, 60, 94, 98, 83, 76, 90, 
  78, 71, 80, 86, 84, 74, 112, 86, 90, 81, 
  74, 66, 83, 85, 71, 83, 84, 91, 74, 83, 
  75, 71, 82, 77, 86, 81, 88, 103, 76, 83, 
  87, 72, 87, 79, 93, 95, 95, 97, 87, 83, 
  86, 106, 79, 94, 73, 90, 93, 77, 93, 81, 
  73, 85, 96, 82, 76, 82, 82, 74, 83, 74, 
  75, 87, 78, 86, 69, 72, 82, 107, 76, 118, 
  81, 67, 80, 95, 65, 80, 73, 103, 79, 80, 
  85, 74, 76, 100, 96, 74, 76, 75, 90, 79, 
  84, 99, 78, 95, 82, 87, 75, 79, 86, 88, 
  86, 89, 79, 83, 95, 81, 81, 81, 93, 86, 
  74, 87, 66, 82, 80, 74, 102, 96, 79, 85, 
  85, 97, 91, 91, 96, 79, 73, 88, 74, 73, 
  79, 95, 86, 78, 67, 110, 87, 96, 92, 76, 
  84, 87, 90, 87, 75, 72, 60, 78, 85, 94, 
  84, 104, 107, 124, 80, 63, 96, 95, 85, 100, 
  91, 94, 77, 73, 92, 87, 85, 66, 78, 78, 
  91, 89, 70, 79, 83, 76, 81, 91, 72, 104, 
  87, 74, 90, 80, 91, 88, 72, 82, 94, 78, 
  97, 98, 92, 88, 80, 72, 84, 48, 94, 62, 
  74, 83, 73, 102, 75, 64, 92, 80, 98, 93, 
  72, 71, 85, 85, 88, 101, 89, 97, 81, 79, 
  91, 67, 109, 93, 85, 90, 79, 96, 85, 79, 
  97, 71, 85, 93, 76, 82, 80, 86, 98, 83, 
  102, 81, 99, 83, 82, 75, 102, 100, 80, 79, 
  82, 73, 84, 91, 71, 78, 89, 109, 81, 76, 
  83, 91, 97, 91, 86, 70, 81, 62, 65, 75, 
  76, 85, 88, 91, 85, 86, 73, 71, 83, 63, 
  69, 76, 78, 119, 61, 69, 71, 65, 62, 78, 
  112, 79, 88, 65, 90, 97, 69, 80, 84, 78, 
  68, 92, 67, 74, 96, 86, 75, 70, 83, 104, 
  70, 85, 76, 96, 76, 84, 74, 63, 83, 76, 
  70, 73, 79, 121, 82, 115, 42, 97, 70, 74, 
  79, 65, 78, 78, 72, 84, 70, 69, 69, 60, 
  87, 81, 68, 71, 71, 91, 90, 79, 77, 104, 
  65, 80, 79, 76, 77, 75, 76, 93, 75, 70, 
  78, 84, 76, 77, 94, 88, 78, 81, 88, 91, 
  71, 77, 94, 82, 68, 72, 74, 73, 63, 88, 
  89, 88, 73, 87, 71, 61, 83, 76, 83, 77, 
  103, 84, 87, 81, 78, 54, 79, 78, 75, 88, 
  90, 86, 86, 73, 80, 74, 91, 64, 76, 81, 
  93, 103, 55, 78, 77, 73, 65, 84, 109, 101, 
  94, 92, 86, 78, 77, 108, 84, 93, 96, 95, 
  78, 68, 83, 84, 77, 74, 93, 82, 74, 88, 
  75, 83, 82, 72, 72, 77, 88, 84, 76, 69, 
  72, 113, 80, 133, 61, 99, 78, 87, 79, 65, 
  82, 73, 74, 97, 88, 69, 69, 118, 99, 69, 
  67, 72, 84, 73, 81, 96, 58, 106, 73, 82, 
  80, 87, 85, 76, 87, 97, 73, 75, 95, 87, 
  73, 71, 96, 85, 74, 78, 81, 83, 69, 79, 
  93, 95, 76, 67, 76, 80, 103, 85, 89, 85, 
  75, 82, 76, 68, 79, 90, 86, 80, 77, 106, 
  102, 89, 92, 82, 88, 78, 87, 88, 82, 72, 
  63, 84, 88, 96, 87, 103, 94, 111, 79, 71, 
  96, 95, 91, 94, 88, 84, 73, 79, 90, 85, 
  87, 65, 89, 70, 98, 88, 85, 89, 77, 94, 
  91, 89, 80, 96, 81, 83, 83, 74, 91, 92, 
  77, 87, 98, 90, 82, 95, 89, 77, 82, 75, 
  80, 63, 89, 78, 86, 77, 79, 110, 79, 68, 
  85, 87, 96, 85, 87, 81, 78, 83, 89, 95, 
  95, 104, 90, 77, 87, 70, 97, 89, 86, 94, 
  79, 84, 83, 79, 96, 79, 87, 88, 80, 91, 
  82, 92, 89, 87, 99, 83, 101, 82, 97, 77, 
  94, 97, 80, 90, 81, 76, 94, 89, 70, 82, 
  82, 94, 80, 84, 86, 86, 95, 81, 96, 80, 
  83, 69, 77, 76, 67, 85, 92, 86, 84, 91, 
  73, 75, 85, 65, 72, 78, 82, 116, 60, 80, 
  73, 67, 78, 76, 91, 74, 103, 69, 88, 94, 
  86, 65, 98, 80, 59, 84, 81, 87, 92, 80, 
  77, 60, 81, 93, 78, 84, 78, 98, 77, 74, 
  82, 74, 77, 77, 72, 81, 85, 111, 83, 129, 
  52, 83, 76, 87, 92, 76, 76, 82, 78, 87, 
  76, 71, 83, 72, 97, 74, 72, 85, 79, 94, 
  94, 86, 77, 99, 82, 78, 77, 79, 85, 81, 
  75, 87, 77, 76, 85, 87, 76, 70, 91, 90, 
  84, 81, 86, 88, 78, 78, 97, 88, 72, 77, 
  99, 79, 47, 89, 97, 86, 76, 84, 73, 63, 
  85, 87, 84, 84, 95, 89, 97, 92, 76, 70, 
  85, 76, 70, 87, 91, 90, 84, 62, 78, 79, 
  92, 79, 84, 91, 100, 98, 73, 88, 78, 76, 
  86, 86, 89, 103, 89, 86, 87, 72, 74, 89, 
  91, 92, 94, 89, 91, 82, 74, 81, 80, 77, 
  88, 82, 72, 85, 85, 90, 82, 67, 93, 79, 
  80, 84, 77, 82, 85, 91, 77, 121, 71, 85, 
  82, 96, 89, 81, 84, 86, 83, 97, 90, 72, 
  85, 102, 85, 67, 72, 87, 83, 88, 86, 100, 
  70, 88, 85, 82, 79, 102, 86, 80, 86, 89, 
  80, 72, 101, 86, 70, 84, 94, 88, 87, 86, 
  87, 86, 71, 82, 85, 94, 83, 76, 79, 85, 
  88, 78, 94, 84, 77, 84, 76, 71, 83, 100, 
  87, 88, 92, 86, 110, 77, 79, 92, 76, 83, 
  65, 93, 97, 103, 80, 97, 73, 98, 81, 73, 
  92, 105, 105, 90, 78, 87, 71, 79, 95, 87, 
  90, 79, 114, 77, 79, 71, 79, 95, 87, 81, 
  98, 77, 86, 80, 74, 95, 95, 95, 81, 67, 
  72, 82, 81, 73, 79, 80, 88, 86, 82, 79, 
  93, 84, 78, 71, 75, 76, 67, 81, 81, 91, 
  88, 72, 89, 84, 67, 98, 85, 79, 88, 89, 
  82, 76, 88, 79, 89, 86, 74, 96, 86, 80, 
  74, 98, 88, 90, 87, 80, 75, 83, 74, 79, 
  91, 90, 83, 89, 81, 72, 81, 89, 81, 76, 
  67, 75, 74, 94, 81, 85, 84, 90, 62, 73, 
  87, 74, 88, 77, 65, 98, 80, 93, 96, 87, 
  112, 73, 91, 75, 90, 97, 66, 74, 55, 85, 
  91, 112, 86, 99, 62, 99, 88, 88, 103, 97, 
  77, 95, 99, 73, 87, 67, 86, 83, 95, 72, 
  144, 98, 77, 84, 86, 73, 89, 83, 106, 76, 
  93, 76, 98, 116, 105, 114, 76, 69, 69, 73, 
  91, 64, 66, 81, 78, 91, 99, 78, 84, 76, 
  92, 59, 83, 83, 62, 75, 73, 100, 87, 64, 
  89, 77, 42, 108, 78, 81, 106, 74, 73, 71, 
  89, 83, 81, 77, 69, 88, 88, 70, 71, 91, 
  77, 104, 85, 78, 73, 81, 87, 87, 78, 60, 
  79, 71, 73, 67, 71, 89, 73, 69, 66, 80, 
  83, 112, 77, 83, 82, 88, 76, 66, 81, 64, 
  85, 90, 52, 88, 71, 93, 122, 79, 85, 73, 
  71, 84, 79, 65, 87, 83, 73, 94, 91, 89, 
  88, 88, 76, 96, 78, 71, 86, 93, 73, 86, 
  82, 90, 86, 86, 87, 84, 84, 81, 99, 79, 
  81, 85, 80, 80, 89, 89, 84, 79, 75, 76, 
  102, 88, 91, 91, 81, 94, 68, 86, 85, 80, 
  82, 84, 73, 76, 77, 85, 96, 90, 84, 67, 
  81, 70, 72, 87, 84, 94, 92, 81, 89, 79, 
  67, 78, 80, 86, 86, 72, 79, 79, 90, 78, 
  81, 82, 78, 81, 87, 86, 78, 101, 90, 100, 
  87, 78, 96, 85, 71, 71, 88, 91, 90, 81, 
  82, 80, 85, 90, 74, 80, 73, 76, 87, 85, 
  77, 87, 85, 97, 95, 81, 88, 84, 83, 79, 
  75, 94, 80, 89, 90, 90, 94, 93, 90, 77, 
  86, 83, 79, 90, 58, 85, 97, 118, 83, 93, 
  67, 88, 92, 91, 96, 111, 115, 79, 87, 91, 
  77, 71, 100, 89, 94, 71, 95, 75, 89, 73, 
  89, 99, 84, 84, 92, 79, 94, 98, 69, 110, 
  84, 85, 78, 64, 84, 78, 82, 77, 84, 89, 
  88, 86, 90, 65, 89, 78, 69, 75, 80, 73, 
  66, 76, 68, 95, 81, 73, 79, 82, 68, 102, 
  102, 79, 94, 93, 82, 81, 78, 90, 83, 67, 
  83, 90, 88, 73, 67, 86, 80, 78, 89, 80, 
  50, 83, 86, 78, 120, 72, 68, 97, 84, 70, 
  82, 87, 79, 82, 79, 90, 77, 101, 78, 88, 
  83, 91, 62, 73, 81, 71, 84, 77, 65, 89, 
  69, 85, 103, 75, 114, 68, 75, 84, 86, 94, 
  57, 91, 46, 74, 91, 137, 85, 99, 59, 65, 
  111, 111, 118, 77, 72, 86, 92, 71, 113, 56, 
  109, 84, 104, 89, 106, 107, 94, 74, 91, 63, 
  77, 72, 94, 76, 77, 94, 93, 128, 86, 121, 
  84, 74, 80, 68, 93, 73, 67, 95, 100, 90, 
  118, 64, 75, 75, 67, 83, 81, 85, 84, 71, 
  66, 95, 78, 78, 80, 75, 46, 102, 95, 77, 
  121, 75, 72, 77, 75, 93, 89, 82, 77, 79, 
  90, 59, 62, 82, 69, 71, 80, 81, 29, 84, 
  108, 102, 95, 46, 58, 75, 82, 65, 72, 95, 
  88, 70, 79, 91, 85, 131, 79, 82, 86, 85, 
  85, 55, 83, 64, 71, 91, 47, 74, 56, 81, 
  133, 63, 80, 69, 72, 92, 84, 74, 82, 86, 
  67, 91, 93, 110, 97, 90, 69, 87, 86, 92, 
  91, 88, 70, 81, 79, 91, 113, 73, 91, 86, 
  86, 97, 89, 89, 85, 97, 78, 73, 79, 91, 
  82, 82, 90, 92, 116, 100, 85, 90, 92, 97, 
  84, 81, 85, 81, 88, 92, 77, 79, 86, 70, 
  93, 78, 77, 77, 83, 63, 72, 81, 86, 93, 
  74, 78, 75, 79, 59, 92, 94, 87, 92, 76, 
  70, 82, 89, 89, 79, 93, 83, 82, 88, 85, 
  75, 91, 82, 94, 88, 78, 81, 87, 86, 69, 
  78, 73, 78, 76, 82, 76, 86, 86, 75, 88, 
  80, 89, 86, 91, 83, 88, 89, 96, 95, 80, 
  83, 76, 65, 79, 72, 90, 73, 82, 97, 79, 
  87, 87, 79, 82, 93, 90, 85, 98, 69, 94, 
  93, 94, 93, 79, 71, 92, 100, 83, 85, 92, 
  82, 88, 62, 92, 82, 86, 91, 87, 80, 71, 
  81, 74, 87, 80, 84, 92, 82, 85, 86, 88, 
  90, 86, 79, 93, 70, 81, 89, 65, 84, 76, 
  79, 90, 82, 97, 90, 93, 80, 76, 95, 85, 
  79, 89, 92, 75, 79, 84, 81, 88, 80, 86, 
  80, 74, 84, 92, 93, 94, 87, 84, 83, 79, 
  83, 76, 88, 85, 87, 87, 85, 88, 77, 72, 
  95, 82, 90, 86, 63, 72, 75, 72, 112, 82, 
  79, 98, 87, 79, 76, 76, 77, 95, 90, 89, 
  69, 80, 77, 88, 93, 98, 85, 85, 88, 87, 
  96, 82, 75, 101, 78, 82, 86, 74, 91, 84, 
  73, 82, 94, 74, 75, 99, 64, 94, 95, 98, 
  91, 89, 69, 95, 107, 91, 87, 91, 70, 77, 
  79, 84, 99, 73, 92, 88, 89, 90, 80, 77, 
  89, 81, 84, 77, 85, 72, 87, 86, 87, 76, 
  73, 106, 68, 82, 99, 70, 79, 78, 76, 83, 
  82, 95, 84, 86, 81, 74, 84, 100, 74, 85, 
  99, 81, 89, 81, 75, 91, 78, 78, 75, 79, 
  70, 87, 103, 93, 84, 79, 88, 71, 86, 81, 
  82, 84, 88, 82, 86, 90, 77, 66, 87, 73, 
  82, 82, 56, 73, 84, 83, 93, 67, 75, 94, 
  89, 71, 80, 81, 84, 90, 87, 91, 76, 82, 
  77, 81, 102, 92, 91, 81, 88, 88, 80, 71, 
  70, 103, 70, 78, 104, 70, 82, 80, 77, 86, 
  86, 56, 86, 94, 71, 93, 93, 92, 94, 85, 
  76, 89, 93, 83, 85, 80, 86, 87, 90, 87, 
  106, 86, 87, 86, 76, 85, 82, 82, 86, 90, 
  78, 78, 82, 86, 82, 88, 84, 80, 86, 88, 
  71, 82, 100, 93, 81, 77, 79, 85, 81, 92, 
  91, 80, 79, 77, 96, 82, 81, 88, 91, 64, 
  94, 89, 90, 86, 75, 82, 75, 67, 84, 90, 
  97, 97, 85, 77, 77, 83, 88, 80, 85, 91, 
  86, 83, 90, 93, 82, 81, 98, 87, 88, 86, 
  81, 79, 78, 74, 80, 84, 84, 89, 82, 81, 
  75, 82, 77, 95, 87, 84, 85, 77, 79, 86, 
  99, 93, 89, 84, 88, 90, 71, 84, 75, 92, 
  82, 83, 88, 78, 74, 72, 110, 81, 81, 81, 
  85, 91, 82, 83, 76, 72, 89, 98, 74, 92, 
  85, 92, 85, 86, 83, 83, 85, 103, 82, 74, 
  84, 77, 84, 68, 73, 85, 91, 74, 58, 79, 
  79, 79, 78, 92, 79, 89, 85, 84, 81, 87, 
  84, 83, 95, 78, 83, 105, 99, 81, 70, 83, 
  80, 84, 83, 83, 89, 81, 96, 105, 88, 88, 
  111, 74, 84, 88, 81, 90, 78, 91, 82, 91, 
  77, 78, 88, 88, 79, 81, 86, 74, 78, 90, 
  92, 98, 87, 78, 82, 94, 79, 89, 85, 84, 
  82, 74, 87, 81, 74, 76, 73, 84, 88, 81, 
  81, 74, 81, 76, 90, 79, 75, 89, 101, 89, 
  90, 87, 80, 92, 93, 91, 82, 81, 87, 90, 
  73, 87, 78, 93, 89, 84, 92, 72, 78, 81, 
  80, 87, 74, 80, 93, 98, 74, 79, 91, 91, 
  86, 90, 84, 75, 76, 103, 81, 70, 83, 77, 
  104, 67, 60, 88, 87, 85, 52, 65, 79, 68, 
  92, 70, 76, 89, 78, 86, 86, 84, 90, 62, 
  84, 57, 96, 97, 97, 78, 59, 108, 86, 84, 
  89, 81, 88, 71, 114, 100, 90, 90, 104, 63, 
  84, 79, 98, 91, 74, 84, 79, 83, 75, 59, 
  107, 75, 77, 93, 77, 71, 78, 86, 87, 95, 
  94, 75, 83, 97, 77, 77, 94, 90, 89, 69, 
  91, 81, 71, 84, 78, 84, 89, 83, 113, 84, 
  85, 65, 79, 67, 68, 87, 106, 86, 89, 76, 
  66, 90, 87, 95, 81, 82, 80, 86, 79, 73, 
  68, 94, 75, 77, 75, 79, 84, 84, 83, 87, 
  74, 80, 93, 76, 72, 87, 84, 92, 89, 81, 
  89, 78, 76, 103, 90, 78, 90, 83, 80, 68, 
  69, 86, 92, 83, 68, 86, 87, 80, 100, 88, 
  79, 92, 85, 85, 85, 84, 83, 81, 97, 82, 
  83, 95, 101, 82, 80, 103, 78, 77, 82, 85, 
  90, 85, 89, 89, 77, 93, 98, 82, 91, 86, 
  95, 89, 89, 87, 81, 89, 83, 75, 105, 90, 
  85, 75, 84, 83, 71, 81, 91, 93, 78, 76, 
  81, 98, 81, 94, 81, 85, 85, 77, 88, 86, 
  72, 94, 75, 82, 89, 79, 79, 77, 84, 83, 
  76, 73, 80, 92, 65, 88, 82, 93, 81, 95, 
  87, 90, 86, 85, 86, 89, 76, 99, 83, 67, 
  86, 73, 101, 89, 89, 87, 63, 81, 97, 73, 
  88, 79, 74, 85, 95, 77, 82, 92, 92, 93, 
  83, 98, 80, 71, 90, 77, 102, 72, 65, 68, 
  95, 82, 111, 87, 62, 83, 76, 84, 86, 90, 
  83, 71, 91, 89, 88, 86, 86, 69, 78, 78, 
  80, 81, 60, 82, 82, 83, 78, 99, 73, 95, 
  83, 111, 75, 106, 80, 71, 93, 80, 89, 85, 
  80, 87, 91, 92, 79, 132, 87, 82, 63, 77, 
  92, 69, 74, 79, 90, 104, 75, 77, 79, 86, 
  88, 78, 95, 78, 96, 79, 85, 73, 68, 69, 
  73, 88, 94, 94, 88, 79, 74, 77, 77, 82, 
  78, 85, 81, 88, 100, 86, 75, 80, 86, 104, 
  69, 85, 70, 83, 84, 85, 84, 102, 76, 76, 
  111, 88, 82, 86, 50, 97, 111, 85, 76, 71, 
  90, 76, 119, 71, 89, 123, 79, 73, 85, 95, 
  86, 62, 83, 77, 119, 108, 61, 66, 85, 98, 
  100, 76, 80, 84, 73, 43, 85, 95, 69, 64, 
  119, 68, 84, 84, 84, 34, 87, 50, 59, 79, 
  43, 85, 105, 80, 88, 110, 75, 83, 86, 117, 
  72, 97, 79, 73, 82, 80, 75, 79, 81, 73, 
  94, 90, 95, 91, 84, 74, 46, 85, 74, 70, 
  76, 83, 82, 106, 31, 74, 72, 87, 94, 71, 
  112, 89, 101, 82, 79, 78, 74, 93, 88, 93, 
  101, 88, 126, 99, 70, 63, 69, 76, 79, 82, 
  107, 82, 86, 80, 69, 79, 88, 120, 59, 101, 
  48, 80, 95, 64, 80, 103, 101, 74, 78, 92, 
  86, 80, 65, 81, 83, 81, 90, 78, 81, 80, 
  91, 80, 80, 87, 84, 92, 83, 97, 87, 69, 
  92, 82, 101, 105, 65, 80, 92, 76, 84, 102, 
  89, 85, 95, 89, 87, 87, 89, 65, 91, 88, 
  86, 123, 93, 76, 69, 87, 78, 84, 80, 72, 
  72, 59, 79, 96, 84, 91, 75, 87, 68, 105, 
  71, 72, 88, 80, 88, 91, 87, 87, 85, 91, 
  80, 66, 84, 85, 69, 69, 92, 97, 65, 81, 
  87, 101, 69, 67, 82, 93, 94, 83, 78, 73, 
  97, 72, 86, 79, 72, 92, 72, 89, 90, 85, 
  86, 82, 64, 85, 88, 77, 81, 92, 60, 83, 
  87, 90, 77, 82, 96, 96, 72, 85, 58, 86, 
  84, 94, 75, 76, 84, 88, 83, 79, 90, 89, 
  85, 86, 77, 72, 85, 70, 80, 90, 74, 93, 
  83, 86, 87, 75, 82, 95, 74, 83, 94, 81, 
  76, 87, 70, 78, 103, 73, 95, 84, 76, 92, 
  87, 96, 83, 78, 98, 83, 76, 89, 99, 87, 
  82, 78, 90, 98, 94, 84, 80, 97, 82, 87, 
  71, 78, 83, 75, 100, 92, 78, 82, 83, 78, 
  85, 82, 101, 85, 94, 84, 97, 86, 80, 81, 
  99, 74, 83, 94, 91, 77, 84, 81, 87, 97, 
  94, 94, 79, 102, 85, 74, 87, 67, 88, 75, 
  92, 65, 71, 88, 77, 82, 83, 80, 75, 69, 
  81, 77, 84, 86, 81, 84, 81, 82, 63, 92, 
  83, 84, 77, 87, 83, 83, 81, 86, 80, 84, 
  77, 75, 94, 82, 77, 80, 90, 91, 83, 89, 
  85, 70, 77, 89, 89, 89, 80, 90, 81, 88, 
  86, 69, 83, 93, 75, 72, 96, 80, 91, 101, 
  67, 75, 107, 80, 90, 72, 82, 96, 81, 82, 
  90, 77, 84, 74, 78, 86, 100, 68, 83, 64, 
  91, 105, 89, 81, 68, 99, 83, 86, 83, 74, 
  76, 60, 113, 87, 73, 88, 82, 66, 85, 82, 
  98, 87, 93, 74, 89, 77, 87, 67, 100, 63, 
  75, 104, 85, 78, 86, 88, 81, 99, 105, 106, 
  81, 93, 88, 64, 95, 64, 93, 76, 87, 69, 
  73, 75, 76, 83, 83, 87, 87, 78, 82, 70, 
  91, 76, 74, 76, 108, 91, 70, 88, 76, 88, 
  90, 93, 80, 87, 65, 90, 81, 84, 69, 71, 
  110, 85, 80, 77, 88, 87, 84, 85, 77, 68, 
  86, 91, 85, 87, 75, 90, 75, 84, 87, 84, 
  84, 100, 83, 82, 91, 83, 72, 99, 74, 76, 
  97, 67, 81, 83, 87, 89, 69, 99, 83, 78, 
  89, 79, 77, 90, 96, 80, 89, 79, 81, 108, 
  97, 87, 83, 67, 72, 75, 68, 84, 85, 78, 
  89, 78, 76, 84, 82, 78, 84, 90, 70, 90, 
  89, 83, 92, 89, 76, 73, 83, 75, 85, 76, 
  94, 92, 86, 84, 79, 90, 85, 92, 83, 91, 
  87, 81, 73, 72, 86, 73, 82, 71, 75, 65, 
  77, 81, 81, 80, 75, 81, 82, 81, 104, 83, 
  82, 79, 89, 89, 80, 97, 83, 79, 90, 81, 
  82, 85, 77, 89, 79, 86, 77, 76, 95, 85, 
  85, 86, 77, 83, 81, 87, 87, 63, 92, 100, 
  72, 83, 83, 78, 87, 87, 100, 76, 98, 90, 
  83, 78, 79, 82, 94, 93, 100, 78, 70, 79, 
  74, 91, 89, 84, 75, 84, 79, 81, 83, 80, 
  81, 83, 82, 75, 83, 87, 78, 65, 76, 85, 
  90, 87, 77, 75, 75, 89, 91, 89, 85, 80, 
  88, 78, 100, 85, 79, 97, 78, 85, 83, 97, 
  85, 70, 69, 85, 70, 78, 82, 91, 73, 95, 
  73, 87, 83, 94, 83, 94, 79, 72, 72, 93, 
  73, 81, 91, 97, 93, 83, 83, 77, 85, 81, 
  88, 93, 98, 89, 85, 71, 74, 83, 78, 81, 
  77, 96, 105, 92, 73, 104, 93, 92, 81, 93, 
  86, 80, 79, 85, 88, 76, 81, 77, 82, 81, 
  77, 70, 78, 74, 79, 76, 105, 80, 80, 68, 
  97, 100, 102, 72, 106, 76, 81, 79, 83, 87, 
  84, 81, 96, 73, 129, 83, 68, 80, 81, 74, 
  89, 80, 78, 83, 63, 84, 104, 91, 75, 91, 
  83, 65, 68, 76, 78, 81, 78, 87, 89, 82, 
  77, 70, 63, 88, 107, 69, 81, 90, 85, 68, 
  90, 98, 61, 102, 87, 68, 70, 98, 76, 60, 
  64, 82, 82, 77, 82, 101, 79, 76, 80, 82, 
  83, 104, 84, 93, 77, 84, 67, 100, 76, 85, 
  93, 110, 78, 76, 70, 92, 78, 79, 83, 82, 
  114, 91, 85, 72, 88, 81, 76, 78, 79, 86, 
  69, 92, 79, 112, 87, 110, 80, 92, 82, 77, 
  92, 75, 80, 92, 81, 86, 86, 90, 72, 85, 
  81, 88, 82, 66, 77, 61, 77, 91, 92, 80, 
  83, 89, 92, 80, 76, 86, 87, 78, 80, 84, 
  83, 74, 99, 81, 78, 84, 96, 84, 95, 87, 
  76, 78, 78, 83, 94, 78, 82, 100, 93, 95, 
  82, 88, 80, 85, 73, 84, 87, 77, 77, 76, 
  75, 85, 87, 86, 85, 78, 91, 77, 77, 89, 
  83, 82, 96, 83, 92, 90, 88, 77, 71, 84, 
  89, 84, 80, 86, 76, 85, 76, 72, 91, 91, 
  83, 94, 78, 100, 76, 98, 93, 83, 97, 98, 
  70, 83, 78, 97, 87, 78, 84, 89, 89, 87, 
  82, 68, 83, 80, 76, 87, 82, 92, 78, 92, 
  74, 98, 85, 90, 82, 96, 82, 76, 81, 85, 
  80, 79, 93, 93, 105, 96, 78, 68, 87, 82, 
  71, 74, 74, 70, 72, 86, 82, 71, 75, 85, 
  93, 73, 80, 94, 80, 74, 82, 78, 103, 69, 
  112, 90, 75, 107, 99, 105, 76, 98, 77, 87, 
  80, 96, 68, 86, 63, 87, 111, 98, 77, 83, 
  79, 79, 73, 87, 82, 98, 81, 70, 91, 94, 
  76, 101, 91, 77, 96, 68, 80, 90, 84, 83, 
  98, 98, 77, 86, 85, 62, 70, 105, 77, 74, 
  86, 74, 86, 79, 77, 81, 95, 90, 85, 87, 
  71, 90, 84, 85, 65, 70, 97, 85, 95, 81, 
  71, 84, 83, 78, 91, 75, 102, 92, 79, 70, 
  82, 84, 73, 90, 82, 95, 70, 95, 80, 74, 
  83, 71, 75, 92, 83, 81, 72, 69, 72, 80, 
  95, 107, 118, 83, 86, 55, 87, 75, 57, 83, 
  109, 77, 94, 74, 97, 84, 78, 76, 82, 69, 
  76, 85, 88, 70, 73, 86, 109, 82, 147, 85, 
  85, 95, 78, 76, 68, 96, 87, 92, 69, 112, 
  84, 110, 56, 76, 138, 83, 40, 84, 91, 86, 
  67, 97, 67, 96, 70, 70, 92, 113, 84, 74, 
  74, 97, 73, 68, 89, 121, 68, 72, 71, 89, 
  60, 74, 88, 51, 82, 89, 61, 66, 87, 78, 
  91, 86, 90, 89, 89, 85, 84, 82, 76, 77, 
  80, 87, 53, 68, 96, 106, 108, 67, 58, 90, 
  75, 77, 97, 71, 129, 98, 76, 72, 88, 105, 
  77, 89, 82, 93, 64, 108, 124, 67, 86, 83, 
  62, 105, 82, 76, 84, 60, 82, 91, 101, 92, 
  100, 84, 72, 69, 87, 82, 73, 77, 78, 86, 
  73, 86, 85, 68, 76, 91, 80, 75, 91, 92, 
  77, 71, 77, 77, 91, 104, 106, 77, 80, 86, 
  81, 93, 80, 100, 70, 79, 87, 94, 92, 82, 
  68, 87, 108, 109, 77, 84, 78, 88, 72, 84, 
  77, 94, 81, 74, 83, 85, 76, 108, 97, 79, 
  91, 71, 88, 89, 81, 81, 79, 96, 78, 84, 
  80, 65, 70, 89, 66, 81, 86, 72, 79, 99, 
  79, 93, 91, 87, 85, 85, 74, 80, 85, 79, 
  73, 69, 103, 90, 85, 80, 76, 75, 85, 76, 
  83, 76, 90, 85, 82, 72, 81, 88, 76, 93, 
  91, 96, 109, 91, 77, 79, 83, 71, 75, 89, 
  85, 76, 71, 74, 81, 80, 85, 88, 76, 85, 
  80, 84, 82, 93, 69, 88, 83, 72, 72, 104, 
  81, 69, 92, 82, 81, 74, 83, 86, 82, 78, 
  87, 81, 84, 64, 77, 97, 74, 92, 80, 95, 
  98, 79, 76, 82, 91, 86, 92, 72, 71, 98, 
  75, 77, 95, 100, 72, 79, 76, 85, 75, 80, 
  85, 76, 83, 83, 69, 93, 114, 85, 86, 84, 
  80, 76, 84, 80, 88, 83, 106, 86, 66, 92, 
  75, 75, 109, 90, 77, 85, 88, 87, 80, 75, 
  84, 85, 80, 90, 90, 87, 78, 77, 78, 78, 
  90, 75, 63, 98, 91, 86, 91, 80, 79, 71, 
  71, 81, 84, 84, 82, 71, 84, 87, 94, 81, 
  63, 86, 82, 94, 84, 74, 78, 86, 88, 95, 
  75, 78, 86, 74, 82, 97, 76, 73, 86, 66, 
  82, 87, 61, 87, 89, 84, 79, 110, 78, 63, 
  74, 75, 78, 71, 83, 88, 76, 71, 91, 77, 
  90, 86, 69, 98, 73, 81, 77, 75, 104, 78, 
  78, 81, 105, 83, 73, 70, 67, 89, 82, 61, 
  97, 98, 82, 83, 68, 80, 71, 86, 78, 85, 
  99, 84, 55, 94, 121, 91, 87, 79, 90, 82, 
  80, 93, 86, 89, 104, 90, 69, 91, 67, 67, 
  96, 83, 78, 93, 68, 82, 77, 89, 84, 80, 
  83, 91, 81, 85, 89, 78, 75, 79, 83, 84, 
  85, 96, 87, 89, 85, 75, 100, 73, 72, 82, 
  75, 82, 75, 73, 76, 85, 101, 70, 79, 94, 
  87, 85, 88, 69, 70, 85, 95, 100, 59, 68, 
  84, 74, 83, 83, 72, 73, 80, 83, 79, 92, 
  74, 89, 85, 89, 69, 100, 84, 67, 91, 86, 
  99, 74, 87, 81, 73, 73, 86, 79, 76, 89, 
  72, 94, 77, 70, 68, 80, 93, 82, 82, 78, 
  95, 84, 74, 74, 70, 90, 69, 81, 95, 100, 
  74, 78, 75, 83, 78, 89, 83, 83, 84, 77, 
  68, 94, 115, 86, 89, 90, 89, 74, 84, 73, 
  74, 80, 105, 90, 69, 94, 73, 70, 96, 88, 
  78, 81, 77, 81, 82, 85, 85, 88, 82, 89, 
  94, 79, 78, 77, 86, 78, 90, 84, 87, 88, 
  94, 80, 91, 80, 83, 76, 68, 83, 86, 88, 
  83, 81, 88, 84, 93, 80, 109, 82, 76, 104, 
  102, 79, 78, 85, 88, 89, 77, 86, 87, 101, 
  75, 81, 97, 79, 75, 100, 81, 91, 74, 77, 
  77, 75, 73, 93, 92, 100, 94, 102, 77, 89, 
  89, 73, 93, 100, 86, 80, 84, 79, 75, 88, 
  86, 65, 71, 79, 82, 72, 101, 98, 90, 72, 
  68, 89, 78, 75, 78, 78, 85, 77, 77, 95, 
  89, 102, 104, 97, 109, 93, 84, 76, 78, 60, 
  85, 69, 68, 94, 99, 72, 98, 80, 69, 71, 
  102, 91, 81, 79, 65, 57, 77, 93, 95, 90, 
  86, 94, 85, 79, 79, 59, 103, 77, 90, 84, 
  77, 74, 93, 78, 83, 79, 86, 88, 54, 59, 
  88, 82, 84, 73, 85, 80, 86, 92, 75, 77, 
  92, 77, 70, 82, 85, 73, 78, 99, 81, 88, 
  95, 100, 97, 84, 86, 106, 86, 81, 94, 87, 
  88, 83, 75, 87, 88, 88, 83, 74, 91, 92, 
  63, 86, 83, 86, 74, 102, 86, 93, 97, 78, 
  86, 67, 88, 85, 88, 83, 77, 91, 88, 82, 
  75, 90, 84, 83, 89, 88, 86, 72, 71, 81, 
  75, 81, 86, 78, 80, 80, 74, 97, 91, 79, 
  86, 77, 89, 69, 80, 82, 99, 68, 86, 80, 
  64, 77, 90, 76, 85, 113, 70, 80, 100, 79, 
  79, 79, 83, 76, 74, 71, 90, 75, 68, 90, 
  82, 83, 85, 84, 59, 72, 95, 87, 82, 61, 
  90, 72, 89, 73, 81, 73, 76, 73, 95, 90, 
  84, 76, 85, 81, 68, 74, 78, 76, 76, 82, 
  84, 107, 102, 72, 79, 84, 92, 81, 81, 79, 
  94, 85, 81, 71, 94, 75, 90, 89, 90, 68, 
  73, 80, 90, 87, 87, 78, 104, 93, 70, 85, 
  90, 83, 77, 85, 97, 85, 77, 83, 83, 68, 
  82, 84, 84, 76, 98, 98, 89, 91, 80, 84, 
  86, 90, 77, 89, 80, 81, 73, 84, 78, 80, 
  87, 70, 81, 75, 71, 102, 94, 81, 79, 79, 
  81, 80, 84, 85, 104, 80, 76, 98, 78, 84, 
  80, 83, 79, 87, 77, 76, 88, 86, 82, 77, 
  79, 85, 99, 76, 83, 84, 75, 74, 81, 87, 
  88, 81, 78, 78, 97, 90, 95, 79, 92, 86, 
  93, 85, 82, 77, 89, 87, 94, 89, 87, 78, 
  75, 84, 75, 86, 91, 73, 74, 88, 89, 95, 
  88, 84, 79, 83, 98, 87, 87, 79, 93, 82, 
  83, 83, 81, 95, 87, 77, 81, 93, 67, 91, 
  76, 93, 77, 75, 68, 89, 70, 83, 84, 96, 
  86, 120, 69, 87, 99, 87, 100, 86, 101, 87, 
  95, 66, 67, 86, 104, 70, 113, 97, 84, 77, 
  82, 84, 80, 85, 69, 72, 74, 85, 83, 83, 
  78, 79, 81, 75, 88, 90, 97, 69, 98, 54, 
  78, 77, 80, 63, 88, 49, 60, 70, 96, 83, 
  89, 87, 65, 107, 89, 98, 85, 73, 68, 120, 
  68, 95, 84, 71, 96, 120, 74, 78, 84, 79, 
  81, 80, 114, 70, 79, 72, 93, 69, 88, 78, 
  74, 83, 64, 62, 97, 90, 84, 78, 87, 71, 
  92, 76, 80, 82, 75, 85, 44, 123, 85, 83, 
  73, 79, 82, 86, 100, 80, 80, 74, 80, 118, 
  75, 71, 75, 92, 88, 95, 86, 72, 78, 77, 
  87, 83, 100, 111, 76, 71, 77, 77, 71, 91, 
  84, 68, 65, 86, 95, 71, 83, 79, 90, 73, 
  100, 90, 87, 105, 113, 88, 97, 83, 72, 73, 
  100, 95, 97, 76, 59, 80, 107, 90, 71, 78, 
  91, 79, 86, 73, 71, 86, 61, 63, 84, 110, 
  90, 66, 82, 92, 67, 71, 78, 102, 82, 83, 
  67, 112, 59, 84, 90, 59, 84, 113, 85, 76, 
  82, 81, 78, 77, 95, 88, 95, 101, 63, 73, 
  87, 86, 107, 84, 77, 98, 84, 72, 88, 60, 
  86, 98, 100, 94, 85, 73, 93, 88, 78, 64, 
  80, 92, 55, 83, 91, 140, 67, 99, 103, 70, 
  95, 78, 79, 60, 87, 76, 85, 66, 82, 83, 
  83, 95, 84, 75, 81, 77, 86, 78, 89, 92, 
  85, 86, 83, 80, 89, 79, 80, 83, 81, 70, 
  77, 86, 82, 70, 81, 79, 82, 89, 101, 97, 
  92, 91, 84, 82, 82, 88, 76, 67, 94, 80, 
  86, 86, 67, 78, 97, 94, 72, 77, 87, 80, 
  94, 78, 74, 90, 68, 89, 89, 93, 95, 85, 
  80, 95, 92, 78, 83, 92, 81, 74, 75, 85, 
  74, 93, 83, 66, 75, 85, 86, 77, 83, 89, 
  86, 77, 80, 92, 83, 84, 98, 74, 91, 87, 
  108, 91, 79, 96, 83, 85, 80, 78, 86, 101, 
  96, 89, 75, 80, 87, 88, 85, 77, 86, 86, 
  63, 83, 101, 97, 76, 94, 87, 87, 95, 80, 
  87, 78, 86, 78, 81, 85, 82, 91, 84, 83, 
  92, 85, 77, 96, 79, 90, 81, 85, 75, 92, 
  68, 86, 79, 101, 84, 93, 78, 94, 78, 88, 
  93, 94, 93, 87, 94, 63, 72, 92, 104, 75, 
  113, 89, 75, 87, 78, 89, 95, 83, 92, 80, 
  94, 94, 82, 78, 83, 74, 76, 92, 87, 98, 
  101, 79, 92, 71, 74, 76, 78, 76, 89, 65, 
  68, 83, 73, 86, 83, 79, 78, 91, 91, 90, 
  82, 77, 73, 96, 83, 90, 90, 78, 95, 88, 
  81, 77, 82, 73, 87, 87, 98, 74, 83, 76, 
  97, 78, 82, 78, 63, 92, 77, 75, 99, 87, 
  76, 74, 73, 83, 92, 73, 83, 81, 78, 75, 
  69, 111, 55, 86, 88, 81, 74, 84, 95, 86, 
  88, 82, 78, 99, 75, 74, 66, 90, 93, 72, 
  86, 82, 80, 82, 80, 93, 100, 84, 68, 78, 
  72, 79, 72, 84, 80, 78, 65, 91, 92, 76, 
  99, 84, 89, 79, 81, 92, 97, 98, 98, 75, 
  78, 87, 78, 79, 101, 80, 95, 79, 70, 95, 
  89, 78, 83, 78, 80, 84, 86, 83, 87, 102, 
  71, 76, 80, 86, 84, 78, 89, 89, 78, 82, 
  70, 82, 87, 83, 80, 87, 84, 83, 81, 70, 
  77, 82, 98, 77, 82, 87, 82, 68, 77, 88, 
  82, 91, 81, 77, 99, 83, 108, 86, 81, 87, 
  85, 73, 76, 83, 82, 91, 95, 89, 81, 83, 
  73, 89, 93, 64, 83, 88, 71, 76, 96, 105, 
  62, 93, 95, 92, 86, 77, 83, 76, 90, 84, 
  79, 72, 81, 75, 73, 87, 85, 76, 83, 80, 
  83, 86, 86, 96, 92, 75, 76, 77, 82, 76, 
  74, 87, 81, 73, 88, 83, 81, 76, 92, 82, 
  85, 94, 80, 92, 93, 87, 90, 73, 70, 78, 
  84, 72, 89, 73, 88, 91, 79, 89, 74, 73, 
  82, 73, 83, 81, 93, 85, 84, 105, 85, 86, 
  85, 86, 81, 84, 80, 83, 95, 80, 78, 81, 
  90, 76, 81, 80, 86, 82, 80, 78, 75, 79, 
  84, 79, 82, 89, 82, 79, 75, 90, 82, 83, 
  94, 87, 106, 82, 101, 81, 82, 82, 81, 81, 
  77, 83, 79, 87, 89, 88, 85, 87, 80, 81, 
  104, 76, 83, 83, 75, 82, 100, 72, 106, 88, 
  81, 105, 94, 86, 87, 86, 84, 86, 81, 81, 
  93, 64, 63, 81, 96, 86, 83, 93, 81, 83, 
  94, 79, 70, 85, 89, 89, 96, 82, 90, 79, 
  44, 75, 60, 94, 71, 83, 79, 88, 87, 80, 
  87, 80, 82, 105, 84, 89, 76, 78, 75, 78, 
  76, 60, 93, 77, 75, 77, 89, 100, 81, 85, 
  88, 77, 83, 90, 71, 85, 75, 91, 73, 84, 
  100, 80, 71, 89, 68, 84, 80, 77, 103, 55, 
  91, 67, 90, 86, 77, 72, 90, 77, 102, 84, 
  83, 91, 90, 78, 82, 87, 89, 85, 93, 84, 
  77, 101, 76, 83, 86, 78, 91, 102, 83, 84, 
  72, 86, 80, 85, 84, 88, 72, 77, 73, 88, 
  83, 88, 85, 86, 78, 74, 90, 83, 74, 72, 
  76, 91, 74, 83, 68, 88, 91, 89, 90, 72, 
  80, 78, 73, 87, 81, 76, 84, 89, 88, 88, 
  84, 82, 97, 79, 83, 95, 81, 80, 67, 86, 
  72, 94, 75, 83, 80, 88, 78, 71, 87, 83, 
  87, 94, 89, 83, 88, 84, 82, 79, 79, 94, 
  88, 86, 89, 75, 76, 94, 88, 91, 83, 78, 
  82, 82, 81, 85, 89, 82, 83, 77, 94, 81, 
  76, 106, 76, 116, 79, 84, 86, 75, 75, 84, 
  88, 85, 79, 75, 93, 85, 91, 96, 85, 84, 
  81, 74, 89, 77, 73, 85, 90, 82, 72, 90, 
  87, 77, 78, 88, 82, 90, 80, 90, 84, 85, 
  80, 87, 86, 85, 76, 86, 75, 86, 96, 86, 
  92, 85, 79, 90, 80, 86, 83, 82, 72, 88, 
  61, 82, 78, 80, 94, 94, 88, 74, 103, 84, 
  72, 98, 80, 69, 82, 91, 73, 82, 93, 74, 
  92, 83, 70, 101, 74, 80, 84, 80, 92, 93, 
  86, 87, 81, 86, 76, 77, 84, 86, 83, 97, 
  93, 81, 92, 82, 90, 75, 85, 100, 87, 90, 
  92, 81, 81, 99, 88, 95, 78, 83, 88, 77, 
  79, 82, 95, 79, 78, 80, 91, 81, 83, 100, 
  100, 95, 72, 88, 80, 95, 76, 87, 84, 87, 
  78, 87, 93, 88, 84, 84, 83, 82, 84, 82, 
  85, 69, 75, 93, 89, 81, 80, 97, 93, 73, 
  85, 89, 68, 73, 88, 87, 92, 80, 75, 84, 
  86, 78, 88, 90, 78, 93, 100, 92, 88, 84, 
  79, 92, 96, 92, 92, 87, 80, 89, 68, 79, 
  89, 85, 82, 89, 83, 73, 61, 85, 102, 75, 
  81, 92, 78, 81, 88, 78, 68, 87, 80, 98, 
  101, 76, 82, 83, 66, 85, 64, 96, 75, 71, 
  90, 86, 108, 80, 85, 86, 85, 104, 84, 85, 
  80, 76, 83, 70, 73, 51, 87, 88, 67, 103, 
  97, 98, 84, 78, 76, 93, 90, 89, 94, 89, 
  68, 85, 87, 84, 97, 76, 83, 80, 57, 55, 
  83, 79, 114, 63, 119, 61, 80, 92, 85, 78, 
  80, 79, 116, 65, 84, 92, 90, 79, 83, 86, 
  95, 86, 80, 86, 83, 107, 71, 79, 82, 67, 
  82, 86, 110, 87, 74, 102, 87, 84, 83, 81, 
  78, 76, 77, 73, 73, 91, 72, 88, 82, 79, 
  79, 85, 80, 70, 77, 88, 102, 83, 81, 92, 
  86, 76, 86, 72, 67, 86, 91, 72, 82, 95, 
  76, 89, 94, 82, 79, 89, 96, 86, 99, 86, 
  92, 79, 75, 84, 62, 93, 71, 85, 81, 89, 
  90, 67, 87, 82, 87, 94, 80, 86, 80, 84, 
  72, 79, 79, 74, 87, 80, 88, 79, 74, 95, 
  88, 83, 87, 84, 81, 91, 89, 71, 78, 87, 
  80, 77, 92, 81, 88, 80, 64, 89, 81, 83, 
  96, 71, 87, 70, 85, 89, 79, 72, 82, 81, 
  94, 93, 86, 86, 81, 75, 91, 75, 88, 85, 
  79, 92, 73, 89, 74, 92, 86, 86, 92, 94, 
  90, 84, 77, 98, 84, 85, 77, 71, 75, 78, 
  76, 81, 84, 81, 87, 89, 81, 85, 74, 84, 
  78, 72, 74, 89, 78, 90, 75, 77, 97, 88, 
  90, 65, 83, 79, 82, 78, 86, 87, 73, 86, 
  84, 80, 87, 87, 95, 74, 79, 93, 83, 74, 
  85, 82, 80, 96, 73, 89, 83, 87, 75, 75, 
  86, 79, 86, 94, 90, 77, 82, 82, 82, 82, 
  81, 100, 84, 83, 100, 78, 75, 95, 88, 90, 
  84, 84, 82, 88, 80, 77, 84, 86, 75, 75, 
  88, 89, 86, 96, 82, 103, 77, 86, 83, 78, 
  74, 81, 88, 82, 79, 78, 85, 75, 81, 99, 
  82, 84, 80, 78, 96, 62, 84, 86, 79, 85, 
  76, 98, 81, 86, 79, 88, 81, 95, 90, 90, 
  82, 92, 78, 87, 84, 72, 80, 85, 81, 86, 
  89, 88, 86, 85, 85, 87, 80, 89, 87, 78, 
  74, 86, 62, 87, 81, 75, 88, 89, 75, 79, 
  66, 83, 88, 76, 80, 78, 100, 79, 74, 87, 
  83, 89, 68, 96, 101, 76, 77, 91, 94, 93, 
  94, 91, 77, 69, 98, 71, 122, 73, 91, 85, 
  85, 101, 86, 83, 97, 88, 88, 68, 75, 60, 
  88, 99, 69, 122, 94, 110, 74, 86, 83, 103, 
  94, 78, 104, 106, 87, 67, 126, 93, 92, 72, 
  80, 58, 67, 47, 79, 97, 101, 80, 110, 80, 
  80, 92, 78, 85, 89, 85, 108, 70, 84, 84, 
  94, 83, 78, 96, 96, 84, 81, 84, 99, 101, 
  88, 76, 89, 75, 74, 84, 136, 93, 85, 87, 
  92, 84, 97, 93, 83, 87, 79, 68, 73, 86, 
  65, 94, 86, 97, 87, 105, 86, 78, 81, 88, 
  106, 70, 95, 88, 86, 75, 70, 74, 55, 84, 
  96, 75, 78, 88, 83, 80, 91, 86, 86, 85, 
  75, 91, 99, 84, 87, 88, 87, 79, 82, 89, 
  73, 78, 90, 82, 87, 62, 84, 84, 84, 95, 
  71, 94, 93, 78, 89, 80, 74, 71, 92, 82, 
  76, 90, 79, 104, 79, 79, 81, 86, 84, 96, 
  88, 89, 80, 73, 98, 87, 95, 72, 86, 47, 
  69, 61, 81, 80, 88, 77, 118, 77, 82, 92, 
  78, 77, 79, 84, 109, 91, 90, 82, 83, 75, 
  83, 87, 93, 86, 86, 85, 85, 92, 77, 79, 
  75, 80, 91, 83, 108, 81, 74, 102, 87, 81, 
  80, 81, 77, 81, 74, 69, 74, 77, 69, 100, 
  80, 91, 86, 85, 76, 74, 84, 86, 100, 75, 
  81, 86, 85, 78, 76, 62, 63, 84, 91, 68, 
  86, 93, 79, 82, 92, 87, 88, 91, 82, 87, 
  93, 91, 93, 81, 81, 79, 74, 97, 69, 83, 
  89, 86, 82, 58, 82, 84, 85, 95, 82, 79, 
  94, 82, 73, 100, 77, 83, 90, 76, 85, 75, 
  74, 94, 82, 87, 81, 83, 80, 103, 75, 81, 
  82, 79, 84, 82, 92, 83, 89, 66, 77, 84, 
  83, 80, 92, 84, 89, 74, 86, 86, 74, 74, 
  77, 73, 102, 97, 87, 81, 80, 74, 85, 76, 
  95, 85, 77, 89, 80, 106, 71, 83, 78, 88, 
  96, 94, 102, 84, 77, 96, 84, 83, 81, 65, 
  78, 84, 72, 77, 78, 78, 80, 97, 78, 86, 
  71, 88, 79, 72, 75, 89, 77, 85, 85, 83, 
  89, 83, 68, 51, 93, 76, 52, 75, 76, 76, 
  96, 80, 57, 101, 93, 76, 82, 66, 82, 71, 
  74, 90, 83, 91, 90, 81, 92, 85, 104, 94, 
  96, 95, 90, 76, 101, 88, 94, 98, 61, 78, 
  74, 67, 77, 85, 85, 52, 71, 53, 91, 77, 
  95, 108, 61, 66, 78, 82, 59, 71, 79, 66, 
  78, 99, 120, 98, 84, 94, 87, 47, 127, 166, 
  82, 74, 74, 123, 73, 79, 67, 75, 127, 80, 
  98, 85, 75, 68, 85, 114, 80, 92, 81, 93, 
  67, 75, 84, 94, 84, 100, 84, 62, 71, 103, 
  83, 83, 55, 85, 114, 86, 77, 70, 87, 60, 
  87, 82, 86, 84, 73, 89, 71, 89, 68, 74, 
  86, 72, 87, 133, 78, 74, 35, 84, 74, 114, 
  71, 66, 68, 82, 68, 72, 81, 77, 88, 85, 
  66, 96, 90, 68, 85, 72, 91, 77, 67, 85, 
  86, 82, 79, 85, 87, 86, 95, 91, 107, 96, 
  86, 85, 95, 88, 81, 101, 70, 80, 80, 66, 
  87, 94, 88, 60, 80, 69, 92, 96, 92, 97, 
  69, 57, 83, 83, 64, 73, 72, 73, 74, 94, 
  112, 90, 82, 87, 90, 52, 96, 153, 91, 71, 
  86, 121, 72, 79, 73, 73, 121, 66, 101, 79, 
  79, 68, 84, 95, 77, 88, 82, 91, 66, 73, 
  81, 104, 86, 99, 92, 71, 79, 102, 93, 73, 
  58, 113, 106, 91, 76, 73, 88, 68, 85, 69, 
  83, 85, 72, 86, 75, 89, 72, 74, 86, 67, 
  93, 105, 83, 73, 43, 84, 79, 95, 79, 89, 
  77, 80, 89, 105, 93, 87, 90, 83, 83, 81, 
  86, 77, 74, 86, 89, 100, 93, 83, 91, 76, 
  78, 91, 76, 88, 72, 91, 85, 81, 84, 79, 
  79, 78, 80, 96, 80, 78, 78, 81, 71, 86, 
  89, 97, 83, 86, 82, 68, 86, 82, 83, 92, 
  95, 86, 95, 83, 89, 71, 81, 70, 84, 85, 
  80, 64, 96, 75, 79, 72, 91, 78, 93, 77, 
  91, 80, 80, 88, 76, 83, 90, 106, 101, 86, 
  83, 85, 79, 74, 95, 76, 104, 74, 90, 83, 
  86, 85, 101, 92, 93, 71, 84, 85, 65, 74, 
  72, 82, 82, 80, 83, 86, 85, 95, 80, 76, 
  85, 83, 70, 83, 94, 86, 83, 83, 96, 86, 
  88, 94, 91, 87, 96, 82, 89, 64, 75, 82, 
  82, 75, 94, 86, 88, 84, 76, 80, 96, 77, 
  83, 72, 67, 77, 82, 83, 86, 105, 68, 91, 
  88, 77, 106, 88, 89, 81, 90, 85, 92, 94, 
  111, 90, 74, 81, 73, 81, 92, 84, 95, 72, 
  85, 72, 82, 67, 84, 82, 75, 86, 88, 88, 
  80, 81, 62, 78, 72, 79, 87, 94, 91, 95, 
  91, 62, 77, 110, 71, 70, 84, 110, 86, 77, 
  76, 77, 95, 80, 79, 76, 79, 72, 90, 84, 
  66, 86, 88, 82, 81, 88, 84, 79, 86, 74, 
  84, 73, 69, 94, 79, 86, 53, 84, 88, 80, 
  84, 72, 89, 81, 91, 70, 82, 79, 75, 86, 
  73, 80, 75, 75, 80, 84, 76, 82, 91, 75, 
  65, 83, 68, 79, 91, 79, 70, 85, 88, 67, 
  95, 83, 82, 87, 82, 78, 101, 74, 87, 79, 
  69, 85, 79, 80, 90, 103, 79, 92, 81, 78, 
  93, 87, 93, 109, 90, 84, 89, 79, 73, 87, 
  77, 79, 94, 85, 94, 85, 85, 79, 89, 76, 
  87, 75, 84, 77, 76, 82, 88, 88, 85, 70, 
  64, 83, 75, 74, 82, 82, 91, 84, 85, 71, 
  68, 89, 67, 78, 84, 103, 85, 78, 77, 73, 
  87, 71, 71, 71, 81, 78, 91, 90, 64, 93, 
  76, 82, 86, 86, 77, 74, 90, 75, 79, 74, 
  79, 88, 83, 82, 55, 72, 83, 85, 81, 74, 
  86, 88, 84, 66, 83, 83, 80, 80, 84, 89, 
  97, 75, 83, 81, 89, 66, 90, 75, 66, 85, 
  75, 74, 86, 88, 81, 76, 87, 88, 88, 87, 
  93, 81, 93, 76, 90, 78, 82, 80, 81, 91, 
  90, 85, 90, 84, 84, 84, 73, 87, 69, 84, 
  83, 85, 85, 81, 82, 77, 79, 90, 81, 93, 
  95, 81, 75, 81, 87, 97, 83, 80, 78, 76, 
  88, 78, 82, 86, 91, 93, 95, 91, 90, 78, 
  81, 81, 76, 79, 79, 72, 92, 80, 80, 72, 
  85, 78, 93, 80, 86, 81, 85, 84, 73, 82, 
  76, 94, 96, 97, 80, 81, 79, 82, 88, 77, 
  102, 84, 85, 72, 79, 82, 89, 92, 89, 75, 
  75, 85, 72, 66, 72, 80, 91, 79, 81, 95, 
  90, 86, 75, 81, 87, 78, 82, 84, 93, 85, 
  82, 78, 86, 79, 88, 88, 96, 84, 87, 77, 
  94, 88, 89, 75, 111, 91, 92, 86, 86, 83, 
  90, 78, 93, 78, 75, 83, 76, 84, 93, 101, 
  87, 104, 74, 93, 77, 78, 77, 87, 85, 70, 
  90, 89, 88, 93, 76, 73, 79, 90, 74, 93, 
  91, 68, 71, 100, 86, 89, 79, 82, 77, 71, 
  91, 110, 90, 93, 88, 94, 84, 92, 94, 69, 
  74, 80, 68, 85, 99, 90, 84, 82, 77, 83, 
  89, 58, 93, 79, 79, 88, 70, 73, 88, 78, 
  96, 95, 65, 76, 80, 91, 88, 70, 80, 90, 
  87, 83, 89, 78, 84, 80, 84, 78, 86, 88, 
  76, 97, 68, 76, 92, 100, 91, 90, 90, 89, 
  77, 75, 82, 89, 94, 78, 84, 84, 82, 84, 
  83, 81, 84, 90, 119, 92, 81, 71, 89, 96, 
  85, 75, 105, 75, 92, 86, 85, 85, 92, 78, 
  99, 83, 86, 86, 77, 88, 92, 96, 72, 103, 
  80, 92, 84, 78, 82, 85, 81, 90, 88, 92, 
  86, 80, 73, 78, 85, 87, 93, 98, 92, 73, 
  80, 95, 83, 84, 88, 68, 72, 77, 90, 105, 
  90, 91, 88, 81, 88, 91, 96, 77, 73, 83, 
  70, 86, 93, 98, 82, 77, 82, 90, 88, 63, 
  95, 75, 81, 84, 74, 81, 76, 72, 95, 96, 
  77, 92, 79, 94, 78, 69, 84, 91, 83, 79, 
  88, 82, 77, 79, 88, 77, 82, 87, 79, 95, 
  70, 79, 86, 93, 84, 88, 89, 90, 80, 76, 
  85, 84, 100, 82, 103, 84, 89, 83, 83, 82, 
  79, 88, 111, 93, 85, 77, 88, 92, 92, 78, 
  86, 83, 83, 87, 82, 89, 91, 76, 88, 87, 
  85, 82, 83, 84, 85, 90, 82, 80, 87, 91, 
  81, 86, 72, 80, 79, 92, 82, 88, 83, 77, 
  82, 79, 86, 89, 99, 74, 87, 76, 84, 96, 
  88, 88, 78, 76, 76, 75, 89, 90, 88, 85, 
  89, 93, 96, 92, 83, 87, 81, 79, 74, 85, 
  96, 85, 81, 84, 82, 86, 87, 71, 83, 81, 
  88, 85, 75, 82, 81, 90, 94, 101, 77, 79, 
  81, 91, 85, 72, 91, 96, 86, 79, 87, 85, 
  81, 92, 93, 80, 74, 78, 88, 82, 78, 76, 
  90, 80, 82, 82, 85, 91, 80, 77, 87, 81, 
  90, 83, 100, 90, 83, 84, 90, 77, 68, 98, 
  104, 85, 82, 84, 85, 89, 77, 84, 79, 95, 
  97, 78, 79, 81, 84, 78, 93, 86, 76, 96, 
  76, 100, 101, 94, 83, 102, 79, 74, 83, 102, 
  71, 80, 92, 78, 79, 86, 84, 84, 75, 81, 
  77, 94, 97, 92, 85, 79, 91, 83, 62, 94, 
  83, 83, 85, 83, 81, 80, 80, 77, 95, 76, 
  86, 74, 86, 88, 96, 82, 81, 84, 73, 82, 
  96, 83, 75, 85, 84, 91, 85, 68, 87, 93, 
  87, 76, 74, 86, 85, 83, 87, 80, 86, 100, 
  85, 72, 76, 80, 108, 97, 90, 92, 82, 86, 
  88, 73, 89, 89, 84, 71, 90, 80, 83, 86, 
  87, 86, 77, 85, 84, 79, 91, 90, 68, 99, 
  72, 86, 96, 91, 75, 78, 97, 73, 82, 81, 
  98, 77, 58, 92, 74, 79, 74, 79, 81, 83, 
  93, 81, 78, 82, 87, 74, 65, 97, 76, 99, 
  92, 96, 93, 81, 88, 76, 77, 89, 78, 80, 
  85, 69, 69, 86, 74, 87, 71, 82, 69, 100, 
  75, 74, 105, 61, 78, 87, 72, 94, 70, 72, 
  77, 82, 79, 81, 81, 68, 88, 63, 79, 60, 
  92, 89, 105, 79, 86, 75, 74, 62, 84, 82, 
  70, 105, 74, 73, 100, 74, 82, 95, 84, 84, 
  77, 62, 82, 88, 75, 90, 74, 98, 91, 66, 
  69, 80, 109, 114, 95, 82, 104, 74, 84, 80, 
  72, 90, 103, 87, 72, 83, 65, 83, 72, 86, 
  68, 91, 79, 76, 88, 92, 67, 86, 77, 75, 
  78, 84, 85, 76, 83, 66, 83, 85, 96, 70, 
  85, 82, 86, 78, 78, 77, 95, 84, 78, 85, 
  83, 78, 88, 91, 84, 96, 77, 98, 96, 101, 
  97, 97, 96, 77, 83, 103, 77, 80, 82, 72, 
  88, 85, 84, 93, 76, 85, 83, 99, 80, 92, 
  90, 85, 76, 85, 59, 93, 81, 80, 87, 82, 
  74, 84, 78, 73, 94, 73, 80, 73, 87, 85, 
  89, 77, 78, 84, 66, 86, 88, 79, 86, 75, 
  79, 83, 89, 74, 88, 90, 88, 81, 91, 86, 
  80, 83, 91, 83, 83, 92, 92, 81, 84, 79, 
  112, 86, 91, 90, 84, 84, 91, 79, 91, 94, 
  84, 84, 90, 80, 78, 82, 77, 84, 76, 83, 
  91, 79, 90, 84, 76, 90, 80, 83, 96, 88, 
  82, 75, 94, 74, 83, 83, 99, 84, 99, 78, 
  82, 87, 74, 80, 72, 73, 75, 83, 80, 70, 
  75, 77, 79, 92, 77, 83, 85, 100, 78, 96, 
  105, 78, 84, 80, 81, 84, 94, 71, 90, 87, 
  78, 67, 87, 80, 90, 80, 108, 66, 88, 81, 
  80, 84, 89, 88, 88, 71, 80, 79, 91, 91, 
  90, 67, 84, 102, 82, 85, 95, 79, 88, 83, 
  93, 73, 71, 61, 87, 76, 76, 81, 87, 94, 
  86, 92, 85, 70, 98, 95, 67, 81, 90, 69, 
  79, 88, 62, 87, 80, 86, 89, 77, 80, 93, 
  86, 75, 92, 80, 87, 78, 83, 74, 90, 70, 
  97, 82, 78, 83, 87, 80, 76, 83, 71, 93, 
  85, 87, 84, 103, 76, 76, 62, 89, 94, 80, 
  72, 83, 82, 77, 75, 81, 157, 85, 90, 92, 
  68, 72, 74, 69, 87, 85, 80, 82, 127, 115, 
  79, 76, 88, 62, 94, 76, 70, 135, 78, 74, 
  81, 67, 88, 89, 95, 77, 111, 97, 83, 71, 
  93, 68, 106, 60, 123, 68, 68, 106, 82, 93, 
  113, 51, 96, 81, 67, 83, 97, 141, 89, 69, 
  96, 124, 58, 101, 113, 61, 98, 57, 103, 88, 
  42, 107, 76, 65, 66, 58, 88, 88, 47, 88, 
  82, 52, 105, 84, 72, 86, 93, 77, 78, 75, 
  60, 64, 71, 102, 139, 67, 58, 76, 89, 60, 
  69, 71, 105, 90, 89, 82, 86, 102, 113, 84, 
  79, 77, 71, 85, 92, 84, 96, 81, 98, 76, 
  109, 112, 62, 74, 64, 77, 97, 75, 72, 95, 
  101, 60, 75, 100, 87, 74, 82, 88, 79, 105, 
  71, 78, 81, 85, 76, 72, 68, 101, 78, 94, 
  82, 82, 80, 94, 82, 89, 89, 81, 75, 83, 
  84, 82, 87, 80, 95, 91, 76, 90, 80, 85, 
  99, 81, 70, 73, 93, 88, 81, 87, 86, 87, 
  84, 96, 85, 78, 88, 81, 93, 68, 92, 77, 
  75, 82, 90, 78, 85, 89, 95, 71, 64, 58, 
  73, 73, 84, 66, 75, 88, 83, 94, 86, 73, 
  88, 69, 85, 83, 88, 71, 84, 104, 65, 75, 
  91, 81, 91, 84, 81, 102, 91, 75, 89, 82, 
  90, 80, 81, 78, 89, 105, 92, 83, 78, 73, 
  78, 83, 77, 89, 83, 96, 85, 89, 87, 87, 
  86, 79, 67, 87, 79, 76, 80, 81, 83, 78, 
  81, 83, 88, 89, 81, 88, 70, 85, 80, 79, 
  82, 85, 76, 76, 74, 87, 82, 89, 82, 84, 
  85, 98, 69, 98, 85, 80, 83, 87, 98, 90, 
  91, 81, 92, 87, 73, 78, 101, 82, 74, 95, 
  73, 76, 92, 98, 84, 80, 75, 92, 88, 76, 
  81, 79, 108, 83, 90, 73, 77, 53, 83, 77, 
  87, 86, 74, 100, 91, 78, 83, 68, 82, 82, 
  91, 67, 78, 97, 93, 90, 87, 76, 95, 90, 
  86, 81, 87, 74, 84, 81, 70, 87, 89, 91, 
  84, 80, 89, 90, 82, 69, 93, 79, 73, 67, 
  70, 83, 85, 79, 88, 82, 86, 101, 91, 84, 
  67, 77, 85, 85, 76, 96, 87, 103, 71, 75, 
  78, 84, 83, 80, 86, 78, 84, 85, 75, 71, 
  111, 91, 84, 99, 63, 73, 77, 80, 99, 84, 
  84, 87, 120, 101, 81, 81, 98, 72, 87, 84, 
  73, 105, 78, 81, 73, 72, 112, 90, 88, 97, 
  75, 90, 87, 75, 97, 81, 81, 86, 106, 70, 
  92, 105, 76, 77, 83, 66, 82, 79, 76, 86, 
  114, 96, 95, 70, 69, 91, 67, 73, 90, 74, 
  66, 88, 98, 86, 72, 94, 83, 58, 93, 61, 
  84, 91, 83, 91, 69, 58, 88, 86, 83, 89, 
  91, 79, 83, 83, 74, 90, 84, 91, 97, 59, 
  66, 86, 86, 55, 85, 82, 80, 73, 76, 92, 
  85, 83, 93, 81, 66, 101, 80, 88, 61, 72, 
  80, 56, 75, 84, 76, 99, 86, 71, 70, 80, 
  79, 78, 89, 88, 90, 79, 63, 76, 79, 79, 
  67, 88, 77, 88, 84, 81, 92, 90, 76, 82, 
  82, 87, 78, 98, 84, 90, 88, 93, 89, 85, 
  89, 80, 74, 91, 96, 92, 86, 102, 85, 84, 
  73, 87, 85, 91, 82, 94, 87, 79, 94, 90, 
  78, 84, 78, 81, 80, 87, 86, 82, 99, 82, 
  97, 76, 86, 92, 83, 81, 84, 86, 76, 99, 
  98, 76, 74, 76, 86, 83, 88, 74, 72, 99, 
  94, 96, 80, 82, 85, 66, 85, 76, 87, 75, 
  84, 103, 76, 86, 90, 78, 78, 82, 90, 92, 
  85, 68, 87, 80, 80, 69, 93, 81, 85, 93, 
  94, 82, 86, 99, 79, 83, 64, 78, 66, 89, 
  78, 89, 71, 86, 104, 79, 76, 87, 84, 84, 
  92, 79, 80, 88, 83, 70, 86, 79, 81, 71, 
  83, 89, 98, 92, 78, 85, 86, 87, 88, 71, 
  78, 75, 79, 79, 74, 90, 78, 98, 91, 76, 
  74, 99, 89, 83, 91, 87, 90, 84, 82, 84, 
  78, 88, 92, 87, 78, 83, 85, 70, 92, 76, 
  83, 79, 81, 83, 81, 78, 101, 83, 83, 81, 
  80, 74, 101, 83, 78, 108, 91, 81, 77, 78, 
  92, 84, 83, 79, 71, 85, 83, 82, 89, 76, 
  71, 80, 85, 84, 88, 87, 87, 124, 81, 81, 
  79, 81, 81, 90, 79, 80, 83, 80, 76, 71, 
  81, 75, 80, 92, 82, 81, 102, 88, 75, 79, 
  84, 78, 100, 93, 82, 84, 76, 69, 81, 87, 
  84, 73, 90, 75, 80, 83, 95, 84, 78, 77, 
  79, 86, 78, 78, 82, 83, 71, 75, 86, 80, 
  94, 83, 78, 84, 88, 93, 82, 76, 75, 75, 
  80, 80, 79, 86, 81, 92, 85, 76, 76, 93, 
  87, 85, 87, 88, 87, 86, 79, 83, 79, 88, 
  89, 83, 73, 82, 86, 69, 84, 77, 84, 79, 
  84, 80, 83, 76, 98, 76, 79, 82, 79, 76, 
  103, 84, 72, 103, 90, 87, 80, 75, 91, 82, 
  83, 81, 73, 87, 80, 80, 88, 73, 74, 78, 
  87, 82, 92, 84, 88, 125, 81, 81, 83, 76, 
  82, 89, 82, 83, 83, 83, 73, 68, 84, 76, 
  79, 91, 80, 81, 103, 83, 76, 82, 85, 76, 
  102, 94, 86, 84, 76, 67, 85, 83, 81, 72, 
  81, 76, 80, 82, 84, 82, 73, 77, 77, 83, 
  76, 76, 92, 89, 78, 77, 91, 83, 91, 84, 
  82, 87, 86, 83, 88, 79, 80, 81, 79, 83, 
  75, 89, 86, 97, 89, 79, 75, 102, 91, 84, 
  83, 85, 89, 87, 82, 85, 85, 91, 87, 87, 
  76, 79, 85, 71, 79, 72, 80, 78, 83, 85, 
  85, 79, 101, 83, 81, 83, 83, 81, 99, 91, 
  83, 100, 92, 84, 77, 76, 93, 85, 87, 78, 
  76, 86, 89, 85, 86, 79, 75, 80, 86, 86, 
  90, 88, 89, 102, 79, 88, 85, 82, 89, 98, 
  80, 85, 83, 90, 81, 76, 84, 75, 84, 88, 
  77, 79, 101, 82, 79, 79, 85, 83, 99, 94, 
  85, 88, 77, 75, 80, 83, 87, 77, 79, 80, 
  84, 86, 81, 84, 78, 81, 74, 84, 80, 82, 
  81, 84, 80, 74, 67, 90, 115, 94, 65, 87, 
  88, 84, 88, 75, 84, 81, 87, 74, 84, 89, 
  74, 88, 87, 69, 85, 96, 84, 88, 95, 95, 
  88, 84, 88, 88, 82, 80, 91, 88, 81, 75, 
  78, 75, 87, 88, 85, 84, 86, 89, 76, 73, 
  100, 71, 78, 80, 69, 75, 91, 76, 71, 121, 
  89, 78, 86, 79, 82, 79, 79, 78, 81, 77, 
  88, 75, 103, 80, 74, 77, 80, 80, 91, 101, 
  82, 171, 84, 71, 87, 78, 81, 88, 70, 70, 
  83, 83, 76, 67, 84, 87, 79, 85, 88, 91, 
  84, 91, 72, 83, 82, 77, 90, 85, 74, 78, 
  85, 70, 95, 87, 67, 63, 85, 84, 83, 82, 
  90, 74, 85, 70, 78, 81, 78, 73, 75, 87, 
  74, 78, 69, 79, 116, 83, 62, 86, 90, 87, 
  81, 79, 81, 85, 90, 75, 86, 86, 78, 84, 
  81, 70, 93, 90, 83, 91, 97, 92, 89, 84, 
  89, 85, 86, 80, 84, 86, 77, 70, 78, 75, 
  80, 85, 87, 82, 94, 84, 80, 71, 100, 67, 
  77, 79, 65, 75, 91, 73, 64, 127, 86, 80, 
  88, 73, 79, 77, 81, 81, 85, 75, 79, 75, 
  99, 76, 80, 78, 81, 85, 92, 96, 82, 180, 
  90, 75, 95, 76, 82, 84, 75, 73, 88, 77, 
  71, 67, 83, 89, 77, 83, 88, 91, 84, 74, 
  72, 86, 81, 72, 92, 86, 82, 75, 84, 66, 
  103, 80, 65, 64, 75, 87, 83, 82, 79, 75, 
  83, 70, 75, 78, 75, 72, 89, 89, 85, 79, 
  75, 86, 105, 83, 67, 89, 85, 81, 87, 82, 
  85, 87, 88, 77, 87, 84, 84, 92, 91, 77, 
  84, 96, 86, 88, 86, 85, 90, 85, 89, 82, 
  99, 86, 85, 87, 75, 73, 83, 77, 76, 80, 
  86, 83, 88, 80, 80, 75, 103, 76, 76, 79, 
  75, 80, 89, 84, 79, 106, 87, 81, 88, 75, 
  83, 82, 84, 75, 83, 85, 82, 78, 96, 80, 
  75, 76, 81, 92, 92, 100, 86, 142, 83, 84, 
  91, 83, 89, 90, 75, 79, 85, 81, 81, 69, 
  84, 86, 84, 82, 84, 89, 85, 69, 75, 82, 
  85, 83, 91, 87, 77, 84, 85, 75, 93, 81, 
  76, 75, 79, 85, 84, 87, 79, 77, 82, 74, 
  75, 80, 80, 79, 82, 77, 81, 82, 74, 90, 
  109, 96, 70, 89, 89, 78, 93, 72, 82, 83, 
  89, 72, 87, 88, 75, 90, 88, 76, 84, 91, 
  92, 89, 91, 92, 86, 77, 85, 87, 80, 79, 
  85, 90, 78, 80, 83, 74, 83, 84, 84, 88, 
  80, 87, 73, 75, 95, 74, 73, 80, 72, 76, 
  82, 79, 85, 107, 80, 78, 85, 78, 87, 84, 
  78, 73, 76, 84, 93, 80, 105, 85, 73, 77, 
  77, 82, 79, 98, 76, 139, 83, 74, 84, 81, 
  81, 91, 74, 71, 74, 89, 80, 70, 91, 83, 
  78, 82, 75, 90, 82, 94, 69, 84, 87, 83, 
  93, 76, 73, 83, 92, 76, 87, 89, 68, 68, 
  85, 84, 80, 78, 83, 79, 83, 74, 78, 89, 
  78, 80, 73, 80, 75, 83, 75, 82, 108, 90, 
  67, 89, 93, 81, 84, 79, 84, 88, 93, 72, 
  87, 83, 80, 86, 83, 76, 87, 85, 89, 92, 
  94, 85, 87, 78, 87, 87, 84, 77, 77, 92, 
  74, 76, 83, 72, 77, 86, 84, 86, 82, 85, 
  74, 74, 97, 72, 68, 80, 66, 78, 83, 76, 
  78, 109, 74, 78, 84, 74, 86, 79, 83, 74, 
  84, 84, 83, 79, 103, 84, 77, 81, 77, 85, 
  74, 96, 75, 150, 86, 78, 87, 81, 80, 87, 
  80, 72, 80, 85, 74, 73, 94, 87, 74, 82, 
  77, 91, 81, 81, 69, 85, 86, 81, 96, 77, 
  74, 79, 93, 70, 94, 81, 64, 75, 80, 84, 
  78, 74, 74, 80, 83, 74, 76, 86, 76, 77, 
  92, 85, 86, 84, 78, 89, 101, 87, 72, 90, 
  85, 79, 91, 85, 83, 87, 90, 71, 87, 84, 
  86, 96, 91, 80, 77, 89, 90, 87, 83, 78, 
  91, 81, 87, 83, 96, 88, 83, 91, 75, 78, 
  87, 75, 78, 80, 85, 86, 80, 83, 78, 77, 
  99, 80, 70, 81, 78, 81, 83, 87, 90, 96, 
  80, 81, 88, 76, 89, 87, 81, 75, 80, 91, 
  82, 79, 94, 83, 71, 78, 79, 88, 82, 98, 
  79, 119, 84, 83, 86, 87, 87, 91, 76, 76, 
  75, 80, 84, 72, 91, 81, 82, 80, 78, 87, 
  83, 73, 74, 82, 88, 88, 92, 80, 76, 83, 
  95, 80, 83, 81, 80, 82, 86, 85, 81, 83, 
  81, 82, 81, 75, 76, 90, 80, 85, 79, 83, 
  99, 85, 77, 94, 79, 72, 84, 100, 83, 80, 
  79, 72, 89, 92, 79, 96, 67, 82, 76, 85, 
  85, 97, 81, 77, 80, 78, 87, 91, 85, 92, 
  75, 86, 95, 94, 95, 88, 81, 93, 74, 91, 
  78, 76, 84, 69, 86, 67, 64, 84, 82, 78, 
  101, 76, 83, 83, 87, 86, 62, 97, 88, 96, 
  78, 83, 94, 83, 80, 82, 86, 92, 80, 93, 
  88, 93, 85, 87, 95, 97, 78, 86, 91, 84, 
  76, 85, 66, 90, 85, 69, 86, 76, 80, 84, 
  104, 90, 81, 77, 86, 75, 80, 78, 78, 97, 
  85, 87, 87, 91, 78, 85, 69, 109, 76, 93, 
  78, 88, 86, 91, 77, 68, 91, 85, 85, 85, 
  67, 81, 77, 98, 84, 79, 87, 79, 89, 89, 
  80, 85, 87, 70, 79, 108, 79, 78, 90, 76, 
  92, 81, 84, 103, 66, 72, 82, 78, 77, 93, 
  84, 81, 78, 71, 102, 89, 93, 83, 68, 91, 
  96, 82, 89, 81, 76, 95, 72, 96, 79, 83, 
  81, 74, 103, 77, 62, 83, 78, 79, 109, 68, 
  83, 84, 87, 81, 63, 94, 91, 96, 75, 94, 
  83, 79, 80, 84, 87, 90, 87, 93, 82, 90, 
  88, 83, 90, 87, 83, 84, 87, 84, 79, 78, 
  70, 78, 86, 76, 74, 89, 69, 80, 95, 97, 
  83, 84, 79, 73, 91, 65, 73, 89, 81, 85, 
  75, 86, 84, 82, 66, 102, 73, 95, 85, 88, 
  80, 92, 83, 73, 94, 75, 83, 86, 67, 85, 
  81, 105, 81, 72, 76, 75, 80, 90, 84, 88, 
  82, 72, 91, 100, 87, 77, 84, 79, 83, 91, 
  82, 97, 72, 77, 78, 83, 88, 96, 79, 75, 
  74, 83, 85, 91, 90, 82, 73, 95, 96, 79, 
  96, 93, 72, 90, 79, 93, 78, 78, 87, 76, 
  89, 94, 64, 81, 84, 80, 102, 82, 81, 86, 
  89, 82, 63, 98, 84, 93, 79, 85, 92, 82, 
  80, 86, 87, 88, 81, 93, 89, 85, 87, 93, 
  100, 88, 84, 85, 87, 83, 71, 76, 68, 80, 
  86, 77, 85, 76, 77, 94, 100, 96, 95, 79, 
  87, 75, 80, 76, 82, 92, 82, 85, 86, 91, 
  76, 88, 68, 97, 74, 92, 78, 93, 81, 88, 
  90, 69, 90, 81, 80, 85, 70, 82, 81, 93, 
  83, 82, 86, 79, 89, 73, 80, 94, 88, 76, 
  81, 96, 83, 77, 81, 76, 91, 90, 82, 91, 
  52, 82, 72, 79, 80, 97, 79, 85, 75, 69, 
  103, 88, 94, 94, 68, 91, 90, 98, 91, 73, 
  80, 83, 77, 88, 91, 77, 82, 71, 79, 72, 
  66, 73, 79, 80, 100, 70, 88, 80, 92, 86, 
  71, 105, 87, 92, 85, 79, 89, 71, 81, 82, 
  72, 89, 86, 93, 93, 95, 84, 89, 79, 83, 
  77, 81, 88, 83, 73, 88, 74, 90, 91, 74, 
  80, 77, 75, 84, 108, 95, 74, 83, 81, 79, 
  73, 63, 68, 98, 83, 93, 70, 86, 79, 86, 
  85, 115, 80, 84, 84, 81, 85, 88, 75, 67, 
  97, 80, 83, 82, 68, 93, 74, 88, 84, 69, 
  93, 79, 68, 75, 79, 74, 95, 73, 83, 108, 
  83, 77, 92, 75, 104, 91, 93, 96, 48, 70, 
  83, 69, 82, 92, 88, 87, 70, 66, 112, 91, 
  101, 78, 71, 91, 94, 82, 79, 63, 75, 93, 
  72, 86, 80, 76, 79, 68, 98, 72, 60, 84, 
  75, 73, 104, 64, 85, 73, 90, 88, 72, 110, 
  86, 88, 82, 93, 75, 71, 86, 96, 68, 78, 
  72, 99, 98, 96, 84, 94, 78, 81, 75, 81, 
  95, 81, 69, 84, 71, 84, 84, 78, 73, 95, 
  67, 75, 98, 91, 78, 87, 73, 78, 93, 47, 
  66, 85, 77, 91, 55, 80, 90, 80, 84, 134, 
  79, 89, 93, 85, 68, 92, 79, 68, 107, 70, 
  84, 82, 76, 109, 81, 89, 83, 69, 88, 76, 
  76, 79, 82, 75, 87, 73, 86, 96, 84, 75, 
  80, 86, 90, 92, 85, 89, 57, 80, 90, 79, 
  94, 92, 77, 80, 71, 74, 99, 97, 91, 82, 
  67, 88, 93, 86, 85, 78, 80, 85, 81, 86, 
  69, 78, 81, 73, 82, 85, 67, 71, 83, 80, 
  95, 74, 83, 83, 93, 83, 74, 103, 80, 92, 
  92, 79, 97, 76, 84, 92, 75, 88, 86, 92, 
  94, 82, 85, 89, 86, 92, 82, 81, 81, 78, 
  74, 80, 77, 86, 83, 80, 80, 81, 72, 81, 
  93, 95, 88, 86, 81, 80, 86, 63, 74, 88, 
  81, 90, 68, 91, 77, 89, 82, 104, 80, 89, 
  84, 99, 78, 90, 98, 67, 96, 77, 80, 81, 
  66, 86, 81, 87, 84, 72, 81, 84, 78, 70, 
  95, 91, 81, 74, 83, 89, 85, 78, 87, 81, 
  83, 83, 76, 90, 70, 86, 75, 85, 80, 102, 
  84, 83, 84, 73, 84, 89, 84, 95, 73, 90, 
  92, 93, 91, 70, 76, 91, 91, 79, 100, 83, 
  80, 80, 82, 76, 70, 82, 74, 82, 100, 79, 
  84, 86, 95, 80, 67, 93, 87, 99, 92, 84, 
  90, 78, 86, 81, 69, 84, 86, 87, 100, 102, 
  88, 83, 86, 85, 93, 74, 89, 83, 80, 88, 
  70, 88, 88, 76, 94, 78, 76, 91, 97, 94, 
  71, 89, 90, 73, 72, 66, 74, 98, 91, 90, 
  81, 80, 83, 93, 96, 112, 86, 93, 78, 78, 
  76, 89, 81, 67, 91, 92, 81, 82, 67, 88, 
  78, 91, 86, 82, 95, 79, 70, 67, 86, 75, 
  81, 69, 82, 100, 83, 74, 91, 78, 92, 85, 
  76, 90, 57, 79, 82, 77, 82, 97, 83, 84, 
  76, 69, 94, 95, 89, 89, 74, 93, 85, 84, 
  83, 57, 77, 94, 101, 76, 94, 80, 86, 72, 
  84, 79, 70, 87, 72, 78, 101, 71, 79, 83, 
  89, 82, 70, 99, 83, 88, 97, 95, 82, 77, 
  86, 85, 62, 82, 79, 94, 100, 107, 85, 86, 
  85, 83, 85, 70, 99, 76, 72, 85, 72, 88, 
  84, 82, 84, 86, 70, 80, 104, 89, 74, 90, 
  82, 75, 82, 52, 71, 98, 89, 89, 74, 79, 
  85, 84, 88, 123, 93, 94, 82, 83, 74, 87, 
  91, 72, 93, 83, 82, 82, 67, 100, 81, 90, 
  82, 75, 88, 76, 70, 74, 89, 82, 78, 71, 
  87, 91, 85, 78, 86, 80, 81, 84, 72, 86, 
  74, 86, 89, 85, 95, 99, 77, 74, 75, 75, 
  79, 104, 88, 97, 73, 84, 84, 84, 83, 69, 
  86, 92, 101, 77, 70, 80, 79, 79, 83, 89, 
  70, 83, 79, 91, 94, 83, 79, 78, 90, 81, 
  73, 88, 79, 98, 96, 85, 94, 82, 89, 87, 
  68, 84, 78, 86, 93, 93, 87, 87, 89, 87, 
  89, 70, 88, 78, 80, 77, 74, 89, 79, 85, 
  96, 81, 76, 78, 94, 86, 84, 82, 89, 72, 
  81, 66, 74, 98, 90, 87, 77, 85, 76, 94, 
  91, 107, 92, 88, 78, 91, 85, 90, 101, 65, 
  89, 87, 91, 84, 66, 83, 85, 90, 86, 82, 
  84, 82, 84, 79, 93, 86, 91, 77, 72, 83, 
  74, 104, 81, 92, 88, 94, 89, 75, 80, 86, 
  92, 74, 78, 85, 95, 73, 102, 75, 105, 86, 
  95, 69, 77, 95, 85, 99, 82, 69, 92, 87, 
  82, 76, 78, 88, 78, 97, 78, 80, 86, 79, 
  78, 75, 91, 76, 95, 94, 77, 77, 76, 91, 
  89, 90, 105, 75, 73, 67, 85, 83, 87, 75, 
  93, 81, 83, 92, 86, 67, 82, 83, 89, 74, 
  93, 90, 97, 76, 75, 112, 88, 75, 83, 87, 
  78, 84, 79, 97, 76, 74, 85, 82, 74, 84, 
  57, 92, 75, 72, 86, 72, 84, 80, 84, 68, 
  86, 94, 72, 81, 89, 94, 73, 90, 79, 76, 
  99, 77, 74, 68, 77, 77, 77, 89, 72, 83, 
  59, 81, 98, 77, 86, 68, 66, 76, 72, 88, 
  76, 103, 88, 95, 83, 84, 74, 76, 86, 71, 
  70, 82, 98, 80, 87, 67, 101, 92, 96, 68, 
  82, 98, 90, 76, 81, 68, 78, 92, 82, 73, 
  88, 89, 84, 86, 75, 87, 83, 84, 83, 82, 
  95, 95, 91, 86, 77, 74, 84, 92, 93, 93, 
  96, 81, 69, 74, 86, 87, 90, 68, 74, 65, 
  82, 81, 88, 76, 79, 82, 89, 78, 91, 94, 
  95, 68, 85, 110, 92, 69, 90, 94, 81, 85, 
  74, 103, 72, 84, 86, 94, 76, 87, 61, 82, 
  63, 74, 87, 71, 80, 75, 88, 75, 91, 89, 
  70, 80, 82, 78, 75, 87, 72, 83, 99, 75, 
  67, 58, 78, 67, 74, 93, 75, 84, 71, 95, 
  87, 80, 83, 70, 77, 79, 76, 94, 77, 101, 
  86, 88, 92, 85, 78, 80, 80, 83, 74, 74, 
  99, 84, 89, 73, 93, 94, 96, 76, 90, 91, 
  88, 74, 86, 82, 75, 86, 86, 90, 79, 96, 
  85, 81, 74, 100, 78, 84, 84, 84, 98, 98, 
  98, 82, 78, 75, 92, 79, 90, 90, 93, 76, 
  81, 82, 91, 87, 92, 83, 77, 72, 81, 76, 
  91, 74, 86, 76, 75, 82, 95, 92, 91, 76, 
  86, 107, 96, 80, 82, 91, 83, 88, 77, 104, 
  75, 89, 94, 94, 87, 97, 67, 82, 70, 77, 
  90, 78, 83, 81, 87, 72, 88, 89, 71, 74, 
  89, 79, 88, 84, 77, 76, 98, 78, 73, 63, 
  81, 63, 77, 92, 87, 85, 87, 84, 84, 86, 
  69, 86, 83, 94, 80, 97, 81, 69, 67, 89, 
  90, 77, 92, 97, 85, 80, 81, 85, 74, 67, 
  107, 95, 100, 78, 98, 74, 73, 88, 80, 100, 
  79, 71, 83, 77, 87, 69, 71, 73, 71, 90, 
  76, 85, 97, 79, 79, 73, 81, 72, 97, 88, 
  81, 76, 77, 87, 77, 88, 94, 76, 78, 67, 
  89, 85, 75, 93, 77, 78, 84, 99, 93, 83, 
  89, 78, 84, 68, 83, 77, 81, 81, 69, 92, 
  85, 80, 69, 74, 79, 92, 76, 88, 82, 73, 
  88, 76, 74, 84, 62, 122, 86, 79, 94, 85, 
  87, 91, 78, 74, 70, 81, 94, 86, 104, 96, 
  83, 96, 91, 63, 86, 84, 67, 91, 83, 92, 
  80, 85, 80, 86, 62, 76, 92, 79, 65, 73, 
  62, 82, 76, 85, 84, 78, 80, 95, 81, 78, 
  82, 81, 87, 66, 66, 86, 83, 65, 109, 78, 
  104, 76, 104, 71, 72, 88, 82, 92, 73, 61, 
  79, 80, 82, 64, 98, 76, 71, 107, 71, 86, 
  93, 80, 81, 74, 87, 74, 85, 96, 77, 71, 
  77, 87, 74, 92, 87, 75, 75, 60, 98, 81, 
  74, 67, 89, 68, 81, 104, 83, 73, 82, 85, 
  91, 75, 87, 87, 99, 75, 72, 95, 90, 64, 
  76, 82, 67, 89, 67, 105, 75, 74, 75, 80, 
  69, 81, 56, 110, 73, 77, 92, 79, 79, 78, 
  74, 75, 80, 89, 85, 82, 89, 88, 73, 87, 
  80, 73, 85, 86, 64, 71, 79, 91, 75, 87, 
  74, 86, 64, 89, 82, 74, 72, 69, 70, 83, 
  79, 86, 86, 91, 79, 100, 80, 83, 89, 83, 
  88, 76, 80, 91, 97, 72, 109, 76, 90, 85, 
  102, 73, 86, 93, 83, 88, 70, 69, 77, 82, 
  79, 76, 91, 84, 76, 90, 72, 89, 91, 86, 
  87, 77, 99, 80, 81, 86, 78, 73, 77, 85, 
  78, 89, 84, 74, 79, 65, 116, 79, 75, 78, 
  71, 72, 79, 89, 83, 75, 85, 90, 86, 81, 
  94, 91, 105, 89, 81, 93, 95, 71, 77, 90, 
  75, 82, 74, 107, 71, 79, 80, 80, 70, 87, 
  60, 80, 66, 79, 91, 75, 77, 82, 80, 79, 
  79, 93, 80, 85, 91, 87, 93, 82, 74, 72, 
  78, 82, 63, 62, 82, 85, 76, 89, 85, 88, 
  92, 79, 64, 87, 77, 90, 93, 77, 91, 90, 
  90, 61, 60, 70, 83, 86, 110, 97, 75, 97, 
  96, 82, 72, 83, 86, 106, 79, 78, 83, 86, 
  83, 79, 88, 106, 83, 84, 82, 87, 99, 72, 
  74, 86, 78, 87, 79, 77, 92, 81, 96, 84, 
  79, 78, 94, 77, 90, 94, 80, 84, 64, 72, 
  93, 85, 87, 98, 75, 94, 85, 97, 71, 92, 
  91, 87, 96, 102, 73, 77, 81, 79, 71, 86, 
  64, 94, 92, 95, 90, 97, 84, 75, 98, 79, 
  92, 74, 86, 79, 86, 90, 76, 80, 86, 92, 
  76, 85, 92, 93, 102, 105, 92, 103, 75, 76, 
  101, 79, 86, 91, 111, 94, 83, 76, 90, 87, 
  83, 99, 112, 73, 79, 89, 91, 95, 89, 74, 
  74, 87, 72, 88, 82, 82, 92, 87, 86, 74, 
  67, 77, 86, 84, 104, 93, 83, 101, 92, 80, 
  66, 67, 90, 100, 95, 83, 92, 98, 78, 80, 
  84, 121, 76, 84, 71, 82, 98, 60, 94, 82, 
  78, 93, 73, 87, 84, 75, 91, 79, 82, 82, 
  88, 83, 94, 91, 74, 76, 67, 83, 87, 87, 
  83, 95, 76, 92, 75, 78, 87, 88, 92, 100, 
  84, 99, 79, 87, 82, 69, 76, 80, 75, 91, 
  88, 103, 86, 89, 77, 74, 86, 71, 83, 83, 
  86, 90, 85, 93, 66, 79, 73, 111, 95, 78, 
  95, 85, 102, 94, 78, 93, 82, 83, 101, 78, 
  83, 94, 103, 95, 92, 91, 89, 92, 77, 94, 
  103, 74, 91, 83, 92, 97, 76, 84, 77, 83, 
  77, 76, 75, 81, 88, 79, 97, 78, 71, 81, 
  78, 78, 102, 90, 86, 96, 88, 92, 83, 71, 
  97, 85, 85, 89, 91, 91, 83, 89, 83, 114, 
  70, 82, 80, 91, 84, 66, 94, 81, 72, 95, 
  73, 89, 90, 83, 92, 80, 95, 81, 81, 90, 
  99, 83, 73, 79, 74, 84, 88, 88, 86, 92, 
  91, 82, 78, 79, 89, 92, 93, 97, 77, 94, 
  83, 85, 85, 74, 85, 80, 89, 103, 90, 99, 
  88, 86, 81, 86, 79, 74, 79, 99, 81, 87, 
  79, 88, 67, 82, 70, 100, 77, 77, 92, 89, 
  83, 92, 76, 96, 77, 93, 87, 86, 80, 91, 
  102, 86, 88, 87, 84, 92, 76, 73, 97, 80, 
  89, 76, 69, 101, 71, 96, 91, 77, 77, 75, 
  94, 84, 92, 86, 76, 96, 81, 100, 77, 85, 
  107, 86, 81, 81, 96, 91, 85, 75, 86, 87, 
  85, 77, 86, 101, 92, 90, 77, 80, 83, 88, 
  84, 64, 95, 74, 88, 94, 86, 95, 84, 83, 
  74, 80, 82, 80, 84, 102, 95, 87, 90, 75, 
  80, 92, 94, 94, 89, 83, 76, 79, 75, 86, 
  81, 90, 83, 72, 87, 90, 73, 95, 102, 74, 
  92, 82, 93, 90, 84, 97, 72, 83, 100, 74, 
  74, 89, 78, 100, 85, 72, 82, 87, 97, 75, 
  80, 91, 76, 99, 86, 84, 107, 73, 99, 84, 
  92, 84, 74, 90, 98, 69, 90, 106, 75, 88, 
  78, 107, 83, 96, 87, 87, 80, 97, 87, 87, 
  70, 93, 71, 87, 79, 85, 81, 80, 79, 84, 
  83, 95, 88, 75, 81, 91, 76, 74, 83, 79, 
  70, 89, 72, 85, 86, 85, 73, 78, 90, 86, 
  81, 99, 76, 106, 75, 91, 82, 80, 81, 93, 
  80, 87, 91, 92, 85, 73, 89, 95, 84, 85, 
  81, 86, 84, 84, 79, 96, 83, 79, 86, 89, 
  88, 86, 81, 79, 72, 85, 71, 84, 77, 79, 
  83, 83, 74, 75, 78, 82, 84, 73, 85, 86, 
  89, 89, 73, 94, 87, 77, 97, 84, 76, 85, 
  80, 86, 88, 78, 78, 87, 89, 80, 79, 76, 
  75, 97, 76, 88, 81, 80, 79, 87, 68, 77, 
  76, 82, 77, 83, 77, 78, 64, 87, 84, 81, 
  74, 86, 78, 83, 78, 82, 79, 71, 89, 83, 
  74, 82, 84, 80, 78, 88, 73, 84, 79, 92, 
  97, 84, 83, 74, 83, 71, 70, 72, 83, 81, 
  75, 83, 82, 95, 70, 82, 89, 96, 88, 83, 
  75, 92, 87, 96, 91, 77, 77, 95, 71, 95, 
  72, 85, 91, 77, 83, 92, 84, 91, 73, 84, 
  88, 73, 82, 86, 81, 96, 88, 78, 83, 77, 
  82, 81, 84, 88, 85, 87, 81, 88, 76, 85, 
  92, 76, 89, 75, 78, 87, 78, 100, 82, 85, 
  82, 94, 92, 74, 92, 91, 85, 85, 88, 85, 
  83, 87, 84, 75, 79, 89, 82, 78, 83, 84, 
  80, 88, 75, 83, 68, 89, 68, 82, 78, 81, 
  73, 79, 81, 78, 81, 85, 86, 71, 84, 77, 
  77, 86, 77, 87, 80, 78, 77, 100, 78, 111, 
  96, 85, 71, 84, 113, 105, 96, 80, 76, 92, 
  85, 98, 90, 94, 119, 87, 75, 92, 87, 84, 
  88, 68, 97, 101, 94, 87, 71, 107, 103, 74, 
  88, 84, 84, 124, 94, 54, 71, 85, 94, 91, 
  81, 106, 93, 70, 79, 81, 76, 90, 85, 102, 
  103, 83, 97, 59, 75, 80, 73, 92, 82, 77, 
  74, 75, 71, 82, 96, 93, 78, 71, 107, 86, 
  81, 94, 121, 80, 82, 83, 89, 87, 99, 114, 
  64, 76, 98, 78, 74, 81, 87, 79, 76, 82, 
  92, 83, 111, 77, 88, 84, 79, 74, 103, 85, 
  105, 89, 99, 86, 88, 84, 82, 96, 103, 66, 
  82, 95, 86, 97, 76, 99, 83, 96, 87, 99, 
  76, 78, 92, 83, 74, 88, 103, 85, 81, 94, 
  80, 80, 80, 92, 81, 88, 87, 86, 81, 82, 
  79, 80, 79, 81, 67, 93, 75, 82, 88, 86, 
  75, 77, 95, 93, 79, 102, 78, 98, 68, 87, 
  81, 84, 84, 92, 76, 88, 94, 95, 76, 83, 
  83, 85, 89, 87, 77, 99, 83, 81, 77, 82, 
  80, 69, 93, 89, 81, 79, 77, 60, 73, 76, 
  80, 80, 82, 84, 72, 89, 75, 79, 79, 84, 
  89, 75, 72, 91, 87, 87, 79, 120, 85, 77, 
  107, 92, 73, 83, 77, 74, 88, 87, 69, 89, 
  82, 84, 69, 69, 76, 75, 81, 89, 76, 83, 
  83, 87, 71, 76, 86, 80, 74, 86, 80, 73, 
  83, 90, 81, 78, 79, 86, 76, 89, 85, 77, 
  80, 66, 86, 81, 83, 76, 83, 78, 84, 76, 
  71, 87, 77, 85, 96, 80, 84, 72, 81, 69, 
  65, 77, 86, 74, 82, 86, 86, 101, 69, 79, 
  91, 88, 94, 80, 77, 100, 83, 93, 85, 67, 
  81, 101, 79, 95, 79, 90, 93, 78, 74, 89, 
  88, 94, 73, 84, 90, 73, 81, 81, 79, 95, 
  94, 82, 95, 78, 81, 75, 77, 84, 91, 87, 
  79, 78, 75, 93, 84, 79, 84, 81, 75, 87, 
  74, 106, 86, 80, 87, 94, 91, 75, 99, 91, 
  87, 89, 88, 77, 88, 86, 79, 87, 70, 95, 
  77, 77, 77, 80, 77, 91, 71, 74, 75, 91, 
  75, 87, 88, 80, 66, 77, 83, 74, 84, 86, 
  88, 74, 82, 85, 79, 88, 87, 84, 80, 77, 
  88, 92, 81, 95, 86, 70, 81, 84, 84, 76, 
  88, 69, 72, 93, 74, 83, 79, 82, 93, 85, 
  74, 80, 89, 81, 76, 85, 90, 87, 85, 91, 
  86, 95, 91, 88, 75, 88, 89, 89, 100, 71, 
  73, 73, 83, 85, 72, 82, 94, 74, 94, 76, 
  73, 88, 83, 93, 88, 92, 98, 81, 73, 83, 
  75, 85, 93, 79, 80, 74, 77, 85, 99, 95, 
  73, 73, 102, 86, 89, 83, 78, 72, 105, 79, 
  88, 97, 84, 112, 92, 87, 98, 83, 89, 78, 
  88, 78, 95, 83, 84, 84, 93, 81, 90, 76, 
  81, 87, 77, 83, 72, 89, 83, 84, 85, 92, 
  88, 90, 79, 67, 99, 92, 81, 84, 73, 83, 
  81, 89, 82, 84, 77, 106, 82, 75, 85, 86, 
  90, 75, 77, 75, 81, 79, 74, 81, 79, 83, 
  87, 75, 77, 75, 78, 73, 67, 75, 79, 82, 
  78, 84, 82, 93, 77, 80, 86, 86, 97, 87, 
  77, 97, 70, 77, 82, 72, 85, 95, 83, 84, 
  79, 92, 80, 77, 81, 84, 91, 89, 77, 91, 
  87, 76, 79, 84, 79, 84, 90, 95, 94, 76, 
  81, 78, 77, 82, 90, 86, 89, 83, 71, 84, 
  77, 86, 85, 78, 76, 79, 78, 91, 88, 90, 
  77, 97, 90, 85, 85, 92, 90, 81, 80, 79, 
  98, 88, 69, 88, 79, 93, 70, 70, 76, 81, 
  75, 87, 76, 81, 85, 89, 80, 86, 87, 85, 
  67, 80, 88, 79, 70, 88, 84, 79, 83, 88, 
  76, 83, 85, 91, 80, 78, 86, 81, 75, 80, 
  79, 76, 74, 82, 78, 95, 80, 84, 91, 75, 
  85, 75, 81, 71, 70, 78, 89, 82, 84, 91, 
  82, 94, 78, 87, 82, 80, 91, 81, 82, 96, 
  82, 87, 83, 80, 79, 95, 87, 97, 76, 87, 
  87, 77, 72, 97, 84, 93, 75, 82, 93, 80, 
  89, 84, 82, 92, 92, 88, 102, 83, 79, 84, 
  86, 88, 91, 83, 87, 85, 77, 87, 90, 84, 
  86, 80, 81, 92, 69, 102, 87, 81, 84, 87, 
  83, 81, 80, 88, 93, 89, 90, 83, 85, 87, 
  88, 81, 83, 93, 80, 81, 84, 84, 86, 88, 
  81, 79, 80, 91, 84, 87, 88, 85, 73, 79, 
  85, 75, 81, 90, 89, 80, 82, 82, 84, 86, 
  80, 75, 88, 87, 95, 74, 84, 94, 87, 89, 
  84, 80, 74, 82, 84, 79, 96, 82, 78, 73, 
  85, 83, 83, 72, 83, 81, 72, 86, 97, 86, 
  73, 102, 87, 84, 79, 80, 94, 91, 96, 85, 
  82, 68, 80, 76, 82, 77, 71, 75, 89, 80, 
  74, 86, 73, 92, 73, 89, 79, 84, 87, 85, 
  75, 84, 90, 96, 71, 77, 88, 72, 77, 80, 
  88, 91, 81, 88, 71, 91, 88, 80, 80, 89, 
  87, 86, 82, 85, 73, 70, 99, 103, 79, 81, 
  80, 79, 75, 89, 100, 79, 94, 86, 66, 89, 
  84, 81, 79, 93, 83, 79, 94, 77, 91, 97, 
  90, 82, 76, 82, 76, 85, 79, 89, 72, 91, 
  77, 113, 105, 85, 84, 81, 81, 75, 82, 82, 
  82, 82, 85, 84, 77, 88, 89, 77, 78, 71, 
  71, 80, 72, 77, 93, 82, 83, 73, 85, 81, 
  67, 67, 72, 72, 77, 97, 87, 85, 70, 104, 
  87, 89, 74, 76, 93, 83, 87, 70, 74, 91, 
  81, 68, 75, 76, 73, 78, 86, 73, 61, 91, 
  66, 97, 66, 92, 69, 79, 83, 75, 68, 79, 
  82, 112, 76, 83, 75, 93, 77, 76, 96, 104, 
  85, 101, 74, 98, 80, 81, 92, 85, 83, 81, 
  88, 75, 71, 66, 94, 84, 89, 88, 76, 91, 
  72, 96, 85, 83, 95, 93, 67, 96, 86, 78, 
  81, 98, 91, 104, 95, 76, 115, 91, 82, 80, 
  78, 84, 74, 95, 71, 75, 76, 106, 66, 128, 
  134, 84, 84, 86, 70, 61, 85, 81, 98, 78, 
  95, 93, 78, 90, 86, 77, 78, 85, 76, 86, 
  82, 79, 80, 83, 74, 74, 87, 81, 79, 69, 
  76, 81, 83, 83, 88, 87, 74, 104, 86, 94, 
  81, 80, 98, 82, 83, 74, 72, 73, 78, 73, 
  82, 78, 77, 79, 83, 77, 71, 99, 73, 88, 
  75, 91, 77, 81, 86, 77, 78, 81, 81, 93, 
  73, 84, 87, 73, 75, 79, 75, 99, 86, 79, 
  74, 92, 91, 78, 96, 93, 86, 95, 80, 82, 
  75, 72, 97, 70, 81, 85, 95, 83, 74, 86, 
  98, 80, 92, 88, 84, 89, 83, 83, 84, 92, 
  87, 88, 94, 74, 90, 96, 88, 78, 76, 81, 
  79, 84, 80, 79, 81, 88, 75, 111, 109, 80, 
  84, 78, 79, 78, 83, 73, 86, 83, 89, 74, 
  84, 93, 81, 91, 86, 76, 71, 80, 83, 89, 
  83, 72, 84, 80, 86, 92, 82, 80, 79, 68, 
  79, 86, 95, 84, 73, 101, 88, 76, 84, 81, 
  87, 89, 103, 91, 86, 85, 79, 73, 99, 79, 
  90, 76, 89, 83, 78, 85, 79, 90, 75, 86, 
  77, 87, 80, 90, 81, 88, 93, 95, 80, 77, 
  89, 74, 89, 78, 78, 91, 79, 100, 77, 97, 
  80, 78, 83, 87, 93, 83, 80, 80, 70, 72, 
  91, 99, 74, 85, 77, 78, 74, 86, 89, 76, 
  94, 84, 72, 95, 87, 80, 66, 89, 80, 78, 
  86, 81, 94, 85, 85, 84, 76, 79, 78, 81, 
  75, 100, 83, 79, 62, 125, 98, 83, 76, 79, 
  79, 67, 82, 79, 84, 77, 77, 78, 75, 79, 
  75, 91, 82, 69, 69, 75, 75, 94, 75, 74, 
  90, 89, 90, 86, 67, 78, 78, 55, 90, 90, 
  76, 83, 68, 104, 86, 90, 80, 69, 79, 87, 
  92, 75, 71, 126, 75, 66, 103, 78, 84, 75, 
  91, 77, 67, 88, 79, 95, 70, 88, 67, 83, 
  66, 81, 78, 87, 91, 120, 79, 78, 73, 85, 
  87, 68, 71, 109, 76, 90, 72, 118, 71, 70, 
  101, 92, 94, 79, 82, 76, 67, 74, 80, 80, 
  88, 94, 83, 84, 74, 95, 79, 77, 101, 84, 
  67, 109, 88, 76, 75, 85, 81, 77, 78, 81, 
  119, 84, 76, 82, 73, 86, 83, 84, 73, 81, 
  87, 91, 65, 149, 119, 81, 76, 87, 68, 56, 
  83, 78, 93, 73, 91, 83, 81, 88, 80, 79, 
  81, 78, 74, 79, 82, 91, 73, 85, 81, 79, 
  89, 91, 77, 74, 94, 73, 89, 84, 81, 85, 
  74, 102, 86, 101, 85, 73, 86, 83, 86, 70, 
  81, 92, 77, 71, 104, 84, 80, 79, 86, 83, 
  75, 90, 78, 88, 77, 93, 73, 86, 82, 81, 
  81, 85, 88, 93, 81, 80, 87, 72, 90, 79, 
  73, 96, 79, 91, 75, 99, 87, 77, 100, 91, 
  93, 96, 76, 86, 71, 72, 91, 69, 78, 92, 
  105, 79, 75, 83, 85, 78, 95, 83, 86, 96, 
  86, 82, 85, 90, 83, 73, 85, 77, 88, 89, 
  82, 77, 75, 81, 88, 81, 77, 76, 86, 89, 
  79, 122, 103, 81, 81, 77, 75, 72, 83, 76, 
  87, 81, 89, 73, 76, 84, 78, 81, 88, 83, 
  75, 90, 80, 88, 81, 80, 80, 81, 82, 83, 
  92, 70, 84, 81, 80, 90, 96, 83, 80, 94, 
  87, 76, 83, 86, 83, 89, 98, 76, 77, 91, 
  94, 73, 93, 78, 86, 81, 88, 83, 97, 81, 
  79, 83, 80, 82, 75, 92, 76, 91, 84, 84, 
  88, 83, 85, 84, 95, 78, 83, 77, 79, 81, 
  79, 99, 77, 79, 95, 81, 85, 81, 100, 83, 
  81, 75, 74, 89, 89, 83, 76, 88, 77, 83, 
  80, 72, 89, 75, 94, 81, 76, 90, 82, 82, 
  72, 90, 73, 76, 81, 80, 82, 88, 81, 86, 
  81, 78, 79, 81, 79, 96, 81, 90, 73, 109, 
  97, 89, 73, 76, 80, 70, 81, 82, 86, 90, 
  81, 75, 74, 82, 74, 83, 90, 75, 74, 92, 
  78, 87, 72, 85, 81, 89, 78, 78, 81, 73, 
  87, 64, 88, 90, 78, 78, 80, 101, 86, 93, 
  80, 76, 83, 85, 97, 71, 70, 110, 84, 68, 
  101, 77, 89, 78, 95, 83, 90, 81, 83, 86, 
  82, 83, 72, 89, 71, 84, 85, 82, 89, 90, 
  79, 81, 89, 83, 87, 71, 69, 78, 74, 87, 
  76, 94, 90, 78, 88, 87, 96, 80, 78, 72, 
  73, 94, 84, 76, 77, 88, 81, 82, 81, 77, 
  88, 72, 103, 75, 74, 90, 87, 85, 76, 91, 
  75, 78, 82, 82, 87, 84, 76, 89, 79, 79, 
  86, 80, 78, 80, 87, 87, 72, 128, 100, 91, 
  76, 74, 72, 72, 82, 79, 86, 88, 87, 81, 
  79, 84, 84, 73, 87, 80, 78, 88, 81, 88, 
  73, 95, 79, 84, 83, 84, 89, 73, 93, 74, 
  84, 88, 82, 82, 83, 97, 84, 99, 85, 83, 
  86, 81, 86, 74, 80, 92, 79, 74, 96, 79, 
  85, 83, 86, 92, 92, 85, 80, 83, 82, 85, 
  75, 91, 79, 79, 79, 84, 81, 84, 87, 86, 
  91, 76, 85, 78, 78, 83, 77, 82, 78, 80, 
  95, 81, 90, 80, 98, 82, 71, 78, 74, 87, 
  91, 72, 77, 90, 97, 77, 79, 73, 88, 78, 
  94, 80, 86, 91, 81, 84, 86, 95, 76, 86, 
  82, 80, 77, 85, 80, 87, 82, 80, 90, 82, 
  79, 77, 85, 88, 71, 108, 97, 89, 75, 75, 
  78, 73, 82, 81, 88, 93, 76, 85, 86, 75, 
  68, 82, 72, 80, 68, 83, 79, 76, 68, 85, 
  62, 94, 89, 83, 98, 109, 62, 68, 99, 101, 
  74, 94, 78, 69, 105, 78, 84, 81, 68, 76, 
  80, 95, 74, 92, 74, 77, 93, 78, 67, 72, 
  92, 97, 90, 78, 97, 81, 71, 78, 76, 77, 
  103, 55, 127, 74, 74, 87, 80, 94, 100, 59, 
  69, 72, 80, 79, 90, 85, 95, 81, 103, 82, 
  89, 99, 72, 90, 71, 79, 86, 92, 93, 97, 
  73, 94, 76, 81, 93, 87, 109, 69, 84, 94, 
  105, 78, 89, 80, 77, 94, 85, 55, 82, 93, 
  88, 79, 96, 69, 84, 74, 85, 83, 75, 92, 
  75, 86, 79, 80, 82, 80, 63, 84, 84, 75, 
  102, 88, 81, 74, 83, 63, 101, 85, 85, 98, 
  69, 77, 83, 97, 75, 78, 99, 83, 68, 82, 
  66, 71, 83, 98, 84, 77, 95, 94, 90, 90, 
  83, 81, 123, 98, 72, 82, 49, 82, 90, 86, 
  82, 77, 75, 81, 89, 81, 89, 60, 87, 129, 
  71, 109, 93, 88, 77, 92, 88, 68, 84, 88, 
  69, 57, 66, 92, 93, 90, 85, 57, 58, 62, 
  72, 73, 81, 91, 87, 97, 79, 80, 78, 68, 
  78, 104, 79, 74, 78, 70, 101, 94, 72, 90, 
  100, 111, 55, 88, 72, 79, 85, 98, 87, 73, 
  87, 74, 91, 71, 86, 59, 94, 84, 83, 75, 
  84, 80, 73, 75, 88, 96, 68, 91, 64, 92, 
  106, 79, 67, 70, 82, 83, 82, 78, 76, 84, 
  77, 81, 88, 69, 71, 92, 78, 77, 81, 79, 
  83, 90, 91, 101, 101, 85, 91, 86, 81, 73, 
  87, 87, 101, 77, 76, 88, 91, 90, 89, 79, 
  78, 101, 93, 84, 84, 88, 93, 74, 88, 85, 
  77, 88, 89, 79, 84, 79, 81, 97, 76, 81, 
  71, 87, 90, 103, 89, 85, 78, 113, 62, 81, 
  87, 89, 96, 83, 84, 75, 79, 87, 89, 88, 
  67, 85, 86, 82, 77, 85, 76, 68, 84, 80, 
  85, 87, 91, 99, 80, 86, 95, 85, 99, 90, 
  96, 94, 74, 89, 96, 92, 68, 91, 101, 89, 
  98, 82, 94, 79, 92, 80, 86, 84, 62, 101, 
  93, 82, 85, 95, 80, 88, 97, 84, 76, 87, 
  84, 77, 89, 89, 74, 85, 86, 81, 85, 81, 
  68, 94, 85, 78, 69, 63, 83, 83, 79, 80, 
  80, 79, 73, 97, 65, 84, 87, 73, 94, 106, 
  57, 71, 78, 98, 78, 98, 72, 67, 97, 69, 
  82, 86, 59, 76, 62, 83, 77, 87, 78, 70, 
  96, 74, 74, 74, 93, 87, 90, 93, 91, 74, 
  75, 75, 85, 76, 102, 65, 128, 66, 75, 92, 
  83, 93, 103, 71, 64, 78, 73, 80, 101, 97, 
  69, 69, 113, 91, 94, 87, 83, 72, 72, 71, 
  83, 84, 85, 89, 76, 95, 69, 81, 92, 79, 
  94, 66, 89, 89, 93, 79, 88, 86, 75, 86, 
  85, 57, 85, 98, 94, 95, 100, 77, 86, 73, 
  85, 82, 74, 87, 74, 77, 71, 81, 88, 88, 
  64, 83, 83, 79, 88, 91, 82, 73, 76, 75, 
  89, 84, 90, 94, 72, 71, 87, 90, 79, 81, 
  97, 82, 68, 84, 74, 64, 77, 96, 83, 60, 
  76, 90, 96, 95, 69, 82, 99, 86, 75, 74, 
  41, 89, 83, 87, 82, 65, 75, 86, 92, 74, 
  88, 58, 85, 121, 77, 133, 91, 88, 73, 85, 
  89, 72, 81, 69, 64, 58, 63, 96, 94, 84, 
  85, 64, 62, 62, 66, 68, 98, 76, 88, 84, 
  83, 86, 86, 55, 78, 89, 73, 75, 78, 63, 
  101, 88, 68, 94, 99, 105, 54, 80, 58, 81, 
  83, 96, 67, 76, 84, 81, 70, 66, 80, 67, 
  91, 86, 78, 82, 85, 83, 67, 74, 95, 96, 
  63, 86, 70, 69, 83, 74, 60, 68, 78, 87, 
  84, 77, 73, 86, 70, 80, 85, 73, 84, 89, 
  70, 76, 86, 85, 88, 85, 92, 105, 80, 86, 
  98, 82, 88, 82, 88, 88, 99, 75, 78, 83, 
  89, 90, 75, 82, 61, 96, 93, 86, 92, 86, 
  84, 78, 83, 78, 77, 79, 81, 73, 84, 80, 
  83, 98, 84, 85, 77, 87, 84, 95, 87, 95, 
  76, 119, 64, 83, 80, 79, 90, 89, 78, 69, 
  77, 89, 91, 87, 83, 80, 76, 68, 86, 87, 
  82, 72, 82, 72, 79, 90, 94, 96, 81, 81, 
  97, 88, 92, 95, 92, 78, 85, 84, 92, 88, 
  69, 85, 90, 97, 80, 90, 88, 87, 86, 80, 
  75, 91, 65, 97, 86, 86, 94, 97, 81, 85, 
  97, 78, 72, 85, 78, 69, 74, 94, 71, 85, 
  82, 80, 80, 81, 73, 107, 91, 80, 67, 74, 
  84, 88, 77, 80, 76, 72, 69, 95, 56, 81, 
  74, 72, 95, 102, 61, 83, 103, 97, 81, 99, 
  78, 74, 88, 61, 75, 87, 69, 77, 69, 95, 
  87, 82, 84, 73, 87, 74, 83, 76, 89, 96, 
  83, 89, 97, 71, 74, 72, 87, 78, 98, 71, 
  128, 68, 73, 87, 86, 98, 96, 67, 74, 77, 
  75, 84, 90, 96, 65, 76, 114, 91, 97, 97, 
  75, 94, 80, 71, 89, 85, 88, 92, 76, 91, 
  76, 80, 81, 83, 100, 71, 90, 79, 103, 76, 
  90, 77, 67, 83, 90, 61, 89, 92, 97, 79, 
  118, 76, 95, 75, 87, 77, 77, 100, 65, 82, 
  88, 76, 89, 96, 73, 83, 80, 81, 93, 92, 
  84, 72, 76, 79, 77, 92, 85, 102, 70, 75, 
  86, 90, 76, 81, 99, 86, 59, 82, 67, 73, 
  83, 90, 95, 74, 87, 91, 102, 86, 79, 89, 
  113, 58, 84, 84, 48, 98, 97, 90, 96, 78, 
  89, 87, 98, 81, 92, 62, 76, 124, 74, 116, 
  94, 81, 82, 84, 87, 67, 81, 80, 74, 54, 
  73, 89, 97, 94, 88, 57, 76, 57, 71, 76, 
  98, 78, 95, 87, 92, 86, 84, 66, 77, 106, 
  79, 77, 74, 76, 101, 92, 72, 95, 102, 107, 
  59, 80, 75, 86, 85, 91, 78, 77, 85, 77, 
  58, 77, 77, 70, 95, 82, 84, 83, 86, 88, 
  78, 66, 93, 95, 70, 93, 67, 85, 80, 82, 
  72, 73, 90, 80, 88, 77, 81, 90, 82, 78, 
  83, 65, 78, 97, 71, 74, 88, 85, 95, 86, 
  85, 101, 88, 77, 80, 84, 81, 89, 89, 85, 
  104, 78, 83, 90, 92, 81, 80, 90, 81, 80, 
  99, 85, 84, 99, 90, 78, 87, 85, 82, 96, 
  86, 81, 88, 85, 77, 98, 82, 87, 86, 89, 
  78, 94, 91, 88, 69, 122, 64, 76, 79, 83, 
  90, 86, 82, 68, 83, 85, 96, 81, 89, 81, 
  83, 76, 85, 84, 78, 68, 75, 80, 92, 90, 
  84, 107, 87, 85, 91, 94, 94, 101, 98, 85, 
  83, 94, 98, 93, 63, 85, 82, 93, 73, 93, 
  84, 81, 87, 75, 88, 86, 64, 93, 86, 91, 
  97, 87, 85, 92, 91, 79, 77, 91, 81, 65, 
  86, 90, 80, 82, 90, 81, 85, 81, 80, 78, 
  90, 105, 69, 86, 81, 71, 95, 91, 88, 82, 
  87, 79, 84, 82, 71, 73, 104, 69, 94, 82, 
  114, 94, 83, 74, 69, 89, 91, 81, 89, 97, 
  92, 79, 74, 91, 74, 86, 79, 82, 105, 77, 
  85, 89, 75, 78, 103, 82, 78, 87, 96, 73, 
  81, 108, 91, 87, 84, 91, 87, 83, 77, 95, 
  71, 82, 80, 80, 85, 101, 78, 83, 88, 87, 
  64, 86, 76, 84, 87, 101, 80, 77, 85, 79, 
  73, 75, 83, 84, 83, 74, 70, 89, 74, 97, 
  99, 86, 75, 83, 82, 93, 91, 63, 70, 79, 
  92, 81, 89, 91, 87, 79, 85, 79, 84, 90, 
  85, 86, 87, 93, 94, 81, 89, 87, 94, 73, 
  75, 83, 96, 86, 84, 84, 68, 90, 80, 106, 
  72, 96, 74, 62, 94, 89, 86, 77, 85, 79, 
  76, 73, 74, 78, 102, 77, 90, 83, 103, 88, 
  88, 75, 74, 87, 96, 78, 97, 95, 92, 81, 
  83, 73, 83, 97, 84, 81, 110, 75, 93, 94, 
  74, 77, 103, 86, 87, 87, 95, 81, 89, 127, 
  87, 86, 75, 87, 83, 75, 88, 100, 67, 89, 
  68, 82, 89, 94, 75, 82, 82, 87, 55, 90, 
  78, 82, 78, 87, 77, 74, 84, 85, 75, 74, 
  85, 87, 83, 76, 63, 89, 69, 107, 88, 83, 
  63, 76, 65, 90, 99, 60, 70, 84, 90, 78, 
  77, 84, 76, 72, 90, 75, 96, 91, 85, 80, 
  94, 89, 75, 74, 87, 93, 81, 73, 83, 79, 
  108, 85, 76, 78, 82, 98, 88, 87, 71, 107, 
  83, 71, 96, 93, 86, 81, 80, 73, 79, 90, 
  78, 70, 101, 71, 81, 80, 89, 89, 85, 78, 
  69, 85, 86, 78, 87, 96, 88, 80, 80, 82, 
  77, 89, 76, 87, 96, 78, 86, 83, 81, 88, 
  90, 98, 80, 84, 92, 70, 85, 103, 91, 82, 
  86, 91, 85, 80, 78, 92, 74, 80, 81, 85, 
  76, 93, 73, 74, 94, 87, 70, 85, 75, 91, 
  83, 78, 78, 77, 79, 80, 87, 89, 74, 85, 
  84, 74, 75, 98, 75, 107, 102, 86, 84, 81, 
  80, 88, 104, 63, 69, 85, 96, 85, 84, 83, 
  83, 78, 87, 83, 97, 85, 88, 91, 82, 86, 
  81, 85, 90, 91, 79, 76, 65, 87, 87, 85, 
  86, 80, 69, 70, 77, 122, 82, 73, 84, 71, 
  105, 93, 76, 84, 86, 100, 80, 89, 72, 71, 
  83, 74, 93, 74, 119, 94, 81, 75, 98, 74, 
  99, 79, 85, 83, 91, 74, 85, 95, 80, 73, 
  77, 72, 94, 94, 81, 105, 79, 89, 100, 96, 
  93, 84, 92, 78, 79, 116, 83, 100, 87, 80, 
  81, 95, 75, 97, 74, 75, 79, 65, 84, 113, 
  104, 76, 107, 88, 75, 83, 67, 70, 98, 92, 
  85, 85, 97, 86, 92, 70, 81, 81, 86, 74, 
  70, 78, 60, 89, 75, 89, 64, 75, 63, 88, 
  90, 73, 70, 93, 87, 74, 85, 98, 89, 72, 
  83, 52, 88, 86, 84, 92, 81, 91, 71, 68, 
  76, 82, 91, 63, 90, 71, 91, 86, 78, 75, 
  68, 91, 97, 156, 86, 75, 76, 50, 114, 85, 
  73, 77, 83, 85, 84, 99, 69, 67, 74, 74, 
  94, 82, 83, 83, 98, 81, 122, 66, 111, 83, 
  81, 107, 102, 75, 87, 74, 82, 73, 87, 73, 
  82, 84, 93, 102, 72, 85, 111, 93, 102, 90, 
  99, 93, 99, 150, 82, 89, 67, 81, 66, 85, 
  83, 104, 76, 92, 73, 67, 90, 90, 103, 76, 
  79, 81, 62, 83, 67, 47, 96, 90, 79, 79, 
  105, 105, 106, 82, 77, 91, 92, 71, 70, 76, 
  47, 94, 56, 94, 46, 63, 36, 86, 98, 65, 
  74, 86, 73, 69, 78, 79, 86, 62, 99, 48, 
  106, 71, 83, 87, 82, 87, 76, 55, 58, 87, 
  84, 62, 117, 60, 110, 92, 51, 70, 77, 89, 
  97, 101, 76, 104, 82, 65, 96, 93, 76, 88, 
  74, 78, 77, 92, 82, 73, 87, 78, 79, 76, 
  73, 87, 91, 75, 94, 70, 95, 86, 82, 97, 
  84, 78, 84, 68, 80, 78, 82, 78, 92, 90, 
  84, 100, 80, 88, 89, 88, 90, 83, 89, 81, 
  80, 107, 78, 80, 88, 84, 80, 88, 73, 97, 
  77, 69, 84, 72, 82, 107, 88, 79, 78, 87, 
  71, 88, 69, 75, 88, 85, 73, 80, 88, 88, 
  108, 97, 74, 91, 89, 79, 75, 83, 63, 99, 
  77, 93, 71, 68, 63, 88, 99, 64, 69, 78, 
  87, 76, 83, 95, 83, 72, 85, 63, 103, 91, 
  88, 92, 83, 95, 98, 69, 76, 86, 72, 67, 
  75, 76, 82, 88, 85, 74, 76, 76, 81, 97, 
  88, 77, 73, 83, 99, 97, 71, 71, 83, 95, 
  81, 99, 69, 63, 76, 89, 83, 76, 107, 102, 
  82, 76, 106, 67, 81, 84, 72, 77, 74, 68, 
  89, 101, 88, 70, 75, 73, 78, 84, 74, 84, 
  68, 85, 81, 89, 100, 79, 81, 67, 82, 103, 
  76, 101, 103, 77, 84, 91, 68, 95, 83, 85, 
  75, 65, 82, 100, 90, 79, 98, 87, 106, 90, 
  68, 91, 97, 91, 113, 80, 82, 75, 104, 81, 
  87, 81, 81, 83, 72, 81, 67, 82, 81, 82, 
  72, 72, 68, 75, 71, 78, 67, 93, 91, 81, 
  86, 106, 73, 75, 64, 69, 81, 92, 82, 91, 
  80, 80, 74, 85, 83, 89, 93, 71, 86, 64, 
  74, 85, 99, 74, 79, 83, 90, 118, 94, 79, 
  57, 62, 103, 91, 67, 67, 83, 89, 88, 103, 
  74, 61, 72, 92, 85, 74, 79, 96, 92, 72, 
  117, 60, 99, 98, 76, 93, 87, 70, 86, 82, 
  80, 50, 82, 68, 66, 72, 77, 96, 61, 85, 
  76, 98, 98, 80, 82, 78, 97, 112, 69, 85, 
  90, 75, 80, 91, 73, 106, 83, 96, 79, 64, 
  85, 99, 102, 82, 89, 85, 97, 84, 51, 68, 
  100, 90, 106, 76, 85, 78, 132, 88, 94, 87, 
  86, 79, 78, 73, 56, 88, 61, 89, 59, 61, 
  53, 78, 76, 75, 62, 88, 86, 81, 90, 110, 
  73, 72, 60, 60, 86, 87, 77, 87, 98, 83, 
  92, 74, 65, 96, 80, 70, 97, 49, 75, 84, 
  82, 73, 81, 84, 75, 89, 86, 99, 71, 77, 
  93, 94, 76, 73, 76, 80, 79, 94, 82, 68, 
  80, 78, 78, 77, 72, 94, 87, 70, 99, 66, 
  79, 101, 73, 86, 69, 74, 86, 75, 85, 67, 
  82, 77, 78, 82, 79, 90, 67, 84, 76, 91, 
  92, 75, 81, 81, 83, 96, 79, 71, 97, 80, 
  89, 87, 68, 90, 86, 78, 77, 71, 78, 98, 
  90, 84, 78, 86, 95, 92, 61, 96, 90, 81, 
  97, 73, 77, 81, 104, 94, 81, 84, 82, 92, 
  77, 86, 69, 85, 88, 81, 75, 68, 69, 80, 
  91, 64, 70, 72, 91, 80, 89, 100, 76, 79, 
  63, 77, 92, 90, 85, 87, 91, 90, 103, 87, 
  84, 89, 81, 73, 76, 74, 73, 82, 101, 80, 
  81, 77, 79, 83, 76, 85, 75, 94, 81, 90, 
  68, 86, 88, 106, 71, 83, 84, 72, 85, 87, 
  87, 98, 90, 87, 79, 71, 85, 89, 95, 80, 
  84, 72, 84, 74, 79, 85, 67, 85, 93, 74, 
  90, 76, 89, 81, 86, 84, 78, 75, 88, 95, 
  98, 81, 95, 89, 79, 80, 64, 73, 80, 75, 
  92, 91, 85, 80, 62, 79, 123, 90, 84, 59, 
  79, 76, 99, 92, 78, 78, 75, 89, 82, 80, 
  82, 92, 88, 88, 73, 91, 98, 80, 86, 80, 
  79, 89, 95, 78, 93, 80, 68, 76, 87, 86, 
  78, 81, 92, 75, 89, 84, 79, 87, 81, 98, 
  70, 99, 75, 89, 84, 81, 81, 90, 77, 85, 
  83, 79, 96, 88, 81, 90, 80, 87, 77, 79, 
  83, 92, 102, 79, 69, 93, 78, 90, 75, 81, 
  83, 98, 68, 85, 93, 78, 93, 93, 86, 95, 
  85, 78, 91, 65, 80, 97, 94, 85, 81, 85, 
  95, 68, 77, 74, 57, 87, 121, 67, 96, 70, 
  94, 97, 92, 86, 87, 75, 86, 90, 100, 74, 
  89, 94, 71, 89, 64, 79, 74, 69, 95, 100, 
  85, 79, 55, 71, 122, 97, 98, 66, 67, 70, 
  100, 94, 77, 70, 68, 78, 82, 77, 80, 88, 
  92, 92, 73, 87, 84, 91, 77, 77, 76, 98, 
  89, 84, 90, 92, 75, 76, 88, 74, 83, 85, 
  91, 75, 81, 79, 74, 79, 80, 91, 64, 135, 
  78, 82, 84, 74, 77, 93, 77, 86, 85, 77, 
  94, 87, 80, 91, 83, 84, 72, 87, 81, 85, 
  74, 88, 76, 103, 86, 89, 67, 91, 95, 84, 
  68, 88, 81, 72, 84, 83, 78, 94, 86, 89, 
  71, 71, 85, 83, 93, 90, 77, 82, 86, 77, 
  84, 86, 71, 87, 116, 78, 85, 76, 85, 85, 
  89, 82, 80, 87, 89, 94, 97, 82, 99, 91, 
  83, 91, 77, 66, 79, 82, 92, 91, 79, 81, 
  70, 80, 101, 91, 79, 72, 78, 79, 97, 81, 
  76, 75, 75, 73, 77, 85, 80, 88, 84, 83, 
  75, 85, 86, 88, 84, 78, 81, 87, 92, 74, 
  93, 80, 67, 74, 79, 81, 80, 88, 91, 76, 
  90, 80, 89, 85, 79, 96, 66, 97, 73, 98, 
  78, 83, 82, 86, 78, 84, 88, 78, 96, 88, 
  83, 90, 77, 88, 80, 62, 73, 74, 106, 76, 
  71, 85, 73, 93, 85, 80, 71, 78, 66, 74, 
  90, 85, 90, 103, 95, 95, 105, 75, 84, 66, 
  83, 97, 105, 99, 78, 86, 92, 70, 84, 95, 
  67, 78, 141, 69, 89, 65, 95, 101, 93, 73, 
  75, 71, 87, 85, 92, 67, 73, 88, 68, 85, 
  86, 74, 73, 68, 74, 107, 81, 81, 67, 72, 
  92, 93, 93, 69, 73, 63, 95, 92, 77, 81, 
  82, 85, 109, 72, 66, 77, 83, 103, 78, 77, 
  91, 105, 64, 88, 90, 77, 85, 59, 94, 95, 
  81, 79, 78, 87, 93, 81, 87, 82, 86, 88, 
  72, 81, 84, 85, 77, 135, 69, 84, 89, 83, 
  80, 87, 58, 78, 84, 72, 72, 78, 69, 88, 
  83, 84, 78, 62, 65, 76, 137, 76, 77, 81, 
  67, 98, 90, 70, 60, 108, 73, 71, 93, 85, 
  87, 112, 102, 99, 72, 67, 81, 64, 75, 98, 
  101, 109, 82, 85, 86, 70, 83, 89, 47, 70, 
  136, 72, 90, 54, 97, 117, 101, 75, 77, 71, 
  89, 76, 86, 64, 70, 93, 60, 77, 90, 83, 
  65, 57, 78, 128, 75, 77, 69, 70, 68, 95, 
  118, 64, 66, 58, 92, 77, 90, 74, 72, 75, 
  105, 67, 67, 74, 83, 88, 90, 70, 75, 104, 
  57, 85, 87, 77, 70, 61, 94, 105, 82, 87, 
  78, 76, 74, 80, 92, 81, 90, 95, 64, 72, 
  81, 74, 80, 173, 80, 77, 87, 68, 71, 86, 
  59, 78, 90, 68, 61, 77, 74, 87, 90, 75, 
  81, 68, 70, 81, 86, 93, 77, 92, 80, 89, 
  88, 78, 79, 125, 67, 75, 89, 77, 90, 88, 
  90, 97, 75, 77, 64, 70, 89, 92, 99, 109, 
  79, 94, 92, 74, 84, 92, 69, 82, 102, 73, 
  79, 69, 92, 88, 88, 75, 82, 84, 87, 92, 
  88, 72, 79, 85, 79, 74, 93, 73, 74, 81, 
  83, 97, 81, 74, 74, 79, 76, 87, 92, 77, 
  70, 77, 92, 83, 86, 84, 78, 80, 89, 76, 
  70, 76, 79, 82, 78, 76, 83, 99, 73, 84, 
  91, 99, 85, 61, 94, 89, 79, 77, 76, 83, 
  95, 98, 85, 79, 87, 85, 83, 76, 84, 89, 
  81, 114, 72, 93, 88, 90, 78, 81, 70, 76, 
  96, 77, 81, 83, 75, 88, 83, 92, 81, 83, 
  83, 75, 64, 103, 86, 89, 88, 84, 78, 93, 
  91, 60, 76, 96, 75, 101, 82, 81, 83, 78, 
  97, 83, 83, 81, 89, 88, 85, 94, 89, 91, 
  91, 72, 76, 89, 83, 79, 104, 82, 81, 76, 
  84, 87, 77, 77, 87, 78, 80, 88, 100, 89, 
  84, 90, 81, 93, 82, 75, 80, 93, 87, 76, 
  89, 86, 93, 83, 82, 77, 80, 75, 78, 80, 
  98, 81, 77, 84, 83, 87, 92, 83, 84, 95, 
  84, 92, 85, 84, 95, 74, 98, 84, 84, 82, 
  83, 74, 93, 71, 80, 81, 88, 87, 90, 80, 
  84, 74, 84, 91, 78, 85, 81, 94, 87, 74, 
  74, 85, 93, 98, 81, 85, 82, 75, 92, 79, 
  100, 84, 80, 92, 78, 85, 82, 84, 77, 73, 
  66, 83, 93, 93, 83, 86, 77, 94, 90, 78, 
  78, 95, 68, 97, 75, 77, 88, 75, 83, 82, 
  80, 81, 98, 92, 77, 94, 92, 92, 97, 71, 
  88, 77, 81, 71, 75, 83, 77, 75, 90, 80, 
  69, 83, 90, 77, 96, 94, 93, 89, 89, 91, 
  78, 86, 83, 76, 84, 85, 89, 74, 90, 86, 
  77, 84, 76, 59, 84, 66, 73, 91, 95, 80, 
  84, 90, 78, 84, 103, 79, 89, 95, 83, 82, 
  85, 85, 85, 66, 99, 91, 91, 79, 89, 79, 
  80, 63, 85, 80, 95, 80, 91, 69, 89, 70, 
  89, 90, 76, 82, 82, 102, 93, 69, 87, 87, 
  95, 101, 67, 89, 86, 83, 94, 80, 103, 92, 
  84, 93, 83, 88, 84, 79, 85, 76, 70, 96, 
  88, 92, 89, 81, 78, 85, 89, 98, 83, 91, 
  77, 90, 82, 81, 81, 85, 94, 82, 76, 84, 
  86, 83, 78, 84, 91, 87, 86, 78, 90, 87, 
  82, 78, 67, 80, 78, 75, 81, 83, 77, 80, 
  93, 84, 80, 84, 94, 96, 87, 89, 84, 77, 
  83, 79, 76, 93, 88, 75, 85, 88, 101, 84, 
  83, 79, 79, 76, 87, 81, 96, 82, 85, 83, 
  79, 90, 93, 82, 90, 88, 80, 81, 89, 86, 
  84, 73, 97, 83, 83, 90, 83, 83, 92, 72, 
  82, 81, 85, 83, 92, 79, 83, 71, 83, 95, 
  80, 88, 77, 95, 88, 77, 77, 96, 97, 88, 
  74, 82, 88, 75, 84, 82, 95, 88, 82, 87, 
  83, 85, 95, 86, 84, 93, 86, 92, 72, 104, 
  99, 85, 83, 76, 100, 64, 64, 106, 88, 92, 
  80, 78, 84, 84, 96, 88, 71, 66, 84, 90, 
  90, 85, 81, 85, 100, 73, 84, 91, 80, 87, 
  104, 77, 90, 80, 84, 89, 86, 90, 79, 87, 
  82, 95, 80, 94, 85, 88, 104, 82, 92, 90, 
  92, 81, 77, 78, 85, 83, 83, 83, 92, 76, 
  93, 79, 105, 82, 111, 111, 70, 89, 87, 80, 
  85, 68, 102, 75, 82, 86, 92, 72, 80, 86, 
  90, 74, 84, 115, 89, 80, 96, 67, 93, 75, 
  77, 90, 97, 73, 86, 85, 76, 72, 78, 85, 
  73, 99, 88, 90, 84, 83, 83, 68, 78, 75, 
  92, 79, 68, 78, 79, 112, 91, 85, 82, 87, 
  93, 78, 93, 102, 95, 97, 69, 112, 105, 87, 
  81, 76, 93, 79, 70, 106, 84, 97, 85, 76, 
  89, 92, 99, 89, 71, 63, 100, 95, 87, 82, 
  74, 80, 98, 66, 89, 87, 73, 89, 75, 69, 
  98, 71, 87, 86, 90, 100, 80, 79, 75, 93, 
  86, 98, 85, 81, 109, 68, 93, 86, 92, 84, 
  77, 78, 85, 77, 101, 70, 92, 69, 92, 87, 
  84, 74, 129, 111, 72, 84, 87, 88, 79, 57, 
  97, 77, 86, 87, 78, 78, 83, 74, 82, 77, 
  89, 116, 89, 80, 107, 63, 86, 73, 72, 81, 
  93, 75, 84, 88, 76, 71, 77, 86, 74, 101, 
  90, 93, 93, 85, 77, 58, 97, 76, 83, 77, 
  77, 75, 81, 123, 86, 95, 83, 86, 98, 73, 
  102, 95, 90, 86, 79, 95, 92, 87, 87, 81, 
  96, 108, 68, 101, 82, 88, 88, 82, 86, 92, 
  85, 92, 71, 72, 85, 86, 81, 82, 83, 81, 
  102, 71, 85, 91, 76, 83, 69, 79, 90, 82, 
  83, 85, 80, 88, 77, 83, 80, 97, 75, 108, 
  88, 87, 112, 74, 90, 85, 94, 85, 75, 79, 
  84, 81, 85, 85, 89, 80, 94, 79, 75, 78, 
  115, 102, 77, 90, 85, 89, 80, 76, 106, 69, 
  84, 74, 88, 79, 74, 80, 94, 74, 83, 107, 
  93, 86, 95, 70, 89, 77, 80, 90, 86, 72, 
  90, 82, 77, 73, 79, 83, 74, 99, 98, 85, 
  86, 86, 92, 71, 101, 80, 92, 79, 81, 78, 
  81, 116, 91, 93, 90, 91, 90, 82, 85, 74, 
  75, 70, 72, 70, 71, 75, 79, 82, 90, 67, 
  76, 77, 84, 82, 66, 92, 76, 59, 85, 80, 
  91, 76, 70, 76, 104, 84, 93, 86, 79, 95, 
  74, 90, 104, 80, 97, 82, 80, 84, 80, 81, 
  83, 71, 86, 89, 83, 74, 80, 67, 81, 93, 
  70, 96, 82, 84, 82, 92, 99, 75, 98, 90, 
  89, 73, 98, 77, 90, 78, 86, 98, 76, 91, 
  86, 60, 82, 77, 95, 81, 78, 107, 73, 100, 
  101, 71, 77, 88, 66, 76, 66, 90, 72, 81, 
  81, 71, 86, 96, 84, 77, 81, 87, 87, 92, 
  89, 67, 78, 81, 89, 72, 86, 81, 59, 82, 
  83, 98, 78, 92, 85, 75, 73, 84, 71, 69, 
  69, 87, 68, 73, 94, 80, 78, 64, 83, 65, 
  73, 69, 64, 71, 78, 84, 86, 84, 80, 77, 
  83, 84, 63, 89, 81, 55, 66, 74, 87, 82, 
  75, 68, 105, 79, 104, 82, 72, 92, 84, 79, 
  104, 80, 75, 77, 81, 80, 90, 84, 92, 68, 
  83, 83, 85, 67, 79, 63, 81, 90, 63, 81, 
  80, 83, 76, 89, 95, 78, 99, 88, 74, 66, 
  91, 72, 100, 71, 71, 95, 72, 83, 97, 51, 
  77, 89, 103, 74, 79, 110, 67, 77, 116, 69, 
  78, 82, 48, 80, 66, 89, 65, 82, 79, 72, 
  82, 94, 90, 64, 68, 81, 81, 94, 102, 60, 
  74, 83, 95, 66, 96, 82, 57, 78, 86, 87, 
  64, 94, 82, 74, 75, 76, 74, 56, 73, 94, 
  69, 67, 88, 74, 87, 78, 77, 89, 67, 71, 
  77, 79, 85, 82, 83, 100, 72, 80, 81, 84, 
  75, 96, 81, 64, 66, 81, 76, 74, 80, 77, 
  92, 76, 89, 83, 84, 77, 75, 84, 87, 76, 
  59, 77, 77, 87, 84, 82, 80, 76, 79, 92, 
  78, 77, 79, 81, 81, 91, 84, 80, 86, 81, 
  85, 88, 93, 73, 100, 81, 90, 79, 87, 77, 
  98, 78, 75, 94, 87, 90, 93, 64, 88, 94, 
  94, 85, 81, 97, 76, 69, 96, 71, 79, 82, 
  75, 75, 72, 106, 73, 81, 90, 70, 82, 92, 
  88, 77, 78, 99, 90, 88, 85, 68, 79, 76, 
  86, 79, 87, 83, 67, 85, 93, 90, 76, 92, 
  88, 68, 82, 87, 78, 79, 75, 89, 72, 80, 
  88, 88, 85, 87, 92, 80, 78, 71, 75, 81, 
  82, 87, 94, 92, 82, 75, 85, 77, 79, 83, 
  85, 66, 84, 92, 82, 80, 84, 87, 92, 87, 
  98, 83, 85, 104, 91, 84, 81, 100, 57, 83, 
  89, 91, 87, 82, 86, 83, 84, 90, 85, 83, 
  90, 78, 84, 92, 74, 78, 83, 77, 86, 86, 
  95, 93, 91, 84, 98, 75, 85, 72, 87, 78, 
  86, 92, 80, 81, 84, 72, 80, 87, 86, 89, 
  78, 87, 78, 83, 83, 84, 78, 78, 81, 74, 
  78, 83, 87, 89, 84, 79, 92, 88, 85, 90, 
  87, 93, 88, 90, 82, 80, 88, 83, 87, 76, 
  75, 86, 71, 90, 79, 80, 75, 102, 87, 89, 
  83, 87, 79, 72, 65, 93, 70, 79, 93, 78, 
  80, 80, 95, 75, 80, 70, 68, 77, 82, 86, 
  99, 78, 83, 79, 89, 82, 81, 81, 86, 54, 
  75, 93, 84, 83, 82, 79, 101, 85, 106, 90, 
  80, 106, 86, 76, 87, 99, 86, 85, 94, 96, 
  85, 82, 83, 74, 83, 86, 94, 82, 87, 68, 
  85, 85, 68, 79, 80, 75, 84, 84, 104, 94, 
  89, 84, 85, 73, 100, 66, 91, 90, 74, 99, 
  74, 80, 81, 64, 80, 99, 81, 93, 78, 79, 
  76, 81, 88, 91, 81, 86, 72, 73, 71, 77, 
  85, 97, 75, 83, 92, 86, 90, 87, 78, 75, 
  87, 91, 83, 77, 85, 87, 85, 77, 75, 82, 
  68, 84, 75, 90, 82, 103, 86, 97, 86, 83, 
  83, 62, 62, 92, 64, 78, 85, 79, 92, 92, 
  84, 100, 72, 67, 78, 80, 85, 83, 92, 67, 
  76, 79, 88, 82, 83, 88, 89, 59, 80, 96, 
  82, 77, 82, 87, 88, 92, 89, 89, 83, 89, 
  84, 84, 80, 97, 100, 83, 91, 92, 78, 87, 
  87, 78, 83, 88, 84, 91, 87, 80, 83, 89, 
  80, 93, 83, 76, 89, 83, 93, 80, 86, 80, 
  88, 82, 85, 74, 86, 87, 81, 99, 84, 82, 
  78, 76, 85, 97, 86, 93, 78, 90, 74, 78, 
  85, 86, 85, 83, 85, 75, 73, 78, 89, 86, 
  81, 79, 90, 86, 90, 84, 87, 69, 88, 86, 
  76, 80, 86, 81, 87, 83, 77, 85, 78, 84, 
  77, 87, 97, 102, 85, 84, 86, 87, 82, 83, 
  71, 92, 71, 85, 55, 88, 86, 106, 87, 67, 
  88, 84, 82, 77, 96, 90, 79, 95, 79, 73, 
  67, 72, 107, 98, 83, 97, 75, 82, 90, 83, 
  101, 72, 113, 93, 89, 78, 92, 74, 79, 88, 
  74, 120, 91, 75, 113, 67, 92, 93, 61, 95, 
  63, 105, 94, 75, 90, 106, 77, 103, 96, 92, 
  89, 85, 108, 76, 76, 100, 128, 75, 90, 76, 
  82, 91, 70, 77, 98, 90, 61, 71, 85, 82, 
  71, 84, 114, 75, 84, 91, 101, 82, 83, 87, 
  98, 97, 80, 115, 93, 78, 55, 75, 78, 91, 
  92, 85, 63, 123, 81, 81, 86, 87, 77, 71, 
  99, 96, 122, 60, 122, 86, 94, 96, 87, 87, 
  85, 77, 89, 89, 100, 74, 109, 70, 83, 76, 
  93, 77, 61, 79, 77, 109, 86, 64, 82, 79, 
  78, 84, 92, 90, 72, 93, 81, 77, 71, 72, 
  101, 93, 93, 85, 74, 77, 86, 87, 98, 70, 
  70, 95, 85, 76, 81, 77, 82, 75, 74, 112, 
  91, 78, 99, 64, 86, 88, 64, 86, 56, 95, 
  87, 78, 80, 102, 74, 100, 90, 92, 85, 79, 
  94, 81, 76, 89, 128, 70, 95, 77, 79, 90, 
  73, 79, 92, 98, 61, 77, 86, 80, 74, 85, 
  106, 79, 80, 85, 95, 79, 75, 90, 97, 91, 
  68, 111, 80, 82, 58, 74, 79, 82, 87, 88, 
  74, 109, 85, 77, 85, 83, 74, 68, 91, 91, 
  122, 64, 120, 87, 85, 91, 84, 82, 84, 78, 
  90, 87, 110, 80, 102, 74, 81, 80, 90, 72, 
  66, 76, 73, 100, 83, 73, 86, 83, 83, 80, 
  87, 88, 77, 85, 81, 78, 74, 79, 97, 87, 
  89, 83, 77, 85, 84, 80, 99, 72, 101, 89, 
  80, 75, 83, 81, 77, 73, 74, 103, 87, 81, 
  101, 67, 83, 91, 67, 93, 61, 91, 88, 77, 
  84, 98, 79, 87, 95, 83, 88, 82, 98, 80, 
  77, 90, 120, 74, 83, 76, 82, 86, 77, 79, 
  90, 91, 64, 74, 97, 80, 79, 92, 96, 79, 
  79, 90, 87, 80, 79, 89, 96, 89, 81, 102, 
  86, 79, 61, 74, 82, 80, 83, 85, 94, 101, 
  83, 79, 82, 83, 78, 72, 96, 90, 110, 74, 
  104, 82, 85, 86, 77, 85, 93, 76, 89, 88, 
  104, 77, 92, 69, 85, 80, 85, 74, 82, 80, 
  83, 99, 78, 77, 86, 89, 77, 85, 86, 82, 
  90, 89, 87, 76, 72, 94, 93, 84, 78, 82, 
  80, 91, 88, 91, 94, 67, 98, 91, 90, 69, 
  81, 73, 79, 81, 82, 90, 82, 80, 87, 69, 
  84, 79, 93, 90, 64, 84, 83, 85, 83, 93, 
  81, 69, 93, 74, 86, 91, 67, 87, 86, 82, 
  112, 83, 76, 85, 73, 81, 64, 92, 80, 83, 
  75, 81, 81, 85, 83, 79, 90, 82, 92, 84, 
  74, 73, 79, 86, 90, 82, 81, 101, 68, 82, 
  58, 81, 85, 81, 76, 89, 53, 75, 87, 81, 
  84, 82, 70, 56, 98, 83, 105, 90, 118, 81, 
  79, 85, 84, 73, 82, 79, 82, 83, 109, 93, 
  60, 82, 82, 87, 74, 80, 90, 74, 75, 97, 
  75, 77, 86, 87, 75, 92, 83, 87, 87, 81, 
  90, 82, 78, 89, 84, 81, 88, 76, 84, 93, 
  77, 94, 99, 67, 79, 87, 83, 64, 79, 76, 
  78, 69, 82, 87, 81, 81, 81, 73, 75, 77, 
  98, 92, 52, 78, 81, 85, 78, 87, 77, 67, 
  86, 84, 85, 86, 66, 88, 86, 78, 101, 85, 
  73, 86, 68, 80, 66, 95, 79, 85, 78, 81, 
  81, 82, 87, 76, 86, 87, 88, 84, 75, 74, 
  82, 87, 86, 80, 75, 107, 56, 85, 54, 83, 
  89, 79, 74, 94, 65, 68, 85, 79, 85, 80, 
  75, 60, 90, 79, 109, 97, 110, 79, 77, 88, 
  79, 71, 74, 81, 80, 83, 96, 103, 56, 84, 
  79, 86, 73, 81, 87, 76, 70, 93, 78, 82, 
  87, 86, 77, 86, 79, 82, 87, 77, 83, 83, 
  76, 91, 84, 80, 88, 78, 84, 94, 75, 83, 
  95, 71, 93, 85, 85, 67, 83, 81, 86, 77, 
  82, 88, 81, 83, 83, 73, 79, 83, 89, 91, 
  58, 82, 81, 81, 79, 88, 81, 66, 86, 86, 
  87, 92, 69, 88, 87, 82, 102, 84, 75, 84, 
  69, 80, 75, 91, 82, 82, 75, 81, 93, 83, 
  84, 80, 89, 83, 85, 88, 74, 80, 83, 85, 
  82, 83, 85, 96, 67, 82, 59, 80, 90, 75, 
  78, 87, 82, 72, 89, 86, 86, 81, 74, 64, 
  98, 82, 100, 95, 97, 77, 78, 85, 74, 72, 
  82, 81, 81, 87, 83, 96, 58, 79, 83, 85, 
  73, 78, 87, 85, 85, 87, 82, 97, 83, 83, 
  86, 86, 73, 82, 96, 83, 88, 79, 61, 101, 
  75, 92, 70, 76, 87, 107, 90, 81, 92, 71, 
  85, 88, 80, 77, 90, 90, 89, 83, 81, 83, 
  75, 90, 69, 84, 85, 80, 94, 90, 75, 83, 
  91, 83, 87, 86, 92, 56, 92, 78, 89, 91, 
  59, 85, 87, 96, 81, 93, 76, 94, 73, 79, 
  73, 87, 86, 86, 87, 82, 87, 91, 91, 82, 
  84, 81, 82, 84, 69, 82, 85, 90, 90, 78, 
  83, 97, 68, 79, 70, 84, 87, 83, 79, 90, 
  67, 68, 79, 88, 82, 85, 70, 77, 90, 84, 
  91, 105, 105, 78, 78, 89, 83, 82, 80, 85, 
  82, 86, 90, 92, 43, 83, 90, 96, 68, 80, 
  90, 83, 80, 88, 87, 102, 80, 79, 83, 92, 
  72, 87, 95, 81, 88, 87, 66, 92, 68, 93, 
  80, 75, 100, 107, 82, 79, 85, 70, 80, 87, 
  77, 73, 83, 90, 87, 80, 85, 86, 78, 93, 
  70, 85, 74, 83, 93, 89, 73, 78, 89, 84, 
  80, 83, 88, 61, 92, 83, 88, 88, 61, 85, 
  91, 90, 77, 94, 77, 95, 74, 78, 80, 90, 
  85, 85, 88, 81, 92, 85, 94, 81, 79, 82, 
  79, 85, 66, 74, 93, 92, 90, 88, 78, 87, 
  57, 84, 67, 86, 91, 79, 85, 90, 82, 68, 
  76, 93, 84, 82, 76, 76, 84, 83, 83, 109, 
  94, 79, 79, 89, 81, 88, 81, 87, 81, 86, 
  77, 96, 41, 86, 93, 93, 74, 84, 92, 79, 
  80, 90, 83, 93, 83, 78, 83, 83, 69, 86, 
  93, 76, 82, 85, 61, 93, 75, 86, 84, 76, 
  92, 105, 81, 79, 88, 71, 81, 88, 82, 73, 
  88, 90, 88, 81, 81, 83, 80, 91, 74, 86, 
  75, 82, 91, 85, 73, 82, 87, 80, 84, 85, 
  89, 61, 92, 88, 92, 91, 60, 84, 87, 92, 
  82, 91, 74, 92, 64, 77, 78, 85, 79, 83, 
  83, 82, 93, 91, 88, 80, 80, 78, 77, 86, 
  71, 74, 91, 90, 84, 85, 85, 91, 72, 82, 
  69, 82, 88, 76, 83, 87, 91, 75, 81, 90, 
  86, 83, 72, 75, 89, 84, 87, 101, 92, 76, 
  74, 86, 80, 79, 90, 85, 83, 85, 83, 87, 
  53, 87, 93, 90, 69, 77, 88, 84, 86, 87, 
  74, 85, 73, 81, 78, 91, 88, 85, 79, 70, 
  82, 82, 77, 104, 86, 81, 86, 73, 87, 86, 
  95, 83, 73, 78, 92, 99, 101, 84, 82, 84, 
  90, 78, 87, 81, 83, 83, 79, 83, 77, 81, 
  74, 71, 90, 84, 79, 88, 70, 86, 88, 80, 
  86, 71, 70, 78, 65, 85, 89, 85, 88, 84, 
  76, 87, 84, 85, 88, 95, 70, 82, 75, 93, 
  80, 76, 84, 85, 93, 85, 84, 72, 72, 90, 
  93, 73, 92, 96, 74, 78, 78, 74, 70, 71, 
  75, 81, 86, 84, 70, 68, 76, 79, 87, 78, 
  87, 94, 80, 89, 72, 95, 80, 86, 99, 72, 
  86, 79, 81, 90, 90, 105, 92, 88, 80, 90, 
  81, 89, 91, 80, 80, 86, 72, 86, 79, 73, 
  77, 85, 79, 87, 87, 82, 76, 72, 80, 83, 
  77, 96, 86, 83, 80, 82, 79, 81, 84, 87, 
  75, 78, 87, 95, 103, 88, 83, 79, 91, 75, 
  92, 79, 72, 79, 76, 83, 88, 87, 76, 71, 
  93, 82, 76, 86, 79, 86, 90, 86, 81, 77, 
  72, 77, 64, 89, 97, 92, 88, 88, 71, 87, 
  82, 87, 93, 79, 74, 77, 73, 92, 85, 78, 
  85, 89, 104, 85, 88, 72, 76, 81, 93, 73, 
  78, 93, 77, 80, 76, 78, 74, 69, 81, 77, 
  90, 90, 81, 72, 74, 81, 84, 80, 86, 92, 
  85, 89, 78, 92, 78, 89, 95, 77, 81, 76, 
  71, 89, 92, 108, 90, 90, 83, 89, 82, 86, 
  93, 82, 85, 83, 66, 86, 79, 81, 74, 88, 
  83, 91, 88, 83, 75, 81, 82, 85, 85, 105, 
  85, 83, 78, 84, 87, 84, 69, 82, 78, 81, 
  87, 88, 91, 87, 85, 84, 99, 76, 92, 80, 
  69, 81, 79, 85, 95, 84, 76, 74, 90, 87, 
  73, 89, 74, 86, 88, 78, 92, 83, 68, 76, 
  69, 86, 90, 83, 87, 83, 85, 88, 75, 88, 
  92, 82, 88, 85, 79, 90, 93, 77, 82, 93, 
  102, 89, 87, 70, 77, 72, 89, 71, 77, 95, 
  77, 84, 77, 87, 73, 75, 90, 82, 84, 88, 
  84, 73, 81, 88, 88, 79, 83, 91, 81, 89, 
  69, 97, 77, 90, 95, 95, 77, 76, 70, 88, 
  87, 103, 83, 84, 85, 92, 78, 80, 92, 81, 
  80, 85, 95, 104, 74, 88, 79, 71, 97, 82, 
  74, 80, 90, 68, 72, 108, 81, 82, 76, 77, 
  88, 71, 79, 89, 98, 83, 80, 68, 89, 86, 
  95, 78, 80, 86, 85, 74, 79, 90, 92, 82, 
  79, 90, 70, 96, 72, 91, 101, 82, 84, 77, 
  77, 86, 86, 91, 77, 83, 77, 85, 77, 100, 
  77, 81, 70, 80, 71, 76, 94, 86, 91, 60, 
  77, 77, 69, 75, 78, 76, 88, 101, 85, 89, 
  81, 86, 84, 77, 97, 91, 87, 71, 90, 73, 
  59, 78, 69, 78, 59, 71, 88, 70, 73, 82, 
  61, 84, 86, 70, 87, 111, 83, 83, 70, 75, 
  83, 73, 87, 66, 97, 83, 81, 87, 95, 103, 
  90, 83, 80, 91, 91, 88, 79, 81, 66, 88, 
  83, 94, 79, 79, 78, 76, 99, 77, 73, 79, 
  67, 82, 70, 108, 78, 75, 68, 79, 75, 95, 
  77, 91, 78, 81, 88, 67, 81, 79, 84, 75, 
  74, 88, 72, 67, 84, 93, 81, 83, 88, 85, 
  71, 85, 72, 81, 100, 87, 80, 73, 85, 101, 
  92, 92, 73, 90, 90, 84, 79, 103, 83, 106, 
  73, 90, 71, 85, 95, 93, 105, 58, 85, 68, 
  68, 69, 77, 83, 83, 83, 94, 91, 80, 89, 
  91, 75, 92, 101, 71, 61, 90, 69, 66, 82, 
  70, 72, 66, 63, 85, 78, 84, 104, 63, 94, 
  82, 74, 88, 126, 87, 75, 68, 67, 75, 76, 
  81, 64, 98, 80, 83, 91, 98, 105, 78, 81, 
  80, 85, 84, 83, 72, 88, 75, 102, 74, 101, 
  79, 83, 79, 75, 95, 83, 74, 80, 93, 92, 
  73, 110, 89, 85, 77, 78, 71, 76, 90, 91, 
  73, 85, 84, 73, 85, 84, 91, 88, 80, 93, 
  89, 68, 81, 89, 70, 88, 79, 90, 92, 98, 
  71, 81, 98, 98, 75, 80, 81, 86, 88, 89, 
  75, 83, 77, 91, 78, 98, 77, 78, 71, 81, 
  77, 77, 84, 85, 92, 61, 84, 74, 73, 73, 
  84, 74, 80, 85, 93, 91, 88, 83, 84, 76, 
  98, 94, 79, 70, 90, 78, 62, 80, 68, 80, 
  62, 68, 84, 75, 97, 71, 67, 96, 85, 72, 
  82, 105, 86, 81, 70, 80, 78, 81, 87, 89, 
  91, 72, 78, 88, 96, 102, 73, 82, 78, 90, 
  89, 80, 79, 82, 84, 93, 101, 100, 77, 93, 
  75, 79, 104, 80, 69, 82, 104, 82, 72, 94, 
  82, 64, 74, 82, 90, 91, 87, 77, 87, 80, 
  92, 73, 87, 81, 82, 79, 75, 74, 91, 91, 
  81, 89, 83, 85, 85, 100, 96, 90, 84, 91, 
  82, 88, 86, 82, 100, 84, 91, 99, 80, 73, 
  87, 78, 97, 98, 77, 81, 77, 73, 76, 71, 
  74, 93, 84, 71, 68, 79, 86, 84, 73, 97, 
  98, 108, 74, 90, 73, 89, 98, 79, 89, 93, 
  83, 69, 85, 77, 60, 91, 87, 77, 69, 67, 
  84, 75, 67, 102, 77, 86, 86, 68, 80, 111, 
  88, 79, 70, 81, 80, 69, 83, 75, 96, 90, 
  91, 86, 92, 127, 88, 87, 88, 80, 93, 79, 
  71, 88, 68, 80, 69, 77, 75, 95, 73, 77, 
  100, 79, 68, 79, 64, 82, 74, 79, 74, 60, 
  64, 79, 102, 120, 93, 79, 78, 76, 106, 74, 
  78, 75, 75, 72, 72, 77, 79, 84, 82, 93, 
  85, 76, 97, 95, 87, 71, 101, 99, 76, 90, 
  77, 79, 104, 92, 91, 91, 84, 86, 102, 69, 
  115, 106, 82, 112, 79, 81, 79, 80, 72, 108, 
  87, 72, 87, 75, 102, 89, 67, 117, 100, 92, 
  76, 87, 67, 81, 99, 85, 76, 94, 69, 64, 
  73, 74, 73, 99, 83, 76, 74, 58, 77, 91, 
  69, 135, 88, 100, 91, 72, 87, 140, 98, 68, 
  70, 73, 68, 71, 83, 72, 85, 102, 99, 93, 
  97, 149, 89, 83, 84, 73, 83, 73, 73, 99, 
  85, 81, 78, 93, 77, 83, 74, 75, 105, 82, 
  71, 76, 102, 76, 72, 99, 84, 63, 73, 76, 
  90, 78, 92, 82, 76, 80, 92, 75, 82, 90, 
  84, 91, 76, 95, 89, 78, 84, 90, 79, 89, 
  85, 89, 87, 90, 85, 90, 80, 98, 88, 85, 
  101, 79, 91, 94, 79, 96, 82, 84, 101, 99, 
  75, 80, 77, 70, 81, 73, 75, 90, 85, 71, 
  96, 78, 88, 85, 64, 93, 95, 83, 90, 89, 
  77, 89, 93, 94, 89, 93, 81, 71, 84, 80, 
  64, 92, 85, 79, 65, 65, 83, 77, 87, 87, 
  78, 94, 86, 70, 83, 104, 91, 77, 72, 82, 
  76, 70, 83, 96, 79, 86, 79, 88, 90, 121, 
  81, 90, 90, 79, 92, 75, 70, 87, 90, 88, 
  71, 70, 83, 78, 105, 82, 80, 69, 79, 84, 
  81, 90, 90, 87, 91, 100, 81, 90, 88, 85, 
  75, 93, 80, 85, 84, 73, 78, 76, 91, 87, 
  97, 77, 82, 79, 85, 82, 78, 80, 91, 68, 
  92, 84, 82, 85, 84, 93, 95, 85, 81, 82, 
  76, 92, 78, 90, 95, 91, 78, 86, 83, 92, 
  93, 73, 77, 91, 91, 88, 81, 85, 81, 80, 
  94, 84, 91, 78, 77, 77, 90, 91, 88, 88, 
  79, 74, 96, 77, 91, 77, 79, 85, 82, 81, 
  84, 90, 82, 96, 88, 83, 84, 82, 74, 90, 
  88, 84, 89, 90, 80, 89, 76, 78, 92, 99, 
  83, 89, 88, 100, 78, 89, 83, 86, 86, 88, 
  76, 82, 82, 86, 91, 86, 78, 92, 85, 87, 
  74, 83, 94, 84, 94, 77, 81, 75, 74, 101, 
  86, 94, 76, 69, 92, 90, 89, 88, 66, 101, 
  87, 85, 83, 78, 77, 69, 86, 86, 78, 79, 
  76, 82, 83, 86, 74, 65, 85, 51, 76, 83, 
  76, 89, 93, 87, 96, 72, 91, 91, 85, 74, 
  94, 83, 100, 80, 92, 85, 85, 92, 93, 76, 
  65, 63, 85, 76, 80, 79, 73, 79, 102, 83, 
  84, 82, 72, 75, 85, 70, 89, 85, 81, 70, 
  81, 83, 84, 94, 85, 84, 84, 84, 82, 88, 
  92, 69, 85, 80, 77, 83, 75, 78, 78, 83, 
  80, 89, 79, 87, 80, 71, 82, 86, 80, 90, 
  75, 99, 87, 83, 85, 86, 83, 85, 85, 82, 
  85, 83, 82, 78, 84, 81, 94, 87, 75, 95, 
  85, 84, 94, 88, 80, 73, 80, 112, 70, 87, 
  71, 62, 90, 87, 72, 88, 87, 101, 87, 82, 
  95, 84, 82, 80, 81, 92, 68, 76, 88, 99, 
  102, 89, 82, 75, 84, 63, 80, 85, 78, 96, 
  83, 102, 88, 70, 99, 96, 89, 68, 106, 85, 
  93, 70, 98, 84, 85, 80, 88, 70, 67, 65, 
  78, 73, 83, 79, 94, 95, 96, 94, 77, 80, 
  74, 80, 82, 78, 90, 87, 83, 87, 73, 90, 
  88, 102, 90, 80, 88, 91, 87, 80, 99, 70, 
  88, 76, 86, 92, 85, 93, 86, 82, 80, 91, 
  78, 87, 76, 70, 89, 75, 75, 96, 80, 96, 
  85, 85, 78, 94, 81, 82, 76, 79, 95, 91, 
  84, 83, 88, 88, 80, 87, 73, 79, 76, 79, 
  92, 82, 75, 85, 85, 112, 85, 95, 93, 87, 
  91, 85, 90, 85, 86, 100, 84, 86, 81, 82, 
  89, 74, 77, 87, 76, 68, 71, 76, 84, 86, 
  79, 92, 83, 68, 80, 81, 76, 91, 84, 90, 
  89, 77, 74, 89, 90, 72, 86, 66, 89, 67, 
  85, 81, 83, 78, 88, 54, 66, 61, 94, 81, 
  73, 100, 62, 78, 92, 81, 81, 85, 73, 79, 
  72, 85, 91, 86, 89, 75, 78, 85, 95, 88, 
  83, 87, 86, 78, 80, 93, 95, 77, 82, 81, 
  75, 84, 75, 71, 80, 81, 84, 75, 83, 87, 
  74, 71, 87, 76, 81, 95, 83, 103, 88, 84, 
  77, 95, 88, 86, 84, 80, 89, 79, 87, 85, 
  76, 69, 124, 86, 73, 94, 64, 76, 95, 88, 
  68, 77, 80, 143, 77, 75, 79, 73, 88, 83, 
  83, 92, 114, 99, 88, 76, 92, 79, 146, 82, 
  77, 86, 54, 69, 68, 79, 97, 78, 68, 74, 
  91, 61, 64, 80, 81, 93, 94, 96, 80, 73, 
  74, 109, 94, 58, 97, 46, 92, 53, 89, 75, 
  94, 84, 85, 51, 46, 52, 80, 71, 79, 111, 
  41, 74, 85, 88, 82, 72, 74, 80, 79, 69, 
  84, 83, 86, 88, 70, 91, 90, 116, 80, 82, 
  73, 72, 84, 75, 91, 63, 79, 73, 64, 75, 
  79, 60, 76, 81, 75, 86, 90, 87, 81, 69, 
  93, 67, 72, 91, 97, 96, 120, 74, 71, 92, 
  76, 86, 68, 72, 91, 83, 78, 87, 77, 64, 
  92, 78, 81, 87, 76, 81, 88, 88, 77, 76, 
  91, 101, 90, 74, 78, 83, 87, 85, 84, 80, 
  102, 92, 103, 99, 82, 78, 114, 86, 79, 93, 
  67, 73, 93, 88, 112, 83, 80, 78, 85, 71, 
  78, 84, 89, 100, 84, 89, 75, 79, 87, 93, 
  95, 74, 99, 66, 88, 64, 88, 88, 93, 88, 
  89, 59, 62, 63, 81, 87, 79, 82, 74, 88, 
  85, 92, 91, 82, 72, 78, 84, 88, 87, 88, 
  86, 93, 72, 83, 91, 88, 75, 99, 87, 74, 
  86, 87, 92, 81, 94, 90, 78, 78, 82, 72, 
  87, 81, 87, 88, 72, 91, 79, 70, 88, 67, 
  81, 88, 93, 80, 79, 84, 69, 83, 83, 81, 
  75, 79, 101, 87, 89, 93, 87, 86, 70, 81, 
  82, 94, 74, 83, 96, 94, 77, 75, 81, 112, 
  65, 79, 89, 65, 89, 85, 75, 94, 82, 93, 
  77, 84, 88, 90, 88, 77, 79, 89, 58, 66, 
  88, 91, 94, 85, 90, 91, 82, 71, 82, 77, 
  75, 83, 79, 93, 93, 69, 87, 85, 87, 70, 
  99, 80, 86, 67, 101, 84, 87, 86, 94, 67, 
  74, 67, 83, 81, 82, 93, 93, 83, 92, 84, 
  82, 87, 74, 108, 91, 75, 92, 79, 93, 80, 
  75, 93, 88, 108, 84, 79, 92, 81, 87, 81, 
  100, 71, 79, 79, 85, 93, 86, 88, 97, 82, 
  87, 75, 79, 103, 90, 69, 72, 78, 83, 94, 
  88, 100, 96, 80, 80, 93, 85, 92, 81, 78, 
  94, 85, 86, 89, 74, 76, 85, 81, 74, 97, 
  82, 82, 95, 89, 79, 74, 78, 96, 82, 76, 
  85, 79, 94, 82, 82, 79, 85, 91, 87, 95, 
  81, 80, 102, 70, 89, 82, 67, 86, 81, 86, 
  84, 88, 76, 75, 92, 62, 68, 75, 81, 88, 
  91, 89, 86, 76, 98, 81, 94, 76, 96, 72, 
  89, 78, 88, 92, 90, 90, 91, 79, 67, 60, 
  82, 91, 86, 76, 71, 73, 95, 91, 90, 87, 
  83, 86, 95, 67, 95, 85, 89, 79, 78, 89, 
  85, 90, 89, 86, 96, 78, 90, 86, 99, 71, 
  87, 88, 77, 87, 82, 84, 86, 80, 84, 87, 
  77, 102, 87, 73, 77, 86, 77, 80, 90, 81, 
  87, 78, 77, 79, 79, 84, 77, 81, 88, 91, 
  85, 86, 85, 82, 68, 78, 81, 81, 95, 89, 
  75, 85, 82, 82, 80, 70, 98, 85, 86, 96, 
  79, 90, 86, 78, 89, 78, 81, 96, 80, 73, 
  61, 67, 89, 86, 96, 86, 97, 87, 81, 84, 
  83, 77, 78, 66, 83, 84, 82, 89, 81, 86, 
  88, 84, 86, 78, 87, 88, 87, 81, 81, 93, 
  73, 81, 86, 93, 86, 82, 84, 83, 90, 81, 
  90, 83, 86, 80, 79, 93, 90, 77, 82, 90, 
  92, 79, 99, 86, 83, 76, 85, 85, 80, 74, 
  78, 86, 96, 76, 93, 92, 80, 80, 94, 90, 
  81, 79, 74, 93, 84, 85, 73, 85, 63, 96, 
  62, 70, 84, 88, 75, 83, 98, 77, 56, 88, 
  73, 76, 72, 82, 69, 79, 78, 91, 80, 90, 
  95, 94, 79, 93, 88, 81, 85, 89, 73, 82, 
  84, 85, 79, 81, 81, 77, 82, 84, 116, 76, 
  90, 83, 77, 89, 83, 86, 75, 119, 96, 76, 
  72, 84, 81, 81, 85, 78, 81, 80, 82, 84, 
  88, 79, 82, 88, 92, 93, 82, 79, 88, 77, 
  82, 71, 77, 81, 80, 81, 80, 75, 83, 81, 
  74, 73, 90, 82, 89, 86, 84, 75, 88, 73, 
  79, 77, 83, 68, 85, 72, 84, 79, 80, 82, 
  84, 75, 78, 88, 81, 79, 82, 78, 90, 82, 
  71, 88, 87, 85, 82, 93, 115, 75, 78, 99, 
  77, 84, 84, 77, 76, 81, 73, 84, 84, 85, 
  84, 92, 88, 81, 88, 87, 86, 97, 81, 80, 
  68, 89, 81, 105, 75, 82, 94, 72, 93, 85, 
  80, 95, 87, 82, 76, 99, 75, 104, 90, 87, 
  83, 84, 78, 75, 86, 75, 139, 80, 85, 84, 
  82, 94, 84, 79, 76, 130, 77, 77, 67, 75, 
  87, 84, 80, 88, 76, 77, 82, 75, 89, 78, 
  83, 83, 97, 96, 78, 81, 91, 78, 84, 67, 
  74, 83, 74, 84, 83, 74, 81, 83, 73, 76, 
  94, 79, 90, 84, 78, 71, 82, 73, 79, 78, 
  90, 69, 80, 78, 91, 81, 78, 89, 82, 73, 
  81, 84, 79, 78, 81, 81, 86, 77, 76, 88, 
  87, 80, 82, 93, 133, 76, 80, 102, 76, 81, 
  115, 79, 74, 76, 76, 89, 79, 83, 83, 91, 
  101, 85, 88, 85, 89, 105, 88, 84, 75, 85, 
  77, 121, 76, 79, 99, 78, 92, 83, 84, 85, 
  88, 77, 86, 90, 73, 80, 86, 84, 82, 82, 
  81, 77, 83, 83, 112, 81, 87, 82, 83, 90, 
  90, 86, 79, 114, 93, 82, 69, 78, 83, 82, 
  84, 88, 79, 78, 79, 82, 84, 76, 86, 87, 
  95, 87, 78, 79, 91, 80, 76, 72, 78, 76, 
  79, 87, 84, 75, 81, 81, 73, 73, 89, 82, 
  92, 87, 84, 75, 90, 82, 84, 79, 82, 75, 
  84, 72, 83, 80, 76, 80, 85, 74, 75, 79, 
  79, 80, 76, 78, 89, 81, 71, 80, 91, 88, 
  72, 93, 109, 72, 86, 93, 78, 77, 82, 78, 
  75, 82, 75, 83, 84, 86, 81, 90, 93, 81, 
  85, 87, 82, 94, 80, 78, 80, 88, 79, 103, 
  77, 85, 93, 71, 91, 91, 77, 100, 89, 73, 
  83, 83, 72, 95, 92, 82, 75, 80, 79, 80, 
  85, 86, 127, 79, 92, 86, 85, 90, 84, 82, 
  73, 126, 79, 77, 70, 85, 88, 85, 75, 76, 
  85, 77, 82, 77, 86, 72, 81, 83, 86, 90, 
  82, 79, 88, 77, 78, 73, 76, 81, 75, 76, 
  83, 71, 86, 79, 74, 72, 88, 78, 94, 87, 
  84, 76, 89, 74, 83, 70, 78, 70, 87, 78, 
  83, 76, 87, 79, 81, 75, 78, 86, 84, 78, 
  80, 77, 85, 78, 67, 84, 80, 79, 87, 90, 
  119, 79, 83, 90, 87, 84, 101, 77, 71, 80, 
  74, 85, 87, 86, 79, 88, 86, 81, 86, 92, 
  89, 100, 85, 87, 79, 91, 85, 116, 72, 82, 
  93, 78, 99, 84, 83, 116, 94, 78, 72, 96, 
  78, 134, 101, 89, 81, 82, 79, 76, 90, 75, 
  172, 82, 88, 95, 81, 96, 89, 76, 76, 147, 
  59, 78, 68, 80, 100, 93, 72, 94, 91, 76, 
  85, 67, 82, 75, 79, 74, 88, 89, 77, 74, 
  88, 81, 76, 67, 75, 86, 74, 79, 93, 70, 
  84, 83, 76, 70, 93, 86, 86, 86, 78, 76, 
  86, 73, 74, 72, 85, 69, 82, 97, 97, 80, 
  78, 82, 78, 75, 92, 81, 88, 69, 80, 85, 
  81, 79, 78, 79, 76, 74, 101, 83, 150, 80, 
  79, 95, 88, 79, 152, 79, 71, 86, 78, 89, 
  91, 86, 76, 81, 105, 80, 87, 88, 84, 115, 
  93, 90, 86, 93, 84, 141, 76, 76, 105, 89, 
  86, 80, 91, 94, 89, 83, 84, 86, 73, 95, 
  94, 84, 79, 84, 79, 80, 85, 90, 126, 80, 
  90, 84, 80, 90, 91, 83, 76, 122, 78, 78, 
  73, 84, 91, 88, 82, 95, 81, 75, 78, 75, 
  84, 72, 89, 83, 88, 91, 81, 72, 89, 82, 
  71, 71, 78, 80, 74, 82, 85, 72, 79, 83, 
  77, 76, 89, 81, 94, 86, 85, 78, 89, 80, 
  82, 73, 77, 77, 83, 77, 83, 77, 79, 77, 
  81, 72, 79, 82, 83, 78, 81, 76, 84, 79, 
  69, 82, 81, 80, 75, 92, 113, 76, 86, 88, 
  88, 82, 94, 79, 71, 78, 76, 81, 86, 88, 
  79, 90, 92, 79, 83, 94, 77, 94, 84, 87, 
  84, 91, 81, 111, 76, 87, 95, 77, 88, 90, 
  81, 89, 85, 77, 90, 71, 76, 79, 89, 81, 
  81, 77, 78, 79, 87, 90, 107, 77, 83, 82, 
  80, 96, 90, 80, 75, 116, 98, 82, 75, 89, 
  81, 85, 77, 81, 84, 77, 87, 75, 86, 86, 
  81, 84, 89, 86, 86, 81, 82, 80, 83, 76, 
  82, 75, 75, 79, 82, 74, 89, 83, 76, 77, 
  85, 81, 91, 85, 78, 75, 88, 79, 82, 77, 
  71, 77, 89, 78, 76, 74, 88, 87, 80, 82, 
  73, 78, 88, 79, 77, 78, 85, 77, 67, 82, 
  87, 87, 84, 85, 110, 80, 89, 96, 81, 85, 
  74, 74, 72, 77, 73, 83, 73, 86, 82, 96, 
  81, 84, 83, 94, 82, 94, 85, 80, 82, 90, 
  81, 85, 75, 94, 82, 72, 89, 86, 91, 96, 
  93, 77, 83, 74, 80, 91, 85, 80, 78, 81, 
  88, 79, 88, 88, 115, 79, 85, 84, 80, 101, 
  93, 79, 76, 118, 78, 78, 68, 86, 84, 91, 
  76, 86, 83, 78, 88, 71, 84, 84, 82, 81, 
  86, 89, 86, 83, 87, 81, 81, 72, 82, 79, 
  71, 78, 87, 74, 88, 84, 73, 75, 87, 77, 
  94, 84, 78, 72, 94, 87, 80, 71, 73, 82, 
  93, 83, 80, 79, 85, 89, 80, 81, 74, 76, 
  87, 73, 83, 78, 84, 77, 69, 81, 86, 80, 
  91, 82, 116, 77, 90, 95, 86, 78, 92, 75, 
  72, 84, 75, 84, 74, 87, 84, 95, 88, 85, 
  83, 94, 79, 94, 83, 79, 84, 91, 81, 96, 
  79, 103, 86, 74, 86, 85, 88, 83, 86, 74, 
  92, 74, 76, 81, 90, 84, 80, 82, 80, 79, 
  85, 89, 107, 79, 84, 85, 80, 94, 89, 81, 
  74, 111, 94, 74, 81, 83, 80, 89, 82, 81, 
  83, 76, 79, 77, 86, 88, 82, 83, 91, 88, 
  83, 83, 81, 81, 81, 77, 79, 72, 75, 77, 
  85, 75, 87, 86, 79, 79, 87, 81, 91, 87, 
  79, 76, 90, 82, 81, 78, 74, 82, 86, 80, 
  78, 81, 83, 86, 81, 83, 71, 75, 89, 81, 
  82, 76, 86, 74, 65, 81, 88, 87, 80, 88, 
  110, 81, 90, 94, 83, 79, 72, 74, 73, 76, 
  75, 81, 73, 90, 87, 95, 83, 80, 85, 97, 
  74, 92, 85, 77, 85, 90, 77, 87, 79, 100, 
  86, 72, 89, 77, 78, 93, 66, 85, 95, 85, 
  69, 75, 88, 76, 69, 74, 89, 85, 77, 85, 
  84, 92, 82, 76, 81, 80, 76, 90, 90, 75, 
  90, 102, 88, 85, 84, 77, 80, 70, 72, 80, 
  73, 78, 76, 89, 83, 99, 76, 85, 84, 89, 
  93, 105, 71, 82, 90, 99, 84, 83, 71, 105, 
  73, 80, 85, 81, 72, 81, 89, 109, 100, 74, 
  82, 86, 81, 91, 80, 80, 88, 101, 95, 79, 
  71, 98, 108, 61, 77, 84, 92, 76, 81, 68, 
  100, 70, 91, 86, 79, 73, 92, 83, 85, 80, 
  78, 77, 94, 87, 79, 85, 87, 76, 80, 113, 
  75, 69, 86, 68, 75, 85, 85, 94, 95, 80, 
  87, 73, 56, 78, 71, 77, 113, 87, 74, 95, 
  85, 81, 76, 87, 63, 80, 98, 90, 72, 75, 
  93, 78, 72, 71, 90, 88, 82, 81, 88, 99, 
  80, 74, 82, 82, 80, 97, 90, 78, 81, 87, 
  85, 85, 85, 76, 85, 84, 74, 84, 74, 92, 
  78, 92, 85, 100, 81, 79, 83, 83, 91, 111, 
  65, 79, 93, 102, 89, 80, 75, 98, 76, 80, 
  78, 84, 67, 82, 82, 106, 95, 82, 77, 84, 
  79, 92, 85, 81, 91, 108, 96, 85, 77, 103, 
  106, 57, 75, 83, 102, 77, 84, 65, 103, 74, 
  92, 84, 82, 76, 87, 84, 91, 81, 83, 79, 
  99, 96, 86, 81, 89, 72, 81, 114, 82, 69, 
  85, 68, 79, 84, 88, 89, 85, 79, 88, 76, 
  60, 74, 74, 79, 123, 92, 73, 97, 89, 77, 
  77, 88, 68, 82, 94, 92, 66, 77, 86, 77, 
  72, 72, 91, 82, 78, 82, 82, 103, 81, 80, 
  87, 82, 75, 88, 96, 75, 82, 82, 87, 81, 
  86, 75, 94, 83, 72, 81, 78, 78, 79, 87, 
  89, 91, 79, 80, 80, 83, 91, 103, 72, 77, 
  92, 98, 82, 83, 70, 104, 77, 77, 85, 82, 
  71, 84, 92, 102, 96, 76, 81, 87, 79, 90, 
  82, 82, 86, 91, 91, 92, 79, 95, 106, 64, 
  80, 80, 92, 74, 82, 73, 96, 70, 91, 82, 
  80, 74, 81, 81, 84, 81, 87, 81, 93, 103, 
  79, 85, 86, 76, 82, 109, 81, 73, 83, 70, 
  76, 80, 84, 86, 84, 78, 87, 77, 65, 76, 
  69, 79, 107, 88, 77, 97, 96, 80, 75, 86, 
  75, 90, 95, 81, 77, 75, 91, 82, 79, 74, 
  87, 82, 74, 84, 80, 99, 75, 81, 76, 82, 
  80, 86, 84, 70, 77, 88, 84, 76, 84, 83, 
  87, 72, 73, 84, 77, 76, 81, 82, 85, 97, 
  81, 87, 75, 95, 95, 98, 69, 82, 97, 98, 
  88, 82, 78, 106, 73, 95, 94, 75, 76, 86, 
  88, 109, 84, 76, 89, 87, 84, 97, 75, 68, 
  85, 103, 91, 83, 67, 92, 106, 65, 79, 85, 
  92, 78, 80, 64, 85, 75, 87, 80, 81, 79, 
  97, 84, 79, 88, 73, 82, 95, 84, 79, 86, 
  84, 83, 82, 114, 80, 70, 83, 68, 76, 89, 
  86, 87, 96, 78, 85, 80, 59, 80, 81, 75, 
  122, 80, 77, 85, 95, 82, 79, 79, 71, 82, 
  101, 88, 83, 72, 97, 83, 78, 76, 93, 92, 
  78, 86, 78, 108, 81, 80, 78, 88, 82, 95, 
  81, 72, 71, 75, 81, 82, 80, 80, 89, 86, 
  76, 90, 73, 91, 86, 86, 84, 100, 84, 82, 
  74, 88, 100, 107, 66, 86, 100, 103, 97, 77, 
  82, 100, 77, 105, 89, 77, 72, 88, 81, 106, 
  84, 85, 85, 86, 81, 100, 79, 71, 90, 106, 
  93, 83, 68, 95, 103, 67, 75, 79, 101, 81, 
  86, 59, 88, 75, 87, 79, 82, 83, 95, 87, 
  86, 85, 76, 83, 92, 92, 83, 84, 89, 80, 
  81, 115, 82, 70, 84, 68, 82, 87, 85, 84, 
  80, 77, 85, 81, 60, 78, 84, 76, 130, 84, 
  74, 84, 96, 77, 82, 83, 81, 88, 93, 92, 
  76, 77, 87, 83, 75, 77, 89, 80, 78, 83, 
  76, 111, 84, 87, 83, 85, 79, 88, 90, 71, 
  72, 80, 83, 80, 81, 76, 93, 83, 75, 83, 
  74, 80, 81, 80, 83, 91, 80, 82, 74, 92, 
  94, 96, 70, 84, 100, 101, 87, 81, 75, 108, 
  74, 86, 94, 77, 76, 89, 89, 105, 86, 74, 
  86, 89, 82, 91, 80, 70, 87, 92, 89, 95, 
  74, 93, 107, 71, 82, 75, 92, 76, 84, 72, 
  85, 70, 85, 80, 80, 80, 83, 84, 80, 91, 
  80, 81, 91, 98, 79, 86, 86, 80, 79, 108, 
  81, 73, 80, 71, 79, 79, 86, 80, 82, 76, 
  86, 81, 66, 78, 82, 75, 117, 80, 79, 83, 
  96, 79, 83, 88, 64, 88, 87, 77, 71, 80, 
  85, 89, 79, 73, 87, 81, 72, 77, 86, 92, 
  74, 75, 79, 86, 76, 82, 81, 73, 84, 87, 
  83, 78, 92, 84, 94, 71, 78, 82, 87, 66, 
  78, 89, 90, 94, 84, 87, 72, 96, 86, 109, 
  71, 89, 95, 95, 87, 85, 75, 96, 80, 89, 
  99, 76, 77, 84, 88, 105, 80, 74, 89, 91, 
  85, 100, 75, 73, 78, 100, 90, 87, 78, 93, 
  107, 70, 77, 78, 86, 79, 79, 72, 88, 79, 
  88, 83, 85, 73, 95, 85, 78, 90, 75, 77, 
  104, 81, 76, 87, 85, 83, 81, 105, 77, 76, 
  87, 72, 74, 86, 80, 85, 83, 77, 80, 85, 
  68, 74, 71, 77, 110, 80, 77, 90, 95, 81, 
  90, 84, 65, 85, 92, 82, 74, 75, 89, 89, 
  78, 78, 86, 89, 74, 75, 86, 102, 84, 75, 
  83, 87, 76, 89, 80, 74, 79, 79, 87, 82, 
  87, 86, 84, 81, 80, 87, 78, 80, 76, 98, 
  87, 99, 87, 83, 73, 93, 89, 109, 70, 93, 
  95, 98, 93, 82, 82, 91, 81, 88, 97, 77, 
  77, 85, 86, 109, 79, 75, 86, 93, 81, 100, 
  81, 77, 80, 95, 89, 88, 77, 99, 104, 73, 
  73, 78, 92, 84, 82, 65, 94, 80, 86, 84, 
  83, 74, 94, 88, 81, 87, 78, 78, 101, 81, 
  81, 86, 85, 78, 76, 107, 76, 74, 90, 71, 
  79, 84, 81, 80, 80, 77, 82, 84, 69, 75, 
  70, 77, 118, 79, 78, 84, 95, 79, 89, 88, 
  70, 86, 87, 85, 70, 79, 82, 85, 75, 79, 
  83, 74, 71, 79, 84, 104, 85, 75, 83, 89, 
  72, 86, 86, 73, 82, 86, 89, 81, 89, 77, 
  94, 79, 82, 81, 74, 70, 75, 89, 80, 91, 
  83, 83, 76, 90, 88, 106, 72, 86, 96, 94, 
  82, 86, 76, 98, 77, 82, 100, 78, 77, 86, 
  87, 105, 81, 73, 85, 94, 85, 96, 82, 73, 
  80, 94, 89, 89, 82, 94, 108, 74, 78, 79, 
  86, 80, 85, 79, 91, 76, 90, 82, 84, 73, 
  83, 86, 80, 91, 78, 75, 97, 87, 75, 87, 
  86, 81, 78, 102, 79, 76, 85, 74, 78, 77, 
  81, 84, 84, 77, 81, 86, 74, 77, 73, 77, 
  110, 80, 76, 87, 77, 76, 84, 67, 64, 80, 
  78, 96, 76, 88, 92, 75, 84, 95, 63, 80, 
  84, 94, 77, 91, 92, 86, 97, 87, 74, 81, 
  83, 92, 94, 76, 93, 74, 84, 83, 78, 95, 
  88, 79, 80, 68, 88, 72, 82, 77, 96, 75, 
  63, 86, 86, 86, 82, 94, 78, 79, 89, 88, 
  83, 82, 85, 89, 68, 78, 84, 87, 63, 83, 
  91, 86, 80, 99, 87, 73, 92, 89, 74, 84, 
  73, 77, 72, 77, 85, 84, 78, 83, 75, 90, 
  86, 89, 69, 91, 91, 90, 76, 92, 104, 86, 
  84, 74, 87, 104, 89, 79, 83, 80, 74, 71, 
  77, 80, 77, 82, 94, 95, 95, 78, 77, 77, 
  89, 74, 79, 91, 87, 82, 80, 95, 82, 90, 
  94, 83, 83, 81, 87, 67, 62, 89, 75, 96, 
  79, 87, 90, 71, 84, 88, 65, 72, 92, 97, 
  83, 84, 85, 72, 92, 87, 92, 75, 84, 97, 
  104, 79, 98, 81, 84, 80, 83, 83, 96, 83, 
  89, 68, 90, 78, 87, 76, 94, 78, 73, 86, 
  79, 85, 82, 97, 78, 83, 98, 86, 77, 78, 
  74, 87, 70, 71, 77, 79, 57, 80, 87, 78, 
  72, 102, 88, 72, 78, 88, 78, 75, 77, 86, 
  67, 77, 92, 83, 80, 84, 76, 92, 84, 93, 
  76, 87, 75, 106, 71, 88, 103, 79, 98, 75, 
  82, 103, 91, 77, 79, 77, 75, 65, 83, 70, 
  84, 83, 94, 97, 97, 82, 80, 78, 90, 73, 
  84, 89, 80, 81, 80, 87, 74, 91, 100, 82, 
  76, 80, 86, 64, 68, 97, 76, 96, 76, 90, 
  88, 78, 82, 77, 64, 84, 87, 83, 72, 87, 
  89, 86, 81, 87, 82, 82, 82, 90, 80, 76, 
  93, 89, 81, 93, 77, 83, 93, 77, 90, 70, 
  91, 73, 88, 76, 95, 83, 69, 80, 84, 84, 
  74, 89, 75, 83, 87, 78, 81, 84, 85, 88, 
  75, 85, 81, 84, 71, 88, 85, 90, 78, 85, 
  85, 74, 94, 87, 75, 86, 79, 87, 70, 82, 
  87, 83, 88, 89, 74, 85, 82, 86, 77, 94, 
  88, 103, 78, 96, 109, 90, 76, 77, 73, 105, 
  85, 72, 85, 78, 76, 73, 74, 82, 78, 83, 
  100, 93, 95, 89, 83, 85, 85, 77, 81, 95, 
  78, 84, 77, 93, 78, 89, 91, 82, 100, 85, 
  88, 76, 78, 78, 85, 89, 72, 86, 92, 73, 
  89, 104, 69, 72, 92, 100, 89, 92, 74, 82, 
  113, 84, 88, 84, 81, 91, 107, 87, 88, 90, 
  79, 83, 77, 98, 103, 84, 77, 73, 91, 73, 
  75, 77, 69, 83, 98, 85, 88, 81, 84, 89, 
  75, 84, 85, 83, 73, 82, 76, 89, 78, 75, 
  99, 77, 67, 67, 92, 84, 101, 101, 77, 75, 
  80, 84, 82, 75, 78, 87, 80, 80, 89, 85, 
  75, 85, 79, 98, 91, 89, 73, 73, 72, 83, 
  81, 90, 86, 66, 92, 75, 104, 85, 87, 87, 
  85, 77, 86, 59, 88, 86, 84, 79, 72, 80, 
  90, 88, 84, 81, 103, 81, 92, 80, 84, 68, 
  93, 87, 87, 81, 92, 75, 110, 91, 85, 81, 
  84, 81, 87, 90, 70, 79, 91, 62, 94, 94, 
  72, 65, 98, 99, 97, 87, 77, 70, 85, 86, 
  106, 79, 78, 88, 119, 89, 89, 117, 84, 84, 
  80, 88, 106, 93, 85, 80, 88, 69, 71, 82, 
  62, 85, 123, 85, 83, 79, 89, 95, 74, 94, 
  75, 77, 60, 78, 59, 92, 86, 72, 96, 78, 
  63, 63, 97, 90, 103, 82, 85, 68, 67, 75, 
  105, 64, 85, 90, 75, 78, 98, 85, 75, 84, 
  87, 101, 94, 87, 80, 67, 66, 87, 74, 94, 
  73, 65, 96, 77, 100, 82, 75, 95, 83, 77, 
  97, 46, 101, 78, 88, 76, 76, 76, 88, 91, 
  78, 73, 88, 80, 99, 69, 79, 61, 89, 82, 
  78, 81, 102, 71, 90, 90, 79, 72, 82, 110, 
  83, 91, 74, 87, 90, 79, 86, 73, 66, 75, 
  96, 93, 87, 89, 87, 82, 73, 86, 88, 82, 
  83, 91, 95, 76, 87, 104, 79, 90, 77, 82, 
  105, 82, 85, 76, 94, 75, 73, 79, 76, 90, 
  93, 85, 87, 80, 76, 87, 75, 87, 89, 84, 
  74, 81, 73, 83, 77, 73, 98, 77, 71, 74, 
  84, 85, 89, 83, 95, 72, 86, 87, 94, 81, 
  81, 94, 75, 82, 91, 83, 83, 84, 80, 91, 
  92, 86, 82, 75, 79, 104, 81, 89, 103, 71, 
  89, 80, 75, 88, 90, 88, 84, 76, 82, 69, 
  85, 86, 83, 84, 83, 81, 91, 95, 88, 85, 
  79, 81, 88, 80, 79, 70, 85, 87, 85, 81, 
  92, 74, 83, 84, 92, 82, 91, 84, 85, 97, 
  64, 85, 91, 70, 77, 85, 78, 75, 96, 83, 
  77, 86, 71, 83, 80, 79, 102, 85, 82, 83, 
  86, 77, 80, 94, 84, 96, 97, 97, 80, 82, 
  80, 81, 99, 71, 87, 82, 68, 82, 107, 76, 
  89, 78, 86, 81, 73, 92, 80, 78, 69, 86, 
  88, 82, 80, 84, 89, 78, 88, 78, 97, 91, 
  110, 76, 75, 79, 87, 86, 71, 83, 83, 101, 
  89, 88, 89, 84, 86, 90, 83, 92, 83, 88, 
  78, 74, 77, 81, 97, 90, 69, 82, 80, 84, 
  92, 91, 80, 89, 85, 80, 88, 83, 86, 96, 
  75, 77, 70, 83, 84, 92, 79, 83, 86, 87, 
  87, 90, 79, 72, 89, 82, 96, 78, 83, 75, 
  82, 86, 77, 87, 95, 74, 87, 95, 53, 72, 
  82, 62, 79, 88, 83, 69, 96, 82, 78, 84, 
  81, 75, 77, 78, 104, 80, 74, 74, 95, 90, 
  82, 106, 88, 96, 85, 85, 88, 89, 86, 79, 
  102, 70, 75, 93, 64, 77, 114, 87, 87, 70, 
  89, 74, 67, 98, 57, 72, 56, 82, 82, 83, 
  84, 81, 90, 84, 75, 80, 100, 95, 117, 61, 
  74, 64, 80, 79, 84, 70, 83, 93, 88, 84, 
  91, 83, 82, 83, 90, 102, 88, 85, 72, 65, 
  75, 84, 97, 85, 58, 81, 76, 85, 110, 96, 
  76, 76, 81, 79, 94, 85, 99, 95, 67, 74, 
  71, 80, 78, 84, 78, 76, 77, 89, 95, 86, 
  80, 61, 79, 83, 90, 77, 85, 73, 84, 90, 
  69, 84, 86, 88, 84, 92, 65, 83, 92, 78, 
  80, 77, 75, 71, 100, 78, 78, 90, 92, 76, 
  82, 82, 82, 83, 81, 80, 80, 96, 80, 97, 
  86, 85, 84, 88, 81, 82, 81, 80, 100, 74, 
  70, 85, 71, 84, 91, 108, 86, 80, 84, 80, 
  72, 92, 83, 83, 69, 85, 88, 76, 80, 73, 
  92, 78, 82, 82, 89, 92, 109, 76, 82, 73, 
  90, 85, 86, 84, 81, 87, 82, 87, 87, 87, 
  83, 81, 77, 94, 94, 89, 81, 74, 83, 85, 
  97, 91, 75, 88, 80, 85, 102, 88, 84, 80, 
  81, 77, 84, 88, 87, 92, 72, 80, 74, 77, 
  82, 86, 86, 86, 82, 82, 83, 89, 92, 71, 
  90, 79, 92, 80, 85, 78, 82, 78, 100, 87, 
  84, 72, 80, 78, 82, 90, 104, 83, 84, 97, 
  73, 82, 76, 86, 77, 84, 70, 88, 82, 83, 
  75, 75, 90, 74, 90, 75, 94, 89, 91, 88, 
  85, 85, 73, 83, 80, 79, 75, 80, 67, 87, 
  91, 79, 74, 76, 70, 90, 84, 103, 86, 72, 
  84, 71, 73, 69, 98, 79, 89, 81, 73, 83, 
  89, 116, 86, 83, 102, 86, 81, 78, 87, 80, 
  93, 86, 99, 99, 86, 82, 88, 83, 85, 91, 
  92, 87, 90, 85, 80, 81, 87, 85, 75, 80, 
  84, 107, 72, 64, 97, 87, 77, 84, 82, 95, 
  78, 85, 71, 89, 72, 90, 86, 80, 81, 79, 
  87, 119, 83, 84, 77, 78, 73, 107, 82, 77, 
  79, 89, 99, 86, 79, 81, 87, 87, 86, 78, 
  80, 75, 89, 98, 110, 77, 79, 91, 77, 82, 
  74, 96, 82, 78, 70, 77, 82, 74, 74, 69, 
  88, 79, 84, 75, 88, 97, 90, 75, 80, 77, 
  77, 76, 100, 71, 78, 84, 70, 83, 98, 73, 
  61, 77, 69, 88, 96, 88, 86, 72, 85, 85, 
  63, 75, 97, 72, 90, 89, 75, 74, 81, 138, 
  89, 72, 87, 72, 84, 77, 86, 75, 80, 86, 
  109, 80, 92, 84, 86, 84, 72, 82, 84, 79, 
  77, 78, 80, 82, 86, 93, 79, 80, 79, 118, 
  77, 68, 92, 85, 80, 104, 93, 95, 76, 84, 
  73, 87, 77, 88, 80, 78, 76, 82, 87, 123, 
  74, 86, 73, 81, 79, 111, 75, 77, 78, 82, 
  102, 86, 83, 84, 86, 88, 90, 84, 82, 83, 
  83, 85, 101, 78, 87, 75, 76, 82, 74, 86, 
  77, 87, 68, 78, 75, 83, 87, 77, 89, 76, 
  86, 90, 87, 92, 91, 91, 81, 91, 77, 88, 
  99, 80, 77, 78, 75, 91, 91, 83, 79, 98, 
  76, 86, 84, 90, 87, 73, 86, 83, 74, 75, 
  94, 81, 87, 75, 74, 83, 86, 107, 79, 83, 
  96, 84, 99, 83, 85, 83, 95, 86, 90, 76, 
  87, 76, 95, 82, 79, 89, 88, 85, 75, 81, 
  81, 83, 86, 89, 80, 82, 84, 100, 76, 69, 
  92, 85, 78, 100, 79, 99, 78, 88, 70, 89, 
  76, 91, 82, 79, 86, 92, 78, 101, 81, 83, 
  76, 76, 80, 100, 87, 84, 85, 88, 96, 80, 
  75, 83, 84, 93, 82, 67, 77, 72, 82, 89, 
  103, 81, 87, 93, 81, 81, 83, 82, 72, 83, 
  76, 81, 76, 78, 81, 80, 77, 75, 93, 77, 
  85, 85, 93, 89, 88, 90, 68, 78, 94, 87, 
  86, 76, 69, 86, 77, 76, 69, 78, 76, 89, 
  82, 91, 84, 76, 81, 80, 80, 73, 96, 70, 
  78, 95, 74, 84, 75, 131, 79, 74, 106, 73, 
  94, 65, 86, 85, 95, 89, 96, 92, 98, 89, 
  86, 88, 80, 84, 86, 81, 87, 86, 71, 76, 
  85, 80, 83, 86, 80, 123, 77, 73, 98, 74, 
  75, 83, 78, 92, 76, 78, 73, 86, 65, 87, 
  77, 76, 80, 82, 70, 112, 80, 84, 67, 85, 
  73, 114, 81, 80, 71, 82, 102, 78, 78, 81, 
  81, 105, 83, 75, 69, 71, 99, 109, 105, 73, 
  66, 91, 100, 81, 96, 88, 75, 75, 72, 69, 
  81, 67, 88, 69, 83, 82, 87, 87, 60, 105, 
  97, 70, 84, 81, 65, 84, 93, 73, 76, 72, 
  67, 77, 79, 77, 58, 73, 75, 85, 83, 65, 
  89, 81, 75, 70, 77, 80, 81, 60, 76, 124, 
  80, 76, 70, 139, 72, 52, 115, 71, 76, 61, 
  110, 77, 85, 96, 129, 82, 93, 106, 81, 87, 
  69, 83, 68, 70, 79, 74, 65, 82, 85, 79, 
  76, 99, 89, 132, 87, 86, 86, 63, 75, 86, 
  98, 91, 82, 85, 68, 77, 67, 80, 70, 73, 
  76, 83, 69, 101, 87, 85, 49, 88, 80, 116, 
  75, 83, 69, 74, 113, 65, 79, 81, 90, 87, 
  86, 77, 76, 76, 77, 85, 101, 83, 90, 91, 
  79, 82, 84, 83, 72, 81, 71, 88, 68, 75, 
  93, 79, 81, 77, 92, 93, 93, 96, 94, 101, 
  83, 89, 74, 82, 95, 86, 90, 76, 79, 87, 
  78, 73, 74, 96, 77, 88, 81, 94, 84, 72, 
  84, 72, 78, 78, 97, 75, 83, 88, 81, 88, 
  74, 121, 78, 80, 103, 78, 84, 69, 82, 85, 
  92, 86, 83, 79, 92, 82, 91, 88, 77, 87, 
  89, 85, 82, 86, 75, 80, 79, 85, 87, 82, 
  80, 113, 77, 76, 88, 73, 79, 81, 79, 96, 
  75, 82, 72, 87, 68, 88, 88, 78, 81, 87, 
  79, 95, 90, 88, 73, 82, 80, 109, 81, 82, 
  80, 82, 96, 75, 83, 85, 77, 88, 87, 86, 
  80, 75, 73, 88, 92, 82, 87, 89, 74, 76, 
  85, 87, 79, 90, 79, 77, 79, 78, 86, 75, 
  90, 85, 88, 75, 86, 87, 97, 89, 95, 90, 
  78, 74, 88, 89, 99, 75, 93, 86, 79, 77, 
  80, 78, 77, 87, 86, 93, 78, 79, 87, 81, 
  88, 77, 79, 82, 78, 78, 87, 74, 91, 91, 
  76, 92, 101, 89, 99, 85, 83, 89, 89, 94, 
  89, 88, 99, 82, 88, 93, 88, 92, 85, 84, 
  94, 81, 73, 84, 84, 78, 84, 89, 79, 116, 
  80, 88, 88, 81, 83, 92, 78, 96, 85, 78, 
  76, 85, 80, 84, 74, 82, 78, 79, 79, 101, 
  75, 92, 84, 89, 82, 105, 82, 74, 74, 90, 
  100, 86, 78, 77, 84, 81, 86, 86, 80, 74, 
  81, 92, 94, 74, 72, 96, 83, 71, 92, 86, 
  80, 82, 78, 63, 85, 77, 90, 74, 87, 85, 
  83, 86, 89, 89, 95, 77, 91, 74, 79, 67, 
  92, 84, 96, 86, 80, 77, 67, 70, 77, 73, 
  82, 84, 84, 88, 84, 79, 81, 86, 80, 83, 
  87, 73, 76, 75, 91, 57, 86, 95, 71, 73, 
  109, 84, 85, 89, 92, 82, 90, 93, 95, 81, 
  103, 90, 84, 92, 76, 89, 86, 81, 87, 84, 
  77, 78, 82, 77, 93, 94, 77, 120, 86, 92, 
  95, 67, 80, 83, 79, 96, 79, 80, 70, 80, 
  74, 79, 78, 75, 77, 83, 85, 97, 82, 93, 
  75, 93, 87, 108, 76, 74, 75, 88, 105, 78, 
  81, 78, 85, 82, 91, 86, 76, 77, 75, 88, 
  86, 87, 82, 90, 79, 74, 84, 88, 75, 88, 
  87, 82, 87, 77, 90, 71, 89, 82, 80, 88, 
  94, 88, 94, 97, 80, 80, 82, 74, 79, 89, 
  101, 77, 79, 88, 79, 79, 81, 94, 76, 88, 
  84, 96, 80, 77, 86, 70, 85, 76, 82, 84, 
  81, 75, 88, 74, 95, 86, 82, 92, 99, 88, 
  72, 83, 84, 85, 93, 89, 88, 80, 93, 84, 
  91, 89, 83, 89, 85, 89, 86, 82, 77, 83, 
  82, 79, 85, 89, 80, 113, 80, 88, 90, 79, 
  86, 86, 83, 98, 79, 80, 78, 82, 78, 81, 
  95, 81, 81, 91, 83, 90, 98, 94, 84, 87, 
  92, 96, 79, 78, 78, 88, 99, 83, 69, 87, 
  76, 97, 104, 94, 86, 80, 93, 82, 95, 76, 
  82, 81, 84, 91, 75, 67, 86, 86, 82, 83, 
  73, 93, 85, 82, 103, 84, 86, 88, 90, 71, 
  77, 97, 127, 84, 93, 101, 88, 74, 118, 84, 
  81, 96, 85, 84, 87, 91, 80, 74, 71, 71, 
  88, 87, 93, 94, 59, 78, 73, 73, 90, 75, 
  62, 86, 86, 85, 59, 74, 84, 89, 103, 81, 
  87, 97, 84, 65, 77, 89, 92, 73, 85, 89, 
  81, 77, 104, 94, 87, 91, 90, 72, 87, 84, 
  91, 81, 86, 107, 76, 87, 89, 76, 83, 79, 
  85, 92, 87, 86, 90, 87, 91, 77, 91, 106, 
  92, 88, 81, 84, 69, 88, 92, 78, 82, 74, 
  83, 73, 82, 90, 98, 79, 72, 84, 103, 94, 
  99, 92, 79, 74, 87, 92, 92, 75, 73, 71, 
  83, 75, 76, 68, 83, 92, 77, 80, 95, 92, 
  83, 76, 96, 86, 96, 109, 95, 71, 76, 79, 
  89, 83, 91, 105, 92, 68, 138, 81, 75, 88, 
  94, 90, 85, 101, 86, 72, 77, 82, 81, 89, 
  91, 72, 53, 72, 63, 73, 90, 74, 58, 83, 
  76, 83, 69, 86, 82, 84, 90, 92, 79, 103, 
  84, 65, 81, 82, 82, 76, 82, 90, 72, 85, 
  90, 99, 81, 97, 82, 72, 81, 75, 87, 77, 
  84, 105, 80, 88, 92, 73, 76, 77, 87, 93, 
  87, 88, 88, 85, 85, 72, 106, 103, 84, 83, 
  94, 94, 96, 84, 91, 73, 73, 72, 73, 73, 
  81, 87, 105, 79, 82, 73, 99, 84, 81, 83, 
  78, 96, 86, 91, 90, 83, 77, 76, 73, 74, 
  82, 71, 84, 89, 58, 71, 91, 81, 80, 82, 
  84, 80, 82, 89, 78, 81, 85, 81, 82, 92, 
  81, 83, 83, 83, 112, 77, 80, 82, 84, 96, 
  93, 80, 93, 82, 77, 73, 90, 96, 89, 95, 
  79, 72, 69, 82, 92, 78, 77, 69, 76, 82, 
  81, 81, 84, 76, 94, 87, 82, 97, 82, 80, 
  77, 73, 80, 95, 86, 91, 70, 82, 79, 90, 
  92, 81, 96, 84, 81, 73, 80, 75, 91, 88, 
  74, 84, 102, 75, 65, 78, 87, 86, 83, 92, 
  86, 81, 91, 88, 86, 81, 92, 89, 78, 85, 
  99, 83, 79, 80, 78, 78, 92, 90, 92, 91, 
  88, 89, 71, 71, 69, 94, 84, 66, 87, 84, 
  74, 100, 96, 82, 74, 76, 77, 66, 73, 76, 
  85, 87, 75, 78, 80, 97, 82, 83, 126, 84, 
  106, 90, 70, 68, 102, 79, 145, 89, 96, 98, 
  83, 67, 151, 74, 89, 75, 103, 98, 80, 87, 
  96, 100, 62, 59, 86, 94, 110, 84, 58, 66, 
  61, 71, 95, 93, 82, 95, 71, 80, 69, 101, 
  69, 90, 84, 77, 103, 104, 78, 70, 71, 80, 
  93, 67, 80, 81, 79, 87, 83, 87, 82, 94, 
  73, 87, 103, 86, 77, 87, 104, 88, 70, 77, 
  73, 82, 73, 76, 90, 85, 85, 83, 74, 87, 
  92, 62, 95, 111, 90, 79, 77, 91, 67, 74, 
  74, 64, 65, 63, 88, 74, 77, 78, 89, 98, 
  71, 77, 80, 90, 76, 70, 83, 81, 65, 101, 
  90, 79, 68, 78, 76, 63, 70, 82, 86, 88, 
  72, 68, 92, 92, 70, 83, 112, 85, 104, 135, 
  73, 70, 109, 61, 90, 86, 83, 94, 92, 56, 
  131, 73, 76, 71, 101, 94, 76, 104, 104, 97, 
  60, 58, 85, 96, 101, 66, 72, 62, 59, 76, 
  97, 93, 90, 86, 57, 81, 76, 95, 63, 88, 
  61, 82, 99, 99, 75, 80, 72, 67, 74, 69, 
  75, 84, 76, 98, 72, 90, 76, 92, 68, 84, 
  109, 66, 68, 84, 88, 83, 75, 77, 87, 80, 
  73, 61, 86, 84, 82, 81, 70, 89, 86, 66, 
  99, 100, 89, 69, 78, 91, 99, 72, 72, 71, 
  83, 70, 81, 72, 74, 81, 90, 108, 80, 89, 
  80, 78, 83, 83, 86, 95, 88, 92, 93, 86, 
  89, 77, 78, 73, 79, 89, 87, 79, 68, 86, 
  71, 80, 80, 90, 83, 79, 92, 73, 75, 80, 
  93, 73, 81, 88, 72, 74, 81, 93, 92, 71, 
  85, 85, 90, 88, 81, 76, 88, 93, 74, 84, 
  90, 96, 95, 93, 90, 70, 77, 88, 88, 80, 
  90, 71, 75, 94, 86, 84, 80, 78, 83, 84, 
  85, 94, 84, 85, 73, 76, 63, 97, 86, 90, 
  79, 81, 87, 84, 91, 78, 89, 92, 94, 75, 
  68, 82, 84, 83, 69, 80, 99, 80, 73, 71, 
  82, 78, 82, 86, 90, 87, 75, 91, 77, 85, 
  88, 80, 70, 82, 86, 79, 80, 74, 92, 83, 
  96, 90, 94, 84, 83, 92, 82, 72, 81, 87, 
  87, 82, 73, 88, 99, 91, 89, 85, 106, 71, 
  77, 76, 83, 87, 75, 84, 70, 90, 82, 88, 
  91, 91, 84, 76, 84, 81, 74, 89, 103, 75, 
  77, 89, 102, 75, 73, 88, 92, 71, 74, 86, 
  82, 96, 86, 87, 87, 110, 61, 84, 86, 101, 
  90, 82, 90, 78, 90, 80, 80, 78, 94, 92, 
  84, 91, 77, 86, 83, 80, 84, 68, 97, 82, 
  73, 82, 71, 74, 81, 86, 83, 82, 82, 79, 
  85, 86, 85, 71, 85, 119, 87, 79, 71, 89, 
  109, 78, 56, 80, 89, 80, 83, 77, 82, 75, 
  69, 90, 75, 77, 68, 97, 67, 83, 88, 80, 
  93, 82, 81, 78, 73, 67, 77, 86, 93, 78, 
  95, 85, 80, 93, 79, 85, 82, 84, 85, 74, 
  73, 91, 97, 89, 89, 82, 105, 78, 79, 70, 
  77, 93, 78, 80, 75, 87, 76, 88, 88, 93, 
  84, 79, 86, 80, 79, 86, 108, 66, 62, 83, 
  84, 74, 84, 81, 75, 65, 72, 87, 79, 91, 
  83, 71, 86, 110, 71, 90, 87, 101, 85, 75, 
  96, 82, 92, 83, 82, 72, 89, 86, 81, 94, 
  84, 78, 79, 81, 74, 73, 88, 85, 70, 82, 
  73, 79, 65, 86, 81, 84, 89, 86, 87, 90, 
  73, 70, 94, 118, 84, 77, 73, 86, 88, 82, 
  69, 79, 100, 76, 80, 70, 83, 76, 69, 89, 
  75, 79, 69, 98, 62, 80, 88, 80, 96, 82, 
  78, 79, 80, 75, 99, 90, 94, 82, 96, 91, 
  73, 95, 83, 101, 89, 80, 83, 99, 82, 93, 
  104, 91, 85, 81, 105, 85, 94, 77, 85, 91, 
  72, 86, 75, 92, 76, 82, 84, 78, 79, 74, 
  72, 67, 81, 81, 93, 81, 84, 103, 83, 82, 
  81, 87, 90, 75, 90, 94, 88, 82, 83, 71, 
  88, 96, 84, 103, 85, 89, 81, 79, 93, 84, 
  92, 83, 81, 76, 83, 85, 88, 97, 78, 82, 
  87, 87, 86, 88, 78, 86, 78, 75, 86, 94, 
  62, 99, 88, 87, 73, 71, 95, 91, 83, 76, 
  90, 98, 72, 88, 84, 84, 86, 94, 68, 86, 
  98, 68, 83, 76, 84, 77, 76, 86, 85, 77, 
  75, 98, 64, 92, 83, 85, 86, 85, 80, 81, 
  89, 75, 91, 91, 78, 83, 90, 96, 78, 84, 
  101, 76, 66, 92, 95, 94, 85, 80, 89, 67, 
  101, 83, 85, 84, 90, 96, 84, 88, 86, 73, 
  85, 92, 99, 80, 84, 83, 77, 77, 84, 93, 
  97, 86, 103, 84, 110, 77, 69, 82, 86, 73, 
  87, 93, 82, 100, 88, 74, 105, 94, 69, 87, 
  92, 92, 93, 91, 93, 91, 83, 97, 78, 89, 
  80, 84, 78, 70, 83, 90, 86, 80, 90, 79, 
  86, 74, 71, 94, 84, 63, 86, 100, 84, 66, 
  96, 90, 80, 85, 102, 75, 85, 89, 100, 89, 
  72, 84, 80, 85, 79, 93, 97, 99, 88, 71, 
  82, 89, 82, 83, 85, 85, 96, 92, 82, 89, 
  77, 86, 84, 88, 82, 85, 74, 82, 75, 82, 
  92, 89, 71, 87, 92, 73, 85, 105, 89, 89, 
  74, 86, 96, 95, 86, 75, 84, 76, 100, 87, 
  78, 78, 96, 102, 82, 85, 91, 85, 77, 79, 
  83, 81, 88, 89, 72, 81, 81, 86, 95, 83, 
  109, 77, 95, 75, 67, 73, 87, 66, 80, 95, 
  85, 101, 90, 74, 112, 90, 66, 92, 92, 94, 
  87, 95, 90, 92, 82, 100, 74, 94, 78, 83, 
  81, 72, 80, 89, 87, 87, 80, 70, 74, 76, 
  67, 95, 85, 66, 78, 83, 81, 71, 97, 94, 
  82, 84, 100, 76, 84, 86, 111, 90, 72, 79, 
  74, 84, 70, 92, 92, 108, 83, 71, 82, 87, 
  81, 83, 85, 80, 96, 95, 89, 90, 78, 89, 
  87, 82, 75, 93, 70, 80, 76, 82, 93, 83, 
  81, 87, 91, 74, 90, 111, 99, 85, 101, 85, 
  97, 107, 81, 75, 87, 75, 90, 85, 82, 75, 
  76, 105, 85, 78, 87, 86, 72, 94, 81, 87, 
  89, 82, 87, 73, 74, 101, 94, 85, 84, 77, 
  95, 79, 82, 82, 86, 68, 88, 84, 91, 89, 
  88, 78, 102, 88, 73, 80, 85, 80, 92, 84, 
  93, 95, 83, 92, 75, 98, 81, 87, 77, 78, 
  83, 84, 86, 78, 91, 78, 78, 88, 72, 91, 
  84, 66, 90, 83, 83, 64, 92, 92, 94, 96, 
  88, 88, 88, 82, 90, 86, 66, 80, 93, 87, 
  84, 83, 97, 84, 85, 73, 83, 76, 81, 85, 
  86, 87, 89, 90, 83, 85, 92, 89, 82, 86, 
  82, 87, 87, 87, 77, 83, 89, 84, 75, 84, 
  85, 79, 89, 93, 75, 76, 86, 100, 76, 74, 
  73, 69, 92, 81, 73, 77, 69, 90, 67, 120, 
  74, 72, 79, 77, 94, 71, 80, 98, 72, 62, 
  130, 80, 110, 78, 74, 88, 69, 70, 96, 74, 
  81, 85, 81, 69, 94, 81, 73, 69, 69, 94, 
  96, 86, 109, 80, 87, 84, 96, 82, 83, 99, 
  85, 75, 84, 93, 93, 87, 72, 86, 78, 73, 
  103, 98, 89, 80, 80, 86, 96, 97, 64, 79, 
  97, 62, 97, 60, 89, 93, 91, 77, 78, 99, 
  83, 78, 93, 80, 57, 100, 84, 74, 79, 77, 
  89, 70, 84, 96, 72, 104, 74, 84, 87, 77, 
  65, 75, 64, 66, 92, 59, 68, 84, 99, 99, 
  54, 85, 71, 77, 91, 79, 85, 70, 78, 85, 
  68, 83, 74, 72, 88, 96, 69, 65, 69, 75, 
  81, 89, 70, 82, 60, 105, 74, 100, 74, 65, 
  74, 78, 76, 64, 82, 100, 72, 65, 138, 82, 
  108, 86, 68, 89, 63, 70, 74, 72, 74, 87, 
  77, 67, 87, 75, 76, 64, 65, 85, 94, 78, 
  98, 83, 86, 84, 91, 73, 74, 94, 76, 67, 
  86, 89, 97, 72, 69, 77, 75, 76, 118, 87, 
  78, 81, 71, 92, 84, 101, 65, 74, 98, 70, 
  91, 68, 88, 99, 93, 86, 65, 106, 82, 75, 
  87, 80, 57, 92, 78, 77, 69, 76, 83, 80, 
  86, 90, 70, 85, 73, 84, 77, 78, 64, 71, 
  64, 63, 97, 56, 66, 85, 113, 107, 84, 87, 
  63, 73, 85, 79, 75, 68, 77, 90, 55, 87, 
  74, 66, 72, 84, 72, 84, 69, 75, 83, 90, 
  76, 70, 67, 95, 61, 99, 73, 76, 84, 84, 
  75, 65, 88, 95, 81, 63, 122, 78, 108, 106, 
  70, 90, 59, 66, 88, 81, 100, 89, 86, 63, 
  91, 83, 82, 66, 73, 87, 85, 77, 109, 75, 
  78, 87, 95, 72, 89, 83, 86, 69, 87, 86, 
  94, 87, 70, 76, 64, 77, 109, 86, 89, 91, 
  69, 90, 105, 95, 72, 87, 101, 88, 97, 62, 
  85, 85, 82, 92, 65, 97, 85, 83, 78, 84, 
  68, 91, 89, 77, 87, 73, 93, 70, 98, 88, 
  75, 70, 78, 88, 85, 81, 70, 76, 72, 69, 
  93, 64, 76, 86, 103, 100, 106, 96, 72, 75, 
  81, 77, 72, 77, 77, 84, 69, 82, 76, 102, 
  77, 67, 85, 80, 73, 74, 80, 83, 66, 103, 
  81, 102, 57, 63, 78, 72, 95, 88, 91, 74, 
  93, 76, 72, 95, 104, 79, 93, 87, 79, 84, 
  65, 79, 79, 94, 74, 80, 92, 75, 82, 76, 
  85, 79, 105, 92, 67, 87, 109, 68, 90, 80, 
  87, 76, 87, 72, 101, 64, 87, 83, 96, 79, 
  100, 84, 74, 80, 79, 111, 77, 97, 69, 79, 
  95, 95, 75, 105, 81, 72, 90, 60, 89, 68, 
  78, 96, 76, 78, 87, 79, 71, 93, 93, 81, 
  99, 85, 86, 77, 94, 77, 71, 87, 80, 86, 
  87, 94, 83, 84, 86, 83, 95, 85, 88, 55, 
  78, 91, 93, 82, 99, 85, 85, 88, 87, 79, 
  72, 79, 93, 85, 78, 71, 87, 86, 62, 62, 
  88, 90, 74, 76, 77, 82, 72, 109, 77, 87, 
  66, 66, 81, 74, 99, 88, 81, 84, 90, 72, 
  72, 93, 89, 80, 88, 76, 83, 88, 63, 84, 
  78, 100, 73, 79, 89, 75, 83, 76, 80, 80, 
  100, 94, 63, 85, 97, 70, 94, 80, 87, 82, 
  84, 87, 102, 63, 94, 80, 91, 77, 97, 80, 
  64, 92, 77, 116, 79, 75, 76, 82, 96, 87, 
  84, 100, 83, 89, 77, 63, 89, 66, 77, 90, 
  80, 73, 89, 83, 63, 92, 90, 78, 95, 85, 
  92, 78, 95, 87, 79, 85, 77, 69, 91, 96, 
  77, 82, 86, 83, 90, 83, 80, 59, 81, 93, 
  73, 75, 102, 88, 91, 74, 81, 85, 74, 81, 
  92, 84, 72, 73, 76, 84, 62, 63, 91, 93, 
  77, 79, 80, 83, 78, 92, 90, 79, 66, 64, 
  81, 85, 96, 90, 89, 73, 81, 72, 80, 98, 
  82, 85, 83, 78, 83, 87, 77, 82, 84, 90, 
  75, 80, 81, 84, 79, 77, 84, 89, 104, 97, 
  61, 80, 103, 76, 89, 87, 88, 82, 81, 93, 
  100, 71, 89, 81, 86, 72, 95, 85, 74, 87, 
  84, 103, 78, 86, 90, 81, 98, 94, 82, 105, 
  75, 89, 88, 67, 89, 70, 82, 77, 87, 74, 
  84, 85, 74, 102, 96, 87, 99, 88, 103, 77, 
  95, 85, 86, 88, 86, 83, 84, 95, 80, 86, 
  78, 87, 92, 92, 81, 63, 83, 84, 70, 73, 
  80, 86, 87, 73, 88, 78, 80, 85, 101, 80, 
  82, 74, 79, 79, 80, 94, 74, 88, 88, 86, 
  83, 80, 78, 86, 85, 103, 71, 91, 79, 89, 
  77, 69, 78, 101, 74, 73, 95, 82, 98, 81, 
  87, 81, 82, 87, 84, 79, 85, 70, 90, 82, 
  98, 79, 74, 82, 91, 92, 96, 94, 82, 77, 
  75, 88, 82, 85, 96, 68, 92, 79, 75, 65, 
  86, 77, 95, 76, 88, 97, 77, 90, 88, 78, 
  70, 94, 76, 75, 85, 89, 84, 81, 84, 73, 
  96, 53, 87, 94, 91, 81, 70, 84, 95, 84, 
  83, 93, 82, 101, 89, 73, 99, 72, 80, 87, 
  82, 97, 83, 93, 92, 89, 85, 83, 85, 92, 
  89, 89, 81, 91, 84, 78, 89, 71, 85, 87, 
  95, 91, 86, 84, 72, 80, 81, 82, 86, 83, 
  74, 84, 79, 92, 63, 74, 87, 83, 81, 84, 
  74, 87, 82, 88, 73, 91, 77, 85, 79, 74, 
  85, 99, 79, 74, 91, 88, 89, 81, 81, 90, 
  82, 82, 86, 75, 80, 73, 94, 85, 93, 71, 
  83, 85, 78, 86, 87, 90, 84, 66, 78, 100, 
  83, 76, 97, 71, 92, 82, 87, 70, 85, 79, 
  92, 88, 86, 95, 73, 90, 87, 84, 74, 87, 
  77, 79, 88, 82, 88, 85, 82, 71, 98, 50, 
  90, 94, 84, 75, 73, 82, 77, 85, 81, 95, 
  90, 91, 95, 71, 98, 72, 78, 73, 80, 94, 
  80, 75, 87, 87, 81, 80, 84, 86, 79, 91, 
  80, 92, 85, 78, 86, 71, 82, 87, 93, 96, 
  85, 92, 71, 84, 83, 77, 83, 78, 87, 94, 
  77, 97, 84, 76, 85, 83, 82, 79, 78, 88, 
  86, 87, 74, 87, 78, 89, 81, 78, 87, 99, 
  95, 71, 96, 87, 97, 82, 86, 89, 80, 83, 
  82, 68, 78, 82, 87, 78, 100, 80, 76, 80, 
  72, 92, 99, 92, 84, 70, 76, 91, 80, 78, 
  92, 75, 89, 85, 76, 64, 86, 74, 98, 74, 
  88, 103, 80, 86, 96, 83, 76, 98, 82, 79, 
  88, 84, 93, 77, 93, 79, 95, 59, 88, 91, 
  90, 74, 71, 87, 77, 86, 79, 93, 83, 101, 
  88, 74, 91, 72, 81, 88, 81, 96, 81, 83, 
  90, 90, 85, 83, 89, 90, 89, 86, 75, 92, 
  86, 97, 81, 80, 74, 89, 91, 95, 89, 87, 
  72, 80, 84, 80, 87, 82, 101, 77, 65, 91, 
  101, 74, 85, 72, 77, 74, 108, 67, 84, 102, 
  76, 92, 104, 72, 84, 61, 87, 104, 63, 77, 
  101, 76, 86, 86, 105, 99, 84, 86, 82, 74, 
  87, 48, 82, 80, 116, 75, 83, 87, 78, 83, 
  106, 94, 93, 68, 77, 79, 67, 69, 84, 71, 
  80, 83, 68, 108, 66, 72, 83, 92, 76, 128, 
  68, 114, 87, 69, 99, 85, 66, 65, 84, 87, 
  82, 71, 81, 55, 96, 86, 64, 92, 86, 67, 
  76, 79, 82, 76, 46, 82, 60, 83, 81, 83, 
  80, 84, 84, 134, 83, 83, 74, 94, 91, 90, 
  80, 97, 83, 79, 91, 82, 75, 107, 78, 58, 
  113, 84, 77, 92, 84, 84, 95, 87, 62, 69, 
  85, 79, 101, 82, 92, 81, 73, 86, 88, 60, 
  85, 72, 86, 75, 106, 74, 80, 88, 81, 88, 
  99, 74, 85, 62, 87, 106, 62, 79, 87, 78, 
  83, 87, 93, 95, 85, 84, 83, 62, 78, 48, 
  81, 81, 104, 71, 82, 99, 81, 85, 99, 93, 
  85, 53, 78, 87, 68, 72, 88, 77, 90, 77, 
  84, 117, 64, 63, 80, 104, 73, 144, 68, 130, 
  84, 66, 100, 80, 62, 69, 88, 87, 84, 72, 
  83, 60, 94, 83, 72, 96, 83, 61, 80, 76, 
  55, 71, 50, 85, 71, 79, 81, 80, 69, 87, 
  83, 119, 82, 84, 72, 91, 87, 86, 81, 89, 
  78, 78, 84, 80, 83, 106, 77, 54, 108, 78, 
  71, 88, 86, 90, 79, 92, 63, 71, 87, 72, 
  102, 74, 102, 94, 88, 92, 102, 61, 84, 75, 
  79, 72, 102, 71, 85, 95, 79, 94, 103, 71, 
  82, 70, 78, 106, 79, 73, 93, 80, 83, 84, 
  106, 96, 82, 93, 83, 65, 94, 68, 86, 82, 
  107, 81, 85, 80, 78, 85, 105, 94, 87, 54, 
  78, 81, 66, 69, 82, 75, 78, 78, 72, 100, 
  69, 72, 85, 89, 78, 125, 70, 106, 85, 75, 
  101, 81, 69, 67, 87, 82, 95, 66, 86, 73, 
  99, 84, 64, 92, 87, 72, 77, 83, 62, 72, 
  47, 86, 63, 79, 79, 86, 77, 83, 83, 129, 
  88, 87, 77, 104, 89, 91, 83, 89, 82, 80, 
  89, 81, 80, 106, 80, 83, 102, 80, 68, 93, 
  81, 84, 78, 93, 63, 69, 79, 77, 105, 84, 
  84, 76, 70, 93, 90, 77, 84, 90, 83, 75, 
  81, 80, 77, 88, 79, 98, 95, 84, 81, 72, 
  94, 94, 75, 78, 97, 80, 91, 83, 81, 111, 
  88, 85, 89, 70, 71, 63, 94, 91, 119, 94, 
  86, 77, 74, 90, 89, 97, 95, 82, 79, 87, 
  78, 86, 81, 74, 79, 91, 75, 77, 88, 79, 
  78, 78, 95, 87, 74, 85, 81, 78, 93, 85, 
  82, 68, 98, 85, 80, 80, 78, 63, 106, 67, 
  73, 89, 85, 78, 82, 81, 89, 78, 78, 85, 
  86, 95, 85, 83, 82, 72, 80, 89, 83, 91, 
  70, 78, 85, 85, 78, 87, 82, 86, 75, 85, 
  71, 95, 86, 74, 85, 80, 82, 85, 91, 96, 
  88, 88, 83, 73, 90, 99, 91, 81, 83, 83, 
  83, 92, 80, 75, 84, 89, 91, 78, 80, 83, 
  75, 92, 76, 97, 90, 85, 83, 73, 83, 89, 
  76, 81, 87, 79, 95, 82, 72, 88, 89, 88, 
  96, 66, 69, 66, 85, 87, 98, 87, 85, 76, 
  86, 87, 80, 91, 85, 68, 81, 96, 82, 88, 
  84, 77, 86, 78, 82, 84, 82, 76, 80, 86, 
  94, 82, 70, 83, 88, 82, 91, 89, 70, 67, 
  95, 87, 84, 82, 77, 76, 107, 62, 82, 90, 
  87, 76, 85, 85, 75, 81, 74, 80, 91, 93, 
  84, 76, 74, 71, 81, 79, 78, 94, 70, 90, 
  84, 82, 82, 84, 83, 84, 77, 83, 71, 93, 
  85, 75, 86, 76, 75, 81, 87, 95, 77, 86, 
  89, 76, 96, 97, 89, 75, 86, 89, 94, 94, 
  91, 75, 80, 90, 90, 77, 78, 81, 77, 98, 
  77, 98, 96, 79, 79, 81, 74, 94, 79, 81, 
  85, 78, 93, 82, 76, 80, 89, 91, 90, 65, 
  94, 77, 89, 90, 94, 92, 89, 79, 88, 87, 
  82, 95, 94, 60, 78, 87, 80, 94, 82, 74, 
  80, 73, 77, 73, 90, 79, 79, 80, 95, 89, 
  79, 79, 80, 75, 94, 89, 70, 71, 92, 81, 
  90, 76, 79, 89, 118, 70, 73, 86, 92, 75, 
  83, 90, 74, 78, 82, 88, 86, 86, 87, 83, 
  72, 66, 77, 88, 82, 93, 74, 89, 84, 87, 
  81, 86, 84, 86, 80, 88, 72, 92, 85, 89, 
  86, 76, 72, 86, 91, 94, 77, 87, 82, 73, 
  88, 97, 90, 81, 68, 77, 95, 89, 74, 73, 
  83, 75, 84, 91, 88, 68, 91, 107, 63, 81, 
  72, 83, 78, 83, 96, 93, 78, 91, 74, 90, 
  76, 91, 94, 85, 95, 87, 74, 69, 72, 85, 
  94, 86, 99, 77, 75, 68, 84, 84, 86, 81, 
  67, 88, 96, 86, 75, 79, 92, 77, 80, 81, 
  72, 85, 85, 79, 87, 86, 78, 87, 88, 78, 
  98, 73, 81, 91, 70, 72, 97, 95, 78, 87, 
  80, 79, 97, 71, 78, 77, 79, 85, 76, 100, 
  87, 85, 79, 91, 92, 72, 74, 85, 84, 89, 
  83, 70, 80, 96, 87, 71, 80, 70, 82, 90, 
  87, 81, 76, 68, 74, 84, 81, 90, 70, 82, 
  80, 82, 87, 105, 93, 75, 85, 84, 89, 89, 
  79, 79, 70, 72, 71, 80, 91, 65, 82, 74, 
  82, 92, 88, 74, 88, 101, 71, 84, 72, 80, 
  73, 68, 92, 92, 72, 89, 76, 90, 74, 93, 
  91, 79, 93, 81, 65, 78, 75, 80, 92, 84, 
  109, 79, 72, 67, 97, 91, 97, 81, 62, 83, 
  90, 84, 87, 91, 92, 80, 64, 74, 70, 83, 
  86, 89, 86, 76, 78, 90, 87, 77, 85, 69, 
  76, 89, 81, 62, 93, 116, 72, 85, 93, 93, 
  110, 62, 82, 79, 74, 78, 66, 91, 89, 91, 
  79, 92, 94, 91, 82, 89, 83, 93, 83, 75, 
  63, 97, 83, 92, 82, 67, 82, 90, 103, 84, 
  71, 71, 87, 88, 82, 94, 76, 84, 70, 82, 
  86, 123, 88, 73, 86, 83, 82, 93, 83, 76, 
  74, 88, 69, 86, 76, 71, 80, 75, 78, 85, 
  87, 74, 86, 84, 64, 80, 80, 86, 81, 70, 
  91, 91, 72, 92, 86, 93, 78, 90, 88, 76, 
  96, 89, 75, 89, 77, 79, 93, 90, 91, 83, 
  73, 77, 94, 79, 87, 91, 70, 82, 94, 83, 
  77, 90, 88, 76, 81, 72, 71, 81, 86, 83, 
  88, 83, 74, 82, 84, 81, 82, 74, 92, 81, 
  97, 64, 98, 85, 78, 95, 73, 90, 106, 73, 
  79, 79, 81, 76, 78, 80, 93, 80, 83, 88, 
  91, 91, 74, 90, 101, 87, 84, 72, 81, 99, 
  78, 88, 78, 71, 81, 90, 84, 83, 75, 70, 
  84, 83, 81, 93, 79, 83, 77, 81, 86, 87, 
  83, 82, 87, 84, 89, 89, 81, 82, 88, 80, 
  78, 71, 110, 88, 83, 93, 82, 86, 101, 75, 
  66, 92, 76, 70, 82, 79, 85, 87, 106, 88, 
  85, 81, 64, 79, 55, 86, 88, 76, 139, 78, 
  73, 85, 101, 111, 76, 74, 91, 68, 73, 102, 
  66, 100, 78, 71, 94, 106, 74, 67, 103, 95, 
  93, 74, 65, 81, 94, 87, 95, 93, 77, 84, 
  80, 65, 83, 73, 70, 77, 81, 64, 75, 92, 
  55, 80, 93, 73, 104, 117, 75, 68, 84, 74, 
  74, 74, 76, 88, 84, 89, 101, 81, 75, 74, 
  84, 75, 71, 80, 97, 80, 88, 67, 73, 70, 
  73, 74, 89, 79, 115, 74, 88, 92, 84, 92, 
  76, 84, 72, 68, 79, 82, 94, 82, 91, 100, 
  80, 90, 74, 87, 92, 95, 85, 71, 63, 65, 
  140, 98, 68, 105, 82, 90, 100, 84, 77, 103, 
  90, 69, 94, 81, 91, 67, 80, 100, 79, 67, 
  75, 69, 60, 92, 81, 92, 170, 82, 56, 99, 
  94, 98, 76, 73, 110, 65, 68, 121, 92, 108, 
  77, 60, 100, 96, 63, 62, 125, 90, 91, 75, 
  56, 91, 102, 84, 88, 95, 74, 71, 69, 82, 
  69, 79, 53, 72, 69, 66, 71, 82, 46, 82, 
  93, 69, 155, 109, 79, 59, 80, 78, 78, 88, 
  76, 92, 76, 90, 90, 79, 82, 73, 87, 78, 
  66, 73, 113, 97, 68, 54, 76, 72, 85, 77, 
  86, 74, 129, 73, 92, 109, 97, 113, 88, 83, 
  69, 64, 69, 76, 116, 83, 85, 144, 74, 106, 
  56, 84, 108, 97, 84, 85, 74, 72, 103, 106, 
  79, 87, 76, 80, 96, 78, 75, 82, 72, 74, 
  82, 84, 85, 74, 79, 94, 76, 89, 93, 80, 
  60, 85, 81, 95, 125, 92, 78, 99, 78, 98, 
  83, 70, 85, 73, 78, 98, 110, 92, 81, 79, 
  101, 100, 76, 68, 98, 89, 92, 79, 66, 89, 
  84, 83, 89, 87, 87, 93, 85, 59, 78, 75, 
  69, 73, 79, 70, 93, 89, 57, 75, 92, 80, 
  80, 99, 86, 72, 88, 77, 83, 103, 79, 84, 
  85, 85, 96, 80, 80, 77, 86, 80, 77, 77, 
  95, 79, 67, 78, 73, 75, 75, 74, 82, 79, 
  99, 84, 83, 90, 83, 86, 79, 88, 65, 74, 
  87, 80, 93, 79, 77, 88, 82, 88, 80, 83, 
  88, 95, 86, 78, 70, 82, 89, 89, 88, 85, 
  81, 88, 92, 79, 71, 81, 70, 88, 88, 78, 
  91, 80, 78, 71, 70, 91, 89, 80, 77, 81, 
  92, 74, 93, 82, 77, 96, 114, 96, 77, 89, 
  83, 88, 95, 90, 72, 94, 64, 83, 112, 93, 
  87, 82, 90, 95, 78, 77, 76, 60, 91, 81, 
  98, 81, 80, 100, 100, 77, 95, 72, 75, 82, 
  91, 80, 82, 90, 78, 74, 102, 86, 82, 86, 
  73, 66, 78, 88, 88, 76, 78, 82, 85, 96, 
  90, 82, 76, 97, 88, 79, 78, 79, 89, 83, 
  95, 86, 72, 94, 73, 79, 93, 72, 105, 72, 
  82, 71, 82, 89, 69, 90, 75, 80, 61, 81, 
  89, 75, 74, 79, 77, 89, 83, 88, 79, 78, 
  90, 70, 74, 82, 106, 75, 81, 95, 78, 92, 
  91, 84, 70, 99, 79, 76, 91, 79, 83, 71, 
  64, 84, 80, 88, 95, 76, 83, 86, 85, 104, 
  88, 85, 74, 99, 91, 91, 91, 88, 102, 93, 
  98, 78, 65, 100, 58, 76, 133, 75, 82, 74, 
  93, 91, 74, 79, 77, 76, 97, 83, 103, 77, 
  75, 96, 100, 84, 95, 77, 86, 85, 92, 92, 
  76, 85, 70, 74, 116, 79, 90, 88, 83, 53, 
  75, 100, 82, 90, 81, 95, 81, 93, 85, 66, 
  76, 84, 87, 79, 73, 71, 89, 90, 99, 82, 
  73, 72, 78, 81, 85, 72, 106, 74, 79, 86, 
  79, 100, 80, 85, 68, 81, 75, 68, 95, 71, 
  74, 80, 71, 98, 73, 86, 82, 83, 78, 77, 
  80, 82, 79, 75, 88, 82, 82, 87, 89, 81, 
  82, 86, 68, 92, 88, 86, 87, 73, 79, 80, 
  82, 96, 97, 77, 71, 80, 85, 104, 93, 85, 
  84, 91, 85, 82, 79, 81, 86, 85, 99, 85, 
  81, 89, 70, 85, 101, 80, 89, 81, 85, 81, 
  78, 76, 77, 100, 84, 82, 94, 82, 86, 102, 
  98, 72, 85, 79, 87, 79, 82, 85, 70, 87, 
  79, 77, 99, 92, 78, 89, 71, 66, 80, 89, 
  84, 91, 76, 93, 88, 89, 87, 81, 81, 76, 
  91, 83, 74, 77, 87, 88, 86, 88, 75, 69, 
  72, 79, 91, 76, 93, 84, 82, 76, 82, 90, 
  74, 79, 59, 89, 105, 84, 92, 78, 77, 78, 
  79, 92, 84, 87, 82, 83, 69, 76, 89, 84, 
  76, 79, 71, 83, 101, 82, 72, 73, 83, 83, 
  101, 86, 73, 81, 86, 85, 80, 68, 99, 67, 
  79, 70, 78, 83, 102, 85, 85, 90, 74, 80, 
  88, 85, 74, 76, 81, 72, 76, 87, 79, 82, 
  54, 75, 79, 75, 69, 96, 66, 85, 73, 100, 
  76, 88, 82, 78, 88, 112, 83, 101, 80, 85, 
  95, 81, 68, 92, 82, 85, 84, 79, 80, 75, 
  79, 91, 121, 77, 82, 89, 87, 90, 79, 80, 
  84, 80, 77, 84, 75, 90, 92, 91, 78, 90, 
  92, 113, 83, 94, 87, 69, 95, 77, 101, 83, 
  88, 84, 75, 88, 88, 104, 88, 84, 84, 85, 
  89, 75, 88, 89, 82, 96, 94, 163, 86, 82, 
  88, 79, 79, 80, 69, 78, 87, 81, 82, 88, 
  76, 77, 97, 81, 73, 71, 84, 75, 102, 91, 
  70, 84, 83, 86, 82, 75, 91, 76, 80, 74, 
  82, 85, 90, 83, 85, 94, 79, 78, 87, 78, 
  70, 77, 74, 78, 78, 87, 80, 88, 61, 87, 
  80, 72, 68, 102, 64, 84, 76, 101, 78, 83, 
  78, 89, 92, 94, 84, 102, 79, 94, 93, 84, 
  74, 93, 82, 84, 78, 75, 80, 80, 81, 90, 
  103, 72, 88, 89, 94, 92, 84, 77, 82, 71, 
  78, 74, 72, 100, 91, 93, 80, 88, 83, 105, 
  80, 103, 87, 75, 93, 73, 95, 83, 87, 82, 
  73, 84, 88, 106, 88, 92, 83, 85, 95, 73, 
  77, 91, 83, 95, 80, 132, 82, 79, 88, 79, 
  78, 82, 77, 83, 87, 78, 78, 91, 72, 80, 
  96, 82, 73, 73, 87, 76, 99, 86, 75, 75, 
  86, 83, 81, 75, 81, 71, 83, 69, 79, 80, 
  97, 78, 85, 92, 72, 81, 92, 97, 78, 75, 
  83, 76, 81, 88, 82, 83, 62, 80, 77, 75, 
  71, 96, 67, 86, 73, 92, 74, 83, 82, 75, 
  89, 103, 83, 96, 81, 83, 100, 80, 77, 91, 
  85, 86, 90, 78, 81, 74, 81, 85, 106, 76, 
  85, 90, 85, 91, 85, 88, 84, 76, 87, 83, 
  75, 98, 92, 96, 78, 92, 91, 104, 79, 93, 
  78, 77, 93, 84, 96, 82, 84, 84, 78, 88, 
  88, 99, 93, 85, 84, 83, 85, 77, 79, 89, 
  80, 94, 69, 144, 83, 82, 80, 80, 86, 85, 
  70, 82, 81, 85, 71, 83, 83, 98, 97, 78, 
  76, 74, 83, 74, 104, 87, 73, 84, 85, 81, 
  80, 62, 90, 73, 74, 76, 78, 83, 92, 77, 
  79, 87, 80, 86, 67, 81, 68, 79, 70, 77, 
  81, 94, 84, 84, 56, 80, 80, 76, 70, 93, 
  71, 75, 77, 107, 85, 85, 81, 84, 90, 102, 
  79, 97, 80, 88, 89, 92, 79, 82, 80, 83, 
  91, 81, 84, 75, 84, 96, 104, 69, 84, 107, 
  87, 78, 76, 70, 85, 79, 81, 78, 76, 77, 
  85, 79, 84, 95, 86, 118, 85, 105, 86, 78, 
  88, 81, 93, 83, 80, 87, 82, 82, 75, 94, 
  83, 86, 82, 81, 85, 76, 80, 83, 81, 100, 
  82, 147, 87, 83, 92, 81, 80, 81, 72, 77, 
  84, 81, 78, 82, 89, 89, 89, 76, 79, 75, 
  81, 74, 105, 86, 71, 87, 83, 80, 85, 70, 
  84, 85, 76, 82, 80, 81, 78, 73, 77, 91, 
  80, 78, 68, 73, 63, 78, 74, 84, 82, 103, 
  84, 90, 63, 92, 78, 72, 74, 96, 64, 78, 
  79, 105, 86, 82, 80, 100, 90, 82, 81, 98, 
  78, 106, 91, 96, 86, 82, 83, 85, 77, 82, 
  81, 79, 82, 93, 84, 69, 87, 112, 94, 83, 
  87, 67, 88, 76, 76, 72, 76, 83, 84, 77, 
  84, 96, 78, 114, 78, 119, 91, 84, 86, 64, 
  82, 82, 76, 88, 76, 79, 72, 97, 86, 93, 
  79, 81, 92, 69, 79, 83, 80, 100, 64, 119, 
  83, 80, 93, 78, 77, 85, 77, 87, 90, 82, 
  76, 85, 81, 89, 92, 80, 79, 73, 83, 76, 
  103, 89, 74, 80, 85, 79, 82, 70, 85, 75, 
  78, 72, 79, 80, 89, 74, 79, 89, 77, 78, 
  80, 90, 72, 77, 79, 77, 83, 90, 82, 82, 
  64, 83, 77, 72, 72, 91, 73, 83, 77, 97, 
  83, 75, 81, 78, 89, 96, 80, 89, 80, 84, 
  97, 86, 87, 85, 84, 85, 76, 77, 82, 75, 
  87, 92, 96, 80, 83, 101, 84, 78, 82, 80, 
  86, 81, 80, 81, 77, 89, 89, 85, 81, 95, 
  85, 108, 83, 100, 82, 79, 92, 78, 91, 81, 
  76, 86, 85, 83, 77, 92, 91, 87, 84, 82, 
  84, 76, 84, 82, 80, 97, 61, 134, 85, 82, 
  85, 81, 82, 84, 80, 84, 78, 88, 80, 89, 
  83, 102, 100, 84, 78, 79, 83, 76, 104, 84, 
  74, 74, 91, 81, 83, 79, 81, 72, 77, 67, 
  83, 80, 94, 78, 79, 90, 81, 91, 69, 82, 
  79, 96, 71, 70, 87, 90, 85, 83, 61, 77, 
  83, 77, 69, 98, 72, 85, 75, 96, 85, 88, 
  78, 78, 93, 113, 75, 93, 81, 86, 96, 87, 
  86, 83, 85, 90, 97, 79, 89, 76, 86, 96, 
  114, 75, 82, 78, 88, 77, 80, 79, 79, 82, 
  82, 85, 85, 68, 80, 83, 80, 102, 90, 109, 
  87, 84, 83, 75, 93, 96, 95, 80, 78, 84, 
  93, 88, 77, 85, 76, 84, 78, 83, 82, 85, 
  84, 88, 88, 93, 79, 141, 91, 87, 86, 90, 
  85, 86, 78, 81, 84, 85, 87, 87, 89, 97, 
  92, 79, 77, 79, 81, 77, 103, 86, 72, 80, 
  87, 80, 90, 83, 81, 79, 79, 72, 82, 76, 
  79, 72, 81, 91, 77, 83, 66, 77, 74, 90, 
  77, 77, 89, 93, 84, 86, 63, 89, 79, 76, 
  74, 96, 69, 87, 77, 96, 84, 84, 77, 87, 
  94, 94, 78, 94, 81, 92, 88, 87, 91, 80, 
  87, 87, 81, 75, 85, 78, 86, 93, 92, 77, 
  83, 86, 93, 83, 84, 77, 81, 84, 79, 80, 
  81, 74, 76, 77, 79, 100, 81, 105, 82, 93, 
  84, 78, 85, 80, 89, 79, 74, 83, 85, 84, 
  75, 85, 78, 87, 78, 81, 83, 80, 83, 85, 
  85, 92, 70, 120, 88, 85, 88, 86, 83, 85, 
  84, 86, 98, 87, 84, 84, 81, 92, 96, 83, 
  83, 77, 81, 82, 98, 90, 76, 71, 91, 82, 
  82, 82, 83, 76, 81, 65, 81, 74, 91, 74, 
  81, 92, 79, 81, 80, 90, 81, 92, 81, 74, 
  94, 93, 81, 83, 68, 83, 80, 76, 74, 98, 
  75, 93, 76, 90, 84, 78, 79, 74, 94, 103, 
  76, 88, 82, 83, 96, 86, 93, 83, 86, 90, 
  78, 79, 87, 74, 86, 95, 108, 85, 79, 82, 
  87, 77, 84, 84, 81, 89, 78, 82, 82, 79, 
  82, 74, 78, 101, 86, 103, 85, 81, 79, 76, 
  94, 84, 91, 77, 78, 84, 92, 87, 76, 84, 
  85, 84, 80, 82, 82, 85, 88, 87, 86, 91, 
  68, 130, 88, 84, 86, 88, 84, 88, 90, 70, 
  93, 96, 85, 82, 90, 78, 94, 76, 66, 87, 
  71, 88, 104, 71, 94, 76, 92, 77, 82, 85, 
  96, 85, 104, 76, 72, 82, 95, 94, 69, 78, 
  85, 94, 86, 77, 76, 73, 84, 96, 91, 81, 
  90, 86, 50, 78, 131, 91, 75, 91, 94, 78, 
  95, 79, 98, 80, 96, 83, 77, 97, 78, 74, 
  70, 82, 76, 81, 84, 72, 112, 64, 70, 92, 
  88, 73, 112, 74, 83, 66, 63, 85, 64, 87, 
  79, 71, 99, 82, 81, 96, 91, 76, 88, 72, 
  85, 78, 77, 81, 82, 87, 119, 66, 84, 86, 
  78, 85, 89, 89, 91, 87, 84, 86, 68, 82, 
  89, 89, 83, 74, 103, 84, 82, 67, 88, 83, 
  76, 87, 94, 94, 69, 80, 87, 84, 89, 90, 
  83, 86, 94, 74, 96, 76, 62, 84, 79, 85, 
  112, 66, 96, 69, 93, 69, 97, 89, 87, 87, 
  105, 75, 79, 83, 99, 84, 68, 78, 90, 91, 
  91, 80, 75, 81, 92, 95, 85, 79, 84, 86, 
  55, 83, 135, 77, 72, 95, 91, 79, 92, 76, 
  96, 86, 98, 79, 79, 97, 82, 79, 70, 79, 
  68, 81, 78, 76, 105, 62, 84, 86, 83, 73, 
  109, 69, 82, 79, 68, 83, 63, 85, 86, 85, 
  97, 83, 81, 91, 91, 82, 85, 72, 81, 78, 
  70, 80, 79, 87, 112, 69, 81, 81, 75, 84, 
  86, 95, 91, 90, 89, 87, 62, 85, 87, 84, 
  75, 81, 89, 85, 83, 63, 71, 82, 71, 87, 
  93, 94, 69, 84, 88, 92, 88, 87, 88, 98, 
  91, 78, 83, 80, 74, 83, 83, 84, 101, 76, 
  93, 76, 94, 81, 102, 84, 92, 86, 97, 72, 
  77, 83, 87, 81, 69, 84, 86, 95, 95, 85, 
  79, 74, 89, 91, 94, 79, 78, 79, 59, 77, 
  112, 65, 77, 93, 93, 76, 93, 81, 96, 86, 
  85, 90, 75, 90, 85, 80, 78, 73, 81, 84, 
  86, 77, 105, 68, 96, 99, 86, 80, 105, 77, 
  80, 83, 75, 89, 68, 78, 81, 89, 95, 87, 
  83, 94, 89, 87, 88, 78, 84, 80, 80, 86, 
  84, 85, 101, 78, 84, 84, 75, 84, 87, 96, 
  86, 92, 90, 85, 61, 80, 86, 79, 82, 88, 
  77, 87, 88, 72, 64, 79, 80, 87, 93, 95, 
  72, 82, 90, 67, 83, 99, 84, 95, 86, 84, 
  94, 87, 72, 88, 75, 86, 89, 70, 90, 78, 
  83, 74, 72, 81, 87, 83, 94, 73, 65, 90, 
  96, 82, 64, 77, 83, 93, 82, 81, 71, 81, 
  81, 88, 91, 83, 74, 80, 59, 82, 124, 95, 
  77, 91, 95, 79, 81, 88, 82, 82, 88, 84, 
  85, 93, 77, 64, 70, 90, 80, 88, 87, 66, 
  114, 65, 74, 82, 87, 64, 104, 71, 79, 70, 
  62, 85, 70, 92, 89, 76, 94, 84, 83, 88, 
  90, 79, 87, 82, 85, 79, 83, 73, 84, 88, 
  117, 78, 85, 82, 70, 81, 91, 78, 86, 86, 
  86, 84, 70, 81, 87, 88, 80, 76, 95, 84, 
  77, 67, 92, 86, 74, 84, 90, 86, 73, 85, 
  88, 79, 88, 88, 82, 93, 87, 86, 92, 86, 
  70, 85, 76, 81, 94, 61, 91, 70, 81, 72, 
  80, 90, 87, 82, 104, 72, 66, 89, 96, 75, 
  64, 79, 83, 86, 84, 82, 73, 84, 84, 85, 
  88, 85, 73, 79, 62, 82, 128, 83, 75, 96, 
  92, 80, 77, 85, 83, 86, 88, 83, 90, 93, 
  81, 71, 69, 88, 76, 90, 88, 71, 111, 65, 
  83, 76, 84, 64, 104, 65, 79, 80, 64, 82, 
  71, 90, 93, 86, 93, 88, 80, 85, 88, 77, 
  82, 73, 83, 80, 74, 71, 83, 87, 97, 80, 
  82, 79, 70, 80, 89, 85, 84, 86, 84, 82, 
  64, 85, 87, 85, 73, 83, 85, 83, 80, 66, 
  78, 87, 63, 88, 85, 87, 76, 88, 91, 89, 
  97, 86, 84, 96, 89, 85, 80, 91, 75, 87, 
  79, 82, 85, 69, 86, 80, 89, 82, 87, 87, 
  100, 83, 97, 73, 73, 88, 87, 79, 69, 84, 
  85, 86, 88, 85, 78, 81, 81, 79, 96, 81, 
  74, 75, 65, 80, 104, 73, 79, 91, 90, 80, 
  87, 87, 89, 90, 83, 91, 85, 87, 83, 77, 
  76, 82, 85, 92, 90, 71, 103, 76, 90, 89, 
  89, 72, 99, 73, 81, 81, 70, 87, 74, 83, 
  85, 89, 91, 85, 82, 88, 86, 87, 87, 83, 
  84, 78, 83, 80, 84, 90, 83, 86, 87, 73, 
  74, 82, 91, 88, 79, 89, 88, 80, 67, 84, 
  88, 84, 82, 89, 82, 87, 82, 74, 74, 84, 
  77, 84, 90, 88, 73, 84, 90, 74, 72, 100, 
  79, 111, 77, 85, 84, 94, 69, 89, 75, 88, 
  84, 80, 105, 99, 86, 80, 66, 73, 83, 80, 
  96, 78, 72, 94, 98, 82, 66, 77, 74, 90, 
  77, 76, 86, 85, 86, 90, 99, 59, 68, 81, 
  62, 87, 126, 93, 81, 90, 86, 74, 85, 90, 
  87, 80, 77, 83, 91, 90, 87, 68, 76, 92, 
  85, 79, 93, 68, 114, 79, 76, 75, 96, 66, 
  103, 74, 68, 69, 73, 82, 72, 100, 89, 85, 
  90, 86, 86, 91, 85, 88, 88, 111, 75, 80, 
  97, 75, 76, 99, 114, 81, 83, 82, 67, 77, 
  86, 69, 79, 89, 87, 84, 71, 80, 91, 82, 
  77, 74, 82, 83, 77, 70, 87, 91, 97, 70, 
  90, 90, 74, 81, 88, 80, 83, 92, 79, 90, 
  75, 91, 85, 97, 72, 88, 80, 86, 83, 74, 
  108, 95, 84, 80, 65, 83, 96, 78, 113, 81, 
  68, 96, 97, 71, 71, 76, 76, 81, 76, 80, 
  86, 86, 90, 90, 97, 62, 69, 79, 65, 80, 
  138, 81, 80, 95, 85, 77, 81, 85, 86, 75, 
  78, 83, 100, 92, 85, 70, 75, 95, 79, 83, 
  101, 75, 115, 77, 76, 77, 93, 66, 107, 70, 
  67, 83, 69, 81, 71, 98, 90, 85, 89, 93, 
  78, 90, 81, 81, 88, 96, 81, 86, 80, 72, 
  74, 98, 93, 81, 81, 78, 64, 77, 83, 74, 
  79, 89, 84, 85, 70, 83, 92, 79, 72, 81, 
  80, 82, 85, 69, 84, 95, 94, 78, 87, 89, 
  77, 89, 95, 85, 98, 90, 82, 84, 80, 92, 
  76, 95, 76, 85, 77, 81, 79, 77, 104, 97, 
  87, 86, 74, 80, 109, 84, 109, 79, 75, 90, 
  89, 74, 75, 84, 76, 75, 86, 81, 88, 87, 
  88, 83, 101, 65, 77, 77, 69, 83, 114, 71, 
  79, 88, 88, 77, 87, 87, 94, 81, 77, 87, 
  92, 84, 87, 78, 80, 88, 83, 85, 96, 67, 
  101, 87, 79, 79, 99, 73, 97, 75, 78, 88, 
  73, 82, 75, 91, 85, 85, 82, 88, 77, 86, 
  86, 87, 85, 96, 76, 79, 86, 81, 81, 98, 
  72, 84, 84, 74, 68, 80, 83, 71, 74, 90, 
  86, 75, 74, 83, 92, 82, 84, 85, 86, 86, 
  77, 77, 85, 89, 86, 73, 86, 91, 73, 84, 
  86, 71, 124, 94, 71, 98, 88, 79, 83, 92, 
  73, 70, 82, 91, 77, 80, 76, 99, 80, 86, 
  95, 81, 109, 87, 93, 75, 98, 93, 90, 99, 
  81, 82, 93, 70, 79, 90, 90, 86, 83, 77, 
  90, 72, 72, 65, 79, 87, 88, 76, 89, 87, 
  75, 85, 96, 81, 89, 80, 90, 68, 85, 84, 
  87, 93, 81, 70, 89, 79, 93, 90, 68, 89, 
  72, 86, 95, 85, 84, 85, 88, 92, 69, 69, 
  78, 83, 79, 96, 75, 89, 87, 91, 79, 79, 
  97, 74, 88, 72, 91, 82, 72, 73, 62, 84, 
  88, 77, 82, 83, 81, 93, 75, 92, 77, 90, 
  87, 78, 83, 80, 68, 92, 92, 90, 74, 90, 
  101, 84, 78, 77, 82, 92, 80, 83, 100, 70, 
  108, 83, 85, 79, 86, 74, 87, 79, 81, 80, 
  88, 77, 86, 74, 92, 92, 86, 80, 94, 75, 
  94, 86, 99, 75, 81, 87, 93, 106, 101, 81, 
  85, 70, 73, 77, 83, 78, 100, 74, 80, 93, 
  58, 76, 88, 73, 86, 74, 79, 83, 85, 76, 
  88, 88, 87, 83, 81, 86, 85, 78, 86, 80, 
  80, 89, 71, 92, 93, 79, 67, 86, 71, 90, 
  82, 83, 85, 78, 98, 90, 62, 97, 77, 93, 
  82, 97, 89, 84, 71, 86, 75, 76, 83, 67, 
  78, 79, 73, 90, 83, 107, 65, 78, 79, 83, 
  81, 84, 83, 105, 70, 85, 78, 85, 92, 83, 
  87, 74, 86, 95, 73, 86, 79, 82, 93, 93, 
  83, 77, 83, 84, 88, 88, 83, 83, 127, 87, 
  90, 74, 81, 74, 92, 75, 90, 76, 76, 65, 
  93, 86, 85, 81, 82, 82, 84, 71, 90, 89, 
  104, 76, 75, 81, 88, 111, 103, 75, 82, 66, 
  71, 89, 68, 84, 99, 75, 92, 76, 57, 77, 
  85, 76, 106, 72, 82, 83, 76, 69, 78, 88, 
  83, 77, 76, 110, 80, 83, 89, 87, 77, 107, 
  88, 86, 97, 77, 75, 71, 82, 88, 79, 92, 
  93, 80, 97, 82, 66, 84, 79, 93, 83, 93, 
  98, 99, 63, 88, 72, 76, 80, 72, 83, 84, 
  78, 89, 89, 114, 62, 76, 83, 75, 82, 83, 
  94, 91, 71, 78, 80, 78, 91, 82, 83, 76, 
  88, 86, 86, 83, 92, 75, 95, 91, 81, 79, 
  80, 89, 91, 82, 95, 67, 105, 83, 76, 87, 
  84, 73, 78, 83, 89, 75, 92, 83, 85, 62, 
  86, 92, 89, 70, 85, 81, 95, 94, 101, 77, 
  85, 88, 91, 114, 104, 76, 85, 68, 71, 74, 
  94, 77, 96, 74, 83, 97, 60, 71, 93, 75, 
  91, 71, 80, 82, 71, 75, 90, 91, 89, 88, 
  78, 94, 77, 81, 94, 88, 74, 97, 68, 98, 
  103, 84, 69, 73, 64, 86, 84, 88, 81, 72, 
  90, 77, 65, 90, 78, 91, 79, 88, 88, 80, 
  72, 89, 78, 74, 83, 70, 85, 84, 80, 84, 
  83, 108, 64, 75, 81, 78, 88, 81, 84, 94, 
  76, 89, 75, 90, 87, 84, 89, 64, 87, 95, 
  81, 88, 82, 81, 94, 88, 75, 75, 77, 86, 
  90, 89, 93, 74, 123, 90, 94, 66, 82, 70, 
  85, 81, 90, 76, 96, 83, 90, 80, 90, 78, 
  80, 77, 87, 77, 78, 94, 102, 79, 77, 84, 
  89, 115, 106, 83, 84, 69, 65, 76, 76, 88, 
  95, 76, 88, 89, 57, 84, 94, 79, 98, 72, 
  76, 79, 73, 76, 86, 96, 78, 78, 70, 99, 
  81, 80, 89, 82, 78, 97, 62, 95, 103, 68, 
  79, 74, 66, 84, 76, 88, 82, 73, 97, 87, 
  64, 95, 85, 95, 87, 89, 99, 94, 64, 85, 
  75, 70, 77, 70, 76, 85, 70, 91, 86, 105, 
  64, 75, 75, 78, 89, 82, 87, 86, 78, 83, 
  75, 79, 87, 79, 85, 64, 91, 102, 81, 87, 
  89, 76, 90, 89, 82, 75, 81, 84, 87, 86, 
  75, 83, 126, 87, 86, 67, 76, 73, 92, 85, 
  80, 75, 77, 89, 74, 96, 79, 72, 79, 85, 
  93, 75, 80, 95, 91, 72, 83, 77, 87, 114, 
  89, 78, 83, 65, 72, 87, 74, 93, 81, 69, 
  91, 53, 68, 77, 68, 89, 103, 70, 90, 80, 
  68, 87, 82, 88, 89, 76, 84, 95, 90, 80, 
  87, 100, 92, 81, 83, 69, 97, 77, 77, 77, 
  78, 69, 97, 90, 86, 82, 85, 84, 84, 67, 
  89, 87, 83, 86, 88, 104, 76, 86, 84, 71, 
  79, 82, 81, 75, 91, 78, 84, 72, 65, 81, 
  88, 82, 82, 81, 91, 88, 81, 80, 76, 76, 
  76, 81, 81, 79, 88, 88, 103, 80, 84, 90, 
  102, 81, 79, 75, 82, 97, 82, 82, 87, 67, 
  119, 92, 78, 86, 81, 68, 74, 74, 84, 77, 
  105, 75, 84, 72, 85, 83, 84, 77, 99, 75, 
  84, 94, 97, 75, 81, 84, 93, 115, 99, 91, 
  80, 76, 64, 81, 83, 89, 93, 89, 94, 97, 
  51, 74, 91, 69, 92, 77, 91, 76, 69, 64, 
  79, 92, 76, 74, 77, 95, 81, 83, 93, 78, 
  81, 84, 69, 87, 98, 86, 85, 80, 72, 99, 
  73, 88, 77, 75, 89, 87, 63, 109, 78, 85, 
  86, 87, 96, 91, 69, 79, 84, 75, 81, 70, 
  88, 96, 70, 86, 91, 99, 76, 85, 69, 78, 
  88, 79, 91, 84, 78, 80, 63, 76, 76, 73, 
  82, 64, 89, 86, 67, 95, 92, 72, 91, 84, 
  74, 77, 86, 89, 83, 82, 74, 77, 122, 87, 
  80, 94, 80, 70, 84, 80, 76, 76, 88, 96, 
  74, 92, 78, 81, 80, 85, 110, 82, 86, 89, 
  81, 69, 82, 78, 95, 115, 80, 88, 83, 70, 
  74, 91, 82, 88, 79, 75, 92, 62, 57, 74, 
  82, 84, 91, 74, 92, 75, 70, 84, 80, 83, 
  89, 68, 82, 83, 93, 79, 85, 83, 95, 51, 
  72, 67, 81, 80, 77, 82, 74, 82, 90, 90, 
  75, 87, 88, 97, 70, 87, 84, 82, 79, 90, 
  80, 93, 86, 83, 91, 71, 85, 78, 82, 74, 
  92, 78, 85, 66, 67, 80, 81, 69, 80, 80, 
  82, 85, 82, 81, 70, 76, 75, 77, 77, 78, 
  82, 89, 101, 81, 80, 86, 98, 83, 83, 75, 
  83, 91, 75, 77, 65, 79, 101, 80, 86, 78, 
  85, 81, 87, 93, 76, 87, 71, 102, 77, 89, 
  74, 86, 96, 93, 127, 82, 78, 85, 78, 81, 
  91, 76, 95, 104, 87, 83, 87, 77, 75, 76, 
  77, 84, 76, 67, 84, 57, 68, 91, 82, 96, 
  90, 74, 101, 82, 75, 102, 85, 83, 92, 70, 
  109, 82, 106, 84, 81, 82, 96, 66, 79, 69, 
  77, 97, 71, 69, 78, 74, 100, 100, 79, 105, 
  86, 82, 81, 76, 91, 84, 83, 87, 75, 90, 
  94, 90, 93, 77, 95, 83, 84, 76, 94, 75, 
  80, 64, 66, 88, 91, 86, 87, 80, 83, 83, 
  90, 92, 83, 89, 82, 79, 94, 81, 78, 80, 
  97, 81, 89, 99, 96, 87, 85, 96, 92, 92, 
  82, 80, 81, 88, 79, 82, 65, 78, 77, 85, 
  83, 98, 81, 90, 76, 77, 76, 81, 81, 97, 
  83, 97, 82, 76, 109, 98, 88, 81, 94, 84, 
  89, 86, 82, 82, 98, 93, 99, 87, 86, 88, 
  79, 78, 80, 90, 70, 77, 96, 74, 85, 77, 
  83, 79, 76, 96, 93, 78, 96, 76, 86, 67, 
  101, 92, 89, 81, 80, 65, 74, 86, 79, 77, 
  73, 91, 77, 88, 77, 85, 81, 96, 94, 91, 
  89, 80, 82, 72, 76, 110, 73, 82, 97, 81, 
  91, 84, 90, 75, 90, 74, 84, 77, 85, 89, 
  84, 95, 67, 85, 85, 91, 85, 89, 91, 93, 
  100, 108, 87, 69, 88, 85, 70, 93, 80, 83, 
  86, 88, 70, 93, 91, 90, 76, 82, 79, 98, 
  93, 76, 81, 74, 109, 65, 71, 76, 74, 92, 
  92, 83, 87, 87, 80, 69, 79, 78, 77, 99, 
  84, 83, 95, 82, 88, 73, 72, 83, 89, 86, 
  76, 86, 78, 92, 88, 85, 90, 77, 81, 82, 
  82, 86, 78, 82, 94, 67, 76, 74, 94, 65, 
  93, 75, 77, 90, 68, 82, 84, 87, 75, 84, 
  93, 89, 90, 73, 77, 84, 77, 79, 95, 87, 
  83, 96, 79, 75, 83, 85, 73, 86, 97, 95, 
  74, 89, 76, 115, 101, 76, 96, 87, 71, 84, 
  83, 74, 72, 91, 80, 103, 93, 89, 93, 99, 
  71, 89, 78, 91, 89, 84, 81, 95, 106, 79, 
  88, 77, 80, 83, 92, 84, 60, 99, 80, 76, 
  71, 69, 75, 77, 86, 77, 88, 62, 96, 80, 
  90, 86, 111, 78, 71, 81, 66, 89, 95, 79, 
  89, 78, 80, 73, 79, 67, 69, 102, 87, 88, 
  76, 68, 90, 78, 65, 80, 88, 87, 79, 97, 
  72, 94, 89, 96, 84, 70, 72, 84, 82, 77, 
  97, 78, 94, 68, 64, 90, 101, 64, 86, 65, 
  71, 101, 54, 76, 70, 107, 66, 83, 99, 96, 
  93, 90, 87, 93, 73, 85, 101, 76, 91, 110, 
  77, 74, 87, 74, 67, 98, 108, 104, 74, 101, 
  72, 93, 111, 81, 99, 91, 80, 79, 70, 79, 
  67, 95, 84, 115, 92, 96, 93, 84, 75, 90, 
  79, 93, 92, 73, 84, 87, 103, 65, 94, 84, 
  76, 92, 102, 86, 75, 104, 77, 82, 84, 74, 
  70, 72, 96, 77, 87, 53, 79, 84, 85, 87, 
  58, 81, 82, 84, 92, 96, 79, 87, 77, 75, 
  72, 94, 81, 103, 87, 88, 80, 78, 91, 94, 
  82, 74, 105, 84, 93, 90, 81, 76, 99, 85, 
  103, 82, 89, 90, 70, 78, 80, 92, 72, 76, 
  82, 84, 95, 78, 72, 92, 73, 97, 94, 75, 
  102, 74, 92, 68, 107, 89, 87, 75, 72, 60, 
  66, 78, 70, 71, 72, 89, 76, 81, 89, 91, 
  81, 93, 97, 81, 89, 74, 85, 70, 87, 96, 
  70, 80, 95, 73, 87, 85, 89, 89, 89, 73, 
  84, 59, 71, 79, 81, 94, 78, 83, 90, 88, 
  81, 84, 78, 88, 92, 111, 85, 81, 93, 85, 
  72, 85, 74, 68, 81, 89, 67, 101, 99, 94, 
  80, 76, 81, 105, 89, 75, 74, 78, 87, 69, 
  73, 81, 80, 91, 84, 88, 83, 91, 83, 71, 
  82, 85, 83, 90, 83, 86, 96, 94, 83, 65, 
  89, 84, 92, 77, 67, 87, 90, 97, 94, 89, 
  74, 83, 76, 79, 83, 86, 74, 76, 80, 68, 
  80, 77, 83, 75, 91, 81, 81, 78, 76, 79, 
  90, 76, 83, 88, 95, 91, 79, 70, 71, 80, 
  72, 76, 93, 87, 75, 81, 83, 81, 77, 83, 
  87, 84, 93, 86, 71, 82, 81, 108, 89, 79, 
  93, 85, 70, 85, 88, 75, 80, 82, 83, 77, 
  83, 85, 89, 101, 70, 94, 81, 91, 75, 88, 
  83, 93, 92, 92, 79, 94, 85, 86, 81, 81, 
  62, 85, 77, 77, 72, 79, 80, 77, 71, 69, 
  88, 75, 95, 85, 85, 87, 100, 81, 77, 83, 
  72, 88, 88, 82, 88, 83, 82, 73, 89, 70, 
  73, 94, 89, 86, 84, 84, 86, 75, 83, 85, 
  94, 88, 69, 97, 79, 88, 90, 97, 66, 78, 
  82, 78, 85, 77, 86, 80, 86, 70, 69, 92, 
  93, 65, 98, 61, 75, 89, 62, 84, 76, 102, 
  72, 80, 96, 101, 81, 83, 82, 89, 79, 82, 
  108, 85, 85, 90, 77, 76, 81, 72, 82, 93, 
  97, 100, 72, 96, 73, 86, 107, 91, 89, 97, 
  78, 82, 75, 71, 75, 88, 80, 94, 86, 98, 
  87, 84, 76, 94, 79, 92, 74, 83, 91, 91, 
  91, 78, 86, 98, 78, 88, 91, 81, 80, 95, 
  74, 80, 83, 76, 71, 69, 78, 72, 85, 64, 
  84, 85, 90, 93, 69, 84, 84, 82, 96, 88, 
  70, 83, 82, 73, 72, 104, 70, 101, 78, 85, 
  81, 82, 93, 91, 87, 85, 94, 75, 85, 85, 
  86, 78, 86, 85, 84, 80, 81, 92, 75, 87, 
  83, 78, 76, 89, 79, 89, 92, 77, 71, 95, 
  65, 108, 95, 82, 107, 83, 89, 84, 102, 86, 
  90, 77, 80, 70, 83, 73, 75, 80, 69, 99, 
  79, 74, 71, 86, 83, 81, 92, 79, 89, 71, 
  104, 72, 88, 89, 80, 88, 93, 67, 94, 92, 
  81, 90, 79, 71, 85, 68, 70, 82, 78, 86, 
  72, 85, 88, 78, 90, 73, 70, 78, 86, 94, 
  93, 68, 88, 82, 77, 90, 84, 67, 80, 88, 
  58, 95, 95, 89, 97, 85, 73, 87, 90, 87, 
  83, 87, 74, 73, 76, 83, 97, 90, 74, 92, 
  80, 77, 81, 81, 68, 95, 80, 82, 82, 89, 
  101, 91, 91, 77, 97, 83, 82, 78, 76, 83, 
  98, 81, 92, 90, 79, 88, 79, 80, 87, 76, 
  75, 80, 73, 81, 81, 73, 77, 101, 77, 100, 
  91, 78, 98, 81, 84, 80, 92, 89, 92, 82, 
  82, 83, 83, 81, 80, 82, 71, 94, 71, 77, 
  80, 91, 79, 82, 92, 86, 87, 67, 89, 74, 
  90, 104, 85, 84, 91, 81, 84, 88, 88, 85, 
  81, 73, 79, 66, 83, 82, 80, 92, 78, 81, 
  82, 82, 86, 76, 80, 83, 85, 92, 85, 78, 
  83, 84, 74, 89, 75, 71, 81, 84, 72, 89, 
  92, 80, 85, 82, 79, 88, 92, 83, 94, 92, 
  80, 82, 79, 80, 89, 89, 78, 92, 85, 84, 
  85, 77, 71, 85, 73, 82, 87, 88, 98, 88, 
  91, 84, 96, 84, 88, 92, 76, 89, 86, 87, 
  83, 92, 71, 89, 83, 82, 89, 81, 83, 77, 
  77, 80, 75, 92, 85, 89, 92, 90, 87, 83, 
  90, 80, 74, 90, 87, 88, 93, 95, 84, 84, 
  85, 91, 80, 87, 83, 81, 86, 89, 78, 83, 
  81, 84, 94, 83, 82, 77, 87, 83, 84, 90, 
  96, 91, 92, 88, 92, 85, 87, 81, 78, 78, 
  78, 78, 89, 92, 77, 86, 76, 85, 79, 85, 
  78, 84, 89, 86, 86, 86, 92, 85, 78, 88, 
  81, 81, 91, 80, 81, 85, 85, 82, 86, 72, 
  80, 83, 78, 73, 
};

unsigned char b_data[b_count] = {
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 39, 14, 0, 0, 0, 63, 31, 
  0, 36, 15, 0, 0, 12, 10, 93, 23, 78, 
  37, 39, 52, 0, 44, 62, 9, 23, 34, 48, 
  251, 53, 0, 0, 103, 0, 11, 0, 0, 19, 
  12, 43, 34, 0, 10, 7, 84, 61, 0, 22, 
  0, 69, 0, 28, 41, 0, 20, 0, 7, 14, 
  0, 3, 6, 7, 15, 0, 0, 16, 25, 16, 
  0, 28, 0, 14, 83, 9, 21, 62, 7, 4, 
  7, 0, 53, 0, 16, 0, 0, 1, 0, 4, 
  66, 24, 50, 9, 0, 0, 69, 27, 15, 2, 
  14, 33, 3, 0, 1, 18, 73, 0, 43, 0, 
  0, 6, 26, 16, 10, 44, 0, 0, 22, 18, 
  0, 41, 77, 0, 0, 0, 0, 0, 27, 20, 
  27, 77, 56, 1, 0, 0, 53, 33, 0, 26, 
  0, 19, 15, 40, 3, 80, 27, 70, 9, 40, 
  13, 19, 51, 56, 1, 0, 62, 39, 168, 33, 
  0, 2, 112, 0, 35, 0, 0, 8, 0, 15, 
  15, 0, 16, 4, 70, 57, 0, 21, 0, 58, 
  0, 81, 74, 0, 31, 0, 4, 0, 0, 0, 
  31, 0, 5, 36, 0, 9, 25, 0, 0, 65, 
  0, 19, 22, 10, 17, 20, 19, 22, 19, 0, 
  39, 0, 23, 18, 0, 9, 5, 21, 68, 17, 
  39, 0, 0, 0, 34, 0, 67, 16, 7, 35, 
  9, 16, 42, 18, 111, 0, 19, 7, 30, 4, 
  45, 33, 26, 6, 0, 0, 14, 0, 1, 30, 
  86, 0, 9, 0, 3, 0, 26, 19, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 12, 21, 64, 6, 
  0, 0, 17, 8, 0, 10, 24, 0, 0, 65, 
  0, 74, 92, 76, 35, 40, 22, 3, 39, 33, 
  0, 0, 31, 58, 156, 6, 15, 0, 58, 0, 
  0, 0, 0, 18, 0, 18, 5, 27, 0, 0, 
  53, 31, 0, 18, 0, 0, 0, 47, 40, 0, 
  10, 0, 0, 9, 0, 6, 28, 0, 0, 0, 
  0, 7, 44, 0, 48, 45, 0, 16, 17, 16, 
  28, 6, 22, 3, 0, 16, 38, 0, 14, 0, 
  0, 13, 0, 23, 45, 25, 8, 25, 0, 0, 
  67, 0, 51, 0, 0, 39, 3, 0, 27, 11, 
  67, 0, 18, 0, 0, 0, 20, 21, 9, 43, 
  3, 0, 12, 0, 0, 0, 64, 0, 5, 0, 
  0, 0, 55, 0, 56, 59, 50, 27, 4, 0, 
  2, 0, 0, 0, 8, 0, 48, 60, 4, 28, 
  76, 49, 0, 0, 0, 6, 1, 61, 24, 0, 
  35, 40, 0, 0, 13, 0, 67, 0, 0, 0, 
  0, 0, 0, 1, 0, 66, 2, 0, 30, 28, 
  26, 42, 0, 12, 0, 69, 96, 0, 23, 0, 
  0, 0, 0, 0, 51, 0, 0, 65, 0, 8, 
  82, 0, 40, 45, 0, 20, 0, 33, 32, 0, 
  14, 3, 0, 16, 42, 0, 37, 0, 0, 30, 
  0, 27, 36, 9, 13, 0, 0, 22, 2, 0, 
  70, 5, 0, 64, 0, 23, 40, 0, 76, 0, 
  6, 0, 58, 8, 17, 40, 5, 0, 26, 0, 
  1, 0, 0, 0, 39, 0, 71, 0, 10, 9, 
  14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 39, 14, 0, 
  0, 0, 63, 31, 0, 36, 15, 0, 0, 12, 
  10, 93, 23, 78, 37, 39, 52, 0, 44, 62, 
  9, 23, 34, 48, 251, 53, 0, 0, 103, 0, 
  11, 0, 0, 19, 12, 43, 34, 0, 10, 7, 
  84, 61, 0, 22, 0, 69, 0, 28, 41, 0, 
  20, 0, 7, 14, 0, 3, 6, 7, 15, 0, 
  0, 16, 25, 16, 0, 28, 0, 14, 83, 9, 
  21, 62, 7, 4, 7, 0, 53, 0, 16, 0, 
  0, 1, 0, 4, 66, 24, 50, 9, 0, 0, 
  69, 27, 15, 2, 14, 33, 3, 0, 1, 18, 
  73, 0, 43, 0, 0, 6, 26, 16, 10, 44, 
  0, 0, 22, 18, 0, 41, 77, 0, 0, 0, 
  0, 0, 27, 20, 27, 77, 56, 1, 0, 0, 
  53, 33, 0, 26, 0, 19, 15, 40, 3, 80, 
  27, 70, 9, 40, 13, 19, 51, 56, 1, 0, 
  62, 39, 168, 33, 0, 2, 112, 0, 35, 0, 
  0, 8, 0, 15, 15, 0, 16, 4, 70, 57, 
  0, 21, 0, 58, 0, 81, 74, 0, 31, 0, 
  4, 0, 0, 0, 31, 0, 5, 36, 0, 9, 
  25, 0, 0, 65, 0, 19, 22, 10, 17, 20, 
  19, 22, 19, 0, 39, 0, 23, 18, 0, 9, 
  5, 21, 68, 17, 39, 0, 0, 0, 34, 0, 
  67, 16, 7, 35, 9, 16, 42, 18, 111, 0, 
  19, 7, 30, 4, 45, 33, 26, 6, 0, 0, 
  14, 0, 1, 30, 86, 0, 9, 0, 3, 0, 
  26, 19, 51, 73, 59, 31, 0, 25, 25, 27, 
  1, 0, 0, 49, 62, 54, 0, 17, 9, 31, 
  5, 0, 0, 97, 24, 47, 40, 0, 67, 36, 
  173, 0, 0, 93, 100, 0, 16, 5, 0, 0, 
  0, 8, 0, 0, 58, 12, 35, 124, 53, 23, 
  0, 49, 0, 76, 26, 0, 69, 0, 16, 0, 
  0, 0, 74, 49, 11, 40, 2, 17, 33, 10, 
  4, 69, 21, 19, 13, 0, 5, 0, 39, 35, 
  1, 0, 24, 0, 46, 72, 0, 11, 18, 1, 
  41, 28, 0, 0, 0, 0, 0, 0, 56, 0, 
  0, 45, 33, 55, 30, 39, 114, 0, 28, 15, 
  40, 0, 15, 24, 15, 0, 0, 0, 36, 0, 
  25, 27, 59, 0, 0, 0, 16, 0, 11, 50, 
  12, 21, 64, 6, 0, 0, 17, 8, 0, 10, 
  24, 0, 0, 65, 0, 74, 92, 76, 35, 40, 
  22, 3, 39, 33, 0, 0, 31, 58, 156, 6, 
  15, 0, 58, 0, 0, 0, 0, 18, 0, 18, 
  5, 27, 0, 0, 53, 31, 0, 18, 0, 0, 
  0, 47, 40, 0, 10, 0, 0, 9, 0, 6, 
  28, 0, 0, 0, 0, 7, 44, 0, 48, 45, 
  0, 16, 17, 16, 28, 6, 22, 3, 0, 16, 
  38, 0, 14, 0, 0, 13, 0, 23, 45, 25, 
  8, 25, 0, 0, 67, 0, 51, 0, 0, 39, 
  3, 0, 27, 11, 67, 0, 18, 0, 0, 0, 
  20, 21, 9, 43, 3, 0, 12, 0, 0, 0, 
  64, 0, 5, 0, 0, 0, 55, 0, 56, 59, 
  50, 27, 4, 0, 2, 0, 0, 0, 8, 0, 
  48, 60, 4, 28, 76, 49, 0, 0, 0, 6, 
  1, 61, 24, 0, 35, 40, 0, 0, 13, 0, 
  67, 0, 0, 0, 0, 0, 0, 1, 0, 66, 
  2, 0, 30, 28, 26, 42, 0, 12, 0, 69, 
  96, 0, 23, 0, 0, 0, 0, 0, 51, 0, 
  0, 65, 0, 8, 82, 0, 40, 45, 0, 20, 
  0, 33, 32, 0, 14, 3, 0, 16, 42, 0, 
  37, 0, 0, 30, 0, 27, 36, 9, 13, 0, 
  0, 22, 2, 0, 70, 5, 0, 64, 0, 23, 
  40, 0, 76, 0, 6, 0, 58, 8, 17, 40, 
  5, 0, 26, 0, 1, 0, 0, 0, 39, 0, 
  71, 0, 10, 9, 14, 0, 2, 55, 59, 38, 
  4, 35, 16, 13, 17, 0, 0, 16, 84, 0, 
  0, 22, 51, 18, 0, 0, 0, 56, 0, 33, 
  67, 0, 5, 30, 0, 0, 0, 43, 70, 0, 
  18, 0, 0, 0, 0, 41, 0, 35, 57, 2, 
  29, 80, 44, 19, 0, 21, 0, 34, 36, 10, 
  35, 0, 10, 0, 0, 0, 30, 26, 0, 32, 
  0, 0, 35, 1, 27, 0, 0, 17, 9, 19, 
  26, 0, 10, 16, 0, 22, 23, 0, 61, 69, 
  0, 5, 0, 0, 0, 42, 5, 0, 0, 31, 
  0, 24, 35, 0, 0, 65, 2, 0, 10, 12, 
  63, 0, 37, 0, 27, 0, 0, 14, 0, 0, 
  0, 0, 0, 0, 0, 0, 4, 0, 41, 0, 
  35, 0, 8, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 27, 77, 
  56, 1, 0, 0, 53, 33, 0, 26, 0, 19, 
  15, 40, 3, 80, 27, 70, 9, 40, 13, 19, 
  51, 56, 1, 0, 62, 39, 168, 33, 0, 2, 
  112, 0, 35, 0, 0, 8, 0, 15, 15, 0, 
  16, 4, 70, 57, 0, 21, 0, 58, 0, 81, 
  74, 0, 31, 0, 4, 0, 0, 0, 31, 0, 
  5, 36, 0, 9, 25, 0, 0, 65, 0, 19, 
  22, 10, 17, 20, 19, 22, 19, 0, 39, 0, 
  23, 18, 0, 9, 5, 21, 68, 17, 39, 0, 
  0, 0, 34, 0, 67, 16, 7, 35, 9, 16, 
  42, 18, 111, 0, 19, 7, 30, 4, 45, 33, 
  26, 6, 0, 0, 14, 0, 1, 30, 86, 0, 
  9, 0, 3, 0, 26, 19, 51, 73, 59, 31, 
  0, 25, 25, 27, 1, 0, 0, 49, 62, 54, 
  0, 17, 9, 31, 5, 0, 0, 97, 24, 47, 
  40, 0, 67, 36, 173, 0, 0, 93, 100, 0, 
  16, 5, 0, 0, 0, 8, 0, 0, 58, 12, 
  35, 124, 53, 23, 0, 49, 0, 76, 26, 0, 
  69, 0, 16, 0, 0, 0, 74, 49, 11, 40, 
  2, 17, 33, 10, 4, 69, 21, 19, 13, 0, 
  5, 0, 39, 35, 1, 0, 24, 0, 46, 72, 
  0, 11, 18, 1, 41, 28, 0, 0, 0, 0, 
  0, 0, 56, 0, 0, 45, 33, 55, 30, 39, 
  114, 0, 28, 15, 40, 0, 15, 24, 15, 0, 
  0, 0, 36, 0, 25, 27, 59, 0, 0, 0, 
  16, 0, 11, 50, 1, 0, 0, 19, 11, 92, 
  28, 0, 0, 0, 0, 57, 41, 55, 0, 0, 
  0, 21, 17, 3, 0, 71, 14, 58, 40, 0, 
  38, 15, 173, 20, 0, 66, 63, 35, 0, 0, 
  0, 0, 0, 44, 0, 0, 10, 45, 6, 158, 
  67, 62, 0, 26, 0, 54, 50, 0, 21, 0, 
  34, 0, 34, 0, 70, 66, 0, 18, 13, 4, 
  36, 35, 62, 39, 52, 9, 43, 0, 28, 0, 
  37, 0, 0, 0, 49, 0, 22, 62, 0, 0, 
  39, 14, 21, 0, 0, 25, 16, 0, 24, 37, 
  0, 0, 11, 49, 15, 31, 12, 45, 82, 9, 
  31, 0, 0, 16, 0, 14, 0, 7, 0, 44, 
  106, 21, 47, 22, 46, 0, 0, 0, 16, 0, 
  13, 16, 56, 59, 50, 27, 4, 0, 2, 0, 
  0, 0, 8, 0, 48, 60, 4, 28, 76, 49, 
  0, 0, 0, 6, 1, 61, 24, 0, 35, 40, 
  0, 0, 13, 0, 67, 0, 0, 0, 0, 0, 
  0, 1, 0, 66, 2, 0, 30, 28, 26, 42, 
  0, 12, 0, 69, 96, 0, 23, 0, 0, 0, 
  0, 0, 51, 0, 0, 65, 0, 8, 82, 0, 
  40, 45, 0, 20, 0, 33, 32, 0, 14, 3, 
  0, 16, 42, 0, 37, 0, 0, 30, 0, 27, 
  36, 9, 13, 0, 0, 22, 2, 0, 70, 5, 
  0, 64, 0, 23, 40, 0, 76, 0, 6, 0, 
  58, 8, 17, 40, 5, 0, 26, 0, 1, 0, 
  0, 0, 39, 0, 71, 0, 10, 9, 14, 0, 
  2, 55, 59, 38, 4, 35, 16, 13, 17, 0, 
  0, 16, 84, 0, 0, 22, 51, 18, 0, 0, 
  0, 56, 0, 33, 67, 0, 5, 30, 0, 0, 
  0, 43, 70, 0, 18, 0, 0, 0, 0, 41, 
  0, 35, 57, 2, 29, 80, 44, 19, 0, 21, 
  0, 34, 36, 10, 35, 0, 10, 0, 0, 0, 
  30, 26, 0, 32, 0, 0, 35, 1, 27, 0, 
  0, 17, 9, 19, 26, 0, 10, 16, 0, 22, 
  23, 0, 61, 69, 0, 5, 0, 0, 0, 42, 
  5, 0, 0, 31, 0, 24, 35, 0, 0, 65, 
  2, 0, 10, 12, 63, 0, 37, 0, 27, 0, 
  0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 
  4, 0, 41, 0, 35, 0, 8, 0, 0, 0, 
  0, 18, 14, 124, 8, 0, 7, 0, 0, 29, 
  52, 11, 0, 6, 15, 0, 0, 0, 0, 77, 
  2, 24, 40, 0, 0, 9, 0, 14, 0, 31, 
  15, 32, 0, 0, 0, 21, 0, 76, 0, 37, 
  0, 65, 12, 85, 61, 31, 0, 0, 0, 31, 
  31, 4, 2, 0, 40, 0, 18, 0, 23, 69, 
  0, 16, 12, 9, 0, 29, 58, 0, 39, 20, 
  11, 0, 25, 21, 19, 0, 0, 29, 42, 0, 
  16, 44, 15, 0, 11, 0, 0, 8, 0, 6, 
  0, 0, 4, 72, 0, 0, 0, 72, 0, 0, 
  4, 12, 57, 0, 27, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 77, 0, 47, 0, 6, 3, 
  0, 0, 55, 0, 22, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  51, 73, 59, 31, 0, 25, 25, 27, 1, 0, 
  0, 49, 62, 54, 0, 17, 9, 31, 5, 0, 
  0, 97, 24, 47, 40, 0, 67, 36, 173, 0, 
  0, 93, 100, 0, 16, 5, 0, 0, 0, 8, 
  0, 0, 58, 12, 35, 124, 53, 23, 0, 49, 
  0, 76, 26, 0, 69, 0, 16, 0, 0, 0, 
  74, 49, 11, 40, 2, 17, 33, 10, 4, 69, 
  21, 19, 13, 0, 5, 0, 39, 35, 1, 0, 
  24, 0, 46, 72, 0, 11, 18, 1, 41, 28, 
  0, 0, 0, 0, 0, 0, 56, 0, 0, 45, 
  33, 55, 30, 39, 114, 0, 28, 15, 40, 0, 
  15, 24, 15, 0, 0, 0, 36, 0, 25, 27, 
  59, 0, 0, 0, 16, 0, 11, 50, 1, 0, 
  0, 19, 11, 92, 28, 0, 0, 0, 0, 57, 
  41, 55, 0, 0, 0, 21, 17, 3, 0, 71, 
  14, 58, 40, 0, 38, 15, 173, 20, 0, 66, 
  63, 35, 0, 0, 0, 0, 0, 44, 0, 0, 
  10, 45, 6, 158, 67, 62, 0, 26, 0, 54, 
  50, 0, 21, 0, 34, 0, 34, 0, 70, 66, 
  0, 18, 13, 4, 36, 35, 62, 39, 52, 9, 
  43, 0, 28, 0, 37, 0, 0, 0, 49, 0, 
  22, 62, 0, 0, 39, 14, 21, 0, 0, 25, 
  16, 0, 24, 37, 0, 0, 11, 49, 15, 31, 
  12, 45, 82, 9, 31, 0, 0, 16, 0, 14, 
  0, 7, 0, 44, 106, 21, 47, 22, 46, 0, 
  0, 0, 16, 0, 13, 16, 0, 38, 0, 0, 
  45, 3, 47, 0, 0, 5, 2, 35, 43, 41, 
  0, 12, 6, 26, 23, 27, 41, 0, 0, 68, 
  18, 30, 36, 25, 149, 46, 0, 0, 61, 42, 
  0, 0, 0, 0, 0, 81, 0, 0, 0, 48, 
  15, 76, 31, 35, 0, 47, 0, 53, 104, 0, 
  0, 15, 21, 0, 0, 5, 36, 26, 0, 63, 
  0, 10, 50, 5, 36, 4, 6, 13, 12, 0, 
  42, 49, 0, 0, 30, 0, 84, 0, 8, 23, 
  8, 1, 28, 38, 67, 0, 15, 10, 39, 0, 
  22, 34, 0, 0, 46, 45, 0, 15, 23, 0, 
  43, 0, 19, 15, 9, 58, 9, 7, 0, 4, 
  0, 0, 41, 21, 33, 22, 54, 6, 20, 0, 
  41, 0, 6, 0, 2, 55, 59, 38, 4, 35, 
  16, 13, 17, 0, 0, 16, 84, 0, 0, 22, 
  51, 18, 0, 0, 0, 56, 0, 33, 67, 0, 
  5, 30, 0, 0, 0, 43, 70, 0, 18, 0, 
  0, 0, 0, 41, 0, 35, 57, 2, 29, 80, 
  44, 19, 0, 21, 0, 34, 36, 10, 35, 0, 
  10, 0, 0, 0, 30, 26, 0, 32, 0, 0, 
  35, 1, 27, 0, 0, 17, 9, 19, 26, 0, 
  10, 16, 0, 22, 23, 0, 61, 69, 0, 5, 
  0, 0, 0, 42, 5, 0, 0, 31, 0, 24, 
  35, 0, 0, 65, 2, 0, 10, 12, 63, 0, 
  37, 0, 27, 0, 0, 14, 0, 0, 0, 0, 
  0, 0, 0, 0, 4, 0, 41, 0, 35, 0, 
  8, 0, 0, 0, 0, 18, 14, 124, 8, 0, 
  7, 0, 0, 29, 52, 11, 0, 6, 15, 0, 
  0, 0, 0, 77, 2, 24, 40, 0, 0, 9, 
  0, 14, 0, 31, 15, 32, 0, 0, 0, 21, 
  0, 76, 0, 37, 0, 65, 12, 85, 61, 31, 
  0, 0, 0, 31, 31, 4, 2, 0, 40, 0, 
  18, 0, 23, 69, 0, 16, 12, 9, 0, 29, 
  58, 0, 39, 20, 11, 0, 25, 21, 19, 0, 
  0, 29, 42, 0, 16, 44, 15, 0, 11, 0, 
  0, 8, 0, 6, 0, 0, 4, 72, 0, 0, 
  0, 72, 0, 0, 4, 12, 57, 0, 27, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 77, 0, 
  47, 0, 6, 3, 0, 0, 55, 0, 22, 0, 
  0, 12, 0, 0, 34, 31, 37, 0, 16, 0, 
  1, 11, 52, 11, 10, 28, 23, 12, 0, 12, 
  51, 0, 0, 50, 24, 48, 0, 15, 0, 35, 
  0, 0, 38, 48, 0, 0, 0, 6, 0, 75, 
  0, 43, 0, 59, 29, 41, 15, 15, 0, 19, 
  0, 15, 107, 18, 0, 0, 17, 0, 0, 28, 
  25, 21, 0, 41, 0, 0, 45, 6, 26, 0, 
  0, 8, 0, 14, 33, 51, 4, 0, 0, 28, 
  84, 14, 0, 6, 19, 0, 12, 21, 18, 26, 
  0, 9, 9, 21, 0, 72, 0, 4, 31, 72, 
  0, 0, 2, 0, 39, 0, 26, 7, 9, 48, 
  0, 0, 0, 3, 0, 0, 39, 24, 41, 0, 
  37, 0, 84, 0, 64, 0, 13, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 1, 0, 0, 19, 11, 92, 28, 0, 
  0, 0, 0, 57, 41, 55, 0, 0, 0, 21, 
  17, 3, 0, 71, 14, 58, 40, 0, 38, 15, 
  173, 20, 0, 66, 63, 35, 0, 0, 0, 0, 
  0, 44, 0, 0, 10, 45, 6, 158, 67, 62, 
  0, 26, 0, 54, 50, 0, 21, 0, 34, 0, 
  34, 0, 70, 66, 0, 18, 13, 4, 36, 35, 
  62, 39, 52, 9, 43, 0, 28, 0, 37, 0, 
  0, 0, 49, 0, 22, 62, 0, 0, 39, 14, 
  21, 0, 0, 25, 16, 0, 24, 37, 0, 0, 
  11, 49, 15, 31, 12, 45, 82, 9, 31, 0, 
  0, 16, 0, 14, 0, 7, 0, 44, 106, 21, 
  47, 22, 46, 0, 0, 0, 16, 0, 13, 16, 
  0, 38, 0, 0, 45, 3, 47, 0, 0, 5, 
  2, 35, 43, 41, 0, 12, 6, 26, 23, 27, 
  41, 0, 0, 68, 18, 30, 36, 25, 149, 46, 
  0, 0, 61, 42, 0, 0, 0, 0, 0, 81, 
  0, 0, 0, 48, 15, 76, 31, 35, 0, 47, 
  0, 53, 104, 0, 0, 15, 21, 0, 0, 5, 
  36, 26, 0, 63, 0, 10, 50, 5, 36, 4, 
  6, 13, 12, 0, 42, 49, 0, 0, 30, 0, 
  84, 0, 8, 23, 8, 1, 28, 38, 67, 0, 
  15, 10, 39, 0, 22, 34, 0, 0, 46, 45, 
  0, 15, 23, 0, 43, 0, 19, 15, 9, 58, 
  9, 7, 0, 4, 0, 0, 41, 21, 33, 22, 
  54, 6, 20, 0, 41, 0, 6, 0, 0, 46, 
  0, 5, 8, 0, 87, 3, 13, 14, 0, 39, 
  38, 29, 17, 42, 21, 66, 26, 57, 83, 0, 
  35, 35, 10, 13, 59, 37, 156, 43, 0, 0, 
  97, 0, 28, 0, 0, 0, 0, 60, 0, 0, 
  0, 58, 6, 89, 17, 14, 0, 43, 0, 39, 
  81, 11, 0, 0, 23, 0, 0, 26, 0, 12, 
  14, 12, 0, 0, 12, 25, 19, 1, 23, 0, 
  31, 0, 56, 15, 12, 6, 36, 0, 63, 0, 
  17, 12, 2, 0, 24, 1, 58, 22, 24, 0, 
  0, 0, 11, 31, 0, 0, 72, 22, 0, 0, 
  23, 0, 40, 0, 15, 32, 13, 36, 18, 8, 
  0, 1, 0, 0, 17, 8, 16, 23, 55, 3, 
  28, 0, 23, 0, 16, 0, 0, 0, 0, 18, 
  14, 124, 8, 0, 7, 0, 0, 29, 52, 11, 
  0, 6, 15, 0, 0, 0, 0, 77, 2, 24, 
  40, 0, 0, 9, 0, 14, 0, 31, 15, 32, 
  0, 0, 0, 21, 0, 76, 0, 37, 0, 65, 
  12, 85, 61, 31, 0, 0, 0, 31, 31, 4, 
  2, 0, 40, 0, 18, 0, 23, 69, 0, 16, 
  12, 9, 0, 29, 58, 0, 39, 20, 11, 0, 
  25, 21, 19, 0, 0, 29, 42, 0, 16, 44, 
  15, 0, 11, 0, 0, 8, 0, 6, 0, 0, 
  4, 72, 0, 0, 0, 72, 0, 0, 4, 12, 
  57, 0, 27, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 77, 0, 47, 0, 6, 3, 0, 0, 
  55, 0, 22, 0, 0, 12, 0, 0, 34, 31, 
  37, 0, 16, 0, 1, 11, 52, 11, 10, 28, 
  23, 12, 0, 12, 51, 0, 0, 50, 24, 48, 
  0, 15, 0, 35, 0, 0, 38, 48, 0, 0, 
  0, 6, 0, 75, 0, 43, 0, 59, 29, 41, 
  15, 15, 0, 19, 0, 15, 107, 18, 0, 0, 
  17, 0, 0, 28, 25, 21, 0, 41, 0, 0, 
  45, 6, 26, 0, 0, 8, 0, 14, 33, 51, 
  4, 0, 0, 28, 84, 14, 0, 6, 19, 0, 
  12, 21, 18, 26, 0, 9, 9, 21, 0, 72, 
  0, 4, 31, 72, 0, 0, 2, 0, 39, 0, 
  26, 7, 9, 48, 0, 0, 0, 3, 0, 0, 
  39, 24, 41, 0, 37, 0, 84, 0, 64, 0, 
  13, 0, 0, 32, 0, 0, 20, 0, 56, 0, 
  35, 0, 0, 29, 28, 20, 52, 24, 39, 50, 
  3, 36, 95, 0, 10, 21, 21, 25, 9, 34, 
  0, 29, 0, 0, 63, 0, 10, 0, 0, 0, 
  0, 48, 0, 3, 0, 63, 16, 61, 5, 1, 
  0, 6, 0, 3, 79, 33, 0, 0, 18, 0, 
  0, 7, 0, 7, 0, 0, 0, 0, 32, 20, 
  20, 0, 0, 0, 0, 0, 62, 0, 13, 2, 
  0, 6, 67, 26, 0, 0, 6, 0, 7, 0, 
  11, 49, 18, 0, 0, 4, 0, 55, 0, 6, 
  64, 36, 0, 0, 3, 0, 34, 0, 22, 9, 
  31, 35, 0, 0, 0, 0, 0, 0, 14, 2, 
  12, 0, 45, 0, 77, 0, 41, 0, 26, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 38, 0, 0, 45, 3, 
  47, 0, 0, 5, 2, 35, 43, 41, 0, 12, 
  6, 26, 23, 27, 41, 0, 0, 68, 18, 30, 
  36, 25, 149, 46, 0, 0, 61, 42, 0, 0, 
  0, 0, 0, 81, 0, 0, 0, 48, 15, 76, 
  31, 35, 0, 47, 0, 53, 104, 0, 0, 15, 
  21, 0, 0, 5, 36, 26, 0, 63, 0, 10, 
  50, 5, 36, 4, 6, 13, 12, 0, 42, 49, 
  0, 0, 30, 0, 84, 0, 8, 23, 8, 1, 
  28, 38, 67, 0, 15, 10, 39, 0, 22, 34, 
  0, 0, 46, 45, 0, 15, 23, 0, 43, 0, 
  19, 15, 9, 58, 9, 7, 0, 4, 0, 0, 
  41, 21, 33, 22, 54, 6, 20, 0, 41, 0, 
  6, 0, 0, 46, 0, 5, 8, 0, 87, 3, 
  13, 14, 0, 39, 38, 29, 17, 42, 21, 66, 
  26, 57, 83, 0, 35, 35, 10, 13, 59, 37, 
  156, 43, 0, 0, 97, 0, 28, 0, 0, 0, 
  0, 60, 0, 0, 0, 58, 6, 89, 17, 14, 
  0, 43, 0, 39, 81, 11, 0, 0, 23, 0, 
  0, 26, 0, 12, 14, 12, 0, 0, 12, 25, 
  19, 1, 23, 0, 31, 0, 56, 15, 12, 6, 
  36, 0, 63, 0, 17, 12, 2, 0, 24, 1, 
  58, 22, 24, 0, 0, 0, 11, 31, 0, 0, 
  72, 22, 0, 0, 23, 0, 40, 0, 15, 32, 
  13, 36, 18, 8, 0, 1, 0, 0, 17, 8, 
  16, 23, 55, 3, 28, 0, 23, 0, 16, 0, 
  0, 26, 0, 19, 10, 0, 77, 11, 23, 31, 
  0, 35, 23, 57, 9, 52, 22, 74, 37, 27, 
  102, 0, 0, 31, 15, 13, 55, 46, 154, 59, 
  0, 4, 97, 0, 27, 0, 0, 0, 0, 55, 
  0, 0, 0, 52, 12, 66, 15, 9, 0, 41, 
  0, 76, 57, 46, 4, 14, 7, 0, 0, 16, 
  0, 0, 24, 8, 0, 8, 10, 17, 12, 30, 
  0, 0, 27, 0, 37, 13, 12, 0, 23, 0, 
  76, 0, 17, 2, 0, 0, 21, 18, 71, 15, 
  30, 0, 0, 0, 29, 12, 20, 0, 83, 41, 
  0, 0, 20, 0, 63, 0, 2, 35, 27, 25, 
  17, 5, 25, 0, 6, 0, 30, 0, 13, 13, 
  58, 0, 47, 0, 29, 0, 20, 0, 0, 12, 
  0, 0, 34, 31, 37, 0, 16, 0, 1, 11, 
  52, 11, 10, 28, 23, 12, 0, 12, 51, 0, 
  0, 50, 24, 48, 0, 15, 0, 35, 0, 0, 
  38, 48, 0, 0, 0, 6, 0, 75, 0, 43, 
  0, 59, 29, 41, 15, 15, 0, 19, 0, 15, 
  107, 18, 0, 0, 17, 0, 0, 28, 25, 21, 
  0, 41, 0, 0, 45, 6, 26, 0, 0, 8, 
  0, 14, 33, 51, 4, 0, 0, 28, 84, 14, 
  0, 6, 19, 0, 12, 21, 18, 26, 0, 9, 
  9, 21, 0, 72, 0, 4, 31, 72, 0, 0, 
  2, 0, 39, 0, 26, 7, 9, 48, 0, 0, 
  0, 3, 0, 0, 39, 24, 41, 0, 37, 0, 
  84, 0, 64, 0, 13, 0, 0, 32, 0, 0, 
  20, 0, 56, 0, 35, 0, 0, 29, 28, 20, 
  52, 24, 39, 50, 3, 36, 95, 0, 10, 21, 
  21, 25, 9, 34, 0, 29, 0, 0, 63, 0, 
  10, 0, 0, 0, 0, 48, 0, 3, 0, 63, 
  16, 61, 5, 1, 0, 6, 0, 3, 79, 33, 
  0, 0, 18, 0, 0, 7, 0, 7, 0, 0, 
  0, 0, 32, 20, 20, 0, 0, 0, 0, 0, 
  62, 0, 13, 2, 0, 6, 67, 26, 0, 0, 
  6, 0, 7, 0, 11, 49, 18, 0, 0, 4, 
  0, 55, 0, 6, 64, 36, 0, 0, 3, 0, 
  34, 0, 22, 9, 31, 35, 0, 0, 0, 0, 
  0, 0, 14, 2, 12, 0, 45, 0, 77, 0, 
  41, 0, 26, 0, 0, 27, 0, 15, 17, 0, 
  54, 0, 26, 19, 0, 24, 19, 41, 54, 36, 
  42, 53, 0, 29, 105, 0, 0, 24, 36, 35, 
  13, 47, 0, 36, 0, 0, 67, 9, 22, 0, 
  0, 0, 0, 30, 0, 0, 0, 58, 16, 44, 
  12, 18, 0, 3, 21, 11, 61, 51, 0, 0, 
  3, 0, 0, 16, 0, 0, 0, 0, 0, 0, 
  38, 18, 25, 0, 0, 0, 0, 0, 56, 0, 
  14, 7, 0, 10, 79, 42, 2, 0, 11, 0, 
  6, 6, 16, 33, 14, 0, 0, 12, 0, 42, 
  0, 6, 83, 38, 0, 0, 5, 0, 37, 0, 
  29, 9, 43, 27, 0, 0, 1, 0, 0, 0, 
  12, 0, 2, 0, 32, 0, 100, 0, 40, 0, 
  22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 46, 0, 5, 
  8, 0, 87, 3, 13, 14, 0, 39, 38, 29, 
  17, 42, 21, 66, 26, 57, 83, 0, 35, 35, 
  10, 13, 59, 37, 156, 43, 0, 0, 97, 0, 
  28, 0, 0, 0, 0, 60, 0, 0, 0, 58, 
  6, 89, 17, 14, 0, 43, 0, 39, 81, 11, 
  0, 0, 23, 0, 0, 26, 0, 12, 14, 12, 
  0, 0, 12, 25, 19, 1, 23, 0, 31, 0, 
  56, 15, 12, 6, 36, 0, 63, 0, 17, 12, 
  2, 0, 24, 1, 58, 22, 24, 0, 0, 0, 
  11, 31, 0, 0, 72, 22, 0, 0, 23, 0, 
  40, 0, 15, 32, 13, 36, 18, 8, 0, 1, 
  0, 0, 17, 8, 16, 23, 55, 3, 28, 0, 
  23, 0, 16, 0, 0, 26, 0, 19, 10, 0, 
  77, 11, 23, 31, 0, 35, 23, 57, 9, 52, 
  22, 74, 37, 27, 102, 0, 0, 31, 15, 13, 
  55, 46, 154, 59, 0, 4, 97, 0, 27, 0, 
  0, 0, 0, 55, 0, 0, 0, 52, 12, 66, 
  15, 9, 0, 41, 0, 76, 57, 46, 4, 14, 
  7, 0, 0, 16, 0, 0, 24, 8, 0, 8, 
  10, 17, 12, 30, 0, 0, 27, 0, 37, 13, 
  12, 0, 23, 0, 76, 0, 17, 2, 0, 0, 
  21, 18, 71, 15, 30, 0, 0, 0, 29, 12, 
  20, 0, 83, 41, 0, 0, 20, 0, 63, 0, 
  2, 35, 27, 25, 17, 5, 25, 0, 6, 0, 
  30, 0, 13, 13, 58, 0, 47, 0, 29, 0, 
  20, 0, 0, 16, 0, 14, 1, 0, 63, 29, 
  23, 32, 0, 13, 0, 45, 0, 47, 19, 68, 
  39, 6, 67, 0, 0, 42, 12, 16, 57, 47, 
  121, 62, 0, 0, 87, 0, 30, 0, 0, 0, 
  0, 41, 0, 0, 0, 17, 8, 43, 25, 0, 
  0, 37, 11, 79, 44, 41, 28, 6, 2, 20, 
  0, 16, 0, 0, 13, 18, 0, 16, 25, 5, 
  1, 40, 0, 0, 44, 0, 27, 34, 0, 0, 
  27, 0, 77, 0, 17, 14, 0, 0, 18, 24, 
  76, 0, 60, 4, 0, 4, 30, 0, 46, 0, 
  60, 49, 0, 0, 9, 0, 57, 0, 0, 18, 
  38, 31, 23, 17, 38, 0, 21, 0, 27, 0, 
  7, 10, 58, 0, 64, 0, 40, 0, 0, 0, 
  0, 32, 0, 0, 20, 0, 56, 0, 35, 0, 
  0, 29, 28, 20, 52, 24, 39, 50, 3, 36, 
  95, 0, 10, 21, 21, 25, 9, 34, 0, 29, 
  0, 0, 63, 0, 10, 0, 0, 0, 0, 48, 
  0, 3, 0, 63, 16, 61, 5, 1, 0, 6, 
  0, 3, 79, 33, 0, 0, 18, 0, 0, 7, 
  0, 7, 0, 0, 0, 0, 32, 20, 20, 0, 
  0, 0, 0, 0, 62, 0, 13, 2, 0, 6, 
  67, 26, 0, 0, 6, 0, 7, 0, 11, 49, 
  18, 0, 0, 4, 0, 55, 0, 6, 64, 36, 
  0, 0, 3, 0, 34, 0, 22, 9, 31, 35, 
  0, 0, 0, 0, 0, 0, 14, 2, 12, 0, 
  45, 0, 77, 0, 41, 0, 26, 0, 0, 27, 
  0, 15, 17, 0, 54, 0, 26, 19, 0, 24, 
  19, 41, 54, 36, 42, 53, 0, 29, 105, 0, 
  0, 24, 36, 35, 13, 47, 0, 36, 0, 0, 
  67, 9, 22, 0, 0, 0, 0, 30, 0, 0, 
  0, 58, 16, 44, 12, 18, 0, 3, 21, 11, 
  61, 51, 0, 0, 3, 0, 0, 16, 0, 0, 
  0, 0, 0, 0, 38, 18, 25, 0, 0, 0, 
  0, 0, 56, 0, 14, 7, 0, 10, 79, 42, 
  2, 0, 11, 0, 6, 6, 16, 33, 14, 0, 
  0, 12, 0, 42, 0, 6, 83, 38, 0, 0, 
  5, 0, 37, 0, 29, 9, 43, 27, 0, 0, 
  1, 0, 0, 0, 12, 0, 2, 0, 32, 0, 
  100, 0, 40, 0, 22, 0, 0, 22, 0, 0, 
  8, 0, 32, 0, 33, 28, 0, 1, 0, 29, 
  40, 48, 56, 56, 12, 13, 56, 0, 0, 29, 
  28, 42, 16, 56, 0, 19, 0, 0, 57, 2, 
  6, 0, 0, 0, 0, 24, 0, 0, 0, 16, 
  1, 14, 21, 10, 0, 5, 37, 5, 41, 38, 
  0, 11, 0, 24, 0, 42, 0, 0, 0, 0, 
  0, 0, 70, 24, 23, 0, 0, 0, 11, 21, 
  44, 0, 8, 0, 0, 12, 70, 39, 7, 8, 
  19, 29, 0, 28, 16, 3, 38, 30, 0, 36, 
  4, 7, 0, 4, 60, 56, 0, 0, 5, 0, 
  33, 0, 12, 9, 35, 35, 0, 12, 2, 0, 
  10, 0, 0, 0, 0, 0, 6, 0, 111, 0, 
  30, 0, 9, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 26, 
  0, 19, 10, 0, 77, 11, 23, 31, 0, 35, 
  23, 57, 9, 52, 22, 74, 37, 27, 102, 0, 
  0, 31, 15, 13, 55, 46, 154, 59, 0, 4, 
  97, 0, 27, 0, 0, 0, 0, 55, 0, 0, 
  0, 52, 12, 66, 15, 9, 0, 41, 0, 76, 
  57, 46, 4, 14, 7, 0, 0, 16, 0, 0, 
  24, 8, 0, 8, 10, 17, 12, 30, 0, 0, 
  27, 0, 37, 13, 12, 0, 23, 0, 76, 0, 
  17, 2, 0, 0, 21, 18, 71, 15, 30, 0, 
  0, 0, 29, 12, 20, 0, 83, 41, 0, 0, 
  20, 0, 63, 0, 2, 35, 27, 25, 17, 5, 
  25, 0, 6, 0, 30, 0, 13, 13, 58, 0, 
  47, 0, 29, 0, 20, 0, 0, 16, 0, 14, 
  1, 0, 63, 29, 23, 32, 0, 13, 0, 45, 
  0, 47, 19, 68, 39, 6, 67, 0, 0, 42, 
  12, 16, 57, 47, 121, 62, 0, 0, 87, 0, 
  30, 0, 0, 0, 0, 41, 0, 0, 0, 17, 
  8, 43, 25, 0, 0, 37, 11, 79, 44, 41, 
  28, 6, 2, 20, 0, 16, 0, 0, 13, 18, 
  0, 16, 25, 5, 1, 40, 0, 0, 44, 0, 
  27, 34, 0, 0, 27, 0, 77, 0, 17, 14, 
  0, 0, 18, 24, 76, 0, 60, 4, 0, 4, 
  30, 0, 46, 0, 60, 49, 0, 0, 9, 0, 
  57, 0, 0, 18, 38, 31, 23, 17, 38, 0, 
  21, 0, 27, 0, 7, 10, 58, 0, 64, 0, 
  40, 0, 0, 0, 0, 26, 0, 7, 2, 0, 
  63, 38, 23, 37, 2, 6, 0, 40, 0, 45, 
  6, 67, 46, 14, 38, 0, 0, 48, 16, 24, 
  55, 58, 112, 45, 0, 0, 68, 0, 26, 0, 
  0, 0, 0, 44, 0, 0, 0, 2, 1, 25, 
  39, 0, 0, 36, 14, 72, 25, 35, 35, 0, 
  0, 49, 0, 21, 0, 0, 16, 34, 0, 26, 
  35, 0, 2, 44, 0, 0, 64, 0, 29, 35, 
  0, 1, 39, 0, 66, 5, 11, 30, 0, 6, 
  14, 27, 89, 0, 74, 5, 0, 3, 35, 0, 
  49, 0, 45, 48, 0, 0, 10, 0, 56, 0, 
  0, 23, 42, 24, 30, 23, 39, 0, 31, 0, 
  11, 0, 7, 13, 40, 0, 62, 0, 52, 0, 
  0, 2, 0, 27, 0, 15, 17, 0, 54, 0, 
  26, 19, 0, 24, 19, 41, 54, 36, 42, 53, 
  0, 29, 105, 0, 0, 24, 36, 35, 13, 47, 
  0, 36, 0, 0, 67, 9, 22, 0, 0, 0, 
  0, 30, 0, 0, 0, 58, 16, 44, 12, 18, 
  0, 3, 21, 11, 61, 51, 0, 0, 3, 0, 
  0, 16, 0, 0, 0, 0, 0, 0, 38, 18, 
  25, 0, 0, 0, 0, 0, 56, 0, 14, 7, 
  0, 10, 79, 42, 2, 0, 11, 0, 6, 6, 
  16, 33, 14, 0, 0, 12, 0, 42, 0, 6, 
  83, 38, 0, 0, 5, 0, 37, 0, 29, 9, 
  43, 27, 0, 0, 1, 0, 0, 0, 12, 0, 
  2, 0, 32, 0, 100, 0, 40, 0, 22, 0, 
  0, 22, 0, 0, 8, 0, 32, 0, 33, 28, 
  0, 1, 0, 29, 40, 48, 56, 56, 12, 13, 
  56, 0, 0, 29, 28, 42, 16, 56, 0, 19, 
  0, 0, 57, 2, 6, 0, 0, 0, 0, 24, 
  0, 0, 0, 16, 1, 14, 21, 10, 0, 5, 
  37, 5, 41, 38, 0, 11, 0, 24, 0, 42, 
  0, 0, 0, 0, 0, 0, 70, 24, 23, 0, 
  0, 0, 11, 21, 44, 0, 8, 0, 0, 12, 
  70, 39, 7, 8, 19, 29, 0, 28, 16, 3, 
  38, 30, 0, 36, 4, 7, 0, 4, 60, 56, 
  0, 0, 5, 0, 33, 0, 12, 9, 35, 35, 
  0, 12, 2, 0, 10, 0, 0, 0, 0, 0, 
  6, 0, 111, 0, 30, 0, 9, 0, 0, 40, 
  0, 0, 15, 0, 26, 0, 40, 45, 1, 0, 
  0, 24, 16, 54, 51, 59, 27, 8, 15, 0, 
  0, 41, 35, 63, 9, 78, 0, 0, 8, 0, 
  21, 0, 0, 0, 0, 0, 0, 35, 0, 0, 
  0, 0, 0, 0, 38, 0, 0, 5, 22, 8, 
  24, 27, 0, 0, 0, 65, 0, 36, 0, 0, 
  0, 33, 0, 2, 97, 14, 35, 0, 0, 0, 
  20, 36, 43, 5, 0, 0, 0, 9, 52, 53, 
  0, 20, 31, 37, 0, 46, 33, 0, 42, 41, 
  0, 48, 0, 0, 2, 16, 45, 62, 0, 0, 
  12, 0, 34, 0, 0, 17, 24, 34, 0, 27, 
  0, 0, 25, 0, 0, 14, 10, 0, 0, 8, 
  110, 0, 42, 0, 17, 9, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 16, 0, 14, 1, 0, 63, 29, 23, 32, 
  0, 13, 0, 45, 0, 47, 19, 68, 39, 6, 
  67, 0, 0, 42, 12, 16, 57, 47, 121, 62, 
  0, 0, 87, 0, 30, 0, 0, 0, 0, 41, 
  0, 0, 0, 17, 8, 43, 25, 0, 0, 37, 
  11, 79, 44, 41, 28, 6, 2, 20, 0, 16, 
  0, 0, 13, 18, 0, 16, 25, 5, 1, 40, 
  0, 0, 44, 0, 27, 34, 0, 0, 27, 0, 
  77, 0, 17, 14, 0, 0, 18, 24, 76, 0, 
  60, 4, 0, 4, 30, 0, 46, 0, 60, 49, 
  0, 0, 9, 0, 57, 0, 0, 18, 38, 31, 
  23, 17, 38, 0, 21, 0, 27, 0, 7, 10, 
  58, 0, 64, 0, 40, 0, 0, 0, 0, 26, 
  0, 7, 2, 0, 63, 38, 23, 37, 2, 6, 
  0, 40, 0, 45, 6, 67, 46, 14, 38, 0, 
  0, 48, 16, 24, 55, 58, 112, 45, 0, 0, 
  68, 0, 26, 0, 0, 0, 0, 44, 0, 0, 
  0, 2, 1, 25, 39, 0, 0, 36, 14, 72, 
  25, 35, 35, 0, 0, 49, 0, 21, 0, 0, 
  16, 34, 0, 26, 35, 0, 2, 44, 0, 0, 
  64, 0, 29, 35, 0, 1, 39, 0, 66, 5, 
  11, 30, 0, 6, 14, 27, 89, 0, 74, 5, 
  0, 3, 35, 0, 49, 0, 45, 48, 0, 0, 
  10, 0, 56, 0, 0, 23, 42, 24, 30, 23, 
  39, 0, 31, 0, 11, 0, 7, 13, 40, 0, 
  62, 0, 52, 0, 0, 2, 0, 45, 0, 0, 
  0, 0, 62, 43, 22, 57, 2, 15, 0, 41, 
  7, 47, 6, 61, 60, 24, 15, 0, 0, 43, 
  26, 39, 53, 69, 110, 31, 0, 0, 54, 0, 
  28, 0, 0, 0, 0, 53, 0, 0, 0, 0, 
  3, 7, 35, 0, 0, 41, 15, 67, 26, 42, 
  26, 0, 0, 57, 0, 32, 0, 0, 14, 45, 
  0, 35, 43, 0, 0, 32, 0, 1, 56, 0, 
  32, 31, 0, 8, 48, 0, 66, 25, 6, 25, 
  12, 12, 17, 31, 106, 0, 60, 5, 0, 7, 
  27, 0, 51, 1, 26, 50, 0, 0, 24, 0, 
  67, 0, 2, 18, 45, 33, 35, 9, 30, 0, 
  39, 0, 0, 6, 16, 9, 41, 0, 67, 0, 
  44, 0, 11, 14, 0, 22, 0, 0, 8, 0, 
  32, 0, 33, 28, 0, 1, 0, 29, 40, 48, 
  56, 56, 12, 13, 56, 0, 0, 29, 28, 42, 
  16, 56, 0, 19, 0, 0, 57, 2, 6, 0, 
  0, 0, 0, 24, 0, 0, 0, 16, 1, 14, 
  21, 10, 0, 5, 37, 5, 41, 38, 0, 11, 
  0, 24, 0, 42, 0, 0, 0, 0, 0, 0, 
  70, 24, 23, 0, 0, 