import configvalues as conf
import values

import getopt
import os
import sys



_OPTIONS = "x:y:"
_LONGOPTIONS = ["dpi=", "skin=", "opaque", "screenshot", "dontsave",
                "first-day=", "numerals=", "no-ewmh", "help"]

_USAGE = """
Usage: gdeskcal [-x <x>] [-y <y>] [--skin=<skinname>] [--opaque|--screenshot]
                [--dontsave] [--first-day=<number>] [--dpi=<resolution>]
                [--numerals=<value>] [--no-ewmh] [--help]"""



#
# Displays the usage text and exits.
#
def usage():

    print _USAGE
    sys.exit(1)




#
# Parses the given command line options and adjusts the given configuration.
#
def parse(cmdline, config):

    try:
        opts, nil = getopt.getopt(cmdline, _OPTIONS, _LONGOPTIONS)
    except:
        raise StandardError


    for o, a in opts:
        if (o in ["--skin"]):
            config.set_offset([conf.SKIN])
            config.clear()
            config.load(os.path.join(values.SKINDIR, a, values.SKINFILE),
                        [os.environ.get(values.SKINPATH, "")])
            config.set_offset([])

        elif (o in ["--dpi"]):
            config.set([conf.TEMPORARY, conf.DPI], float(a))
            
        elif (o in ["--opaque"]):
            config.set([conf.TEMPORARY, conf.TRANSPARENCY], "0")

        elif (o in ["--screenshot"]):
            config.set([conf.TEMPORARY, conf.TRANSPARENCY], "1")

        elif (o in ["--dontsave"]):
            config.set([conf.TEMPORARY, conf.SAVE_CHANGES], "0")

        elif (o in ["--no-ewmh"]):
            config.set([conf.TEMPORARY, conf.USE_EWMH], "0")

        elif (o in ["--first-day"]):
            day = min(7, max(1, int(a)))
            config.set([conf.BEHAVIOUR, conf.FIRST_DAY], day - 1)

        elif (o in ["--numerals"]):
            config.set([conf.BEHAVIOUR, conf.NATIONAL_NUMERALS],
                       (a.lower() == "national"))

        elif (o in ["-x"]):
            config.set([conf.GEOMETRY, conf.WINDOW, conf.X], int(a))
            
        elif (o in ["-y"]):
            config.set([conf.GEOMETRY, conf.WINDOW, conf.Y], int(a))

        elif (o in ["--help"]):
            usage()

    #end for
