/*
 * Cheops Network User Interface
 *
 * Copyright (C) 1999, Adtran, Inc.
 * 
 * Distributed under the terms of the GNU GPL
 *
 */


#ifndef __GTK_LINK_H
#define __GTK_LINK_H
#include <gdk/gdk.h>
#include <gtk/gtkmisc.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GTK_LINK(obj)          GTK_CHECK_CAST (obj, gtk_link_get_type (), GtkLink)
#define GTK_LINK_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, gtk_link_get_type (), GtkLinkClass)
#define GTK_IS_LINK(obj)       GTK_CHECK_TYPE (obj, gtk_link_get_type ())

typedef struct _GtkLink        GtkLink;
typedef struct _GtkLinkClass   GtkLinkClass;

struct _GtkLink {
	GtkMisc misc;
	/* Coordinates we're connecting */
	int x1;
	int y1;
	int x2;
	int y2;
	int xos;
	int yos;
};

struct _GtkLinkClass {
	GtkMiscClass parent_class;
};

guint 		gtk_link_get_type (void);
GtkWidget*	gtk_link_new(void);
void		gtk_link_set_coords(GtkLink *, int, int, int, int);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
