#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

from fenrirscreenreader.core.i18n import _
from fenrirscreenreader.utils import char_utils


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _(
            "Move Review to the end of current line and display the content"
        )

    def run(self):
        # Check if we're in table mode first
        is_table_mode = self.env["runtime"]["TableManager"].is_table_mode()
        if is_table_mode:
            table_info = self.env["runtime"]["TableManager"].move_to_last_cell()
            if table_info:
                output_text = (
                    f"{table_info['cell_content']} {table_info['column_header']}"
                )
                self.env["runtime"]["OutputManager"].present_text(
                    output_text, interrupt=True, flush=False
                )
                self.env["runtime"]["OutputManager"].present_text(
                    _("last cell"), interrupt=False
                )
            else:
                self.env["runtime"]["OutputManager"].present_text(
                    _("no table data"), interrupt=True, flush=False
                )
            return
        
        # Regular line end navigation (when not in table mode)
        cursor_pos = self.env["runtime"][
            "CursorManager"
        ].get_review_or_text_cursor()
        self.env["runtime"]["CursorManager"].set_review_cursor_position(
            self.env["screen"]["columns"] - 1, cursor_pos["y"]
        )
        (
            self.env["screen"]["newCursorReview"]["x"],
            self.env["screen"]["newCursorReview"]["y"],
            curr_char,
        ) = char_utils.get_current_char(
            self.env["screen"]["newCursorReview"]["x"],
            self.env["screen"]["newCursorReview"]["y"],
            self.env["screen"]["new_content_text"],
        )

        self.env["runtime"]["OutputManager"].present_text(
            curr_char,
            interrupt=True,
            ignore_punctuation=True,
            announce_capital=True,
            flush=False,
        )
        self.env["runtime"]["OutputManager"].present_text(
            _("end of line"), interrupt=False
        )

    def set_callback(self, callback):
        pass
