/*
 * FCML - Free Code Manipulation Library.
 * Copyright (C) 2010-2015 Slawomir Wojtasiak
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <fcml_assembler.h>
#include "instructions_m_t.h"
#include "instructions_base_t.h"

fcml_bool fcml_tf_instructions_m_suite_init(void) {
	return FCML_TRUE;
}

fcml_bool fcml_tf_instructions_m_suite_cleanup(void) {
	return FCML_TRUE;
}

void fcml_tf_instruction_MASKMOVQ(void) {
    FCML_I64( "maskmovq mm3,mm0", 0x0F, 0xF7, 0xD8 );
    FCML_I32( "maskmovq mm4,mm0", 0x0F, 0xF7, 0xE0 );
    FCML_I32_FAILED( "FAIL", 0x0F, 0xF7, 0x40, 0x20 );

    FCML_A64( "maskmovq %mm0,%mm3", 0x0f, 0xf7, 0xd8 );
}

void fcml_tf_instruction_MASKMOVDQU(void) {
    FCML_I64( "maskmovdqu xmm3,xmm0", 0x66, 0x0F, 0xF7, 0xD8 );
    FCML_I32( "maskmovdqu xmm4,xmm0", 0x66, 0x0F, 0xF7, 0xE0 );
    FCML_I32_FAILED( "FAIL", 0x66, 0x0F, 0xF7, 0x40, 0x20 );

    FCML_I3264( "vmaskmovdqu xmm3,xmm0", 0xc5, 0xf9, 0xf7, 0xd8 );

	FCML_A3264( "maskmovdqu %xmm0,%xmm3", 0x66, 0x0f, 0xf7, 0xd8 );
	FCML_A3264( "vmaskmovdqu %xmm0,%xmm3", 0xc5, 0xf9, 0xf7, 0xd8 );
}

void fcml_tf_instruction_MAXPD(void) {
    FCML_I64( "maxpd xmm0,xmmword ptr [rax+0000000000000020h]", 0x66, 0x0F, 0x5F, 0x40, 0x20 );
    FCML_I32( "maxpd xmm0,xmm2", 0x66, 0x0F, 0x5F, 0xC2 );
    FCML_I32( "maxpd xmm0,xmmword ptr [eax+00000020h]", 0x66, 0x0F, 0x5F, 0x40, 0x20 );

    FCML_I64( "vmaxpd xmm3,xmm0,xmm0", 0xc5, 0xf9, 0x5f, 0xd8 );
    FCML_I32( "vmaxpd ymm3,ymm0,ymm0", 0xc5, 0xfd, 0x5f, 0xd8 );
    FCML_I32( "vmaxpd ymm3,ymm3,ymmword ptr [eax]", 0xc5, 0xe5, 0x5f, 0x18 );

    FCML_A64( "maxpd 0x0000000000000020(%rax),%xmm0", 0x66, 0x0f, 0x5f, 0x40, 0x20 );
    FCML_A64( "vmaxpd %xmm0,%xmm0,%xmm3", 0xc5, 0xf9, 0x5f, 0xd8 );
}

void fcml_tf_instruction_MAXPS(void) {
    FCML_I64( "maxps xmm0,xmmword ptr [rax+0000000000000020h]", 0x0F, 0x5F, 0x40, 0x20 );
    FCML_I32( "maxps xmm0,xmm2", 0x0F, 0x5F, 0xC2 );
    FCML_I32( "maxps xmm0,xmmword ptr [eax+00000020h]", 0x0F, 0x5F, 0x40, 0x20 );

    FCML_I64( "vmaxps xmm3,xmm0,xmm0", 0xc5, 0xf8, 0x5f, 0xd8 );
    FCML_I32( "vmaxps ymm3,ymm0,ymm0", 0xc5, 0xfc, 0x5f, 0xd8 );
    FCML_I32( "vmaxps ymm3,ymm3,ymmword ptr [eax]", 0xc5, 0xe4, 0x5f, 0x18 );

    FCML_A64( "maxps 0x0000000000000020(%rax),%xmm0", 0x0f, 0x5f, 0x40, 0x20 );
    FCML_A64( "vmaxps %xmm0,%xmm0,%xmm3", 0xc5, 0xf8, 0x5f, 0xd8 );
}

void fcml_tf_instruction_MAXSD(void) {
    FCML_I64( "maxsd xmm0,mmword ptr [rax+0000000000000020h]", 0xF2, 0x0F, 0x5F, 0x40, 0x20 );
    FCML_I32( "maxsd xmm0,xmm2", 0xF2, 0x0F, 0x5F, 0xC2 );
    FCML_I32( "maxsd xmm0,mmword ptr [eax+00000020h]", 0xF2, 0x0F, 0x5F, 0x40, 0x20 );

    FCML_I64( "vmaxsd xmm3,xmm3,xmm0", 0xc5, 0xe3, 0x5f, 0xd8 );
    FCML_I32( "vmaxsd xmm3,xmm7,xmm0", 0xc5, 0xc3, 0x5f, 0xd8 );
    FCML_I32_A( "vmaxsd long_form xmm3,xmm7,xmm0", 0xc4, 0xe1, 0x43, 0x5f, 0xd8 );
    FCML_I32( "vmaxsd xmm3,xmm0,mmword ptr [eax]", 0xc5, 0xfb, 0x5f, 0x18 );

    FCML_A64( "maxsd 0x0000000000000020(%rax),%xmm0", 0xf2, 0x0f, 0x5f, 0x40, 0x20 );
    FCML_A64( "vmaxsd %xmm0,%xmm3,%xmm3", 0xc5, 0xe3, 0x5f, 0xd8 );
}

void fcml_tf_instruction_MAXSS(void) {
    FCML_I64( "maxss xmm0,dword ptr [rax+0000000000000020h]", 0xF3, 0x0F, 0x5F, 0x40, 0x20 );
    FCML_I32( "maxss xmm0,xmm2", 0xF3, 0x0F, 0x5F, 0xC2 );
    FCML_I32( "maxss xmm0,dword ptr [eax+00000020h]", 0xF3, 0x0F, 0x5F, 0x40, 0x20 );

    FCML_I64( "vmaxss xmm3,xmm3,xmm0", 0xc5, 0xe2, 0x5f, 0xd8 );
    FCML_I32( "vmaxss xmm3,xmm7,xmm0", 0xc5, 0xc2, 0x5f, 0xd8 );
    FCML_I32( "vmaxss xmm3,xmm0,dword ptr [eax]", 0xc5, 0xfa, 0x5f, 0x18 );

    FCML_A64( "maxss 0x0000000000000020(%rax),%xmm0", 0xf3, 0x0f, 0x5f, 0x40, 0x20 );
    FCML_A64( "vmaxss %xmm0,%xmm3,%xmm3", 0xc5, 0xe2, 0x5f, 0xd8 );
}

void fcml_tf_instruction_MFENCE(void) {
    FCML_I3264( "mfence", 0x0F, 0xAE, 0xF0 );

    FCML_A64( "mfence", 0x0f, 0xae, 0xf0 );
}

void fcml_tf_instruction_MINPD(void) {
    FCML_I64( "minpd xmm0,xmmword ptr [rax+0000000000000020h]", 0x66, 0x0F, 0x5D, 0x40, 0x20 );
    FCML_I32( "minpd xmm0,xmm2", 0x66, 0x0F, 0x5D, 0xC2 );
    FCML_I32( "minpd xmm0,xmmword ptr [eax+00000020h]", 0x66, 0x0F, 0x5D, 0x40, 0x20 );

    FCML_I64( "vminpd xmm3,xmm0,xmm0", 0xc5, 0xf9, 0x5d, 0xd8 );
    FCML_I32( "vminpd ymm3,ymm0,ymm0", 0xc5, 0xfd, 0x5d, 0xd8 );
    FCML_I32( "vminpd ymm3,ymm3,ymmword ptr [eax]", 0xc5, 0xe5, 0x5d, 0x18 );

    FCML_A64( "minpd 0x0000000000000020(%rax),%xmm0", 0x66, 0x0f, 0x5d, 0x40, 0x20 );
    FCML_A64( "vminpd %xmm0,%xmm0,%xmm3", 0xc5, 0xf9, 0x5d, 0xd8 );
}

void fcml_tf_instruction_MINPS(void) {
    FCML_I64( "minps xmm0,xmmword ptr [rax+0000000000000020h]", 0x0F, 0x5D, 0x40, 0x20 );
    FCML_I32( "minps xmm0,xmm2", 0x0F, 0x5D, 0xC2 );
    FCML_I32( "minps xmm0,xmmword ptr [eax+00000020h]", 0x0F, 0x5D, 0x40, 0x20 );

    FCML_I64( "vminps xmm3,xmm0,xmm0", 0xc5, 0xf8, 0x5d, 0xd8 );
    FCML_I32( "vminps ymm3,ymm0,ymm0", 0xc5, 0xfc, 0x5d, 0xd8 );
    FCML_I32( "vminps ymm3,ymm3,ymmword ptr [eax]", 0xc5, 0xe4, 0x5d, 0x18 );

    FCML_A64( "minps 0x0000000000000020(%rax),%xmm0", 0x0f, 0x5d, 0x40, 0x20 );
    FCML_A64( "vminps %xmm0,%xmm0,%xmm3", 0xc5, 0xf8, 0x5d, 0xd8 );
}

void fcml_tf_instruction_MINSD(void) {
    FCML_I64( "minsd xmm0,mmword ptr [rax+0000000000000020h]", 0xF2, 0x0F, 0x5D, 0x40, 0x20 );
    FCML_I32( "minsd xmm0,xmm2", 0xF2, 0x0F, 0x5D, 0xC2 );
    FCML_I32( "minsd xmm0,mmword ptr [eax+00000020h]", 0xF2, 0x0F, 0x5D, 0x40, 0x20 );

    FCML_I64( "vminsd xmm3,xmm0,xmm0", 0xc5, 0xfb, 0x5d, 0xd8 );
    FCML_I32( "vminsd xmm3,xmm0,xmm0", 0xc5, 0xfb, 0x5d, 0xd8 );
    FCML_I32( "vminsd xmm3,xmm3,mmword ptr [eax]", 0xc5, 0xe3, 0x5d, 0x18 );

    FCML_A64( "minsd 0x0000000000000020(%rax),%xmm0", 0xf2, 0x0f, 0x5d, 0x40, 0x20 );
    FCML_A64( "vminsd %xmm0,%xmm0,%xmm3", 0xc5, 0xfb, 0x5d, 0xd8 );
}

void fcml_tf_instruction_MINSS(void) {
    FCML_I64( "minss xmm0,dword ptr [rax+0000000000000020h]", 0xF3, 0x0F, 0x5D, 0x40, 0x20 );
    FCML_I32( "minss xmm0,xmm2", 0xF3, 0x0F, 0x5D, 0xC2 );
    FCML_I32( "minss xmm0,dword ptr [eax+00000020h]", 0xF3, 0x0F, 0x5D, 0x40, 0x20 );

    FCML_I64( "vminss xmm3,xmm0,xmm0", 0xc5, 0xfa, 0x5d, 0xd8 );
    FCML_I32( "vminss xmm3,xmm0,xmm0", 0xc5, 0xfa, 0x5d, 0xd8 );

    FCML_A64( "minss 0x0000000000000020(%rax),%xmm0", 0xf3, 0x0f, 0x5d, 0x40, 0x20 );
    FCML_A64( "vminss %xmm0,%xmm0,%xmm3", 0xc5, 0xfa, 0x5d, 0xd8 );
}

void fcml_tf_instruction_MONITOR(void) {
    FCML_I64( "monitor rax,rcx,rdx", 0x0F, 0x01, 0xC8 );
    FCML_I32_A( "monitor", 0x0F, 0x01, 0xC8 );

    FCML_A64( "monitor %rax,%rcx,%rdx", 0x0f, 0x01, 0xc8 );
    FCML_I32_A( "monitor", 0x0F, 0x01, 0xC8 );
}

void fcml_tf_instruction_MOV(void) {

	FCML_I32( "mov eax,dr2", 0x0F, 0x21, 0xD0 );
    FCML_I32( "mov eax,dr2", 0x66, 0x0F, 0x21, 0xD0 );

    FCML_I64_D( "mov rax,dr2", 0x66, 0x0F, 0x21, 0xD0 );
    FCML_I64_D( "mov rax,dr2", 0x48, 0x0F, 0x21, 0xD0 );
    FCML_I64( "mov rax,dr2", 0x0F, 0x21, 0xD0 );

    FCML_I32( "mov dr2,eax", 0x0F, 0x23, 0xD0 );
    FCML_I32( "mov dr2,eax", 0x66, 0x0F, 0x23, 0xD0 );

    FCML_I64_D( "mov dr2,rax", 0x66, 0x0F, 0x23, 0xD0 );
    FCML_I64_D( "mov dr2,rax", 0x48, 0x0F, 0x23, 0xD0 );
    FCML_I64( "mov dr2,rax", 0x0F, 0x23, 0xD0 );

    FCML_A64( "mov %db2,%rax", 0x0f, 0x21, 0xd0 );
    FCML_A64( "mov %rax,%db2", 0x0f, 0x23, 0xd0 );

    FCML_I32( "mov eax,dr0", 0x0F, 0x21, 0xC0 );
    FCML_I32( "mov eax,dr1", 0x0F, 0x21, 0xC8 );
    FCML_I32( "mov eax,dr2", 0x0F, 0x21, 0xD0 );
    FCML_I32( "mov eax,dr3", 0x0F, 0x21, 0xD8 );
    FCML_I32( "mov eax,dr4", 0x0F, 0x21, 0xE0 );
    FCML_I32( "mov eax,dr5", 0x0F, 0x21, 0xE8 );
    FCML_I32( "mov eax,dr6", 0x0F, 0x21, 0xF0 );
    FCML_I32( "mov eax,dr7", 0x0F, 0x21, 0xF8 );
    FCML_I64_D( "mov rax,<unknown DR>", 0x44, 0x0F, 0x21, 0xC0 );
    FCML_I64_D( "mov rax,<unknown DR>", 0x44, 0x0F, 0x21, 0xC8 );
    FCML_I64_D( "mov rax,<unknown DR>", 0x44, 0x0F, 0x21, 0xD0 );
    FCML_I64_D( "mov rax,<unknown DR>", 0x44, 0x0F, 0x21, 0xD8 );
    FCML_I64_D( "mov rax,<unknown DR>", 0x44, 0x0F, 0x21, 0xE0 );
    FCML_I64_D( "mov rax,<unknown DR>", 0x44, 0x0F, 0x21, 0xE8 );
    FCML_I64_D( "mov rax,<unknown DR>", 0x44, 0x0F, 0x21, 0xF0 );
    FCML_I64_D( "mov rax,<unknown DR>", 0x44, 0x0F, 0x21, 0xF8 );

    FCML_I32( "mov eax,cr2", 0x0F, 0x20, 0xD0 );
    FCML_I32( "mov eax,cr2", 0x66, 0x0F, 0x20, 0xD0 );

    FCML_I64_D( "mov rax,cr2", 0x66, 0x0F, 0x20, 0xD0 );
    FCML_I64_D( "mov rax,cr2", 0x48, 0x0F, 0x20, 0xD0 );
    FCML_I64( "mov rax,cr2", 0x0F, 0x20, 0xD0 );

    FCML_I32( "mov cr2,eax", 0x0F, 0x22, 0xD0 );
    FCML_I32_D( "mov cr2,eax", 0x66, 0x0F, 0x22, 0xD0 );

    FCML_I64_D( "mov cr2,rax", 0x66, 0x0F, 0x22, 0xD0 );
    FCML_I64_D( "mov cr2,rax", 0x48, 0x0F, 0x22, 0xD0 );
    FCML_I64( "mov cr2,rax", 0x0F, 0x22, 0xD0 );
    FCML_I32_D( "mov eax,cr0", 0x0F, 0x20, 0xC0 );
    FCML_I32_D( "mov eax,<unknown CR>", 0x0F, 0x20, 0xC8 );
    FCML_I32_D( "mov eax,cr2", 0x0F, 0x20, 0xD0 );
    FCML_I32_D( "mov eax,cr3", 0x0F, 0x20, 0xD8 );
    FCML_I32_D( "mov eax,cr4", 0x0F, 0x20, 0xE0 );
    FCML_I32_D( "mov eax,<unknown CR>", 0x0F, 0x20, 0xE8 );
    FCML_I32_D( "mov eax,<unknown CR>", 0x0F, 0x20, 0xF0 );
    FCML_I32_D( "mov eax,<unknown CR>", 0x0F, 0x20, 0xF8 );
    FCML_I64_D( "mov rax,cr8", 0x44, 0x0F, 0x20, 0xC0 );
    FCML_I64_D( "mov rax,<unknown CR>", 0x44, 0x0F, 0x20, 0xC8 );
    FCML_I64_D( "mov rax,<unknown CR>", 0x44, 0x0F, 0x20, 0xD0 );
    FCML_I64_D( "mov rax,<unknown CR>", 0x44, 0x0F, 0x20, 0xD8 );
    FCML_I64_D( "mov rax,<unknown CR>", 0x44, 0x0F, 0x20, 0xE0 );
    FCML_I64_D( "mov rax,<unknown CR>", 0x44, 0x0F, 0x20, 0xE8 );
    FCML_I64_D( "mov rax,<unknown CR>", 0x44, 0x0F, 0x20, 0xF0 );
    FCML_I64_D( "mov rax,<unknown CR>", 0x44, 0x0F, 0x20, 0xF8 );

    FCML_A64( "mov %cr2,%rax", 0x0f, 0x20, 0xd0 );
    FCML_A64( "mov %rax,%cr2", 0x0f, 0x22, 0xd0 );

    FCML_I64_D( "mov byte ptr [rax],dl", 0x48, 0x88, 0x10 );
    FCML_I64( "mov byte ptr [rax],dl", 0x88, 0x10 );
    FCML_I32( "mov byte ptr [eax],dl", 0x88, 0x10 );
    FCML_I32( "xrelease mov byte ptr [eax],dl", 0xF3, 0x88, 0x10 );
    FCML_I32_A_FAILED( "xacquire mov byte ptr [eax],dl", 0xF2, 0x88, 0x10 );

    FCML_A64( "mov %dl,(%rax)", 0x88, 0x10 );
    FCML_A64( "xrelease mov %dl,(%rax)", 0xf3, 0x88, 0x10 );

    FCML_I64( "mov qword ptr [rax],rdx", 0x48, 0x89, 0x10 );
    FCML_I32( "mov dword ptr [eax],edx", 0x89, 0x10 );
    FCML_I32( "mov word ptr [eax],dx", 0x66, 0x89, 0x10 );
    FCML_I32( "xrelease mov word ptr [eax],dx", 0xF3, 0x66, 0x89, 0x10 );
    FCML_I32_A_FAILED( "xacquire mov word ptr [eax],dx", 0xF2, 0x66, 0x89, 0x10 );

    FCML_A64( "mov %rdx,(%rax)", 0x48, 0x89, 0x10 );
    FCML_A64( "xrelease mov %dx,(%rax)", 0xf3, 0x66, 0x89, 0x10 );

    FCML_I64_D( "mov dl,byte ptr [rax]", 0x48, 0x8A, 0x10 );
    FCML_I64( "mov dl,byte ptr [rax]", 0x8A, 0x10 );
    FCML_I32( "mov dl,byte ptr [eax]", 0x8A, 0x10 );

    FCML_A64( "mov (%rax),%dl", 0x8a, 0x10 );

    FCML_I64( "mov rdx,qword ptr [rax]", 0x48, 0x8B, 0x10 );
    FCML_I32( "mov edx,dword ptr [eax]", 0x8B, 0x10 );
    FCML_I32( "mov dx,word ptr [eax]", 0x66, 0x8B, 0x10 );

    FCML_A64( "mov (%rax),%rdx", 0x48, 0x8b, 0x10 );
    FCML_A64( "mov (%rax),%edx", 0x8b, 0x10 );

    FCML_I32( "mov eax,ss", 0x8C, 0xD0 );
    FCML_I32( "mov ax,ss", 0x66, 0x8C, 0xD0 );
    FCML_I64( "mov rax,ss", 0x48, 0x8C, 0xD0 );
    FCML_I32( "mov word ptr [eax],ss", 0x8C, 0x10 );
    FCML_I32_A( "mov word ptr [eax],ss", 0x8C, 0x10 );
    FCML_I32( "mov word ptr [eax],ss", 0x66, 0x8C, 0x10 );
    FCML_I64( "mov word ptr [rax],ss", 0x8C, 0x10 );

    FCML_A32( "mov %ss,%eax", 0x8C, 0xD0 );
	FCML_A32( "mov %ss,%ax", 0x66, 0x8C, 0xD0 );
	FCML_A64( "mov %ss,%rax", 0x48, 0x8C, 0xD0 );
	FCML_A64( "mov %ss,(%rax)", 0x8C, 0x10 );

    FCML_I64( "mov rax,ss", 0x48, 0x8C, 0xD0 );

    FCML_I32( "mov ds,bx", 0x8E, 0xDB );

    FCML_I64( "mov ds,bx", 0x8E, 0xDB );
    FCML_I64( "mov ds,word ptr [rbx]", 0x8E, 0x1B );
    FCML_I64_A( "mov ds,[rbx]", 0x8E, 0x1B );
    FCML_I64_A_FAILED( "mov ds,ebx", 0x8E, 0xDB );
    FCML_I64_A_FAILED( "mov ds,rbx", 0x48, 0x8E, 0xDB );

    FCML_A32( "mov %bx,%ds", 0x8e, 0xdb );

    FCML_I32_M( "mov al,byte ptr [40302010h]", 2, FCML_MI( 0xA0, 0x10, 0x20, 0x30, 0x40 ), FCML_MI( 0x8a, 0x05, 0x10, 0x20, 0x30, 0x40 ) );
    FCML_I32_M( "mov al,byte ptr [2010h]", 2, FCML_MI( 0x67, 0xA0, 0x10, 0x20 ), FCML_MI( 0x67, 0x8a, 0x06, 0x10, 0x20 ) );
    FCML_I64( "mov al,byte ptr [5352515040302010h]", 0xA0, 0x10, 0x20, 0x30, 0x40, 0x50, 0x51, 0x52, 0x53 );
    FCML_I64_M( "mov al,byte ptr [40302010h]", 2, FCML_MI( 0x67, 0xa0, 0x10, 0x20, 0x30, 0x40 ), FCML_MI( 0x67, 0x8a, 0x04, 0x25, 0x10, 0x20, 0x30, 0x40 ) );

    FCML_A64( "movabs 0x5352515040302010,%al", 0xa0, 0x10, 0x20, 0x30, 0x40, 0x50, 0x51, 0x52, 0x53 );
    FCML_A64( "movabs 0x0000000089482010,%al", 0xa0, 0x10, 0x20, 0x48, 0x89, 0x00, 0x00, 0x00, 0x00 );
    FCML_A64_M( "mov 0x89482010,%al", 2, FCML_MI( 0x67, 0xa0, 0x10, 0x20, 0x48, 0x89 ), FCML_MI( 0x67, 0x8a, 0x04, 0x25, 0x10, 0x20, 0x48, 0x89 ) );
    FCML_A32_M_A( "mov 0x89482010,%al", 2, FCML_MI( 0xa0, 0x10, 0x20, 0x48, 0x89 ), FCML_MI( 0x8a, 0x05, 0x10, 0x20, 0x48, 0x89 ) );

    FCML_I32_M( "mov eax,dword ptr [40302010h]", 2, FCML_MI( 0xA1, 0x10, 0x20, 0x30, 0x40 ), FCML_MI( 0x8b, 0x05, 0x10, 0x20, 0x30, 0x40 ) );
    FCML_I32_M( "mov ax,word ptr [2010h]", 2, FCML_MI( 0x66, 0x67, 0xA1, 0x10, 0x20 ), FCML_MI( 0x66, 0x67, 0x8B, 0x06, 0x10, 0x20 ) );
    FCML_I32_M( "mov ax,word ptr [40302010h]", 2, FCML_MI( 0x66, 0xA1, 0x10, 0x20, 0x30, 0x040 ), FCML_MI( 0x66, 0x8B, 0x05, 0x10, 0x20, 0x30, 0x040 ) );
    FCML_I64( "mov eax,dword ptr [5352515040302010h]", 0xA1, 0x10, 0x20, 0x30, 0x40, 0x50, 0x51, 0x52, 0x53 );
    FCML_I64( "mov ax,word ptr [5352515040302010h]", 0x66, 0xA1, 0x10, 0x20, 0x30, 0x40, 0x50, 0x51, 0x52, 0x53 );
    FCML_I64( "mov rax,qword ptr [5352515040302010h]", 0x48, 0xA1, 0x10, 0x20, 0x30, 0x40, 0x50, 0x51, 0x52, 0x53 );
    FCML_I64_M( "mov ax,word ptr [40302010h]", 2, FCML_MI( 0x66, 0x67, 0xa1, 0x10, 0x20, 0x30, 0x40 ), FCML_MI( 0x66, 0x67, 0x8b, 0x04, 0x25, 0x10, 0x20, 0x30, 0x40 ) );

    FCML_A64( "movabs 0x5352515040302010,%eax", 0xa1, 0x10, 0x20, 0x30, 0x40, 0x50, 0x51, 0x52, 0x53 );
    FCML_A64( "movabs 0x5352515040302010,%ax", 0x66, 0xa1, 0x10, 0x20, 0x30, 0x40, 0x50, 0x51, 0x52, 0x53 );
    FCML_A32_M_A( "mov 0x40302010,%eax", 2, FCML_MI( 0xa1, 0x10, 0x20, 0x30, 0x40 ), FCML_MI( 0x8b, 0x05, 0x10, 0x20, 0x30, 0x40 ) );

    FCML_I32_M( "mov byte ptr [40302010h],al", 2, FCML_MI( 0xA2, 0x10, 0x20, 0x30, 0x40 ), FCML_MI( 0x88, 0x05, 0x10, 0x20, 0x30, 0x40 ) );
    FCML_I32_M( "mov byte ptr [2010h],al", 2, FCML_MI( 0x67, 0xA2, 0x10, 0x20 ), FCML_MI( 0x67, 0x88, 0x06, 0x10, 0x20 ) );
    FCML_I64( "mov byte ptr [5352515040302010h],al", 0xA2, 0x10, 0x20, 0x30, 0x40, 0x50, 0x51, 0x52, 0x53 );
    FCML_I64_M( "mov byte ptr [40302010h],al", 2, FCML_MI( 0x67, 0xa2, 0x10, 0x20, 0x30, 0x40 ), FCML_MI( 0x67, 0x88, 0x04, 0x25, 0x10, 0x20, 0x30, 0x40 ) );

    FCML_A32_M( "mov %al,0x2010", 3, FCML_MI( 0x67, 0xa2, 0x10, 0x20 ), FCML_MI( 0xa2, 0x10, 0x20, 0x00, 0x00 ), FCML_MI( 0x67, 0x88, 0x06, 0x10, 0x20 ) );
    FCML_A64( "movabs %al,0x5352515040302010", 0xA2, 0x10, 0x20, 0x30, 0x40, 0x50, 0x51, 0x52, 0x53 );

    FCML_I32_M( "mov dword ptr [40302010h],eax", 2, FCML_MI( 0xA3, 0x10, 0x20, 0x30, 0x40 ), FCML_MI( 0x89, 0x05, 0x10, 0x20, 0x30, 0x40 ) );
    FCML_I32_M( "mov word ptr [2010h],ax", 2, FCML_MI( 0x66, 0x67, 0xA3, 0x10, 0x20 ), FCML_MI( 0x66, 0x67, 0x89, 0x06, 0x10, 0x20  ) );
    FCML_I32_M( "mov word ptr [40302010h],ax", 2, FCML_MI( 0x66, 0xA3, 0x10, 0x20, 0x30, 0x040 ), FCML_MI( 0x66, 0x89, 0x05, 0x10, 0x20, 0x30, 0x040 ) );
    FCML_I64( "mov dword ptr [5352515040302010h],eax", 0xA3, 0x10, 0x20, 0x30, 0x40, 0x50, 0x51, 0x52, 0x53 );
    FCML_I64( "mov word ptr [5352515040302010h],ax", 0x66, 0xA3, 0x10, 0x20, 0x30, 0x40, 0x50, 0x51, 0x52, 0x53 );
    FCML_I64( "mov qword ptr [5352515040302010h],rax", 0x48, 0xA3, 0x10, 0x20, 0x30, 0x40, 0x50, 0x51, 0x52, 0x53 );
    FCML_I64_M( "mov word ptr [40302010h],ax", 2, FCML_MI( 0x66, 0x67, 0xa3, 0x10, 0x20, 0x30, 0x40 ), FCML_MI( 0x66, 0x67, 0x89, 0x04, 0x25, 0x10, 0x20, 0x30, 0x40 ) );

    FCML_A32_M( "mov %ax,0x2010", 3, FCML_MI( 0x66, 0x67, 0xa3, 0x10, 0x20 ), FCML_MI( 0x66, 0xa3, 0x10, 0x20, 0x00, 0x00 ), FCML_MI( 0x66, 0x67, 0x89, 0x06, 0x10, 0x20 ) );
    FCML_A64( "movabs %rax,0x5352515040302010", 0x48, 0xA3, 0x10, 0x20, 0x30, 0x40, 0x50, 0x51, 0x52, 0x53 );

    FCML_I32_M( "mov al,0d0h", 2, FCML_MI( 0xB0, 0xD0 ), FCML_MI( 0xC6, 0xC0, 0xD0 )  );
    FCML_I32_M( "mov cl,0d0h", 2, FCML_MI( 0xB1, 0xD0 ), FCML_MI( 0xC6, 0xC1, 0xD0 ) );
    FCML_I32_M( "mov al,0d0h", 2, FCML_MI( 0x66, 0xB0, 0xD0 ), FCML_MI( 0x66, 0xC6, 0xC0, 0xD0 ) );
    FCML_I64_M( "mov al,0d0h", 2, FCML_MI( 0xB0, 0xD0 ), FCML_MI( 0xC6, 0xC0, 0xD0 ) );

    FCML_A32_M( "mov $0xd0,%al", 2, FCML_MI( 0xb0, 0xd0 ), FCML_MI( 0xc6, 0xc0, 0xd0 ) );

    FCML_I32_M( "mov eax,0d1d0d0d0h", 2, FCML_MI( 0xB8, 0xD0, 0xD0, 0xD0, 0xD1 ), FCML_MI( 0xC7, 0xC0, 0xD0, 0xD0, 0xD0, 0xD1 ) );
    FCML_I32_M( "mov ecx,0d1d0d0d0h", 2 ,FCML_MI( 0xB9, 0xD0, 0xD0, 0xD0, 0xD1 ), FCML_MI( 0xC7, 0xC1, 0xD0, 0xD0, 0xD0, 0xD1 ) );
    FCML_I32_M( "mov ax,0d1d0h", 2, FCML_MI( 0x66, 0xB8, 0xD0, 0xD1 ), FCML_MI( 0x66, 0xc7, 0xc0, 0xd0, 0xd1 ) );
    FCML_I64( "mov rax,0d1d0d0d0d1d0d0d0h", 0x48, 0xB8, 0xD0, 0xD0, 0xD0, 0xD1, 0xD0, 0xD0, 0xD0, 0xD1);
    FCML_I64_M( "mov ax,0d0d0h", 2, FCML_MI( 0x66, 0xB8, 0xD0, 0xD0 ), FCML_MI( 0x66, 0xc7, 0xc0, 0xd0, 0xd0 ) );

    FCML_A32_M( "mov $0xd1d0,%ax", 2, FCML_MI( 0x66, 0xB8, 0xD0, 0xD1 ), FCML_MI( 0x66, 0xc7, 0xc0, 0xd0, 0xd1 ) );
    FCML_A64( "movabs $0xd1d0d0d0d1d0d0d0,%rax", 0x48, 0xb8, 0xd0, 0xd0, 0xd0, 0xd1, 0xd0, 0xd0, 0xd0, 0xd1 );

    FCML_I32( "mov byte ptr [eax+00000010h],20h", 0xC6, 0x40, 0x10, 0x20 );
    FCML_I32( "mov byte ptr [eax+00000010h],20h", 0x66, 0xC6, 0x40, 0x10, 0x20  );
    FCML_I32_M( "mov al,20h", 2, FCML_MI( 0x66, 0xC6, 0xc0, 0x20 ), FCML_MI( 0x66, 0xb0, 0x20 ) );
    FCML_I64_D( "mov byte ptr [rax+0000000000000010h],20h", 0x48, 0xC6, 0x40, 0x10, 0x20);
    FCML_I64( "mov byte ptr [rax+0000000000000010h],20h", 0xC6, 0x40, 0x10, 0x20);

    FCML_A64( "movb $0x20,0x0000000000000010(%rax)", 0xc6, 0x40, 0x10, 0x20 );
    FCML_A32( "movb $0x20,%al", 0xC6, 0xc0, 0x20  );
    FCML_A32_M_A( "mov $0x20,%al", 2, FCML_MI( 0xc6, 0xc0, 0x20 ), FCML_MI( 0xb0, 0x20 ) );

    FCML_I32( "mov dword ptr [eax+00000010h],40302010h", 0xC7, 0x40, 0x10, 0x10, 0x20, 0x30, 0x40 );
    FCML_I32( "mov word ptr [eax+00000010h],2010h", 0x66, 0xC7, 0x40, 0x10, 0x10, 0x20  );
    FCML_I32_M( "mov ax,2010h", 2, FCML_MI( 0x66, 0xb8, 0x10, 0x20 ), FCML_MI( 0x66, 0xc7, 0xc0, 0x10, 0x20 ) );
    FCML_I64( "mov qword ptr [rax+0000000000000010h],0000000040302010h", 0x48, 0xC7, 0x40, 0x10, 0x10, 0x20, 0x30, 0x40 );
    FCML_I64( "mov qword ptr [rbp+rbx*8+0000000040302010h],0ffffffff80706050h", 0x48, 0xC7, 0x84, 0xDD, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70, 0x80 );

    FCML_A32( "movl $0x40302010,0x00000010(%eax)", 0xC7, 0x40, 0x10, 0x10, 0x20, 0x30, 0x40 );
    FCML_A32( "movw $0x2010,0x00000010(%eax)", 0x66, 0xC7, 0x40, 0x10, 0x10, 0x20  );
    FCML_A64( "movq $0xffffffff80706050,0x0000000040302010(%rbp,%rbx,8)", 0x48, 0xc7, 0x84, 0xdd, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70, 0x80 );
    FCML_A64_M( "mov $0x2010,%ax", 2, FCML_MI( 0x66, 0xb8, 0x10, 0x20 ), FCML_MI( 0x66, 0xc7, 0xc0, 0x10, 0x20 ) );
}

void fcml_tf_instruction_MOVAPD(void) {

    FCML_I64( "movapd xmm0,xmmword ptr [rax+0000000000000020h]", 0x66, 0x0F, 0x28, 0x40, 0x20 );
    FCML_I64_D( "movapd xmm0,xmmword ptr [rax+0000000000000020h]", 0x66, 0x48, 0x0F, 0x28, 0x40, 0x20 );
    FCML_I32_M( "movapd xmm0,xmm2", 2, FCML_MI( 0x66, 0x0F, 0x28, 0xC2 ), FCML_MI( 0x66, 0x0f, 0x29, 0xd0 ) );
    FCML_I32( "movapd xmm0,xmmword ptr [eax+00000020h]", 0x66, 0x0F, 0x28, 0x40, 0x20 );

    FCML_I64( "movapd xmmword ptr [rax+0000000000000020h],xmm0", 0x66, 0x0F, 0x29, 0x40, 0x20 );
    FCML_I64_D( "movapd xmmword ptr [rax+0000000000000020h],xmm0", 0x66, 0x48, 0x0F, 0x29, 0x40, 0x20 );
    FCML_I32_M( "movapd xmm2,xmm0", 2, FCML_MI( 0x66, 0x0F, 0x29, 0xC2 ), FCML_MI( 0x66, 0x0f, 0x28, 0xd0 ) );
    FCML_I32( "movapd xmmword ptr [eax+00000020h],xmm0", 0x66, 0x0F, 0x29, 0x40, 0x20 );

    FCML_I3264_M( "vmovapd xmm3,xmm0", 2, FCML_MI( 0xc5, 0xf9, 0x29, 0xc3 ), FCML_MI( 0xc5, 0xf9, 0x28, 0xd8 ) );
    FCML_I32( "vmovapd xmm0,xmmword ptr [eax]", 0xc5, 0xf9, 0x28, 0x00 );

    FCML_I64_M( "vmovapd xmm0,xmm3", 2, FCML_MI( 0xc5, 0xf9, 0x29, 0xd8 ), FCML_MI( 0xc5, 0xf9, 0x28, 0xc3 ) );
    FCML_I32_M( "vmovapd xmm0,xmm3", 2, FCML_MI( 0xc5, 0xf9, 0x29, 0xd8 ), FCML_MI( 0xc5, 0xf9, 0x28, 0xc3 ) );
    FCML_I32( "vmovapd xmmword ptr [eax],xmm0", 0xc5, 0xf9, 0x29, 0x00 );

    FCML_A64( "movapd 0x0000000000000020(%rax),%xmm0", 0x66, 0x0f, 0x28, 0x40, 0x20 );
    FCML_A64( "movapd %xmm0,0x0000000000000020(%rax)", 0x66, 0x0f, 0x29, 0x40, 0x20 );
    FCML_A64( "vmovapd (%rax),%xmm0", 0xc5, 0xf9, 0x28, 0x00 );
    FCML_A64( "vmovapd %xmm0,(%rax)", 0xc5, 0xf9, 0x29, 0x00 );
}

void fcml_tf_instruction_MOVAPS(void) {

    FCML_I64( "movaps xmm0,xmmword ptr [rax+0000000000000020h]", 0x0F, 0x28, 0x40, 0x20 );
    FCML_I32_M( "movaps xmm0,xmm2", 2, FCML_MI( 0x0f, 0x29, 0xd0 ), FCML_MI( 0x0f, 0x28, 0xc2 ) );
    FCML_I32( "movaps xmm0,xmmword ptr [eax+00000020h]", 0x0F, 0x28, 0x40, 0x20 );

    FCML_I64( "movaps xmmword ptr [rax+0000000000000020h],xmm0", 0x0F, 0x29, 0x40, 0x20 );
    FCML_I32_M( "movaps xmm2,xmm0", 2, FCML_MI( 0x0f, 0x29, 0xc2 ), FCML_MI( 0x0f, 0x28, 0xd0 ) );
    FCML_I32( "movaps xmmword ptr [eax+00000020h],xmm0", 0x0F, 0x29, 0x40, 0x20 );

    FCML_I64_M( "vmovaps xmm3,xmm0", 2, FCML_MI( 0xc5, 0xf8, 0x29, 0xc3 ), FCML_MI( 0xc5, 0xf8, 0x28, 0xd8 ) );
    FCML_I32_M( "vmovaps xmm3,xmm0", 2, FCML_MI( 0xc5, 0xf8, 0x29, 0xc3 ), FCML_MI( 0xc5, 0xf8, 0x28, 0xd8 ) );
    FCML_I32_M( "vmovaps ymm3,ymm0", 2, FCML_MI( 0xc5, 0xfc, 0x29, 0xc3 ), FCML_MI( 0xc5, 0xfc, 0x28, 0xd8 ) );
    FCML_I32( "vmovaps xmm0,xmmword ptr [eax]", 0xc5, 0xf8, 0x28, 0x00 );

    FCML_I64_M( "vmovaps xmm0,xmm3", 2, FCML_MI( 0xc5, 0xf8, 0x29, 0xd8 ), FCML_MI( 0xc5, 0xf8, 0x28, 0xc3 ) );
    FCML_I32_M( "vmovaps xmm0,xmm3", 2, FCML_MI( 0xc5, 0xf8, 0x29, 0xd8 ), FCML_MI( 0xc5, 0xf8, 0x28, 0xc3 ) );
    FCML_I32( "vmovaps xmmword ptr [eax],xmm0", 0xc5, 0xf8, 0x29, 0x00 );
    FCML_I32( "vmovaps ymmword ptr [eax],ymm0", 0xc5, 0xfc, 0x29, 0x00 );

    FCML_A64( "movaps 0x0000000000000020(%rax),%xmm0", 0x0f, 0x28, 0x40, 0x20 );
    FCML_A64( "movaps %xmm0,0x0000000000000020(%rax)", 0x0f, 0x29, 0x40, 0x20 );
    FCML_A64( "vmovaps (%rax),%xmm0", 0xc5, 0xf8, 0x28, 0x00 );
    FCML_A64( "vmovaps %ymm0,(%rax)", 0xc5, 0xfc, 0x29, 0x00 );
}

void fcml_tf_instruction_MOVBE(void) {

	FCML_I64( "movbe edx,dword ptr [rax]", 0x0F, 0x38, 0xF0, 0x10 );
    FCML_I64( "movbe rdx,qword ptr [rax]", 0x48, 0x0F, 0x38, 0xF0, 0x10 );
    FCML_I32_FAILED( "movbe eax,edx", 0x0F, 0x38, 0xF0, 0xC2 );
    FCML_I32( "movbe dx,word ptr [eax]", 0x66, 0x0F, 0x38, 0xF0, 0x10 );

    FCML_I64( "movbe dword ptr [rax],edx", 0x0F, 0x38, 0xF1, 0x10 );
    FCML_I64( "movbe qword ptr [rax],rdx", 0x48, 0x0F, 0x38, 0xF1, 0x10 );
    FCML_I32_FAILED( "movbe edx,eax", 0x0F, 0x38, 0xF1, 0xC2 );
    FCML_I32( "movbe word ptr [eax],dx", 0x66, 0x0F, 0x38, 0xF1, 0x10 );

    FCML_A64( "movbe (%rax),%edx", 0x0f, 0x38, 0xf0, 0x10 );
    FCML_A64( "movbe %edx,(%rax)", 0x0f, 0x38, 0xf1, 0x10 );
}

void fcml_tf_instruction_MOVQ(void) {

	FCML_I32( "movq mm0,mmword ptr [eax]", 0x0F, 0x6F, 0x00 );
	FCML_I64( "movq mm0,mmword ptr [rax]", 0x0F, 0x6F, 0x00 );
	FCML_I64_M_A( "movq mm0,[rax]", 2, FCML_MI( 0x0f, 0x6f, 0x00 ), FCML_MI( 0x48, 0x0f, 0x6e, 0x00 ) );
	FCML_I32_D( "movq mm0,mm2", 0x0f, 0x6f, 0xc2 );
	FCML_I64_M( "movq mm2,mm0", 2, FCML_MI( 0x0f, 0x6f, 0xd0 ), FCML_MI( 0x0f, 0x7f, 0xc2 ) );
	/* GAS (ambigous syntax)
	 */
	FCML_A64_M( "movq (%rax),%mm0", 2, FCML_MI( 0x0f, 0x6f, 0x00 ), FCML_MI( 0x48, 0x0f, 0x6e, 0x00 ) );
	FCML_A64_M( "movq %mm0,%mm0", 2, FCML_MI( 0x0f, 0x7f, 0xc0 ), FCML_MI( 0x0f, 0x6f, 0xc0 ) );

	FCML_I32( "movq mmword ptr [eax],mm0", 0x0F, 0x7F, 0x00 );
	FCML_I64( "movq mmword ptr [rax],mm0",  0x0F, 0x7F, 0x00 );
	FCML_I64_M( "movq mm0,mm2", 2, FCML_MI( 0x0f, 0x7f, 0xd0 ), FCML_MI( 0x0f, 0x6f, 0xc2 ) );

	FCML_A64_M( "movq %mm0,(%rax)", 2, FCML_MI( 0x0f, 0x7f, 0x00 ), FCML_MI( 0x48, 0x0f, 0x7e, 0x00 ) );

	FCML_I64_A( "movq mmword ptr [rax],mm2", 0x0f, 0x7f, 0x10 );

	FCML_A64_M( "movq %mm2,(%rax)", 2, FCML_MI( 0x0f, 0x7f, 0x10 ), FCML_MI( 0x48, 0x0f, 0x7e, 0x10 ) );

	FCML_I32( "movq xmm0,mmword ptr [eax]", 0xF3, 0x0F, 0x7E, 0x00 );
	FCML_I64( "movq xmm0,mmword ptr [rax]", 0xF3, 0x0F, 0x7E, 0x00 );
	FCML_I64_M( "movq xmm2,xmm0", 2, FCML_MI( 0x66, 0x0f, 0xd6, 0xc2 ), FCML_MI( 0xf3, 0x0f, 0x7e, 0xd0 ) );

	FCML_A64_M( "movq (%rax),%xmm0", 2, FCML_MI( 0xf3, 0x0f, 0x7e, 0x00 ), FCML_MI( 0x66, 0x48, 0x0f, 0x6e, 0x00 ) );
	FCML_A64_M( "movq %xmm0,%xmm2", 2, FCML_MI( 0x66, 0x0f, 0xd6, 0xc2 ), FCML_MI( 0xf3, 0x0f, 0x7e, 0xd0 ) );

	FCML_I32( "movq mmword ptr [eax],xmm0", 0x66, 0x0F, 0xD6, 0x00 );
	FCML_I64( "movq mmword ptr [rax],xmm0", 0x66, 0x0F, 0xD6, 0x00 );
	FCML_I64_M( "movq xmm0,xmm2", 2, FCML_MI( 0x66, 0x0f, 0xd6, 0xd0 ), FCML_MI( 0xf3, 0x0f, 0x7e, 0xc2 ) );

	FCML_A64_M( "movq %xmm0,(%rax)", 2, FCML_MI( 0x66, 0x0f, 0xd6, 0x00 ), FCML_MI( 0x66, 0x48, 0x0f, 0x7e, 0x00 ) );
	FCML_A64_M( "movq %xmm2,%xmm0", 2, FCML_MI( 0x66, 0x0f, 0xd6, 0xd0 ), FCML_MI( 0xf3, 0x0f, 0x7e, 0xc2 ) );

	FCML_I32( "vmovq xmm0,mmword ptr [eax]", 0xc5, 0xfa, 0x7e, 0x00 );
	FCML_I32_M( "vmovq xmm0,xmm0", 2, FCML_MI( 0xc5, 0xf9, 0xd6, 0xc0 ), FCML_MI( 0xc5, 0xfa, 0x7e, 0xc0 ) );

	FCML_A32( "vmovq (%eax),%xmm0", 0xc5, 0xfa, 0x7e, 0x00 );

	FCML_I32( "vmovq mmword ptr [eax],xmm0", 0xc5, 0xf9, 0xd6, 0x00 );
	FCML_I32_M( "vmovq xmm0,xmm0", 2, FCML_MI( 0xc5, 0xf9, 0xd6, 0xc0 ), FCML_MI( 0xc5, 0xfa, 0x7e, 0xc0 ) );

	FCML_A32( "vmovq %xmm0,(%eax)", 0xc5, 0xf9, 0xd6, 0x00 );
	FCML_A32_M( "vmovq %xmm0,%xmm0", 2, FCML_MI( 0xc5, 0xf9, 0xd6, 0xc0 ), FCML_MI( 0xc5, 0xfa, 0x7e, 0xc0 ) );

	FCML_I64( "vmovq mmword ptr [rcx+rax],xmm2", 0xc5, 0xf9, 0xd6, 0x14, 0x01 );

	FCML_A64_M( "vmovq %xmm2,(%rcx,%rax)", 2, FCML_MI( 0xc5, 0xf9, 0xd6, 0x14, 0x01 ), FCML_MI( 0xc4, 0xe1, 0xf9, 0x7e, 0x14, 0x01 ) );

	FCML_I64_M( "movq mm2,qword ptr [rax]", 2, FCML_MI( 0x48, 0x0f, 0x6e, 0x10 ), FCML_MI( 0x0f, 0x6f, 0x10 ) );

	FCML_A64_M( "movq (%rax),%mm2", 2,FCML_MI( 0x48, 0x0f, 0x6e, 0x10 ), FCML_MI( 0x0f, 0x6f, 0x10 ) );
	FCML_A64( "movq %rax,%mm0", 0x48, 0x0f, 0x6e, 0xc0 );

	FCML_I64_A( "movq xmm2,mmword ptr [rax]", 0xf3, 0x0f, 0x7e, 0x10 );

	FCML_A64_M( "movq (%rax),%xmm2", 2, FCML_MI( 0xf3, 0x0f, 0x7e, 0x10 ), FCML_MI( 0x66, 0x48, 0x0f, 0x6e, 0x10 ) );

	FCML_I64_M( "movq qword ptr [rax],xmm2", 2, FCML_MI( 0x66, 0x48, 0x0f, 0x7e, 0x10 ), FCML_MI( 0x66, 0x0f, 0xd6, 0x10 ) );

	FCML_A64_M( "movq %xmm2,(%rax)", 2, FCML_MI( 0x66, 0x48, 0x0f, 0x7e, 0x10 ), FCML_MI( 0x66, 0x0f, 0xd6, 0x10 ) );

	FCML_I64( "vmovq xmm2,mmword ptr [rcx+rax]", 0xc5, 0xfa, 0x7e, 0x14, 0x01 );

	FCML_A64_M( "vmovq (%rcx,%rax),%xmm2", 2, FCML_MI( 0xc5, 0xfa, 0x7e, 0x14, 0x01 ), FCML_MI( 0xc4, 0xe1, 0xf9, 0x6e, 0x14, 0x01 ) );
}

void fcml_tf_instruction_MOVD(void) {

    FCML_I32( "movd mm2,dword ptr [eax]", 0x0F, 0x6E, 0x10 );
    FCML_I64( "movd mm2,dword ptr [rax]", 0x0F, 0x6E, 0x10 );

    FCML_A64( "movd (%rax),%mm2", 0x0f, 0x6e, 0x10 );
    FCML_A64( "movd %eax,%mm0", 0x0f, 0x6e, 0xc0 );

    FCML_I32( "movd dword ptr [eax],mm2", 0x0F, 0x7E, 0x10 );
    FCML_I64( "movd dword ptr [rax],mm2", 0x0F, 0x7E, 0x10 );

    FCML_A64( "movd %mm2,(%rax)", 0x0f, 0x7e, 0x10 );
    FCML_A64( "movd %mm0,%eax", 0x0f, 0x7e, 0xc0 );

    FCML_I32( "movd xmm2,dword ptr [eax]", 0x66, 0x0F, 0x6E, 0x10 );
    FCML_I64( "movd xmm2,dword ptr [rax]", 0x66, 0x0F, 0x6E, 0x10 );

    FCML_A64( "movd (%rax),%xmm2", 0x66, 0x0f, 0x6e, 0x10 );
    FCML_A64( "movd %eax,%xmm0", 0x66, 0x0f, 0x6e, 0xc0 );

    FCML_I32( "movd dword ptr [eax],xmm2", 0x66, 0x0F, 0x7E, 0x10 );
    FCML_I64( "movd dword ptr [rax],xmm2", 0x66, 0x0F, 0x7E, 0x10 );

    FCML_A64( "movd %xmm2,(%rax)", 0x66, 0x0f, 0x7e, 0x10 );
    FCML_A64( "movd %xmm0,%eax", 0x66, 0x0f, 0x7e, 0xc0 );

    FCML_I32( "vmovd xmm2,dword ptr [ecx+eax]", 0xc5, 0xf9, 0x6e, 0x14, 0x01 );

    FCML_A64( "vmovd (%rcx,%rax),%xmm2", 0xc5, 0xf9, 0x6e, 0x14, 0x01 );
    FCML_A64( "vmovd (%rcx,%rax,8),%xmm2", 0xc5, 0xf9, 0x6e, 0x14, 0xc1 );
    FCML_A64( "vmovd %ecx,%xmm0", 0xc5, 0xf9, 0x6e, 0xc1 );

    FCML_I32( "vmovd dword ptr [ecx+eax],xmm2", 0xc5, 0xf9, 0x7e, 0x14, 0x01 );

    FCML_A64( "vmovd %xmm2,(%rcx,%rax)", 0xc5, 0xf9, 0x7e, 0x14, 0x01 );
    FCML_A64( "vmovd %xmm0,%ecx", 0xc5, 0xf9, 0x7e, 0xc1 );
}

void fcml_tf_instruction_MOVDDUP(void) {

    FCML_I32( "movddup xmm2,mmword ptr [eax]", 0xF2, 0x0F, 0x12, 0x10 );
    FCML_I32( "movddup xmm3,xmm0", 0xF2, 0x0F, 0x12, 0xD8 );
    FCML_I64( "movddup xmm2,mmword ptr [rax]", 0xF2, 0x0F, 0x12, 0x10 );

    FCML_A64( "movddup (%rax),%xmm2", 0xf2, 0x0f, 0x12, 0x10 );
    FCML_A64( "movddup %xmm0,%xmm3", 0xf2, 0x0f, 0x12, 0xd8 );

    FCML_I64( "vmovddup xmm3,xmm0", 0xc5, 0xfb, 0x12, 0xd8 );
    FCML_I32( "vmovddup xmm0,mmword ptr [eax]", 0xc5, 0xfb, 0x12, 0x00 );
    FCML_I32( "vmovddup ymm3,ymm0", 0xc5, 0xff, 0x12, 0xd8 );
    FCML_I64( "vmovddup ymm0,ymmword ptr [rax]", 0xc5, 0xff, 0x12, 0x00 );

    FCML_A64( "vmovddup %ymm0,%ymm3", 0xc5, 0xff, 0x12, 0xd8 );
    FCML_A64( "vmovddup (%rax),%ymm0", 0xc5, 0xff, 0x12, 0x00 );

    FCML_I64_M( "vmovdqu xmm3,xmm0", 2, FCML_MI( 0xc5, 0xfa, 0x7f, 0xc3 ), FCML_MI( 0xc5, 0xfa, 0x6f, 0xd8 ) );
    FCML_I32( "vmovdqu ymm0,ymmword ptr [eax]", 0xc5, 0xfe, 0x6f, 0x00 );

    FCML_A64_M( "vmovdqu %xmm0,%xmm3", 2, FCML_MI( 0xc5, 0xfa, 0x7f, 0xc3 ), FCML_MI( 0xc5, 0xfa, 0x6f, 0xd8 ) );
    FCML_A64( "vmovdqu (%rax),%ymm0", 0xc5, 0xfe, 0x6f, 0x00 );

    FCML_I32_M( "vmovdqu xmm0,xmm3", 2, FCML_MI( 0xc5, 0xfa, 0x7f, 0xd8 ), FCML_MI( 0xc5, 0xfa, 0x6f, 0xc3 ) );
    FCML_I64( "vmovdqu ymmword ptr [rax],ymm0", 0xc5, 0xfe, 0x7f, 0x00 );

    FCML_A64_M( "vmovdqu %xmm3,%xmm0", 2, FCML_MI( 0xc5, 0xfa, 0x7f, 0xd8 ), FCML_MI( 0xc5, 0xfa, 0x6f, 0xc3 ) );
    FCML_A64( "vmovdqu %ymm0,(%rax)", 0xc5, 0xfe, 0x7f, 0x00 );
}

void fcml_tf_instruction_MOVDQA(void) {

    FCML_I32( "movdqa xmm2,xmmword ptr [eax]", 0x66, 0x0F, 0x6F, 0x10 );
    FCML_I32_M( "movdqa xmm3,xmm0", 2, FCML_MI( 0x66, 0x0f, 0x7f, 0xc3 ), FCML_MI( 0x66, 0x0f, 0x6f, 0xd8 ) );
    FCML_I64( "movdqa xmm2,xmmword ptr [rax]", 0x66, 0x0F, 0x6F, 0x10 );

    FCML_A64( "movdqa (%rax),%xmm2", 0x66, 0x0f, 0x6f, 0x10 );
    FCML_A64_M( "movdqa %xmm0,%xmm3", 2, FCML_MI( 0x66, 0x0f, 0x7f, 0xc3 ), FCML_MI( 0x66, 0x0f, 0x6f, 0xd8 ) );

    FCML_I32( "movdqa xmmword ptr [eax],xmm2", 0x66, 0x0F, 0x7F, 0x10 );
    FCML_I32_M( "movdqa xmm0,xmm3", 2, FCML_MI( 0x66, 0x0f, 0x7f, 0xd8 ), FCML_MI( 0x66, 0x0f, 0x6f, 0xc3 ) );
    FCML_I64( "movdqa xmmword ptr [rax],xmm2", 0x66, 0x0F, 0x7F, 0x10 );

    FCML_A64( "movdqa %xmm2,(%rax)", 0x66, 0x0f, 0x7f, 0x10 );

    FCML_I64_M( "vmovdqa xmm3,xmm0", 2, FCML_MI( 0xc5, 0xf9, 0x7f, 0xc3 ), FCML_MI( 0xc5, 0xf9, 0x6f, 0xd8 ) );
    FCML_I32( "vmovdqa ymm0,ymmword ptr [eax]", 0xc5, 0xfd, 0x6f, 0x00 );

    FCML_A64( "vmovdqa (%rax),%ymm0", 0xc5, 0xfd, 0x6f, 0x00 );

    FCML_I32_M( "vmovdqa xmm0,xmm3", 2, FCML_MI( 0xc5, 0xf9, 0x7f, 0xd8 ), FCML_MI( 0xc5, 0xf9, 0x6f, 0xc3 ) );
    FCML_I64( "vmovdqa ymmword ptr [rax],ymm0", 0xc5, 0xfd, 0x7f, 0x00 );

    FCML_A64( "vmovdqa %ymm0,(%rax)", 0xc5, 0xfd, 0x7f, 0x00 );
}

void fcml_tf_instruction_MOVDQU(void) {

    FCML_I32( "movdqu xmm2,xmmword ptr [eax]", 0xF3, 0x0F, 0x6F, 0x10 );
    FCML_I32_M( "movdqu xmm3,xmm0", 2, FCML_MI( 0xf3, 0x0f, 0x7f, 0xc3 ), FCML_MI( 0xf3, 0x0f, 0x6f, 0xd8 ) );
    FCML_I64( "movdqu xmm2,xmmword ptr [rax]", 0xF3, 0x0F, 0x6F, 0x10 );

    FCML_A64_M( "movdqu %xmm0,%xmm3", 2, FCML_MI( 0xf3, 0x0f, 0x7f, 0xc3 ), FCML_MI( 0xf3, 0x0f, 0x6f, 0xd8 ) );
    FCML_A64( "movdqu (%rax),%xmm2", 0xf3, 0x0f, 0x6f, 0x10 );

    FCML_I32( "movdqu xmmword ptr [eax],xmm2", 0xF3, 0x0F, 0x7F, 0x10 );
    FCML_I32_M( "movdqu xmm0,xmm3", 2, FCML_MI( 0xf3, 0x0f, 0x7f, 0xd8 ), FCML_MI( 0xf3, 0x0f, 0x6f, 0xc3 ) );
    FCML_I64( "movdqu xmmword ptr [rax],xmm2", 0xF3, 0x0F, 0x7F, 0x10 );

    FCML_A64( "movdqu %xmm2,(%rax)", 0xf3, 0x0f, 0x7f, 0x10 );
}

void fcml_tf_instruction_MOVDQ2Q(void) {

    FCML_I32( "movdq2q mm2,xmm0", 0xF2, 0x0F, 0xD6, 0xD0 );
    FCML_I32( "movdq2q mm3,xmm0", 0xF2, 0x0F, 0xD6, 0xD8 );
    FCML_I64( "movdq2q mm2,xmm0", 0xF2, 0x0F, 0xD6, 0xD0 );

    FCML_A64( "movdq2q %xmm0,%mm3", 0xf2, 0x0f, 0xd6, 0xd8 );
}

void fcml_tf_instruction_MOVHLPS(void) {

    FCML_I32( "movhlps xmm2,xmm0", 0x0F, 0x12, 0xD0 );
    FCML_I32( "movhlps xmm3,xmm0", 0x0F, 0x12, 0xD8 );
    FCML_I64( "movhlps xmm2,xmm0", 0x0F, 0x12, 0xD0 );

    FCML_A64( "movhlps %xmm0,%xmm3", 0x0f, 0x12, 0xd8 );

    FCML_I32( "vmovhlps xmm3,xmm0,xmm0", 0xc5, 0xf8, 0x12, 0xd8 );
    FCML_I64( "vmovhlps xmm3,xmm0,xmm1", 0xc5, 0xf8, 0x12, 0xd9 );
    FCML_I64( "vmovhlps xmm3,xmm15,xmm1", 0xc5, 0x80, 0x12, 0xd9 );

    FCML_A64( "vmovhlps %xmm1,%xmm0,%xmm3", 0xc5, 0xf8, 0x12, 0xd9 );
}

void fcml_tf_instruction_MOVHPD(void) {

    FCML_I32( "movhpd xmm1,qword ptr [eax]", 0x66, 0x0F, 0x16, 0x08 );
    FCML_I64( "movhpd xmm1,qword ptr [rax]", 0x66, 0x0F, 0x16, 0x08 );

    FCML_I32( "movhpd qword ptr [eax],xmm1", 0x66, 0x0F, 0x17, 0x08 );
    FCML_I64( "movhpd qword ptr [rax],xmm1", 0x66, 0x0F, 0x17, 0x08 );

    FCML_I32( "vmovhpd xmm2,xmm1,qword ptr [eax]", 0xC5, 0xF1, 0x16, 0x10 );
    FCML_I64( "vmovhpd xmm0,xmm5,qword ptr [rax]", 0xc5, 0xd1, 0x16, 0x00 );

    FCML_I64( "vmovhpd qword ptr [rax],xmm0", 0xc5, 0xf9, 0x17, 0x00 );

    FCML_A64( "movhpd (%rax),%xmm1", 0x66, 0x0f, 0x16, 0x08 );
    FCML_A64( "movhpd %xmm1,(%rax)", 0x66, 0x0f, 0x17, 0x08 );
    FCML_A64( "vmovhpd (%rax),%xmm5,%xmm0", 0xc5, 0xd1, 0x16, 0x00 );
    FCML_A64( "vmovhpd %xmm0,(%rax)", 0xc5, 0xf9, 0x17, 0x00 );
}

void fcml_tf_instruction_MOVHPS(void) {

    FCML_I32( "movhps xmm1,qword ptr [eax]", 0x0F, 0x16, 0x08 );
    FCML_I64( "movhps xmm1,qword ptr [rax]", 0x0F, 0x16, 0x08 );

    FCML_I32( "movhps qword ptr [eax],xmm1", 0x0F, 0x17, 0x08 );
    FCML_I64( "movhps qword ptr [rax],xmm1", 0x0F, 0x17, 0x08 );

    FCML_I32( "vmovhps xmm2,xmm1,qword ptr [eax]", 0xC5, 0xF0, 0x16, 0x10 );
    FCML_I64( "vmovhps xmm0,xmm5,qword ptr [rax]", 0xc5, 0xd0, 0x16, 0x00 );

    FCML_I64( "vmovhps qword ptr [rax],xmm0", 0xc5, 0xf8, 0x17, 0x00 );

    FCML_A64( "movhps (%rax),%xmm1", 0x0f, 0x16, 0x08 );
    FCML_A64( "movhps %xmm1,(%rax)", 0x0f, 0x17, 0x08 );
    FCML_A64( "vmovhps (%rax),%xmm5,%xmm0", 0xc5, 0xd0, 0x16, 0x00 );
    FCML_A64( "vmovhps %xmm0,(%rax)", 0xc5, 0xf8, 0x17, 0x00 );
}

void fcml_tf_instruction_MOVLHPS(void) {

    FCML_I32( "movlhps xmm2,xmm0", 0x0F, 0x16, 0xD0 );
    FCML_I32( "movlhps xmm3,xmm0", 0x0F, 0x16, 0xD8 );
    FCML_I64( "movlhps xmm2,xmm0", 0x0F, 0x16, 0xD0 );

    FCML_I32( "vmovlhps xmm2,xmm5,xmm0", 0xC5, 0xD0, 0x16, 0xD0 );
    FCML_I64( "vmovlhps xmm0,xmm6,xmm0", 0xc5, 0xc8, 0x16, 0xc0 );

    FCML_A64( "movlhps %xmm0,%xmm2", 0x0f, 0x16, 0xd0 );
    FCML_A64( "vmovlhps %xmm0,%xmm5,%xmm2", 0xc5, 0xd0, 0x16, 0xd0 );
}

void fcml_tf_instruction_MOVLPD(void) {

    FCML_I32( "movlpd xmm0,qword ptr [eax]", 0x66, 0x0F, 0x12, 0x00 );
    FCML_I64( "movlpd xmm0,qword ptr [rax]", 0x66, 0x0F, 0x12, 0x00 );

    FCML_I32( "movlpd qword ptr [eax],xmm0", 0x66, 0x0F, 0x13, 0x00 );
    FCML_I64( "movlpd qword ptr [rax],xmm0", 0x66, 0x0F, 0x13, 0x00 );

    FCML_I32( "vmovlpd xmm2,xmm1,qword ptr [eax]", 0xC5, 0xF1, 0x12, 0x10 );
    FCML_I64( "vmovlpd xmm0,xmm5,qword ptr [rax]", 0xc5, 0xd1, 0x12, 0x00 );

    FCML_I64( "vmovlpd qword ptr [rax],xmm0", 0xc5, 0xf9, 0x13, 0x00 );

    FCML_A64( "movlpd (%rax),%xmm0", 0x66, 0x0f, 0x12, 0x00 );
    FCML_A64( "movlpd %xmm0,(%rax)", 0x66, 0x0f, 0x13, 0x00 );
    FCML_A64( "vmovlpd (%rax),%xmm5,%xmm0", 0xc5, 0xd1, 0x12, 0x00 );
    FCML_A64( "vmovlpd %xmm0,(%rax)", 0xc5, 0xf9, 0x13, 0x00 );
}

void fcml_tf_instruction_MOVLPS(void) {

    FCML_I32( "movlps xmm0,qword ptr [eax]", 0x0F, 0x12, 0x00 );
    FCML_I64( "movlps xmm0,qword ptr [rax]", 0x0F, 0x12, 0x00 );

    FCML_I32( "movlps qword ptr [eax],xmm0", 0x0F, 0x13, 0x00 );
    FCML_I64( "movlps qword ptr [rax],xmm0",  0x0F, 0x13, 0x00 );

    FCML_I32( "vmovlps xmm2,xmm1,qword ptr [eax]", 0xC5, 0xF0, 0x12, 0x10 );
    FCML_I64( "vmovlps xmm0,xmm5,qword ptr [rax]", 0xc5, 0xd0, 0x12, 0x00 );

    FCML_I64( "vmovlps qword ptr [rax],xmm0", 0xc5, 0xf8, 0x13, 0x00 );

    FCML_A64( "movlps (%rax),%xmm0", 0x0f, 0x12, 0x00 );
    FCML_A64( "movlps %xmm0,(%rax)", 0x0f, 0x13, 0x00 );
    FCML_A64( "vmovlps (%rax),%xmm5,%xmm0", 0xc5, 0xd0, 0x12, 0x00 );
    FCML_A64( "vmovlps %xmm0,(%rax)", 0xc5, 0xf8, 0x13, 0x00 );
}

void fcml_tf_instruction_MOVMSKPD(void) {

    FCML_I32( "movmskpd edx,xmm0", 0x66, 0x0F, 0x50, 0xD0 );
    FCML_I32( "movmskpd ebx,xmm0", 0x66, 0x0F, 0x50, 0xD8 );
    FCML_I64( "movmskpd rdx,xmm0", 0x66, 0x0F, 0x50, 0xD0 );

    FCML_I32( "vmovmskpd edx,xmm0", 0xc5, 0xf9, 0x50, 0xd0 );
    FCML_I32( "vmovmskpd ebx,xmm0", 0xc5, 0xf9, 0x50, 0xd8 );
    FCML_I64( "vmovmskpd rdx,ymm0", 0xc5, 0xfd, 0x50, 0xd0 );
    FCML_I64( "vmovmskpd rdx,ymm0", 0xc5, 0xfd, 0x50, 0xd0 );
    FCML_I32( "vmovmskpd ebx,ymm0", 0xc5, 0xfd, 0x50, 0xd8 );

    FCML_A64( "movmskpd %xmm0,%rdx", 0x66, 0x0f, 0x50, 0xd0 );
    FCML_A64( "vmovmskpd %ymm0,%rbx", 0xc5, 0xfd, 0x50, 0xd8 );
}

void fcml_tf_instruction_MOVMSKPS(void) {

    FCML_I32( "movmskps edx,xmm0", 0x0F, 0x50, 0xD0 );
    FCML_I32( "movmskps ebx,xmm0", 0x0F, 0x50, 0xD8 );
    FCML_I64( "movmskps rdx,xmm0", 0x0F, 0x50, 0xD0 );

    FCML_I32( "vmovmskps edx,xmm0", 0xc5, 0xf8, 0x50, 0xd0 );
    FCML_I32( "vmovmskps ebx,xmm0", 0xc5, 0xf8, 0x50, 0xd8 );
    FCML_I64( "vmovmskps rdx,ymm0", 0xc5, 0xfc, 0x50, 0xd0 );
    FCML_I64( "vmovmskps rdx,ymm0", 0xc5, 0xfc, 0x50, 0xd0 );
    FCML_I32( "vmovmskps ebx,ymm0", 0xc5, 0xfc, 0x50, 0xd8 );

    FCML_A64( "movmskps %xmm0,%rdx", 0x0f, 0x50, 0xd0 );
    FCML_A64( "vmovmskps %ymm0,%rdx", 0xc5, 0xfc, 0x50, 0xd0 );
}

void fcml_tf_instruction_MOVNTDQA(void) {

    FCML_I32( "movntdqa xmm0,xmmword ptr [eax]", 0x66, 0x0F, 0x38, 0x2A, 0x00 );
    FCML_I64( "movntdqa xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x2A, 0x00 );

    FCML_I64( "vmovntdqa xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x2A, 0x00 );

    FCML_I64( "vmovntdqa ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x2A, 0x00 );

    FCML_A64( "movntdqa (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x2a, 0x00 );
    FCML_A64( "vmovntdqa (%rax),%xmm0", 0xc4, 0xe2, 0x79, 0x2a, 0x00 );
    FCML_A64( "vmovntdqa (%rax),%ymm0", 0xc4, 0xe2, 0x7d, 0x2a, 0x00 );
}

void fcml_tf_instruction_MOVNTDQ(void) {

    FCML_I32( "movntdq xmmword ptr [eax],xmm0", 0x66, 0x0F, 0xE7, 0x00 );
    FCML_I64( "movntdq xmmword ptr [rax],xmm0", 0x66, 0x0F, 0xE7, 0x00 );

    FCML_I64( "vmovntdq xmmword ptr [rax],xmm0", 0xc5, 0xf9, 0xe7, 0x00 );

    FCML_A64( "movntdq %xmm0,(%rax)", 0x66, 0x0f, 0xe7, 0x00 );
    FCML_A64( "vmovntdq %xmm0,(%rax)", 0xc5, 0xf9, 0xe7, 0x00 );
}

void fcml_tf_instruction_MOVNTI(void) {

    FCML_I32( "movnti dword ptr [eax],eax", 0x0F, 0xC3, 0x00 );
    FCML_I32( "movnti dword ptr [eax],eax", 0x66, 0x0F, 0xC3, 0x00 );
    FCML_I64( "movnti dword ptr [rax],eax", 0x0F, 0xC3, 0x00 );
    FCML_I64( "movnti qword ptr [rax],rax", 0x48, 0x0F, 0xC3, 0x00 );

    FCML_A64( "movnti %eax,(%rax)", 0x0f, 0xc3, 0x00 );
    FCML_A64( "movnti %rax,(%rax)", 0x48, 0x0f, 0xc3, 0x00 );
}

void fcml_tf_instruction_MOVNTPD(void) {

    FCML_I32( "movntpd xmmword ptr [eax],xmm0", 0x66, 0x0F, 0x2B, 0x00 );
    FCML_I64( "movntpd xmmword ptr [rax],xmm0", 0x66, 0x0F, 0x2B, 0x00 );

    FCML_I64( "vmovntpd xmmword ptr [rax],xmm0", 0xc5, 0xf9, 0x2b, 0x00 );

    FCML_A64( "movntpd %xmm0,(%rax)", 0x66, 0x0f, 0x2b, 0x00 );
    FCML_A64( "vmovntpd %xmm0,(%rax)", 0xc5, 0xf9, 0x2b, 0x00 );
}

void fcml_tf_instruction_MOVNTPS(void) {

    FCML_I32( "movntps xmmword ptr [eax],xmm0", 0x0F, 0x2B, 0x00 );
    FCML_I64( "movntps xmmword ptr [rax],xmm0", 0x0F, 0x2B, 0x00 );

    FCML_I64( "vmovntps xmmword ptr [rax],xmm0", 0xc5, 0xf8, 0x2b, 0x00 );
    FCML_I32( "vmovntps xmmword ptr [eax],xmm0", 0xc5, 0xf8, 0x2b, 0x00 );

    FCML_A64( "movntps %xmm0,(%rax)", 0x0f, 0x2b, 0x00 );
    FCML_A64( "vmovntps %xmm0,(%rax)", 0xc5, 0xf8, 0x2b, 0x00 );
}

void fcml_tf_instruction_MOVNTSD(void) {

    FCML_I32( "movntsd qword ptr [eax],xmm0", 0xF2, 0x0F, 0x2B, 0x00 );
    FCML_I64( "movntsd qword ptr [rax],xmm0", 0xF2, 0x0F, 0x2B, 0x00 );
    FCML_I32_FAILED( "FAIL", 0xF2, 0x0F, 0x2B, 0xC0 );

    FCML_A64( "movntsd %xmm0,(%rax)", 0xf2, 0x0f, 0x2b, 0x00 );
}

void fcml_tf_instruction_MOVNTSS(void) {

    FCML_I32( "movntss dword ptr [eax],xmm0", 0xF3, 0x0F, 0x2B, 0x00 );
    FCML_I64( "movntss dword ptr [rax],xmm0", 0xF3, 0x0F, 0x2B, 0x00 );
    FCML_I32_FAILED( "FAIL", 0xF3, 0x0F, 0x2B, 0xC0 );

    FCML_A64( "movntss %xmm0,(%rax)", 0xf3, 0x0f, 0x2b, 0x00 );
}

void fcml_tf_instruction_MOVNTQ(void) {

    FCML_I32( "movntq qword ptr [eax],mm0", 0x0F, 0xE7, 0x00 );
    FCML_I64( "movntq qword ptr [rax],mm0",  0x0F, 0xE7, 0x00 );

    FCML_A64( "movntq %mm0,(%rax)", 0x0f, 0xe7, 0x00 );
}

void fcml_tf_instruction_MOVQ2DQ(void) {

    FCML_I32( "movq2dq xmm2,mm0", 0xF3, 0x0F, 0xD6, 0xD0 );
    FCML_I32( "movq2dq xmm3,mm0", 0xF3, 0x0F, 0xD6, 0xD8 );
    FCML_I64( "movq2dq xmm2,mm0", 0xF3, 0x0F, 0xD6, 0xD0 );

    FCML_A64( "movq2dq %mm0,%xmm2", 0xf3, 0x0f, 0xd6, 0xd0 );
}

void fcml_tf_instruction_MOVS(void) {

    FCML_I32( "rep movs byte ptr [di],byte ptr [si]", 0xF3, 0x67, 0xA4 );
    FCML_I32( "movs byte ptr [di],byte ptr [si]", 0x66, 0x67, 0xA4 );
    FCML_I32( "movs byte ptr [edi],byte ptr [esi]", 0xA4 );
    FCML_I64( "movs byte ptr [rdi],byte ptr [rsi]", 0xA4 );
    FCML_I64_A( "movsb", 0xA4 );
    FCML_I64_D( "movs byte ptr [rdi],byte ptr [rsi]", 0x40, 0xA4 );
    FCML_I64_D( "movs byte ptr [edi],byte ptr [esi]", 0x67, 0x40, 0xA4 );
    FCML_I64_D( "movs byte ptr [edi],byte ptr [esi]", 0x66, 0x67, 0x40, 0xA4 );

    FCML_A64( "movsb (%rsi),(%rdi)", 0xa4 );
    FCML_A64( "movsb (%esi),(%edi)", 0x67, 0xa4 );
    FCML_A64_A( "movsb", 0xA4 );

    FCML_I32( "rep movs dword ptr [di],dword ptr [si]", 0xF3, 0x67, 0xA5 );
    FCML_I32( "movs word ptr [di],word ptr [si]", 0x66, 0x67, 0xA5 );
    FCML_I32( "movs dword ptr [edi],dword ptr [esi]", 0xA5 );
    FCML_I64( "movs qword ptr [rdi],qword ptr [rsi]", 0x48, 0xA5 );
    FCML_I64( "movs dword ptr [rdi],dword ptr [rsi]", 0xA5 );
    FCML_I64_A( "movsw", 0x66, 0xA5 );
    FCML_I64_A( "movsd", 0xA5 );
    FCML_I64_A( "movsq", 0x48, 0xA5 );
    FCML_I64_D( "movs dword ptr [rdi],dword ptr [rsi]", 0x40, 0xA5 );
    FCML_I64_D( "movs dword ptr [edi],dword ptr [esi]", 0x67, 0x40, 0xA5 );
    FCML_I64_D( "movs word ptr [edi],word ptr [esi]", 0x66, 0x67, 0x40, 0xA5 );

    FCML_A32( "rep movsl (%si),(%di)", 0xF3, 0x67, 0xA5 );
	FCML_A32( "movsw (%si),(%di)", 0x66, 0x67, 0xA5 );
	FCML_A32( "movsl (%esi),(%edi)", 0xA5 );
    FCML_A64_A( "movsw", 0x66, 0xA5 );
	FCML_A64_A( "movsl", 0xA5 );
	FCML_A64_A( "movsq", 0x48, 0xA5 );
}

void fcml_tf_instruction_MOVSD(void) {

    FCML_I32( "movsd xmm2,mmword ptr [eax]", 0xF2, 0x0F, 0x10, 0x10 );
    FCML_I32_M( "movsd xmm3,xmm0", 2, FCML_MI( 0xf2, 0x0f, 0x11, 0xc3 ), FCML_MI( 0xf2, 0x0f, 0x10, 0xd8 ) );
    FCML_I64( "movsd xmm2,mmword ptr [rax]", 0xF2, 0x0F, 0x10, 0x10 );

    FCML_I32( "movsd mmword ptr [eax],xmm2", 0xF2, 0x0F, 0x11, 0x10 );
    FCML_I32_M( "movsd xmm0,xmm3", 2, FCML_MI( 0xf2, 0x0f, 0x11, 0xd8 ), FCML_MI( 0xf2, 0x0f, 0x10, 0xc3 ) );
    FCML_I64( "movsd mmword ptr [rax],xmm2", 0xF2, 0x0F, 0x11, 0x10 );
    /* These two encodings are functionally equivalent. See: 26568_APM_v4.pdf
     */

    FCML_I32_M( "vmovsd xmm1,xmm3,xmm0", 2, FCML_MI( 0xc5, 0xe3, 0x11, 0xc1 ), FCML_MI( 0xc5, 0xe3, 0x10, 0xc8 ) );
    FCML_I64_M( "vmovsd xmm1,xmm3,xmm0", 2, FCML_MI( 0xc5, 0xe3, 0x11, 0xc1 ), FCML_MI( 0xc5, 0xe3, 0x10, 0xc8 ) );

    FCML_I64_M( "vmovsd xmm1,xmm3,xmm0", 2, FCML_MI( 0xc5, 0xe3, 0x11, 0xc1 ), FCML_MI( 0xc5, 0xe3, 0x10, 0xc8 ) );
    FCML_I32_M( "vmovsd xmm0,xmm3,xmm1", 2, FCML_MI( 0xc5, 0xe3, 0x11, 0xc8 ), FCML_MI( 0xc5, 0xe3, 0x10, 0xc1 ) );

    FCML_I32( "vmovsd xmm0,qword ptr [eax]", 0xc5, 0xfb, 0x10, 0x00 );

    FCML_I32( "vmovsd qword ptr [eax],xmm0", 0xc5, 0xfb, 0x11, 0x00 );

    FCML_A64( "movsd (%rax),%xmm2", 0xf2, 0x0f, 0x10, 0x10 );
    FCML_A64( "movsd %xmm2,(%rax)", 0xf2, 0x0f, 0x11, 0x10 );
    FCML_A64_M( "movsd %xmm3,%xmm0", 2, FCML_MI( 0xf2, 0x0f, 0x11, 0xd8 ), FCML_MI( 0xf2, 0x0f, 0x10, 0xc3 ) );
    FCML_A64_M( "vmovsd %xmm0,%xmm3,%xmm1", 2, FCML_MI( 0xc5, 0xe3, 0x11, 0xc1 ), FCML_MI( 0xc5, 0xe3, 0x10, 0xc8 ) );
    FCML_A64_M( "vmovsd %xmm1,%xmm3,%xmm0", 2, FCML_MI( 0xc5, 0xe3, 0x11, 0xc8 ), FCML_MI( 0xc5, 0xe3, 0x10, 0xc1 ) );
    FCML_A64( "vmovsd %xmm0,(%rax)", 0xc5, 0xfb, 0x11, 0x00 );
}

void fcml_tf_instruction_MOVSHDUP(void) {

    FCML_I32( "movshdup xmm2,xmmword ptr [eax]", 0xF3, 0x0F, 0x16, 0x10 );
    FCML_I32( "movshdup xmm3,xmm0", 0xF3, 0x0F, 0x16, 0xD8 );
    FCML_I64( "movshdup xmm2,xmmword ptr [rax]", 0xF3, 0x0F, 0x16, 0x10 );

    FCML_I64( "vmovshdup xmm3,xmm0", 0xc5, 0xfa, 0x16, 0xd8 );
    FCML_I32( "vmovshdup ymm0,ymmword ptr [eax]", 0xc5, 0xfe, 0x16, 0x00 );

    FCML_A64( "movshdup %xmm0,%xmm3", 0xf3, 0x0f, 0x16, 0xd8 );
    FCML_A64( "movshdup (%rax),%xmm2", 0xf3, 0x0f, 0x16, 0x10 );
    FCML_A64( "vmovshdup (%rax),%ymm0", 0xc5, 0xfe, 0x16, 0x00 );
}

void fcml_tf_instruction_MOVSLDUP(void) {

    FCML_I32( "movsldup xmm2,xmmword ptr [eax]", 0xF3, 0x0F, 0x12, 0x10 );
    FCML_I32( "movsldup xmm3,xmm0", 0xF3, 0x0F, 0x12, 0xD8 );
    FCML_I64( "movsldup xmm2,xmmword ptr [rax]", 0xF3, 0x0F, 0x12, 0x10 );

    FCML_I64( "vmovsldup xmm3,xmm0", 0xc5, 0xfa, 0x12, 0xd8 );
    FCML_I32( "vmovsldup ymm0,ymmword ptr [eax]", 0xc5, 0xfe, 0x12, 0x00 );

    FCML_A64( "movsldup %xmm0,%xmm3", 0xf3, 0x0f, 0x12, 0xd8 );
    FCML_A64( "vmovsldup (%rax),%ymm0", 0xc5, 0xfe, 0x12, 0x00 );
}

void fcml_tf_instruction_MOVSS(void) {

    FCML_I32( "movss xmm2,dword ptr [eax]", 0xF3, 0x0F, 0x10, 0x10 );
    FCML_I32_M( "movss xmm3,xmm0", 2, FCML_MI( 0xf3, 0x0f, 0x11, 0xc3 ), FCML_MI( 0xf3, 0x0f, 0x10, 0xd8 ) );
    FCML_I64( "movss xmm2,dword ptr [rax]", 0xF3, 0x0F, 0x10, 0x10 );

    FCML_I32( "movss dword ptr [eax],xmm2", 0xF3, 0x0F, 0x11, 0x10 );
    FCML_I32_M( "movss xmm0,xmm3", 2, FCML_MI( 0xf3, 0x0f, 0x11, 0xd8 ), FCML_MI( 0xf3, 0x0f, 0x10, 0xc3 ) );
    FCML_I64( "movss dword ptr [rax],xmm2", 0xF3, 0x0F, 0x11, 0x10 );

    FCML_I32_M( "vmovss xmm1,xmm3,xmm0", 2, FCML_MI( 0xc5, 0xe2, 0x11, 0xc1 ), FCML_MI( 0xc5, 0xe2, 0x10, 0xc8 ) );
    FCML_I64_M( "vmovss xmm1,xmm3,xmm0", 2, FCML_MI( 0xc5, 0xe2, 0x11, 0xc1 ), FCML_MI( 0xc5, 0xe2, 0x10, 0xc8 ) );

    FCML_I32_M( "vmovss xmm0,xmm3,xmm1", 2, FCML_MI( 0xc5, 0xe2, 0x11, 0xc8 ), FCML_MI( 0xc5, 0xe2, 0x10, 0xc1 ) );
    FCML_I64_M( "vmovss xmm0,xmm3,xmm1", 2, FCML_MI( 0xc5, 0xe2, 0x11, 0xc8 ), FCML_MI( 0xc5, 0xe2, 0x10, 0xc1 ) );

    FCML_I32( "vmovss xmm0,dword ptr [eax]", 0xc5, 0xfa, 0x10, 0x00 );

    FCML_I32( "vmovss dword ptr [eax],xmm0", 0xc5, 0xfa, 0x11, 0x00 );

    FCML_A64( "movss (%rax),%xmm2", 0xf3, 0x0f, 0x10, 0x10 );
    FCML_A64( "movss %xmm2,(%rax)", 0xf3, 0x0f, 0x11, 0x10 );
    FCML_A64_M( "vmovss %xmm1,%xmm3,%xmm0", 2, FCML_MI( 0xc5, 0xe2, 0x11, 0xc8 ), FCML_MI( 0xc5, 0xe2, 0x10, 0xc1 ) );
    FCML_A64( "vmovss %xmm0,(%rax)", 0xc5, 0xfa, 0x11, 0x00 );
}

void fcml_tf_instruction_MOVSX(void) {

    FCML_I32( "movsx dx,byte ptr [eax]", 0x66, 0x0F, 0xBE, 0x10 );
    FCML_I32( "movsx edx,byte ptr [eax]", 0x0F, 0xBE, 0x10 );
    FCML_I64( "movsx dx,byte ptr [rax]", 0x66, 0x0F, 0xBE, 0x10 );
    FCML_I64( "movsx edx,byte ptr [rax]", 0x0F, 0xBE, 0x10 );
    FCML_I64( "movsx rdx,byte ptr [rax]", 0x48, 0x0F, 0xBE, 0x10 );

    FCML_A64( "movsbw (%rax),%dx", 0x66, 0x0f, 0xbe, 0x10 );
    FCML_A64( "movsbl (%rax),%edx", 0x0f, 0xbe, 0x10 );
    FCML_A64( "movsbl %al,%eax", 0x0f, 0xbe, 0xc0 );
    FCML_A64( "movsbq (%rax),%rdx", 0x48, 0x0f, 0xbe, 0x10 );

    FCML_I32( "movsx edx,word ptr [eax]", 0x66, 0x0F, 0xBF, 0x10 );
    FCML_I32( "movsx edx,word ptr [eax]", 0x0F, 0xBF, 0x10 );
    FCML_I64( "movsx rdx,word ptr [rax]", 0x48, 0x0F, 0xBF, 0x10 );

    FCML_A64( "movsww (%rax),%edx", 0x66, 0x0f, 0xbf, 0x10 );
    FCML_A64( "movswl (%rax),%edx", 0x0f, 0xbf, 0x10 );
    FCML_A64( "movswl %ax,%eax", 0x0f, 0xbf, 0xc0 );
    FCML_A64( "movswq (%rax),%rdx", 0x48, 0x0f, 0xbf, 0x10 );

    FCML_I64( "movsxd rdx,dword ptr [rax]", 0x48, 0x63, 0x10 );
}

void fcml_tf_instruction_MOVUPD(void) {

    FCML_I32( "movupd xmm2,xmmword ptr [eax]", 0x66, 0x0F, 0x10, 0x10 );
    FCML_I32_M( "movupd xmm3,xmm0", 2, FCML_MI( 0x66, 0x0f, 0x11, 0xc3 ), FCML_MI( 0x66, 0x0f, 0x10, 0xd8 ) );
    FCML_I64( "movupd xmm2,xmmword ptr [rax]", 0x66, 0x0F, 0x10, 0x10 );

    FCML_I32( "movupd xmmword ptr [eax],xmm2", 0x66, 0x0F, 0x11, 0x10 );
    FCML_I32_M( "movupd xmm0,xmm3", 2, FCML_MI( 0x66, 0x0f, 0x11, 0xd8 ), FCML_MI( 0x66, 0x0f, 0x10, 0xc3 ) );
    FCML_I64( "movupd xmmword ptr [rax],xmm2", 0x66, 0x0F, 0x11, 0x10 );

    FCML_I3264_M( "vmovupd xmm3,xmm0", 2, FCML_MI( 0xc5, 0xf9, 0x11, 0xc3 ), FCML_MI( 0xc5, 0xf9, 0x10, 0xd8 ) );
    FCML_I32( "vmovupd xmm0,xmmword ptr [eax]", 0xc5, 0xf9, 0x10, 0x00 );

    FCML_I64_M( "vmovupd xmm0,xmm3", 2, FCML_MI( 0xc5, 0xf9, 0x11, 0xd8 ), FCML_MI( 0xc5, 0xf9, 0x10, 0xc3 ) );
    FCML_I32_M( "vmovupd xmm0,xmm3", 2, FCML_MI( 0xc5, 0xf9, 0x11, 0xd8 ), FCML_MI( 0xc5, 0xf9, 0x10, 0xc3 ) );
    FCML_I32( "vmovupd xmmword ptr [eax],xmm0", 0xc5, 0xf9, 0x11, 0x00 );

    FCML_A64( "movupd (%rax),%xmm2", 0x66, 0x0f, 0x10, 0x10 );
    FCML_A64_M( "movupd %xmm3,%xmm0", 2, FCML_MI( 0x66, 0x0f, 0x11, 0xd8 ), FCML_MI( 0x66, 0x0f, 0x10, 0xc3 ) );
    FCML_A64( "vmovupd (%rax),%xmm0", 0xc5, 0xf9, 0x10, 0x00 );
    FCML_A64_M( "vmovupd %xmm3,%xmm0", 2, FCML_MI( 0xc5, 0xf9, 0x11, 0xd8 ), FCML_MI( 0xc5, 0xf9, 0x10, 0xc3 ) );
}

void fcml_tf_instruction_MOVUPS(void) {

    FCML_I32( "movups xmm2,xmmword ptr [eax]", 0x0F, 0x10, 0x10 );
    FCML_I32_M( "movups xmm3,xmm0", 2, FCML_MI( 0x0f, 0x11, 0xc3 ), FCML_MI( 0x0f, 0x10, 0xd8 ) );
    FCML_I64( "movups xmm2,xmmword ptr [rax]",0x0F, 0x10, 0x10 );

    FCML_I32( "movups xmmword ptr [eax],xmm2", 0x0F, 0x11, 0x10 );
    FCML_I32_M( "movups xmm0,xmm3", 2, FCML_MI( 0x0f, 0x11, 0xd8 ), FCML_MI( 0x0f, 0x10, 0xc3 ) );
    FCML_I64( "movups xmmword ptr [rax],xmm2", 0x0F, 0x11, 0x10 );

    FCML_I3264_M( "vmovups xmm3,xmm0", 2, FCML_MI( 0xc5, 0xf8, 0x11, 0xc3 ), FCML_MI( 0xc5, 0xf8, 0x10, 0xd8 ) );
    FCML_I32( "vmovups xmm0,xmmword ptr [eax]", 0xc5, 0xf8, 0x10, 0x00 );

    FCML_I3264_M( "vmovups xmm0,xmm3", 2, FCML_MI( 0xc5, 0xf8, 0x11, 0xd8 ), FCML_MI( 0xc5, 0xf8, 0x10, 0xc3 ) );
    FCML_I32( "vmovups xmmword ptr [eax],xmm0", 0xc5, 0xf8, 0x11, 0x00 );

    FCML_A64( "movups (%rax),%xmm2", 0x0f, 0x10, 0x10 );
    FCML_A64_M( "movups %xmm3,%xmm0", 2, FCML_MI( 0x0f, 0x11, 0xd8 ), FCML_MI( 0x0f, 0x10, 0xc3 ) );
    FCML_A64( "vmovups (%rax),%xmm0", 0xc5, 0xf8, 0x10, 0x00 );
    FCML_A64_M( "vmovups %xmm3,%xmm0", 2, FCML_MI( 0xc5, 0xf8, 0x11, 0xd8 ), FCML_MI( 0xc5, 0xf8, 0x10, 0xc3 ) );
}

void fcml_tf_instruction_MOVZX(void) {

    FCML_I32( "movzx dx,byte ptr [eax]", 0x66, 0x0F, 0xB6, 0x10 );
    FCML_I32( "movzx edx,byte ptr [eax]", 0x0F, 0xB6, 0x10 );
    FCML_I64( "movzx dx,byte ptr [rax]", 0x66, 0x0F, 0xB6, 0x10 );
    FCML_I64( "movzx edx,byte ptr [rax]", 0x0F, 0xB6, 0x10 );
    FCML_I64( "movzx rdx,byte ptr [rax]", 0x48, 0x0F, 0xB6, 0x10 );

    FCML_A64( "movzbw (%rax),%dx", 0x66, 0x0f, 0xb6, 0x10 );
    FCML_A64( "movzbl (%rax),%edx", 0x0f, 0xb6, 0x10 );
    FCML_A64( "movzbl %al,%eax", 0x0f, 0xb6, 0xc0 );
    FCML_A64( "movzbq (%rax),%rdx", 0x48, 0x0f, 0xb6, 0x10 );

    FCML_I32( "movzx edx,word ptr [eax]", 0x66, 0x0F, 0xB7, 0x10 );
    FCML_I32( "movzx edx,word ptr [eax]", 0x0F, 0xB7, 0x10 );
    FCML_I64( "movzx edx,word ptr [rax]", 0x66, 0x0F, 0xB7, 0x10 );
    FCML_I64( "movzx rdx,word ptr [rax]", 0x48, 0x0F, 0xB7, 0x10 );

    FCML_A64( "movzww (%rax),%edx", 0x66, 0x0f, 0xb7, 0x10 );
    FCML_A64( "movzwl (%rax),%edx", 0x0f, 0xb7, 0x10 );
    FCML_A64( "movzwl %ax,%eax", 0x0f, 0xb7, 0xc0 );
    FCML_A64( "movzwq (%rax),%rdx", 0x48, 0x0f, 0xb7, 0x10 );
}

void fcml_tf_instruction_MPSADBW(void) {

    FCML_I32( "mpsadbw xmm2,xmmword ptr [eax],20h", 0x66, 0x0F, 0x3A, 0x42, 0x10, 0x20 );
    FCML_I32( "mpsadbw xmm2,xmm6,20h", 0x66, 0x0F, 0x3A, 0x42, 0xD6, 0x20 );
    FCML_I64( "mpsadbw xmm2,xmmword ptr [rax],20h", 0x66, 0x0F, 0x3A, 0x42, 0x10, 0x20 );
    FCML_I64( "mpsadbw xmm2,xmmword ptr [rax],20h", 0x66, 0x0F, 0x3A, 0x42, 0x10, 0x20 );

    FCML_I32( "vmpsadbw xmm2,xmm6,xmmword ptr [ecx+eax],20h", 0xC4, 0xE3, 0x49, 0x42, 0x14, 0x01, 0x20 );
    FCML_I64( "vmpsadbw xmm2,xmm6,xmmword ptr [rcx+rax],20h", 0xC4, 0xE3, 0x49, 0x42, 0x14, 0x01, 0x20 );

    FCML_I32( "vmpsadbw ymm2,ymm6,ymmword ptr [ecx+eax],20h", 0xC4, 0xE3, 0x4D, 0x42, 0x14, 0x01, 0x20 );
    FCML_I64( "vmpsadbw ymm2,ymm6,ymmword ptr [rcx+rax],20h", 0xC4, 0xE3, 0x4D, 0x42, 0x14, 0x01, 0x20 );

    FCML_A64( "mpsadbw $0x20,(%rax),%xmm2", 0x66, 0x0f, 0x3a, 0x42, 0x10, 0x20 );
    FCML_A64( "mpsadbw $0x20,%xmm6,%xmm2", 0x66, 0x0f, 0x3a, 0x42, 0xd6, 0x20 );
    FCML_A64( "vmpsadbw $0x20,(%rcx,%rax),%xmm6,%xmm2", 0xc4, 0xe3, 0x49, 0x42, 0x14, 0x01, 0x20 );
    FCML_A64( "vmpsadbw $0x20,(%rcx,%rax),%ymm6,%ymm2", 0xc4, 0xe3, 0x4d, 0x42, 0x14, 0x01, 0x20 );
}

void fcml_tf_instruction_MUL(void) {

    FCML_I32_D( "mul byte ptr [eax]", 0x66, 0xF6, 0x20 );
    FCML_I32( "mul byte ptr [eax]", 0xF6, 0x20 );
    FCML_I64_D( "mul byte ptr [rax]", 0x66, 0xF6, 0x20 );
    FCML_I64( "mul byte ptr [rax]", 0xF6, 0x20 );
    FCML_I64_D( "mul byte ptr [rax]", 0x48, 0xF6, 0x20 );

    FCML_I32_D( "mul word ptr [eax]", 0x66, 0xF7, 0x20 );
    FCML_I32( "mul dword ptr [eax]", 0xF7, 0x20 );
    FCML_I64_D( "mul word ptr [rax]", 0x66, 0xF7, 0x20 );
    FCML_I64( "mul dword ptr [rax]", 0xF7, 0x20 );
    FCML_I64_D( "mul qword ptr [rax]", 0x48, 0xF7, 0x20 );

    FCML_A64( "mulb (%rax)", 0xf6, 0x20 );
    FCML_A64_A( "mul %dl", 0xf6, 0xe2 );
    FCML_A64( "mulw (%rax)", 0x66, 0xf7, 0x20 );
    FCML_A64( "mull (%rax)", 0xf7, 0x20 );
    FCML_A64( "mulq (%rax)", 0x48, 0xf7, 0x20 );
    FCML_A64_A( "mul %edx", 0xf7, 0xe2 );
}

void fcml_tf_instruction_MULPD(void) {

    FCML_I32( "mulpd xmm2,xmmword ptr [eax]", 0x66, 0x0F, 0x59, 0x10 );
    FCML_I64( "vmulpd xmm3,xmm0,xmm0", 0xc5, 0xf9, 0x59, 0xd8 );
    FCML_I64( "mulpd xmm2,xmmword ptr [rax]", 0x66, 0x0F, 0x59, 0x10 );

    FCML_I64( "vmulpd xmm3,xmm0,xmm0", 0xc5, 0xf9, 0x59, 0xd8 );
    FCML_I32( "vmulpd ymm3,ymm0,ymm0", 0xc5, 0xfd, 0x59, 0xd8 );
    FCML_I32( "vmulpd ymm3,ymm3,ymmword ptr [eax]", 0xc5, 0xe5, 0x59, 0x18 );

    FCML_A64( "mulpd (%rax),%xmm2", 0x66, 0x0f, 0x59, 0x10 );
    FCML_A64( "vmulpd %xmm0,%xmm0,%xmm3", 0xc5, 0xf9, 0x59, 0xd8 );
    FCML_A64( "vmulpd (%rax),%ymm3,%ymm3", 0xc5, 0xe5, 0x59, 0x18 );
}

void fcml_tf_instruction_MULPS(void) {

    FCML_I32( "mulps xmm2,xmmword ptr [eax]", 0x0F, 0x59, 0x10 );
    FCML_I32( "mulps xmm3,xmm0", 0x0F, 0x59, 0xD8 );
    FCML_I64( "mulps xmm2,xmmword ptr [rax]", 0x0F, 0x59, 0x10 );

    FCML_I64( "vmulps xmm3,xmm0,xmm0", 0xc5, 0xf8, 0x59, 0xd8 );
    FCML_I32( "vmulps ymm3,ymm0,ymm0", 0xc5, 0xfc, 0x59, 0xd8 );
    FCML_I32( "vmulps ymm3,ymm3,ymmword ptr [eax]", 0xc5, 0xe4, 0x59, 0x18 );

    FCML_A64( "mulps (%rax),%xmm2", 0x0f, 0x59, 0x10 );
    FCML_A64( "mulps %xmm0,%xmm3", 0x0f, 0x59, 0xd8 );
    FCML_A64( "vmulps (%rax),%ymm3,%ymm3", 0xc5, 0xe4, 0x59, 0x18 );
}

void fcml_tf_instruction_MULSD(void) {

    FCML_I32( "mulsd xmm2,mmword ptr [eax]", 0xF2, 0x0F, 0x59, 0x10 );
    FCML_I32( "mulsd xmm3,xmm0", 0xF2, 0x0F, 0x59, 0xD8 );
    FCML_I64( "mulsd xmm2,mmword ptr [rax]", 0xF2, 0x0F, 0x59, 0x10 );

    FCML_I3264( "vmulsd xmm3,xmm3,xmm0", 0xc5, 0xe3, 0x59, 0xd8 );
    FCML_I32( "vmulsd xmm3,xmm0,mmword ptr [eax]", 0xc5, 0xfb, 0x59, 0x18 );

    FCML_A64( "mulsd (%rax),%xmm2", 0xf2, 0x0f, 0x59, 0x10 );
    FCML_A64( "mulsd %xmm0,%xmm3", 0xf2, 0x0f, 0x59, 0xd8 );
    FCML_A64( "vmulsd (%rax),%xmm0,%xmm3", 0xc5, 0xfb, 0x59, 0x18 );
}

void fcml_tf_instruction_MULSS(void) {

    FCML_I32( "mulss xmm2,dword ptr [eax]", 0xF3, 0x0F, 0x59, 0x10 );
    FCML_I32( "mulss xmm3,xmm0", 0xF3, 0x0F, 0x59, 0xD8 );
    FCML_I64( "mulss xmm2,dword ptr [rax]", 0xF3, 0x0F, 0x59, 0x10 );

    FCML_I3264( "vmulss xmm3,xmm7,xmm0", 0xc5, 0xc2, 0x59, 0xd8 );
    FCML_I32( "vmulss xmm3,xmm0,dword ptr [eax]", 0xc5, 0xfa, 0x59, 0x18 );

    FCML_A64( "mulss %xmm0,%xmm3", 0xf3, 0x0f, 0x59, 0xd8 );
    FCML_A64( "mulss (%rax),%xmm2", 0xf3, 0x0f, 0x59, 0x10 );
    FCML_A64( "vmulss (%rax),%xmm0,%xmm3", 0xc5, 0xfa, 0x59, 0x18 );
}

void fcml_tf_instruction_MWAIT(void) {

    FCML_I3264( "mwait", 0x0F, 0x01, 0xC9 );

    FCML_A64( "mwait", 0x0f, 0x01, 0xc9 );
}

void fcml_tf_instruction_MULX(void) {

	FCML_I32( "mulx eax,edi,dword ptr [eax]", 0xC4, 0xE2, 0x43, 0xF6, 0x00 );
	FCML_I32( "mulx eax,edi,eax", 0xC4, 0xE2, 0x43, 0xF6, 0xC0 );

	FCML_I64( "mulx rax,rdi,qword ptr [rax]", 0xC4, 0xE2, 0xC3, 0xF6, 0x00 );
	FCML_I64( "mulx rax,rdi,rax", 0xC4, 0xE2, 0xC3, 0xF6, 0xC0 );

	FCML_A64( "mulx (%rax),%rdi,%rax", 0xc4, 0xe2, 0xc3, 0xf6, 0x00 );
	FCML_A64( "mulx %rax,%rdi,%rax", 0xc4, 0xe2, 0xc3, 0xf6, 0xc0 );
}

fcml_stf_test_case fctl_ti_instructions_m[] = {
	{ "fcml_tf_instruction_MASKMOVQ", fcml_tf_instruction_MASKMOVQ },
	{ "fcml_tf_instruction_MASKMOVDQU", fcml_tf_instruction_MASKMOVDQU },
	{ "fcml_tf_instruction_MAXPD", fcml_tf_instruction_MAXPD },
	{ "fcml_tf_instruction_MAXPS", fcml_tf_instruction_MAXPS },
	{ "fcml_tf_instruction_MAXSD", fcml_tf_instruction_MAXSD },
	{ "fcml_tf_instruction_MAXSS", fcml_tf_instruction_MAXSS },
	{ "fcml_tf_instruction_MFENCE", fcml_tf_instruction_MFENCE },
	{ "fcml_tf_instruction_MINPD", fcml_tf_instruction_MINPD },
	{ "fcml_tf_instruction_MINPS", fcml_tf_instruction_MINPS },
	{ "fcml_tf_instruction_MINSD", fcml_tf_instruction_MINSD },
	{ "fcml_tf_instruction_MINSS", fcml_tf_instruction_MINSS },
	{ "fcml_tf_instruction_MONITOR", fcml_tf_instruction_MONITOR },
	{ "fcml_tf_instruction_MOV", fcml_tf_instruction_MOV },
	{ "fcml_tf_instruction_MOVAPD", fcml_tf_instruction_MOVAPD },
	{ "fcml_tf_instruction_MOVAPS", fcml_tf_instruction_MOVAPS },
	{ "fcml_tf_instruction_MOVBE", fcml_tf_instruction_MOVBE },
	{ "fcml_tf_instruction_MOVD", fcml_tf_instruction_MOVD },
	{ "fcml_tf_instruction_MOVQ", fcml_tf_instruction_MOVQ },
	{ "fcml_tf_instruction_MOVDDUP", fcml_tf_instruction_MOVDDUP },
	{ "fcml_tf_instruction_MOVDQA", fcml_tf_instruction_MOVDQA },
	{ "fcml_tf_instruction_MOVDQU", fcml_tf_instruction_MOVDQU },
	{ "fcml_tf_instruction_MOVDQ2Q", fcml_tf_instruction_MOVDQ2Q },
	{ "fcml_tf_instruction_MOVHLPS", fcml_tf_instruction_MOVHLPS },
	{ "fcml_tf_instruction_MOVHPD", fcml_tf_instruction_MOVHPD },
	{ "fcml_tf_instruction_MOVHPS", fcml_tf_instruction_MOVHPS },
	{ "fcml_tf_instruction_MOVLHPS", fcml_tf_instruction_MOVLHPS },
	{ "fcml_tf_instruction_MOVLPD", fcml_tf_instruction_MOVLPD },
	{ "fcml_tf_instruction_MOVLPS", fcml_tf_instruction_MOVLPS },
	{ "fcml_tf_instruction_MOVMSKPD", fcml_tf_instruction_MOVMSKPD },
	{ "fcml_tf_instruction_MOVMSKPS", fcml_tf_instruction_MOVMSKPS },
	{ "fcml_tf_instruction_MOVNTDQA", fcml_tf_instruction_MOVNTDQA },
	{ "fcml_tf_instruction_MOVNTDQ", fcml_tf_instruction_MOVNTDQ },
	{ "fcml_tf_instruction_MOVNTI", fcml_tf_instruction_MOVNTI },
	{ "fcml_tf_instruction_MOVNTPD", fcml_tf_instruction_MOVNTPD },
	{ "fcml_tf_instruction_MOVNTPS", fcml_tf_instruction_MOVNTPS },
	{ "fcml_tf_instruction_MOVNTSD", fcml_tf_instruction_MOVNTSD },
	{ "fcml_tf_instruction_MOVNTSS", fcml_tf_instruction_MOVNTSS },
	{ "fcml_tf_instruction_MOVNTQ", fcml_tf_instruction_MOVNTQ },
	{ "fcml_tf_instruction_MOVQ2DQ", fcml_tf_instruction_MOVQ2DQ },
	{ "fcml_tf_instruction_MOVS", fcml_tf_instruction_MOVS },
	{ "fcml_tf_instruction_MOVSD", fcml_tf_instruction_MOVSD },
	{ "fcml_tf_instruction_MOVSHDUP", fcml_tf_instruction_MOVSHDUP },
	{ "fcml_tf_instruction_MOVSLDUP", fcml_tf_instruction_MOVSLDUP },
	{ "fcml_tf_instruction_MOVSS", fcml_tf_instruction_MOVSS },
	{ "fcml_tf_instruction_MOVSX", fcml_tf_instruction_MOVSX },
	{ "fcml_tf_instruction_MOVUPD", fcml_tf_instruction_MOVUPD },
	{ "fcml_tf_instruction_MOVUPS", fcml_tf_instruction_MOVUPS },
	{ "fcml_tf_instruction_MOVZX", fcml_tf_instruction_MOVZX },
	{ "fcml_tf_instruction_MPSADBW", fcml_tf_instruction_MPSADBW },
	{ "fcml_tf_instruction_MUL", fcml_tf_instruction_MUL },
	{ "fcml_tf_instruction_MULPD", fcml_tf_instruction_MULPD },
	{ "fcml_tf_instruction_MULPS", fcml_tf_instruction_MULPS },
	{ "fcml_tf_instruction_MULSD", fcml_tf_instruction_MULSD },
	{ "fcml_tf_instruction_MULSS", fcml_tf_instruction_MULSS },
	{ "fcml_tf_instruction_MWAIT", fcml_tf_instruction_MWAIT },
	{ "fcml_tf_instruction_MULX", fcml_tf_instruction_MULX },
	FCML_STF_NULL_TEST
};

fcml_stf_test_suite fctl_si_instructions_m = {
	"suite-fctl_ti_instructions_m", fcml_tf_instructions_m_suite_init, fcml_tf_instructions_m_suite_cleanup, fctl_ti_instructions_m
};
