/*
 * Decompiled with CFR 0.152.
 */
class StringScanner {
    private char[] buf;
    private int idx;
    private int len;
    private String stringDelimiters = "";

    public StringScanner(String s) {
        this.buf = new char[s.length() + 1];
        s.getChars(0, s.length(), this.buf, 0);
        this.len = s.length();
        this.buf[this.len] = '\u0000';
        this.idx = 0;
    }

    public int getIndex() {
        return this.idx;
    }

    public void setIndex(int i) {
        this.idx = i < 0 ? 0 : (i > this.len ? this.len : i);
    }

    public void setStringDelimiters(String s) {
        this.stringDelimiters = s;
    }

    public String getStringDelimiters() {
        return this.stringDelimiters;
    }

    public char scanChar() throws StringScanException {
        int idxSave = this.idx;
        this.skipWhiteSpace();
        try {
            if (this.buf[this.idx] == '\'') {
                return this.scanQuotedChar();
            }
            return this.scanUnquotedChar();
        }
        catch (StringScanException e) {
            this.idx = idxSave;
            throw e;
        }
    }

    public char scanQuotedChar() throws StringScanException {
        StringScanException exception = null;
        char retval = '\u0000';
        int idxSave = this.idx;
        this.skipWhiteSpace();
        if (this.idx == this.len) {
            exception = new StringScanException(this.idx, "end of input");
        } else if (this.buf[this.idx++] == '\'') {
            try {
                retval = this.scanUnquotedChar();
            }
            catch (StringScanException e) {
                exception = e;
            }
            if (exception == null) {
                if (this.idx == this.len) {
                    exception = new StringScanException(this.idx, "end of input");
                } else if (this.buf[this.idx++] != '\'') {
                    exception = new StringScanException(this.idx - 1, "unclosed quoted character");
                }
            }
        } else {
            exception = new StringScanException(this.idx - 1, "uninitialized quoted character");
        }
        if (exception != null) {
            this.idx = idxSave;
            throw exception;
        }
        return retval;
    }

    public char scanUnquotedChar() throws StringScanException {
        char c;
        StringScanException exception = null;
        char retval = '\u0000';
        int idxSave = this.idx;
        if (this.idx == this.len) {
            exception = new StringScanException(this.idx, "end of input");
        } else if ((c = this.buf[this.idx++]) == '\\') {
            if (this.idx == this.len) {
                exception = new StringScanException(this.idx, "end of input");
            } else if ((c = this.buf[this.idx++]) == '\"') {
                retval = '\"';
            } else if (c == '\'') {
                retval = '\'';
            } else if (c == '\\') {
                retval = '\\';
            } else if (c == 'n') {
                retval = '\n';
            } else if (c == 't') {
                retval = '\t';
            } else if (c == 'b') {
                retval = '\b';
            } else if (c == 'r') {
                retval = '\r';
            } else if (c == 'f') {
                retval = '\f';
            } else if ('0' <= c && c < '8') {
                int v = c - 48;
                for (int j = 0; j < 2 && this.idx != this.len && '0' <= (c = this.buf[this.idx]) && c < '8' && v * 8 + (c - 48) <= 255; ++j) {
                    v = v * 8 + (c - 48);
                    ++this.idx;
                }
                retval = (char)v;
            } else {
                exception = new StringScanException(this.idx - 1, "illegal escape character '" + c + "'");
            }
        } else {
            retval = c;
        }
        if (exception != null) {
            this.idx = idxSave;
            throw exception;
        }
        return retval;
    }

    public String scanQuotedString() throws StringScanException {
        char c;
        StringScanException exception = null;
        StringBuffer sbuf = new StringBuffer(this.len);
        int idxSave = this.idx;
        this.skipWhiteSpace();
        if (this.idx == this.len) {
            exception = new StringScanException(this.idx, "end of input");
        } else if ((c = this.buf[this.idx++]) == '\"') {
            while (this.idx < this.len && (c = this.buf[this.idx]) != '\"' && c != '\n') {
                block13: {
                    if (c == '\\') {
                        try {
                            c = this.scanUnquotedChar();
                            break block13;
                        }
                        catch (StringScanException e) {
                            exception = e;
                            break;
                        }
                    }
                    ++this.idx;
                }
                sbuf.append(c);
            }
            if (exception == null && this.idx >= this.len) {
                exception = new StringScanException(this.len, "end of input");
            } else if (exception == null && c == '\n') {
                exception = new StringScanException(this.idx, "unclosed quoted string");
            } else {
                ++this.idx;
            }
        } else {
            exception = new StringScanException(this.idx - 1, "quoted string must start with \"");
        }
        if (exception != null) {
            this.idx = idxSave;
            throw exception;
        }
        return sbuf.toString();
    }

    public String scanNonWhiteSpaceString() throws StringScanException {
        StringBuffer sbuf = new StringBuffer(this.len);
        int idxSave = this.idx;
        this.skipWhiteSpace();
        if (this.idx == this.len) {
            StringScanException e = new StringScanException(this.idx, "end of input");
            this.idx = idxSave;
            throw e;
        }
        char c = this.buf[this.idx++];
        while (this.idx < this.len && !Character.isWhitespace(c) && this.stringDelimiters.indexOf(c) == -1) {
            sbuf.append(c);
            c = this.buf[this.idx++];
        }
        if (Character.isWhitespace(c) || this.stringDelimiters.indexOf(c) != -1) {
            --this.idx;
        } else {
            sbuf.append(c);
        }
        return sbuf.toString();
    }

    public String scanString() throws StringScanException {
        int idxSave = this.idx;
        this.skipWhiteSpace();
        try {
            if (this.buf[this.idx] == '\"') {
                return this.scanQuotedString();
            }
            return this.scanNonWhiteSpaceString();
        }
        catch (StringScanException e) {
            this.idx = idxSave;
            throw e;
        }
    }

    public String getString() throws StringScanException {
        StringBuffer sbuf = new StringBuffer(this.len);
        while (this.idx < this.len) {
            sbuf.append(this.buf[this.idx++]);
        }
        return sbuf.toString();
    }

    public long scanInt() throws StringScanException {
        int idxSave = this.idx;
        int sign = 1;
        this.skipWhiteSpace();
        char c = this.buf[this.idx];
        if (c == '-' || c == '+') {
            sign = c == '-' ? -1 : 1;
            ++this.idx;
        }
        try {
            if (this.idx == this.len) {
                throw new StringScanException(this.len, "end of input");
            }
            c = this.buf[this.idx];
            if (c == '0') {
                c = this.buf[this.idx + 1];
                if (c == 'x' || c == 'X') {
                    this.idx += 2;
                    return (long)sign * this.scanInt(16, false);
                }
                return (long)sign * this.scanInt(8, false);
            }
            return (long)sign * this.scanInt(10, false);
        }
        catch (StringScanException e) {
            this.idx = idxSave;
            throw e;
        }
    }

    public long scanInt(int radix) throws StringScanException {
        return this.scanInt(radix, true);
    }

    private String baseDesc(int radix) {
        switch (radix) {
            case 10: {
                return "decimal";
            }
            case 8: {
                return "octal";
            }
            case 16: {
                return "hex";
            }
        }
        return "base " + radix;
    }

    public long scanInt(int radix, boolean skipWhite) throws StringScanException {
        int charval;
        char c;
        StringScanException exception = null;
        int idxSave = this.idx;
        long val = 0L;
        boolean negate = false;
        if (skipWhite) {
            this.skipWhiteSpace();
        }
        if ((c = this.buf[this.idx]) == '-' || c == '+') {
            negate = c == '-';
            ++this.idx;
        }
        if (this.idx >= this.len) {
            exception = new StringScanException(this.len, "end of input");
        } else if ((charval = Character.digit(this.buf[this.idx++], radix)) == -1) {
            exception = new StringScanException(this.idx - 1, "malformed " + this.baseDesc(radix) + " integer");
        } else {
            val = charval;
            while ((charval = Character.digit(this.buf[this.idx], radix)) != -1) {
                val = val * (long)radix + (long)charval;
                ++this.idx;
            }
            c = this.buf[this.idx];
            if (Character.isLetter(c) || Character.isDigit(c) || c == '_') {
                exception = new StringScanException(this.idx, "malformed " + this.baseDesc(radix) + " integer");
            }
        }
        if (exception != null) {
            this.idx = idxSave;
            throw exception;
        }
        return negate ? -val : val;
    }

    public double scanDouble() throws StringScanException {
        StringScanException exception = null;
        int idxSave = this.idx;
        boolean hasDigits = false;
        double value = 0.0;
        this.skipWhiteSpace();
        if (this.idx == this.len) {
            exception = new StringScanException("end of input");
        } else {
            boolean signed;
            char c = this.buf[this.idx];
            if (c == '-' || c == '+') {
                signed = true;
                ++this.idx;
            }
            if (this.matchDigits()) {
                hasDigits = true;
            }
            if (this.buf[this.idx] == '.') {
                ++this.idx;
            }
            if (!(hasDigits || this.buf[this.idx] >= '0' && this.buf[this.idx] <= '9')) {
                exception = this.idx == this.len ? new StringScanException(this.idx, "end of input") : new StringScanException(this.idx, "malformed floating number: no digits");
            } else {
                this.matchDigits();
                c = this.buf[this.idx];
                if (c == 'e' || c == 'E') {
                    ++this.idx;
                    c = this.buf[this.idx];
                    if (c == '-' || c == '+') {
                        signed = true;
                        ++this.idx;
                    }
                    if (this.buf[this.idx] < '0' || this.buf[this.idx] > '9') {
                        exception = this.idx == this.len ? new StringScanException(this.idx, "end of input") : new StringScanException(this.idx, "malformed floating number: no digits in exponent");
                    } else {
                        this.matchDigits();
                    }
                }
            }
        }
        if (exception == null) {
            try {
                value = Double.parseDouble(new String(this.buf, idxSave, this.idx - idxSave));
            }
            catch (NumberFormatException e) {
                exception = new StringScanException(this.idx, "malformed floating number");
            }
        }
        if (exception != null) {
            this.idx = idxSave;
            throw exception;
        }
        return value;
    }

    public boolean scanBoolean() throws StringScanException {
        char c;
        StringScanException exception = null;
        int idxSave = this.idx;
        String testStr = "false";
        boolean testval = false;
        this.skipWhiteSpace();
        if (this.buf[this.idx] == 't') {
            testStr = "true";
            testval = true;
        } else {
            testval = false;
        }
        int i = 0;
        for (i = 0; i < testStr.length(); ++i) {
            if (testStr.charAt(i) != this.buf[this.idx]) {
                if (this.idx != this.len) break;
                exception = new StringScanException(this.idx, "end of input");
                break;
            }
            ++this.idx;
        }
        if (exception == null && (i < testStr.length() || Character.isLetterOrDigit(c = this.buf[this.idx]) || c == '_')) {
            exception = new StringScanException(this.idx, "illegal boolean");
        }
        if (exception != null) {
            this.idx = idxSave;
            throw exception;
        }
        return testval;
    }

    public boolean matchString(String s) {
        int k = this.idx;
        for (int i = 0; i < s.length(); ++i) {
            if (k < this.len && s.charAt(i) == this.buf[k++]) continue;
            return false;
        }
        this.idx = k;
        return true;
    }

    public boolean matchDigits() {
        char c;
        int k = this.idx;
        while ((c = this.buf[k]) >= '0' && c <= '9') {
            ++k;
        }
        if (k > this.idx) {
            this.idx = k;
            return true;
        }
        return false;
    }

    public void skipWhiteSpace() {
        while (Character.isWhitespace(this.buf[this.idx])) {
            ++this.idx;
        }
    }

    private int skipWhiteSpace(int k) {
        while (Character.isWhitespace(this.buf[k])) {
            ++k;
        }
        return k;
    }

    public boolean atEnd() {
        return this.idx == this.len;
    }

    public boolean atBeginning() {
        return this.idx == 0;
    }

    public void ungetc() {
        if (this.idx > 0) {
            --this.idx;
        }
    }

    public char getc() {
        char c = this.buf[this.idx];
        if (this.idx < this.len) {
            ++this.idx;
        }
        return c;
    }

    public char peekc() {
        return this.buf[this.idx];
    }

    public String substring(int i0, int i1) {
        if (i0 < 0) {
            i0 = 0;
        } else if (i0 >= this.len) {
            i0 = this.len - 1;
        }
        if (i1 < 0) {
            i1 = 0;
        } else if (i1 > this.len) {
            i1 = this.len;
        }
        if (i1 <= i0) {
            return "";
        }
        return new String(this.buf, i0, i1 - i0);
    }

    public String substring(int i0) {
        if (i0 < 0) {
            i0 = 0;
        }
        if (i0 >= this.len) {
            return "";
        }
        return new String(this.buf, i0, this.len - i0);
    }
}

