#!/usr/bin/env perl
#####
# keywords.pl
# Andy Hammerlindl 2006/07/31
#
#  Extract keywords from camp.l and list them in a keywords file.  These
#  keywords are used in autocompletion at the interactive prompt.
#####

# Extra keywords to add that aren't automatically extracted, currently none.
@extrawords = ();


open(keywords, ">keywords.cc") ||
    die("Couldn't open keywords.out for writing.");

print keywords <<END;
/*****
 * This file is automatically generated by keywords.pl.
 * Changes will be overwritten.
 *****/

END

sub add {
  print keywords "ADD(".$_[0].");\n";
}

foreach $word (@extrawords) {
  add($word);
}

open(camp, "camp.l") || die("Couldn't open camp.l");

# Search for the %% separator, after which the definitions start.
while (<camp>) {
  if (/^%%\s*$/) {
    last; # Break out of the loop.
  }
}

# Grab simple keyword definitions from camp.l
while (<camp>) {
  if (/^%%\s*$/) {
    last; # A second %% indicates the end of definitions.
  }
  if (/^([A-Za-z_][A-Za-z0-9_]*)\s*\{/) {
    add($1);
  }
}

# Grab the special commands from the interactive prompt.
open(process, "process.cc") || dir("Couldn't open process.cc");

while (<process>) {
  if (/^\s*ADDCOMMAND\(\s*([A-Za-z_][A-Za-z0-9_]*),/) {
    add($1);
  }
}

