#
# Makefile for the linear algebra library embedded in ABINIT
#

include ../../config.mk

all_targets all linalg: install
	@echo "$(linalg_pkg_name) is now ready for use."

uncompress: uncompress-stamp
	@echo "$(linalg_pkg_name) has been uncompressed."

configure: configure-stamp
	@echo "$(linalg_pkg_name) has been configured."

build: build-stamp
	@echo "$(linalg_pkg_name) has been built."

install: install-stamp
	@echo "$(linalg_pkg_name) has been installed."

uncompress-stamp:
	tar xf $(abinit_srcdir)/lib/linalg/$(linalg_pkg_name).tar
	touch uncompress-stamp

configure-stamp: uncompress
	touch configure-stamp

build-stamp: configure
	cd blas && $(MAKE) FC="$(FC)" FCFLAGS="$(FCFLAGS_FIXEDFORM) $(FCFLAGS_LINALG)"
	cd lapack && $(MAKE) FC="$(FC)" FCFLAGS="$(FCFLAGS_FIXEDFORM) $(FCFLAGS_LINALG)"
	$(AR) $(ARFLAGS) liblinalg.a blas/*.o lapack/*.o
	-$(RANLIB) liblinalg.a
	touch build-stamp

install-stamp: build
	touch install-stamp

clean:
	rm -rf blas lapack
	rm -f uncompress-stamp configure-stamp build-stamp install-stamp
