#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 BetaRays <array@dotslashplay.it>
# SPDX-FileCopyrightText: © 2020 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# TIS-100
# send your bug reports to bugs@dotslashplay.it
###

script_version=20241019.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='tis-100'
GAME_NAME='TIS-100'

ARCHIVE_BASE_1_NAME='tis_100_11_14_2020_43142.sh'
ARCHIVE_BASE_1_MD5='ce632a3b15de61222f79d3c4f506bac1'
ARCHIVE_BASE_1_SIZE='84000'
ARCHIVE_BASE_1_VERSION='2020.11.14-gog43142'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/tis100'

ARCHIVE_BASE_0_NAME='tis_100_en_11_27_2017_16765.sh'
ARCHIVE_BASE_0_MD5='70518ec82ee8148697b704ed2c3c8953'
ARCHIVE_BASE_0_SIZE='83000'
ARCHIVE_BASE_0_VERSION='2017.11.27-gog16765'


UNITY3D_NAME='tis100'
UNITY3D_PLUGINS='
ScreenSelector.so'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_DOC_DATA_FILES='
*.pdf
*.txt'

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN64_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN32_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libgdk_pixbuf-2.0.so.0
libglib-2.0.so.0
libGL.so.1
libgobject-2.0.so.0
libgtk-x11-2.0.so.0
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libX11.so.6
libXcursor.so.1
libXrandr.so.2'
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN32_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Copy the manual in the game directory

manual_source="$(package_path 'PKG_DATA')$(path_documentation)/TIS-100 Reference Manual.pdf"
manual_destination="$(package_path 'PKG_DATA')$(path_game_data)/TIS-100 Reference Manual.pdf"
mkdir --parents "$(dirname "$manual_destination")"
cp --link "$manual_source" "$manual_destination"

# Write launchers

launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
