/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFG_GU.C $
   $Locker: ska $	$Name:  $	$State: Exp $

ob(ject): cfgGetUnsigned
su(bsystem): cmdline
ty(pe): 
sy(nopsis): 
sh(ort description): Scan an option as unsigned number
he(ader files): 
lo(ng description): Check if the current option applies to the unsigned number
	type and perform the actions, if so.\par
	If \tok{radix == 0}, the number is parsed in C-style.\newline
	The number is limited by \tok{low <= *num <= high}.\par
	On success the value of \para{*num} has been changed to the
	specified number.
pr(erequistes): 
re(lated to): 
se(condary subsystems): 
va:
 \item		\tok{0}: success, *num changed
 \item		\tok{1}: number exceeds range
 \item		\tok{>=10}: (position + 10) where the first non-numerical is
xr(ef): 
im(port): 
fi(le): cfg_gu.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include <portable.h>
#include "str.h"
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFG_GU.C 1.6 2001/02/27 01:28:02 ska Exp ska $";
#endif

int cfgGetUnsigned(struct Cfg_Getopt * const optstru, unsigned * const num
 , unsigned low, unsigned high, int radix)
{	unsigned nM(long) n;
	char *endp, *p;

	DBG_ENTER("cfgGetUnsigned", Suppl_cmdline)

	assert(optstru);

	switch(optArgType()) {
	case CFG_TERROR:
		DBG_RETURN_I( 2)

	case CFG_TINTEGER:
		*num = optArgInteger();
		DBG_RETURN_I( 0)

	case CFG_TBOOLEAN:		/* invalid type */
		break;

	default:				/* unknown == string */
		if(!*(p = skipws(optArgString())))
			DBG_RETURN_I( 10)		/* no digit at all */

		endp = 0;
		n = strtoul(p, &endp, radix);
		if(endp && *skipws(endp))		/* error */
			DBG_RETURN_I( (endp - optArgString()) + 10)

		if(low <= n && n <= high) {
			*num = (unsigned)n;
			DBG_RETURN_I( 0)
		}
	}

	DBG_RETURN_I( 1)
}
