/*
 * Decompiled with CFR 0.152.
 */
package sun.text.normalizer;

import java.text.CharacterIterator;
import sun.text.normalizer.CharacterIteratorWrapper;
import sun.text.normalizer.ReplaceableUCharacterIterator;
import sun.text.normalizer.UCharacterProperty;
import sun.text.normalizer.UTF16;

public abstract class UCharacterIterator
implements Cloneable {
    public static final int DONE = -1;

    protected UCharacterIterator() {
    }

    public static final UCharacterIterator getInstance(String string) {
        return new ReplaceableUCharacterIterator(string);
    }

    public static final UCharacterIterator getInstance(StringBuffer stringBuffer) {
        return new ReplaceableUCharacterIterator(stringBuffer);
    }

    public static final UCharacterIterator getInstance(CharacterIterator characterIterator) {
        return new CharacterIteratorWrapper(characterIterator);
    }

    public abstract int current();

    public abstract int getLength();

    public abstract int getIndex();

    public abstract int next();

    public int nextCodePoint() {
        int n = this.next();
        if (UTF16.isLeadSurrogate((char)n)) {
            int n2 = this.next();
            if (UTF16.isTrailSurrogate((char)n2)) {
                return UCharacterProperty.getRawSupplementary((char)n, (char)n2);
            }
            if (n2 != -1) {
                this.previous();
            }
        }
        return n;
    }

    public abstract int previous();

    public abstract void setIndex(int var1);

    public abstract int getText(char[] var1, int var2);

    public final int getText(char[] cArray) {
        return this.getText(cArray, 0);
    }

    public String getText() {
        char[] cArray = new char[this.getLength()];
        this.getText(cArray);
        return new String(cArray);
    }

    public int moveIndex(int n) {
        int n2 = Math.max(0, Math.min(this.getIndex() + n, this.getLength()));
        this.setIndex(n2);
        return n2;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

