/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedBlockingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E>,
Serializable {
    private static final long serialVersionUID = -6903933977591709194L;
    private final int capacity;
    private final AtomicInteger count = new AtomicInteger(0);
    private transient Node<E> head;
    private transient Node<E> last;
    private final ReentrantLock takeLock = new ReentrantLock();
    private final Condition notEmpty = this.takeLock.newCondition();
    private final ReentrantLock putLock = new ReentrantLock();
    private final Condition notFull = this.putLock.newCondition();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalNotEmpty() {
        ReentrantLock reentrantLock = this.takeLock;
        reentrantLock.lock();
        try {
            this.notEmpty.signal();
            Object var3_2 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalNotFull() {
        ReentrantLock reentrantLock = this.putLock;
        reentrantLock.lock();
        try {
            this.notFull.signal();
            Object var3_2 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    private void enqueue(E e) {
        this.last.next = new Node<E>(e);
        this.last = this.last.next;
    }

    private E dequeue() {
        Node<E> node = this.head;
        Node node2 = node.next;
        node.next = node;
        this.head = node2;
        Object e = node2.item;
        node2.item = null;
        return e;
    }

    void fullyLock() {
        this.putLock.lock();
        this.takeLock.lock();
    }

    void fullyUnlock() {
        this.takeLock.unlock();
        this.putLock.unlock();
    }

    boolean isFullyLocked() {
        return this.putLock.isHeldByCurrentThread() && this.takeLock.isHeldByCurrentThread();
    }

    public LinkedBlockingQueue() {
        this(Integer.MAX_VALUE);
    }

    public LinkedBlockingQueue(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = n;
        this.head = new Node<Object>(null);
        this.last = this.head;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedBlockingQueue(Collection<? extends E> collection) {
        this(Integer.MAX_VALUE);
        ReentrantLock reentrantLock = this.putLock;
        reentrantLock.lock();
        try {
            int n = 0;
            for (E e : collection) {
                if (e == null) {
                    throw new NullPointerException();
                }
                if (n == this.capacity) {
                    throw new IllegalStateException("Queue full");
                }
                super.enqueue(e);
                ++n;
            }
            this.count.set(n);
            Object var7_6 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    @Override
    public int size() {
        return this.count.get();
    }

    @Override
    public int remainingCapacity() {
        return this.capacity - this.count.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(E e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        int n = -1;
        ReentrantLock reentrantLock = this.putLock;
        AtomicInteger atomicInteger = this.count;
        reentrantLock.lockInterruptibly();
        try {
            while (atomicInteger.get() == this.capacity) {
                this.notFull.await();
            }
            this.enqueue(e);
            n = atomicInteger.getAndIncrement();
            if (n + 1 < this.capacity) {
                this.notFull.signal();
            }
            Object var6_5 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        if (n == 0) {
            this.signalNotEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean offer(E e, long l, TimeUnit timeUnit) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        long l2 = timeUnit.toNanos(l);
        int n = -1;
        ReentrantLock reentrantLock = this.putLock;
        AtomicInteger atomicInteger = this.count;
        reentrantLock.lockInterruptibly();
        try {
            while (atomicInteger.get() == this.capacity) {
                if (l2 <= 0L) {
                    boolean bl = false;
                    Object var12_9 = null;
                    reentrantLock.unlock();
                    return bl;
                }
                l2 = this.notFull.awaitNanos(l2);
            }
            this.enqueue(e);
            n = atomicInteger.getAndIncrement();
            if (n + 1 < this.capacity) {
                this.notFull.signal();
            }
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        Object var12_10 = null;
        reentrantLock.unlock();
        if (n == 0) {
            this.signalNotEmpty();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        AtomicInteger atomicInteger = this.count;
        if (atomicInteger.get() == this.capacity) {
            return false;
        }
        int n = -1;
        ReentrantLock reentrantLock = this.putLock;
        reentrantLock.lock();
        try {
            if (atomicInteger.get() < this.capacity) {
                this.enqueue(e);
                n = atomicInteger.getAndIncrement();
                if (n + 1 < this.capacity) {
                    this.notFull.signal();
                }
            }
            Object var6_5 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        if (n == 0) {
            this.signalNotEmpty();
        }
        return n >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E take() throws InterruptedException {
        E e;
        int n = -1;
        AtomicInteger atomicInteger = this.count;
        ReentrantLock reentrantLock = this.takeLock;
        reentrantLock.lockInterruptibly();
        try {
            while (atomicInteger.get() == 0) {
                this.notEmpty.await();
            }
            e = this.dequeue();
            n = atomicInteger.getAndDecrement();
            if (n > 1) {
                this.notEmpty.signal();
            }
            Object var6_5 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        if (n == this.capacity) {
            this.signalNotFull();
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public E poll(long l, TimeUnit timeUnit) throws InterruptedException {
        E e = null;
        int n = -1;
        long l2 = timeUnit.toNanos(l);
        AtomicInteger atomicInteger = this.count;
        ReentrantLock reentrantLock = this.takeLock;
        reentrantLock.lockInterruptibly();
        try {
            while (atomicInteger.get() == 0) {
                if (l2 <= 0L) {
                    E e2 = null;
                    Object var12_9 = null;
                    reentrantLock.unlock();
                    return e2;
                }
                l2 = this.notEmpty.awaitNanos(l2);
            }
            e = this.dequeue();
            n = atomicInteger.getAndDecrement();
            if (n > 1) {
                this.notEmpty.signal();
            }
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        Object var12_10 = null;
        reentrantLock.unlock();
        if (n == this.capacity) {
            this.signalNotFull();
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        AtomicInteger atomicInteger = this.count;
        if (atomicInteger.get() == 0) {
            return null;
        }
        E e = null;
        int n = -1;
        ReentrantLock reentrantLock = this.takeLock;
        reentrantLock.lock();
        try {
            if (atomicInteger.get() > 0) {
                e = this.dequeue();
                n = atomicInteger.getAndDecrement();
                if (n > 1) {
                    this.notEmpty.signal();
                }
            }
            Object var6_5 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        if (n == this.capacity) {
            this.signalNotFull();
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        Node node;
        ReentrantLock reentrantLock;
        block4: {
            E e;
            if (this.count.get() == 0) {
                return null;
            }
            reentrantLock = this.takeLock;
            reentrantLock.lock();
            try {
                node = this.head.next;
                if (node != null) break block4;
                e = null;
                Object var5_5 = null;
                reentrantLock.unlock();
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                reentrantLock.unlock();
                throw throwable;
            }
            return e;
        }
        Object e = node.item;
        Object var5_6 = null;
        reentrantLock.unlock();
        return e;
    }

    void unlink(Node<E> node, Node<E> node2) {
        node.item = null;
        node2.next = node.next;
        if (this.last == node) {
            this.last = node2;
        }
        if (this.count.getAndDecrement() == this.capacity) {
            this.notFull.signal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean remove(Object object) {
        boolean bl;
        if (object == null) {
            return false;
        }
        this.fullyLock();
        try {
            Node<E> node = this.head;
            Node node2 = node.next;
            while (node2 != null) {
                if (object.equals(node2.item)) {
                    this.unlink(node2, node);
                    boolean bl2 = true;
                    Object var6_6 = null;
                    this.fullyUnlock();
                    return bl2;
                }
                node = node2;
                node2 = node2.next;
            }
            bl = false;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.fullyUnlock();
            throw throwable;
        }
        Object var6_7 = null;
        this.fullyUnlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        this.fullyLock();
        try {
            int n = this.count.get();
            Object[] objectArray = new Object[n];
            int n2 = 0;
            Object[] objectArray2 = this.head.next;
            while (objectArray2 != null) {
                objectArray[n2++] = objectArray2.item;
                objectArray2 = objectArray2.next;
            }
            objectArray2 = objectArray;
            Object var6_5 = null;
            this.fullyUnlock();
            return objectArray2;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.fullyUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] objectArray) {
        this.fullyLock();
        try {
            int n = this.count.get();
            if (objectArray.length < n) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
            }
            int n2 = 0;
            Object object = this.head.next;
            while (object != null) {
                objectArray[n2++] = object.item;
                object = object.next;
            }
            if (objectArray.length > n2) {
                objectArray[n2] = null;
            }
            object = objectArray;
            Object var6_5 = null;
            this.fullyUnlock();
            return object;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.fullyUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        this.fullyLock();
        try {
            String string = super.toString();
            Object var3_2 = null;
            this.fullyUnlock();
            return string;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.fullyUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.fullyLock();
        try {
            Node node;
            Node<E> node2 = this.head;
            while ((node = node2.next) != null) {
                node2.next = node2;
                node.item = null;
                node2 = node;
            }
            this.head = this.last;
            if (this.count.getAndSet(0) == this.capacity) {
                this.notFull.signal();
            }
            Object var4_3 = null;
            this.fullyUnlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.fullyUnlock();
            throw throwable;
        }
    }

    @Override
    public int drainTo(Collection<? super E> collection) {
        return this.drainTo(collection, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int drainTo(Collection<? super E> collection, int n) {
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        boolean bl = false;
        ReentrantLock reentrantLock = this.takeLock;
        reentrantLock.lock();
        try {
            int n2;
            block7: {
                boolean bl2;
                int n3;
                int n4 = Math.min(n, this.count.get());
                Node<E> node = this.head;
                try {
                    for (n3 = 0; n3 < n4; ++n3) {
                        Node node2 = node.next;
                        collection.add(node2.item);
                        node2.item = null;
                        node.next = node;
                        node = node2;
                    }
                    n2 = n4;
                    Object var10_10 = null;
                    if (n3 <= 0) break block7;
                    this.head = node;
                    bl2 = this.count.getAndAdd(-n3) == this.capacity;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    if (n3 <= 0) throw throwable;
                    this.head = node;
                    bl = this.count.getAndAdd(-n3) == this.capacity;
                    throw throwable;
                }
                bl = bl2;
            }
            Object var12_12 = null;
            reentrantLock.unlock();
            if (!bl) return n2;
            this.signalNotFull();
            return n2;
        }
        catch (Throwable throwable2) {
            Object var12_13 = null;
            reentrantLock.unlock();
            if (!bl) throw throwable2;
            this.signalNotFull();
            throw throwable2;
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.fullyLock();
        try {
            objectOutputStream.defaultWriteObject();
            Node node = this.head.next;
            while (node != null) {
                objectOutputStream.writeObject(node.item);
                node = node.next;
            }
            objectOutputStream.writeObject(null);
            Object var4_3 = null;
            this.fullyUnlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.fullyUnlock();
            throw throwable;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        objectInputStream.defaultReadObject();
        this.count.set(0);
        this.head = new Node<Object>(null);
        this.last = this.head;
        while ((object = objectInputStream.readObject()) != null) {
            this.add(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Itr
    implements Iterator<E> {
        private Node<E> current;
        private Node<E> lastRet;
        private E currentElement;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Itr() {
            LinkedBlockingQueue.this.fullyLock();
            try {
                this.current = ((LinkedBlockingQueue)LinkedBlockingQueue.this).head.next;
                if (this.current != null) {
                    this.currentElement = this.current.item;
                }
                Object var3_2 = null;
                LinkedBlockingQueue.this.fullyUnlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                LinkedBlockingQueue.this.fullyUnlock();
                throw throwable;
            }
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        private Node<E> nextNode(Node<E> node) {
            Node node2;
            while ((node2 = node.next) != node) {
                if (node2 == null || node2.item != null) {
                    return node2;
                }
                node = node2;
            }
            return ((LinkedBlockingQueue)LinkedBlockingQueue.this).head.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() {
            Object e;
            LinkedBlockingQueue.this.fullyLock();
            try {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                Object e2 = this.currentElement;
                this.lastRet = this.current;
                this.current = this.nextNode(this.current);
                this.currentElement = this.current == null ? null : this.current.item;
                e = e2;
                Object var4_3 = null;
                LinkedBlockingQueue.this.fullyUnlock();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                LinkedBlockingQueue.this.fullyUnlock();
                throw throwable;
            }
            return e;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            LinkedBlockingQueue.this.fullyLock();
            try {
                Node node = this.lastRet;
                this.lastRet = null;
                Node node2 = LinkedBlockingQueue.this.head;
                Node node3 = node2.next;
                while (node3 != null) {
                    if (node3 == node) {
                        LinkedBlockingQueue.this.unlink(node3, node2);
                        break;
                    }
                    node2 = node3;
                    node3 = node3.next;
                }
                Object var5_4 = null;
                LinkedBlockingQueue.this.fullyUnlock();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                LinkedBlockingQueue.this.fullyUnlock();
                throw throwable;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Node<E> {
        E item;
        Node<E> next;

        Node(E e) {
            this.item = e;
        }
    }
}

