/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollPaneUI;
import javax.swing.plaf.metal.MetalBorders;

public class MetalScrollPaneUI
extends BasicScrollPaneUI {
    private PropertyChangeListener scrollBarSwapListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalScrollPaneUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        JScrollPane jScrollPane = (JScrollPane)jComponent;
        this.updateScrollbarsFreeStanding();
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        JScrollPane jScrollPane = (JScrollPane)jComponent;
        JScrollBar jScrollBar = jScrollPane.getHorizontalScrollBar();
        JScrollBar jScrollBar2 = jScrollPane.getVerticalScrollBar();
        if (jScrollBar != null) {
            jScrollBar.putClientProperty("JScrollBar.isFreeStanding", null);
        }
        if (jScrollBar2 != null) {
            jScrollBar2.putClientProperty("JScrollBar.isFreeStanding", null);
        }
        jComponent.removePropertyChangeListener(this.scrollBarSwapListener);
    }

    public void installListeners(JScrollPane jScrollPane) {
        super.installListeners(jScrollPane);
        this.scrollBarSwapListener = this.createScrollBarSwapListener();
        jScrollPane.addPropertyChangeListener(this.scrollBarSwapListener);
    }

    public void uninstallListeners(JScrollPane jScrollPane) {
    }

    private void updateScrollbarsFreeStanding() {
        if (this.scrollpane == null) {
            return;
        }
        Border border = this.scrollpane.getBorder();
        Boolean bl = border instanceof MetalBorders.ScrollPaneBorder ? Boolean.FALSE : Boolean.TRUE;
        JScrollBar jScrollBar = this.scrollpane.getHorizontalScrollBar();
        if (jScrollBar != null) {
            jScrollBar.putClientProperty("JScrollBar.isFreeStanding", bl);
        }
        if ((jScrollBar = this.scrollpane.getVerticalScrollBar()) != null) {
            jScrollBar.putClientProperty("JScrollBar.isFreeStanding", bl);
        }
    }

    protected PropertyChangeListener createScrollBarSwapListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("verticalScrollBar") || string.equals("horizontalScrollBar")) {
                    JScrollBar jScrollBar;
                    JScrollBar jScrollBar2 = (JScrollBar)propertyChangeEvent.getOldValue();
                    if (jScrollBar2 != null) {
                        jScrollBar2.putClientProperty("JScrollBar.isFreeStanding", null);
                    }
                    if ((jScrollBar = (JScrollBar)propertyChangeEvent.getNewValue()) != null) {
                        jScrollBar.putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
                    }
                } else if ("border".equals(string)) {
                    MetalScrollPaneUI.this.updateScrollbarsFreeStanding();
                }
            }
        };
    }
}

