/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels.spi;

import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Pipe;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelector;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import sun.misc.Service;
import sun.misc.ServiceConfigurationError;
import sun.nio.ch.DefaultSelectorProvider;

public abstract class SelectorProvider {
    private static final Object lock = new Object();
    private static SelectorProvider provider = null;

    protected SelectorProvider() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("selectorProvider"));
        }
    }

    private static boolean loadProviderFromProperty() {
        String string = System.getProperty("java.nio.channels.spi.SelectorProvider");
        if (string == null) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName(string, true, ClassLoader.getSystemClassLoader());
            provider = (SelectorProvider)clazz.newInstance();
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ServiceConfigurationError(classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ServiceConfigurationError(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new ServiceConfigurationError(instantiationException);
        }
        catch (SecurityException securityException) {
            throw new ServiceConfigurationError(securityException);
        }
    }

    private static boolean loadProviderAsService() {
        Iterator iterator = Service.providers(SelectorProvider.class, ClassLoader.getSystemClassLoader());
        while (true) {
            try {
                if (!iterator.hasNext()) {
                    return false;
                }
                provider = (SelectorProvider)iterator.next();
                return true;
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
                if (serviceConfigurationError.getCause() instanceof SecurityException) continue;
                throw serviceConfigurationError;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SelectorProvider provider() {
        Object object = lock;
        synchronized (object) {
            if (provider != null) {
                return provider;
            }
            return (SelectorProvider)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (SelectorProvider.loadProviderFromProperty()) {
                        return provider;
                    }
                    if (SelectorProvider.loadProviderAsService()) {
                        return provider;
                    }
                    provider = DefaultSelectorProvider.create();
                    return provider;
                }
            });
        }
    }

    public abstract DatagramChannel openDatagramChannel() throws IOException;

    public abstract Pipe openPipe() throws IOException;

    public abstract AbstractSelector openSelector() throws IOException;

    public abstract ServerSocketChannel openServerSocketChannel() throws IOException;

    public abstract SocketChannel openSocketChannel() throws IOException;

    public Channel inheritedChannel() throws IOException {
        return null;
    }
}

