/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.stream.buffer.sax;

import com.sun.xml.internal.stream.buffer.AbstractProcessor;
import com.sun.xml.internal.stream.buffer.AttributesHolder;
import com.sun.xml.internal.stream.buffer.XMLStreamBuffer;
import com.sun.xml.internal.stream.buffer.sax.DefaultWithLexicalHandler;
import java.io.IOException;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.LocatorImpl;

public class SAXBufferProcessor
extends AbstractProcessor
implements XMLReader {
    protected EntityResolver _entityResolver = DEFAULT_LEXICAL_HANDLER;
    protected DTDHandler _dtdHandler = DEFAULT_LEXICAL_HANDLER;
    protected ContentHandler _contentHandler = DEFAULT_LEXICAL_HANDLER;
    protected ErrorHandler _errorHandler = DEFAULT_LEXICAL_HANDLER;
    protected LexicalHandler _lexicalHandler = DEFAULT_LEXICAL_HANDLER;
    protected boolean _namespacePrefixesFeature = false;
    protected AttributesHolder _attributes = new AttributesHolder();
    protected String[] _namespacePrefixes = new String[16];
    protected int _namespacePrefixesIndex;
    protected int[] _namespaceAttributesStack = new int[16];
    protected int _namespaceAttributesStackIndex;
    private static final DefaultWithLexicalHandler DEFAULT_LEXICAL_HANDLER = new DefaultWithLexicalHandler();

    public SAXBufferProcessor() {
    }

    public SAXBufferProcessor(XMLStreamBuffer xMLStreamBuffer) {
        this.setXMLStreamBuffer(xMLStreamBuffer);
    }

    public SAXBufferProcessor(XMLStreamBuffer xMLStreamBuffer, boolean bl) {
        this.setXMLStreamBuffer(xMLStreamBuffer, bl);
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://xml.org/sax/features/namespaces")) {
            return true;
        }
        if (string.equals("http://xml.org/sax/features/namespace-prefixes")) {
            return this._namespacePrefixesFeature;
        }
        if (string.equals("http://xml.org/sax/features/external-general-entities")) {
            return true;
        }
        if (string.equals("http://xml.org/sax/features/external-parameter-entities")) {
            return true;
        }
        if (string.equals("http://xml.org/sax/features/string-interning")) {
            return this._stringInterningFeature;
        }
        throw new SAXNotRecognizedException("Feature not supported: " + string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://xml.org/sax/features/namespaces")) {
            if (!bl) {
                throw new SAXNotSupportedException(string + ":" + bl);
            }
        } else if (string.equals("http://xml.org/sax/features/namespace-prefixes")) {
            this._namespacePrefixesFeature = bl;
        } else if (!string.equals("http://xml.org/sax/features/external-general-entities") && !string.equals("http://xml.org/sax/features/external-parameter-entities")) {
            if (string.equals("http://xml.org/sax/features/string-interning")) {
                if (bl != this._stringInterningFeature) {
                    throw new SAXNotSupportedException(string + ":" + bl);
                }
            } else {
                throw new SAXNotRecognizedException("Feature not supported: " + string);
            }
        }
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://xml.org/sax/properties/lexical-handler")) {
            return this.getLexicalHandler();
        }
        throw new SAXNotRecognizedException("Property not recognized: " + string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://xml.org/sax/properties/lexical-handler")) {
            if (!(object instanceof LexicalHandler)) {
                throw new SAXNotSupportedException("http://xml.org/sax/properties/lexical-handler");
            }
        } else {
            throw new SAXNotRecognizedException("Property not recognized: " + string);
        }
        this.setLexicalHandler((LexicalHandler)object);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this._entityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this._entityResolver;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this._dtdHandler = dTDHandler;
    }

    public DTDHandler getDTDHandler() {
        return this._dtdHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this._contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this._contentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this._errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this._errorHandler;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this._lexicalHandler = lexicalHandler;
    }

    public LexicalHandler getLexicalHandler() {
        return this._lexicalHandler;
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        this.process();
    }

    public void parse(String string) throws IOException, SAXException {
        this.process();
    }

    public final void process(XMLStreamBuffer xMLStreamBuffer) throws SAXException {
        this.setXMLStreamBuffer(xMLStreamBuffer);
        this.process();
    }

    public final void process(XMLStreamBuffer xMLStreamBuffer, boolean bl) throws SAXException {
        this.setXMLStreamBuffer(xMLStreamBuffer);
        this.process();
    }

    public void setXMLStreamBuffer(XMLStreamBuffer xMLStreamBuffer) {
        this.setBuffer(xMLStreamBuffer);
    }

    public void setXMLStreamBuffer(XMLStreamBuffer xMLStreamBuffer, boolean bl) {
        if (!bl && this._treeCount > 1) {
            throw new IllegalStateException("Can't write a forest to a full XML infoset");
        }
        this.setBuffer(xMLStreamBuffer, bl);
    }

    public final void process() throws SAXException {
        if (!this._fragmentMode) {
            LocatorImpl locatorImpl = new LocatorImpl();
            locatorImpl.setSystemId(this._buffer.getSystemId());
            locatorImpl.setLineNumber(-1);
            locatorImpl.setColumnNumber(-1);
            this._contentHandler.setDocumentLocator(locatorImpl);
            this._contentHandler.startDocument();
        }
        block13: while (this._treeCount > 0) {
            int n = this.readEiiState();
            switch (n) {
                case 1: {
                    this.processDocument();
                    --this._treeCount;
                    continue block13;
                }
                case 17: {
                    return;
                }
                case 3: {
                    this.processElement(this.readStructureString(), this.readStructureString(), this.readStructureString());
                    --this._treeCount;
                    continue block13;
                }
                case 4: {
                    String string = this.readStructureString();
                    String string2 = this.readStructureString();
                    String string3 = this.readStructureString();
                    this.processElement(string2, string3, this.getQName(string, string3));
                    --this._treeCount;
                    continue block13;
                }
                case 5: {
                    String string = this.readStructureString();
                    String string2 = this.readStructureString();
                    this.processElement(string, string2, string2);
                    --this._treeCount;
                    continue block13;
                }
                case 6: {
                    String string = this.readStructureString();
                    this.processElement("", string, string);
                    --this._treeCount;
                    continue block13;
                }
                case 12: {
                    this.processCommentAsCharArraySmall();
                    continue block13;
                }
                case 13: {
                    this.processCommentAsCharArrayMedium();
                    continue block13;
                }
                case 14: {
                    this.processCommentAsCharArrayCopy();
                    continue block13;
                }
                case 15: {
                    this.processComment(this.readContentString());
                    continue block13;
                }
                case 16: {
                    this.processProcessingInstruction(this.readStructureString(), this.readStructureString());
                    continue block13;
                }
            }
            throw this.reportFatalError("Illegal state for DIIs: " + n);
        }
        if (!this._fragmentMode) {
            this._contentHandler.endDocument();
        }
    }

    private void processCommentAsCharArraySmall() throws SAXException {
        int n = this.readStructure();
        int n2 = this.readContentCharactersBuffer(n);
        this.processComment(this._contentCharactersBuffer, n2, n);
    }

    private SAXParseException reportFatalError(String string) throws SAXException {
        SAXParseException sAXParseException = new SAXParseException(string, null);
        if (this._errorHandler != null) {
            this._errorHandler.fatalError(sAXParseException);
        }
        return sAXParseException;
    }

    private void processDocument() throws SAXException {
        int n;
        block12: while (true) {
            n = this.readEiiState();
            switch (n) {
                case 3: {
                    this.processElement(this.readStructureString(), this.readStructureString(), this.readStructureString());
                    continue block12;
                }
                case 4: {
                    String string = this.readStructureString();
                    String string2 = this.readStructureString();
                    String string3 = this.readStructureString();
                    this.processElement(string2, string3, this.getQName(string, string3));
                    continue block12;
                }
                case 5: {
                    String string = this.readStructureString();
                    String string2 = this.readStructureString();
                    this.processElement(string, string2, string2);
                    continue block12;
                }
                case 6: {
                    String string = this.readStructureString();
                    this.processElement("", string, string);
                    continue block12;
                }
                case 12: {
                    this.processCommentAsCharArraySmall();
                    continue block12;
                }
                case 13: {
                    this.processCommentAsCharArrayMedium();
                    continue block12;
                }
                case 14: {
                    this.processCommentAsCharArrayCopy();
                    continue block12;
                }
                case 15: {
                    this.processComment(this.readContentString());
                    continue block12;
                }
                case 16: {
                    this.processProcessingInstruction(this.readStructureString(), this.readStructureString());
                    continue block12;
                }
                case 17: {
                    return;
                }
            }
            break;
        }
        throw this.reportFatalError("Illegal state for child of DII: " + n);
    }

    protected void processElement(String string, String string2, String string3) throws SAXException {
        boolean bl = false;
        boolean bl2 = false;
        int n = this.peekStructure();
        if ((n & 0xF0) == 64) {
            bl2 = true;
            n = this.processNamespaceAttributes(n);
        }
        if ((n & 0xF0) == 48) {
            bl = true;
            this.processAttributes(n);
        }
        this._contentHandler.startElement(string, string2, string3, this._attributes);
        if (bl) {
            this._attributes.clear();
        }
        do {
            n = this.readEiiState();
            switch (n) {
                case 3: {
                    this.processElement(this.readStructureString(), this.readStructureString(), this.readStructureString());
                    break;
                }
                case 4: {
                    String string4 = this.readStructureString();
                    String string5 = this.readStructureString();
                    String string6 = this.readStructureString();
                    this.processElement(string5, string6, this.getQName(string4, string6));
                    break;
                }
                case 5: {
                    String string7 = this.readStructureString();
                    String string8 = this.readStructureString();
                    this.processElement(string7, string8, string8);
                    break;
                }
                case 6: {
                    String string9 = this.readStructureString();
                    this.processElement("", string9, string9);
                    break;
                }
                case 7: {
                    int n2 = this.readStructure();
                    int n3 = this.readContentCharactersBuffer(n2);
                    this._contentHandler.characters(this._contentCharactersBuffer, n3, n2);
                    break;
                }
                case 8: {
                    int n4 = this.readStructure16();
                    int n5 = this.readContentCharactersBuffer(n4);
                    this._contentHandler.characters(this._contentCharactersBuffer, n5, n4);
                    break;
                }
                case 9: {
                    char[] cArray = this.readContentCharactersCopy();
                    this._contentHandler.characters(cArray, 0, cArray.length);
                    break;
                }
                case 10: {
                    String string10 = this.readContentString();
                    this._contentHandler.characters(string10.toCharArray(), 0, string10.length());
                    break;
                }
                case 11: {
                    CharSequence charSequence = (CharSequence)this.readContentObject();
                    String string11 = ((Object)charSequence).toString();
                    this._contentHandler.characters(string11.toCharArray(), 0, string11.length());
                    break;
                }
                case 12: {
                    this.processCommentAsCharArraySmall();
                    break;
                }
                case 13: {
                    this.processCommentAsCharArrayMedium();
                    break;
                }
                case 14: {
                    this.processCommentAsCharArrayCopy();
                    break;
                }
                case 104: {
                    this.processComment(this.readContentString());
                    break;
                }
                case 16: {
                    this.processProcessingInstruction(this.readStructureString(), this.readStructureString());
                    break;
                }
                case 17: {
                    break;
                }
                default: {
                    throw this.reportFatalError("Illegal state for child of EII: " + n);
                }
            }
        } while (n != 17);
        this._contentHandler.endElement(string, string2, string3);
        if (bl2) {
            this.processEndPrefixMapping();
        }
    }

    private void processCommentAsCharArrayCopy() throws SAXException {
        char[] cArray = this.readContentCharactersCopy();
        this.processComment(cArray, 0, cArray.length);
    }

    private void processCommentAsCharArrayMedium() throws SAXException {
        int n = this.readStructure16();
        int n2 = this.readContentCharactersBuffer(n);
        this.processComment(this._contentCharactersBuffer, n2, n);
    }

    private void processEndPrefixMapping() throws SAXException {
        int n = this._namespaceAttributesStack[--this._namespaceAttributesStackIndex];
        int n2 = this._namespaceAttributesStackIndex > 0 ? this._namespaceAttributesStack[this._namespaceAttributesStackIndex] : 0;
        for (int i = n - 1; i >= n2; --i) {
            this._contentHandler.endPrefixMapping(this._namespacePrefixes[i]);
        }
        this._namespacePrefixesIndex = n2;
    }

    private int processNamespaceAttributes(int n) throws SAXException {
        do {
            switch (SAXBufferProcessor.getNIIState(n)) {
                case 1: {
                    this.processNamespaceAttribute("", "");
                    break;
                }
                case 2: {
                    this.processNamespaceAttribute(this.readStructureString(), "");
                    break;
                }
                case 3: {
                    this.processNamespaceAttribute(this.readStructureString(), this.readStructureString());
                    break;
                }
                case 4: {
                    this.processNamespaceAttribute("", this.readStructureString());
                    break;
                }
                default: {
                    throw this.reportFatalError("Illegal state: " + n);
                }
            }
            this.readStructure();
        } while (((n = this.peekStructure()) & 0xF0) == 64);
        this.cacheNamespacePrefixIndex();
        return n;
    }

    private void processAttributes(int n) throws SAXException {
        do {
            switch (SAXBufferProcessor.getAIIState(n)) {
                case 1: {
                    this._attributes.addAttributeWithQName(this.readStructureString(), this.readStructureString(), this.readStructureString(), this.readStructureString(), this.readContentString());
                    break;
                }
                case 2: {
                    String string = this.readStructureString();
                    String string2 = this.readStructureString();
                    String string3 = this.readStructureString();
                    this._attributes.addAttributeWithQName(string2, string3, this.getQName(string, string3), this.readStructureString(), this.readContentString());
                    break;
                }
                case 3: {
                    String string = this.readStructureString();
                    String string2 = this.readStructureString();
                    this._attributes.addAttributeWithQName(string, string2, string2, this.readStructureString(), this.readContentString());
                    break;
                }
                case 4: {
                    String string = this.readStructureString();
                    this._attributes.addAttributeWithQName("", string, string, this.readStructureString(), this.readContentString());
                    break;
                }
                default: {
                    throw this.reportFatalError("Illegal state: " + n);
                }
            }
            this.readStructure();
        } while (((n = this.peekStructure()) & 0xF0) == 48);
    }

    private void processNamespaceAttribute(String string, String string2) throws SAXException {
        this._contentHandler.startPrefixMapping(string, string2);
        if (this._namespacePrefixesFeature) {
            if (string != "") {
                this._attributes.addAttributeWithQName("http://www.w3.org/2000/xmlns/", string, this.getQName("xmlns", string), "CDATA", string2);
            } else {
                this._attributes.addAttributeWithQName("http://www.w3.org/2000/xmlns/", "xmlns", "xmlns", "CDATA", string2);
            }
        }
        this.cacheNamespacePrefix(string);
    }

    private void cacheNamespacePrefix(String string) {
        if (this._namespacePrefixesIndex == this._namespacePrefixes.length) {
            String[] stringArray = new String[this._namespacePrefixesIndex * 3 / 2 + 1];
            System.arraycopy(this._namespacePrefixes, 0, stringArray, 0, this._namespacePrefixesIndex);
            this._namespacePrefixes = stringArray;
        }
        this._namespacePrefixes[this._namespacePrefixesIndex++] = string;
    }

    private void cacheNamespacePrefixIndex() {
        if (this._namespaceAttributesStackIndex == this._namespaceAttributesStack.length) {
            int[] nArray = new int[this._namespaceAttributesStackIndex * 3 / 2 + 1];
            System.arraycopy(this._namespaceAttributesStack, 0, nArray, 0, this._namespaceAttributesStackIndex);
            this._namespaceAttributesStack = nArray;
        }
        this._namespaceAttributesStack[this._namespaceAttributesStackIndex++] = this._namespacePrefixesIndex;
    }

    private void processComment(String string) throws SAXException {
        this.processComment(string.toCharArray(), 0, string.length());
    }

    private void processComment(char[] cArray, int n, int n2) throws SAXException {
        this._lexicalHandler.comment(cArray, n, n2);
    }

    private void processProcessingInstruction(String string, String string2) throws SAXException {
        this._contentHandler.processingInstruction(string, string2);
    }
}

