/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIFailureHandler;
import java.rmi.server.RMIServerSocketFactory;
import sun.rmi.transport.proxy.RMIMasterSocketFactory;

public abstract class RMISocketFactory
implements RMIClientSocketFactory,
RMIServerSocketFactory {
    private static RMISocketFactory factory = null;
    private static RMISocketFactory defaultSocketFactory;
    private static RMIFailureHandler handler;

    public abstract Socket createSocket(String var1, int var2) throws IOException;

    public abstract ServerSocket createServerSocket(int var1) throws IOException;

    public static synchronized void setSocketFactory(RMISocketFactory rMISocketFactory) throws IOException {
        if (factory != null) {
            throw new SocketException("factory already defined");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        factory = rMISocketFactory;
    }

    public static synchronized RMISocketFactory getSocketFactory() {
        return factory;
    }

    public static synchronized RMISocketFactory getDefaultSocketFactory() {
        if (defaultSocketFactory == null) {
            defaultSocketFactory = new RMIMasterSocketFactory();
        }
        return defaultSocketFactory;
    }

    public static synchronized void setFailureHandler(RMIFailureHandler rMIFailureHandler) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        handler = rMIFailureHandler;
    }

    public static synchronized RMIFailureHandler getFailureHandler() {
        return handler;
    }

    static {
        handler = null;
    }
}

