/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.activation;

import com.sun.corba.se.impl.activation.CommandHandler;
import com.sun.corba.se.impl.activation.ServerTool;
import com.sun.corba.se.impl.orbutil.CorbaResourceUtil;
import com.sun.corba.se.spi.activation.Activator;
import com.sun.corba.se.spi.activation.ActivatorHelper;
import com.sun.corba.se.spi.activation.ServerAlreadyActive;
import com.sun.corba.se.spi.activation.ServerHeldDown;
import com.sun.corba.se.spi.activation.ServerNotRegistered;
import java.io.PrintStream;
import org.omg.CORBA.ORB;

class StartServer
implements CommandHandler {
    static final int illegalServerId = -1;

    StartServer() {
    }

    public String getCommandName() {
        return "startup";
    }

    public void printCommandHelp(PrintStream printStream, boolean bl) {
        if (!bl) {
            printStream.println(CorbaResourceUtil.getText("servertool.startserver"));
        } else {
            printStream.println(CorbaResourceUtil.getText("servertool.startserver1"));
        }
    }

    public boolean processCommand(String[] stringArray, ORB oRB, PrintStream printStream) {
        int n = -1;
        try {
            if (stringArray.length == 2) {
                if (stringArray[0].equals("-serverid")) {
                    n = Integer.valueOf(stringArray[1]);
                } else if (stringArray[0].equals("-applicationName")) {
                    n = ServerTool.getServerIdForAlias(oRB, stringArray[1]);
                }
            }
            if (n == -1) {
                return true;
            }
            Activator activator = ActivatorHelper.narrow(oRB.resolve_initial_references("ServerActivator"));
            activator.activate(n);
            printStream.println(CorbaResourceUtil.getText("servertool.startserver2"));
        }
        catch (ServerNotRegistered serverNotRegistered) {
            printStream.println(CorbaResourceUtil.getText("servertool.nosuchserver"));
        }
        catch (ServerAlreadyActive serverAlreadyActive) {
            printStream.println(CorbaResourceUtil.getText("servertool.serverup"));
        }
        catch (ServerHeldDown serverHeldDown) {
            printStream.println(CorbaResourceUtil.getText("servertool.helddown"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }
}

