/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils;

import java.io.IOException;
import java.io.OutputStream;

public class UnsyncBufferedOutputStream
extends OutputStream {
    final OutputStream out;
    static final int size = 8192;
    final byte[] buf = new byte[8192];
    int pointer = 0;

    public UnsyncBufferedOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.pointer + n2;
        if (n3 > 8192) {
            this.flushBuffer();
            if (n2 > 8192) {
                this.out.write(byArray, n, n2);
                return;
            }
            n3 = n2;
        }
        System.arraycopy(byArray, n, this.buf, this.pointer, n2);
        this.pointer = n3;
    }

    private final void flushBuffer() throws IOException {
        if (this.pointer > 0) {
            this.out.write(this.buf, 0, this.pointer);
        }
        this.pointer = 0;
    }

    public void write(int n) throws IOException {
        if (this.pointer >= 8192) {
            this.flushBuffer();
        }
        this.buf[this.pointer++] = (byte)n;
    }

    public void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }

    public void close() throws IOException {
        this.flush();
    }
}

